import { EDStatic } from '../Interface/Static';
export declare enum PolicyRuleType {
    User = "m.policy.rule.user",
    Room = "m.policy.rule.room",
    Server = "m.policy.rule.server",
    Unknown = "unknown"
}
export declare const USER_RULE_TYPES: string[];
export declare const ROOM_RULE_TYPES: string[];
export declare const SERVER_RULE_TYPES: string[];
export declare const ALL_RULE_TYPES: string[];
export declare function variantsForPolicyRuleType(type: PolicyRuleType): string[];
export declare function normalisePolicyRuleType(type: string): PolicyRuleType;
export declare function isPolicyTypeObsolete(normalisedType: PolicyRuleType, existingType: string, candidateType: string): boolean;
export declare const PlainTextPolicyContent: import("@sinclair/typebox").TObject<{
    entity: import("@sinclair/typebox").TString;
    recommendation: import("@sinclair/typebox").TString;
    reason: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TString>;
}>;
export type HashedPolicyContent = EDStatic<typeof HashedPolicyContent>;
export declare const HashedPolicyContent: import("@sinclair/typebox").TUnion<[import("@sinclair/typebox").TIntersect<[import("@sinclair/typebox").TObject<{
    recommendation: import("@sinclair/typebox").TString;
    reason: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TString>;
}>, import("@sinclair/typebox").TObject<{
    'org.matrix.msc4205.hashes': import("@sinclair/typebox").TRecord<import("@sinclair/typebox").TString, import("@sinclair/typebox").TString>;
}>]>, import("@sinclair/typebox").TIntersect<[import("@sinclair/typebox").TObject<{
    recommendation: import("@sinclair/typebox").TString;
    reason: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TString>;
}>, import("@sinclair/typebox").TObject<{
    hashes: import("@sinclair/typebox").TRecord<import("@sinclair/typebox").TString, import("@sinclair/typebox").TString>;
}>]>]>;
export type UnredactedPolicyContent = EDStatic<typeof UnredactedPolicyContent>;
export declare const UnredactedPolicyContent: import("@sinclair/typebox").TUnion<[import("@sinclair/typebox").TObject<{
    entity: import("@sinclair/typebox").TString;
    recommendation: import("@sinclair/typebox").TString;
    reason: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TString>;
}>, import("@sinclair/typebox").TUnion<[import("@sinclair/typebox").TIntersect<[import("@sinclair/typebox").TObject<{
    recommendation: import("@sinclair/typebox").TString;
    reason: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TString>;
}>, import("@sinclair/typebox").TObject<{
    'org.matrix.msc4205.hashes': import("@sinclair/typebox").TRecord<import("@sinclair/typebox").TString, import("@sinclair/typebox").TString>;
}>]>, import("@sinclair/typebox").TIntersect<[import("@sinclair/typebox").TObject<{
    recommendation: import("@sinclair/typebox").TString;
    reason: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TString>;
}>, import("@sinclair/typebox").TObject<{
    hashes: import("@sinclair/typebox").TRecord<import("@sinclair/typebox").TString, import("@sinclair/typebox").TString>;
}>]>]>]>;
export type RedactablePolicyContent = EDStatic<typeof RedactablePolicyContent>;
export declare const RedactablePolicyContent: import("@sinclair/typebox").TUnion<[import("@sinclair/typebox").TUnion<[import("@sinclair/typebox").TObject<{
    entity: import("@sinclair/typebox").TString;
    recommendation: import("@sinclair/typebox").TString;
    reason: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TString>;
}>, import("@sinclair/typebox").TUnion<[import("@sinclair/typebox").TIntersect<[import("@sinclair/typebox").TObject<{
    recommendation: import("@sinclair/typebox").TString;
    reason: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TString>;
}>, import("@sinclair/typebox").TObject<{
    'org.matrix.msc4205.hashes': import("@sinclair/typebox").TRecord<import("@sinclair/typebox").TString, import("@sinclair/typebox").TString>;
}>]>, import("@sinclair/typebox").TIntersect<[import("@sinclair/typebox").TObject<{
    recommendation: import("@sinclair/typebox").TString;
    reason: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TString>;
}>, import("@sinclair/typebox").TObject<{
    hashes: import("@sinclair/typebox").TRecord<import("@sinclair/typebox").TString, import("@sinclair/typebox").TString>;
}>]>]>]>, import("@sinclair/typebox").TObject<{}>]>;
export type GeneircPolicyRuleEvent = EDStatic<typeof PolicyRuleEvent>;
export declare const GeneircPolicyRuleEvent: import("@sinclair/typebox").TIntersect<[import("@sinclair/typebox").TIntersect<[import("@sinclair/typebox").TIntersect<[import("@sinclair/typebox").TObject<{
    content: import("@sinclair/typebox").TUnion<[import("@sinclair/typebox").TUnion<[import("@sinclair/typebox").TObject<{
        entity: import("@sinclair/typebox").TString;
        recommendation: import("@sinclair/typebox").TString;
        reason: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TString>;
    }>, import("@sinclair/typebox").TUnion<[import("@sinclair/typebox").TIntersect<[import("@sinclair/typebox").TObject<{
        recommendation: import("@sinclair/typebox").TString;
        reason: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TString>;
    }>, import("@sinclair/typebox").TObject<{
        'org.matrix.msc4205.hashes': import("@sinclair/typebox").TRecord<import("@sinclair/typebox").TString, import("@sinclair/typebox").TString>;
    }>]>, import("@sinclair/typebox").TIntersect<[import("@sinclair/typebox").TObject<{
        recommendation: import("@sinclair/typebox").TString;
        reason: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TString>;
    }>, import("@sinclair/typebox").TObject<{
        hashes: import("@sinclair/typebox").TRecord<import("@sinclair/typebox").TString, import("@sinclair/typebox").TString>;
    }>]>]>]>, import("@sinclair/typebox").TObject<{}>]>;
    type: import("@sinclair/typebox").TString;
}>, import("@sinclair/typebox").TObject<{
    event_id: import("@sinclair/typebox").TUnsafe<import("@the-draupnir-project/matrix-basic-types").StringEventID>;
    sender: import("@sinclair/typebox").TUnsafe<import("@the-draupnir-project/matrix-basic-types").StringUserID>;
    origin_server_ts: import("@sinclair/typebox").TNumber;
    unsigned: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TObject<{
        age: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TNumber>;
        redacted_because: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TUnknown>;
        transaction_id: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TString>;
        prev_content: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TUnknown>;
    }>>;
}>]>, import("@sinclair/typebox").TObject<{
    room_id: import("@sinclair/typebox").TUnsafe<import("@the-draupnir-project/matrix-basic-types").StringRoomID>;
}>]>, import("@sinclair/typebox").TObject<{
    state_key: import("@sinclair/typebox").TString;
}>]>;
export type PolicyRuleUser = EDStatic<typeof PolicyRuleUser>;
export declare const PolicyRuleUser: import("@sinclair/typebox").TIntersect<[import("@sinclair/typebox").TIntersect<[import("@sinclair/typebox").TIntersect<[import("@sinclair/typebox").TIntersect<[import("@sinclair/typebox").TObject<{
    content: import("@sinclair/typebox").TUnion<[import("@sinclair/typebox").TUnion<[import("@sinclair/typebox").TObject<{
        entity: import("@sinclair/typebox").TString;
        recommendation: import("@sinclair/typebox").TString;
        reason: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TString>;
    }>, import("@sinclair/typebox").TUnion<[import("@sinclair/typebox").TIntersect<[import("@sinclair/typebox").TObject<{
        recommendation: import("@sinclair/typebox").TString;
        reason: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TString>;
    }>, import("@sinclair/typebox").TObject<{
        'org.matrix.msc4205.hashes': import("@sinclair/typebox").TRecord<import("@sinclair/typebox").TString, import("@sinclair/typebox").TString>;
    }>]>, import("@sinclair/typebox").TIntersect<[import("@sinclair/typebox").TObject<{
        recommendation: import("@sinclair/typebox").TString;
        reason: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TString>;
    }>, import("@sinclair/typebox").TObject<{
        hashes: import("@sinclair/typebox").TRecord<import("@sinclair/typebox").TString, import("@sinclair/typebox").TString>;
    }>]>]>]>, import("@sinclair/typebox").TObject<{}>]>;
    type: import("@sinclair/typebox").TString;
}>, import("@sinclair/typebox").TObject<{
    event_id: import("@sinclair/typebox").TUnsafe<import("@the-draupnir-project/matrix-basic-types").StringEventID>;
    sender: import("@sinclair/typebox").TUnsafe<import("@the-draupnir-project/matrix-basic-types").StringUserID>;
    origin_server_ts: import("@sinclair/typebox").TNumber;
    unsigned: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TObject<{
        age: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TNumber>;
        redacted_because: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TUnknown>;
        transaction_id: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TString>;
        prev_content: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TUnknown>;
    }>>;
}>]>, import("@sinclair/typebox").TObject<{
    room_id: import("@sinclair/typebox").TUnsafe<import("@the-draupnir-project/matrix-basic-types").StringRoomID>;
}>]>, import("@sinclair/typebox").TObject<{
    state_key: import("@sinclair/typebox").TString;
}>]>, import("@sinclair/typebox").TObject<{
    state_key: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TString>;
    type: import("@sinclair/typebox").TUnion<import("@sinclair/typebox").TLiteral<string>[]>;
}>]>;
export type PolicyRuleServer = EDStatic<typeof PolicyRuleServer>;
export declare const PolicyRuleServer: import("@sinclair/typebox").TIntersect<[import("@sinclair/typebox").TIntersect<[import("@sinclair/typebox").TIntersect<[import("@sinclair/typebox").TIntersect<[import("@sinclair/typebox").TObject<{
    content: import("@sinclair/typebox").TUnion<[import("@sinclair/typebox").TUnion<[import("@sinclair/typebox").TObject<{
        entity: import("@sinclair/typebox").TString;
        recommendation: import("@sinclair/typebox").TString;
        reason: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TString>;
    }>, import("@sinclair/typebox").TUnion<[import("@sinclair/typebox").TIntersect<[import("@sinclair/typebox").TObject<{
        recommendation: import("@sinclair/typebox").TString;
        reason: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TString>;
    }>, import("@sinclair/typebox").TObject<{
        'org.matrix.msc4205.hashes': import("@sinclair/typebox").TRecord<import("@sinclair/typebox").TString, import("@sinclair/typebox").TString>;
    }>]>, import("@sinclair/typebox").TIntersect<[import("@sinclair/typebox").TObject<{
        recommendation: import("@sinclair/typebox").TString;
        reason: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TString>;
    }>, import("@sinclair/typebox").TObject<{
        hashes: import("@sinclair/typebox").TRecord<import("@sinclair/typebox").TString, import("@sinclair/typebox").TString>;
    }>]>]>]>, import("@sinclair/typebox").TObject<{}>]>;
    type: import("@sinclair/typebox").TString;
}>, import("@sinclair/typebox").TObject<{
    event_id: import("@sinclair/typebox").TUnsafe<import("@the-draupnir-project/matrix-basic-types").StringEventID>;
    sender: import("@sinclair/typebox").TUnsafe<import("@the-draupnir-project/matrix-basic-types").StringUserID>;
    origin_server_ts: import("@sinclair/typebox").TNumber;
    unsigned: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TObject<{
        age: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TNumber>;
        redacted_because: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TUnknown>;
        transaction_id: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TString>;
        prev_content: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TUnknown>;
    }>>;
}>]>, import("@sinclair/typebox").TObject<{
    room_id: import("@sinclair/typebox").TUnsafe<import("@the-draupnir-project/matrix-basic-types").StringRoomID>;
}>]>, import("@sinclair/typebox").TObject<{
    state_key: import("@sinclair/typebox").TString;
}>]>, import("@sinclair/typebox").TObject<{
    state_key: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TString>;
    type: import("@sinclair/typebox").TUnion<import("@sinclair/typebox").TLiteral<string>[]>;
}>]>;
export type PolicyRuleRoom = EDStatic<typeof PolicyRuleRoom>;
export declare const PolicyRuleRoom: import("@sinclair/typebox").TIntersect<[import("@sinclair/typebox").TIntersect<[import("@sinclair/typebox").TIntersect<[import("@sinclair/typebox").TIntersect<[import("@sinclair/typebox").TObject<{
    content: import("@sinclair/typebox").TUnion<[import("@sinclair/typebox").TUnion<[import("@sinclair/typebox").TObject<{
        entity: import("@sinclair/typebox").TString;
        recommendation: import("@sinclair/typebox").TString;
        reason: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TString>;
    }>, import("@sinclair/typebox").TUnion<[import("@sinclair/typebox").TIntersect<[import("@sinclair/typebox").TObject<{
        recommendation: import("@sinclair/typebox").TString;
        reason: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TString>;
    }>, import("@sinclair/typebox").TObject<{
        'org.matrix.msc4205.hashes': import("@sinclair/typebox").TRecord<import("@sinclair/typebox").TString, import("@sinclair/typebox").TString>;
    }>]>, import("@sinclair/typebox").TIntersect<[import("@sinclair/typebox").TObject<{
        recommendation: import("@sinclair/typebox").TString;
        reason: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TString>;
    }>, import("@sinclair/typebox").TObject<{
        hashes: import("@sinclair/typebox").TRecord<import("@sinclair/typebox").TString, import("@sinclair/typebox").TString>;
    }>]>]>]>, import("@sinclair/typebox").TObject<{}>]>;
    type: import("@sinclair/typebox").TString;
}>, import("@sinclair/typebox").TObject<{
    event_id: import("@sinclair/typebox").TUnsafe<import("@the-draupnir-project/matrix-basic-types").StringEventID>;
    sender: import("@sinclair/typebox").TUnsafe<import("@the-draupnir-project/matrix-basic-types").StringUserID>;
    origin_server_ts: import("@sinclair/typebox").TNumber;
    unsigned: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TObject<{
        age: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TNumber>;
        redacted_because: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TUnknown>;
        transaction_id: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TString>;
        prev_content: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TUnknown>;
    }>>;
}>]>, import("@sinclair/typebox").TObject<{
    room_id: import("@sinclair/typebox").TUnsafe<import("@the-draupnir-project/matrix-basic-types").StringRoomID>;
}>]>, import("@sinclair/typebox").TObject<{
    state_key: import("@sinclair/typebox").TString;
}>]>, import("@sinclair/typebox").TObject<{
    state_key: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TString>;
    type: import("@sinclair/typebox").TUnion<import("@sinclair/typebox").TLiteral<string>[]>;
}>]>;
export type PolicyRuleEvent = EDStatic<typeof PolicyRuleEvent>;
export declare const PolicyRuleEvent: import("@sinclair/typebox").TUnion<[import("@sinclair/typebox").TIntersect<[import("@sinclair/typebox").TIntersect<[import("@sinclair/typebox").TIntersect<[import("@sinclair/typebox").TIntersect<[import("@sinclair/typebox").TObject<{
    content: import("@sinclair/typebox").TUnion<[import("@sinclair/typebox").TUnion<[import("@sinclair/typebox").TObject<{
        entity: import("@sinclair/typebox").TString;
        recommendation: import("@sinclair/typebox").TString;
        reason: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TString>;
    }>, import("@sinclair/typebox").TUnion<[import("@sinclair/typebox").TIntersect<[import("@sinclair/typebox").TObject<{
        recommendation: import("@sinclair/typebox").TString;
        reason: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TString>;
    }>, import("@sinclair/typebox").TObject<{
        'org.matrix.msc4205.hashes': import("@sinclair/typebox").TRecord<import("@sinclair/typebox").TString, import("@sinclair/typebox").TString>;
    }>]>, import("@sinclair/typebox").TIntersect<[import("@sinclair/typebox").TObject<{
        recommendation: import("@sinclair/typebox").TString;
        reason: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TString>;
    }>, import("@sinclair/typebox").TObject<{
        hashes: import("@sinclair/typebox").TRecord<import("@sinclair/typebox").TString, import("@sinclair/typebox").TString>;
    }>]>]>]>, import("@sinclair/typebox").TObject<{}>]>;
    type: import("@sinclair/typebox").TString;
}>, import("@sinclair/typebox").TObject<{
    event_id: import("@sinclair/typebox").TUnsafe<import("@the-draupnir-project/matrix-basic-types").StringEventID>;
    sender: import("@sinclair/typebox").TUnsafe<import("@the-draupnir-project/matrix-basic-types").StringUserID>;
    origin_server_ts: import("@sinclair/typebox").TNumber;
    unsigned: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TObject<{
        age: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TNumber>;
        redacted_because: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TUnknown>;
        transaction_id: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TString>;
        prev_content: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TUnknown>;
    }>>;
}>]>, import("@sinclair/typebox").TObject<{
    room_id: import("@sinclair/typebox").TUnsafe<import("@the-draupnir-project/matrix-basic-types").StringRoomID>;
}>]>, import("@sinclair/typebox").TObject<{
    state_key: import("@sinclair/typebox").TString;
}>]>, import("@sinclair/typebox").TObject<{
    state_key: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TString>;
    type: import("@sinclair/typebox").TUnion<import("@sinclair/typebox").TLiteral<string>[]>;
}>]>, import("@sinclair/typebox").TIntersect<[import("@sinclair/typebox").TIntersect<[import("@sinclair/typebox").TIntersect<[import("@sinclair/typebox").TIntersect<[import("@sinclair/typebox").TObject<{
    content: import("@sinclair/typebox").TUnion<[import("@sinclair/typebox").TUnion<[import("@sinclair/typebox").TObject<{
        entity: import("@sinclair/typebox").TString;
        recommendation: import("@sinclair/typebox").TString;
        reason: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TString>;
    }>, import("@sinclair/typebox").TUnion<[import("@sinclair/typebox").TIntersect<[import("@sinclair/typebox").TObject<{
        recommendation: import("@sinclair/typebox").TString;
        reason: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TString>;
    }>, import("@sinclair/typebox").TObject<{
        'org.matrix.msc4205.hashes': import("@sinclair/typebox").TRecord<import("@sinclair/typebox").TString, import("@sinclair/typebox").TString>;
    }>]>, import("@sinclair/typebox").TIntersect<[import("@sinclair/typebox").TObject<{
        recommendation: import("@sinclair/typebox").TString;
        reason: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TString>;
    }>, import("@sinclair/typebox").TObject<{
        hashes: import("@sinclair/typebox").TRecord<import("@sinclair/typebox").TString, import("@sinclair/typebox").TString>;
    }>]>]>]>, import("@sinclair/typebox").TObject<{}>]>;
    type: import("@sinclair/typebox").TString;
}>, import("@sinclair/typebox").TObject<{
    event_id: import("@sinclair/typebox").TUnsafe<import("@the-draupnir-project/matrix-basic-types").StringEventID>;
    sender: import("@sinclair/typebox").TUnsafe<import("@the-draupnir-project/matrix-basic-types").StringUserID>;
    origin_server_ts: import("@sinclair/typebox").TNumber;
    unsigned: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TObject<{
        age: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TNumber>;
        redacted_because: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TUnknown>;
        transaction_id: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TString>;
        prev_content: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TUnknown>;
    }>>;
}>]>, import("@sinclair/typebox").TObject<{
    room_id: import("@sinclair/typebox").TUnsafe<import("@the-draupnir-project/matrix-basic-types").StringRoomID>;
}>]>, import("@sinclair/typebox").TObject<{
    state_key: import("@sinclair/typebox").TString;
}>]>, import("@sinclair/typebox").TObject<{
    state_key: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TString>;
    type: import("@sinclair/typebox").TUnion<import("@sinclair/typebox").TLiteral<string>[]>;
}>]>, import("@sinclair/typebox").TIntersect<[import("@sinclair/typebox").TIntersect<[import("@sinclair/typebox").TIntersect<[import("@sinclair/typebox").TIntersect<[import("@sinclair/typebox").TObject<{
    content: import("@sinclair/typebox").TUnion<[import("@sinclair/typebox").TUnion<[import("@sinclair/typebox").TObject<{
        entity: import("@sinclair/typebox").TString;
        recommendation: import("@sinclair/typebox").TString;
        reason: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TString>;
    }>, import("@sinclair/typebox").TUnion<[import("@sinclair/typebox").TIntersect<[import("@sinclair/typebox").TObject<{
        recommendation: import("@sinclair/typebox").TString;
        reason: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TString>;
    }>, import("@sinclair/typebox").TObject<{
        'org.matrix.msc4205.hashes': import("@sinclair/typebox").TRecord<import("@sinclair/typebox").TString, import("@sinclair/typebox").TString>;
    }>]>, import("@sinclair/typebox").TIntersect<[import("@sinclair/typebox").TObject<{
        recommendation: import("@sinclair/typebox").TString;
        reason: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TString>;
    }>, import("@sinclair/typebox").TObject<{
        hashes: import("@sinclair/typebox").TRecord<import("@sinclair/typebox").TString, import("@sinclair/typebox").TString>;
    }>]>]>]>, import("@sinclair/typebox").TObject<{}>]>;
    type: import("@sinclair/typebox").TString;
}>, import("@sinclair/typebox").TObject<{
    event_id: import("@sinclair/typebox").TUnsafe<import("@the-draupnir-project/matrix-basic-types").StringEventID>;
    sender: import("@sinclair/typebox").TUnsafe<import("@the-draupnir-project/matrix-basic-types").StringUserID>;
    origin_server_ts: import("@sinclair/typebox").TNumber;
    unsigned: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TObject<{
        age: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TNumber>;
        redacted_because: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TUnknown>;
        transaction_id: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TString>;
        prev_content: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TUnknown>;
    }>>;
}>]>, import("@sinclair/typebox").TObject<{
    room_id: import("@sinclair/typebox").TUnsafe<import("@the-draupnir-project/matrix-basic-types").StringRoomID>;
}>]>, import("@sinclair/typebox").TObject<{
    state_key: import("@sinclair/typebox").TString;
}>]>, import("@sinclair/typebox").TObject<{
    state_key: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TString>;
    type: import("@sinclair/typebox").TUnion<import("@sinclair/typebox").TLiteral<string>[]>;
}>]>]>;
export declare function isPolicyRuleEvent(value: unknown): value is PolicyRuleEvent;
//# sourceMappingURL=PolicyEvents.d.ts.map