import { StaticDecode } from '@sinclair/typebox';
import { MembershipEvent, MembershipEventContent } from '../MatrixTypes/MembershipEvent';
import { StringEventID, StringRoomID, StringUserID } from '@the-draupnir-project/matrix-basic-types';
export declare enum Membership {
    Join = "join",
    Invite = "invite",
    Knock = "knock",
    Leave = "leave",
    Ban = "ban"
}
/**
 * Represents the change to the membership field of a membership event.
 * This does not represent change in the overall event!
 * You must still account for NoChange does not mean the membership events
 * themselves are the same!!! If that was the case, there would be no
 * `MembershipChange` event emitted by the revision issuer in the first place!
 */
export declare enum MembershipChangeType {
    /** A genuine join to the room. */
    Joined = "joined",
    /** A join to the room when the user has recently left, was removed or banned.
     * This distinction exists because bridged users from IRC or XMPP will do this all the time.
     * And things like greeter bots would break.
     */
    Rejoined = "rejoined",
    /** The user left the room by their own command. */
    Left = "left",
    /** The user was kicked by another user. */
    Kicked = "kicked",
    /** The user was banned by another user. */
    Banned = "banned",
    /** The user was unbanned by another user. */
    Unbanned = "unbanned",
    /** The user made a genuine knock on the room. */
    Knocked = "knocked",
    /** The user renocked on the room after recently leaving @see {@link MembershipChangeType.Rejoin}. */
    Reknocked = "renocked",
    /** The user was invited by another user. */
    Invited = "invited",
    /** There was no change to the membership, but there may have been changes to their profile or reason for their membership. */
    NoChange = "no-change"
}
export declare function membershipChangeType(nextMembership: StaticDecode<typeof MembershipEvent>, previousMembershipContent?: MembershipEventContent): MembershipChangeType;
export declare enum ProfileChangeType {
    InitialProfile = "initial-profile",
    Displayname = "displayname",
    Avatar = "avatar",
    DisplaynameAndAvatar = "displayname-and-avatar",
    NoChange = "no-change"
}
export declare function profileChangeType(nextMembership: MembershipEvent, previousMembershipContent?: MembershipEventContent): ProfileChangeType;
export declare class MembershipChange {
    readonly userID: StringUserID;
    readonly sender: StringUserID;
    readonly roomID: StringRoomID;
    readonly eventID: StringEventID;
    readonly membership: 'join' | 'invite' | 'knock' | 'leave' | 'ban';
    readonly membershipChangeType: MembershipChangeType;
    readonly profileChangeType: ProfileChangeType;
    readonly content: MembershipEventContent;
    constructor(userID: StringUserID, sender: StringUserID, roomID: StringRoomID, eventID: StringEventID, membership: 'join' | 'invite' | 'knock' | 'leave' | 'ban', membershipChangeType: MembershipChangeType, profileChangeType: ProfileChangeType, content: MembershipEventContent);
}
//# sourceMappingURL=MembershipChange.d.ts.map