import EventEmitter from 'events';
import { RoomMembershipRevisionIssuer } from './MembershipRevisionIssuer';
import { RoomMembershipRevision } from './MembershipRevision';
import { RoomStateRevisionIssuer } from '../StateTracking/StateRevisionIssuer';
import { MembershipEvent } from '../MatrixTypes/MembershipEvent';
import { Redaction } from '../MatrixTypes/Redaction';
import { MatrixRoomID } from '@the-draupnir-project/matrix-basic-types';
/**
 * An implementation of the {@link RoomMembershipRevisionIssuer} that
 * uses the {@link RoomStateRevisionIssuer}.
 */
export declare class RoomStateMembershipRevisionIssuer extends EventEmitter implements RoomMembershipRevisionIssuer {
    readonly room: MatrixRoomID;
    currentRevision: RoomMembershipRevision;
    private readonly roomStateRevisionIssuer;
    private readonly stateRevisionListener;
    constructor(room: MatrixRoomID, currentRevision: RoomMembershipRevision, roomStateRevisionIssuer: RoomStateRevisionIssuer);
    updateForMembershipEvent(event: MembershipEvent): void;
    updateForRedactionEvent(event: Redaction): void;
    private listener;
    unregisterListeners(): void;
}
//# sourceMappingURL=RoomStateMembershipRevisionIssuer.d.ts.map