"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FakePolicyRoomRevisionIssuer = void 0;
const RoomStatePolicyListRevisionIssuer_1 = require("./RoomStatePolicyListRevisionIssuer");
class FakePolicyRoomRevisionIssuer extends RoomStatePolicyListRevisionIssuer_1.RoomStatePolicyRoomRevisionIssuer {
    constructor(room, currentRevision, roomStateRevisionIssuer) {
        super(room, currentRevision, roomStateRevisionIssuer);
        this.revisionLog = [];
    }
    emit(event, nextRevision, changes, previousRevision) {
        // eslint-disable-next-line @typescript-eslint/no-unnecessary-condition
        if (event !== 'revision') {
            throw new TypeError(`The FakePolicyRoomRevisionIssuer was only written to work with the 'revision' event and not: ${event}`);
        }
        this.revisionLog.push([nextRevision, changes, previousRevision]);
        return super.emit(event, nextRevision, changes, previousRevision);
    }
    // These methods are on the Fake's reflective side
    getLastRevision() {
        const revisionEntry = this.revisionLog.at(-1);
        if (revisionEntry === undefined) {
            throw new TypeError(`the revision log is empty`);
        }
        return revisionEntry;
    }
    getNumberOfRevisions() {
        return this.revisionLog.length;
    }
}
exports.FakePolicyRoomRevisionIssuer = FakePolicyRoomRevisionIssuer;
//# sourceMappingURL=FakePolicyRoomRevisionIssuer.js.map