"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const ɵRepository = __importStar(require("ts-auto-mock/repository"));
const ɵExtension = __importStar(require("ts-auto-mock/extension"));
const ɵMerge = __importStar(require("ts-auto-mock/merge"));
const ɵRandom = __importStar(require("ts-auto-mock/random"));
ɵRepository.ɵRepository.instance.registerFactory("@OkResult_2", function (t) { return (function () { var d = {}, m = { "isOkay": !0 }; Object.defineProperties(m, {
    "ok": { get() { return d.hasOwnProperty("ok") ? d["ok"] : d["ok"] = (function () {
            const generic = t.find(generic => {
                return generic.i.indexOf("@OkResult_2Ok") >= 0;
            });
            if (generic) {
                return generic.w();
            }
            return null;
        })(); }, set(v) { d["ok"] = v; }, enumerable: !0 },
    "match": { get() { return d.hasOwnProperty("match") ? d["match"] : d["match"] = ɵExtension.Provider.instance.getMethod("match", () => {
            return (function () {
                const generic = t.find(generic => {
                    return generic.i.indexOf("@match_2T") >= 0;
                });
                if (generic) {
                    return generic.w();
                }
                return null;
            })();
        }); }, set(v) { d["match"] = v; }, enumerable: !0 },
    "expect": { get() { return d.hasOwnProperty("expect") ? d["expect"] : d["expect"] = ɵExtension.Provider.instance.getMethod("expect", () => {
            return null;
        }); }, set(v) { d["expect"] = v; }, enumerable: !0 }
}); Object.defineProperty(m, ɵExtension.ɵMarker.instance.get(), { value: !0 }); return m; })(); });
ɵRepository.ɵRepository.instance.registerFactory("@Result_2", function (t) { return ɵRepository.ɵRepository.instance.getFactory("@OkResult_2")([{
        i: ["@OkResult_2Ok"],
        w: function () { return (function () {
            const generic = t.find(generic => {
                return generic.i.indexOf("@Result_2Ok") >= 0;
            });
            if (generic) {
                return generic.w();
            }
            return null;
        })(); }
    }]); });
ɵRepository.ɵRepository.instance.registerFactory("@ResultError_2", function (t) { return (function () { var d = {}, m = { "message": "", "mostRelevantElaboration": "" }; Object.defineProperties(m, {
    "elaborate": { get() { return d.hasOwnProperty("elaborate") ? d["elaborate"] : d["elaborate"] = ɵExtension.Provider.instance.getMethod("elaborate", () => {
            return ɵRepository.ɵRepository.instance.getFactory("@ResultError_2")(t);
        }); }, set(v) { d["elaborate"] = v; }, enumerable: !0 },
    "getElaborations": { get() { return d.hasOwnProperty("getElaborations") ? d["getElaborations"] : d["getElaborations"] = ɵExtension.Provider.instance.getMethod("getElaborations", () => {
            return [];
        }); }, set(v) { d["getElaborations"] = v; }, enumerable: !0 },
    "toReadableString": { get() { return d.hasOwnProperty("toReadableString") ? d["toReadableString"] : d["toReadableString"] = ɵExtension.Provider.instance.getMethod("toReadableString", () => {
            return "";
        }); }, set(v) { d["toReadableString"] = v; }, enumerable: !0 },
    "toString": { get() { return d.hasOwnProperty("toString") ? d["toString"] : d["toString"] = ɵExtension.Provider.instance.getMethod("toString", () => {
            return "";
        }); }, set(v) { d["toString"] = v; }, enumerable: !0 },
    "toExpectError": { get() { return d.hasOwnProperty("toExpectError") ? d["toExpectError"] : d["toExpectError"] = ɵExtension.Provider.instance.getMethod("toExpectError", () => {
            return void 0;
        }); }, set(v) { d["toExpectError"] = v; }, enumerable: !0 }
}); Object.defineProperty(m, ɵExtension.ɵMarker.instance.get(), { value: !0 }); return m; })(); });
ɵRepository.ɵRepository.instance.registerFactory("@StringTypeResult_1", function (t) { return (function () { var d = {}, m = { "isEveryResultOk": !1, "numberOfFailedResults": 0 }; Object.defineProperties(m, {
    "map": { get() { return d.hasOwnProperty("map") ? d["map"] : d["map"] = new Map; }, set(v) { d["map"] = v; }, enumerable: !0 }
}); Object.defineProperty(m, ɵExtension.ɵMarker.instance.get(), { value: !0 }); return m; })(); });
ɵRepository.ɵRepository.instance.registerFactory("@StringUserID_1", function (t) { return void 0; });
ɵRepository.ɵRepository.instance.registerFactory("@ResultForUsersInRoom_1", function (t) { return ɵRepository.ɵRepository.instance.getFactory("@StringTypeResult_1")([{
        i: ["@StringTypeResult_1T"],
        w: function () { return ɵRepository.ɵRepository.instance.getFactory("@StringUserID_1")([]); }
    }]); });
ɵRepository.ɵRepository.instance.registerFactory("@ResultForUsersInSet_1", function (t) { return (function () { var d = {}, m = { "isEveryResultOk": !1, "numberOfFailedResults": 0 }; Object.defineProperties(m, {
    "map": { get() { return d.hasOwnProperty("map") ? d["map"] : d["map"] = new Map; }, set(v) { d["map"] = v; }, enumerable: !0 }
}); Object.defineProperty(m, ɵExtension.ɵMarker.instance.get(), { value: !0 }); return m; })(); });
ɵRepository.ɵRepository.instance.registerFactory("@StringRoomID_1", function (t) { return void 0; });
ɵRepository.ɵRepository.instance.registerFactory("@RoomSetResult_1", function (t) { return ɵRepository.ɵRepository.instance.getFactory("@StringTypeResult_1")([{
        i: ["@StringTypeResult_1T"],
        w: function () { return ɵRepository.ɵRepository.instance.getFactory("@StringRoomID_1")([]); }
    }]); });
ɵRepository.ɵRepository.instance.registerFactory("@UserConsequences_1", function (t) { return (function () { var d = {}, m = { "requiredPermissions": [], "requiredStatePermissions": [], "requiredEventPermissions": [] }; Object.defineProperties(m, {
    "consequenceForUserInRoom": { get() { return d.hasOwnProperty("consequenceForUserInRoom") ? d["consequenceForUserInRoom"] : d["consequenceForUserInRoom"] = ɵExtension.Provider.instance.getMethod("consequenceForUserInRoom", () => {
            return Promise.resolve(ɵRepository.ɵRepository.instance.getFactory("@Result_2")([{
                    i: ["@Result_2Ok"],
                    w: function () { return void 0; }
                }, {
                    i: ["@Result_2Error"],
                    w: function () { return ɵRepository.ɵRepository.instance.getFactory("@ResultError_2")([]); }
                }]));
        }); }, set(v) { d["consequenceForUserInRoom"] = v; }, enumerable: !0 },
    "consequenceForUsersInRoom": { get() { return d.hasOwnProperty("consequenceForUsersInRoom") ? d["consequenceForUsersInRoom"] : d["consequenceForUsersInRoom"] = ɵExtension.Provider.instance.getMethod("consequenceForUsersInRoom", () => {
            return Promise.resolve(ɵRepository.ɵRepository.instance.getFactory("@Result_2")([{
                    i: ["@Result_2Ok"],
                    w: function () { return ɵRepository.ɵRepository.instance.getFactory("@ResultForUsersInRoom_1")([]); }
                }, {
                    i: ["@Result_2Error"],
                    w: function () { return ɵRepository.ɵRepository.instance.getFactory("@ResultError_2")([]); }
                }]));
        }); }, set(v) { d["consequenceForUsersInRoom"] = v; }, enumerable: !0 },
    "consequenceForUsersInRoomSet": { get() { return d.hasOwnProperty("consequenceForUsersInRoomSet") ? d["consequenceForUsersInRoomSet"] : d["consequenceForUsersInRoomSet"] = ɵExtension.Provider.instance.getMethod("consequenceForUsersInRoomSet", () => {
            return Promise.resolve(ɵRepository.ɵRepository.instance.getFactory("@Result_2")([{
                    i: ["@Result_2Ok"],
                    w: function () { return ɵRepository.ɵRepository.instance.getFactory("@ResultForUsersInSet_1")([]); }
                }, {
                    i: ["@Result_2Error"],
                    w: function () { return ɵRepository.ɵRepository.instance.getFactory("@ResultError_2")([]); }
                }]));
        }); }, set(v) { d["consequenceForUsersInRoomSet"] = v; }, enumerable: !0 },
    "unbanUserFromRoomSet": { get() { return d.hasOwnProperty("unbanUserFromRoomSet") ? d["unbanUserFromRoomSet"] : d["unbanUserFromRoomSet"] = ɵExtension.Provider.instance.getMethod("unbanUserFromRoomSet", () => {
            return Promise.resolve(ɵRepository.ɵRepository.instance.getFactory("@Result_2")([{
                    i: ["@Result_2Ok"],
                    w: function () { return ɵRepository.ɵRepository.instance.getFactory("@RoomSetResult_1")([]); }
                }, {
                    i: ["@Result_2Error"],
                    w: function () { return ɵRepository.ɵRepository.instance.getFactory("@ResultError_2")([]); }
                }]));
        }); }, set(v) { d["unbanUserFromRoomSet"] = v; }, enumerable: !0 }
}); Object.defineProperty(m, ɵExtension.ɵMarker.instance.get(), { value: !0 }); return m; })(); });
// SPDX-FileCopyrightText: 2023-2024 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: AFL-3.0
const ts_auto_mock_1 = require("ts-auto-mock");
const Protection_1 = require("../../Protection");
require("./MemberBanSynchronisation");
const Action_1 = require("../../../Interface/Action");
const EventGeneration_1 = require("../../../TestUtilities/EventGeneration");
const DeclareRoomState_1 = require("../../../StateTracking/DeclareRoomState");
const MembershipChange_1 = require("../../../Membership/MembershipChange");
const wait_for_expect_1 = __importDefault(require("wait-for-expect"));
const PolicyEvents_1 = require("../../../MatrixTypes/PolicyEvents");
const Lifetime_1 = require("../../../Interface/Lifetime");
async function createMemberBanSynchronisationProtection(capabilities, protectedRoomsSet) {
    const description = (0, Protection_1.findProtection)('MemberBanSynchronisationProtection');
    if (description === undefined) {
        throw new TypeError('Should be able to find the member ban synchronisation protection');
    }
    const protectionResult = await description.factory(description, 
    // TODO: replace this when protected rooms set gets a lifetime.
    new Lifetime_1.StandardLifetime(), protectedRoomsSet, undefined, capabilities, {});
    if ((0, Action_1.isError)(protectionResult)) {
        throw new TypeError('Should be able to construct the protection');
    }
    // cba to add a generic to the protection description so the factory can have
    // a generic return type. Shouldn't be this level of disconect between types
    // and the real bullshit getting annoyed now whenver i have to do any meta
    // programming.
    return protectionResult.ok;
}
// handleMembershipChange
test('Membership changes that should result in a ban when matching an existing policy', async function () {
    const policyRoom = (0, EventGeneration_1.randomRoomID)([]);
    const protectedRoom = (0, EventGeneration_1.randomRoomID)([]);
    const changesToTest = [
        MembershipChange_1.MembershipChangeType.Invited,
        MembershipChange_1.MembershipChangeType.Joined,
        MembershipChange_1.MembershipChangeType.Knocked,
        MembershipChange_1.MembershipChangeType.Rejoined,
    ];
    const usersToTest = changesToTest.map((_change) => (0, EventGeneration_1.randomUserID)());
    const rejoiningUser = usersToTest[3];
    if (rejoiningUser === undefined) {
        throw new TypeError(`Test setup incorrectly`);
    }
    const { protectedRoomsSet, roomStateManager, roomMembershipManager } = await (0, DeclareRoomState_1.describeProtectedRoomsSet)({
        rooms: [
            {
                room: protectedRoom,
                membershipDescriptions: [
                    {
                        // we need this for the user who will rejoin the room.
                        sender: rejoiningUser,
                        membership: MembershipChange_1.Membership.Leave,
                    },
                ],
            },
        ],
        lists: [
            {
                room: policyRoom,
                policyDescriptions: usersToTest.map((userID) => ({
                    entity: userID,
                    type: PolicyEvents_1.PolicyRuleType.User,
                })),
            },
        ],
    });
    const userConsequences = ɵRepository.ɵRepository.instance.getFactory("@UserConsequences_1")([]);
    const consequenceSpy = jest.spyOn(userConsequences, 'consequenceForUserInRoom');
    const protection = await createMemberBanSynchronisationProtection({ userConsequences }, protectedRoomsSet);
    const membershipRevisionIssuer = roomMembershipManager.getFakeRoomMembershpRevisionIssuer(protectedRoom);
    roomStateManager.appendState({
        room: protectedRoom,
        membershipDescriptions: changesToTest.map((changeType, index) => {
            const membership = (() => {
                switch (changeType) {
                    case MembershipChange_1.MembershipChangeType.Invited:
                        return MembershipChange_1.Membership.Invite;
                    case MembershipChange_1.MembershipChangeType.Joined:
                    case MembershipChange_1.MembershipChangeType.Rejoined:
                        return MembershipChange_1.Membership.Join;
                    case MembershipChange_1.MembershipChangeType.Knocked:
                        return MembershipChange_1.Membership.Knock;
                    default:
                        throw new TypeError(`Unexpected membership change type in test`);
                }
            })();
            const userToTest = usersToTest[index];
            if (userToTest === undefined) {
                throw new TypeError(`There aren't enough test users for the changes to test`);
            }
            return {
                state_key: userToTest,
                sender: userToTest,
                membership: membership,
            };
        }),
    });
    await (0, wait_for_expect_1.default)(() => {
        expect(membershipRevisionIssuer.getNumberOfRevisions()).toBe(1);
    });
    const revisionEntry = membershipRevisionIssuer.getLastRevision();
    const protectionHandlerResult = await protection.handleMembershipChange.call(protection, revisionEntry[0], revisionEntry[1]);
    expect((0, Action_1.isOk)(protectionHandlerResult)).toBeTruthy();
    expect(consequenceSpy).toBeCalledTimes(usersToTest.length);
});
// handlePolicyRevision
// We need to test the consequence method itself in another test?
test('A policy change banning a user on a directly watched list will call the consequence to update for the revision', async function () {
    const spammerToBanUserID = `@spam:example.com`;
    const policyRoom = (0, EventGeneration_1.randomRoomID)([]);
    const { protectedRoomsSet, roomStateManager, policyRoomManager } = await (0, DeclareRoomState_1.describeProtectedRoomsSet)({
        rooms: [
            {
                membershipDescriptions: [
                    {
                        sender: spammerToBanUserID,
                        membership: MembershipChange_1.Membership.Join,
                    },
                ],
            },
        ],
        lists: [
            {
                room: policyRoom,
            },
        ],
    });
    const userConsequences = ɵRepository.ɵRepository.instance.getFactory("@UserConsequences_1")([]);
    const consequenceSpy = jest.spyOn(userConsequences, 'consequenceForUsersInRoomSet');
    const protection = await createMemberBanSynchronisationProtection({ userConsequences }, protectedRoomsSet);
    const policyRoomRevisionIssuer = policyRoomManager.getFakePolicyRoomRevisionIssuer(policyRoom);
    roomStateManager.appendState({
        room: policyRoom,
        policyDescriptions: [
            { entity: spammerToBanUserID, type: PolicyEvents_1.PolicyRuleType.User },
        ],
    });
    await (0, wait_for_expect_1.default)(() => {
        expect(policyRoomRevisionIssuer.getNumberOfRevisions()).toBe(1);
    });
    const revision = protectedRoomsSet.setPoliciesMatchingMembership.currentRevision;
    const protectionHandlerResult = await protection.synchroniseWithRevision(revision);
    expect((0, Action_1.isOk)(protectionHandlerResult)).toBeTruthy();
    expect(consequenceSpy).toHaveBeenCalled();
    expect(revision.allRulesMatchingMember(spammerToBanUserID, {})).toHaveLength(1);
});
//# sourceMappingURL=MemberBanSynchronisation.test.js.map