"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.StandardServerBanIntentProjection = void 0;
// SPDX-FileCopyrightText: 2025 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: Apache-2.0
//
// SPDX-FileAttributionText: <text>
// This modified file incorporates work from matrix-protection-suite
// https://github.com/Gnuxie/matrix-protection-suite
// </text>
const ulidx_1 = require("ulidx");
const Projection_1 = require("../../../Projection/Projection");
const ServerBanIntentProjectionNode_1 = require("./ServerBanIntentProjectionNode");
class StandardServerBanIntentProjection extends Projection_1.ProjectionOutputHelper {
    constructor(policyListRevisionIssuer) {
        const node = ServerBanIntentProjectionNode_1.StandardServerBanIntentProjectionNode.create((0, ulidx_1.monotonicFactory)());
        const delta = node.reduceInitialInputs([
            policyListRevisionIssuer.currentRevision,
        ]);
        super(node.reduceDelta(delta));
        this.policyListRevisionIssuer = policyListRevisionIssuer;
        this.handleUpstreamRevision = ((_revision, delta) => {
            this.applyInput(delta);
        });
        this.policyListRevisionIssuer.on('revision', this.handleUpstreamRevision);
    }
    [Symbol.dispose]() {
        this.policyListRevisionIssuer.off('revision', this.handleUpstreamRevision);
        super[Symbol.dispose]();
    }
}
exports.StandardServerBanIntentProjection = StandardServerBanIntentProjection;
//# sourceMappingURL=ServerBanIntentProjection.js.map