import { StateEvent } from '../MatrixTypes/Events';
import { MembershipEvent } from '../MatrixTypes/MembershipEvent';
import { Membership } from '../Membership/MembershipChange';
import { Recommendation } from '../PolicyList/PolicyRule';
import { PolicyRuleEvent, PolicyRuleType } from '../MatrixTypes/PolicyEvents';
import { ProtectedRoomsSet } from '../Protection/ProtectedRoomsSet';
import { FakeRoomStateRevisionIssuer } from './FakeRoomStateRevisionIssuer';
import { FakeRoomStateManager } from './FakeRoomStateManager';
import { FakeRoomMembershipManager } from '../Membership/FakeRoomMembershipManager';
import { FakePolicyRoomManager } from './FakePolicyRoomManager';
import { FakePolicyRoomRevisionIssuer } from '../PolicyList/FakePolicyRoomRevisionIssuer';
import { FakeRoomMembershipRevisionIssuer } from '../Membership/FakeRoomMembershipRevisionIssuer';
import { MatrixRoomID, StringRoomID, StringUserID } from '@the-draupnir-project/matrix-basic-types';
export type DescribeProtectedRoomsSet = {
    rooms?: DescribeRoomOptions[];
    lists?: DescribeRoomOptions[];
    clientUserID?: StringUserID;
};
export type ProtectedRoomsSetDescription = {
    protectedRoomsSet: ProtectedRoomsSet;
    roomStateManager: FakeRoomStateManager;
    policyRoomManager: FakePolicyRoomManager;
    roomMembershipManager: FakeRoomMembershipManager;
};
export declare function describeProtectedRoomsSet({ rooms, lists, clientUserID, }: DescribeProtectedRoomsSet): Promise<ProtectedRoomsSetDescription>;
export type RoomDescription = {
    stateRevisionIssuer: FakeRoomStateRevisionIssuer;
    membershipRevisionIssuer: FakeRoomMembershipRevisionIssuer;
    policyRevisionIssuer: FakePolicyRoomRevisionIssuer;
};
export type DescribeRoomOptions = {
    room?: MatrixRoomID;
    stateDescriptions?: DescribeStateEventOptions[];
    membershipDescriptions?: DescribeRoomMemberOptions[];
    policyDescriptions?: DescribePolicyRule[];
};
export type RoomStateDescription = {
    room: MatrixRoomID;
    stateEvents: StateEvent[];
    policyEvents: PolicyRuleEvent[];
    membershipEvents: MembershipEvent[];
};
export declare function describeRoomStateEvents({ room, stateDescriptions, membershipDescriptions, policyDescriptions, }: Omit<DescribeRoomOptions, 'room'> & {
    room: MatrixRoomID;
}): RoomStateDescription;
export declare function describeRoom({ room, stateDescriptions, membershipDescriptions, policyDescriptions, }: DescribeRoomOptions): RoomDescription;
export type DescribeRoomMemberOptions = {
    sender: StringUserID;
    target?: StringUserID;
    membership?: Membership;
    room_id?: StringRoomID;
    avatar_url?: string;
    displayname?: string;
    reason?: string;
};
export declare function describeRoomMember({ sender, target, membership, room_id, avatar_url, displayname, reason, }: DescribeRoomMemberOptions): MembershipEvent;
export type DescribePolicyRule = {
    sender?: StringUserID;
    room_id?: StringRoomID;
    type?: PolicyRuleType;
    entity?: string;
    hashes?: Record<string, string>;
    reason?: string;
    recommendation?: Recommendation;
    copyFrom?: PolicyRuleEvent;
    remove?: PolicyRuleEvent;
};
export declare function describePolicyRule({ sender, room_id, type, entity, reason, recommendation, copyFrom, remove, hashes, }: DescribePolicyRule): PolicyRuleEvent;
export type DescribeStateEventOptions = {
    sender: StringUserID;
    state_key?: string | undefined;
    content?: Record<string, unknown> | undefined;
    room_id?: StringRoomID | undefined;
    type: string;
};
export declare function describeStateEvent({ sender, state_key, type, content, room_id, }: DescribeStateEventOptions): StateEvent;
//# sourceMappingURL=DeclareRoomState.d.ts.map