"use strict";
// SPDX-FileCopyrightText: 2024 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: AFL-3.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.makeHandleMissingProtectionPermissions = makeHandleMissingProtectionPermissions;
const matrix_protection_suite_1 = require("matrix-protection-suite");
const mps_interface_adaptor_1 = require("@the-draupnir-project/mps-interface-adaptor");
const matrix_basic_types_1 = require("@the-draupnir-project/matrix-basic-types");
const interface_manager_1 = require("@the-draupnir-project/interface-manager");
function renderPermissions(title, permissions) {
    return permissions.length === 0 ? (interface_manager_1.DeadDocumentJSX.JSXFactory("fragment", null)) : (interface_manager_1.DeadDocumentJSX.JSXFactory("fragment", null,
        title,
        interface_manager_1.DeadDocumentJSX.JSXFactory("ul", null, permissions.map((permission) => (interface_manager_1.DeadDocumentJSX.JSXFactory("li", null,
            interface_manager_1.DeadDocumentJSX.JSXFactory("code", null, permission)))))));
}
function missingPermissionsTotal(change) {
    return (change.permissionsChange.missingEventPermissions.length +
        change.permissionsChange.missingPermissions.length +
        change.permissionsChange.missingStatePermissions.length);
}
function renderMissingProtectionPermissions(protectionPermissions) {
    return (interface_manager_1.DeadDocumentJSX.JSXFactory("details", null,
        interface_manager_1.DeadDocumentJSX.JSXFactory("summary", null,
            "The ",
            interface_manager_1.DeadDocumentJSX.JSXFactory("code", null, protectionPermissions.protection.description.name),
            " is missing the following permissions (",
            missingPermissionsTotal(protectionPermissions),
            "):"),
        renderPermissions(interface_manager_1.DeadDocumentJSX.JSXFactory("fragment", null, "Missing permissions:"), protectionPermissions.permissionsChange.missingPermissions),
        renderPermissions(interface_manager_1.DeadDocumentJSX.JSXFactory("fragment", null, "Missing state permissions:"), protectionPermissions.permissionsChange.missingStatePermissions),
        renderPermissions(interface_manager_1.DeadDocumentJSX.JSXFactory("fragment", null, "Missing event permissions:"), protectionPermissions.permissionsChange.missingEventPermissions)));
}
function renderMissingProtectionsPermissions(roomID, protectionPermissions) {
    return (interface_manager_1.DeadDocumentJSX.JSXFactory("fragment", null,
        "There are protections with missing permissions within the room",
        " ",
        (0, mps_interface_adaptor_1.renderRoomPill)(matrix_basic_types_1.MatrixRoomReference.fromRoomID(roomID, [])),
        ".",
        interface_manager_1.DeadDocumentJSX.JSXFactory("ul", null, protectionPermissions.map((details) => (interface_manager_1.DeadDocumentJSX.JSXFactory("li", null, renderMissingProtectionPermissions(details)))))));
}
function makeHandleMissingProtectionPermissions(roomMessageSender, managementRoomID) {
    return function (roomID, protectionPermissions) {
        void (0, matrix_protection_suite_1.Task)((0, mps_interface_adaptor_1.sendMatrixEventsFromDeadDocument)(roomMessageSender, managementRoomID, interface_manager_1.DeadDocumentJSX.JSXFactory("root", null, renderMissingProtectionsPermissions(roomID, protectionPermissions)), {}));
    };
}
//# sourceMappingURL=MissingProtectionPermissions.js.map