"use strict";
// SPDX-FileCopyrightText: 2025 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: AFL-3.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.CheckEventForSpamEndpoint = exports.CheckEventForSpamRequestBody = void 0;
const typebox_1 = require("@sinclair/typebox");
const matrix_protection_suite_1 = require("matrix-protection-suite");
const log = new matrix_protection_suite_1.Logger("CheckEventForSpamEndpoint");
exports.CheckEventForSpamRequestBody = typebox_1.Type.Object({
    event: (0, matrix_protection_suite_1.RoomEvent)(typebox_1.Type.Unknown()),
});
class CheckEventForSpamEndpoint {
    constructor(pluginManager) {
        this.pluginManager = pluginManager;
        // nothing to do.
    }
    async handleCheckEventForSpamAsync(request, response, isResponded) {
        const decodedBody = matrix_protection_suite_1.Value.Decode(exports.CheckEventForSpamRequestBody, request.body);
        if ((0, matrix_protection_suite_1.isError)(decodedBody)) {
            log.error("Error decoding request body:", decodedBody.error);
            if (!isResponded && this.pluginManager.isBlocking()) {
                response
                    .status(400)
                    .send({ errcode: "M_INVALID_PARAM", error: "Error handling event" });
            }
            return;
        }
        if (!isResponded && this.pluginManager.isBlocking()) {
            const blockingResult = await this.pluginManager.callBlockingHandles(decodedBody.ok);
            if (blockingResult === "NOT_SPAM") {
                response.status(200);
                response.send({});
            }
            else {
                response.status(400);
                response.send(blockingResult);
            }
        }
        else if (!isResponded) {
            response.status(200);
            response.send({});
        }
        this.pluginManager.callNonBlockingHandlesInTask(decodedBody.ok);
    }
    handleCheckEventForSpam(request, response) {
        if (!this.pluginManager.isBlocking()) {
            response.status(200);
            response.send({});
        }
        void (0, matrix_protection_suite_1.Task)(this.handleCheckEventForSpamAsync(request, response, !this.pluginManager.isBlocking()));
    }
}
exports.CheckEventForSpamEndpoint = CheckEventForSpamEndpoint;
//# sourceMappingURL=CheckEventForSpamEndpoint.js.map