"use strict";
// SPDX-FileCopyrightText: 2025 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: Apache-2.0
//
// SPDX-FileAttributionText: <text>
// This modified file incorporates work from Draupnir
// https://github.com/the-draupnir-project/Draupnir
// </text>
Object.defineProperty(exports, "__esModule", { value: true });
exports.handleHttpAntispamPing = handleHttpAntispamPing;
const typebox_1 = require("@sinclair/typebox");
const matrix_protection_suite_1 = require("matrix-protection-suite");
const log = new matrix_protection_suite_1.Logger("PingEndpoint");
const PingBody = typebox_1.Type.Object({
    id: typebox_1.Type.Unknown(),
});
function handleHttpAntispamPing(request, response) {
    const decodedBody = matrix_protection_suite_1.Value.Decode(PingBody, request.body);
    if ((0, matrix_protection_suite_1.isError)(decodedBody)) {
        log.error("Error decoding request body:", decodedBody.error);
        response.status(400).send({
            errcode: "M_INVALID_PARAM",
            error: "Error decoding request body",
        });
        return;
    }
    response.status(200).send({
        id: decodedBody.ok.id,
        status: "ok",
    });
}
//# sourceMappingURL=PingEndpoint.js.map