"use strict";
// SPDX-FileCopyrightText: 2025 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: AFL-3.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.SynapseHttpAntispam = void 0;
const SpamCheckEndpointPluginManager_1 = require("./SpamCheckEndpointPluginManager");
const UserMayInviteEndpoint_1 = require("./UserMayInviteEndpoint");
const UserMayJoinRoomEndpoint_1 = require("./UserMayJoinRoomEndpoint");
const CheckEventForSpamEndpoint_1 = require("./CheckEventForSpamEndpoint");
const PingEndpoint_1 = require("./PingEndpoint");
const SPAM_CHECK_PREFIX = "/api/1/spam_check";
const AUTHORIZATION = new RegExp("Bearer (.*)");
function makeAuthenticatedEndpointHandler(secret, cb) {
    return function (request, response) {
        const authorization = request.get("Authorization");
        if (!authorization) {
            response.status(401).send("Missing access token");
            return;
        }
        const [, accessToken] = AUTHORIZATION.exec(authorization) ?? [];
        if (accessToken !== secret) {
            response.status(401).send("Missing access token");
            return;
        }
        cb(request, response);
    };
}
class SynapseHttpAntispam {
    constructor(secret) {
        this.secret = secret;
        this.userMayInviteHandles = new SpamCheckEndpointPluginManager_1.SpamCheckEndpointPluginManager();
        this.userMayInviteEndpoint = new UserMayInviteEndpoint_1.UserMayInviteEndpoint(this.userMayInviteHandles);
        this.userMayJoinRoomHandles = new SpamCheckEndpointPluginManager_1.SpamCheckEndpointPluginManager();
        this.userMayJoinRoomEndpoint = new UserMayJoinRoomEndpoint_1.UserMayJoinRoomEndpoint(this.userMayJoinRoomHandles);
        this.checkEventForSpamHandles = new SpamCheckEndpointPluginManager_1.SpamCheckEndpointPluginManager();
        this.checkEventForSpamEndpoint = new CheckEventForSpamEndpoint_1.CheckEventForSpamEndpoint(this.checkEventForSpamHandles);
        // nothing to do
    }
    register(webController) {
        webController.post(`${SPAM_CHECK_PREFIX}/user_may_invite`, makeAuthenticatedEndpointHandler(this.secret, (request, response) => {
            this.userMayInviteEndpoint.handleUserMayInvite(request, response);
        }));
        webController.post(`${SPAM_CHECK_PREFIX}/user_may_join_room`, makeAuthenticatedEndpointHandler(this.secret, (request, response) => {
            this.userMayJoinRoomEndpoint.handleUserMayJoinRoom(request, response);
        }));
        webController.post(`${SPAM_CHECK_PREFIX}/check_event_for_spam`, makeAuthenticatedEndpointHandler(this.secret, (request, response) => {
            this.checkEventForSpamEndpoint.handleCheckEventForSpam(request, response);
        }));
        webController.post(`${SPAM_CHECK_PREFIX}/ping`, makeAuthenticatedEndpointHandler(this.secret, PingEndpoint_1.handleHttpAntispamPing));
    }
}
exports.SynapseHttpAntispam = SynapseHttpAntispam;
//# sourceMappingURL=SynapseHttpAntispam.js.map