"use strict";var I=Object.create;var h=Object.defineProperty;var M=Object.getOwnPropertyDescriptor;var U=Object.getOwnPropertyNames;var J=Object.getPrototypeOf;var N=Object.prototype.hasOwnProperty;var T=(p,e)=>h(p,"name",{value:e,configurable:true});var C=(p,e)=>{for(var t in e)h(p,t,{get:e[t],enumerable:true})};var E=(p,e,t,r)=>{if(e&&typeof e==="object"||typeof e==="function"){for(let s of U(e))if(!N.call(p,s)&&s!==t)h(p,s,{get:()=>e[s],enumerable:!(r=M(e,s))||r.enumerable})}return p};var d=(p,e,t)=>(t=p!=null?I(J(p)):{},E(e||!p||!p.__esModule?h(t,"default",{value:p,enumerable:true}):t,p));var B=p=>E(h({},"__esModule",{value:true}),p);var z={};C(z,{default:()=>R});module.exports=B(z);var w=require("node:path");var c=require("fs-extra");var y=d(require("ms"));var $=d(require("tar"));var m=d(require("../../models/Recipe"));var A=d(require("../../models/RecipePreview"));var D=d(require("../../models/Service"));var S=d(require("../../models/User"));var g=d(require("../../helpers/async-helpers"));var v=require("../../config");var q=require("../../environment-remote");var O=require("../../helpers/asar-helpers");var a=d(require("../apiBase"));var n=require("../utils/auth");var l=require("../../helpers/recipe-helpers");var b=require("../../helpers/service-helpers");const o=require("../../preload-safe-debug")("Ferdium:ServerApi");module.paths.unshift((0,l.getDevRecipeDirectory)(),(0,l.getRecipeDirectory)());class R{recipePreviews=[];recipes=[];async login(e,t){const r=await(0,n.sendAuthRequest)(`${(0,a.default)()}/auth/login`,{method:"POST",headers:{Authorization:`Basic ${Buffer.from(`${e}:${t}`).toString("base64")}`}},false);try{const s=await r.json();if(!r.ok){throw s}o("ServerApi::login resolves",s);return s.token}catch(s){o("ServerApi::login ERROR:",s);throw s}}async signup(e){const t=await(0,n.sendAuthRequest)(`${(0,a.default)()}/auth/signup`,{method:"POST",body:JSON.stringify(e)},false);try{const r=await t.json();if(!t.ok){throw r}o("ServerApi::signup resolves",r);return r.token}catch(r){o("ServerApi::signup ERROR:",r);throw r}}async inviteUser(e){const t=await(0,n.sendAuthRequest)(`${(0,a.default)()}/invite`,{method:"POST",body:JSON.stringify(e)});if(!t.ok){throw new Error(t.statusText)}o("ServerApi::inviteUser");return true}async retrievePassword(e){const t=await(0,n.sendAuthRequest)(`${(0,a.default)()}/auth/password`,{method:"POST",body:JSON.stringify({email:e})},false);if(!t.ok){throw new Error(t.statusText)}const r=await t.json();o("ServerApi::retrievePassword");return r}async userInfo(){if((0,a.default)()===v.SERVER_NOT_LOADED){throw new Error("Server not loaded")}const e=await(0,n.sendAuthRequest)(`${(0,a.default)()}/me`);if(!e.ok){throw new Error(e.statusText)}const t=await e.json();const r=new S.default(t);o("ServerApi::userInfo resolves",r);return r}async requestNewToken(){if((0,a.default)()===v.SERVER_NOT_LOADED){throw new Error("Server not loaded")}const e=await(0,n.sendAuthRequest)(`${(0,a.default)()}/me/newtoken`);if(!e.ok){throw new Error(e.statusText)}const t=await e.json();o("ServerApi::requestNewToken new authToken received");return t}async updateUserInfo(e){const t=await(0,n.sendAuthRequest)(`${(0,a.default)()}/me`,{method:"PUT",body:JSON.stringify(e)});if(!t.ok){throw new Error(t.statusText)}const r=await t.json();const s=Object.assign(r,{data:new S.default(r.data)});o("ServerApi::updateUserInfo resolves",s);return s}async deleteAccount(){const e=await(0,n.sendAuthRequest)(`${(0,a.default)()}/me`,{method:"DELETE"});if(!e.ok){throw new Error(e.statusText)}const t=await e.json();o("ServerApi::deleteAccount resolves",t);return t}async getServices(){if((0,a.default)()===v.SERVER_NOT_LOADED){throw new Error("Server not loaded")}const e=await(0,n.sendAuthRequest)(`${(0,a.default)()}/me/services`);if(!e.ok){throw new Error(e.statusText)}const t=await e.json();const r=await this._mapServiceModels(t);const s=r.filter(i=>!!i);o("ServerApi::getServices resolves",s);return s}async createService(e,t){const r=await(0,n.sendAuthRequest)(`${(0,a.default)()}/service`,{method:"POST",body:JSON.stringify({recipeId:e,...t})});if(!r.ok){throw new Error(r.statusText)}const s=await r.json();if(t.iconFile){const u=await this.uploadServiceIcon(s.data.id,t.iconFile);s.data=u}const i=Object.assign(s,{data:await this._prepareServiceModel(s.data)});o("ServerApi::createService resolves",i);return i}async updateService(e,t){const r=t;if(r.iconFile){await this.uploadServiceIcon(e,r.iconFile)}const s=await(0,n.sendAuthRequest)(`${(0,a.default)()}/service/${e}`,{method:"PUT",body:JSON.stringify(r)});if(!s.ok){throw new Error(s.statusText)}const i=await s.json();const u=Object.assign(i,{data:await this._prepareServiceModel(i.data)});o("ServerApi::updateService resolves",u);return u}async uploadServiceIcon(e,t){const r=new FormData;r.append("icon",t);const s=(0,n.prepareAuthRequest)({method:"PUT",body:r});delete s.headers["Content-Type"];await(0,n.prepareLocalToken)(s);const i=await window.fetch(`${(0,a.default)()}/service/${e}`,s);if(!i.ok){throw new Error(i.statusText)}const u=await i.json();return u.data}async reorderService(e){const t=await(0,n.sendAuthRequest)(`${(0,a.default)()}/service/reorder`,{method:"PUT",body:JSON.stringify(e)});if(!t.ok){throw new Error(t.statusText)}const r=await t.json();o("ServerApi::reorderService resolves",r);return r}async deleteService(e){const t=await(0,n.sendAuthRequest)(`${(0,a.default)()}/service/${e}`,{method:"DELETE"});if(!t.ok){throw new Error(t.statusText)}const r=await t.json();(0,b.removeServicePartitionDirectory)(e,true);o("ServerApi::deleteService resolves",r);return r}async getDefaultFeatures(){if((0,a.default)()===v.SERVER_NOT_LOADED){throw new Error("Server not loaded")}const e=await(0,n.sendAuthRequest)(`${(0,a.default)()}/features/default`);if(!e.ok){throw new Error(e.statusText)}const t=await e.json();const r=t;o("ServerApi::getDefaultFeatures resolves",r);return r}async getFeatures(){if((0,a.default)()===v.SERVER_NOT_LOADED){throw new Error("Server not loaded")}const e=await(0,n.sendAuthRequest)(`${(0,a.default)()}/features`);if(!e.ok){throw new Error(e.statusText)}const t=await e.json();const r=t;o("ServerApi::getFeatures resolves",r);return r}async getInstalledRecipes(){const e=(0,l.getRecipeDirectory)();const t=(0,c.readdirSync)(e).filter(r=>(0,c.statSync)((0,w.join)(e,r)).isDirectory()&&r!=="temp"&&r!=="dev");this.recipes=t.map(r=>{const s=require(r)(m.default);return new s((0,l.loadRecipeConfig)(r))}).filter(r=>r.id);this.recipes=this.recipes.concat(this._getDevRecipes());o("StubServerApi::getInstalledRecipes resolves",this.recipes);return this.recipes}async getRecipeUpdates(e){const t=await(0,n.sendAuthRequest)(`${(0,a.default)()}/recipes/update`,{method:"POST",body:JSON.stringify(e)});if(!t.ok){throw new Error(t.statusText)}const r=await t.json();o("ServerApi::getRecipeUpdates resolves",r);return r}async getRecipePreviews(){const e=await(0,n.sendAuthRequest)(`${(0,a.default)()}/recipes`);if(!e.ok)throw new Error(e.statusText);const t=await e.json();const r=this._mapRecipePreviewModel(t);o("ServerApi::getRecipes resolves",r);return r}async getFeaturedRecipePreviews(){const e=await(0,n.sendAuthRequest)(`${(0,a.default)()}/recipes/popular`);if(!e.ok)throw new Error(e.statusText);const t=await e.json();const r=this._mapRecipePreviewModel(t);o("ServerApi::getFeaturedRecipes resolves",r);return r}async searchRecipePreviews(e){const t=`${(0,a.default)()}/recipes/search?needle=${e}`;const r=await(0,n.sendAuthRequest)(t);if(!r.ok)throw new Error(r.statusText);const s=await r.json();const i=this._mapRecipePreviewModel(s);o("ServerApi::searchRecipePreviews resolves",i);return i}async getRecipePackage(e){const t=(0,q.userDataRecipesPath)();const r=(0,w.join)(t,"temp",e);const s=(0,w.join)(r,"recipe.tar.gz");const i=(0,O.asarRecipesPath)(`${e}.tar.gz`);(0,c.ensureDirSync)(r);let u;if((0,c.pathExistsSync)(i)){o("[ServerApi::getRecipePackage] Using internal recipe file");u=i}else{o("[ServerApi::getRecipePackage] Downloading recipe from server");u=s;const f=`${(0,a.default)()}/recipes/download/${e}`;const x=await window.fetch(f);o("Recipe downloaded",e);const F=await x.blob();const _=await F.arrayBuffer();(0,c.writeFileSync)(s,Buffer.from(_))}o(u);await(0,g.default)((0,y.default)("10ms"));await $.default.x({file:u,cwd:r,preservePaths:true,unlink:true,preserveOwner:false,onwarn:f=>o("warn",e,f)});await(0,g.default)((0,y.default)("10ms"));const{id:P,defaultIcon:j}=(0,c.readJsonSync)((0,w.join)(r,"package.json"));const k=(0,w.join)(t,P);(0,c.copySync)(r,k);(0,c.removeSync)(r);(0,c.removeSync)((0,w.join)(t,e,"recipe.tar.gz"));if(j){(0,c.removeSync)((0,w.join)(k,"icon.svg"))}return P}async healthCheck(){if((0,a.default)()===v.SERVER_NOT_LOADED){throw new Error("Server not loaded")}const e=await(0,n.sendAuthRequest)(`${(0,a.default)(false)}/health`,{method:"GET"},false);if(!e.ok){throw new Error(e.statusText)}o("ServerApi::healthCheck resolves")}async _mapServiceModels(e){const t=e.map(r=>r.recipeId);await this._bulkRecipeCheck(t);return Promise.all(e.map(async r=>this._prepareServiceModel(r)))}async _prepareServiceModel(e){try{const t=this.recipes.find(r=>r.id===e.recipeId);if(!t){console.warn(`Recipe ${e.recipeId} not loaded`);return null}return new D.default(e,t)}catch(t){o(t);return null}}async _bulkRecipeCheck(e){const t=e.filter((r,s,i)=>i.indexOf(r)===s);return Promise.all(t.map(async r=>{let s=this.recipes.find(i=>i.id===r);if(!s){console.warn(`Recipe '${r}' not installed, trying to fetch from server`);await this.getRecipePackage(r);o("Rerun ServerAPI::getInstalledRecipes");await this.getInstalledRecipes();s=this.recipes.find(i=>i.id===r);if(!s){console.warn(`Could not load recipe ${r}`);return null}}return s})).catch(r=>console.error("Can't load recipe",r))}_mapRecipePreviewModel(e){return e.map(t=>{try{return new A.default(t)}catch(r){console.error(r);return null}}).filter(Boolean)}_getDevRecipes(){const e=(0,l.getDevRecipeDirectory)();try{const t=(0,c.readdirSync)(e).filter(s=>(0,c.statSync)((0,w.join)(e,s)).isDirectory()&&s!=="temp");const r=t.map(s=>{try{const i=require(s)(m.default);return new i((0,l.loadRecipeConfig)(s))}catch(i){console.error(i)}return false}).filter(s=>s.id).map(s=>{const i=s;i.icons={svg:`${i.path}/icon.svg`};i.local=true;return s});return r}catch{o("Could not load dev recipes");return false}}}T(R,"ServerApi");
