const tslib = require('tslib');
const electron = require('electron');
const fs = require('fs');
const path = require('path');
const util = require('util');

const sentryCachePath = path.join(electron.app ? electron.app.getPath('userData') : '', 'sentry');
const writeFileAsync = util.promisify(fs.writeFile);
const readFileAsync = util.promisify(fs.readFile);
const mkdirAsync = util.promisify(fs.mkdir);
const statAsync = util.promisify(fs.stat);
const unlinkAsync = util.promisify(fs.unlink);
const readDirAsync = util.promisify(fs.readdir);
// mkdir with recursive was only added in Node 10+
/**
 * Recursively creates the given path.
 *
 * @param path A relative or absolute path to create.
 * @returns A Promise that resolves when the path has been created.
 */
function mkdirp(path$1) {
    return tslib.__awaiter(this, void 0, void 0, function* () {
        // eslint-disable-next-line no-bitwise
        const realPath = path.resolve(path$1);
        try {
            yield mkdirAsync(realPath, 0o777);
        }
        catch (err) {
            const error = err;
            if (error && error.code === 'ENOENT') {
                yield mkdirp(path.dirname(realPath));
                yield mkdirAsync(realPath, 0o777);
            }
            try {
                if (!fs.statSync(realPath).isDirectory()) {
                    throw err;
                }
            }
            catch (_) {
                throw err;
            }
        }
    });
}

exports.mkdirAsync = mkdirAsync;
exports.mkdirp = mkdirp;
exports.readDirAsync = readDirAsync;
exports.readFileAsync = readFileAsync;
exports.sentryCachePath = sentryCachePath;
exports.statAsync = statAsync;
exports.unlinkAsync = unlinkAsync;
exports.writeFileAsync = writeFileAsync;
//# sourceMappingURL=fs.js.map
