const tslib = require('tslib');
const core = require('@sentry/core');
const electron = require('electron');
const context = require('../context.js');
const normalize = require('../../common/normalize.js');
const merge = require('../../common/merge.js');

/** Adds Electron context to events and normalises paths. */
class MainContext {
    constructor() {
        this.name = MainContext.id;
    }
    /** @inheritDoc */
    setupOnce(addGlobalEventProcessor) {
        var _a;
        const options = (_a = core.getCurrentHub().getClient()) === null || _a === void 0 ? void 0 : _a.getOptions();
        addGlobalEventProcessor((event) => tslib.__awaiter(this, void 0, void 0, function* () {
            const normalized = normalize.normalizeEvent(event, electron.app.getAppPath());
            const defaults = yield context.getEventDefaults(options === null || options === void 0 ? void 0 : options.release, options === null || options === void 0 ? void 0 : options.environment);
            return merge.mergeEvents(defaults, normalized);
        }));
    }
}
/** @inheritDoc */
MainContext.id = 'MainContext';

exports.MainContext = MainContext;
//# sourceMappingURL=main-context.js.map
