const core = require('@sentry/core');
const utils = require('@sentry/utils');
const ipc = require('../ipc.js');

/**
 * Passes scope changes to the main process.
 */
class ScopeToMain {
    constructor() {
        this.name = ScopeToMain.id;
    }
    /** @inheritDoc */
    setupOnce() {
        this._setupScopeListener();
    }
    /**
     * Sends the scope to the main process when it updates.
     */
    _setupScopeListener() {
        const scope = core.getCurrentHub().getScope();
        if (scope) {
            const ipc$1 = ipc.getIPC();
            scope.addScopeListener((updatedScope) => {
                ipc$1.sendScope(JSON.stringify(utils.normalize(updatedScope, 20, 2000)));
                scope.clearBreadcrumbs();
                scope.clearAttachments();
            });
        }
    }
}
/** @inheritDoc */
ScopeToMain.id = 'ScopeToMain';

exports.ScopeToMain = ScopeToMain;
//# sourceMappingURL=scope-to-main.js.map
