(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define([], factory);
	else if(typeof exports === 'object')
		exports["MobxReactFormValidatorJOI"] = factory();
	else
		root["MobxReactFormValidatorJOI"] = factory();
})(self, () => {
return /******/ (() => { // webpackBootstrap
/******/ 	"use strict";
var __webpack_exports__ = {};
// This entry need to be wrapped in an IIFE because it uses a non-standard name for the exports (exports).
(() => {
var exports = __webpack_exports__;
/*!*******************************!*\
  !*** ./src/validators/JOI.ts ***!
  \*******************************/

Object.defineProperty(exports, "__esModule", ({ value: true }));
class JOI {
    constructor({ config, state = null, promises = [], }) {
        Object.defineProperty(this, "promises", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: []
        });
        Object.defineProperty(this, "config", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: null
        });
        Object.defineProperty(this, "state", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: null
        });
        Object.defineProperty(this, "extend", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: null
        });
        Object.defineProperty(this, "validator", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: null
        });
        Object.defineProperty(this, "schema", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: null
        });
        this.state = state;
        this.promises = promises;
        this.extend = config === null || config === void 0 ? void 0 : config.extend;
        this.validator = config.package;
        this.schema = config.schema;
        this.extendValidator();
    }
    extendValidator() {
        // extend using "extend" callback
        if (typeof this.extend === "function") {
            this.extend({
                validator: this.validator,
                form: this.state.form,
            });
        }
    }
    validate(field) {
        const { error } = this.schema.validate(field.state.form.validatedValues, { abortEarly: false });
        if (!error)
            return;
        const fieldPathArray = field.path.split('.');
        const fieldErrors = error.details
            .filter(detail => {
            const errorPathString = detail.path.join('.');
            const fieldPathString = fieldPathArray.join('.');
            return errorPathString === fieldPathString || errorPathString.startsWith(`${fieldPathString}.`);
        })
            .map(detail => {
            var _a;
            // Replace the path in the error message with the custom label
            const label = ((_a = detail.context) === null || _a === void 0 ? void 0 : _a.label) || detail.path.join('.');
            const message = detail.message.replace(`${detail.path.join('.')}`, label);
            return message;
        });
        if (fieldErrors.length) {
            field.validationErrorStack = fieldErrors;
        }
    }
}
exports["default"] = (config) => ({
    class: JOI,
    config,
});

})();

/******/ 	return __webpack_exports__;
/******/ })()
;
});
//# sourceMappingURL=MobxReactFormValidatorJOI.umd.js.map