/* playlist-file.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from playlist-file.vala, do not modify */

#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>

#define G4_PLAY_LIST_TYPE_NONE ((guint) 0)
#define G4_PLAY_LIST_TYPE_M3U ((guint) 1)
#define G4_PLAY_LIST_TYPE_PLS ((guint) 2)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

VALA_EXTERN guint g4_get_playlist_type (const gchar* mimetype);
VALA_EXTERN gboolean g4_is_playlist_file (const gchar* mimetype);
VALA_EXTERN gboolean g4_is_valid_uri (const gchar* uri,
                          GUriFlags flags);
VALA_EXTERN gchar* g4_load_playlist_file (GFile* file,
                              GPtrArray* uris);
VALA_EXTERN gchar* g4_load_m3u_file (GDataInputStream* dis,
                         GFile* parent,
                         GPtrArray* uris,
                         GError** error);
VALA_EXTERN gchar* g4_load_pls_file (GDataInputStream* dis,
                         GFile* parent,
                         GPtrArray* uris,
                         GError** error);
VALA_EXTERN gchar* g4_get_file_display_name (GFile* file);
VALA_EXTERN gchar* g4_parse_relative_uri (const gchar* uri,
                              GFile* parent);
VALA_EXTERN gchar* g4_get_relative_path (GFile* parent,
                             GFile* file);
VALA_EXTERN gboolean g4_save_m3u8_file (GDataOutputStream* dos,
                            GFile* parent,
                            GPtrArray* uris,
                            const gchar* title,
                            gboolean with_titles,
                            GError** error);
VALA_EXTERN gboolean g4_save_pls_file (GDataOutputStream* dos,
                           GFile* parent,
                           GPtrArray* uris,
                           const gchar* title,
                           gboolean with_titles,
                           GError** error);
VALA_EXTERN gboolean g4_save_playlist_file (GFile* file,
                                GPtrArray* uris,
                                const gchar* title,
                                gboolean with_titles);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

guint
g4_get_playlist_type (const gchar* mimetype)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	guint result;
	g_return_val_if_fail (mimetype != NULL, 0U);
	_tmp0_ = mimetype;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if ((_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("audio/x-mpegurl")))) || (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("public.m3u-playlist"))))) {
		switch (0) {
			default:
			{
				result = G4_PLAY_LIST_TYPE_M3U;
				return result;
			}
		}
	} else if ((_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("audio/x-scpls")))) || (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("public.pls-playlist"))))) {
		switch (0) {
			default:
			{
				result = G4_PLAY_LIST_TYPE_PLS;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				result = G4_PLAY_LIST_TYPE_NONE;
				return result;
			}
		}
	}
}

gboolean
g4_is_playlist_file (const gchar* mimetype)
{
	gboolean result;
	g_return_val_if_fail (mimetype != NULL, FALSE);
	result = g4_get_playlist_type (mimetype) != G4_PLAY_LIST_TYPE_NONE;
	return result;
}

gboolean
g4_is_valid_uri (const gchar* uri,
                 GUriFlags flags)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (uri != NULL, FALSE);
	{
		gboolean _tmp0_ = FALSE;
		_tmp0_ = g_uri_is_valid (uri, flags, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		result = _tmp0_;
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp1_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp1_;
	}
	result = FALSE;
	return result;
}

gchar*
g4_load_playlist_file (GFile* file,
                       GPtrArray* uris)
{
	gchar* title = NULL;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (uris != NULL, NULL);
	title = NULL;
	{
		GFileInfo* info = NULL;
		GFileInfo* _tmp0_;
		const gchar* _tmp1_ = NULL;
		GFileInfo* _tmp2_;
		const gchar* _tmp3_;
		guint type = 0U;
		GFileInputStream* fis = NULL;
		GFileInputStream* _tmp4_;
		GBufferedInputStream* bis = NULL;
		GFileInputStream* _tmp5_;
		GBufferedInputStream* _tmp6_;
		GDataInputStream* dis = NULL;
		GBufferedInputStream* _tmp7_;
		GDataInputStream* _tmp8_;
		GFile* parent = NULL;
		GFile* _tmp9_;
		gchar* _tmp20_ = NULL;
		const gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp24_;
		_tmp0_ = g_file_query_info (file, G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
		info = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = info;
		_tmp3_ = g_file_info_get_content_type (_tmp2_);
		_tmp1_ = _tmp3_;
		if (_tmp1_ == NULL) {
			_tmp1_ = "";
		}
		type = g4_get_playlist_type ((const gchar*) _tmp1_);
		_tmp4_ = g_file_read (file, NULL, &_inner_error0_);
		fis = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (info);
			goto __catch0_g_error;
		}
		_tmp5_ = fis;
		_tmp6_ = (GBufferedInputStream*) g_buffered_input_stream_new ((GInputStream*) _tmp5_);
		bis = _tmp6_;
		_tmp7_ = bis;
		_tmp8_ = g_data_input_stream_new ((GInputStream*) _tmp7_);
		dis = _tmp8_;
		_tmp9_ = g_file_get_parent (file);
		parent = _tmp9_;
		switch (type) {
			case G4_PLAY_LIST_TYPE_M3U:
			{
				gchar* _tmp10_ = NULL;
				GDataInputStream* _tmp11_;
				GFile* _tmp12_;
				gchar* _tmp13_;
				gchar* _tmp14_;
				_tmp11_ = dis;
				_tmp12_ = parent;
				_tmp13_ = g4_load_m3u_file (_tmp11_, _tmp12_, uris, &_inner_error0_);
				_tmp10_ = _tmp13_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (parent);
					_g_object_unref0 (dis);
					_g_object_unref0 (bis);
					_g_object_unref0 (fis);
					_g_object_unref0 (info);
					goto __catch0_g_error;
				}
				_tmp14_ = _tmp10_;
				_tmp10_ = NULL;
				_g_free0 (title);
				title = _tmp14_;
				_g_free0 (_tmp10_);
				break;
			}
			case G4_PLAY_LIST_TYPE_PLS:
			{
				gchar* _tmp15_ = NULL;
				GDataInputStream* _tmp16_;
				GFile* _tmp17_;
				gchar* _tmp18_;
				gchar* _tmp19_;
				_tmp16_ = dis;
				_tmp17_ = parent;
				_tmp18_ = g4_load_pls_file (_tmp16_, _tmp17_, uris, &_inner_error0_);
				_tmp15_ = _tmp18_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (parent);
					_g_object_unref0 (dis);
					_g_object_unref0 (bis);
					_g_object_unref0 (fis);
					_g_object_unref0 (info);
					goto __catch0_g_error;
				}
				_tmp19_ = _tmp15_;
				_tmp15_ = NULL;
				_g_free0 (title);
				title = _tmp19_;
				_g_free0 (_tmp15_);
				break;
			}
			default:
			break;
		}
		_tmp21_ = title;
		_tmp22_ = g_strdup (_tmp21_);
		_tmp20_ = _tmp22_;
		if (_tmp20_ == NULL) {
			gchar* _tmp23_;
			_tmp23_ = g4_get_file_display_name (file);
			_g_free0 (_tmp20_);
			_tmp20_ = _tmp23_;
		}
		_tmp24_ = _tmp20_;
		_tmp20_ = NULL;
		result = (gchar*) _tmp24_;
		_g_free0 (_tmp20_);
		_g_object_unref0 (parent);
		_g_object_unref0 (dis);
		_g_object_unref0 (bis);
		_g_object_unref0 (fis);
		_g_object_unref0 (info);
		_g_free0 (title);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (title);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = NULL;
	_g_free0 (title);
	return result;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

gchar*
g4_load_m3u_file (GDataInputStream* dis,
                  GFile* parent,
                  GPtrArray* uris,
                  GError** error)
{
	gsize length = 0UL;
	gchar* str = NULL;
	gchar* title = NULL;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (dis != NULL, NULL);
	g_return_val_if_fail (uris != NULL, NULL);
	length = (gsize) 0;
	str = NULL;
	title = NULL;
	while (TRUE) {
		gchar* _tmp0_ = NULL;
		gsize _tmp1_ = 0UL;
		gchar* _tmp2_;
		gchar* _tmp3_;
		const gchar* _tmp4_;
		gchar* line = NULL;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp2_ = g_data_input_stream_read_line_utf8 (dis, &_tmp1_, NULL, &_inner_error0_);
		length = _tmp1_;
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (title);
			_g_free0 (str);
			return NULL;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		_g_free0 (str);
		str = _tmp3_;
		_tmp4_ = str;
		if (!(_tmp4_ != NULL)) {
			_g_free0 (_tmp0_);
			break;
		}
		_tmp5_ = str;
		_tmp6_ = g_strdup ((const gchar*) _tmp5_);
		line = _tmp6_;
		_tmp7_ = line;
		if (g_str_has_prefix (_tmp7_, "#PLAYLIST:")) {
			gchar* text = NULL;
			const gchar* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			const gchar* _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			_tmp8_ = line;
			_tmp9_ = string_substring (_tmp8_, (glong) 10, (glong) -1);
			_tmp10_ = _tmp9_;
			_tmp11_ = string_strip (_tmp10_);
			_tmp12_ = _tmp11_;
			_g_free0 (_tmp10_);
			text = _tmp12_;
			_tmp13_ = text;
			_tmp14_ = strlen (_tmp13_);
			_tmp15_ = _tmp14_;
			if (_tmp15_ > 0) {
				const gchar* _tmp16_;
				gchar* _tmp17_;
				_tmp16_ = text;
				_tmp17_ = g_strdup (_tmp16_);
				_g_free0 (title);
				title = _tmp17_;
			}
			_g_free0 (text);
		} else {
			gboolean _tmp18_ = FALSE;
			if (length > ((gsize) 0)) {
				const gchar* _tmp19_;
				_tmp19_ = line;
				_tmp18_ = string_get (_tmp19_, (glong) 0) != '#';
			} else {
				_tmp18_ = FALSE;
			}
			if (_tmp18_) {
				gchar* abs_uri = NULL;
				const gchar* _tmp20_;
				gchar* _tmp21_;
				gchar* _tmp22_;
				gchar* _tmp23_;
				gchar* _tmp24_;
				const gchar* _tmp25_;
				_tmp20_ = line;
				_tmp21_ = string_strip (_tmp20_);
				_tmp22_ = _tmp21_;
				_tmp23_ = g4_parse_relative_uri (_tmp22_, parent);
				_tmp24_ = _tmp23_;
				_g_free0 (_tmp22_);
				abs_uri = _tmp24_;
				_tmp25_ = abs_uri;
				if (_tmp25_ != NULL) {
					const gchar* _tmp26_;
					gchar* _tmp27_;
					_tmp26_ = abs_uri;
					_tmp27_ = g_strdup ((const gchar*) _tmp26_);
					g_ptr_array_add (uris, _tmp27_);
				}
				_g_free0 (abs_uri);
			}
		}
		_g_free0 (line);
		_g_free0 (_tmp0_);
	}
	result = title;
	_g_free0 (str);
	return result;
}

static gint
string_index_of_char (const gchar* self,
                      gunichar c,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

gchar*
g4_load_pls_file (GDataInputStream* dis,
                  GFile* parent,
                  GPtrArray* uris,
                  GError** error)
{
	gboolean list_found = FALSE;
	gsize length = 0UL;
	gchar* str = NULL;
	gchar* title = NULL;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (dis != NULL, NULL);
	g_return_val_if_fail (uris != NULL, NULL);
	list_found = FALSE;
	length = (gsize) 0;
	str = NULL;
	title = NULL;
	while (TRUE) {
		gchar* _tmp0_ = NULL;
		gsize _tmp1_ = 0UL;
		gchar* _tmp2_;
		gchar* _tmp3_;
		const gchar* _tmp4_;
		gint pos = 0;
		gchar* line = NULL;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gboolean _tmp7_ = FALSE;
		const gchar* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		_tmp2_ = g_data_input_stream_read_line_utf8 (dis, &_tmp1_, NULL, &_inner_error0_);
		length = _tmp1_;
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (title);
			_g_free0 (str);
			return NULL;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		_g_free0 (str);
		str = _tmp3_;
		_tmp4_ = str;
		if (!(_tmp4_ != NULL)) {
			_g_free0 (_tmp0_);
			break;
		}
		pos = -1;
		_tmp5_ = str;
		_tmp6_ = string_strip ((const gchar*) _tmp5_);
		line = _tmp6_;
		_tmp8_ = line;
		_tmp9_ = strlen (_tmp8_);
		_tmp10_ = _tmp9_;
		if (_tmp10_ > 1) {
			const gchar* _tmp11_;
			_tmp11_ = line;
			_tmp7_ = string_get (_tmp11_, (glong) 0) == '[';
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			const gchar* _tmp12_;
			_tmp12_ = line;
			list_found = g_strcmp0 (_tmp12_, "[playlist]") == 0;
		} else {
			gboolean _tmp13_ = FALSE;
			if (list_found) {
				const gchar* _tmp14_;
				_tmp14_ = line;
				pos = string_index_of_char (_tmp14_, (gunichar) '=', 0);
				_tmp13_ = pos > 0;
			} else {
				_tmp13_ = FALSE;
			}
			if (_tmp13_) {
				const gchar* _tmp15_;
				_tmp15_ = line;
				if (g_str_has_prefix (_tmp15_, "File")) {
					gchar* uri = NULL;
					const gchar* _tmp16_;
					gchar* _tmp17_;
					gchar* _tmp18_;
					gchar* _tmp19_;
					gchar* _tmp20_;
					gchar* abs_uri = NULL;
					const gchar* _tmp21_;
					gchar* _tmp22_;
					const gchar* _tmp23_;
					_tmp16_ = line;
					_tmp17_ = string_substring (_tmp16_, (glong) (pos + 1), (glong) -1);
					_tmp18_ = _tmp17_;
					_tmp19_ = string_strip (_tmp18_);
					_tmp20_ = _tmp19_;
					_g_free0 (_tmp18_);
					uri = _tmp20_;
					_tmp21_ = uri;
					_tmp22_ = g4_parse_relative_uri (_tmp21_, parent);
					abs_uri = _tmp22_;
					_tmp23_ = abs_uri;
					if (_tmp23_ != NULL) {
						const gchar* _tmp24_;
						gchar* _tmp25_;
						_tmp24_ = abs_uri;
						_tmp25_ = g_strdup ((const gchar*) _tmp24_);
						g_ptr_array_add (uris, _tmp25_);
					}
					_g_free0 (abs_uri);
					_g_free0 (uri);
				} else {
					const gchar* _tmp26_;
					_tmp26_ = line;
					if (g_ascii_strncasecmp (_tmp26_, "X-GNOME-Title", (gsize) pos) == 0) {
						gchar* text = NULL;
						const gchar* _tmp27_;
						gchar* _tmp28_;
						gchar* _tmp29_;
						gchar* _tmp30_;
						gchar* _tmp31_;
						const gchar* _tmp32_;
						gint _tmp33_;
						gint _tmp34_;
						_tmp27_ = line;
						_tmp28_ = string_substring (_tmp27_, (glong) (pos + 1), (glong) -1);
						_tmp29_ = _tmp28_;
						_tmp30_ = string_strip (_tmp29_);
						_tmp31_ = _tmp30_;
						_g_free0 (_tmp29_);
						text = _tmp31_;
						_tmp32_ = text;
						_tmp33_ = strlen (_tmp32_);
						_tmp34_ = _tmp33_;
						if (_tmp34_ > 0) {
							const gchar* _tmp35_;
							gchar* _tmp36_;
							_tmp35_ = text;
							_tmp36_ = g_strdup (_tmp35_);
							_g_free0 (title);
							title = _tmp36_;
						}
						_g_free0 (text);
					}
				}
			}
		}
		_g_free0 (line);
		_g_free0 (_tmp0_);
	}
	result = title;
	_g_free0 (str);
	return result;
}

gchar*
g4_get_relative_path (GFile* parent,
                      GFile* file)
{
	GFile* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* path = NULL;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* file_path = NULL;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	GFile* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp15_;
	const gchar* _tmp16_;
	gchar* parent_path = NULL;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	gint pos = 0;
	gchar* result;
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = parent;
	_tmp1_ = NULL;
	if (_tmp0_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = g_file_get_relative_path (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, g_file_get_type (), GFile), file);
		_g_free0 (_tmp1_);
		_tmp1_ = _tmp2_;
	}
	_tmp3_ = _tmp1_;
	_tmp1_ = NULL;
	path = _tmp3_;
	_tmp4_ = path;
	if (_tmp4_ != NULL) {
		const gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = path;
		_tmp6_ = g_strdup ((const gchar*) _tmp5_);
		result = _tmp6_;
		_g_free0 (path);
		_g_free0 (_tmp1_);
		return result;
	}
	_tmp7_ = g_file_get_path (file);
	_g_free0 (path);
	path = _tmp7_;
	_tmp8_ = path;
	if (_tmp8_ == NULL) {
		gchar* _tmp9_;
		_tmp9_ = g_strdup ("");
		result = _tmp9_;
		_g_free0 (path);
		_g_free0 (_tmp1_);
		return result;
	}
	_tmp10_ = path;
	_tmp11_ = g_strdup ((const gchar*) _tmp10_);
	file_path = _tmp11_;
	_tmp12_ = parent;
	_tmp13_ = NULL;
	if (_tmp12_ != NULL) {
		gchar* _tmp14_;
		_tmp14_ = g_file_get_path (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, g_file_get_type (), GFile));
		_g_free0 (_tmp13_);
		_tmp13_ = _tmp14_;
	}
	_tmp15_ = _tmp13_;
	_tmp13_ = NULL;
	_g_free0 (path);
	path = _tmp15_;
	_tmp16_ = path;
	if (_tmp16_ == NULL) {
		result = file_path;
		_g_free0 (_tmp13_);
		_g_free0 (path);
		_g_free0 (_tmp1_);
		return result;
	}
	_tmp17_ = path;
	_tmp18_ = g_strdup ((const gchar*) _tmp17_);
	parent_path = _tmp18_;
	pos = 0;
	{
		gboolean _tmp19_ = FALSE;
		_tmp19_ = TRUE;
		while (TRUE) {
			gint ret = 0;
			const gchar* _tmp20_;
			gboolean _tmp21_ = FALSE;
			if (!_tmp19_) {
				if (!(pos > 0)) {
					break;
				}
			}
			_tmp19_ = FALSE;
			_tmp20_ = file_path;
			ret = string_index_of_char (_tmp20_, (gunichar) '/', pos + 1);
			if (ret > pos) {
				const gchar* _tmp22_;
				const gchar* _tmp23_;
				_tmp22_ = file_path;
				_tmp23_ = parent_path;
				_tmp21_ = g_ascii_strncasecmp (_tmp22_, _tmp23_, (gsize) ret) == 0;
			} else {
				_tmp21_ = FALSE;
			}
			if (_tmp21_) {
				pos = ret;
			} else {
				break;
			}
		}
	}
	if (pos > 1) {
		gint len = 0;
		const gchar* _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		GString* sb = NULL;
		GString* _tmp27_;
		GString* _tmp32_;
		const gchar* _tmp33_;
		const gchar* _tmp34_;
		gchar* _tmp35_;
		gchar* _tmp36_;
		gchar* _tmp37_;
		_tmp24_ = parent_path;
		_tmp25_ = strlen (_tmp24_);
		_tmp26_ = _tmp25_;
		len = _tmp26_;
		_tmp27_ = g_string_new ("");
		sb = _tmp27_;
		{
			gint p = 0;
			p = pos;
			{
				gboolean _tmp28_ = FALSE;
				_tmp28_ = TRUE;
				while (TRUE) {
					gboolean _tmp30_ = FALSE;
					GString* _tmp31_;
					if (!_tmp28_) {
						const gchar* _tmp29_;
						_tmp29_ = parent_path;
						p = string_index_of_char (_tmp29_, (gunichar) '/', p + 1);
					}
					_tmp28_ = FALSE;
					if (p > 0) {
						_tmp30_ = p < len;
					} else {
						_tmp30_ = FALSE;
					}
					if (!_tmp30_) {
						break;
					}
					_tmp31_ = sb;
					g_string_append (_tmp31_, "../");
				}
			}
		}
		_tmp32_ = sb;
		_tmp33_ = _tmp32_->str;
		_tmp34_ = file_path;
		_tmp35_ = string_substring (_tmp34_, (glong) (pos + 1), (glong) -1);
		_tmp36_ = _tmp35_;
		_tmp37_ = g_strconcat (_tmp33_, _tmp36_, NULL);
		_g_free0 (file_path);
		file_path = _tmp37_;
		_g_free0 (_tmp36_);
		_g_string_free0 (sb);
	}
	result = file_path;
	_g_free0 (parent_path);
	_g_free0 (_tmp13_);
	_g_free0 (path);
	_g_free0 (_tmp1_);
	return result;
}

gchar*
g4_parse_relative_uri (const gchar* uri,
                       GFile* parent)
{
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	gint _tmp2_;
	GFile* _tmp9_ = NULL;
	GFile* _tmp10_ = NULL;
	GFile* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp15_;
	gchar* result;
	g_return_val_if_fail (uri != NULL, NULL);
	_tmp1_ = strlen (uri);
	_tmp2_ = _tmp1_;
	if (_tmp2_ > 0) {
		_tmp0_ = string_get (uri, (glong) 0) == '/';
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GFile* _tmp3_;
		GFile* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp3_ = g_file_new_for_path (uri);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_file_get_uri (_tmp4_);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp4_);
		result = _tmp6_;
		return result;
	} else {
		if (g4_is_valid_uri (uri, G_URI_FLAGS_NONE)) {
			const gchar* _tmp7_ = NULL;
			gchar* _tmp8_;
			if (g_str_has_prefix (uri, "file://")) {
				_tmp7_ = (const gchar*) uri;
			} else {
				_tmp7_ = NULL;
			}
			_tmp8_ = g_strdup (_tmp7_);
			result = _tmp8_;
			return result;
		}
	}
	_tmp9_ = parent;
	_tmp10_ = NULL;
	if (_tmp9_ != NULL) {
		GFile* _tmp11_;
		_tmp11_ = g_file_resolve_relative_path (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, g_file_get_type (), GFile), uri);
		_g_object_unref0 (_tmp10_);
		_tmp10_ = _tmp11_;
	}
	_tmp12_ = _tmp10_;
	_tmp13_ = NULL;
	if (_tmp12_ != NULL) {
		gchar* _tmp14_;
		_tmp14_ = g_file_get_uri (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, g_file_get_type (), GFile));
		_g_free0 (_tmp13_);
		_tmp13_ = _tmp14_;
	}
	_tmp15_ = _tmp13_;
	_tmp13_ = NULL;
	result = _tmp15_;
	_g_free0 (_tmp13_);
	_g_object_unref0 (_tmp10_);
	return result;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

gboolean
g4_save_m3u8_file (GDataOutputStream* dos,
                   GFile* parent,
                   GPtrArray* uris,
                   const gchar* title,
                   gboolean with_titles,
                   GError** error)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (dos != NULL, FALSE);
	g_return_val_if_fail (uris != NULL, FALSE);
	_tmp0_ = g_data_output_stream_put_string (dos, "#EXTM3U\n", NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp1_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		return _tmp1_;
	}
	if (!_tmp0_) {
		result = FALSE;
		return result;
	}
	if (title != NULL) {
		_tmp3_ = with_titles;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		gboolean _tmp4_ = FALSE;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gboolean _tmp8_;
		_tmp5_ = string_to_string ((const gchar*) title);
		_tmp6_ = g_strconcat ("#PLAYLIST:", _tmp5_, "\n", NULL);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_data_output_stream_put_string (dos, _tmp7_, NULL, &_inner_error0_);
		_g_free0 (_tmp7_);
		_tmp4_ = _tmp8_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp9_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			return _tmp9_;
		}
		_tmp2_ = !_tmp4_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		result = FALSE;
		return result;
	}
	{
		GPtrArray* uri_collection = NULL;
		guint uri_index = 0U;
		uri_collection = uris;
		for (uri_index = 0; uri_index < uri_collection->len; uri_index = uri_index + 1) {
			gchar* _tmp10_;
			gchar* uri = NULL;
			_tmp10_ = g_strdup ((gchar*) g_ptr_array_index (uri_collection, uri_index));
			uri = _tmp10_;
			{
				GFile* f = NULL;
				const gchar* _tmp11_;
				GFile* _tmp12_;
				gchar* path = NULL;
				GFile* _tmp13_;
				gchar* _tmp14_;
				gboolean _tmp24_ = FALSE;
				const gchar* _tmp25_;
				const gchar* _tmp26_;
				gchar* _tmp27_;
				gchar* _tmp28_;
				gboolean _tmp29_;
				_tmp11_ = uri;
				_tmp12_ = g_file_new_for_uri (_tmp11_);
				f = _tmp12_;
				_tmp13_ = f;
				_tmp14_ = g4_get_relative_path (parent, _tmp13_);
				path = _tmp14_;
				if (with_titles) {
					gchar* name = NULL;
					GFile* _tmp15_;
					gchar* _tmp16_;
					gboolean _tmp17_ = FALSE;
					const gchar* _tmp18_;
					const gchar* _tmp19_;
					gchar* _tmp20_;
					gchar* _tmp21_;
					gboolean _tmp22_;
					_tmp15_ = f;
					_tmp16_ = g4_get_file_display_name (_tmp15_);
					name = _tmp16_;
					_tmp18_ = name;
					_tmp19_ = string_to_string (_tmp18_);
					_tmp20_ = g_strconcat ("#EXTINF:,", _tmp19_, "\n", NULL);
					_tmp21_ = _tmp20_;
					_tmp22_ = g_data_output_stream_put_string (dos, _tmp21_, NULL, &_inner_error0_);
					_g_free0 (_tmp21_);
					_tmp17_ = _tmp22_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						gboolean _tmp23_ = FALSE;
						g_propagate_error (error, _inner_error0_);
						_g_free0 (name);
						_g_free0 (path);
						_g_object_unref0 (f);
						_g_free0 (uri);
						return _tmp23_;
					}
					if (!_tmp17_) {
						result = FALSE;
						_g_free0 (name);
						_g_free0 (path);
						_g_object_unref0 (f);
						_g_free0 (uri);
						return result;
					}
					_g_free0 (name);
				}
				_tmp25_ = path;
				_tmp26_ = string_to_string (_tmp25_);
				_tmp27_ = g_strconcat (_tmp26_, "\n", NULL);
				_tmp28_ = _tmp27_;
				_tmp29_ = g_data_output_stream_put_string (dos, _tmp28_, NULL, &_inner_error0_);
				_g_free0 (_tmp28_);
				_tmp24_ = _tmp29_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					gboolean _tmp30_ = FALSE;
					g_propagate_error (error, _inner_error0_);
					_g_free0 (path);
					_g_object_unref0 (f);
					_g_free0 (uri);
					return _tmp30_;
				}
				if (!_tmp24_) {
					result = FALSE;
					_g_free0 (path);
					_g_object_unref0 (f);
					_g_free0 (uri);
					return result;
				}
				_g_free0 (path);
				_g_object_unref0 (f);
				_g_free0 (uri);
			}
		}
	}
	result = TRUE;
	return result;
}

static gint
vala_g_ptr_array_get_length (GPtrArray* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) self->len;
	return result;
}

gboolean
g4_save_pls_file (GDataOutputStream* dos,
                  GFile* parent,
                  GPtrArray* uris,
                  const gchar* title,
                  gboolean with_titles,
                  GError** error)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gint count = 0;
	gint _tmp10_;
	gint _tmp11_;
	gboolean _tmp12_ = FALSE;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gboolean _tmp17_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (dos != NULL, FALSE);
	g_return_val_if_fail (uris != NULL, FALSE);
	_tmp0_ = g_data_output_stream_put_string (dos, "[playlist]\n", NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp1_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		return _tmp1_;
	}
	if (!_tmp0_) {
		result = FALSE;
		return result;
	}
	if (title != NULL) {
		_tmp3_ = with_titles;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		gboolean _tmp4_ = FALSE;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gboolean _tmp8_;
		_tmp5_ = string_to_string ((const gchar*) title);
		_tmp6_ = g_strconcat ("X-GNOME-Title=", _tmp5_, "\n", NULL);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_data_output_stream_put_string (dos, _tmp7_, NULL, &_inner_error0_);
		_g_free0 (_tmp7_);
		_tmp4_ = _tmp8_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp9_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			return _tmp9_;
		}
		_tmp2_ = !_tmp4_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		result = FALSE;
		return result;
	}
	_tmp10_ = vala_g_ptr_array_get_length (uris);
	_tmp11_ = _tmp10_;
	count = _tmp11_;
	_tmp13_ = g_strdup_printf ("%i", count);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_strconcat ("NumberOfEntries=", _tmp14_, "\n", NULL);
	_tmp16_ = _tmp15_;
	_tmp17_ = g_data_output_stream_put_string (dos, _tmp16_, NULL, &_inner_error0_);
	_g_free0 (_tmp16_);
	_g_free0 (_tmp14_);
	_tmp12_ = _tmp17_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp18_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		return _tmp18_;
	}
	if (!_tmp12_) {
		result = FALSE;
		return result;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp19_ = FALSE;
			_tmp19_ = TRUE;
			while (TRUE) {
				GFile* f = NULL;
				gconstpointer _tmp21_;
				GFile* _tmp22_;
				gchar* path = NULL;
				GFile* _tmp23_;
				gchar* _tmp24_;
				gint n = 0;
				gboolean _tmp36_ = FALSE;
				gchar* _tmp37_;
				gchar* _tmp38_;
				const gchar* _tmp39_;
				const gchar* _tmp40_;
				gchar* _tmp41_;
				gchar* _tmp42_;
				gboolean _tmp43_;
				if (!_tmp19_) {
					gint _tmp20_;
					_tmp20_ = i;
					i = _tmp20_ + 1;
				}
				_tmp19_ = FALSE;
				if (!(i < count)) {
					break;
				}
				_tmp21_ = g_ptr_array_index (uris, (guint) i);
				_tmp22_ = g_file_new_for_uri ((const gchar*) _tmp21_);
				f = _tmp22_;
				_tmp23_ = f;
				_tmp24_ = g4_get_relative_path (parent, _tmp23_);
				path = _tmp24_;
				n = i + 1;
				if (with_titles) {
					gchar* name = NULL;
					GFile* _tmp25_;
					gchar* _tmp26_;
					gboolean _tmp27_ = FALSE;
					gchar* _tmp28_;
					gchar* _tmp29_;
					const gchar* _tmp30_;
					const gchar* _tmp31_;
					gchar* _tmp32_;
					gchar* _tmp33_;
					gboolean _tmp34_;
					_tmp25_ = f;
					_tmp26_ = g4_get_file_display_name (_tmp25_);
					name = _tmp26_;
					_tmp28_ = g_strdup_printf ("%i", n);
					_tmp29_ = _tmp28_;
					_tmp30_ = name;
					_tmp31_ = string_to_string (_tmp30_);
					_tmp32_ = g_strconcat ("Title", _tmp29_, "=", _tmp31_, "\n", NULL);
					_tmp33_ = _tmp32_;
					_tmp34_ = g_data_output_stream_put_string (dos, _tmp33_, NULL, &_inner_error0_);
					_g_free0 (_tmp33_);
					_g_free0 (_tmp29_);
					_tmp27_ = _tmp34_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						gboolean _tmp35_ = FALSE;
						g_propagate_error (error, _inner_error0_);
						_g_free0 (name);
						_g_free0 (path);
						_g_object_unref0 (f);
						return _tmp35_;
					}
					if (!_tmp27_) {
						result = FALSE;
						_g_free0 (name);
						_g_free0 (path);
						_g_object_unref0 (f);
						return result;
					}
					_g_free0 (name);
				}
				_tmp37_ = g_strdup_printf ("%i", n);
				_tmp38_ = _tmp37_;
				_tmp39_ = path;
				_tmp40_ = string_to_string (_tmp39_);
				_tmp41_ = g_strconcat ("File", _tmp38_, "=", _tmp40_, "\n", NULL);
				_tmp42_ = _tmp41_;
				_tmp43_ = g_data_output_stream_put_string (dos, _tmp42_, NULL, &_inner_error0_);
				_g_free0 (_tmp42_);
				_g_free0 (_tmp38_);
				_tmp36_ = _tmp43_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					gboolean _tmp44_ = FALSE;
					g_propagate_error (error, _inner_error0_);
					_g_free0 (path);
					_g_object_unref0 (f);
					return _tmp44_;
				}
				if (!_tmp36_) {
					result = FALSE;
					_g_free0 (path);
					_g_object_unref0 (f);
					return result;
				}
				_g_free0 (path);
				_g_object_unref0 (f);
			}
		}
	}
	result = TRUE;
	return result;
}

static gint
string_last_index_of_char (const gchar* self,
                           gunichar c,
                           gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strrchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

gboolean
g4_save_playlist_file (GFile* file,
                       GPtrArray* uris,
                       const gchar* title,
                       gboolean with_titles)
{
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* bname = NULL;
	gchar* _tmp3_;
	gint pos = 0;
	const gchar* _tmp4_;
	gchar* name = NULL;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* ext = NULL;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (file != NULL, FALSE);
	g_return_val_if_fail (uris != NULL, FALSE);
	_tmp1_ = g_file_get_basename (file);
	_tmp0_ = _tmp1_;
	if (_tmp0_ == NULL) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("");
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp2_;
	}
	_tmp3_ = _tmp0_;
	_tmp0_ = NULL;
	bname = (gchar*) _tmp3_;
	_tmp4_ = bname;
	pos = string_last_index_of_char (_tmp4_, (gunichar) '.', 0);
	_tmp5_ = bname;
	_tmp6_ = string_substring (_tmp5_, (glong) 0, (glong) pos);
	name = _tmp6_;
	_tmp7_ = bname;
	_tmp8_ = string_substring (_tmp7_, (glong) (pos + 1), (glong) -1);
	ext = _tmp8_;
	{
		GFileOutputStream* fos = NULL;
		GFileOutputStream* _tmp9_;
		GBufferedOutputStream* bos = NULL;
		GFileOutputStream* _tmp10_;
		GBufferedOutputStream* _tmp11_;
		GDataOutputStream* dos = NULL;
		GBufferedOutputStream* _tmp12_;
		GDataOutputStream* _tmp13_;
		GFile* parent = NULL;
		GFile* _tmp14_;
		const gchar* _tmp15_;
		_tmp9_ = g_file_replace (file, NULL, FALSE, G_FILE_CREATE_NONE, NULL, &_inner_error0_);
		fos = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp10_ = fos;
		_tmp11_ = (GBufferedOutputStream*) g_buffered_output_stream_new ((GOutputStream*) _tmp10_);
		bos = _tmp11_;
		_tmp12_ = bos;
		_tmp13_ = g_data_output_stream_new ((GOutputStream*) _tmp12_);
		dos = _tmp13_;
		_tmp14_ = g_file_get_parent (file);
		parent = _tmp14_;
		_tmp15_ = ext;
		if (g_ascii_strncasecmp (_tmp15_, "pls", (gsize) 3) == 0) {
			const gchar* _tmp16_ = NULL;
			gboolean _tmp18_ = FALSE;
			GDataOutputStream* _tmp19_;
			GFile* _tmp20_;
			_tmp16_ = title;
			if (_tmp16_ == NULL) {
				const gchar* _tmp17_;
				_tmp17_ = name;
				_tmp16_ = _tmp17_;
			}
			_tmp19_ = dos;
			_tmp20_ = parent;
			_tmp18_ = g4_save_pls_file (_tmp19_, _tmp20_, uris, (const gchar*) _tmp16_, with_titles, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (parent);
				_g_object_unref0 (dos);
				_g_object_unref0 (bos);
				_g_object_unref0 (fos);
				goto __catch0_g_error;
			}
			result = _tmp18_;
			_g_object_unref0 (parent);
			_g_object_unref0 (dos);
			_g_object_unref0 (bos);
			_g_object_unref0 (fos);
			_g_free0 (ext);
			_g_free0 (name);
			_g_free0 (bname);
			_g_free0 (_tmp0_);
			return result;
		} else {
			const gchar* _tmp21_ = NULL;
			gboolean _tmp23_ = FALSE;
			GDataOutputStream* _tmp24_;
			GFile* _tmp25_;
			_tmp21_ = title;
			if (_tmp21_ == NULL) {
				const gchar* _tmp22_;
				_tmp22_ = name;
				_tmp21_ = _tmp22_;
			}
			_tmp24_ = dos;
			_tmp25_ = parent;
			_tmp23_ = g4_save_m3u8_file (_tmp24_, _tmp25_, uris, (const gchar*) _tmp21_, with_titles, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (parent);
				_g_object_unref0 (dos);
				_g_object_unref0 (bos);
				_g_object_unref0 (fos);
				goto __catch0_g_error;
			}
			result = _tmp23_;
			_g_object_unref0 (parent);
			_g_object_unref0 (dos);
			_g_object_unref0 (bos);
			_g_object_unref0 (fos);
			_g_free0 (ext);
			_g_free0 (name);
			_g_free0 (bname);
			_g_free0 (_tmp0_);
			return result;
		}
		_g_object_unref0 (parent);
		_g_object_unref0 (dos);
		_g_object_unref0 (bos);
		_g_object_unref0 (fos);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		gchar* _tmp26_;
		gchar* _tmp27_;
		GError* _tmp28_;
		const gchar* _tmp29_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp26_ = g_file_get_parse_name (file);
		_tmp27_ = _tmp26_;
		_tmp28_ = e;
		_tmp29_ = _tmp28_->message;
		g_print ("Save playlist %s: %s\n", _tmp27_, _tmp29_);
		_g_free0 (_tmp27_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp30_ = FALSE;
		_g_free0 (ext);
		_g_free0 (name);
		_g_free0 (bname);
		_g_free0 (_tmp0_);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp30_;
	}
	result = FALSE;
	_g_free0 (ext);
	_g_free0 (name);
	_g_free0 (bname);
	_g_free0 (_tmp0_);
	return result;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

