/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.gp;

import apdu4j.core.HexUtils;
import com.payneteasy.tlv.BerTlv;
import com.payneteasy.tlv.BerTlvParser;
import com.payneteasy.tlv.BerTlvs;
import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import pro.javacard.gp.GPDataException;

public final class GPUtils {
    private GPUtils() {
    }

    public static int intValue(String s) {
        if (s.trim().toLowerCase().startsWith("0x")) {
            return Integer.parseInt(s.substring(2), 16);
        }
        return Integer.parseInt(s, 10);
    }

    public static String intString(int i) {
        return String.format("%d (0x%02X)", i, i);
    }

    public static String bin2readable(byte[] bytes) {
        if (bytes == null) {
            return "(null)";
        }
        StringBuilder s = new StringBuilder();
        for (byte b : bytes) {
            char c = (char)b;
            s.append(c >= ' ' && c < '\u007f' ? Character.valueOf(c) : ".");
        }
        return "|" + String.valueOf(s) + "|";
    }

    public static byte[] concatenate(byte[] ... args) {
        int length = 0;
        int pos = 0;
        for (byte[] arg : args) {
            length += arg.length;
        }
        byte[] result = new byte[length];
        for (byte[] arg : args) {
            System.arraycopy(arg, 0, result, pos, arg.length);
            pos += arg.length;
        }
        return result;
    }

    public static List<byte[]> splitArray(byte[] array, int blockSize) {
        ArrayList<byte[]> result = new ArrayList<byte[]>();
        int len = array.length;
        int offset = 0;
        int left = len - offset;
        while (left > 0) {
            int currentLen = Math.min(left, blockSize);
            byte[] block = new byte[currentLen];
            System.arraycopy(array, offset, block, 0, currentLen);
            result.add(block);
            left -= currentLen;
            offset += currentLen;
        }
        return result;
    }

    public static byte[] encodeLength(int len) {
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        if (len < 128) {
            bo.write((byte)len);
        } else if (len <= 255) {
            bo.write(-127);
            bo.write((byte)len);
        } else if (len <= 65535) {
            bo.write(-126);
            bo.write((byte)((len & 0xFF00) >> 8));
            bo.write((byte)(len & 0xFF));
        } else {
            bo.write(-125);
            bo.write((byte)((len & 0xFF0000) >> 16));
            bo.write((byte)((len & 0xFF00) >> 8));
            bo.write((byte)(len & 0xFF));
        }
        return bo.toByteArray();
    }

    public static int getLength(byte[] buffer, int offset) {
        int first = buffer[offset] & 0xFF;
        if (first <= 128) {
            return buffer[offset] & 0xFF;
        }
        if (first == 129) {
            return buffer[offset + 1] & 0xFF;
        }
        if (first == 130) {
            return (buffer[offset + 1] & 0xFF) << 8 | buffer[offset + 2] & 0xFF;
        }
        throw new GPDataException("Invalid length encoding", Arrays.copyOfRange(buffer, offset, offset + 3));
    }

    public static int getLenLen(byte[] buffer, int offset) {
        if ((buffer[offset] & 0xFF) <= 128) {
            return 1;
        }
        return (buffer[offset] & 0xFF) - 127;
    }

    public static byte[] encodeLcLength(int lc, int le) {
        if (lc > 255 || le > 256) {
            byte[] lc_ba = ByteBuffer.allocate(4).putInt(lc).array();
            return Arrays.copyOfRange(lc_ba, 1, 4);
        }
        return new byte[]{(byte)lc};
    }

    static byte[] positive(byte[] bytes) {
        if (bytes[0] == 0 && bytes.length % 2 == 1) {
            return Arrays.copyOfRange(bytes, 1, bytes.length);
        }
        return bytes;
    }

    static byte[] positive(BigInteger i) {
        byte[] bytes = i.toByteArray();
        return GPUtils.positive(bytes);
    }

    static void trace_lv(byte[] data, Logger logger) {
        try {
            for (String s : GPUtils.visualize_lv(data)) {
                logger.trace(s);
            }
        }
        catch (IllegalArgumentException e) {
            logger.error("Invalid LV data: {}", (Object)Hex.toHexString(data), (Object)e);
        }
    }

    static List<String> visualize_lv(byte[] data) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            int l;
            int lenLen;
            for (int i = 0; i < data.length; i += lenLen + l) {
                l = GPUtils.getLength(data, i);
                lenLen = GPUtils.getLenLen(data, i);
                result.add(String.format("[%s] %s", HexUtils.bin2hex(Arrays.copyOfRange(data, i, i + lenLen)), HexUtils.bin2hex(Arrays.copyOfRange(data, i + lenLen, i + lenLen + l))));
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Not valid LV structure: " + e.getMessage(), e);
        }
        return result;
    }

    static String spacer(int n) {
        return new String(new char[n]).replace('\u0000', ' ');
    }

    static void dump(BerTlv tlv, int depth, List<String> result) {
        if (tlv.isConstructed()) {
            result.add(String.format("%s[%s]", GPUtils.spacer(depth * 5), Hex.toHexString(tlv.getTag().bytes)));
            for (BerTlv child : tlv.getValues()) {
                GPUtils.dump(child, depth + 1, result);
            }
        } else {
            result.add(String.format("%s[%s] %s", GPUtils.spacer(depth * 5), Hex.toHexString(tlv.getTag().bytes), Hex.toHexString(tlv.getBytesValue())));
        }
    }

    static void dump(BerTlvs tlv, int depth, List<String> result) {
        for (BerTlv t : tlv.getList()) {
            GPUtils.dump(t, depth, result);
        }
    }

    public static List<String> visualize_tlv(byte[] payload) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            BerTlvs tlvs = new BerTlvParser().parse(payload);
            GPUtils.dump(tlvs, 0, result);
        }
        catch (ArrayIndexOutOfBoundsException | IllegalStateException e) {
            throw new IllegalArgumentException("Not valid TLVs: " + e.getMessage(), e);
        }
        return result;
    }

    static void trace_tlv(byte[] data, Logger l) {
        try {
            for (String s : GPUtils.visualize_tlv(data)) {
                l.trace(s);
            }
        }
        catch (IllegalArgumentException e) {
            l.error("Invalid TLV data: {}", (Object)Hex.toHexString(data), (Object)e);
        }
    }
}

