/* gnome-idle-monitor.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from gnome-idle-monitor.vala, do not modify */

/*
 * Adapted from gnome-session/gnome-session/gs-idle-monitor.h
 * and from gnome-desktop/libgnome-session/gnome-idle-monitor.h
 *
 * Copyright (C) 2012 Red Hat, Inc.
 * Copyright (C) 2016 gnome-pomodoro contributors.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 * Original author: William Jon McCann <mccann@jhu.edu>
 */

#include "gnome.h"
#include <glib-object.h>
#include <glib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define GNOME_PLUGIN_TYPE_IDLE_MONITOR_WATCH (gnome_plugin_idle_monitor_watch_get_type ())
#define GNOME_PLUGIN_IDLE_MONITOR_WATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_PLUGIN_TYPE_IDLE_MONITOR_WATCH, GnomePluginIdleMonitorWatch))
#define GNOME_PLUGIN_IDLE_MONITOR_WATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_PLUGIN_TYPE_IDLE_MONITOR_WATCH, GnomePluginIdleMonitorWatchClass))
#define GNOME_PLUGIN_IS_IDLE_MONITOR_WATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_PLUGIN_TYPE_IDLE_MONITOR_WATCH))
#define GNOME_PLUGIN_IS_IDLE_MONITOR_WATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_PLUGIN_TYPE_IDLE_MONITOR_WATCH))
#define GNOME_PLUGIN_IDLE_MONITOR_WATCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_PLUGIN_TYPE_IDLE_MONITOR_WATCH, GnomePluginIdleMonitorWatchClass))

typedef struct _GnomePluginIdleMonitorWatch GnomePluginIdleMonitorWatch;
typedef struct _GnomePluginIdleMonitorWatchClass GnomePluginIdleMonitorWatchClass;
typedef struct _GnomePluginIdleMonitorWatchPrivate GnomePluginIdleMonitorWatchPrivate;
enum  {
	GNOME_PLUGIN_IDLE_MONITOR_WATCH_0_PROPERTY,
	GNOME_PLUGIN_IDLE_MONITOR_WATCH_NUM_PROPERTIES
};
static GParamSpec* gnome_plugin_idle_monitor_watch_properties[GNOME_PLUGIN_IDLE_MONITOR_WATCH_NUM_PROPERTIES];
enum  {
	GNOME_PLUGIN_IDLE_MONITOR_0_PROPERTY,
	GNOME_PLUGIN_IDLE_MONITOR_NUM_PROPERTIES
};
static GParamSpec* gnome_plugin_idle_monitor_properties[GNOME_PLUGIN_IDLE_MONITOR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GnomePluginIdleMonitorWatch {
	GInitiallyUnowned parent_instance;
	GnomePluginIdleMonitorWatchPrivate * priv;
	GnomePluginIdleMonitor* monitor;
	guint id;
	guint upstream_id;
	GnomePluginIdleMonitorWatchFunc callback;
	gpointer callback_target;
	GDestroyNotify callback_target_destroy_notify;
	guint64 timeout_msec;
};

struct _GnomePluginIdleMonitorWatchClass {
	GInitiallyUnownedClass parent_class;
};

struct _GnomePluginIdleMonitorPrivate {
	GCancellable* cancellable;
	MetaIdleMonitor* proxy;
	GHashTable* watches;
	GHashTable* watches_by_upstream_id;
};

static gpointer gnome_plugin_idle_monitor_watch_parent_class = NULL;
static guint gnome_plugin_idle_monitor_watch_next_id;
static guint gnome_plugin_idle_monitor_watch_next_id = (guint) 1;
static GType gnome_plugin_idle_monitor_watch_type_id = 0;
static gint GnomePluginIdleMonitor_private_offset;
static gpointer gnome_plugin_idle_monitor_parent_class = NULL;
static GInitableIface * gnome_plugin_idle_monitor_g_initable_parent_iface = NULL;
static GType gnome_plugin_idle_monitor_type_id = 0;

GType gnome_plugin_idle_monitor_watch_register_type (GTypeModule * module);
VALA_EXTERN GType gnome_plugin_idle_monitor_watch_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GnomePluginIdleMonitorWatch* gnome_plugin_idle_monitor_watch_new (GnomePluginIdleMonitor* monitor,
                                                                  guint64 timeout_msec,
                                                                  GnomePluginIdleMonitorWatchFunc callback,
                                                                  gpointer callback_target,
                                                                  GDestroyNotify callback_target_destroy_notify);
VALA_EXTERN GnomePluginIdleMonitorWatch* gnome_plugin_idle_monitor_watch_construct (GType object_type,
                                                                        GnomePluginIdleMonitor* monitor,
                                                                        guint64 timeout_msec,
                                                                        GnomePluginIdleMonitorWatchFunc callback,
                                                                        gpointer callback_target,
                                                                        GDestroyNotify callback_target_destroy_notify);
static guint gnome_plugin_idle_monitor_watch_get_next_id (GnomePluginIdleMonitorWatch* self);
static GObject * gnome_plugin_idle_monitor_watch_constructor (GType type,
                                                       guint n_construct_properties,
                                                       GObjectConstructParam * construct_properties);
static void gnome_plugin_idle_monitor_watch_finalize (GObject * obj);
static void gnome_plugin_idle_monitor_real_dispose (GObject* base);
static gboolean gnome_plugin_idle_monitor_real_init (GInitable* base,
                                              GCancellable* cancellable,
                                              GError** error);
static void gnome_plugin_idle_monitor_on_watch_fired (GnomePluginIdleMonitor* self,
                                               MetaIdleMonitor* proxy,
                                               guint upstream_id);
static void _gnome_plugin_idle_monitor_on_watch_fired_meta_idle_monitor_watch_fired (MetaIdleMonitor* _sender,
                                                                              guint id,
                                                                              gpointer self);
static void __lambda4_ (GnomePluginIdleMonitor* self,
                 guint id,
                 GnomePluginIdleMonitorWatch* watch);
static void gnome_plugin_idle_monitor_add_user_active_watch_internal (GnomePluginIdleMonitor* self,
                                                               GnomePluginIdleMonitorWatch* watch);
static void gnome_plugin_idle_monitor_add_idle_watch_internal (GnomePluginIdleMonitor* self,
                                                        GnomePluginIdleMonitorWatch* watch);
static void ___lambda4__gh_func (gconstpointer key,
                          gconstpointer value,
                          gpointer self);
static void gnome_plugin_idle_monitor_remove_watch_internal (GnomePluginIdleMonitor* self,
                                                      GnomePluginIdleMonitorWatch* watch);
static GObject * gnome_plugin_idle_monitor_constructor (GType type,
                                                 guint n_construct_properties,
                                                 GObjectConstructParam * construct_properties);
static void _g_object_unref0_ (gpointer var);
static void gnome_plugin_idle_monitor_finalize (GObject * obj);

GnomePluginIdleMonitorWatch*
gnome_plugin_idle_monitor_watch_construct (GType object_type,
                                           GnomePluginIdleMonitor* monitor,
                                           guint64 timeout_msec,
                                           GnomePluginIdleMonitorWatchFunc callback,
                                           gpointer callback_target,
                                           GDestroyNotify callback_target_destroy_notify)
{
	GnomePluginIdleMonitorWatch * self = NULL;
	GnomePluginIdleMonitorWatchFunc _tmp0_;
	gpointer _tmp0__target;
	GDestroyNotify _tmp0__target_destroy_notify;
	g_return_val_if_fail (monitor != NULL, NULL);
	self = (GnomePluginIdleMonitorWatch*) g_object_new (object_type, NULL);
	self->monitor = monitor;
	self->timeout_msec = timeout_msec;
	_tmp0_ = callback;
	_tmp0__target = callback_target;
	_tmp0__target_destroy_notify = callback_target_destroy_notify;
	callback = NULL;
	callback_target = NULL;
	callback_target_destroy_notify = NULL;
	(self->callback_target_destroy_notify == NULL) ? NULL : (self->callback_target_destroy_notify (self->callback_target), NULL);
	self->callback = NULL;
	self->callback_target = NULL;
	self->callback_target_destroy_notify = NULL;
	self->callback = _tmp0_;
	self->callback_target = _tmp0__target;
	self->callback_target_destroy_notify = _tmp0__target_destroy_notify;
	(callback_target_destroy_notify == NULL) ? NULL : (callback_target_destroy_notify (callback_target), NULL);
	callback = NULL;
	callback_target = NULL;
	callback_target_destroy_notify = NULL;
	return self;
}

GnomePluginIdleMonitorWatch*
gnome_plugin_idle_monitor_watch_new (GnomePluginIdleMonitor* monitor,
                                     guint64 timeout_msec,
                                     GnomePluginIdleMonitorWatchFunc callback,
                                     gpointer callback_target,
                                     GDestroyNotify callback_target_destroy_notify)
{
	return gnome_plugin_idle_monitor_watch_construct (GNOME_PLUGIN_TYPE_IDLE_MONITOR_WATCH, monitor, timeout_msec, callback, callback_target, callback_target_destroy_notify);
}

static guint
gnome_plugin_idle_monitor_watch_get_next_id (GnomePluginIdleMonitorWatch* self)
{
	guint next_id = 0U;
	guint _tmp0_;
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	next_id = gnome_plugin_idle_monitor_watch_next_id;
	_tmp0_ = gnome_plugin_idle_monitor_watch_next_id;
	gnome_plugin_idle_monitor_watch_next_id = _tmp0_ + 1;
	result = next_id;
	return result;
}

static GObject *
gnome_plugin_idle_monitor_watch_constructor (GType type,
                                             guint n_construct_properties,
                                             GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GnomePluginIdleMonitorWatch * self;
	parent_class = G_OBJECT_CLASS (gnome_plugin_idle_monitor_watch_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GNOME_PLUGIN_TYPE_IDLE_MONITOR_WATCH, GnomePluginIdleMonitorWatch);
	self->id = gnome_plugin_idle_monitor_watch_get_next_id (self);
	return obj;
}

static void
gnome_plugin_idle_monitor_watch_class_init (GnomePluginIdleMonitorWatchClass * klass,
                                            gpointer klass_data)
{
	gnome_plugin_idle_monitor_watch_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->constructor = gnome_plugin_idle_monitor_watch_constructor;
	G_OBJECT_CLASS (klass)->finalize = gnome_plugin_idle_monitor_watch_finalize;
}

static void
gnome_plugin_idle_monitor_watch_instance_init (GnomePluginIdleMonitorWatch * self,
                                               gpointer klass)
{
}

static void
gnome_plugin_idle_monitor_watch_finalize (GObject * obj)
{
	GnomePluginIdleMonitorWatch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GNOME_PLUGIN_TYPE_IDLE_MONITOR_WATCH, GnomePluginIdleMonitorWatch);
	(self->callback_target_destroy_notify == NULL) ? NULL : (self->callback_target_destroy_notify (self->callback_target), NULL);
	self->callback = NULL;
	self->callback_target = NULL;
	self->callback_target_destroy_notify = NULL;
	G_OBJECT_CLASS (gnome_plugin_idle_monitor_watch_parent_class)->finalize (obj);
}

GType
gnome_plugin_idle_monitor_watch_get_type (void)
{
	return gnome_plugin_idle_monitor_watch_type_id;
}

GType
gnome_plugin_idle_monitor_watch_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (GnomePluginIdleMonitorWatchClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gnome_plugin_idle_monitor_watch_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GnomePluginIdleMonitorWatch), 0, (GInstanceInitFunc) gnome_plugin_idle_monitor_watch_instance_init, NULL };
	gnome_plugin_idle_monitor_watch_type_id = g_type_module_register_type (module, G_TYPE_INITIALLY_UNOWNED, "GnomePluginIdleMonitorWatch", &g_define_type_info, 0);
	return gnome_plugin_idle_monitor_watch_type_id;
}

static inline gpointer
gnome_plugin_idle_monitor_get_instance_private (GnomePluginIdleMonitor* self)
{
	return G_STRUCT_MEMBER_P (self, GnomePluginIdleMonitor_private_offset);
}

/**
         * gnome_idle_monitor_new:
         *
         * Returns: a new #GnomeIdleMonitor that tracks the server-global
         * idletime for all devices.
         */
GnomePluginIdleMonitor*
gnome_plugin_idle_monitor_construct (GType object_type,
                                     GError** error)
{
	GnomePluginIdleMonitor * self = NULL;
	GCancellable* _tmp0_;
	GError* _inner_error0_ = NULL;
	self = (GnomePluginIdleMonitor*) g_object_new (object_type, NULL);
	_tmp0_ = self->priv->cancellable;
	g_initable_init (G_TYPE_CHECK_INSTANCE_CAST (self, g_initable_get_type (), GInitable), _tmp0_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (self);
		return NULL;
	}
	return self;
}

GnomePluginIdleMonitor*
gnome_plugin_idle_monitor_new (GError** error)
{
	return gnome_plugin_idle_monitor_construct (GNOME_PLUGIN_TYPE_IDLE_MONITOR, error);
}

static void
gnome_plugin_idle_monitor_real_dispose (GObject* base)
{
	GnomePluginIdleMonitor * self;
	GCancellable* _tmp0_;
	self = (GnomePluginIdleMonitor*) base;
	_tmp0_ = self->priv->cancellable;
	if (_tmp0_ != NULL) {
		GCancellable* _tmp1_;
		_tmp1_ = self->priv->cancellable;
		g_cancellable_cancel (_tmp1_);
	}
	G_OBJECT_CLASS (gnome_plugin_idle_monitor_parent_class)->dispose (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject));
}

static void
_gnome_plugin_idle_monitor_on_watch_fired_meta_idle_monitor_watch_fired (MetaIdleMonitor* _sender,
                                                                         guint id,
                                                                         gpointer self)
{
	gnome_plugin_idle_monitor_on_watch_fired ((GnomePluginIdleMonitor*) self, _sender, id);
}

static void
__lambda4_ (GnomePluginIdleMonitor* self,
            guint id,
            GnomePluginIdleMonitorWatch* watch)
{
	g_return_if_fail (watch != NULL);
	_vala_assert (watch != NULL, "watch != null");
	if (watch->timeout_msec == ((guint64) 0)) {
		gnome_plugin_idle_monitor_add_user_active_watch_internal (self, watch);
	} else {
		gnome_plugin_idle_monitor_add_idle_watch_internal (self, watch);
	}
}

static void
___lambda4__gh_func (gconstpointer key,
                     gconstpointer value,
                     gpointer self)
{
	__lambda4_ ((GnomePluginIdleMonitor*) self, (guint) ((guintptr) key), (GnomePluginIdleMonitorWatch*) value);
}

static gboolean
gnome_plugin_idle_monitor_real_init (GInitable* base,
                                     GCancellable* cancellable,
                                     GError** error)
{
	GnomePluginIdleMonitor * self;
	MetaIdleMonitor* _tmp0_ = NULL;
	MetaIdleMonitor* _tmp1_;
	MetaIdleMonitor* _tmp3_;
	MetaIdleMonitor* _tmp4_;
	GHashTable* _tmp5_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (GnomePluginIdleMonitor*) base;
	_tmp1_ = (MetaIdleMonitor*) g_initable_new (META_TYPE_IDLE_MONITOR_PROXY, NULL, &_inner_error0_, "g-flags", G_DBUS_PROXY_FLAGS_DO_NOT_AUTO_START, "g-name", "org.gnome.Mutter.IdleMonitor", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/org/gnome/Mutter/IdleMonitor/Core", "g-interface-name", "org.gnome.Mutter.IdleMonitor", NULL);
	_tmp0_ = (MetaIdleMonitor*) _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp2_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		return _tmp2_;
	}
	_tmp3_ = _tmp0_;
	_tmp0_ = NULL;
	_g_object_unref0 (self->priv->proxy);
	self->priv->proxy = _tmp3_;
	_tmp4_ = self->priv->proxy;
	g_signal_connect_object (_tmp4_, "watch-fired", (GCallback) _gnome_plugin_idle_monitor_on_watch_fired_meta_idle_monitor_watch_fired, self, 0);
	_tmp5_ = self->priv->watches;
	g_hash_table_foreach (_tmp5_, ___lambda4__gh_func, self);
	result = TRUE;
	_g_object_unref0 (_tmp0_);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
gnome_plugin_idle_monitor_on_watch_fired (GnomePluginIdleMonitor* self,
                                          MetaIdleMonitor* proxy,
                                          guint upstream_id)
{
	GnomePluginIdleMonitorWatch* watch = NULL;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	GnomePluginIdleMonitorWatch* _tmp2_;
	GnomePluginIdleMonitorWatch* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (proxy != NULL);
	_tmp0_ = self->priv->watches_by_upstream_id;
	_tmp1_ = g_hash_table_lookup (_tmp0_, (gpointer) ((guintptr) upstream_id));
	_tmp2_ = _g_object_ref0 ((GnomePluginIdleMonitorWatch*) _tmp1_);
	watch = _tmp2_;
	_tmp3_ = watch;
	if (_tmp3_ != NULL) {
		GnomePluginIdleMonitorWatch* _tmp4_;
		GnomePluginIdleMonitorWatchFunc _tmp5_;
		gpointer _tmp5__target;
		GnomePluginIdleMonitorWatch* _tmp11_;
		_tmp4_ = watch;
		_tmp5_ = _tmp4_->callback;
		_tmp5__target = _tmp4_->callback_target;
		if (_tmp5_ != NULL) {
			GnomePluginIdleMonitorWatch* _tmp6_;
			GnomePluginIdleMonitorWatchFunc _tmp7_;
			gpointer _tmp7__target;
			GnomePluginIdleMonitorWatch* _tmp8_;
			GnomePluginIdleMonitor* _tmp9_;
			GnomePluginIdleMonitorWatch* _tmp10_;
			_tmp6_ = watch;
			_tmp7_ = _tmp6_->callback;
			_tmp7__target = _tmp6_->callback_target;
			_tmp8_ = watch;
			_tmp9_ = _tmp8_->monitor;
			_tmp10_ = watch;
			_tmp7_ (_tmp9_, _tmp10_->id, _tmp7__target);
		}
		_tmp11_ = watch;
		if (_tmp11_->timeout_msec == ((guint64) 0)) {
			GnomePluginIdleMonitorWatch* _tmp12_;
			_tmp12_ = watch;
			gnome_plugin_idle_monitor_remove_watch_internal (self, _tmp12_);
		}
	}
	_g_object_unref0 (watch);
}

static void
gnome_plugin_idle_monitor_add_idle_watch_internal (GnomePluginIdleMonitor* self,
                                                   GnomePluginIdleMonitorWatch* watch)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (watch != NULL);
	{
		MetaIdleMonitor* _tmp0_;
		guint _tmp1_ = 0U;
		GHashTable* _tmp2_;
		_tmp0_ = self->priv->proxy;
		meta_idle_monitor_add_idle_watch (_tmp0_, watch->timeout_msec, &_tmp1_, &_inner_error0_);
		watch->upstream_id = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = self->priv->watches_by_upstream_id;
		g_hash_table_insert (_tmp2_, (gpointer) ((guintptr) watch->upstream_id), watch);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = _error_;
		_tmp4_ = _tmp3_->message;
		g_warning ("gnome-idle-monitor.vala:155: Failed to add idle watch: %s", _tmp4_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
gnome_plugin_idle_monitor_add_user_active_watch_internal (GnomePluginIdleMonitor* self,
                                                          GnomePluginIdleMonitorWatch* watch)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (watch != NULL);
	{
		MetaIdleMonitor* _tmp0_;
		guint _tmp1_ = 0U;
		GHashTable* _tmp2_;
		_tmp0_ = self->priv->proxy;
		meta_idle_monitor_add_user_active_watch (_tmp0_, &_tmp1_, &_inner_error0_);
		watch->upstream_id = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = self->priv->watches_by_upstream_id;
		g_hash_table_insert (_tmp2_, (gpointer) ((guintptr) watch->upstream_id), watch);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = _error_;
		_tmp4_ = _tmp3_->message;
		g_warning ("gnome-idle-monitor.vala:168: Failed to add user-active watch: %s", _tmp4_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
gnome_plugin_idle_monitor_remove_watch_internal (GnomePluginIdleMonitor* self,
                                                 GnomePluginIdleMonitorWatch* watch)
{
	GHashTable* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (watch != NULL);
	_tmp0_ = self->priv->watches;
	g_hash_table_remove (_tmp0_, (gpointer) ((guintptr) watch->id));
	if (watch->upstream_id != ((guint) 0)) {
		GHashTable* _tmp1_;
		_tmp1_ = self->priv->watches_by_upstream_id;
		g_hash_table_remove (_tmp1_, (gpointer) ((guintptr) watch->upstream_id));
		watch->upstream_id = (guint) 0;
	}
}

/**
         * gnome_idle_monitor_add_idle_watch:
         * @monitor: A #GnomeIdleMonitor
         * @interval_msec: The idletime interval, in milliseconds
         * @callback: (allow-none): The callback to call when the user has
         *     accumulated @interval_msec milliseconds of idle time.
         * @user_data: (allow-none): The user data to pass to the callback
         * @notify: A #GDestroyNotify
         *
         * Returns: a watch id
         *
         * Adds a watch for a specific idle time. The callback will be called
         * when the user has accumulated @interval_msec milliseconds of idle time.
         * This function will return an ID that can either be passed to
         * gnome_idle_monitor_remove_watch(), or can be used to tell idle time
         * watches apart if you have more than one.
         *
         * Also note that this function will only care about positive transitions
         * (user's idle time exceeding a certain time). If you want to know about
         * when the user has become active, use
         * gnome_idle_monitor_add_user_active_watch().
         */
guint
gnome_plugin_idle_monitor_add_idle_watch (GnomePluginIdleMonitor* self,
                                          guint64 interval_msec,
                                          GnomePluginIdleMonitorWatchFunc callback,
                                          gpointer callback_target,
                                          GDestroyNotify callback_target_destroy_notify)
{
	GnomePluginIdleMonitorWatch* watch = NULL;
	GnomePluginIdleMonitorWatchFunc _tmp0_;
	gpointer _tmp0__target;
	GDestroyNotify _tmp0__target_destroy_notify;
	GnomePluginIdleMonitorWatch* _tmp1_;
	GHashTable* _tmp2_;
	GnomePluginIdleMonitorWatch* _tmp3_;
	GnomePluginIdleMonitorWatch* _tmp4_;
	GnomePluginIdleMonitorWatch* _tmp5_;
	MetaIdleMonitor* _tmp6_;
	GnomePluginIdleMonitorWatch* _tmp8_;
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	_vala_return_val_if_fail (interval_msec > ((guint64) 0), "interval_msec > 0", 0U);
	_tmp0_ = callback;
	_tmp0__target = callback_target;
	_tmp0__target_destroy_notify = callback_target_destroy_notify;
	callback = NULL;
	callback_target = NULL;
	callback_target_destroy_notify = NULL;
	_tmp1_ = gnome_plugin_idle_monitor_watch_new (self, interval_msec, _tmp0_, _tmp0__target, _tmp0__target_destroy_notify);
	g_object_ref_sink (_tmp1_);
	watch = _tmp1_;
	_tmp2_ = self->priv->watches;
	_tmp3_ = watch;
	_tmp4_ = watch;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	g_hash_table_insert (_tmp2_, (gpointer) ((guintptr) _tmp3_->id), _tmp5_);
	_tmp6_ = self->priv->proxy;
	if (_tmp6_ != NULL) {
		GnomePluginIdleMonitorWatch* _tmp7_;
		_tmp7_ = watch;
		gnome_plugin_idle_monitor_add_idle_watch_internal (self, _tmp7_);
	}
	_tmp8_ = watch;
	result = _tmp8_->id;
	_g_object_unref0 (watch);
	(callback_target_destroy_notify == NULL) ? NULL : (callback_target_destroy_notify (callback_target), NULL);
	callback = NULL;
	callback_target = NULL;
	callback_target_destroy_notify = NULL;
	return result;
}

/**
         * gnome_idle_monitor_add_user_active_watch:
         * @monitor: A #GnomeIdleMonitor
         * @callback: (allow-none): The callback to call when the user is
         *     active again.
         * @user_data: (allow-none): The user data to pass to the callback
         * @notify: A #GDestroyNotify
         *
         * Returns: a watch id
         *
         * Add a one-time watch to know when the user is active again.
         * Note that this watch is one-time and will de-activate after the
         * function is called, for efficiency purposes. It's most convenient
         * to call this when an idle watch, as added by
         * gnome_idle_monitor_add_idle_watch(), has triggered.
         */
guint
gnome_plugin_idle_monitor_add_user_active_watch (GnomePluginIdleMonitor* self,
                                                 GnomePluginIdleMonitorWatchFunc callback,
                                                 gpointer callback_target,
                                                 GDestroyNotify callback_target_destroy_notify)
{
	GnomePluginIdleMonitorWatch* watch = NULL;
	GnomePluginIdleMonitorWatchFunc _tmp0_;
	gpointer _tmp0__target;
	GDestroyNotify _tmp0__target_destroy_notify;
	GnomePluginIdleMonitorWatch* _tmp1_;
	GHashTable* _tmp2_;
	GnomePluginIdleMonitorWatch* _tmp3_;
	GnomePluginIdleMonitorWatch* _tmp4_;
	GnomePluginIdleMonitorWatch* _tmp5_;
	MetaIdleMonitor* _tmp6_;
	GnomePluginIdleMonitorWatch* _tmp8_;
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = callback;
	_tmp0__target = callback_target;
	_tmp0__target_destroy_notify = callback_target_destroy_notify;
	callback = NULL;
	callback_target = NULL;
	callback_target_destroy_notify = NULL;
	_tmp1_ = gnome_plugin_idle_monitor_watch_new (self, (guint64) 0, _tmp0_, _tmp0__target, _tmp0__target_destroy_notify);
	g_object_ref_sink (_tmp1_);
	watch = _tmp1_;
	_tmp2_ = self->priv->watches;
	_tmp3_ = watch;
	_tmp4_ = watch;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	g_hash_table_insert (_tmp2_, (gpointer) ((guintptr) _tmp3_->id), _tmp5_);
	_tmp6_ = self->priv->proxy;
	if (_tmp6_ != NULL) {
		GnomePluginIdleMonitorWatch* _tmp7_;
		_tmp7_ = watch;
		gnome_plugin_idle_monitor_add_user_active_watch_internal (self, _tmp7_);
	}
	_tmp8_ = watch;
	result = _tmp8_->id;
	_g_object_unref0 (watch);
	(callback_target_destroy_notify == NULL) ? NULL : (callback_target_destroy_notify (callback_target), NULL);
	callback = NULL;
	callback_target = NULL;
	callback_target_destroy_notify = NULL;
	return result;
}

/**
         * gnome_idle_monitor_remove_watch:
         * @monitor: A #GnomeIdleMonitor
         * @id: A watch ID
         *
         * Removes an idle time watcher, previously added by
         * gnome_idle_monitor_add_idle_watch() or
         * gnome_idle_monitor_add_user_active_watch().
         */
void
gnome_plugin_idle_monitor_remove_watch (GnomePluginIdleMonitor* self,
                                        guint id)
{
	GnomePluginIdleMonitorWatch* watch = NULL;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	GnomePluginIdleMonitorWatch* _tmp2_;
	GnomePluginIdleMonitorWatch* _tmp3_;
	GnomePluginIdleMonitorWatch* _tmp4_;
	GnomePluginIdleMonitorWatch* _tmp9_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->watches;
	_tmp1_ = g_hash_table_lookup (_tmp0_, (gpointer) ((guintptr) id));
	_tmp2_ = _g_object_ref0 ((GnomePluginIdleMonitorWatch*) _tmp1_);
	watch = _tmp2_;
	_tmp3_ = watch;
	if (_tmp3_ == NULL) {
		_g_object_unref0 (watch);
		return;
	}
	_tmp4_ = watch;
	if (_tmp4_->upstream_id != ((guint) 0)) {
		{
			MetaIdleMonitor* _tmp5_;
			GnomePluginIdleMonitorWatch* _tmp6_;
			_tmp5_ = self->priv->proxy;
			_tmp6_ = watch;
			meta_idle_monitor_remove_watch (_tmp5_, _tmp6_->upstream_id, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* _error_ = NULL;
			GError* _tmp7_;
			const gchar* _tmp8_;
			_error_ = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp7_ = _error_;
			_tmp8_ = _tmp7_->message;
			g_warning ("gnome-idle-monitor.vala:274: Failed to remove watch: %s", _tmp8_);
			_g_error_free0 (_error_);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (watch);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp9_ = watch;
	gnome_plugin_idle_monitor_remove_watch_internal (self, _tmp9_);
	_g_object_unref0 (watch);
}

/**
         * gnome_idle_monitor_get_idletime:
         * @monitor: A #GnomeIdleMonitor
         *
         * Returns: The current idle time, in milliseconds
         */
guint64
gnome_plugin_idle_monitor_get_idletime (GnomePluginIdleMonitor* self)
{
	guint64 value = 0ULL;
	MetaIdleMonitor* _tmp0_;
	GError* _inner_error0_ = NULL;
	guint64 result;
	g_return_val_if_fail (self != NULL, 0ULL);
	value = (guint64) 0;
	_tmp0_ = self->priv->proxy;
	if (_tmp0_ != NULL) {
		{
			MetaIdleMonitor* _tmp1_;
			guint64 _tmp2_ = 0ULL;
			_tmp1_ = self->priv->proxy;
			meta_idle_monitor_get_idletime (_tmp1_, &_tmp2_, &_inner_error0_);
			value = _tmp2_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* _error_ = NULL;
			GError* _tmp3_;
			const gchar* _tmp4_;
			_error_ = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp3_ = _error_;
			_tmp4_ = _tmp3_->message;
			g_warning ("gnome-idle-monitor.vala:296: Failed to get idletime: %s", _tmp4_);
			_g_error_free0 (_error_);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			guint64 _tmp5_ = 0ULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp5_;
		}
	}
	result = value;
	return result;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static GObject *
gnome_plugin_idle_monitor_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GnomePluginIdleMonitor * self;
	GHashTable* _tmp0_;
	GHashTable* _tmp1_;
	GCancellable* _tmp2_;
	parent_class = G_OBJECT_CLASS (gnome_plugin_idle_monitor_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GNOME_PLUGIN_TYPE_IDLE_MONITOR, GnomePluginIdleMonitor);
	_tmp0_ = g_hash_table_new_full (NULL, NULL, NULL, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->watches);
	self->priv->watches = _tmp0_;
	_tmp1_ = g_hash_table_new_full (NULL, NULL, NULL, NULL);
	_g_hash_table_unref0 (self->priv->watches_by_upstream_id);
	self->priv->watches_by_upstream_id = _tmp1_;
	_tmp2_ = g_cancellable_new ();
	_g_object_unref0 (self->priv->cancellable);
	self->priv->cancellable = _tmp2_;
	return obj;
}

static void
gnome_plugin_idle_monitor_class_init (GnomePluginIdleMonitorClass * klass,
                                      gpointer klass_data)
{
	gnome_plugin_idle_monitor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GnomePluginIdleMonitor_private_offset);
	((GObjectClass *) klass)->dispose = (void (*) (GObject*)) gnome_plugin_idle_monitor_real_dispose;
	G_OBJECT_CLASS (klass)->constructor = gnome_plugin_idle_monitor_constructor;
	G_OBJECT_CLASS (klass)->finalize = gnome_plugin_idle_monitor_finalize;
}

static void
gnome_plugin_idle_monitor_g_initable_interface_init (GInitableIface * iface,
                                                     gpointer iface_data)
{
	gnome_plugin_idle_monitor_g_initable_parent_iface = g_type_interface_peek_parent (iface);
	iface->init = (gboolean (*) (GInitable*, GCancellable*, GError**)) gnome_plugin_idle_monitor_real_init;
}

static void
gnome_plugin_idle_monitor_instance_init (GnomePluginIdleMonitor * self,
                                         gpointer klass)
{
	self->priv = gnome_plugin_idle_monitor_get_instance_private (self);
}

static void
gnome_plugin_idle_monitor_finalize (GObject * obj)
{
	GnomePluginIdleMonitor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GNOME_PLUGIN_TYPE_IDLE_MONITOR, GnomePluginIdleMonitor);
	_g_object_unref0 (self->priv->cancellable);
	_g_object_unref0 (self->priv->proxy);
	_g_hash_table_unref0 (self->priv->watches);
	_g_hash_table_unref0 (self->priv->watches_by_upstream_id);
	G_OBJECT_CLASS (gnome_plugin_idle_monitor_parent_class)->finalize (obj);
}

GType
gnome_plugin_idle_monitor_get_type (void)
{
	return gnome_plugin_idle_monitor_type_id;
}

GType
gnome_plugin_idle_monitor_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (GnomePluginIdleMonitorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gnome_plugin_idle_monitor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GnomePluginIdleMonitor), 0, (GInstanceInitFunc) gnome_plugin_idle_monitor_instance_init, NULL };
	static const GInterfaceInfo g_initable_info = { (GInterfaceInitFunc) gnome_plugin_idle_monitor_g_initable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	gnome_plugin_idle_monitor_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "GnomePluginIdleMonitor", &g_define_type_info, 0);
	g_type_module_add_interface (module, gnome_plugin_idle_monitor_type_id, g_initable_get_type (), &g_initable_info);
	GnomePluginIdleMonitor_private_offset = sizeof (GnomePluginIdleMonitorPrivate);
	return gnome_plugin_idle_monitor_type_id;
}

