/* entry.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from entry.vala, do not modify */

/*
 * Copyright (c) 2017 gnome-pomodoro contributors
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Kamil Prusko <kamilprusko@gmail.com>
 *
 */

#include <gom/gom.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include "gnome-pomodoro.h"
#include <math.h>
#include <float.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define POMODORO_TYPE_ENTRY (pomodoro_entry_get_type ())
#define POMODORO_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), POMODORO_TYPE_ENTRY, PomodoroEntry))
#define POMODORO_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), POMODORO_TYPE_ENTRY, PomodoroEntryClass))
#define POMODORO_IS_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), POMODORO_TYPE_ENTRY))
#define POMODORO_IS_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), POMODORO_TYPE_ENTRY))
#define POMODORO_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), POMODORO_TYPE_ENTRY, PomodoroEntryClass))

typedef struct _PomodoroEntry PomodoroEntry;
typedef struct _PomodoroEntryClass PomodoroEntryClass;
typedef struct _PomodoroEntryPrivate PomodoroEntryPrivate;
enum  {
	POMODORO_ENTRY_0_PROPERTY,
	POMODORO_ENTRY_ID_PROPERTY,
	POMODORO_ENTRY_STATE_NAME_PROPERTY,
	POMODORO_ENTRY_STATE_DURATION_PROPERTY,
	POMODORO_ENTRY_ELAPSED_PROPERTY,
	POMODORO_ENTRY_DATETIME_STRING_PROPERTY,
	POMODORO_ENTRY_DATETIME_LOCAL_STRING_PROPERTY,
	POMODORO_ENTRY_NUM_PROPERTIES
};
static GParamSpec* pomodoro_entry_properties[POMODORO_ENTRY_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_time_zone_unref0(var) ((var == NULL) ? NULL : (var = (g_time_zone_unref (var), NULL)))

struct _PomodoroEntry {
	GomResource parent_instance;
	PomodoroEntryPrivate * priv;
};

struct _PomodoroEntryClass {
	GomResourceClass parent_class;
};

struct _PomodoroEntryPrivate {
	gint64 _id;
	gchar* _state_name;
	gint64 _state_duration;
	gint64 _elapsed;
	gchar* _datetime_string;
	gchar* _datetime_local_string;
};

static gint PomodoroEntry_private_offset;
static gpointer pomodoro_entry_parent_class = NULL;

VALA_EXTERN GType pomodoro_entry_get_type (void) G_GNUC_CONST ;
VALA_EXTERN PomodoroEntry* pomodoro_entry_new_from_state (PomodoroTimerState* state);
VALA_EXTERN PomodoroEntry* pomodoro_entry_construct_from_state (GType object_type,
                                                    PomodoroTimerState* state);
VALA_EXTERN void pomodoro_entry_set_state_name (PomodoroEntry* self,
                                    const gchar* value);
VALA_EXTERN void pomodoro_entry_set_state_duration (PomodoroEntry* self,
                                        gint64 value);
VALA_EXTERN void pomodoro_entry_set_elapsed (PomodoroEntry* self,
                                 gint64 value);
VALA_EXTERN void pomodoro_entry_set_datetime (PomodoroEntry* self,
                                  GDateTime* value);
VALA_EXTERN void pomodoro_entry_set_datetime_string (PomodoroEntry* self,
                                         const gchar* value);
VALA_EXTERN void pomodoro_entry_set_datetime_local_string (PomodoroEntry* self,
                                               const gchar* value);
VALA_EXTERN GDateTime* pomodoro_entry_get_datetime_local (PomodoroEntry* self);
VALA_EXTERN const gchar* pomodoro_entry_get_datetime_local_string (PomodoroEntry* self);
VALA_EXTERN PomodoroEntry* pomodoro_entry_new (void);
VALA_EXTERN PomodoroEntry* pomodoro_entry_construct (GType object_type);
VALA_EXTERN gint64 pomodoro_entry_get_id (PomodoroEntry* self);
VALA_EXTERN void pomodoro_entry_set_id (PomodoroEntry* self,
                            gint64 value);
VALA_EXTERN const gchar* pomodoro_entry_get_state_name (PomodoroEntry* self);
VALA_EXTERN gint64 pomodoro_entry_get_state_duration (PomodoroEntry* self);
VALA_EXTERN gint64 pomodoro_entry_get_elapsed (PomodoroEntry* self);
VALA_EXTERN const gchar* pomodoro_entry_get_datetime_string (PomodoroEntry* self);
static void pomodoro_entry_finalize (GObject * obj);
static GType pomodoro_entry_get_type_once (void);
static void _vala_pomodoro_entry_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec);
static void _vala_pomodoro_entry_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec);

static inline gpointer
pomodoro_entry_get_instance_private (PomodoroEntry* self)
{
	return G_STRUCT_MEMBER_P (self, PomodoroEntry_private_offset);
}

PomodoroEntry*
pomodoro_entry_construct_from_state (GType object_type,
                                     PomodoroTimerState* state)
{
	PomodoroEntry * self = NULL;
	GDateTime* datetime = NULL;
	gdouble _tmp0_;
	gdouble _tmp1_;
	GDateTime* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gdouble _tmp5_;
	gdouble _tmp6_;
	gdouble _tmp7_;
	gdouble _tmp8_;
	g_return_val_if_fail (state != NULL, NULL);
	self = (PomodoroEntry*) g_object_new (object_type, NULL);
	_tmp0_ = pomodoro_timer_state_get_timestamp (state);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_date_time_new_from_unix_utc ((gint64) floor (_tmp1_));
	datetime = _tmp2_;
	_tmp3_ = pomodoro_timer_state_get_name (state);
	_tmp4_ = _tmp3_;
	pomodoro_entry_set_state_name (self, _tmp4_);
	_tmp5_ = pomodoro_timer_state_get_duration (state);
	_tmp6_ = _tmp5_;
	pomodoro_entry_set_state_duration (self, (gint64) floor (_tmp6_));
	_tmp7_ = pomodoro_timer_state_get_elapsed (state);
	_tmp8_ = _tmp7_;
	pomodoro_entry_set_elapsed (self, (gint64) floor (_tmp8_));
	pomodoro_entry_set_datetime (self, datetime);
	_g_date_time_unref0 (datetime);
	return self;
}

PomodoroEntry*
pomodoro_entry_new_from_state (PomodoroTimerState* state)
{
	return pomodoro_entry_construct_from_state (POMODORO_TYPE_ENTRY, state);
}

static gchar*
g_date_time_to_string (GDateTime* self)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_date_time_format (self, "%FT%H:%M:%S%z");
	result = _tmp0_;
	return result;
}

void
pomodoro_entry_set_datetime (PomodoroEntry* self,
                             GDateTime* value)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_ = g_date_time_to_string (value);
	_tmp1_ = _tmp0_;
	pomodoro_entry_set_datetime_string (self, _tmp1_);
	_g_free0 (_tmp1_);
	_tmp2_ = g_date_time_to_local (value);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_date_time_format (_tmp3_, "%Y-%m-%dT%H:%M:%S");
	_tmp5_ = _tmp4_;
	pomodoro_entry_set_datetime_local_string (self, _tmp5_);
	_g_free0 (_tmp5_);
	_g_date_time_unref0 (_tmp3_);
}

GDateTime*
pomodoro_entry_get_datetime_local (PomodoroEntry* self)
{
	const gchar* _tmp0_;
	GTimeZone* _tmp1_;
	GTimeZone* _tmp2_;
	GDateTime* _tmp3_;
	GDateTime* _tmp4_;
	GDateTime* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_datetime_local_string;
	_tmp1_ = g_time_zone_new_local ();
	_tmp2_ = _tmp1_;
	_tmp3_ = g_date_time_new_from_iso8601 (_tmp0_, _tmp2_);
	_tmp4_ = _tmp3_;
	_g_time_zone_unref0 (_tmp2_);
	result = _tmp4_;
	return result;
}

PomodoroEntry*
pomodoro_entry_construct (GType object_type)
{
	PomodoroEntry * self = NULL;
	self = (PomodoroEntry*) g_object_new (object_type, NULL);
	return self;
}

PomodoroEntry*
pomodoro_entry_new (void)
{
	return pomodoro_entry_construct (POMODORO_TYPE_ENTRY);
}

gint64
pomodoro_entry_get_id (PomodoroEntry* self)
{
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_id;
	return result;
}

void
pomodoro_entry_set_id (PomodoroEntry* self,
                       gint64 value)
{
	gint64 old_value;
	g_return_if_fail (self != NULL);
	old_value = pomodoro_entry_get_id (self);
	if (old_value != value) {
		self->priv->_id = value;
		g_object_notify_by_pspec ((GObject *) self, pomodoro_entry_properties[POMODORO_ENTRY_ID_PROPERTY]);
	}
}

const gchar*
pomodoro_entry_get_state_name (PomodoroEntry* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_state_name;
	result = _tmp0_;
	return result;
}

void
pomodoro_entry_set_state_name (PomodoroEntry* self,
                               const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = pomodoro_entry_get_state_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_state_name);
		self->priv->_state_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, pomodoro_entry_properties[POMODORO_ENTRY_STATE_NAME_PROPERTY]);
	}
}

gint64
pomodoro_entry_get_state_duration (PomodoroEntry* self)
{
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_state_duration;
	return result;
}

void
pomodoro_entry_set_state_duration (PomodoroEntry* self,
                                   gint64 value)
{
	gint64 old_value;
	g_return_if_fail (self != NULL);
	old_value = pomodoro_entry_get_state_duration (self);
	if (old_value != value) {
		self->priv->_state_duration = value;
		g_object_notify_by_pspec ((GObject *) self, pomodoro_entry_properties[POMODORO_ENTRY_STATE_DURATION_PROPERTY]);
	}
}

gint64
pomodoro_entry_get_elapsed (PomodoroEntry* self)
{
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_elapsed;
	return result;
}

void
pomodoro_entry_set_elapsed (PomodoroEntry* self,
                            gint64 value)
{
	gint64 old_value;
	g_return_if_fail (self != NULL);
	old_value = pomodoro_entry_get_elapsed (self);
	if (old_value != value) {
		self->priv->_elapsed = value;
		g_object_notify_by_pspec ((GObject *) self, pomodoro_entry_properties[POMODORO_ENTRY_ELAPSED_PROPERTY]);
	}
}

const gchar*
pomodoro_entry_get_datetime_string (PomodoroEntry* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_datetime_string;
	result = _tmp0_;
	return result;
}

void
pomodoro_entry_set_datetime_string (PomodoroEntry* self,
                                    const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = pomodoro_entry_get_datetime_string (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_datetime_string);
		self->priv->_datetime_string = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, pomodoro_entry_properties[POMODORO_ENTRY_DATETIME_STRING_PROPERTY]);
	}
}

const gchar*
pomodoro_entry_get_datetime_local_string (PomodoroEntry* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_datetime_local_string;
	result = _tmp0_;
	return result;
}

void
pomodoro_entry_set_datetime_local_string (PomodoroEntry* self,
                                          const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = pomodoro_entry_get_datetime_local_string (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_datetime_local_string);
		self->priv->_datetime_local_string = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, pomodoro_entry_properties[POMODORO_ENTRY_DATETIME_LOCAL_STRING_PROPERTY]);
	}
}

static void
pomodoro_entry_class_init (PomodoroEntryClass * klass,
                           gpointer klass_data)
{
	pomodoro_entry_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PomodoroEntry_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_pomodoro_entry_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_pomodoro_entry_set_property;
	G_OBJECT_CLASS (klass)->finalize = pomodoro_entry_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), POMODORO_ENTRY_ID_PROPERTY, pomodoro_entry_properties[POMODORO_ENTRY_ID_PROPERTY] = g_param_spec_int64 ("id", "id", "id", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POMODORO_ENTRY_STATE_NAME_PROPERTY, pomodoro_entry_properties[POMODORO_ENTRY_STATE_NAME_PROPERTY] = g_param_spec_string ("state-name", "state-name", "state-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POMODORO_ENTRY_STATE_DURATION_PROPERTY, pomodoro_entry_properties[POMODORO_ENTRY_STATE_DURATION_PROPERTY] = g_param_spec_int64 ("state-duration", "state-duration", "state-duration", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POMODORO_ENTRY_ELAPSED_PROPERTY, pomodoro_entry_properties[POMODORO_ENTRY_ELAPSED_PROPERTY] = g_param_spec_int64 ("elapsed", "elapsed", "elapsed", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POMODORO_ENTRY_DATETIME_STRING_PROPERTY, pomodoro_entry_properties[POMODORO_ENTRY_DATETIME_STRING_PROPERTY] = g_param_spec_string ("datetime-string", "datetime-string", "datetime-string", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POMODORO_ENTRY_DATETIME_LOCAL_STRING_PROPERTY, pomodoro_entry_properties[POMODORO_ENTRY_DATETIME_LOCAL_STRING_PROPERTY] = g_param_spec_string ("datetime-local-string", "datetime-local-string", "datetime-local-string", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	gom_resource_class_set_table (GOM_RESOURCE_CLASS (klass), "entries");
	gom_resource_class_set_primary_key (GOM_RESOURCE_CLASS (klass), "id");
	gom_resource_class_set_notnull (GOM_RESOURCE_CLASS (klass), "state-name");
	gom_resource_class_set_notnull (GOM_RESOURCE_CLASS (klass), "datetime-string");
	gom_resource_class_set_notnull (GOM_RESOURCE_CLASS (klass), "datetime-local-string");
}

static void
pomodoro_entry_instance_init (PomodoroEntry * self,
                              gpointer klass)
{
	self->priv = pomodoro_entry_get_instance_private (self);
}

static void
pomodoro_entry_finalize (GObject * obj)
{
	PomodoroEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, POMODORO_TYPE_ENTRY, PomodoroEntry);
	_g_free0 (self->priv->_state_name);
	_g_free0 (self->priv->_datetime_string);
	_g_free0 (self->priv->_datetime_local_string);
	G_OBJECT_CLASS (pomodoro_entry_parent_class)->finalize (obj);
}

static GType
pomodoro_entry_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PomodoroEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pomodoro_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PomodoroEntry), 0, (GInstanceInitFunc) pomodoro_entry_instance_init, NULL };
	GType pomodoro_entry_type_id;
	pomodoro_entry_type_id = g_type_register_static (gom_resource_get_type (), "PomodoroEntry", &g_define_type_info, 0);
	PomodoroEntry_private_offset = g_type_add_instance_private (pomodoro_entry_type_id, sizeof (PomodoroEntryPrivate));
	return pomodoro_entry_type_id;
}

GType
pomodoro_entry_get_type (void)
{
	static volatile gsize pomodoro_entry_type_id__once = 0;
	if (g_once_init_enter (&pomodoro_entry_type_id__once)) {
		GType pomodoro_entry_type_id;
		pomodoro_entry_type_id = pomodoro_entry_get_type_once ();
		g_once_init_leave (&pomodoro_entry_type_id__once, pomodoro_entry_type_id);
	}
	return pomodoro_entry_type_id__once;
}

static void
_vala_pomodoro_entry_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec)
{
	PomodoroEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, POMODORO_TYPE_ENTRY, PomodoroEntry);
	switch (property_id) {
		case POMODORO_ENTRY_ID_PROPERTY:
		g_value_set_int64 (value, pomodoro_entry_get_id (self));
		break;
		case POMODORO_ENTRY_STATE_NAME_PROPERTY:
		g_value_set_string (value, pomodoro_entry_get_state_name (self));
		break;
		case POMODORO_ENTRY_STATE_DURATION_PROPERTY:
		g_value_set_int64 (value, pomodoro_entry_get_state_duration (self));
		break;
		case POMODORO_ENTRY_ELAPSED_PROPERTY:
		g_value_set_int64 (value, pomodoro_entry_get_elapsed (self));
		break;
		case POMODORO_ENTRY_DATETIME_STRING_PROPERTY:
		g_value_set_string (value, pomodoro_entry_get_datetime_string (self));
		break;
		case POMODORO_ENTRY_DATETIME_LOCAL_STRING_PROPERTY:
		g_value_set_string (value, pomodoro_entry_get_datetime_local_string (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_pomodoro_entry_set_property (GObject * object,
                                   guint property_id,
                                   const GValue * value,
                                   GParamSpec * pspec)
{
	PomodoroEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, POMODORO_TYPE_ENTRY, PomodoroEntry);
	switch (property_id) {
		case POMODORO_ENTRY_ID_PROPERTY:
		pomodoro_entry_set_id (self, g_value_get_int64 (value));
		break;
		case POMODORO_ENTRY_STATE_NAME_PROPERTY:
		pomodoro_entry_set_state_name (self, g_value_get_string (value));
		break;
		case POMODORO_ENTRY_STATE_DURATION_PROPERTY:
		pomodoro_entry_set_state_duration (self, g_value_get_int64 (value));
		break;
		case POMODORO_ENTRY_ELAPSED_PROPERTY:
		pomodoro_entry_set_elapsed (self, g_value_get_int64 (value));
		break;
		case POMODORO_ENTRY_DATETIME_STRING_PROPERTY:
		pomodoro_entry_set_datetime_string (self, g_value_get_string (value));
		break;
		case POMODORO_ENTRY_DATETIME_LOCAL_STRING_PROPERTY:
		pomodoro_entry_set_datetime_local_string (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

