/* preferences-dialog.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from preferences-dialog.vala, do not modify */

/*
 * Copyright (c) 2013,2014,2016 gnome-pomodoro contributors
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Kamil Prusko <kamilprusko@gmail.com>
 *
 */

#include <glib.h>
#include <float.h>
#include <math.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include "gnome-pomodoro.h"
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <libpeas/peas.h>

#define POMODORO_TIMER_SCALE_LOWER 60.0
#define POMODORO_TIMER_SCALE_UPPER (60.0 * 120.0)
#define POMODORO_LONG_BREAK_INTERVAL_LOWER 1.0
#define POMODORO_LONG_BREAK_INTERVAL_UPPER 10.0
#define POMODORO_PREFERENCES_DIALOG_DEFAULT_WIDTH 600
#define POMODORO_PREFERENCES_DIALOG_DEFAULT_HEIGHT 720
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define POMODORO_TYPE_ACCELERATOR (pomodoro_accelerator_get_type ())
#define POMODORO_ACCELERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), POMODORO_TYPE_ACCELERATOR, PomodoroAccelerator))
#define POMODORO_ACCELERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), POMODORO_TYPE_ACCELERATOR, PomodoroAcceleratorClass))
#define POMODORO_IS_ACCELERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), POMODORO_TYPE_ACCELERATOR))
#define POMODORO_IS_ACCELERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), POMODORO_TYPE_ACCELERATOR))
#define POMODORO_ACCELERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), POMODORO_TYPE_ACCELERATOR, PomodoroAcceleratorClass))

typedef struct _PomodoroAccelerator PomodoroAccelerator;
typedef struct _PomodoroAcceleratorClass PomodoroAcceleratorClass;
enum  {
	POMODORO_PREFERENCES_KEYBOARD_SHORTCUT_PAGE_0_PROPERTY,
	POMODORO_PREFERENCES_KEYBOARD_SHORTCUT_PAGE_NUM_PROPERTIES
};
static GParamSpec* pomodoro_preferences_keyboard_shortcut_page_properties[POMODORO_PREFERENCES_KEYBOARD_SHORTCUT_PAGE_NUM_PROPERTIES];

#define POMODORO_TYPE_ACCELERATOR_ERROR (pomodoro_accelerator_error_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	POMODORO_PREFERENCES_PLUGINS_PAGE_0_PROPERTY,
	POMODORO_PREFERENCES_PLUGINS_PAGE_NUM_PROPERTIES
};
static GParamSpec* pomodoro_preferences_plugins_page_properties[POMODORO_PREFERENCES_PLUGINS_PAGE_NUM_PROPERTIES];
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define __vala_PeasPluginInfo_free0(var) ((var == NULL) ? NULL : (var = (_vala_PeasPluginInfo_free (var), NULL)))
typedef struct _Block9Data Block9Data;
enum  {
	POMODORO_PREFERENCES_MAIN_PAGE_0_PROPERTY,
	POMODORO_PREFERENCES_MAIN_PAGE_NUM_PROPERTIES
};
static GParamSpec* pomodoro_preferences_main_page_properties[POMODORO_PREFERENCES_MAIN_PAGE_NUM_PROPERTIES];
typedef struct _Block10Data Block10Data;
typedef struct _Block11Data Block11Data;
typedef struct _Block12Data Block12Data;
typedef struct _Block13Data Block13Data;
typedef struct _Block14Data Block14Data;

#define POMODORO_PREFERENCES_DIALOG_TYPE_PAGE_META (pomodoro_preferences_dialog_page_meta_get_type ())
typedef struct _PomodoroPreferencesDialogPageMeta PomodoroPreferencesDialogPageMeta;
enum  {
	POMODORO_PREFERENCES_DIALOG_0_PROPERTY,
	POMODORO_PREFERENCES_DIALOG_NUM_PROPERTIES
};
static GParamSpec* pomodoro_preferences_dialog_properties[POMODORO_PREFERENCES_DIALOG_NUM_PROPERTIES];
#define _pomodoro_preferences_dialog_page_meta_free0(var) ((var == NULL) ? NULL : (var = (pomodoro_preferences_dialog_page_meta_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _PomodoroPreferencesKeyboardShortcutPagePrivate {
	PomodoroAccelerator* _accelerator;
	GtkBox* preview_box;
	GtkButton* disable_button;
	GtkLabel* error_label;
	GSettings* settings;
	gulong key_press_event_id;
	gulong key_release_event_id;
	gulong focus_out_event_id;
};

typedef enum  {
	POMODORO_ACCELERATOR_ERROR_INVALID,
	POMODORO_ACCELERATOR_ERROR_FORBIDDEN,
	POMODORO_ACCELERATOR_ERROR_TYPING_COLLISION
} PomodoroAcceleratorError;
#define POMODORO_ACCELERATOR_ERROR pomodoro_accelerator_error_quark ()

struct _PomodoroPreferencesPluginsPagePrivate {
	GtkListBox* plugins_listbox;
	GSettings* settings;
	PeasEngine* engine;
	GHashTable* toggles;
};

struct _Block9Data {
	int _ref_count_;
	PomodoroPreferencesPluginsPage* self;
	GtkSwitch* toggle;
	PeasPluginInfo* plugin_info;
};

struct _PomodoroPreferencesMainPagePrivate {
	GtkListBoxRow* listboxrow_accelerator;
	GtkListBoxRow* listboxrow_idle_monitor;
	GSettings* settings;
	PomodoroAccelerator* accelerator;
};

struct _Block10Data {
	int _ref_count_;
	PomodoroPreferencesMainPage* self;
	GtkAdjustment* adjustment;
	GtkLabel* label;
};

struct _Block11Data {
	int _ref_count_;
	PomodoroPreferencesMainPage* self;
	GtkLabel* accelerator_label;
};

struct _Block12Data {
	int _ref_count_;
	PomodoroPreferencesMainPage* self;
	GtkListBox* listbox;
};

struct _Block13Data {
	int _ref_count_;
	PomodoroPreferencesMainPage* self;
	gboolean visible;
};

struct _Block14Data {
	int _ref_count_;
	PomodoroPreferencesMainPage* self;
	gboolean visible;
};

struct _PomodoroPreferencesDialogPageMeta {
	GType type;
	gchar* name;
	gchar* title;
};

struct _PomodoroPreferencesDialogPrivate {
	GtkHeaderBar* header_bar;
	GtkStack* stack;
	GtkButton* back_button;
	GHashTable* pages;
	GList* history;
	PeasExtensionSet* extensions;
};

static gint PomodoroPreferencesKeyboardShortcutPage_private_offset;
static gpointer pomodoro_preferences_keyboard_shortcut_page_parent_class = NULL;
static GtkBuildableIface * pomodoro_preferences_keyboard_shortcut_page_gtk_buildable_parent_iface = NULL;
static PomodoroPreferencesPageIface * pomodoro_preferences_keyboard_shortcut_page_pomodoro_preferences_page_parent_iface = NULL;
static gint PomodoroPreferencesPluginsPage_private_offset;
static gpointer pomodoro_preferences_plugins_page_parent_class = NULL;
static GtkBuildableIface * pomodoro_preferences_plugins_page_gtk_buildable_parent_iface = NULL;
static PomodoroPreferencesPageIface * pomodoro_preferences_plugins_page_pomodoro_preferences_page_parent_iface = NULL;
static gint PomodoroPreferencesMainPage_private_offset;
static gpointer pomodoro_preferences_main_page_parent_class = NULL;
static GtkBuildableIface * pomodoro_preferences_main_page_gtk_buildable_parent_iface = NULL;
static PomodoroPreferencesPageIface * pomodoro_preferences_main_page_pomodoro_preferences_page_parent_iface = NULL;
static gint PomodoroPreferencesDialog_private_offset;
static gpointer pomodoro_preferences_dialog_parent_class = NULL;
static PomodoroPreferencesDialog* pomodoro_preferences_dialog_instance;
static PomodoroPreferencesDialog* pomodoro_preferences_dialog_instance = NULL;
static GtkBuildableIface * pomodoro_preferences_dialog_gtk_buildable_parent_iface = NULL;

VALA_EXTERN gboolean pomodoro_get_accelerator_mapping (GValue* value,
                                           GVariant* variant,
                                           void* user_data);
VALA_EXTERN GVariant* pomodoro_set_accelerator_mapping (GValue* value,
                                            const GVariantType* expected_type,
                                            void* user_data);
VALA_EXTERN void pomodoro_list_box_separator_func (GtkListBoxRow* row,
                                       GtkListBoxRow* before);
static GType pomodoro_preferences_dialog_extension_get_type_once (void);
static void pomodoro_preferences_page_real_configure_header_bar (PomodoroPreferencesPage* self,
                                                          GtkHeaderBar* header_bar);
static GType pomodoro_preferences_page_get_type_once (void);
VALA_EXTERN GType pomodoro_accelerator_get_type (void) G_GNUC_CONST ;
static gboolean pomodoro_preferences_keyboard_shortcut_page_validate_accelerator (PomodoroPreferencesKeyboardShortcutPage* self);
static PomodoroAccelerator* pomodoro_preferences_keyboard_shortcut_page_get_accelerator (PomodoroPreferencesKeyboardShortcutPage* self);
VALA_EXTERN GQuark pomodoro_accelerator_error_quark (void);
VALA_EXTERN GType pomodoro_accelerator_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void pomodoro_accelerator_validate (PomodoroAccelerator* self,
                                    GError** error);
VALA_EXTERN gchar* pomodoro_accelerator_get_display_name (PomodoroAccelerator* self);
static void pomodoro_preferences_keyboard_shortcut_page_update_preview (PomodoroPreferencesKeyboardShortcutPage* self);
static void __lambda26_ (PomodoroPreferencesKeyboardShortcutPage* self,
                  GtkWidget* child);
static void ___lambda26__gtk_callback (GtkWidget* widget,
                                gpointer self);
VALA_EXTERN gchar** pomodoro_accelerator_get_keys (PomodoroAccelerator* self,
                                       gint* result_length1);
static void pomodoro_preferences_keyboard_shortcut_page_on_disable_clicked (PomodoroPreferencesKeyboardShortcutPage* self);
VALA_EXTERN void pomodoro_accelerator_unset (PomodoroAccelerator* self);
static void _pomodoro_preferences_keyboard_shortcut_page_on_disable_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                                         gpointer self);
static void pomodoro_preferences_keyboard_shortcut_page_on_accelerator_changed (PomodoroPreferencesKeyboardShortcutPage* self);
static gboolean pomodoro_preferences_keyboard_shortcut_page_on_key_press_event (PomodoroPreferencesKeyboardShortcutPage* self,
                                                                         GdkEventKey* event);
VALA_EXTERN void pomodoro_accelerator_set_keyval (PomodoroAccelerator* self,
                                      guint keyval,
                                      GdkModifierType modifiers);
static gboolean pomodoro_preferences_keyboard_shortcut_page_on_key_release_event (PomodoroPreferencesKeyboardShortcutPage* self,
                                                                           GdkEventKey* event);
static gboolean pomodoro_preferences_keyboard_shortcut_page_on_focus_out_event (PomodoroPreferencesKeyboardShortcutPage* self,
                                                                         GdkEventFocus* event);
static void pomodoro_preferences_keyboard_shortcut_page_real_map (GtkWidget* base);
static gboolean _pomodoro_preferences_keyboard_shortcut_page_on_key_press_event_gtk_widget_key_press_event (GtkWidget* _sender,
                                                                                                     GdkEventKey* event,
                                                                                                     gpointer self);
static gboolean _pomodoro_preferences_keyboard_shortcut_page_on_key_release_event_gtk_widget_key_release_event (GtkWidget* _sender,
                                                                                                         GdkEventKey* event,
                                                                                                         gpointer self);
static gboolean _pomodoro_preferences_keyboard_shortcut_page_on_focus_out_event_gtk_widget_focus_out_event (GtkWidget* _sender,
                                                                                                     GdkEventFocus* event,
                                                                                                     gpointer self);
static void pomodoro_preferences_keyboard_shortcut_page_real_unmap (GtkWidget* base);
static void pomodoro_preferences_keyboard_shortcut_page_set_accelerator (PomodoroPreferencesKeyboardShortcutPage* self,
                                                                  PomodoroAccelerator* value);
static GObject * pomodoro_preferences_keyboard_shortcut_page_constructor (GType type,
                                                                   guint n_construct_properties,
                                                                   GObjectConstructParam * construct_properties);
VALA_EXTERN PomodoroAccelerator* pomodoro_accelerator_new (void);
VALA_EXTERN PomodoroAccelerator* pomodoro_accelerator_construct (GType object_type);
static void _pomodoro_preferences_keyboard_shortcut_page_on_accelerator_changed_pomodoro_accelerator_changed (PomodoroAccelerator* _sender,
                                                                                                       gpointer self);
static void pomodoro_preferences_keyboard_shortcut_page_finalize (GObject * obj);
static GType pomodoro_preferences_keyboard_shortcut_page_get_type_once (void);
static void _vala_pomodoro_preferences_keyboard_shortcut_page_get_property (GObject * object,
                                                                     guint property_id,
                                                                     GValue * value,
                                                                     GParamSpec * pspec);
static void _vala_pomodoro_preferences_keyboard_shortcut_page_set_property (GObject * object,
                                                                     guint property_id,
                                                                     const GValue * value,
                                                                     GParamSpec * pspec);
static gint pomodoro_preferences_plugins_page_list_box_sort_func (GtkListBoxRow* row1,
                                                           GtkListBoxRow* row2);
static void pomodoro_preferences_plugins_page_on_settings_changed (PomodoroPreferencesPluginsPage* self,
                                                            GSettings* settings,
                                                            const gchar* key);
static PeasPluginInfo* _vala_PeasPluginInfo_copy (PeasPluginInfo* self);
static gboolean pomodoro_preferences_plugins_page_get_plugin_enabled (PomodoroPreferencesPluginsPage* self,
                                                               const gchar* name);
static void _vala_PeasPluginInfo_free (PeasPluginInfo* self);
static void pomodoro_preferences_plugins_page_set_plugin_enabled (PomodoroPreferencesPluginsPage* self,
                                                           const gchar* name,
                                                           gboolean value);
static void _vala_array_add7 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add8 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static GtkListBoxRow* pomodoro_preferences_plugins_page_create_row (PomodoroPreferencesPluginsPage* self,
                                                             PeasPluginInfo* plugin_info);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
static void __lambda24_ (Block9Data* _data9_);
static void ___lambda24__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static gboolean __lambda25_ (Block9Data* _data9_,
                      gboolean state);
static gboolean ___lambda25__gtk_switch_state_set (GtkSwitch* _sender,
                                            gboolean state,
                                            gpointer self);
static gboolean pomodoro_preferences_plugins_page_is_legacy_plugin (PomodoroPreferencesPluginsPage* self,
                                                             const gchar* plugin_name);
static void pomodoro_preferences_plugins_page_populate (PomodoroPreferencesPluginsPage* self);
static GObject * pomodoro_preferences_plugins_page_constructor (GType type,
                                                         guint n_construct_properties,
                                                         GObjectConstructParam * construct_properties);
static void _pomodoro_preferences_plugins_page_on_settings_changed_g_settings_changed (GSettings* _sender,
                                                                                const gchar* key,
                                                                                gpointer self);
static void _pomodoro_list_box_separator_func_gtk_list_box_update_header_func (GtkListBoxRow* row,
                                                                        GtkListBoxRow* before,
                                                                        gpointer self);
static gint _pomodoro_preferences_plugins_page_list_box_sort_func_gtk_list_box_sort_func (GtkListBoxRow* row1,
                                                                                   GtkListBoxRow* row2,
                                                                                   gpointer self);
static void _g_free0_ (gpointer var);
static void pomodoro_preferences_plugins_page_finalize (GObject * obj);
static GType pomodoro_preferences_plugins_page_get_type_once (void);
static PomodoroWidgetsLogScale* pomodoro_preferences_main_page_setup_time_scale (PomodoroPreferencesMainPage* self,
                                                                          GtkBuilder* builder,
                                                                          const gchar* grid_name,
                                                                          const gchar* label_name);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (void * _userdata_);
static void __lambda16_ (Block10Data* _data10_);
VALA_EXTERN gchar* pomodoro_format_time (gint seconds);
static void ___lambda16__gtk_adjustment_value_changed (GtkAdjustment* _sender,
                                                gpointer self);
static void pomodoro_preferences_main_page_setup_timer_section (PomodoroPreferencesMainPage* self,
                                                         GtkBuilder* builder);
static Block11Data* block11_data_ref (Block11Data* _data11_);
static void block11_data_unref (void * _userdata_);
static void __lambda17_ (Block11Data* _data11_);
static void ___lambda17__pomodoro_accelerator_changed (PomodoroAccelerator* _sender,
                                                gpointer self);
static void pomodoro_preferences_main_page_setup_notifications_section (PomodoroPreferencesMainPage* self,
                                                                 GtkBuilder* builder);
static void pomodoro_preferences_main_page_setup_other_section (PomodoroPreferencesMainPage* self,
                                                         GtkBuilder* builder);
static void pomodoro_preferences_main_page_setup_plugins_section (PomodoroPreferencesMainPage* self,
                                                           GtkBuilder* builder);
static void pomodoro_preferences_main_page_real_parser_finished (GtkBuildable* base,
                                                          GtkBuilder* builder);
static void pomodoro_preferences_main_page_on_row_activated (PomodoroPreferencesMainPage* self,
                                                      GtkListBox* listbox,
                                                      GtkListBoxRow* row);
static void _pomodoro_preferences_main_page_on_row_activated_gtk_list_box_row_activated (GtkListBox* _sender,
                                                                                  GtkListBoxRow* row,
                                                                                  gpointer self);
static void pomodoro_preferences_main_page_update_capabilities (PomodoroPreferencesMainPage* self);
static void pomodoro_preferences_main_page_on_capability_enabled (PomodoroPreferencesMainPage* self,
                                                           const gchar* capability_name);
static void pomodoro_preferences_main_page_on_capability_disabled (PomodoroPreferencesMainPage* self,
                                                            const gchar* capability_name);
static void pomodoro_preferences_main_page_setup_listbox (PomodoroPreferencesMainPage* self,
                                                   GtkListBox* listbox);
static Block12Data* block12_data_ref (Block12Data* _data12_);
static void block12_data_unref (void * _userdata_);
static void __lambda21_ (Block12Data* _data12_,
                  GtkWidget* child);
static void pomodoro_preferences_main_page_on_listbox_add (PomodoroPreferencesMainPage* self,
                                                    GtkWidget* widget,
                                                    GtkWidget* child);
static void ___lambda21__gtk_callback (GtkWidget* widget,
                                gpointer self);
static void _pomodoro_preferences_main_page_on_listbox_add_gtk_container_add (GtkContainer* _sender,
                                                                       GtkWidget* widget,
                                                                       gpointer self);
static void pomodoro_preferences_main_page_on_listbox_remove (PomodoroPreferencesMainPage* self,
                                                       GtkWidget* widget,
                                                       GtkWidget* child);
static void _pomodoro_preferences_main_page_on_listbox_remove_gtk_container_remove (GtkContainer* _sender,
                                                                             GtkWidget* widget,
                                                                             gpointer self);
static void pomodoro_preferences_main_page_on_listboxrow_visible_notify (PomodoroPreferencesMainPage* self,
                                                                  GObject* object,
                                                                  GParamSpec* pspec);
static Block13Data* block13_data_ref (Block13Data* _data13_);
static void block13_data_unref (void * _userdata_);
static void ___lambda22_ (Block13Data* _data13_,
                   GtkWidget* child);
static void ____lambda22__gtk_callback (GtkWidget* widget,
                                 gpointer self);
static void _pomodoro_preferences_main_page_on_listboxrow_visible_notify_g_object_notify (GObject* _sender,
                                                                                   GParamSpec* pspec,
                                                                                   gpointer self);
static Block14Data* block14_data_ref (Block14Data* _data14_);
static void block14_data_unref (void * _userdata_);
static void ___lambda23_ (Block14Data* _data14_,
                   GtkWidget* child);
static void ____lambda23__gtk_callback (GtkWidget* widget,
                                 gpointer self);
static void pomodoro_preferences_main_page_real_dispose (GObject* base);
static void _pomodoro_preferences_main_page_on_capability_enabled_pomodoro_capability_manager_capability_enabled (PomodoroCapabilityManager* _sender,
                                                                                                           const gchar* capability_name,
                                                                                                           gpointer self);
static void _pomodoro_preferences_main_page_on_capability_disabled_pomodoro_capability_manager_capability_disabled (PomodoroCapabilityManager* _sender,
                                                                                                             const gchar* capability_name,
                                                                                                             gpointer self);
static GObject * pomodoro_preferences_main_page_constructor (GType type,
                                                      guint n_construct_properties,
                                                      GObjectConstructParam * construct_properties);
static void pomodoro_preferences_main_page_finalize (GObject * obj);
static GType pomodoro_preferences_main_page_get_type_once (void);
static GType pomodoro_preferences_dialog_page_meta_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static PomodoroPreferencesDialogPageMeta* pomodoro_preferences_dialog_page_meta_dup (const PomodoroPreferencesDialogPageMeta* self);
static void pomodoro_preferences_dialog_page_meta_free (PomodoroPreferencesDialogPageMeta* self);
static void pomodoro_preferences_dialog_page_meta_copy (const PomodoroPreferencesDialogPageMeta* self,
                                                 PomodoroPreferencesDialogPageMeta* dest);
static void pomodoro_preferences_dialog_page_meta_destroy (PomodoroPreferencesDialogPageMeta* self);
static void pomodoro_preferences_dialog_on_back_activate (PomodoroPreferencesDialog* self,
                                                   GSimpleAction* action,
                                                   GVariant* parameter);
static void _pomodoro_preferences_dialog_on_back_activate_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                     GVariant* parameter,
                                                                                     gpointer self);
static inline void _g_list_free__g_free0_ (GList* self);
static void pomodoro_preferences_dialog_real_parser_finished (GtkBuildable* base,
                                                       GtkBuilder* builder);
static void pomodoro_preferences_dialog_on_page_notify (PomodoroPreferencesDialog* self,
                                                 PomodoroPreferencesPage* page);
static void pomodoro_preferences_dialog_history_push (PomodoroPreferencesDialog* self,
                                               const gchar* name);
static void __lambda15_ (PomodoroPreferencesDialog* self,
                  GtkWidget* child);
static void ___lambda15__gtk_callback (GtkWidget* widget,
                                gpointer self);
static void pomodoro_preferences_dialog_on_visible_child_notify (PomodoroPreferencesDialog* self);
static gchar* pomodoro_preferences_dialog_history_pop (PomodoroPreferencesDialog* self);
static void pomodoro_preferences_dialog_history_clear (PomodoroPreferencesDialog* self);
static GObject * pomodoro_preferences_dialog_constructor (GType type,
                                                   guint n_construct_properties,
                                                   GObjectConstructParam * construct_properties);
static void _pomodoro_preferences_dialog_page_meta_free0_ (gpointer var);
static void _pomodoro_preferences_dialog_on_visible_child_notify_g_object_notify (GObject* _sender,
                                                                           GParamSpec* pspec,
                                                                           gpointer self);
static void pomodoro_preferences_dialog_finalize (GObject * obj);
static GType pomodoro_preferences_dialog_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

VALA_EXTERN const gchar* POMODORO_APPLICATION_LEGACY_PLUGINS[2];
static const GActionEntry POMODORO_PREFERENCES_DIALOG_ACTION_ENTRIES[1] = {{"back", _pomodoro_preferences_dialog_on_back_activate_gsimple_action_activate_callback}};

/**
     * Mapping from settings to accelerator
     */
gboolean
pomodoro_get_accelerator_mapping (GValue* value,
                                  GVariant* variant,
                                  void* user_data)
{
	const gchar** accelerators = NULL;
	gsize _tmp0_ = 0;
	const gchar** _tmp1_;
	gint accelerators_length1;
	gint _accelerators_size_;
	const gchar** _tmp2_;
	gint _tmp2__length1;
	gboolean result;
	g_return_val_if_fail (value != NULL, FALSE);
	g_return_val_if_fail (variant != NULL, FALSE);
	_tmp1_ = g_variant_get_strv (variant, &_tmp0_);
	accelerators = _tmp1_;
	accelerators_length1 = _tmp0_;
	_accelerators_size_ = accelerators_length1;
	_tmp2_ = accelerators;
	_tmp2__length1 = accelerators_length1;
	{
		const gchar** accelerator_collection = NULL;
		gint accelerator_collection_length1 = 0;
		gint _accelerator_collection_size_ = 0;
		gint accelerator_it = 0;
		accelerator_collection = _tmp2_;
		accelerator_collection_length1 = _tmp2__length1;
		for (accelerator_it = 0; accelerator_it < accelerator_collection_length1; accelerator_it = accelerator_it + 1) {
			const gchar* accelerator = NULL;
			accelerator = accelerator_collection[accelerator_it];
			{
				const gchar* _tmp3_;
				_tmp3_ = accelerator;
				g_value_set_string (value, _tmp3_);
				result = TRUE;
				accelerators = (g_free (accelerators), NULL);
				return result;
			}
		}
	}
	g_value_set_string (value, "");
	result = TRUE;
	accelerators = (g_free (accelerators), NULL);
	return result;
}

/**
     * Mapping from accelerator to settings
     */
GVariant*
pomodoro_set_accelerator_mapping (GValue* value,
                                  const GVariantType* expected_type,
                                  void* user_data)
{
	gchar* accelerator_name = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	GVariant* result;
	g_return_val_if_fail (value != NULL, NULL);
	g_return_val_if_fail (expected_type != NULL, NULL);
	_tmp0_ = g_value_get_string (value);
	_tmp1_ = g_strdup (_tmp0_);
	accelerator_name = _tmp1_;
	_tmp2_ = accelerator_name;
	if (g_strcmp0 (_tmp2_, "") == 0) {
		gchar** strv = NULL;
		gchar** _tmp3_;
		gint strv_length1;
		gint _strv_size_;
		gchar** _tmp4_;
		gint _tmp4__length1;
		GVariant* _tmp5_;
		_tmp3_ = g_new0 (gchar*, 0 + 1);
		strv = _tmp3_;
		strv_length1 = 0;
		_strv_size_ = strv_length1;
		_tmp4_ = strv;
		_tmp4__length1 = strv_length1;
		_tmp5_ = g_variant_new_strv (_tmp4_, _tmp4__length1);
		g_variant_ref_sink (_tmp5_);
		result = _tmp5_;
		strv = (_vala_array_free (strv, strv_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (accelerator_name);
		return result;
	} else {
		gchar** strv = NULL;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar** _tmp8_;
		gint strv_length1;
		gint _strv_size_;
		gchar** _tmp9_;
		gint _tmp9__length1;
		GVariant* _tmp10_;
		_tmp6_ = accelerator_name;
		_tmp7_ = g_strdup (_tmp6_);
		_tmp8_ = g_new0 (gchar*, 1 + 1);
		_tmp8_[0] = _tmp7_;
		strv = _tmp8_;
		strv_length1 = 1;
		_strv_size_ = strv_length1;
		_tmp9_ = strv;
		_tmp9__length1 = strv_length1;
		_tmp10_ = g_variant_new_strv (_tmp9_, _tmp9__length1);
		g_variant_ref_sink (_tmp10_);
		result = _tmp10_;
		strv = (_vala_array_free (strv, strv_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (accelerator_name);
		return result;
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
pomodoro_list_box_separator_func (GtkListBoxRow* row,
                                  GtkListBoxRow* before)
{
	g_return_if_fail (row != NULL);
	if (before != NULL) {
		GtkWidget* header = NULL;
		GtkWidget* _tmp0_;
		GtkWidget* _tmp1_;
		GtkWidget* _tmp2_;
		_tmp0_ = gtk_list_box_row_get_header (row);
		_tmp1_ = _g_object_ref0 (_tmp0_);
		header = _tmp1_;
		_tmp2_ = header;
		if (_tmp2_ == NULL) {
			GtkSeparator* _tmp3_;
			GtkWidget* _tmp4_;
			GtkWidget* _tmp5_;
			_tmp3_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
			g_object_ref_sink (_tmp3_);
			_g_object_unref0 (header);
			header = (GtkWidget*) _tmp3_;
			_tmp4_ = header;
			gtk_widget_show (_tmp4_);
			_tmp5_ = header;
			gtk_list_box_row_set_header (row, _tmp5_);
		}
		_g_object_unref0 (header);
	}
}

static void
pomodoro_preferences_dialog_extension_default_init (PomodoroPreferencesDialogExtensionIface * iface,
                                                    gpointer iface_data)
{
}

static GType
pomodoro_preferences_dialog_extension_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PomodoroPreferencesDialogExtensionIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pomodoro_preferences_dialog_extension_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType pomodoro_preferences_dialog_extension_type_id;
	pomodoro_preferences_dialog_extension_type_id = g_type_register_static (G_TYPE_INTERFACE, "PomodoroPreferencesDialogExtension", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (pomodoro_preferences_dialog_extension_type_id, peas_extension_base_get_type ());
	return pomodoro_preferences_dialog_extension_type_id;
}

GType
pomodoro_preferences_dialog_extension_get_type (void)
{
	static volatile gsize pomodoro_preferences_dialog_extension_type_id__once = 0;
	if (g_once_init_enter (&pomodoro_preferences_dialog_extension_type_id__once)) {
		GType pomodoro_preferences_dialog_extension_type_id;
		pomodoro_preferences_dialog_extension_type_id = pomodoro_preferences_dialog_extension_get_type_once ();
		g_once_init_leave (&pomodoro_preferences_dialog_extension_type_id__once, pomodoro_preferences_dialog_extension_type_id);
	}
	return pomodoro_preferences_dialog_extension_type_id__once;
}

PomodoroPreferencesDialog*
pomodoro_preferences_page_get_preferences_dialog (PomodoroPreferencesPage* self)
{
	GtkWidget* _tmp0_;
	PomodoroPreferencesDialog* result;
	_tmp0_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	result = POMODORO_IS_PREFERENCES_DIALOG (_tmp0_) ? ((PomodoroPreferencesDialog*) _tmp0_) : NULL;
	return result;
}

static void
pomodoro_preferences_page_real_configure_header_bar (PomodoroPreferencesPage* self,
                                                     GtkHeaderBar* header_bar)
{
	g_return_if_fail (header_bar != NULL);
}

void
pomodoro_preferences_page_configure_header_bar (PomodoroPreferencesPage* self,
                                                GtkHeaderBar* header_bar)
{
	PomodoroPreferencesPageIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = POMODORO_PREFERENCES_PAGE_GET_INTERFACE (self);
	if (_iface_->configure_header_bar) {
		_iface_->configure_header_bar (self, header_bar);
	}
}

static void
pomodoro_preferences_page_default_init (PomodoroPreferencesPageIface * iface,
                                        gpointer iface_data)
{
	iface->configure_header_bar = pomodoro_preferences_page_real_configure_header_bar;
}

static GType
pomodoro_preferences_page_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PomodoroPreferencesPageIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pomodoro_preferences_page_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType pomodoro_preferences_page_type_id;
	pomodoro_preferences_page_type_id = g_type_register_static (G_TYPE_INTERFACE, "PomodoroPreferencesPage", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (pomodoro_preferences_page_type_id, gtk_widget_get_type ());
	return pomodoro_preferences_page_type_id;
}

GType
pomodoro_preferences_page_get_type (void)
{
	static volatile gsize pomodoro_preferences_page_type_id__once = 0;
	if (g_once_init_enter (&pomodoro_preferences_page_type_id__once)) {
		GType pomodoro_preferences_page_type_id;
		pomodoro_preferences_page_type_id = pomodoro_preferences_page_get_type_once ();
		g_once_init_leave (&pomodoro_preferences_page_type_id__once, pomodoro_preferences_page_type_id);
	}
	return pomodoro_preferences_page_type_id__once;
}

static inline gpointer
pomodoro_preferences_keyboard_shortcut_page_get_instance_private (PomodoroPreferencesKeyboardShortcutPage* self)
{
	return G_STRUCT_MEMBER_P (self, PomodoroPreferencesKeyboardShortcutPage_private_offset);
}

static gboolean
pomodoro_preferences_keyboard_shortcut_page_validate_accelerator (PomodoroPreferencesKeyboardShortcutPage* self)
{
	gboolean is_valid = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	is_valid = FALSE;
	{
		PomodoroAccelerator* _tmp0_;
		GtkLabel* _tmp2_;
		_tmp0_ = self->priv->_accelerator;
		pomodoro_accelerator_validate (_tmp0_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp1_ = FALSE;
			if (_inner_error0_->domain == POMODORO_ACCELERATOR_ERROR) {
				goto __catch0_pomodoro_accelerator_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp1_;
		}
		_tmp2_ = self->priv->error_label;
		gtk_widget_hide ((GtkWidget*) _tmp2_);
		is_valid = TRUE;
	}
	goto __finally0;
	__catch0_pomodoro_accelerator_error:
	{
		GError* _error_ = NULL;
		GError* _tmp3_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = _error_;
		if (g_error_matches (_tmp3_, POMODORO_ACCELERATOR_ERROR, POMODORO_ACCELERATOR_ERROR_TYPING_COLLISION)) {
			GtkLabel* _tmp4_;
			PomodoroAccelerator* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			GtkLabel* _tmp11_;
			_tmp4_ = self->priv->error_label;
			_tmp5_ = self->priv->_accelerator;
			_tmp6_ = pomodoro_accelerator_get_display_name (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = _tmp7_;
			_tmp9_ = g_strdup_printf (_ ("Using \"%s\" as shortcut will interfere with typing. Try adding anothe" \
"r key, such as Control, Alt or Shift."), _tmp8_);
			_tmp10_ = _tmp9_;
			gtk_label_set_label (_tmp4_, _tmp10_);
			_g_free0 (_tmp10_);
			_g_free0 (_tmp8_);
			_tmp11_ = self->priv->error_label;
			gtk_widget_show ((GtkWidget*) _tmp11_);
		}
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp12_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp12_;
	}
	result = is_valid;
	return result;
}

static void
__lambda26_ (PomodoroPreferencesKeyboardShortcutPage* self,
             GtkWidget* child)
{
	g_return_if_fail (child != NULL);
	gtk_widget_destroy (child);
}

static void
___lambda26__gtk_callback (GtkWidget* widget,
                           gpointer self)
{
	__lambda26_ ((PomodoroPreferencesKeyboardShortcutPage*) self, widget);
}

static void
pomodoro_preferences_keyboard_shortcut_page_update_preview (PomodoroPreferencesKeyboardShortcutPage* self)
{
	gint index = 0;
	GtkBox* _tmp0_;
	PomodoroAccelerator* _tmp1_;
	gint _tmp2_ = 0;
	gchar** _tmp3_;
	GtkButton* _tmp16_;
	GtkBox* _tmp17_;
	g_return_if_fail (self != NULL);
	index = 0;
	_tmp0_ = self->priv->preview_box;
	gtk_container_forall ((GtkContainer*) _tmp0_, ___lambda26__gtk_callback, self);
	_tmp1_ = self->priv->_accelerator;
	_tmp3_ = pomodoro_accelerator_get_keys (_tmp1_, &_tmp2_);
	{
		gchar** element_collection = NULL;
		gint element_collection_length1 = 0;
		gint _element_collection_size_ = 0;
		gint element_it = 0;
		element_collection = _tmp3_;
		element_collection_length1 = _tmp2_;
		for (element_it = 0; element_it < element_collection_length1; element_it = element_it + 1) {
			gchar* _tmp4_;
			gchar* element = NULL;
			_tmp4_ = g_strdup (element_collection[element_it]);
			element = _tmp4_;
			{
				GtkLabel* key_label = NULL;
				const gchar* _tmp8_;
				GtkLabel* _tmp9_;
				GtkLabel* _tmp10_;
				GtkLabel* _tmp11_;
				GtkStyleContext* _tmp12_;
				GtkBox* _tmp13_;
				GtkLabel* _tmp14_;
				gint _tmp15_;
				if (index > 0) {
					GtkBox* _tmp5_;
					GtkLabel* _tmp6_;
					GtkLabel* _tmp7_;
					_tmp5_ = self->priv->preview_box;
					_tmp6_ = (GtkLabel*) gtk_label_new ("+");
					g_object_ref_sink (_tmp6_);
					_tmp7_ = _tmp6_;
					gtk_box_pack_start (_tmp5_, (GtkWidget*) _tmp7_, FALSE, FALSE, (guint) 0);
					_g_object_unref0 (_tmp7_);
				}
				_tmp8_ = element;
				_tmp9_ = (GtkLabel*) gtk_label_new (_tmp8_);
				g_object_ref_sink (_tmp9_);
				key_label = _tmp9_;
				_tmp10_ = key_label;
				gtk_widget_set_valign ((GtkWidget*) _tmp10_, GTK_ALIGN_CENTER);
				_tmp11_ = key_label;
				_tmp12_ = gtk_widget_get_style_context ((GtkWidget*) _tmp11_);
				gtk_style_context_add_class (_tmp12_, "key");
				_tmp13_ = self->priv->preview_box;
				_tmp14_ = key_label;
				gtk_box_pack_start (_tmp13_, (GtkWidget*) _tmp14_, FALSE, FALSE, (guint) 0);
				_tmp15_ = index;
				index = _tmp15_ + 1;
				_g_object_unref0 (key_label);
				_g_free0 (element);
			}
		}
		element_collection = (_vala_array_free (element_collection, element_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp16_ = self->priv->disable_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp16_, index > 0);
	_tmp17_ = self->priv->preview_box;
	gtk_widget_show_all ((GtkWidget*) _tmp17_);
}

static void
pomodoro_preferences_keyboard_shortcut_page_on_disable_clicked (PomodoroPreferencesKeyboardShortcutPage* self)
{
	PomodoroAccelerator* _tmp0_;
	GSettings* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_accelerator;
	pomodoro_accelerator_unset (_tmp0_);
	_tmp1_ = self->priv->settings;
	g_settings_apply (_tmp1_);
}

static void
_pomodoro_preferences_keyboard_shortcut_page_on_disable_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                                    gpointer self)
{
	pomodoro_preferences_keyboard_shortcut_page_on_disable_clicked ((PomodoroPreferencesKeyboardShortcutPage*) self);
}

static void
pomodoro_preferences_keyboard_shortcut_page_on_accelerator_changed (PomodoroPreferencesKeyboardShortcutPage* self)
{
	g_return_if_fail (self != NULL);
	pomodoro_preferences_keyboard_shortcut_page_validate_accelerator (self);
	pomodoro_preferences_keyboard_shortcut_page_update_preview (self);
}

static gboolean
pomodoro_preferences_keyboard_shortcut_page_on_key_press_event (PomodoroPreferencesKeyboardShortcutPage* self,
                                                                GdkEventKey* event)
{
	PomodoroAccelerator* _tmp4_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	switch (event->keyval) {
		case GDK_KEY_Tab:
		case GDK_KEY_space:
		case GDK_KEY_Return:
		{
			result = GTK_WIDGET_CLASS (pomodoro_preferences_keyboard_shortcut_page_parent_class)->key_press_event ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_box_get_type (), GtkBox), event);
			return result;
		}
		case GDK_KEY_BackSpace:
		{
			GSettings* _tmp0_;
			gboolean _tmp1_;
			gboolean _tmp2_;
			_tmp0_ = self->priv->settings;
			_tmp1_ = g_settings_get_has_unapplied (_tmp0_);
			_tmp2_ = _tmp1_;
			if (!_tmp2_) {
				pomodoro_preferences_keyboard_shortcut_page_on_disable_clicked (self);
			}
			result = TRUE;
			return result;
		}
		case GDK_KEY_Escape:
		{
			GActionGroup* _tmp3_;
			_tmp3_ = gtk_widget_get_action_group ((GtkWidget*) self, "win");
			g_action_group_activate_action (_tmp3_, "back", NULL);
			result = TRUE;
			return result;
		}
		default:
		break;
	}
	_tmp4_ = self->priv->_accelerator;
	pomodoro_accelerator_set_keyval (_tmp4_, event->keyval, event->state);
	result = TRUE;
	return result;
}

static gboolean
pomodoro_preferences_keyboard_shortcut_page_on_key_release_event (PomodoroPreferencesKeyboardShortcutPage* self,
                                                                  GdkEventKey* event)
{
	gboolean _tmp0_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	switch (event->keyval) {
		case GDK_KEY_Tab:
		case GDK_KEY_space:
		case GDK_KEY_Return:
		case GDK_KEY_BackSpace:
		{
			result = TRUE;
			return result;
		}
		default:
		break;
	}
	if (event->state == 0) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = event->length == 0;
	}
	if (_tmp0_) {
		{
			PomodoroAccelerator* _tmp1_;
			GSettings* _tmp3_;
			_tmp1_ = self->priv->_accelerator;
			pomodoro_accelerator_validate (_tmp1_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gboolean _tmp2_ = FALSE;
				if (_inner_error0_->domain == POMODORO_ACCELERATOR_ERROR) {
					goto __catch0_pomodoro_accelerator_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp2_;
			}
			_tmp3_ = self->priv->settings;
			g_settings_apply (_tmp3_);
		}
		goto __finally0;
		__catch0_pomodoro_accelerator_error:
		{
			GSettings* _tmp4_;
			g_clear_error (&_inner_error0_);
			_tmp4_ = self->priv->settings;
			g_settings_revert (_tmp4_);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp5_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp5_;
		}
	}
	result = TRUE;
	return result;
}

static gboolean
pomodoro_preferences_keyboard_shortcut_page_on_focus_out_event (PomodoroPreferencesKeyboardShortcutPage* self,
                                                                GdkEventFocus* event)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	GSettings* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = gtk_widget_get_visible ((GtkWidget*) self);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		result = FALSE;
		return result;
	}
	_tmp2_ = self->priv->settings;
	g_settings_revert (_tmp2_);
	result = TRUE;
	return result;
}

static gboolean
_pomodoro_preferences_keyboard_shortcut_page_on_key_press_event_gtk_widget_key_press_event (GtkWidget* _sender,
                                                                                            GdkEventKey* event,
                                                                                            gpointer self)
{
	gboolean result;
	result = pomodoro_preferences_keyboard_shortcut_page_on_key_press_event ((PomodoroPreferencesKeyboardShortcutPage*) self, event);
	return result;
}

static gboolean
_pomodoro_preferences_keyboard_shortcut_page_on_key_release_event_gtk_widget_key_release_event (GtkWidget* _sender,
                                                                                                GdkEventKey* event,
                                                                                                gpointer self)
{
	gboolean result;
	result = pomodoro_preferences_keyboard_shortcut_page_on_key_release_event ((PomodoroPreferencesKeyboardShortcutPage*) self, event);
	return result;
}

static gboolean
_pomodoro_preferences_keyboard_shortcut_page_on_focus_out_event_gtk_widget_focus_out_event (GtkWidget* _sender,
                                                                                            GdkEventFocus* event,
                                                                                            gpointer self)
{
	gboolean result;
	result = pomodoro_preferences_keyboard_shortcut_page_on_focus_out_event ((PomodoroPreferencesKeyboardShortcutPage*) self, event);
	return result;
}

static void
pomodoro_preferences_keyboard_shortcut_page_real_map (GtkWidget* base)
{
	PomodoroPreferencesKeyboardShortcutPage * self;
	GtkWidget* toplevel = NULL;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	PomodoroApplication* application = NULL;
	PomodoroApplication* _tmp8_;
	PomodoroApplication* _tmp9_;
	PomodoroCapabilityManager* _tmp10_;
	self = (PomodoroPreferencesKeyboardShortcutPage*) base;
	GTK_WIDGET_CLASS (pomodoro_preferences_keyboard_shortcut_page_parent_class)->map ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_box_get_type (), GtkBox));
	_tmp0_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	toplevel = _tmp1_;
	if (self->priv->key_press_event_id == ((gulong) 0)) {
		GtkWidget* _tmp2_;
		gulong _tmp3_;
		_tmp2_ = toplevel;
		_tmp3_ = g_signal_connect_object (_tmp2_, "key-press-event", (GCallback) _pomodoro_preferences_keyboard_shortcut_page_on_key_press_event_gtk_widget_key_press_event, self, 0);
		self->priv->key_press_event_id = _tmp3_;
	}
	if (self->priv->key_release_event_id == ((gulong) 0)) {
		GtkWidget* _tmp4_;
		gulong _tmp5_;
		_tmp4_ = toplevel;
		_tmp5_ = g_signal_connect_object (_tmp4_, "key-release-event", (GCallback) _pomodoro_preferences_keyboard_shortcut_page_on_key_release_event_gtk_widget_key_release_event, self, 0);
		self->priv->key_release_event_id = _tmp5_;
	}
	if (self->priv->focus_out_event_id == ((gulong) 0)) {
		GtkWidget* _tmp6_;
		gulong _tmp7_;
		_tmp6_ = toplevel;
		_tmp7_ = g_signal_connect_object (_tmp6_, "focus-out-event", (GCallback) _pomodoro_preferences_keyboard_shortcut_page_on_focus_out_event_gtk_widget_focus_out_event, self, 0);
		self->priv->focus_out_event_id = _tmp7_;
	}
	_tmp8_ = pomodoro_application_get_default ();
	_tmp9_ = _g_object_ref0 (_tmp8_);
	application = _tmp9_;
	_tmp10_ = application->capabilities;
	pomodoro_capability_manager_disable (_tmp10_, "accelerator");
	_g_object_unref0 (application);
	_g_object_unref0 (toplevel);
}

static void
pomodoro_preferences_keyboard_shortcut_page_real_unmap (GtkWidget* base)
{
	PomodoroPreferencesKeyboardShortcutPage * self;
	GtkWidget* toplevel = NULL;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	PomodoroApplication* application = NULL;
	PomodoroApplication* _tmp8_;
	PomodoroApplication* _tmp9_;
	PomodoroCapabilityManager* _tmp10_;
	self = (PomodoroPreferencesKeyboardShortcutPage*) base;
	GTK_WIDGET_CLASS (pomodoro_preferences_keyboard_shortcut_page_parent_class)->unmap ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_box_get_type (), GtkBox));
	_tmp0_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	toplevel = _tmp1_;
	if (self->priv->key_press_event_id != ((gulong) 0)) {
		GtkWidget* _tmp2_;
		guint _tmp3_;
		_tmp2_ = toplevel;
		g_signal_parse_name ("key-press-event", gtk_widget_get_type (), &_tmp3_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _pomodoro_preferences_keyboard_shortcut_page_on_key_press_event_gtk_widget_key_press_event, self);
		self->priv->key_press_event_id = (gulong) 0;
	}
	if (self->priv->key_release_event_id != ((gulong) 0)) {
		GtkWidget* _tmp4_;
		guint _tmp5_;
		_tmp4_ = toplevel;
		g_signal_parse_name ("key-release-event", gtk_widget_get_type (), &_tmp5_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _pomodoro_preferences_keyboard_shortcut_page_on_key_release_event_gtk_widget_key_release_event, self);
		self->priv->key_release_event_id = (gulong) 0;
	}
	if (self->priv->focus_out_event_id != ((gulong) 0)) {
		GtkWidget* _tmp6_;
		guint _tmp7_;
		_tmp6_ = toplevel;
		g_signal_parse_name ("focus-out-event", gtk_widget_get_type (), &_tmp7_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp6_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _pomodoro_preferences_keyboard_shortcut_page_on_focus_out_event_gtk_widget_focus_out_event, self);
	}
	_tmp8_ = pomodoro_application_get_default ();
	_tmp9_ = _g_object_ref0 (_tmp8_);
	application = _tmp9_;
	_tmp10_ = application->capabilities;
	pomodoro_capability_manager_enable (_tmp10_, "accelerator");
	_g_object_unref0 (application);
	_g_object_unref0 (toplevel);
}

PomodoroPreferencesKeyboardShortcutPage*
pomodoro_preferences_keyboard_shortcut_page_construct (GType object_type)
{
	PomodoroPreferencesKeyboardShortcutPage * self = NULL;
	self = (PomodoroPreferencesKeyboardShortcutPage*) g_object_new (object_type, NULL);
	return self;
}

PomodoroPreferencesKeyboardShortcutPage*
pomodoro_preferences_keyboard_shortcut_page_new (void)
{
	return pomodoro_preferences_keyboard_shortcut_page_construct (POMODORO_TYPE_PREFERENCES_KEYBOARD_SHORTCUT_PAGE);
}

static PomodoroAccelerator*
pomodoro_preferences_keyboard_shortcut_page_get_accelerator (PomodoroPreferencesKeyboardShortcutPage* self)
{
	PomodoroAccelerator* result;
	PomodoroAccelerator* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_accelerator;
	result = _tmp0_;
	return result;
}

static void
pomodoro_preferences_keyboard_shortcut_page_set_accelerator (PomodoroPreferencesKeyboardShortcutPage* self,
                                                             PomodoroAccelerator* value)
{
	PomodoroAccelerator* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_accelerator);
	self->priv->_accelerator = _tmp0_;
}

static void
_pomodoro_preferences_keyboard_shortcut_page_on_accelerator_changed_pomodoro_accelerator_changed (PomodoroAccelerator* _sender,
                                                                                                  gpointer self)
{
	pomodoro_preferences_keyboard_shortcut_page_on_accelerator_changed ((PomodoroPreferencesKeyboardShortcutPage*) self);
}

static GObject *
pomodoro_preferences_keyboard_shortcut_page_constructor (GType type,
                                                         guint n_construct_properties,
                                                         GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PomodoroPreferencesKeyboardShortcutPage * self;
	PomodoroAccelerator* _tmp0_;
	PomodoroAccelerator* _tmp1_;
	PomodoroAccelerator* _tmp2_;
	GSettings* _tmp3_;
	GSettings* _tmp4_;
	GSettings* _tmp5_;
	GSettings* _tmp6_;
	PomodoroAccelerator* _tmp7_;
	parent_class = G_OBJECT_CLASS (pomodoro_preferences_keyboard_shortcut_page_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, POMODORO_TYPE_PREFERENCES_KEYBOARD_SHORTCUT_PAGE, PomodoroPreferencesKeyboardShortcutPage);
	_tmp0_ = pomodoro_accelerator_new ();
	_tmp1_ = _tmp0_;
	pomodoro_preferences_keyboard_shortcut_page_set_accelerator (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = self->priv->_accelerator;
	g_signal_connect_object (_tmp2_, "changed", (GCallback) _pomodoro_preferences_keyboard_shortcut_page_on_accelerator_changed_pomodoro_accelerator_changed, self, 0);
	_tmp3_ = pomodoro_get_settings ();
	_tmp4_ = g_settings_get_child (_tmp3_, "preferences");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp4_;
	_tmp5_ = self->priv->settings;
	g_settings_delay (_tmp5_);
	_tmp6_ = self->priv->settings;
	_tmp7_ = self->priv->_accelerator;
	g_settings_bind_with_mapping (_tmp6_, "toggle-timer-key", (GObject*) _tmp7_, "name", G_SETTINGS_BIND_DEFAULT, (GSettingsBindGetMapping) pomodoro_get_accelerator_mapping, (GSettingsBindSetMapping) pomodoro_set_accelerator_mapping, NULL, NULL);
	pomodoro_preferences_keyboard_shortcut_page_on_accelerator_changed (self);
	return obj;
}

static void
pomodoro_preferences_keyboard_shortcut_page_class_init (PomodoroPreferencesKeyboardShortcutPageClass * klass,
                                                        gpointer klass_data)
{
	pomodoro_preferences_keyboard_shortcut_page_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PomodoroPreferencesKeyboardShortcutPage_private_offset);
	((GtkWidgetClass *) klass)->map = (void (*) (GtkWidget*)) pomodoro_preferences_keyboard_shortcut_page_real_map;
	((GtkWidgetClass *) klass)->unmap = (void (*) (GtkWidget*)) pomodoro_preferences_keyboard_shortcut_page_real_unmap;
	G_OBJECT_CLASS (klass)->get_property = _vala_pomodoro_preferences_keyboard_shortcut_page_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_pomodoro_preferences_keyboard_shortcut_page_set_property;
	G_OBJECT_CLASS (klass)->constructor = pomodoro_preferences_keyboard_shortcut_page_constructor;
	G_OBJECT_CLASS (klass)->finalize = pomodoro_preferences_keyboard_shortcut_page_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/pomodoro/preferences-keyboard-shortcut-page.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "preview_box", FALSE, PomodoroPreferencesKeyboardShortcutPage_private_offset + G_STRUCT_OFFSET (PomodoroPreferencesKeyboardShortcutPagePrivate, preview_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "disable_button", FALSE, PomodoroPreferencesKeyboardShortcutPage_private_offset + G_STRUCT_OFFSET (PomodoroPreferencesKeyboardShortcutPagePrivate, disable_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "error_label", FALSE, PomodoroPreferencesKeyboardShortcutPage_private_offset + G_STRUCT_OFFSET (PomodoroPreferencesKeyboardShortcutPagePrivate, error_label));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_disable_clicked", G_CALLBACK(_pomodoro_preferences_keyboard_shortcut_page_on_disable_clicked_gtk_button_clicked));
}

static void
pomodoro_preferences_keyboard_shortcut_page_gtk_buildable_interface_init (GtkBuildableIface * iface,
                                                                          gpointer iface_data)
{
	pomodoro_preferences_keyboard_shortcut_page_gtk_buildable_parent_iface = g_type_interface_peek_parent (iface);
}

static void
pomodoro_preferences_keyboard_shortcut_page_pomodoro_preferences_page_interface_init (PomodoroPreferencesPageIface * iface,
                                                                                      gpointer iface_data)
{
	pomodoro_preferences_keyboard_shortcut_page_pomodoro_preferences_page_parent_iface = g_type_interface_peek_parent (iface);
}

static void
pomodoro_preferences_keyboard_shortcut_page_instance_init (PomodoroPreferencesKeyboardShortcutPage * self,
                                                           gpointer klass)
{
	self->priv = pomodoro_preferences_keyboard_shortcut_page_get_instance_private (self);
	self->priv->key_press_event_id = (gulong) 0;
	self->priv->key_release_event_id = (gulong) 0;
	self->priv->focus_out_event_id = (gulong) 0;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
pomodoro_preferences_keyboard_shortcut_page_finalize (GObject * obj)
{
	PomodoroPreferencesKeyboardShortcutPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, POMODORO_TYPE_PREFERENCES_KEYBOARD_SHORTCUT_PAGE, PomodoroPreferencesKeyboardShortcutPage);
	_g_object_unref0 (self->priv->_accelerator);
	_g_object_unref0 (self->priv->settings);
	G_OBJECT_CLASS (pomodoro_preferences_keyboard_shortcut_page_parent_class)->finalize (obj);
}

static GType
pomodoro_preferences_keyboard_shortcut_page_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PomodoroPreferencesKeyboardShortcutPageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pomodoro_preferences_keyboard_shortcut_page_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PomodoroPreferencesKeyboardShortcutPage), 0, (GInstanceInitFunc) pomodoro_preferences_keyboard_shortcut_page_instance_init, NULL };
	static const GInterfaceInfo gtk_buildable_info = { (GInterfaceInitFunc) pomodoro_preferences_keyboard_shortcut_page_gtk_buildable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo pomodoro_preferences_page_info = { (GInterfaceInitFunc) pomodoro_preferences_keyboard_shortcut_page_pomodoro_preferences_page_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType pomodoro_preferences_keyboard_shortcut_page_type_id;
	pomodoro_preferences_keyboard_shortcut_page_type_id = g_type_register_static (gtk_box_get_type (), "PomodoroPreferencesKeyboardShortcutPage", &g_define_type_info, 0);
	g_type_add_interface_static (pomodoro_preferences_keyboard_shortcut_page_type_id, gtk_buildable_get_type (), &gtk_buildable_info);
	g_type_add_interface_static (pomodoro_preferences_keyboard_shortcut_page_type_id, POMODORO_TYPE_PREFERENCES_PAGE, &pomodoro_preferences_page_info);
	PomodoroPreferencesKeyboardShortcutPage_private_offset = g_type_add_instance_private (pomodoro_preferences_keyboard_shortcut_page_type_id, sizeof (PomodoroPreferencesKeyboardShortcutPagePrivate));
	return pomodoro_preferences_keyboard_shortcut_page_type_id;
}

GType
pomodoro_preferences_keyboard_shortcut_page_get_type (void)
{
	static volatile gsize pomodoro_preferences_keyboard_shortcut_page_type_id__once = 0;
	if (g_once_init_enter (&pomodoro_preferences_keyboard_shortcut_page_type_id__once)) {
		GType pomodoro_preferences_keyboard_shortcut_page_type_id;
		pomodoro_preferences_keyboard_shortcut_page_type_id = pomodoro_preferences_keyboard_shortcut_page_get_type_once ();
		g_once_init_leave (&pomodoro_preferences_keyboard_shortcut_page_type_id__once, pomodoro_preferences_keyboard_shortcut_page_type_id);
	}
	return pomodoro_preferences_keyboard_shortcut_page_type_id__once;
}

static void
_vala_pomodoro_preferences_keyboard_shortcut_page_get_property (GObject * object,
                                                                guint property_id,
                                                                GValue * value,
                                                                GParamSpec * pspec)
{
	PomodoroPreferencesKeyboardShortcutPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, POMODORO_TYPE_PREFERENCES_KEYBOARD_SHORTCUT_PAGE, PomodoroPreferencesKeyboardShortcutPage);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_pomodoro_preferences_keyboard_shortcut_page_set_property (GObject * object,
                                                                guint property_id,
                                                                const GValue * value,
                                                                GParamSpec * pspec)
{
	PomodoroPreferencesKeyboardShortcutPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, POMODORO_TYPE_PREFERENCES_KEYBOARD_SHORTCUT_PAGE, PomodoroPreferencesKeyboardShortcutPage);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
pomodoro_preferences_plugins_page_get_instance_private (PomodoroPreferencesPluginsPage* self)
{
	return G_STRUCT_MEMBER_P (self, PomodoroPreferencesPluginsPage_private_offset);
}

static gint
pomodoro_preferences_plugins_page_list_box_sort_func (GtkListBoxRow* row1,
                                                      GtkListBoxRow* row2)
{
	gchar* name1 = NULL;
	gconstpointer _tmp0_;
	gchar* _tmp1_;
	gchar* name2 = NULL;
	gconstpointer _tmp2_;
	gchar* _tmp3_;
	GCompareFunc _tmp4_;
	gint result;
	g_return_val_if_fail (row1 != NULL, 0);
	g_return_val_if_fail (row2 != NULL, 0);
	_tmp0_ = g_object_get_data ((GObject*) row1, "name");
	_tmp1_ = g_strdup ((const gchar*) _tmp0_);
	name1 = _tmp1_;
	_tmp2_ = g_object_get_data ((GObject*) row2, "name");
	_tmp3_ = g_strdup ((const gchar*) _tmp2_);
	name2 = _tmp3_;
	_tmp4_ = ((GCompareFunc) g_strcmp0);
	result = _tmp4_ (name1, name2);
	_g_free0 (name2);
	_g_free0 (name1);
	return result;
}

static PeasPluginInfo*
_vala_PeasPluginInfo_copy (PeasPluginInfo* self)
{
	return g_boxed_copy (peas_plugin_info_get_type (), self);
}

static gpointer
__vala_PeasPluginInfo_copy0 (gpointer self)
{
	return self ? _vala_PeasPluginInfo_copy (self) : NULL;
}

static void
_vala_PeasPluginInfo_free (PeasPluginInfo* self)
{
	g_boxed_free (peas_plugin_info_get_type (), self);
}

static void
pomodoro_preferences_plugins_page_on_settings_changed (PomodoroPreferencesPluginsPage* self,
                                                       GSettings* settings,
                                                       const gchar* key)
{
	PeasEngine* _tmp0_;
	GList* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (settings != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = self->priv->engine;
	_tmp1_ = peas_engine_get_plugin_list (_tmp0_);
	{
		GList* plugin_info_collection = NULL;
		GList* plugin_info_it = NULL;
		plugin_info_collection = _tmp1_;
		for (plugin_info_it = plugin_info_collection; plugin_info_it != NULL; plugin_info_it = plugin_info_it->next) {
			PeasPluginInfo* _tmp2_;
			PeasPluginInfo* plugin_info = NULL;
			_tmp2_ = __vala_PeasPluginInfo_copy0 ((PeasPluginInfo*) plugin_info_it->data);
			plugin_info = _tmp2_;
			{
				GtkSwitch* toggle = NULL;
				GHashTable* _tmp3_;
				PeasPluginInfo* _tmp4_;
				const gchar* _tmp5_;
				gconstpointer _tmp6_;
				GtkSwitch* _tmp7_;
				gboolean enabled = FALSE;
				GtkSwitch* _tmp8_;
				_tmp3_ = self->priv->toggles;
				_tmp4_ = plugin_info;
				_tmp5_ = peas_plugin_info_get_module_name (_tmp4_);
				_tmp6_ = g_hash_table_lookup (_tmp3_, _tmp5_);
				_tmp7_ = _g_object_ref0 ((GtkSwitch*) _tmp6_);
				toggle = _tmp7_;
				enabled = FALSE;
				_tmp8_ = toggle;
				if (_tmp8_ != NULL) {
					PeasPluginInfo* _tmp9_;
					const gchar* _tmp10_;
					GtkSwitch* _tmp11_;
					gboolean _tmp12_;
					gboolean _tmp13_;
					_tmp9_ = plugin_info;
					_tmp10_ = peas_plugin_info_get_module_name (_tmp9_);
					enabled = pomodoro_preferences_plugins_page_get_plugin_enabled (self, _tmp10_);
					_tmp11_ = toggle;
					_tmp12_ = gtk_switch_get_state (_tmp11_);
					_tmp13_ = _tmp12_;
					if (_tmp13_ != enabled) {
						GtkSwitch* _tmp14_;
						_tmp14_ = toggle;
						gtk_switch_set_state (_tmp14_, enabled);
					}
				}
				_g_object_unref0 (toggle);
				__vala_PeasPluginInfo_free0 (plugin_info);
			}
		}
	}
}

static gboolean
pomodoro_preferences_plugins_page_get_plugin_enabled (PomodoroPreferencesPluginsPage* self,
                                                      const gchar* name)
{
	gchar** enabled_plugins = NULL;
	GSettings* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint enabled_plugins_length1;
	gint _enabled_plugins_size_;
	gboolean enabled_in_settings = FALSE;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	_tmp0_ = self->priv->settings;
	_tmp2_ = _tmp1_ = g_settings_get_strv (_tmp0_, "enabled-plugins");
	enabled_plugins = _tmp2_;
	enabled_plugins_length1 = _vala_array_length (_tmp1_);
	_enabled_plugins_size_ = enabled_plugins_length1;
	enabled_in_settings = FALSE;
	_tmp3_ = enabled_plugins;
	_tmp3__length1 = enabled_plugins_length1;
	{
		gchar** plugin_name_collection = NULL;
		gint plugin_name_collection_length1 = 0;
		gint _plugin_name_collection_size_ = 0;
		gint plugin_name_it = 0;
		plugin_name_collection = _tmp3_;
		plugin_name_collection_length1 = _tmp3__length1;
		for (plugin_name_it = 0; plugin_name_it < plugin_name_collection_length1; plugin_name_it = plugin_name_it + 1) {
			gchar* _tmp4_;
			gchar* plugin_name = NULL;
			_tmp4_ = g_strdup (plugin_name_collection[plugin_name_it]);
			plugin_name = _tmp4_;
			{
				const gchar* _tmp5_;
				_tmp5_ = plugin_name;
				if (g_strcmp0 (_tmp5_, name) == 0) {
					enabled_in_settings = TRUE;
					_g_free0 (plugin_name);
					break;
				}
				_g_free0 (plugin_name);
			}
		}
	}
	result = enabled_in_settings;
	enabled_plugins = (_vala_array_free (enabled_plugins, enabled_plugins_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static void
_vala_array_add7 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add8 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
pomodoro_preferences_plugins_page_set_plugin_enabled (PomodoroPreferencesPluginsPage* self,
                                                      const gchar* name,
                                                      gboolean value)
{
	gchar** enabled_plugins = NULL;
	GSettings* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint enabled_plugins_length1;
	gint _enabled_plugins_size_;
	gboolean enabled_in_settings = FALSE;
	gchar** tmp = NULL;
	gchar** _tmp3_;
	gint tmp_length1;
	gint _tmp_size_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = self->priv->settings;
	_tmp2_ = _tmp1_ = g_settings_get_strv (_tmp0_, "enabled-plugins");
	enabled_plugins = _tmp2_;
	enabled_plugins_length1 = _vala_array_length (_tmp1_);
	_enabled_plugins_size_ = enabled_plugins_length1;
	enabled_in_settings = FALSE;
	_tmp3_ = g_new0 (gchar*, 0 + 1);
	tmp = _tmp3_;
	tmp_length1 = 0;
	_tmp_size_ = tmp_length1;
	_tmp4_ = enabled_plugins;
	_tmp4__length1 = enabled_plugins_length1;
	{
		gchar** plugin_name_collection = NULL;
		gint plugin_name_collection_length1 = 0;
		gint _plugin_name_collection_size_ = 0;
		gint plugin_name_it = 0;
		plugin_name_collection = _tmp4_;
		plugin_name_collection_length1 = _tmp4__length1;
		for (plugin_name_it = 0; plugin_name_it < plugin_name_collection_length1; plugin_name_it = plugin_name_it + 1) {
			gchar* _tmp5_;
			gchar* plugin_name = NULL;
			_tmp5_ = g_strdup (plugin_name_collection[plugin_name_it]);
			plugin_name = _tmp5_;
			{
				const gchar* _tmp6_;
				_tmp6_ = plugin_name;
				if (g_strcmp0 (_tmp6_, name) == 0) {
					enabled_in_settings = TRUE;
				} else {
					const gchar* _tmp7_;
					gchar* _tmp8_;
					_tmp7_ = plugin_name;
					_tmp8_ = g_strdup (_tmp7_);
					_vala_array_add7 (&tmp, &tmp_length1, &_tmp_size_, _tmp8_);
				}
				_g_free0 (plugin_name);
			}
		}
	}
	if (value) {
		gchar* _tmp9_;
		_tmp9_ = g_strdup (name);
		_vala_array_add8 (&tmp, &tmp_length1, &_tmp_size_, _tmp9_);
	}
	if (enabled_in_settings != value) {
		GSettings* _tmp10_;
		gchar** _tmp11_;
		gint _tmp11__length1;
		_tmp10_ = self->priv->settings;
		_tmp11_ = tmp;
		_tmp11__length1 = tmp_length1;
		g_settings_set_strv (_tmp10_, "enabled-plugins", _tmp11_);
	}
	tmp = (_vala_array_free (tmp, tmp_length1, (GDestroyNotify) g_free), NULL);
	enabled_plugins = (_vala_array_free (enabled_plugins, enabled_plugins_length1, (GDestroyNotify) g_free), NULL);
}

static Block9Data*
block9_data_ref (Block9Data* _data9_)
{
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}

static void
block9_data_unref (void * _userdata_)
{
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		PomodoroPreferencesPluginsPage* self;
		self = _data9_->self;
		_g_object_unref0 (_data9_->toggle);
		__vala_PeasPluginInfo_free0 (_data9_->plugin_info);
		_g_object_unref0 (self);
		g_slice_free (Block9Data, _data9_);
	}
}

static void
__lambda24_ (Block9Data* _data9_)
{
	PomodoroPreferencesPluginsPage* self;
	const gchar* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	self = _data9_->self;
	_tmp0_ = peas_plugin_info_get_module_name (_data9_->plugin_info);
	_tmp1_ = gtk_switch_get_active (_data9_->toggle);
	_tmp2_ = _tmp1_;
	pomodoro_preferences_plugins_page_set_plugin_enabled (self, _tmp0_, _tmp2_);
}

static void
___lambda24__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda24_ (self);
}

static gboolean
__lambda25_ (Block9Data* _data9_,
             gboolean state)
{
	PomodoroPreferencesPluginsPage* self;
	gboolean success = FALSE;
	gboolean result;
	self = _data9_->self;
	success = state == peas_plugin_info_is_loaded (_data9_->plugin_info);
	result = !success;
	return result;
}

static gboolean
___lambda25__gtk_switch_state_set (GtkSwitch* _sender,
                                   gboolean state,
                                   gpointer self)
{
	gboolean result;
	result = __lambda25_ (self, state);
	return result;
}

static GtkListBoxRow*
pomodoro_preferences_plugins_page_create_row (PomodoroPreferencesPluginsPage* self,
                                              PeasPluginInfo* plugin_info)
{
	Block9Data* _data9_;
	PeasPluginInfo* _tmp0_;
	GtkLabel* name_label = NULL;
	const gchar* _tmp1_;
	GtkLabel* _tmp2_;
	GtkStyleContext* _tmp3_;
	GtkLabel* description_label = NULL;
	const gchar* _tmp4_;
	GtkLabel* _tmp5_;
	GtkStyleContext* _tmp6_;
	GtkStyleContext* _tmp7_;
	GtkSwitch* _tmp8_;
	GHashTable* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	GtkBox* vbox = NULL;
	GtkBox* _tmp12_;
	GtkBox* hbox = NULL;
	GtkBox* _tmp13_;
	GtkListBoxRow* row = NULL;
	GtkListBoxRow* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	GtkListBoxRow* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (plugin_info != NULL, NULL);
	_data9_ = g_slice_new0 (Block9Data);
	_data9_->_ref_count_ = 1;
	_data9_->self = g_object_ref (self);
	_tmp0_ = __vala_PeasPluginInfo_copy0 (plugin_info);
	__vala_PeasPluginInfo_free0 (_data9_->plugin_info);
	_data9_->plugin_info = _tmp0_;
	_tmp1_ = peas_plugin_info_get_name (_data9_->plugin_info);
	_tmp2_ = (GtkLabel*) gtk_label_new (_tmp1_);
	g_object_ref_sink (_tmp2_);
	name_label = _tmp2_;
	_tmp3_ = gtk_widget_get_style_context ((GtkWidget*) name_label);
	gtk_style_context_add_class (_tmp3_, "pomodoro-plugin-name");
	gtk_widget_set_halign ((GtkWidget*) name_label, GTK_ALIGN_START);
	_tmp4_ = peas_plugin_info_get_description (_data9_->plugin_info);
	_tmp5_ = (GtkLabel*) gtk_label_new (_tmp4_);
	g_object_ref_sink (_tmp5_);
	description_label = _tmp5_;
	_tmp6_ = gtk_widget_get_style_context ((GtkWidget*) description_label);
	gtk_style_context_add_class (_tmp6_, "dim-label");
	_tmp7_ = gtk_widget_get_style_context ((GtkWidget*) description_label);
	gtk_style_context_add_class (_tmp7_, "pomodoro-plugin-description");
	gtk_widget_set_halign ((GtkWidget*) description_label, GTK_ALIGN_START);
	_tmp8_ = (GtkSwitch*) gtk_switch_new ();
	g_object_ref_sink (_tmp8_);
	_data9_->toggle = _tmp8_;
	gtk_widget_set_valign ((GtkWidget*) _data9_->toggle, GTK_ALIGN_CENTER);
	gtk_switch_set_state (_data9_->toggle, peas_plugin_info_is_loaded (_data9_->plugin_info));
	g_signal_connect_data ((GObject*) _data9_->toggle, "notify::active", (GCallback) ___lambda24__g_object_notify, block9_data_ref (_data9_), (GClosureNotify) block9_data_unref, 0);
	g_signal_connect_data (_data9_->toggle, "state-set", (GCallback) ___lambda25__gtk_switch_state_set, block9_data_ref (_data9_), (GClosureNotify) block9_data_unref, 0);
	_tmp9_ = self->priv->toggles;
	_tmp10_ = peas_plugin_info_get_module_name (_data9_->plugin_info);
	_tmp11_ = g_strdup (_tmp10_);
	g_hash_table_insert (_tmp9_, _tmp11_, _data9_->toggle);
	_tmp12_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp12_);
	vbox = _tmp12_;
	gtk_box_pack_start (vbox, (GtkWidget*) name_label, FALSE, FALSE, (guint) 0);
	gtk_box_pack_start (vbox, (GtkWidget*) description_label, FALSE, FALSE, (guint) 0);
	_tmp13_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 30);
	g_object_ref_sink (_tmp13_);
	hbox = _tmp13_;
	gtk_box_pack_start (hbox, (GtkWidget*) vbox, TRUE, TRUE, (guint) 0);
	gtk_box_pack_start (hbox, (GtkWidget*) _data9_->toggle, FALSE, TRUE, (guint) 0);
	_tmp14_ = (GtkListBoxRow*) gtk_list_box_row_new ();
	g_object_ref_sink (_tmp14_);
	row = _tmp14_;
	_tmp15_ = peas_plugin_info_get_name (_data9_->plugin_info);
	_tmp16_ = g_strdup (_tmp15_);
	g_object_set_data_full ((GObject*) row, "name", _tmp16_, g_free);
	gtk_list_box_row_set_activatable (row, FALSE);
	gtk_container_add ((GtkContainer*) row, (GtkWidget*) hbox);
	gtk_widget_show_all ((GtkWidget*) row);
	result = row;
	_g_object_unref0 (hbox);
	_g_object_unref0 (vbox);
	_g_object_unref0 (description_label);
	_g_object_unref0 (name_label);
	block9_data_unref (_data9_);
	_data9_ = NULL;
	return result;
}

static gboolean
pomodoro_preferences_plugins_page_is_legacy_plugin (PomodoroPreferencesPluginsPage* self,
                                                    const gchar* plugin_name)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (plugin_name != NULL, FALSE);
	{
		const gchar** name_collection = NULL;
		gint name_collection_length1 = 0;
		gint _name_collection_size_ = 0;
		gint name_it = 0;
		name_collection = POMODORO_APPLICATION_LEGACY_PLUGINS;
		name_collection_length1 = G_N_ELEMENTS (POMODORO_APPLICATION_LEGACY_PLUGINS);
		for (name_it = 0; name_it < name_collection_length1; name_it = name_it + 1) {
			const gchar* name = NULL;
			name = name_collection[name_it];
			{
				const gchar* _tmp0_;
				_tmp0_ = name;
				if (g_strcmp0 (_tmp0_, plugin_name) == 0) {
					result = TRUE;
					return result;
				}
			}
		}
	}
	result = FALSE;
	return result;
}

static void
pomodoro_preferences_plugins_page_populate (PomodoroPreferencesPluginsPage* self)
{
	PeasEngine* _tmp0_;
	PeasEngine* _tmp1_;
	GList* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->engine;
	peas_engine_rescan_plugins (_tmp0_);
	_tmp1_ = self->priv->engine;
	_tmp2_ = peas_engine_get_plugin_list (_tmp1_);
	{
		GList* plugin_info_collection = NULL;
		GList* plugin_info_it = NULL;
		plugin_info_collection = _tmp2_;
		for (plugin_info_it = plugin_info_collection; plugin_info_it != NULL; plugin_info_it = plugin_info_it->next) {
			PeasPluginInfo* _tmp3_;
			PeasPluginInfo* plugin_info = NULL;
			_tmp3_ = __vala_PeasPluginInfo_copy0 ((PeasPluginInfo*) plugin_info_it->data);
			plugin_info = _tmp3_;
			{
				PeasPluginInfo* _tmp4_;
				PeasPluginInfo* _tmp5_;
				const gchar* _tmp6_;
				GtkListBoxRow* row = NULL;
				PeasPluginInfo* _tmp7_;
				GtkListBoxRow* _tmp8_;
				GtkListBox* _tmp9_;
				GtkListBoxRow* _tmp10_;
				_tmp4_ = plugin_info;
				if (peas_plugin_info_is_hidden (_tmp4_)) {
					__vala_PeasPluginInfo_free0 (plugin_info);
					continue;
				}
				_tmp5_ = plugin_info;
				_tmp6_ = peas_plugin_info_get_module_name (_tmp5_);
				if (pomodoro_preferences_plugins_page_is_legacy_plugin (self, _tmp6_)) {
					__vala_PeasPluginInfo_free0 (plugin_info);
					continue;
				}
				_tmp7_ = plugin_info;
				_tmp8_ = pomodoro_preferences_plugins_page_create_row (self, _tmp7_);
				row = _tmp8_;
				_tmp9_ = self->priv->plugins_listbox;
				_tmp10_ = row;
				gtk_list_box_insert (_tmp9_, (GtkWidget*) _tmp10_, -1);
				_g_object_unref0 (row);
				__vala_PeasPluginInfo_free0 (plugin_info);
			}
		}
	}
}

PomodoroPreferencesPluginsPage*
pomodoro_preferences_plugins_page_construct (GType object_type)
{
	PomodoroPreferencesPluginsPage * self = NULL;
	self = (PomodoroPreferencesPluginsPage*) g_object_new (object_type, NULL);
	return self;
}

PomodoroPreferencesPluginsPage*
pomodoro_preferences_plugins_page_new (void)
{
	return pomodoro_preferences_plugins_page_construct (POMODORO_TYPE_PREFERENCES_PLUGINS_PAGE);
}

static void
_pomodoro_preferences_plugins_page_on_settings_changed_g_settings_changed (GSettings* _sender,
                                                                           const gchar* key,
                                                                           gpointer self)
{
	pomodoro_preferences_plugins_page_on_settings_changed ((PomodoroPreferencesPluginsPage*) self, _sender, key);
}

static void
_pomodoro_list_box_separator_func_gtk_list_box_update_header_func (GtkListBoxRow* row,
                                                                   GtkListBoxRow* before,
                                                                   gpointer self)
{
	pomodoro_list_box_separator_func (row, before);
}

static gint
_pomodoro_preferences_plugins_page_list_box_sort_func_gtk_list_box_sort_func (GtkListBoxRow* row1,
                                                                              GtkListBoxRow* row2,
                                                                              gpointer self)
{
	gint result;
	result = pomodoro_preferences_plugins_page_list_box_sort_func (row1, row2);
	return result;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static GObject *
pomodoro_preferences_plugins_page_constructor (GType type,
                                               guint n_construct_properties,
                                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PomodoroPreferencesPluginsPage * self;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	PeasEngine* _tmp3_;
	PeasEngine* _tmp4_;
	GtkListBox* _tmp5_;
	GtkListBox* _tmp6_;
	GHashFunc _tmp7_;
	GEqualFunc _tmp8_;
	GHashTable* _tmp9_;
	parent_class = G_OBJECT_CLASS (pomodoro_preferences_plugins_page_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, POMODORO_TYPE_PREFERENCES_PLUGINS_PAGE, PomodoroPreferencesPluginsPage);
	_tmp0_ = pomodoro_get_settings ();
	_tmp1_ = g_settings_get_child (_tmp0_, "preferences");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp1_;
	_tmp2_ = self->priv->settings;
	g_signal_connect_object (_tmp2_, "changed::enabled-plugins", (GCallback) _pomodoro_preferences_plugins_page_on_settings_changed_g_settings_changed, self, 0);
	_tmp3_ = peas_engine_get_default ();
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (self->priv->engine);
	self->priv->engine = _tmp4_;
	_tmp5_ = self->priv->plugins_listbox;
	gtk_list_box_set_header_func (_tmp5_, _pomodoro_list_box_separator_func_gtk_list_box_update_header_func, NULL, NULL);
	_tmp6_ = self->priv->plugins_listbox;
	gtk_list_box_set_sort_func (_tmp6_, _pomodoro_preferences_plugins_page_list_box_sort_func_gtk_list_box_sort_func, NULL, NULL);
	_tmp7_ = g_str_hash;
	_tmp8_ = g_str_equal;
	_tmp9_ = g_hash_table_new_full (_tmp7_, _tmp8_, _g_free0_, NULL);
	_g_hash_table_unref0 (self->priv->toggles);
	self->priv->toggles = _tmp9_;
	pomodoro_preferences_plugins_page_populate (self);
	return obj;
}

static void
pomodoro_preferences_plugins_page_class_init (PomodoroPreferencesPluginsPageClass * klass,
                                              gpointer klass_data)
{
	pomodoro_preferences_plugins_page_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PomodoroPreferencesPluginsPage_private_offset);
	G_OBJECT_CLASS (klass)->constructor = pomodoro_preferences_plugins_page_constructor;
	G_OBJECT_CLASS (klass)->finalize = pomodoro_preferences_plugins_page_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/pomodoro/preferences-plugins-page.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "plugins_listbox", FALSE, PomodoroPreferencesPluginsPage_private_offset + G_STRUCT_OFFSET (PomodoroPreferencesPluginsPagePrivate, plugins_listbox));
}

static void
pomodoro_preferences_plugins_page_gtk_buildable_interface_init (GtkBuildableIface * iface,
                                                                gpointer iface_data)
{
	pomodoro_preferences_plugins_page_gtk_buildable_parent_iface = g_type_interface_peek_parent (iface);
}

static void
pomodoro_preferences_plugins_page_pomodoro_preferences_page_interface_init (PomodoroPreferencesPageIface * iface,
                                                                            gpointer iface_data)
{
	pomodoro_preferences_plugins_page_pomodoro_preferences_page_parent_iface = g_type_interface_peek_parent (iface);
}

static void
pomodoro_preferences_plugins_page_instance_init (PomodoroPreferencesPluginsPage * self,
                                                 gpointer klass)
{
	self->priv = pomodoro_preferences_plugins_page_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
pomodoro_preferences_plugins_page_finalize (GObject * obj)
{
	PomodoroPreferencesPluginsPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, POMODORO_TYPE_PREFERENCES_PLUGINS_PAGE, PomodoroPreferencesPluginsPage);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->engine);
	_g_hash_table_unref0 (self->priv->toggles);
	G_OBJECT_CLASS (pomodoro_preferences_plugins_page_parent_class)->finalize (obj);
}

static GType
pomodoro_preferences_plugins_page_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PomodoroPreferencesPluginsPageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pomodoro_preferences_plugins_page_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PomodoroPreferencesPluginsPage), 0, (GInstanceInitFunc) pomodoro_preferences_plugins_page_instance_init, NULL };
	static const GInterfaceInfo gtk_buildable_info = { (GInterfaceInitFunc) pomodoro_preferences_plugins_page_gtk_buildable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo pomodoro_preferences_page_info = { (GInterfaceInitFunc) pomodoro_preferences_plugins_page_pomodoro_preferences_page_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType pomodoro_preferences_plugins_page_type_id;
	pomodoro_preferences_plugins_page_type_id = g_type_register_static (gtk_scrolled_window_get_type (), "PomodoroPreferencesPluginsPage", &g_define_type_info, 0);
	g_type_add_interface_static (pomodoro_preferences_plugins_page_type_id, gtk_buildable_get_type (), &gtk_buildable_info);
	g_type_add_interface_static (pomodoro_preferences_plugins_page_type_id, POMODORO_TYPE_PREFERENCES_PAGE, &pomodoro_preferences_page_info);
	PomodoroPreferencesPluginsPage_private_offset = g_type_add_instance_private (pomodoro_preferences_plugins_page_type_id, sizeof (PomodoroPreferencesPluginsPagePrivate));
	return pomodoro_preferences_plugins_page_type_id;
}

GType
pomodoro_preferences_plugins_page_get_type (void)
{
	static volatile gsize pomodoro_preferences_plugins_page_type_id__once = 0;
	if (g_once_init_enter (&pomodoro_preferences_plugins_page_type_id__once)) {
		GType pomodoro_preferences_plugins_page_type_id;
		pomodoro_preferences_plugins_page_type_id = pomodoro_preferences_plugins_page_get_type_once ();
		g_once_init_leave (&pomodoro_preferences_plugins_page_type_id__once, pomodoro_preferences_plugins_page_type_id);
	}
	return pomodoro_preferences_plugins_page_type_id__once;
}

static inline gpointer
pomodoro_preferences_main_page_get_instance_private (PomodoroPreferencesMainPage* self)
{
	return G_STRUCT_MEMBER_P (self, PomodoroPreferencesMainPage_private_offset);
}

static Block10Data*
block10_data_ref (Block10Data* _data10_)
{
	g_atomic_int_inc (&_data10_->_ref_count_);
	return _data10_;
}

static void
block10_data_unref (void * _userdata_)
{
	Block10Data* _data10_;
	_data10_ = (Block10Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
		PomodoroPreferencesMainPage* self;
		self = _data10_->self;
		_g_object_unref0 (_data10_->label);
		_g_object_unref0 (_data10_->adjustment);
		_g_object_unref0 (self);
		g_slice_free (Block10Data, _data10_);
	}
}

static void
__lambda16_ (Block10Data* _data10_)
{
	PomodoroPreferencesMainPage* self;
	gdouble _tmp0_;
	gdouble _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	self = _data10_->self;
	_tmp0_ = gtk_adjustment_get_value (_data10_->adjustment);
	_tmp1_ = _tmp0_;
	_tmp2_ = pomodoro_format_time ((gint) _tmp1_);
	_tmp3_ = _tmp2_;
	gtk_label_set_text (_data10_->label, _tmp3_);
	_g_free0 (_tmp3_);
}

static void
___lambda16__gtk_adjustment_value_changed (GtkAdjustment* _sender,
                                           gpointer self)
{
	__lambda16_ (self);
}

static PomodoroWidgetsLogScale*
pomodoro_preferences_main_page_setup_time_scale (PomodoroPreferencesMainPage* self,
                                                 GtkBuilder* builder,
                                                 const gchar* grid_name,
                                                 const gchar* label_name)
{
	Block10Data* _data10_;
	GtkAdjustment* _tmp0_;
	PomodoroWidgetsLogScale* scale = NULL;
	PomodoroWidgetsLogScale* _tmp1_;
	GtkGrid* grid = NULL;
	GObject* _tmp2_;
	GtkGrid* _tmp3_;
	GObject* _tmp4_;
	GtkLabel* _tmp5_;
	PomodoroWidgetsLogScale* unowned_scale = NULL;
	PomodoroWidgetsLogScale* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (builder != NULL, NULL);
	g_return_val_if_fail (grid_name != NULL, NULL);
	g_return_val_if_fail (label_name != NULL, NULL);
	_data10_ = g_slice_new0 (Block10Data);
	_data10_->_ref_count_ = 1;
	_data10_->self = g_object_ref (self);
	_tmp0_ = gtk_adjustment_new (0.0, POMODORO_TIMER_SCALE_LOWER, POMODORO_TIMER_SCALE_UPPER, 60.0, 300.0, 0.0);
	g_object_ref_sink (_tmp0_);
	_data10_->adjustment = _tmp0_;
	_tmp1_ = pomodoro_widgets_log_scale_new (_data10_->adjustment, 2.0);
	g_object_ref_sink (_tmp1_);
	scale = _tmp1_;
	gtk_widget_show ((GtkWidget*) scale);
	_tmp2_ = gtk_builder_get_object (builder, grid_name);
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gtk_grid_get_type ()) ? ((GtkGrid*) _tmp2_) : NULL);
	grid = _tmp3_;
	gtk_grid_attach (grid, (GtkWidget*) scale, 0, 1, 2, 1);
	_tmp4_ = gtk_builder_get_object (builder, label_name);
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, gtk_label_get_type ()) ? ((GtkLabel*) _tmp4_) : NULL);
	_data10_->label = _tmp5_;
	g_signal_connect_data (_data10_->adjustment, "value-changed", (GCallback) ___lambda16__gtk_adjustment_value_changed, block10_data_ref (_data10_), (GClosureNotify) block10_data_unref, 0);
	gtk_adjustment_value_changed (_data10_->adjustment);
	unowned_scale = scale;
	result = unowned_scale;
	_g_object_unref0 (grid);
	_g_object_unref0 (scale);
	block10_data_unref (_data10_);
	_data10_ = NULL;
	return result;
}

static Block11Data*
block11_data_ref (Block11Data* _data11_)
{
	g_atomic_int_inc (&_data11_->_ref_count_);
	return _data11_;
}

static void
block11_data_unref (void * _userdata_)
{
	Block11Data* _data11_;
	_data11_ = (Block11Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data11_->_ref_count_)) {
		PomodoroPreferencesMainPage* self;
		self = _data11_->self;
		_g_object_unref0 (_data11_->accelerator_label);
		_g_object_unref0 (self);
		g_slice_free (Block11Data, _data11_);
	}
}

static void
__lambda17_ (Block11Data* _data11_)
{
	PomodoroPreferencesMainPage* self;
	gchar* _tmp0_ = NULL;
	PomodoroAccelerator* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_;
	self = _data11_->self;
	_tmp1_ = self->priv->accelerator;
	_tmp2_ = pomodoro_accelerator_get_display_name (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strcmp0 (_tmp4_, "") != 0;
	_g_free0 (_tmp4_);
	if (_tmp5_) {
		PomodoroAccelerator* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp6_ = self->priv->accelerator;
		_tmp7_ = pomodoro_accelerator_get_display_name (_tmp6_);
		_tmp8_ = _tmp7_;
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp8_;
	} else {
		gchar* _tmp9_;
		_tmp9_ = g_strdup (_ ("Off"));
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp9_;
	}
	gtk_label_set_label (_data11_->accelerator_label, _tmp0_);
	_g_free0 (_tmp0_);
}

static void
___lambda17__pomodoro_accelerator_changed (PomodoroAccelerator* _sender,
                                           gpointer self)
{
	__lambda17_ (self);
}

static void
pomodoro_preferences_main_page_setup_timer_section (PomodoroPreferencesMainPage* self,
                                                    GtkBuilder* builder)
{
	Block11Data* _data11_;
	PomodoroWidgetsLogScale* pomodoro_scale = NULL;
	PomodoroWidgetsLogScale* _tmp0_;
	PomodoroWidgetsLogScale* _tmp1_;
	PomodoroWidgetsLogScale* short_break_scale = NULL;
	PomodoroWidgetsLogScale* _tmp2_;
	PomodoroWidgetsLogScale* _tmp3_;
	PomodoroWidgetsLogScale* long_break_scale = NULL;
	PomodoroWidgetsLogScale* _tmp4_;
	PomodoroWidgetsLogScale* _tmp5_;
	GtkSpinButton* long_break_interval_spinbutton = NULL;
	GObject* _tmp6_;
	GtkSpinButton* _tmp7_;
	GObject* _tmp8_;
	GtkLabel* _tmp9_;
	GSettings* _tmp10_;
	GtkAdjustment* _tmp11_;
	GtkAdjustment* _tmp12_;
	GSettings* _tmp13_;
	GtkAdjustment* _tmp14_;
	GtkAdjustment* _tmp15_;
	GSettings* _tmp16_;
	GtkAdjustment* _tmp17_;
	GtkAdjustment* _tmp18_;
	GSettings* _tmp19_;
	GtkAdjustment* _tmp20_;
	GtkAdjustment* _tmp21_;
	PomodoroAccelerator* _tmp22_;
	PomodoroAccelerator* _tmp23_;
	GSettings* _tmp24_;
	PomodoroAccelerator* _tmp25_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (builder != NULL);
	_data11_ = g_slice_new0 (Block11Data);
	_data11_->_ref_count_ = 1;
	_data11_->self = g_object_ref (self);
	_tmp0_ = pomodoro_preferences_main_page_setup_time_scale (self, builder, "pomodoro_grid", "pomodoro_label");
	_tmp1_ = _g_object_ref0 (_tmp0_);
	pomodoro_scale = _tmp1_;
	_tmp2_ = pomodoro_preferences_main_page_setup_time_scale (self, builder, "short_break_grid", "short_break_label");
	_tmp3_ = _g_object_ref0 (_tmp2_);
	short_break_scale = _tmp3_;
	_tmp4_ = pomodoro_preferences_main_page_setup_time_scale (self, builder, "long_break_grid", "long_break_label");
	_tmp5_ = _g_object_ref0 (_tmp4_);
	long_break_scale = _tmp5_;
	_tmp6_ = gtk_builder_get_object (builder, "long_break_interval_spinbutton");
	_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, gtk_spin_button_get_type ()) ? ((GtkSpinButton*) _tmp6_) : NULL);
	long_break_interval_spinbutton = _tmp7_;
	_tmp8_ = gtk_builder_get_object (builder, "accelerator_label");
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, gtk_label_get_type ()) ? ((GtkLabel*) _tmp8_) : NULL);
	_data11_->accelerator_label = _tmp9_;
	_tmp10_ = self->priv->settings;
	_tmp11_ = pomodoro_widgets_log_scale_get_base_adjustment (pomodoro_scale);
	_tmp12_ = _tmp11_;
	g_settings_bind (_tmp10_, "pomodoro-duration", (GObject*) _tmp12_, "value", G_SETTINGS_BIND_DEFAULT);
	_tmp13_ = self->priv->settings;
	_tmp14_ = pomodoro_widgets_log_scale_get_base_adjustment (short_break_scale);
	_tmp15_ = _tmp14_;
	g_settings_bind (_tmp13_, "short-break-duration", (GObject*) _tmp15_, "value", G_SETTINGS_BIND_DEFAULT);
	_tmp16_ = self->priv->settings;
	_tmp17_ = pomodoro_widgets_log_scale_get_base_adjustment (long_break_scale);
	_tmp18_ = _tmp17_;
	g_settings_bind (_tmp16_, "long-break-duration", (GObject*) _tmp18_, "value", G_SETTINGS_BIND_DEFAULT);
	_tmp19_ = self->priv->settings;
	_tmp20_ = gtk_spin_button_get_adjustment (long_break_interval_spinbutton);
	_tmp21_ = _tmp20_;
	g_settings_bind (_tmp19_, "long-break-interval", (GObject*) _tmp21_, "value", G_SETTINGS_BIND_DEFAULT);
	_tmp22_ = pomodoro_accelerator_new ();
	_g_object_unref0 (self->priv->accelerator);
	self->priv->accelerator = _tmp22_;
	_tmp23_ = self->priv->accelerator;
	g_signal_connect_data (_tmp23_, "changed", (GCallback) ___lambda17__pomodoro_accelerator_changed, block11_data_ref (_data11_), (GClosureNotify) block11_data_unref, 0);
	_tmp24_ = self->priv->settings;
	_tmp25_ = self->priv->accelerator;
	g_settings_bind_with_mapping (_tmp24_, "toggle-timer-key", (GObject*) _tmp25_, "name", G_SETTINGS_BIND_DEFAULT, (GSettingsBindGetMapping) pomodoro_get_accelerator_mapping, (GSettingsBindSetMapping) pomodoro_set_accelerator_mapping, NULL, NULL);
	_g_object_unref0 (long_break_interval_spinbutton);
	_g_object_unref0 (long_break_scale);
	_g_object_unref0 (short_break_scale);
	_g_object_unref0 (pomodoro_scale);
	block11_data_unref (_data11_);
	_data11_ = NULL;
}

static void
pomodoro_preferences_main_page_setup_notifications_section (PomodoroPreferencesMainPage* self,
                                                            GtkBuilder* builder)
{
	GSettings* _tmp0_;
	GObject* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (builder != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = gtk_builder_get_object (builder, "screen_notifications_toggle");
	g_settings_bind (_tmp0_, "show-screen-notifications", _tmp1_, "active", G_SETTINGS_BIND_DEFAULT);
}

static void
pomodoro_preferences_main_page_setup_other_section (PomodoroPreferencesMainPage* self,
                                                    GtkBuilder* builder)
{
	GtkSwitch* pause_when_idle_toggle = NULL;
	GObject* _tmp0_;
	GtkSwitch* _tmp1_;
	GSettings* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (builder != NULL);
	_tmp0_ = gtk_builder_get_object (builder, "pause_when_idle_toggle");
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gtk_switch_get_type ()) ? ((GtkSwitch*) _tmp0_) : NULL);
	pause_when_idle_toggle = _tmp1_;
	_tmp2_ = self->priv->settings;
	g_settings_bind (_tmp2_, "pause-when-idle", (GObject*) pause_when_idle_toggle, "active", G_SETTINGS_BIND_DEFAULT);
	_g_object_unref0 (pause_when_idle_toggle);
}

static void
pomodoro_preferences_main_page_setup_plugins_section (PomodoroPreferencesMainPage* self,
                                                      GtkBuilder* builder)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (builder != NULL);
}

static void
pomodoro_preferences_main_page_real_parser_finished (GtkBuildable* base,
                                                     GtkBuilder* builder)
{
	PomodoroPreferencesMainPage * self;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	self = (PomodoroPreferencesMainPage*) base;
	g_return_if_fail (builder != NULL);
	_tmp0_ = pomodoro_get_settings ();
	_tmp1_ = g_settings_get_child (_tmp0_, "preferences");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp1_;
	pomodoro_preferences_main_page_gtk_buildable_parent_iface->parser_finished ((GtkBuildable*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow), builder);
	pomodoro_preferences_main_page_setup_timer_section (self, builder);
	pomodoro_preferences_main_page_setup_notifications_section (self, builder);
	pomodoro_preferences_main_page_setup_other_section (self, builder);
	pomodoro_preferences_main_page_setup_plugins_section (self, builder);
}

static void
pomodoro_preferences_main_page_on_row_activated (PomodoroPreferencesMainPage* self,
                                                 GtkListBox* listbox,
                                                 GtkListBoxRow* row)
{
	PomodoroPreferencesDialog* preferences_dialog = NULL;
	PomodoroPreferencesDialog* _tmp0_;
	PomodoroPreferencesDialog* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GQuark _tmp6_ = 0U;
	static GQuark _tmp5_label0 = 0;
	static GQuark _tmp5_label1 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (listbox != NULL);
	g_return_if_fail (row != NULL);
	_tmp0_ = pomodoro_preferences_page_get_preferences_dialog ((PomodoroPreferencesPage*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	preferences_dialog = _tmp1_;
	_tmp2_ = gtk_widget_get_name ((GtkWidget*) row);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp6_ = (NULL == _tmp4_) ? 0 : g_quark_from_string (_tmp4_);
	if (_tmp6_ == ((0 != _tmp5_label0) ? _tmp5_label0 : (_tmp5_label0 = g_quark_from_static_string ("keyboard-shortcut")))) {
		switch (0) {
			default:
			{
				PomodoroPreferencesDialog* _tmp7_;
				_tmp7_ = preferences_dialog;
				pomodoro_preferences_dialog_set_page (_tmp7_, "keyboard-shortcut");
				break;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label1) ? _tmp5_label1 : (_tmp5_label1 = g_quark_from_static_string ("plugins")))) {
		switch (0) {
			default:
			{
				PomodoroPreferencesDialog* _tmp8_;
				_tmp8_ = preferences_dialog;
				pomodoro_preferences_dialog_set_page (_tmp8_, "plugins");
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				break;
			}
		}
	}
	_g_object_unref0 (preferences_dialog);
}

static void
_pomodoro_preferences_main_page_on_row_activated_gtk_list_box_row_activated (GtkListBox* _sender,
                                                                             GtkListBoxRow* row,
                                                                             gpointer self)
{
	pomodoro_preferences_main_page_on_row_activated ((PomodoroPreferencesMainPage*) self, _sender, row);
}

static void
pomodoro_preferences_main_page_update_capabilities (PomodoroPreferencesMainPage* self)
{
	PomodoroApplication* application = NULL;
	PomodoroApplication* _tmp0_;
	PomodoroApplication* _tmp1_;
	PomodoroCapabilityManager* capabilities = NULL;
	PomodoroCapabilityManager* _tmp2_;
	PomodoroCapabilityManager* _tmp3_;
	GtkListBoxRow* _tmp4_;
	GtkListBoxRow* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = pomodoro_application_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	application = _tmp1_;
	_tmp2_ = application->capabilities;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	capabilities = _tmp3_;
	_tmp4_ = self->priv->listboxrow_accelerator;
	gtk_widget_set_visible ((GtkWidget*) _tmp4_, pomodoro_capability_manager_has_enabled (capabilities, "accelerator"));
	_tmp5_ = self->priv->listboxrow_idle_monitor;
	gtk_widget_set_visible ((GtkWidget*) _tmp5_, pomodoro_capability_manager_has_enabled (capabilities, "idle-monitor"));
	_g_object_unref0 (capabilities);
	_g_object_unref0 (application);
}

static void
pomodoro_preferences_main_page_on_capability_enabled (PomodoroPreferencesMainPage* self,
                                                      const gchar* capability_name)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (capability_name != NULL);
	pomodoro_preferences_main_page_update_capabilities (self);
}

static void
pomodoro_preferences_main_page_on_capability_disabled (PomodoroPreferencesMainPage* self,
                                                       const gchar* capability_name)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (capability_name != NULL);
	pomodoro_preferences_main_page_update_capabilities (self);
}

static Block12Data*
block12_data_ref (Block12Data* _data12_)
{
	g_atomic_int_inc (&_data12_->_ref_count_);
	return _data12_;
}

static void
block12_data_unref (void * _userdata_)
{
	Block12Data* _data12_;
	_data12_ = (Block12Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data12_->_ref_count_)) {
		PomodoroPreferencesMainPage* self;
		self = _data12_->self;
		_g_object_unref0 (_data12_->listbox);
		_g_object_unref0 (self);
		g_slice_free (Block12Data, _data12_);
	}
}

static void
__lambda21_ (Block12Data* _data12_,
             GtkWidget* child)
{
	PomodoroPreferencesMainPage* self;
	self = _data12_->self;
	g_return_if_fail (child != NULL);
	pomodoro_preferences_main_page_on_listbox_add (self, G_TYPE_CHECK_INSTANCE_TYPE (_data12_->listbox, gtk_widget_get_type ()) ? ((GtkWidget*) _data12_->listbox) : NULL, child);
}

static void
___lambda21__gtk_callback (GtkWidget* widget,
                           gpointer self)
{
	__lambda21_ (self, widget);
}

static void
_pomodoro_preferences_main_page_on_listbox_add_gtk_container_add (GtkContainer* _sender,
                                                                  GtkWidget* widget,
                                                                  gpointer self)
{
	pomodoro_preferences_main_page_on_listbox_add ((PomodoroPreferencesMainPage*) self, _sender, widget);
}

static void
_pomodoro_preferences_main_page_on_listbox_remove_gtk_container_remove (GtkContainer* _sender,
                                                                        GtkWidget* widget,
                                                                        gpointer self)
{
	pomodoro_preferences_main_page_on_listbox_remove ((PomodoroPreferencesMainPage*) self, _sender, widget);
}

static void
pomodoro_preferences_main_page_setup_listbox (PomodoroPreferencesMainPage* self,
                                              GtkListBox* listbox)
{
	Block12Data* _data12_;
	GtkListBox* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (listbox != NULL);
	_data12_ = g_slice_new0 (Block12Data);
	_data12_->_ref_count_ = 1;
	_data12_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (listbox);
	_g_object_unref0 (_data12_->listbox);
	_data12_->listbox = _tmp0_;
	gtk_container_foreach ((GtkContainer*) _data12_->listbox, ___lambda21__gtk_callback, _data12_);
	g_signal_connect_object ((GtkContainer*) _data12_->listbox, "add", (GCallback) _pomodoro_preferences_main_page_on_listbox_add_gtk_container_add, self, G_CONNECT_AFTER);
	g_signal_connect_object ((GtkContainer*) _data12_->listbox, "remove", (GCallback) _pomodoro_preferences_main_page_on_listbox_remove_gtk_container_remove, self, G_CONNECT_AFTER);
	block12_data_unref (_data12_);
	_data12_ = NULL;
}

static Block13Data*
block13_data_ref (Block13Data* _data13_)
{
	g_atomic_int_inc (&_data13_->_ref_count_);
	return _data13_;
}

static void
block13_data_unref (void * _userdata_)
{
	Block13Data* _data13_;
	_data13_ = (Block13Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data13_->_ref_count_)) {
		PomodoroPreferencesMainPage* self;
		self = _data13_->self;
		_g_object_unref0 (self);
		g_slice_free (Block13Data, _data13_);
	}
}

static void
___lambda22_ (Block13Data* _data13_,
              GtkWidget* child)
{
	PomodoroPreferencesMainPage* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = _data13_->self;
	g_return_if_fail (child != NULL);
	_tmp0_ = gtk_widget_get_visible (child);
	_tmp1_ = _tmp0_;
	_data13_->visible |= _tmp1_;
}

static void
____lambda22__gtk_callback (GtkWidget* widget,
                            gpointer self)
{
	___lambda22_ (self, widget);
}

static void
pomodoro_preferences_main_page_on_listboxrow_visible_notify (PomodoroPreferencesMainPage* self,
                                                             GObject* object,
                                                             GParamSpec* pspec)
{
	Block13Data* _data13_;
	GtkWidget* widget = NULL;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	GtkContainer* _tmp2_;
	GtkContainer* _tmp3_;
	GtkListBox* listbox = NULL;
	GtkWidget* _tmp4_;
	GtkListBox* _tmp5_;
	GtkWidget* _tmp6_;
	GtkContainer* _tmp7_;
	GtkContainer* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	g_return_if_fail (pspec != NULL);
	_data13_ = g_slice_new0 (Block13Data);
	_data13_->_ref_count_ = 1;
	_data13_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (object, gtk_widget_get_type ()) ? ((GtkWidget*) object) : NULL);
	widget = _tmp0_;
	_tmp1_ = widget;
	_tmp2_ = gtk_widget_get_parent (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_g_object_unref0 (widget);
		block13_data_unref (_data13_);
		_data13_ = NULL;
		return;
	}
	_tmp4_ = widget;
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, gtk_list_box_get_type ()) ? ((GtkListBox*) _tmp4_) : NULL);
	listbox = _tmp5_;
	_data13_->visible = FALSE;
	_tmp6_ = widget;
	_tmp7_ = gtk_widget_get_parent (_tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp8_ != NULL) {
		GtkListBox* _tmp9_;
		GtkWidget* _tmp10_;
		GtkContainer* _tmp11_;
		GtkContainer* _tmp12_;
		gboolean _tmp13_;
		gboolean _tmp14_;
		_tmp9_ = listbox;
		gtk_container_foreach ((GtkContainer*) _tmp9_, ____lambda22__gtk_callback, _data13_);
		_tmp10_ = widget;
		_tmp11_ = gtk_widget_get_parent (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = gtk_widget_get_visible ((GtkWidget*) _tmp12_);
		_tmp14_ = _tmp13_;
		if (_tmp14_ != _data13_->visible) {
			GtkWidget* _tmp15_;
			GtkContainer* _tmp16_;
			GtkContainer* _tmp17_;
			_tmp15_ = widget;
			_tmp16_ = gtk_widget_get_parent (_tmp15_);
			_tmp17_ = _tmp16_;
			gtk_widget_set_visible ((GtkWidget*) _tmp17_, _data13_->visible);
		}
	}
	_g_object_unref0 (listbox);
	_g_object_unref0 (widget);
	block13_data_unref (_data13_);
	_data13_ = NULL;
}

static void
_pomodoro_preferences_main_page_on_listboxrow_visible_notify_g_object_notify (GObject* _sender,
                                                                              GParamSpec* pspec,
                                                                              gpointer self)
{
	pomodoro_preferences_main_page_on_listboxrow_visible_notify ((PomodoroPreferencesMainPage*) self, _sender, pspec);
}

static void
pomodoro_preferences_main_page_on_listbox_add (PomodoroPreferencesMainPage* self,
                                               GtkWidget* widget,
                                               GtkWidget* child)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GtkContainer* _tmp2_;
	GtkContainer* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	g_return_if_fail (child != NULL);
	g_signal_connect_object ((GObject*) child, "notify::visible", (GCallback) _pomodoro_preferences_main_page_on_listboxrow_visible_notify_g_object_notify, self, 0);
	_tmp2_ = gtk_widget_get_parent (widget);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != NULL) {
		GtkContainer* _tmp4_;
		GtkContainer* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp4_ = gtk_widget_get_parent (widget);
		_tmp5_ = _tmp4_;
		_tmp6_ = gtk_widget_get_visible ((GtkWidget*) _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp1_ = !_tmp7_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gboolean _tmp8_;
		gboolean _tmp9_;
		_tmp8_ = gtk_widget_get_visible (child);
		_tmp9_ = _tmp8_;
		_tmp0_ = _tmp9_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkContainer* _tmp10_;
		GtkContainer* _tmp11_;
		_tmp10_ = gtk_widget_get_parent (widget);
		_tmp11_ = _tmp10_;
		gtk_widget_set_visible ((GtkWidget*) _tmp11_, TRUE);
	}
}

static Block14Data*
block14_data_ref (Block14Data* _data14_)
{
	g_atomic_int_inc (&_data14_->_ref_count_);
	return _data14_;
}

static void
block14_data_unref (void * _userdata_)
{
	Block14Data* _data14_;
	_data14_ = (Block14Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data14_->_ref_count_)) {
		PomodoroPreferencesMainPage* self;
		self = _data14_->self;
		_g_object_unref0 (self);
		g_slice_free (Block14Data, _data14_);
	}
}

static void
___lambda23_ (Block14Data* _data14_,
              GtkWidget* child)
{
	PomodoroPreferencesMainPage* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = _data14_->self;
	g_return_if_fail (child != NULL);
	_tmp0_ = gtk_widget_get_visible (child);
	_tmp1_ = _tmp0_;
	_data14_->visible |= _tmp1_;
}

static void
____lambda23__gtk_callback (GtkWidget* widget,
                            gpointer self)
{
	___lambda23_ (self, widget);
}

static void
pomodoro_preferences_main_page_on_listbox_remove (PomodoroPreferencesMainPage* self,
                                                  GtkWidget* widget,
                                                  GtkWidget* child)
{
	guint _tmp0_;
	GQuark _tmp1_;
	GtkContainer* _tmp2_;
	GtkContainer* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	g_return_if_fail (child != NULL);
	g_signal_parse_name ("notify::visible", G_TYPE_OBJECT, &_tmp0_, &_tmp1_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) child, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, _tmp1_, NULL, (GCallback) _pomodoro_preferences_main_page_on_listboxrow_visible_notify_g_object_notify, self);
	_tmp2_ = gtk_widget_get_parent (widget);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != NULL) {
		Block14Data* _data14_;
		GtkListBox* listbox = NULL;
		GtkListBox* _tmp4_;
		GtkListBox* _tmp5_;
		GtkContainer* _tmp6_;
		GtkContainer* _tmp7_;
		gboolean _tmp8_;
		gboolean _tmp9_;
		_data14_ = g_slice_new0 (Block14Data);
		_data14_->_ref_count_ = 1;
		_data14_->self = g_object_ref (self);
		_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (widget, gtk_list_box_get_type ()) ? ((GtkListBox*) widget) : NULL);
		listbox = _tmp4_;
		_data14_->visible = FALSE;
		_tmp5_ = listbox;
		gtk_container_foreach ((GtkContainer*) _tmp5_, ____lambda23__gtk_callback, _data14_);
		_tmp6_ = gtk_widget_get_parent (widget);
		_tmp7_ = _tmp6_;
		_tmp8_ = gtk_widget_get_visible ((GtkWidget*) _tmp7_);
		_tmp9_ = _tmp8_;
		if (_tmp9_ != _data14_->visible) {
			GtkContainer* _tmp10_;
			GtkContainer* _tmp11_;
			_tmp10_ = gtk_widget_get_parent (widget);
			_tmp11_ = _tmp10_;
			gtk_widget_set_visible ((GtkWidget*) _tmp11_, _data14_->visible);
		}
		_g_object_unref0 (listbox);
		block14_data_unref (_data14_);
		_data14_ = NULL;
	}
}

static void
_pomodoro_preferences_main_page_on_capability_enabled_pomodoro_capability_manager_capability_enabled (PomodoroCapabilityManager* _sender,
                                                                                                      const gchar* capability_name,
                                                                                                      gpointer self)
{
	pomodoro_preferences_main_page_on_capability_enabled ((PomodoroPreferencesMainPage*) self, capability_name);
}

static void
_pomodoro_preferences_main_page_on_capability_disabled_pomodoro_capability_manager_capability_disabled (PomodoroCapabilityManager* _sender,
                                                                                                        const gchar* capability_name,
                                                                                                        gpointer self)
{
	pomodoro_preferences_main_page_on_capability_disabled ((PomodoroPreferencesMainPage*) self, capability_name);
}

static void
pomodoro_preferences_main_page_real_dispose (GObject* base)
{
	PomodoroPreferencesMainPage * self;
	PomodoroApplication* application = NULL;
	PomodoroApplication* _tmp0_;
	PomodoroApplication* _tmp1_;
	PomodoroCapabilityManager* _tmp2_;
	guint _tmp3_;
	PomodoroCapabilityManager* _tmp4_;
	guint _tmp5_;
	self = (PomodoroPreferencesMainPage*) base;
	_tmp0_ = pomodoro_application_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	application = _tmp1_;
	_tmp2_ = application->capabilities;
	g_signal_parse_name ("capability-enabled", POMODORO_TYPE_CAPABILITY_MANAGER, &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _pomodoro_preferences_main_page_on_capability_enabled_pomodoro_capability_manager_capability_enabled, self);
	_tmp4_ = application->capabilities;
	g_signal_parse_name ("capability-disabled", POMODORO_TYPE_CAPABILITY_MANAGER, &_tmp5_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _pomodoro_preferences_main_page_on_capability_disabled_pomodoro_capability_manager_capability_disabled, self);
	G_OBJECT_CLASS (pomodoro_preferences_main_page_parent_class)->dispose ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow));
	_g_object_unref0 (application);
}

PomodoroPreferencesMainPage*
pomodoro_preferences_main_page_construct (GType object_type)
{
	PomodoroPreferencesMainPage * self = NULL;
	self = (PomodoroPreferencesMainPage*) g_object_new (object_type, NULL);
	return self;
}

PomodoroPreferencesMainPage*
pomodoro_preferences_main_page_new (void)
{
	return pomodoro_preferences_main_page_construct (POMODORO_TYPE_PREFERENCES_MAIN_PAGE);
}

static GObject *
pomodoro_preferences_main_page_constructor (GType type,
                                            guint n_construct_properties,
                                            GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PomodoroPreferencesMainPage * self;
	GtkListBox* _tmp0_;
	GtkListBox* _tmp1_;
	GtkListBox* _tmp2_;
	GtkListBox* _tmp3_;
	PomodoroApplication* application = NULL;
	PomodoroApplication* _tmp4_;
	PomodoroApplication* _tmp5_;
	PomodoroApplication* _tmp6_;
	PomodoroCapabilityManager* _tmp7_;
	PomodoroApplication* _tmp8_;
	PomodoroCapabilityManager* _tmp9_;
	GtkListBox* _tmp10_;
	parent_class = G_OBJECT_CLASS (pomodoro_preferences_main_page_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, POMODORO_TYPE_PREFERENCES_MAIN_PAGE, PomodoroPreferencesMainPage);
	_tmp0_ = self->timer_listbox;
	gtk_list_box_set_header_func (_tmp0_, _pomodoro_list_box_separator_func_gtk_list_box_update_header_func, NULL, NULL);
	_tmp1_ = self->notifications_listbox;
	gtk_list_box_set_header_func (_tmp1_, _pomodoro_list_box_separator_func_gtk_list_box_update_header_func, NULL, NULL);
	_tmp2_ = self->desktop_listbox;
	gtk_list_box_set_header_func (_tmp2_, _pomodoro_list_box_separator_func_gtk_list_box_update_header_func, NULL, NULL);
	_tmp3_ = self->plugins_listbox;
	gtk_list_box_set_header_func (_tmp3_, _pomodoro_list_box_separator_func_gtk_list_box_update_header_func, NULL, NULL);
	_tmp4_ = pomodoro_application_get_default ();
	_tmp5_ = _g_object_ref0 (_tmp4_);
	application = _tmp5_;
	_tmp6_ = application;
	_tmp7_ = _tmp6_->capabilities;
	g_signal_connect_object (_tmp7_, "capability-enabled", (GCallback) _pomodoro_preferences_main_page_on_capability_enabled_pomodoro_capability_manager_capability_enabled, self, 0);
	_tmp8_ = application;
	_tmp9_ = _tmp8_->capabilities;
	g_signal_connect_object (_tmp9_, "capability-disabled", (GCallback) _pomodoro_preferences_main_page_on_capability_disabled_pomodoro_capability_manager_capability_disabled, self, 0);
	pomodoro_preferences_main_page_update_capabilities (self);
	_tmp10_ = self->desktop_listbox;
	pomodoro_preferences_main_page_setup_listbox (self, _tmp10_);
	_g_object_unref0 (application);
	return obj;
}

static void
pomodoro_preferences_main_page_class_init (PomodoroPreferencesMainPageClass * klass,
                                           gpointer klass_data)
{
	pomodoro_preferences_main_page_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PomodoroPreferencesMainPage_private_offset);
	((GObjectClass *) klass)->dispose = (void (*) (GObject*)) pomodoro_preferences_main_page_real_dispose;
	G_OBJECT_CLASS (klass)->constructor = pomodoro_preferences_main_page_constructor;
	G_OBJECT_CLASS (klass)->finalize = pomodoro_preferences_main_page_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/pomodoro/preferences-main-page.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "box", FALSE, G_STRUCT_OFFSET (PomodoroPreferencesMainPage, box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "timer_listbox", FALSE, G_STRUCT_OFFSET (PomodoroPreferencesMainPage, timer_listbox));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "notifications_listbox", FALSE, G_STRUCT_OFFSET (PomodoroPreferencesMainPage, notifications_listbox));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "desktop_listbox", FALSE, G_STRUCT_OFFSET (PomodoroPreferencesMainPage, desktop_listbox));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "plugins_listbox", FALSE, G_STRUCT_OFFSET (PomodoroPreferencesMainPage, plugins_listbox));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "lisboxrow_sizegroup", FALSE, G_STRUCT_OFFSET (PomodoroPreferencesMainPage, lisboxrow_sizegroup));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "listboxrow_accelerator", FALSE, PomodoroPreferencesMainPage_private_offset + G_STRUCT_OFFSET (PomodoroPreferencesMainPagePrivate, listboxrow_accelerator));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "listboxrow_idle_monitor", FALSE, PomodoroPreferencesMainPage_private_offset + G_STRUCT_OFFSET (PomodoroPreferencesMainPagePrivate, listboxrow_idle_monitor));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_row_activated", G_CALLBACK(_pomodoro_preferences_main_page_on_row_activated_gtk_list_box_row_activated));
}

static void
pomodoro_preferences_main_page_gtk_buildable_interface_init (GtkBuildableIface * iface,
                                                             gpointer iface_data)
{
	pomodoro_preferences_main_page_gtk_buildable_parent_iface = g_type_interface_peek_parent (iface);
	iface->parser_finished = (void (*) (GtkBuildable*, GtkBuilder*)) pomodoro_preferences_main_page_real_parser_finished;
}

static void
pomodoro_preferences_main_page_pomodoro_preferences_page_interface_init (PomodoroPreferencesPageIface * iface,
                                                                         gpointer iface_data)
{
	pomodoro_preferences_main_page_pomodoro_preferences_page_parent_iface = g_type_interface_peek_parent (iface);
}

static void
pomodoro_preferences_main_page_instance_init (PomodoroPreferencesMainPage * self,
                                              gpointer klass)
{
	self->priv = pomodoro_preferences_main_page_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
pomodoro_preferences_main_page_finalize (GObject * obj)
{
	PomodoroPreferencesMainPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, POMODORO_TYPE_PREFERENCES_MAIN_PAGE, PomodoroPreferencesMainPage);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->accelerator);
	G_OBJECT_CLASS (pomodoro_preferences_main_page_parent_class)->finalize (obj);
}

static GType
pomodoro_preferences_main_page_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PomodoroPreferencesMainPageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pomodoro_preferences_main_page_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PomodoroPreferencesMainPage), 0, (GInstanceInitFunc) pomodoro_preferences_main_page_instance_init, NULL };
	static const GInterfaceInfo gtk_buildable_info = { (GInterfaceInitFunc) pomodoro_preferences_main_page_gtk_buildable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo pomodoro_preferences_page_info = { (GInterfaceInitFunc) pomodoro_preferences_main_page_pomodoro_preferences_page_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType pomodoro_preferences_main_page_type_id;
	pomodoro_preferences_main_page_type_id = g_type_register_static (gtk_scrolled_window_get_type (), "PomodoroPreferencesMainPage", &g_define_type_info, 0);
	g_type_add_interface_static (pomodoro_preferences_main_page_type_id, gtk_buildable_get_type (), &gtk_buildable_info);
	g_type_add_interface_static (pomodoro_preferences_main_page_type_id, POMODORO_TYPE_PREFERENCES_PAGE, &pomodoro_preferences_page_info);
	PomodoroPreferencesMainPage_private_offset = g_type_add_instance_private (pomodoro_preferences_main_page_type_id, sizeof (PomodoroPreferencesMainPagePrivate));
	return pomodoro_preferences_main_page_type_id;
}

GType
pomodoro_preferences_main_page_get_type (void)
{
	static volatile gsize pomodoro_preferences_main_page_type_id__once = 0;
	if (g_once_init_enter (&pomodoro_preferences_main_page_type_id__once)) {
		GType pomodoro_preferences_main_page_type_id;
		pomodoro_preferences_main_page_type_id = pomodoro_preferences_main_page_get_type_once ();
		g_once_init_leave (&pomodoro_preferences_main_page_type_id__once, pomodoro_preferences_main_page_type_id);
	}
	return pomodoro_preferences_main_page_type_id__once;
}

static inline gpointer
pomodoro_preferences_dialog_get_instance_private (PomodoroPreferencesDialog* self)
{
	return G_STRUCT_MEMBER_P (self, PomodoroPreferencesDialog_private_offset);
}

static void
_pomodoro_preferences_dialog_on_back_activate_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                GVariant* parameter,
                                                                                gpointer self)
{
	pomodoro_preferences_dialog_on_back_activate ((PomodoroPreferencesDialog*) self, action, parameter);
}

static inline void
_g_list_free__g_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_free0_);
}

PomodoroPreferencesDialog*
pomodoro_preferences_dialog_get_default (void)
{
	PomodoroPreferencesDialog* _tmp0_;
	PomodoroPreferencesDialog* _tmp1_;
	PomodoroPreferencesDialog* result;
	_tmp0_ = pomodoro_preferences_dialog_instance;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
pomodoro_preferences_dialog_real_parser_finished (GtkBuildable* base,
                                                  GtkBuilder* builder)
{
	PomodoroPreferencesDialog * self;
	self = (PomodoroPreferencesDialog*) base;
	g_return_if_fail (builder != NULL);
	pomodoro_preferences_dialog_gtk_buildable_parent_iface->parser_finished ((GtkBuildable*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_window_get_type (), GtkApplicationWindow), builder);
}

static void
__lambda15_ (PomodoroPreferencesDialog* self,
             GtkWidget* child)
{
	GtkButton* _tmp0_;
	g_return_if_fail (child != NULL);
	_tmp0_ = self->priv->back_button;
	if (child != G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget)) {
		GtkHeaderBar* _tmp1_;
		_tmp1_ = self->priv->header_bar;
		gtk_container_remove ((GtkContainer*) _tmp1_, child);
	}
}

static void
___lambda15__gtk_callback (GtkWidget* widget,
                           gpointer self)
{
	__lambda15_ ((PomodoroPreferencesDialog*) self, widget);
}

static void
pomodoro_preferences_dialog_on_page_notify (PomodoroPreferencesDialog* self,
                                            PomodoroPreferencesPage* page)
{
	gchar* name = NULL;
	gchar* title = NULL;
	GtkStack* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GtkHeaderBar* _tmp3_;
	GtkButton* _tmp4_;
	GList* _tmp5_;
	GtkHeaderBar* _tmp6_;
	GtkHeaderBar* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (page != NULL);
	_tmp0_ = self->priv->stack;
	gtk_container_child_get ((GtkContainer*) _tmp0_, (GtkWidget*) page, "name", &_tmp1_, "title", &_tmp2_, NULL);
	_g_free0 (name);
	name = _tmp1_;
	_g_free0 (title);
	title = _tmp2_;
	pomodoro_preferences_dialog_history_push (self, name);
	_tmp3_ = self->priv->header_bar;
	gtk_header_bar_set_title (_tmp3_, title);
	_tmp4_ = self->priv->back_button;
	_tmp5_ = self->priv->history;
	gtk_widget_set_visible ((GtkWidget*) _tmp4_, g_list_length (_tmp5_) > ((guint) 1));
	_tmp6_ = self->priv->header_bar;
	gtk_container_forall ((GtkContainer*) _tmp6_, ___lambda15__gtk_callback, self);
	_tmp7_ = self->priv->header_bar;
	pomodoro_preferences_page_configure_header_bar (page, _tmp7_);
	_g_free0 (title);
	_g_free0 (name);
}

static void
pomodoro_preferences_dialog_on_visible_child_notify (PomodoroPreferencesDialog* self)
{
	gint window_width = 0;
	gint window_height = 0;
	gint header_bar_height = 0;
	gint page_height = 0;
	PomodoroPreferencesPage* page = NULL;
	GtkStack* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	PomodoroPreferencesPage* _tmp3_;
	PomodoroPreferencesPage* _tmp4_;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	GtkHeaderBar* _tmp7_;
	gint _tmp8_ = 0;
	PomodoroPreferencesPage* _tmp9_;
	gint _tmp10_ = 0;
	PomodoroPreferencesPage* _tmp11_;
	g_return_if_fail (self != NULL);
	window_width = 0;
	window_height = 0;
	header_bar_height = 0;
	page_height = 0;
	_tmp0_ = self->priv->stack;
	_tmp1_ = gtk_stack_get_visible_child (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (POMODORO_IS_PREFERENCES_PAGE (_tmp2_) ? ((PomodoroPreferencesPage*) _tmp2_) : NULL);
	page = _tmp3_;
	_tmp4_ = page;
	pomodoro_preferences_dialog_on_page_notify (self, _tmp4_);
	gtk_window_get_size ((GtkWindow*) self, &_tmp5_, &_tmp6_);
	window_width = _tmp5_;
	window_height = _tmp6_;
	_tmp7_ = self->priv->header_bar;
	gtk_widget_get_preferred_height ((GtkWidget*) _tmp7_, NULL, &_tmp8_);
	header_bar_height = _tmp8_;
	_tmp9_ = page;
	gtk_widget_get_preferred_height_for_width ((GtkWidget*) _tmp9_, window_width, NULL, &_tmp10_);
	page_height = _tmp10_;
	_tmp11_ = page;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, gtk_scrolled_window_get_type ())) {
		GtkScrolledWindow* scrolled_window = NULL;
		PomodoroPreferencesPage* _tmp12_;
		GtkScrolledWindow* _tmp13_;
		GtkScrolledWindow* _tmp14_;
		_tmp12_ = page;
		_tmp13_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, gtk_scrolled_window_get_type ()) ? ((GtkScrolledWindow*) _tmp12_) : NULL);
		scrolled_window = _tmp13_;
		_tmp14_ = scrolled_window;
		gtk_scrolled_window_set_min_content_height (_tmp14_, MIN (page_height, POMODORO_PREFERENCES_DIALOG_DEFAULT_HEIGHT));
		gtk_window_resize ((GtkWindow*) self, window_width, header_bar_height + POMODORO_PREFERENCES_DIALOG_DEFAULT_HEIGHT);
		_g_object_unref0 (scrolled_window);
	} else {
		gtk_window_resize ((GtkWindow*) self, window_width, header_bar_height + page_height);
	}
	_g_object_unref0 (page);
}

static void
pomodoro_preferences_dialog_on_back_activate (PomodoroPreferencesDialog* self,
                                              GSimpleAction* action,
                                              GVariant* parameter)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = pomodoro_preferences_dialog_history_pop (self);
	_tmp1_ = _tmp0_;
	_g_free0 (_tmp1_);
}

static gpointer
_pomodoro_preferences_dialog_page_meta_dup0 (gpointer self)
{
	return self ? pomodoro_preferences_dialog_page_meta_dup (self) : NULL;
}

PomodoroPreferencesPage*
pomodoro_preferences_dialog_get_page (PomodoroPreferencesDialog* self,
                                      const gchar* name)
{
	GtkStack* _tmp0_;
	gboolean _tmp6_ = FALSE;
	GHashTable* _tmp7_;
	PomodoroPreferencesPage* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->priv->stack;
	if (_tmp0_ != NULL) {
		GtkWidget* page_widget = NULL;
		GtkStack* _tmp1_;
		GtkWidget* _tmp2_;
		GtkWidget* _tmp3_;
		GtkWidget* _tmp4_;
		_tmp1_ = self->priv->stack;
		_tmp2_ = gtk_stack_get_child_by_name (_tmp1_, name);
		_tmp3_ = _g_object_ref0 (_tmp2_);
		page_widget = _tmp3_;
		_tmp4_ = page_widget;
		if (_tmp4_ != NULL) {
			GtkWidget* _tmp5_;
			_tmp5_ = page_widget;
			result = POMODORO_IS_PREFERENCES_PAGE (_tmp5_) ? ((PomodoroPreferencesPage*) _tmp5_) : NULL;
			_g_object_unref0 (page_widget);
			return result;
		}
		_g_object_unref0 (page_widget);
	}
	_tmp7_ = self->priv->pages;
	if (_tmp7_ != NULL) {
		GHashTable* _tmp8_;
		_tmp8_ = self->priv->pages;
		_tmp6_ = g_hash_table_contains (_tmp8_, name);
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		PomodoroPreferencesDialogPageMeta* meta = NULL;
		GHashTable* _tmp9_;
		gconstpointer _tmp10_;
		PomodoroPreferencesDialogPageMeta* _tmp11_;
		PomodoroPreferencesPage* page = NULL;
		PomodoroPreferencesDialogPageMeta* _tmp12_;
		GObject* _tmp13_;
		GObject* _tmp14_;
		PomodoroPreferencesPage* _tmp15_;
		GtkStack* _tmp16_;
		PomodoroPreferencesPage* _tmp17_;
		PomodoroPreferencesDialogPageMeta* _tmp18_;
		const gchar* _tmp19_;
		PomodoroPreferencesDialogPageMeta* _tmp20_;
		const gchar* _tmp21_;
		PomodoroPreferencesPage* _tmp22_;
		_tmp9_ = self->priv->pages;
		_tmp10_ = g_hash_table_lookup (_tmp9_, name);
		_tmp11_ = _pomodoro_preferences_dialog_page_meta_dup0 ((PomodoroPreferencesDialogPageMeta*) _tmp10_);
		meta = _tmp11_;
		_tmp12_ = meta;
		_tmp13_ = g_object_new ((*_tmp12_).type, NULL);
		_tmp14_ = G_IS_INITIALLY_UNOWNED (_tmp13_) ? g_object_ref_sink (_tmp13_) : _tmp13_;
		_tmp15_ = POMODORO_IS_PREFERENCES_PAGE (_tmp14_) ? ((PomodoroPreferencesPage*) _tmp14_) : NULL;
		if (_tmp15_ == NULL) {
			_g_object_unref0 (_tmp14_);
		}
		page = _tmp15_;
		_tmp16_ = self->priv->stack;
		_tmp17_ = page;
		_tmp18_ = meta;
		_tmp19_ = (*_tmp18_).name;
		_tmp20_ = meta;
		_tmp21_ = (*_tmp20_).title;
		gtk_stack_add_titled (_tmp16_, G_TYPE_CHECK_INSTANCE_TYPE (_tmp17_, gtk_widget_get_type ()) ? ((GtkWidget*) _tmp17_) : NULL, _tmp19_, _tmp21_);
		_tmp22_ = page;
		result = POMODORO_IS_PREFERENCES_PAGE (_tmp22_) ? ((PomodoroPreferencesPage*) _tmp22_) : NULL;
		_g_object_unref0 (page);
		_pomodoro_preferences_dialog_page_meta_free0 (meta);
		return result;
	}
	result = NULL;
	return result;
}

static void
pomodoro_preferences_dialog_history_clear (PomodoroPreferencesDialog* self)
{
	g_return_if_fail (self != NULL);
	(self->priv->history == NULL) ? NULL : (self->priv->history = (_g_list_free__g_free0_ (self->priv->history), NULL));
	self->priv->history = NULL;
}

static void
pomodoro_preferences_dialog_history_push (PomodoroPreferencesDialog* self,
                                          const gchar* name)
{
	gchar* _tmp16_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	if (g_strcmp0 (name, "main") == 0) {
		pomodoro_preferences_dialog_history_clear (self);
	} else {
		GList* last = NULL;
		GList* _tmp0_;
		GList* _tmp1_;
		gboolean _tmp2_ = FALSE;
		GList* _tmp3_;
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_ = FALSE;
		GList* _tmp8_;
		_tmp0_ = self->priv->history;
		_tmp1_ = g_list_last (_tmp0_);
		last = _tmp1_;
		_tmp3_ = last;
		if (_tmp3_ != NULL) {
			GList* _tmp4_;
			gconstpointer _tmp5_;
			_tmp4_ = last;
			_tmp5_ = _tmp4_->data;
			_tmp2_ = g_strcmp0 ((const gchar*) _tmp5_, name) == 0;
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			return;
		}
		_tmp8_ = last;
		if (_tmp8_ != NULL) {
			GList* _tmp9_;
			GList* _tmp10_;
			_tmp9_ = last;
			_tmp10_ = _tmp9_->prev;
			_tmp7_ = _tmp10_ != NULL;
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			GList* _tmp11_;
			GList* _tmp12_;
			gconstpointer _tmp13_;
			_tmp11_ = last;
			_tmp12_ = _tmp11_->prev;
			_tmp13_ = _tmp12_->data;
			_tmp6_ = g_strcmp0 ((const gchar*) _tmp13_, name) == 0;
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			gchar* _tmp14_;
			gchar* _tmp15_;
			_tmp14_ = pomodoro_preferences_dialog_history_pop (self);
			_tmp15_ = _tmp14_;
			_g_free0 (_tmp15_);
			return;
		}
	}
	_tmp16_ = g_strdup (name);
	self->priv->history = g_list_append (self->priv->history, _tmp16_);
}

static gchar*
pomodoro_preferences_dialog_history_pop (PomodoroPreferencesDialog* self)
{
	GList* last = NULL;
	GList* _tmp0_;
	GList* _tmp1_;
	gchar* last_name = NULL;
	gchar* next_name = NULL;
	gchar* _tmp2_;
	GList* _tmp3_;
	GList* _tmp10_;
	const gchar* _tmp14_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->history;
	_tmp1_ = g_list_last (_tmp0_);
	last = _tmp1_;
	last_name = NULL;
	_tmp2_ = g_strdup ("main");
	next_name = _tmp2_;
	_tmp3_ = last;
	if (_tmp3_ != NULL) {
		GList* _tmp4_;
		gconstpointer _tmp5_;
		gchar* _tmp6_;
		GList* _tmp7_;
		GList* _tmp8_;
		GList* _tmp9_;
		_tmp4_ = last;
		_tmp5_ = _tmp4_->data;
		_tmp6_ = g_strdup ((const gchar*) _tmp5_);
		_g_free0 (last_name);
		last_name = _tmp6_;
		_tmp7_ = last;
		self->priv->history = g_list_delete_link (self->priv->history, _tmp7_);
		_tmp8_ = self->priv->history;
		_tmp9_ = g_list_last (_tmp8_);
		last = _tmp9_;
	}
	_tmp10_ = last;
	if (_tmp10_ != NULL) {
		GList* _tmp11_;
		gconstpointer _tmp12_;
		gchar* _tmp13_;
		_tmp11_ = last;
		_tmp12_ = _tmp11_->data;
		_tmp13_ = g_strdup ((const gchar*) _tmp12_);
		_g_free0 (next_name);
		next_name = _tmp13_;
	}
	_tmp14_ = next_name;
	pomodoro_preferences_dialog_set_page (self, _tmp14_);
	result = last_name;
	_g_free0 (next_name);
	return result;
}

void
pomodoro_preferences_dialog_add_page (PomodoroPreferencesDialog* self,
                                      const gchar* name,
                                      const gchar* title,
                                      GType type)
{
	PomodoroPreferencesDialogPageMeta meta = {0};
	gchar* _tmp0_;
	gchar* _tmp1_;
	PomodoroPreferencesDialogPageMeta _tmp2_ = {0};
	GHashTable* _tmp3_;
	gchar* _tmp4_;
	PomodoroPreferencesDialogPageMeta _tmp5_;
	PomodoroPreferencesDialogPageMeta _tmp6_;
	PomodoroPreferencesDialogPageMeta* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (title != NULL);
	_vala_return_if_fail (g_type_is_a (type, POMODORO_TYPE_PREFERENCES_PAGE), "type.is_a (typeof (Pomodoro.PreferencesPage))");
	_tmp0_ = g_strdup (name);
	_tmp1_ = g_strdup (title);
	memset (&_tmp2_, 0, sizeof (PomodoroPreferencesDialogPageMeta));
	_g_free0 (_tmp2_.name);
	_tmp2_.name = _tmp0_;
	_g_free0 (_tmp2_.title);
	_tmp2_.title = _tmp1_;
	_tmp2_.type = type;
	meta = _tmp2_;
	_tmp3_ = self->priv->pages;
	_tmp4_ = g_strdup (name);
	_tmp5_ = meta;
	_tmp6_ = _tmp5_;
	_tmp7_ = _pomodoro_preferences_dialog_page_meta_dup0 (&_tmp6_);
	g_hash_table_insert (_tmp3_, _tmp4_, _tmp7_);
	pomodoro_preferences_dialog_page_meta_destroy (&meta);
}

void
pomodoro_preferences_dialog_remove_page (PomodoroPreferencesDialog* self,
                                         const gchar* name)
{
	GtkStack* _tmp0_;
	GHashTable* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = self->priv->stack;
	if (_tmp0_ != NULL) {
		GtkWidget* child = NULL;
		GtkStack* _tmp1_;
		GtkWidget* _tmp2_;
		GtkWidget* _tmp3_;
		GtkStack* _tmp4_;
		const gchar* _tmp5_;
		GtkWidget* _tmp6_;
		_tmp1_ = self->priv->stack;
		_tmp2_ = gtk_stack_get_child_by_name (_tmp1_, name);
		_tmp3_ = _g_object_ref0 (_tmp2_);
		child = _tmp3_;
		_tmp4_ = self->priv->stack;
		_tmp5_ = gtk_stack_get_visible_child_name (_tmp4_);
		if (g_strcmp0 (_tmp5_, name) == 0) {
			pomodoro_preferences_dialog_set_page (self, "main");
		}
		_tmp6_ = child;
		if (_tmp6_ != NULL) {
			GtkStack* _tmp7_;
			GtkWidget* _tmp8_;
			_tmp7_ = self->priv->stack;
			_tmp8_ = child;
			gtk_container_remove ((GtkContainer*) _tmp7_, _tmp8_);
		}
		_g_object_unref0 (child);
	}
	_tmp9_ = self->priv->pages;
	g_hash_table_remove (_tmp9_, name);
}

void
pomodoro_preferences_dialog_set_page (PomodoroPreferencesDialog* self,
                                      const gchar* name)
{
	PomodoroPreferencesPage* page = NULL;
	PomodoroPreferencesPage* _tmp0_;
	PomodoroPreferencesPage* _tmp1_;
	PomodoroPreferencesPage* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = pomodoro_preferences_dialog_get_page (self, name);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	page = _tmp1_;
	_tmp2_ = page;
	if (_tmp2_ != NULL) {
		GtkStack* _tmp3_;
		_tmp3_ = self->priv->stack;
		gtk_stack_set_visible_child_name (_tmp3_, name);
	} else {
		g_warning ("preferences-dialog.vala:1033: Could not change page to \"%s\"", name);
	}
	_g_object_unref0 (page);
}

PomodoroPreferencesDialog*
pomodoro_preferences_dialog_construct (GType object_type)
{
	PomodoroPreferencesDialog * self = NULL;
	self = (PomodoroPreferencesDialog*) g_object_new (object_type, NULL);
	return self;
}

PomodoroPreferencesDialog*
pomodoro_preferences_dialog_new (void)
{
	return pomodoro_preferences_dialog_construct (POMODORO_TYPE_PREFERENCES_DIALOG);
}

static void
pomodoro_preferences_dialog_page_meta_copy (const PomodoroPreferencesDialogPageMeta* self,
                                            PomodoroPreferencesDialogPageMeta* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	(*dest).type = (*self).type;
	_tmp0_ = (*self).name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).name);
	(*dest).name = _tmp1_;
	_tmp2_ = (*self).title;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).title);
	(*dest).title = _tmp3_;
}

static void
pomodoro_preferences_dialog_page_meta_destroy (PomodoroPreferencesDialogPageMeta* self)
{
	_g_free0 ((*self).name);
	_g_free0 ((*self).title);
}

static PomodoroPreferencesDialogPageMeta*
pomodoro_preferences_dialog_page_meta_dup (const PomodoroPreferencesDialogPageMeta* self)
{
	PomodoroPreferencesDialogPageMeta* dup;
	dup = g_new0 (PomodoroPreferencesDialogPageMeta, 1);
	pomodoro_preferences_dialog_page_meta_copy (self, dup);
	return dup;
}

static void
pomodoro_preferences_dialog_page_meta_free (PomodoroPreferencesDialogPageMeta* self)
{
	pomodoro_preferences_dialog_page_meta_destroy (self);
	g_free (self);
}

static GType
pomodoro_preferences_dialog_page_meta_get_type_once (void)
{
	GType pomodoro_preferences_dialog_page_meta_type_id;
	pomodoro_preferences_dialog_page_meta_type_id = g_boxed_type_register_static ("PomodoroPreferencesDialogPageMeta", (GBoxedCopyFunc) pomodoro_preferences_dialog_page_meta_dup, (GBoxedFreeFunc) pomodoro_preferences_dialog_page_meta_free);
	return pomodoro_preferences_dialog_page_meta_type_id;
}

static GType
pomodoro_preferences_dialog_page_meta_get_type (void)
{
	static volatile gsize pomodoro_preferences_dialog_page_meta_type_id__once = 0;
	if (g_once_init_enter (&pomodoro_preferences_dialog_page_meta_type_id__once)) {
		GType pomodoro_preferences_dialog_page_meta_type_id;
		pomodoro_preferences_dialog_page_meta_type_id = pomodoro_preferences_dialog_page_meta_get_type_once ();
		g_once_init_leave (&pomodoro_preferences_dialog_page_meta_type_id__once, pomodoro_preferences_dialog_page_meta_type_id);
	}
	return pomodoro_preferences_dialog_page_meta_type_id__once;
}

static void
_pomodoro_preferences_dialog_page_meta_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (pomodoro_preferences_dialog_page_meta_free (var), NULL));
}

static void
_pomodoro_preferences_dialog_on_visible_child_notify_g_object_notify (GObject* _sender,
                                                                      GParamSpec* pspec,
                                                                      gpointer self)
{
	pomodoro_preferences_dialog_on_visible_child_notify ((PomodoroPreferencesDialog*) self);
}

static GObject *
pomodoro_preferences_dialog_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PomodoroPreferencesDialog * self;
	GdkGeometry geometry = {0};
	GdkGeometry _tmp0_ = {0};
	GdkGeometry _tmp1_;
	GHashFunc _tmp2_;
	GEqualFunc _tmp3_;
	GHashTable* _tmp4_;
	PeasEngine* _tmp5_;
	PeasExtensionSet* _tmp6_;
	GtkStack* _tmp7_;
	parent_class = G_OBJECT_CLASS (pomodoro_preferences_dialog_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, POMODORO_TYPE_PREFERENCES_DIALOG, PomodoroPreferencesDialog);
	pomodoro_preferences_dialog_instance = self;
	memset (&_tmp0_, 0, sizeof (GdkGeometry));
	_tmp0_.min_width = POMODORO_PREFERENCES_DIALOG_DEFAULT_WIDTH;
	_tmp0_.max_width = -1;
	_tmp0_.min_height = 300;
	_tmp0_.max_height = -1;
	geometry = _tmp0_;
	_tmp1_ = geometry;
	gtk_window_set_geometry_hints ((GtkWindow*) self, (GtkWidget*) self, &_tmp1_, GDK_HINT_MIN_SIZE);
	_tmp2_ = g_str_hash;
	_tmp3_ = g_str_equal;
	_tmp4_ = g_hash_table_new_full (_tmp2_, _tmp3_, _g_free0_, _pomodoro_preferences_dialog_page_meta_free0_);
	_g_hash_table_unref0 (self->priv->pages);
	self->priv->pages = _tmp4_;
	pomodoro_preferences_dialog_add_page (self, "main", _ ("Preferences"), POMODORO_TYPE_PREFERENCES_MAIN_PAGE);
	pomodoro_preferences_dialog_add_page (self, "plugins", _ ("Plugins"), POMODORO_TYPE_PREFERENCES_PLUGINS_PAGE);
	pomodoro_preferences_dialog_add_page (self, "keyboard-shortcut", _ ("Keyboard Shortcut"), POMODORO_TYPE_PREFERENCES_KEYBOARD_SHORTCUT_PAGE);
	g_action_map_add_action_entries ((GActionMap*) self, POMODORO_PREFERENCES_DIALOG_ACTION_ENTRIES, (gint) G_N_ELEMENTS (POMODORO_PREFERENCES_DIALOG_ACTION_ENTRIES), self);
	pomodoro_preferences_dialog_history_clear (self);
	pomodoro_preferences_dialog_set_page (self, "main");
	_tmp5_ = peas_engine_get_default ();
	_tmp6_ = peas_extension_set_new (_tmp5_, POMODORO_TYPE_PREFERENCES_DIALOG_EXTENSION, NULL);
	_g_object_unref0 (self->priv->extensions);
	self->priv->extensions = _tmp6_;
	_tmp7_ = self->priv->stack;
	g_signal_connect_object ((GObject*) _tmp7_, "notify::visible-child", (GCallback) _pomodoro_preferences_dialog_on_visible_child_notify_g_object_notify, self, 0);
	pomodoro_preferences_dialog_on_visible_child_notify (self);
	return obj;
}

static void
pomodoro_preferences_dialog_class_init (PomodoroPreferencesDialogClass * klass,
                                        gpointer klass_data)
{
	pomodoro_preferences_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PomodoroPreferencesDialog_private_offset);
	G_OBJECT_CLASS (klass)->constructor = pomodoro_preferences_dialog_constructor;
	G_OBJECT_CLASS (klass)->finalize = pomodoro_preferences_dialog_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/pomodoro/preferences.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "header_bar", FALSE, PomodoroPreferencesDialog_private_offset + G_STRUCT_OFFSET (PomodoroPreferencesDialogPrivate, header_bar));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "stack", FALSE, PomodoroPreferencesDialog_private_offset + G_STRUCT_OFFSET (PomodoroPreferencesDialogPrivate, stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "back_button", FALSE, PomodoroPreferencesDialog_private_offset + G_STRUCT_OFFSET (PomodoroPreferencesDialogPrivate, back_button));
}

static void
pomodoro_preferences_dialog_gtk_buildable_interface_init (GtkBuildableIface * iface,
                                                          gpointer iface_data)
{
	pomodoro_preferences_dialog_gtk_buildable_parent_iface = g_type_interface_peek_parent (iface);
	iface->parser_finished = (void (*) (GtkBuildable*, GtkBuilder*)) pomodoro_preferences_dialog_real_parser_finished;
}

static void
pomodoro_preferences_dialog_instance_init (PomodoroPreferencesDialog * self,
                                           gpointer klass)
{
	self->priv = pomodoro_preferences_dialog_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
pomodoro_preferences_dialog_finalize (GObject * obj)
{
	PomodoroPreferencesDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, POMODORO_TYPE_PREFERENCES_DIALOG, PomodoroPreferencesDialog);
	pomodoro_preferences_dialog_instance = self;
	_g_hash_table_unref0 (self->priv->pages);
	(self->priv->history == NULL) ? NULL : (self->priv->history = (_g_list_free__g_free0_ (self->priv->history), NULL));
	_g_object_unref0 (self->priv->extensions);
	G_OBJECT_CLASS (pomodoro_preferences_dialog_parent_class)->finalize (obj);
}

static GType
pomodoro_preferences_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PomodoroPreferencesDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pomodoro_preferences_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PomodoroPreferencesDialog), 0, (GInstanceInitFunc) pomodoro_preferences_dialog_instance_init, NULL };
	static const GInterfaceInfo gtk_buildable_info = { (GInterfaceInitFunc) pomodoro_preferences_dialog_gtk_buildable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType pomodoro_preferences_dialog_type_id;
	pomodoro_preferences_dialog_type_id = g_type_register_static (gtk_application_window_get_type (), "PomodoroPreferencesDialog", &g_define_type_info, 0);
	g_type_add_interface_static (pomodoro_preferences_dialog_type_id, gtk_buildable_get_type (), &gtk_buildable_info);
	PomodoroPreferencesDialog_private_offset = g_type_add_instance_private (pomodoro_preferences_dialog_type_id, sizeof (PomodoroPreferencesDialogPrivate));
	return pomodoro_preferences_dialog_type_id;
}

GType
pomodoro_preferences_dialog_get_type (void)
{
	static volatile gsize pomodoro_preferences_dialog_type_id__once = 0;
	if (g_once_init_enter (&pomodoro_preferences_dialog_type_id__once)) {
		GType pomodoro_preferences_dialog_type_id;
		pomodoro_preferences_dialog_type_id = pomodoro_preferences_dialog_get_type_once ();
		g_once_init_leave (&pomodoro_preferences_dialog_type_id__once, pomodoro_preferences_dialog_type_id);
	}
	return pomodoro_preferences_dialog_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

