#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize ("O0")
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 2744
#define LARGE_STATE_COUNT 48
#define SYMBOL_COUNT 308
#define ALIAS_COUNT 1
#define TOKEN_COUNT 155
#define EXTERNAL_TOKEN_COUNT 2
#define FIELD_COUNT 35
#define MAX_ALIAS_SEQUENCE_LENGTH 9
#define PRODUCTION_ID_COUNT 77

enum ts_symbol_identifiers {
  anon_sym_PROJECT = 1,
  anon_sym_SLASH = 2,
  anon_sym_COLON = 3,
  anon_sym_VERSION = 4,
  anon_sym_ARG = 5,
  anon_sym_EQ = 6,
  anon_sym_BUILD = 7,
  anon_sym_CACHE = 8,
  anon_sym_CMD = 9,
  anon_sym_COPY = 10,
  anon_sym_DO = 11,
  anon_sym_ENTRYPOINT = 12,
  anon_sym_ENV = 13,
  anon_sym_EQ2 = 14,
  anon_sym_EXPOSE = 15,
  anon_sym_FOR = 16,
  anon_sym_IN = 17,
  anon_sym_END = 18,
  anon_sym_FROM = 19,
  anon_sym_FROMDOCKERFILE = 20,
  anon_sym_FUNCTION = 21,
  anon_sym_COMMAND = 22,
  anon_sym_GITCLONE = 23,
  anon_sym_HOST = 24,
  anon_sym_IF = 25,
  anon_sym_IMPORT = 26,
  anon_sym_AS = 27,
  anon_sym_LET = 28,
  anon_sym_EQ3 = 29,
  anon_sym_LABEL = 30,
  anon_sym_LOCALLY = 31,
  anon_sym_RUN = 32,
  anon_sym_DASH_DASH = 33,
  anon_sym_SAVEARTIFACT = 34,
  anon_sym_ASLOCAL = 35,
  anon_sym_SAVEIMAGE = 36,
  anon_sym_SET = 37,
  anon_sym_TRY = 38,
  anon_sym_FINALLY = 39,
  anon_sym_USER = 40,
  anon_sym_COLON2 = 41,
  anon_sym_VOLUME = 42,
  anon_sym_WAIT = 43,
  anon_sym_WITHDOCKER = 44,
  anon_sym_WORKDIR = 45,
  aux_sym_block_token1 = 46,
  anon_sym_ELSEIF = 47,
  anon_sym_ELSE = 48,
  anon_sym_DOT = 49,
  anon_sym_DASH = 50,
  anon_sym_LPAREN = 51,
  anon_sym_RPAREN = 52,
  anon_sym_LBRACK = 53,
  anon_sym_RBRACK = 54,
  anon_sym_LBRACE = 55,
  anon_sym_RBRACE = 56,
  anon_sym_SLASH2 = 57,
  anon_sym_COMMA = 58,
  anon_sym_AT = 59,
  anon_sym_DOT2 = 60,
  anon_sym_DASH2 = 61,
  anon_sym_LPAREN2 = 62,
  anon_sym_RPAREN2 = 63,
  anon_sym_LBRACK2 = 64,
  anon_sym_RBRACK2 = 65,
  anon_sym_LBRACE2 = 66,
  anon_sym_RBRACE2 = 67,
  anon_sym_COMMA2 = 68,
  anon_sym_AT2 = 69,
  sym_function_ref = 70,
  anon_sym_SPACE = 71,
  sym_number = 72,
  sym_options = 73,
  anon_sym_DOLLAR = 74,
  anon_sym_PLUS = 75,
  anon_sym_DQUOTE = 76,
  aux_sym_shell_fragment_token1 = 77,
  anon_sym_SQUOTE = 78,
  aux_sym_shell_fragment_token2 = 79,
  anon_sym_LBRACK3 = 80,
  anon_sym_LPAREN3 = 81,
  anon_sym_RPAREN3 = 82,
  sym_version_major_minor = 83,
  sym_allow_privileged = 84,
  sym_auto_skip = 85,
  sym_aws = 86,
  anon_sym_DASH_DASHbranch = 87,
  anon_sym_DASH_DASH2 = 88,
  anon_sym_DASH_DASHbuild_DASHarg = 89,
  anon_sym_DASH_DASHcache_DASHid = 90,
  anon_sym_DASH_DASHcache_DASHfrom = 91,
  sym_cache_hint = 92,
  anon_sym_DASH_DASHchmod = 93,
  anon_sym_DASH_DASHchown = 94,
  anon_sym_DASH_DASHcompose = 95,
  sym_dir = 96,
  anon_sym_DASHf = 97,
  anon_sym_DASH_DASHtarget = 98,
  sym_entrypoint = 99,
  sym_feature_flag = 100,
  sym_force = 101,
  sym_global = 102,
  anon_sym_DASH_DASHid = 103,
  sym_if_exists = 104,
  anon_sym_DASH_DASHinteractive = 105,
  anon_sym_DASH_DASHinteractive_DASHkeep = 106,
  sym_keep_own = 107,
  sym_keep_ts = 108,
  anon_sym_DASH_DASHload = 109,
  anon_sym_DASH_DASHmount = 110,
  sym_network_none = 111,
  sym_no_cache = 112,
  anon_sym_DASH_DASHoidc = 113,
  sym_pass_args = 114,
  sym_persist = 115,
  anon_sym_DASH_DASHplatform = 116,
  sym_privileged = 117,
  anon_sym_DASH_DASHpull = 118,
  sym_push = 119,
  sym_raw_output = 120,
  sym_required = 121,
  anon_sym_DASH_DASHsecret = 122,
  anon_sym_EQ4 = 123,
  anon_sym_DASH_DASHsep = 124,
  anon_sym_DASH_DASHservice = 125,
  anon_sym_DASH_DASHsharing = 126,
  sym_ssh = 127,
  sym_symlink_no_follow = 128,
  aux_sym_unknown_option_token1 = 129,
  sym_without_earthly_labels = 130,
  sym__string_base_other = 131,
  sym__string_base_alpha = 132,
  sym__string_base_num = 133,
  sym__immediate_string_base_other = 134,
  sym__immediate_string_base_alpha = 135,
  sym__immediate_string_base_num = 136,
  aux_sym_double_quoted_string_token1 = 137,
  anon_sym_DQUOTE2 = 138,
  anon_sym_SQUOTE2 = 139,
  aux_sym_single_quoted_string_token1 = 140,
  anon_sym_PLUS2 = 141,
  aux_sym_unquoted_string_with_spaces_token1 = 142,
  anon_sym_RPAREN4 = 143,
  anon_sym_DOLLAR2 = 144,
  aux_sym__immediate_escape_sequence_token1 = 145,
  sym_line_continuation = 146,
  sym_comment = 147,
  sym_line_continuation_comment = 148,
  anon_sym_LF = 149,
  anon_sym_CR_LF = 150,
  anon_sym_FF = 151,
  anon_sym_NULL = 152,
  sym__indent = 153,
  sym__dedent = 154,
  sym_source_file = 155,
  sym_project_command = 156,
  sym_target = 157,
  sym_version_command = 158,
  sym_version_options = 159,
  sym_arg_command = 160,
  sym_arg_options = 161,
  sym_build_command = 162,
  sym_build_options = 163,
  sym_cache_command = 164,
  sym_cache_options = 165,
  sym_cmd_command = 166,
  sym_copy_command = 167,
  sym_copy_options = 168,
  sym_do_command = 169,
  sym_do_options = 170,
  sym_entrypoint_command = 171,
  sym_env_command = 172,
  sym_expose_command = 173,
  sym_for_command = 174,
  sym_for_options = 175,
  sym_from_command = 176,
  sym_from_options = 177,
  sym_from_dockerfile_command = 178,
  sym_from_dockerfile_options = 179,
  sym_function_command = 180,
  sym_git_clone_command = 181,
  sym_git_clone_options = 182,
  sym_host_command = 183,
  sym_if_command = 184,
  sym_import_command = 185,
  sym_import_options = 186,
  sym_let_command = 187,
  sym_label_command = 188,
  sym_locally_command = 189,
  sym_run_command = 190,
  sym_run_options = 191,
  sym_save_artifact_command = 192,
  sym_save_artifact_options = 193,
  sym_save_image_command = 194,
  sym_save_image_options = 195,
  sym_set_command = 196,
  sym_try_command = 197,
  sym_try_command_finally_block = 198,
  sym_user_command = 199,
  sym_volume_command = 200,
  sym_wait_command = 201,
  sym_with_docker_command = 202,
  sym_with_docker_options = 203,
  sym_workdir_command = 204,
  sym_block = 205,
  sym__conditional_block = 206,
  aux_sym__conditional_block_options = 207,
  sym_elif_block = 208,
  sym_else_block = 209,
  sym__immediate_identifier = 210,
  sym_earthfile_ref = 211,
  sym_identifier = 212,
  sym_image_spec = 213,
  sym_image_name = 214,
  sym_image_tag = 215,
  sym_image_digest = 216,
  sym_images = 217,
  sym_label = 218,
  sym_shell_fragment = 219,
  sym_string_array = 220,
  sym_target_ref = 221,
  sym_target_ref_with_build_args = 222,
  sym_target_artifact = 223,
  sym_target_artifact_build_args = 224,
  sym_variable = 225,
  sym_branch = 226,
  sym_build_arg = 227,
  sym_build_args = 228,
  sym_build_arg_deprecated = 229,
  sym_cache_id = 230,
  sym_cache_from = 231,
  sym_chmod = 232,
  sym_chown = 233,
  sym_compose = 234,
  sym_docker_build_arg = 235,
  sym_docker_file = 236,
  sym_docker_target = 237,
  sym_id = 238,
  sym_interactive = 239,
  sym_load = 240,
  sym_mount = 241,
  sym_oidc = 242,
  sym_platform = 243,
  sym_pull = 244,
  sym_secret = 245,
  sym_sep = 246,
  sym_service = 247,
  sym_sharing = 248,
  sym_unknown_option = 249,
  sym__string_base = 250,
  sym__immediate_string_base = 251,
  sym_double_quoted_string = 252,
  sym__immediate_double_quoted_string = 253,
  sym_single_quoted_string = 254,
  sym__immediate_single_quoted_string = 255,
  sym_unquoted_string = 256,
  sym__immediate_unquoted_string = 257,
  sym_unquoted_string_with_spaces = 258,
  sym_string_with_spaces = 259,
  sym_string = 260,
  sym_strings = 261,
  sym_expansion = 262,
  sym__immediate_expansion = 263,
  sym__immediate_variable = 264,
  sym__immediate_escape_sequence = 265,
  sym_escape_sequence = 266,
  sym__eol = 267,
  aux_sym_source_file_repeat1 = 268,
  aux_sym_version_options_repeat1 = 269,
  aux_sym_arg_options_repeat1 = 270,
  aux_sym_build_options_repeat1 = 271,
  aux_sym_cache_options_repeat1 = 272,
  aux_sym_copy_command_repeat1 = 273,
  aux_sym_copy_options_repeat1 = 274,
  aux_sym_do_options_repeat1 = 275,
  aux_sym_expose_command_repeat1 = 276,
  aux_sym_for_options_repeat1 = 277,
  aux_sym_from_options_repeat1 = 278,
  aux_sym_from_dockerfile_options_repeat1 = 279,
  aux_sym_git_clone_options_repeat1 = 280,
  aux_sym_if_command_repeat1 = 281,
  aux_sym_import_options_repeat1 = 282,
  aux_sym_label_command_repeat1 = 283,
  aux_sym_run_options_repeat1 = 284,
  aux_sym_save_artifact_options_repeat1 = 285,
  aux_sym_save_image_options_repeat1 = 286,
  aux_sym_try_command_finally_block_repeat1 = 287,
  aux_sym_with_docker_options_repeat1 = 288,
  aux_sym_block_repeat1 = 289,
  aux_sym__immediate_identifier_repeat1 = 290,
  aux_sym_earthfile_ref_repeat1 = 291,
  aux_sym_image_name_repeat1 = 292,
  aux_sym_image_digest_repeat1 = 293,
  aux_sym_images_repeat1 = 294,
  aux_sym_shell_fragment_repeat1 = 295,
  aux_sym_shell_fragment_repeat2 = 296,
  aux_sym_shell_fragment_repeat3 = 297,
  aux_sym_string_array_repeat1 = 298,
  aux_sym_variable_repeat1 = 299,
  aux_sym_build_args_repeat1 = 300,
  aux_sym__immediate_string_base_repeat1 = 301,
  aux_sym_double_quoted_string_repeat1 = 302,
  aux_sym_single_quoted_string_repeat1 = 303,
  aux_sym_unquoted_string_repeat1 = 304,
  aux_sym_unquoted_string_with_spaces_repeat1 = 305,
  aux_sym_string_with_spaces_repeat1 = 306,
  aux_sym_string_repeat1 = 307,
  alias_sym__immediate_escape_sequence = 308,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [anon_sym_PROJECT] = "PROJECT",
  [anon_sym_SLASH] = "/",
  [anon_sym_COLON] = ":",
  [anon_sym_VERSION] = "VERSION",
  [anon_sym_ARG] = "ARG",
  [anon_sym_EQ] = "=",
  [anon_sym_BUILD] = "BUILD",
  [anon_sym_CACHE] = "CACHE",
  [anon_sym_CMD] = "CMD",
  [anon_sym_COPY] = "COPY",
  [anon_sym_DO] = "DO",
  [anon_sym_ENTRYPOINT] = "ENTRYPOINT",
  [anon_sym_ENV] = "ENV",
  [anon_sym_EQ2] = "=",
  [anon_sym_EXPOSE] = "EXPOSE",
  [anon_sym_FOR] = "FOR",
  [anon_sym_IN] = "IN",
  [anon_sym_END] = "END",
  [anon_sym_FROM] = "FROM",
  [anon_sym_FROMDOCKERFILE] = "FROM DOCKERFILE",
  [anon_sym_FUNCTION] = "FUNCTION",
  [anon_sym_COMMAND] = "COMMAND",
  [anon_sym_GITCLONE] = "GIT CLONE",
  [anon_sym_HOST] = "HOST",
  [anon_sym_IF] = "IF",
  [anon_sym_IMPORT] = "IMPORT",
  [anon_sym_AS] = "AS",
  [anon_sym_LET] = "LET",
  [anon_sym_EQ3] = "=",
  [anon_sym_LABEL] = "LABEL",
  [anon_sym_LOCALLY] = "LOCALLY",
  [anon_sym_RUN] = "RUN",
  [anon_sym_DASH_DASH] = "-- ",
  [anon_sym_SAVEARTIFACT] = "SAVE ARTIFACT",
  [anon_sym_ASLOCAL] = "AS LOCAL",
  [anon_sym_SAVEIMAGE] = "SAVE IMAGE",
  [anon_sym_SET] = "SET",
  [anon_sym_TRY] = "TRY",
  [anon_sym_FINALLY] = "FINALLY",
  [anon_sym_USER] = "USER",
  [anon_sym_COLON2] = ":",
  [anon_sym_VOLUME] = "VOLUME",
  [anon_sym_WAIT] = "WAIT",
  [anon_sym_WITHDOCKER] = "WITH DOCKER",
  [anon_sym_WORKDIR] = "WORKDIR",
  [aux_sym_block_token1] = "block_token1",
  [anon_sym_ELSEIF] = "ELSE IF",
  [anon_sym_ELSE] = "ELSE",
  [anon_sym_DOT] = ".",
  [anon_sym_DASH] = "-",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_SLASH2] = "/",
  [anon_sym_COMMA] = ",",
  [anon_sym_AT] = "@",
  [anon_sym_DOT2] = ".",
  [anon_sym_DASH2] = "-",
  [anon_sym_LPAREN2] = "(",
  [anon_sym_RPAREN2] = ")",
  [anon_sym_LBRACK2] = "[",
  [anon_sym_RBRACK2] = "]",
  [anon_sym_LBRACE2] = "{",
  [anon_sym_RBRACE2] = "}",
  [anon_sym_COMMA2] = ",",
  [anon_sym_AT2] = "@",
  [sym_function_ref] = "function_ref",
  [anon_sym_SPACE] = " ",
  [sym_number] = "number",
  [sym_options] = "options",
  [anon_sym_DOLLAR] = "$",
  [anon_sym_PLUS] = "+",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym_shell_fragment_token1] = "shell_fragment_token1",
  [anon_sym_SQUOTE] = "'",
  [aux_sym_shell_fragment_token2] = "shell_fragment_token2",
  [anon_sym_LBRACK3] = "[",
  [anon_sym_LPAREN3] = "(",
  [anon_sym_RPAREN3] = ")",
  [sym_version_major_minor] = "version_major_minor",
  [sym_allow_privileged] = "allow_privileged",
  [sym_auto_skip] = "auto_skip",
  [sym_aws] = "aws",
  [anon_sym_DASH_DASHbranch] = "--branch",
  [anon_sym_DASH_DASH2] = "--",
  [anon_sym_DASH_DASHbuild_DASHarg] = "--build-arg",
  [anon_sym_DASH_DASHcache_DASHid] = "--cache-id",
  [anon_sym_DASH_DASHcache_DASHfrom] = "--cache-from",
  [sym_cache_hint] = "cache_hint",
  [anon_sym_DASH_DASHchmod] = "--chmod",
  [anon_sym_DASH_DASHchown] = "--chown",
  [anon_sym_DASH_DASHcompose] = "--compose",
  [sym_dir] = "dir",
  [anon_sym_DASHf] = "-f",
  [anon_sym_DASH_DASHtarget] = "--target",
  [sym_entrypoint] = "entrypoint",
  [sym_feature_flag] = "feature_flag",
  [sym_force] = "force",
  [sym_global] = "global",
  [anon_sym_DASH_DASHid] = "--id",
  [sym_if_exists] = "if_exists",
  [anon_sym_DASH_DASHinteractive] = "--interactive",
  [anon_sym_DASH_DASHinteractive_DASHkeep] = "--interactive-keep",
  [sym_keep_own] = "keep_own",
  [sym_keep_ts] = "keep_ts",
  [anon_sym_DASH_DASHload] = "--load",
  [anon_sym_DASH_DASHmount] = "--mount",
  [sym_network_none] = "network_none",
  [sym_no_cache] = "no_cache",
  [anon_sym_DASH_DASHoidc] = "--oidc",
  [sym_pass_args] = "pass_args",
  [sym_persist] = "persist",
  [anon_sym_DASH_DASHplatform] = "--platform",
  [sym_privileged] = "privileged",
  [anon_sym_DASH_DASHpull] = "--pull",
  [sym_push] = "push",
  [sym_raw_output] = "raw_output",
  [sym_required] = "required",
  [anon_sym_DASH_DASHsecret] = "--secret",
  [anon_sym_EQ4] = "=",
  [anon_sym_DASH_DASHsep] = "--sep",
  [anon_sym_DASH_DASHservice] = "--service",
  [anon_sym_DASH_DASHsharing] = "--sharing",
  [sym_ssh] = "ssh",
  [sym_symlink_no_follow] = "symlink_no_follow",
  [aux_sym_unknown_option_token1] = "unknown_option_token1",
  [sym_without_earthly_labels] = "without_earthly_labels",
  [sym__string_base_other] = "_string_base_other",
  [sym__string_base_alpha] = "_string_base_alpha",
  [sym__string_base_num] = "_string_base_num",
  [sym__immediate_string_base_other] = "_immediate_string_base_other",
  [sym__immediate_string_base_alpha] = "_immediate_string_base_alpha",
  [sym__immediate_string_base_num] = "_immediate_string_base_num",
  [aux_sym_double_quoted_string_token1] = "double_quoted_string_token1",
  [anon_sym_DQUOTE2] = "\"",
  [anon_sym_SQUOTE2] = "'",
  [aux_sym_single_quoted_string_token1] = "single_quoted_string_token1",
  [anon_sym_PLUS2] = "+",
  [aux_sym_unquoted_string_with_spaces_token1] = "unquoted_string_with_spaces_token1",
  [anon_sym_RPAREN4] = ")",
  [anon_sym_DOLLAR2] = "$",
  [aux_sym__immediate_escape_sequence_token1] = "_immediate_escape_sequence_token1",
  [sym_line_continuation] = "line_continuation",
  [sym_comment] = "comment",
  [sym_line_continuation_comment] = "line_continuation_comment",
  [anon_sym_LF] = "\n",
  [anon_sym_CR_LF] = "\r\n",
  [anon_sym_FF] = "\f",
  [anon_sym_NULL] = "\0",
  [sym__indent] = "_indent",
  [sym__dedent] = "_dedent",
  [sym_source_file] = "source_file",
  [sym_project_command] = "project_command",
  [sym_target] = "target",
  [sym_version_command] = "version_command",
  [sym_version_options] = "options",
  [sym_arg_command] = "arg_command",
  [sym_arg_options] = "options",
  [sym_build_command] = "build_command",
  [sym_build_options] = "options",
  [sym_cache_command] = "cache_command",
  [sym_cache_options] = "options",
  [sym_cmd_command] = "cmd_command",
  [sym_copy_command] = "copy_command",
  [sym_copy_options] = "options",
  [sym_do_command] = "do_command",
  [sym_do_options] = "options",
  [sym_entrypoint_command] = "entrypoint_command",
  [sym_env_command] = "env_command",
  [sym_expose_command] = "expose_command",
  [sym_for_command] = "for_command",
  [sym_for_options] = "options",
  [sym_from_command] = "from_command",
  [sym_from_options] = "options",
  [sym_from_dockerfile_command] = "from_dockerfile_command",
  [sym_from_dockerfile_options] = "options",
  [sym_function_command] = "function_command",
  [sym_git_clone_command] = "git_clone_command",
  [sym_git_clone_options] = "options",
  [sym_host_command] = "host_command",
  [sym_if_command] = "if_command",
  [sym_import_command] = "import_command",
  [sym_import_options] = "options",
  [sym_let_command] = "let_command",
  [sym_label_command] = "label_command",
  [sym_locally_command] = "locally_command",
  [sym_run_command] = "run_command",
  [sym_run_options] = "options",
  [sym_save_artifact_command] = "save_artifact_command",
  [sym_save_artifact_options] = "options",
  [sym_save_image_command] = "save_image_command",
  [sym_save_image_options] = "options",
  [sym_set_command] = "set_command",
  [sym_try_command] = "try_command",
  [sym_try_command_finally_block] = "block",
  [sym_user_command] = "user_command",
  [sym_volume_command] = "volume_command",
  [sym_wait_command] = "wait_command",
  [sym_with_docker_command] = "with_docker_command",
  [sym_with_docker_options] = "options",
  [sym_workdir_command] = "workdir_command",
  [sym_block] = "block",
  [sym__conditional_block] = "_conditional_block",
  [aux_sym__conditional_block_options] = "_conditional_block_options",
  [sym_elif_block] = "elif_block",
  [sym_else_block] = "else_block",
  [sym__immediate_identifier] = "identifier",
  [sym_earthfile_ref] = "earthfile_ref",
  [sym_identifier] = "identifier",
  [sym_image_spec] = "image_spec",
  [sym_image_name] = "image_name",
  [sym_image_tag] = "image_tag",
  [sym_image_digest] = "image_digest",
  [sym_images] = "images",
  [sym_label] = "label",
  [sym_shell_fragment] = "shell_fragment",
  [sym_string_array] = "string_array",
  [sym_target_ref] = "target_ref",
  [sym_target_ref_with_build_args] = "target_ref_with_build_args",
  [sym_target_artifact] = "target_artifact",
  [sym_target_artifact_build_args] = "target_artifact_build_args",
  [sym_variable] = "variable",
  [sym_branch] = "branch",
  [sym_build_arg] = "build_arg",
  [sym_build_args] = "build_args",
  [sym_build_arg_deprecated] = "build_arg_deprecated",
  [sym_cache_id] = "cache_id",
  [sym_cache_from] = "cache_from",
  [sym_chmod] = "chmod",
  [sym_chown] = "chown",
  [sym_compose] = "compose",
  [sym_docker_build_arg] = "docker_build_arg",
  [sym_docker_file] = "docker_file",
  [sym_docker_target] = "docker_target",
  [sym_id] = "id",
  [sym_interactive] = "interactive",
  [sym_load] = "load",
  [sym_mount] = "mount",
  [sym_oidc] = "oidc",
  [sym_platform] = "platform",
  [sym_pull] = "pull",
  [sym_secret] = "secret",
  [sym_sep] = "sep",
  [sym_service] = "service",
  [sym_sharing] = "sharing",
  [sym_unknown_option] = "unknown_option",
  [sym__string_base] = "_string_base",
  [sym__immediate_string_base] = "_immediate_string_base",
  [sym_double_quoted_string] = "double_quoted_string",
  [sym__immediate_double_quoted_string] = "double_quoted_string",
  [sym_single_quoted_string] = "single_quoted_string",
  [sym__immediate_single_quoted_string] = "single_quoted_string",
  [sym_unquoted_string] = "unquoted_string",
  [sym__immediate_unquoted_string] = "unquoted_string",
  [sym_unquoted_string_with_spaces] = "unquoted_string",
  [sym_string_with_spaces] = "string",
  [sym_string] = "string",
  [sym_strings] = "strings",
  [sym_expansion] = "expansion",
  [sym__immediate_expansion] = "expansion",
  [sym__immediate_variable] = "variable",
  [sym__immediate_escape_sequence] = "_immediate_escape_sequence",
  [sym_escape_sequence] = "escape_sequence",
  [sym__eol] = "_eol",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym_version_options_repeat1] = "version_options_repeat1",
  [aux_sym_arg_options_repeat1] = "arg_options_repeat1",
  [aux_sym_build_options_repeat1] = "build_options_repeat1",
  [aux_sym_cache_options_repeat1] = "cache_options_repeat1",
  [aux_sym_copy_command_repeat1] = "copy_command_repeat1",
  [aux_sym_copy_options_repeat1] = "copy_options_repeat1",
  [aux_sym_do_options_repeat1] = "do_options_repeat1",
  [aux_sym_expose_command_repeat1] = "expose_command_repeat1",
  [aux_sym_for_options_repeat1] = "for_options_repeat1",
  [aux_sym_from_options_repeat1] = "from_options_repeat1",
  [aux_sym_from_dockerfile_options_repeat1] = "from_dockerfile_options_repeat1",
  [aux_sym_git_clone_options_repeat1] = "git_clone_options_repeat1",
  [aux_sym_if_command_repeat1] = "if_command_repeat1",
  [aux_sym_import_options_repeat1] = "import_options_repeat1",
  [aux_sym_label_command_repeat1] = "label_command_repeat1",
  [aux_sym_run_options_repeat1] = "run_options_repeat1",
  [aux_sym_save_artifact_options_repeat1] = "save_artifact_options_repeat1",
  [aux_sym_save_image_options_repeat1] = "save_image_options_repeat1",
  [aux_sym_try_command_finally_block_repeat1] = "try_command_finally_block_repeat1",
  [aux_sym_with_docker_options_repeat1] = "with_docker_options_repeat1",
  [aux_sym_block_repeat1] = "block_repeat1",
  [aux_sym__immediate_identifier_repeat1] = "_immediate_identifier_repeat1",
  [aux_sym_earthfile_ref_repeat1] = "earthfile_ref_repeat1",
  [aux_sym_image_name_repeat1] = "image_name_repeat1",
  [aux_sym_image_digest_repeat1] = "image_digest_repeat1",
  [aux_sym_images_repeat1] = "images_repeat1",
  [aux_sym_shell_fragment_repeat1] = "shell_fragment_repeat1",
  [aux_sym_shell_fragment_repeat2] = "shell_fragment_repeat2",
  [aux_sym_shell_fragment_repeat3] = "shell_fragment_repeat3",
  [aux_sym_string_array_repeat1] = "string_array_repeat1",
  [aux_sym_variable_repeat1] = "variable_repeat1",
  [aux_sym_build_args_repeat1] = "build_args_repeat1",
  [aux_sym__immediate_string_base_repeat1] = "_immediate_string_base_repeat1",
  [aux_sym_double_quoted_string_repeat1] = "double_quoted_string_repeat1",
  [aux_sym_single_quoted_string_repeat1] = "single_quoted_string_repeat1",
  [aux_sym_unquoted_string_repeat1] = "unquoted_string_repeat1",
  [aux_sym_unquoted_string_with_spaces_repeat1] = "unquoted_string_with_spaces_repeat1",
  [aux_sym_string_with_spaces_repeat1] = "string_with_spaces_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [alias_sym__immediate_escape_sequence] = "_immediate_escape_sequence",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [anon_sym_PROJECT] = anon_sym_PROJECT,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_VERSION] = anon_sym_VERSION,
  [anon_sym_ARG] = anon_sym_ARG,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_BUILD] = anon_sym_BUILD,
  [anon_sym_CACHE] = anon_sym_CACHE,
  [anon_sym_CMD] = anon_sym_CMD,
  [anon_sym_COPY] = anon_sym_COPY,
  [anon_sym_DO] = anon_sym_DO,
  [anon_sym_ENTRYPOINT] = anon_sym_ENTRYPOINT,
  [anon_sym_ENV] = anon_sym_ENV,
  [anon_sym_EQ2] = anon_sym_EQ,
  [anon_sym_EXPOSE] = anon_sym_EXPOSE,
  [anon_sym_FOR] = anon_sym_FOR,
  [anon_sym_IN] = anon_sym_IN,
  [anon_sym_END] = anon_sym_END,
  [anon_sym_FROM] = anon_sym_FROM,
  [anon_sym_FROMDOCKERFILE] = anon_sym_FROMDOCKERFILE,
  [anon_sym_FUNCTION] = anon_sym_FUNCTION,
  [anon_sym_COMMAND] = anon_sym_COMMAND,
  [anon_sym_GITCLONE] = anon_sym_GITCLONE,
  [anon_sym_HOST] = anon_sym_HOST,
  [anon_sym_IF] = anon_sym_IF,
  [anon_sym_IMPORT] = anon_sym_IMPORT,
  [anon_sym_AS] = anon_sym_AS,
  [anon_sym_LET] = anon_sym_LET,
  [anon_sym_EQ3] = anon_sym_EQ,
  [anon_sym_LABEL] = anon_sym_LABEL,
  [anon_sym_LOCALLY] = anon_sym_LOCALLY,
  [anon_sym_RUN] = anon_sym_RUN,
  [anon_sym_DASH_DASH] = anon_sym_DASH_DASH,
  [anon_sym_SAVEARTIFACT] = anon_sym_SAVEARTIFACT,
  [anon_sym_ASLOCAL] = anon_sym_ASLOCAL,
  [anon_sym_SAVEIMAGE] = anon_sym_SAVEIMAGE,
  [anon_sym_SET] = anon_sym_SET,
  [anon_sym_TRY] = anon_sym_TRY,
  [anon_sym_FINALLY] = anon_sym_FINALLY,
  [anon_sym_USER] = anon_sym_USER,
  [anon_sym_COLON2] = anon_sym_COLON,
  [anon_sym_VOLUME] = anon_sym_VOLUME,
  [anon_sym_WAIT] = anon_sym_WAIT,
  [anon_sym_WITHDOCKER] = anon_sym_WITHDOCKER,
  [anon_sym_WORKDIR] = anon_sym_WORKDIR,
  [aux_sym_block_token1] = aux_sym_block_token1,
  [anon_sym_ELSEIF] = anon_sym_ELSEIF,
  [anon_sym_ELSE] = anon_sym_ELSE,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_SLASH2] = anon_sym_SLASH,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_DOT2] = anon_sym_DOT,
  [anon_sym_DASH2] = anon_sym_DASH,
  [anon_sym_LPAREN2] = anon_sym_LPAREN,
  [anon_sym_RPAREN2] = anon_sym_RPAREN,
  [anon_sym_LBRACK2] = anon_sym_LBRACK,
  [anon_sym_RBRACK2] = anon_sym_RBRACK,
  [anon_sym_LBRACE2] = anon_sym_LBRACE,
  [anon_sym_RBRACE2] = anon_sym_RBRACE,
  [anon_sym_COMMA2] = anon_sym_COMMA,
  [anon_sym_AT2] = anon_sym_AT,
  [sym_function_ref] = sym_function_ref,
  [anon_sym_SPACE] = anon_sym_SPACE,
  [sym_number] = sym_number,
  [sym_options] = sym_options,
  [anon_sym_DOLLAR] = anon_sym_DOLLAR,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym_shell_fragment_token1] = aux_sym_shell_fragment_token1,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [aux_sym_shell_fragment_token2] = aux_sym_shell_fragment_token2,
  [anon_sym_LBRACK3] = anon_sym_LBRACK,
  [anon_sym_LPAREN3] = anon_sym_LPAREN,
  [anon_sym_RPAREN3] = anon_sym_RPAREN,
  [sym_version_major_minor] = sym_version_major_minor,
  [sym_allow_privileged] = sym_allow_privileged,
  [sym_auto_skip] = sym_auto_skip,
  [sym_aws] = sym_aws,
  [anon_sym_DASH_DASHbranch] = anon_sym_DASH_DASHbranch,
  [anon_sym_DASH_DASH2] = anon_sym_DASH_DASH2,
  [anon_sym_DASH_DASHbuild_DASHarg] = anon_sym_DASH_DASHbuild_DASHarg,
  [anon_sym_DASH_DASHcache_DASHid] = anon_sym_DASH_DASHcache_DASHid,
  [anon_sym_DASH_DASHcache_DASHfrom] = anon_sym_DASH_DASHcache_DASHfrom,
  [sym_cache_hint] = sym_cache_hint,
  [anon_sym_DASH_DASHchmod] = anon_sym_DASH_DASHchmod,
  [anon_sym_DASH_DASHchown] = anon_sym_DASH_DASHchown,
  [anon_sym_DASH_DASHcompose] = anon_sym_DASH_DASHcompose,
  [sym_dir] = sym_dir,
  [anon_sym_DASHf] = anon_sym_DASHf,
  [anon_sym_DASH_DASHtarget] = anon_sym_DASH_DASHtarget,
  [sym_entrypoint] = sym_entrypoint,
  [sym_feature_flag] = sym_feature_flag,
  [sym_force] = sym_force,
  [sym_global] = sym_global,
  [anon_sym_DASH_DASHid] = anon_sym_DASH_DASHid,
  [sym_if_exists] = sym_if_exists,
  [anon_sym_DASH_DASHinteractive] = anon_sym_DASH_DASHinteractive,
  [anon_sym_DASH_DASHinteractive_DASHkeep] = anon_sym_DASH_DASHinteractive_DASHkeep,
  [sym_keep_own] = sym_keep_own,
  [sym_keep_ts] = sym_keep_ts,
  [anon_sym_DASH_DASHload] = anon_sym_DASH_DASHload,
  [anon_sym_DASH_DASHmount] = anon_sym_DASH_DASHmount,
  [sym_network_none] = sym_network_none,
  [sym_no_cache] = sym_no_cache,
  [anon_sym_DASH_DASHoidc] = anon_sym_DASH_DASHoidc,
  [sym_pass_args] = sym_pass_args,
  [sym_persist] = sym_persist,
  [anon_sym_DASH_DASHplatform] = anon_sym_DASH_DASHplatform,
  [sym_privileged] = sym_privileged,
  [anon_sym_DASH_DASHpull] = anon_sym_DASH_DASHpull,
  [sym_push] = sym_push,
  [sym_raw_output] = sym_raw_output,
  [sym_required] = sym_required,
  [anon_sym_DASH_DASHsecret] = anon_sym_DASH_DASHsecret,
  [anon_sym_EQ4] = anon_sym_EQ,
  [anon_sym_DASH_DASHsep] = anon_sym_DASH_DASHsep,
  [anon_sym_DASH_DASHservice] = anon_sym_DASH_DASHservice,
  [anon_sym_DASH_DASHsharing] = anon_sym_DASH_DASHsharing,
  [sym_ssh] = sym_ssh,
  [sym_symlink_no_follow] = sym_symlink_no_follow,
  [aux_sym_unknown_option_token1] = aux_sym_unknown_option_token1,
  [sym_without_earthly_labels] = sym_without_earthly_labels,
  [sym__string_base_other] = sym__string_base_other,
  [sym__string_base_alpha] = sym__string_base_alpha,
  [sym__string_base_num] = sym__string_base_num,
  [sym__immediate_string_base_other] = sym__immediate_string_base_other,
  [sym__immediate_string_base_alpha] = sym__immediate_string_base_alpha,
  [sym__immediate_string_base_num] = sym__immediate_string_base_num,
  [aux_sym_double_quoted_string_token1] = aux_sym_double_quoted_string_token1,
  [anon_sym_DQUOTE2] = anon_sym_DQUOTE,
  [anon_sym_SQUOTE2] = anon_sym_SQUOTE,
  [aux_sym_single_quoted_string_token1] = aux_sym_single_quoted_string_token1,
  [anon_sym_PLUS2] = anon_sym_PLUS,
  [aux_sym_unquoted_string_with_spaces_token1] = aux_sym_unquoted_string_with_spaces_token1,
  [anon_sym_RPAREN4] = anon_sym_RPAREN,
  [anon_sym_DOLLAR2] = anon_sym_DOLLAR,
  [aux_sym__immediate_escape_sequence_token1] = aux_sym__immediate_escape_sequence_token1,
  [sym_line_continuation] = sym_line_continuation,
  [sym_comment] = sym_comment,
  [sym_line_continuation_comment] = sym_line_continuation_comment,
  [anon_sym_LF] = anon_sym_LF,
  [anon_sym_CR_LF] = anon_sym_CR_LF,
  [anon_sym_FF] = anon_sym_FF,
  [anon_sym_NULL] = anon_sym_NULL,
  [sym__indent] = sym__indent,
  [sym__dedent] = sym__dedent,
  [sym_source_file] = sym_source_file,
  [sym_project_command] = sym_project_command,
  [sym_target] = sym_target,
  [sym_version_command] = sym_version_command,
  [sym_version_options] = sym_options,
  [sym_arg_command] = sym_arg_command,
  [sym_arg_options] = sym_options,
  [sym_build_command] = sym_build_command,
  [sym_build_options] = sym_options,
  [sym_cache_command] = sym_cache_command,
  [sym_cache_options] = sym_options,
  [sym_cmd_command] = sym_cmd_command,
  [sym_copy_command] = sym_copy_command,
  [sym_copy_options] = sym_options,
  [sym_do_command] = sym_do_command,
  [sym_do_options] = sym_options,
  [sym_entrypoint_command] = sym_entrypoint_command,
  [sym_env_command] = sym_env_command,
  [sym_expose_command] = sym_expose_command,
  [sym_for_command] = sym_for_command,
  [sym_for_options] = sym_options,
  [sym_from_command] = sym_from_command,
  [sym_from_options] = sym_options,
  [sym_from_dockerfile_command] = sym_from_dockerfile_command,
  [sym_from_dockerfile_options] = sym_options,
  [sym_function_command] = sym_function_command,
  [sym_git_clone_command] = sym_git_clone_command,
  [sym_git_clone_options] = sym_options,
  [sym_host_command] = sym_host_command,
  [sym_if_command] = sym_if_command,
  [sym_import_command] = sym_import_command,
  [sym_import_options] = sym_options,
  [sym_let_command] = sym_let_command,
  [sym_label_command] = sym_label_command,
  [sym_locally_command] = sym_locally_command,
  [sym_run_command] = sym_run_command,
  [sym_run_options] = sym_options,
  [sym_save_artifact_command] = sym_save_artifact_command,
  [sym_save_artifact_options] = sym_options,
  [sym_save_image_command] = sym_save_image_command,
  [sym_save_image_options] = sym_options,
  [sym_set_command] = sym_set_command,
  [sym_try_command] = sym_try_command,
  [sym_try_command_finally_block] = sym_block,
  [sym_user_command] = sym_user_command,
  [sym_volume_command] = sym_volume_command,
  [sym_wait_command] = sym_wait_command,
  [sym_with_docker_command] = sym_with_docker_command,
  [sym_with_docker_options] = sym_options,
  [sym_workdir_command] = sym_workdir_command,
  [sym_block] = sym_block,
  [sym__conditional_block] = sym__conditional_block,
  [aux_sym__conditional_block_options] = aux_sym__conditional_block_options,
  [sym_elif_block] = sym_elif_block,
  [sym_else_block] = sym_else_block,
  [sym__immediate_identifier] = sym_identifier,
  [sym_earthfile_ref] = sym_earthfile_ref,
  [sym_identifier] = sym_identifier,
  [sym_image_spec] = sym_image_spec,
  [sym_image_name] = sym_image_name,
  [sym_image_tag] = sym_image_tag,
  [sym_image_digest] = sym_image_digest,
  [sym_images] = sym_images,
  [sym_label] = sym_label,
  [sym_shell_fragment] = sym_shell_fragment,
  [sym_string_array] = sym_string_array,
  [sym_target_ref] = sym_target_ref,
  [sym_target_ref_with_build_args] = sym_target_ref_with_build_args,
  [sym_target_artifact] = sym_target_artifact,
  [sym_target_artifact_build_args] = sym_target_artifact_build_args,
  [sym_variable] = sym_variable,
  [sym_branch] = sym_branch,
  [sym_build_arg] = sym_build_arg,
  [sym_build_args] = sym_build_args,
  [sym_build_arg_deprecated] = sym_build_arg_deprecated,
  [sym_cache_id] = sym_cache_id,
  [sym_cache_from] = sym_cache_from,
  [sym_chmod] = sym_chmod,
  [sym_chown] = sym_chown,
  [sym_compose] = sym_compose,
  [sym_docker_build_arg] = sym_docker_build_arg,
  [sym_docker_file] = sym_docker_file,
  [sym_docker_target] = sym_docker_target,
  [sym_id] = sym_id,
  [sym_interactive] = sym_interactive,
  [sym_load] = sym_load,
  [sym_mount] = sym_mount,
  [sym_oidc] = sym_oidc,
  [sym_platform] = sym_platform,
  [sym_pull] = sym_pull,
  [sym_secret] = sym_secret,
  [sym_sep] = sym_sep,
  [sym_service] = sym_service,
  [sym_sharing] = sym_sharing,
  [sym_unknown_option] = sym_unknown_option,
  [sym__string_base] = sym__string_base,
  [sym__immediate_string_base] = sym__immediate_string_base,
  [sym_double_quoted_string] = sym_double_quoted_string,
  [sym__immediate_double_quoted_string] = sym_double_quoted_string,
  [sym_single_quoted_string] = sym_single_quoted_string,
  [sym__immediate_single_quoted_string] = sym_single_quoted_string,
  [sym_unquoted_string] = sym_unquoted_string,
  [sym__immediate_unquoted_string] = sym_unquoted_string,
  [sym_unquoted_string_with_spaces] = sym_unquoted_string,
  [sym_string_with_spaces] = sym_string,
  [sym_string] = sym_string,
  [sym_strings] = sym_strings,
  [sym_expansion] = sym_expansion,
  [sym__immediate_expansion] = sym_expansion,
  [sym__immediate_variable] = sym_variable,
  [sym__immediate_escape_sequence] = sym__immediate_escape_sequence,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym__eol] = sym__eol,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym_version_options_repeat1] = aux_sym_version_options_repeat1,
  [aux_sym_arg_options_repeat1] = aux_sym_arg_options_repeat1,
  [aux_sym_build_options_repeat1] = aux_sym_build_options_repeat1,
  [aux_sym_cache_options_repeat1] = aux_sym_cache_options_repeat1,
  [aux_sym_copy_command_repeat1] = aux_sym_copy_command_repeat1,
  [aux_sym_copy_options_repeat1] = aux_sym_copy_options_repeat1,
  [aux_sym_do_options_repeat1] = aux_sym_do_options_repeat1,
  [aux_sym_expose_command_repeat1] = aux_sym_expose_command_repeat1,
  [aux_sym_for_options_repeat1] = aux_sym_for_options_repeat1,
  [aux_sym_from_options_repeat1] = aux_sym_from_options_repeat1,
  [aux_sym_from_dockerfile_options_repeat1] = aux_sym_from_dockerfile_options_repeat1,
  [aux_sym_git_clone_options_repeat1] = aux_sym_git_clone_options_repeat1,
  [aux_sym_if_command_repeat1] = aux_sym_if_command_repeat1,
  [aux_sym_import_options_repeat1] = aux_sym_import_options_repeat1,
  [aux_sym_label_command_repeat1] = aux_sym_label_command_repeat1,
  [aux_sym_run_options_repeat1] = aux_sym_run_options_repeat1,
  [aux_sym_save_artifact_options_repeat1] = aux_sym_save_artifact_options_repeat1,
  [aux_sym_save_image_options_repeat1] = aux_sym_save_image_options_repeat1,
  [aux_sym_try_command_finally_block_repeat1] = aux_sym_try_command_finally_block_repeat1,
  [aux_sym_with_docker_options_repeat1] = aux_sym_with_docker_options_repeat1,
  [aux_sym_block_repeat1] = aux_sym_block_repeat1,
  [aux_sym__immediate_identifier_repeat1] = aux_sym__immediate_identifier_repeat1,
  [aux_sym_earthfile_ref_repeat1] = aux_sym_earthfile_ref_repeat1,
  [aux_sym_image_name_repeat1] = aux_sym_image_name_repeat1,
  [aux_sym_image_digest_repeat1] = aux_sym_image_digest_repeat1,
  [aux_sym_images_repeat1] = aux_sym_images_repeat1,
  [aux_sym_shell_fragment_repeat1] = aux_sym_shell_fragment_repeat1,
  [aux_sym_shell_fragment_repeat2] = aux_sym_shell_fragment_repeat2,
  [aux_sym_shell_fragment_repeat3] = aux_sym_shell_fragment_repeat3,
  [aux_sym_string_array_repeat1] = aux_sym_string_array_repeat1,
  [aux_sym_variable_repeat1] = aux_sym_variable_repeat1,
  [aux_sym_build_args_repeat1] = aux_sym_build_args_repeat1,
  [aux_sym__immediate_string_base_repeat1] = aux_sym__immediate_string_base_repeat1,
  [aux_sym_double_quoted_string_repeat1] = aux_sym_double_quoted_string_repeat1,
  [aux_sym_single_quoted_string_repeat1] = aux_sym_single_quoted_string_repeat1,
  [aux_sym_unquoted_string_repeat1] = aux_sym_unquoted_string_repeat1,
  [aux_sym_unquoted_string_with_spaces_repeat1] = aux_sym_unquoted_string_with_spaces_repeat1,
  [aux_sym_string_with_spaces_repeat1] = aux_sym_string_with_spaces_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [alias_sym__immediate_escape_sequence] = alias_sym__immediate_escape_sequence,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_PROJECT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_VERSION] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ARG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BUILD] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CACHE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CMD] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COPY] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DO] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ENTRYPOINT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ENV] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EXPOSE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_FOR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_IN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_END] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_FROM] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_FROMDOCKERFILE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_FUNCTION] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMAND] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GITCLONE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_HOST] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_IF] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_IMPORT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ3] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LABEL] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LOCALLY] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RUN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SAVEARTIFACT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ASLOCAL] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SAVEIMAGE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TRY] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_FINALLY] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_USER] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_VOLUME] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_WAIT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_WITHDOCKER] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_WORKDIR] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_block_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_ELSEIF] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ELSE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT2] = {
    .visible = true,
    .named = false,
  },
  [sym_function_ref] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_SPACE] = {
    .visible = true,
    .named = false,
  },
  [sym_number] = {
    .visible = true,
    .named = true,
  },
  [sym_options] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_shell_fragment_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_shell_fragment_token2] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_LBRACK3] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN3] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN3] = {
    .visible = true,
    .named = false,
  },
  [sym_version_major_minor] = {
    .visible = true,
    .named = true,
  },
  [sym_allow_privileged] = {
    .visible = true,
    .named = true,
  },
  [sym_auto_skip] = {
    .visible = true,
    .named = true,
  },
  [sym_aws] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DASH_DASHbranch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASH2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASHbuild_DASHarg] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASHcache_DASHid] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASHcache_DASHfrom] = {
    .visible = true,
    .named = false,
  },
  [sym_cache_hint] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DASH_DASHchmod] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASHchown] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASHcompose] = {
    .visible = true,
    .named = false,
  },
  [sym_dir] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DASHf] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASHtarget] = {
    .visible = true,
    .named = false,
  },
  [sym_entrypoint] = {
    .visible = true,
    .named = true,
  },
  [sym_feature_flag] = {
    .visible = true,
    .named = true,
  },
  [sym_force] = {
    .visible = true,
    .named = true,
  },
  [sym_global] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DASH_DASHid] = {
    .visible = true,
    .named = false,
  },
  [sym_if_exists] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DASH_DASHinteractive] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASHinteractive_DASHkeep] = {
    .visible = true,
    .named = false,
  },
  [sym_keep_own] = {
    .visible = true,
    .named = true,
  },
  [sym_keep_ts] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DASH_DASHload] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASHmount] = {
    .visible = true,
    .named = false,
  },
  [sym_network_none] = {
    .visible = true,
    .named = true,
  },
  [sym_no_cache] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DASH_DASHoidc] = {
    .visible = true,
    .named = false,
  },
  [sym_pass_args] = {
    .visible = true,
    .named = true,
  },
  [sym_persist] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DASH_DASHplatform] = {
    .visible = true,
    .named = false,
  },
  [sym_privileged] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DASH_DASHpull] = {
    .visible = true,
    .named = false,
  },
  [sym_push] = {
    .visible = true,
    .named = true,
  },
  [sym_raw_output] = {
    .visible = true,
    .named = true,
  },
  [sym_required] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DASH_DASHsecret] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ4] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASHsep] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASHservice] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASHsharing] = {
    .visible = true,
    .named = false,
  },
  [sym_ssh] = {
    .visible = true,
    .named = true,
  },
  [sym_symlink_no_follow] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_unknown_option_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_without_earthly_labels] = {
    .visible = true,
    .named = true,
  },
  [sym__string_base_other] = {
    .visible = false,
    .named = true,
  },
  [sym__string_base_alpha] = {
    .visible = false,
    .named = true,
  },
  [sym__string_base_num] = {
    .visible = false,
    .named = true,
  },
  [sym__immediate_string_base_other] = {
    .visible = false,
    .named = true,
  },
  [sym__immediate_string_base_alpha] = {
    .visible = false,
    .named = true,
  },
  [sym__immediate_string_base_num] = {
    .visible = false,
    .named = true,
  },
  [aux_sym_double_quoted_string_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_DQUOTE2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SQUOTE2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_single_quoted_string_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_PLUS2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_unquoted_string_with_spaces_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_RPAREN4] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__immediate_escape_sequence_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_line_continuation] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_line_continuation_comment] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LF] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CR_LF] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_FF] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_NULL] = {
    .visible = true,
    .named = false,
  },
  [sym__indent] = {
    .visible = false,
    .named = true,
  },
  [sym__dedent] = {
    .visible = false,
    .named = true,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym_project_command] = {
    .visible = true,
    .named = true,
  },
  [sym_target] = {
    .visible = true,
    .named = true,
  },
  [sym_version_command] = {
    .visible = true,
    .named = true,
  },
  [sym_version_options] = {
    .visible = true,
    .named = true,
  },
  [sym_arg_command] = {
    .visible = true,
    .named = true,
  },
  [sym_arg_options] = {
    .visible = true,
    .named = true,
  },
  [sym_build_command] = {
    .visible = true,
    .named = true,
  },
  [sym_build_options] = {
    .visible = true,
    .named = true,
  },
  [sym_cache_command] = {
    .visible = true,
    .named = true,
  },
  [sym_cache_options] = {
    .visible = true,
    .named = true,
  },
  [sym_cmd_command] = {
    .visible = true,
    .named = true,
  },
  [sym_copy_command] = {
    .visible = true,
    .named = true,
  },
  [sym_copy_options] = {
    .visible = true,
    .named = true,
  },
  [sym_do_command] = {
    .visible = true,
    .named = true,
  },
  [sym_do_options] = {
    .visible = true,
    .named = true,
  },
  [sym_entrypoint_command] = {
    .visible = true,
    .named = true,
  },
  [sym_env_command] = {
    .visible = true,
    .named = true,
  },
  [sym_expose_command] = {
    .visible = true,
    .named = true,
  },
  [sym_for_command] = {
    .visible = true,
    .named = true,
  },
  [sym_for_options] = {
    .visible = true,
    .named = true,
  },
  [sym_from_command] = {
    .visible = true,
    .named = true,
  },
  [sym_from_options] = {
    .visible = true,
    .named = true,
  },
  [sym_from_dockerfile_command] = {
    .visible = true,
    .named = true,
  },
  [sym_from_dockerfile_options] = {
    .visible = true,
    .named = true,
  },
  [sym_function_command] = {
    .visible = true,
    .named = true,
  },
  [sym_git_clone_command] = {
    .visible = true,
    .named = true,
  },
  [sym_git_clone_options] = {
    .visible = true,
    .named = true,
  },
  [sym_host_command] = {
    .visible = true,
    .named = true,
  },
  [sym_if_command] = {
    .visible = true,
    .named = true,
  },
  [sym_import_command] = {
    .visible = true,
    .named = true,
  },
  [sym_import_options] = {
    .visible = true,
    .named = true,
  },
  [sym_let_command] = {
    .visible = true,
    .named = true,
  },
  [sym_label_command] = {
    .visible = true,
    .named = true,
  },
  [sym_locally_command] = {
    .visible = true,
    .named = true,
  },
  [sym_run_command] = {
    .visible = true,
    .named = true,
  },
  [sym_run_options] = {
    .visible = true,
    .named = true,
  },
  [sym_save_artifact_command] = {
    .visible = true,
    .named = true,
  },
  [sym_save_artifact_options] = {
    .visible = true,
    .named = true,
  },
  [sym_save_image_command] = {
    .visible = true,
    .named = true,
  },
  [sym_save_image_options] = {
    .visible = true,
    .named = true,
  },
  [sym_set_command] = {
    .visible = true,
    .named = true,
  },
  [sym_try_command] = {
    .visible = true,
    .named = true,
  },
  [sym_try_command_finally_block] = {
    .visible = true,
    .named = true,
  },
  [sym_user_command] = {
    .visible = true,
    .named = true,
  },
  [sym_volume_command] = {
    .visible = true,
    .named = true,
  },
  [sym_wait_command] = {
    .visible = true,
    .named = true,
  },
  [sym_with_docker_command] = {
    .visible = true,
    .named = true,
  },
  [sym_with_docker_options] = {
    .visible = true,
    .named = true,
  },
  [sym_workdir_command] = {
    .visible = true,
    .named = true,
  },
  [sym_block] = {
    .visible = true,
    .named = true,
  },
  [sym__conditional_block] = {
    .visible = false,
    .named = true,
  },
  [aux_sym__conditional_block_options] = {
    .visible = false,
    .named = false,
  },
  [sym_elif_block] = {
    .visible = true,
    .named = true,
  },
  [sym_else_block] = {
    .visible = true,
    .named = true,
  },
  [sym__immediate_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_earthfile_ref] = {
    .visible = true,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_image_spec] = {
    .visible = true,
    .named = true,
  },
  [sym_image_name] = {
    .visible = true,
    .named = true,
  },
  [sym_image_tag] = {
    .visible = true,
    .named = true,
  },
  [sym_image_digest] = {
    .visible = true,
    .named = true,
  },
  [sym_images] = {
    .visible = true,
    .named = true,
  },
  [sym_label] = {
    .visible = true,
    .named = true,
  },
  [sym_shell_fragment] = {
    .visible = true,
    .named = true,
  },
  [sym_string_array] = {
    .visible = true,
    .named = true,
  },
  [sym_target_ref] = {
    .visible = true,
    .named = true,
  },
  [sym_target_ref_with_build_args] = {
    .visible = true,
    .named = true,
  },
  [sym_target_artifact] = {
    .visible = true,
    .named = true,
  },
  [sym_target_artifact_build_args] = {
    .visible = true,
    .named = true,
  },
  [sym_variable] = {
    .visible = true,
    .named = true,
  },
  [sym_branch] = {
    .visible = true,
    .named = true,
  },
  [sym_build_arg] = {
    .visible = true,
    .named = true,
  },
  [sym_build_args] = {
    .visible = true,
    .named = true,
  },
  [sym_build_arg_deprecated] = {
    .visible = true,
    .named = true,
  },
  [sym_cache_id] = {
    .visible = true,
    .named = true,
  },
  [sym_cache_from] = {
    .visible = true,
    .named = true,
  },
  [sym_chmod] = {
    .visible = true,
    .named = true,
  },
  [sym_chown] = {
    .visible = true,
    .named = true,
  },
  [sym_compose] = {
    .visible = true,
    .named = true,
  },
  [sym_docker_build_arg] = {
    .visible = true,
    .named = true,
  },
  [sym_docker_file] = {
    .visible = true,
    .named = true,
  },
  [sym_docker_target] = {
    .visible = true,
    .named = true,
  },
  [sym_id] = {
    .visible = true,
    .named = true,
  },
  [sym_interactive] = {
    .visible = true,
    .named = true,
  },
  [sym_load] = {
    .visible = true,
    .named = true,
  },
  [sym_mount] = {
    .visible = true,
    .named = true,
  },
  [sym_oidc] = {
    .visible = true,
    .named = true,
  },
  [sym_platform] = {
    .visible = true,
    .named = true,
  },
  [sym_pull] = {
    .visible = true,
    .named = true,
  },
  [sym_secret] = {
    .visible = true,
    .named = true,
  },
  [sym_sep] = {
    .visible = true,
    .named = true,
  },
  [sym_service] = {
    .visible = true,
    .named = true,
  },
  [sym_sharing] = {
    .visible = true,
    .named = true,
  },
  [sym_unknown_option] = {
    .visible = true,
    .named = true,
  },
  [sym__string_base] = {
    .visible = false,
    .named = true,
  },
  [sym__immediate_string_base] = {
    .visible = false,
    .named = true,
  },
  [sym_double_quoted_string] = {
    .visible = true,
    .named = true,
  },
  [sym__immediate_double_quoted_string] = {
    .visible = true,
    .named = true,
  },
  [sym_single_quoted_string] = {
    .visible = true,
    .named = true,
  },
  [sym__immediate_single_quoted_string] = {
    .visible = true,
    .named = true,
  },
  [sym_unquoted_string] = {
    .visible = true,
    .named = true,
  },
  [sym__immediate_unquoted_string] = {
    .visible = true,
    .named = true,
  },
  [sym_unquoted_string_with_spaces] = {
    .visible = true,
    .named = true,
  },
  [sym_string_with_spaces] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_strings] = {
    .visible = true,
    .named = true,
  },
  [sym_expansion] = {
    .visible = true,
    .named = true,
  },
  [sym__immediate_expansion] = {
    .visible = true,
    .named = true,
  },
  [sym__immediate_variable] = {
    .visible = true,
    .named = true,
  },
  [sym__immediate_escape_sequence] = {
    .visible = false,
    .named = true,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym__eol] = {
    .visible = false,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_version_options_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_arg_options_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_build_options_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_cache_options_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_copy_command_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_copy_options_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_do_options_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_expose_command_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_for_options_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_from_options_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_from_dockerfile_options_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_git_clone_options_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_if_command_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_import_options_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_label_command_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_run_options_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_save_artifact_options_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_save_image_options_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_try_command_finally_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_with_docker_options_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__immediate_identifier_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_earthfile_ref_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_image_name_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_image_digest_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_images_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_shell_fragment_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_shell_fragment_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_shell_fragment_repeat3] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_array_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_variable_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_build_args_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__immediate_string_base_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_double_quoted_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_single_quoted_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_unquoted_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_unquoted_string_with_spaces_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_with_spaces_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym__immediate_escape_sequence] = {
    .visible = true,
    .named = true,
  },
};

enum ts_field_identifiers {
  field_alias = 1,
  field_alternative = 2,
  field_base_target = 3,
  field_body = 4,
  field_command = 5,
  field_condition = 6,
  field_context = 7,
  field_default_value = 8,
  field_dest = 9,
  field_digest = 10,
  field_earthfile = 11,
  field_finally = 12,
  field_group = 13,
  field_id = 14,
  field_image = 15,
  field_images = 16,
  field_ip = 17,
  field_key = 18,
  field_label = 19,
  field_local_dest = 20,
  field_mount_point = 21,
  field_name = 22,
  field_options = 23,
  field_org_name = 24,
  field_project_name = 25,
  field_spec = 26,
  field_src = 27,
  field_tag = 28,
  field_target = 29,
  field_url = 30,
  field_user = 31,
  field_value = 32,
  field_values = 33,
  field_var = 34,
  field_version = 35,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alias] = "alias",
  [field_alternative] = "alternative",
  [field_base_target] = "base_target",
  [field_body] = "body",
  [field_command] = "command",
  [field_condition] = "condition",
  [field_context] = "context",
  [field_default_value] = "default_value",
  [field_dest] = "dest",
  [field_digest] = "digest",
  [field_earthfile] = "earthfile",
  [field_finally] = "finally",
  [field_group] = "group",
  [field_id] = "id",
  [field_image] = "image",
  [field_images] = "images",
  [field_ip] = "ip",
  [field_key] = "key",
  [field_label] = "label",
  [field_local_dest] = "local_dest",
  [field_mount_point] = "mount_point",
  [field_name] = "name",
  [field_options] = "options",
  [field_org_name] = "org_name",
  [field_project_name] = "project_name",
  [field_spec] = "spec",
  [field_src] = "src",
  [field_tag] = "tag",
  [field_target] = "target",
  [field_url] = "url",
  [field_user] = "user",
  [field_value] = "value",
  [field_values] = "values",
  [field_var] = "var",
  [field_version] = "version",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [3] = {.index = 1, .length = 1},
  [4] = {.index = 2, .length = 1},
  [5] = {.index = 3, .length = 1},
  [6] = {.index = 4, .length = 1},
  [7] = {.index = 5, .length = 1},
  [9] = {.index = 6, .length = 1},
  [10] = {.index = 7, .length = 2},
  [12] = {.index = 9, .length = 1},
  [13] = {.index = 10, .length = 1},
  [14] = {.index = 11, .length = 1},
  [15] = {.index = 12, .length = 1},
  [16] = {.index = 13, .length = 1},
  [17] = {.index = 14, .length = 1},
  [18] = {.index = 15, .length = 1},
  [19] = {.index = 16, .length = 1},
  [20] = {.index = 17, .length = 2},
  [21] = {.index = 19, .length = 1},
  [22] = {.index = 20, .length = 2},
  [23] = {.index = 22, .length = 2},
  [24] = {.index = 24, .length = 2},
  [25] = {.index = 26, .length = 2},
  [26] = {.index = 14, .length = 1},
  [27] = {.index = 28, .length = 2},
  [28] = {.index = 30, .length = 1},
  [29] = {.index = 31, .length = 2},
  [30] = {.index = 33, .length = 2},
  [31] = {.index = 35, .length = 2},
  [32] = {.index = 37, .length = 2},
  [33] = {.index = 39, .length = 2},
  [34] = {.index = 41, .length = 3},
  [35] = {.index = 44, .length = 1},
  [36] = {.index = 45, .length = 2},
  [37] = {.index = 47, .length = 2},
  [38] = {.index = 49, .length = 2},
  [39] = {.index = 51, .length = 2},
  [40] = {.index = 53, .length = 1},
  [41] = {.index = 54, .length = 1},
  [42] = {.index = 55, .length = 2},
  [43] = {.index = 57, .length = 2},
  [44] = {.index = 59, .length = 2},
  [45] = {.index = 61, .length = 2},
  [46] = {.index = 63, .length = 1},
  [47] = {.index = 64, .length = 2},
  [48] = {.index = 66, .length = 2},
  [49] = {.index = 68, .length = 2},
  [50] = {.index = 70, .length = 3},
  [51] = {.index = 73, .length = 2},
  [52] = {.index = 75, .length = 3},
  [53] = {.index = 78, .length = 4},
  [54] = {.index = 82, .length = 4},
  [55] = {.index = 86, .length = 3},
  [56] = {.index = 89, .length = 1},
  [57] = {.index = 90, .length = 2},
  [58] = {.index = 92, .length = 2},
  [59] = {.index = 94, .length = 3},
  [60] = {.index = 97, .length = 2},
  [61] = {.index = 99, .length = 2},
  [62] = {.index = 101, .length = 3},
  [63] = {.index = 104, .length = 2},
  [64] = {.index = 106, .length = 3},
  [65] = {.index = 109, .length = 2},
  [66] = {.index = 111, .length = 5},
  [67] = {.index = 116, .length = 2},
  [68] = {.index = 118, .length = 3},
  [69] = {.index = 121, .length = 3},
  [70] = {.index = 124, .length = 2},
  [71] = {.index = 126, .length = 2},
  [72] = {.index = 128, .length = 4},
  [73] = {.index = 132, .length = 1},
  [74] = {.index = 133, .length = 1},
  [75] = {.index = 134, .length = 3},
  [76] = {.index = 137, .length = 2},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_base_target, 0},
  [1] =
    {field_src, 0},
  [2] =
    {field_name, 0},
  [3] =
    {field_base_target, 1},
  [4] =
    {field_version, 1},
  [5] =
    {field_name, 1},
  [6] =
    {field_mount_point, 1},
  [7] =
    {field_src, 0, .inherited = true},
    {field_src, 1, .inherited = true},
  [9] =
    {field_context, 1},
  [10] =
    {field_alternative, 0},
  [11] =
    {field_condition, 0},
  [12] =
    {field_command, 1},
  [13] =
    {field_src, 1},
  [14] =
    {field_options, 1},
  [15] =
    {field_images, 1},
  [16] =
    {field_user, 1},
  [17] =
    {field_options, 1},
    {field_version, 2},
  [19] =
    {field_value, 2},
  [20] =
    {field_name, 2},
    {field_options, 1},
  [22] =
    {field_earthfile, 0},
    {field_name, 2},
  [24] =
    {field_mount_point, 2},
    {field_options, 1},
  [26] =
    {field_dest, 2},
    {field_src, 1, .inherited = true},
  [28] =
    {field_key, 1},
    {field_value, 2},
  [30] =
    {field_id, 2},
  [31] =
    {field_name, 0},
    {field_tag, 2},
  [33] =
    {field_digest, 2},
    {field_name, 0},
  [35] =
    {field_context, 2},
    {field_options, 1},
  [37] =
    {field_dest, 2},
    {field_url, 1},
  [39] =
    {field_ip, 2},
    {field_name, 1},
  [41] =
    {field_body, 1, .inherited = true},
    {field_condition, 1, .inherited = true},
    {field_options, 1, .inherited = true},
  [44] =
    {field_body, 1},
  [45] =
    {field_alternative, 0, .inherited = true},
    {field_alternative, 1, .inherited = true},
  [47] =
    {field_condition, 1},
    {field_options, 0},
  [49] =
    {field_body, 2},
    {field_condition, 0},
  [51] =
    {field_label, 0},
    {field_value, 2},
  [53] =
    {field_command, 2},
  [54] =
    {field_spec, 2},
  [55] =
    {field_command, 2},
    {field_options, 1},
  [57] =
    {field_options, 1},
    {field_src, 2},
  [59] =
    {field_dest, 2},
    {field_src, 1},
  [61] =
    {field_images, 2},
    {field_options, 1},
  [63] =
    {field_target, 2},
  [64] =
    {field_org_name, 1},
    {field_project_name, 3},
  [66] =
    {field_default_value, 3},
    {field_name, 1},
  [68] =
    {field_name, 1},
    {field_value, 2},
  [70] =
    {field_dest, 3},
    {field_options, 1},
    {field_src, 2, .inherited = true},
  [73] =
    {field_key, 1},
    {field_value, 3},
  [75] =
    {field_dest, 3},
    {field_options, 1},
    {field_url, 2},
  [78] =
    {field_alternative, 2},
    {field_body, 1, .inherited = true},
    {field_condition, 1, .inherited = true},
    {field_options, 1, .inherited = true},
  [82] =
    {field_alternative, 2, .inherited = true},
    {field_body, 1, .inherited = true},
    {field_condition, 1, .inherited = true},
    {field_options, 1, .inherited = true},
  [86] =
    {field_body, 3},
    {field_condition, 1},
    {field_options, 0},
  [89] =
    {field_alias, 3},
  [90] =
    {field_name, 1},
    {field_value, 3},
  [92] =
    {field_command, 3},
    {field_options, 1},
  [94] =
    {field_dest, 3},
    {field_options, 1},
    {field_src, 2},
  [97] =
    {field_local_dest, 3},
    {field_src, 1},
  [99] =
    {field_group, 3},
    {field_user, 1},
  [101] =
    {field_default_value, 4},
    {field_name, 2},
    {field_options, 1},
  [104] =
    {field_id, 4},
    {field_var, 2},
  [106] =
    {field_digest, 4},
    {field_name, 0},
    {field_tag, 2},
  [109] =
    {field_key, 2},
    {field_value, 4},
  [111] =
    {field_alternative, 2, .inherited = true},
    {field_alternative, 3},
    {field_body, 1, .inherited = true},
    {field_condition, 1, .inherited = true},
    {field_options, 1, .inherited = true},
  [116] =
    {field_alias, 4},
    {field_options, 1},
  [118] =
    {field_local_dest, 4},
    {field_options, 1},
    {field_src, 2},
  [121] =
    {field_dest, 2},
    {field_local_dest, 4},
    {field_src, 1},
  [124] =
    {field_image, 2},
    {field_target, 4},
  [126] =
    {field_name, 1},
    {field_values, 3},
  [128] =
    {field_dest, 3},
    {field_local_dest, 5},
    {field_options, 1},
    {field_src, 2},
  [132] =
    {field_finally, 4},
  [133] =
    {field_body, 2},
  [134] =
    {field_name, 2},
    {field_options, 1},
    {field_values, 4},
  [137] =
    {field_body, 2},
    {field_finally, 5},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [2] = {
    [0] = alias_sym__immediate_escape_sequence,
  },
  [8] = {
    [0] = sym_escape_sequence,
  },
  [11] = {
    [1] = sym_function_ref,
  },
  [26] = {
    [2] = sym_function_ref,
  },
  [37] = {
    [0] = sym_options,
  },
  [55] = {
    [0] = sym_options,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  aux_sym__conditional_block_options, 2,
    aux_sym__conditional_block_options,
    sym_options,
  sym_target_ref, 2,
    sym_target_ref,
    sym_function_ref,
  sym__immediate_escape_sequence, 2,
    sym__immediate_escape_sequence,
    sym_escape_sequence,
  sym_escape_sequence, 2,
    sym_escape_sequence,
    alias_sym__immediate_escape_sequence,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 4,
  [5] = 5,
  [6] = 6,
  [7] = 7,
  [8] = 7,
  [9] = 9,
  [10] = 3,
  [11] = 7,
  [12] = 12,
  [13] = 9,
  [14] = 14,
  [15] = 15,
  [16] = 6,
  [17] = 12,
  [18] = 12,
  [19] = 14,
  [20] = 14,
  [21] = 9,
  [22] = 3,
  [23] = 23,
  [24] = 24,
  [25] = 25,
  [26] = 6,
  [27] = 27,
  [28] = 24,
  [29] = 25,
  [30] = 27,
  [31] = 24,
  [32] = 25,
  [33] = 27,
  [34] = 34,
  [35] = 35,
  [36] = 36,
  [37] = 37,
  [38] = 36,
  [39] = 35,
  [40] = 37,
  [41] = 34,
  [42] = 42,
  [43] = 37,
  [44] = 35,
  [45] = 34,
  [46] = 46,
  [47] = 36,
  [48] = 46,
  [49] = 49,
  [50] = 50,
  [51] = 51,
  [52] = 52,
  [53] = 53,
  [54] = 24,
  [55] = 55,
  [56] = 56,
  [57] = 57,
  [58] = 58,
  [59] = 59,
  [60] = 60,
  [61] = 61,
  [62] = 27,
  [63] = 25,
  [64] = 64,
  [65] = 50,
  [66] = 66,
  [67] = 49,
  [68] = 68,
  [69] = 69,
  [70] = 70,
  [71] = 71,
  [72] = 72,
  [73] = 73,
  [74] = 51,
  [75] = 52,
  [76] = 76,
  [77] = 53,
  [78] = 25,
  [79] = 61,
  [80] = 56,
  [81] = 24,
  [82] = 25,
  [83] = 69,
  [84] = 27,
  [85] = 59,
  [86] = 27,
  [87] = 60,
  [88] = 25,
  [89] = 24,
  [90] = 55,
  [91] = 24,
  [92] = 68,
  [93] = 58,
  [94] = 70,
  [95] = 64,
  [96] = 66,
  [97] = 73,
  [98] = 57,
  [99] = 27,
  [100] = 27,
  [101] = 72,
  [102] = 76,
  [103] = 25,
  [104] = 46,
  [105] = 24,
  [106] = 24,
  [107] = 51,
  [108] = 24,
  [109] = 50,
  [110] = 27,
  [111] = 49,
  [112] = 25,
  [113] = 25,
  [114] = 27,
  [115] = 52,
  [116] = 76,
  [117] = 56,
  [118] = 70,
  [119] = 57,
  [120] = 55,
  [121] = 69,
  [122] = 68,
  [123] = 72,
  [124] = 27,
  [125] = 125,
  [126] = 58,
  [127] = 73,
  [128] = 24,
  [129] = 60,
  [130] = 59,
  [131] = 25,
  [132] = 64,
  [133] = 133,
  [134] = 66,
  [135] = 53,
  [136] = 61,
  [137] = 137,
  [138] = 24,
  [139] = 24,
  [140] = 25,
  [141] = 137,
  [142] = 34,
  [143] = 37,
  [144] = 27,
  [145] = 25,
  [146] = 27,
  [147] = 36,
  [148] = 35,
  [149] = 137,
  [150] = 34,
  [151] = 35,
  [152] = 36,
  [153] = 37,
  [154] = 36,
  [155] = 24,
  [156] = 34,
  [157] = 24,
  [158] = 34,
  [159] = 25,
  [160] = 24,
  [161] = 37,
  [162] = 27,
  [163] = 36,
  [164] = 35,
  [165] = 27,
  [166] = 35,
  [167] = 27,
  [168] = 34,
  [169] = 37,
  [170] = 35,
  [171] = 25,
  [172] = 37,
  [173] = 25,
  [174] = 36,
  [175] = 24,
  [176] = 37,
  [177] = 34,
  [178] = 27,
  [179] = 35,
  [180] = 37,
  [181] = 35,
  [182] = 34,
  [183] = 25,
  [184] = 24,
  [185] = 36,
  [186] = 36,
  [187] = 36,
  [188] = 27,
  [189] = 37,
  [190] = 25,
  [191] = 34,
  [192] = 42,
  [193] = 37,
  [194] = 27,
  [195] = 35,
  [196] = 25,
  [197] = 24,
  [198] = 36,
  [199] = 46,
  [200] = 52,
  [201] = 37,
  [202] = 37,
  [203] = 46,
  [204] = 51,
  [205] = 125,
  [206] = 36,
  [207] = 207,
  [208] = 36,
  [209] = 207,
  [210] = 46,
  [211] = 211,
  [212] = 35,
  [213] = 46,
  [214] = 207,
  [215] = 133,
  [216] = 207,
  [217] = 34,
  [218] = 34,
  [219] = 49,
  [220] = 35,
  [221] = 46,
  [222] = 50,
  [223] = 35,
  [224] = 49,
  [225] = 59,
  [226] = 36,
  [227] = 227,
  [228] = 49,
  [229] = 229,
  [230] = 70,
  [231] = 125,
  [232] = 57,
  [233] = 133,
  [234] = 46,
  [235] = 50,
  [236] = 76,
  [237] = 56,
  [238] = 52,
  [239] = 69,
  [240] = 46,
  [241] = 52,
  [242] = 34,
  [243] = 35,
  [244] = 73,
  [245] = 34,
  [246] = 51,
  [247] = 37,
  [248] = 37,
  [249] = 60,
  [250] = 36,
  [251] = 53,
  [252] = 50,
  [253] = 37,
  [254] = 61,
  [255] = 66,
  [256] = 52,
  [257] = 50,
  [258] = 64,
  [259] = 50,
  [260] = 36,
  [261] = 51,
  [262] = 49,
  [263] = 55,
  [264] = 52,
  [265] = 51,
  [266] = 72,
  [267] = 51,
  [268] = 35,
  [269] = 58,
  [270] = 68,
  [271] = 271,
  [272] = 34,
  [273] = 49,
  [274] = 55,
  [275] = 70,
  [276] = 69,
  [277] = 68,
  [278] = 66,
  [279] = 49,
  [280] = 66,
  [281] = 61,
  [282] = 53,
  [283] = 69,
  [284] = 35,
  [285] = 64,
  [286] = 60,
  [287] = 68,
  [288] = 52,
  [289] = 73,
  [290] = 52,
  [291] = 66,
  [292] = 49,
  [293] = 64,
  [294] = 58,
  [295] = 55,
  [296] = 50,
  [297] = 72,
  [298] = 51,
  [299] = 56,
  [300] = 58,
  [301] = 55,
  [302] = 34,
  [303] = 58,
  [304] = 53,
  [305] = 61,
  [306] = 73,
  [307] = 68,
  [308] = 71,
  [309] = 53,
  [310] = 56,
  [311] = 52,
  [312] = 61,
  [313] = 57,
  [314] = 51,
  [315] = 36,
  [316] = 68,
  [317] = 37,
  [318] = 60,
  [319] = 64,
  [320] = 72,
  [321] = 66,
  [322] = 69,
  [323] = 56,
  [324] = 60,
  [325] = 69,
  [326] = 50,
  [327] = 59,
  [328] = 36,
  [329] = 34,
  [330] = 46,
  [331] = 73,
  [332] = 61,
  [333] = 73,
  [334] = 55,
  [335] = 60,
  [336] = 72,
  [337] = 35,
  [338] = 76,
  [339] = 72,
  [340] = 57,
  [341] = 70,
  [342] = 37,
  [343] = 57,
  [344] = 58,
  [345] = 59,
  [346] = 51,
  [347] = 56,
  [348] = 76,
  [349] = 50,
  [350] = 70,
  [351] = 76,
  [352] = 76,
  [353] = 70,
  [354] = 53,
  [355] = 57,
  [356] = 59,
  [357] = 64,
  [358] = 59,
  [359] = 49,
  [360] = 49,
  [361] = 56,
  [362] = 362,
  [363] = 73,
  [364] = 56,
  [365] = 365,
  [366] = 37,
  [367] = 57,
  [368] = 362,
  [369] = 50,
  [370] = 60,
  [371] = 36,
  [372] = 52,
  [373] = 60,
  [374] = 72,
  [375] = 76,
  [376] = 34,
  [377] = 73,
  [378] = 35,
  [379] = 69,
  [380] = 68,
  [381] = 61,
  [382] = 53,
  [383] = 69,
  [384] = 59,
  [385] = 362,
  [386] = 55,
  [387] = 387,
  [388] = 60,
  [389] = 76,
  [390] = 57,
  [391] = 68,
  [392] = 56,
  [393] = 58,
  [394] = 61,
  [395] = 53,
  [396] = 69,
  [397] = 64,
  [398] = 53,
  [399] = 66,
  [400] = 400,
  [401] = 70,
  [402] = 46,
  [403] = 59,
  [404] = 51,
  [405] = 46,
  [406] = 55,
  [407] = 58,
  [408] = 72,
  [409] = 66,
  [410] = 70,
  [411] = 64,
  [412] = 64,
  [413] = 56,
  [414] = 37,
  [415] = 50,
  [416] = 55,
  [417] = 46,
  [418] = 53,
  [419] = 50,
  [420] = 61,
  [421] = 68,
  [422] = 70,
  [423] = 59,
  [424] = 58,
  [425] = 69,
  [426] = 73,
  [427] = 72,
  [428] = 49,
  [429] = 60,
  [430] = 52,
  [431] = 52,
  [432] = 51,
  [433] = 76,
  [434] = 51,
  [435] = 46,
  [436] = 66,
  [437] = 46,
  [438] = 36,
  [439] = 57,
  [440] = 49,
  [441] = 53,
  [442] = 46,
  [443] = 59,
  [444] = 52,
  [445] = 73,
  [446] = 69,
  [447] = 72,
  [448] = 76,
  [449] = 58,
  [450] = 66,
  [451] = 49,
  [452] = 70,
  [453] = 60,
  [454] = 50,
  [455] = 61,
  [456] = 55,
  [457] = 57,
  [458] = 56,
  [459] = 51,
  [460] = 51,
  [461] = 53,
  [462] = 76,
  [463] = 52,
  [464] = 68,
  [465] = 58,
  [466] = 211,
  [467] = 61,
  [468] = 57,
  [469] = 46,
  [470] = 56,
  [471] = 60,
  [472] = 49,
  [473] = 50,
  [474] = 70,
  [475] = 51,
  [476] = 52,
  [477] = 64,
  [478] = 49,
  [479] = 69,
  [480] = 59,
  [481] = 68,
  [482] = 66,
  [483] = 64,
  [484] = 55,
  [485] = 73,
  [486] = 72,
  [487] = 50,
  [488] = 488,
  [489] = 72,
  [490] = 55,
  [491] = 55,
  [492] = 52,
  [493] = 58,
  [494] = 51,
  [495] = 46,
  [496] = 49,
  [497] = 70,
  [498] = 50,
  [499] = 70,
  [500] = 76,
  [501] = 53,
  [502] = 70,
  [503] = 72,
  [504] = 69,
  [505] = 55,
  [506] = 58,
  [507] = 60,
  [508] = 72,
  [509] = 50,
  [510] = 53,
  [511] = 57,
  [512] = 64,
  [513] = 64,
  [514] = 66,
  [515] = 76,
  [516] = 66,
  [517] = 211,
  [518] = 73,
  [519] = 76,
  [520] = 56,
  [521] = 64,
  [522] = 59,
  [523] = 66,
  [524] = 73,
  [525] = 58,
  [526] = 59,
  [527] = 227,
  [528] = 528,
  [529] = 52,
  [530] = 60,
  [531] = 59,
  [532] = 51,
  [533] = 61,
  [534] = 60,
  [535] = 57,
  [536] = 53,
  [537] = 56,
  [538] = 57,
  [539] = 61,
  [540] = 528,
  [541] = 49,
  [542] = 68,
  [543] = 69,
  [544] = 68,
  [545] = 46,
  [546] = 68,
  [547] = 69,
  [548] = 229,
  [549] = 56,
  [550] = 73,
  [551] = 551,
  [552] = 528,
  [553] = 61,
  [554] = 227,
  [555] = 57,
  [556] = 72,
  [557] = 58,
  [558] = 55,
  [559] = 61,
  [560] = 68,
  [561] = 53,
  [562] = 69,
  [563] = 68,
  [564] = 60,
  [565] = 57,
  [566] = 56,
  [567] = 59,
  [568] = 76,
  [569] = 60,
  [570] = 73,
  [571] = 69,
  [572] = 66,
  [573] = 49,
  [574] = 64,
  [575] = 76,
  [576] = 59,
  [577] = 73,
  [578] = 52,
  [579] = 66,
  [580] = 51,
  [581] = 70,
  [582] = 50,
  [583] = 64,
  [584] = 50,
  [585] = 72,
  [586] = 58,
  [587] = 587,
  [588] = 53,
  [589] = 70,
  [590] = 229,
  [591] = 51,
  [592] = 61,
  [593] = 49,
  [594] = 56,
  [595] = 52,
  [596] = 55,
  [597] = 49,
  [598] = 70,
  [599] = 69,
  [600] = 73,
  [601] = 59,
  [602] = 76,
  [603] = 51,
  [604] = 76,
  [605] = 66,
  [606] = 606,
  [607] = 64,
  [608] = 53,
  [609] = 606,
  [610] = 72,
  [611] = 611,
  [612] = 61,
  [613] = 58,
  [614] = 606,
  [615] = 60,
  [616] = 60,
  [617] = 61,
  [618] = 55,
  [619] = 50,
  [620] = 72,
  [621] = 69,
  [622] = 56,
  [623] = 70,
  [624] = 57,
  [625] = 56,
  [626] = 68,
  [627] = 52,
  [628] = 628,
  [629] = 60,
  [630] = 56,
  [631] = 69,
  [632] = 632,
  [633] = 53,
  [634] = 634,
  [635] = 632,
  [636] = 632,
  [637] = 27,
  [638] = 25,
  [639] = 639,
  [640] = 24,
  [641] = 25,
  [642] = 639,
  [643] = 27,
  [644] = 639,
  [645] = 24,
  [646] = 27,
  [647] = 24,
  [648] = 648,
  [649] = 25,
  [650] = 650,
  [651] = 24,
  [652] = 652,
  [653] = 27,
  [654] = 654,
  [655] = 655,
  [656] = 656,
  [657] = 125,
  [658] = 658,
  [659] = 659,
  [660] = 660,
  [661] = 661,
  [662] = 662,
  [663] = 663,
  [664] = 664,
  [665] = 665,
  [666] = 666,
  [667] = 667,
  [668] = 668,
  [669] = 669,
  [670] = 670,
  [671] = 671,
  [672] = 672,
  [673] = 673,
  [674] = 674,
  [675] = 675,
  [676] = 676,
  [677] = 677,
  [678] = 659,
  [679] = 679,
  [680] = 680,
  [681] = 681,
  [682] = 682,
  [683] = 683,
  [684] = 684,
  [685] = 659,
  [686] = 686,
  [687] = 687,
  [688] = 688,
  [689] = 689,
  [690] = 690,
  [691] = 691,
  [692] = 692,
  [693] = 693,
  [694] = 694,
  [695] = 695,
  [696] = 696,
  [697] = 697,
  [698] = 698,
  [699] = 699,
  [700] = 700,
  [701] = 701,
  [702] = 702,
  [703] = 703,
  [704] = 704,
  [705] = 705,
  [706] = 706,
  [707] = 707,
  [708] = 708,
  [709] = 709,
  [710] = 710,
  [711] = 711,
  [712] = 712,
  [713] = 713,
  [714] = 714,
  [715] = 715,
  [716] = 716,
  [717] = 717,
  [718] = 718,
  [719] = 719,
  [720] = 720,
  [721] = 721,
  [722] = 722,
  [723] = 723,
  [724] = 724,
  [725] = 725,
  [726] = 726,
  [727] = 727,
  [728] = 728,
  [729] = 729,
  [730] = 730,
  [731] = 731,
  [732] = 732,
  [733] = 733,
  [734] = 734,
  [735] = 659,
  [736] = 736,
  [737] = 737,
  [738] = 738,
  [739] = 739,
  [740] = 740,
  [741] = 741,
  [742] = 742,
  [743] = 743,
  [744] = 744,
  [745] = 745,
  [746] = 746,
  [747] = 747,
  [748] = 748,
  [749] = 749,
  [750] = 749,
  [751] = 749,
  [752] = 752,
  [753] = 271,
  [754] = 752,
  [755] = 755,
  [756] = 133,
  [757] = 752,
  [758] = 703,
  [759] = 700,
  [760] = 663,
  [761] = 661,
  [762] = 669,
  [763] = 34,
  [764] = 764,
  [765] = 737,
  [766] = 704,
  [767] = 694,
  [768] = 664,
  [769] = 654,
  [770] = 710,
  [771] = 736,
  [772] = 691,
  [773] = 35,
  [774] = 684,
  [775] = 687,
  [776] = 689,
  [777] = 666,
  [778] = 740,
  [779] = 690,
  [780] = 36,
  [781] = 655,
  [782] = 660,
  [783] = 783,
  [784] = 784,
  [785] = 658,
  [786] = 764,
  [787] = 713,
  [788] = 682,
  [789] = 672,
  [790] = 734,
  [791] = 716,
  [792] = 695,
  [793] = 764,
  [794] = 681,
  [795] = 674,
  [796] = 697,
  [797] = 717,
  [798] = 711,
  [799] = 733,
  [800] = 680,
  [801] = 801,
  [802] = 36,
  [803] = 699,
  [804] = 718,
  [805] = 648,
  [806] = 683,
  [807] = 731,
  [808] = 688,
  [809] = 708,
  [810] = 692,
  [811] = 728,
  [812] = 719,
  [813] = 725,
  [814] = 706,
  [815] = 707,
  [816] = 37,
  [817] = 744,
  [818] = 745,
  [819] = 747,
  [820] = 724,
  [821] = 727,
  [822] = 742,
  [823] = 729,
  [824] = 37,
  [825] = 35,
  [826] = 676,
  [827] = 723,
  [828] = 667,
  [829] = 730,
  [830] = 732,
  [831] = 738,
  [832] = 739,
  [833] = 741,
  [834] = 743,
  [835] = 746,
  [836] = 748,
  [837] = 34,
  [838] = 693,
  [839] = 726,
  [840] = 712,
  [841] = 721,
  [842] = 670,
  [843] = 698,
  [844] = 705,
  [845] = 686,
  [846] = 668,
  [847] = 662,
  [848] = 673,
  [849] = 715,
  [850] = 702,
  [851] = 714,
  [852] = 656,
  [853] = 675,
  [854] = 701,
  [855] = 665,
  [856] = 709,
  [857] = 671,
  [858] = 858,
  [859] = 727,
  [860] = 860,
  [861] = 683,
  [862] = 25,
  [863] = 24,
  [864] = 27,
  [865] = 860,
  [866] = 866,
  [867] = 867,
  [868] = 676,
  [869] = 37,
  [870] = 693,
  [871] = 669,
  [872] = 700,
  [873] = 716,
  [874] = 866,
  [875] = 673,
  [876] = 876,
  [877] = 671,
  [878] = 656,
  [879] = 717,
  [880] = 662,
  [881] = 739,
  [882] = 882,
  [883] = 670,
  [884] = 741,
  [885] = 743,
  [886] = 667,
  [887] = 736,
  [888] = 734,
  [889] = 733,
  [890] = 731,
  [891] = 680,
  [892] = 711,
  [893] = 882,
  [894] = 677,
  [895] = 658,
  [896] = 681,
  [897] = 684,
  [898] = 898,
  [899] = 867,
  [900] = 660,
  [901] = 661,
  [902] = 663,
  [903] = 664,
  [904] = 904,
  [905] = 666,
  [906] = 906,
  [907] = 907,
  [908] = 689,
  [909] = 860,
  [910] = 910,
  [911] = 672,
  [912] = 682,
  [913] = 674,
  [914] = 686,
  [915] = 687,
  [916] = 691,
  [917] = 917,
  [918] = 654,
  [919] = 695,
  [920] = 694,
  [921] = 697,
  [922] = 699,
  [923] = 688,
  [924] = 704,
  [925] = 710,
  [926] = 692,
  [927] = 713,
  [928] = 708,
  [929] = 718,
  [930] = 698,
  [931] = 719,
  [932] = 867,
  [933] = 729,
  [934] = 730,
  [935] = 702,
  [936] = 732,
  [937] = 703,
  [938] = 738,
  [939] = 655,
  [940] = 706,
  [941] = 707,
  [942] = 35,
  [943] = 709,
  [944] = 866,
  [945] = 746,
  [946] = 748,
  [947] = 726,
  [948] = 714,
  [949] = 715,
  [950] = 712,
  [951] = 705,
  [952] = 882,
  [953] = 898,
  [954] = 954,
  [955] = 721,
  [956] = 668,
  [957] = 723,
  [958] = 724,
  [959] = 725,
  [960] = 675,
  [961] = 701,
  [962] = 728,
  [963] = 665,
  [964] = 690,
  [965] = 747,
  [966] = 898,
  [967] = 745,
  [968] = 744,
  [969] = 36,
  [970] = 742,
  [971] = 34,
  [972] = 737,
  [973] = 740,
  [974] = 974,
  [975] = 46,
  [976] = 24,
  [977] = 25,
  [978] = 978,
  [979] = 979,
  [980] = 978,
  [981] = 981,
  [982] = 25,
  [983] = 27,
  [984] = 984,
  [985] = 27,
  [986] = 986,
  [987] = 984,
  [988] = 978,
  [989] = 42,
  [990] = 990,
  [991] = 24,
  [992] = 984,
  [993] = 993,
  [994] = 27,
  [995] = 24,
  [996] = 996,
  [997] = 27,
  [998] = 24,
  [999] = 999,
  [1000] = 25,
  [1001] = 27,
  [1002] = 1002,
  [1003] = 24,
  [1004] = 46,
  [1005] = 49,
  [1006] = 652,
  [1007] = 996,
  [1008] = 1008,
  [1009] = 996,
  [1010] = 25,
  [1011] = 25,
  [1012] = 51,
  [1013] = 52,
  [1014] = 986,
  [1015] = 49,
  [1016] = 125,
  [1017] = 50,
  [1018] = 50,
  [1019] = 46,
  [1020] = 1020,
  [1021] = 974,
  [1022] = 1022,
  [1023] = 51,
  [1024] = 76,
  [1025] = 1025,
  [1026] = 1026,
  [1027] = 1027,
  [1028] = 227,
  [1029] = 1029,
  [1030] = 1030,
  [1031] = 1026,
  [1032] = 1032,
  [1033] = 125,
  [1034] = 49,
  [1035] = 1022,
  [1036] = 1020,
  [1037] = 1020,
  [1038] = 1038,
  [1039] = 229,
  [1040] = 1022,
  [1041] = 1032,
  [1042] = 1032,
  [1043] = 981,
  [1044] = 1032,
  [1045] = 1026,
  [1046] = 1022,
  [1047] = 1047,
  [1048] = 211,
  [1049] = 1047,
  [1050] = 1047,
  [1051] = 69,
  [1052] = 1052,
  [1053] = 52,
  [1054] = 61,
  [1055] = 50,
  [1056] = 1056,
  [1057] = 133,
  [1058] = 71,
  [1059] = 55,
  [1060] = 1060,
  [1061] = 37,
  [1062] = 1062,
  [1063] = 1063,
  [1064] = 1060,
  [1065] = 53,
  [1066] = 61,
  [1067] = 1067,
  [1068] = 1068,
  [1069] = 69,
  [1070] = 56,
  [1071] = 53,
  [1072] = 587,
  [1073] = 1073,
  [1074] = 52,
  [1075] = 68,
  [1076] = 60,
  [1077] = 1060,
  [1078] = 51,
  [1079] = 68,
  [1080] = 57,
  [1081] = 1062,
  [1082] = 58,
  [1083] = 73,
  [1084] = 64,
  [1085] = 72,
  [1086] = 60,
  [1087] = 1073,
  [1088] = 1063,
  [1089] = 1089,
  [1090] = 36,
  [1091] = 76,
  [1092] = 66,
  [1093] = 1093,
  [1094] = 1094,
  [1095] = 1093,
  [1096] = 133,
  [1097] = 34,
  [1098] = 57,
  [1099] = 55,
  [1100] = 1100,
  [1101] = 58,
  [1102] = 59,
  [1103] = 35,
  [1104] = 70,
  [1105] = 1105,
  [1106] = 1063,
  [1107] = 1073,
  [1108] = 1067,
  [1109] = 1093,
  [1110] = 1094,
  [1111] = 1067,
  [1112] = 70,
  [1113] = 64,
  [1114] = 56,
  [1115] = 1115,
  [1116] = 1068,
  [1117] = 1094,
  [1118] = 66,
  [1119] = 59,
  [1120] = 49,
  [1121] = 72,
  [1122] = 73,
  [1123] = 1068,
  [1124] = 68,
  [1125] = 37,
  [1126] = 73,
  [1127] = 1127,
  [1128] = 1128,
  [1129] = 1129,
  [1130] = 125,
  [1131] = 1127,
  [1132] = 1132,
  [1133] = 1132,
  [1134] = 648,
  [1135] = 58,
  [1136] = 70,
  [1137] = 64,
  [1138] = 59,
  [1139] = 34,
  [1140] = 66,
  [1141] = 1141,
  [1142] = 35,
  [1143] = 1141,
  [1144] = 35,
  [1145] = 36,
  [1146] = 72,
  [1147] = 61,
  [1148] = 55,
  [1149] = 1127,
  [1150] = 57,
  [1151] = 34,
  [1152] = 36,
  [1153] = 1141,
  [1154] = 69,
  [1155] = 1155,
  [1156] = 1156,
  [1157] = 53,
  [1158] = 37,
  [1159] = 56,
  [1160] = 76,
  [1161] = 1161,
  [1162] = 1132,
  [1163] = 1155,
  [1164] = 60,
  [1165] = 1165,
  [1166] = 125,
  [1167] = 1167,
  [1168] = 1167,
  [1169] = 1169,
  [1170] = 1170,
  [1171] = 1171,
  [1172] = 1172,
  [1173] = 1173,
  [1174] = 34,
  [1175] = 1175,
  [1176] = 1176,
  [1177] = 1177,
  [1178] = 1173,
  [1179] = 1173,
  [1180] = 1180,
  [1181] = 1181,
  [1182] = 36,
  [1183] = 1183,
  [1184] = 1180,
  [1185] = 1180,
  [1186] = 1180,
  [1187] = 1180,
  [1188] = 1180,
  [1189] = 37,
  [1190] = 1180,
  [1191] = 1180,
  [1192] = 1180,
  [1193] = 1180,
  [1194] = 1194,
  [1195] = 1180,
  [1196] = 35,
  [1197] = 1180,
  [1198] = 1198,
  [1199] = 1199,
  [1200] = 1200,
  [1201] = 1201,
  [1202] = 1183,
  [1203] = 1180,
  [1204] = 1204,
  [1205] = 1177,
  [1206] = 1167,
  [1207] = 1207,
  [1208] = 1208,
  [1209] = 1209,
  [1210] = 907,
  [1211] = 1198,
  [1212] = 1212,
  [1213] = 1199,
  [1214] = 1183,
  [1215] = 1200,
  [1216] = 1216,
  [1217] = 1201,
  [1218] = 1218,
  [1219] = 1219,
  [1220] = 1220,
  [1221] = 1221,
  [1222] = 1222,
  [1223] = 1220,
  [1224] = 1208,
  [1225] = 1207,
  [1226] = 1226,
  [1227] = 1183,
  [1228] = 1228,
  [1229] = 1221,
  [1230] = 1230,
  [1231] = 1180,
  [1232] = 1232,
  [1233] = 1177,
  [1234] = 1201,
  [1235] = 1167,
  [1236] = 1236,
  [1237] = 1216,
  [1238] = 1176,
  [1239] = 1175,
  [1240] = 1240,
  [1241] = 1241,
  [1242] = 1242,
  [1243] = 1170,
  [1244] = 1169,
  [1245] = 1198,
  [1246] = 1212,
  [1247] = 1199,
  [1248] = 1200,
  [1249] = 1216,
  [1250] = 1201,
  [1251] = 1221,
  [1252] = 1220,
  [1253] = 1253,
  [1254] = 986,
  [1255] = 677,
  [1256] = 133,
  [1257] = 1207,
  [1258] = 1194,
  [1259] = 1183,
  [1260] = 1181,
  [1261] = 648,
  [1262] = 1180,
  [1263] = 1263,
  [1264] = 1208,
  [1265] = 1265,
  [1266] = 1177,
  [1267] = 1176,
  [1268] = 1175,
  [1269] = 1170,
  [1270] = 1200,
  [1271] = 1169,
  [1272] = 1199,
  [1273] = 648,
  [1274] = 1212,
  [1275] = 1275,
  [1276] = 1198,
  [1277] = 1277,
  [1278] = 1278,
  [1279] = 650,
  [1280] = 36,
  [1281] = 1281,
  [1282] = 37,
  [1283] = 648,
  [1284] = 35,
  [1285] = 34,
  [1286] = 36,
  [1287] = 34,
  [1288] = 35,
  [1289] = 648,
  [1290] = 37,
  [1291] = 1291,
  [1292] = 1292,
  [1293] = 1293,
  [1294] = 1292,
  [1295] = 46,
  [1296] = 1296,
  [1297] = 1297,
  [1298] = 1298,
  [1299] = 1291,
  [1300] = 677,
  [1301] = 36,
  [1302] = 677,
  [1303] = 1291,
  [1304] = 1304,
  [1305] = 46,
  [1306] = 1306,
  [1307] = 46,
  [1308] = 677,
  [1309] = 46,
  [1310] = 720,
  [1311] = 1292,
  [1312] = 1293,
  [1313] = 46,
  [1314] = 648,
  [1315] = 1292,
  [1316] = 906,
  [1317] = 677,
  [1318] = 1297,
  [1319] = 907,
  [1320] = 46,
  [1321] = 679,
  [1322] = 1293,
  [1323] = 1297,
  [1324] = 1291,
  [1325] = 52,
  [1326] = 1326,
  [1327] = 1327,
  [1328] = 974,
  [1329] = 917,
  [1330] = 648,
  [1331] = 49,
  [1332] = 50,
  [1333] = 1333,
  [1334] = 49,
  [1335] = 1335,
  [1336] = 1336,
  [1337] = 46,
  [1338] = 49,
  [1339] = 49,
  [1340] = 51,
  [1341] = 677,
  [1342] = 1342,
  [1343] = 1336,
  [1344] = 981,
  [1345] = 49,
  [1346] = 1336,
  [1347] = 1347,
  [1348] = 49,
  [1349] = 986,
  [1350] = 1350,
  [1351] = 1351,
  [1352] = 1351,
  [1353] = 1353,
  [1354] = 1351,
  [1355] = 36,
  [1356] = 1356,
  [1357] = 1357,
  [1358] = 46,
  [1359] = 1357,
  [1360] = 50,
  [1361] = 1351,
  [1362] = 66,
  [1363] = 64,
  [1364] = 1357,
  [1365] = 1351,
  [1366] = 58,
  [1367] = 55,
  [1368] = 1357,
  [1369] = 1351,
  [1370] = 76,
  [1371] = 46,
  [1372] = 1357,
  [1373] = 1373,
  [1374] = 1351,
  [1375] = 1357,
  [1376] = 53,
  [1377] = 1351,
  [1378] = 61,
  [1379] = 1357,
  [1380] = 68,
  [1381] = 1381,
  [1382] = 1351,
  [1383] = 1357,
  [1384] = 51,
  [1385] = 1351,
  [1386] = 1357,
  [1387] = 1351,
  [1388] = 73,
  [1389] = 1357,
  [1390] = 1351,
  [1391] = 72,
  [1392] = 1357,
  [1393] = 211,
  [1394] = 1030,
  [1395] = 49,
  [1396] = 1357,
  [1397] = 70,
  [1398] = 1351,
  [1399] = 1357,
  [1400] = 1351,
  [1401] = 1357,
  [1402] = 1351,
  [1403] = 51,
  [1404] = 57,
  [1405] = 76,
  [1406] = 51,
  [1407] = 1357,
  [1408] = 51,
  [1409] = 1357,
  [1410] = 648,
  [1411] = 52,
  [1412] = 1357,
  [1413] = 59,
  [1414] = 1381,
  [1415] = 1351,
  [1416] = 677,
  [1417] = 1357,
  [1418] = 648,
  [1419] = 1356,
  [1420] = 1420,
  [1421] = 1357,
  [1422] = 1357,
  [1423] = 1351,
  [1424] = 1351,
  [1425] = 1357,
  [1426] = 69,
  [1427] = 1373,
  [1428] = 1428,
  [1429] = 1356,
  [1430] = 227,
  [1431] = 1351,
  [1432] = 1357,
  [1433] = 1351,
  [1434] = 907,
  [1435] = 1357,
  [1436] = 52,
  [1437] = 1357,
  [1438] = 1357,
  [1439] = 1351,
  [1440] = 76,
  [1441] = 1441,
  [1442] = 229,
  [1443] = 1351,
  [1444] = 1381,
  [1445] = 1357,
  [1446] = 1441,
  [1447] = 1351,
  [1448] = 1351,
  [1449] = 1373,
  [1450] = 211,
  [1451] = 52,
  [1452] = 1452,
  [1453] = 1357,
  [1454] = 1357,
  [1455] = 1441,
  [1456] = 1351,
  [1457] = 69,
  [1458] = 1357,
  [1459] = 1351,
  [1460] = 50,
  [1461] = 56,
  [1462] = 1357,
  [1463] = 1351,
  [1464] = 1351,
  [1465] = 1357,
  [1466] = 1357,
  [1467] = 229,
  [1468] = 1351,
  [1469] = 60,
  [1470] = 69,
  [1471] = 227,
  [1472] = 1357,
  [1473] = 50,
  [1474] = 52,
  [1475] = 69,
  [1476] = 60,
  [1477] = 60,
  [1478] = 73,
  [1479] = 66,
  [1480] = 53,
  [1481] = 64,
  [1482] = 70,
  [1483] = 53,
  [1484] = 677,
  [1485] = 61,
  [1486] = 52,
  [1487] = 68,
  [1488] = 1488,
  [1489] = 57,
  [1490] = 76,
  [1491] = 1491,
  [1492] = 50,
  [1493] = 49,
  [1494] = 677,
  [1495] = 56,
  [1496] = 648,
  [1497] = 68,
  [1498] = 59,
  [1499] = 51,
  [1500] = 61,
  [1501] = 51,
  [1502] = 73,
  [1503] = 1491,
  [1504] = 66,
  [1505] = 64,
  [1506] = 49,
  [1507] = 1507,
  [1508] = 72,
  [1509] = 58,
  [1510] = 1488,
  [1511] = 50,
  [1512] = 56,
  [1513] = 55,
  [1514] = 52,
  [1515] = 59,
  [1516] = 72,
  [1517] = 1517,
  [1518] = 70,
  [1519] = 58,
  [1520] = 50,
  [1521] = 55,
  [1522] = 57,
  [1523] = 1488,
  [1524] = 1491,
  [1525] = 51,
  [1526] = 72,
  [1527] = 61,
  [1528] = 76,
  [1529] = 227,
  [1530] = 64,
  [1531] = 229,
  [1532] = 69,
  [1533] = 68,
  [1534] = 57,
  [1535] = 61,
  [1536] = 53,
  [1537] = 66,
  [1538] = 70,
  [1539] = 64,
  [1540] = 58,
  [1541] = 55,
  [1542] = 70,
  [1543] = 55,
  [1544] = 53,
  [1545] = 58,
  [1546] = 72,
  [1547] = 61,
  [1548] = 64,
  [1549] = 66,
  [1550] = 73,
  [1551] = 59,
  [1552] = 68,
  [1553] = 56,
  [1554] = 677,
  [1555] = 60,
  [1556] = 73,
  [1557] = 72,
  [1558] = 70,
  [1559] = 57,
  [1560] = 76,
  [1561] = 60,
  [1562] = 68,
  [1563] = 1563,
  [1564] = 56,
  [1565] = 59,
  [1566] = 73,
  [1567] = 53,
  [1568] = 58,
  [1569] = 55,
  [1570] = 59,
  [1571] = 69,
  [1572] = 66,
  [1573] = 211,
  [1574] = 227,
  [1575] = 229,
  [1576] = 60,
  [1577] = 56,
  [1578] = 57,
  [1579] = 1171,
  [1580] = 1580,
  [1581] = 1219,
  [1582] = 1582,
  [1583] = 1583,
  [1584] = 1584,
  [1585] = 1585,
  [1586] = 76,
  [1587] = 1222,
  [1588] = 1580,
  [1589] = 76,
  [1590] = 1585,
  [1591] = 1228,
  [1592] = 1226,
  [1593] = 1593,
  [1594] = 70,
  [1595] = 1584,
  [1596] = 76,
  [1597] = 68,
  [1598] = 1598,
  [1599] = 73,
  [1600] = 1600,
  [1601] = 70,
  [1602] = 59,
  [1603] = 70,
  [1604] = 57,
  [1605] = 1580,
  [1606] = 1585,
  [1607] = 1584,
  [1608] = 1598,
  [1609] = 1609,
  [1610] = 1582,
  [1611] = 979,
  [1612] = 993,
  [1613] = 1613,
  [1614] = 1614,
  [1615] = 46,
  [1616] = 1614,
  [1617] = 1614,
  [1618] = 49,
  [1619] = 1619,
  [1620] = 1620,
  [1621] = 1619,
  [1622] = 1622,
  [1623] = 69,
  [1624] = 76,
  [1625] = 1265,
  [1626] = 1626,
  [1627] = 1626,
  [1628] = 1626,
  [1629] = 1278,
  [1630] = 986,
  [1631] = 1631,
  [1632] = 1632,
  [1633] = 979,
  [1634] = 993,
  [1635] = 1335,
  [1636] = 1636,
  [1637] = 1637,
  [1638] = 1342,
  [1639] = 1333,
  [1640] = 993,
  [1641] = 979,
  [1642] = 1517,
  [1643] = 648,
  [1644] = 1563,
  [1645] = 1645,
  [1646] = 907,
  [1647] = 1647,
  [1648] = 1648,
  [1649] = 1649,
  [1650] = 1650,
  [1651] = 986,
  [1652] = 1583,
  [1653] = 1653,
  [1654] = 1278,
  [1655] = 1600,
  [1656] = 1656,
  [1657] = 1657,
  [1658] = 986,
  [1659] = 677,
  [1660] = 1660,
  [1661] = 650,
  [1662] = 1662,
  [1663] = 648,
  [1664] = 1265,
  [1665] = 1632,
  [1666] = 677,
  [1667] = 1667,
  [1668] = 1631,
  [1669] = 1667,
  [1670] = 679,
  [1671] = 1671,
  [1672] = 1667,
  [1673] = 720,
  [1674] = 1674,
  [1675] = 986,
  [1676] = 52,
  [1677] = 50,
  [1678] = 981,
  [1679] = 1679,
  [1680] = 1680,
  [1681] = 51,
  [1682] = 986,
  [1683] = 1683,
  [1684] = 1335,
  [1685] = 1674,
  [1686] = 50,
  [1687] = 1687,
  [1688] = 52,
  [1689] = 1683,
  [1690] = 1690,
  [1691] = 1691,
  [1692] = 974,
  [1693] = 1333,
  [1694] = 1694,
  [1695] = 1694,
  [1696] = 1679,
  [1697] = 1694,
  [1698] = 1679,
  [1699] = 1699,
  [1700] = 1700,
  [1701] = 1694,
  [1702] = 1679,
  [1703] = 1632,
  [1704] = 986,
  [1705] = 1699,
  [1706] = 1700,
  [1707] = 1694,
  [1708] = 51,
  [1709] = 974,
  [1710] = 1679,
  [1711] = 1699,
  [1712] = 1700,
  [1713] = 1694,
  [1714] = 1679,
  [1715] = 1699,
  [1716] = 1700,
  [1717] = 1694,
  [1718] = 1679,
  [1719] = 1699,
  [1720] = 1700,
  [1721] = 1694,
  [1722] = 1679,
  [1723] = 1699,
  [1724] = 1700,
  [1725] = 1694,
  [1726] = 1679,
  [1727] = 1699,
  [1728] = 1700,
  [1729] = 1694,
  [1730] = 1679,
  [1731] = 1699,
  [1732] = 1700,
  [1733] = 1694,
  [1734] = 1679,
  [1735] = 1699,
  [1736] = 1265,
  [1737] = 1700,
  [1738] = 1694,
  [1739] = 1679,
  [1740] = 1699,
  [1741] = 1700,
  [1742] = 1694,
  [1743] = 1679,
  [1744] = 1699,
  [1745] = 1700,
  [1746] = 1694,
  [1747] = 1679,
  [1748] = 1699,
  [1749] = 1700,
  [1750] = 1694,
  [1751] = 1679,
  [1752] = 1699,
  [1753] = 1700,
  [1754] = 1694,
  [1755] = 1679,
  [1756] = 1699,
  [1757] = 1278,
  [1758] = 1700,
  [1759] = 1694,
  [1760] = 1679,
  [1761] = 1699,
  [1762] = 1631,
  [1763] = 1700,
  [1764] = 1694,
  [1765] = 1691,
  [1766] = 1679,
  [1767] = 981,
  [1768] = 1699,
  [1769] = 1700,
  [1770] = 1694,
  [1771] = 1679,
  [1772] = 1699,
  [1773] = 1700,
  [1774] = 1694,
  [1775] = 1679,
  [1776] = 1699,
  [1777] = 1700,
  [1778] = 1694,
  [1779] = 1679,
  [1780] = 1699,
  [1781] = 1690,
  [1782] = 1700,
  [1783] = 1694,
  [1784] = 1679,
  [1785] = 1785,
  [1786] = 1786,
  [1787] = 1699,
  [1788] = 1700,
  [1789] = 1691,
  [1790] = 1694,
  [1791] = 1679,
  [1792] = 1699,
  [1793] = 974,
  [1794] = 1700,
  [1795] = 1694,
  [1796] = 1700,
  [1797] = 1679,
  [1798] = 1699,
  [1799] = 1799,
  [1800] = 1700,
  [1801] = 1694,
  [1802] = 1679,
  [1803] = 1683,
  [1804] = 1699,
  [1805] = 981,
  [1806] = 1700,
  [1807] = 1694,
  [1808] = 1679,
  [1809] = 1699,
  [1810] = 1700,
  [1811] = 1694,
  [1812] = 1679,
  [1813] = 1699,
  [1814] = 1700,
  [1815] = 1786,
  [1816] = 1694,
  [1817] = 1786,
  [1818] = 1785,
  [1819] = 1679,
  [1820] = 1690,
  [1821] = 1785,
  [1822] = 1699,
  [1823] = 1679,
  [1824] = 1680,
  [1825] = 1674,
  [1826] = 1700,
  [1827] = 1694,
  [1828] = 1687,
  [1829] = 1687,
  [1830] = 1680,
  [1831] = 1679,
  [1832] = 1799,
  [1833] = 1694,
  [1834] = 1699,
  [1835] = 1700,
  [1836] = 1699,
  [1837] = 1342,
  [1838] = 1838,
  [1839] = 1839,
  [1840] = 1840,
  [1841] = 1841,
  [1842] = 1842,
  [1843] = 1842,
  [1844] = 1838,
  [1845] = 1839,
  [1846] = 1839,
  [1847] = 1841,
  [1848] = 1631,
  [1849] = 1840,
  [1850] = 1838,
  [1851] = 1851,
  [1852] = 1632,
  [1853] = 1853,
  [1854] = 1851,
  [1855] = 1840,
  [1856] = 1851,
  [1857] = 1842,
  [1858] = 1858,
  [1859] = 1841,
  [1860] = 1860,
  [1861] = 1861,
  [1862] = 1862,
  [1863] = 1863,
  [1864] = 1864,
  [1865] = 1452,
  [1866] = 1866,
  [1867] = 1867,
  [1868] = 1860,
  [1869] = 1860,
  [1870] = 1870,
  [1871] = 1871,
  [1872] = 1861,
  [1873] = 1870,
  [1874] = 1874,
  [1875] = 1860,
  [1876] = 1353,
  [1877] = 1861,
  [1878] = 1871,
  [1879] = 1870,
  [1880] = 1860,
  [1881] = 1866,
  [1882] = 1860,
  [1883] = 1883,
  [1884] = 1870,
  [1885] = 1861,
  [1886] = 1874,
  [1887] = 1871,
  [1888] = 1870,
  [1889] = 1883,
  [1890] = 1871,
  [1891] = 1871,
  [1892] = 1861,
  [1893] = 1893,
  [1894] = 1870,
  [1895] = 1861,
  [1896] = 1871,
  [1897] = 1870,
  [1898] = 1898,
  [1899] = 1860,
  [1900] = 1900,
  [1901] = 1860,
  [1902] = 1902,
  [1903] = 1903,
  [1904] = 1870,
  [1905] = 1861,
  [1906] = 1871,
  [1907] = 1870,
  [1908] = 1871,
  [1909] = 1860,
  [1910] = 1910,
  [1911] = 1861,
  [1912] = 1871,
  [1913] = 1870,
  [1914] = 1333,
  [1915] = 1915,
  [1916] = 1861,
  [1917] = 1867,
  [1918] = 648,
  [1919] = 1860,
  [1920] = 1860,
  [1921] = 1861,
  [1922] = 1871,
  [1923] = 1870,
  [1924] = 1870,
  [1925] = 1860,
  [1926] = 1926,
  [1927] = 1861,
  [1928] = 1871,
  [1929] = 1870,
  [1930] = 1871,
  [1931] = 1860,
  [1932] = 1861,
  [1933] = 1910,
  [1934] = 1861,
  [1935] = 1871,
  [1936] = 1870,
  [1937] = 1335,
  [1938] = 1900,
  [1939] = 1860,
  [1940] = 1860,
  [1941] = 1861,
  [1942] = 1871,
  [1943] = 1870,
  [1944] = 1863,
  [1945] = 51,
  [1946] = 1860,
  [1947] = 1860,
  [1948] = 1870,
  [1949] = 1861,
  [1950] = 1860,
  [1951] = 1871,
  [1952] = 1952,
  [1953] = 1870,
  [1954] = 1871,
  [1955] = 1900,
  [1956] = 1910,
  [1957] = 1860,
  [1958] = 1861,
  [1959] = 1861,
  [1960] = 1871,
  [1961] = 1870,
  [1962] = 1860,
  [1963] = 1860,
  [1964] = 1871,
  [1965] = 1870,
  [1966] = 1861,
  [1967] = 1967,
  [1968] = 1871,
  [1969] = 1870,
  [1970] = 1871,
  [1971] = 1860,
  [1972] = 1861,
  [1973] = 1861,
  [1974] = 1871,
  [1975] = 1870,
  [1976] = 1862,
  [1977] = 1342,
  [1978] = 1860,
  [1979] = 1860,
  [1980] = 1870,
  [1981] = 1870,
  [1982] = 1861,
  [1983] = 1871,
  [1984] = 1871,
  [1985] = 1870,
  [1986] = 1883,
  [1987] = 1874,
  [1988] = 1952,
  [1989] = 1871,
  [1990] = 1870,
  [1991] = 1860,
  [1992] = 1861,
  [1993] = 1861,
  [1994] = 1871,
  [1995] = 1870,
  [1996] = 1861,
  [1997] = 1860,
  [1998] = 1860,
  [1999] = 1867,
  [2000] = 1861,
  [2001] = 1871,
  [2002] = 1870,
  [2003] = 2003,
  [2004] = 1860,
  [2005] = 2005,
  [2006] = 1517,
  [2007] = 1861,
  [2008] = 2008,
  [2009] = 1861,
  [2010] = 1871,
  [2011] = 1870,
  [2012] = 1870,
  [2013] = 1871,
  [2014] = 1860,
  [2015] = 1861,
  [2016] = 1863,
  [2017] = 2017,
  [2018] = 2018,
  [2019] = 2019,
  [2020] = 52,
  [2021] = 50,
  [2022] = 2018,
  [2023] = 2019,
  [2024] = 2019,
  [2025] = 2018,
  [2026] = 2019,
  [2027] = 51,
  [2028] = 2018,
  [2029] = 2018,
  [2030] = 1563,
  [2031] = 2019,
  [2032] = 2018,
  [2033] = 2019,
  [2034] = 2019,
  [2035] = 2019,
  [2036] = 2018,
  [2037] = 2018,
  [2038] = 2019,
  [2039] = 69,
  [2040] = 2019,
  [2041] = 2018,
  [2042] = 2019,
  [2043] = 2018,
  [2044] = 2018,
  [2045] = 2019,
  [2046] = 2018,
  [2047] = 2018,
  [2048] = 2018,
  [2049] = 2019,
  [2050] = 2019,
  [2051] = 677,
  [2052] = 2018,
  [2053] = 2019,
  [2054] = 2018,
  [2055] = 2018,
  [2056] = 50,
  [2057] = 2019,
  [2058] = 2018,
  [2059] = 2019,
  [2060] = 2019,
  [2061] = 2018,
  [2062] = 1353,
  [2063] = 2063,
  [2064] = 2018,
  [2065] = 2065,
  [2066] = 1452,
  [2067] = 2019,
  [2068] = 2018,
  [2069] = 2019,
  [2070] = 2070,
  [2071] = 2019,
  [2072] = 2072,
  [2073] = 2018,
  [2074] = 2019,
  [2075] = 2018,
  [2076] = 2019,
  [2077] = 52,
  [2078] = 2018,
  [2079] = 1353,
  [2080] = 2019,
  [2081] = 1452,
  [2082] = 69,
  [2083] = 2083,
  [2084] = 2019,
  [2085] = 2018,
  [2086] = 2019,
  [2087] = 2018,
  [2088] = 2018,
  [2089] = 2019,
  [2090] = 2019,
  [2091] = 56,
  [2092] = 2019,
  [2093] = 2019,
  [2094] = 56,
  [2095] = 2019,
  [2096] = 2019,
  [2097] = 2018,
  [2098] = 1452,
  [2099] = 2083,
  [2100] = 2019,
  [2101] = 60,
  [2102] = 2018,
  [2103] = 60,
  [2104] = 2104,
  [2105] = 2105,
  [2106] = 2106,
  [2107] = 2107,
  [2108] = 2108,
  [2109] = 69,
  [2110] = 1650,
  [2111] = 2111,
  [2112] = 2112,
  [2113] = 69,
  [2114] = 2114,
  [2115] = 2115,
  [2116] = 2116,
  [2117] = 2117,
  [2118] = 2118,
  [2119] = 2111,
  [2120] = 2120,
  [2121] = 1650,
  [2122] = 1647,
  [2123] = 2108,
  [2124] = 2105,
  [2125] = 2125,
  [2126] = 2104,
  [2127] = 1600,
  [2128] = 2128,
  [2129] = 2129,
  [2130] = 2114,
  [2131] = 2131,
  [2132] = 2105,
  [2133] = 2114,
  [2134] = 2134,
  [2135] = 2106,
  [2136] = 2115,
  [2137] = 2128,
  [2138] = 2115,
  [2139] = 2114,
  [2140] = 2140,
  [2141] = 2141,
  [2142] = 2117,
  [2143] = 2116,
  [2144] = 2104,
  [2145] = 2145,
  [2146] = 1583,
  [2147] = 2117,
  [2148] = 2116,
  [2149] = 2134,
  [2150] = 2150,
  [2151] = 2111,
  [2152] = 2125,
  [2153] = 2112,
  [2154] = 2116,
  [2155] = 2117,
  [2156] = 1647,
  [2157] = 2157,
  [2158] = 2125,
  [2159] = 2112,
  [2160] = 2108,
  [2161] = 2161,
  [2162] = 2118,
  [2163] = 2131,
  [2164] = 69,
  [2165] = 2111,
  [2166] = 1517,
  [2167] = 2115,
  [2168] = 2106,
  [2169] = 2134,
  [2170] = 69,
  [2171] = 2171,
  [2172] = 2172,
  [2173] = 2173,
  [2174] = 2174,
  [2175] = 2175,
  [2176] = 2176,
  [2177] = 2177,
  [2178] = 2178,
  [2179] = 2171,
  [2180] = 2180,
  [2181] = 2181,
  [2182] = 2182,
  [2183] = 2183,
  [2184] = 2184,
  [2185] = 2185,
  [2186] = 2186,
  [2187] = 2187,
  [2188] = 2188,
  [2189] = 2189,
  [2190] = 2190,
  [2191] = 2191,
  [2192] = 2171,
  [2193] = 2193,
  [2194] = 2194,
  [2195] = 2171,
  [2196] = 2182,
  [2197] = 2197,
  [2198] = 2198,
  [2199] = 2199,
  [2200] = 2200,
  [2201] = 2182,
  [2202] = 2202,
  [2203] = 2203,
  [2204] = 2204,
  [2205] = 2171,
  [2206] = 2206,
  [2207] = 2194,
  [2208] = 2182,
  [2209] = 2209,
  [2210] = 2210,
  [2211] = 2211,
  [2212] = 2206,
  [2213] = 2213,
  [2214] = 2181,
  [2215] = 2215,
  [2216] = 2216,
  [2217] = 2217,
  [2218] = 2171,
  [2219] = 2182,
  [2220] = 2220,
  [2221] = 2171,
  [2222] = 2222,
  [2223] = 2172,
  [2224] = 2224,
  [2225] = 2182,
  [2226] = 2171,
  [2227] = 59,
  [2228] = 2182,
  [2229] = 2229,
  [2230] = 2202,
  [2231] = 2171,
  [2232] = 2232,
  [2233] = 2175,
  [2234] = 2234,
  [2235] = 2235,
  [2236] = 2236,
  [2237] = 2237,
  [2238] = 2182,
  [2239] = 2239,
  [2240] = 2240,
  [2241] = 2182,
  [2242] = 2182,
  [2243] = 2243,
  [2244] = 2244,
  [2245] = 2171,
  [2246] = 2246,
  [2247] = 2247,
  [2248] = 2171,
  [2249] = 2229,
  [2250] = 2182,
  [2251] = 2251,
  [2252] = 2172,
  [2253] = 2253,
  [2254] = 2254,
  [2255] = 2255,
  [2256] = 2182,
  [2257] = 2171,
  [2258] = 2258,
  [2259] = 2259,
  [2260] = 2171,
  [2261] = 2182,
  [2262] = 2262,
  [2263] = 2182,
  [2264] = 2264,
  [2265] = 2182,
  [2266] = 2266,
  [2267] = 2267,
  [2268] = 2182,
  [2269] = 2186,
  [2270] = 2182,
  [2271] = 2271,
  [2272] = 2272,
  [2273] = 2190,
  [2274] = 2171,
  [2275] = 2182,
  [2276] = 2276,
  [2277] = 2182,
  [2278] = 2278,
  [2279] = 2183,
  [2280] = 2280,
  [2281] = 2281,
  [2282] = 2282,
  [2283] = 2171,
  [2284] = 2284,
  [2285] = 2285,
  [2286] = 2171,
  [2287] = 2287,
  [2288] = 2193,
  [2289] = 2289,
  [2290] = 2182,
  [2291] = 2291,
  [2292] = 2198,
  [2293] = 2176,
  [2294] = 2210,
  [2295] = 2295,
  [2296] = 2296,
  [2297] = 2297,
  [2298] = 2298,
  [2299] = 2224,
  [2300] = 2237,
  [2301] = 2301,
  [2302] = 2302,
  [2303] = 2237,
  [2304] = 2171,
  [2305] = 2204,
  [2306] = 2306,
  [2307] = 2291,
  [2308] = 2184,
  [2309] = 2309,
  [2310] = 2310,
  [2311] = 2297,
  [2312] = 2312,
  [2313] = 2310,
  [2314] = 2314,
  [2315] = 2182,
  [2316] = 2316,
  [2317] = 2314,
  [2318] = 2310,
  [2319] = 2171,
  [2320] = 57,
  [2321] = 2264,
  [2322] = 1563,
  [2323] = 2183,
  [2324] = 2324,
  [2325] = 2325,
  [2326] = 2297,
  [2327] = 2314,
  [2328] = 2182,
  [2329] = 2302,
  [2330] = 2171,
  [2331] = 2188,
  [2332] = 2312,
  [2333] = 2182,
  [2334] = 2182,
  [2335] = 2222,
  [2336] = 2295,
  [2337] = 2337,
  [2338] = 2295,
  [2339] = 2271,
  [2340] = 2271,
  [2341] = 2287,
  [2342] = 2253,
  [2343] = 2171,
  [2344] = 2344,
  [2345] = 2291,
  [2346] = 2346,
  [2347] = 2182,
  [2348] = 2171,
  [2349] = 2267,
  [2350] = 2171,
  [2351] = 2253,
  [2352] = 2182,
  [2353] = 2234,
  [2354] = 2202,
  [2355] = 2232,
  [2356] = 2356,
  [2357] = 2357,
  [2358] = 2182,
  [2359] = 2346,
  [2360] = 2183,
  [2361] = 2361,
  [2362] = 2171,
  [2363] = 2363,
  [2364] = 734,
  [2365] = 2234,
  [2366] = 2206,
  [2367] = 2216,
  [2368] = 2181,
  [2369] = 2176,
  [2370] = 736,
  [2371] = 2371,
  [2372] = 2357,
  [2373] = 2216,
  [2374] = 2215,
  [2375] = 2375,
  [2376] = 2376,
  [2377] = 2254,
  [2378] = 2203,
  [2379] = 2262,
  [2380] = 2222,
  [2381] = 2197,
  [2382] = 2215,
  [2383] = 2258,
  [2384] = 2184,
  [2385] = 2309,
  [2386] = 2213,
  [2387] = 2376,
  [2388] = 2180,
  [2389] = 2182,
  [2390] = 2199,
  [2391] = 2203,
  [2392] = 2392,
  [2393] = 2197,
  [2394] = 2232,
  [2395] = 2302,
  [2396] = 2278,
  [2397] = 2235,
  [2398] = 2398,
  [2399] = 2194,
  [2400] = 2171,
  [2401] = 2287,
  [2402] = 2402,
  [2403] = 2182,
  [2404] = 2404,
  [2405] = 2224,
  [2406] = 2217,
  [2407] = 2180,
  [2408] = 2278,
  [2409] = 2284,
  [2410] = 2236,
  [2411] = 2337,
  [2412] = 741,
  [2413] = 2244,
  [2414] = 2240,
  [2415] = 2415,
  [2416] = 739,
  [2417] = 2417,
  [2418] = 2418,
  [2419] = 2375,
  [2420] = 2420,
  [2421] = 2239,
  [2422] = 2398,
  [2423] = 2280,
  [2424] = 2254,
  [2425] = 2402,
  [2426] = 2392,
  [2427] = 2357,
  [2428] = 2272,
  [2429] = 2284,
  [2430] = 2298,
  [2431] = 2431,
  [2432] = 2415,
  [2433] = 2420,
  [2434] = 2434,
  [2435] = 2280,
  [2436] = 2235,
  [2437] = 2437,
  [2438] = 2312,
  [2439] = 2439,
  [2440] = 717,
  [2441] = 2441,
  [2442] = 2442,
  [2443] = 2276,
  [2444] = 2266,
  [2445] = 2337,
  [2446] = 2404,
  [2447] = 2420,
  [2448] = 658,
  [2449] = 2276,
  [2450] = 2298,
  [2451] = 716,
  [2452] = 2441,
  [2453] = 2251,
  [2454] = 2177,
  [2455] = 2220,
  [2456] = 2174,
  [2457] = 2266,
  [2458] = 2185,
  [2459] = 2174,
  [2460] = 2177,
  [2461] = 2259,
  [2462] = 2189,
  [2463] = 2463,
  [2464] = 2185,
  [2465] = 700,
  [2466] = 2259,
  [2467] = 2189,
  [2468] = 2191,
  [2469] = 2375,
  [2470] = 2376,
  [2471] = 2191,
  [2472] = 2346,
  [2473] = 2309,
  [2474] = 2204,
  [2475] = 2243,
  [2476] = 2211,
  [2477] = 2211,
  [2478] = 2213,
  [2479] = 2182,
  [2480] = 2217,
  [2481] = 2220,
  [2482] = 2186,
  [2483] = 2182,
  [2484] = 2484,
  [2485] = 2171,
  [2486] = 2190,
  [2487] = 2199,
  [2488] = 2357,
  [2489] = 2182,
  [2490] = 2490,
  [2491] = 2229,
  [2492] = 2234,
  [2493] = 2175,
  [2494] = 2236,
  [2495] = 2247,
  [2496] = 2239,
  [2497] = 2216,
  [2498] = 2243,
  [2499] = 2402,
  [2500] = 2247,
  [2501] = 2251,
  [2502] = 2284,
  [2503] = 2392,
  [2504] = 2420,
  [2505] = 2258,
  [2506] = 2266,
  [2507] = 2262,
  [2508] = 2171,
  [2509] = 2186,
  [2510] = 2211,
  [2511] = 2190,
  [2512] = 2182,
  [2513] = 2513,
  [2514] = 2171,
  [2515] = 2193,
  [2516] = 2267,
  [2517] = 2441,
  [2518] = 2171,
  [2519] = 2415,
  [2520] = 2198,
  [2521] = 2272,
  [2522] = 2490,
  [2523] = 2357,
  [2524] = 2324,
  [2525] = 2398,
  [2526] = 2526,
  [2527] = 2240,
  [2528] = 2244,
  [2529] = 2188,
  [2530] = 2404,
  [2531] = 2210,
  [2532] = 2171,
  [2533] = 2533,
  [2534] = 2534,
  [2535] = 2534,
  [2536] = 2536,
  [2537] = 2534,
  [2538] = 2538,
  [2539] = 2539,
  [2540] = 2536,
  [2541] = 2534,
  [2542] = 2542,
  [2543] = 2533,
  [2544] = 2536,
  [2545] = 2534,
  [2546] = 2546,
  [2547] = 2538,
  [2548] = 2536,
  [2549] = 2534,
  [2550] = 2550,
  [2551] = 2551,
  [2552] = 2534,
  [2553] = 2533,
  [2554] = 2536,
  [2555] = 2536,
  [2556] = 2533,
  [2557] = 2536,
  [2558] = 2538,
  [2559] = 2533,
  [2560] = 2560,
  [2561] = 2534,
  [2562] = 2536,
  [2563] = 2538,
  [2564] = 2533,
  [2565] = 2534,
  [2566] = 2536,
  [2567] = 2538,
  [2568] = 2533,
  [2569] = 2534,
  [2570] = 2536,
  [2571] = 2538,
  [2572] = 2533,
  [2573] = 1600,
  [2574] = 2534,
  [2575] = 2536,
  [2576] = 2539,
  [2577] = 2538,
  [2578] = 2542,
  [2579] = 2533,
  [2580] = 2534,
  [2581] = 2546,
  [2582] = 2536,
  [2583] = 2538,
  [2584] = 2538,
  [2585] = 2550,
  [2586] = 2551,
  [2587] = 743,
  [2588] = 2534,
  [2589] = 2536,
  [2590] = 2538,
  [2591] = 2533,
  [2592] = 2551,
  [2593] = 2534,
  [2594] = 2536,
  [2595] = 2560,
  [2596] = 2538,
  [2597] = 2533,
  [2598] = 2534,
  [2599] = 2536,
  [2600] = 2542,
  [2601] = 2538,
  [2602] = 2533,
  [2603] = 2534,
  [2604] = 2536,
  [2605] = 2538,
  [2606] = 2533,
  [2607] = 733,
  [2608] = 731,
  [2609] = 2534,
  [2610] = 2536,
  [2611] = 2538,
  [2612] = 2550,
  [2613] = 2533,
  [2614] = 2534,
  [2615] = 2536,
  [2616] = 2533,
  [2617] = 2533,
  [2618] = 1583,
  [2619] = 2534,
  [2620] = 2536,
  [2621] = 2538,
  [2622] = 2533,
  [2623] = 2534,
  [2624] = 2536,
  [2625] = 2538,
  [2626] = 2534,
  [2627] = 2536,
  [2628] = 2538,
  [2629] = 2533,
  [2630] = 681,
  [2631] = 2534,
  [2632] = 2536,
  [2633] = 2538,
  [2634] = 2634,
  [2635] = 2533,
  [2636] = 2534,
  [2637] = 2536,
  [2638] = 2538,
  [2639] = 2533,
  [2640] = 2534,
  [2641] = 2536,
  [2642] = 2538,
  [2643] = 2533,
  [2644] = 2534,
  [2645] = 2536,
  [2646] = 2538,
  [2647] = 2533,
  [2648] = 2534,
  [2649] = 2536,
  [2650] = 2546,
  [2651] = 2538,
  [2652] = 2533,
  [2653] = 2534,
  [2654] = 2536,
  [2655] = 2538,
  [2656] = 2533,
  [2657] = 2534,
  [2658] = 2536,
  [2659] = 2538,
  [2660] = 2533,
  [2661] = 2534,
  [2662] = 2536,
  [2663] = 1171,
  [2664] = 2538,
  [2665] = 2665,
  [2666] = 2534,
  [2667] = 2536,
  [2668] = 2668,
  [2669] = 2538,
  [2670] = 2533,
  [2671] = 2671,
  [2672] = 2542,
  [2673] = 1219,
  [2674] = 2674,
  [2675] = 2675,
  [2676] = 2676,
  [2677] = 2677,
  [2678] = 2665,
  [2679] = 2679,
  [2680] = 2534,
  [2681] = 2536,
  [2682] = 2682,
  [2683] = 2683,
  [2684] = 2684,
  [2685] = 2538,
  [2686] = 2533,
  [2687] = 2687,
  [2688] = 2688,
  [2689] = 2689,
  [2690] = 2689,
  [2691] = 1222,
  [2692] = 2692,
  [2693] = 2688,
  [2694] = 2687,
  [2695] = 2533,
  [2696] = 2696,
  [2697] = 2538,
  [2698] = 2675,
  [2699] = 2676,
  [2700] = 2539,
  [2701] = 2677,
  [2702] = 2675,
  [2703] = 2679,
  [2704] = 2704,
  [2705] = 2534,
  [2706] = 2536,
  [2707] = 2682,
  [2708] = 2708,
  [2709] = 2709,
  [2710] = 2710,
  [2711] = 2683,
  [2712] = 2684,
  [2713] = 2538,
  [2714] = 2533,
  [2715] = 2687,
  [2716] = 2688,
  [2717] = 2684,
  [2718] = 2689,
  [2719] = 2560,
  [2720] = 2671,
  [2721] = 2721,
  [2722] = 2692,
  [2723] = 2683,
  [2724] = 1226,
  [2725] = 1228,
  [2726] = 2726,
  [2727] = 2682,
  [2728] = 2536,
  [2729] = 2534,
  [2730] = 2671,
  [2731] = 2731,
  [2732] = 2692,
  [2733] = 2733,
  [2734] = 2679,
  [2735] = 2634,
  [2736] = 2674,
  [2737] = 2737,
  [2738] = 2634,
  [2739] = 2674,
  [2740] = 2665,
  [2741] = 2677,
  [2742] = 2676,
  [2743] = 2743,
};

static TSCharacterRange sym__string_base_other_character_set_1[] = {
  {0, 0x08}, {0x0e, 0x1f}, {'!', '!'}, {'#', '#'}, {'%', '&'}, {'*', '*'}, {';', '<'}, {'>', '?'},
  {'^', '^'}, {'`', '`'}, {'|', '|'}, {'~', 0x10ffff},
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(419);
      ADVANCE_MAP(
        0, 1049,
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 1023,
        '#', 1009,
        '$', 1032,
        '\'', 1024,
        '(', 570,
        ')', 1031,
        '+', 1029,
        ',', 551,
        '-', 503,
        '.', 500,
        '/', 422,
        ':', 487,
        '=', 612,
        '@', 552,
        'A', 299,
        'B', 331,
        'C', 189,
        'D', 281,
        'E', 266,
        'F', 240,
        'G', 241,
        'H', 284,
        'I', 232,
        'L', 190,
        'P', 309,
        'R', 332,
        'S', 191,
        'T', 300,
        'U', 313,
        'V', 225,
        'W', 196,
        '[', 569,
        '\\', 154,
        ']', 548,
        'd', 409,
        '{', 549,
        '}', 550,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(414);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1016);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          (lookahead < '@' || ']' < lookahead) &&
          lookahead != '_' &&
          (lookahead < 'a' || '{' < lookahead)) ADVANCE(1010);
      END_STATE();
    case 1:
      ADVANCE_MAP(
        0, 1049,
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 1023,
        '#', 1009,
        '$', 1032,
        '\'', 1024,
        '(', 570,
        ')', 546,
        '+', 1029,
        ',', 551,
        '-', 501,
        '.', 500,
        '/', 422,
        ':', 487,
        '=', 469,
        '@', 552,
        '[', 547,
        '\\', 154,
        ']', 548,
        '{', 549,
        '}', 550,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(41);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1016);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1015);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(1010);
      END_STATE();
    case 2:
      ADVANCE_MAP(
        0, 1049,
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 1023,
        '#', 1009,
        '$', 1032,
        '\'', 1024,
        '(', 545,
        ')', 546,
        '+', 1029,
        ',', 551,
        '-', 501,
        '.', 500,
        '/', 422,
        ':', 487,
        '=', 469,
        '@', 552,
        'A', 1013,
        '[', 547,
        '\\', 154,
        ']', 548,
        '{', 549,
        '}', 550,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(42);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1016);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1015);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(1010);
      END_STATE();
    case 3:
      ADVANCE_MAP(
        0, 1049,
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 1023,
        '#', 1009,
        '$', 1032,
        '\'', 1024,
        '(', 545,
        ')', 546,
        '+', 1029,
        ',', 551,
        '-', 501,
        '.', 500,
        '/', 422,
        ':', 487,
        '=', 469,
        '@', 552,
        '[', 547,
        '\\', 154,
        ']', 548,
        '{', 549,
        '}', 550,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(43);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1016);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1015);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(1010);
      END_STATE();
    case 4:
      ADVANCE_MAP(
        0, 1049,
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 1023,
        '#', 1009,
        '$', 1032,
        '\'', 1024,
        '(', 545,
        ')', 546,
        '+', 1029,
        ',', 551,
        '-', 510,
        '.', 500,
        '/', 422,
        ':', 487,
        '=', 469,
        '@', 552,
        '[', 547,
        '\\', 154,
        ']', 548,
        '{', 549,
        '}', 550,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(44);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1016);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1015);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(1010);
      END_STATE();
    case 5:
      ADVANCE_MAP(
        0, 1049,
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 1023,
        '#', 1009,
        '$', 1032,
        '\'', 564,
        '(', 545,
        ')', 546,
        '+', 1029,
        ',', 551,
        '-', 501,
        '.', 500,
        '/', 422,
        ':', 487,
        '=', 469,
        '@', 552,
        'A', 1013,
        '[', 547,
        '\\', 154,
        ']', 548,
        '{', 549,
        '}', 550,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(17);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1016);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1015);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(1010);
      END_STATE();
    case 6:
      ADVANCE_MAP(
        0, 1049,
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 1023,
        '#', 1009,
        '$', 1032,
        '\'', 564,
        '(', 545,
        ')', 546,
        '+', 1029,
        ',', 551,
        '-', 501,
        '.', 500,
        '/', 422,
        ':', 487,
        '=', 469,
        '@', 552,
        'A', 1014,
        '[', 547,
        '\\', 154,
        ']', 548,
        '{', 549,
        '}', 550,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(16);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1016);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1015);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(1010);
      END_STATE();
    case 7:
      ADVANCE_MAP(
        0, 1049,
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 1023,
        '#', 1009,
        '$', 1032,
        '\'', 564,
        '(', 545,
        ')', 546,
        '+', 1029,
        ',', 551,
        '-', 501,
        '.', 500,
        '/', 422,
        ':', 487,
        '=', 469,
        '@', 552,
        '[', 547,
        '\\', 154,
        ']', 548,
        '{', 549,
        '}', 550,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(15);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1016);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1015);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(1010);
      END_STATE();
    case 8:
      ADVANCE_MAP(
        0, 1049,
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 1023,
        '#', 1009,
        '$', 1032,
        '\'', 564,
        '(', 545,
        ')', 546,
        '+', 1029,
        ',', 551,
        '-', 514,
        '.', 500,
        '/', 422,
        ':', 487,
        '=', 469,
        '@', 552,
        '[', 547,
        '\\', 154,
        ']', 548,
        '{', 549,
        '}', 550,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(13);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1016);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1015);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(1010);
      END_STATE();
    case 9:
      ADVANCE_MAP(
        0, 1049,
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 1023,
        '#', 1009,
        '$', 1032,
        '\'', 564,
        '(', 545,
        ')', 546,
        '+', 1029,
        ',', 551,
        '-', 502,
        '.', 500,
        '/', 422,
        ':', 487,
        '=', 469,
        '@', 552,
        '[', 547,
        '\\', 154,
        ']', 548,
        '{', 549,
        '}', 550,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(14);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1016);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1015);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(1010);
      END_STATE();
    case 10:
      ADVANCE_MAP(
        0, 1049,
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 1009,
        '$', 1032,
        '\'', 1024,
        '(', 545,
        ')', 546,
        '+', 1029,
        ',', 551,
        '-', 501,
        '.', 500,
        '/', 422,
        ':', 487,
        '=', 469,
        '@', 552,
        '[', 547,
        '\\', 154,
        ']', 548,
        '{', 549,
        '}', 550,
        '\t', 1030,
        ' ', 1030,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1016);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1015);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(1010);
      END_STATE();
    case 11:
      ADVANCE_MAP(
        0, 1049,
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 1009,
        '$', 557,
        '\'', 1024,
        '(', 519,
        ')', 520,
        '+', 558,
        ',', 526,
        '-', 501,
        '.', 500,
        '/', 422,
        ':', 487,
        '=', 428,
        '@', 552,
        '[', 521,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(48);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1016);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1015);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(1010);
      END_STATE();
    case 12:
      ADVANCE_MAP(
        0, 1049,
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 1009,
        '$', 557,
        '\'', 564,
        '(', 519,
        ')', 520,
        '+', 558,
        ',', 526,
        '-', 529,
        '.', 528,
        '/', 525,
        ':', 423,
        '=', 428,
        '@', 527,
        '[', 521,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(43);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1016);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1015);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(1010);
      END_STATE();
    case 13:
      ADVANCE_MAP(
        0, 1048,
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '#', 153,
        '\'', 564,
        '+', 558,
        '-', 184,
        '\\', 154,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(13);
      END_STATE();
    case 14:
      ADVANCE_MAP(
        0, 1048,
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '#', 153,
        '\'', 564,
        '+', 558,
        '-', 530,
        '\\', 154,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(14);
      END_STATE();
    case 15:
      ADVANCE_MAP(
        0, 1048,
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '#', 153,
        '\'', 564,
        '+', 558,
        '\\', 154,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(15);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 16:
      ADVANCE_MAP(
        0, 1048,
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '#', 153,
        '\'', 564,
        'A', 312,
        '\\', 154,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(16);
      END_STATE();
    case 17:
      ADVANCE_MAP(
        0, 1048,
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '#', 153,
        '\'', 564,
        'A', 318,
        '\\', 154,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(17);
      END_STATE();
    case 18:
      ADVANCE_MAP(
        0, 1048,
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '#', 153,
        '-', 501,
        '.', 500,
        ':', 487,
        '\\', 155,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(29);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1016);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1015);
      END_STATE();
    case 19:
      if ((!eof && lookahead == 00)) ADVANCE(1048);
      if (lookahead == '\n') ADVANCE(1041);
      if (lookahead == '\f') ADVANCE(1045);
      if (lookahead == '\r') ADVANCE(152);
      if (lookahead == '#') ADVANCE(153);
      if (lookahead == '-') ADVANCE(184);
      if (lookahead == '\\') ADVANCE(155);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(19);
      END_STATE();
    case 20:
      ADVANCE_MAP(
        0, 1048,
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '#', 153,
        '-', 187,
        '=', 612,
        '\\', 155,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(21);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(555);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 21:
      if ((!eof && lookahead == 00)) ADVANCE(1048);
      if (lookahead == '\n') ADVANCE(1041);
      if (lookahead == '\f') ADVANCE(1045);
      if (lookahead == '\r') ADVANCE(152);
      if (lookahead == '#') ADVANCE(153);
      if (lookahead == '-') ADVANCE(187);
      if (lookahead == '\\') ADVANCE(155);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(21);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(555);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 22:
      ADVANCE_MAP(
        0, 1048,
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '#', 153,
        '-', 186,
        'A', 312,
        '\\', 155,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(22);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(188);
      END_STATE();
    case 23:
      ADVANCE_MAP(
        0, 1048,
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '#', 153,
        '-', 514,
        '.', 500,
        ':', 487,
        '=', 469,
        '@', 552,
        '\\', 155,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(19);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1016);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1015);
      END_STATE();
    case 24:
      ADVANCE_MAP(
        0, 1048,
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '#', 153,
        '-', 530,
        '/', 422,
        ':', 487,
        '@', 552,
        '\\', 155,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(26);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1016);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1015);
      END_STATE();
    case 25:
      ADVANCE_MAP(
        0, 1048,
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '#', 153,
        '-', 530,
        '=', 428,
        '\\', 155,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(25);
      END_STATE();
    case 26:
      if ((!eof && lookahead == 00)) ADVANCE(1048);
      if (lookahead == '\n') ADVANCE(1041);
      if (lookahead == '\f') ADVANCE(1045);
      if (lookahead == '\r') ADVANCE(152);
      if (lookahead == '#') ADVANCE(153);
      if (lookahead == '-') ADVANCE(530);
      if (lookahead == '\\') ADVANCE(155);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(26);
      END_STATE();
    case 27:
      ADVANCE_MAP(
        0, 1048,
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '#', 153,
        '-', 502,
        '.', 500,
        '=', 428,
        '@', 552,
        '\\', 155,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(25);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1016);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1015);
      END_STATE();
    case 28:
      if ((!eof && lookahead == 00)) ADVANCE(1048);
      if (lookahead == '\n') ADVANCE(1041);
      if (lookahead == '\f') ADVANCE(1045);
      if (lookahead == '\r') ADVANCE(152);
      if (lookahead == '#') ADVANCE(153);
      if (lookahead == 'A') ADVANCE(318);
      if (lookahead == '\\') ADVANCE(155);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(28);
      END_STATE();
    case 29:
      if ((!eof && lookahead == 00)) ADVANCE(1048);
      if (lookahead == '\n') ADVANCE(1041);
      if (lookahead == '\f') ADVANCE(1045);
      if (lookahead == '\r') ADVANCE(152);
      if (lookahead == '#') ADVANCE(153);
      if (lookahead == '\\') ADVANCE(155);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(29);
      END_STATE();
    case 30:
      ADVANCE_MAP(
        0, 1050,
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 901,
        '$', 557,
        '\'', 1024,
        '(', 570,
        ')', 520,
        '+', 558,
        ',', 526,
        '-', 529,
        '.', 528,
        '/', 525,
        ':', 423,
        '=', 428,
        '@', 527,
        '[', 521,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(45);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1008);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(902);
      END_STATE();
    case 31:
      ADVANCE_MAP(
        0, 1050,
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 901,
        '$', 557,
        '\'', 1024,
        '(', 519,
        ')', 520,
        '+', 558,
        ',', 526,
        '-', 501,
        '.', 500,
        '/', 525,
        ':', 423,
        '=', 428,
        '@', 552,
        '[', 521,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(48);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1016);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1015);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(902);
      END_STATE();
    case 32:
      ADVANCE_MAP(
        0, 1050,
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 901,
        '$', 557,
        '\'', 1024,
        '(', 519,
        ')', 520,
        '+', 558,
        ',', 526,
        '-', 529,
        '.', 528,
        '/', 525,
        ':', 487,
        '=', 428,
        '@', 552,
        '[', 521,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(48);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1008);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(902);
      END_STATE();
    case 33:
      ADVANCE_MAP(
        0, 1050,
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 901,
        '$', 557,
        '\'', 1024,
        '(', 519,
        ')', 520,
        '+', 558,
        ',', 526,
        '-', 529,
        '.', 528,
        '/', 525,
        ':', 487,
        '=', 428,
        '@', 527,
        '[', 521,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(48);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1016);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1015);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(902);
      END_STATE();
    case 34:
      ADVANCE_MAP(
        0, 1050,
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 901,
        '$', 557,
        '\'', 1024,
        '(', 519,
        ')', 520,
        '+', 558,
        ',', 526,
        '-', 529,
        '.', 528,
        '/', 525,
        ':', 423,
        '=', 428,
        '@', 552,
        '[', 521,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(48);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1008);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(902);
      END_STATE();
    case 35:
      ADVANCE_MAP(
        0, 1050,
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 901,
        '$', 557,
        '\'', 1024,
        '(', 519,
        ')', 520,
        '+', 558,
        ',', 526,
        '-', 529,
        '.', 528,
        '/', 525,
        ':', 423,
        '=', 428,
        '@', 527,
        'A', 985,
        '[', 521,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(46);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1008);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(902);
      END_STATE();
    case 36:
      ADVANCE_MAP(
        0, 1050,
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 901,
        '$', 557,
        '\'', 1024,
        '(', 519,
        ')', 520,
        '+', 558,
        ',', 526,
        '-', 529,
        '.', 528,
        '/', 525,
        ':', 423,
        '=', 428,
        '@', 527,
        '[', 569,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(47);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1008);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(902);
      END_STATE();
    case 37:
      ADVANCE_MAP(
        0, 1050,
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 901,
        '$', 557,
        '\'', 1024,
        '(', 519,
        ')', 520,
        '+', 558,
        ',', 526,
        '-', 529,
        '.', 528,
        '/', 525,
        ':', 423,
        '=', 428,
        '@', 527,
        '[', 521,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(48);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1008);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(902);
      END_STATE();
    case 38:
      ADVANCE_MAP(
        0, 1050,
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 901,
        '$', 557,
        '\'', 1024,
        '(', 519,
        ')', 520,
        '+', 558,
        ',', 526,
        '-', 538,
        '.', 528,
        '/', 525,
        ':', 423,
        '=', 428,
        '@', 527,
        '[', 521,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(49);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1008);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(902);
      END_STATE();
    case 39:
      ADVANCE_MAP(
        0, 1050,
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 901,
        '$', 557,
        '\'', 1024,
        '(', 519,
        ')', 520,
        '+', 558,
        ',', 526,
        '-', 538,
        '.', 528,
        '/', 525,
        ':', 423,
        '=', 469,
        '@', 527,
        '[', 521,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(49);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1008);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(902);
      END_STATE();
    case 40:
      ADVANCE_MAP(
        0, 1050,
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 901,
        '$', 557,
        '\'', 1024,
        '(', 519,
        ')', 520,
        '+', 558,
        ',', 526,
        '-', 530,
        '.', 528,
        '/', 525,
        ':', 423,
        '=', 428,
        '@', 527,
        '[', 521,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(50);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1008);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(902);
      END_STATE();
    case 41:
      ADVANCE_MAP(
        0, 1050,
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 901,
        '$', 557,
        '\'', 564,
        '(', 570,
        ')', 520,
        '+', 558,
        ',', 526,
        '-', 529,
        '.', 528,
        '/', 525,
        ':', 423,
        '=', 428,
        '@', 527,
        '[', 521,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(41);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1008);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(902);
      END_STATE();
    case 42:
      ADVANCE_MAP(
        0, 1050,
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 901,
        '$', 557,
        '\'', 564,
        '(', 519,
        ')', 520,
        '+', 558,
        ',', 526,
        '-', 529,
        '.', 528,
        '/', 525,
        ':', 423,
        '=', 428,
        '@', 527,
        'A', 985,
        '[', 521,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(42);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1008);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(902);
      END_STATE();
    case 43:
      ADVANCE_MAP(
        0, 1050,
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 901,
        '$', 557,
        '\'', 564,
        '(', 519,
        ')', 520,
        '+', 558,
        ',', 526,
        '-', 529,
        '.', 528,
        '/', 525,
        ':', 423,
        '=', 428,
        '@', 527,
        '[', 521,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(43);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1008);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(902);
      END_STATE();
    case 44:
      ADVANCE_MAP(
        0, 1050,
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 901,
        '$', 557,
        '\'', 564,
        '(', 519,
        ')', 520,
        '+', 558,
        ',', 526,
        '-', 538,
        '.', 528,
        '/', 525,
        ':', 423,
        '=', 428,
        '@', 527,
        '[', 521,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(44);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1008);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(902);
      END_STATE();
    case 45:
      ADVANCE_MAP(
        0, 1050,
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 901,
        '$', 557,
        '(', 570,
        ')', 520,
        '+', 558,
        ',', 526,
        '-', 529,
        '.', 528,
        '/', 525,
        ':', 423,
        '=', 428,
        '@', 527,
        '[', 521,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(45);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1008);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          (lookahead < '\'' || ')' < lookahead)) ADVANCE(902);
      END_STATE();
    case 46:
      ADVANCE_MAP(
        0, 1050,
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 901,
        '$', 557,
        '(', 519,
        ')', 520,
        '+', 558,
        ',', 526,
        '-', 529,
        '.', 528,
        '/', 525,
        ':', 423,
        '=', 428,
        '@', 527,
        'A', 985,
        '[', 521,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(46);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1008);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          (lookahead < '\'' || ')' < lookahead)) ADVANCE(902);
      END_STATE();
    case 47:
      ADVANCE_MAP(
        0, 1050,
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 901,
        '$', 557,
        '(', 519,
        ')', 520,
        '+', 558,
        ',', 526,
        '-', 529,
        '.', 528,
        '/', 525,
        ':', 423,
        '=', 428,
        '@', 527,
        '[', 569,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(47);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1008);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          (lookahead < '\'' || ')' < lookahead)) ADVANCE(902);
      END_STATE();
    case 48:
      ADVANCE_MAP(
        0, 1050,
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 901,
        '$', 557,
        '(', 519,
        ')', 520,
        '+', 558,
        ',', 526,
        '-', 529,
        '.', 528,
        '/', 525,
        ':', 423,
        '=', 428,
        '@', 527,
        '[', 521,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(48);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1008);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          (lookahead < '\'' || ')' < lookahead)) ADVANCE(902);
      END_STATE();
    case 49:
      ADVANCE_MAP(
        0, 1050,
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 901,
        '$', 557,
        '(', 519,
        ')', 520,
        '+', 558,
        ',', 526,
        '-', 538,
        '.', 528,
        '/', 525,
        ':', 423,
        '=', 428,
        '@', 527,
        '[', 521,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(49);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1008);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          (lookahead < '\'' || ')' < lookahead)) ADVANCE(902);
      END_STATE();
    case 50:
      ADVANCE_MAP(
        0, 1050,
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 901,
        '$', 557,
        '(', 519,
        ')', 520,
        '+', 558,
        ',', 526,
        '-', 530,
        '.', 528,
        '/', 525,
        ':', 423,
        '=', 428,
        '@', 527,
        '[', 521,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(50);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1008);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          (lookahead < '\'' || ')' < lookahead)) ADVANCE(902);
      END_STATE();
    case 51:
      if (lookahead == '\t') SKIP(149);
      if (lookahead == '\n') ADVANCE(1041);
      if (lookahead == '\f') ADVANCE(1045);
      if (lookahead == '\r') ADVANCE(152);
      if (lookahead == ' ') ADVANCE(554);
      if (lookahead == '#') ADVANCE(153);
      if (lookahead == '-') ADVANCE(501);
      if (lookahead == '.') ADVANCE(500);
      if (lookahead == '=') ADVANCE(469);
      if (lookahead == '\\') ADVANCE(155);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1016);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1015);
      END_STATE();
    case 52:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 1023,
        '#', 1009,
        '$', 1032,
        '\'', 1024,
        '(', 570,
        ')', 546,
        '+', 1029,
        ',', 551,
        '-', 501,
        '.', 500,
        '/', 422,
        ':', 487,
        '=', 469,
        '@', 552,
        '[', 547,
        '\\', 154,
        ']', 548,
        '{', 549,
        '}', 550,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(102);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1016);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1015);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(1010);
      END_STATE();
    case 53:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 1023,
        '#', 1009,
        '$', 1032,
        '\'', 1024,
        '(', 570,
        ')', 546,
        '+', 1029,
        ',', 551,
        '-', 506,
        '.', 500,
        '/', 422,
        ':', 487,
        '=', 469,
        '@', 552,
        '[', 547,
        '\\', 154,
        ']', 548,
        '{', 549,
        '}', 550,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(103);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1016);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1015);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(1010);
      END_STATE();
    case 54:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 1023,
        '#', 1009,
        '$', 1032,
        '\'', 1024,
        '(', 570,
        ')', 546,
        '+', 1029,
        ',', 551,
        '-', 505,
        '.', 500,
        '/', 422,
        ':', 487,
        '=', 469,
        '@', 552,
        '[', 547,
        '\\', 154,
        ']', 548,
        '{', 549,
        '}', 550,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(104);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1016);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1015);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(1010);
      END_STATE();
    case 55:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 1023,
        '#', 1009,
        '$', 1032,
        '\'', 1024,
        '(', 545,
        ')', 546,
        '+', 1029,
        ',', 551,
        '-', 501,
        '.', 500,
        '/', 422,
        ':', 487,
        '=', 469,
        '@', 552,
        '[', 547,
        '\\', 154,
        ']', 548,
        '{', 549,
        '}', 550,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(111);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1016);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1015);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(1010);
      END_STATE();
    case 56:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 1023,
        '#', 1009,
        '$', 1032,
        '\'', 1024,
        '(', 545,
        ')', 546,
        '+', 1029,
        ',', 551,
        '-', 507,
        '.', 500,
        '/', 422,
        ':', 487,
        '=', 469,
        '@', 552,
        '[', 547,
        '\\', 154,
        ']', 548,
        '{', 549,
        '}', 550,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(112);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1016);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1015);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(1010);
      END_STATE();
    case 57:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 1023,
        '#', 1009,
        '$', 1032,
        '\'', 1024,
        '(', 545,
        ')', 546,
        '+', 1029,
        ',', 551,
        '-', 509,
        '.', 500,
        '/', 422,
        ':', 487,
        '=', 469,
        '@', 552,
        '[', 547,
        '\\', 154,
        ']', 548,
        '{', 549,
        '}', 550,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(116);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1016);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1015);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(1010);
      END_STATE();
    case 58:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 1023,
        '#', 1009,
        '$', 1032,
        '\'', 1024,
        '(', 545,
        ')', 546,
        '+', 1029,
        ',', 551,
        '-', 511,
        '.', 500,
        '/', 422,
        ':', 487,
        '=', 469,
        '@', 552,
        '[', 547,
        '\\', 154,
        ']', 548,
        '{', 549,
        '}', 550,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(117);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1016);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1015);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(1010);
      END_STATE();
    case 59:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 1023,
        '#', 1009,
        '$', 1032,
        '\'', 1024,
        '(', 545,
        ')', 546,
        '+', 1029,
        ',', 551,
        '-', 512,
        '.', 500,
        '/', 422,
        ':', 487,
        '=', 469,
        '@', 552,
        '[', 547,
        '\\', 154,
        ']', 548,
        '{', 549,
        '}', 550,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(118);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1016);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1015);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(1010);
      END_STATE();
    case 60:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 1023,
        '#', 1009,
        '$', 1032,
        '\'', 1024,
        '(', 545,
        ')', 546,
        '+', 1029,
        ',', 551,
        '-', 517,
        '.', 500,
        '/', 422,
        ':', 487,
        '=', 469,
        '@', 552,
        '[', 547,
        '\\', 154,
        ']', 548,
        '{', 549,
        '}', 550,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(119);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1016);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1015);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(1010);
      END_STATE();
    case 61:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 1023,
        '#', 1009,
        '$', 1032,
        '\'', 1024,
        '(', 545,
        ')', 546,
        '+', 1029,
        ',', 551,
        '-', 513,
        '.', 500,
        '/', 422,
        ':', 487,
        '=', 469,
        '@', 552,
        '[', 547,
        '\\', 154,
        ']', 548,
        '{', 549,
        '}', 550,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(120);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1016);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1015);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(1010);
      END_STATE();
    case 62:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 1023,
        '#', 1009,
        '$', 1032,
        '\'', 1024,
        '(', 545,
        ')', 546,
        '+', 1029,
        ',', 551,
        '-', 518,
        '.', 500,
        '/', 422,
        ':', 487,
        '=', 469,
        '@', 552,
        '[', 547,
        '\\', 154,
        ']', 548,
        '{', 549,
        '}', 550,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(121);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1016);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1015);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(1010);
      END_STATE();
    case 63:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 1023,
        '#', 1009,
        '$', 1032,
        '\'', 564,
        '(', 545,
        ')', 546,
        '+', 1029,
        ',', 551,
        '-', 504,
        '.', 500,
        '/', 422,
        ':', 487,
        '=', 612,
        '@', 552,
        '[', 569,
        '\\', 154,
        ']', 548,
        '{', 549,
        '}', 550,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(108);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1016);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1015);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(1010);
      END_STATE();
    case 64:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 1023,
        '#', 1009,
        '$', 1032,
        '\'', 564,
        '(', 545,
        ')', 546,
        '+', 1029,
        ',', 551,
        '-', 504,
        '.', 500,
        '/', 422,
        ':', 487,
        '=', 469,
        '@', 552,
        '[', 569,
        '\\', 154,
        ']', 548,
        '{', 549,
        '}', 550,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(108);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1016);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1015);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(1010);
      END_STATE();
    case 65:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 1023,
        '#', 1009,
        '$', 1032,
        '\'', 564,
        '(', 545,
        ')', 546,
        '+', 1029,
        ',', 551,
        '-', 508,
        '.', 500,
        '/', 422,
        ':', 487,
        '=', 612,
        '@', 552,
        '[', 547,
        '\\', 154,
        ']', 548,
        '{', 549,
        '}', 550,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(114);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1016);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1015);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(1010);
      END_STATE();
    case 66:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 1023,
        '#', 1009,
        '$', 1032,
        '\'', 564,
        '(', 545,
        ')', 546,
        '+', 1029,
        ',', 551,
        '-', 508,
        '.', 500,
        '/', 422,
        ':', 487,
        '=', 469,
        '@', 552,
        '[', 547,
        '\\', 154,
        ']', 548,
        '{', 549,
        '}', 550,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(114);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1016);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1015);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(1010);
      END_STATE();
    case 67:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 1023,
        '#', 1009,
        '$', 1032,
        '\'', 564,
        '(', 545,
        ')', 546,
        '+', 1029,
        ',', 551,
        '-', 516,
        '.', 500,
        '/', 422,
        ':', 487,
        '=', 612,
        '@', 552,
        '[', 547,
        '\\', 154,
        ']', 548,
        '{', 549,
        '}', 550,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(138);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1016);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1015);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(1010);
      END_STATE();
    case 68:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 1023,
        '#', 1009,
        '$', 1032,
        '\'', 564,
        '(', 545,
        ')', 546,
        '+', 1029,
        ',', 551,
        '-', 516,
        '.', 500,
        '/', 422,
        ':', 487,
        '=', 469,
        '@', 552,
        '[', 547,
        '\\', 154,
        ']', 548,
        '{', 549,
        '}', 550,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(138);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1016);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1015);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(1010);
      END_STATE();
    case 69:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 1023,
        '#', 1009,
        '$', 1032,
        '\'', 564,
        '(', 545,
        ')', 546,
        '+', 1029,
        ',', 551,
        '-', 515,
        '.', 500,
        '/', 422,
        ':', 487,
        '=', 469,
        '@', 552,
        '[', 547,
        '\\', 154,
        ']', 548,
        '{', 549,
        '}', 550,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(139);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1016);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1015);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(1010);
      END_STATE();
    case 70:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 1023,
        '#', 1009,
        '$', 1032,
        '\'', 564,
        '(', 545,
        ')', 571,
        '+', 1029,
        ',', 551,
        '-', 502,
        '.', 500,
        '/', 422,
        ':', 487,
        '=', 469,
        '@', 552,
        '[', 547,
        '\\', 154,
        ']', 548,
        '{', 549,
        '}', 550,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(137);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1016);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1015);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(1010);
      END_STATE();
    case 71:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 1009,
        '$', 1032,
        '\'', 1024,
        '(', 570,
        ')', 546,
        '+', 1029,
        ',', 551,
        '-', 501,
        '.', 500,
        '/', 422,
        ':', 487,
        '=', 469,
        '@', 552,
        '[', 547,
        '\\', 154,
        ']', 548,
        '{', 549,
        '}', 550,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(123);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1016);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1015);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(1010);
      END_STATE();
    case 72:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 1009,
        '$', 1032,
        '\'', 1024,
        '(', 570,
        ')', 546,
        '+', 1029,
        ',', 551,
        '-', 506,
        '.', 500,
        '/', 422,
        ':', 487,
        '=', 469,
        '@', 552,
        '[', 547,
        '\\', 154,
        ']', 548,
        '{', 549,
        '}', 550,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(124);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1016);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1015);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(1010);
      END_STATE();
    case 73:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 1009,
        '$', 557,
        '\'', 564,
        '(', 519,
        ')', 1031,
        '+', 558,
        ',', 526,
        '-', 529,
        '.', 528,
        '/', 525,
        ':', 423,
        '=', 428,
        '@', 527,
        '[', 521,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(105);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1016);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1015);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(1010);
      END_STATE();
    case 74:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 1009,
        '$', 557,
        '\'', 564,
        '(', 519,
        ')', 546,
        '+', 558,
        ',', 526,
        '-', 529,
        '.', 528,
        '/', 525,
        ':', 423,
        '=', 428,
        '@', 527,
        '[', 521,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(111);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1016);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1015);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(1010);
      END_STATE();
    case 75:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 901,
        '$', 557,
        '\'', 1024,
        '(', 570,
        ')', 520,
        '+', 558,
        ',', 526,
        '-', 529,
        '.', 528,
        '/', 525,
        ':', 423,
        '=', 428,
        '@', 527,
        '[', 521,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(123);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1008);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(902);
      END_STATE();
    case 76:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 901,
        '$', 557,
        '\'', 1024,
        '(', 570,
        ')', 520,
        '+', 558,
        ',', 526,
        '-', 506,
        '.', 500,
        '/', 525,
        ':', 423,
        '=', 428,
        '@', 527,
        '[', 521,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(124);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1016);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1015);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(902);
      END_STATE();
    case 77:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 901,
        '$', 557,
        '\'', 1024,
        '(', 570,
        ')', 520,
        '+', 558,
        ',', 526,
        '-', 534,
        '.', 528,
        '/', 525,
        ':', 423,
        '=', 428,
        '@', 527,
        '[', 521,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(124);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1008);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(902);
      END_STATE();
    case 78:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 901,
        '$', 557,
        '\'', 1024,
        '(', 570,
        ')', 520,
        '+', 558,
        ',', 526,
        '-', 534,
        '.', 528,
        '/', 525,
        ':', 423,
        '=', 469,
        '@', 527,
        '[', 521,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(124);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1008);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(902);
      END_STATE();
    case 79:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 901,
        '$', 557,
        '\'', 1024,
        '(', 570,
        ')', 520,
        '+', 558,
        ',', 526,
        '-', 533,
        '.', 528,
        '/', 525,
        ':', 423,
        '=', 469,
        '@', 527,
        '[', 521,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(125);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1008);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(902);
      END_STATE();
    case 80:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 901,
        '$', 557,
        '\'', 1024,
        '(', 519,
        ')', 520,
        '+', 558,
        ',', 526,
        '-', 501,
        '.', 500,
        '/', 525,
        ':', 423,
        '=', 428,
        '@', 527,
        '[', 521,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(127);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1016);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1015);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(902);
      END_STATE();
    case 81:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 901,
        '$', 557,
        '\'', 1024,
        '(', 519,
        ')', 520,
        '+', 558,
        ',', 526,
        '-', 529,
        '.', 528,
        '/', 525,
        ':', 423,
        '=', 443,
        '@', 527,
        '[', 521,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(126);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1016);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1015);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(902);
      END_STATE();
    case 82:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 901,
        '$', 557,
        '\'', 1024,
        '(', 519,
        ')', 520,
        '+', 558,
        ',', 526,
        '-', 529,
        '.', 528,
        '/', 525,
        ':', 423,
        '=', 443,
        '@', 527,
        '[', 521,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(126);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1008);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(902);
      END_STATE();
    case 83:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 901,
        '$', 557,
        '\'', 1024,
        '(', 519,
        ')', 520,
        '+', 558,
        ',', 526,
        '-', 529,
        '.', 528,
        '/', 525,
        ':', 423,
        '=', 428,
        '@', 527,
        '[', 521,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(127);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1008);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(902);
      END_STATE();
    case 84:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 901,
        '$', 557,
        '\'', 1024,
        '(', 519,
        ')', 520,
        '+', 558,
        ',', 526,
        '-', 529,
        '.', 528,
        '/', 525,
        ':', 423,
        '=', 469,
        '@', 527,
        '[', 521,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(127);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1016);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1015);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(902);
      END_STATE();
    case 85:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 901,
        '$', 557,
        '\'', 1024,
        '(', 519,
        ')', 520,
        '+', 558,
        ',', 526,
        '-', 529,
        '.', 528,
        '/', 525,
        ':', 423,
        '=', 469,
        '@', 527,
        '[', 521,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(127);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1008);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(902);
      END_STATE();
    case 86:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 901,
        '$', 557,
        '\'', 1024,
        '(', 519,
        ')', 520,
        '+', 558,
        ',', 526,
        '-', 535,
        '.', 528,
        '/', 525,
        ':', 423,
        '=', 428,
        '@', 527,
        '[', 521,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(128);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1008);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(902);
      END_STATE();
    case 87:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 901,
        '$', 557,
        '\'', 1024,
        '(', 519,
        ')', 520,
        '+', 558,
        ',', 526,
        '-', 535,
        '.', 528,
        '/', 525,
        ':', 423,
        '=', 469,
        '@', 527,
        '[', 521,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(128);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1008);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(902);
      END_STATE();
    case 88:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 901,
        '$', 557,
        '\'', 1024,
        '(', 519,
        ')', 520,
        '+', 558,
        ',', 526,
        '-', 537,
        '.', 528,
        '/', 525,
        ':', 423,
        '=', 428,
        '@', 527,
        '[', 521,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(129);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1008);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(902);
      END_STATE();
    case 89:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 901,
        '$', 557,
        '\'', 1024,
        '(', 519,
        ')', 520,
        '+', 558,
        ',', 526,
        '-', 537,
        '.', 528,
        '/', 525,
        ':', 423,
        '=', 469,
        '@', 527,
        '[', 521,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(129);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1008);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(902);
      END_STATE();
    case 90:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 901,
        '$', 557,
        '\'', 1024,
        '(', 519,
        ')', 520,
        '+', 558,
        ',', 526,
        '-', 511,
        '.', 500,
        '/', 525,
        ':', 423,
        '=', 428,
        '@', 527,
        '[', 521,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(130);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1016);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1015);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(902);
      END_STATE();
    case 91:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 901,
        '$', 557,
        '\'', 1024,
        '(', 519,
        ')', 520,
        '+', 558,
        ',', 526,
        '-', 539,
        '.', 528,
        '/', 525,
        ':', 423,
        '=', 428,
        '@', 527,
        '[', 521,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(130);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1008);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(902);
      END_STATE();
    case 92:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 901,
        '$', 557,
        '\'', 1024,
        '(', 519,
        ')', 520,
        '+', 558,
        ',', 526,
        '-', 539,
        '.', 528,
        '/', 525,
        ':', 423,
        '=', 469,
        '@', 527,
        '[', 521,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(130);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1008);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(902);
      END_STATE();
    case 93:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 901,
        '$', 557,
        '\'', 1024,
        '(', 519,
        ')', 520,
        '+', 558,
        ',', 526,
        '-', 540,
        '.', 528,
        '/', 525,
        ':', 423,
        '=', 428,
        '@', 527,
        '[', 521,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(131);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1008);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(902);
      END_STATE();
    case 94:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 901,
        '$', 557,
        '\'', 1024,
        '(', 519,
        ')', 520,
        '+', 558,
        ',', 526,
        '-', 540,
        '.', 528,
        '/', 525,
        ':', 423,
        '=', 469,
        '@', 527,
        '[', 521,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(131);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1008);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(902);
      END_STATE();
    case 95:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 901,
        '$', 557,
        '\'', 1024,
        '(', 519,
        ')', 520,
        '+', 558,
        ',', 526,
        '-', 542,
        '.', 528,
        '/', 525,
        ':', 423,
        '=', 428,
        '@', 527,
        '[', 521,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(132);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1008);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(902);
      END_STATE();
    case 96:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 901,
        '$', 557,
        '\'', 1024,
        '(', 519,
        ')', 520,
        '+', 558,
        ',', 526,
        '-', 542,
        '.', 528,
        '/', 525,
        ':', 423,
        '=', 469,
        '@', 527,
        '[', 521,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(132);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1008);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(902);
      END_STATE();
    case 97:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 901,
        '$', 557,
        '\'', 1024,
        '(', 519,
        ')', 520,
        '+', 558,
        ',', 526,
        '-', 541,
        '.', 528,
        '/', 525,
        ':', 423,
        '=', 428,
        '@', 527,
        '[', 521,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(133);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1008);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(902);
      END_STATE();
    case 98:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 901,
        '$', 557,
        '\'', 1024,
        '(', 519,
        ')', 520,
        '+', 558,
        ',', 526,
        '-', 541,
        '.', 528,
        '/', 525,
        ':', 423,
        '=', 469,
        '@', 527,
        '[', 521,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(133);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1008);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(902);
      END_STATE();
    case 99:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 901,
        '$', 557,
        '\'', 1024,
        '(', 519,
        ')', 520,
        '+', 558,
        ',', 526,
        '-', 543,
        '.', 528,
        '/', 525,
        ':', 423,
        '=', 428,
        '@', 527,
        '[', 521,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(134);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1008);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(902);
      END_STATE();
    case 100:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 901,
        '$', 557,
        '\'', 1024,
        '(', 519,
        ')', 520,
        '+', 558,
        ',', 526,
        '-', 543,
        '.', 528,
        '/', 525,
        ':', 423,
        '=', 469,
        '@', 527,
        '[', 521,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(134);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1008);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(902);
      END_STATE();
    case 101:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 901,
        '$', 557,
        '\'', 1024,
        '(', 519,
        ')', 571,
        '+', 558,
        ',', 526,
        '-', 530,
        '.', 528,
        '/', 525,
        ':', 423,
        '=', 428,
        '@', 527,
        '[', 521,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(135);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1008);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(902);
      END_STATE();
    case 102:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 901,
        '$', 557,
        '\'', 564,
        '(', 570,
        ')', 520,
        '+', 558,
        ',', 526,
        '-', 529,
        '.', 528,
        '/', 525,
        ':', 423,
        '=', 428,
        '@', 527,
        '[', 521,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(102);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1008);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(902);
      END_STATE();
    case 103:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 901,
        '$', 557,
        '\'', 564,
        '(', 570,
        ')', 520,
        '+', 558,
        ',', 526,
        '-', 534,
        '.', 528,
        '/', 525,
        ':', 423,
        '=', 428,
        '@', 527,
        '[', 521,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(103);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1008);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(902);
      END_STATE();
    case 104:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 901,
        '$', 557,
        '\'', 564,
        '(', 570,
        ')', 520,
        '+', 558,
        ',', 526,
        '-', 533,
        '.', 528,
        '/', 525,
        ':', 423,
        '=', 428,
        '@', 527,
        '[', 521,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(104);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1008);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(902);
      END_STATE();
    case 105:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 901,
        '$', 557,
        '\'', 564,
        '(', 519,
        ')', 1031,
        '+', 558,
        ',', 526,
        '-', 529,
        '.', 528,
        '/', 525,
        ':', 423,
        '=', 428,
        '@', 527,
        '[', 521,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(105);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1008);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(902);
      END_STATE();
    case 106:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 901,
        '$', 557,
        '\'', 564,
        '(', 519,
        ')', 546,
        '+', 558,
        ',', 526,
        '-', 529,
        '.', 528,
        '/', 525,
        ':', 423,
        '=', 428,
        '@', 527,
        '[', 521,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(111);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1008);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(902);
      END_STATE();
    case 107:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 901,
        '$', 557,
        '\'', 564,
        '(', 519,
        ')', 520,
        '+', 558,
        ',', 526,
        '-', 532,
        '.', 528,
        '/', 525,
        ':', 423,
        '=', 612,
        '@', 527,
        '[', 569,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(108);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1008);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(902);
      END_STATE();
    case 108:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 901,
        '$', 557,
        '\'', 564,
        '(', 519,
        ')', 520,
        '+', 558,
        ',', 526,
        '-', 532,
        '.', 528,
        '/', 525,
        ':', 423,
        '=', 428,
        '@', 527,
        '[', 569,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(108);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1008);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(902);
      END_STATE();
    case 109:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 901,
        '$', 557,
        '\'', 564,
        '(', 519,
        ')', 520,
        '+', 558,
        ',', 526,
        '-', 532,
        '.', 528,
        '/', 525,
        ':', 423,
        '=', 469,
        '@', 527,
        '[', 569,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(108);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1008);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(902);
      END_STATE();
    case 110:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 901,
        '$', 557,
        '\'', 564,
        '(', 519,
        ')', 520,
        '+', 558,
        ',', 526,
        '-', 529,
        '.', 528,
        '/', 525,
        ':', 423,
        '=', 428,
        '@', 527,
        '[', 569,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(110);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1008);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(902);
      END_STATE();
    case 111:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 901,
        '$', 557,
        '\'', 564,
        '(', 519,
        ')', 520,
        '+', 558,
        ',', 526,
        '-', 529,
        '.', 528,
        '/', 525,
        ':', 423,
        '=', 428,
        '@', 527,
        '[', 521,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(111);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1008);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(902);
      END_STATE();
    case 112:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 901,
        '$', 557,
        '\'', 564,
        '(', 519,
        ')', 520,
        '+', 558,
        ',', 526,
        '-', 535,
        '.', 528,
        '/', 525,
        ':', 423,
        '=', 428,
        '@', 527,
        '[', 521,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(112);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1008);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(902);
      END_STATE();
    case 113:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 901,
        '$', 557,
        '\'', 564,
        '(', 519,
        ')', 520,
        '+', 558,
        ',', 526,
        '-', 536,
        '.', 528,
        '/', 525,
        ':', 423,
        '=', 612,
        '@', 527,
        '[', 521,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(114);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1008);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(902);
      END_STATE();
    case 114:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 901,
        '$', 557,
        '\'', 564,
        '(', 519,
        ')', 520,
        '+', 558,
        ',', 526,
        '-', 536,
        '.', 528,
        '/', 525,
        ':', 423,
        '=', 428,
        '@', 527,
        '[', 521,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(114);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1008);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(902);
      END_STATE();
    case 115:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 901,
        '$', 557,
        '\'', 564,
        '(', 519,
        ')', 520,
        '+', 558,
        ',', 526,
        '-', 536,
        '.', 528,
        '/', 525,
        ':', 423,
        '=', 469,
        '@', 527,
        '[', 521,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(114);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1008);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(902);
      END_STATE();
    case 116:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 901,
        '$', 557,
        '\'', 564,
        '(', 519,
        ')', 520,
        '+', 558,
        ',', 526,
        '-', 537,
        '.', 528,
        '/', 525,
        ':', 423,
        '=', 428,
        '@', 527,
        '[', 521,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(116);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1008);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(902);
      END_STATE();
    case 117:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 901,
        '$', 557,
        '\'', 564,
        '(', 519,
        ')', 520,
        '+', 558,
        ',', 526,
        '-', 539,
        '.', 528,
        '/', 525,
        ':', 423,
        '=', 428,
        '@', 527,
        '[', 521,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(117);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1008);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(902);
      END_STATE();
    case 118:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 901,
        '$', 557,
        '\'', 564,
        '(', 519,
        ')', 520,
        '+', 558,
        ',', 526,
        '-', 540,
        '.', 528,
        '/', 525,
        ':', 423,
        '=', 428,
        '@', 527,
        '[', 521,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(118);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1008);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(902);
      END_STATE();
    case 119:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 901,
        '$', 557,
        '\'', 564,
        '(', 519,
        ')', 520,
        '+', 558,
        ',', 526,
        '-', 542,
        '.', 528,
        '/', 525,
        ':', 423,
        '=', 428,
        '@', 527,
        '[', 521,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(119);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1008);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(902);
      END_STATE();
    case 120:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 901,
        '$', 557,
        '\'', 564,
        '(', 519,
        ')', 520,
        '+', 558,
        ',', 526,
        '-', 541,
        '.', 528,
        '/', 525,
        ':', 423,
        '=', 428,
        '@', 527,
        '[', 521,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(120);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1008);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(902);
      END_STATE();
    case 121:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 901,
        '$', 557,
        '\'', 564,
        '(', 519,
        ')', 520,
        '+', 558,
        ',', 526,
        '-', 543,
        '.', 528,
        '/', 525,
        ':', 423,
        '=', 428,
        '@', 527,
        '[', 521,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(121);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1008);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(902);
      END_STATE();
    case 122:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 901,
        '$', 557,
        '\'', 564,
        '(', 519,
        ')', 520,
        '+', 558,
        ',', 526,
        '-', 544,
        '.', 528,
        '/', 525,
        ':', 423,
        '=', 428,
        '@', 527,
        '[', 569,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(122);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1008);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(902);
      END_STATE();
    case 123:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 901,
        '$', 557,
        '(', 570,
        ')', 520,
        '+', 558,
        ',', 526,
        '-', 529,
        '.', 528,
        '/', 525,
        ':', 423,
        '=', 428,
        '@', 527,
        '[', 521,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(123);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1008);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          (lookahead < '\'' || ')' < lookahead)) ADVANCE(902);
      END_STATE();
    case 124:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 901,
        '$', 557,
        '(', 570,
        ')', 520,
        '+', 558,
        ',', 526,
        '-', 534,
        '.', 528,
        '/', 525,
        ':', 423,
        '=', 428,
        '@', 527,
        '[', 521,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(124);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1008);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          (lookahead < '\'' || ')' < lookahead)) ADVANCE(902);
      END_STATE();
    case 125:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 901,
        '$', 557,
        '(', 570,
        ')', 520,
        '+', 558,
        ',', 526,
        '-', 533,
        '.', 528,
        '/', 525,
        ':', 423,
        '=', 428,
        '@', 527,
        '[', 521,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(125);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1008);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          (lookahead < '\'' || ')' < lookahead)) ADVANCE(902);
      END_STATE();
    case 126:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 901,
        '$', 557,
        '(', 519,
        ')', 520,
        '+', 558,
        ',', 526,
        '-', 529,
        '.', 528,
        '/', 525,
        ':', 423,
        '=', 443,
        '@', 527,
        '[', 521,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(126);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1008);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          (lookahead < '\'' || ')' < lookahead)) ADVANCE(902);
      END_STATE();
    case 127:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 901,
        '$', 557,
        '(', 519,
        ')', 520,
        '+', 558,
        ',', 526,
        '-', 529,
        '.', 528,
        '/', 525,
        ':', 423,
        '=', 428,
        '@', 527,
        '[', 521,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(127);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1008);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          (lookahead < '\'' || ')' < lookahead)) ADVANCE(902);
      END_STATE();
    case 128:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 901,
        '$', 557,
        '(', 519,
        ')', 520,
        '+', 558,
        ',', 526,
        '-', 535,
        '.', 528,
        '/', 525,
        ':', 423,
        '=', 428,
        '@', 527,
        '[', 521,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(128);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1008);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          (lookahead < '\'' || ')' < lookahead)) ADVANCE(902);
      END_STATE();
    case 129:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 901,
        '$', 557,
        '(', 519,
        ')', 520,
        '+', 558,
        ',', 526,
        '-', 537,
        '.', 528,
        '/', 525,
        ':', 423,
        '=', 428,
        '@', 527,
        '[', 521,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(129);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1008);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          (lookahead < '\'' || ')' < lookahead)) ADVANCE(902);
      END_STATE();
    case 130:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 901,
        '$', 557,
        '(', 519,
        ')', 520,
        '+', 558,
        ',', 526,
        '-', 539,
        '.', 528,
        '/', 525,
        ':', 423,
        '=', 428,
        '@', 527,
        '[', 521,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(130);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1008);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          (lookahead < '\'' || ')' < lookahead)) ADVANCE(902);
      END_STATE();
    case 131:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 901,
        '$', 557,
        '(', 519,
        ')', 520,
        '+', 558,
        ',', 526,
        '-', 540,
        '.', 528,
        '/', 525,
        ':', 423,
        '=', 428,
        '@', 527,
        '[', 521,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(131);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1008);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          (lookahead < '\'' || ')' < lookahead)) ADVANCE(902);
      END_STATE();
    case 132:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 901,
        '$', 557,
        '(', 519,
        ')', 520,
        '+', 558,
        ',', 526,
        '-', 542,
        '.', 528,
        '/', 525,
        ':', 423,
        '=', 428,
        '@', 527,
        '[', 521,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(132);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1008);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          (lookahead < '\'' || ')' < lookahead)) ADVANCE(902);
      END_STATE();
    case 133:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 901,
        '$', 557,
        '(', 519,
        ')', 520,
        '+', 558,
        ',', 526,
        '-', 541,
        '.', 528,
        '/', 525,
        ':', 423,
        '=', 428,
        '@', 527,
        '[', 521,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(133);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1008);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          (lookahead < '\'' || ')' < lookahead)) ADVANCE(902);
      END_STATE();
    case 134:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 901,
        '$', 557,
        '(', 519,
        ')', 520,
        '+', 558,
        ',', 526,
        '-', 543,
        '.', 528,
        '/', 525,
        ':', 423,
        '=', 428,
        '@', 527,
        '[', 521,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(134);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1008);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          (lookahead < '\'' || ')' < lookahead)) ADVANCE(902);
      END_STATE();
    case 135:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 901,
        '$', 557,
        '(', 519,
        ')', 571,
        '+', 558,
        ',', 526,
        '-', 530,
        '.', 528,
        '/', 525,
        ':', 423,
        '=', 428,
        '@', 527,
        '[', 521,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(135);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1008);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          (lookahead < '\'' || ')' < lookahead)) ADVANCE(902);
      END_STATE();
    case 136:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '#', 1009,
        '(', 545,
        ')', 546,
        '+', 558,
        ',', 551,
        '-', 501,
        '.', 500,
        '/', 422,
        ':', 487,
        '@', 552,
        '[', 547,
        '\\', 154,
        ']', 548,
        '{', 549,
        '}', 550,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(140);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1016);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1015);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          (lookahead < '"' || '$' < lookahead) &&
          (lookahead < '\'' || ')' < lookahead) &&
          lookahead != '=') ADVANCE(1010);
      END_STATE();
    case 137:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '#', 153,
        '\'', 564,
        ')', 571,
        '+', 558,
        '-', 530,
        '\\', 154,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(137);
      END_STATE();
    case 138:
      if (lookahead == '\n') ADVANCE(1041);
      if (lookahead == '\f') ADVANCE(1045);
      if (lookahead == '\r') ADVANCE(152);
      if (lookahead == '#') ADVANCE(153);
      if (lookahead == '\'') ADVANCE(564);
      if (lookahead == '-') ADVANCE(187);
      if (lookahead == '\\') ADVANCE(154);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(138);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 139:
      if (lookahead == '\n') ADVANCE(1041);
      if (lookahead == '\f') ADVANCE(1045);
      if (lookahead == '\r') ADVANCE(152);
      if (lookahead == '#') ADVANCE(153);
      if (lookahead == '\'') ADVANCE(564);
      if (lookahead == '-') ADVANCE(185);
      if (lookahead == '\\') ADVANCE(154);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(139);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 140:
      if (lookahead == '\n') ADVANCE(1041);
      if (lookahead == '\f') ADVANCE(1045);
      if (lookahead == '\r') ADVANCE(152);
      if (lookahead == '#') ADVANCE(153);
      if (lookahead == '+') ADVANCE(558);
      if (lookahead == '\\') ADVANCE(154);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(140);
      END_STATE();
    case 141:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '#', 153,
        '-', 501,
        '.', 500,
        '/', 422,
        ':', 423,
        '=', 469,
        '@', 552,
        '\\', 155,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(146);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1016);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1015);
      END_STATE();
    case 142:
      if (lookahead == '\n') ADVANCE(1041);
      if (lookahead == '\f') ADVANCE(1045);
      if (lookahead == '\r') ADVANCE(152);
      if (lookahead == '#') ADVANCE(153);
      if (lookahead == '-') ADVANCE(187);
      if (lookahead == '=') ADVANCE(469);
      if (lookahead == '\\') ADVANCE(155);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(143);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(188);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 143:
      if (lookahead == '\n') ADVANCE(1041);
      if (lookahead == '\f') ADVANCE(1045);
      if (lookahead == '\r') ADVANCE(152);
      if (lookahead == '#') ADVANCE(153);
      if (lookahead == '-') ADVANCE(187);
      if (lookahead == '\\') ADVANCE(155);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(143);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(188);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 144:
      if (lookahead == '\n') ADVANCE(1041);
      if (lookahead == '\f') ADVANCE(1045);
      if (lookahead == '\r') ADVANCE(152);
      if (lookahead == '#') ADVANCE(153);
      if (lookahead == '-') ADVANCE(185);
      if (lookahead == '=') ADVANCE(469);
      if (lookahead == '\\') ADVANCE(155);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(145);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 145:
      if (lookahead == '\n') ADVANCE(1041);
      if (lookahead == '\f') ADVANCE(1045);
      if (lookahead == '\r') ADVANCE(152);
      if (lookahead == '#') ADVANCE(153);
      if (lookahead == '-') ADVANCE(185);
      if (lookahead == '\\') ADVANCE(155);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(145);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 146:
      if (lookahead == '\n') ADVANCE(1041);
      if (lookahead == '\f') ADVANCE(1045);
      if (lookahead == '\r') ADVANCE(152);
      if (lookahead == '#') ADVANCE(153);
      if (lookahead == ':') ADVANCE(423);
      if (lookahead == '\\') ADVANCE(155);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(146);
      END_STATE();
    case 147:
      if (lookahead == '\n') ADVANCE(1041);
      if (lookahead == '\f') ADVANCE(1045);
      if (lookahead == '\r') ADVANCE(152);
      if (lookahead == '#') ADVANCE(153);
      if (lookahead == 'I') ADVANCE(1012);
      if (lookahead == '\\') ADVANCE(155);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(148);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1016);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1015);
      END_STATE();
    case 148:
      if (lookahead == '\n') ADVANCE(1041);
      if (lookahead == '\f') ADVANCE(1045);
      if (lookahead == '\r') ADVANCE(152);
      if (lookahead == '#') ADVANCE(153);
      if (lookahead == 'I') ADVANCE(272);
      if (lookahead == '\\') ADVANCE(155);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(148);
      END_STATE();
    case 149:
      if (lookahead == '\n') ADVANCE(1041);
      if (lookahead == '\f') ADVANCE(1045);
      if (lookahead == '\r') ADVANCE(152);
      if (lookahead == '#') ADVANCE(153);
      if (lookahead == '\\') ADVANCE(155);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(149);
      END_STATE();
    case 150:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1047,
        '\r', 1025,
        '#', 1026,
        '\'', 1024,
        '\\', 154,
        '\t', 1027,
        ' ', 1027,
      );
      if (lookahead != 0) ADVANCE(1028);
      END_STATE();
    case 151:
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1047,
        '\r', 1025,
        '#', 1026,
        '\'', 564,
        '\\', 154,
        '\t', 1027,
        ' ', 1027,
      );
      if (lookahead != 0) ADVANCE(1028);
      END_STATE();
    case 152:
      if (lookahead == '\n') ADVANCE(1043);
      END_STATE();
    case 153:
      if (lookahead == '\n') ADVANCE(1037);
      if (lookahead == '\f') ADVANCE(1038);
      if (lookahead == '\r') ADVANCE(153);
      if (lookahead != 0) ADVANCE(153);
      END_STATE();
    case 154:
      if (lookahead == '\n') ADVANCE(1036);
      if (lookahead == '#') ADVANCE(1034);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(1035);
      if (lookahead != 0) ADVANCE(1033);
      END_STATE();
    case 155:
      if (lookahead == '\n') ADVANCE(1036);
      if (lookahead == '#') ADVANCE(156);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(183);
      END_STATE();
    case 156:
      if (lookahead == '\n') ADVANCE(1040);
      if (lookahead != 0) ADVANCE(156);
      END_STATE();
    case 157:
      ADVANCE_MAP(
        '\n', 1042,
        0x0b, 497,
        '\f', 1046,
        '\r', 496,
        '#', 153,
        'A', 298,
        'B', 331,
        'C', 189,
        'D', 281,
        'E', 266,
        'F', 240,
        'G', 241,
        'H', 284,
        'I', 231,
        'L', 190,
        'P', 309,
        'R', 332,
        'S', 191,
        'T', 300,
        'U', 313,
        'V', 282,
        'W', 196,
        '\\', 155,
        '\t', 495,
        ' ', 495,
      );
      END_STATE();
    case 158:
      ADVANCE_MAP(
        '\n', 1022,
        '\f', 1022,
        '\r', 1019,
        '"', 1023,
        '#', 1018,
        '$', 1032,
        '\\', 154,
        '\t', 1017,
        ' ', 1017,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1020);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1021);
      if (lookahead != 0) ADVANCE(1022);
      END_STATE();
    case 159:
      ADVANCE_MAP(
        '\n', 1022,
        '\f', 1022,
        '\r', 1019,
        '"', 559,
        '#', 1018,
        '$', 1032,
        '\\', 154,
        '\t', 1017,
        ' ', 1017,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1020);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1021);
      if (lookahead != 0) ADVANCE(1022);
      END_STATE();
    case 160:
      ADVANCE_MAP(
        '\n', 568,
        '\f', 568,
        '\r', 567,
        '#', 566,
        '\'', 564,
        '\\', 154,
        '\t', 565,
        ' ', 565,
      );
      if (lookahead != 0) ADVANCE(568);
      END_STATE();
    case 161:
      ADVANCE_MAP(
        '\n', 563,
        '\f', 563,
        '\r', 562,
        '"', 559,
        '#', 561,
        '\\', 154,
        '\t', 560,
        ' ', 560,
      );
      if (lookahead != 0) ADVANCE(563);
      END_STATE();
    case 162:
      if (lookahead == ' ') ADVANCE(198);
      END_STATE();
    case 163:
      if (lookahead == ' ') ADVANCE(378);
      END_STATE();
    case 164:
      if (lookahead == ' ') ADVANCE(406);
      END_STATE();
    case 165:
      if (lookahead == ' ') ADVANCE(351);
      END_STATE();
    case 166:
      if (lookahead == ' ') ADVANCE(345);
      END_STATE();
    case 167:
      if (lookahead == ' ') ADVANCE(365);
      END_STATE();
    case 168:
      if (lookahead == ' ') ADVANCE(352);
      END_STATE();
    case 169:
      if (lookahead == ' ') ADVANCE(476);
      END_STATE();
    case 170:
      if (lookahead == ' ') ADVANCE(410);
      END_STATE();
    case 171:
      if (lookahead == ' ') ADVANCE(404);
      END_STATE();
    case 172:
      if (lookahead == ' ') ADVANCE(342);
      END_STATE();
    case 173:
      if (lookahead == ' ') ADVANCE(369);
      END_STATE();
    case 174:
      if (lookahead == ' ') ADVANCE(408);
      END_STATE();
    case 175:
      if (lookahead == ' ') ADVANCE(341);
      END_STATE();
    case 176:
      if (lookahead == ' ') ADVANCE(203);
      END_STATE();
    case 177:
      if (lookahead == ' ') ADVANCE(388);
      END_STATE();
    case 178:
      if (lookahead == ' ') ADVANCE(265);
      END_STATE();
    case 179:
      if (lookahead == ' ') ADVANCE(216);
      END_STATE();
    case 180:
      if (lookahead == ' ') ADVANCE(348);
      END_STATE();
    case 181:
      if (lookahead == ' ') ADVANCE(349);
      END_STATE();
    case 182:
      if (lookahead == ' ') ADVANCE(350);
      END_STATE();
    case 183:
      if (lookahead == '#') ADVANCE(156);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(183);
      END_STATE();
    case 184:
      if (lookahead == '-') ADVANCE(640);
      END_STATE();
    case 185:
      if (lookahead == '-') ADVANCE(725);
      END_STATE();
    case 186:
      if (lookahead == '-') ADVANCE(413);
      END_STATE();
    case 187:
      if (lookahead == '-') ADVANCE(779);
      END_STATE();
    case 188:
      if (lookahead == '.') ADVANCE(412);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(188);
      END_STATE();
    case 189:
      if (lookahead == 'A') ADVANCE(201);
      if (lookahead == 'M') ADVANCE(210);
      if (lookahead == 'O') ADVANCE(267);
      END_STATE();
    case 190:
      if (lookahead == 'A') ADVANCE(200);
      if (lookahead == 'E') ADVANCE(320);
      if (lookahead == 'O') ADVANCE(208);
      END_STATE();
    case 191:
      if (lookahead == 'A') ADVANCE(334);
      if (lookahead == 'E') ADVANCE(321);
      END_STATE();
    case 192:
      if (lookahead == 'A') ADVANCE(237);
      END_STATE();
    case 193:
      if (lookahead == 'A') ADVANCE(261);
      END_STATE();
    case 194:
      if (lookahead == 'A') ADVANCE(278);
      END_STATE();
    case 195:
      if (lookahead == 'A') ADVANCE(256);
      END_STATE();
    case 196:
      if (lookahead == 'A') ADVANCE(245);
      if (lookahead == 'I') ADVANCE(328);
      if (lookahead == 'O') ADVANCE(302);
      END_STATE();
    case 197:
      if (lookahead == 'A') ADVANCE(262);
      END_STATE();
    case 198:
      if (lookahead == 'A') ADVANCE(311);
      if (lookahead == 'I') ADVANCE(270);
      END_STATE();
    case 199:
      if (lookahead == 'A') ADVANCE(206);
      END_STATE();
    case 200:
      if (lookahead == 'B') ADVANCE(226);
      END_STATE();
    case 201:
      if (lookahead == 'C') ADVANCE(239);
      END_STATE();
    case 202:
      if (lookahead == 'C') ADVANCE(253);
      END_STATE();
    case 203:
      if (lookahead == 'C') ADVANCE(263);
      END_STATE();
    case 204:
      if (lookahead == 'C') ADVANCE(330);
      END_STATE();
    case 205:
      if (lookahead == 'C') ADVANCE(325);
      END_STATE();
    case 206:
      if (lookahead == 'C') ADVANCE(327);
      END_STATE();
    case 207:
      if (lookahead == 'C') ADVANCE(195);
      END_STATE();
    case 208:
      if (lookahead == 'C') ADVANCE(197);
      END_STATE();
    case 209:
      if (lookahead == 'C') ADVANCE(254);
      END_STATE();
    case 210:
      if (lookahead == 'D') ADVANCE(433);
      END_STATE();
    case 211:
      if (lookahead == 'D') ADVANCE(450);
      if (lookahead == 'T') ADVANCE(307);
      if (lookahead == 'V') ADVANCE(441);
      END_STATE();
    case 212:
      if (lookahead == 'D') ADVANCE(429);
      END_STATE();
    case 213:
      if (lookahead == 'D') ADVANCE(456);
      END_STATE();
    case 214:
      if (lookahead == 'D') ADVANCE(249);
      END_STATE();
    case 215:
      if (lookahead == 'D') ADVANCE(286);
      END_STATE();
    case 216:
      if (lookahead == 'D') ADVANCE(294);
      END_STATE();
    case 217:
      if (lookahead == 'E') ADVANCE(499);
      END_STATE();
    case 218:
      if (lookahead == 'E') ADVANCE(431);
      END_STATE();
    case 219:
      if (lookahead == 'E') ADVANCE(444);
      END_STATE();
    case 220:
      if (lookahead == 'E') ADVANCE(488);
      END_STATE();
    case 221:
      if (lookahead == 'E') ADVANCE(458);
      END_STATE();
    case 222:
      if (lookahead == 'E') ADVANCE(479);
      END_STATE();
    case 223:
      if (lookahead == 'E') ADVANCE(453);
      END_STATE();
    case 224:
      if (lookahead == 'E') ADVANCE(162);
      END_STATE();
    case 225:
      if (lookahead == 'E') ADVANCE(306);
      if (lookahead == 'O') ADVANCE(258);
      END_STATE();
    case 226:
      if (lookahead == 'E') ADVANCE(255);
      END_STATE();
    case 227:
      if (lookahead == 'E') ADVANCE(303);
      END_STATE();
    case 228:
      if (lookahead == 'E') ADVANCE(308);
      END_STATE();
    case 229:
      if (lookahead == 'E') ADVANCE(305);
      END_STATE();
    case 230:
      if (lookahead == 'E') ADVANCE(205);
      END_STATE();
    case 231:
      if (lookahead == 'F') ADVANCE(461);
      if (lookahead == 'M') ADVANCE(296);
      END_STATE();
    case 232:
      if (lookahead == 'F') ADVANCE(461);
      if (lookahead == 'M') ADVANCE(296);
      if (lookahead == 'N') ADVANCE(448);
      END_STATE();
    case 233:
      if (lookahead == 'F') ADVANCE(498);
      END_STATE();
    case 234:
      if (lookahead == 'F') ADVANCE(199);
      END_STATE();
    case 235:
      if (lookahead == 'F') ADVANCE(248);
      END_STATE();
    case 236:
      if (lookahead == 'G') ADVANCE(426);
      END_STATE();
    case 237:
      if (lookahead == 'G') ADVANCE(222);
      END_STATE();
    case 238:
      if (lookahead == 'H') ADVANCE(179);
      END_STATE();
    case 239:
      if (lookahead == 'H') ADVANCE(218);
      END_STATE();
    case 240:
      if (lookahead == 'I') ADVANCE(273);
      if (lookahead == 'O') ADVANCE(301);
      if (lookahead == 'R') ADVANCE(285);
      if (lookahead == 'U') ADVANCE(277);
      END_STATE();
    case 241:
      if (lookahead == 'I') ADVANCE(319);
      END_STATE();
    case 242:
      if (lookahead == 'I') ADVANCE(233);
      END_STATE();
    case 243:
      if (lookahead == 'I') ADVANCE(257);
      END_STATE();
    case 244:
      if (lookahead == 'I') ADVANCE(234);
      END_STATE();
    case 245:
      if (lookahead == 'I') ADVANCE(323);
      END_STATE();
    case 246:
      if (lookahead == 'I') ADVANCE(287);
      END_STATE();
    case 247:
      if (lookahead == 'I') ADVANCE(280);
      END_STATE();
    case 248:
      if (lookahead == 'I') ADVANCE(264);
      END_STATE();
    case 249:
      if (lookahead == 'I') ADVANCE(304);
      END_STATE();
    case 250:
      if (lookahead == 'I') ADVANCE(289);
      END_STATE();
    case 251:
      if (lookahead == 'J') ADVANCE(230);
      END_STATE();
    case 252:
      if (lookahead == 'K') ADVANCE(214);
      END_STATE();
    case 253:
      if (lookahead == 'K') ADVANCE(228);
      END_STATE();
    case 254:
      if (lookahead == 'K') ADVANCE(229);
      END_STATE();
    case 255:
      if (lookahead == 'L') ADVANCE(470);
      END_STATE();
    case 256:
      if (lookahead == 'L') ADVANCE(478);
      END_STATE();
    case 257:
      if (lookahead == 'L') ADVANCE(212);
      END_STATE();
    case 258:
      if (lookahead == 'L') ADVANCE(333);
      END_STATE();
    case 259:
      if (lookahead == 'L') ADVANCE(337);
      END_STATE();
    case 260:
      if (lookahead == 'L') ADVANCE(338);
      END_STATE();
    case 261:
      if (lookahead == 'L') ADVANCE(259);
      END_STATE();
    case 262:
      if (lookahead == 'L') ADVANCE(260);
      END_STATE();
    case 263:
      if (lookahead == 'L') ADVANCE(290);
      END_STATE();
    case 264:
      if (lookahead == 'L') ADVANCE(223);
      END_STATE();
    case 265:
      if (lookahead == 'L') ADVANCE(292);
      END_STATE();
    case 266:
      if (lookahead == 'L') ADVANCE(314);
      if (lookahead == 'N') ADVANCE(211);
      if (lookahead == 'X') ADVANCE(295);
      END_STATE();
    case 267:
      if (lookahead == 'M') ADVANCE(269);
      if (lookahead == 'P') ADVANCE(336);
      END_STATE();
    case 268:
      if (lookahead == 'M') ADVANCE(451);
      END_STATE();
    case 269:
      if (lookahead == 'M') ADVANCE(194);
      END_STATE();
    case 270:
      if (lookahead == 'M') ADVANCE(192);
      END_STATE();
    case 271:
      if (lookahead == 'M') ADVANCE(220);
      END_STATE();
    case 272:
      if (lookahead == 'N') ADVANCE(448);
      END_STATE();
    case 273:
      if (lookahead == 'N') ADVANCE(193);
      END_STATE();
    case 274:
      if (lookahead == 'N') ADVANCE(474);
      END_STATE();
    case 275:
      if (lookahead == 'N') ADVANCE(424);
      END_STATE();
    case 276:
      if (lookahead == 'N') ADVANCE(454);
      END_STATE();
    case 277:
      if (lookahead == 'N') ADVANCE(204);
      END_STATE();
    case 278:
      if (lookahead == 'N') ADVANCE(213);
      END_STATE();
    case 279:
      if (lookahead == 'N') ADVANCE(221);
      END_STATE();
    case 280:
      if (lookahead == 'N') ADVANCE(326);
      END_STATE();
    case 281:
      if (lookahead == 'O') ADVANCE(437);
      END_STATE();
    case 282:
      if (lookahead == 'O') ADVANCE(258);
      END_STATE();
    case 283:
      if (lookahead == 'O') ADVANCE(251);
      END_STATE();
    case 284:
      if (lookahead == 'O') ADVANCE(316);
      END_STATE();
    case 285:
      if (lookahead == 'O') ADVANCE(268);
      END_STATE();
    case 286:
      if (lookahead == 'O') ADVANCE(202);
      END_STATE();
    case 287:
      if (lookahead == 'O') ADVANCE(275);
      END_STATE();
    case 288:
      if (lookahead == 'O') ADVANCE(247);
      END_STATE();
    case 289:
      if (lookahead == 'O') ADVANCE(276);
      END_STATE();
    case 290:
      if (lookahead == 'O') ADVANCE(279);
      END_STATE();
    case 291:
      if (lookahead == 'O') ADVANCE(310);
      END_STATE();
    case 292:
      if (lookahead == 'O') ADVANCE(207);
      END_STATE();
    case 293:
      if (lookahead == 'O') ADVANCE(317);
      END_STATE();
    case 294:
      if (lookahead == 'O') ADVANCE(209);
      END_STATE();
    case 295:
      if (lookahead == 'P') ADVANCE(293);
      END_STATE();
    case 296:
      if (lookahead == 'P') ADVANCE(291);
      END_STATE();
    case 297:
      if (lookahead == 'P') ADVANCE(288);
      END_STATE();
    case 298:
      if (lookahead == 'R') ADVANCE(236);
      END_STATE();
    case 299:
      if (lookahead == 'R') ADVANCE(236);
      if (lookahead == 'S') ADVANCE(465);
      END_STATE();
    case 300:
      if (lookahead == 'R') ADVANCE(335);
      END_STATE();
    case 301:
      if (lookahead == 'R') ADVANCE(446);
      END_STATE();
    case 302:
      if (lookahead == 'R') ADVANCE(252);
      END_STATE();
    case 303:
      if (lookahead == 'R') ADVANCE(485);
      END_STATE();
    case 304:
      if (lookahead == 'R') ADVANCE(493);
      END_STATE();
    case 305:
      if (lookahead == 'R') ADVANCE(492);
      END_STATE();
    case 306:
      if (lookahead == 'R') ADVANCE(315);
      END_STATE();
    case 307:
      if (lookahead == 'R') ADVANCE(339);
      END_STATE();
    case 308:
      if (lookahead == 'R') ADVANCE(235);
      END_STATE();
    case 309:
      if (lookahead == 'R') ADVANCE(283);
      END_STATE();
    case 310:
      if (lookahead == 'R') ADVANCE(324);
      END_STATE();
    case 311:
      if (lookahead == 'R') ADVANCE(329);
      END_STATE();
    case 312:
      if (lookahead == 'S') ADVANCE(465);
      END_STATE();
    case 313:
      if (lookahead == 'S') ADVANCE(227);
      END_STATE();
    case 314:
      if (lookahead == 'S') ADVANCE(217);
      END_STATE();
    case 315:
      if (lookahead == 'S') ADVANCE(246);
      END_STATE();
    case 316:
      if (lookahead == 'S') ADVANCE(322);
      END_STATE();
    case 317:
      if (lookahead == 'S') ADVANCE(219);
      END_STATE();
    case 318:
      if (lookahead == 'S') ADVANCE(178);
      END_STATE();
    case 319:
      if (lookahead == 'T') ADVANCE(176);
      END_STATE();
    case 320:
      if (lookahead == 'T') ADVANCE(467);
      END_STATE();
    case 321:
      if (lookahead == 'T') ADVANCE(480);
      END_STATE();
    case 322:
      if (lookahead == 'T') ADVANCE(459);
      END_STATE();
    case 323:
      if (lookahead == 'T') ADVANCE(490);
      END_STATE();
    case 324:
      if (lookahead == 'T') ADVANCE(463);
      END_STATE();
    case 325:
      if (lookahead == 'T') ADVANCE(420);
      END_STATE();
    case 326:
      if (lookahead == 'T') ADVANCE(439);
      END_STATE();
    case 327:
      if (lookahead == 'T') ADVANCE(477);
      END_STATE();
    case 328:
      if (lookahead == 'T') ADVANCE(238);
      END_STATE();
    case 329:
      if (lookahead == 'T') ADVANCE(244);
      END_STATE();
    case 330:
      if (lookahead == 'T') ADVANCE(250);
      END_STATE();
    case 331:
      if (lookahead == 'U') ADVANCE(243);
      END_STATE();
    case 332:
      if (lookahead == 'U') ADVANCE(274);
      END_STATE();
    case 333:
      if (lookahead == 'U') ADVANCE(271);
      END_STATE();
    case 334:
      if (lookahead == 'V') ADVANCE(224);
      END_STATE();
    case 335:
      if (lookahead == 'Y') ADVANCE(482);
      END_STATE();
    case 336:
      if (lookahead == 'Y') ADVANCE(435);
      END_STATE();
    case 337:
      if (lookahead == 'Y') ADVANCE(484);
      END_STATE();
    case 338:
      if (lookahead == 'Y') ADVANCE(472);
      END_STATE();
    case 339:
      if (lookahead == 'Y') ADVANCE(297);
      END_STATE();
    case 340:
      if (lookahead == '_') ADVANCE(395);
      END_STATE();
    case 341:
      if (lookahead == 'a') ADVANCE(372);
      END_STATE();
    case 342:
      if (lookahead == 'a') ADVANCE(382);
      END_STATE();
    case 343:
      if (lookahead == 'a') ADVANCE(394);
      END_STATE();
    case 344:
      if (lookahead == 'a') ADVANCE(384);
      END_STATE();
    case 345:
      if (lookahead == 'a') ADVANCE(399);
      END_STATE();
    case 346:
      if (lookahead == 'a') ADVANCE(400);
      END_STATE();
    case 347:
      if (lookahead == 'a') ADVANCE(401);
      END_STATE();
    case 348:
      if (lookahead == 'a') ADVANCE(373);
      END_STATE();
    case 349:
      if (lookahead == 'a') ADVANCE(385);
      END_STATE();
    case 350:
      if (lookahead == 'a') ADVANCE(403);
      END_STATE();
    case 351:
      if (lookahead == 'b') ADVANCE(361);
      if (lookahead == 'u') ADVANCE(402);
      END_STATE();
    case 352:
      if (lookahead == 'c') ADVANCE(392);
      END_STATE();
    case 353:
      if (lookahead == 'd') ADVANCE(360);
      END_STATE();
    case 354:
      if (lookahead == 'd') ADVANCE(177);
      END_STATE();
    case 355:
      if (lookahead == 'd') ADVANCE(182);
      END_STATE();
    case 356:
      if (lookahead == 'e') ADVANCE(600);
      END_STATE();
    case 357:
      if (lookahead == 'e') ADVANCE(355);
      END_STATE();
    case 358:
      if (lookahead == 'e') ADVANCE(364);
      END_STATE();
    case 359:
      if (lookahead == 'e') ADVANCE(405);
      END_STATE();
    case 360:
      if (lookahead == 'e') ADVANCE(164);
      END_STATE();
    case 361:
      if (lookahead == 'e') ADVANCE(170);
      END_STATE();
    case 362:
      if (lookahead == 'e') ADVANCE(166);
      END_STATE();
    case 363:
      if (lookahead == 'e') ADVANCE(168);
      END_STATE();
    case 364:
      if (lookahead == 'f') ADVANCE(553);
      END_STATE();
    case 365:
      if (lookahead == 'f') ADVANCE(387);
      END_STATE();
    case 366:
      if (lookahead == 'g') ADVANCE(359);
      END_STATE();
    case 367:
      if (lookahead == 'h') ADVANCE(363);
      END_STATE();
    case 368:
      if (lookahead == 'i') ADVANCE(389);
      END_STATE();
    case 369:
      if (lookahead == 'i') ADVANCE(383);
      END_STATE();
    case 370:
      if (lookahead == 'i') ADVANCE(346);
      END_STATE();
    case 371:
      if (lookahead == 'i') ADVANCE(347);
      END_STATE();
    case 372:
      if (lookahead == 'l') ADVANCE(370);
      END_STATE();
    case 373:
      if (lookahead == 'l') ADVANCE(371);
      END_STATE();
    case 374:
      if (lookahead == 'm') ADVANCE(411);
      END_STATE();
    case 375:
      if (lookahead == 'm') ADVANCE(374);
      END_STATE();
    case 376:
      if (lookahead == 'm') ADVANCE(377);
      END_STATE();
    case 377:
      if (lookahead == 'm') ADVANCE(344);
      END_STATE();
    case 378:
      if (lookahead == 'n') ADVANCE(386);
      END_STATE();
    case 379:
      if (lookahead == 'n') ADVANCE(397);
      END_STATE();
    case 380:
      if (lookahead == 'n') ADVANCE(356);
      END_STATE();
    case 381:
      if (lookahead == 'n') ADVANCE(390);
      END_STATE();
    case 382:
      if (lookahead == 'n') ADVANCE(175);
      END_STATE();
    case 383:
      if (lookahead == 'n') ADVANCE(171);
      END_STATE();
    case 384:
      if (lookahead == 'n') ADVANCE(354);
      END_STATE();
    case 385:
      if (lookahead == 'n') ADVANCE(180);
      END_STATE();
    case 386:
      if (lookahead == 'o') ADVANCE(353);
      END_STATE();
    case 387:
      if (lookahead == 'o') ADVANCE(396);
      END_STATE();
    case 388:
      if (lookahead == 'o') ADVANCE(393);
      END_STATE();
    case 389:
      if (lookahead == 'o') ADVANCE(379);
      END_STATE();
    case 390:
      if (lookahead == 'o') ADVANCE(380);
      END_STATE();
    case 391:
      if (lookahead == 'o') ADVANCE(165);
      END_STATE();
    case 392:
      if (lookahead == 'o') ADVANCE(376);
      END_STATE();
    case 393:
      if (lookahead == 'p') ADVANCE(407);
      END_STATE();
    case 394:
      if (lookahead == 'r') ADVANCE(366);
      END_STATE();
    case 395:
      if (lookahead == 'r') ADVANCE(358);
      END_STATE();
    case 396:
      if (lookahead == 'r') ADVANCE(174);
      END_STATE();
    case 397:
      if (lookahead == 's') ADVANCE(556);
      END_STATE();
    case 398:
      if (lookahead == 's') ADVANCE(357);
      END_STATE();
    case 399:
      if (lookahead == 's') ADVANCE(172);
      END_STATE();
    case 400:
      if (lookahead == 's') ADVANCE(173);
      END_STATE();
    case 401:
      if (lookahead == 's') ADVANCE(167);
      END_STATE();
    case 402:
      if (lookahead == 's') ADVANCE(362);
      END_STATE();
    case 403:
      if (lookahead == 's') ADVANCE(181);
      END_STATE();
    case 404:
      if (lookahead == 't') ADVANCE(367);
      END_STATE();
    case 405:
      if (lookahead == 't') ADVANCE(340);
      END_STATE();
    case 406:
      if (lookahead == 't') ADVANCE(391);
      END_STATE();
    case 407:
      if (lookahead == 't') ADVANCE(368);
      END_STATE();
    case 408:
      if (lookahead == 't') ADVANCE(343);
      END_STATE();
    case 409:
      if (lookahead == 'u') ADVANCE(375);
      END_STATE();
    case 410:
      if (lookahead == 'u') ADVANCE(398);
      END_STATE();
    case 411:
      if (lookahead == 'y') ADVANCE(163);
      END_STATE();
    case 412:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(572);
      END_STATE();
    case 413:
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(589);
      END_STATE();
    case 414:
      if (eof) ADVANCE(419);
      ADVANCE_MAP(
        0, 1050,
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 901,
        '$', 557,
        '\'', 564,
        '(', 570,
        ')', 1031,
        '+', 558,
        ',', 526,
        '-', 531,
        '.', 528,
        '/', 525,
        ':', 423,
        '=', 443,
        '@', 527,
        'A', 299,
        'B', 331,
        'C', 189,
        'D', 281,
        'E', 266,
        'F', 240,
        'G', 241,
        'H', 284,
        'I', 232,
        'L', 190,
        'P', 309,
        'R', 332,
        'S', 191,
        'T', 300,
        'U', 313,
        'V', 225,
        'W', 196,
        '[', 569,
        '\\', 154,
        ']', 522,
        'd', 409,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(414);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(555);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          (lookahead < '@' || ']' < lookahead) &&
          lookahead != '_' &&
          (lookahead < 'a' || '{' < lookahead)) ADVANCE(902);
      END_STATE();
    case 415:
      if (eof) ADVANCE(419);
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 901,
        '$', 557,
        '\'', 1024,
        '(', 570,
        ')', 520,
        '+', 558,
        ',', 526,
        '-', 533,
        '.', 528,
        '/', 525,
        ':', 423,
        '=', 428,
        '@', 527,
        '[', 521,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(416);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1008);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(902);
      END_STATE();
    case 416:
      if (eof) ADVANCE(419);
      ADVANCE_MAP(
        '\n', 1041,
        '\f', 1045,
        '\r', 152,
        '"', 559,
        '#', 901,
        '$', 557,
        '(', 570,
        ')', 520,
        '+', 558,
        ',', 526,
        '-', 533,
        '.', 528,
        '/', 525,
        ':', 423,
        '=', 428,
        '@', 527,
        '[', 521,
        '\\', 154,
        ']', 522,
        '{', 523,
        '}', 524,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(416);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1008);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          (lookahead < '\'' || ')' < lookahead)) ADVANCE(902);
      END_STATE();
    case 417:
      if (eof) ADVANCE(419);
      ADVANCE_MAP(
        '\n', 1042,
        0x0b, 497,
        '\f', 1046,
        '\r', 496,
        '#', 153,
        'A', 973,
        'B', 999,
        'C', 907,
        'D', 959,
        'E', 952,
        'F', 964,
        'G', 934,
        'H', 962,
        'I', 930,
        'L', 908,
        'P', 981,
        'R', 1000,
        'S', 909,
        'T', 974,
        'U', 983,
        'V', 927,
        'W', 912,
        '\\', 155,
        '\t', 495,
        ' ', 495,
      );
      if (('J' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 418:
      if (eof) ADVANCE(419);
      ADVANCE_MAP(
        '\n', 1042,
        0x0b, 497,
        '\f', 1046,
        '\r', 496,
        '#', 153,
        'A', 973,
        'B', 999,
        'C', 907,
        'D', 959,
        'E', 952,
        'F', 964,
        'G', 934,
        'H', 962,
        'I', 930,
        'L', 908,
        'P', 981,
        'R', 1000,
        'S', 909,
        'T', 974,
        'U', 983,
        'V', 960,
        'W', 912,
        '\\', 155,
        '\t', 495,
        ' ', 495,
      );
      if (('J' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 419:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 420:
      ACCEPT_TOKEN(anon_sym_PROJECT);
      END_STATE();
    case 421:
      ACCEPT_TOKEN(anon_sym_PROJECT);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 422:
      ACCEPT_TOKEN(anon_sym_SLASH);
      END_STATE();
    case 423:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 424:
      ACCEPT_TOKEN(anon_sym_VERSION);
      END_STATE();
    case 425:
      ACCEPT_TOKEN(anon_sym_VERSION);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 426:
      ACCEPT_TOKEN(anon_sym_ARG);
      END_STATE();
    case 427:
      ACCEPT_TOKEN(anon_sym_ARG);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 428:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 429:
      ACCEPT_TOKEN(anon_sym_BUILD);
      END_STATE();
    case 430:
      ACCEPT_TOKEN(anon_sym_BUILD);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 431:
      ACCEPT_TOKEN(anon_sym_CACHE);
      END_STATE();
    case 432:
      ACCEPT_TOKEN(anon_sym_CACHE);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 433:
      ACCEPT_TOKEN(anon_sym_CMD);
      END_STATE();
    case 434:
      ACCEPT_TOKEN(anon_sym_CMD);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 435:
      ACCEPT_TOKEN(anon_sym_COPY);
      END_STATE();
    case 436:
      ACCEPT_TOKEN(anon_sym_COPY);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 437:
      ACCEPT_TOKEN(anon_sym_DO);
      END_STATE();
    case 438:
      ACCEPT_TOKEN(anon_sym_DO);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 439:
      ACCEPT_TOKEN(anon_sym_ENTRYPOINT);
      END_STATE();
    case 440:
      ACCEPT_TOKEN(anon_sym_ENTRYPOINT);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 441:
      ACCEPT_TOKEN(anon_sym_ENV);
      END_STATE();
    case 442:
      ACCEPT_TOKEN(anon_sym_ENV);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 443:
      ACCEPT_TOKEN(anon_sym_EQ2);
      END_STATE();
    case 444:
      ACCEPT_TOKEN(anon_sym_EXPOSE);
      END_STATE();
    case 445:
      ACCEPT_TOKEN(anon_sym_EXPOSE);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 446:
      ACCEPT_TOKEN(anon_sym_FOR);
      END_STATE();
    case 447:
      ACCEPT_TOKEN(anon_sym_FOR);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 448:
      ACCEPT_TOKEN(anon_sym_IN);
      END_STATE();
    case 449:
      ACCEPT_TOKEN(anon_sym_IN);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1015);
      END_STATE();
    case 450:
      ACCEPT_TOKEN(anon_sym_END);
      END_STATE();
    case 451:
      ACCEPT_TOKEN(anon_sym_FROM);
      if (lookahead == ' ') ADVANCE(215);
      END_STATE();
    case 452:
      ACCEPT_TOKEN(anon_sym_FROM);
      if (lookahead == ' ') ADVANCE(215);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 453:
      ACCEPT_TOKEN(anon_sym_FROMDOCKERFILE);
      END_STATE();
    case 454:
      ACCEPT_TOKEN(anon_sym_FUNCTION);
      END_STATE();
    case 455:
      ACCEPT_TOKEN(anon_sym_FUNCTION);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 456:
      ACCEPT_TOKEN(anon_sym_COMMAND);
      END_STATE();
    case 457:
      ACCEPT_TOKEN(anon_sym_COMMAND);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 458:
      ACCEPT_TOKEN(anon_sym_GITCLONE);
      END_STATE();
    case 459:
      ACCEPT_TOKEN(anon_sym_HOST);
      END_STATE();
    case 460:
      ACCEPT_TOKEN(anon_sym_HOST);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 461:
      ACCEPT_TOKEN(anon_sym_IF);
      END_STATE();
    case 462:
      ACCEPT_TOKEN(anon_sym_IF);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 463:
      ACCEPT_TOKEN(anon_sym_IMPORT);
      END_STATE();
    case 464:
      ACCEPT_TOKEN(anon_sym_IMPORT);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 465:
      ACCEPT_TOKEN(anon_sym_AS);
      END_STATE();
    case 466:
      ACCEPT_TOKEN(anon_sym_AS);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1015);
      END_STATE();
    case 467:
      ACCEPT_TOKEN(anon_sym_LET);
      END_STATE();
    case 468:
      ACCEPT_TOKEN(anon_sym_LET);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 469:
      ACCEPT_TOKEN(anon_sym_EQ3);
      END_STATE();
    case 470:
      ACCEPT_TOKEN(anon_sym_LABEL);
      END_STATE();
    case 471:
      ACCEPT_TOKEN(anon_sym_LABEL);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 472:
      ACCEPT_TOKEN(anon_sym_LOCALLY);
      END_STATE();
    case 473:
      ACCEPT_TOKEN(anon_sym_LOCALLY);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 474:
      ACCEPT_TOKEN(anon_sym_RUN);
      END_STATE();
    case 475:
      ACCEPT_TOKEN(anon_sym_RUN);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 476:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      END_STATE();
    case 477:
      ACCEPT_TOKEN(anon_sym_SAVEARTIFACT);
      END_STATE();
    case 478:
      ACCEPT_TOKEN(anon_sym_ASLOCAL);
      END_STATE();
    case 479:
      ACCEPT_TOKEN(anon_sym_SAVEIMAGE);
      END_STATE();
    case 480:
      ACCEPT_TOKEN(anon_sym_SET);
      END_STATE();
    case 481:
      ACCEPT_TOKEN(anon_sym_SET);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 482:
      ACCEPT_TOKEN(anon_sym_TRY);
      END_STATE();
    case 483:
      ACCEPT_TOKEN(anon_sym_TRY);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 484:
      ACCEPT_TOKEN(anon_sym_FINALLY);
      END_STATE();
    case 485:
      ACCEPT_TOKEN(anon_sym_USER);
      END_STATE();
    case 486:
      ACCEPT_TOKEN(anon_sym_USER);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 487:
      ACCEPT_TOKEN(anon_sym_COLON2);
      END_STATE();
    case 488:
      ACCEPT_TOKEN(anon_sym_VOLUME);
      END_STATE();
    case 489:
      ACCEPT_TOKEN(anon_sym_VOLUME);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 490:
      ACCEPT_TOKEN(anon_sym_WAIT);
      END_STATE();
    case 491:
      ACCEPT_TOKEN(anon_sym_WAIT);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 492:
      ACCEPT_TOKEN(anon_sym_WITHDOCKER);
      END_STATE();
    case 493:
      ACCEPT_TOKEN(anon_sym_WORKDIR);
      END_STATE();
    case 494:
      ACCEPT_TOKEN(anon_sym_WORKDIR);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 495:
      ACCEPT_TOKEN(aux_sym_block_token1);
      ADVANCE_MAP(
        '\n', 1042,
        0x0b, 497,
        '\f', 1046,
        '\r', 496,
        '#', 153,
        '\\', 155,
        '\t', 495,
        ' ', 495,
      );
      END_STATE();
    case 496:
      ACCEPT_TOKEN(aux_sym_block_token1);
      if (lookahead == '\n') ADVANCE(1044);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(497);
      END_STATE();
    case 497:
      ACCEPT_TOKEN(aux_sym_block_token1);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(497);
      END_STATE();
    case 498:
      ACCEPT_TOKEN(anon_sym_ELSEIF);
      END_STATE();
    case 499:
      ACCEPT_TOKEN(anon_sym_ELSE);
      if (lookahead == ' ') ADVANCE(242);
      END_STATE();
    case 500:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 501:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 502:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(577);
      END_STATE();
    case 503:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(577);
      if (lookahead == 'f') ADVANCE(586);
      END_STATE();
    case 504:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(618);
      END_STATE();
    case 505:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(638);
      END_STATE();
    case 506:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(639);
      if (lookahead == 'f') ADVANCE(586);
      END_STATE();
    case 507:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(635);
      END_STATE();
    case 508:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(778);
      END_STATE();
    case 509:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(718);
      END_STATE();
    case 510:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(674);
      END_STATE();
    case 511:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(668);
      END_STATE();
    case 512:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(641);
      END_STATE();
    case 513:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(661);
      END_STATE();
    case 514:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(640);
      END_STATE();
    case 515:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(725);
      END_STATE();
    case 516:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(779);
      END_STATE();
    case 517:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(642);
      END_STATE();
    case 518:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(643);
      END_STATE();
    case 519:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 520:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 521:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 522:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 523:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 524:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 525:
      ACCEPT_TOKEN(anon_sym_SLASH2);
      END_STATE();
    case 526:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 527:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 528:
      ACCEPT_TOKEN(anon_sym_DOT2);
      END_STATE();
    case 529:
      ACCEPT_TOKEN(anon_sym_DASH2);
      END_STATE();
    case 530:
      ACCEPT_TOKEN(anon_sym_DASH2);
      if (lookahead == '-') ADVANCE(577);
      END_STATE();
    case 531:
      ACCEPT_TOKEN(anon_sym_DASH2);
      if (lookahead == '-') ADVANCE(577);
      if (lookahead == 'f') ADVANCE(586);
      END_STATE();
    case 532:
      ACCEPT_TOKEN(anon_sym_DASH2);
      if (lookahead == '-') ADVANCE(618);
      END_STATE();
    case 533:
      ACCEPT_TOKEN(anon_sym_DASH2);
      if (lookahead == '-') ADVANCE(638);
      END_STATE();
    case 534:
      ACCEPT_TOKEN(anon_sym_DASH2);
      if (lookahead == '-') ADVANCE(639);
      if (lookahead == 'f') ADVANCE(586);
      END_STATE();
    case 535:
      ACCEPT_TOKEN(anon_sym_DASH2);
      if (lookahead == '-') ADVANCE(635);
      END_STATE();
    case 536:
      ACCEPT_TOKEN(anon_sym_DASH2);
      if (lookahead == '-') ADVANCE(778);
      END_STATE();
    case 537:
      ACCEPT_TOKEN(anon_sym_DASH2);
      if (lookahead == '-') ADVANCE(718);
      END_STATE();
    case 538:
      ACCEPT_TOKEN(anon_sym_DASH2);
      if (lookahead == '-') ADVANCE(674);
      END_STATE();
    case 539:
      ACCEPT_TOKEN(anon_sym_DASH2);
      if (lookahead == '-') ADVANCE(668);
      END_STATE();
    case 540:
      ACCEPT_TOKEN(anon_sym_DASH2);
      if (lookahead == '-') ADVANCE(641);
      END_STATE();
    case 541:
      ACCEPT_TOKEN(anon_sym_DASH2);
      if (lookahead == '-') ADVANCE(661);
      END_STATE();
    case 542:
      ACCEPT_TOKEN(anon_sym_DASH2);
      if (lookahead == '-') ADVANCE(642);
      END_STATE();
    case 543:
      ACCEPT_TOKEN(anon_sym_DASH2);
      if (lookahead == '-') ADVANCE(643);
      END_STATE();
    case 544:
      ACCEPT_TOKEN(anon_sym_DASH2);
      if (lookahead == '-') ADVANCE(169);
      END_STATE();
    case 545:
      ACCEPT_TOKEN(anon_sym_LPAREN2);
      END_STATE();
    case 546:
      ACCEPT_TOKEN(anon_sym_RPAREN2);
      END_STATE();
    case 547:
      ACCEPT_TOKEN(anon_sym_LBRACK2);
      END_STATE();
    case 548:
      ACCEPT_TOKEN(anon_sym_RBRACK2);
      END_STATE();
    case 549:
      ACCEPT_TOKEN(anon_sym_LBRACE2);
      END_STATE();
    case 550:
      ACCEPT_TOKEN(anon_sym_RBRACE2);
      END_STATE();
    case 551:
      ACCEPT_TOKEN(anon_sym_COMMA2);
      END_STATE();
    case 552:
      ACCEPT_TOKEN(anon_sym_AT2);
      END_STATE();
    case 553:
      ACCEPT_TOKEN(sym_function_ref);
      END_STATE();
    case 554:
      ACCEPT_TOKEN(anon_sym_SPACE);
      if (lookahead == '#') ADVANCE(153);
      if (lookahead == '\\') ADVANCE(155);
      END_STATE();
    case 555:
      ACCEPT_TOKEN(sym_number);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(555);
      END_STATE();
    case 556:
      ACCEPT_TOKEN(sym_options);
      END_STATE();
    case 557:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      END_STATE();
    case 558:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 559:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 560:
      ACCEPT_TOKEN(aux_sym_shell_fragment_token1);
      if (lookahead == '\n') ADVANCE(563);
      if (lookahead == '\f') ADVANCE(563);
      if (lookahead == '\r') ADVANCE(562);
      if (lookahead == '#') ADVANCE(561);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(560);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '#' &&
          lookahead != '\\') ADVANCE(563);
      END_STATE();
    case 561:
      ACCEPT_TOKEN(aux_sym_shell_fragment_token1);
      if (lookahead == '\n') ADVANCE(563);
      if (lookahead == '\f') ADVANCE(561);
      if (lookahead == '\r') ADVANCE(561);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(561);
      END_STATE();
    case 562:
      ACCEPT_TOKEN(aux_sym_shell_fragment_token1);
      if (lookahead == '\n') ADVANCE(563);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(563);
      END_STATE();
    case 563:
      ACCEPT_TOKEN(aux_sym_shell_fragment_token1);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(563);
      END_STATE();
    case 564:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 565:
      ACCEPT_TOKEN(aux_sym_shell_fragment_token2);
      if (lookahead == '\n') ADVANCE(568);
      if (lookahead == '\f') ADVANCE(568);
      if (lookahead == '\r') ADVANCE(567);
      if (lookahead == '#') ADVANCE(566);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(565);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(568);
      END_STATE();
    case 566:
      ACCEPT_TOKEN(aux_sym_shell_fragment_token2);
      if (lookahead == '\n') ADVANCE(568);
      if (lookahead == '\f') ADVANCE(566);
      if (lookahead == '\r') ADVANCE(566);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(566);
      END_STATE();
    case 567:
      ACCEPT_TOKEN(aux_sym_shell_fragment_token2);
      if (lookahead == '\n') ADVANCE(568);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(568);
      END_STATE();
    case 568:
      ACCEPT_TOKEN(aux_sym_shell_fragment_token2);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(568);
      END_STATE();
    case 569:
      ACCEPT_TOKEN(anon_sym_LBRACK3);
      END_STATE();
    case 570:
      ACCEPT_TOKEN(anon_sym_LPAREN3);
      END_STATE();
    case 571:
      ACCEPT_TOKEN(anon_sym_RPAREN3);
      END_STATE();
    case 572:
      ACCEPT_TOKEN(sym_version_major_minor);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(572);
      END_STATE();
    case 573:
      ACCEPT_TOKEN(sym_allow_privileged);
      END_STATE();
    case 574:
      ACCEPT_TOKEN(sym_auto_skip);
      END_STATE();
    case 575:
      ACCEPT_TOKEN(sym_aws);
      END_STATE();
    case 576:
      ACCEPT_TOKEN(anon_sym_DASH_DASHbranch);
      END_STATE();
    case 577:
      ACCEPT_TOKEN(anon_sym_DASH_DASH2);
      END_STATE();
    case 578:
      ACCEPT_TOKEN(anon_sym_DASH_DASHbuild_DASHarg);
      END_STATE();
    case 579:
      ACCEPT_TOKEN(anon_sym_DASH_DASHcache_DASHid);
      END_STATE();
    case 580:
      ACCEPT_TOKEN(anon_sym_DASH_DASHcache_DASHfrom);
      END_STATE();
    case 581:
      ACCEPT_TOKEN(sym_cache_hint);
      END_STATE();
    case 582:
      ACCEPT_TOKEN(anon_sym_DASH_DASHchmod);
      END_STATE();
    case 583:
      ACCEPT_TOKEN(anon_sym_DASH_DASHchown);
      END_STATE();
    case 584:
      ACCEPT_TOKEN(anon_sym_DASH_DASHcompose);
      END_STATE();
    case 585:
      ACCEPT_TOKEN(sym_dir);
      END_STATE();
    case 586:
      ACCEPT_TOKEN(anon_sym_DASHf);
      END_STATE();
    case 587:
      ACCEPT_TOKEN(anon_sym_DASH_DASHtarget);
      END_STATE();
    case 588:
      ACCEPT_TOKEN(sym_entrypoint);
      END_STATE();
    case 589:
      ACCEPT_TOKEN(sym_feature_flag);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(589);
      END_STATE();
    case 590:
      ACCEPT_TOKEN(sym_force);
      END_STATE();
    case 591:
      ACCEPT_TOKEN(sym_global);
      END_STATE();
    case 592:
      ACCEPT_TOKEN(anon_sym_DASH_DASHid);
      END_STATE();
    case 593:
      ACCEPT_TOKEN(sym_if_exists);
      END_STATE();
    case 594:
      ACCEPT_TOKEN(anon_sym_DASH_DASHinteractive);
      if (lookahead == '-') ADVANCE(758);
      END_STATE();
    case 595:
      ACCEPT_TOKEN(anon_sym_DASH_DASHinteractive_DASHkeep);
      END_STATE();
    case 596:
      ACCEPT_TOKEN(sym_keep_own);
      END_STATE();
    case 597:
      ACCEPT_TOKEN(sym_keep_ts);
      END_STATE();
    case 598:
      ACCEPT_TOKEN(anon_sym_DASH_DASHload);
      END_STATE();
    case 599:
      ACCEPT_TOKEN(anon_sym_DASH_DASHmount);
      END_STATE();
    case 600:
      ACCEPT_TOKEN(sym_network_none);
      END_STATE();
    case 601:
      ACCEPT_TOKEN(sym_no_cache);
      END_STATE();
    case 602:
      ACCEPT_TOKEN(anon_sym_DASH_DASHoidc);
      END_STATE();
    case 603:
      ACCEPT_TOKEN(sym_pass_args);
      END_STATE();
    case 604:
      ACCEPT_TOKEN(sym_persist);
      END_STATE();
    case 605:
      ACCEPT_TOKEN(anon_sym_DASH_DASHplatform);
      END_STATE();
    case 606:
      ACCEPT_TOKEN(sym_privileged);
      END_STATE();
    case 607:
      ACCEPT_TOKEN(anon_sym_DASH_DASHpull);
      END_STATE();
    case 608:
      ACCEPT_TOKEN(sym_push);
      END_STATE();
    case 609:
      ACCEPT_TOKEN(sym_raw_output);
      END_STATE();
    case 610:
      ACCEPT_TOKEN(sym_required);
      END_STATE();
    case 611:
      ACCEPT_TOKEN(anon_sym_DASH_DASHsecret);
      END_STATE();
    case 612:
      ACCEPT_TOKEN(anon_sym_EQ4);
      END_STATE();
    case 613:
      ACCEPT_TOKEN(anon_sym_DASH_DASHsep);
      END_STATE();
    case 614:
      ACCEPT_TOKEN(anon_sym_DASH_DASHservice);
      END_STATE();
    case 615:
      ACCEPT_TOKEN(anon_sym_DASH_DASHsharing);
      END_STATE();
    case 616:
      ACCEPT_TOKEN(sym_ssh);
      END_STATE();
    case 617:
      ACCEPT_TOKEN(sym_symlink_no_follow);
      END_STATE();
    case 618:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      ADVANCE_MAP(
        ' ', 476,
        'a', 888,
        'e', 786,
        'i', 789,
        'm', 797,
        'n', 695,
        'o', 737,
        'p', 828,
        'r', 637,
        's', 684,
      );
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 619:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == '-') ADVANCE(805);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 620:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == '-') ADVANCE(716);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 621:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == '-') ADVANCE(663);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 622:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == '-') ADVANCE(715);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 623:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == '-') ADVANCE(648);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 624:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == '-') ADVANCE(793);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 625:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == '-') ADVANCE(820);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 626:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == '-') ADVANCE(770);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 627:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == '-') ADVANCE(852);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 628:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == '-') ADVANCE(688);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 629:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == '-') ADVANCE(713);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 630:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == '-') ADVANCE(872);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 631:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == '-') ADVANCE(799);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 632:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == '-') ADVANCE(747);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 633:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == '-') ADVANCE(651);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 634:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == '=') ADVANCE(381);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 635:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'a') ADVANCE(767);
      if (lookahead == 'b') ADVANCE(879);
      if (lookahead == 'p') ADVANCE(644);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('c' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 636:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'a') ADVANCE(660);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 637:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'a') ADVANCE(892);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 638:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      ADVANCE_MAP(
        'a', 768,
        'b', 879,
        'c', 728,
        'd', 744,
        'i', 714,
        'k', 704,
        'p', 644,
        's', 897,
      );
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('e' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 639:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'a') ADVANCE(768);
      if (lookahead == 'b') ADVANCE(879);
      if (lookahead == 'p') ADVANCE(763);
      if (lookahead == 't') ADVANCE(653);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('c' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 640:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'a') ADVANCE(768);
      if (lookahead == 'c') ADVANCE(658);
      if (lookahead == 'l') ADVANCE(809);
      if (lookahead == 'p') ADVANCE(762);
      if (lookahead == 's') ADVANCE(711);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 641:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'a') ADVANCE(768);
      if (lookahead == 'p') ADVANCE(644);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 642:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'a') ADVANCE(768);
      if (lookahead == 'p') ADVANCE(645);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 643:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'a') ADVANCE(768);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 644:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'a') ADVANCE(851);
      if (lookahead == 'l') ADVANCE(652);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 645:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'a') ADVANCE(851);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 646:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'a') ADVANCE(666);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 647:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'a') ADVANCE(667);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 648:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'a') ADVANCE(831);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 649:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'a') ADVANCE(794);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 650:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'a') ADVANCE(679);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 651:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'a') ADVANCE(833);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 652:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'a') ADVANCE(868);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 653:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'a') ADVANCE(843);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 654:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'a') ADVANCE(761);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 655:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'a') ADVANCE(839);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 656:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'a') ADVANCE(838);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 657:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'a') ADVANCE(672);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 658:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'a') ADVANCE(673);
      if (lookahead == 'o') ADVANCE(785);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 659:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'b') ADVANCE(654);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 660:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'b') ADVANCE(705);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 661:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'b') ADVANCE(835);
      if (lookahead == 'k') ADVANCE(710);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 662:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'c') ADVANCE(602);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 663:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'c') ADVANCE(646);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 664:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'c') ADVANCE(830);
      if (lookahead == 'p') ADVANCE(613);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 665:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'c') ADVANCE(830);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 666:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'c') ADVANCE(730);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 667:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'c') ADVANCE(870);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 668:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'c') ADVANCE(731);
      if (lookahead == 'i') ADVANCE(678);
      if (lookahead == 'p') ADVANCE(709);
      if (lookahead == 's') ADVANCE(736);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 669:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'c') ADVANCE(729);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 670:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'c') ADVANCE(689);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 671:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'c') ADVANCE(691);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 672:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'c') ADVANCE(733);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 673:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'c') ADVANCE(734);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 674:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'c') ADVANCE(657);
      if (lookahead == 'p') ADVANCE(877);
      if (lookahead == 'w') ADVANCE(748);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 675:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'd') ADVANCE(606);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 676:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'd') ADVANCE(582);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 677:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'd') ADVANCE(573);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 678:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'd') ADVANCE(592);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 679:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'd') ADVANCE(598);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 680:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'd') ADVANCE(579);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 681:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'd') ADVANCE(610);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 682:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'd') ADVANCE(662);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 683:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'd') ADVANCE(633);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 684:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'e') ADVANCE(665);
      if (lookahead == 's') ADVANCE(726);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 685:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'e') ADVANCE(721);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 686:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'e') ADVANCE(601);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 687:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'e') ADVANCE(594);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 688:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'e') ADVANCE(895);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 689:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'e') ADVANCE(590);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 690:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'e') ADVANCE(584);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 691:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'e') ADVANCE(614);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 692:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'e') ADVANCE(664);
      if (lookahead == 's') ADVANCE(726);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 693:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'e') ADVANCE(824);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 694:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'e') ADVANCE(675);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 695:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'e') ADVANCE(869);
      if (lookahead == 'o') ADVANCE(621);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 696:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'e') ADVANCE(842);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 697:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'e') ADVANCE(816);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 698:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'e') ADVANCE(819);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 699:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'e') ADVANCE(861);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 700:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'e') ADVANCE(677);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 701:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'e') ADVANCE(822);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 702:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'e') ADVANCE(697);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 703:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'e') ADVANCE(681);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 704:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'e') ADVANCE(698);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 705:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'e') ADVANCE(773);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 706:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'e') ADVANCE(620);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 707:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'e') ADVANCE(864);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 708:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'e') ADVANCE(632);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 709:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'e') ADVANCE(837);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 710:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'e') ADVANCE(701);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 711:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'e') ADVANCE(841);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 712:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'e') ADVANCE(723);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 713:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'e') ADVANCE(655);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 714:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'f') ADVANCE(628);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 715:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'f') ADVANCE(815);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 716:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'f') ADVANCE(836);
      if (lookahead == 'h') ADVANCE(753);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 717:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'f') ADVANCE(807);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 718:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'f') ADVANCE(811);
      if (lookahead == 'i') ADVANCE(714);
      if (lookahead == 'k') ADVANCE(704);
      if (lookahead == 's') ADVANCE(897);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 719:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'g') ADVANCE(578);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 720:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'g') ADVANCE(615);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 721:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'g') ADVANCE(694);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 722:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'g') ADVANCE(848);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 723:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'g') ADVANCE(700);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 724:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'g') ADVANCE(707);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 725:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'g') ADVANCE(775);
      if (lookahead == 'r') ADVANCE(693);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 726:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'h') ADVANCE(616);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 727:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'h') ADVANCE(608);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 728:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'h') ADVANCE(782);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 729:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'h') ADVANCE(576);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 730:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'h') ADVANCE(686);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 731:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'h') ADVANCE(783);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 732:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'h') ADVANCE(766);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 733:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'h') ADVANCE(706);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 734:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'h') ADVANCE(708);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 735:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'h') ADVANCE(814);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 736:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'h') ADVANCE(656);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 737:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'i') ADVANCE(682);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 738:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'i') ADVANCE(884);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 739:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'i') ADVANCE(765);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 740:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'i') ADVANCE(885);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 741:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'i') ADVANCE(790);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 742:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'i') ADVANCE(764);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 743:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'i') ADVANCE(854);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 744:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'i') ADVANCE(827);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 745:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'i') ADVANCE(792);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 746:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'i') ADVANCE(817);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 747:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'i') ADVANCE(680);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 748:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'i') ADVANCE(871);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 749:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'i') ADVANCE(840);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 750:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'i') ADVANCE(855);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 751:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'i') ADVANCE(671);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 752:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'i') ADVANCE(795);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 753:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'i') ADVANCE(796);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 754:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'i') ADVANCE(776);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 755:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'i') ADVANCE(887);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 756:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'k') ADVANCE(634);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 757:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'k') ADVANCE(624);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 758:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'k') ADVANCE(702);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 759:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'k') ADVANCE(746);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 760:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'l') ADVANCE(607);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 761:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'l') ADVANCE(591);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 762:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'l') ADVANCE(652);
      if (lookahead == 'u') ADVANCE(774);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 763:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'l') ADVANCE(652);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 764:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'l') ADVANCE(683);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 765:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'l') ADVANCE(685);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 766:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'l') ADVANCE(898);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 767:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'l') ADVANCE(769);
      if (lookahead == 'u') ADVANCE(876);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 768:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'l') ADVANCE(769);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 769:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'l') ADVANCE(813);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 770:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'l') ADVANCE(636);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 771:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'l') ADVANCE(806);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 772:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'l') ADVANCE(741);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 773:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'l') ADVANCE(849);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 774:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'l') ADVANCE(760);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 775:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'l') ADVANCE(800);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 776:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'l') ADVANCE(712);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 777:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'l') ADVANCE(771);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 778:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'm') ADVANCE(797);
      if (lookahead == 'n') ADVANCE(798);
      if (lookahead == 'p') ADVANCE(829);
      if (lookahead == 's') ADVANCE(684);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 779:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'm') ADVANCE(797);
      if (lookahead == 'n') ADVANCE(798);
      if (lookahead == 'p') ADVANCE(829);
      if (lookahead == 's') ADVANCE(692);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 780:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'm') ADVANCE(605);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 781:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'm') ADVANCE(580);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 782:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'm') ADVANCE(803);
      if (lookahead == 'o') ADVANCE(890);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 783:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'm') ADVANCE(803);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 784:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'm') ADVANCE(772);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 785:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'm') ADVANCE(821);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 786:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'n') ADVANCE(858);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 787:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'n') ADVANCE(583);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 788:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'n') ADVANCE(596);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 789:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'n') ADVANCE(859);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 790:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'n') ADVANCE(757);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 791:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'n') ADVANCE(860);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 792:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'n') ADVANCE(720);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 793:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'n') ADVANCE(808);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 794:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'n') ADVANCE(669);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 795:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'n') ADVANCE(862);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 796:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'n') ADVANCE(865);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 797:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'o') ADVANCE(883);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 798:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'o') ADVANCE(621);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 799:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'o') ADVANCE(878);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 800:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'o') ADVANCE(659);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 801:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'o') ADVANCE(781);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 802:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'o') ADVANCE(752);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 803:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'o') ADVANCE(676);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 804:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'o') ADVANCE(826);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 805:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'o') ADVANCE(893);
      if (lookahead == 't') ADVANCE(846);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 806:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'o') ADVANCE(889);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 807:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'o') ADVANCE(832);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 808:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'o') ADVANCE(622);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 809:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'o') ADVANCE(650);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 810:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'o') ADVANCE(627);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 811:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'o') ADVANCE(834);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 812:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'o') ADVANCE(856);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 813:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'o') ADVANCE(894);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 814:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'o') ADVANCE(882);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 815:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'o') ADVANCE(777);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 816:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'p') ADVANCE(595);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 817:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'p') ADVANCE(574);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 818:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'p') ADVANCE(802);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 819:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'p') ADVANCE(619);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 820:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'p') ADVANCE(844);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 821:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'p') ADVANCE(812);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 822:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'p') ADVANCE(630);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 823:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'p') ADVANCE(880);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 824:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'q') ADVANCE(881);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 825:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'r') ADVANCE(896);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 826:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'r') ADVANCE(756);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 827:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'r') ADVANCE(585);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 828:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'r') ADVANCE(738);
      if (lookahead == 'u') ADVANCE(850);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 829:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'r') ADVANCE(738);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 830:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'r') ADVANCE(699);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 831:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'r') ADVANCE(722);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 832:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'r') ADVANCE(780);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 833:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'r') ADVANCE(719);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 834:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'r') ADVANCE(670);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 835:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'r') ADVANCE(649);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 836:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'r') ADVANCE(801);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 837:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'r') ADVANCE(857);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 838:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'r') ADVANCE(745);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 839:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'r') ADVANCE(873);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 840:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'r') ADVANCE(703);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 841:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'r') ADVANCE(886);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 842:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'r') ADVANCE(647);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 843:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'r') ADVANCE(724);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 844:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'r') ADVANCE(755);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 845:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 's') ADVANCE(575);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 846:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 's') ADVANCE(597);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 847:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 's') ADVANCE(593);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 848:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 's') ADVANCE(603);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 849:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 's') ADVANCE(900);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 850:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 's') ADVANCE(727);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 851:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 's') ADVANCE(853);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 852:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 's') ADVANCE(759);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 853:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 's') ADVANCE(623);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 854:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 's') ADVANCE(874);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 855:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 's') ADVANCE(866);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 856:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 's') ADVANCE(690);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 857:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 's') ADVANCE(750);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 858:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 't') ADVANCE(825);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 859:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 't') ADVANCE(696);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 860:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 't') ADVANCE(599);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 861:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 't') ADVANCE(611);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 862:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 't') ADVANCE(588);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 863:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 't') ADVANCE(609);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 864:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 't') ADVANCE(587);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 865:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 't') ADVANCE(581);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 866:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 't') ADVANCE(604);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 867:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 't') ADVANCE(823);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 868:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 't') ADVANCE(717);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 869:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 't') ADVANCE(891);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 870:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 't') ADVANCE(740);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 871:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 't') ADVANCE(735);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 872:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 't') ADVANCE(846);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 873:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 't') ADVANCE(732);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 874:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 't') ADVANCE(847);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 875:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 't') ADVANCE(629);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 876:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 't') ADVANCE(810);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 877:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'u') ADVANCE(850);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 878:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'u') ADVANCE(867);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 879:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'u') ADVANCE(742);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 880:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'u') ADVANCE(863);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 881:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'u') ADVANCE(749);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 882:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'u') ADVANCE(875);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 883:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'u') ADVANCE(791);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 884:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'v') ADVANCE(739);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 885:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'v') ADVANCE(687);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 886:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'v') ADVANCE(751);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 887:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'v') ADVANCE(754);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 888:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'w') ADVANCE(845);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 889:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'w') ADVANCE(617);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 890:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'w') ADVANCE(787);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 891:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'w') ADVANCE(804);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 892:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'w') ADVANCE(631);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 893:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'w') ADVANCE(788);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 894:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'w') ADVANCE(625);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 895:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'x') ADVANCE(743);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 896:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'y') ADVANCE(818);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 897:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'y') ADVANCE(784);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 898:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == 'y') ADVANCE(626);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 899:
      ACCEPT_TOKEN(aux_sym_unknown_option_token1);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      END_STATE();
    case 900:
      ACCEPT_TOKEN(sym_without_earthly_labels);
      END_STATE();
    case 901:
      ACCEPT_TOKEN(sym__string_base_other);
      if (lookahead == '\n') ADVANCE(1037);
      if (lookahead == '\f') ADVANCE(1038);
      if (lookahead == '\r') ADVANCE(153);
      if (('\t' <= lookahead && lookahead <= 0x0b) ||
          lookahead == ' ' ||
          lookahead == '"' ||
          lookahead == '$' ||
          ('\'' <= lookahead && lookahead <= ')') ||
          ('+' <= lookahead && lookahead <= ':') ||
          lookahead == '=' ||
          ('@' <= lookahead && lookahead <= ']') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= '{') ||
          lookahead == '}') ADVANCE(153);
      if (lookahead != 0) ADVANCE(901);
      END_STATE();
    case 902:
      ACCEPT_TOKEN(sym__string_base_other);
      if ((!eof && set_contains(sym__string_base_other_character_set_1, 12, lookahead))) ADVANCE(902);
      END_STATE();
    case 903:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == ' ') ADVANCE(198);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 904:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == ' ') ADVANCE(203);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 905:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == ' ') ADVANCE(265);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 906:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == ' ') ADVANCE(216);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 907:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'A') ADVANCE(914);
      if (lookahead == 'M') ADVANCE(918);
      if (lookahead == 'O') ADVANCE(948);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 908:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'A') ADVANCE(913);
      if (lookahead == 'E') ADVANCE(989);
      if (lookahead == 'O') ADVANCE(915);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 909:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'A') ADVANCE(1002);
      if (lookahead == 'E') ADVANCE(990);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 910:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'A') ADVANCE(957);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 911:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'A') ADVANCE(947);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 912:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'A') ADVANCE(937);
      if (lookahead == 'I') ADVANCE(996);
      if (lookahead == 'O') ADVANCE(976);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 913:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'B') ADVANCE(926);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 914:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'C') ADVANCE(933);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 915:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'C') ADVANCE(911);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 916:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'C') ADVANCE(998);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 917:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'C') ADVANCE(994);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 918:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'D') ADVANCE(434);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 919:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'D') ADVANCE(430);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 920:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'D') ADVANCE(457);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 921:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'D') ADVANCE(940);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 922:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'E') ADVANCE(432);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 923:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'E') ADVANCE(445);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 924:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'E') ADVANCE(489);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 925:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'E') ADVANCE(903);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 926:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'E') ADVANCE(943);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 927:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'E') ADVANCE(979);
      if (lookahead == 'O') ADVANCE(945);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 928:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'E') ADVANCE(977);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 929:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'E') ADVANCE(917);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 930:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'F') ADVANCE(462);
      if (lookahead == 'M') ADVANCE(971);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 931:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'G') ADVANCE(427);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 932:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'H') ADVANCE(906);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 933:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'H') ADVANCE(922);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 934:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'I') ADVANCE(988);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 935:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'I') ADVANCE(944);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 936:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'I') ADVANCE(958);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 937:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'I') ADVANCE(992);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 938:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'I') ADVANCE(965);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 939:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'I') ADVANCE(967);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 940:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'I') ADVANCE(978);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 941:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'J') ADVANCE(929);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 942:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'K') ADVANCE(921);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 943:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'L') ADVANCE(471);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 944:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'L') ADVANCE(919);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 945:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'L') ADVANCE(1001);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 946:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'L') ADVANCE(1005);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 947:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'L') ADVANCE(946);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 948:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'M') ADVANCE(950);
      if (lookahead == 'P') ADVANCE(1004);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 949:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'M') ADVANCE(452);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 950:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'M') ADVANCE(910);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 951:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'M') ADVANCE(924);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 952:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'N') ADVANCE(997);
      if (lookahead == 'X') ADVANCE(970);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 953:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'N') ADVANCE(475);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 954:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'N') ADVANCE(425);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 955:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'N') ADVANCE(455);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 956:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'N') ADVANCE(916);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 957:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'N') ADVANCE(920);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 958:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'N') ADVANCE(995);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 959:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'O') ADVANCE(438);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 960:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'O') ADVANCE(945);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 961:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'O') ADVANCE(941);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 962:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'O') ADVANCE(986);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 963:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'O') ADVANCE(949);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 964:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'O') ADVANCE(975);
      if (lookahead == 'R') ADVANCE(963);
      if (lookahead == 'U') ADVANCE(956);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 965:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'O') ADVANCE(954);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 966:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'O') ADVANCE(936);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 967:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'O') ADVANCE(955);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 968:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'O') ADVANCE(982);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 969:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'O') ADVANCE(987);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 970:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'P') ADVANCE(969);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 971:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'P') ADVANCE(968);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 972:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'P') ADVANCE(966);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 973:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'R') ADVANCE(931);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 974:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'R') ADVANCE(1003);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 975:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'R') ADVANCE(447);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 976:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'R') ADVANCE(942);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 977:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'R') ADVANCE(486);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 978:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'R') ADVANCE(494);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 979:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'R') ADVANCE(984);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 980:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'R') ADVANCE(1006);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 981:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'R') ADVANCE(961);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 982:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'R') ADVANCE(993);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 983:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'S') ADVANCE(928);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 984:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'S') ADVANCE(938);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 985:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'S') ADVANCE(905);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 986:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'S') ADVANCE(991);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 987:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'S') ADVANCE(923);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 988:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'T') ADVANCE(904);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 989:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'T') ADVANCE(468);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 990:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'T') ADVANCE(481);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 991:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'T') ADVANCE(460);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 992:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'T') ADVANCE(491);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 993:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'T') ADVANCE(464);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 994:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'T') ADVANCE(421);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 995:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'T') ADVANCE(440);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 996:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'T') ADVANCE(932);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 997:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'T') ADVANCE(980);
      if (lookahead == 'V') ADVANCE(442);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 998:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'T') ADVANCE(939);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 999:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'U') ADVANCE(935);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 1000:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'U') ADVANCE(953);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 1001:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'U') ADVANCE(951);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 1002:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'V') ADVANCE(925);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 1003:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'Y') ADVANCE(483);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 1004:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'Y') ADVANCE(436);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 1005:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'Y') ADVANCE(473);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 1006:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (lookahead == 'Y') ADVANCE(972);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 1007:
      ACCEPT_TOKEN(sym__string_base_alpha);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1007);
      END_STATE();
    case 1008:
      ACCEPT_TOKEN(sym__string_base_num);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1008);
      END_STATE();
    case 1009:
      ACCEPT_TOKEN(sym__immediate_string_base_other);
      if (lookahead == '\n') ADVANCE(1037);
      if (lookahead == '\f') ADVANCE(1038);
      if (lookahead == '\r') ADVANCE(153);
      if (('\t' <= lookahead && lookahead <= 0x0b) ||
          lookahead == ' ' ||
          lookahead == '"' ||
          lookahead == '$' ||
          ('\'' <= lookahead && lookahead <= ')') ||
          ('+' <= lookahead && lookahead <= ':') ||
          lookahead == '=' ||
          ('@' <= lookahead && lookahead <= ']') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= '{') ||
          lookahead == '}') ADVANCE(153);
      if (lookahead != 0) ADVANCE(1009);
      END_STATE();
    case 1010:
      ACCEPT_TOKEN(sym__immediate_string_base_other);
      if ((!eof && set_contains(sym__string_base_other_character_set_1, 12, lookahead))) ADVANCE(1010);
      END_STATE();
    case 1011:
      ACCEPT_TOKEN(sym__immediate_string_base_alpha);
      if (lookahead == ' ') ADVANCE(265);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1015);
      END_STATE();
    case 1012:
      ACCEPT_TOKEN(sym__immediate_string_base_alpha);
      if (lookahead == 'N') ADVANCE(449);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1015);
      END_STATE();
    case 1013:
      ACCEPT_TOKEN(sym__immediate_string_base_alpha);
      if (lookahead == 'S') ADVANCE(1011);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1015);
      END_STATE();
    case 1014:
      ACCEPT_TOKEN(sym__immediate_string_base_alpha);
      if (lookahead == 'S') ADVANCE(466);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1015);
      END_STATE();
    case 1015:
      ACCEPT_TOKEN(sym__immediate_string_base_alpha);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1015);
      END_STATE();
    case 1016:
      ACCEPT_TOKEN(sym__immediate_string_base_num);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1016);
      END_STATE();
    case 1017:
      ACCEPT_TOKEN(aux_sym_double_quoted_string_token1);
      if (lookahead == '\n') ADVANCE(1022);
      if (lookahead == '\f') ADVANCE(1022);
      if (lookahead == '\r') ADVANCE(1019);
      if (lookahead == '#') ADVANCE(1018);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(1017);
      if (lookahead != 0 &&
          (lookahead < '"' || '$' < lookahead) &&
          lookahead != '\\') ADVANCE(1022);
      END_STATE();
    case 1018:
      ACCEPT_TOKEN(aux_sym_double_quoted_string_token1);
      if (lookahead == '\n') ADVANCE(1022);
      if (lookahead == '\f') ADVANCE(1018);
      if (lookahead == '\r') ADVANCE(1018);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '\\') ADVANCE(1018);
      END_STATE();
    case 1019:
      ACCEPT_TOKEN(aux_sym_double_quoted_string_token1);
      if (lookahead == '\n') ADVANCE(1022);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '\\') ADVANCE(1022);
      END_STATE();
    case 1020:
      ACCEPT_TOKEN(aux_sym_double_quoted_string_token1);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1020);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '\\') ADVANCE(1022);
      END_STATE();
    case 1021:
      ACCEPT_TOKEN(aux_sym_double_quoted_string_token1);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1021);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '\\') ADVANCE(1022);
      END_STATE();
    case 1022:
      ACCEPT_TOKEN(aux_sym_double_quoted_string_token1);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '\\') ADVANCE(1022);
      END_STATE();
    case 1023:
      ACCEPT_TOKEN(anon_sym_DQUOTE2);
      END_STATE();
    case 1024:
      ACCEPT_TOKEN(anon_sym_SQUOTE2);
      END_STATE();
    case 1025:
      ACCEPT_TOKEN(aux_sym_single_quoted_string_token1);
      if (lookahead == '\n') ADVANCE(1043);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(1028);
      END_STATE();
    case 1026:
      ACCEPT_TOKEN(aux_sym_single_quoted_string_token1);
      if (lookahead == '\n') ADVANCE(1037);
      if (lookahead == '\f') ADVANCE(1039);
      if (lookahead == '\r') ADVANCE(1026);
      if (lookahead == '\'' ||
          lookahead == '\\') ADVANCE(153);
      if (lookahead != 0) ADVANCE(1026);
      END_STATE();
    case 1027:
      ACCEPT_TOKEN(aux_sym_single_quoted_string_token1);
      if (lookahead == '\f') ADVANCE(1047);
      if (lookahead == '\r') ADVANCE(1025);
      if (lookahead == '#') ADVANCE(1026);
      if (lookahead == '\\') ADVANCE(154);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(1027);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\'') ADVANCE(1028);
      END_STATE();
    case 1028:
      ACCEPT_TOKEN(aux_sym_single_quoted_string_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(1028);
      END_STATE();
    case 1029:
      ACCEPT_TOKEN(anon_sym_PLUS2);
      END_STATE();
    case 1030:
      ACCEPT_TOKEN(aux_sym_unquoted_string_with_spaces_token1);
      if (lookahead == '#') ADVANCE(901);
      if (lookahead == '\\') ADVANCE(154);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(1030);
      END_STATE();
    case 1031:
      ACCEPT_TOKEN(anon_sym_RPAREN4);
      END_STATE();
    case 1032:
      ACCEPT_TOKEN(anon_sym_DOLLAR2);
      END_STATE();
    case 1033:
      ACCEPT_TOKEN(aux_sym__immediate_escape_sequence_token1);
      END_STATE();
    case 1034:
      ACCEPT_TOKEN(aux_sym__immediate_escape_sequence_token1);
      if (lookahead == '\n') ADVANCE(1040);
      if (lookahead != 0) ADVANCE(156);
      END_STATE();
    case 1035:
      ACCEPT_TOKEN(aux_sym__immediate_escape_sequence_token1);
      if (lookahead == '#') ADVANCE(156);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(183);
      END_STATE();
    case 1036:
      ACCEPT_TOKEN(sym_line_continuation);
      if (lookahead == '#') ADVANCE(156);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(183);
      END_STATE();
    case 1037:
      ACCEPT_TOKEN(sym_comment);
      END_STATE();
    case 1038:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(1037);
      if (lookahead == '\f') ADVANCE(1038);
      if (lookahead == '\r') ADVANCE(153);
      if (lookahead != 0) ADVANCE(153);
      END_STATE();
    case 1039:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(1037);
      if (lookahead == '\f') ADVANCE(1039);
      if (lookahead == '\r') ADVANCE(1026);
      if (lookahead == '\'' ||
          lookahead == '\\') ADVANCE(153);
      if (lookahead != 0) ADVANCE(1026);
      END_STATE();
    case 1040:
      ACCEPT_TOKEN(sym_line_continuation_comment);
      if (lookahead == '#') ADVANCE(156);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(183);
      END_STATE();
    case 1041:
      ACCEPT_TOKEN(anon_sym_LF);
      END_STATE();
    case 1042:
      ACCEPT_TOKEN(anon_sym_LF);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(497);
      END_STATE();
    case 1043:
      ACCEPT_TOKEN(anon_sym_CR_LF);
      END_STATE();
    case 1044:
      ACCEPT_TOKEN(anon_sym_CR_LF);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(497);
      END_STATE();
    case 1045:
      ACCEPT_TOKEN(anon_sym_FF);
      END_STATE();
    case 1046:
      ACCEPT_TOKEN(anon_sym_FF);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(497);
      END_STATE();
    case 1047:
      ACCEPT_TOKEN(anon_sym_FF);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(1028);
      END_STATE();
    case 1048:
      ACCEPT_TOKEN(anon_sym_NULL);
      END_STATE();
    case 1049:
      ACCEPT_TOKEN(anon_sym_NULL);
      if ((!eof && set_contains(sym__string_base_other_character_set_1, 12, lookahead))) ADVANCE(1010);
      END_STATE();
    case 1050:
      ACCEPT_TOKEN(anon_sym_NULL);
      if ((!eof && set_contains(sym__string_base_other_character_set_1, 12, lookahead))) ADVANCE(902);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 417},
  [2] = {.lex_state = 418},
  [3] = {.lex_state = 157},
  [4] = {.lex_state = 157},
  [5] = {.lex_state = 157},
  [6] = {.lex_state = 157},
  [7] = {.lex_state = 157},
  [8] = {.lex_state = 157},
  [9] = {.lex_state = 157},
  [10] = {.lex_state = 418},
  [11] = {.lex_state = 157},
  [12] = {.lex_state = 157},
  [13] = {.lex_state = 157},
  [14] = {.lex_state = 157},
  [15] = {.lex_state = 157, .external_lex_state = 2},
  [16] = {.lex_state = 418},
  [17] = {.lex_state = 157},
  [18] = {.lex_state = 157},
  [19] = {.lex_state = 157},
  [20] = {.lex_state = 157},
  [21] = {.lex_state = 157},
  [22] = {.lex_state = 157, .external_lex_state = 2},
  [23] = {.lex_state = 157},
  [24] = {.lex_state = 63},
  [25] = {.lex_state = 63},
  [26] = {.lex_state = 157, .external_lex_state = 2},
  [27] = {.lex_state = 63},
  [28] = {.lex_state = 64},
  [29] = {.lex_state = 64},
  [30] = {.lex_state = 64},
  [31] = {.lex_state = 54},
  [32] = {.lex_state = 54},
  [33] = {.lex_state = 54},
  [34] = {.lex_state = 63},
  [35] = {.lex_state = 63},
  [36] = {.lex_state = 63},
  [37] = {.lex_state = 63},
  [38] = {.lex_state = 64},
  [39] = {.lex_state = 64},
  [40] = {.lex_state = 64},
  [41] = {.lex_state = 64},
  [42] = {.lex_state = 63},
  [43] = {.lex_state = 54},
  [44] = {.lex_state = 54},
  [45] = {.lex_state = 54},
  [46] = {.lex_state = 63},
  [47] = {.lex_state = 54},
  [48] = {.lex_state = 64},
  [49] = {.lex_state = 63},
  [50] = {.lex_state = 63},
  [51] = {.lex_state = 63},
  [52] = {.lex_state = 63},
  [53] = {.lex_state = 63},
  [54] = {.lex_state = 53},
  [55] = {.lex_state = 63},
  [56] = {.lex_state = 63},
  [57] = {.lex_state = 63},
  [58] = {.lex_state = 63},
  [59] = {.lex_state = 63},
  [60] = {.lex_state = 63},
  [61] = {.lex_state = 63},
  [62] = {.lex_state = 53},
  [63] = {.lex_state = 53},
  [64] = {.lex_state = 63},
  [65] = {.lex_state = 64},
  [66] = {.lex_state = 63},
  [67] = {.lex_state = 64},
  [68] = {.lex_state = 63},
  [69] = {.lex_state = 63},
  [70] = {.lex_state = 63},
  [71] = {.lex_state = 63},
  [72] = {.lex_state = 63},
  [73] = {.lex_state = 63},
  [74] = {.lex_state = 64},
  [75] = {.lex_state = 64},
  [76] = {.lex_state = 63},
  [77] = {.lex_state = 64},
  [78] = {.lex_state = 56},
  [79] = {.lex_state = 64},
  [80] = {.lex_state = 64},
  [81] = {.lex_state = 65},
  [82] = {.lex_state = 57},
  [83] = {.lex_state = 64},
  [84] = {.lex_state = 56},
  [85] = {.lex_state = 64},
  [86] = {.lex_state = 65},
  [87] = {.lex_state = 64},
  [88] = {.lex_state = 4},
  [89] = {.lex_state = 56},
  [90] = {.lex_state = 64},
  [91] = {.lex_state = 57},
  [92] = {.lex_state = 64},
  [93] = {.lex_state = 64},
  [94] = {.lex_state = 64},
  [95] = {.lex_state = 64},
  [96] = {.lex_state = 64},
  [97] = {.lex_state = 64},
  [98] = {.lex_state = 64},
  [99] = {.lex_state = 4},
  [100] = {.lex_state = 57},
  [101] = {.lex_state = 64},
  [102] = {.lex_state = 64},
  [103] = {.lex_state = 65},
  [104] = {.lex_state = 54},
  [105] = {.lex_state = 4},
  [106] = {.lex_state = 66},
  [107] = {.lex_state = 54},
  [108] = {.lex_state = 58},
  [109] = {.lex_state = 54},
  [110] = {.lex_state = 66},
  [111] = {.lex_state = 54},
  [112] = {.lex_state = 58},
  [113] = {.lex_state = 66},
  [114] = {.lex_state = 58},
  [115] = {.lex_state = 54},
  [116] = {.lex_state = 54},
  [117] = {.lex_state = 54},
  [118] = {.lex_state = 54},
  [119] = {.lex_state = 54},
  [120] = {.lex_state = 54},
  [121] = {.lex_state = 54},
  [122] = {.lex_state = 54},
  [123] = {.lex_state = 54},
  [124] = {.lex_state = 59},
  [125] = {.lex_state = 53},
  [126] = {.lex_state = 54},
  [127] = {.lex_state = 54},
  [128] = {.lex_state = 59},
  [129] = {.lex_state = 54},
  [130] = {.lex_state = 54},
  [131] = {.lex_state = 59},
  [132] = {.lex_state = 54},
  [133] = {.lex_state = 53},
  [134] = {.lex_state = 54},
  [135] = {.lex_state = 54},
  [136] = {.lex_state = 54},
  [137] = {.lex_state = 415},
  [138] = {.lex_state = 60},
  [139] = {.lex_state = 61},
  [140] = {.lex_state = 61},
  [141] = {.lex_state = 415},
  [142] = {.lex_state = 53},
  [143] = {.lex_state = 53},
  [144] = {.lex_state = 60},
  [145] = {.lex_state = 60},
  [146] = {.lex_state = 61},
  [147] = {.lex_state = 53},
  [148] = {.lex_state = 53},
  [149] = {.lex_state = 415},
  [150] = {.lex_state = 65},
  [151] = {.lex_state = 57},
  [152] = {.lex_state = 4},
  [153] = {.lex_state = 57},
  [154] = {.lex_state = 56},
  [155] = {.lex_state = 2},
  [156] = {.lex_state = 57},
  [157] = {.lex_state = 62},
  [158] = {.lex_state = 4},
  [159] = {.lex_state = 2},
  [160] = {.lex_state = 1},
  [161] = {.lex_state = 56},
  [162] = {.lex_state = 62},
  [163] = {.lex_state = 57},
  [164] = {.lex_state = 56},
  [165] = {.lex_state = 1},
  [166] = {.lex_state = 4},
  [167] = {.lex_state = 2},
  [168] = {.lex_state = 56},
  [169] = {.lex_state = 65},
  [170] = {.lex_state = 65},
  [171] = {.lex_state = 1},
  [172] = {.lex_state = 4},
  [173] = {.lex_state = 62},
  [174] = {.lex_state = 65},
  [175] = {.lex_state = 3},
  [176] = {.lex_state = 72},
  [177] = {.lex_state = 58},
  [178] = {.lex_state = 52},
  [179] = {.lex_state = 66},
  [180] = {.lex_state = 66},
  [181] = {.lex_state = 58},
  [182] = {.lex_state = 66},
  [183] = {.lex_state = 3},
  [184] = {.lex_state = 52},
  [185] = {.lex_state = 72},
  [186] = {.lex_state = 66},
  [187] = {.lex_state = 58},
  [188] = {.lex_state = 3},
  [189] = {.lex_state = 58},
  [190] = {.lex_state = 52},
  [191] = {.lex_state = 59},
  [192] = {.lex_state = 65},
  [193] = {.lex_state = 59},
  [194] = {.lex_state = 55},
  [195] = {.lex_state = 59},
  [196] = {.lex_state = 55},
  [197] = {.lex_state = 55},
  [198] = {.lex_state = 59},
  [199] = {.lex_state = 53},
  [200] = {.lex_state = 53},
  [201] = {.lex_state = 61},
  [202] = {.lex_state = 60},
  [203] = {.lex_state = 4},
  [204] = {.lex_state = 53},
  [205] = {.lex_state = 1},
  [206] = {.lex_state = 60},
  [207] = {.lex_state = 108},
  [208] = {.lex_state = 61},
  [209] = {.lex_state = 108},
  [210] = {.lex_state = 65},
  [211] = {.lex_state = 53},
  [212] = {.lex_state = 60},
  [213] = {.lex_state = 56},
  [214] = {.lex_state = 108},
  [215] = {.lex_state = 1},
  [216] = {.lex_state = 108},
  [217] = {.lex_state = 60},
  [218] = {.lex_state = 61},
  [219] = {.lex_state = 53},
  [220] = {.lex_state = 61},
  [221] = {.lex_state = 57},
  [222] = {.lex_state = 53},
  [223] = {.lex_state = 1},
  [224] = {.lex_state = 57},
  [225] = {.lex_state = 53},
  [226] = {.lex_state = 62},
  [227] = {.lex_state = 53},
  [228] = {.lex_state = 65},
  [229] = {.lex_state = 53},
  [230] = {.lex_state = 53},
  [231] = {.lex_state = 52},
  [232] = {.lex_state = 53},
  [233] = {.lex_state = 52},
  [234] = {.lex_state = 58},
  [235] = {.lex_state = 56},
  [236] = {.lex_state = 53},
  [237] = {.lex_state = 53},
  [238] = {.lex_state = 65},
  [239] = {.lex_state = 53},
  [240] = {.lex_state = 66},
  [241] = {.lex_state = 57},
  [242] = {.lex_state = 1},
  [243] = {.lex_state = 62},
  [244] = {.lex_state = 53},
  [245] = {.lex_state = 2},
  [246] = {.lex_state = 56},
  [247] = {.lex_state = 62},
  [248] = {.lex_state = 2},
  [249] = {.lex_state = 53},
  [250] = {.lex_state = 2},
  [251] = {.lex_state = 53},
  [252] = {.lex_state = 57},
  [253] = {.lex_state = 1},
  [254] = {.lex_state = 53},
  [255] = {.lex_state = 53},
  [256] = {.lex_state = 56},
  [257] = {.lex_state = 4},
  [258] = {.lex_state = 53},
  [259] = {.lex_state = 65},
  [260] = {.lex_state = 1},
  [261] = {.lex_state = 4},
  [262] = {.lex_state = 4},
  [263] = {.lex_state = 53},
  [264] = {.lex_state = 4},
  [265] = {.lex_state = 65},
  [266] = {.lex_state = 53},
  [267] = {.lex_state = 57},
  [268] = {.lex_state = 2},
  [269] = {.lex_state = 53},
  [270] = {.lex_state = 53},
  [271] = {.lex_state = 3},
  [272] = {.lex_state = 62},
  [273] = {.lex_state = 56},
  [274] = {.lex_state = 57},
  [275] = {.lex_state = 65},
  [276] = {.lex_state = 57},
  [277] = {.lex_state = 65},
  [278] = {.lex_state = 56},
  [279] = {.lex_state = 66},
  [280] = {.lex_state = 65},
  [281] = {.lex_state = 57},
  [282] = {.lex_state = 57},
  [283] = {.lex_state = 4},
  [284] = {.lex_state = 52},
  [285] = {.lex_state = 56},
  [286] = {.lex_state = 56},
  [287] = {.lex_state = 57},
  [288] = {.lex_state = 58},
  [289] = {.lex_state = 57},
  [290] = {.lex_state = 72},
  [291] = {.lex_state = 4},
  [292] = {.lex_state = 72},
  [293] = {.lex_state = 4},
  [294] = {.lex_state = 56},
  [295] = {.lex_state = 56},
  [296] = {.lex_state = 72},
  [297] = {.lex_state = 57},
  [298] = {.lex_state = 72},
  [299] = {.lex_state = 65},
  [300] = {.lex_state = 4},
  [301] = {.lex_state = 4},
  [302] = {.lex_state = 52},
  [303] = {.lex_state = 57},
  [304] = {.lex_state = 56},
  [305] = {.lex_state = 56},
  [306] = {.lex_state = 65},
  [307] = {.lex_state = 56},
  [308] = {.lex_state = 65},
  [309] = {.lex_state = 4},
  [310] = {.lex_state = 4},
  [311] = {.lex_state = 66},
  [312] = {.lex_state = 4},
  [313] = {.lex_state = 57},
  [314] = {.lex_state = 58},
  [315] = {.lex_state = 52},
  [316] = {.lex_state = 4},
  [317] = {.lex_state = 3},
  [318] = {.lex_state = 4},
  [319] = {.lex_state = 57},
  [320] = {.lex_state = 65},
  [321] = {.lex_state = 57},
  [322] = {.lex_state = 65},
  [323] = {.lex_state = 57},
  [324] = {.lex_state = 65},
  [325] = {.lex_state = 56},
  [326] = {.lex_state = 66},
  [327] = {.lex_state = 57},
  [328] = {.lex_state = 3},
  [329] = {.lex_state = 3},
  [330] = {.lex_state = 59},
  [331] = {.lex_state = 4},
  [332] = {.lex_state = 65},
  [333] = {.lex_state = 56},
  [334] = {.lex_state = 65},
  [335] = {.lex_state = 57},
  [336] = {.lex_state = 56},
  [337] = {.lex_state = 3},
  [338] = {.lex_state = 4},
  [339] = {.lex_state = 4},
  [340] = {.lex_state = 56},
  [341] = {.lex_state = 4},
  [342] = {.lex_state = 52},
  [343] = {.lex_state = 65},
  [344] = {.lex_state = 65},
  [345] = {.lex_state = 4},
  [346] = {.lex_state = 66},
  [347] = {.lex_state = 56},
  [348] = {.lex_state = 57},
  [349] = {.lex_state = 58},
  [350] = {.lex_state = 57},
  [351] = {.lex_state = 65},
  [352] = {.lex_state = 56},
  [353] = {.lex_state = 56},
  [354] = {.lex_state = 65},
  [355] = {.lex_state = 4},
  [356] = {.lex_state = 56},
  [357] = {.lex_state = 65},
  [358] = {.lex_state = 65},
  [359] = {.lex_state = 58},
  [360] = {.lex_state = 59},
  [361] = {.lex_state = 58},
  [362] = {.lex_state = 77},
  [363] = {.lex_state = 66},
  [364] = {.lex_state = 72},
  [365] = {.lex_state = 10},
  [366] = {.lex_state = 55},
  [367] = {.lex_state = 58},
  [368] = {.lex_state = 77},
  [369] = {.lex_state = 59},
  [370] = {.lex_state = 66},
  [371] = {.lex_state = 55},
  [372] = {.lex_state = 59},
  [373] = {.lex_state = 72},
  [374] = {.lex_state = 58},
  [375] = {.lex_state = 58},
  [376] = {.lex_state = 55},
  [377] = {.lex_state = 58},
  [378] = {.lex_state = 55},
  [379] = {.lex_state = 72},
  [380] = {.lex_state = 66},
  [381] = {.lex_state = 66},
  [382] = {.lex_state = 66},
  [383] = {.lex_state = 58},
  [384] = {.lex_state = 66},
  [385] = {.lex_state = 77},
  [386] = {.lex_state = 66},
  [387] = {.lex_state = 10},
  [388] = {.lex_state = 58},
  [389] = {.lex_state = 66},
  [390] = {.lex_state = 66},
  [391] = {.lex_state = 58},
  [392] = {.lex_state = 66},
  [393] = {.lex_state = 66},
  [394] = {.lex_state = 58},
  [395] = {.lex_state = 58},
  [396] = {.lex_state = 66},
  [397] = {.lex_state = 66},
  [398] = {.lex_state = 72},
  [399] = {.lex_state = 66},
  [400] = {.lex_state = 10},
  [401] = {.lex_state = 58},
  [402] = {.lex_state = 61},
  [403] = {.lex_state = 58},
  [404] = {.lex_state = 59},
  [405] = {.lex_state = 60},
  [406] = {.lex_state = 58},
  [407] = {.lex_state = 58},
  [408] = {.lex_state = 66},
  [409] = {.lex_state = 58},
  [410] = {.lex_state = 66},
  [411] = {.lex_state = 58},
  [412] = {.lex_state = 59},
  [413] = {.lex_state = 59},
  [414] = {.lex_state = 71},
  [415] = {.lex_state = 61},
  [416] = {.lex_state = 59},
  [417] = {.lex_state = 62},
  [418] = {.lex_state = 59},
  [419] = {.lex_state = 60},
  [420] = {.lex_state = 59},
  [421] = {.lex_state = 59},
  [422] = {.lex_state = 59},
  [423] = {.lex_state = 59},
  [424] = {.lex_state = 59},
  [425] = {.lex_state = 59},
  [426] = {.lex_state = 59},
  [427] = {.lex_state = 59},
  [428] = {.lex_state = 61},
  [429] = {.lex_state = 59},
  [430] = {.lex_state = 61},
  [431] = {.lex_state = 60},
  [432] = {.lex_state = 60},
  [433] = {.lex_state = 59},
  [434] = {.lex_state = 61},
  [435] = {.lex_state = 1},
  [436] = {.lex_state = 59},
  [437] = {.lex_state = 2},
  [438] = {.lex_state = 71},
  [439] = {.lex_state = 59},
  [440] = {.lex_state = 60},
  [441] = {.lex_state = 60},
  [442] = {.lex_state = 3},
  [443] = {.lex_state = 60},
  [444] = {.lex_state = 62},
  [445] = {.lex_state = 61},
  [446] = {.lex_state = 60},
  [447] = {.lex_state = 61},
  [448] = {.lex_state = 60},
  [449] = {.lex_state = 61},
  [450] = {.lex_state = 60},
  [451] = {.lex_state = 62},
  [452] = {.lex_state = 61},
  [453] = {.lex_state = 61},
  [454] = {.lex_state = 2},
  [455] = {.lex_state = 61},
  [456] = {.lex_state = 60},
  [457] = {.lex_state = 61},
  [458] = {.lex_state = 60},
  [459] = {.lex_state = 1},
  [460] = {.lex_state = 62},
  [461] = {.lex_state = 61},
  [462] = {.lex_state = 61},
  [463] = {.lex_state = 1},
  [464] = {.lex_state = 61},
  [465] = {.lex_state = 60},
  [466] = {.lex_state = 1},
  [467] = {.lex_state = 60},
  [468] = {.lex_state = 60},
  [469] = {.lex_state = 52},
  [470] = {.lex_state = 61},
  [471] = {.lex_state = 60},
  [472] = {.lex_state = 2},
  [473] = {.lex_state = 62},
  [474] = {.lex_state = 60},
  [475] = {.lex_state = 2},
  [476] = {.lex_state = 2},
  [477] = {.lex_state = 60},
  [478] = {.lex_state = 1},
  [479] = {.lex_state = 61},
  [480] = {.lex_state = 61},
  [481] = {.lex_state = 60},
  [482] = {.lex_state = 61},
  [483] = {.lex_state = 61},
  [484] = {.lex_state = 61},
  [485] = {.lex_state = 60},
  [486] = {.lex_state = 60},
  [487] = {.lex_state = 1},
  [488] = {.lex_state = 108},
  [489] = {.lex_state = 62},
  [490] = {.lex_state = 1},
  [491] = {.lex_state = 62},
  [492] = {.lex_state = 52},
  [493] = {.lex_state = 62},
  [494] = {.lex_state = 52},
  [495] = {.lex_state = 55},
  [496] = {.lex_state = 52},
  [497] = {.lex_state = 2},
  [498] = {.lex_state = 3},
  [499] = {.lex_state = 1},
  [500] = {.lex_state = 62},
  [501] = {.lex_state = 1},
  [502] = {.lex_state = 62},
  [503] = {.lex_state = 1},
  [504] = {.lex_state = 1},
  [505] = {.lex_state = 2},
  [506] = {.lex_state = 2},
  [507] = {.lex_state = 1},
  [508] = {.lex_state = 2},
  [509] = {.lex_state = 52},
  [510] = {.lex_state = 2},
  [511] = {.lex_state = 1},
  [512] = {.lex_state = 2},
  [513] = {.lex_state = 1},
  [514] = {.lex_state = 2},
  [515] = {.lex_state = 1},
  [516] = {.lex_state = 1},
  [517] = {.lex_state = 52},
  [518] = {.lex_state = 2},
  [519] = {.lex_state = 2},
  [520] = {.lex_state = 1},
  [521] = {.lex_state = 62},
  [522] = {.lex_state = 2},
  [523] = {.lex_state = 62},
  [524] = {.lex_state = 1},
  [525] = {.lex_state = 1},
  [526] = {.lex_state = 1},
  [527] = {.lex_state = 1},
  [528] = {.lex_state = 38},
  [529] = {.lex_state = 3},
  [530] = {.lex_state = 62},
  [531] = {.lex_state = 62},
  [532] = {.lex_state = 3},
  [533] = {.lex_state = 2},
  [534] = {.lex_state = 2},
  [535] = {.lex_state = 2},
  [536] = {.lex_state = 62},
  [537] = {.lex_state = 62},
  [538] = {.lex_state = 62},
  [539] = {.lex_state = 62},
  [540] = {.lex_state = 38},
  [541] = {.lex_state = 3},
  [542] = {.lex_state = 2},
  [543] = {.lex_state = 62},
  [544] = {.lex_state = 1},
  [545] = {.lex_state = 10},
  [546] = {.lex_state = 62},
  [547] = {.lex_state = 2},
  [548] = {.lex_state = 1},
  [549] = {.lex_state = 2},
  [550] = {.lex_state = 62},
  [551] = {.lex_state = 108},
  [552] = {.lex_state = 38},
  [553] = {.lex_state = 1},
  [554] = {.lex_state = 52},
  [555] = {.lex_state = 3},
  [556] = {.lex_state = 52},
  [557] = {.lex_state = 52},
  [558] = {.lex_state = 52},
  [559] = {.lex_state = 52},
  [560] = {.lex_state = 3},
  [561] = {.lex_state = 52},
  [562] = {.lex_state = 3},
  [563] = {.lex_state = 52},
  [564] = {.lex_state = 52},
  [565] = {.lex_state = 52},
  [566] = {.lex_state = 3},
  [567] = {.lex_state = 3},
  [568] = {.lex_state = 3},
  [569] = {.lex_state = 3},
  [570] = {.lex_state = 3},
  [571] = {.lex_state = 52},
  [572] = {.lex_state = 3},
  [573] = {.lex_state = 10},
  [574] = {.lex_state = 3},
  [575] = {.lex_state = 52},
  [576] = {.lex_state = 52},
  [577] = {.lex_state = 52},
  [578] = {.lex_state = 55},
  [579] = {.lex_state = 52},
  [580] = {.lex_state = 10},
  [581] = {.lex_state = 52},
  [582] = {.lex_state = 55},
  [583] = {.lex_state = 52},
  [584] = {.lex_state = 10},
  [585] = {.lex_state = 3},
  [586] = {.lex_state = 3},
  [587] = {.lex_state = 3},
  [588] = {.lex_state = 3},
  [589] = {.lex_state = 3},
  [590] = {.lex_state = 52},
  [591] = {.lex_state = 55},
  [592] = {.lex_state = 3},
  [593] = {.lex_state = 55},
  [594] = {.lex_state = 52},
  [595] = {.lex_state = 10},
  [596] = {.lex_state = 3},
  [597] = {.lex_state = 71},
  [598] = {.lex_state = 10},
  [599] = {.lex_state = 55},
  [600] = {.lex_state = 55},
  [601] = {.lex_state = 55},
  [602] = {.lex_state = 10},
  [603] = {.lex_state = 71},
  [604] = {.lex_state = 55},
  [605] = {.lex_state = 55},
  [606] = {.lex_state = 86},
  [607] = {.lex_state = 55},
  [608] = {.lex_state = 55},
  [609] = {.lex_state = 86},
  [610] = {.lex_state = 55},
  [611] = {.lex_state = 10},
  [612] = {.lex_state = 10},
  [613] = {.lex_state = 55},
  [614] = {.lex_state = 86},
  [615] = {.lex_state = 55},
  [616] = {.lex_state = 10},
  [617] = {.lex_state = 55},
  [618] = {.lex_state = 55},
  [619] = {.lex_state = 71},
  [620] = {.lex_state = 10},
  [621] = {.lex_state = 10},
  [622] = {.lex_state = 55},
  [623] = {.lex_state = 55},
  [624] = {.lex_state = 55},
  [625] = {.lex_state = 10},
  [626] = {.lex_state = 55},
  [627] = {.lex_state = 71},
  [628] = {.lex_state = 415},
  [629] = {.lex_state = 71},
  [630] = {.lex_state = 71},
  [631] = {.lex_state = 71},
  [632] = {.lex_state = 93},
  [633] = {.lex_state = 71},
  [634] = {.lex_state = 415},
  [635] = {.lex_state = 93},
  [636] = {.lex_state = 93},
  [637] = {.lex_state = 8},
  [638] = {.lex_state = 8},
  [639] = {.lex_state = 91},
  [640] = {.lex_state = 67},
  [641] = {.lex_state = 67},
  [642] = {.lex_state = 91},
  [643] = {.lex_state = 67},
  [644] = {.lex_state = 91},
  [645] = {.lex_state = 8},
  [646] = {.lex_state = 8},
  [647] = {.lex_state = 8},
  [648] = {.lex_state = 109},
  [649] = {.lex_state = 68},
  [650] = {.lex_state = 107},
  [651] = {.lex_state = 68},
  [652] = {.lex_state = 8},
  [653] = {.lex_state = 68},
  [654] = {.lex_state = 157},
  [655] = {.lex_state = 157},
  [656] = {.lex_state = 157},
  [657] = {.lex_state = 8},
  [658] = {.lex_state = 157},
  [659] = {.lex_state = 88},
  [660] = {.lex_state = 157},
  [661] = {.lex_state = 157},
  [662] = {.lex_state = 157},
  [663] = {.lex_state = 157},
  [664] = {.lex_state = 157},
  [665] = {.lex_state = 157},
  [666] = {.lex_state = 157},
  [667] = {.lex_state = 157},
  [668] = {.lex_state = 157},
  [669] = {.lex_state = 157},
  [670] = {.lex_state = 157},
  [671] = {.lex_state = 157},
  [672] = {.lex_state = 157},
  [673] = {.lex_state = 157},
  [674] = {.lex_state = 157},
  [675] = {.lex_state = 157},
  [676] = {.lex_state = 157},
  [677] = {.lex_state = 108},
  [678] = {.lex_state = 88},
  [679] = {.lex_state = 108},
  [680] = {.lex_state = 157},
  [681] = {.lex_state = 157},
  [682] = {.lex_state = 157},
  [683] = {.lex_state = 157},
  [684] = {.lex_state = 157},
  [685] = {.lex_state = 88},
  [686] = {.lex_state = 157},
  [687] = {.lex_state = 157},
  [688] = {.lex_state = 157},
  [689] = {.lex_state = 157},
  [690] = {.lex_state = 157},
  [691] = {.lex_state = 157},
  [692] = {.lex_state = 157},
  [693] = {.lex_state = 157},
  [694] = {.lex_state = 157},
  [695] = {.lex_state = 157},
  [696] = {.lex_state = 108},
  [697] = {.lex_state = 157},
  [698] = {.lex_state = 157},
  [699] = {.lex_state = 157},
  [700] = {.lex_state = 157},
  [701] = {.lex_state = 157},
  [702] = {.lex_state = 157},
  [703] = {.lex_state = 157},
  [704] = {.lex_state = 157},
  [705] = {.lex_state = 157},
  [706] = {.lex_state = 157},
  [707] = {.lex_state = 157},
  [708] = {.lex_state = 157},
  [709] = {.lex_state = 157},
  [710] = {.lex_state = 157},
  [711] = {.lex_state = 157},
  [712] = {.lex_state = 157},
  [713] = {.lex_state = 157},
  [714] = {.lex_state = 157},
  [715] = {.lex_state = 157},
  [716] = {.lex_state = 157},
  [717] = {.lex_state = 157},
  [718] = {.lex_state = 157},
  [719] = {.lex_state = 157},
  [720] = {.lex_state = 108},
  [721] = {.lex_state = 157},
  [722] = {.lex_state = 108},
  [723] = {.lex_state = 157},
  [724] = {.lex_state = 157},
  [725] = {.lex_state = 157},
  [726] = {.lex_state = 157},
  [727] = {.lex_state = 157},
  [728] = {.lex_state = 157},
  [729] = {.lex_state = 157},
  [730] = {.lex_state = 157},
  [731] = {.lex_state = 157},
  [732] = {.lex_state = 157},
  [733] = {.lex_state = 157},
  [734] = {.lex_state = 157},
  [735] = {.lex_state = 88},
  [736] = {.lex_state = 157},
  [737] = {.lex_state = 157},
  [738] = {.lex_state = 157},
  [739] = {.lex_state = 157},
  [740] = {.lex_state = 157},
  [741] = {.lex_state = 157},
  [742] = {.lex_state = 157},
  [743] = {.lex_state = 157},
  [744] = {.lex_state = 157},
  [745] = {.lex_state = 157},
  [746] = {.lex_state = 157},
  [747] = {.lex_state = 157},
  [748] = {.lex_state = 157},
  [749] = {.lex_state = 114},
  [750] = {.lex_state = 114},
  [751] = {.lex_state = 114},
  [752] = {.lex_state = 95},
  [753] = {.lex_state = 8},
  [754] = {.lex_state = 95},
  [755] = {.lex_state = 114},
  [756] = {.lex_state = 8},
  [757] = {.lex_state = 95},
  [758] = {.lex_state = 418},
  [759] = {.lex_state = 418},
  [760] = {.lex_state = 418},
  [761] = {.lex_state = 418},
  [762] = {.lex_state = 418},
  [763] = {.lex_state = 8},
  [764] = {.lex_state = 97},
  [765] = {.lex_state = 418},
  [766] = {.lex_state = 418},
  [767] = {.lex_state = 418},
  [768] = {.lex_state = 418},
  [769] = {.lex_state = 418},
  [770] = {.lex_state = 418},
  [771] = {.lex_state = 418},
  [772] = {.lex_state = 418},
  [773] = {.lex_state = 8},
  [774] = {.lex_state = 418},
  [775] = {.lex_state = 418},
  [776] = {.lex_state = 418},
  [777] = {.lex_state = 418},
  [778] = {.lex_state = 418},
  [779] = {.lex_state = 418},
  [780] = {.lex_state = 67},
  [781] = {.lex_state = 418},
  [782] = {.lex_state = 418},
  [783] = {.lex_state = 418},
  [784] = {.lex_state = 418},
  [785] = {.lex_state = 418},
  [786] = {.lex_state = 97},
  [787] = {.lex_state = 418},
  [788] = {.lex_state = 418},
  [789] = {.lex_state = 418},
  [790] = {.lex_state = 418},
  [791] = {.lex_state = 418},
  [792] = {.lex_state = 418},
  [793] = {.lex_state = 97},
  [794] = {.lex_state = 418},
  [795] = {.lex_state = 418},
  [796] = {.lex_state = 418},
  [797] = {.lex_state = 418},
  [798] = {.lex_state = 418},
  [799] = {.lex_state = 418},
  [800] = {.lex_state = 418},
  [801] = {.lex_state = 114},
  [802] = {.lex_state = 8},
  [803] = {.lex_state = 418},
  [804] = {.lex_state = 418},
  [805] = {.lex_state = 79},
  [806] = {.lex_state = 418},
  [807] = {.lex_state = 418},
  [808] = {.lex_state = 418},
  [809] = {.lex_state = 418},
  [810] = {.lex_state = 418},
  [811] = {.lex_state = 418},
  [812] = {.lex_state = 418},
  [813] = {.lex_state = 418},
  [814] = {.lex_state = 418},
  [815] = {.lex_state = 418},
  [816] = {.lex_state = 8},
  [817] = {.lex_state = 418},
  [818] = {.lex_state = 418},
  [819] = {.lex_state = 418},
  [820] = {.lex_state = 418},
  [821] = {.lex_state = 418},
  [822] = {.lex_state = 418},
  [823] = {.lex_state = 418},
  [824] = {.lex_state = 67},
  [825] = {.lex_state = 67},
  [826] = {.lex_state = 418},
  [827] = {.lex_state = 418},
  [828] = {.lex_state = 418},
  [829] = {.lex_state = 418},
  [830] = {.lex_state = 418},
  [831] = {.lex_state = 418},
  [832] = {.lex_state = 418},
  [833] = {.lex_state = 418},
  [834] = {.lex_state = 418},
  [835] = {.lex_state = 418},
  [836] = {.lex_state = 418},
  [837] = {.lex_state = 67},
  [838] = {.lex_state = 418},
  [839] = {.lex_state = 418},
  [840] = {.lex_state = 418},
  [841] = {.lex_state = 418},
  [842] = {.lex_state = 418},
  [843] = {.lex_state = 418},
  [844] = {.lex_state = 418},
  [845] = {.lex_state = 418},
  [846] = {.lex_state = 418},
  [847] = {.lex_state = 418},
  [848] = {.lex_state = 418},
  [849] = {.lex_state = 418},
  [850] = {.lex_state = 418},
  [851] = {.lex_state = 418},
  [852] = {.lex_state = 418},
  [853] = {.lex_state = 418},
  [854] = {.lex_state = 418},
  [855] = {.lex_state = 418},
  [856] = {.lex_state = 418},
  [857] = {.lex_state = 418},
  [858] = {.lex_state = 77},
  [859] = {.lex_state = 157, .external_lex_state = 2},
  [860] = {.lex_state = 99},
  [861] = {.lex_state = 157, .external_lex_state = 2},
  [862] = {.lex_state = 69},
  [863] = {.lex_state = 69},
  [864] = {.lex_state = 69},
  [865] = {.lex_state = 99},
  [866] = {.lex_state = 37},
  [867] = {.lex_state = 75},
  [868] = {.lex_state = 157, .external_lex_state = 2},
  [869] = {.lex_state = 68},
  [870] = {.lex_state = 157, .external_lex_state = 2},
  [871] = {.lex_state = 157, .external_lex_state = 2},
  [872] = {.lex_state = 157, .external_lex_state = 2},
  [873] = {.lex_state = 157, .external_lex_state = 2},
  [874] = {.lex_state = 37},
  [875] = {.lex_state = 157, .external_lex_state = 2},
  [876] = {.lex_state = 75},
  [877] = {.lex_state = 157, .external_lex_state = 2},
  [878] = {.lex_state = 157, .external_lex_state = 2},
  [879] = {.lex_state = 157, .external_lex_state = 2},
  [880] = {.lex_state = 157, .external_lex_state = 2},
  [881] = {.lex_state = 157, .external_lex_state = 2},
  [882] = {.lex_state = 75},
  [883] = {.lex_state = 157, .external_lex_state = 2},
  [884] = {.lex_state = 157, .external_lex_state = 2},
  [885] = {.lex_state = 157, .external_lex_state = 2},
  [886] = {.lex_state = 157, .external_lex_state = 2},
  [887] = {.lex_state = 157, .external_lex_state = 2},
  [888] = {.lex_state = 157, .external_lex_state = 2},
  [889] = {.lex_state = 157, .external_lex_state = 2},
  [890] = {.lex_state = 157, .external_lex_state = 2},
  [891] = {.lex_state = 157, .external_lex_state = 2},
  [892] = {.lex_state = 157, .external_lex_state = 2},
  [893] = {.lex_state = 75},
  [894] = {.lex_state = 415},
  [895] = {.lex_state = 157, .external_lex_state = 2},
  [896] = {.lex_state = 157, .external_lex_state = 2},
  [897] = {.lex_state = 157, .external_lex_state = 2},
  [898] = {.lex_state = 75},
  [899] = {.lex_state = 75},
  [900] = {.lex_state = 157, .external_lex_state = 2},
  [901] = {.lex_state = 157, .external_lex_state = 2},
  [902] = {.lex_state = 157, .external_lex_state = 2},
  [903] = {.lex_state = 157, .external_lex_state = 2},
  [904] = {.lex_state = 415},
  [905] = {.lex_state = 157, .external_lex_state = 2},
  [906] = {.lex_state = 415},
  [907] = {.lex_state = 415},
  [908] = {.lex_state = 157, .external_lex_state = 2},
  [909] = {.lex_state = 99},
  [910] = {.lex_state = 77},
  [911] = {.lex_state = 157, .external_lex_state = 2},
  [912] = {.lex_state = 157, .external_lex_state = 2},
  [913] = {.lex_state = 157, .external_lex_state = 2},
  [914] = {.lex_state = 157, .external_lex_state = 2},
  [915] = {.lex_state = 157, .external_lex_state = 2},
  [916] = {.lex_state = 157, .external_lex_state = 2},
  [917] = {.lex_state = 415},
  [918] = {.lex_state = 157, .external_lex_state = 2},
  [919] = {.lex_state = 157, .external_lex_state = 2},
  [920] = {.lex_state = 157, .external_lex_state = 2},
  [921] = {.lex_state = 157, .external_lex_state = 2},
  [922] = {.lex_state = 157, .external_lex_state = 2},
  [923] = {.lex_state = 157, .external_lex_state = 2},
  [924] = {.lex_state = 157, .external_lex_state = 2},
  [925] = {.lex_state = 157, .external_lex_state = 2},
  [926] = {.lex_state = 157, .external_lex_state = 2},
  [927] = {.lex_state = 157, .external_lex_state = 2},
  [928] = {.lex_state = 157, .external_lex_state = 2},
  [929] = {.lex_state = 157, .external_lex_state = 2},
  [930] = {.lex_state = 157, .external_lex_state = 2},
  [931] = {.lex_state = 157, .external_lex_state = 2},
  [932] = {.lex_state = 75},
  [933] = {.lex_state = 157, .external_lex_state = 2},
  [934] = {.lex_state = 157, .external_lex_state = 2},
  [935] = {.lex_state = 157, .external_lex_state = 2},
  [936] = {.lex_state = 157, .external_lex_state = 2},
  [937] = {.lex_state = 157, .external_lex_state = 2},
  [938] = {.lex_state = 157, .external_lex_state = 2},
  [939] = {.lex_state = 157, .external_lex_state = 2},
  [940] = {.lex_state = 157, .external_lex_state = 2},
  [941] = {.lex_state = 157, .external_lex_state = 2},
  [942] = {.lex_state = 68},
  [943] = {.lex_state = 157, .external_lex_state = 2},
  [944] = {.lex_state = 37},
  [945] = {.lex_state = 157, .external_lex_state = 2},
  [946] = {.lex_state = 157, .external_lex_state = 2},
  [947] = {.lex_state = 157, .external_lex_state = 2},
  [948] = {.lex_state = 157, .external_lex_state = 2},
  [949] = {.lex_state = 157, .external_lex_state = 2},
  [950] = {.lex_state = 157, .external_lex_state = 2},
  [951] = {.lex_state = 157, .external_lex_state = 2},
  [952] = {.lex_state = 75},
  [953] = {.lex_state = 75},
  [954] = {.lex_state = 75},
  [955] = {.lex_state = 157, .external_lex_state = 2},
  [956] = {.lex_state = 157, .external_lex_state = 2},
  [957] = {.lex_state = 157, .external_lex_state = 2},
  [958] = {.lex_state = 157, .external_lex_state = 2},
  [959] = {.lex_state = 157, .external_lex_state = 2},
  [960] = {.lex_state = 157, .external_lex_state = 2},
  [961] = {.lex_state = 157, .external_lex_state = 2},
  [962] = {.lex_state = 157, .external_lex_state = 2},
  [963] = {.lex_state = 157, .external_lex_state = 2},
  [964] = {.lex_state = 157, .external_lex_state = 2},
  [965] = {.lex_state = 157, .external_lex_state = 2},
  [966] = {.lex_state = 75},
  [967] = {.lex_state = 157, .external_lex_state = 2},
  [968] = {.lex_state = 157, .external_lex_state = 2},
  [969] = {.lex_state = 68},
  [970] = {.lex_state = 157, .external_lex_state = 2},
  [971] = {.lex_state = 68},
  [972] = {.lex_state = 157, .external_lex_state = 2},
  [973] = {.lex_state = 157, .external_lex_state = 2},
  [974] = {.lex_state = 76},
  [975] = {.lex_state = 8},
  [976] = {.lex_state = 70},
  [977] = {.lex_state = 70},
  [978] = {.lex_state = 36},
  [979] = {.lex_state = 11},
  [980] = {.lex_state = 36},
  [981] = {.lex_state = 76},
  [982] = {.lex_state = 9},
  [983] = {.lex_state = 70},
  [984] = {.lex_state = 75},
  [985] = {.lex_state = 9},
  [986] = {.lex_state = 76},
  [987] = {.lex_state = 75},
  [988] = {.lex_state = 36},
  [989] = {.lex_state = 67},
  [990] = {.lex_state = 75},
  [991] = {.lex_state = 9},
  [992] = {.lex_state = 75},
  [993] = {.lex_state = 11},
  [994] = {.lex_state = 6},
  [995] = {.lex_state = 7},
  [996] = {.lex_state = 83},
  [997] = {.lex_state = 5},
  [998] = {.lex_state = 5},
  [999] = {.lex_state = 37},
  [1000] = {.lex_state = 7},
  [1001] = {.lex_state = 7},
  [1002] = {.lex_state = 75},
  [1003] = {.lex_state = 6},
  [1004] = {.lex_state = 67},
  [1005] = {.lex_state = 8},
  [1006] = {.lex_state = 9},
  [1007] = {.lex_state = 83},
  [1008] = {.lex_state = 37},
  [1009] = {.lex_state = 83},
  [1010] = {.lex_state = 6},
  [1011] = {.lex_state = 5},
  [1012] = {.lex_state = 67},
  [1013] = {.lex_state = 67},
  [1014] = {.lex_state = 90},
  [1015] = {.lex_state = 67},
  [1016] = {.lex_state = 9},
  [1017] = {.lex_state = 8},
  [1018] = {.lex_state = 67},
  [1019] = {.lex_state = 68},
  [1020] = {.lex_state = 37},
  [1021] = {.lex_state = 90},
  [1022] = {.lex_state = 35},
  [1023] = {.lex_state = 8},
  [1024] = {.lex_state = 8},
  [1025] = {.lex_state = 114},
  [1026] = {.lex_state = 37},
  [1027] = {.lex_state = 86},
  [1028] = {.lex_state = 8},
  [1029] = {.lex_state = 91},
  [1030] = {.lex_state = 8},
  [1031] = {.lex_state = 37},
  [1032] = {.lex_state = 35},
  [1033] = {.lex_state = 70},
  [1034] = {.lex_state = 11},
  [1035] = {.lex_state = 35},
  [1036] = {.lex_state = 37},
  [1037] = {.lex_state = 37},
  [1038] = {.lex_state = 91},
  [1039] = {.lex_state = 8},
  [1040] = {.lex_state = 35},
  [1041] = {.lex_state = 35},
  [1042] = {.lex_state = 35},
  [1043] = {.lex_state = 90},
  [1044] = {.lex_state = 35},
  [1045] = {.lex_state = 37},
  [1046] = {.lex_state = 35},
  [1047] = {.lex_state = 37},
  [1048] = {.lex_state = 8},
  [1049] = {.lex_state = 37},
  [1050] = {.lex_state = 37},
  [1051] = {.lex_state = 8},
  [1052] = {.lex_state = 86},
  [1053] = {.lex_state = 8},
  [1054] = {.lex_state = 67},
  [1055] = {.lex_state = 68},
  [1056] = {.lex_state = 38},
  [1057] = {.lex_state = 70},
  [1058] = {.lex_state = 67},
  [1059] = {.lex_state = 8},
  [1060] = {.lex_state = 83},
  [1061] = {.lex_state = 69},
  [1062] = {.lex_state = 101},
  [1063] = {.lex_state = 83},
  [1064] = {.lex_state = 83},
  [1065] = {.lex_state = 8},
  [1066] = {.lex_state = 8},
  [1067] = {.lex_state = 37},
  [1068] = {.lex_state = 83},
  [1069] = {.lex_state = 67},
  [1070] = {.lex_state = 8},
  [1071] = {.lex_state = 67},
  [1072] = {.lex_state = 8},
  [1073] = {.lex_state = 37},
  [1074] = {.lex_state = 68},
  [1075] = {.lex_state = 8},
  [1076] = {.lex_state = 8},
  [1077] = {.lex_state = 83},
  [1078] = {.lex_state = 68},
  [1079] = {.lex_state = 67},
  [1080] = {.lex_state = 67},
  [1081] = {.lex_state = 40},
  [1082] = {.lex_state = 8},
  [1083] = {.lex_state = 8},
  [1084] = {.lex_state = 8},
  [1085] = {.lex_state = 8},
  [1086] = {.lex_state = 67},
  [1087] = {.lex_state = 37},
  [1088] = {.lex_state = 83},
  [1089] = {.lex_state = 37},
  [1090] = {.lex_state = 69},
  [1091] = {.lex_state = 67},
  [1092] = {.lex_state = 8},
  [1093] = {.lex_state = 83},
  [1094] = {.lex_state = 83},
  [1095] = {.lex_state = 83},
  [1096] = {.lex_state = 9},
  [1097] = {.lex_state = 69},
  [1098] = {.lex_state = 8},
  [1099] = {.lex_state = 67},
  [1100] = {.lex_state = 37},
  [1101] = {.lex_state = 67},
  [1102] = {.lex_state = 67},
  [1103] = {.lex_state = 69},
  [1104] = {.lex_state = 67},
  [1105] = {.lex_state = 83},
  [1106] = {.lex_state = 83},
  [1107] = {.lex_state = 37},
  [1108] = {.lex_state = 37},
  [1109] = {.lex_state = 83},
  [1110] = {.lex_state = 83},
  [1111] = {.lex_state = 37},
  [1112] = {.lex_state = 8},
  [1113] = {.lex_state = 67},
  [1114] = {.lex_state = 67},
  [1115] = {.lex_state = 38},
  [1116] = {.lex_state = 83},
  [1117] = {.lex_state = 83},
  [1118] = {.lex_state = 67},
  [1119] = {.lex_state = 8},
  [1120] = {.lex_state = 68},
  [1121] = {.lex_state = 67},
  [1122] = {.lex_state = 67},
  [1123] = {.lex_state = 83},
  [1124] = {.lex_state = 68},
  [1125] = {.lex_state = 9},
  [1126] = {.lex_state = 68},
  [1127] = {.lex_state = 83},
  [1128] = {.lex_state = 88},
  [1129] = {.lex_state = 37},
  [1130] = {.lex_state = 7},
  [1131] = {.lex_state = 83},
  [1132] = {.lex_state = 82},
  [1133] = {.lex_state = 82},
  [1134] = {.lex_state = 78},
  [1135] = {.lex_state = 68},
  [1136] = {.lex_state = 68},
  [1137] = {.lex_state = 68},
  [1138] = {.lex_state = 68},
  [1139] = {.lex_state = 9},
  [1140] = {.lex_state = 68},
  [1141] = {.lex_state = 83},
  [1142] = {.lex_state = 9},
  [1143] = {.lex_state = 83},
  [1144] = {.lex_state = 70},
  [1145] = {.lex_state = 70},
  [1146] = {.lex_state = 68},
  [1147] = {.lex_state = 68},
  [1148] = {.lex_state = 68},
  [1149] = {.lex_state = 83},
  [1150] = {.lex_state = 68},
  [1151] = {.lex_state = 70},
  [1152] = {.lex_state = 9},
  [1153] = {.lex_state = 83},
  [1154] = {.lex_state = 68},
  [1155] = {.lex_state = 85},
  [1156] = {.lex_state = 37},
  [1157] = {.lex_state = 68},
  [1158] = {.lex_state = 70},
  [1159] = {.lex_state = 68},
  [1160] = {.lex_state = 68},
  [1161] = {.lex_state = 88},
  [1162] = {.lex_state = 82},
  [1163] = {.lex_state = 85},
  [1164] = {.lex_state = 68},
  [1165] = {.lex_state = 37},
  [1166] = {.lex_state = 6},
  [1167] = {.lex_state = 122},
  [1168] = {.lex_state = 122},
  [1169] = {.lex_state = 83},
  [1170] = {.lex_state = 83},
  [1171] = {.lex_state = 77},
  [1172] = {.lex_state = 93},
  [1173] = {.lex_state = 83},
  [1174] = {.lex_state = 6},
  [1175] = {.lex_state = 83},
  [1176] = {.lex_state = 83},
  [1177] = {.lex_state = 83},
  [1178] = {.lex_state = 83},
  [1179] = {.lex_state = 83},
  [1180] = {.lex_state = 83},
  [1181] = {.lex_state = 83},
  [1182] = {.lex_state = 6},
  [1183] = {.lex_state = 83},
  [1184] = {.lex_state = 83},
  [1185] = {.lex_state = 83},
  [1186] = {.lex_state = 83},
  [1187] = {.lex_state = 83},
  [1188] = {.lex_state = 83},
  [1189] = {.lex_state = 6},
  [1190] = {.lex_state = 83},
  [1191] = {.lex_state = 83},
  [1192] = {.lex_state = 83},
  [1193] = {.lex_state = 83},
  [1194] = {.lex_state = 83},
  [1195] = {.lex_state = 83},
  [1196] = {.lex_state = 6},
  [1197] = {.lex_state = 83},
  [1198] = {.lex_state = 83},
  [1199] = {.lex_state = 83},
  [1200] = {.lex_state = 83},
  [1201] = {.lex_state = 83},
  [1202] = {.lex_state = 83},
  [1203] = {.lex_state = 83},
  [1204] = {.lex_state = 83},
  [1205] = {.lex_state = 83},
  [1206] = {.lex_state = 122},
  [1207] = {.lex_state = 83},
  [1208] = {.lex_state = 83},
  [1209] = {.lex_state = 83},
  [1210] = {.lex_state = 77},
  [1211] = {.lex_state = 83},
  [1212] = {.lex_state = 83},
  [1213] = {.lex_state = 83},
  [1214] = {.lex_state = 83},
  [1215] = {.lex_state = 83},
  [1216] = {.lex_state = 83},
  [1217] = {.lex_state = 83},
  [1218] = {.lex_state = 83},
  [1219] = {.lex_state = 77},
  [1220] = {.lex_state = 83},
  [1221] = {.lex_state = 83},
  [1222] = {.lex_state = 77},
  [1223] = {.lex_state = 83},
  [1224] = {.lex_state = 83},
  [1225] = {.lex_state = 83},
  [1226] = {.lex_state = 77},
  [1227] = {.lex_state = 83},
  [1228] = {.lex_state = 77},
  [1229] = {.lex_state = 83},
  [1230] = {.lex_state = 83},
  [1231] = {.lex_state = 83},
  [1232] = {.lex_state = 83},
  [1233] = {.lex_state = 83},
  [1234] = {.lex_state = 83},
  [1235] = {.lex_state = 122},
  [1236] = {.lex_state = 83},
  [1237] = {.lex_state = 83},
  [1238] = {.lex_state = 83},
  [1239] = {.lex_state = 83},
  [1240] = {.lex_state = 83},
  [1241] = {.lex_state = 83},
  [1242] = {.lex_state = 83},
  [1243] = {.lex_state = 83},
  [1244] = {.lex_state = 83},
  [1245] = {.lex_state = 83},
  [1246] = {.lex_state = 83},
  [1247] = {.lex_state = 83},
  [1248] = {.lex_state = 83},
  [1249] = {.lex_state = 83},
  [1250] = {.lex_state = 83},
  [1251] = {.lex_state = 83},
  [1252] = {.lex_state = 83},
  [1253] = {.lex_state = 93},
  [1254] = {.lex_state = 31},
  [1255] = {.lex_state = 77},
  [1256] = {.lex_state = 7},
  [1257] = {.lex_state = 83},
  [1258] = {.lex_state = 83},
  [1259] = {.lex_state = 83},
  [1260] = {.lex_state = 83},
  [1261] = {.lex_state = 39},
  [1262] = {.lex_state = 83},
  [1263] = {.lex_state = 77},
  [1264] = {.lex_state = 83},
  [1265] = {.lex_state = 31},
  [1266] = {.lex_state = 83},
  [1267] = {.lex_state = 83},
  [1268] = {.lex_state = 83},
  [1269] = {.lex_state = 83},
  [1270] = {.lex_state = 83},
  [1271] = {.lex_state = 83},
  [1272] = {.lex_state = 83},
  [1273] = {.lex_state = 89},
  [1274] = {.lex_state = 83},
  [1275] = {.lex_state = 83},
  [1276] = {.lex_state = 83},
  [1277] = {.lex_state = 77},
  [1278] = {.lex_state = 31},
  [1279] = {.lex_state = 113},
  [1280] = {.lex_state = 5},
  [1281] = {.lex_state = 77},
  [1282] = {.lex_state = 5},
  [1283] = {.lex_state = 87},
  [1284] = {.lex_state = 7},
  [1285] = {.lex_state = 7},
  [1286] = {.lex_state = 7},
  [1287] = {.lex_state = 5},
  [1288] = {.lex_state = 5},
  [1289] = {.lex_state = 115},
  [1290] = {.lex_state = 7},
  [1291] = {.lex_state = 110},
  [1292] = {.lex_state = 110},
  [1293] = {.lex_state = 110},
  [1294] = {.lex_state = 110},
  [1295] = {.lex_state = 69},
  [1296] = {.lex_state = 97},
  [1297] = {.lex_state = 110},
  [1298] = {.lex_state = 38},
  [1299] = {.lex_state = 110},
  [1300] = {.lex_state = 86},
  [1301] = {.lex_state = 70},
  [1302] = {.lex_state = 88},
  [1303] = {.lex_state = 110},
  [1304] = {.lex_state = 97},
  [1305] = {.lex_state = 9},
  [1306] = {.lex_state = 114},
  [1307] = {.lex_state = 74},
  [1308] = {.lex_state = 38},
  [1309] = {.lex_state = 70},
  [1310] = {.lex_state = 114},
  [1311] = {.lex_state = 110},
  [1312] = {.lex_state = 110},
  [1313] = {.lex_state = 73},
  [1314] = {.lex_state = 92},
  [1315] = {.lex_state = 110},
  [1316] = {.lex_state = 86},
  [1317] = {.lex_state = 114},
  [1318] = {.lex_state = 110},
  [1319] = {.lex_state = 86},
  [1320] = {.lex_state = 12},
  [1321] = {.lex_state = 114},
  [1322] = {.lex_state = 110},
  [1323] = {.lex_state = 110},
  [1324] = {.lex_state = 110},
  [1325] = {.lex_state = 69},
  [1326] = {.lex_state = 91},
  [1327] = {.lex_state = 91},
  [1328] = {.lex_state = 80},
  [1329] = {.lex_state = 91},
  [1330] = {.lex_state = 94},
  [1331] = {.lex_state = 70},
  [1332] = {.lex_state = 69},
  [1333] = {.lex_state = 33},
  [1334] = {.lex_state = 9},
  [1335] = {.lex_state = 33},
  [1336] = {.lex_state = 12},
  [1337] = {.lex_state = 7},
  [1338] = {.lex_state = 12},
  [1339] = {.lex_state = 69},
  [1340] = {.lex_state = 69},
  [1341] = {.lex_state = 91},
  [1342] = {.lex_state = 33},
  [1343] = {.lex_state = 74},
  [1344] = {.lex_state = 80},
  [1345] = {.lex_state = 73},
  [1346] = {.lex_state = 73},
  [1347] = {.lex_state = 95},
  [1348] = {.lex_state = 74},
  [1349] = {.lex_state = 80},
  [1350] = {.lex_state = 95},
  [1351] = {.lex_state = 111},
  [1352] = {.lex_state = 111},
  [1353] = {.lex_state = 81},
  [1354] = {.lex_state = 111},
  [1355] = {.lex_state = 7},
  [1356] = {.lex_state = 55},
  [1357] = {.lex_state = 111},
  [1358] = {.lex_state = 6},
  [1359] = {.lex_state = 111},
  [1360] = {.lex_state = 70},
  [1361] = {.lex_state = 111},
  [1362] = {.lex_state = 69},
  [1363] = {.lex_state = 69},
  [1364] = {.lex_state = 111},
  [1365] = {.lex_state = 111},
  [1366] = {.lex_state = 69},
  [1367] = {.lex_state = 69},
  [1368] = {.lex_state = 111},
  [1369] = {.lex_state = 111},
  [1370] = {.lex_state = 70},
  [1371] = {.lex_state = 5},
  [1372] = {.lex_state = 111},
  [1373] = {.lex_state = 43},
  [1374] = {.lex_state = 111},
  [1375] = {.lex_state = 111},
  [1376] = {.lex_state = 69},
  [1377] = {.lex_state = 111},
  [1378] = {.lex_state = 69},
  [1379] = {.lex_state = 111},
  [1380] = {.lex_state = 69},
  [1381] = {.lex_state = 43},
  [1382] = {.lex_state = 111},
  [1383] = {.lex_state = 111},
  [1384] = {.lex_state = 84},
  [1385] = {.lex_state = 111},
  [1386] = {.lex_state = 111},
  [1387] = {.lex_state = 111},
  [1388] = {.lex_state = 69},
  [1389] = {.lex_state = 111},
  [1390] = {.lex_state = 111},
  [1391] = {.lex_state = 69},
  [1392] = {.lex_state = 111},
  [1393] = {.lex_state = 70},
  [1394] = {.lex_state = 9},
  [1395] = {.lex_state = 7},
  [1396] = {.lex_state = 111},
  [1397] = {.lex_state = 69},
  [1398] = {.lex_state = 111},
  [1399] = {.lex_state = 111},
  [1400] = {.lex_state = 111},
  [1401] = {.lex_state = 111},
  [1402] = {.lex_state = 111},
  [1403] = {.lex_state = 9},
  [1404] = {.lex_state = 69},
  [1405] = {.lex_state = 69},
  [1406] = {.lex_state = 81},
  [1407] = {.lex_state = 111},
  [1408] = {.lex_state = 70},
  [1409] = {.lex_state = 111},
  [1410] = {.lex_state = 98},
  [1411] = {.lex_state = 70},
  [1412] = {.lex_state = 111},
  [1413] = {.lex_state = 69},
  [1414] = {.lex_state = 105},
  [1415] = {.lex_state = 111},
  [1416] = {.lex_state = 93},
  [1417] = {.lex_state = 111},
  [1418] = {.lex_state = 96},
  [1419] = {.lex_state = 55},
  [1420] = {.lex_state = 99},
  [1421] = {.lex_state = 111},
  [1422] = {.lex_state = 111},
  [1423] = {.lex_state = 111},
  [1424] = {.lex_state = 111},
  [1425] = {.lex_state = 111},
  [1426] = {.lex_state = 69},
  [1427] = {.lex_state = 105},
  [1428] = {.lex_state = 99},
  [1429] = {.lex_state = 55},
  [1430] = {.lex_state = 70},
  [1431] = {.lex_state = 111},
  [1432] = {.lex_state = 111},
  [1433] = {.lex_state = 111},
  [1434] = {.lex_state = 93},
  [1435] = {.lex_state = 111},
  [1436] = {.lex_state = 84},
  [1437] = {.lex_state = 111},
  [1438] = {.lex_state = 111},
  [1439] = {.lex_state = 111},
  [1440] = {.lex_state = 9},
  [1441] = {.lex_state = 55},
  [1442] = {.lex_state = 70},
  [1443] = {.lex_state = 111},
  [1444] = {.lex_state = 106},
  [1445] = {.lex_state = 111},
  [1446] = {.lex_state = 55},
  [1447] = {.lex_state = 111},
  [1448] = {.lex_state = 111},
  [1449] = {.lex_state = 106},
  [1450] = {.lex_state = 9},
  [1451] = {.lex_state = 9},
  [1452] = {.lex_state = 81},
  [1453] = {.lex_state = 111},
  [1454] = {.lex_state = 111},
  [1455] = {.lex_state = 55},
  [1456] = {.lex_state = 111},
  [1457] = {.lex_state = 70},
  [1458] = {.lex_state = 111},
  [1459] = {.lex_state = 111},
  [1460] = {.lex_state = 84},
  [1461] = {.lex_state = 69},
  [1462] = {.lex_state = 111},
  [1463] = {.lex_state = 111},
  [1464] = {.lex_state = 111},
  [1465] = {.lex_state = 111},
  [1466] = {.lex_state = 111},
  [1467] = {.lex_state = 9},
  [1468] = {.lex_state = 111},
  [1469] = {.lex_state = 69},
  [1470] = {.lex_state = 9},
  [1471] = {.lex_state = 9},
  [1472] = {.lex_state = 111},
  [1473] = {.lex_state = 9},
  [1474] = {.lex_state = 5},
  [1475] = {.lex_state = 7},
  [1476] = {.lex_state = 70},
  [1477] = {.lex_state = 9},
  [1478] = {.lex_state = 9},
  [1479] = {.lex_state = 9},
  [1480] = {.lex_state = 9},
  [1481] = {.lex_state = 9},
  [1482] = {.lex_state = 9},
  [1483] = {.lex_state = 70},
  [1484] = {.lex_state = 95},
  [1485] = {.lex_state = 9},
  [1486] = {.lex_state = 7},
  [1487] = {.lex_state = 70},
  [1488] = {.lex_state = 30},
  [1489] = {.lex_state = 9},
  [1490] = {.lex_state = 7},
  [1491] = {.lex_state = 30},
  [1492] = {.lex_state = 5},
  [1493] = {.lex_state = 5},
  [1494] = {.lex_state = 97},
  [1495] = {.lex_state = 70},
  [1496] = {.lex_state = 100},
  [1497] = {.lex_state = 9},
  [1498] = {.lex_state = 9},
  [1499] = {.lex_state = 6},
  [1500] = {.lex_state = 70},
  [1501] = {.lex_state = 7},
  [1502] = {.lex_state = 70},
  [1503] = {.lex_state = 30},
  [1504] = {.lex_state = 70},
  [1505] = {.lex_state = 70},
  [1506] = {.lex_state = 6},
  [1507] = {.lex_state = 97},
  [1508] = {.lex_state = 70},
  [1509] = {.lex_state = 70},
  [1510] = {.lex_state = 30},
  [1511] = {.lex_state = 6},
  [1512] = {.lex_state = 9},
  [1513] = {.lex_state = 70},
  [1514] = {.lex_state = 6},
  [1515] = {.lex_state = 70},
  [1516] = {.lex_state = 9},
  [1517] = {.lex_state = 32},
  [1518] = {.lex_state = 70},
  [1519] = {.lex_state = 9},
  [1520] = {.lex_state = 7},
  [1521] = {.lex_state = 9},
  [1522] = {.lex_state = 70},
  [1523] = {.lex_state = 30},
  [1524] = {.lex_state = 30},
  [1525] = {.lex_state = 5},
  [1526] = {.lex_state = 7},
  [1527] = {.lex_state = 6},
  [1528] = {.lex_state = 6},
  [1529] = {.lex_state = 6},
  [1530] = {.lex_state = 7},
  [1531] = {.lex_state = 6},
  [1532] = {.lex_state = 6},
  [1533] = {.lex_state = 7},
  [1534] = {.lex_state = 7},
  [1535] = {.lex_state = 7},
  [1536] = {.lex_state = 7},
  [1537] = {.lex_state = 5},
  [1538] = {.lex_state = 6},
  [1539] = {.lex_state = 5},
  [1540] = {.lex_state = 5},
  [1541] = {.lex_state = 5},
  [1542] = {.lex_state = 7},
  [1543] = {.lex_state = 6},
  [1544] = {.lex_state = 5},
  [1545] = {.lex_state = 6},
  [1546] = {.lex_state = 6},
  [1547] = {.lex_state = 5},
  [1548] = {.lex_state = 6},
  [1549] = {.lex_state = 6},
  [1550] = {.lex_state = 6},
  [1551] = {.lex_state = 6},
  [1552] = {.lex_state = 5},
  [1553] = {.lex_state = 7},
  [1554] = {.lex_state = 99},
  [1555] = {.lex_state = 6},
  [1556] = {.lex_state = 5},
  [1557] = {.lex_state = 5},
  [1558] = {.lex_state = 5},
  [1559] = {.lex_state = 5},
  [1560] = {.lex_state = 5},
  [1561] = {.lex_state = 7},
  [1562] = {.lex_state = 6},
  [1563] = {.lex_state = 34},
  [1564] = {.lex_state = 6},
  [1565] = {.lex_state = 5},
  [1566] = {.lex_state = 7},
  [1567] = {.lex_state = 6},
  [1568] = {.lex_state = 7},
  [1569] = {.lex_state = 7},
  [1570] = {.lex_state = 7},
  [1571] = {.lex_state = 5},
  [1572] = {.lex_state = 7},
  [1573] = {.lex_state = 7},
  [1574] = {.lex_state = 7},
  [1575] = {.lex_state = 7},
  [1576] = {.lex_state = 5},
  [1577] = {.lex_state = 5},
  [1578] = {.lex_state = 6},
  [1579] = {.lex_state = 75},
  [1580] = {.lex_state = 106},
  [1581] = {.lex_state = 75},
  [1582] = {.lex_state = 6},
  [1583] = {.lex_state = 37},
  [1584] = {.lex_state = 106},
  [1585] = {.lex_state = 43},
  [1586] = {.lex_state = 43},
  [1587] = {.lex_state = 75},
  [1588] = {.lex_state = 43},
  [1589] = {.lex_state = 106},
  [1590] = {.lex_state = 106},
  [1591] = {.lex_state = 75},
  [1592] = {.lex_state = 75},
  [1593] = {.lex_state = 75},
  [1594] = {.lex_state = 43},
  [1595] = {.lex_state = 105},
  [1596] = {.lex_state = 105},
  [1597] = {.lex_state = 37},
  [1598] = {.lex_state = 6},
  [1599] = {.lex_state = 37},
  [1600] = {.lex_state = 37},
  [1601] = {.lex_state = 105},
  [1602] = {.lex_state = 37},
  [1603] = {.lex_state = 106},
  [1604] = {.lex_state = 37},
  [1605] = {.lex_state = 105},
  [1606] = {.lex_state = 105},
  [1607] = {.lex_state = 43},
  [1608] = {.lex_state = 136},
  [1609] = {.lex_state = 136},
  [1610] = {.lex_state = 136},
  [1611] = {.lex_state = 8},
  [1612] = {.lex_state = 8},
  [1613] = {.lex_state = 83},
  [1614] = {.lex_state = 23},
  [1615] = {.lex_state = 136},
  [1616] = {.lex_state = 23},
  [1617] = {.lex_state = 23},
  [1618] = {.lex_state = 136},
  [1619] = {.lex_state = 6},
  [1620] = {.lex_state = 23},
  [1621] = {.lex_state = 136},
  [1622] = {.lex_state = 23},
  [1623] = {.lex_state = 136},
  [1624] = {.lex_state = 136},
  [1625] = {.lex_state = 23},
  [1626] = {.lex_state = 20},
  [1627] = {.lex_state = 20},
  [1628] = {.lex_state = 20},
  [1629] = {.lex_state = 23},
  [1630] = {.lex_state = 23},
  [1631] = {.lex_state = 23},
  [1632] = {.lex_state = 23},
  [1633] = {.lex_state = 9},
  [1634] = {.lex_state = 9},
  [1635] = {.lex_state = 23},
  [1636] = {.lex_state = 20},
  [1637] = {.lex_state = 20},
  [1638] = {.lex_state = 23},
  [1639] = {.lex_state = 23},
  [1640] = {.lex_state = 52},
  [1641] = {.lex_state = 52},
  [1642] = {.lex_state = 23},
  [1643] = {.lex_state = 23},
  [1644] = {.lex_state = 23},
  [1645] = {.lex_state = 23},
  [1646] = {.lex_state = 23},
  [1647] = {.lex_state = 23},
  [1648] = {.lex_state = 23},
  [1649] = {.lex_state = 23},
  [1650] = {.lex_state = 23},
  [1651] = {.lex_state = 141},
  [1652] = {.lex_state = 23},
  [1653] = {.lex_state = 23},
  [1654] = {.lex_state = 27},
  [1655] = {.lex_state = 23},
  [1656] = {.lex_state = 23},
  [1657] = {.lex_state = 23},
  [1658] = {.lex_state = 27},
  [1659] = {.lex_state = 23},
  [1660] = {.lex_state = 23},
  [1661] = {.lex_state = 20},
  [1662] = {.lex_state = 23},
  [1663] = {.lex_state = 142},
  [1664] = {.lex_state = 27},
  [1665] = {.lex_state = 27},
  [1666] = {.lex_state = 20},
  [1667] = {.lex_state = 144},
  [1668] = {.lex_state = 27},
  [1669] = {.lex_state = 144},
  [1670] = {.lex_state = 20},
  [1671] = {.lex_state = 20},
  [1672] = {.lex_state = 144},
  [1673] = {.lex_state = 20},
  [1674] = {.lex_state = 24},
  [1675] = {.lex_state = 51},
  [1676] = {.lex_state = 158},
  [1677] = {.lex_state = 158},
  [1678] = {.lex_state = 141},
  [1679] = {.lex_state = 159},
  [1680] = {.lex_state = 24},
  [1681] = {.lex_state = 159},
  [1682] = {.lex_state = 70},
  [1683] = {.lex_state = 24},
  [1684] = {.lex_state = 24},
  [1685] = {.lex_state = 24},
  [1686] = {.lex_state = 159},
  [1687] = {.lex_state = 24},
  [1688] = {.lex_state = 159},
  [1689] = {.lex_state = 24},
  [1690] = {.lex_state = 24},
  [1691] = {.lex_state = 24},
  [1692] = {.lex_state = 141},
  [1693] = {.lex_state = 24},
  [1694] = {.lex_state = 159},
  [1695] = {.lex_state = 159},
  [1696] = {.lex_state = 159},
  [1697] = {.lex_state = 159},
  [1698] = {.lex_state = 159},
  [1699] = {.lex_state = 158},
  [1700] = {.lex_state = 158},
  [1701] = {.lex_state = 159},
  [1702] = {.lex_state = 159},
  [1703] = {.lex_state = 70},
  [1704] = {.lex_state = 18},
  [1705] = {.lex_state = 158},
  [1706] = {.lex_state = 158},
  [1707] = {.lex_state = 159},
  [1708] = {.lex_state = 158},
  [1709] = {.lex_state = 18},
  [1710] = {.lex_state = 159},
  [1711] = {.lex_state = 158},
  [1712] = {.lex_state = 158},
  [1713] = {.lex_state = 159},
  [1714] = {.lex_state = 159},
  [1715] = {.lex_state = 158},
  [1716] = {.lex_state = 158},
  [1717] = {.lex_state = 159},
  [1718] = {.lex_state = 159},
  [1719] = {.lex_state = 158},
  [1720] = {.lex_state = 158},
  [1721] = {.lex_state = 159},
  [1722] = {.lex_state = 159},
  [1723] = {.lex_state = 158},
  [1724] = {.lex_state = 158},
  [1725] = {.lex_state = 159},
  [1726] = {.lex_state = 159},
  [1727] = {.lex_state = 158},
  [1728] = {.lex_state = 158},
  [1729] = {.lex_state = 159},
  [1730] = {.lex_state = 159},
  [1731] = {.lex_state = 158},
  [1732] = {.lex_state = 158},
  [1733] = {.lex_state = 159},
  [1734] = {.lex_state = 159},
  [1735] = {.lex_state = 158},
  [1736] = {.lex_state = 1},
  [1737] = {.lex_state = 158},
  [1738] = {.lex_state = 159},
  [1739] = {.lex_state = 159},
  [1740] = {.lex_state = 158},
  [1741] = {.lex_state = 158},
  [1742] = {.lex_state = 159},
  [1743] = {.lex_state = 159},
  [1744] = {.lex_state = 158},
  [1745] = {.lex_state = 158},
  [1746] = {.lex_state = 159},
  [1747] = {.lex_state = 159},
  [1748] = {.lex_state = 158},
  [1749] = {.lex_state = 158},
  [1750] = {.lex_state = 159},
  [1751] = {.lex_state = 159},
  [1752] = {.lex_state = 158},
  [1753] = {.lex_state = 158},
  [1754] = {.lex_state = 159},
  [1755] = {.lex_state = 159},
  [1756] = {.lex_state = 158},
  [1757] = {.lex_state = 1},
  [1758] = {.lex_state = 158},
  [1759] = {.lex_state = 159},
  [1760] = {.lex_state = 159},
  [1761] = {.lex_state = 158},
  [1762] = {.lex_state = 70},
  [1763] = {.lex_state = 158},
  [1764] = {.lex_state = 159},
  [1765] = {.lex_state = 24},
  [1766] = {.lex_state = 159},
  [1767] = {.lex_state = 51},
  [1768] = {.lex_state = 158},
  [1769] = {.lex_state = 158},
  [1770] = {.lex_state = 159},
  [1771] = {.lex_state = 159},
  [1772] = {.lex_state = 158},
  [1773] = {.lex_state = 158},
  [1774] = {.lex_state = 159},
  [1775] = {.lex_state = 159},
  [1776] = {.lex_state = 158},
  [1777] = {.lex_state = 158},
  [1778] = {.lex_state = 159},
  [1779] = {.lex_state = 159},
  [1780] = {.lex_state = 158},
  [1781] = {.lex_state = 24},
  [1782] = {.lex_state = 158},
  [1783] = {.lex_state = 159},
  [1784] = {.lex_state = 159},
  [1785] = {.lex_state = 24},
  [1786] = {.lex_state = 24},
  [1787] = {.lex_state = 158},
  [1788] = {.lex_state = 158},
  [1789] = {.lex_state = 24},
  [1790] = {.lex_state = 159},
  [1791] = {.lex_state = 159},
  [1792] = {.lex_state = 158},
  [1793] = {.lex_state = 51},
  [1794] = {.lex_state = 158},
  [1795] = {.lex_state = 159},
  [1796] = {.lex_state = 158},
  [1797] = {.lex_state = 159},
  [1798] = {.lex_state = 158},
  [1799] = {.lex_state = 158},
  [1800] = {.lex_state = 158},
  [1801] = {.lex_state = 159},
  [1802] = {.lex_state = 159},
  [1803] = {.lex_state = 24},
  [1804] = {.lex_state = 158},
  [1805] = {.lex_state = 18},
  [1806] = {.lex_state = 158},
  [1807] = {.lex_state = 159},
  [1808] = {.lex_state = 159},
  [1809] = {.lex_state = 158},
  [1810] = {.lex_state = 158},
  [1811] = {.lex_state = 159},
  [1812] = {.lex_state = 159},
  [1813] = {.lex_state = 158},
  [1814] = {.lex_state = 158},
  [1815] = {.lex_state = 24},
  [1816] = {.lex_state = 159},
  [1817] = {.lex_state = 24},
  [1818] = {.lex_state = 24},
  [1819] = {.lex_state = 159},
  [1820] = {.lex_state = 24},
  [1821] = {.lex_state = 24},
  [1822] = {.lex_state = 158},
  [1823] = {.lex_state = 159},
  [1824] = {.lex_state = 24},
  [1825] = {.lex_state = 24},
  [1826] = {.lex_state = 158},
  [1827] = {.lex_state = 159},
  [1828] = {.lex_state = 24},
  [1829] = {.lex_state = 24},
  [1830] = {.lex_state = 24},
  [1831] = {.lex_state = 159},
  [1832] = {.lex_state = 159},
  [1833] = {.lex_state = 159},
  [1834] = {.lex_state = 158},
  [1835] = {.lex_state = 158},
  [1836] = {.lex_state = 158},
  [1837] = {.lex_state = 24},
  [1838] = {.lex_state = 101},
  [1839] = {.lex_state = 0},
  [1840] = {.lex_state = 101},
  [1841] = {.lex_state = 20},
  [1842] = {.lex_state = 0},
  [1843] = {.lex_state = 0},
  [1844] = {.lex_state = 101},
  [1845] = {.lex_state = 0},
  [1846] = {.lex_state = 0},
  [1847] = {.lex_state = 20},
  [1848] = {.lex_state = 1},
  [1849] = {.lex_state = 101},
  [1850] = {.lex_state = 101},
  [1851] = {.lex_state = 20},
  [1852] = {.lex_state = 1},
  [1853] = {.lex_state = 144},
  [1854] = {.lex_state = 20},
  [1855] = {.lex_state = 101},
  [1856] = {.lex_state = 20},
  [1857] = {.lex_state = 0},
  [1858] = {.lex_state = 144},
  [1859] = {.lex_state = 20},
  [1860] = {.lex_state = 150},
  [1861] = {.lex_state = 151},
  [1862] = {.lex_state = 151},
  [1863] = {.lex_state = 0},
  [1864] = {.lex_state = 415},
  [1865] = {.lex_state = 27},
  [1866] = {.lex_state = 24},
  [1867] = {.lex_state = 0},
  [1868] = {.lex_state = 150},
  [1869] = {.lex_state = 150},
  [1870] = {.lex_state = 150},
  [1871] = {.lex_state = 151},
  [1872] = {.lex_state = 151},
  [1873] = {.lex_state = 150},
  [1874] = {.lex_state = 160},
  [1875] = {.lex_state = 150},
  [1876] = {.lex_state = 27},
  [1877] = {.lex_state = 151},
  [1878] = {.lex_state = 151},
  [1879] = {.lex_state = 150},
  [1880] = {.lex_state = 150},
  [1881] = {.lex_state = 101},
  [1882] = {.lex_state = 150},
  [1883] = {.lex_state = 161},
  [1884] = {.lex_state = 150},
  [1885] = {.lex_state = 151},
  [1886] = {.lex_state = 160},
  [1887] = {.lex_state = 151},
  [1888] = {.lex_state = 150},
  [1889] = {.lex_state = 161},
  [1890] = {.lex_state = 151},
  [1891] = {.lex_state = 151},
  [1892] = {.lex_state = 151},
  [1893] = {.lex_state = 415},
  [1894] = {.lex_state = 150},
  [1895] = {.lex_state = 151},
  [1896] = {.lex_state = 151},
  [1897] = {.lex_state = 150},
  [1898] = {.lex_state = 20},
  [1899] = {.lex_state = 150},
  [1900] = {.lex_state = 161},
  [1901] = {.lex_state = 150},
  [1902] = {.lex_state = 415},
  [1903] = {.lex_state = 415},
  [1904] = {.lex_state = 150},
  [1905] = {.lex_state = 151},
  [1906] = {.lex_state = 151},
  [1907] = {.lex_state = 150},
  [1908] = {.lex_state = 151},
  [1909] = {.lex_state = 150},
  [1910] = {.lex_state = 160},
  [1911] = {.lex_state = 151},
  [1912] = {.lex_state = 151},
  [1913] = {.lex_state = 150},
  [1914] = {.lex_state = 64},
  [1915] = {.lex_state = 101},
  [1916] = {.lex_state = 151},
  [1917] = {.lex_state = 0},
  [1918] = {.lex_state = 144},
  [1919] = {.lex_state = 150},
  [1920] = {.lex_state = 150},
  [1921] = {.lex_state = 151},
  [1922] = {.lex_state = 151},
  [1923] = {.lex_state = 150},
  [1924] = {.lex_state = 150},
  [1925] = {.lex_state = 150},
  [1926] = {.lex_state = 415},
  [1927] = {.lex_state = 151},
  [1928] = {.lex_state = 151},
  [1929] = {.lex_state = 150},
  [1930] = {.lex_state = 151},
  [1931] = {.lex_state = 150},
  [1932] = {.lex_state = 151},
  [1933] = {.lex_state = 160},
  [1934] = {.lex_state = 151},
  [1935] = {.lex_state = 151},
  [1936] = {.lex_state = 150},
  [1937] = {.lex_state = 64},
  [1938] = {.lex_state = 161},
  [1939] = {.lex_state = 150},
  [1940] = {.lex_state = 150},
  [1941] = {.lex_state = 151},
  [1942] = {.lex_state = 151},
  [1943] = {.lex_state = 150},
  [1944] = {.lex_state = 0},
  [1945] = {.lex_state = 27},
  [1946] = {.lex_state = 150},
  [1947] = {.lex_state = 150},
  [1948] = {.lex_state = 150},
  [1949] = {.lex_state = 151},
  [1950] = {.lex_state = 150},
  [1951] = {.lex_state = 151},
  [1952] = {.lex_state = 101},
  [1953] = {.lex_state = 150},
  [1954] = {.lex_state = 151},
  [1955] = {.lex_state = 161},
  [1956] = {.lex_state = 160},
  [1957] = {.lex_state = 150},
  [1958] = {.lex_state = 151},
  [1959] = {.lex_state = 151},
  [1960] = {.lex_state = 151},
  [1961] = {.lex_state = 150},
  [1962] = {.lex_state = 150},
  [1963] = {.lex_state = 150},
  [1964] = {.lex_state = 151},
  [1965] = {.lex_state = 150},
  [1966] = {.lex_state = 151},
  [1967] = {.lex_state = 0},
  [1968] = {.lex_state = 151},
  [1969] = {.lex_state = 150},
  [1970] = {.lex_state = 151},
  [1971] = {.lex_state = 150},
  [1972] = {.lex_state = 151},
  [1973] = {.lex_state = 151},
  [1974] = {.lex_state = 151},
  [1975] = {.lex_state = 150},
  [1976] = {.lex_state = 150},
  [1977] = {.lex_state = 64},
  [1978] = {.lex_state = 150},
  [1979] = {.lex_state = 150},
  [1980] = {.lex_state = 150},
  [1981] = {.lex_state = 150},
  [1982] = {.lex_state = 151},
  [1983] = {.lex_state = 151},
  [1984] = {.lex_state = 151},
  [1985] = {.lex_state = 150},
  [1986] = {.lex_state = 161},
  [1987] = {.lex_state = 160},
  [1988] = {.lex_state = 24},
  [1989] = {.lex_state = 151},
  [1990] = {.lex_state = 150},
  [1991] = {.lex_state = 150},
  [1992] = {.lex_state = 151},
  [1993] = {.lex_state = 151},
  [1994] = {.lex_state = 151},
  [1995] = {.lex_state = 150},
  [1996] = {.lex_state = 151},
  [1997] = {.lex_state = 150},
  [1998] = {.lex_state = 150},
  [1999] = {.lex_state = 0},
  [2000] = {.lex_state = 151},
  [2001] = {.lex_state = 151},
  [2002] = {.lex_state = 150},
  [2003] = {.lex_state = 415},
  [2004] = {.lex_state = 150},
  [2005] = {.lex_state = 161},
  [2006] = {.lex_state = 24},
  [2007] = {.lex_state = 151},
  [2008] = {.lex_state = 160},
  [2009] = {.lex_state = 151},
  [2010] = {.lex_state = 151},
  [2011] = {.lex_state = 150},
  [2012] = {.lex_state = 150},
  [2013] = {.lex_state = 151},
  [2014] = {.lex_state = 150},
  [2015] = {.lex_state = 151},
  [2016] = {.lex_state = 0},
  [2017] = {.lex_state = 415},
  [2018] = {.lex_state = 63},
  [2019] = {.lex_state = 63},
  [2020] = {.lex_state = 63},
  [2021] = {.lex_state = 76},
  [2022] = {.lex_state = 63},
  [2023] = {.lex_state = 63},
  [2024] = {.lex_state = 63},
  [2025] = {.lex_state = 63},
  [2026] = {.lex_state = 63},
  [2027] = {.lex_state = 147},
  [2028] = {.lex_state = 63},
  [2029] = {.lex_state = 63},
  [2030] = {.lex_state = 24},
  [2031] = {.lex_state = 63},
  [2032] = {.lex_state = 63},
  [2033] = {.lex_state = 63},
  [2034] = {.lex_state = 63},
  [2035] = {.lex_state = 63},
  [2036] = {.lex_state = 63},
  [2037] = {.lex_state = 63},
  [2038] = {.lex_state = 63},
  [2039] = {.lex_state = 158},
  [2040] = {.lex_state = 63},
  [2041] = {.lex_state = 63},
  [2042] = {.lex_state = 63},
  [2043] = {.lex_state = 63},
  [2044] = {.lex_state = 63},
  [2045] = {.lex_state = 63},
  [2046] = {.lex_state = 63},
  [2047] = {.lex_state = 63},
  [2048] = {.lex_state = 63},
  [2049] = {.lex_state = 63},
  [2050] = {.lex_state = 63},
  [2051] = {.lex_state = 144},
  [2052] = {.lex_state = 63},
  [2053] = {.lex_state = 63},
  [2054] = {.lex_state = 63},
  [2055] = {.lex_state = 63},
  [2056] = {.lex_state = 63},
  [2057] = {.lex_state = 63},
  [2058] = {.lex_state = 63},
  [2059] = {.lex_state = 63},
  [2060] = {.lex_state = 63},
  [2061] = {.lex_state = 63},
  [2062] = {.lex_state = 147},
  [2063] = {.lex_state = 0},
  [2064] = {.lex_state = 63},
  [2065] = {.lex_state = 415},
  [2066] = {.lex_state = 147},
  [2067] = {.lex_state = 63},
  [2068] = {.lex_state = 63},
  [2069] = {.lex_state = 63},
  [2070] = {.lex_state = 0},
  [2071] = {.lex_state = 63},
  [2072] = {.lex_state = 22},
  [2073] = {.lex_state = 63},
  [2074] = {.lex_state = 63},
  [2075] = {.lex_state = 63},
  [2076] = {.lex_state = 63},
  [2077] = {.lex_state = 76},
  [2078] = {.lex_state = 63},
  [2079] = {.lex_state = 64},
  [2080] = {.lex_state = 63},
  [2081] = {.lex_state = 64},
  [2082] = {.lex_state = 159},
  [2083] = {.lex_state = 158},
  [2084] = {.lex_state = 63},
  [2085] = {.lex_state = 63},
  [2086] = {.lex_state = 63},
  [2087] = {.lex_state = 63},
  [2088] = {.lex_state = 63},
  [2089] = {.lex_state = 63},
  [2090] = {.lex_state = 63},
  [2091] = {.lex_state = 158},
  [2092] = {.lex_state = 63},
  [2093] = {.lex_state = 63},
  [2094] = {.lex_state = 159},
  [2095] = {.lex_state = 63},
  [2096] = {.lex_state = 63},
  [2097] = {.lex_state = 63},
  [2098] = {.lex_state = 63},
  [2099] = {.lex_state = 159},
  [2100] = {.lex_state = 63},
  [2101] = {.lex_state = 159},
  [2102] = {.lex_state = 63},
  [2103] = {.lex_state = 158},
  [2104] = {.lex_state = 22},
  [2105] = {.lex_state = 23},
  [2106] = {.lex_state = 27},
  [2107] = {.lex_state = 22},
  [2108] = {.lex_state = 27},
  [2109] = {.lex_state = 161},
  [2110] = {.lex_state = 24},
  [2111] = {.lex_state = 28},
  [2112] = {.lex_state = 22},
  [2113] = {.lex_state = 151},
  [2114] = {.lex_state = 63},
  [2115] = {.lex_state = 28},
  [2116] = {.lex_state = 63},
  [2117] = {.lex_state = 63},
  [2118] = {.lex_state = 151},
  [2119] = {.lex_state = 28},
  [2120] = {.lex_state = 0},
  [2121] = {.lex_state = 24},
  [2122] = {.lex_state = 24},
  [2123] = {.lex_state = 27},
  [2124] = {.lex_state = 23},
  [2125] = {.lex_state = 20},
  [2126] = {.lex_state = 22},
  [2127] = {.lex_state = 24},
  [2128] = {.lex_state = 24},
  [2129] = {.lex_state = 0},
  [2130] = {.lex_state = 63},
  [2131] = {.lex_state = 24},
  [2132] = {.lex_state = 23},
  [2133] = {.lex_state = 63},
  [2134] = {.lex_state = 20},
  [2135] = {.lex_state = 27},
  [2136] = {.lex_state = 28},
  [2137] = {.lex_state = 101},
  [2138] = {.lex_state = 28},
  [2139] = {.lex_state = 63},
  [2140] = {.lex_state = 0},
  [2141] = {.lex_state = 0},
  [2142] = {.lex_state = 63},
  [2143] = {.lex_state = 63},
  [2144] = {.lex_state = 22},
  [2145] = {.lex_state = 415},
  [2146] = {.lex_state = 24},
  [2147] = {.lex_state = 63},
  [2148] = {.lex_state = 63},
  [2149] = {.lex_state = 20},
  [2150] = {.lex_state = 415},
  [2151] = {.lex_state = 28},
  [2152] = {.lex_state = 20},
  [2153] = {.lex_state = 22},
  [2154] = {.lex_state = 63},
  [2155] = {.lex_state = 63},
  [2156] = {.lex_state = 24},
  [2157] = {.lex_state = 415, .external_lex_state = 3},
  [2158] = {.lex_state = 20},
  [2159] = {.lex_state = 22},
  [2160] = {.lex_state = 27},
  [2161] = {.lex_state = 22},
  [2162] = {.lex_state = 150},
  [2163] = {.lex_state = 101},
  [2164] = {.lex_state = 150},
  [2165] = {.lex_state = 28},
  [2166] = {.lex_state = 64},
  [2167] = {.lex_state = 28},
  [2168] = {.lex_state = 27},
  [2169] = {.lex_state = 20},
  [2170] = {.lex_state = 160},
  [2171] = {.lex_state = 63},
  [2172] = {.lex_state = 23},
  [2173] = {.lex_state = 23},
  [2174] = {.lex_state = 23},
  [2175] = {.lex_state = 23},
  [2176] = {.lex_state = 415},
  [2177] = {.lex_state = 23},
  [2178] = {.lex_state = 51},
  [2179] = {.lex_state = 63},
  [2180] = {.lex_state = 23},
  [2181] = {.lex_state = 23},
  [2182] = {.lex_state = 63},
  [2183] = {.lex_state = 63},
  [2184] = {.lex_state = 23},
  [2185] = {.lex_state = 23},
  [2186] = {.lex_state = 23},
  [2187] = {.lex_state = 415},
  [2188] = {.lex_state = 415},
  [2189] = {.lex_state = 23},
  [2190] = {.lex_state = 23},
  [2191] = {.lex_state = 23},
  [2192] = {.lex_state = 63},
  [2193] = {.lex_state = 23},
  [2194] = {.lex_state = 23},
  [2195] = {.lex_state = 63},
  [2196] = {.lex_state = 63},
  [2197] = {.lex_state = 23},
  [2198] = {.lex_state = 23},
  [2199] = {.lex_state = 0},
  [2200] = {.lex_state = 415},
  [2201] = {.lex_state = 63},
  [2202] = {.lex_state = 23},
  [2203] = {.lex_state = 23},
  [2204] = {.lex_state = 23},
  [2205] = {.lex_state = 63},
  [2206] = {.lex_state = 23},
  [2207] = {.lex_state = 23},
  [2208] = {.lex_state = 63},
  [2209] = {.lex_state = 51},
  [2210] = {.lex_state = 23},
  [2211] = {.lex_state = 23},
  [2212] = {.lex_state = 23},
  [2213] = {.lex_state = 23},
  [2214] = {.lex_state = 23},
  [2215] = {.lex_state = 23},
  [2216] = {.lex_state = 23},
  [2217] = {.lex_state = 23},
  [2218] = {.lex_state = 63},
  [2219] = {.lex_state = 63},
  [2220] = {.lex_state = 23},
  [2221] = {.lex_state = 63},
  [2222] = {.lex_state = 415},
  [2223] = {.lex_state = 23},
  [2224] = {.lex_state = 23},
  [2225] = {.lex_state = 63},
  [2226] = {.lex_state = 63},
  [2227] = {.lex_state = 415},
  [2228] = {.lex_state = 63},
  [2229] = {.lex_state = 23},
  [2230] = {.lex_state = 23},
  [2231] = {.lex_state = 63},
  [2232] = {.lex_state = 23},
  [2233] = {.lex_state = 23},
  [2234] = {.lex_state = 23},
  [2235] = {.lex_state = 23},
  [2236] = {.lex_state = 23},
  [2237] = {.lex_state = 23},
  [2238] = {.lex_state = 63},
  [2239] = {.lex_state = 23},
  [2240] = {.lex_state = 51},
  [2241] = {.lex_state = 63},
  [2242] = {.lex_state = 63},
  [2243] = {.lex_state = 23},
  [2244] = {.lex_state = 51},
  [2245] = {.lex_state = 63},
  [2246] = {.lex_state = 23},
  [2247] = {.lex_state = 23},
  [2248] = {.lex_state = 63},
  [2249] = {.lex_state = 23},
  [2250] = {.lex_state = 63},
  [2251] = {.lex_state = 23},
  [2252] = {.lex_state = 23},
  [2253] = {.lex_state = 23},
  [2254] = {.lex_state = 23},
  [2255] = {.lex_state = 51},
  [2256] = {.lex_state = 63},
  [2257] = {.lex_state = 63},
  [2258] = {.lex_state = 23},
  [2259] = {.lex_state = 415},
  [2260] = {.lex_state = 63},
  [2261] = {.lex_state = 63},
  [2262] = {.lex_state = 23},
  [2263] = {.lex_state = 63},
  [2264] = {.lex_state = 63},
  [2265] = {.lex_state = 63},
  [2266] = {.lex_state = 23},
  [2267] = {.lex_state = 415},
  [2268] = {.lex_state = 63},
  [2269] = {.lex_state = 23},
  [2270] = {.lex_state = 63},
  [2271] = {.lex_state = 23},
  [2272] = {.lex_state = 23},
  [2273] = {.lex_state = 23},
  [2274] = {.lex_state = 63},
  [2275] = {.lex_state = 63},
  [2276] = {.lex_state = 23},
  [2277] = {.lex_state = 63},
  [2278] = {.lex_state = 415},
  [2279] = {.lex_state = 63},
  [2280] = {.lex_state = 23},
  [2281] = {.lex_state = 51},
  [2282] = {.lex_state = 415},
  [2283] = {.lex_state = 63},
  [2284] = {.lex_state = 23},
  [2285] = {.lex_state = 51},
  [2286] = {.lex_state = 63},
  [2287] = {.lex_state = 415},
  [2288] = {.lex_state = 23},
  [2289] = {.lex_state = 51},
  [2290] = {.lex_state = 63},
  [2291] = {.lex_state = 23},
  [2292] = {.lex_state = 23},
  [2293] = {.lex_state = 415},
  [2294] = {.lex_state = 23},
  [2295] = {.lex_state = 23},
  [2296] = {.lex_state = 415},
  [2297] = {.lex_state = 23},
  [2298] = {.lex_state = 23},
  [2299] = {.lex_state = 23},
  [2300] = {.lex_state = 23},
  [2301] = {.lex_state = 51},
  [2302] = {.lex_state = 415},
  [2303] = {.lex_state = 23},
  [2304] = {.lex_state = 63},
  [2305] = {.lex_state = 23},
  [2306] = {.lex_state = 415},
  [2307] = {.lex_state = 23},
  [2308] = {.lex_state = 23},
  [2309] = {.lex_state = 23},
  [2310] = {.lex_state = 23},
  [2311] = {.lex_state = 23},
  [2312] = {.lex_state = 23},
  [2313] = {.lex_state = 23},
  [2314] = {.lex_state = 23},
  [2315] = {.lex_state = 63},
  [2316] = {.lex_state = 51},
  [2317] = {.lex_state = 23},
  [2318] = {.lex_state = 23},
  [2319] = {.lex_state = 63},
  [2320] = {.lex_state = 415},
  [2321] = {.lex_state = 63},
  [2322] = {.lex_state = 64},
  [2323] = {.lex_state = 63},
  [2324] = {.lex_state = 51},
  [2325] = {.lex_state = 51},
  [2326] = {.lex_state = 23},
  [2327] = {.lex_state = 23},
  [2328] = {.lex_state = 63},
  [2329] = {.lex_state = 415},
  [2330] = {.lex_state = 63},
  [2331] = {.lex_state = 415},
  [2332] = {.lex_state = 23},
  [2333] = {.lex_state = 63},
  [2334] = {.lex_state = 63},
  [2335] = {.lex_state = 415},
  [2336] = {.lex_state = 23},
  [2337] = {.lex_state = 23},
  [2338] = {.lex_state = 23},
  [2339] = {.lex_state = 23},
  [2340] = {.lex_state = 23},
  [2341] = {.lex_state = 415},
  [2342] = {.lex_state = 23},
  [2343] = {.lex_state = 63},
  [2344] = {.lex_state = 51},
  [2345] = {.lex_state = 23},
  [2346] = {.lex_state = 23},
  [2347] = {.lex_state = 63},
  [2348] = {.lex_state = 63},
  [2349] = {.lex_state = 415},
  [2350] = {.lex_state = 63},
  [2351] = {.lex_state = 23},
  [2352] = {.lex_state = 63},
  [2353] = {.lex_state = 23},
  [2354] = {.lex_state = 23},
  [2355] = {.lex_state = 23},
  [2356] = {.lex_state = 51},
  [2357] = {.lex_state = 51},
  [2358] = {.lex_state = 63},
  [2359] = {.lex_state = 23},
  [2360] = {.lex_state = 63},
  [2361] = {.lex_state = 23},
  [2362] = {.lex_state = 63},
  [2363] = {.lex_state = 20},
  [2364] = {.lex_state = 0},
  [2365] = {.lex_state = 23},
  [2366] = {.lex_state = 23},
  [2367] = {.lex_state = 23},
  [2368] = {.lex_state = 23},
  [2369] = {.lex_state = 415},
  [2370] = {.lex_state = 0},
  [2371] = {.lex_state = 51},
  [2372] = {.lex_state = 51},
  [2373] = {.lex_state = 23},
  [2374] = {.lex_state = 23},
  [2375] = {.lex_state = 23},
  [2376] = {.lex_state = 23},
  [2377] = {.lex_state = 23},
  [2378] = {.lex_state = 23},
  [2379] = {.lex_state = 23},
  [2380] = {.lex_state = 415},
  [2381] = {.lex_state = 23},
  [2382] = {.lex_state = 23},
  [2383] = {.lex_state = 23},
  [2384] = {.lex_state = 23},
  [2385] = {.lex_state = 23},
  [2386] = {.lex_state = 23},
  [2387] = {.lex_state = 23},
  [2388] = {.lex_state = 23},
  [2389] = {.lex_state = 63},
  [2390] = {.lex_state = 0},
  [2391] = {.lex_state = 23},
  [2392] = {.lex_state = 23},
  [2393] = {.lex_state = 23},
  [2394] = {.lex_state = 23},
  [2395] = {.lex_state = 415},
  [2396] = {.lex_state = 415},
  [2397] = {.lex_state = 23},
  [2398] = {.lex_state = 23},
  [2399] = {.lex_state = 23},
  [2400] = {.lex_state = 63},
  [2401] = {.lex_state = 415},
  [2402] = {.lex_state = 23},
  [2403] = {.lex_state = 63},
  [2404] = {.lex_state = 0},
  [2405] = {.lex_state = 23},
  [2406] = {.lex_state = 23},
  [2407] = {.lex_state = 23},
  [2408] = {.lex_state = 415},
  [2409] = {.lex_state = 23},
  [2410] = {.lex_state = 23},
  [2411] = {.lex_state = 23},
  [2412] = {.lex_state = 0},
  [2413] = {.lex_state = 51},
  [2414] = {.lex_state = 51},
  [2415] = {.lex_state = 415},
  [2416] = {.lex_state = 0},
  [2417] = {.lex_state = 51},
  [2418] = {.lex_state = 51},
  [2419] = {.lex_state = 23},
  [2420] = {.lex_state = 23},
  [2421] = {.lex_state = 23},
  [2422] = {.lex_state = 23},
  [2423] = {.lex_state = 23},
  [2424] = {.lex_state = 23},
  [2425] = {.lex_state = 23},
  [2426] = {.lex_state = 23},
  [2427] = {.lex_state = 51},
  [2428] = {.lex_state = 23},
  [2429] = {.lex_state = 23},
  [2430] = {.lex_state = 23},
  [2431] = {.lex_state = 51},
  [2432] = {.lex_state = 415},
  [2433] = {.lex_state = 23},
  [2434] = {.lex_state = 51},
  [2435] = {.lex_state = 23},
  [2436] = {.lex_state = 23},
  [2437] = {.lex_state = 63},
  [2438] = {.lex_state = 23},
  [2439] = {.lex_state = 415},
  [2440] = {.lex_state = 0},
  [2441] = {.lex_state = 415},
  [2442] = {.lex_state = 51},
  [2443] = {.lex_state = 23},
  [2444] = {.lex_state = 23},
  [2445] = {.lex_state = 23},
  [2446] = {.lex_state = 0},
  [2447] = {.lex_state = 23},
  [2448] = {.lex_state = 0},
  [2449] = {.lex_state = 23},
  [2450] = {.lex_state = 23},
  [2451] = {.lex_state = 0},
  [2452] = {.lex_state = 415},
  [2453] = {.lex_state = 23},
  [2454] = {.lex_state = 23},
  [2455] = {.lex_state = 23},
  [2456] = {.lex_state = 23},
  [2457] = {.lex_state = 23},
  [2458] = {.lex_state = 23},
  [2459] = {.lex_state = 23},
  [2460] = {.lex_state = 23},
  [2461] = {.lex_state = 415},
  [2462] = {.lex_state = 23},
  [2463] = {.lex_state = 415},
  [2464] = {.lex_state = 23},
  [2465] = {.lex_state = 0},
  [2466] = {.lex_state = 415},
  [2467] = {.lex_state = 23},
  [2468] = {.lex_state = 23},
  [2469] = {.lex_state = 23},
  [2470] = {.lex_state = 23},
  [2471] = {.lex_state = 23},
  [2472] = {.lex_state = 23},
  [2473] = {.lex_state = 23},
  [2474] = {.lex_state = 23},
  [2475] = {.lex_state = 23},
  [2476] = {.lex_state = 23},
  [2477] = {.lex_state = 23},
  [2478] = {.lex_state = 23},
  [2479] = {.lex_state = 63},
  [2480] = {.lex_state = 23},
  [2481] = {.lex_state = 23},
  [2482] = {.lex_state = 23},
  [2483] = {.lex_state = 63},
  [2484] = {.lex_state = 23},
  [2485] = {.lex_state = 63},
  [2486] = {.lex_state = 23},
  [2487] = {.lex_state = 0},
  [2488] = {.lex_state = 51},
  [2489] = {.lex_state = 63},
  [2490] = {.lex_state = 51},
  [2491] = {.lex_state = 23},
  [2492] = {.lex_state = 23},
  [2493] = {.lex_state = 23},
  [2494] = {.lex_state = 23},
  [2495] = {.lex_state = 23},
  [2496] = {.lex_state = 23},
  [2497] = {.lex_state = 23},
  [2498] = {.lex_state = 23},
  [2499] = {.lex_state = 23},
  [2500] = {.lex_state = 23},
  [2501] = {.lex_state = 23},
  [2502] = {.lex_state = 23},
  [2503] = {.lex_state = 23},
  [2504] = {.lex_state = 23},
  [2505] = {.lex_state = 23},
  [2506] = {.lex_state = 23},
  [2507] = {.lex_state = 23},
  [2508] = {.lex_state = 63},
  [2509] = {.lex_state = 23},
  [2510] = {.lex_state = 23},
  [2511] = {.lex_state = 23},
  [2512] = {.lex_state = 63},
  [2513] = {.lex_state = 415},
  [2514] = {.lex_state = 63},
  [2515] = {.lex_state = 23},
  [2516] = {.lex_state = 415},
  [2517] = {.lex_state = 415},
  [2518] = {.lex_state = 63},
  [2519] = {.lex_state = 415},
  [2520] = {.lex_state = 23},
  [2521] = {.lex_state = 23},
  [2522] = {.lex_state = 51},
  [2523] = {.lex_state = 51},
  [2524] = {.lex_state = 51},
  [2525] = {.lex_state = 23},
  [2526] = {.lex_state = 23},
  [2527] = {.lex_state = 51},
  [2528] = {.lex_state = 51},
  [2529] = {.lex_state = 415},
  [2530] = {.lex_state = 0},
  [2531] = {.lex_state = 23},
  [2532] = {.lex_state = 63},
  [2533] = {.lex_state = 73},
  [2534] = {.lex_state = 0},
  [2535] = {.lex_state = 0},
  [2536] = {.lex_state = 63},
  [2537] = {.lex_state = 0},
  [2538] = {.lex_state = 415},
  [2539] = {.lex_state = 0},
  [2540] = {.lex_state = 63},
  [2541] = {.lex_state = 0},
  [2542] = {.lex_state = 415},
  [2543] = {.lex_state = 73},
  [2544] = {.lex_state = 63},
  [2545] = {.lex_state = 0},
  [2546] = {.lex_state = 0},
  [2547] = {.lex_state = 415},
  [2548] = {.lex_state = 63},
  [2549] = {.lex_state = 0},
  [2550] = {.lex_state = 64},
  [2551] = {.lex_state = 64},
  [2552] = {.lex_state = 0},
  [2553] = {.lex_state = 73},
  [2554] = {.lex_state = 63},
  [2555] = {.lex_state = 63},
  [2556] = {.lex_state = 73},
  [2557] = {.lex_state = 63},
  [2558] = {.lex_state = 415},
  [2559] = {.lex_state = 73},
  [2560] = {.lex_state = 63},
  [2561] = {.lex_state = 0},
  [2562] = {.lex_state = 63},
  [2563] = {.lex_state = 415},
  [2564] = {.lex_state = 73},
  [2565] = {.lex_state = 0},
  [2566] = {.lex_state = 63},
  [2567] = {.lex_state = 415},
  [2568] = {.lex_state = 73},
  [2569] = {.lex_state = 0},
  [2570] = {.lex_state = 63},
  [2571] = {.lex_state = 415},
  [2572] = {.lex_state = 73},
  [2573] = {.lex_state = 64},
  [2574] = {.lex_state = 0},
  [2575] = {.lex_state = 63},
  [2576] = {.lex_state = 0},
  [2577] = {.lex_state = 415},
  [2578] = {.lex_state = 415},
  [2579] = {.lex_state = 73},
  [2580] = {.lex_state = 0},
  [2581] = {.lex_state = 0},
  [2582] = {.lex_state = 63},
  [2583] = {.lex_state = 415},
  [2584] = {.lex_state = 415},
  [2585] = {.lex_state = 64},
  [2586] = {.lex_state = 64},
  [2587] = {.lex_state = 0},
  [2588] = {.lex_state = 0},
  [2589] = {.lex_state = 63},
  [2590] = {.lex_state = 415},
  [2591] = {.lex_state = 73},
  [2592] = {.lex_state = 64},
  [2593] = {.lex_state = 0},
  [2594] = {.lex_state = 63},
  [2595] = {.lex_state = 63},
  [2596] = {.lex_state = 415},
  [2597] = {.lex_state = 73},
  [2598] = {.lex_state = 0},
  [2599] = {.lex_state = 63},
  [2600] = {.lex_state = 415},
  [2601] = {.lex_state = 415},
  [2602] = {.lex_state = 73},
  [2603] = {.lex_state = 0},
  [2604] = {.lex_state = 63},
  [2605] = {.lex_state = 415},
  [2606] = {.lex_state = 73},
  [2607] = {.lex_state = 0},
  [2608] = {.lex_state = 0},
  [2609] = {.lex_state = 0},
  [2610] = {.lex_state = 63},
  [2611] = {.lex_state = 415},
  [2612] = {.lex_state = 64},
  [2613] = {.lex_state = 73},
  [2614] = {.lex_state = 0},
  [2615] = {.lex_state = 63},
  [2616] = {.lex_state = 73},
  [2617] = {.lex_state = 73},
  [2618] = {.lex_state = 64},
  [2619] = {.lex_state = 0},
  [2620] = {.lex_state = 63},
  [2621] = {.lex_state = 415},
  [2622] = {.lex_state = 73},
  [2623] = {.lex_state = 0},
  [2624] = {.lex_state = 63},
  [2625] = {.lex_state = 415},
  [2626] = {.lex_state = 0},
  [2627] = {.lex_state = 63},
  [2628] = {.lex_state = 415},
  [2629] = {.lex_state = 73},
  [2630] = {.lex_state = 0},
  [2631] = {.lex_state = 0},
  [2632] = {.lex_state = 63},
  [2633] = {.lex_state = 415},
  [2634] = {.lex_state = 0},
  [2635] = {.lex_state = 73},
  [2636] = {.lex_state = 0},
  [2637] = {.lex_state = 63},
  [2638] = {.lex_state = 415},
  [2639] = {.lex_state = 73},
  [2640] = {.lex_state = 0},
  [2641] = {.lex_state = 63},
  [2642] = {.lex_state = 415},
  [2643] = {.lex_state = 73},
  [2644] = {.lex_state = 0},
  [2645] = {.lex_state = 63},
  [2646] = {.lex_state = 415},
  [2647] = {.lex_state = 73},
  [2648] = {.lex_state = 0},
  [2649] = {.lex_state = 63},
  [2650] = {.lex_state = 0},
  [2651] = {.lex_state = 415},
  [2652] = {.lex_state = 73},
  [2653] = {.lex_state = 0},
  [2654] = {.lex_state = 63},
  [2655] = {.lex_state = 415},
  [2656] = {.lex_state = 73},
  [2657] = {.lex_state = 0},
  [2658] = {.lex_state = 63},
  [2659] = {.lex_state = 415},
  [2660] = {.lex_state = 73},
  [2661] = {.lex_state = 0},
  [2662] = {.lex_state = 63},
  [2663] = {.lex_state = 23},
  [2664] = {.lex_state = 415},
  [2665] = {.lex_state = 70},
  [2666] = {.lex_state = 0},
  [2667] = {.lex_state = 63},
  [2668] = {.lex_state = 23},
  [2669] = {.lex_state = 415},
  [2670] = {.lex_state = 73},
  [2671] = {.lex_state = 0},
  [2672] = {.lex_state = 415},
  [2673] = {.lex_state = 23},
  [2674] = {.lex_state = 0},
  [2675] = {.lex_state = 0},
  [2676] = {.lex_state = 0},
  [2677] = {.lex_state = 0},
  [2678] = {.lex_state = 70},
  [2679] = {.lex_state = 0},
  [2680] = {.lex_state = 0},
  [2681] = {.lex_state = 63},
  [2682] = {.lex_state = 0},
  [2683] = {.lex_state = 0},
  [2684] = {.lex_state = 70},
  [2685] = {.lex_state = 415},
  [2686] = {.lex_state = 73},
  [2687] = {.lex_state = 0},
  [2688] = {.lex_state = 0},
  [2689] = {.lex_state = 0},
  [2690] = {.lex_state = 0},
  [2691] = {.lex_state = 23},
  [2692] = {.lex_state = 0},
  [2693] = {.lex_state = 0},
  [2694] = {.lex_state = 0},
  [2695] = {.lex_state = 73},
  [2696] = {.lex_state = 142},
  [2697] = {.lex_state = 415},
  [2698] = {.lex_state = 0},
  [2699] = {.lex_state = 0},
  [2700] = {.lex_state = 0},
  [2701] = {.lex_state = 0},
  [2702] = {.lex_state = 0},
  [2703] = {.lex_state = 0},
  [2704] = {.lex_state = 415},
  [2705] = {.lex_state = 0},
  [2706] = {.lex_state = 63},
  [2707] = {.lex_state = 0},
  [2708] = {.lex_state = 0},
  [2709] = {.lex_state = 23},
  [2710] = {.lex_state = 415},
  [2711] = {.lex_state = 0},
  [2712] = {.lex_state = 70},
  [2713] = {.lex_state = 415},
  [2714] = {.lex_state = 73},
  [2715] = {.lex_state = 0},
  [2716] = {.lex_state = 0},
  [2717] = {.lex_state = 70},
  [2718] = {.lex_state = 0},
  [2719] = {.lex_state = 63},
  [2720] = {.lex_state = 0},
  [2721] = {.lex_state = 0},
  [2722] = {.lex_state = 0},
  [2723] = {.lex_state = 0},
  [2724] = {.lex_state = 23},
  [2725] = {.lex_state = 23},
  [2726] = {.lex_state = 64},
  [2727] = {.lex_state = 0},
  [2728] = {.lex_state = 63},
  [2729] = {.lex_state = 0},
  [2730] = {.lex_state = 0},
  [2731] = {.lex_state = 23},
  [2732] = {.lex_state = 0},
  [2733] = {.lex_state = 415},
  [2734] = {.lex_state = 0},
  [2735] = {.lex_state = 0},
  [2736] = {.lex_state = 0},
  [2737] = {.lex_state = 0, .external_lex_state = 2},
  [2738] = {.lex_state = 0},
  [2739] = {.lex_state = 0},
  [2740] = {.lex_state = 70},
  [2741] = {.lex_state = 0},
  [2742] = {.lex_state = 0},
  [2743] = {.lex_state = 70},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [anon_sym_PROJECT] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_VERSION] = ACTIONS(1),
    [anon_sym_ARG] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_BUILD] = ACTIONS(1),
    [anon_sym_CACHE] = ACTIONS(1),
    [anon_sym_CMD] = ACTIONS(1),
    [anon_sym_COPY] = ACTIONS(1),
    [anon_sym_DO] = ACTIONS(1),
    [anon_sym_ENTRYPOINT] = ACTIONS(1),
    [anon_sym_ENV] = ACTIONS(1),
    [anon_sym_EQ2] = ACTIONS(1),
    [anon_sym_EXPOSE] = ACTIONS(1),
    [anon_sym_FOR] = ACTIONS(1),
    [anon_sym_IN] = ACTIONS(1),
    [anon_sym_END] = ACTIONS(1),
    [anon_sym_FROM] = ACTIONS(1),
    [anon_sym_FROMDOCKERFILE] = ACTIONS(1),
    [anon_sym_FUNCTION] = ACTIONS(1),
    [anon_sym_COMMAND] = ACTIONS(1),
    [anon_sym_GITCLONE] = ACTIONS(1),
    [anon_sym_HOST] = ACTIONS(1),
    [anon_sym_IF] = ACTIONS(1),
    [anon_sym_IMPORT] = ACTIONS(1),
    [anon_sym_AS] = ACTIONS(1),
    [anon_sym_LET] = ACTIONS(1),
    [anon_sym_EQ3] = ACTIONS(1),
    [anon_sym_LABEL] = ACTIONS(1),
    [anon_sym_LOCALLY] = ACTIONS(1),
    [anon_sym_RUN] = ACTIONS(1),
    [anon_sym_SAVEARTIFACT] = ACTIONS(1),
    [anon_sym_SAVEIMAGE] = ACTIONS(1),
    [anon_sym_SET] = ACTIONS(1),
    [anon_sym_TRY] = ACTIONS(1),
    [anon_sym_FINALLY] = ACTIONS(1),
    [anon_sym_USER] = ACTIONS(1),
    [anon_sym_COLON2] = ACTIONS(1),
    [anon_sym_VOLUME] = ACTIONS(1),
    [anon_sym_WAIT] = ACTIONS(1),
    [anon_sym_WITHDOCKER] = ACTIONS(1),
    [anon_sym_WORKDIR] = ACTIONS(1),
    [anon_sym_ELSEIF] = ACTIONS(1),
    [anon_sym_ELSE] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_SLASH2] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_DOT2] = ACTIONS(1),
    [anon_sym_DASH2] = ACTIONS(1),
    [anon_sym_LPAREN2] = ACTIONS(1),
    [anon_sym_RPAREN2] = ACTIONS(1),
    [anon_sym_LBRACK2] = ACTIONS(1),
    [anon_sym_RBRACK2] = ACTIONS(1),
    [anon_sym_LBRACE2] = ACTIONS(1),
    [anon_sym_RBRACE2] = ACTIONS(1),
    [anon_sym_COMMA2] = ACTIONS(1),
    [anon_sym_AT2] = ACTIONS(1),
    [sym_function_ref] = ACTIONS(1),
    [sym_number] = ACTIONS(1),
    [sym_options] = ACTIONS(1),
    [anon_sym_DOLLAR] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [anon_sym_LBRACK3] = ACTIONS(1),
    [anon_sym_LPAREN3] = ACTIONS(1),
    [anon_sym_RPAREN3] = ACTIONS(1),
    [anon_sym_DASH_DASH2] = ACTIONS(1),
    [anon_sym_DASHf] = ACTIONS(1),
    [anon_sym_EQ4] = ACTIONS(1),
    [aux_sym_unknown_option_token1] = ACTIONS(1),
    [sym__string_base_other] = ACTIONS(1),
    [sym__string_base_num] = ACTIONS(1),
    [sym__immediate_string_base_other] = ACTIONS(1),
    [sym__immediate_string_base_num] = ACTIONS(1),
    [anon_sym_DQUOTE2] = ACTIONS(1),
    [anon_sym_SQUOTE2] = ACTIONS(1),
    [anon_sym_PLUS2] = ACTIONS(1),
    [anon_sym_RPAREN4] = ACTIONS(1),
    [anon_sym_DOLLAR2] = ACTIONS(1),
    [aux_sym__immediate_escape_sequence_token1] = ACTIONS(1),
    [sym_line_continuation] = ACTIONS(3),
    [sym_comment] = ACTIONS(5),
    [sym_line_continuation_comment] = ACTIONS(5),
    [anon_sym_LF] = ACTIONS(5),
    [anon_sym_CR_LF] = ACTIONS(5),
    [anon_sym_FF] = ACTIONS(5),
    [anon_sym_NULL] = ACTIONS(1),
    [sym__indent] = ACTIONS(1),
    [sym__dedent] = ACTIONS(1),
  },
  [1] = {
    [sym_source_file] = STATE(2708),
    [sym_project_command] = STATE(10),
    [sym_target] = STATE(2003),
    [sym_version_command] = STATE(2),
    [sym_arg_command] = STATE(10),
    [sym_build_command] = STATE(10),
    [sym_cache_command] = STATE(10),
    [sym_cmd_command] = STATE(10),
    [sym_copy_command] = STATE(10),
    [sym_do_command] = STATE(10),
    [sym_entrypoint_command] = STATE(10),
    [sym_env_command] = STATE(10),
    [sym_expose_command] = STATE(10),
    [sym_for_command] = STATE(10),
    [sym_from_command] = STATE(10),
    [sym_from_dockerfile_command] = STATE(10),
    [sym_function_command] = STATE(10),
    [sym_git_clone_command] = STATE(10),
    [sym_host_command] = STATE(10),
    [sym_if_command] = STATE(10),
    [sym_import_command] = STATE(10),
    [sym_let_command] = STATE(10),
    [sym_label_command] = STATE(10),
    [sym_locally_command] = STATE(10),
    [sym_run_command] = STATE(10),
    [sym_save_artifact_command] = STATE(10),
    [sym_save_image_command] = STATE(10),
    [sym_set_command] = STATE(10),
    [sym_try_command] = STATE(10),
    [sym_user_command] = STATE(10),
    [sym_volume_command] = STATE(10),
    [sym_wait_command] = STATE(10),
    [sym_with_docker_command] = STATE(10),
    [sym_workdir_command] = STATE(10),
    [sym_block] = STATE(2017),
    [sym_identifier] = STATE(2704),
    [aux_sym_source_file_repeat1] = STATE(2003),
    [aux_sym_block_repeat1] = STATE(10),
    [ts_builtin_sym_end] = ACTIONS(7),
    [anon_sym_PROJECT] = ACTIONS(9),
    [anon_sym_VERSION] = ACTIONS(11),
    [anon_sym_ARG] = ACTIONS(13),
    [anon_sym_BUILD] = ACTIONS(15),
    [anon_sym_CACHE] = ACTIONS(17),
    [anon_sym_CMD] = ACTIONS(19),
    [anon_sym_COPY] = ACTIONS(21),
    [anon_sym_DO] = ACTIONS(23),
    [anon_sym_ENTRYPOINT] = ACTIONS(25),
    [anon_sym_ENV] = ACTIONS(27),
    [anon_sym_EXPOSE] = ACTIONS(29),
    [anon_sym_FOR] = ACTIONS(31),
    [anon_sym_FROM] = ACTIONS(33),
    [anon_sym_FROMDOCKERFILE] = ACTIONS(35),
    [anon_sym_FUNCTION] = ACTIONS(37),
    [anon_sym_COMMAND] = ACTIONS(37),
    [anon_sym_GITCLONE] = ACTIONS(39),
    [anon_sym_HOST] = ACTIONS(41),
    [anon_sym_IF] = ACTIONS(43),
    [anon_sym_IMPORT] = ACTIONS(45),
    [anon_sym_LET] = ACTIONS(47),
    [anon_sym_LABEL] = ACTIONS(49),
    [anon_sym_LOCALLY] = ACTIONS(51),
    [anon_sym_RUN] = ACTIONS(53),
    [anon_sym_SAVEARTIFACT] = ACTIONS(55),
    [anon_sym_SAVEIMAGE] = ACTIONS(57),
    [anon_sym_SET] = ACTIONS(59),
    [anon_sym_TRY] = ACTIONS(61),
    [anon_sym_USER] = ACTIONS(63),
    [anon_sym_VOLUME] = ACTIONS(65),
    [anon_sym_WAIT] = ACTIONS(67),
    [anon_sym_WITHDOCKER] = ACTIONS(69),
    [anon_sym_WORKDIR] = ACTIONS(71),
    [aux_sym_block_token1] = ACTIONS(73),
    [sym__string_base_alpha] = ACTIONS(75),
    [sym_line_continuation] = ACTIONS(3),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation_comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(3),
    [anon_sym_CR_LF] = ACTIONS(3),
    [anon_sym_FF] = ACTIONS(3),
  },
  [2] = {
    [sym_project_command] = STATE(10),
    [sym_target] = STATE(1902),
    [sym_arg_command] = STATE(10),
    [sym_build_command] = STATE(10),
    [sym_cache_command] = STATE(10),
    [sym_cmd_command] = STATE(10),
    [sym_copy_command] = STATE(10),
    [sym_do_command] = STATE(10),
    [sym_entrypoint_command] = STATE(10),
    [sym_env_command] = STATE(10),
    [sym_expose_command] = STATE(10),
    [sym_for_command] = STATE(10),
    [sym_from_command] = STATE(10),
    [sym_from_dockerfile_command] = STATE(10),
    [sym_function_command] = STATE(10),
    [sym_git_clone_command] = STATE(10),
    [sym_host_command] = STATE(10),
    [sym_if_command] = STATE(10),
    [sym_import_command] = STATE(10),
    [sym_let_command] = STATE(10),
    [sym_label_command] = STATE(10),
    [sym_locally_command] = STATE(10),
    [sym_run_command] = STATE(10),
    [sym_save_artifact_command] = STATE(10),
    [sym_save_image_command] = STATE(10),
    [sym_set_command] = STATE(10),
    [sym_try_command] = STATE(10),
    [sym_user_command] = STATE(10),
    [sym_volume_command] = STATE(10),
    [sym_wait_command] = STATE(10),
    [sym_with_docker_command] = STATE(10),
    [sym_workdir_command] = STATE(10),
    [sym_block] = STATE(1903),
    [sym_identifier] = STATE(2704),
    [aux_sym_source_file_repeat1] = STATE(1902),
    [aux_sym_block_repeat1] = STATE(10),
    [ts_builtin_sym_end] = ACTIONS(77),
    [anon_sym_PROJECT] = ACTIONS(9),
    [anon_sym_ARG] = ACTIONS(13),
    [anon_sym_BUILD] = ACTIONS(15),
    [anon_sym_CACHE] = ACTIONS(17),
    [anon_sym_CMD] = ACTIONS(19),
    [anon_sym_COPY] = ACTIONS(21),
    [anon_sym_DO] = ACTIONS(23),
    [anon_sym_ENTRYPOINT] = ACTIONS(25),
    [anon_sym_ENV] = ACTIONS(27),
    [anon_sym_EXPOSE] = ACTIONS(29),
    [anon_sym_FOR] = ACTIONS(31),
    [anon_sym_FROM] = ACTIONS(33),
    [anon_sym_FROMDOCKERFILE] = ACTIONS(35),
    [anon_sym_FUNCTION] = ACTIONS(37),
    [anon_sym_COMMAND] = ACTIONS(37),
    [anon_sym_GITCLONE] = ACTIONS(39),
    [anon_sym_HOST] = ACTIONS(41),
    [anon_sym_IF] = ACTIONS(43),
    [anon_sym_IMPORT] = ACTIONS(45),
    [anon_sym_LET] = ACTIONS(47),
    [anon_sym_LABEL] = ACTIONS(49),
    [anon_sym_LOCALLY] = ACTIONS(51),
    [anon_sym_RUN] = ACTIONS(53),
    [anon_sym_SAVEARTIFACT] = ACTIONS(55),
    [anon_sym_SAVEIMAGE] = ACTIONS(57),
    [anon_sym_SET] = ACTIONS(59),
    [anon_sym_TRY] = ACTIONS(61),
    [anon_sym_USER] = ACTIONS(63),
    [anon_sym_VOLUME] = ACTIONS(65),
    [anon_sym_WAIT] = ACTIONS(67),
    [anon_sym_WITHDOCKER] = ACTIONS(69),
    [anon_sym_WORKDIR] = ACTIONS(71),
    [aux_sym_block_token1] = ACTIONS(73),
    [sym__string_base_alpha] = ACTIONS(75),
    [sym_line_continuation] = ACTIONS(3),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation_comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(3),
    [anon_sym_CR_LF] = ACTIONS(3),
    [anon_sym_FF] = ACTIONS(3),
  },
  [3] = {
    [sym_project_command] = STATE(6),
    [sym_arg_command] = STATE(6),
    [sym_build_command] = STATE(6),
    [sym_cache_command] = STATE(6),
    [sym_cmd_command] = STATE(6),
    [sym_copy_command] = STATE(6),
    [sym_do_command] = STATE(6),
    [sym_entrypoint_command] = STATE(6),
    [sym_env_command] = STATE(6),
    [sym_expose_command] = STATE(6),
    [sym_for_command] = STATE(6),
    [sym_from_command] = STATE(6),
    [sym_from_dockerfile_command] = STATE(6),
    [sym_function_command] = STATE(6),
    [sym_git_clone_command] = STATE(6),
    [sym_host_command] = STATE(6),
    [sym_if_command] = STATE(6),
    [sym_import_command] = STATE(6),
    [sym_let_command] = STATE(6),
    [sym_label_command] = STATE(6),
    [sym_locally_command] = STATE(6),
    [sym_run_command] = STATE(6),
    [sym_save_artifact_command] = STATE(6),
    [sym_save_image_command] = STATE(6),
    [sym_set_command] = STATE(6),
    [sym_try_command] = STATE(6),
    [sym_user_command] = STATE(6),
    [sym_volume_command] = STATE(6),
    [sym_wait_command] = STATE(6),
    [sym_with_docker_command] = STATE(6),
    [sym_workdir_command] = STATE(6),
    [aux_sym_block_repeat1] = STATE(6),
    [anon_sym_PROJECT] = ACTIONS(79),
    [anon_sym_ARG] = ACTIONS(81),
    [anon_sym_BUILD] = ACTIONS(83),
    [anon_sym_CACHE] = ACTIONS(85),
    [anon_sym_CMD] = ACTIONS(87),
    [anon_sym_COPY] = ACTIONS(89),
    [anon_sym_DO] = ACTIONS(91),
    [anon_sym_ENTRYPOINT] = ACTIONS(93),
    [anon_sym_ENV] = ACTIONS(95),
    [anon_sym_EXPOSE] = ACTIONS(97),
    [anon_sym_FOR] = ACTIONS(99),
    [anon_sym_END] = ACTIONS(101),
    [anon_sym_FROM] = ACTIONS(103),
    [anon_sym_FROMDOCKERFILE] = ACTIONS(105),
    [anon_sym_FUNCTION] = ACTIONS(107),
    [anon_sym_COMMAND] = ACTIONS(107),
    [anon_sym_GITCLONE] = ACTIONS(109),
    [anon_sym_HOST] = ACTIONS(111),
    [anon_sym_IF] = ACTIONS(113),
    [anon_sym_IMPORT] = ACTIONS(115),
    [anon_sym_LET] = ACTIONS(117),
    [anon_sym_LABEL] = ACTIONS(119),
    [anon_sym_LOCALLY] = ACTIONS(121),
    [anon_sym_RUN] = ACTIONS(123),
    [anon_sym_SAVEARTIFACT] = ACTIONS(125),
    [anon_sym_SAVEIMAGE] = ACTIONS(127),
    [anon_sym_SET] = ACTIONS(129),
    [anon_sym_TRY] = ACTIONS(131),
    [anon_sym_FINALLY] = ACTIONS(101),
    [anon_sym_USER] = ACTIONS(133),
    [anon_sym_VOLUME] = ACTIONS(135),
    [anon_sym_WAIT] = ACTIONS(137),
    [anon_sym_WITHDOCKER] = ACTIONS(139),
    [anon_sym_WORKDIR] = ACTIONS(141),
    [aux_sym_block_token1] = ACTIONS(143),
    [anon_sym_ELSEIF] = ACTIONS(101),
    [anon_sym_ELSE] = ACTIONS(101),
    [sym_line_continuation] = ACTIONS(3),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation_comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(3),
    [anon_sym_CR_LF] = ACTIONS(3),
    [anon_sym_FF] = ACTIONS(3),
  },
  [4] = {
    [sym_project_command] = STATE(3),
    [sym_arg_command] = STATE(3),
    [sym_build_command] = STATE(3),
    [sym_cache_command] = STATE(3),
    [sym_cmd_command] = STATE(3),
    [sym_copy_command] = STATE(3),
    [sym_do_command] = STATE(3),
    [sym_entrypoint_command] = STATE(3),
    [sym_env_command] = STATE(3),
    [sym_expose_command] = STATE(3),
    [sym_for_command] = STATE(3),
    [sym_from_command] = STATE(3),
    [sym_from_dockerfile_command] = STATE(3),
    [sym_function_command] = STATE(3),
    [sym_git_clone_command] = STATE(3),
    [sym_host_command] = STATE(3),
    [sym_if_command] = STATE(3),
    [sym_import_command] = STATE(3),
    [sym_let_command] = STATE(3),
    [sym_label_command] = STATE(3),
    [sym_locally_command] = STATE(3),
    [sym_run_command] = STATE(3),
    [sym_save_artifact_command] = STATE(3),
    [sym_save_image_command] = STATE(3),
    [sym_set_command] = STATE(3),
    [sym_try_command] = STATE(3),
    [sym_user_command] = STATE(3),
    [sym_volume_command] = STATE(3),
    [sym_wait_command] = STATE(3),
    [sym_with_docker_command] = STATE(3),
    [sym_workdir_command] = STATE(3),
    [sym_block] = STATE(2129),
    [aux_sym_block_repeat1] = STATE(3),
    [anon_sym_PROJECT] = ACTIONS(79),
    [anon_sym_ARG] = ACTIONS(81),
    [anon_sym_BUILD] = ACTIONS(83),
    [anon_sym_CACHE] = ACTIONS(85),
    [anon_sym_CMD] = ACTIONS(87),
    [anon_sym_COPY] = ACTIONS(89),
    [anon_sym_DO] = ACTIONS(91),
    [anon_sym_ENTRYPOINT] = ACTIONS(93),
    [anon_sym_ENV] = ACTIONS(95),
    [anon_sym_EXPOSE] = ACTIONS(97),
    [anon_sym_FOR] = ACTIONS(99),
    [anon_sym_END] = ACTIONS(145),
    [anon_sym_FROM] = ACTIONS(103),
    [anon_sym_FROMDOCKERFILE] = ACTIONS(105),
    [anon_sym_FUNCTION] = ACTIONS(107),
    [anon_sym_COMMAND] = ACTIONS(107),
    [anon_sym_GITCLONE] = ACTIONS(109),
    [anon_sym_HOST] = ACTIONS(111),
    [anon_sym_IF] = ACTIONS(113),
    [anon_sym_IMPORT] = ACTIONS(115),
    [anon_sym_LET] = ACTIONS(117),
    [anon_sym_LABEL] = ACTIONS(119),
    [anon_sym_LOCALLY] = ACTIONS(121),
    [anon_sym_RUN] = ACTIONS(123),
    [anon_sym_SAVEARTIFACT] = ACTIONS(125),
    [anon_sym_SAVEIMAGE] = ACTIONS(127),
    [anon_sym_SET] = ACTIONS(129),
    [anon_sym_TRY] = ACTIONS(131),
    [anon_sym_USER] = ACTIONS(133),
    [anon_sym_VOLUME] = ACTIONS(135),
    [anon_sym_WAIT] = ACTIONS(137),
    [anon_sym_WITHDOCKER] = ACTIONS(139),
    [anon_sym_WORKDIR] = ACTIONS(141),
    [aux_sym_block_token1] = ACTIONS(147),
    [anon_sym_ELSEIF] = ACTIONS(145),
    [anon_sym_ELSE] = ACTIONS(145),
    [sym_line_continuation] = ACTIONS(3),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation_comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(3),
    [anon_sym_CR_LF] = ACTIONS(3),
    [anon_sym_FF] = ACTIONS(3),
  },
  [5] = {
    [sym_project_command] = STATE(3),
    [sym_arg_command] = STATE(3),
    [sym_build_command] = STATE(3),
    [sym_cache_command] = STATE(3),
    [sym_cmd_command] = STATE(3),
    [sym_copy_command] = STATE(3),
    [sym_do_command] = STATE(3),
    [sym_entrypoint_command] = STATE(3),
    [sym_env_command] = STATE(3),
    [sym_expose_command] = STATE(3),
    [sym_for_command] = STATE(3),
    [sym_from_command] = STATE(3),
    [sym_from_dockerfile_command] = STATE(3),
    [sym_function_command] = STATE(3),
    [sym_git_clone_command] = STATE(3),
    [sym_host_command] = STATE(3),
    [sym_if_command] = STATE(3),
    [sym_import_command] = STATE(3),
    [sym_let_command] = STATE(3),
    [sym_label_command] = STATE(3),
    [sym_locally_command] = STATE(3),
    [sym_run_command] = STATE(3),
    [sym_save_artifact_command] = STATE(3),
    [sym_save_image_command] = STATE(3),
    [sym_set_command] = STATE(3),
    [sym_try_command] = STATE(3),
    [sym_user_command] = STATE(3),
    [sym_volume_command] = STATE(3),
    [sym_wait_command] = STATE(3),
    [sym_with_docker_command] = STATE(3),
    [sym_workdir_command] = STATE(3),
    [sym_block] = STATE(2140),
    [aux_sym_block_repeat1] = STATE(3),
    [anon_sym_PROJECT] = ACTIONS(79),
    [anon_sym_ARG] = ACTIONS(81),
    [anon_sym_BUILD] = ACTIONS(83),
    [anon_sym_CACHE] = ACTIONS(85),
    [anon_sym_CMD] = ACTIONS(87),
    [anon_sym_COPY] = ACTIONS(89),
    [anon_sym_DO] = ACTIONS(91),
    [anon_sym_ENTRYPOINT] = ACTIONS(93),
    [anon_sym_ENV] = ACTIONS(95),
    [anon_sym_EXPOSE] = ACTIONS(97),
    [anon_sym_FOR] = ACTIONS(99),
    [anon_sym_END] = ACTIONS(149),
    [anon_sym_FROM] = ACTIONS(103),
    [anon_sym_FROMDOCKERFILE] = ACTIONS(105),
    [anon_sym_FUNCTION] = ACTIONS(107),
    [anon_sym_COMMAND] = ACTIONS(107),
    [anon_sym_GITCLONE] = ACTIONS(109),
    [anon_sym_HOST] = ACTIONS(111),
    [anon_sym_IF] = ACTIONS(113),
    [anon_sym_IMPORT] = ACTIONS(115),
    [anon_sym_LET] = ACTIONS(117),
    [anon_sym_LABEL] = ACTIONS(119),
    [anon_sym_LOCALLY] = ACTIONS(121),
    [anon_sym_RUN] = ACTIONS(123),
    [anon_sym_SAVEARTIFACT] = ACTIONS(125),
    [anon_sym_SAVEIMAGE] = ACTIONS(127),
    [anon_sym_SET] = ACTIONS(129),
    [anon_sym_TRY] = ACTIONS(131),
    [anon_sym_USER] = ACTIONS(133),
    [anon_sym_VOLUME] = ACTIONS(135),
    [anon_sym_WAIT] = ACTIONS(137),
    [anon_sym_WITHDOCKER] = ACTIONS(139),
    [anon_sym_WORKDIR] = ACTIONS(141),
    [aux_sym_block_token1] = ACTIONS(147),
    [anon_sym_ELSEIF] = ACTIONS(149),
    [anon_sym_ELSE] = ACTIONS(149),
    [sym_line_continuation] = ACTIONS(3),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation_comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(3),
    [anon_sym_CR_LF] = ACTIONS(3),
    [anon_sym_FF] = ACTIONS(3),
  },
  [6] = {
    [sym_project_command] = STATE(6),
    [sym_arg_command] = STATE(6),
    [sym_build_command] = STATE(6),
    [sym_cache_command] = STATE(6),
    [sym_cmd_command] = STATE(6),
    [sym_copy_command] = STATE(6),
    [sym_do_command] = STATE(6),
    [sym_entrypoint_command] = STATE(6),
    [sym_env_command] = STATE(6),
    [sym_expose_command] = STATE(6),
    [sym_for_command] = STATE(6),
    [sym_from_command] = STATE(6),
    [sym_from_dockerfile_command] = STATE(6),
    [sym_function_command] = STATE(6),
    [sym_git_clone_command] = STATE(6),
    [sym_host_command] = STATE(6),
    [sym_if_command] = STATE(6),
    [sym_import_command] = STATE(6),
    [sym_let_command] = STATE(6),
    [sym_label_command] = STATE(6),
    [sym_locally_command] = STATE(6),
    [sym_run_command] = STATE(6),
    [sym_save_artifact_command] = STATE(6),
    [sym_save_image_command] = STATE(6),
    [sym_set_command] = STATE(6),
    [sym_try_command] = STATE(6),
    [sym_user_command] = STATE(6),
    [sym_volume_command] = STATE(6),
    [sym_wait_command] = STATE(6),
    [sym_with_docker_command] = STATE(6),
    [sym_workdir_command] = STATE(6),
    [aux_sym_block_repeat1] = STATE(6),
    [anon_sym_PROJECT] = ACTIONS(151),
    [anon_sym_ARG] = ACTIONS(154),
    [anon_sym_BUILD] = ACTIONS(157),
    [anon_sym_CACHE] = ACTIONS(160),
    [anon_sym_CMD] = ACTIONS(163),
    [anon_sym_COPY] = ACTIONS(166),
    [anon_sym_DO] = ACTIONS(169),
    [anon_sym_ENTRYPOINT] = ACTIONS(172),
    [anon_sym_ENV] = ACTIONS(175),
    [anon_sym_EXPOSE] = ACTIONS(178),
    [anon_sym_FOR] = ACTIONS(181),
    [anon_sym_END] = ACTIONS(184),
    [anon_sym_FROM] = ACTIONS(186),
    [anon_sym_FROMDOCKERFILE] = ACTIONS(189),
    [anon_sym_FUNCTION] = ACTIONS(192),
    [anon_sym_COMMAND] = ACTIONS(192),
    [anon_sym_GITCLONE] = ACTIONS(195),
    [anon_sym_HOST] = ACTIONS(198),
    [anon_sym_IF] = ACTIONS(201),
    [anon_sym_IMPORT] = ACTIONS(204),
    [anon_sym_LET] = ACTIONS(207),
    [anon_sym_LABEL] = ACTIONS(210),
    [anon_sym_LOCALLY] = ACTIONS(213),
    [anon_sym_RUN] = ACTIONS(216),
    [anon_sym_SAVEARTIFACT] = ACTIONS(219),
    [anon_sym_SAVEIMAGE] = ACTIONS(222),
    [anon_sym_SET] = ACTIONS(225),
    [anon_sym_TRY] = ACTIONS(228),
    [anon_sym_FINALLY] = ACTIONS(184),
    [anon_sym_USER] = ACTIONS(231),
    [anon_sym_VOLUME] = ACTIONS(234),
    [anon_sym_WAIT] = ACTIONS(237),
    [anon_sym_WITHDOCKER] = ACTIONS(240),
    [anon_sym_WORKDIR] = ACTIONS(243),
    [aux_sym_block_token1] = ACTIONS(246),
    [anon_sym_ELSEIF] = ACTIONS(184),
    [anon_sym_ELSE] = ACTIONS(184),
    [sym_line_continuation] = ACTIONS(3),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation_comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(3),
    [anon_sym_CR_LF] = ACTIONS(3),
    [anon_sym_FF] = ACTIONS(3),
  },
  [7] = {
    [sym_project_command] = STATE(3),
    [sym_arg_command] = STATE(3),
    [sym_build_command] = STATE(3),
    [sym_cache_command] = STATE(3),
    [sym_cmd_command] = STATE(3),
    [sym_copy_command] = STATE(3),
    [sym_do_command] = STATE(3),
    [sym_entrypoint_command] = STATE(3),
    [sym_env_command] = STATE(3),
    [sym_expose_command] = STATE(3),
    [sym_for_command] = STATE(3),
    [sym_from_command] = STATE(3),
    [sym_from_dockerfile_command] = STATE(3),
    [sym_function_command] = STATE(3),
    [sym_git_clone_command] = STATE(3),
    [sym_host_command] = STATE(3),
    [sym_if_command] = STATE(3),
    [sym_import_command] = STATE(3),
    [sym_let_command] = STATE(3),
    [sym_label_command] = STATE(3),
    [sym_locally_command] = STATE(3),
    [sym_run_command] = STATE(3),
    [sym_save_artifact_command] = STATE(3),
    [sym_save_image_command] = STATE(3),
    [sym_set_command] = STATE(3),
    [sym_try_command] = STATE(3),
    [sym_user_command] = STATE(3),
    [sym_volume_command] = STATE(3),
    [sym_wait_command] = STATE(3),
    [sym_with_docker_command] = STATE(3),
    [sym_workdir_command] = STATE(3),
    [sym_block] = STATE(2716),
    [aux_sym_block_repeat1] = STATE(3),
    [anon_sym_PROJECT] = ACTIONS(79),
    [anon_sym_ARG] = ACTIONS(81),
    [anon_sym_BUILD] = ACTIONS(83),
    [anon_sym_CACHE] = ACTIONS(85),
    [anon_sym_CMD] = ACTIONS(87),
    [anon_sym_COPY] = ACTIONS(89),
    [anon_sym_DO] = ACTIONS(91),
    [anon_sym_ENTRYPOINT] = ACTIONS(93),
    [anon_sym_ENV] = ACTIONS(95),
    [anon_sym_EXPOSE] = ACTIONS(97),
    [anon_sym_FOR] = ACTIONS(99),
    [anon_sym_END] = ACTIONS(249),
    [anon_sym_FROM] = ACTIONS(103),
    [anon_sym_FROMDOCKERFILE] = ACTIONS(105),
    [anon_sym_FUNCTION] = ACTIONS(107),
    [anon_sym_COMMAND] = ACTIONS(107),
    [anon_sym_GITCLONE] = ACTIONS(109),
    [anon_sym_HOST] = ACTIONS(111),
    [anon_sym_IF] = ACTIONS(113),
    [anon_sym_IMPORT] = ACTIONS(115),
    [anon_sym_LET] = ACTIONS(117),
    [anon_sym_LABEL] = ACTIONS(119),
    [anon_sym_LOCALLY] = ACTIONS(121),
    [anon_sym_RUN] = ACTIONS(123),
    [anon_sym_SAVEARTIFACT] = ACTIONS(125),
    [anon_sym_SAVEIMAGE] = ACTIONS(127),
    [anon_sym_SET] = ACTIONS(129),
    [anon_sym_TRY] = ACTIONS(131),
    [anon_sym_USER] = ACTIONS(133),
    [anon_sym_VOLUME] = ACTIONS(135),
    [anon_sym_WAIT] = ACTIONS(137),
    [anon_sym_WITHDOCKER] = ACTIONS(139),
    [anon_sym_WORKDIR] = ACTIONS(141),
    [aux_sym_block_token1] = ACTIONS(147),
    [sym_line_continuation] = ACTIONS(3),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation_comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(3),
    [anon_sym_CR_LF] = ACTIONS(3),
    [anon_sym_FF] = ACTIONS(3),
  },
  [8] = {
    [sym_project_command] = STATE(3),
    [sym_arg_command] = STATE(3),
    [sym_build_command] = STATE(3),
    [sym_cache_command] = STATE(3),
    [sym_cmd_command] = STATE(3),
    [sym_copy_command] = STATE(3),
    [sym_do_command] = STATE(3),
    [sym_entrypoint_command] = STATE(3),
    [sym_env_command] = STATE(3),
    [sym_expose_command] = STATE(3),
    [sym_for_command] = STATE(3),
    [sym_from_command] = STATE(3),
    [sym_from_dockerfile_command] = STATE(3),
    [sym_function_command] = STATE(3),
    [sym_git_clone_command] = STATE(3),
    [sym_host_command] = STATE(3),
    [sym_if_command] = STATE(3),
    [sym_import_command] = STATE(3),
    [sym_let_command] = STATE(3),
    [sym_label_command] = STATE(3),
    [sym_locally_command] = STATE(3),
    [sym_run_command] = STATE(3),
    [sym_save_artifact_command] = STATE(3),
    [sym_save_image_command] = STATE(3),
    [sym_set_command] = STATE(3),
    [sym_try_command] = STATE(3),
    [sym_user_command] = STATE(3),
    [sym_volume_command] = STATE(3),
    [sym_wait_command] = STATE(3),
    [sym_with_docker_command] = STATE(3),
    [sym_workdir_command] = STATE(3),
    [sym_block] = STATE(2688),
    [aux_sym_block_repeat1] = STATE(3),
    [anon_sym_PROJECT] = ACTIONS(79),
    [anon_sym_ARG] = ACTIONS(81),
    [anon_sym_BUILD] = ACTIONS(83),
    [anon_sym_CACHE] = ACTIONS(85),
    [anon_sym_CMD] = ACTIONS(87),
    [anon_sym_COPY] = ACTIONS(89),
    [anon_sym_DO] = ACTIONS(91),
    [anon_sym_ENTRYPOINT] = ACTIONS(93),
    [anon_sym_ENV] = ACTIONS(95),
    [anon_sym_EXPOSE] = ACTIONS(97),
    [anon_sym_FOR] = ACTIONS(99),
    [anon_sym_END] = ACTIONS(251),
    [anon_sym_FROM] = ACTIONS(103),
    [anon_sym_FROMDOCKERFILE] = ACTIONS(105),
    [anon_sym_FUNCTION] = ACTIONS(107),
    [anon_sym_COMMAND] = ACTIONS(107),
    [anon_sym_GITCLONE] = ACTIONS(109),
    [anon_sym_HOST] = ACTIONS(111),
    [anon_sym_IF] = ACTIONS(113),
    [anon_sym_IMPORT] = ACTIONS(115),
    [anon_sym_LET] = ACTIONS(117),
    [anon_sym_LABEL] = ACTIONS(119),
    [anon_sym_LOCALLY] = ACTIONS(121),
    [anon_sym_RUN] = ACTIONS(123),
    [anon_sym_SAVEARTIFACT] = ACTIONS(125),
    [anon_sym_SAVEIMAGE] = ACTIONS(127),
    [anon_sym_SET] = ACTIONS(129),
    [anon_sym_TRY] = ACTIONS(131),
    [anon_sym_USER] = ACTIONS(133),
    [anon_sym_VOLUME] = ACTIONS(135),
    [anon_sym_WAIT] = ACTIONS(137),
    [anon_sym_WITHDOCKER] = ACTIONS(139),
    [anon_sym_WORKDIR] = ACTIONS(141),
    [aux_sym_block_token1] = ACTIONS(147),
    [sym_line_continuation] = ACTIONS(3),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation_comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(3),
    [anon_sym_CR_LF] = ACTIONS(3),
    [anon_sym_FF] = ACTIONS(3),
  },
  [9] = {
    [sym_project_command] = STATE(3),
    [sym_arg_command] = STATE(3),
    [sym_build_command] = STATE(3),
    [sym_cache_command] = STATE(3),
    [sym_cmd_command] = STATE(3),
    [sym_copy_command] = STATE(3),
    [sym_do_command] = STATE(3),
    [sym_entrypoint_command] = STATE(3),
    [sym_env_command] = STATE(3),
    [sym_expose_command] = STATE(3),
    [sym_for_command] = STATE(3),
    [sym_from_command] = STATE(3),
    [sym_from_dockerfile_command] = STATE(3),
    [sym_function_command] = STATE(3),
    [sym_git_clone_command] = STATE(3),
    [sym_host_command] = STATE(3),
    [sym_if_command] = STATE(3),
    [sym_import_command] = STATE(3),
    [sym_let_command] = STATE(3),
    [sym_label_command] = STATE(3),
    [sym_locally_command] = STATE(3),
    [sym_run_command] = STATE(3),
    [sym_save_artifact_command] = STATE(3),
    [sym_save_image_command] = STATE(3),
    [sym_set_command] = STATE(3),
    [sym_try_command] = STATE(3),
    [sym_user_command] = STATE(3),
    [sym_volume_command] = STATE(3),
    [sym_wait_command] = STATE(3),
    [sym_with_docker_command] = STATE(3),
    [sym_workdir_command] = STATE(3),
    [sym_block] = STATE(2701),
    [aux_sym_block_repeat1] = STATE(3),
    [anon_sym_PROJECT] = ACTIONS(79),
    [anon_sym_ARG] = ACTIONS(81),
    [anon_sym_BUILD] = ACTIONS(83),
    [anon_sym_CACHE] = ACTIONS(85),
    [anon_sym_CMD] = ACTIONS(87),
    [anon_sym_COPY] = ACTIONS(89),
    [anon_sym_DO] = ACTIONS(91),
    [anon_sym_ENTRYPOINT] = ACTIONS(93),
    [anon_sym_ENV] = ACTIONS(95),
    [anon_sym_EXPOSE] = ACTIONS(97),
    [anon_sym_FOR] = ACTIONS(99),
    [anon_sym_END] = ACTIONS(253),
    [anon_sym_FROM] = ACTIONS(103),
    [anon_sym_FROMDOCKERFILE] = ACTIONS(105),
    [anon_sym_FUNCTION] = ACTIONS(107),
    [anon_sym_COMMAND] = ACTIONS(107),
    [anon_sym_GITCLONE] = ACTIONS(109),
    [anon_sym_HOST] = ACTIONS(111),
    [anon_sym_IF] = ACTIONS(113),
    [anon_sym_IMPORT] = ACTIONS(115),
    [anon_sym_LET] = ACTIONS(117),
    [anon_sym_LABEL] = ACTIONS(119),
    [anon_sym_LOCALLY] = ACTIONS(121),
    [anon_sym_RUN] = ACTIONS(123),
    [anon_sym_SAVEARTIFACT] = ACTIONS(125),
    [anon_sym_SAVEIMAGE] = ACTIONS(127),
    [anon_sym_SET] = ACTIONS(129),
    [anon_sym_TRY] = ACTIONS(131),
    [anon_sym_USER] = ACTIONS(133),
    [anon_sym_VOLUME] = ACTIONS(135),
    [anon_sym_WAIT] = ACTIONS(137),
    [anon_sym_WITHDOCKER] = ACTIONS(139),
    [anon_sym_WORKDIR] = ACTIONS(141),
    [aux_sym_block_token1] = ACTIONS(147),
    [sym_line_continuation] = ACTIONS(3),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation_comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(3),
    [anon_sym_CR_LF] = ACTIONS(3),
    [anon_sym_FF] = ACTIONS(3),
  },
  [10] = {
    [sym_project_command] = STATE(16),
    [sym_arg_command] = STATE(16),
    [sym_build_command] = STATE(16),
    [sym_cache_command] = STATE(16),
    [sym_cmd_command] = STATE(16),
    [sym_copy_command] = STATE(16),
    [sym_do_command] = STATE(16),
    [sym_entrypoint_command] = STATE(16),
    [sym_env_command] = STATE(16),
    [sym_expose_command] = STATE(16),
    [sym_for_command] = STATE(16),
    [sym_from_command] = STATE(16),
    [sym_from_dockerfile_command] = STATE(16),
    [sym_function_command] = STATE(16),
    [sym_git_clone_command] = STATE(16),
    [sym_host_command] = STATE(16),
    [sym_if_command] = STATE(16),
    [sym_import_command] = STATE(16),
    [sym_let_command] = STATE(16),
    [sym_label_command] = STATE(16),
    [sym_locally_command] = STATE(16),
    [sym_run_command] = STATE(16),
    [sym_save_artifact_command] = STATE(16),
    [sym_save_image_command] = STATE(16),
    [sym_set_command] = STATE(16),
    [sym_try_command] = STATE(16),
    [sym_user_command] = STATE(16),
    [sym_volume_command] = STATE(16),
    [sym_wait_command] = STATE(16),
    [sym_with_docker_command] = STATE(16),
    [sym_workdir_command] = STATE(16),
    [aux_sym_block_repeat1] = STATE(16),
    [ts_builtin_sym_end] = ACTIONS(255),
    [anon_sym_PROJECT] = ACTIONS(9),
    [anon_sym_ARG] = ACTIONS(13),
    [anon_sym_BUILD] = ACTIONS(15),
    [anon_sym_CACHE] = ACTIONS(17),
    [anon_sym_CMD] = ACTIONS(19),
    [anon_sym_COPY] = ACTIONS(21),
    [anon_sym_DO] = ACTIONS(23),
    [anon_sym_ENTRYPOINT] = ACTIONS(25),
    [anon_sym_ENV] = ACTIONS(27),
    [anon_sym_EXPOSE] = ACTIONS(29),
    [anon_sym_FOR] = ACTIONS(31),
    [anon_sym_FROM] = ACTIONS(33),
    [anon_sym_FROMDOCKERFILE] = ACTIONS(35),
    [anon_sym_FUNCTION] = ACTIONS(37),
    [anon_sym_COMMAND] = ACTIONS(37),
    [anon_sym_GITCLONE] = ACTIONS(39),
    [anon_sym_HOST] = ACTIONS(41),
    [anon_sym_IF] = ACTIONS(43),
    [anon_sym_IMPORT] = ACTIONS(45),
    [anon_sym_LET] = ACTIONS(47),
    [anon_sym_LABEL] = ACTIONS(49),
    [anon_sym_LOCALLY] = ACTIONS(51),
    [anon_sym_RUN] = ACTIONS(53),
    [anon_sym_SAVEARTIFACT] = ACTIONS(55),
    [anon_sym_SAVEIMAGE] = ACTIONS(57),
    [anon_sym_SET] = ACTIONS(59),
    [anon_sym_TRY] = ACTIONS(61),
    [anon_sym_USER] = ACTIONS(63),
    [anon_sym_VOLUME] = ACTIONS(65),
    [anon_sym_WAIT] = ACTIONS(67),
    [anon_sym_WITHDOCKER] = ACTIONS(69),
    [anon_sym_WORKDIR] = ACTIONS(71),
    [aux_sym_block_token1] = ACTIONS(257),
    [sym__string_base_alpha] = ACTIONS(101),
    [sym_line_continuation] = ACTIONS(3),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation_comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(3),
    [anon_sym_CR_LF] = ACTIONS(3),
    [anon_sym_FF] = ACTIONS(3),
  },
  [11] = {
    [sym_project_command] = STATE(3),
    [sym_arg_command] = STATE(3),
    [sym_build_command] = STATE(3),
    [sym_cache_command] = STATE(3),
    [sym_cmd_command] = STATE(3),
    [sym_copy_command] = STATE(3),
    [sym_do_command] = STATE(3),
    [sym_entrypoint_command] = STATE(3),
    [sym_env_command] = STATE(3),
    [sym_expose_command] = STATE(3),
    [sym_for_command] = STATE(3),
    [sym_from_command] = STATE(3),
    [sym_from_dockerfile_command] = STATE(3),
    [sym_function_command] = STATE(3),
    [sym_git_clone_command] = STATE(3),
    [sym_host_command] = STATE(3),
    [sym_if_command] = STATE(3),
    [sym_import_command] = STATE(3),
    [sym_let_command] = STATE(3),
    [sym_label_command] = STATE(3),
    [sym_locally_command] = STATE(3),
    [sym_run_command] = STATE(3),
    [sym_save_artifact_command] = STATE(3),
    [sym_save_image_command] = STATE(3),
    [sym_set_command] = STATE(3),
    [sym_try_command] = STATE(3),
    [sym_user_command] = STATE(3),
    [sym_volume_command] = STATE(3),
    [sym_wait_command] = STATE(3),
    [sym_with_docker_command] = STATE(3),
    [sym_workdir_command] = STATE(3),
    [sym_block] = STATE(2693),
    [aux_sym_block_repeat1] = STATE(3),
    [anon_sym_PROJECT] = ACTIONS(79),
    [anon_sym_ARG] = ACTIONS(81),
    [anon_sym_BUILD] = ACTIONS(83),
    [anon_sym_CACHE] = ACTIONS(85),
    [anon_sym_CMD] = ACTIONS(87),
    [anon_sym_COPY] = ACTIONS(89),
    [anon_sym_DO] = ACTIONS(91),
    [anon_sym_ENTRYPOINT] = ACTIONS(93),
    [anon_sym_ENV] = ACTIONS(95),
    [anon_sym_EXPOSE] = ACTIONS(97),
    [anon_sym_FOR] = ACTIONS(99),
    [anon_sym_END] = ACTIONS(259),
    [anon_sym_FROM] = ACTIONS(103),
    [anon_sym_FROMDOCKERFILE] = ACTIONS(105),
    [anon_sym_FUNCTION] = ACTIONS(107),
    [anon_sym_COMMAND] = ACTIONS(107),
    [anon_sym_GITCLONE] = ACTIONS(109),
    [anon_sym_HOST] = ACTIONS(111),
    [anon_sym_IF] = ACTIONS(113),
    [anon_sym_IMPORT] = ACTIONS(115),
    [anon_sym_LET] = ACTIONS(117),
    [anon_sym_LABEL] = ACTIONS(119),
    [anon_sym_LOCALLY] = ACTIONS(121),
    [anon_sym_RUN] = ACTIONS(123),
    [anon_sym_SAVEARTIFACT] = ACTIONS(125),
    [anon_sym_SAVEIMAGE] = ACTIONS(127),
    [anon_sym_SET] = ACTIONS(129),
    [anon_sym_TRY] = ACTIONS(131),
    [anon_sym_USER] = ACTIONS(133),
    [anon_sym_VOLUME] = ACTIONS(135),
    [anon_sym_WAIT] = ACTIONS(137),
    [anon_sym_WITHDOCKER] = ACTIONS(139),
    [anon_sym_WORKDIR] = ACTIONS(141),
    [aux_sym_block_token1] = ACTIONS(147),
    [sym_line_continuation] = ACTIONS(3),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation_comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(3),
    [anon_sym_CR_LF] = ACTIONS(3),
    [anon_sym_FF] = ACTIONS(3),
  },
  [12] = {
    [sym_project_command] = STATE(3),
    [sym_arg_command] = STATE(3),
    [sym_build_command] = STATE(3),
    [sym_cache_command] = STATE(3),
    [sym_cmd_command] = STATE(3),
    [sym_copy_command] = STATE(3),
    [sym_do_command] = STATE(3),
    [sym_entrypoint_command] = STATE(3),
    [sym_env_command] = STATE(3),
    [sym_expose_command] = STATE(3),
    [sym_for_command] = STATE(3),
    [sym_from_command] = STATE(3),
    [sym_from_dockerfile_command] = STATE(3),
    [sym_function_command] = STATE(3),
    [sym_git_clone_command] = STATE(3),
    [sym_host_command] = STATE(3),
    [sym_if_command] = STATE(3),
    [sym_import_command] = STATE(3),
    [sym_let_command] = STATE(3),
    [sym_label_command] = STATE(3),
    [sym_locally_command] = STATE(3),
    [sym_run_command] = STATE(3),
    [sym_save_artifact_command] = STATE(3),
    [sym_save_image_command] = STATE(3),
    [sym_set_command] = STATE(3),
    [sym_try_command] = STATE(3),
    [sym_user_command] = STATE(3),
    [sym_volume_command] = STATE(3),
    [sym_wait_command] = STATE(3),
    [sym_with_docker_command] = STATE(3),
    [sym_workdir_command] = STATE(3),
    [sym_block] = STATE(2702),
    [aux_sym_block_repeat1] = STATE(3),
    [anon_sym_PROJECT] = ACTIONS(79),
    [anon_sym_ARG] = ACTIONS(81),
    [anon_sym_BUILD] = ACTIONS(83),
    [anon_sym_CACHE] = ACTIONS(85),
    [anon_sym_CMD] = ACTIONS(87),
    [anon_sym_COPY] = ACTIONS(89),
    [anon_sym_DO] = ACTIONS(91),
    [anon_sym_ENTRYPOINT] = ACTIONS(93),
    [anon_sym_ENV] = ACTIONS(95),
    [anon_sym_EXPOSE] = ACTIONS(97),
    [anon_sym_FOR] = ACTIONS(99),
    [anon_sym_END] = ACTIONS(261),
    [anon_sym_FROM] = ACTIONS(103),
    [anon_sym_FROMDOCKERFILE] = ACTIONS(105),
    [anon_sym_FUNCTION] = ACTIONS(107),
    [anon_sym_COMMAND] = ACTIONS(107),
    [anon_sym_GITCLONE] = ACTIONS(109),
    [anon_sym_HOST] = ACTIONS(111),
    [anon_sym_IF] = ACTIONS(113),
    [anon_sym_IMPORT] = ACTIONS(115),
    [anon_sym_LET] = ACTIONS(117),
    [anon_sym_LABEL] = ACTIONS(119),
    [anon_sym_LOCALLY] = ACTIONS(121),
    [anon_sym_RUN] = ACTIONS(123),
    [anon_sym_SAVEARTIFACT] = ACTIONS(125),
    [anon_sym_SAVEIMAGE] = ACTIONS(127),
    [anon_sym_SET] = ACTIONS(129),
    [anon_sym_TRY] = ACTIONS(131),
    [anon_sym_USER] = ACTIONS(133),
    [anon_sym_VOLUME] = ACTIONS(135),
    [anon_sym_WAIT] = ACTIONS(137),
    [anon_sym_WITHDOCKER] = ACTIONS(139),
    [anon_sym_WORKDIR] = ACTIONS(141),
    [aux_sym_block_token1] = ACTIONS(147),
    [sym_line_continuation] = ACTIONS(3),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation_comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(3),
    [anon_sym_CR_LF] = ACTIONS(3),
    [anon_sym_FF] = ACTIONS(3),
  },
  [13] = {
    [sym_project_command] = STATE(3),
    [sym_arg_command] = STATE(3),
    [sym_build_command] = STATE(3),
    [sym_cache_command] = STATE(3),
    [sym_cmd_command] = STATE(3),
    [sym_copy_command] = STATE(3),
    [sym_do_command] = STATE(3),
    [sym_entrypoint_command] = STATE(3),
    [sym_env_command] = STATE(3),
    [sym_expose_command] = STATE(3),
    [sym_for_command] = STATE(3),
    [sym_from_command] = STATE(3),
    [sym_from_dockerfile_command] = STATE(3),
    [sym_function_command] = STATE(3),
    [sym_git_clone_command] = STATE(3),
    [sym_host_command] = STATE(3),
    [sym_if_command] = STATE(3),
    [sym_import_command] = STATE(3),
    [sym_let_command] = STATE(3),
    [sym_label_command] = STATE(3),
    [sym_locally_command] = STATE(3),
    [sym_run_command] = STATE(3),
    [sym_save_artifact_command] = STATE(3),
    [sym_save_image_command] = STATE(3),
    [sym_set_command] = STATE(3),
    [sym_try_command] = STATE(3),
    [sym_user_command] = STATE(3),
    [sym_volume_command] = STATE(3),
    [sym_wait_command] = STATE(3),
    [sym_with_docker_command] = STATE(3),
    [sym_workdir_command] = STATE(3),
    [sym_block] = STATE(2677),
    [aux_sym_block_repeat1] = STATE(3),
    [anon_sym_PROJECT] = ACTIONS(79),
    [anon_sym_ARG] = ACTIONS(81),
    [anon_sym_BUILD] = ACTIONS(83),
    [anon_sym_CACHE] = ACTIONS(85),
    [anon_sym_CMD] = ACTIONS(87),
    [anon_sym_COPY] = ACTIONS(89),
    [anon_sym_DO] = ACTIONS(91),
    [anon_sym_ENTRYPOINT] = ACTIONS(93),
    [anon_sym_ENV] = ACTIONS(95),
    [anon_sym_EXPOSE] = ACTIONS(97),
    [anon_sym_FOR] = ACTIONS(99),
    [anon_sym_END] = ACTIONS(263),
    [anon_sym_FROM] = ACTIONS(103),
    [anon_sym_FROMDOCKERFILE] = ACTIONS(105),
    [anon_sym_FUNCTION] = ACTIONS(107),
    [anon_sym_COMMAND] = ACTIONS(107),
    [anon_sym_GITCLONE] = ACTIONS(109),
    [anon_sym_HOST] = ACTIONS(111),
    [anon_sym_IF] = ACTIONS(113),
    [anon_sym_IMPORT] = ACTIONS(115),
    [anon_sym_LET] = ACTIONS(117),
    [anon_sym_LABEL] = ACTIONS(119),
    [anon_sym_LOCALLY] = ACTIONS(121),
    [anon_sym_RUN] = ACTIONS(123),
    [anon_sym_SAVEARTIFACT] = ACTIONS(125),
    [anon_sym_SAVEIMAGE] = ACTIONS(127),
    [anon_sym_SET] = ACTIONS(129),
    [anon_sym_TRY] = ACTIONS(131),
    [anon_sym_USER] = ACTIONS(133),
    [anon_sym_VOLUME] = ACTIONS(135),
    [anon_sym_WAIT] = ACTIONS(137),
    [anon_sym_WITHDOCKER] = ACTIONS(139),
    [anon_sym_WORKDIR] = ACTIONS(141),
    [aux_sym_block_token1] = ACTIONS(147),
    [sym_line_continuation] = ACTIONS(3),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation_comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(3),
    [anon_sym_CR_LF] = ACTIONS(3),
    [anon_sym_FF] = ACTIONS(3),
  },
  [14] = {
    [sym_project_command] = STATE(3),
    [sym_arg_command] = STATE(3),
    [sym_build_command] = STATE(3),
    [sym_cache_command] = STATE(3),
    [sym_cmd_command] = STATE(3),
    [sym_copy_command] = STATE(3),
    [sym_do_command] = STATE(3),
    [sym_entrypoint_command] = STATE(3),
    [sym_env_command] = STATE(3),
    [sym_expose_command] = STATE(3),
    [sym_for_command] = STATE(3),
    [sym_from_command] = STATE(3),
    [sym_from_dockerfile_command] = STATE(3),
    [sym_function_command] = STATE(3),
    [sym_git_clone_command] = STATE(3),
    [sym_host_command] = STATE(3),
    [sym_if_command] = STATE(3),
    [sym_import_command] = STATE(3),
    [sym_let_command] = STATE(3),
    [sym_label_command] = STATE(3),
    [sym_locally_command] = STATE(3),
    [sym_run_command] = STATE(3),
    [sym_save_artifact_command] = STATE(3),
    [sym_save_image_command] = STATE(3),
    [sym_set_command] = STATE(3),
    [sym_try_command] = STATE(3),
    [sym_user_command] = STATE(3),
    [sym_volume_command] = STATE(3),
    [sym_wait_command] = STATE(3),
    [sym_with_docker_command] = STATE(3),
    [sym_workdir_command] = STATE(3),
    [sym_block] = STATE(2732),
    [aux_sym_block_repeat1] = STATE(3),
    [anon_sym_PROJECT] = ACTIONS(79),
    [anon_sym_ARG] = ACTIONS(81),
    [anon_sym_BUILD] = ACTIONS(83),
    [anon_sym_CACHE] = ACTIONS(85),
    [anon_sym_CMD] = ACTIONS(87),
    [anon_sym_COPY] = ACTIONS(89),
    [anon_sym_DO] = ACTIONS(91),
    [anon_sym_ENTRYPOINT] = ACTIONS(93),
    [anon_sym_ENV] = ACTIONS(95),
    [anon_sym_EXPOSE] = ACTIONS(97),
    [anon_sym_FOR] = ACTIONS(99),
    [anon_sym_FROM] = ACTIONS(103),
    [anon_sym_FROMDOCKERFILE] = ACTIONS(105),
    [anon_sym_FUNCTION] = ACTIONS(107),
    [anon_sym_COMMAND] = ACTIONS(107),
    [anon_sym_GITCLONE] = ACTIONS(109),
    [anon_sym_HOST] = ACTIONS(111),
    [anon_sym_IF] = ACTIONS(113),
    [anon_sym_IMPORT] = ACTIONS(115),
    [anon_sym_LET] = ACTIONS(117),
    [anon_sym_LABEL] = ACTIONS(119),
    [anon_sym_LOCALLY] = ACTIONS(121),
    [anon_sym_RUN] = ACTIONS(123),
    [anon_sym_SAVEARTIFACT] = ACTIONS(125),
    [anon_sym_SAVEIMAGE] = ACTIONS(127),
    [anon_sym_SET] = ACTIONS(129),
    [anon_sym_TRY] = ACTIONS(131),
    [anon_sym_FINALLY] = ACTIONS(265),
    [anon_sym_USER] = ACTIONS(133),
    [anon_sym_VOLUME] = ACTIONS(135),
    [anon_sym_WAIT] = ACTIONS(137),
    [anon_sym_WITHDOCKER] = ACTIONS(139),
    [anon_sym_WORKDIR] = ACTIONS(141),
    [aux_sym_block_token1] = ACTIONS(147),
    [sym_line_continuation] = ACTIONS(3),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation_comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(3),
    [anon_sym_CR_LF] = ACTIONS(3),
    [anon_sym_FF] = ACTIONS(3),
  },
  [15] = {
    [sym_project_command] = STATE(22),
    [sym_arg_command] = STATE(22),
    [sym_build_command] = STATE(22),
    [sym_cache_command] = STATE(22),
    [sym_cmd_command] = STATE(22),
    [sym_copy_command] = STATE(22),
    [sym_do_command] = STATE(22),
    [sym_entrypoint_command] = STATE(22),
    [sym_env_command] = STATE(22),
    [sym_expose_command] = STATE(22),
    [sym_for_command] = STATE(22),
    [sym_from_command] = STATE(22),
    [sym_from_dockerfile_command] = STATE(22),
    [sym_function_command] = STATE(22),
    [sym_git_clone_command] = STATE(22),
    [sym_host_command] = STATE(22),
    [sym_if_command] = STATE(22),
    [sym_import_command] = STATE(22),
    [sym_let_command] = STATE(22),
    [sym_label_command] = STATE(22),
    [sym_locally_command] = STATE(22),
    [sym_run_command] = STATE(22),
    [sym_save_artifact_command] = STATE(22),
    [sym_save_image_command] = STATE(22),
    [sym_set_command] = STATE(22),
    [sym_try_command] = STATE(22),
    [sym_user_command] = STATE(22),
    [sym_volume_command] = STATE(22),
    [sym_wait_command] = STATE(22),
    [sym_with_docker_command] = STATE(22),
    [sym_workdir_command] = STATE(22),
    [sym_block] = STATE(2737),
    [aux_sym_block_repeat1] = STATE(22),
    [anon_sym_PROJECT] = ACTIONS(267),
    [anon_sym_ARG] = ACTIONS(269),
    [anon_sym_BUILD] = ACTIONS(271),
    [anon_sym_CACHE] = ACTIONS(273),
    [anon_sym_CMD] = ACTIONS(275),
    [anon_sym_COPY] = ACTIONS(277),
    [anon_sym_DO] = ACTIONS(279),
    [anon_sym_ENTRYPOINT] = ACTIONS(281),
    [anon_sym_ENV] = ACTIONS(283),
    [anon_sym_EXPOSE] = ACTIONS(285),
    [anon_sym_FOR] = ACTIONS(287),
    [anon_sym_FROM] = ACTIONS(289),
    [anon_sym_FROMDOCKERFILE] = ACTIONS(291),
    [anon_sym_FUNCTION] = ACTIONS(293),
    [anon_sym_COMMAND] = ACTIONS(293),
    [anon_sym_GITCLONE] = ACTIONS(295),
    [anon_sym_HOST] = ACTIONS(297),
    [anon_sym_IF] = ACTIONS(299),
    [anon_sym_IMPORT] = ACTIONS(301),
    [anon_sym_LET] = ACTIONS(303),
    [anon_sym_LABEL] = ACTIONS(305),
    [anon_sym_LOCALLY] = ACTIONS(307),
    [anon_sym_RUN] = ACTIONS(309),
    [anon_sym_SAVEARTIFACT] = ACTIONS(311),
    [anon_sym_SAVEIMAGE] = ACTIONS(313),
    [anon_sym_SET] = ACTIONS(315),
    [anon_sym_TRY] = ACTIONS(317),
    [anon_sym_USER] = ACTIONS(319),
    [anon_sym_VOLUME] = ACTIONS(321),
    [anon_sym_WAIT] = ACTIONS(323),
    [anon_sym_WITHDOCKER] = ACTIONS(325),
    [anon_sym_WORKDIR] = ACTIONS(327),
    [aux_sym_block_token1] = ACTIONS(329),
    [sym_line_continuation] = ACTIONS(3),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation_comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(3),
    [anon_sym_CR_LF] = ACTIONS(3),
    [anon_sym_FF] = ACTIONS(3),
    [sym__dedent] = ACTIONS(331),
  },
  [16] = {
    [sym_project_command] = STATE(16),
    [sym_arg_command] = STATE(16),
    [sym_build_command] = STATE(16),
    [sym_cache_command] = STATE(16),
    [sym_cmd_command] = STATE(16),
    [sym_copy_command] = STATE(16),
    [sym_do_command] = STATE(16),
    [sym_entrypoint_command] = STATE(16),
    [sym_env_command] = STATE(16),
    [sym_expose_command] = STATE(16),
    [sym_for_command] = STATE(16),
    [sym_from_command] = STATE(16),
    [sym_from_dockerfile_command] = STATE(16),
    [sym_function_command] = STATE(16),
    [sym_git_clone_command] = STATE(16),
    [sym_host_command] = STATE(16),
    [sym_if_command] = STATE(16),
    [sym_import_command] = STATE(16),
    [sym_let_command] = STATE(16),
    [sym_label_command] = STATE(16),
    [sym_locally_command] = STATE(16),
    [sym_run_command] = STATE(16),
    [sym_save_artifact_command] = STATE(16),
    [sym_save_image_command] = STATE(16),
    [sym_set_command] = STATE(16),
    [sym_try_command] = STATE(16),
    [sym_user_command] = STATE(16),
    [sym_volume_command] = STATE(16),
    [sym_wait_command] = STATE(16),
    [sym_with_docker_command] = STATE(16),
    [sym_workdir_command] = STATE(16),
    [aux_sym_block_repeat1] = STATE(16),
    [ts_builtin_sym_end] = ACTIONS(333),
    [anon_sym_PROJECT] = ACTIONS(335),
    [anon_sym_ARG] = ACTIONS(338),
    [anon_sym_BUILD] = ACTIONS(341),
    [anon_sym_CACHE] = ACTIONS(344),
    [anon_sym_CMD] = ACTIONS(347),
    [anon_sym_COPY] = ACTIONS(350),
    [anon_sym_DO] = ACTIONS(353),
    [anon_sym_ENTRYPOINT] = ACTIONS(356),
    [anon_sym_ENV] = ACTIONS(359),
    [anon_sym_EXPOSE] = ACTIONS(362),
    [anon_sym_FOR] = ACTIONS(365),
    [anon_sym_FROM] = ACTIONS(368),
    [anon_sym_FROMDOCKERFILE] = ACTIONS(371),
    [anon_sym_FUNCTION] = ACTIONS(374),
    [anon_sym_COMMAND] = ACTIONS(374),
    [anon_sym_GITCLONE] = ACTIONS(377),
    [anon_sym_HOST] = ACTIONS(380),
    [anon_sym_IF] = ACTIONS(383),
    [anon_sym_IMPORT] = ACTIONS(386),
    [anon_sym_LET] = ACTIONS(389),
    [anon_sym_LABEL] = ACTIONS(392),
    [anon_sym_LOCALLY] = ACTIONS(395),
    [anon_sym_RUN] = ACTIONS(398),
    [anon_sym_SAVEARTIFACT] = ACTIONS(401),
    [anon_sym_SAVEIMAGE] = ACTIONS(404),
    [anon_sym_SET] = ACTIONS(407),
    [anon_sym_TRY] = ACTIONS(410),
    [anon_sym_USER] = ACTIONS(413),
    [anon_sym_VOLUME] = ACTIONS(416),
    [anon_sym_WAIT] = ACTIONS(419),
    [anon_sym_WITHDOCKER] = ACTIONS(422),
    [anon_sym_WORKDIR] = ACTIONS(425),
    [aux_sym_block_token1] = ACTIONS(428),
    [sym__string_base_alpha] = ACTIONS(184),
    [sym_line_continuation] = ACTIONS(3),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation_comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(3),
    [anon_sym_CR_LF] = ACTIONS(3),
    [anon_sym_FF] = ACTIONS(3),
  },
  [17] = {
    [sym_project_command] = STATE(3),
    [sym_arg_command] = STATE(3),
    [sym_build_command] = STATE(3),
    [sym_cache_command] = STATE(3),
    [sym_cmd_command] = STATE(3),
    [sym_copy_command] = STATE(3),
    [sym_do_command] = STATE(3),
    [sym_entrypoint_command] = STATE(3),
    [sym_env_command] = STATE(3),
    [sym_expose_command] = STATE(3),
    [sym_for_command] = STATE(3),
    [sym_from_command] = STATE(3),
    [sym_from_dockerfile_command] = STATE(3),
    [sym_function_command] = STATE(3),
    [sym_git_clone_command] = STATE(3),
    [sym_host_command] = STATE(3),
    [sym_if_command] = STATE(3),
    [sym_import_command] = STATE(3),
    [sym_let_command] = STATE(3),
    [sym_label_command] = STATE(3),
    [sym_locally_command] = STATE(3),
    [sym_run_command] = STATE(3),
    [sym_save_artifact_command] = STATE(3),
    [sym_save_image_command] = STATE(3),
    [sym_set_command] = STATE(3),
    [sym_try_command] = STATE(3),
    [sym_user_command] = STATE(3),
    [sym_volume_command] = STATE(3),
    [sym_wait_command] = STATE(3),
    [sym_with_docker_command] = STATE(3),
    [sym_workdir_command] = STATE(3),
    [sym_block] = STATE(2675),
    [aux_sym_block_repeat1] = STATE(3),
    [anon_sym_PROJECT] = ACTIONS(79),
    [anon_sym_ARG] = ACTIONS(81),
    [anon_sym_BUILD] = ACTIONS(83),
    [anon_sym_CACHE] = ACTIONS(85),
    [anon_sym_CMD] = ACTIONS(87),
    [anon_sym_COPY] = ACTIONS(89),
    [anon_sym_DO] = ACTIONS(91),
    [anon_sym_ENTRYPOINT] = ACTIONS(93),
    [anon_sym_ENV] = ACTIONS(95),
    [anon_sym_EXPOSE] = ACTIONS(97),
    [anon_sym_FOR] = ACTIONS(99),
    [anon_sym_END] = ACTIONS(431),
    [anon_sym_FROM] = ACTIONS(103),
    [anon_sym_FROMDOCKERFILE] = ACTIONS(105),
    [anon_sym_FUNCTION] = ACTIONS(107),
    [anon_sym_COMMAND] = ACTIONS(107),
    [anon_sym_GITCLONE] = ACTIONS(109),
    [anon_sym_HOST] = ACTIONS(111),
    [anon_sym_IF] = ACTIONS(113),
    [anon_sym_IMPORT] = ACTIONS(115),
    [anon_sym_LET] = ACTIONS(117),
    [anon_sym_LABEL] = ACTIONS(119),
    [anon_sym_LOCALLY] = ACTIONS(121),
    [anon_sym_RUN] = ACTIONS(123),
    [anon_sym_SAVEARTIFACT] = ACTIONS(125),
    [anon_sym_SAVEIMAGE] = ACTIONS(127),
    [anon_sym_SET] = ACTIONS(129),
    [anon_sym_TRY] = ACTIONS(131),
    [anon_sym_USER] = ACTIONS(133),
    [anon_sym_VOLUME] = ACTIONS(135),
    [anon_sym_WAIT] = ACTIONS(137),
    [anon_sym_WITHDOCKER] = ACTIONS(139),
    [anon_sym_WORKDIR] = ACTIONS(141),
    [aux_sym_block_token1] = ACTIONS(147),
    [sym_line_continuation] = ACTIONS(3),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation_comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(3),
    [anon_sym_CR_LF] = ACTIONS(3),
    [anon_sym_FF] = ACTIONS(3),
  },
  [18] = {
    [sym_project_command] = STATE(3),
    [sym_arg_command] = STATE(3),
    [sym_build_command] = STATE(3),
    [sym_cache_command] = STATE(3),
    [sym_cmd_command] = STATE(3),
    [sym_copy_command] = STATE(3),
    [sym_do_command] = STATE(3),
    [sym_entrypoint_command] = STATE(3),
    [sym_env_command] = STATE(3),
    [sym_expose_command] = STATE(3),
    [sym_for_command] = STATE(3),
    [sym_from_command] = STATE(3),
    [sym_from_dockerfile_command] = STATE(3),
    [sym_function_command] = STATE(3),
    [sym_git_clone_command] = STATE(3),
    [sym_host_command] = STATE(3),
    [sym_if_command] = STATE(3),
    [sym_import_command] = STATE(3),
    [sym_let_command] = STATE(3),
    [sym_label_command] = STATE(3),
    [sym_locally_command] = STATE(3),
    [sym_run_command] = STATE(3),
    [sym_save_artifact_command] = STATE(3),
    [sym_save_image_command] = STATE(3),
    [sym_set_command] = STATE(3),
    [sym_try_command] = STATE(3),
    [sym_user_command] = STATE(3),
    [sym_volume_command] = STATE(3),
    [sym_wait_command] = STATE(3),
    [sym_with_docker_command] = STATE(3),
    [sym_workdir_command] = STATE(3),
    [sym_block] = STATE(2698),
    [aux_sym_block_repeat1] = STATE(3),
    [anon_sym_PROJECT] = ACTIONS(79),
    [anon_sym_ARG] = ACTIONS(81),
    [anon_sym_BUILD] = ACTIONS(83),
    [anon_sym_CACHE] = ACTIONS(85),
    [anon_sym_CMD] = ACTIONS(87),
    [anon_sym_COPY] = ACTIONS(89),
    [anon_sym_DO] = ACTIONS(91),
    [anon_sym_ENTRYPOINT] = ACTIONS(93),
    [anon_sym_ENV] = ACTIONS(95),
    [anon_sym_EXPOSE] = ACTIONS(97),
    [anon_sym_FOR] = ACTIONS(99),
    [anon_sym_END] = ACTIONS(433),
    [anon_sym_FROM] = ACTIONS(103),
    [anon_sym_FROMDOCKERFILE] = ACTIONS(105),
    [anon_sym_FUNCTION] = ACTIONS(107),
    [anon_sym_COMMAND] = ACTIONS(107),
    [anon_sym_GITCLONE] = ACTIONS(109),
    [anon_sym_HOST] = ACTIONS(111),
    [anon_sym_IF] = ACTIONS(113),
    [anon_sym_IMPORT] = ACTIONS(115),
    [anon_sym_LET] = ACTIONS(117),
    [anon_sym_LABEL] = ACTIONS(119),
    [anon_sym_LOCALLY] = ACTIONS(121),
    [anon_sym_RUN] = ACTIONS(123),
    [anon_sym_SAVEARTIFACT] = ACTIONS(125),
    [anon_sym_SAVEIMAGE] = ACTIONS(127),
    [anon_sym_SET] = ACTIONS(129),
    [anon_sym_TRY] = ACTIONS(131),
    [anon_sym_USER] = ACTIONS(133),
    [anon_sym_VOLUME] = ACTIONS(135),
    [anon_sym_WAIT] = ACTIONS(137),
    [anon_sym_WITHDOCKER] = ACTIONS(139),
    [anon_sym_WORKDIR] = ACTIONS(141),
    [aux_sym_block_token1] = ACTIONS(147),
    [sym_line_continuation] = ACTIONS(3),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation_comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(3),
    [anon_sym_CR_LF] = ACTIONS(3),
    [anon_sym_FF] = ACTIONS(3),
  },
  [19] = {
    [sym_project_command] = STATE(3),
    [sym_arg_command] = STATE(3),
    [sym_build_command] = STATE(3),
    [sym_cache_command] = STATE(3),
    [sym_cmd_command] = STATE(3),
    [sym_copy_command] = STATE(3),
    [sym_do_command] = STATE(3),
    [sym_entrypoint_command] = STATE(3),
    [sym_env_command] = STATE(3),
    [sym_expose_command] = STATE(3),
    [sym_for_command] = STATE(3),
    [sym_from_command] = STATE(3),
    [sym_from_dockerfile_command] = STATE(3),
    [sym_function_command] = STATE(3),
    [sym_git_clone_command] = STATE(3),
    [sym_host_command] = STATE(3),
    [sym_if_command] = STATE(3),
    [sym_import_command] = STATE(3),
    [sym_let_command] = STATE(3),
    [sym_label_command] = STATE(3),
    [sym_locally_command] = STATE(3),
    [sym_run_command] = STATE(3),
    [sym_save_artifact_command] = STATE(3),
    [sym_save_image_command] = STATE(3),
    [sym_set_command] = STATE(3),
    [sym_try_command] = STATE(3),
    [sym_user_command] = STATE(3),
    [sym_volume_command] = STATE(3),
    [sym_wait_command] = STATE(3),
    [sym_with_docker_command] = STATE(3),
    [sym_workdir_command] = STATE(3),
    [sym_block] = STATE(2692),
    [aux_sym_block_repeat1] = STATE(3),
    [anon_sym_PROJECT] = ACTIONS(79),
    [anon_sym_ARG] = ACTIONS(81),
    [anon_sym_BUILD] = ACTIONS(83),
    [anon_sym_CACHE] = ACTIONS(85),
    [anon_sym_CMD] = ACTIONS(87),
    [anon_sym_COPY] = ACTIONS(89),
    [anon_sym_DO] = ACTIONS(91),
    [anon_sym_ENTRYPOINT] = ACTIONS(93),
    [anon_sym_ENV] = ACTIONS(95),
    [anon_sym_EXPOSE] = ACTIONS(97),
    [anon_sym_FOR] = ACTIONS(99),
    [anon_sym_FROM] = ACTIONS(103),
    [anon_sym_FROMDOCKERFILE] = ACTIONS(105),
    [anon_sym_FUNCTION] = ACTIONS(107),
    [anon_sym_COMMAND] = ACTIONS(107),
    [anon_sym_GITCLONE] = ACTIONS(109),
    [anon_sym_HOST] = ACTIONS(111),
    [anon_sym_IF] = ACTIONS(113),
    [anon_sym_IMPORT] = ACTIONS(115),
    [anon_sym_LET] = ACTIONS(117),
    [anon_sym_LABEL] = ACTIONS(119),
    [anon_sym_LOCALLY] = ACTIONS(121),
    [anon_sym_RUN] = ACTIONS(123),
    [anon_sym_SAVEARTIFACT] = ACTIONS(125),
    [anon_sym_SAVEIMAGE] = ACTIONS(127),
    [anon_sym_SET] = ACTIONS(129),
    [anon_sym_TRY] = ACTIONS(131),
    [anon_sym_FINALLY] = ACTIONS(435),
    [anon_sym_USER] = ACTIONS(133),
    [anon_sym_VOLUME] = ACTIONS(135),
    [anon_sym_WAIT] = ACTIONS(137),
    [anon_sym_WITHDOCKER] = ACTIONS(139),
    [anon_sym_WORKDIR] = ACTIONS(141),
    [aux_sym_block_token1] = ACTIONS(147),
    [sym_line_continuation] = ACTIONS(3),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation_comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(3),
    [anon_sym_CR_LF] = ACTIONS(3),
    [anon_sym_FF] = ACTIONS(3),
  },
  [20] = {
    [sym_project_command] = STATE(3),
    [sym_arg_command] = STATE(3),
    [sym_build_command] = STATE(3),
    [sym_cache_command] = STATE(3),
    [sym_cmd_command] = STATE(3),
    [sym_copy_command] = STATE(3),
    [sym_do_command] = STATE(3),
    [sym_entrypoint_command] = STATE(3),
    [sym_env_command] = STATE(3),
    [sym_expose_command] = STATE(3),
    [sym_for_command] = STATE(3),
    [sym_from_command] = STATE(3),
    [sym_from_dockerfile_command] = STATE(3),
    [sym_function_command] = STATE(3),
    [sym_git_clone_command] = STATE(3),
    [sym_host_command] = STATE(3),
    [sym_if_command] = STATE(3),
    [sym_import_command] = STATE(3),
    [sym_let_command] = STATE(3),
    [sym_label_command] = STATE(3),
    [sym_locally_command] = STATE(3),
    [sym_run_command] = STATE(3),
    [sym_save_artifact_command] = STATE(3),
    [sym_save_image_command] = STATE(3),
    [sym_set_command] = STATE(3),
    [sym_try_command] = STATE(3),
    [sym_user_command] = STATE(3),
    [sym_volume_command] = STATE(3),
    [sym_wait_command] = STATE(3),
    [sym_with_docker_command] = STATE(3),
    [sym_workdir_command] = STATE(3),
    [sym_block] = STATE(2722),
    [aux_sym_block_repeat1] = STATE(3),
    [anon_sym_PROJECT] = ACTIONS(79),
    [anon_sym_ARG] = ACTIONS(81),
    [anon_sym_BUILD] = ACTIONS(83),
    [anon_sym_CACHE] = ACTIONS(85),
    [anon_sym_CMD] = ACTIONS(87),
    [anon_sym_COPY] = ACTIONS(89),
    [anon_sym_DO] = ACTIONS(91),
    [anon_sym_ENTRYPOINT] = ACTIONS(93),
    [anon_sym_ENV] = ACTIONS(95),
    [anon_sym_EXPOSE] = ACTIONS(97),
    [anon_sym_FOR] = ACTIONS(99),
    [anon_sym_FROM] = ACTIONS(103),
    [anon_sym_FROMDOCKERFILE] = ACTIONS(105),
    [anon_sym_FUNCTION] = ACTIONS(107),
    [anon_sym_COMMAND] = ACTIONS(107),
    [anon_sym_GITCLONE] = ACTIONS(109),
    [anon_sym_HOST] = ACTIONS(111),
    [anon_sym_IF] = ACTIONS(113),
    [anon_sym_IMPORT] = ACTIONS(115),
    [anon_sym_LET] = ACTIONS(117),
    [anon_sym_LABEL] = ACTIONS(119),
    [anon_sym_LOCALLY] = ACTIONS(121),
    [anon_sym_RUN] = ACTIONS(123),
    [anon_sym_SAVEARTIFACT] = ACTIONS(125),
    [anon_sym_SAVEIMAGE] = ACTIONS(127),
    [anon_sym_SET] = ACTIONS(129),
    [anon_sym_TRY] = ACTIONS(131),
    [anon_sym_FINALLY] = ACTIONS(437),
    [anon_sym_USER] = ACTIONS(133),
    [anon_sym_VOLUME] = ACTIONS(135),
    [anon_sym_WAIT] = ACTIONS(137),
    [anon_sym_WITHDOCKER] = ACTIONS(139),
    [anon_sym_WORKDIR] = ACTIONS(141),
    [aux_sym_block_token1] = ACTIONS(147),
    [sym_line_continuation] = ACTIONS(3),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation_comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(3),
    [anon_sym_CR_LF] = ACTIONS(3),
    [anon_sym_FF] = ACTIONS(3),
  },
  [21] = {
    [sym_project_command] = STATE(3),
    [sym_arg_command] = STATE(3),
    [sym_build_command] = STATE(3),
    [sym_cache_command] = STATE(3),
    [sym_cmd_command] = STATE(3),
    [sym_copy_command] = STATE(3),
    [sym_do_command] = STATE(3),
    [sym_entrypoint_command] = STATE(3),
    [sym_env_command] = STATE(3),
    [sym_expose_command] = STATE(3),
    [sym_for_command] = STATE(3),
    [sym_from_command] = STATE(3),
    [sym_from_dockerfile_command] = STATE(3),
    [sym_function_command] = STATE(3),
    [sym_git_clone_command] = STATE(3),
    [sym_host_command] = STATE(3),
    [sym_if_command] = STATE(3),
    [sym_import_command] = STATE(3),
    [sym_let_command] = STATE(3),
    [sym_label_command] = STATE(3),
    [sym_locally_command] = STATE(3),
    [sym_run_command] = STATE(3),
    [sym_save_artifact_command] = STATE(3),
    [sym_save_image_command] = STATE(3),
    [sym_set_command] = STATE(3),
    [sym_try_command] = STATE(3),
    [sym_user_command] = STATE(3),
    [sym_volume_command] = STATE(3),
    [sym_wait_command] = STATE(3),
    [sym_with_docker_command] = STATE(3),
    [sym_workdir_command] = STATE(3),
    [sym_block] = STATE(2741),
    [aux_sym_block_repeat1] = STATE(3),
    [anon_sym_PROJECT] = ACTIONS(79),
    [anon_sym_ARG] = ACTIONS(81),
    [anon_sym_BUILD] = ACTIONS(83),
    [anon_sym_CACHE] = ACTIONS(85),
    [anon_sym_CMD] = ACTIONS(87),
    [anon_sym_COPY] = ACTIONS(89),
    [anon_sym_DO] = ACTIONS(91),
    [anon_sym_ENTRYPOINT] = ACTIONS(93),
    [anon_sym_ENV] = ACTIONS(95),
    [anon_sym_EXPOSE] = ACTIONS(97),
    [anon_sym_FOR] = ACTIONS(99),
    [anon_sym_END] = ACTIONS(439),
    [anon_sym_FROM] = ACTIONS(103),
    [anon_sym_FROMDOCKERFILE] = ACTIONS(105),
    [anon_sym_FUNCTION] = ACTIONS(107),
    [anon_sym_COMMAND] = ACTIONS(107),
    [anon_sym_GITCLONE] = ACTIONS(109),
    [anon_sym_HOST] = ACTIONS(111),
    [anon_sym_IF] = ACTIONS(113),
    [anon_sym_IMPORT] = ACTIONS(115),
    [anon_sym_LET] = ACTIONS(117),
    [anon_sym_LABEL] = ACTIONS(119),
    [anon_sym_LOCALLY] = ACTIONS(121),
    [anon_sym_RUN] = ACTIONS(123),
    [anon_sym_SAVEARTIFACT] = ACTIONS(125),
    [anon_sym_SAVEIMAGE] = ACTIONS(127),
    [anon_sym_SET] = ACTIONS(129),
    [anon_sym_TRY] = ACTIONS(131),
    [anon_sym_USER] = ACTIONS(133),
    [anon_sym_VOLUME] = ACTIONS(135),
    [anon_sym_WAIT] = ACTIONS(137),
    [anon_sym_WITHDOCKER] = ACTIONS(139),
    [anon_sym_WORKDIR] = ACTIONS(141),
    [aux_sym_block_token1] = ACTIONS(147),
    [sym_line_continuation] = ACTIONS(3),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation_comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(3),
    [anon_sym_CR_LF] = ACTIONS(3),
    [anon_sym_FF] = ACTIONS(3),
  },
  [22] = {
    [sym_project_command] = STATE(26),
    [sym_arg_command] = STATE(26),
    [sym_build_command] = STATE(26),
    [sym_cache_command] = STATE(26),
    [sym_cmd_command] = STATE(26),
    [sym_copy_command] = STATE(26),
    [sym_do_command] = STATE(26),
    [sym_entrypoint_command] = STATE(26),
    [sym_env_command] = STATE(26),
    [sym_expose_command] = STATE(26),
    [sym_for_command] = STATE(26),
    [sym_from_command] = STATE(26),
    [sym_from_dockerfile_command] = STATE(26),
    [sym_function_command] = STATE(26),
    [sym_git_clone_command] = STATE(26),
    [sym_host_command] = STATE(26),
    [sym_if_command] = STATE(26),
    [sym_import_command] = STATE(26),
    [sym_let_command] = STATE(26),
    [sym_label_command] = STATE(26),
    [sym_locally_command] = STATE(26),
    [sym_run_command] = STATE(26),
    [sym_save_artifact_command] = STATE(26),
    [sym_save_image_command] = STATE(26),
    [sym_set_command] = STATE(26),
    [sym_try_command] = STATE(26),
    [sym_user_command] = STATE(26),
    [sym_volume_command] = STATE(26),
    [sym_wait_command] = STATE(26),
    [sym_with_docker_command] = STATE(26),
    [sym_workdir_command] = STATE(26),
    [aux_sym_block_repeat1] = STATE(26),
    [anon_sym_PROJECT] = ACTIONS(267),
    [anon_sym_ARG] = ACTIONS(269),
    [anon_sym_BUILD] = ACTIONS(271),
    [anon_sym_CACHE] = ACTIONS(273),
    [anon_sym_CMD] = ACTIONS(275),
    [anon_sym_COPY] = ACTIONS(277),
    [anon_sym_DO] = ACTIONS(279),
    [anon_sym_ENTRYPOINT] = ACTIONS(281),
    [anon_sym_ENV] = ACTIONS(283),
    [anon_sym_EXPOSE] = ACTIONS(285),
    [anon_sym_FOR] = ACTIONS(287),
    [anon_sym_FROM] = ACTIONS(289),
    [anon_sym_FROMDOCKERFILE] = ACTIONS(291),
    [anon_sym_FUNCTION] = ACTIONS(293),
    [anon_sym_COMMAND] = ACTIONS(293),
    [anon_sym_GITCLONE] = ACTIONS(295),
    [anon_sym_HOST] = ACTIONS(297),
    [anon_sym_IF] = ACTIONS(299),
    [anon_sym_IMPORT] = ACTIONS(301),
    [anon_sym_LET] = ACTIONS(303),
    [anon_sym_LABEL] = ACTIONS(305),
    [anon_sym_LOCALLY] = ACTIONS(307),
    [anon_sym_RUN] = ACTIONS(309),
    [anon_sym_SAVEARTIFACT] = ACTIONS(311),
    [anon_sym_SAVEIMAGE] = ACTIONS(313),
    [anon_sym_SET] = ACTIONS(315),
    [anon_sym_TRY] = ACTIONS(317),
    [anon_sym_USER] = ACTIONS(319),
    [anon_sym_VOLUME] = ACTIONS(321),
    [anon_sym_WAIT] = ACTIONS(323),
    [anon_sym_WITHDOCKER] = ACTIONS(325),
    [anon_sym_WORKDIR] = ACTIONS(327),
    [aux_sym_block_token1] = ACTIONS(441),
    [sym_line_continuation] = ACTIONS(3),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation_comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(3),
    [anon_sym_CR_LF] = ACTIONS(3),
    [anon_sym_FF] = ACTIONS(3),
    [sym__dedent] = ACTIONS(255),
  },
  [23] = {
    [sym_project_command] = STATE(3),
    [sym_arg_command] = STATE(3),
    [sym_build_command] = STATE(3),
    [sym_cache_command] = STATE(3),
    [sym_cmd_command] = STATE(3),
    [sym_copy_command] = STATE(3),
    [sym_do_command] = STATE(3),
    [sym_entrypoint_command] = STATE(3),
    [sym_env_command] = STATE(3),
    [sym_expose_command] = STATE(3),
    [sym_for_command] = STATE(3),
    [sym_from_command] = STATE(3),
    [sym_from_dockerfile_command] = STATE(3),
    [sym_function_command] = STATE(3),
    [sym_git_clone_command] = STATE(3),
    [sym_host_command] = STATE(3),
    [sym_if_command] = STATE(3),
    [sym_import_command] = STATE(3),
    [sym_let_command] = STATE(3),
    [sym_label_command] = STATE(3),
    [sym_locally_command] = STATE(3),
    [sym_run_command] = STATE(3),
    [sym_save_artifact_command] = STATE(3),
    [sym_save_image_command] = STATE(3),
    [sym_set_command] = STATE(3),
    [sym_try_command] = STATE(3),
    [sym_user_command] = STATE(3),
    [sym_volume_command] = STATE(3),
    [sym_wait_command] = STATE(3),
    [sym_with_docker_command] = STATE(3),
    [sym_workdir_command] = STATE(3),
    [sym_block] = STATE(2721),
    [aux_sym_block_repeat1] = STATE(3),
    [anon_sym_PROJECT] = ACTIONS(79),
    [anon_sym_ARG] = ACTIONS(81),
    [anon_sym_BUILD] = ACTIONS(83),
    [anon_sym_CACHE] = ACTIONS(85),
    [anon_sym_CMD] = ACTIONS(87),
    [anon_sym_COPY] = ACTIONS(89),
    [anon_sym_DO] = ACTIONS(91),
    [anon_sym_ENTRYPOINT] = ACTIONS(93),
    [anon_sym_ENV] = ACTIONS(95),
    [anon_sym_EXPOSE] = ACTIONS(97),
    [anon_sym_FOR] = ACTIONS(99),
    [anon_sym_FROM] = ACTIONS(103),
    [anon_sym_FROMDOCKERFILE] = ACTIONS(105),
    [anon_sym_FUNCTION] = ACTIONS(107),
    [anon_sym_COMMAND] = ACTIONS(107),
    [anon_sym_GITCLONE] = ACTIONS(109),
    [anon_sym_HOST] = ACTIONS(111),
    [anon_sym_IF] = ACTIONS(113),
    [anon_sym_IMPORT] = ACTIONS(115),
    [anon_sym_LET] = ACTIONS(117),
    [anon_sym_LABEL] = ACTIONS(119),
    [anon_sym_LOCALLY] = ACTIONS(121),
    [anon_sym_RUN] = ACTIONS(123),
    [anon_sym_SAVEARTIFACT] = ACTIONS(125),
    [anon_sym_SAVEIMAGE] = ACTIONS(127),
    [anon_sym_SET] = ACTIONS(129),
    [anon_sym_TRY] = ACTIONS(131),
    [anon_sym_USER] = ACTIONS(133),
    [anon_sym_VOLUME] = ACTIONS(135),
    [anon_sym_WAIT] = ACTIONS(137),
    [anon_sym_WITHDOCKER] = ACTIONS(139),
    [anon_sym_WORKDIR] = ACTIONS(141),
    [aux_sym_block_token1] = ACTIONS(147),
    [sym_line_continuation] = ACTIONS(3),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation_comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(3),
    [anon_sym_CR_LF] = ACTIONS(3),
    [anon_sym_FF] = ACTIONS(3),
  },
  [24] = {
    [sym__immediate_string_base] = STATE(36),
    [sym__immediate_double_quoted_string] = STATE(25),
    [sym__immediate_single_quoted_string] = STATE(25),
    [sym__immediate_unquoted_string] = STATE(25),
    [sym__immediate_expansion] = STATE(36),
    [sym__immediate_escape_sequence] = STATE(53),
    [aux_sym__immediate_string_base_repeat1] = STATE(36),
    [aux_sym_unquoted_string_repeat1] = STATE(36),
    [aux_sym_string_repeat1] = STATE(25),
    [anon_sym_SLASH] = ACTIONS(443),
    [anon_sym_COLON] = ACTIONS(445),
    [anon_sym_EQ] = ACTIONS(445),
    [anon_sym_EQ3] = ACTIONS(447),
    [anon_sym_DASH_DASH] = ACTIONS(449),
    [anon_sym_COLON2] = ACTIONS(443),
    [anon_sym_DOT] = ACTIONS(443),
    [anon_sym_DASH] = ACTIONS(447),
    [anon_sym_LPAREN] = ACTIONS(445),
    [anon_sym_RPAREN] = ACTIONS(445),
    [anon_sym_LBRACK] = ACTIONS(445),
    [anon_sym_RBRACK] = ACTIONS(445),
    [anon_sym_LBRACE] = ACTIONS(445),
    [anon_sym_RBRACE] = ACTIONS(445),
    [anon_sym_SLASH2] = ACTIONS(445),
    [anon_sym_COMMA] = ACTIONS(445),
    [anon_sym_AT] = ACTIONS(445),
    [anon_sym_DOT2] = ACTIONS(445),
    [anon_sym_DASH2] = ACTIONS(445),
    [anon_sym_LPAREN2] = ACTIONS(443),
    [anon_sym_RPAREN2] = ACTIONS(443),
    [anon_sym_LBRACK2] = ACTIONS(447),
    [anon_sym_RBRACK2] = ACTIONS(443),
    [anon_sym_LBRACE2] = ACTIONS(443),
    [anon_sym_RBRACE2] = ACTIONS(443),
    [anon_sym_COMMA2] = ACTIONS(443),
    [anon_sym_AT2] = ACTIONS(443),
    [anon_sym_DOLLAR] = ACTIONS(445),
    [anon_sym_PLUS] = ACTIONS(445),
    [anon_sym_DQUOTE] = ACTIONS(445),
    [anon_sym_SQUOTE] = ACTIONS(451),
    [anon_sym_LBRACK3] = ACTIONS(449),
    [sym_aws] = ACTIONS(449),
    [sym_entrypoint] = ACTIONS(449),
    [anon_sym_DASH_DASHinteractive] = ACTIONS(445),
    [anon_sym_DASH_DASHinteractive_DASHkeep] = ACTIONS(449),
    [anon_sym_DASH_DASHmount] = ACTIONS(449),
    [sym_network_none] = ACTIONS(449),
    [sym_no_cache] = ACTIONS(449),
    [anon_sym_DASH_DASHoidc] = ACTIONS(449),
    [sym_privileged] = ACTIONS(449),
    [sym_push] = ACTIONS(449),
    [sym_raw_output] = ACTIONS(449),
    [anon_sym_DASH_DASHsecret] = ACTIONS(449),
    [anon_sym_EQ4] = ACTIONS(449),
    [sym_ssh] = ACTIONS(449),
    [aux_sym_unknown_option_token1] = ACTIONS(445),
    [sym__string_base_other] = ACTIONS(445),
    [sym__string_base_alpha] = ACTIONS(445),
    [sym__string_base_num] = ACTIONS(445),
    [sym__immediate_string_base_other] = ACTIONS(447),
    [sym__immediate_string_base_alpha] = ACTIONS(443),
    [sym__immediate_string_base_num] = ACTIONS(443),
    [anon_sym_DQUOTE2] = ACTIONS(454),
    [anon_sym_PLUS2] = ACTIONS(443),
    [anon_sym_DOLLAR2] = ACTIONS(456),
    [aux_sym__immediate_escape_sequence_token1] = ACTIONS(458),
    [sym_line_continuation] = ACTIONS(3),
    [sym_comment] = ACTIONS(449),
    [sym_line_continuation_comment] = ACTIONS(5),
    [anon_sym_LF] = ACTIONS(5),
    [anon_sym_CR_LF] = ACTIONS(5),
    [anon_sym_FF] = ACTIONS(5),
  },
  [25] = {
    [sym__immediate_string_base] = STATE(36),
    [sym__immediate_double_quoted_string] = STATE(25),
    [sym__immediate_single_quoted_string] = STATE(25),
    [sym__immediate_unquoted_string] = STATE(25),
    [sym__immediate_expansion] = STATE(36),
    [sym__immediate_escape_sequence] = STATE(53),
    [aux_sym__immediate_string_base_repeat1] = STATE(36),
    [aux_sym_unquoted_string_repeat1] = STATE(36),
    [aux_sym_string_repeat1] = STATE(25),
    [anon_sym_SLASH] = ACTIONS(461),
    [anon_sym_COLON] = ACTIONS(464),
    [anon_sym_EQ] = ACTIONS(464),
    [anon_sym_EQ3] = ACTIONS(466),
    [anon_sym_DASH_DASH] = ACTIONS(469),
    [anon_sym_COLON2] = ACTIONS(461),
    [anon_sym_DOT] = ACTIONS(461),
    [anon_sym_DASH] = ACTIONS(466),
    [anon_sym_LPAREN] = ACTIONS(464),
    [anon_sym_RPAREN] = ACTIONS(464),
    [anon_sym_LBRACK] = ACTIONS(464),
    [anon_sym_RBRACK] = ACTIONS(464),
    [anon_sym_LBRACE] = ACTIONS(464),
    [anon_sym_RBRACE] = ACTIONS(464),
    [anon_sym_SLASH2] = ACTIONS(464),
    [anon_sym_COMMA] = ACTIONS(464),
    [anon_sym_AT] = ACTIONS(464),
    [anon_sym_DOT2] = ACTIONS(464),
    [anon_sym_DASH2] = ACTIONS(464),
    [anon_sym_LPAREN2] = ACTIONS(461),
    [anon_sym_RPAREN2] = ACTIONS(461),
    [anon_sym_LBRACK2] = ACTIONS(466),
    [anon_sym_RBRACK2] = ACTIONS(461),
    [anon_sym_LBRACE2] = ACTIONS(461),
    [anon_sym_RBRACE2] = ACTIONS(461),
    [anon_sym_COMMA2] = ACTIONS(461),
    [anon_sym_AT2] = ACTIONS(461),
    [anon_sym_DOLLAR] = ACTIONS(464),
    [anon_sym_PLUS] = ACTIONS(464),
    [anon_sym_DQUOTE] = ACTIONS(464),
    [anon_sym_SQUOTE] = ACTIONS(471),
    [anon_sym_LBRACK3] = ACTIONS(469),
    [sym_aws] = ACTIONS(469),
    [sym_entrypoint] = ACTIONS(469),
    [anon_sym_DASH_DASHinteractive] = ACTIONS(464),
    [anon_sym_DASH_DASHinteractive_DASHkeep] = ACTIONS(469),
    [anon_sym_DASH_DASHmount] = ACTIONS(469),
    [sym_network_none] = ACTIONS(469),
    [sym_no_cache] = ACTIONS(469),
    [anon_sym_DASH_DASHoidc] = ACTIONS(469),
    [sym_privileged] = ACTIONS(469),
    [sym_push] = ACTIONS(469),
    [sym_raw_output] = ACTIONS(469),
    [anon_sym_DASH_DASHsecret] = ACTIONS(469),
    [anon_sym_EQ4] = ACTIONS(469),
    [sym_ssh] = ACTIONS(469),
    [aux_sym_unknown_option_token1] = ACTIONS(464),
    [sym__string_base_other] = ACTIONS(464),
    [sym__string_base_alpha] = ACTIONS(464),
    [sym__string_base_num] = ACTIONS(464),
    [sym__immediate_string_base_other] = ACTIONS(466),
    [sym__immediate_string_base_alpha] = ACTIONS(461),
    [sym__immediate_string_base_num] = ACTIONS(461),
    [anon_sym_DQUOTE2] = ACTIONS(474),
    [anon_sym_PLUS2] = ACTIONS(461),
    [anon_sym_DOLLAR2] = ACTIONS(477),
    [aux_sym__immediate_escape_sequence_token1] = ACTIONS(480),
    [sym_line_continuation] = ACTIONS(3),
    [sym_comment] = ACTIONS(469),
    [sym_line_continuation_comment] = ACTIONS(5),
    [anon_sym_LF] = ACTIONS(5),
    [anon_sym_CR_LF] = ACTIONS(5),
    [anon_sym_FF] = ACTIONS(5),
  },
  [26] = {
    [sym_project_command] = STATE(26),
    [sym_arg_command] = STATE(26),
    [sym_build_command] = STATE(26),
    [sym_cache_command] = STATE(26),
    [sym_cmd_command] = STATE(26),
    [sym_copy_command] = STATE(26),
    [sym_do_command] = STATE(26),
    [sym_entrypoint_command] = STATE(26),
    [sym_env_command] = STATE(26),
    [sym_expose_command] = STATE(26),
    [sym_for_command] = STATE(26),
    [sym_from_command] = STATE(26),
    [sym_from_dockerfile_command] = STATE(26),
    [sym_function_command] = STATE(26),
    [sym_git_clone_command] = STATE(26),
    [sym_host_command] = STATE(26),
    [sym_if_command] = STATE(26),
    [sym_import_command] = STATE(26),
    [sym_let_command] = STATE(26),
    [sym_label_command] = STATE(26),
    [sym_locally_command] = STATE(26),
    [sym_run_command] = STATE(26),
    [sym_save_artifact_command] = STATE(26),
    [sym_save_image_command] = STATE(26),
    [sym_set_command] = STATE(26),
    [sym_try_command] = STATE(26),
    [sym_user_command] = STATE(26),
    [sym_volume_command] = STATE(26),
    [sym_wait_command] = STATE(26),
    [sym_with_docker_command] = STATE(26),
    [sym_workdir_command] = STATE(26),
    [aux_sym_block_repeat1] = STATE(26),
    [anon_sym_PROJECT] = ACTIONS(483),
    [anon_sym_ARG] = ACTIONS(486),
    [anon_sym_BUILD] = ACTIONS(489),
    [anon_sym_CACHE] = ACTIONS(492),
    [anon_sym_CMD] = ACTIONS(495),
    [anon_sym_COPY] = ACTIONS(498),
    [anon_sym_DO] = ACTIONS(501),
    [anon_sym_ENTRYPOINT] = ACTIONS(504),
    [anon_sym_ENV] = ACTIONS(507),
    [anon_sym_EXPOSE] = ACTIONS(510),
    [anon_sym_FOR] = ACTIONS(513),
    [anon_sym_FROM] = ACTIONS(516),
    [anon_sym_FROMDOCKERFILE] = ACTIONS(519),
    [anon_sym_FUNCTION] = ACTIONS(522),
    [anon_sym_COMMAND] = ACTIONS(522),
    [anon_sym_GITCLONE] = ACTIONS(525),
    [anon_sym_HOST] = ACTIONS(528),
    [anon_sym_IF] = ACTIONS(531),
    [anon_sym_IMPORT] = ACTIONS(534),
    [anon_sym_LET] = ACTIONS(537),
    [anon_sym_LABEL] = ACTIONS(540),
    [anon_sym_LOCALLY] = ACTIONS(543),
    [anon_sym_RUN] = ACTIONS(546),
    [anon_sym_SAVEARTIFACT] = ACTIONS(549),
    [anon_sym_SAVEIMAGE] = ACTIONS(552),
    [anon_sym_SET] = ACTIONS(555),
    [anon_sym_TRY] = ACTIONS(558),
    [anon_sym_USER] = ACTIONS(561),
    [anon_sym_VOLUME] = ACTIONS(564),
    [anon_sym_WAIT] = ACTIONS(567),
    [anon_sym_WITHDOCKER] = ACTIONS(570),
    [anon_sym_WORKDIR] = ACTIONS(573),
    [aux_sym_block_token1] = ACTIONS(576),
    [sym_line_continuation] = ACTIONS(3),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation_comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(3),
    [anon_sym_CR_LF] = ACTIONS(3),
    [anon_sym_FF] = ACTIONS(3),
    [sym__dedent] = ACTIONS(333),
  },
  [27] = {
    [sym__immediate_string_base] = STATE(36),
    [sym__immediate_double_quoted_string] = STATE(24),
    [sym__immediate_single_quoted_string] = STATE(24),
    [sym__immediate_unquoted_string] = STATE(24),
    [sym__immediate_expansion] = STATE(36),
    [sym__immediate_escape_sequence] = STATE(53),
    [aux_sym__immediate_string_base_repeat1] = STATE(36),
    [aux_sym_unquoted_string_repeat1] = STATE(36),
    [aux_sym_string_repeat1] = STATE(24),
    [anon_sym_SLASH] = ACTIONS(443),
    [anon_sym_COLON] = ACTIONS(579),
    [anon_sym_EQ] = ACTIONS(579),
    [anon_sym_EQ3] = ACTIONS(447),
    [anon_sym_DASH_DASH] = ACTIONS(581),
    [anon_sym_COLON2] = ACTIONS(443),
    [anon_sym_DOT] = ACTIONS(443),
    [anon_sym_DASH] = ACTIONS(447),
    [anon_sym_LPAREN] = ACTIONS(579),
    [anon_sym_RPAREN] = ACTIONS(579),
    [anon_sym_LBRACK] = ACTIONS(579),
    [anon_sym_RBRACK] = ACTIONS(579),
    [anon_sym_LBRACE] = ACTIONS(579),
    [anon_sym_RBRACE] = ACTIONS(579),
    [anon_sym_SLASH2] = ACTIONS(579),
    [anon_sym_COMMA] = ACTIONS(579),
    [anon_sym_AT] = ACTIONS(579),
    [anon_sym_DOT2] = ACTIONS(579),
    [anon_sym_DASH2] = ACTIONS(579),
    [anon_sym_LPAREN2] = ACTIONS(443),
    [anon_sym_RPAREN2] = ACTIONS(443),
    [anon_sym_LBRACK2] = ACTIONS(447),
    [anon_sym_RBRACK2] = ACTIONS(443),
    [anon_sym_LBRACE2] = ACTIONS(443),
    [anon_sym_RBRACE2] = ACTIONS(443),
    [anon_sym_COMMA2] = ACTIONS(443),
    [anon_sym_AT2] = ACTIONS(443),
    [anon_sym_DOLLAR] = ACTIONS(579),
    [anon_sym_PLUS] = ACTIONS(579),
    [anon_sym_DQUOTE] = ACTIONS(579),
    [anon_sym_SQUOTE] = ACTIONS(583),
    [anon_sym_LBRACK3] = ACTIONS(581),
    [sym_aws] = ACTIONS(581),
    [sym_entrypoint] = ACTIONS(581),
    [anon_sym_DASH_DASHinteractive] = ACTIONS(579),
    [anon_sym_DASH_DASHinteractive_DASHkeep] = ACTIONS(581),
    [anon_sym_DASH_DASHmount] = ACTIONS(581),
    [sym_network_none] = ACTIONS(581),
    [sym_no_cache] = ACTIONS(581),
    [anon_sym_DASH_DASHoidc] = ACTIONS(581),
    [sym_privileged] = ACTIONS(581),
    [sym_push] = ACTIONS(581),
    [sym_raw_output] = ACTIONS(581),
    [anon_sym_DASH_DASHsecret] = ACTIONS(581),
    [anon_sym_EQ4] = ACTIONS(581),
    [sym_ssh] = ACTIONS(581),
    [aux_sym_unknown_option_token1] = ACTIONS(579),
    [sym__string_base_other] = ACTIONS(579),
    [sym__string_base_alpha] = ACTIONS(579),
    [sym__string_base_num] = ACTIONS(579),
    [sym__immediate_string_base_other] = ACTIONS(447),
    [sym__immediate_string_base_alpha] = ACTIONS(443),
    [sym__immediate_string_base_num] = ACTIONS(443),
    [anon_sym_DQUOTE2] = ACTIONS(454),
    [anon_sym_PLUS2] = ACTIONS(443),
    [anon_sym_DOLLAR2] = ACTIONS(456),
    [aux_sym__immediate_escape_sequence_token1] = ACTIONS(586),
    [sym_line_continuation] = ACTIONS(3),
    [sym_comment] = ACTIONS(581),
    [sym_line_continuation_comment] = ACTIONS(5),
    [anon_sym_LF] = ACTIONS(5),
    [anon_sym_CR_LF] = ACTIONS(5),
    [anon_sym_FF] = ACTIONS(5),
  },
  [28] = {
    [sym__immediate_string_base] = STATE(38),
    [sym__immediate_double_quoted_string] = STATE(29),
    [sym__immediate_single_quoted_string] = STATE(29),
    [sym__immediate_unquoted_string] = STATE(29),
    [sym__immediate_expansion] = STATE(38),
    [sym__immediate_escape_sequence] = STATE(77),
    [aux_sym__immediate_string_base_repeat1] = STATE(38),
    [aux_sym_unquoted_string_repeat1] = STATE(38),
    [aux_sym_string_repeat1] = STATE(29),
    [anon_sym_SLASH] = ACTIONS(589),
    [anon_sym_COLON] = ACTIONS(445),
    [anon_sym_EQ] = ACTIONS(445),
    [anon_sym_EQ3] = ACTIONS(589),
    [anon_sym_DASH_DASH] = ACTIONS(449),
    [anon_sym_COLON2] = ACTIONS(589),
    [anon_sym_DOT] = ACTIONS(589),
    [anon_sym_DASH] = ACTIONS(591),
    [anon_sym_LPAREN] = ACTIONS(445),
    [anon_sym_RPAREN] = ACTIONS(445),
    [anon_sym_LBRACK] = ACTIONS(445),
    [anon_sym_RBRACK] = ACTIONS(445),
    [anon_sym_LBRACE] = ACTIONS(445),
    [anon_sym_RBRACE] = ACTIONS(445),
    [anon_sym_SLASH2] = ACTIONS(445),
    [anon_sym_COMMA] = ACTIONS(445),
    [anon_sym_AT] = ACTIONS(445),
    [anon_sym_DOT2] = ACTIONS(445),
    [anon_sym_DASH2] = ACTIONS(445),
    [anon_sym_LPAREN2] = ACTIONS(589),
    [anon_sym_RPAREN2] = ACTIONS(589),
    [anon_sym_LBRACK2] = ACTIONS(591),
    [anon_sym_RBRACK2] = ACTIONS(589),
    [anon_sym_LBRACE2] = ACTIONS(589),
    [anon_sym_RBRACE2] = ACTIONS(589),
    [anon_sym_COMMA2] = ACTIONS(589),
    [anon_sym_AT2] = ACTIONS(589),
    [anon_sym_DOLLAR] = ACTIONS(445),
    [anon_sym_PLUS] = ACTIONS(445),
    [anon_sym_DQUOTE] = ACTIONS(445),
    [anon_sym_SQUOTE] = ACTIONS(593),
    [anon_sym_LBRACK3] = ACTIONS(449),
    [sym_aws] = ACTIONS(449),
    [sym_entrypoint] = ACTIONS(449),
    [anon_sym_DASH_DASHinteractive] = ACTIONS(445),
    [anon_sym_DASH_DASHinteractive_DASHkeep] = ACTIONS(449),
    [anon_sym_DASH_DASHmount] = ACTIONS(449),
    [sym_network_none] = ACTIONS(449),
    [sym_no_cache] = ACTIONS(449),
    [anon_sym_DASH_DASHoidc] = ACTIONS(449),
    [sym_privileged] = ACTIONS(449),
    [sym_push] = ACTIONS(449),
    [sym_raw_output] = ACTIONS(449),
    [anon_sym_DASH_DASHsecret] = ACTIONS(449),
    [sym_ssh] = ACTIONS(449),
    [aux_sym_unknown_option_token1] = ACTIONS(445),
    [sym__string_base_other] = ACTIONS(445),
    [sym__string_base_alpha] = ACTIONS(445),
    [sym__string_base_num] = ACTIONS(445),
    [sym__immediate_string_base_other] = ACTIONS(591),
    [sym__immediate_string_base_alpha] = ACTIONS(589),
    [sym__immediate_string_base_num] = ACTIONS(589),
    [anon_sym_DQUOTE2] = ACTIONS(596),
    [anon_sym_PLUS2] = ACTIONS(589),
    [anon_sym_DOLLAR2] = ACTIONS(598),
    [aux_sym__immediate_escape_sequence_token1] = ACTIONS(600),
    [sym_line_continuation] = ACTIONS(3),
    [sym_comment] = ACTIONS(449),
    [sym_line_continuation_comment] = ACTIONS(5),
    [anon_sym_LF] = ACTIONS(5),
    [anon_sym_CR_LF] = ACTIONS(5),
    [anon_sym_FF] = ACTIONS(5),
  },
  [29] = {
    [sym__immediate_string_base] = STATE(38),
    [sym__immediate_double_quoted_string] = STATE(29),
    [sym__immediate_single_quoted_string] = STATE(29),
    [sym__immediate_unquoted_string] = STATE(29),
    [sym__immediate_expansion] = STATE(38),
    [sym__immediate_escape_sequence] = STATE(77),
    [aux_sym__immediate_string_base_repeat1] = STATE(38),
    [aux_sym_unquoted_string_repeat1] = STATE(38),
    [aux_sym_string_repeat1] = STATE(29),
    [anon_sym_SLASH] = ACTIONS(603),
    [anon_sym_COLON] = ACTIONS(464),
    [anon_sym_EQ] = ACTIONS(464),
    [anon_sym_EQ3] = ACTIONS(603),
    [anon_sym_DASH_DASH] = ACTIONS(469),
    [anon_sym_COLON2] = ACTIONS(603),
    [anon_sym_DOT] = ACTIONS(603),
    [anon_sym_DASH] = ACTIONS(606),
    [anon_sym_LPAREN] = ACTIONS(464),
    [anon_sym_RPAREN] = ACTIONS(464),
    [anon_sym_LBRACK] = ACTIONS(464),
    [anon_sym_RBRACK] = ACTIONS(464),
    [anon_sym_LBRACE] = ACTIONS(464),
    [anon_sym_RBRACE] = ACTIONS(464),
    [anon_sym_SLASH2] = ACTIONS(464),
    [anon_sym_COMMA] = ACTIONS(464),
    [anon_sym_AT] = ACTIONS(464),
    [anon_sym_DOT2] = ACTIONS(464),
    [anon_sym_DASH2] = ACTIONS(464),
    [anon_sym_LPAREN2] = ACTIONS(603),
    [anon_sym_RPAREN2] = ACTIONS(603),
    [anon_sym_LBRACK2] = ACTIONS(606),
    [anon_sym_RBRACK2] = ACTIONS(603),
    [anon_sym_LBRACE2] = ACTIONS(603),
    [anon_sym_RBRACE2] = ACTIONS(603),
    [anon_sym_COMMA2] = ACTIONS(603),
    [anon_sym_AT2] = ACTIONS(603),
    [anon_sym_DOLLAR] = ACTIONS(464),
    [anon_sym_PLUS] = ACTIONS(464),
    [anon_sym_DQUOTE] = ACTIONS(464),
    [anon_sym_SQUOTE] = ACTIONS(609),
    [anon_sym_LBRACK3] = ACTIONS(469),
    [sym_aws] = ACTIONS(469),
    [sym_entrypoint] = ACTIONS(469),
    [anon_sym_DASH_DASHinteractive] = ACTIONS(464),
    [anon_sym_DASH_DASHinteractive_DASHkeep] = ACTIONS(469),
    [anon_sym_DASH_DASHmount] = ACTIONS(469),
    [sym_network_none] = ACTIONS(469),
    [sym_no_cache] = ACTIONS(469),
    [anon_sym_DASH_DASHoidc] = ACTIONS(469),
    [sym_privileged] = ACTIONS(469),
    [sym_push] = ACTIONS(469),
    [sym_raw_output] = ACTIONS(469),
    [anon_sym_DASH_DASHsecret] = ACTIONS(469),
    [sym_ssh] = ACTIONS(469),
    [aux_sym_unknown_option_token1] = ACTIONS(464),
    [sym__string_base_other] = ACTIONS(464),
    [sym__string_base_alpha] = ACTIONS(464),
    [sym__string_base_num] = ACTIONS(464),
    [sym__immediate_string_base_other] = ACTIONS(606),
    [sym__immediate_string_base_alpha] = ACTIONS(603),
    [sym__immediate_string_base_num] = ACTIONS(603),
    [anon_sym_DQUOTE2] = ACTIONS(612),
    [anon_sym_PLUS2] = ACTIONS(603),
    [anon_sym_DOLLAR2] = ACTIONS(615),
    [aux_sym__immediate_escape_sequence_token1] = ACTIONS(618),
    [sym_line_continuation] = ACTIONS(3),
    [sym_comment] = ACTIONS(469),
    [sym_line_continuation_comment] = ACTIONS(5),
    [anon_sym_LF] = ACTIONS(5),
    [anon_sym_CR_LF] = ACTIONS(5),
    [anon_sym_FF] = ACTIONS(5),
  },
  [30] = {
    [sym__immediate_string_base] = STATE(38),
    [sym__immediate_double_quoted_string] = STATE(28),
    [sym__immediate_single_quoted_string] = STATE(28),
    [sym__immediate_unquoted_string] = STATE(28),
    [sym__immediate_expansion] = STATE(38),
    [sym__immediate_escape_sequence] = STATE(77),
    [aux_sym__immediate_string_base_repeat1] = STATE(38),
    [aux_sym_unquoted_string_repeat1] = STATE(38),
    [aux_sym_string_repeat1] = STATE(28),
    [anon_sym_SLASH] = ACTIONS(589),
    [anon_sym_COLON] = ACTIONS(579),
    [anon_sym_EQ] = ACTIONS(579),
    [anon_sym_EQ3] = ACTIONS(589),
    [anon_sym_DASH_DASH] = ACTIONS(581),
    [anon_sym_COLON2] = ACTIONS(589),
    [anon_sym_DOT] = ACTIONS(589),
    [anon_sym_DASH] = ACTIONS(591),
    [anon_sym_LPAREN] = ACTIONS(579),
    [anon_sym_RPAREN] = ACTIONS(579),
    [anon_sym_LBRACK] = ACTIONS(579),
    [anon_sym_RBRACK] = ACTIONS(579),
    [anon_sym_LBRACE] = ACTIONS(579),
    [anon_sym_RBRACE] = ACTIONS(579),
    [anon_sym_SLASH2] = ACTIONS(579),
    [anon_sym_COMMA] = ACTIONS(579),
    [anon_sym_AT] = ACTIONS(579),
    [anon_sym_DOT2] = ACTIONS(579),
    [anon_sym_DASH2] = ACTIONS(579),
    [anon_sym_LPAREN2] = ACTIONS(589),
    [anon_sym_RPAREN2] = ACTIONS(589),
    [anon_sym_LBRACK2] = ACTIONS(591),
    [anon_sym_RBRACK2] = ACTIONS(589),
    [anon_sym_LBRACE2] = ACTIONS(589),
    [anon_sym_RBRACE2] = ACTIONS(589),
    [anon_sym_COMMA2] = ACTIONS(589),
    [anon_sym_AT2] = ACTIONS(589),
    [anon_sym_DOLLAR] = ACTIONS(579),
    [anon_sym_PLUS] = ACTIONS(579),
    [anon_sym_DQUOTE] = ACTIONS(579),
    [anon_sym_SQUOTE] = ACTIONS(621),
    [anon_sym_LBRACK3] = ACTIONS(581),
    [sym_aws] = ACTIONS(581),
    [sym_entrypoint] = ACTIONS(581),
    [anon_sym_DASH_DASHinteractive] = ACTIONS(579),
    [anon_sym_DASH_DASHinteractive_DASHkeep] = ACTIONS(581),
    [anon_sym_DASH_DASHmount] = ACTIONS(581),
    [sym_network_none] = ACTIONS(581),
    [sym_no_cache] = ACTIONS(581),
    [anon_sym_DASH_DASHoidc] = ACTIONS(581),
    [sym_privileged] = ACTIONS(581),
    [sym_push] = ACTIONS(581),
    [sym_raw_output] = ACTIONS(581),
    [anon_sym_DASH_DASHsecret] = ACTIONS(581),
    [sym_ssh] = ACTIONS(581),
    [aux_sym_unknown_option_token1] = ACTIONS(579),
    [sym__string_base_other] = ACTIONS(579),
    [sym__string_base_alpha] = ACTIONS(579),
    [sym__string_base_num] = ACTIONS(579),
    [sym__immediate_string_base_other] = ACTIONS(591),
    [sym__immediate_string_base_alpha] = ACTIONS(589),
    [sym__immediate_string_base_num] = ACTIONS(589),
    [anon_sym_DQUOTE2] = ACTIONS(596),
    [anon_sym_PLUS2] = ACTIONS(589),
    [anon_sym_DOLLAR2] = ACTIONS(598),
    [aux_sym__immediate_escape_sequence_token1] = ACTIONS(624),
    [sym_line_continuation] = ACTIONS(3),
    [sym_comment] = ACTIONS(581),
    [sym_line_continuation_comment] = ACTIONS(5),
    [anon_sym_LF] = ACTIONS(5),
    [anon_sym_CR_LF] = ACTIONS(5),
    [anon_sym_FF] = ACTIONS(5),
  },
  [31] = {
    [sym__immediate_string_base] = STATE(47),
    [sym__immediate_double_quoted_string] = STATE(32),
    [sym__immediate_single_quoted_string] = STATE(32),
    [sym__immediate_unquoted_string] = STATE(32),
    [sym__immediate_expansion] = STATE(47),
    [sym__immediate_escape_sequence] = STATE(135),
    [aux_sym__immediate_string_base_repeat1] = STATE(47),
    [aux_sym_unquoted_string_repeat1] = STATE(47),
    [aux_sym_string_repeat1] = STATE(32),
    [anon_sym_SLASH] = ACTIONS(627),
    [anon_sym_COLON] = ACTIONS(445),
    [anon_sym_EQ] = ACTIONS(445),
    [anon_sym_EQ3] = ACTIONS(627),
    [anon_sym_COLON2] = ACTIONS(627),
    [anon_sym_DOT] = ACTIONS(627),
    [anon_sym_DASH] = ACTIONS(629),
    [anon_sym_LPAREN] = ACTIONS(445),
    [anon_sym_RPAREN] = ACTIONS(445),
    [anon_sym_LBRACK] = ACTIONS(445),
    [anon_sym_RBRACK] = ACTIONS(445),
    [anon_sym_LBRACE] = ACTIONS(445),
    [anon_sym_RBRACE] = ACTIONS(445),
    [anon_sym_SLASH2] = ACTIONS(445),
    [anon_sym_COMMA] = ACTIONS(445),
    [anon_sym_AT] = ACTIONS(445),
    [anon_sym_DOT2] = ACTIONS(445),
    [anon_sym_DASH2] = ACTIONS(445),
    [anon_sym_LPAREN2] = ACTIONS(629),
    [anon_sym_RPAREN2] = ACTIONS(627),
    [anon_sym_LBRACK2] = ACTIONS(627),
    [anon_sym_RBRACK2] = ACTIONS(627),
    [anon_sym_LBRACE2] = ACTIONS(627),
    [anon_sym_RBRACE2] = ACTIONS(627),
    [anon_sym_COMMA2] = ACTIONS(627),
    [anon_sym_AT2] = ACTIONS(627),
    [anon_sym_DOLLAR] = ACTIONS(445),
    [anon_sym_PLUS] = ACTIONS(445),
    [anon_sym_DQUOTE] = ACTIONS(445),
    [anon_sym_SQUOTE] = ACTIONS(631),
    [anon_sym_LPAREN3] = ACTIONS(449),
    [sym_allow_privileged] = ACTIONS(449),
    [anon_sym_DASH_DASHbuild_DASHarg] = ACTIONS(449),
    [anon_sym_DASH_DASHchmod] = ACTIONS(449),
    [anon_sym_DASH_DASHchown] = ACTIONS(449),
    [sym_dir] = ACTIONS(449),
    [sym_if_exists] = ACTIONS(449),
    [sym_keep_own] = ACTIONS(449),
    [sym_keep_ts] = ACTIONS(449),
    [sym_pass_args] = ACTIONS(449),
    [anon_sym_DASH_DASHplatform] = ACTIONS(449),
    [sym_symlink_no_follow] = ACTIONS(449),
    [aux_sym_unknown_option_token1] = ACTIONS(445),
    [sym__string_base_other] = ACTIONS(445),
    [sym__string_base_alpha] = ACTIONS(445),
    [sym__string_base_num] = ACTIONS(445),
    [sym__immediate_string_base_other] = ACTIONS(629),
    [sym__immediate_string_base_alpha] = ACTIONS(627),
    [sym__immediate_string_base_num] = ACTIONS(627),
    [anon_sym_DQUOTE2] = ACTIONS(633),
    [anon_sym_SQUOTE2] = ACTIONS(449),
    [anon_sym_PLUS2] = ACTIONS(627),
    [anon_sym_DOLLAR2] = ACTIONS(635),
    [aux_sym__immediate_escape_sequence_token1] = ACTIONS(637),
    [sym_line_continuation] = ACTIONS(3),
    [sym_comment] = ACTIONS(5),
    [sym_line_continuation_comment] = ACTIONS(5),
    [anon_sym_LF] = ACTIONS(5),
    [anon_sym_CR_LF] = ACTIONS(5),
    [anon_sym_FF] = ACTIONS(5),
  },
  [32] = {
    [sym__immediate_string_base] = STATE(47),
    [sym__immediate_double_quoted_string] = STATE(32),
    [sym__immediate_single_quoted_string] = STATE(32),
    [sym__immediate_unquoted_string] = STATE(32),
    [sym__immediate_expansion] = STATE(47),
    [sym__immediate_escape_sequence] = STATE(135),
    [aux_sym__immediate_string_base_repeat1] = STATE(47),
    [aux_sym_unquoted_string_repeat1] = STATE(47),
    [aux_sym_string_repeat1] = STATE(32),
    [anon_sym_SLASH] = ACTIONS(640),
    [anon_sym_COLON] = ACTIONS(464),
    [anon_sym_EQ] = ACTIONS(464),
    [anon_sym_EQ3] = ACTIONS(640),
    [anon_sym_COLON2] = ACTIONS(640),
    [anon_sym_DOT] = ACTIONS(640),
    [anon_sym_DASH] = ACTIONS(643),
    [anon_sym_LPAREN] = ACTIONS(464),
    [anon_sym_RPAREN] = ACTIONS(464),
    [anon_sym_LBRACK] = ACTIONS(464),
    [anon_sym_RBRACK] = ACTIONS(464),
    [anon_sym_LBRACE] = ACTIONS(464),
    [anon_sym_RBRACE] = ACTIONS(464),
    [anon_sym_SLASH2] = ACTIONS(464),
    [anon_sym_COMMA] = ACTIONS(464),
    [anon_sym_AT] = ACTIONS(464),
    [anon_sym_DOT2] = ACTIONS(464),
    [anon_sym_DASH2] = ACTIONS(464),
    [anon_sym_LPAREN2] = ACTIONS(643),
    [anon_sym_RPAREN2] = ACTIONS(640),
    [anon_sym_LBRACK2] = ACTIONS(640),
    [anon_sym_RBRACK2] = ACTIONS(640),
    [anon_sym_LBRACE2] = ACTIONS(640),
    [anon_sym_RBRACE2] = ACTIONS(640),
    [anon_sym_COMMA2] = ACTIONS(640),
    [anon_sym_AT2] = ACTIONS(640),
    [anon_sym_DOLLAR] = ACTIONS(464),
    [anon_sym_PLUS] = ACTIONS(464),
    [anon_sym_DQUOTE] = ACTIONS(464),
    [anon_sym_SQUOTE] = ACTIONS(646),
    [anon_sym_LPAREN3] = ACTIONS(469),
    [sym_allow_privileged] = ACTIONS(469),
    [anon_sym_DASH_DASHbuild_DASHarg] = ACTIONS(469),
    [anon_sym_DASH_DASHchmod] = ACTIONS(469),
    [anon_sym_DASH_DASHchown] = ACTIONS(469),
    [sym_dir] = ACTIONS(469),
    [sym_if_exists] = ACTIONS(469),
    [sym_keep_own] = ACTIONS(469),
    [sym_keep_ts] = ACTIONS(469),
    [sym_pass_args] = ACTIONS(469),
    [anon_sym_DASH_DASHplatform] = ACTIONS(469),
    [sym_symlink_no_follow] = ACTIONS(469),
    [aux_sym_unknown_option_token1] = ACTIONS(464),
    [sym__string_base_other] = ACTIONS(464),
    [sym__string_base_alpha] = ACTIONS(464),
    [sym__string_base_num] = ACTIONS(464),
    [sym__immediate_string_base_other] = ACTIONS(643),
    [sym__immediate_string_base_alpha] = ACTIONS(640),
    [sym__immediate_string_base_num] = ACTIONS(640),
    [anon_sym_DQUOTE2] = ACTIONS(649),
    [anon_sym_SQUOTE2] = ACTIONS(469),
    [anon_sym_PLUS2] = ACTIONS(640),
    [anon_sym_DOLLAR2] = ACTIONS(652),
    [aux_sym__immediate_escape_sequence_token1] = ACTIONS(655),
    [sym_line_continuation] = ACTIONS(3),
    [sym_comment] = ACTIONS(5),
    [sym_line_continuation_comment] = ACTIONS(5),
    [anon_sym_LF] = ACTIONS(5),
    [anon_sym_CR_LF] = ACTIONS(5),
    [anon_sym_FF] = ACTIONS(5),
  },
  [33] = {
    [sym__immediate_string_base] = STATE(47),
    [sym__immediate_double_quoted_string] = STATE(31),
    [sym__immediate_single_quoted_string] = STATE(31),
    [sym__immediate_unquoted_string] = STATE(31),
    [sym__immediate_expansion] = STATE(47),
    [sym__immediate_escape_sequence] = STATE(135),
    [aux_sym__immediate_string_base_repeat1] = STATE(47),
    [aux_sym_unquoted_string_repeat1] = STATE(47),
    [aux_sym_string_repeat1] = STATE(31),
    [anon_sym_SLASH] = ACTIONS(627),
    [anon_sym_COLON] = ACTIONS(579),
    [anon_sym_EQ] = ACTIONS(579),
    [anon_sym_EQ3] = ACTIONS(627),
    [anon_sym_COLON2] = ACTIONS(627),
    [anon_sym_DOT] = ACTIONS(627),
    [anon_sym_DASH] = ACTIONS(629),
    [anon_sym_LPAREN] = ACTIONS(579),
    [anon_sym_RPAREN] = ACTIONS(579),
    [anon_sym_LBRACK] = ACTIONS(579),
    [anon_sym_RBRACK] = ACTIONS(579),
    [anon_sym_LBRACE] = ACTIONS(579),
    [anon_sym_RBRACE] = ACTIONS(579),
    [anon_sym_SLASH2] = ACTIONS(579),
    [anon_sym_COMMA] = ACTIONS(579),
    [anon_sym_AT] = ACTIONS(579),
    [anon_sym_DOT2] = ACTIONS(579),
    [anon_sym_DASH2] = ACTIONS(579),
    [anon_sym_LPAREN2] = ACTIONS(629),
    [anon_sym_RPAREN2] = ACTIONS(627),
    [anon_sym_LBRACK2] = ACTIONS(627),
    [anon_sym_RBRACK2] = ACTIONS(627),
    [anon_sym_LBRACE2] = ACTIONS(627),
    [anon_sym_RBRACE2] = ACTIONS(627),
    [anon_sym_COMMA2] = ACTIONS(627),
    [anon_sym_AT2] = ACTIONS(627),
    [anon_sym_DOLLAR] = ACTIONS(579),
    [anon_sym_PLUS] = ACTIONS(579),
    [anon_sym_DQUOTE] = ACTIONS(579),
    [anon_sym_SQUOTE] = ACTIONS(631),
    [anon_sym_LPAREN3] = ACTIONS(581),
    [sym_allow_privileged] = ACTIONS(581),
    [anon_sym_DASH_DASHbuild_DASHarg] = ACTIONS(581),
    [anon_sym_DASH_DASHchmod] = ACTIONS(581),
    [anon_sym_DASH_DASHchown] = ACTIONS(581),
    [sym_dir] = ACTIONS(581),
    [sym_if_exists] = ACTIONS(581),
    [sym_keep_own] = ACTIONS(581),
    [sym_keep_ts] = ACTIONS(581),
    [sym_pass_args] = ACTIONS(581),
    [anon_sym_DASH_DASHplatform] = ACTIONS(581),
    [sym_symlink_no_follow] = ACTIONS(581),
    [aux_sym_unknown_option_token1] = ACTIONS(579),
    [sym__string_base_other] = ACTIONS(579),
    [sym__string_base_alpha] = ACTIONS(579),
    [sym__string_base_num] = ACTIONS(579),
    [sym__immediate_string_base_other] = ACTIONS(629),
    [sym__immediate_string_base_alpha] = ACTIONS(627),
    [sym__immediate_string_base_num] = ACTIONS(627),
    [anon_sym_DQUOTE2] = ACTIONS(633),
    [anon_sym_SQUOTE2] = ACTIONS(581),
    [anon_sym_PLUS2] = ACTIONS(627),
    [anon_sym_DOLLAR2] = ACTIONS(635),
    [aux_sym__immediate_escape_sequence_token1] = ACTIONS(658),
    [sym_line_continuation] = ACTIONS(3),
    [sym_comment] = ACTIONS(5),
    [sym_line_continuation_comment] = ACTIONS(5),
    [anon_sym_LF] = ACTIONS(5),
    [anon_sym_CR_LF] = ACTIONS(5),
    [anon_sym_FF] = ACTIONS(5),
  },
  [34] = {
    [sym__immediate_string_base] = STATE(37),
    [sym__immediate_expansion] = STATE(37),
    [sym__immediate_escape_sequence] = STATE(53),
    [aux_sym__immediate_string_base_repeat1] = STATE(37),
    [aux_sym_unquoted_string_repeat1] = STATE(37),
    [anon_sym_SLASH] = ACTIONS(661),
    [anon_sym_COLON] = ACTIONS(664),
    [anon_sym_EQ] = ACTIONS(664),
    [anon_sym_EQ3] = ACTIONS(666),
    [anon_sym_DASH_DASH] = ACTIONS(669),
    [anon_sym_COLON2] = ACTIONS(661),
    [anon_sym_DOT] = ACTIONS(661),
    [anon_sym_DASH] = ACTIONS(666),
    [anon_sym_LPAREN] = ACTIONS(664),
    [anon_sym_RPAREN] = ACTIONS(664),
    [anon_sym_LBRACK] = ACTIONS(664),
    [anon_sym_RBRACK] = ACTIONS(664),
    [anon_sym_LBRACE] = ACTIONS(664),
    [anon_sym_RBRACE] = ACTIONS(664),
    [anon_sym_SLASH2] = ACTIONS(664),
    [anon_sym_COMMA] = ACTIONS(664),
    [anon_sym_AT] = ACTIONS(664),
    [anon_sym_DOT2] = ACTIONS(664),
    [anon_sym_DASH2] = ACTIONS(664),
    [anon_sym_LPAREN2] = ACTIONS(661),
    [anon_sym_RPAREN2] = ACTIONS(661),
    [anon_sym_LBRACK2] = ACTIONS(666),
    [anon_sym_RBRACK2] = ACTIONS(661),
    [anon_sym_LBRACE2] = ACTIONS(661),
    [anon_sym_RBRACE2] = ACTIONS(661),
    [anon_sym_COMMA2] = ACTIONS(661),
    [anon_sym_AT2] = ACTIONS(661),
    [anon_sym_DOLLAR] = ACTIONS(664),
    [anon_sym_PLUS] = ACTIONS(664),
    [anon_sym_DQUOTE] = ACTIONS(664),
    [anon_sym_SQUOTE] = ACTIONS(669),
    [anon_sym_LBRACK3] = ACTIONS(669),
    [sym_aws] = ACTIONS(669),
    [sym_entrypoint] = ACTIONS(669),
    [anon_sym_DASH_DASHinteractive] = ACTIONS(664),
    [anon_sym_DASH_DASHinteractive_DASHkeep] = ACTIONS(669),
    [anon_sym_DASH_DASHmount] = ACTIONS(669),
    [sym_network_none] = ACTIONS(669),
    [sym_no_cache] = ACTIONS(669),
    [anon_sym_DASH_DASHoidc] = ACTIONS(669),
    [sym_privileged] = ACTIONS(669),
    [sym_push] = ACTIONS(669),
    [sym_raw_output] = ACTIONS(669),
    [anon_sym_DASH_DASHsecret] = ACTIONS(669),
    [anon_sym_EQ4] = ACTIONS(669),
    [sym_ssh] = ACTIONS(669),
    [aux_sym_unknown_option_token1] = ACTIONS(664),
    [sym__string_base_other] = ACTIONS(664),
    [sym__string_base_alpha] = ACTIONS(664),
    [sym__string_base_num] = ACTIONS(664),
    [sym__immediate_string_base_other] = ACTIONS(666),
    [sym__immediate_string_base_alpha] = ACTIONS(661),
    [sym__immediate_string_base_num] = ACTIONS(661),
    [anon_sym_DQUOTE2] = ACTIONS(669),
    [anon_sym_PLUS2] = ACTIONS(661),
    [anon_sym_DOLLAR2] = ACTIONS(671),
    [aux_sym__immediate_escape_sequence_token1] = ACTIONS(674),
    [sym_line_continuation] = ACTIONS(3),
    [sym_comment] = ACTIONS(669),
    [sym_line_continuation_comment] = ACTIONS(5),
    [anon_sym_LF] = ACTIONS(5),
    [anon_sym_CR_LF] = ACTIONS(5),
    [anon_sym_FF] = ACTIONS(5),
  },
  [35] = {
    [sym__immediate_string_base] = STATE(34),
    [sym__immediate_expansion] = STATE(34),
    [sym__immediate_escape_sequence] = STATE(53),
    [aux_sym__immediate_string_base_repeat1] = STATE(34),
    [aux_sym_unquoted_string_repeat1] = STATE(34),
    [anon_sym_SLASH] = ACTIONS(677),
    [anon_sym_COLON] = ACTIONS(680),
    [anon_sym_EQ] = ACTIONS(680),
    [anon_sym_EQ3] = ACTIONS(682),
    [anon_sym_DASH_DASH] = ACTIONS(685),
    [anon_sym_COLON2] = ACTIONS(677),
    [anon_sym_DOT] = ACTIONS(677),
    [anon_sym_DASH] = ACTIONS(682),
    [anon_sym_LPAREN] = ACTIONS(680),
    [anon_sym_RPAREN] = ACTIONS(680),
    [anon_sym_LBRACK] = ACTIONS(680),
    [anon_sym_RBRACK] = ACTIONS(680),
    [anon_sym_LBRACE] = ACTIONS(680),
    [anon_sym_RBRACE] = ACTIONS(680),
    [anon_sym_SLASH2] = ACTIONS(680),
    [anon_sym_COMMA] = ACTIONS(680),
    [anon_sym_AT] = ACTIONS(680),
    [anon_sym_DOT2] = ACTIONS(680),
    [anon_sym_DASH2] = ACTIONS(680),
    [anon_sym_LPAREN2] = ACTIONS(677),
    [anon_sym_RPAREN2] = ACTIONS(677),
    [anon_sym_LBRACK2] = ACTIONS(682),
    [anon_sym_RBRACK2] = ACTIONS(677),
    [anon_sym_LBRACE2] = ACTIONS(677),
    [anon_sym_RBRACE2] = ACTIONS(677),
    [anon_sym_COMMA2] = ACTIONS(677),
    [anon_sym_AT2] = ACTIONS(677),
    [anon_sym_DOLLAR] = ACTIONS(680),
    [anon_sym_PLUS] = ACTIONS(680),
    [anon_sym_DQUOTE] = ACTIONS(680),
    [anon_sym_SQUOTE] = ACTIONS(685),
    [anon_sym_LBRACK3] = ACTIONS(685),
    [sym_aws] = ACTIONS(685),
    [sym_entrypoint] = ACTIONS(685),
    [anon_sym_DASH_DASHinteractive] = ACTIONS(680),
    [anon_sym_DASH_DASHinteractive_DASHkeep] = ACTIONS(685),
    [anon_sym_DASH_DASHmount] = ACTIONS(685),
    [sym_network_none] = ACTIONS(685),
    [sym_no_cache] = ACTIONS(685),
    [anon_sym_DASH_DASHoidc] = ACTIONS(685),
    [sym_privileged] = ACTIONS(685),
    [sym_push] = ACTIONS(685),
    [sym_raw_output] = ACTIONS(685),
    [anon_sym_DASH_DASHsecret] = ACTIONS(685),
    [anon_sym_EQ4] = ACTIONS(685),
    [sym_ssh] = ACTIONS(685),
    [aux_sym_unknown_option_token1] = ACTIONS(680),
    [sym__string_base_other] = ACTIONS(680),
    [sym__string_base_alpha] = ACTIONS(680),
    [sym__string_base_num] = ACTIONS(680),
    [sym__immediate_string_base_other] = ACTIONS(682),
    [sym__immediate_string_base_alpha] = ACTIONS(677),
    [sym__immediate_string_base_num] = ACTIONS(677),
    [anon_sym_DQUOTE2] = ACTIONS(685),
    [anon_sym_PLUS2] = ACTIONS(677),
    [anon_sym_DOLLAR2] = ACTIONS(687),
    [aux_sym__immediate_escape_sequence_token1] = ACTIONS(690),
    [sym_line_continuation] = ACTIONS(3),
    [sym_comment] = ACTIONS(685),
    [sym_line_continuation_comment] = ACTIONS(5),
    [anon_sym_LF] = ACTIONS(5),
    [anon_sym_CR_LF] = ACTIONS(5),
    [anon_sym_FF] = ACTIONS(5),
  },
  [36] = {
    [sym__immediate_string_base] = STATE(37),
    [sym__immediate_expansion] = STATE(37),
    [sym__immediate_escape_sequence] = STATE(53),
    [aux_sym__immediate_string_base_repeat1] = STATE(37),
    [aux_sym_unquoted_string_repeat1] = STATE(37),
    [anon_sym_SLASH] = ACTIONS(693),
    [anon_sym_COLON] = ACTIONS(695),
    [anon_sym_EQ] = ACTIONS(695),
    [anon_sym_EQ3] = ACTIONS(695),
    [anon_sym_DASH_DASH] = ACTIONS(693),
    [anon_sym_COLON2] = ACTIONS(693),
    [anon_sym_DOT] = ACTIONS(693),
    [anon_sym_DASH] = ACTIONS(695),
    [anon_sym_LPAREN] = ACTIONS(695),
    [anon_sym_RPAREN] = ACTIONS(695),
    [anon_sym_LBRACK] = ACTIONS(695),
    [anon_sym_RBRACK] = ACTIONS(695),
    [anon_sym_LBRACE] = ACTIONS(695),
    [anon_sym_RBRACE] = ACTIONS(695),
    [anon_sym_SLASH2] = ACTIONS(695),
    [anon_sym_COMMA] = ACTIONS(695),
    [anon_sym_AT] = ACTIONS(695),
    [anon_sym_DOT2] = ACTIONS(695),
    [anon_sym_DASH2] = ACTIONS(695),
    [anon_sym_LPAREN2] = ACTIONS(693),
    [anon_sym_RPAREN2] = ACTIONS(693),
    [anon_sym_LBRACK2] = ACTIONS(695),
    [anon_sym_RBRACK2] = ACTIONS(693),
    [anon_sym_LBRACE2] = ACTIONS(693),
    [anon_sym_RBRACE2] = ACTIONS(693),
    [anon_sym_COMMA2] = ACTIONS(693),
    [anon_sym_AT2] = ACTIONS(693),
    [anon_sym_DOLLAR] = ACTIONS(695),
    [anon_sym_PLUS] = ACTIONS(695),
    [anon_sym_DQUOTE] = ACTIONS(695),
    [anon_sym_SQUOTE] = ACTIONS(693),
    [anon_sym_LBRACK3] = ACTIONS(693),
    [sym_aws] = ACTIONS(693),
    [sym_entrypoint] = ACTIONS(693),
    [anon_sym_DASH_DASHinteractive] = ACTIONS(695),
    [anon_sym_DASH_DASHinteractive_DASHkeep] = ACTIONS(693),
    [anon_sym_DASH_DASHmount] = ACTIONS(693),
    [sym_network_none] = ACTIONS(693),
    [sym_no_cache] = ACTIONS(693),
    [anon_sym_DASH_DASHoidc] = ACTIONS(693),
    [sym_privileged] = ACTIONS(693),
    [sym_push] = ACTIONS(693),
    [sym_raw_output] = ACTIONS(693),
    [anon_sym_DASH_DASHsecret] = ACTIONS(693),
    [anon_sym_EQ4] = ACTIONS(693),
    [sym_ssh] = ACTIONS(693),
    [aux_sym_unknown_option_token1] = ACTIONS(695),
    [sym__string_base_other] = ACTIONS(695),
    [sym__string_base_alpha] = ACTIONS(695),
    [sym__string_base_num] = ACTIONS(695),
    [sym__immediate_string_base_other] = ACTIONS(695),
    [sym__immediate_string_base_alpha] = ACTIONS(693),
    [sym__immediate_string_base_num] = ACTIONS(693),
    [anon_sym_DQUOTE2] = ACTIONS(693),
    [anon_sym_PLUS2] = ACTIONS(693),
    [anon_sym_DOLLAR2] = ACTIONS(693),
    [aux_sym__immediate_escape_sequence_token1] = ACTIONS(695),
    [sym_line_continuation] = ACTIONS(3),
    [sym_comment] = ACTIONS(693),
    [sym_line_continuation_comment] = ACTIONS(5),
    [anon_sym_LF] = ACTIONS(5),
    [anon_sym_CR_LF] = ACTIONS(5),
    [anon_sym_FF] = ACTIONS(5),
  },
  [37] = {
    [sym__immediate_string_base] = STATE(37),
    [sym__immediate_expansion] = STATE(37),
    [sym__immediate_escape_sequence] = STATE(53),
    [aux_sym__immediate_string_base_repeat1] = STATE(37),
    [aux_sym_unquoted_string_repeat1] = STATE(37),
    [anon_sym_SLASH] = ACTIONS(697),
    [anon_sym_COLON] = ACTIONS(700),
    [anon_sym_EQ] = ACTIONS(700),
    [anon_sym_EQ3] = ACTIONS(702),
    [anon_sym_DASH_DASH] = ACTIONS(705),
    [anon_sym_COLON2] = ACTIONS(697),
    [anon_sym_DOT] = ACTIONS(697),
    [anon_sym_DASH] = ACTIONS(702),
    [anon_sym_LPAREN] = ACTIONS(700),
    [anon_sym_RPAREN] = ACTIONS(700),
    [anon_sym_LBRACK] = ACTIONS(700),
    [anon_sym_RBRACK] = ACTIONS(700),
    [anon_sym_LBRACE] = ACTIONS(700),
    [anon_sym_RBRACE] = ACTIONS(700),
    [anon_sym_SLASH2] = ACTIONS(700),
    [anon_sym_COMMA] = ACTIONS(700),
    [anon_sym_AT] = ACTIONS(700),
    [anon_sym_DOT2] = ACTIONS(700),
    [anon_sym_DASH2] = ACTIONS(700),
    [anon_sym_LPAREN2] = ACTIONS(697),
    [anon_sym_RPAREN2] = ACTIONS(697),
    [anon_sym_LBRACK2] = ACTIONS(702),
    [anon_sym_RBRACK2] = ACTIONS(697),
    [anon_sym_LBRACE2] = ACTIONS(697),
    [anon_sym_RBRACE2] = ACTIONS(697),
    [anon_sym_COMMA2] = ACTIONS(697),
    [anon_sym_AT2] = ACTIONS(697),
    [anon_sym_DOLLAR] = ACTIONS(700),
    [anon_sym_PLUS] = ACTIONS(700),
    [anon_sym_DQUOTE] = ACTIONS(700),
    [anon_sym_SQUOTE] = ACTIONS(705),
    [anon_sym_LBRACK3] = ACTIONS(705),
    [sym_aws] = ACTIONS(705),
    [sym_entrypoint] = ACTIONS(705),
    [anon_sym_DASH_DASHinteractive] = ACTIONS(700),
    [anon_sym_DASH_DASHinteractive_DASHkeep] = ACTIONS(705),
    [anon_sym_DASH_DASHmount] = ACTIONS(705),
    [sym_network_none] = ACTIONS(705),
    [sym_no_cache] = ACTIONS(705),
    [anon_sym_DASH_DASHoidc] = ACTIONS(705),
    [sym_privileged] = ACTIONS(705),
    [sym_push] = ACTIONS(705),
    [sym_raw_output] = ACTIONS(705),
    [anon_sym_DASH_DASHsecret] = ACTIONS(705),
    [anon_sym_EQ4] = ACTIONS(705),
    [sym_ssh] = ACTIONS(705),
    [aux_sym_unknown_option_token1] = ACTIONS(700),
    [sym__string_base_other] = ACTIONS(700),
    [sym__string_base_alpha] = ACTIONS(700),
    [sym__string_base_num] = ACTIONS(700),
    [sym__immediate_string_base_other] = ACTIONS(702),
    [sym__immediate_string_base_alpha] = ACTIONS(697),
    [sym__immediate_string_base_num] = ACTIONS(697),
    [anon_sym_DQUOTE2] = ACTIONS(705),
    [anon_sym_PLUS2] = ACTIONS(697),
    [anon_sym_DOLLAR2] = ACTIONS(707),
    [aux_sym__immediate_escape_sequence_token1] = ACTIONS(710),
    [sym_line_continuation] = ACTIONS(3),
    [sym_comment] = ACTIONS(705),
    [sym_line_continuation_comment] = ACTIONS(5),
    [anon_sym_LF] = ACTIONS(5),
    [anon_sym_CR_LF] = ACTIONS(5),
    [anon_sym_FF] = ACTIONS(5),
  },
  [38] = {
    [sym__immediate_string_base] = STATE(40),
    [sym__immediate_expansion] = STATE(40),
    [sym__immediate_escape_sequence] = STATE(77),
    [aux_sym__immediate_string_base_repeat1] = STATE(40),
    [aux_sym_unquoted_string_repeat1] = STATE(40),
    [anon_sym_SLASH] = ACTIONS(693),
    [anon_sym_COLON] = ACTIONS(695),
    [anon_sym_EQ] = ACTIONS(695),
    [anon_sym_EQ3] = ACTIONS(693),
    [anon_sym_DASH_DASH] = ACTIONS(693),
    [anon_sym_COLON2] = ACTIONS(693),
    [anon_sym_DOT] = ACTIONS(693),
    [anon_sym_DASH] = ACTIONS(695),
    [anon_sym_LPAREN] = ACTIONS(695),
    [anon_sym_RPAREN] = ACTIONS(695),
    [anon_sym_LBRACK] = ACTIONS(695),
    [anon_sym_RBRACK] = ACTIONS(695),
    [anon_sym_LBRACE] = ACTIONS(695),
    [anon_sym_RBRACE] = ACTIONS(695),
    [anon_sym_SLASH2] = ACTIONS(695),
    [anon_sym_COMMA] = ACTIONS(695),
    [anon_sym_AT] = ACTIONS(695),
    [anon_sym_DOT2] = ACTIONS(695),
    [anon_sym_DASH2] = ACTIONS(695),
    [anon_sym_LPAREN2] = ACTIONS(693),
    [anon_sym_RPAREN2] = ACTIONS(693),
    [anon_sym_LBRACK2] = ACTIONS(695),
    [anon_sym_RBRACK2] = ACTIONS(693),
    [anon_sym_LBRACE2] = ACTIONS(693),
    [anon_sym_RBRACE2] = ACTIONS(693),
    [anon_sym_COMMA2] = ACTIONS(693),
    [anon_sym_AT2] = ACTIONS(693),
    [anon_sym_DOLLAR] = ACTIONS(695),
    [anon_sym_PLUS] = ACTIONS(695),
    [anon_sym_DQUOTE] = ACTIONS(695),
    [anon_sym_SQUOTE] = ACTIONS(693),
    [anon_sym_LBRACK3] = ACTIONS(693),
    [sym_aws] = ACTIONS(693),
    [sym_entrypoint] = ACTIONS(693),
    [anon_sym_DASH_DASHinteractive] = ACTIONS(695),
    [anon_sym_DASH_DASHinteractive_DASHkeep] = ACTIONS(693),
    [anon_sym_DASH_DASHmount] = ACTIONS(693),
    [sym_network_none] = ACTIONS(693),
    [sym_no_cache] = ACTIONS(693),
    [anon_sym_DASH_DASHoidc] = ACTIONS(693),
    [sym_privileged] = ACTIONS(693),
    [sym_push] = ACTIONS(693),
    [sym_raw_output] = ACTIONS(693),
    [anon_sym_DASH_DASHsecret] = ACTIONS(693),
    [sym_ssh] = ACTIONS(693),
    [aux_sym_unknown_option_token1] = ACTIONS(695),
    [sym__string_base_other] = ACTIONS(695),
    [sym__string_base_alpha] = ACTIONS(695),
    [sym__string_base_num] = ACTIONS(695),
    [sym__immediate_string_base_other] = ACTIONS(695),
    [sym__immediate_string_base_alpha] = ACTIONS(693),
    [sym__immediate_string_base_num] = ACTIONS(693),
    [anon_sym_DQUOTE2] = ACTIONS(693),
    [anon_sym_PLUS2] = ACTIONS(693),
    [anon_sym_DOLLAR2] = ACTIONS(693),
    [aux_sym__immediate_escape_sequence_token1] = ACTIONS(695),
    [sym_line_continuation] = ACTIONS(3),
    [sym_comment] = ACTIONS(693),
    [sym_line_continuation_comment] = ACTIONS(5),
    [anon_sym_LF] = ACTIONS(5),
    [anon_sym_CR_LF] = ACTIONS(5),
    [anon_sym_FF] = ACTIONS(5),
  },
  [39] = {
    [sym__immediate_string_base] = STATE(41),
    [sym__immediate_expansion] = STATE(41),
    [sym__immediate_escape_sequence] = STATE(77),
    [aux_sym__immediate_string_base_repeat1] = STATE(41),
    [aux_sym_unquoted_string_repeat1] = STATE(41),
    [anon_sym_SLASH] = ACTIONS(713),
    [anon_sym_COLON] = ACTIONS(680),
    [anon_sym_EQ] = ACTIONS(680),
    [anon_sym_EQ3] = ACTIONS(713),
    [anon_sym_DASH_DASH] = ACTIONS(685),
    [anon_sym_COLON2] = ACTIONS(713),
    [anon_sym_DOT] = ACTIONS(713),
    [anon_sym_DASH] = ACTIONS(716),
    [anon_sym_LPAREN] = ACTIONS(680),
    [anon_sym_RPAREN] = ACTIONS(680),
    [anon_sym_LBRACK] = ACTIONS(680),
    [anon_sym_RBRACK] = ACTIONS(680),
    [anon_sym_LBRACE] = ACTIONS(680),
    [anon_sym_RBRACE] = ACTIONS(680),
    [anon_sym_SLASH2] = ACTIONS(680),
    [anon_sym_COMMA] = ACTIONS(680),
    [anon_sym_AT] = ACTIONS(680),
    [anon_sym_DOT2] = ACTIONS(680),
    [anon_sym_DASH2] = ACTIONS(680),
    [anon_sym_LPAREN2] = ACTIONS(713),
    [anon_sym_RPAREN2] = ACTIONS(713),
    [anon_sym_LBRACK2] = ACTIONS(716),
    [anon_sym_RBRACK2] = ACTIONS(713),
    [anon_sym_LBRACE2] = ACTIONS(713),
    [anon_sym_RBRACE2] = ACTIONS(713),
    [anon_sym_COMMA2] = ACTIONS(713),
    [anon_sym_AT2] = ACTIONS(713),
    [anon_sym_DOLLAR] = ACTIONS(680),
    [anon_sym_PLUS] = ACTIONS(680),
    [anon_sym_DQUOTE] = ACTIONS(680),
    [anon_sym_SQUOTE] = ACTIONS(685),
    [anon_sym_LBRACK3] = ACTIONS(685),
    [sym_aws] = ACTIONS(685),
    [sym_entrypoint] = ACTIONS(685),
    [anon_sym_DASH_DASHinteractive] = ACTIONS(680),
    [anon_sym_DASH_DASHinteractive_DASHkeep] = ACTIONS(685),
    [anon_sym_DASH_DASHmount] = ACTIONS(685),
    [sym_network_none] = ACTIONS(685),
    [sym_no_cache] = ACTIONS(685),
    [anon_sym_DASH_DASHoidc] = ACTIONS(685),
    [sym_privileged] = ACTIONS(685),
    [sym_push] = ACTIONS(685),
    [sym_raw_output] = ACTIONS(685),
    [anon_sym_DASH_DASHsecret] = ACTIONS(685),
    [sym_ssh] = ACTIONS(685),
    [aux_sym_unknown_option_token1] = ACTIONS(680),
    [sym__string_base_other] = ACTIONS(680),
    [sym__string_base_alpha] = ACTIONS(680),
    [sym__string_base_num] = ACTIONS(680),
    [sym__immediate_string_base_other] = ACTIONS(716),
    [sym__immediate_string_base_alpha] = ACTIONS(713),
    [sym__immediate_string_base_num] = ACTIONS(713),
    [anon_sym_DQUOTE2] = ACTIONS(685),
    [anon_sym_PLUS2] = ACTIONS(713),
    [anon_sym_DOLLAR2] = ACTIONS(719),
    [aux_sym__immediate_escape_sequence_token1] = ACTIONS(722),
    [sym_line_continuation] = ACTIONS(3),
    [sym_comment] = ACTIONS(685),
    [sym_line_continuation_comment] = ACTIONS(5),
    [anon_sym_LF] = ACTIONS(5),
    [anon_sym_CR_LF] = ACTIONS(5),
    [anon_sym_FF] = ACTIONS(5),
  },
  [40] = {
    [sym__immediate_string_base] = STATE(40),
    [sym__immediate_expansion] = STATE(40),
    [sym__immediate_escape_sequence] = STATE(77),
    [aux_sym__immediate_string_base_repeat1] = STATE(40),
    [aux_sym_unquoted_string_repeat1] = STATE(40),
    [anon_sym_SLASH] = ACTIONS(725),
    [anon_sym_COLON] = ACTIONS(700),
    [anon_sym_EQ] = ACTIONS(700),
    [anon_sym_EQ3] = ACTIONS(725),
    [anon_sym_DASH_DASH] = ACTIONS(705),
    [anon_sym_COLON2] = ACTIONS(725),
    [anon_sym_DOT] = ACTIONS(725),
    [anon_sym_DASH] = ACTIONS(728),
    [anon_sym_LPAREN] = ACTIONS(700),
    [anon_sym_RPAREN] = ACTIONS(700),
    [anon_sym_LBRACK] = ACTIONS(700),
    [anon_sym_RBRACK] = ACTIONS(700),
    [anon_sym_LBRACE] = ACTIONS(700),
    [anon_sym_RBRACE] = ACTIONS(700),
    [anon_sym_SLASH2] = ACTIONS(700),
    [anon_sym_COMMA] = ACTIONS(700),
    [anon_sym_AT] = ACTIONS(700),
    [anon_sym_DOT2] = ACTIONS(700),
    [anon_sym_DASH2] = ACTIONS(700),
    [anon_sym_LPAREN2] = ACTIONS(725),
    [anon_sym_RPAREN2] = ACTIONS(725),
    [anon_sym_LBRACK2] = ACTIONS(728),
    [anon_sym_RBRACK2] = ACTIONS(725),
    [anon_sym_LBRACE2] = ACTIONS(725),
    [anon_sym_RBRACE2] = ACTIONS(725),
    [anon_sym_COMMA2] = ACTIONS(725),
    [anon_sym_AT2] = ACTIONS(725),
    [anon_sym_DOLLAR] = ACTIONS(700),
    [anon_sym_PLUS] = ACTIONS(700),
    [anon_sym_DQUOTE] = ACTIONS(700),
    [anon_sym_SQUOTE] = ACTIONS(705),
    [anon_sym_LBRACK3] = ACTIONS(705),
    [sym_aws] = ACTIONS(705),
    [sym_entrypoint] = ACTIONS(705),
    [anon_sym_DASH_DASHinteractive] = ACTIONS(700),
    [anon_sym_DASH_DASHinteractive_DASHkeep] = ACTIONS(705),
    [anon_sym_DASH_DASHmount] = ACTIONS(705),
    [sym_network_none] = ACTIONS(705),
    [sym_no_cache] = ACTIONS(705),
    [anon_sym_DASH_DASHoidc] = ACTIONS(705),
    [sym_privileged] = ACTIONS(705),
    [sym_push] = ACTIONS(705),
    [sym_raw_output] = ACTIONS(705),
    [anon_sym_DASH_DASHsecret] = ACTIONS(705),
    [sym_ssh] = ACTIONS(705),
    [aux_sym_unknown_option_token1] = ACTIONS(700),
    [sym__string_base_other] = ACTIONS(700),
    [sym__string_base_alpha] = ACTIONS(700),
    [sym__string_base_num] = ACTIONS(700),
    [sym__immediate_string_base_other] = ACTIONS(728),
    [sym__immediate_string_base_alpha] = ACTIONS(725),
    [sym__immediate_string_base_num] = ACTIONS(725),
    [anon_sym_DQUOTE2] = ACTIONS(705),
    [anon_sym_PLUS2] = ACTIONS(725),
    [anon_sym_DOLLAR2] = ACTIONS(731),
    [aux_sym__immediate_escape_sequence_token1] = ACTIONS(734),
    [sym_line_continuation] = ACTIONS(3),
    [sym_comment] = ACTIONS(705),
    [sym_line_continuation_comment] = ACTIONS(5),
    [anon_sym_LF] = ACTIONS(5),
    [anon_sym_CR_LF] = ACTIONS(5),
    [anon_sym_FF] = ACTIONS(5),
  },
  [41] = {
    [sym__immediate_string_base] = STATE(40),
    [sym__immediate_expansion] = STATE(40),
    [sym__immediate_escape_sequence] = STATE(77),
    [aux_sym__immediate_string_base_repeat1] = STATE(40),
    [aux_sym_unquoted_string_repeat1] = STATE(40),
    [anon_sym_SLASH] = ACTIONS(737),
    [anon_sym_COLON] = ACTIONS(664),
    [anon_sym_EQ] = ACTIONS(664),
    [anon_sym_EQ3] = ACTIONS(737),
    [anon_sym_DASH_DASH] = ACTIONS(669),
    [anon_sym_COLON2] = ACTIONS(737),
    [anon_sym_DOT] = ACTIONS(737),
    [anon_sym_DASH] = ACTIONS(740),
    [anon_sym_LPAREN] = ACTIONS(664),
    [anon_sym_RPAREN] = ACTIONS(664),
    [anon_sym_LBRACK] = ACTIONS(664),
    [anon_sym_RBRACK] = ACTIONS(664),
    [anon_sym_LBRACE] = ACTIONS(664),
    [anon_sym_RBRACE] = ACTIONS(664),
    [anon_sym_SLASH2] = ACTIONS(664),
    [anon_sym_COMMA] = ACTIONS(664),
    [anon_sym_AT] = ACTIONS(664),
    [anon_sym_DOT2] = ACTIONS(664),
    [anon_sym_DASH2] = ACTIONS(664),
    [anon_sym_LPAREN2] = ACTIONS(737),
    [anon_sym_RPAREN2] = ACTIONS(737),
    [anon_sym_LBRACK2] = ACTIONS(740),
    [anon_sym_RBRACK2] = ACTIONS(737),
    [anon_sym_LBRACE2] = ACTIONS(737),
    [anon_sym_RBRACE2] = ACTIONS(737),
    [anon_sym_COMMA2] = ACTIONS(737),
    [anon_sym_AT2] = ACTIONS(737),
    [anon_sym_DOLLAR] = ACTIONS(664),
    [anon_sym_PLUS] = ACTIONS(664),
    [anon_sym_DQUOTE] = ACTIONS(664),
    [anon_sym_SQUOTE] = ACTIONS(669),
    [anon_sym_LBRACK3] = ACTIONS(669),
    [sym_aws] = ACTIONS(669),
    [sym_entrypoint] = ACTIONS(669),
    [anon_sym_DASH_DASHinteractive] = ACTIONS(664),
    [anon_sym_DASH_DASHinteractive_DASHkeep] = ACTIONS(669),
    [anon_sym_DASH_DASHmount] = ACTIONS(669),
    [sym_network_none] = ACTIONS(669),
    [sym_no_cache] = ACTIONS(669),
    [anon_sym_DASH_DASHoidc] = ACTIONS(669),
    [sym_privileged] = ACTIONS(669),
    [sym_push] = ACTIONS(669),
    [sym_raw_output] = ACTIONS(669),
    [anon_sym_DASH_DASHsecret] = ACTIONS(669),
    [sym_ssh] = ACTIONS(669),
    [aux_sym_unknown_option_token1] = ACTIONS(664),
    [sym__string_base_other] = ACTIONS(664),
    [sym__string_base_alpha] = ACTIONS(664),
    [sym__string_base_num] = ACTIONS(664),
    [sym__immediate_string_base_other] = ACTIONS(740),
    [sym__immediate_string_base_alpha] = ACTIONS(737),
    [sym__immediate_string_base_num] = ACTIONS(737),
    [anon_sym_DQUOTE2] = ACTIONS(669),
    [anon_sym_PLUS2] = ACTIONS(737),
    [anon_sym_DOLLAR2] = ACTIONS(743),
    [aux_sym__immediate_escape_sequence_token1] = ACTIONS(746),
    [sym_line_continuation] = ACTIONS(3),
    [sym_comment] = ACTIONS(669),
    [sym_line_continuation_comment] = ACTIONS(5),
    [anon_sym_LF] = ACTIONS(5),
    [anon_sym_CR_LF] = ACTIONS(5),
    [anon_sym_FF] = ACTIONS(5),
  },
  [42] = {
    [sym__immediate_string_base] = STATE(76),
    [aux_sym_variable_repeat1] = STATE(2098),
    [aux_sym__immediate_string_base_repeat1] = STATE(76),
    [anon_sym_SLASH] = ACTIONS(749),
    [anon_sym_COLON] = ACTIONS(751),
    [anon_sym_EQ] = ACTIONS(751),
    [anon_sym_EQ3] = ACTIONS(751),
    [anon_sym_DASH_DASH] = ACTIONS(749),
    [anon_sym_COLON2] = ACTIONS(749),
    [anon_sym_DOT] = ACTIONS(749),
    [anon_sym_DASH] = ACTIONS(751),
    [anon_sym_LPAREN] = ACTIONS(751),
    [anon_sym_RPAREN] = ACTIONS(751),
    [anon_sym_LBRACK] = ACTIONS(751),
    [anon_sym_RBRACK] = ACTIONS(751),
    [anon_sym_LBRACE] = ACTIONS(751),
    [anon_sym_RBRACE] = ACTIONS(751),
    [anon_sym_SLASH2] = ACTIONS(751),
    [anon_sym_COMMA] = ACTIONS(751),
    [anon_sym_AT] = ACTIONS(751),
    [anon_sym_DOT2] = ACTIONS(751),
    [anon_sym_DASH2] = ACTIONS(751),
    [anon_sym_LPAREN2] = ACTIONS(749),
    [anon_sym_RPAREN2] = ACTIONS(749),
    [anon_sym_LBRACK2] = ACTIONS(751),
    [anon_sym_RBRACK2] = ACTIONS(749),
    [anon_sym_LBRACE2] = ACTIONS(749),
    [anon_sym_RBRACE2] = ACTIONS(749),
    [anon_sym_COMMA2] = ACTIONS(749),
    [anon_sym_AT2] = ACTIONS(749),
    [anon_sym_DOLLAR] = ACTIONS(751),
    [anon_sym_PLUS] = ACTIONS(751),
    [anon_sym_DQUOTE] = ACTIONS(751),
    [anon_sym_SQUOTE] = ACTIONS(749),
    [anon_sym_LBRACK3] = ACTIONS(749),
    [sym_aws] = ACTIONS(749),
    [sym_entrypoint] = ACTIONS(749),
    [anon_sym_DASH_DASHinteractive] = ACTIONS(751),
    [anon_sym_DASH_DASHinteractive_DASHkeep] = ACTIONS(749),
    [anon_sym_DASH_DASHmount] = ACTIONS(749),
    [sym_network_none] = ACTIONS(749),
    [sym_no_cache] = ACTIONS(749),
    [anon_sym_DASH_DASHoidc] = ACTIONS(749),
    [sym_privileged] = ACTIONS(749),
    [sym_push] = ACTIONS(749),
    [sym_raw_output] = ACTIONS(749),
    [anon_sym_DASH_DASHsecret] = ACTIONS(749),
    [anon_sym_EQ4] = ACTIONS(753),
    [sym_ssh] = ACTIONS(749),
    [aux_sym_unknown_option_token1] = ACTIONS(751),
    [sym__string_base_other] = ACTIONS(751),
    [sym__string_base_alpha] = ACTIONS(751),
    [sym__string_base_num] = ACTIONS(751),
    [sym__immediate_string_base_other] = ACTIONS(756),
    [sym__immediate_string_base_alpha] = ACTIONS(759),
    [sym__immediate_string_base_num] = ACTIONS(759),
    [anon_sym_DQUOTE2] = ACTIONS(749),
    [anon_sym_PLUS2] = ACTIONS(749),
    [anon_sym_DOLLAR2] = ACTIONS(749),
    [aux_sym__immediate_escape_sequence_token1] = ACTIONS(751),
    [sym_line_continuation] = ACTIONS(3),
    [sym_comment] = ACTIONS(749),
    [sym_line_continuation_comment] = ACTIONS(5),
    [anon_sym_LF] = ACTIONS(5),
    [anon_sym_CR_LF] = ACTIONS(5),
    [anon_sym_FF] = ACTIONS(5),
  },
  [43] = {
    [sym__immediate_string_base] = STATE(43),
    [sym__immediate_expansion] = STATE(43),
    [sym__immediate_escape_sequence] = STATE(135),
    [aux_sym__immediate_string_base_repeat1] = STATE(43),
    [aux_sym_unquoted_string_repeat1] = STATE(43),
    [anon_sym_SLASH] = ACTIONS(762),
    [anon_sym_COLON] = ACTIONS(700),
    [anon_sym_EQ] = ACTIONS(700),
    [anon_sym_EQ3] = ACTIONS(762),
    [anon_sym_COLON2] = ACTIONS(762),
    [anon_sym_DOT] = ACTIONS(762),
    [anon_sym_DASH] = ACTIONS(765),
    [anon_sym_LPAREN] = ACTIONS(700),
    [anon_sym_RPAREN] = ACTIONS(700),
    [anon_sym_LBRACK] = ACTIONS(700),
    [anon_sym_RBRACK] = ACTIONS(700),
    [anon_sym_LBRACE] = ACTIONS(700),
    [anon_sym_RBRACE] = ACTIONS(700),
    [anon_sym_SLASH2] = ACTIONS(700),
    [anon_sym_COMMA] = ACTIONS(700),
    [anon_sym_AT] = ACTIONS(700),
    [anon_sym_DOT2] = ACTIONS(700),
    [anon_sym_DASH2] = ACTIONS(700),
    [anon_sym_LPAREN2] = ACTIONS(765),
    [anon_sym_RPAREN2] = ACTIONS(762),
    [anon_sym_LBRACK2] = ACTIONS(762),
    [anon_sym_RBRACK2] = ACTIONS(762),
    [anon_sym_LBRACE2] = ACTIONS(762),
    [anon_sym_RBRACE2] = ACTIONS(762),
    [anon_sym_COMMA2] = ACTIONS(762),
    [anon_sym_AT2] = ACTIONS(762),
    [anon_sym_DOLLAR] = ACTIONS(700),
    [anon_sym_PLUS] = ACTIONS(700),
    [anon_sym_DQUOTE] = ACTIONS(700),
    [anon_sym_SQUOTE] = ACTIONS(700),
    [anon_sym_LPAREN3] = ACTIONS(705),
    [sym_allow_privileged] = ACTIONS(705),
    [anon_sym_DASH_DASHbuild_DASHarg] = ACTIONS(705),
    [anon_sym_DASH_DASHchmod] = ACTIONS(705),
    [anon_sym_DASH_DASHchown] = ACTIONS(705),
    [sym_dir] = ACTIONS(705),
    [sym_if_exists] = ACTIONS(705),
    [sym_keep_own] = ACTIONS(705),
    [sym_keep_ts] = ACTIONS(705),
    [sym_pass_args] = ACTIONS(705),
    [anon_sym_DASH_DASHplatform] = ACTIONS(705),
    [sym_symlink_no_follow] = ACTIONS(705),
    [aux_sym_unknown_option_token1] = ACTIONS(700),
    [sym__string_base_other] = ACTIONS(700),
    [sym__string_base_alpha] = ACTIONS(700),
    [sym__string_base_num] = ACTIONS(700),
    [sym__immediate_string_base_other] = ACTIONS(765),
    [sym__immediate_string_base_alpha] = ACTIONS(762),
    [sym__immediate_string_base_num] = ACTIONS(762),
    [anon_sym_DQUOTE2] = ACTIONS(705),
    [anon_sym_SQUOTE2] = ACTIONS(705),
    [anon_sym_PLUS2] = ACTIONS(762),
    [anon_sym_DOLLAR2] = ACTIONS(768),
    [aux_sym__immediate_escape_sequence_token1] = ACTIONS(771),
    [sym_line_continuation] = ACTIONS(3),
    [sym_comment] = ACTIONS(5),
    [sym_line_continuation_comment] = ACTIONS(5),
    [anon_sym_LF] = ACTIONS(5),
    [anon_sym_CR_LF] = ACTIONS(5),
    [anon_sym_FF] = ACTIONS(5),
  },
  [44] = {
    [sym__immediate_string_base] = STATE(45),
    [sym__immediate_expansion] = STATE(45),
    [sym__immediate_escape_sequence] = STATE(135),
    [aux_sym__immediate_string_base_repeat1] = STATE(45),
    [aux_sym_unquoted_string_repeat1] = STATE(45),
    [anon_sym_SLASH] = ACTIONS(774),
    [anon_sym_COLON] = ACTIONS(680),
    [anon_sym_EQ] = ACTIONS(680),
    [anon_sym_EQ3] = ACTIONS(774),
    [anon_sym_COLON2] = ACTIONS(774),
    [anon_sym_DOT] = ACTIONS(774),
    [anon_sym_DASH] = ACTIONS(777),
    [anon_sym_LPAREN] = ACTIONS(680),
    [anon_sym_RPAREN] = ACTIONS(680),
    [anon_sym_LBRACK] = ACTIONS(680),
    [anon_sym_RBRACK] = ACTIONS(680),
    [anon_sym_LBRACE] = ACTIONS(680),
    [anon_sym_RBRACE] = ACTIONS(680),
    [anon_sym_SLASH2] = ACTIONS(680),
    [anon_sym_COMMA] = ACTIONS(680),
    [anon_sym_AT] = ACTIONS(680),
    [anon_sym_DOT2] = ACTIONS(680),
    [anon_sym_DASH2] = ACTIONS(680),
    [anon_sym_LPAREN2] = ACTIONS(777),
    [anon_sym_RPAREN2] = ACTIONS(774),
    [anon_sym_LBRACK2] = ACTIONS(774),
    [anon_sym_RBRACK2] = ACTIONS(774),
    [anon_sym_LBRACE2] = ACTIONS(774),
    [anon_sym_RBRACE2] = ACTIONS(774),
    [anon_sym_COMMA2] = ACTIONS(774),
    [anon_sym_AT2] = ACTIONS(774),
    [anon_sym_DOLLAR] = ACTIONS(680),
    [anon_sym_PLUS] = ACTIONS(680),
    [anon_sym_DQUOTE] = ACTIONS(680),
    [anon_sym_SQUOTE] = ACTIONS(680),
    [anon_sym_LPAREN3] = ACTIONS(685),
    [sym_allow_privileged] = ACTIONS(685),
    [anon_sym_DASH_DASHbuild_DASHarg] = ACTIONS(685),
    [anon_sym_DASH_DASHchmod] = ACTIONS(685),
    [anon_sym_DASH_DASHchown] = ACTIONS(685),
    [sym_dir] = ACTIONS(685),
    [sym_if_exists] = ACTIONS(685),
    [sym_keep_own] = ACTIONS(685),
    [sym_keep_ts] = ACTIONS(685),
    [sym_pass_args] = ACTIONS(685),
    [anon_sym_DASH_DASHplatform] = ACTIONS(685),
    [sym_symlink_no_follow] = ACTIONS(685),
    [aux_sym_unknown_option_token1] = ACTIONS(680),
    [sym__string_base_other] = ACTIONS(680),
    [sym__string_base_alpha] = ACTIONS(680),
    [sym__string_base_num] = ACTIONS(680),
    [sym__immediate_string_base_other] = ACTIONS(777),
    [sym__immediate_string_base_alpha] = ACTIONS(774),
    [sym__immediate_string_base_num] = ACTIONS(774),
    [anon_sym_DQUOTE2] = ACTIONS(685),
    [anon_sym_SQUOTE2] = ACTIONS(685),
    [anon_sym_PLUS2] = ACTIONS(774),
    [anon_sym_DOLLAR2] = ACTIONS(780),
    [aux_sym__immediate_escape_sequence_token1] = ACTIONS(783),
    [sym_line_continuation] = ACTIONS(3),
    [sym_comment] = ACTIONS(5),
    [sym_line_continuation_comment] = ACTIONS(5),
    [anon_sym_LF] = ACTIONS(5),
    [anon_sym_CR_LF] = ACTIONS(5),
    [anon_sym_FF] = ACTIONS(5),
  },
  [45] = {
    [sym__immediate_string_base] = STATE(43),
    [sym__immediate_expansion] = STATE(43),
    [sym__immediate_escape_sequence] = STATE(135),
    [aux_sym__immediate_string_base_repeat1] = STATE(43),
    [aux_sym_unquoted_string_repeat1] = STATE(43),
    [anon_sym_SLASH] = ACTIONS(786),
    [anon_sym_COLON] = ACTIONS(664),
    [anon_sym_EQ] = ACTIONS(664),
    [anon_sym_EQ3] = ACTIONS(786),
    [anon_sym_COLON2] = ACTIONS(786),
    [anon_sym_DOT] = ACTIONS(786),
    [anon_sym_DASH] = ACTIONS(789),
    [anon_sym_LPAREN] = ACTIONS(664),
    [anon_sym_RPAREN] = ACTIONS(664),
    [anon_sym_LBRACK] = ACTIONS(664),
    [anon_sym_RBRACK] = ACTIONS(664),
    [anon_sym_LBRACE] = ACTIONS(664),
    [anon_sym_RBRACE] = ACTIONS(664),
    [anon_sym_SLASH2] = ACTIONS(664),
    [anon_sym_COMMA] = ACTIONS(664),
    [anon_sym_AT] = ACTIONS(664),
    [anon_sym_DOT2] = ACTIONS(664),
    [anon_sym_DASH2] = ACTIONS(664),
    [anon_sym_LPAREN2] = ACTIONS(789),
    [anon_sym_RPAREN2] = ACTIONS(786),
    [anon_sym_LBRACK2] = ACTIONS(786),
    [anon_sym_RBRACK2] = ACTIONS(786),
    [anon_sym_LBRACE2] = ACTIONS(786),
    [anon_sym_RBRACE2] = ACTIONS(786),
    [anon_sym_COMMA2] = ACTIONS(786),
    [anon_sym_AT2] = ACTIONS(786),
    [anon_sym_DOLLAR] = ACTIONS(664),
    [anon_sym_PLUS] = ACTIONS(664),
    [anon_sym_DQUOTE] = ACTIONS(664),
    [anon_sym_SQUOTE] = ACTIONS(664),
    [anon_sym_LPAREN3] = ACTIONS(669),
    [sym_allow_privileged] = ACTIONS(669),
    [anon_sym_DASH_DASHbuild_DASHarg] = ACTIONS(669),
    [anon_sym_DASH_DASHchmod] = ACTIONS(669),
    [anon_sym_DASH_DASHchown] = ACTIONS(669),
    [sym_dir] = ACTIONS(669),
    [sym_if_exists] = ACTIONS(669),
    [sym_keep_own] = ACTIONS(669),
    [sym_keep_ts] = ACTIONS(669),
    [sym_pass_args] = ACTIONS(669),
    [anon_sym_DASH_DASHplatform] = ACTIONS(669),
    [sym_symlink_no_follow] = ACTIONS(669),
    [aux_sym_unknown_option_token1] = ACTIONS(664),
    [sym__string_base_other] = ACTIONS(664),
    [sym__string_base_alpha] = ACTIONS(664),
    [sym__string_base_num] = ACTIONS(664),
    [sym__immediate_string_base_other] = ACTIONS(789),
    [sym__immediate_string_base_alpha] = ACTIONS(786),
    [sym__immediate_string_base_num] = ACTIONS(786),
    [anon_sym_DQUOTE2] = ACTIONS(669),
    [anon_sym_SQUOTE2] = ACTIONS(669),
    [anon_sym_PLUS2] = ACTIONS(786),
    [anon_sym_DOLLAR2] = ACTIONS(792),
    [aux_sym__immediate_escape_sequence_token1] = ACTIONS(795),
    [sym_line_continuation] = ACTIONS(3),
    [sym_comment] = ACTIONS(5),
    [sym_line_continuation_comment] = ACTIONS(5),
    [anon_sym_LF] = ACTIONS(5),
    [anon_sym_CR_LF] = ACTIONS(5),
    [anon_sym_FF] = ACTIONS(5),
  },
  [46] = {
    [sym__immediate_string_base] = STATE(76),
    [aux_sym__immediate_string_base_repeat1] = STATE(76),
    [anon_sym_SLASH] = ACTIONS(749),
    [anon_sym_COLON] = ACTIONS(751),
    [anon_sym_EQ] = ACTIONS(751),
    [anon_sym_EQ3] = ACTIONS(751),
    [anon_sym_DASH_DASH] = ACTIONS(749),
    [anon_sym_COLON2] = ACTIONS(749),
    [anon_sym_DOT] = ACTIONS(749),
    [anon_sym_DASH] = ACTIONS(751),
    [anon_sym_LPAREN] = ACTIONS(751),
    [anon_sym_RPAREN] = ACTIONS(751),
    [anon_sym_LBRACK] = ACTIONS(751),
    [anon_sym_RBRACK] = ACTIONS(751),
    [anon_sym_LBRACE] = ACTIONS(751),
    [anon_sym_RBRACE] = ACTIONS(751),
    [anon_sym_SLASH2] = ACTIONS(751),
    [anon_sym_COMMA] = ACTIONS(751),
    [anon_sym_AT] = ACTIONS(751),
    [anon_sym_DOT2] = ACTIONS(751),
    [anon_sym_DASH2] = ACTIONS(751),
    [anon_sym_LPAREN2] = ACTIONS(749),
    [anon_sym_RPAREN2] = ACTIONS(749),
    [anon_sym_LBRACK2] = ACTIONS(751),
    [anon_sym_RBRACK2] = ACTIONS(749),
    [anon_sym_LBRACE2] = ACTIONS(749),
    [anon_sym_RBRACE2] = ACTIONS(749),
    [anon_sym_COMMA2] = ACTIONS(749),
    [anon_sym_AT2] = ACTIONS(749),
    [anon_sym_DOLLAR] = ACTIONS(751),
    [anon_sym_PLUS] = ACTIONS(751),
    [anon_sym_DQUOTE] = ACTIONS(751),
    [anon_sym_SQUOTE] = ACTIONS(749),
    [anon_sym_LBRACK3] = ACTIONS(749),
    [sym_aws] = ACTIONS(749),
    [sym_entrypoint] = ACTIONS(749),
    [anon_sym_DASH_DASHinteractive] = ACTIONS(751),
    [anon_sym_DASH_DASHinteractive_DASHkeep] = ACTIONS(749),
    [anon_sym_DASH_DASHmount] = ACTIONS(749),
    [sym_network_none] = ACTIONS(749),
    [sym_no_cache] = ACTIONS(749),
    [anon_sym_DASH_DASHoidc] = ACTIONS(749),
    [sym_privileged] = ACTIONS(749),
    [sym_push] = ACTIONS(749),
    [sym_raw_output] = ACTIONS(749),
    [anon_sym_DASH_DASHsecret] = ACTIONS(749),
    [anon_sym_EQ4] = ACTIONS(749),
    [sym_ssh] = ACTIONS(749),
    [aux_sym_unknown_option_token1] = ACTIONS(751),
    [sym__string_base_other] = ACTIONS(751),
    [sym__string_base_alpha] = ACTIONS(751),
    [sym__string_base_num] = ACTIONS(751),
    [sym__immediate_string_base_other] = ACTIONS(756),
    [sym__immediate_string_base_alpha] = ACTIONS(798),
    [sym__immediate_string_base_num] = ACTIONS(798),
    [anon_sym_DQUOTE2] = ACTIONS(749),
    [anon_sym_PLUS2] = ACTIONS(749),
    [anon_sym_DOLLAR2] = ACTIONS(749),
    [aux_sym__immediate_escape_sequence_token1] = ACTIONS(751),
    [sym_line_continuation] = ACTIONS(3),
    [sym_comment] = ACTIONS(749),
    [sym_line_continuation_comment] = ACTIONS(5),
    [anon_sym_LF] = ACTIONS(5),
    [anon_sym_CR_LF] = ACTIONS(5),
    [anon_sym_FF] = ACTIONS(5),
  },
  [47] = {
    [sym__immediate_string_base] = STATE(43),
    [sym__immediate_expansion] = STATE(43),
    [sym__immediate_escape_sequence] = STATE(135),
    [aux_sym__immediate_string_base_repeat1] = STATE(43),
    [aux_sym_unquoted_string_repeat1] = STATE(43),
    [anon_sym_SLASH] = ACTIONS(693),
    [anon_sym_COLON] = ACTIONS(695),
    [anon_sym_EQ] = ACTIONS(695),
    [anon_sym_EQ3] = ACTIONS(693),
    [anon_sym_COLON2] = ACTIONS(693),
    [anon_sym_DOT] = ACTIONS(693),
    [anon_sym_DASH] = ACTIONS(695),
    [anon_sym_LPAREN] = ACTIONS(695),
    [anon_sym_RPAREN] = ACTIONS(695),
    [anon_sym_LBRACK] = ACTIONS(695),
    [anon_sym_RBRACK] = ACTIONS(695),
    [anon_sym_LBRACE] = ACTIONS(695),
    [anon_sym_RBRACE] = ACTIONS(695),
    [anon_sym_SLASH2] = ACTIONS(695),
    [anon_sym_COMMA] = ACTIONS(695),
    [anon_sym_AT] = ACTIONS(695),
    [anon_sym_DOT2] = ACTIONS(695),
    [anon_sym_DASH2] = ACTIONS(695),
    [anon_sym_LPAREN2] = ACTIONS(695),
    [anon_sym_RPAREN2] = ACTIONS(693),
    [anon_sym_LBRACK2] = ACTIONS(693),
    [anon_sym_RBRACK2] = ACTIONS(693),
    [anon_sym_LBRACE2] = ACTIONS(693),
    [anon_sym_RBRACE2] = ACTIONS(693),
    [anon_sym_COMMA2] = ACTIONS(693),
    [anon_sym_AT2] = ACTIONS(693),
    [anon_sym_DOLLAR] = ACTIONS(695),
    [anon_sym_PLUS] = ACTIONS(695),
    [anon_sym_DQUOTE] = ACTIONS(695),
    [anon_sym_SQUOTE] = ACTIONS(695),
    [anon_sym_LPAREN3] = ACTIONS(693),
    [sym_allow_privileged] = ACTIONS(693),
    [anon_sym_DASH_DASHbuild_DASHarg] = ACTIONS(693),
    [anon_sym_DASH_DASHchmod] = ACTIONS(693),
    [anon_sym_DASH_DASHchown] = ACTIONS(693),
    [sym_dir] = ACTIONS(693),
    [sym_if_exists] = ACTIONS(693),
    [sym_keep_own] = ACTIONS(693),
    [sym_keep_ts] = ACTIONS(693),
    [sym_pass_args] = ACTIONS(693),
    [anon_sym_DASH_DASHplatform] = ACTIONS(693),
    [sym_symlink_no_follow] = ACTIONS(693),
    [aux_sym_unknown_option_token1] = ACTIONS(695),
    [sym__string_base_other] = ACTIONS(695),
    [sym__string_base_alpha] = ACTIONS(695),
    [sym__string_base_num] = ACTIONS(695),
    [sym__immediate_string_base_other] = ACTIONS(695),
    [sym__immediate_string_base_alpha] = ACTIONS(693),
    [sym__immediate_string_base_num] = ACTIONS(693),
    [anon_sym_DQUOTE2] = ACTIONS(693),
    [anon_sym_SQUOTE2] = ACTIONS(693),
    [anon_sym_PLUS2] = ACTIONS(693),
    [anon_sym_DOLLAR2] = ACTIONS(693),
    [aux_sym__immediate_escape_sequence_token1] = ACTIONS(695),
    [sym_line_continuation] = ACTIONS(3),
    [sym_comment] = ACTIONS(5),
    [sym_line_continuation_comment] = ACTIONS(5),
    [anon_sym_LF] = ACTIONS(5),
    [anon_sym_CR_LF] = ACTIONS(5),
    [anon_sym_FF] = ACTIONS(5),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 7,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(801), 1,
      sym__immediate_string_base_other,
    ACTIONS(804), 2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
    STATE(102), 2,
      sym__immediate_string_base,
      aux_sym__immediate_string_base_repeat1,
    ACTIONS(5), 4,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(751), 24,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_LBRACK2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_DASH_DASHinteractive,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      aux_sym__immediate_escape_sequence_token1,
    ACTIONS(749), 30,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_DASH_DASH,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_SQUOTE,
      anon_sym_LBRACK3,
      sym_aws,
      sym_entrypoint,
      anon_sym_DASH_DASHinteractive_DASHkeep,
      anon_sym_DASH_DASHmount,
      sym_network_none,
      sym_no_cache,
      anon_sym_DASH_DASHoidc,
      sym_privileged,
      sym_push,
      sym_raw_output,
      anon_sym_DASH_DASHsecret,
      sym_ssh,
      anon_sym_DQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
      sym_comment,
  [79] = 7,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(811), 1,
      sym__immediate_string_base_other,
    STATE(49), 1,
      aux_sym__immediate_string_base_repeat1,
    ACTIONS(814), 2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
    ACTIONS(5), 4,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(809), 25,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_EQ3,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_LBRACK2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_DASH_DASHinteractive,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      aux_sym__immediate_escape_sequence_token1,
    ACTIONS(807), 30,
      anon_sym_SLASH,
      anon_sym_DASH_DASH,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_SQUOTE,
      anon_sym_LBRACK3,
      sym_aws,
      sym_entrypoint,
      anon_sym_DASH_DASHinteractive_DASHkeep,
      anon_sym_DASH_DASHmount,
      sym_network_none,
      sym_no_cache,
      anon_sym_DASH_DASHoidc,
      sym_privileged,
      sym_push,
      sym_raw_output,
      anon_sym_DASH_DASHsecret,
      anon_sym_EQ4,
      sym_ssh,
      anon_sym_DQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
      sym_comment,
  [158] = 5,
    ACTIONS(3), 1,
      sym_line_continuation,
    STATE(51), 1,
      aux_sym_variable_repeat1,
    ACTIONS(5), 4,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(819), 26,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_EQ3,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_LBRACK2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_DASH_DASHinteractive,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
    ACTIONS(817), 32,
      anon_sym_SLASH,
      anon_sym_DASH_DASH,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_SQUOTE,
      anon_sym_LBRACK3,
      sym_aws,
      sym_entrypoint,
      anon_sym_DASH_DASHinteractive_DASHkeep,
      anon_sym_DASH_DASHmount,
      sym_network_none,
      sym_no_cache,
      anon_sym_DASH_DASHoidc,
      sym_privileged,
      sym_push,
      sym_raw_output,
      anon_sym_DASH_DASHsecret,
      anon_sym_EQ4,
      sym_ssh,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
      sym_comment,
  [233] = 6,
    ACTIONS(3), 1,
      sym_line_continuation,
    STATE(51), 1,
      aux_sym_variable_repeat1,
    ACTIONS(825), 2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
    ACTIONS(5), 4,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(823), 26,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_EQ3,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_LBRACK2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_DASH_DASHinteractive,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
    ACTIONS(821), 30,
      anon_sym_SLASH,
      anon_sym_DASH_DASH,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_SQUOTE,
      anon_sym_LBRACK3,
      sym_aws,
      sym_entrypoint,
      anon_sym_DASH_DASHinteractive_DASHkeep,
      anon_sym_DASH_DASHmount,
      sym_network_none,
      sym_no_cache,
      anon_sym_DASH_DASHoidc,
      sym_privileged,
      sym_push,
      sym_raw_output,
      anon_sym_DASH_DASHsecret,
      anon_sym_EQ4,
      sym_ssh,
      anon_sym_DQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
      sym_comment,
  [310] = 5,
    ACTIONS(3), 1,
      sym_line_continuation,
    STATE(50), 1,
      aux_sym_variable_repeat1,
    ACTIONS(5), 4,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(830), 26,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_EQ3,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_LBRACK2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_DASH_DASHinteractive,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
    ACTIONS(828), 32,
      anon_sym_SLASH,
      anon_sym_DASH_DASH,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_SQUOTE,
      anon_sym_LBRACK3,
      sym_aws,
      sym_entrypoint,
      anon_sym_DASH_DASHinteractive_DASHkeep,
      anon_sym_DASH_DASHmount,
      sym_network_none,
      sym_no_cache,
      anon_sym_DASH_DASHoidc,
      sym_privileged,
      sym_push,
      sym_raw_output,
      anon_sym_DASH_DASHsecret,
      anon_sym_EQ4,
      sym_ssh,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
      sym_comment,
  [385] = 4,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 4,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(834), 26,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_EQ3,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_LBRACK2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_DASH_DASHinteractive,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
    ACTIONS(832), 32,
      anon_sym_SLASH,
      anon_sym_DASH_DASH,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_SQUOTE,
      anon_sym_LBRACK3,
      sym_aws,
      sym_entrypoint,
      anon_sym_DASH_DASHinteractive_DASHkeep,
      anon_sym_DASH_DASHmount,
      sym_network_none,
      sym_no_cache,
      anon_sym_DASH_DASHoidc,
      sym_privileged,
      sym_push,
      sym_raw_output,
      anon_sym_DASH_DASHsecret,
      anon_sym_EQ4,
      sym_ssh,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
      sym_comment,
  [457] = 13,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(840), 1,
      anon_sym_SQUOTE,
    ACTIONS(842), 1,
      anon_sym_DQUOTE2,
    ACTIONS(844), 1,
      anon_sym_DOLLAR2,
    ACTIONS(846), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(251), 1,
      sym__immediate_escape_sequence,
    ACTIONS(838), 3,
      anon_sym_DASH,
      anon_sym_LPAREN2,
      sym__immediate_string_base_other,
    STATE(63), 4,
      sym__immediate_double_quoted_string,
      sym__immediate_single_quoted_string,
      sym__immediate_unquoted_string,
      aux_sym_string_repeat1,
    STATE(147), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(449), 7,
      anon_sym_LPAREN3,
      sym_allow_privileged,
      anon_sym_DASH_DASHbuild_DASHarg,
      anon_sym_DASHf,
      anon_sym_DASH_DASHtarget,
      anon_sym_DASH_DASHplatform,
      anon_sym_SQUOTE2,
    ACTIONS(836), 14,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(445), 20,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
  [547] = 4,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 4,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(851), 26,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_EQ3,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_LBRACK2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_DASH_DASHinteractive,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
    ACTIONS(849), 32,
      anon_sym_SLASH,
      anon_sym_DASH_DASH,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_SQUOTE,
      anon_sym_LBRACK3,
      sym_aws,
      sym_entrypoint,
      anon_sym_DASH_DASHinteractive_DASHkeep,
      anon_sym_DASH_DASHmount,
      sym_network_none,
      sym_no_cache,
      anon_sym_DASH_DASHoidc,
      sym_privileged,
      sym_push,
      sym_raw_output,
      anon_sym_DASH_DASHsecret,
      anon_sym_EQ4,
      sym_ssh,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
      sym_comment,
  [619] = 4,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 4,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(855), 26,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_EQ3,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_LBRACK2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_DASH_DASHinteractive,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
    ACTIONS(853), 32,
      anon_sym_SLASH,
      anon_sym_DASH_DASH,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_SQUOTE,
      anon_sym_LBRACK3,
      sym_aws,
      sym_entrypoint,
      anon_sym_DASH_DASHinteractive_DASHkeep,
      anon_sym_DASH_DASHmount,
      sym_network_none,
      sym_no_cache,
      anon_sym_DASH_DASHoidc,
      sym_privileged,
      sym_push,
      sym_raw_output,
      anon_sym_DASH_DASHsecret,
      anon_sym_EQ4,
      sym_ssh,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
      sym_comment,
  [691] = 4,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 4,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(859), 26,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_EQ3,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_LBRACK2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_DASH_DASHinteractive,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
    ACTIONS(857), 32,
      anon_sym_SLASH,
      anon_sym_DASH_DASH,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_SQUOTE,
      anon_sym_LBRACK3,
      sym_aws,
      sym_entrypoint,
      anon_sym_DASH_DASHinteractive_DASHkeep,
      anon_sym_DASH_DASHmount,
      sym_network_none,
      sym_no_cache,
      anon_sym_DASH_DASHoidc,
      sym_privileged,
      sym_push,
      sym_raw_output,
      anon_sym_DASH_DASHsecret,
      anon_sym_EQ4,
      sym_ssh,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
      sym_comment,
  [763] = 4,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 4,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(863), 26,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_EQ3,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_LBRACK2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_DASH_DASHinteractive,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
    ACTIONS(861), 32,
      anon_sym_SLASH,
      anon_sym_DASH_DASH,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_SQUOTE,
      anon_sym_LBRACK3,
      sym_aws,
      sym_entrypoint,
      anon_sym_DASH_DASHinteractive_DASHkeep,
      anon_sym_DASH_DASHmount,
      sym_network_none,
      sym_no_cache,
      anon_sym_DASH_DASHoidc,
      sym_privileged,
      sym_push,
      sym_raw_output,
      anon_sym_DASH_DASHsecret,
      anon_sym_EQ4,
      sym_ssh,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
      sym_comment,
  [835] = 4,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 4,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(867), 26,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_EQ3,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_LBRACK2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_DASH_DASHinteractive,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
    ACTIONS(865), 32,
      anon_sym_SLASH,
      anon_sym_DASH_DASH,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_SQUOTE,
      anon_sym_LBRACK3,
      sym_aws,
      sym_entrypoint,
      anon_sym_DASH_DASHinteractive_DASHkeep,
      anon_sym_DASH_DASHmount,
      sym_network_none,
      sym_no_cache,
      anon_sym_DASH_DASHoidc,
      sym_privileged,
      sym_push,
      sym_raw_output,
      anon_sym_DASH_DASHsecret,
      anon_sym_EQ4,
      sym_ssh,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
      sym_comment,
  [907] = 4,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 4,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(871), 26,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_EQ3,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_LBRACK2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_DASH_DASHinteractive,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
    ACTIONS(869), 32,
      anon_sym_SLASH,
      anon_sym_DASH_DASH,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_SQUOTE,
      anon_sym_LBRACK3,
      sym_aws,
      sym_entrypoint,
      anon_sym_DASH_DASHinteractive_DASHkeep,
      anon_sym_DASH_DASHmount,
      sym_network_none,
      sym_no_cache,
      anon_sym_DASH_DASHoidc,
      sym_privileged,
      sym_push,
      sym_raw_output,
      anon_sym_DASH_DASHsecret,
      anon_sym_EQ4,
      sym_ssh,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
      sym_comment,
  [979] = 4,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 4,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(875), 26,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_EQ3,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_LBRACK2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_DASH_DASHinteractive,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
    ACTIONS(873), 32,
      anon_sym_SLASH,
      anon_sym_DASH_DASH,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_SQUOTE,
      anon_sym_LBRACK3,
      sym_aws,
      sym_entrypoint,
      anon_sym_DASH_DASHinteractive_DASHkeep,
      anon_sym_DASH_DASHmount,
      sym_network_none,
      sym_no_cache,
      anon_sym_DASH_DASHoidc,
      sym_privileged,
      sym_push,
      sym_raw_output,
      anon_sym_DASH_DASHsecret,
      anon_sym_EQ4,
      sym_ssh,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
      sym_comment,
  [1051] = 13,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(840), 1,
      anon_sym_SQUOTE,
    ACTIONS(842), 1,
      anon_sym_DQUOTE2,
    ACTIONS(844), 1,
      anon_sym_DOLLAR2,
    ACTIONS(877), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(251), 1,
      sym__immediate_escape_sequence,
    ACTIONS(838), 3,
      anon_sym_DASH,
      anon_sym_LPAREN2,
      sym__immediate_string_base_other,
    STATE(54), 4,
      sym__immediate_double_quoted_string,
      sym__immediate_single_quoted_string,
      sym__immediate_unquoted_string,
      aux_sym_string_repeat1,
    STATE(147), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(581), 7,
      anon_sym_LPAREN3,
      sym_allow_privileged,
      anon_sym_DASH_DASHbuild_DASHarg,
      anon_sym_DASHf,
      anon_sym_DASH_DASHtarget,
      anon_sym_DASH_DASHplatform,
      anon_sym_SQUOTE2,
    ACTIONS(836), 14,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(579), 20,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
  [1141] = 13,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(886), 1,
      anon_sym_SQUOTE,
    ACTIONS(889), 1,
      anon_sym_DQUOTE2,
    ACTIONS(892), 1,
      anon_sym_DOLLAR2,
    ACTIONS(895), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(251), 1,
      sym__immediate_escape_sequence,
    ACTIONS(883), 3,
      anon_sym_DASH,
      anon_sym_LPAREN2,
      sym__immediate_string_base_other,
    STATE(63), 4,
      sym__immediate_double_quoted_string,
      sym__immediate_single_quoted_string,
      sym__immediate_unquoted_string,
      aux_sym_string_repeat1,
    STATE(147), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(469), 7,
      anon_sym_LPAREN3,
      sym_allow_privileged,
      anon_sym_DASH_DASHbuild_DASHarg,
      anon_sym_DASHf,
      anon_sym_DASH_DASHtarget,
      anon_sym_DASH_DASHplatform,
      anon_sym_SQUOTE2,
    ACTIONS(880), 14,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(464), 20,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
  [1231] = 4,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 4,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(900), 26,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_EQ3,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_LBRACK2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_DASH_DASHinteractive,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
    ACTIONS(898), 32,
      anon_sym_SLASH,
      anon_sym_DASH_DASH,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_SQUOTE,
      anon_sym_LBRACK3,
      sym_aws,
      sym_entrypoint,
      anon_sym_DASH_DASHinteractive_DASHkeep,
      anon_sym_DASH_DASHmount,
      sym_network_none,
      sym_no_cache,
      anon_sym_DASH_DASHoidc,
      sym_privileged,
      sym_push,
      sym_raw_output,
      anon_sym_DASH_DASHsecret,
      anon_sym_EQ4,
      sym_ssh,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
      sym_comment,
  [1303] = 5,
    ACTIONS(3), 1,
      sym_line_continuation,
    STATE(74), 1,
      aux_sym_variable_repeat1,
    ACTIONS(5), 4,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(819), 25,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_LBRACK2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_DASH_DASHinteractive,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
    ACTIONS(817), 32,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_DASH_DASH,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_SQUOTE,
      anon_sym_LBRACK3,
      sym_aws,
      sym_entrypoint,
      anon_sym_DASH_DASHinteractive_DASHkeep,
      anon_sym_DASH_DASHmount,
      sym_network_none,
      sym_no_cache,
      anon_sym_DASH_DASHoidc,
      sym_privileged,
      sym_push,
      sym_raw_output,
      anon_sym_DASH_DASHsecret,
      sym_ssh,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
      sym_comment,
  [1377] = 4,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 4,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(904), 26,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_EQ3,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_LBRACK2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_DASH_DASHinteractive,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
    ACTIONS(902), 32,
      anon_sym_SLASH,
      anon_sym_DASH_DASH,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_SQUOTE,
      anon_sym_LBRACK3,
      sym_aws,
      sym_entrypoint,
      anon_sym_DASH_DASHinteractive_DASHkeep,
      anon_sym_DASH_DASHmount,
      sym_network_none,
      sym_no_cache,
      anon_sym_DASH_DASHoidc,
      sym_privileged,
      sym_push,
      sym_raw_output,
      anon_sym_DASH_DASHsecret,
      anon_sym_EQ4,
      sym_ssh,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
      sym_comment,
  [1449] = 7,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(906), 1,
      sym__immediate_string_base_other,
    STATE(67), 1,
      aux_sym__immediate_string_base_repeat1,
    ACTIONS(909), 2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
    ACTIONS(5), 4,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(809), 24,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_LBRACK2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_DASH_DASHinteractive,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      aux_sym__immediate_escape_sequence_token1,
    ACTIONS(807), 30,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_DASH_DASH,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_SQUOTE,
      anon_sym_LBRACK3,
      sym_aws,
      sym_entrypoint,
      anon_sym_DASH_DASHinteractive_DASHkeep,
      anon_sym_DASH_DASHmount,
      sym_network_none,
      sym_no_cache,
      anon_sym_DASH_DASHoidc,
      sym_privileged,
      sym_push,
      sym_raw_output,
      anon_sym_DASH_DASHsecret,
      sym_ssh,
      anon_sym_DQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
      sym_comment,
  [1527] = 4,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 4,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(914), 26,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_EQ3,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_LBRACK2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_DASH_DASHinteractive,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
    ACTIONS(912), 32,
      anon_sym_SLASH,
      anon_sym_DASH_DASH,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_SQUOTE,
      anon_sym_LBRACK3,
      sym_aws,
      sym_entrypoint,
      anon_sym_DASH_DASHinteractive_DASHkeep,
      anon_sym_DASH_DASHmount,
      sym_network_none,
      sym_no_cache,
      anon_sym_DASH_DASHoidc,
      sym_privileged,
      sym_push,
      sym_raw_output,
      anon_sym_DASH_DASHsecret,
      anon_sym_EQ4,
      sym_ssh,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
      sym_comment,
  [1599] = 4,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 4,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(918), 26,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_EQ3,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_LBRACK2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_DASH_DASHinteractive,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
    ACTIONS(916), 32,
      anon_sym_SLASH,
      anon_sym_DASH_DASH,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_SQUOTE,
      anon_sym_LBRACK3,
      sym_aws,
      sym_entrypoint,
      anon_sym_DASH_DASHinteractive_DASHkeep,
      anon_sym_DASH_DASHmount,
      sym_network_none,
      sym_no_cache,
      anon_sym_DASH_DASHoidc,
      sym_privileged,
      sym_push,
      sym_raw_output,
      anon_sym_DASH_DASHsecret,
      anon_sym_EQ4,
      sym_ssh,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
      sym_comment,
  [1671] = 4,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 4,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(922), 26,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_EQ3,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_LBRACK2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_DASH_DASHinteractive,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
    ACTIONS(920), 32,
      anon_sym_SLASH,
      anon_sym_DASH_DASH,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_SQUOTE,
      anon_sym_LBRACK3,
      sym_aws,
      sym_entrypoint,
      anon_sym_DASH_DASHinteractive_DASHkeep,
      anon_sym_DASH_DASHmount,
      sym_network_none,
      sym_no_cache,
      anon_sym_DASH_DASHoidc,
      sym_privileged,
      sym_push,
      sym_raw_output,
      anon_sym_DASH_DASHsecret,
      anon_sym_EQ4,
      sym_ssh,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
      sym_comment,
  [1743] = 5,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(928), 3,
      anon_sym_EQ4,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
    ACTIONS(5), 4,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(926), 26,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_EQ3,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_LBRACK2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_DASH_DASHinteractive,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
    ACTIONS(924), 29,
      anon_sym_SLASH,
      anon_sym_DASH_DASH,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_SQUOTE,
      anon_sym_LBRACK3,
      sym_aws,
      sym_entrypoint,
      anon_sym_DASH_DASHinteractive_DASHkeep,
      anon_sym_DASH_DASHmount,
      sym_network_none,
      sym_no_cache,
      anon_sym_DASH_DASHoidc,
      sym_privileged,
      sym_push,
      sym_raw_output,
      anon_sym_DASH_DASHsecret,
      sym_ssh,
      anon_sym_DQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
      sym_comment,
  [1817] = 4,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 4,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(933), 26,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_EQ3,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_LBRACK2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_DASH_DASHinteractive,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
    ACTIONS(931), 32,
      anon_sym_SLASH,
      anon_sym_DASH_DASH,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_SQUOTE,
      anon_sym_LBRACK3,
      sym_aws,
      sym_entrypoint,
      anon_sym_DASH_DASHinteractive_DASHkeep,
      anon_sym_DASH_DASHmount,
      sym_network_none,
      sym_no_cache,
      anon_sym_DASH_DASHoidc,
      sym_privileged,
      sym_push,
      sym_raw_output,
      anon_sym_DASH_DASHsecret,
      anon_sym_EQ4,
      sym_ssh,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
      sym_comment,
  [1889] = 4,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 4,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(937), 26,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_EQ3,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_LBRACK2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_DASH_DASHinteractive,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
    ACTIONS(935), 32,
      anon_sym_SLASH,
      anon_sym_DASH_DASH,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_SQUOTE,
      anon_sym_LBRACK3,
      sym_aws,
      sym_entrypoint,
      anon_sym_DASH_DASHinteractive_DASHkeep,
      anon_sym_DASH_DASHmount,
      sym_network_none,
      sym_no_cache,
      anon_sym_DASH_DASHoidc,
      sym_privileged,
      sym_push,
      sym_raw_output,
      anon_sym_DASH_DASHsecret,
      anon_sym_EQ4,
      sym_ssh,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
      sym_comment,
  [1961] = 6,
    ACTIONS(3), 1,
      sym_line_continuation,
    STATE(74), 1,
      aux_sym_variable_repeat1,
    ACTIONS(939), 2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
    ACTIONS(5), 4,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(823), 25,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_LBRACK2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_DASH_DASHinteractive,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
    ACTIONS(821), 30,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_DASH_DASH,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_SQUOTE,
      anon_sym_LBRACK3,
      sym_aws,
      sym_entrypoint,
      anon_sym_DASH_DASHinteractive_DASHkeep,
      anon_sym_DASH_DASHmount,
      sym_network_none,
      sym_no_cache,
      anon_sym_DASH_DASHoidc,
      sym_privileged,
      sym_push,
      sym_raw_output,
      anon_sym_DASH_DASHsecret,
      sym_ssh,
      anon_sym_DQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
      sym_comment,
  [2037] = 5,
    ACTIONS(3), 1,
      sym_line_continuation,
    STATE(65), 1,
      aux_sym_variable_repeat1,
    ACTIONS(5), 4,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(830), 25,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_LBRACK2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_DASH_DASHinteractive,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
    ACTIONS(828), 32,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_DASH_DASH,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_SQUOTE,
      anon_sym_LBRACK3,
      sym_aws,
      sym_entrypoint,
      anon_sym_DASH_DASHinteractive_DASHkeep,
      anon_sym_DASH_DASHmount,
      sym_network_none,
      sym_no_cache,
      anon_sym_DASH_DASHoidc,
      sym_privileged,
      sym_push,
      sym_raw_output,
      anon_sym_DASH_DASHsecret,
      sym_ssh,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
      sym_comment,
  [2111] = 4,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 4,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(944), 26,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_EQ3,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_LBRACK2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_DASH_DASHinteractive,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
    ACTIONS(942), 32,
      anon_sym_SLASH,
      anon_sym_DASH_DASH,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_SQUOTE,
      anon_sym_LBRACK3,
      sym_aws,
      sym_entrypoint,
      anon_sym_DASH_DASHinteractive_DASHkeep,
      anon_sym_DASH_DASHmount,
      sym_network_none,
      sym_no_cache,
      anon_sym_DASH_DASHoidc,
      sym_privileged,
      sym_push,
      sym_raw_output,
      anon_sym_DASH_DASHsecret,
      anon_sym_EQ4,
      sym_ssh,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
      sym_comment,
  [2183] = 4,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 4,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(834), 25,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_LBRACK2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_DASH_DASHinteractive,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
    ACTIONS(832), 32,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_DASH_DASH,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_SQUOTE,
      anon_sym_LBRACK3,
      sym_aws,
      sym_entrypoint,
      anon_sym_DASH_DASHinteractive_DASHkeep,
      anon_sym_DASH_DASHmount,
      sym_network_none,
      sym_no_cache,
      anon_sym_DASH_DASHoidc,
      sym_privileged,
      sym_push,
      sym_raw_output,
      anon_sym_DASH_DASHsecret,
      sym_ssh,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
      sym_comment,
  [2254] = 13,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(952), 1,
      anon_sym_SQUOTE,
    ACTIONS(955), 1,
      anon_sym_DQUOTE2,
    ACTIONS(958), 1,
      anon_sym_DOLLAR2,
    ACTIONS(961), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(304), 1,
      sym__immediate_escape_sequence,
    ACTIONS(949), 2,
      anon_sym_DASH,
      sym__immediate_string_base_other,
    STATE(78), 4,
      sym__immediate_double_quoted_string,
      sym__immediate_single_quoted_string,
      sym__immediate_unquoted_string,
      aux_sym_string_repeat1,
    STATE(154), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(469), 6,
      sym_allow_privileged,
      sym_auto_skip,
      anon_sym_DASH_DASHbuild_DASHarg,
      sym_pass_args,
      anon_sym_DASH_DASHplatform,
      anon_sym_SQUOTE2,
    ACTIONS(946), 15,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(464), 20,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
  [2343] = 4,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 4,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(875), 25,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_LBRACK2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_DASH_DASHinteractive,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
    ACTIONS(873), 32,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_DASH_DASH,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_SQUOTE,
      anon_sym_LBRACK3,
      sym_aws,
      sym_entrypoint,
      anon_sym_DASH_DASHinteractive_DASHkeep,
      anon_sym_DASH_DASHmount,
      sym_network_none,
      sym_no_cache,
      anon_sym_DASH_DASHoidc,
      sym_privileged,
      sym_push,
      sym_raw_output,
      anon_sym_DASH_DASHsecret,
      sym_ssh,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
      sym_comment,
  [2414] = 4,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 4,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(855), 25,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_LBRACK2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_DASH_DASHinteractive,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
    ACTIONS(853), 32,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_DASH_DASH,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_SQUOTE,
      anon_sym_LBRACK3,
      sym_aws,
      sym_entrypoint,
      anon_sym_DASH_DASHinteractive_DASHkeep,
      anon_sym_DASH_DASHmount,
      sym_network_none,
      sym_no_cache,
      anon_sym_DASH_DASHoidc,
      sym_privileged,
      sym_push,
      sym_raw_output,
      anon_sym_DASH_DASHsecret,
      sym_ssh,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
      sym_comment,
  [2485] = 13,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(968), 1,
      anon_sym_SQUOTE,
    ACTIONS(971), 1,
      anon_sym_DQUOTE2,
    ACTIONS(973), 1,
      anon_sym_DOLLAR2,
    ACTIONS(975), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(354), 1,
      sym__immediate_escape_sequence,
    ACTIONS(966), 3,
      anon_sym_EQ3,
      anon_sym_DASH,
      sym__immediate_string_base_other,
    ACTIONS(5), 4,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    STATE(103), 4,
      sym__immediate_double_quoted_string,
      sym__immediate_single_quoted_string,
      sym__immediate_unquoted_string,
      aux_sym_string_repeat1,
    STATE(174), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(449), 7,
      anon_sym_DASH_DASHmount,
      sym_no_cache,
      sym_privileged,
      anon_sym_DASH_DASHsecret,
      anon_sym_EQ4,
      sym_ssh,
      sym_comment,
    ACTIONS(964), 14,
      anon_sym_SLASH,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(445), 20,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
  [2574] = 13,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(984), 1,
      anon_sym_SQUOTE,
    ACTIONS(987), 1,
      anon_sym_DQUOTE2,
    ACTIONS(990), 1,
      anon_sym_DOLLAR2,
    ACTIONS(993), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(282), 1,
      sym__immediate_escape_sequence,
    ACTIONS(981), 2,
      anon_sym_DASH,
      sym__immediate_string_base_other,
    STATE(82), 4,
      sym__immediate_double_quoted_string,
      sym__immediate_single_quoted_string,
      sym__immediate_unquoted_string,
      aux_sym_string_repeat1,
    STATE(163), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(469), 6,
      sym_force,
      sym_if_exists,
      sym_keep_own,
      sym_keep_ts,
      sym_symlink_no_follow,
      anon_sym_SQUOTE2,
    ACTIONS(978), 15,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(464), 20,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
  [2663] = 4,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 4,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(918), 25,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_LBRACK2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_DASH_DASHinteractive,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
    ACTIONS(916), 32,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_DASH_DASH,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_SQUOTE,
      anon_sym_LBRACK3,
      sym_aws,
      sym_entrypoint,
      anon_sym_DASH_DASHinteractive_DASHkeep,
      anon_sym_DASH_DASHmount,
      sym_network_none,
      sym_no_cache,
      anon_sym_DASH_DASHoidc,
      sym_privileged,
      sym_push,
      sym_raw_output,
      anon_sym_DASH_DASHsecret,
      sym_ssh,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
      sym_comment,
  [2734] = 13,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(1000), 1,
      anon_sym_SQUOTE,
    ACTIONS(1002), 1,
      anon_sym_DQUOTE2,
    ACTIONS(1004), 1,
      anon_sym_DOLLAR2,
    ACTIONS(1006), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(304), 1,
      sym__immediate_escape_sequence,
    ACTIONS(998), 2,
      anon_sym_DASH,
      sym__immediate_string_base_other,
    STATE(89), 4,
      sym__immediate_double_quoted_string,
      sym__immediate_single_quoted_string,
      sym__immediate_unquoted_string,
      aux_sym_string_repeat1,
    STATE(154), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(581), 6,
      sym_allow_privileged,
      sym_auto_skip,
      anon_sym_DASH_DASHbuild_DASHarg,
      sym_pass_args,
      anon_sym_DASH_DASHplatform,
      anon_sym_SQUOTE2,
    ACTIONS(996), 15,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(579), 20,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
  [2823] = 4,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 4,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(867), 25,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_LBRACK2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_DASH_DASHinteractive,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
    ACTIONS(865), 32,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_DASH_DASH,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_SQUOTE,
      anon_sym_LBRACK3,
      sym_aws,
      sym_entrypoint,
      anon_sym_DASH_DASHinteractive_DASHkeep,
      anon_sym_DASH_DASHmount,
      sym_network_none,
      sym_no_cache,
      anon_sym_DASH_DASHoidc,
      sym_privileged,
      sym_push,
      sym_raw_output,
      anon_sym_DASH_DASHsecret,
      sym_ssh,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
      sym_comment,
  [2894] = 13,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(971), 1,
      anon_sym_DQUOTE2,
    ACTIONS(973), 1,
      anon_sym_DOLLAR2,
    ACTIONS(1009), 1,
      anon_sym_SQUOTE,
    ACTIONS(1012), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(354), 1,
      sym__immediate_escape_sequence,
    ACTIONS(966), 3,
      anon_sym_EQ3,
      anon_sym_DASH,
      sym__immediate_string_base_other,
    ACTIONS(5), 4,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    STATE(81), 4,
      sym__immediate_double_quoted_string,
      sym__immediate_single_quoted_string,
      sym__immediate_unquoted_string,
      aux_sym_string_repeat1,
    STATE(174), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(581), 7,
      anon_sym_DASH_DASHmount,
      sym_no_cache,
      sym_privileged,
      anon_sym_DASH_DASHsecret,
      anon_sym_EQ4,
      sym_ssh,
      sym_comment,
    ACTIONS(964), 14,
      anon_sym_SLASH,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(579), 20,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
  [2983] = 4,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 4,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(871), 25,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_LBRACK2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_DASH_DASHinteractive,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
    ACTIONS(869), 32,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_DASH_DASH,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_SQUOTE,
      anon_sym_LBRACK3,
      sym_aws,
      sym_entrypoint,
      anon_sym_DASH_DASHinteractive_DASHkeep,
      anon_sym_DASH_DASHmount,
      sym_network_none,
      sym_no_cache,
      anon_sym_DASH_DASHoidc,
      sym_privileged,
      sym_push,
      sym_raw_output,
      anon_sym_DASH_DASHsecret,
      sym_ssh,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
      sym_comment,
  [3054] = 13,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 1,
      sym_line_continuation_comment,
    ACTIONS(1021), 1,
      anon_sym_SQUOTE,
    ACTIONS(1024), 1,
      anon_sym_DQUOTE2,
    ACTIONS(1027), 1,
      anon_sym_DOLLAR2,
    ACTIONS(1030), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(309), 1,
      sym__immediate_escape_sequence,
    ACTIONS(1018), 2,
      anon_sym_DASH,
      sym__immediate_string_base_other,
    STATE(88), 4,
      sym__immediate_double_quoted_string,
      sym__immediate_single_quoted_string,
      sym__immediate_unquoted_string,
      aux_sym_string_repeat1,
    STATE(152), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(469), 9,
      anon_sym_DASH_DASHcache_DASHfrom,
      sym_cache_hint,
      sym_push,
      sym_without_earthly_labels,
      anon_sym_SQUOTE2,
      sym_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(1015), 15,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(464), 21,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      anon_sym_NULL,
  [3143] = 13,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(1000), 1,
      anon_sym_SQUOTE,
    ACTIONS(1002), 1,
      anon_sym_DQUOTE2,
    ACTIONS(1004), 1,
      anon_sym_DOLLAR2,
    ACTIONS(1033), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(304), 1,
      sym__immediate_escape_sequence,
    ACTIONS(998), 2,
      anon_sym_DASH,
      sym__immediate_string_base_other,
    STATE(78), 4,
      sym__immediate_double_quoted_string,
      sym__immediate_single_quoted_string,
      sym__immediate_unquoted_string,
      aux_sym_string_repeat1,
    STATE(154), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(449), 6,
      sym_allow_privileged,
      sym_auto_skip,
      anon_sym_DASH_DASHbuild_DASHarg,
      sym_pass_args,
      anon_sym_DASH_DASHplatform,
      anon_sym_SQUOTE2,
    ACTIONS(996), 15,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(445), 20,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
  [3232] = 4,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 4,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(851), 25,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_LBRACK2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_DASH_DASHinteractive,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
    ACTIONS(849), 32,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_DASH_DASH,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_SQUOTE,
      anon_sym_LBRACK3,
      sym_aws,
      sym_entrypoint,
      anon_sym_DASH_DASHinteractive_DASHkeep,
      anon_sym_DASH_DASHmount,
      sym_network_none,
      sym_no_cache,
      anon_sym_DASH_DASHoidc,
      sym_privileged,
      sym_push,
      sym_raw_output,
      anon_sym_DASH_DASHsecret,
      sym_ssh,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
      sym_comment,
  [3303] = 13,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(1040), 1,
      anon_sym_SQUOTE,
    ACTIONS(1042), 1,
      anon_sym_DQUOTE2,
    ACTIONS(1044), 1,
      anon_sym_DOLLAR2,
    ACTIONS(1046), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(282), 1,
      sym__immediate_escape_sequence,
    ACTIONS(1038), 2,
      anon_sym_DASH,
      sym__immediate_string_base_other,
    STATE(82), 4,
      sym__immediate_double_quoted_string,
      sym__immediate_single_quoted_string,
      sym__immediate_unquoted_string,
      aux_sym_string_repeat1,
    STATE(163), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(449), 6,
      sym_force,
      sym_if_exists,
      sym_keep_own,
      sym_keep_ts,
      sym_symlink_no_follow,
      anon_sym_SQUOTE2,
    ACTIONS(1036), 15,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(445), 20,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
  [3392] = 4,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 4,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(914), 25,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_LBRACK2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_DASH_DASHinteractive,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
    ACTIONS(912), 32,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_DASH_DASH,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_SQUOTE,
      anon_sym_LBRACK3,
      sym_aws,
      sym_entrypoint,
      anon_sym_DASH_DASHinteractive_DASHkeep,
      anon_sym_DASH_DASHmount,
      sym_network_none,
      sym_no_cache,
      anon_sym_DASH_DASHoidc,
      sym_privileged,
      sym_push,
      sym_raw_output,
      anon_sym_DASH_DASHsecret,
      sym_ssh,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
      sym_comment,
  [3463] = 4,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 4,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(863), 25,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_LBRACK2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_DASH_DASHinteractive,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
    ACTIONS(861), 32,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_DASH_DASH,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_SQUOTE,
      anon_sym_LBRACK3,
      sym_aws,
      sym_entrypoint,
      anon_sym_DASH_DASHinteractive_DASHkeep,
      anon_sym_DASH_DASHmount,
      sym_network_none,
      sym_no_cache,
      anon_sym_DASH_DASHoidc,
      sym_privileged,
      sym_push,
      sym_raw_output,
      anon_sym_DASH_DASHsecret,
      sym_ssh,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
      sym_comment,
  [3534] = 4,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 4,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(922), 25,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_LBRACK2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_DASH_DASHinteractive,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
    ACTIONS(920), 32,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_DASH_DASH,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_SQUOTE,
      anon_sym_LBRACK3,
      sym_aws,
      sym_entrypoint,
      anon_sym_DASH_DASHinteractive_DASHkeep,
      anon_sym_DASH_DASHmount,
      sym_network_none,
      sym_no_cache,
      anon_sym_DASH_DASHoidc,
      sym_privileged,
      sym_push,
      sym_raw_output,
      anon_sym_DASH_DASHsecret,
      sym_ssh,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
      sym_comment,
  [3605] = 4,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 4,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(900), 25,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_LBRACK2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_DASH_DASHinteractive,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
    ACTIONS(898), 32,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_DASH_DASH,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_SQUOTE,
      anon_sym_LBRACK3,
      sym_aws,
      sym_entrypoint,
      anon_sym_DASH_DASHinteractive_DASHkeep,
      anon_sym_DASH_DASHmount,
      sym_network_none,
      sym_no_cache,
      anon_sym_DASH_DASHoidc,
      sym_privileged,
      sym_push,
      sym_raw_output,
      anon_sym_DASH_DASHsecret,
      sym_ssh,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
      sym_comment,
  [3676] = 4,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 4,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(904), 25,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_LBRACK2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_DASH_DASHinteractive,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
    ACTIONS(902), 32,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_DASH_DASH,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_SQUOTE,
      anon_sym_LBRACK3,
      sym_aws,
      sym_entrypoint,
      anon_sym_DASH_DASHinteractive_DASHkeep,
      anon_sym_DASH_DASHmount,
      sym_network_none,
      sym_no_cache,
      anon_sym_DASH_DASHoidc,
      sym_privileged,
      sym_push,
      sym_raw_output,
      anon_sym_DASH_DASHsecret,
      sym_ssh,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
      sym_comment,
  [3747] = 4,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 4,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(937), 25,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_LBRACK2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_DASH_DASHinteractive,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
    ACTIONS(935), 32,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_DASH_DASH,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_SQUOTE,
      anon_sym_LBRACK3,
      sym_aws,
      sym_entrypoint,
      anon_sym_DASH_DASHinteractive_DASHkeep,
      anon_sym_DASH_DASHmount,
      sym_network_none,
      sym_no_cache,
      anon_sym_DASH_DASHoidc,
      sym_privileged,
      sym_push,
      sym_raw_output,
      anon_sym_DASH_DASHsecret,
      sym_ssh,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
      sym_comment,
  [3818] = 4,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 4,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(859), 25,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_LBRACK2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_DASH_DASHinteractive,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
    ACTIONS(857), 32,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_DASH_DASH,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_SQUOTE,
      anon_sym_LBRACK3,
      sym_aws,
      sym_entrypoint,
      anon_sym_DASH_DASHinteractive_DASHkeep,
      anon_sym_DASH_DASHmount,
      sym_network_none,
      sym_no_cache,
      anon_sym_DASH_DASHoidc,
      sym_privileged,
      sym_push,
      sym_raw_output,
      anon_sym_DASH_DASHsecret,
      sym_ssh,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
      sym_comment,
  [3889] = 13,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 1,
      sym_line_continuation_comment,
    ACTIONS(1053), 1,
      anon_sym_SQUOTE,
    ACTIONS(1055), 1,
      anon_sym_DQUOTE2,
    ACTIONS(1057), 1,
      anon_sym_DOLLAR2,
    ACTIONS(1059), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(309), 1,
      sym__immediate_escape_sequence,
    ACTIONS(1051), 2,
      anon_sym_DASH,
      sym__immediate_string_base_other,
    STATE(105), 4,
      sym__immediate_double_quoted_string,
      sym__immediate_single_quoted_string,
      sym__immediate_unquoted_string,
      aux_sym_string_repeat1,
    STATE(152), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(581), 9,
      anon_sym_DASH_DASHcache_DASHfrom,
      sym_cache_hint,
      sym_push,
      sym_without_earthly_labels,
      anon_sym_SQUOTE2,
      sym_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(1049), 15,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(579), 21,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      anon_sym_NULL,
  [3978] = 13,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(1040), 1,
      anon_sym_SQUOTE,
    ACTIONS(1042), 1,
      anon_sym_DQUOTE2,
    ACTIONS(1044), 1,
      anon_sym_DOLLAR2,
    ACTIONS(1062), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(282), 1,
      sym__immediate_escape_sequence,
    ACTIONS(1038), 2,
      anon_sym_DASH,
      sym__immediate_string_base_other,
    STATE(91), 4,
      sym__immediate_double_quoted_string,
      sym__immediate_single_quoted_string,
      sym__immediate_unquoted_string,
      aux_sym_string_repeat1,
    STATE(163), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(581), 6,
      sym_force,
      sym_if_exists,
      sym_keep_own,
      sym_keep_ts,
      sym_symlink_no_follow,
      anon_sym_SQUOTE2,
    ACTIONS(1036), 15,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(579), 20,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
  [4067] = 4,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 4,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(933), 25,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_LBRACK2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_DASH_DASHinteractive,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
    ACTIONS(931), 32,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_DASH_DASH,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_SQUOTE,
      anon_sym_LBRACK3,
      sym_aws,
      sym_entrypoint,
      anon_sym_DASH_DASHinteractive_DASHkeep,
      anon_sym_DASH_DASHmount,
      sym_network_none,
      sym_no_cache,
      anon_sym_DASH_DASHoidc,
      sym_privileged,
      sym_push,
      sym_raw_output,
      anon_sym_DASH_DASHsecret,
      sym_ssh,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
      sym_comment,
  [4138] = 4,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 4,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(944), 25,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_LBRACK2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_DASH_DASHinteractive,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
    ACTIONS(942), 32,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_DASH_DASH,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_SQUOTE,
      anon_sym_LBRACK3,
      sym_aws,
      sym_entrypoint,
      anon_sym_DASH_DASHinteractive_DASHkeep,
      anon_sym_DASH_DASHmount,
      sym_network_none,
      sym_no_cache,
      anon_sym_DASH_DASHoidc,
      sym_privileged,
      sym_push,
      sym_raw_output,
      anon_sym_DASH_DASHsecret,
      sym_ssh,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
      sym_comment,
  [4209] = 13,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(1071), 1,
      anon_sym_SQUOTE,
    ACTIONS(1074), 1,
      anon_sym_DQUOTE2,
    ACTIONS(1077), 1,
      anon_sym_DOLLAR2,
    ACTIONS(1080), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(354), 1,
      sym__immediate_escape_sequence,
    ACTIONS(1068), 3,
      anon_sym_EQ3,
      anon_sym_DASH,
      sym__immediate_string_base_other,
    ACTIONS(5), 4,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    STATE(103), 4,
      sym__immediate_double_quoted_string,
      sym__immediate_single_quoted_string,
      sym__immediate_unquoted_string,
      aux_sym_string_repeat1,
    STATE(174), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(469), 7,
      anon_sym_DASH_DASHmount,
      sym_no_cache,
      sym_privileged,
      anon_sym_DASH_DASHsecret,
      anon_sym_EQ4,
      sym_ssh,
      sym_comment,
    ACTIONS(1065), 14,
      anon_sym_SLASH,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(464), 20,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
  [4298] = 7,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(1083), 1,
      sym__immediate_string_base_other,
    ACTIONS(1086), 2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
    STATE(116), 2,
      sym__immediate_string_base,
      aux_sym__immediate_string_base_repeat1,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(751), 24,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_LPAREN2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      aux_sym__immediate_escape_sequence_token1,
    ACTIONS(749), 27,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_LPAREN3,
      sym_allow_privileged,
      anon_sym_DASH_DASHbuild_DASHarg,
      anon_sym_DASH_DASHchmod,
      anon_sym_DASH_DASHchown,
      sym_dir,
      sym_if_exists,
      sym_keep_own,
      sym_keep_ts,
      sym_pass_args,
      anon_sym_DASH_DASHplatform,
      sym_symlink_no_follow,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
  [4375] = 13,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 1,
      sym_line_continuation_comment,
    ACTIONS(1053), 1,
      anon_sym_SQUOTE,
    ACTIONS(1055), 1,
      anon_sym_DQUOTE2,
    ACTIONS(1057), 1,
      anon_sym_DOLLAR2,
    ACTIONS(1089), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(309), 1,
      sym__immediate_escape_sequence,
    ACTIONS(1051), 2,
      anon_sym_DASH,
      sym__immediate_string_base_other,
    STATE(88), 4,
      sym__immediate_double_quoted_string,
      sym__immediate_single_quoted_string,
      sym__immediate_unquoted_string,
      aux_sym_string_repeat1,
    STATE(152), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(449), 9,
      anon_sym_DASH_DASHcache_DASHfrom,
      sym_cache_hint,
      sym_push,
      sym_without_earthly_labels,
      anon_sym_SQUOTE2,
      sym_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(1049), 15,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(445), 21,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      anon_sym_NULL,
  [4464] = 13,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(1096), 1,
      anon_sym_SQUOTE,
    ACTIONS(1099), 1,
      anon_sym_DQUOTE2,
    ACTIONS(1101), 1,
      anon_sym_DOLLAR2,
    ACTIONS(1103), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(382), 1,
      sym__immediate_escape_sequence,
    ACTIONS(1094), 2,
      anon_sym_DASH,
      sym__immediate_string_base_other,
    ACTIONS(5), 4,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    STATE(113), 4,
      sym__immediate_double_quoted_string,
      sym__immediate_single_quoted_string,
      sym__immediate_unquoted_string,
      aux_sym_string_repeat1,
    STATE(186), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(449), 6,
      anon_sym_DASH_DASHmount,
      sym_no_cache,
      sym_privileged,
      anon_sym_DASH_DASHsecret,
      sym_ssh,
      sym_comment,
    ACTIONS(1092), 15,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(445), 20,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
  [4552] = 6,
    ACTIONS(3), 1,
      sym_line_continuation,
    STATE(107), 1,
      aux_sym_variable_repeat1,
    ACTIONS(1106), 2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(823), 25,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_LPAREN2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
    ACTIONS(821), 27,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_LPAREN3,
      sym_allow_privileged,
      anon_sym_DASH_DASHbuild_DASHarg,
      anon_sym_DASH_DASHchmod,
      anon_sym_DASH_DASHchown,
      sym_dir,
      sym_if_exists,
      sym_keep_own,
      sym_keep_ts,
      sym_pass_args,
      anon_sym_DASH_DASHplatform,
      sym_symlink_no_follow,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
  [4626] = 13,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(1113), 1,
      anon_sym_SQUOTE,
    ACTIONS(1115), 1,
      anon_sym_DQUOTE2,
    ACTIONS(1117), 1,
      anon_sym_DOLLAR2,
    ACTIONS(1119), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(395), 1,
      sym__immediate_escape_sequence,
    ACTIONS(1111), 2,
      anon_sym_DASH,
      sym__immediate_string_base_other,
    STATE(112), 4,
      sym__immediate_double_quoted_string,
      sym__immediate_single_quoted_string,
      sym__immediate_unquoted_string,
      aux_sym_string_repeat1,
    STATE(187), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(449), 5,
      anon_sym_DASH_DASHchmod,
      anon_sym_DASH_DASHid,
      sym_persist,
      anon_sym_DASH_DASHsharing,
      anon_sym_SQUOTE2,
    ACTIONS(1109), 15,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(445), 20,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
  [4714] = 5,
    ACTIONS(3), 1,
      sym_line_continuation,
    STATE(107), 1,
      aux_sym_variable_repeat1,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(819), 25,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_LPAREN2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
    ACTIONS(817), 29,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_LPAREN3,
      sym_allow_privileged,
      anon_sym_DASH_DASHbuild_DASHarg,
      anon_sym_DASH_DASHchmod,
      anon_sym_DASH_DASHchown,
      sym_dir,
      sym_if_exists,
      sym_keep_own,
      sym_keep_ts,
      sym_pass_args,
      anon_sym_DASH_DASHplatform,
      sym_symlink_no_follow,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
  [4786] = 13,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(1099), 1,
      anon_sym_DQUOTE2,
    ACTIONS(1101), 1,
      anon_sym_DOLLAR2,
    ACTIONS(1122), 1,
      anon_sym_SQUOTE,
    ACTIONS(1125), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(382), 1,
      sym__immediate_escape_sequence,
    ACTIONS(1094), 2,
      anon_sym_DASH,
      sym__immediate_string_base_other,
    ACTIONS(5), 4,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    STATE(106), 4,
      sym__immediate_double_quoted_string,
      sym__immediate_single_quoted_string,
      sym__immediate_unquoted_string,
      aux_sym_string_repeat1,
    STATE(186), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(581), 6,
      anon_sym_DASH_DASHmount,
      sym_no_cache,
      sym_privileged,
      anon_sym_DASH_DASHsecret,
      sym_ssh,
      sym_comment,
    ACTIONS(1092), 15,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(579), 20,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
  [4874] = 7,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(1128), 1,
      sym__immediate_string_base_other,
    STATE(111), 1,
      aux_sym__immediate_string_base_repeat1,
    ACTIONS(1131), 2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(809), 24,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_LPAREN2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      aux_sym__immediate_escape_sequence_token1,
    ACTIONS(807), 27,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_LPAREN3,
      sym_allow_privileged,
      anon_sym_DASH_DASHbuild_DASHarg,
      anon_sym_DASH_DASHchmod,
      anon_sym_DASH_DASHchown,
      sym_dir,
      sym_if_exists,
      sym_keep_own,
      sym_keep_ts,
      sym_pass_args,
      anon_sym_DASH_DASHplatform,
      sym_symlink_no_follow,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
  [4950] = 13,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(1140), 1,
      anon_sym_SQUOTE,
    ACTIONS(1143), 1,
      anon_sym_DQUOTE2,
    ACTIONS(1146), 1,
      anon_sym_DOLLAR2,
    ACTIONS(1149), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(395), 1,
      sym__immediate_escape_sequence,
    ACTIONS(1137), 2,
      anon_sym_DASH,
      sym__immediate_string_base_other,
    STATE(112), 4,
      sym__immediate_double_quoted_string,
      sym__immediate_single_quoted_string,
      sym__immediate_unquoted_string,
      aux_sym_string_repeat1,
    STATE(187), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(469), 5,
      anon_sym_DASH_DASHchmod,
      anon_sym_DASH_DASHid,
      sym_persist,
      anon_sym_DASH_DASHsharing,
      anon_sym_SQUOTE2,
    ACTIONS(1134), 15,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(464), 20,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
  [5038] = 13,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(1158), 1,
      anon_sym_SQUOTE,
    ACTIONS(1161), 1,
      anon_sym_DQUOTE2,
    ACTIONS(1164), 1,
      anon_sym_DOLLAR2,
    ACTIONS(1167), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(382), 1,
      sym__immediate_escape_sequence,
    ACTIONS(1155), 2,
      anon_sym_DASH,
      sym__immediate_string_base_other,
    ACTIONS(5), 4,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    STATE(113), 4,
      sym__immediate_double_quoted_string,
      sym__immediate_single_quoted_string,
      sym__immediate_unquoted_string,
      aux_sym_string_repeat1,
    STATE(186), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(469), 6,
      anon_sym_DASH_DASHmount,
      sym_no_cache,
      sym_privileged,
      anon_sym_DASH_DASHsecret,
      sym_ssh,
      sym_comment,
    ACTIONS(1152), 15,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(464), 20,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
  [5126] = 13,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(1113), 1,
      anon_sym_SQUOTE,
    ACTIONS(1115), 1,
      anon_sym_DQUOTE2,
    ACTIONS(1117), 1,
      anon_sym_DOLLAR2,
    ACTIONS(1170), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(395), 1,
      sym__immediate_escape_sequence,
    ACTIONS(1111), 2,
      anon_sym_DASH,
      sym__immediate_string_base_other,
    STATE(108), 4,
      sym__immediate_double_quoted_string,
      sym__immediate_single_quoted_string,
      sym__immediate_unquoted_string,
      aux_sym_string_repeat1,
    STATE(187), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(581), 5,
      anon_sym_DASH_DASHchmod,
      anon_sym_DASH_DASHid,
      sym_persist,
      anon_sym_DASH_DASHsharing,
      anon_sym_SQUOTE2,
    ACTIONS(1109), 15,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(579), 20,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
  [5214] = 5,
    ACTIONS(3), 1,
      sym_line_continuation,
    STATE(109), 1,
      aux_sym_variable_repeat1,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(830), 25,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_LPAREN2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
    ACTIONS(828), 29,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_LPAREN3,
      sym_allow_privileged,
      anon_sym_DASH_DASHbuild_DASHarg,
      anon_sym_DASH_DASHchmod,
      anon_sym_DASH_DASHchown,
      sym_dir,
      sym_if_exists,
      sym_keep_own,
      sym_keep_ts,
      sym_pass_args,
      anon_sym_DASH_DASHplatform,
      sym_symlink_no_follow,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
  [5286] = 4,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(944), 25,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_LPAREN2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
    ACTIONS(942), 29,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_LPAREN3,
      sym_allow_privileged,
      anon_sym_DASH_DASHbuild_DASHarg,
      anon_sym_DASH_DASHchmod,
      anon_sym_DASH_DASHchown,
      sym_dir,
      sym_if_exists,
      sym_keep_own,
      sym_keep_ts,
      sym_pass_args,
      anon_sym_DASH_DASHplatform,
      sym_symlink_no_follow,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
  [5355] = 4,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(855), 25,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_LPAREN2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
    ACTIONS(853), 29,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_LPAREN3,
      sym_allow_privileged,
      anon_sym_DASH_DASHbuild_DASHarg,
      anon_sym_DASH_DASHchmod,
      anon_sym_DASH_DASHchown,
      sym_dir,
      sym_if_exists,
      sym_keep_own,
      sym_keep_ts,
      sym_pass_args,
      anon_sym_DASH_DASHplatform,
      sym_symlink_no_follow,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
  [5424] = 4,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(922), 25,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_LPAREN2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
    ACTIONS(920), 29,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_LPAREN3,
      sym_allow_privileged,
      anon_sym_DASH_DASHbuild_DASHarg,
      anon_sym_DASH_DASHchmod,
      anon_sym_DASH_DASHchown,
      sym_dir,
      sym_if_exists,
      sym_keep_own,
      sym_keep_ts,
      sym_pass_args,
      anon_sym_DASH_DASHplatform,
      sym_symlink_no_follow,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
  [5493] = 4,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(859), 25,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_LPAREN2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
    ACTIONS(857), 29,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_LPAREN3,
      sym_allow_privileged,
      anon_sym_DASH_DASHbuild_DASHarg,
      anon_sym_DASH_DASHchmod,
      anon_sym_DASH_DASHchown,
      sym_dir,
      sym_if_exists,
      sym_keep_own,
      sym_keep_ts,
      sym_pass_args,
      anon_sym_DASH_DASHplatform,
      sym_symlink_no_follow,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
  [5562] = 4,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(851), 25,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_LPAREN2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
    ACTIONS(849), 29,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_LPAREN3,
      sym_allow_privileged,
      anon_sym_DASH_DASHbuild_DASHarg,
      anon_sym_DASH_DASHchmod,
      anon_sym_DASH_DASHchown,
      sym_dir,
      sym_if_exists,
      sym_keep_own,
      sym_keep_ts,
      sym_pass_args,
      anon_sym_DASH_DASHplatform,
      sym_symlink_no_follow,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
  [5631] = 4,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(918), 25,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_LPAREN2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
    ACTIONS(916), 29,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_LPAREN3,
      sym_allow_privileged,
      anon_sym_DASH_DASHbuild_DASHarg,
      anon_sym_DASH_DASHchmod,
      anon_sym_DASH_DASHchown,
      sym_dir,
      sym_if_exists,
      sym_keep_own,
      sym_keep_ts,
      sym_pass_args,
      anon_sym_DASH_DASHplatform,
      sym_symlink_no_follow,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
  [5700] = 4,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(914), 25,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_LPAREN2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
    ACTIONS(912), 29,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_LPAREN3,
      sym_allow_privileged,
      anon_sym_DASH_DASHbuild_DASHarg,
      anon_sym_DASH_DASHchmod,
      anon_sym_DASH_DASHchown,
      sym_dir,
      sym_if_exists,
      sym_keep_own,
      sym_keep_ts,
      sym_pass_args,
      anon_sym_DASH_DASHplatform,
      sym_symlink_no_follow,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
  [5769] = 4,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(933), 25,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_LPAREN2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
    ACTIONS(931), 29,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_LPAREN3,
      sym_allow_privileged,
      anon_sym_DASH_DASHbuild_DASHarg,
      anon_sym_DASH_DASHchmod,
      anon_sym_DASH_DASHchown,
      sym_dir,
      sym_if_exists,
      sym_keep_own,
      sym_keep_ts,
      sym_pass_args,
      anon_sym_DASH_DASHplatform,
      sym_symlink_no_follow,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
  [5838] = 13,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(1177), 1,
      anon_sym_SQUOTE,
    ACTIONS(1179), 1,
      anon_sym_DQUOTE2,
    ACTIONS(1181), 1,
      anon_sym_DOLLAR2,
    ACTIONS(1183), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(418), 1,
      sym__immediate_escape_sequence,
    ACTIONS(1175), 2,
      anon_sym_DASH,
      sym__immediate_string_base_other,
    ACTIONS(581), 4,
      sym_allow_privileged,
      sym_pass_args,
      anon_sym_DASH_DASHplatform,
      anon_sym_SQUOTE2,
    STATE(128), 4,
      sym__immediate_double_quoted_string,
      sym__immediate_single_quoted_string,
      sym__immediate_unquoted_string,
      aux_sym_string_repeat1,
    STATE(198), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(1173), 15,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(579), 20,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
  [5925] = 14,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(1195), 1,
      anon_sym_PLUS,
    ACTIONS(1198), 1,
      anon_sym_DOLLAR2,
    ACTIONS(1201), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(229), 1,
      sym__immediate_escape_sequence,
    STATE(1608), 1,
      aux_sym_earthfile_ref_repeat1,
    ACTIONS(1189), 2,
      anon_sym_EQ3,
      anon_sym_PLUS2,
    STATE(142), 2,
      sym__immediate_expansion,
      aux_sym_unquoted_string_repeat1,
    STATE(227), 2,
      sym__immediate_string_base,
      aux_sym__immediate_string_base_repeat1,
    ACTIONS(1192), 3,
      anon_sym_DASH,
      anon_sym_LPAREN2,
      sym__immediate_string_base_other,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(685), 8,
      anon_sym_LPAREN3,
      sym_allow_privileged,
      anon_sym_DASH_DASHbuild_DASHarg,
      anon_sym_DASHf,
      anon_sym_DASH_DASHtarget,
      anon_sym_DASH_DASHplatform,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
    ACTIONS(1186), 12,
      anon_sym_SLASH,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
    ACTIONS(680), 20,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
  [6014] = 4,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(863), 25,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_LPAREN2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
    ACTIONS(861), 29,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_LPAREN3,
      sym_allow_privileged,
      anon_sym_DASH_DASHbuild_DASHarg,
      anon_sym_DASH_DASHchmod,
      anon_sym_DASH_DASHchown,
      sym_dir,
      sym_if_exists,
      sym_keep_own,
      sym_keep_ts,
      sym_pass_args,
      anon_sym_DASH_DASHplatform,
      sym_symlink_no_follow,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
  [6083] = 4,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(937), 25,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_LPAREN2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
    ACTIONS(935), 29,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_LPAREN3,
      sym_allow_privileged,
      anon_sym_DASH_DASHbuild_DASHarg,
      anon_sym_DASH_DASHchmod,
      anon_sym_DASH_DASHchown,
      sym_dir,
      sym_if_exists,
      sym_keep_own,
      sym_keep_ts,
      sym_pass_args,
      anon_sym_DASH_DASHplatform,
      sym_symlink_no_follow,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
  [6152] = 13,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(1177), 1,
      anon_sym_SQUOTE,
    ACTIONS(1179), 1,
      anon_sym_DQUOTE2,
    ACTIONS(1181), 1,
      anon_sym_DOLLAR2,
    ACTIONS(1204), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(418), 1,
      sym__immediate_escape_sequence,
    ACTIONS(1175), 2,
      anon_sym_DASH,
      sym__immediate_string_base_other,
    ACTIONS(449), 4,
      sym_allow_privileged,
      sym_pass_args,
      anon_sym_DASH_DASHplatform,
      anon_sym_SQUOTE2,
    STATE(131), 4,
      sym__immediate_double_quoted_string,
      sym__immediate_single_quoted_string,
      sym__immediate_unquoted_string,
      aux_sym_string_repeat1,
    STATE(198), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(1173), 15,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(445), 20,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
  [6239] = 4,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(871), 25,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_LPAREN2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
    ACTIONS(869), 29,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_LPAREN3,
      sym_allow_privileged,
      anon_sym_DASH_DASHbuild_DASHarg,
      anon_sym_DASH_DASHchmod,
      anon_sym_DASH_DASHchown,
      sym_dir,
      sym_if_exists,
      sym_keep_own,
      sym_keep_ts,
      sym_pass_args,
      anon_sym_DASH_DASHplatform,
      sym_symlink_no_follow,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
  [6308] = 4,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(867), 25,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_LPAREN2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
    ACTIONS(865), 29,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_LPAREN3,
      sym_allow_privileged,
      anon_sym_DASH_DASHbuild_DASHarg,
      anon_sym_DASH_DASHchmod,
      anon_sym_DASH_DASHchown,
      sym_dir,
      sym_if_exists,
      sym_keep_own,
      sym_keep_ts,
      sym_pass_args,
      anon_sym_DASH_DASHplatform,
      sym_symlink_no_follow,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
  [6377] = 13,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(1213), 1,
      anon_sym_SQUOTE,
    ACTIONS(1216), 1,
      anon_sym_DQUOTE2,
    ACTIONS(1219), 1,
      anon_sym_DOLLAR2,
    ACTIONS(1222), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(418), 1,
      sym__immediate_escape_sequence,
    ACTIONS(1210), 2,
      anon_sym_DASH,
      sym__immediate_string_base_other,
    ACTIONS(469), 4,
      sym_allow_privileged,
      sym_pass_args,
      anon_sym_DASH_DASHplatform,
      anon_sym_SQUOTE2,
    STATE(131), 4,
      sym__immediate_double_quoted_string,
      sym__immediate_single_quoted_string,
      sym__immediate_unquoted_string,
      aux_sym_string_repeat1,
    STATE(198), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(1207), 15,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(464), 20,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
  [6464] = 4,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(900), 25,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_LPAREN2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
    ACTIONS(898), 29,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_LPAREN3,
      sym_allow_privileged,
      anon_sym_DASH_DASHbuild_DASHarg,
      anon_sym_DASH_DASHchmod,
      anon_sym_DASH_DASHchown,
      sym_dir,
      sym_if_exists,
      sym_keep_own,
      sym_keep_ts,
      sym_pass_args,
      anon_sym_DASH_DASHplatform,
      sym_symlink_no_follow,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
  [6533] = 12,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(1198), 1,
      anon_sym_DOLLAR2,
    ACTIONS(1201), 1,
      aux_sym__immediate_escape_sequence_token1,
    ACTIONS(1228), 1,
      sym__immediate_string_base_alpha,
    STATE(251), 1,
      sym__immediate_escape_sequence,
    STATE(2121), 1,
      sym__immediate_identifier,
    ACTIONS(1225), 3,
      anon_sym_DASH,
      anon_sym_LPAREN2,
      sym__immediate_string_base_other,
    STATE(142), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(685), 8,
      anon_sym_LPAREN3,
      sym_allow_privileged,
      anon_sym_DASH_DASHbuild_DASHarg,
      anon_sym_DASHf,
      anon_sym_DASH_DASHtarget,
      anon_sym_DASH_DASHplatform,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
    ACTIONS(1189), 13,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(680), 21,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
  [6618] = 4,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(904), 25,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_LPAREN2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
    ACTIONS(902), 29,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_LPAREN3,
      sym_allow_privileged,
      anon_sym_DASH_DASHbuild_DASHarg,
      anon_sym_DASH_DASHchmod,
      anon_sym_DASH_DASHchown,
      sym_dir,
      sym_if_exists,
      sym_keep_own,
      sym_keep_ts,
      sym_pass_args,
      anon_sym_DASH_DASHplatform,
      sym_symlink_no_follow,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
  [6687] = 4,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(834), 25,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_LPAREN2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
    ACTIONS(832), 29,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_LPAREN3,
      sym_allow_privileged,
      anon_sym_DASH_DASHbuild_DASHarg,
      anon_sym_DASH_DASHchmod,
      anon_sym_DASH_DASHchown,
      sym_dir,
      sym_if_exists,
      sym_keep_own,
      sym_keep_ts,
      sym_pass_args,
      anon_sym_DASH_DASHplatform,
      sym_symlink_no_follow,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
  [6756] = 4,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(875), 25,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_LPAREN2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
    ACTIONS(873), 29,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_LPAREN3,
      sym_allow_privileged,
      anon_sym_DASH_DASHbuild_DASHarg,
      anon_sym_DASH_DASHchmod,
      anon_sym_DASH_DASHchown,
      sym_dir,
      sym_if_exists,
      sym_keep_own,
      sym_keep_ts,
      sym_pass_args,
      anon_sym_DASH_DASHplatform,
      sym_symlink_no_follow,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
  [6825] = 28,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(1233), 1,
      anon_sym_EQ,
    ACTIONS(1237), 1,
      anon_sym_DOLLAR,
    ACTIONS(1239), 1,
      anon_sym_PLUS,
    ACTIONS(1241), 1,
      anon_sym_DQUOTE,
    ACTIONS(1243), 1,
      anon_sym_LPAREN3,
    ACTIONS(1247), 1,
      anon_sym_DASH_DASHbuild_DASHarg,
    ACTIONS(1249), 1,
      anon_sym_DASH_DASHchmod,
    ACTIONS(1251), 1,
      anon_sym_DASH_DASHchown,
    ACTIONS(1253), 1,
      anon_sym_DASH_DASHplatform,
    ACTIONS(1255), 1,
      aux_sym_unknown_option_token1,
    ACTIONS(1257), 1,
      sym__string_base_other,
    ACTIONS(1261), 1,
      anon_sym_SQUOTE2,
    ACTIONS(1263), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(231), 1,
      sym__string_base,
    STATE(898), 1,
      sym_copy_options,
    STATE(899), 1,
      aux_sym_copy_command_repeat1,
    STATE(2542), 1,
      sym_earthfile_ref,
    STATE(2650), 1,
      sym_target_ref,
    ACTIONS(1235), 2,
      anon_sym_LPAREN,
      anon_sym_DASH2,
    ACTIONS(1259), 2,
      sym__string_base_alpha,
      sym__string_base_num,
    STATE(284), 2,
      sym_expansion,
      sym_escape_sequence,
    STATE(178), 3,
      sym_double_quoted_string,
      sym_single_quoted_string,
      sym_unquoted_string,
    STATE(1593), 3,
      sym_target_artifact,
      sym_target_artifact_build_args,
      sym_string,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    STATE(634), 6,
      sym_build_arg_deprecated,
      sym_chmod,
      sym_chown,
      sym_platform,
      sym_unknown_option,
      aux_sym_copy_options_repeat1,
    ACTIONS(1245), 7,
      sym_allow_privileged,
      sym_dir,
      sym_if_exists,
      sym_keep_own,
      sym_keep_ts,
      sym_pass_args,
      sym_symlink_no_follow,
    ACTIONS(1231), 10,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
  [6941] = 13,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(1269), 1,
      anon_sym_SQUOTE,
    ACTIONS(1271), 1,
      anon_sym_DQUOTE2,
    ACTIONS(1273), 1,
      anon_sym_DOLLAR2,
    ACTIONS(1275), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(441), 1,
      sym__immediate_escape_sequence,
    ACTIONS(1267), 2,
      anon_sym_DASH,
      sym__immediate_string_base_other,
    ACTIONS(449), 3,
      sym_allow_privileged,
      sym_pass_args,
      anon_sym_SQUOTE2,
    STATE(145), 4,
      sym__immediate_double_quoted_string,
      sym__immediate_single_quoted_string,
      sym__immediate_unquoted_string,
      aux_sym_string_repeat1,
    STATE(206), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(1265), 15,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(445), 20,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
  [7027] = 13,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(1282), 1,
      anon_sym_SQUOTE,
    ACTIONS(1284), 1,
      anon_sym_DQUOTE2,
    ACTIONS(1286), 1,
      anon_sym_DOLLAR2,
    ACTIONS(1288), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(461), 1,
      sym__immediate_escape_sequence,
    ACTIONS(1280), 2,
      anon_sym_DASH,
      sym__immediate_string_base_other,
    ACTIONS(449), 3,
      anon_sym_DASH_DASHbranch,
      sym_keep_ts,
      anon_sym_SQUOTE2,
    STATE(140), 4,
      sym__immediate_double_quoted_string,
      sym__immediate_single_quoted_string,
      sym__immediate_unquoted_string,
      aux_sym_string_repeat1,
    STATE(208), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(1278), 15,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(445), 20,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
  [7113] = 13,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(1297), 1,
      anon_sym_SQUOTE,
    ACTIONS(1300), 1,
      anon_sym_DQUOTE2,
    ACTIONS(1303), 1,
      anon_sym_DOLLAR2,
    ACTIONS(1306), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(461), 1,
      sym__immediate_escape_sequence,
    ACTIONS(1294), 2,
      anon_sym_DASH,
      sym__immediate_string_base_other,
    ACTIONS(469), 3,
      anon_sym_DASH_DASHbranch,
      sym_keep_ts,
      anon_sym_SQUOTE2,
    STATE(140), 4,
      sym__immediate_double_quoted_string,
      sym__immediate_single_quoted_string,
      sym__immediate_unquoted_string,
      aux_sym_string_repeat1,
    STATE(208), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(1291), 15,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(464), 20,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
  [7199] = 28,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(1233), 1,
      anon_sym_EQ,
    ACTIONS(1237), 1,
      anon_sym_DOLLAR,
    ACTIONS(1239), 1,
      anon_sym_PLUS,
    ACTIONS(1241), 1,
      anon_sym_DQUOTE,
    ACTIONS(1243), 1,
      anon_sym_LPAREN3,
    ACTIONS(1247), 1,
      anon_sym_DASH_DASHbuild_DASHarg,
    ACTIONS(1249), 1,
      anon_sym_DASH_DASHchmod,
    ACTIONS(1251), 1,
      anon_sym_DASH_DASHchown,
    ACTIONS(1253), 1,
      anon_sym_DASH_DASHplatform,
    ACTIONS(1255), 1,
      aux_sym_unknown_option_token1,
    ACTIONS(1257), 1,
      sym__string_base_other,
    ACTIONS(1261), 1,
      anon_sym_SQUOTE2,
    ACTIONS(1263), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(231), 1,
      sym__string_base,
    STATE(932), 1,
      aux_sym_copy_command_repeat1,
    STATE(953), 1,
      sym_copy_options,
    STATE(2542), 1,
      sym_earthfile_ref,
    STATE(2650), 1,
      sym_target_ref,
    ACTIONS(1235), 2,
      anon_sym_LPAREN,
      anon_sym_DASH2,
    ACTIONS(1259), 2,
      sym__string_base_alpha,
      sym__string_base_num,
    STATE(284), 2,
      sym_expansion,
      sym_escape_sequence,
    STATE(178), 3,
      sym_double_quoted_string,
      sym_single_quoted_string,
      sym_unquoted_string,
    STATE(1593), 3,
      sym_target_artifact,
      sym_target_artifact_build_args,
      sym_string,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    STATE(634), 6,
      sym_build_arg_deprecated,
      sym_chmod,
      sym_chown,
      sym_platform,
      sym_unknown_option,
      aux_sym_copy_options_repeat1,
    ACTIONS(1245), 7,
      sym_allow_privileged,
      sym_dir,
      sym_if_exists,
      sym_keep_own,
      sym_keep_ts,
      sym_pass_args,
      sym_symlink_no_follow,
    ACTIONS(1231), 10,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
  [7315] = 10,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(1315), 1,
      anon_sym_DOLLAR2,
    ACTIONS(1318), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(251), 1,
      sym__immediate_escape_sequence,
    ACTIONS(1312), 3,
      anon_sym_DASH,
      anon_sym_LPAREN2,
      sym__immediate_string_base_other,
    STATE(143), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(669), 8,
      anon_sym_LPAREN3,
      sym_allow_privileged,
      anon_sym_DASH_DASHbuild_DASHarg,
      anon_sym_DASHf,
      anon_sym_DASH_DASHtarget,
      anon_sym_DASH_DASHplatform,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
    ACTIONS(1309), 14,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(664), 21,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
  [7395] = 10,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(1327), 1,
      anon_sym_DOLLAR2,
    ACTIONS(1330), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(251), 1,
      sym__immediate_escape_sequence,
    ACTIONS(1324), 3,
      anon_sym_DASH,
      anon_sym_LPAREN2,
      sym__immediate_string_base_other,
    STATE(143), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(705), 8,
      anon_sym_LPAREN3,
      sym_allow_privileged,
      anon_sym_DASH_DASHbuild_DASHarg,
      anon_sym_DASHf,
      anon_sym_DASH_DASHtarget,
      anon_sym_DASH_DASHplatform,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
    ACTIONS(1321), 14,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(700), 21,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
  [7475] = 13,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(1269), 1,
      anon_sym_SQUOTE,
    ACTIONS(1271), 1,
      anon_sym_DQUOTE2,
    ACTIONS(1273), 1,
      anon_sym_DOLLAR2,
    ACTIONS(1333), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(441), 1,
      sym__immediate_escape_sequence,
    ACTIONS(1267), 2,
      anon_sym_DASH,
      sym__immediate_string_base_other,
    ACTIONS(581), 3,
      sym_allow_privileged,
      sym_pass_args,
      anon_sym_SQUOTE2,
    STATE(138), 4,
      sym__immediate_double_quoted_string,
      sym__immediate_single_quoted_string,
      sym__immediate_unquoted_string,
      aux_sym_string_repeat1,
    STATE(206), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(1265), 15,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(579), 20,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
  [7561] = 13,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(1342), 1,
      anon_sym_SQUOTE,
    ACTIONS(1345), 1,
      anon_sym_DQUOTE2,
    ACTIONS(1348), 1,
      anon_sym_DOLLAR2,
    ACTIONS(1351), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(441), 1,
      sym__immediate_escape_sequence,
    ACTIONS(1339), 2,
      anon_sym_DASH,
      sym__immediate_string_base_other,
    ACTIONS(469), 3,
      sym_allow_privileged,
      sym_pass_args,
      anon_sym_SQUOTE2,
    STATE(145), 4,
      sym__immediate_double_quoted_string,
      sym__immediate_single_quoted_string,
      sym__immediate_unquoted_string,
      aux_sym_string_repeat1,
    STATE(206), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(1336), 15,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(464), 20,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
  [7647] = 13,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(1282), 1,
      anon_sym_SQUOTE,
    ACTIONS(1284), 1,
      anon_sym_DQUOTE2,
    ACTIONS(1286), 1,
      anon_sym_DOLLAR2,
    ACTIONS(1354), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(461), 1,
      sym__immediate_escape_sequence,
    ACTIONS(1280), 2,
      anon_sym_DASH,
      sym__immediate_string_base_other,
    ACTIONS(581), 3,
      anon_sym_DASH_DASHbranch,
      sym_keep_ts,
      anon_sym_SQUOTE2,
    STATE(139), 4,
      sym__immediate_double_quoted_string,
      sym__immediate_single_quoted_string,
      sym__immediate_unquoted_string,
      aux_sym_string_repeat1,
    STATE(208), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(1278), 15,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(579), 20,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
  [7733] = 6,
    ACTIONS(3), 1,
      sym_line_continuation,
    STATE(251), 1,
      sym__immediate_escape_sequence,
    STATE(143), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(693), 23,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_LPAREN3,
      sym_allow_privileged,
      anon_sym_DASH_DASHbuild_DASHarg,
      anon_sym_DASHf,
      anon_sym_DASH_DASHtarget,
      anon_sym_DASH_DASHplatform,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
    ACTIONS(695), 25,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_LPAREN2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
  [7805] = 10,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(1198), 1,
      anon_sym_DOLLAR2,
    ACTIONS(1201), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(251), 1,
      sym__immediate_escape_sequence,
    ACTIONS(1225), 3,
      anon_sym_DASH,
      anon_sym_LPAREN2,
      sym__immediate_string_base_other,
    STATE(142), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(685), 8,
      anon_sym_LPAREN3,
      sym_allow_privileged,
      anon_sym_DASH_DASHbuild_DASHarg,
      anon_sym_DASHf,
      anon_sym_DASH_DASHtarget,
      anon_sym_DASH_DASHplatform,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
    ACTIONS(1189), 14,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(680), 21,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
  [7885] = 28,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(1233), 1,
      anon_sym_EQ,
    ACTIONS(1237), 1,
      anon_sym_DOLLAR,
    ACTIONS(1239), 1,
      anon_sym_PLUS,
    ACTIONS(1241), 1,
      anon_sym_DQUOTE,
    ACTIONS(1243), 1,
      anon_sym_LPAREN3,
    ACTIONS(1247), 1,
      anon_sym_DASH_DASHbuild_DASHarg,
    ACTIONS(1249), 1,
      anon_sym_DASH_DASHchmod,
    ACTIONS(1251), 1,
      anon_sym_DASH_DASHchown,
    ACTIONS(1253), 1,
      anon_sym_DASH_DASHplatform,
    ACTIONS(1255), 1,
      aux_sym_unknown_option_token1,
    ACTIONS(1257), 1,
      sym__string_base_other,
    ACTIONS(1261), 1,
      anon_sym_SQUOTE2,
    ACTIONS(1263), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(231), 1,
      sym__string_base,
    STATE(867), 1,
      aux_sym_copy_command_repeat1,
    STATE(966), 1,
      sym_copy_options,
    STATE(2542), 1,
      sym_earthfile_ref,
    STATE(2650), 1,
      sym_target_ref,
    ACTIONS(1235), 2,
      anon_sym_LPAREN,
      anon_sym_DASH2,
    ACTIONS(1259), 2,
      sym__string_base_alpha,
      sym__string_base_num,
    STATE(284), 2,
      sym_expansion,
      sym_escape_sequence,
    STATE(178), 3,
      sym_double_quoted_string,
      sym_single_quoted_string,
      sym_unquoted_string,
    STATE(1593), 3,
      sym_target_artifact,
      sym_target_artifact_build_args,
      sym_string,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    STATE(634), 6,
      sym_build_arg_deprecated,
      sym_chmod,
      sym_chown,
      sym_platform,
      sym_unknown_option,
      aux_sym_copy_options_repeat1,
    ACTIONS(1245), 7,
      sym_allow_privileged,
      sym_dir,
      sym_if_exists,
      sym_keep_own,
      sym_keep_ts,
      sym_pass_args,
      sym_symlink_no_follow,
    ACTIONS(1231), 10,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
  [8001] = 10,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(1363), 1,
      anon_sym_DOLLAR2,
    ACTIONS(1366), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(354), 1,
      sym__immediate_escape_sequence,
    ACTIONS(1360), 3,
      anon_sym_EQ3,
      anon_sym_DASH,
      sym__immediate_string_base_other,
    ACTIONS(5), 4,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    STATE(169), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(669), 9,
      anon_sym_SQUOTE,
      anon_sym_DASH_DASHmount,
      sym_no_cache,
      sym_privileged,
      anon_sym_DASH_DASHsecret,
      anon_sym_EQ4,
      sym_ssh,
      anon_sym_DQUOTE2,
      sym_comment,
    ACTIONS(1357), 14,
      anon_sym_SLASH,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(664), 20,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
  [8080] = 10,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(1375), 1,
      anon_sym_DOLLAR2,
    ACTIONS(1378), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(282), 1,
      sym__immediate_escape_sequence,
    ACTIONS(1372), 2,
      anon_sym_DASH,
      sym__immediate_string_base_other,
    STATE(156), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(685), 7,
      sym_force,
      sym_if_exists,
      sym_keep_own,
      sym_keep_ts,
      sym_symlink_no_follow,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
    ACTIONS(1369), 15,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(680), 21,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
  [8159] = 6,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 1,
      sym_line_continuation_comment,
    STATE(309), 1,
      sym__immediate_escape_sequence,
    STATE(172), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(695), 25,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
      anon_sym_NULL,
    ACTIONS(693), 26,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_DASH_DASHcache_DASHfrom,
      sym_cache_hint,
      sym_push,
      sym_without_earthly_labels,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
      sym_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
  [8230] = 10,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(1387), 1,
      anon_sym_DOLLAR2,
    ACTIONS(1390), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(282), 1,
      sym__immediate_escape_sequence,
    ACTIONS(1384), 2,
      anon_sym_DASH,
      sym__immediate_string_base_other,
    STATE(153), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(705), 7,
      sym_force,
      sym_if_exists,
      sym_keep_own,
      sym_keep_ts,
      sym_symlink_no_follow,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
    ACTIONS(1381), 15,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(700), 21,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
  [8309] = 6,
    ACTIONS(3), 1,
      sym_line_continuation,
    STATE(304), 1,
      sym__immediate_escape_sequence,
    STATE(161), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(693), 23,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym_allow_privileged,
      sym_auto_skip,
      anon_sym_DASH_DASHbuild_DASHarg,
      sym_pass_args,
      anon_sym_DASH_DASHplatform,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
    ACTIONS(695), 24,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
  [8380] = 13,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 1,
      sym_line_continuation_comment,
    ACTIONS(1395), 1,
      anon_sym_SQUOTE,
    ACTIONS(1399), 1,
      anon_sym_DQUOTE2,
    ACTIONS(1401), 1,
      anon_sym_DOLLAR2,
    ACTIONS(1403), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(510), 1,
      sym__immediate_escape_sequence,
    ACTIONS(1397), 2,
      sym__immediate_string_base_other,
      sym__immediate_string_base_alpha,
    STATE(159), 4,
      sym__immediate_double_quoted_string,
      sym__immediate_single_quoted_string,
      sym__immediate_unquoted_string,
      aux_sym_string_repeat1,
    STATE(250), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(449), 6,
      anon_sym_ASLOCAL,
      anon_sym_SQUOTE2,
      sym_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(1393), 15,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(445), 20,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      anon_sym_NULL,
  [8465] = 10,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(1412), 1,
      anon_sym_DOLLAR2,
    ACTIONS(1415), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(282), 1,
      sym__immediate_escape_sequence,
    ACTIONS(1409), 2,
      anon_sym_DASH,
      sym__immediate_string_base_other,
    STATE(153), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(669), 7,
      sym_force,
      sym_if_exists,
      sym_keep_own,
      sym_keep_ts,
      sym_symlink_no_follow,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
    ACTIONS(1406), 15,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(664), 21,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
  [8544] = 13,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(1422), 1,
      anon_sym_SQUOTE,
    ACTIONS(1424), 1,
      anon_sym_DQUOTE2,
    ACTIONS(1426), 1,
      anon_sym_DOLLAR2,
    ACTIONS(1428), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(536), 1,
      sym__immediate_escape_sequence,
    ACTIONS(449), 2,
      sym_allow_privileged,
      anon_sym_SQUOTE2,
    ACTIONS(1420), 2,
      anon_sym_DASH,
      sym__immediate_string_base_other,
    STATE(173), 4,
      sym__immediate_double_quoted_string,
      sym__immediate_single_quoted_string,
      sym__immediate_unquoted_string,
      aux_sym_string_repeat1,
    STATE(226), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(1418), 15,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(445), 20,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
  [8629] = 10,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 1,
      sym_line_continuation_comment,
    ACTIONS(1437), 1,
      anon_sym_DOLLAR2,
    ACTIONS(1440), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(309), 1,
      sym__immediate_escape_sequence,
    ACTIONS(1434), 2,
      anon_sym_DASH,
      sym__immediate_string_base_other,
    STATE(172), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(669), 10,
      anon_sym_DASH_DASHcache_DASHfrom,
      sym_cache_hint,
      sym_push,
      sym_without_earthly_labels,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
      sym_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(1431), 15,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(664), 22,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      anon_sym_NULL,
  [8708] = 13,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 1,
      sym_line_continuation_comment,
    ACTIONS(1446), 1,
      anon_sym_SQUOTE,
    ACTIONS(1452), 1,
      anon_sym_DQUOTE2,
    ACTIONS(1455), 1,
      anon_sym_DOLLAR2,
    ACTIONS(1458), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(510), 1,
      sym__immediate_escape_sequence,
    ACTIONS(1449), 2,
      sym__immediate_string_base_other,
      sym__immediate_string_base_alpha,
    STATE(159), 4,
      sym__immediate_double_quoted_string,
      sym__immediate_single_quoted_string,
      sym__immediate_unquoted_string,
      aux_sym_string_repeat1,
    STATE(250), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(469), 6,
      anon_sym_ASLOCAL,
      anon_sym_SQUOTE2,
      sym_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(1443), 15,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(464), 20,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      anon_sym_NULL,
  [8793] = 13,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 1,
      sym_line_continuation_comment,
    ACTIONS(1465), 1,
      anon_sym_SQUOTE,
    ACTIONS(1467), 1,
      anon_sym_DQUOTE2,
    ACTIONS(1469), 1,
      anon_sym_DOLLAR2,
    ACTIONS(1471), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(501), 1,
      sym__immediate_escape_sequence,
    ACTIONS(1463), 2,
      anon_sym_LPAREN2,
      sym__immediate_string_base_other,
    STATE(171), 4,
      sym__immediate_double_quoted_string,
      sym__immediate_single_quoted_string,
      sym__immediate_unquoted_string,
      aux_sym_string_repeat1,
    STATE(260), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(449), 6,
      anon_sym_LPAREN3,
      anon_sym_SQUOTE2,
      sym_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(1461), 15,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(445), 20,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      anon_sym_NULL,
  [8878] = 10,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(1480), 1,
      anon_sym_DOLLAR2,
    ACTIONS(1483), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(304), 1,
      sym__immediate_escape_sequence,
    ACTIONS(1477), 2,
      anon_sym_DASH,
      sym__immediate_string_base_other,
    STATE(161), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(705), 7,
      sym_allow_privileged,
      sym_auto_skip,
      anon_sym_DASH_DASHbuild_DASHarg,
      sym_pass_args,
      anon_sym_DASH_DASHplatform,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
    ACTIONS(1474), 15,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(700), 21,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
  [8957] = 13,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(1422), 1,
      anon_sym_SQUOTE,
    ACTIONS(1424), 1,
      anon_sym_DQUOTE2,
    ACTIONS(1426), 1,
      anon_sym_DOLLAR2,
    ACTIONS(1486), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(536), 1,
      sym__immediate_escape_sequence,
    ACTIONS(581), 2,
      sym_allow_privileged,
      anon_sym_SQUOTE2,
    ACTIONS(1420), 2,
      anon_sym_DASH,
      sym__immediate_string_base_other,
    STATE(157), 4,
      sym__immediate_double_quoted_string,
      sym__immediate_single_quoted_string,
      sym__immediate_unquoted_string,
      aux_sym_string_repeat1,
    STATE(226), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(1418), 15,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(579), 20,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
  [9042] = 6,
    ACTIONS(3), 1,
      sym_line_continuation,
    STATE(282), 1,
      sym__immediate_escape_sequence,
    STATE(153), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(693), 23,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym_force,
      sym_if_exists,
      sym_keep_own,
      sym_keep_ts,
      sym_symlink_no_follow,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
    ACTIONS(695), 24,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
  [9113] = 10,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(1495), 1,
      anon_sym_DOLLAR2,
    ACTIONS(1498), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(304), 1,
      sym__immediate_escape_sequence,
    ACTIONS(1492), 2,
      anon_sym_DASH,
      sym__immediate_string_base_other,
    STATE(168), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(685), 7,
      sym_allow_privileged,
      sym_auto_skip,
      anon_sym_DASH_DASHbuild_DASHarg,
      sym_pass_args,
      anon_sym_DASH_DASHplatform,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
    ACTIONS(1489), 15,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(680), 21,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
  [9192] = 13,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 1,
      sym_line_continuation_comment,
    ACTIONS(1465), 1,
      anon_sym_SQUOTE,
    ACTIONS(1467), 1,
      anon_sym_DQUOTE2,
    ACTIONS(1469), 1,
      anon_sym_DOLLAR2,
    ACTIONS(1501), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(501), 1,
      sym__immediate_escape_sequence,
    ACTIONS(1463), 2,
      anon_sym_LPAREN2,
      sym__immediate_string_base_other,
    STATE(160), 4,
      sym__immediate_double_quoted_string,
      sym__immediate_single_quoted_string,
      sym__immediate_unquoted_string,
      aux_sym_string_repeat1,
    STATE(260), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(581), 6,
      anon_sym_LPAREN3,
      anon_sym_SQUOTE2,
      sym_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(1461), 15,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(579), 20,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      anon_sym_NULL,
  [9277] = 10,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 1,
      sym_line_continuation_comment,
    ACTIONS(1510), 1,
      anon_sym_DOLLAR2,
    ACTIONS(1513), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(309), 1,
      sym__immediate_escape_sequence,
    ACTIONS(1507), 2,
      anon_sym_DASH,
      sym__immediate_string_base_other,
    STATE(158), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(685), 10,
      anon_sym_DASH_DASHcache_DASHfrom,
      sym_cache_hint,
      sym_push,
      sym_without_earthly_labels,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
      sym_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(1504), 15,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(680), 22,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      anon_sym_NULL,
  [9356] = 13,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 1,
      sym_line_continuation_comment,
    ACTIONS(1395), 1,
      anon_sym_SQUOTE,
    ACTIONS(1399), 1,
      anon_sym_DQUOTE2,
    ACTIONS(1401), 1,
      anon_sym_DOLLAR2,
    ACTIONS(1516), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(510), 1,
      sym__immediate_escape_sequence,
    ACTIONS(1397), 2,
      sym__immediate_string_base_other,
      sym__immediate_string_base_alpha,
    STATE(155), 4,
      sym__immediate_double_quoted_string,
      sym__immediate_single_quoted_string,
      sym__immediate_unquoted_string,
      aux_sym_string_repeat1,
    STATE(250), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(581), 6,
      anon_sym_ASLOCAL,
      anon_sym_SQUOTE2,
      sym_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(1393), 15,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(579), 20,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      anon_sym_NULL,
  [9441] = 10,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(1525), 1,
      anon_sym_DOLLAR2,
    ACTIONS(1528), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(304), 1,
      sym__immediate_escape_sequence,
    ACTIONS(1522), 2,
      anon_sym_DASH,
      sym__immediate_string_base_other,
    STATE(161), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(669), 7,
      sym_allow_privileged,
      sym_auto_skip,
      anon_sym_DASH_DASHbuild_DASHarg,
      sym_pass_args,
      anon_sym_DASH_DASHplatform,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
    ACTIONS(1519), 15,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(664), 21,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
  [9520] = 10,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(1537), 1,
      anon_sym_DOLLAR2,
    ACTIONS(1540), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(354), 1,
      sym__immediate_escape_sequence,
    ACTIONS(1534), 3,
      anon_sym_EQ3,
      anon_sym_DASH,
      sym__immediate_string_base_other,
    ACTIONS(5), 4,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    STATE(169), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(705), 9,
      anon_sym_SQUOTE,
      anon_sym_DASH_DASHmount,
      sym_no_cache,
      sym_privileged,
      anon_sym_DASH_DASHsecret,
      anon_sym_EQ4,
      sym_ssh,
      anon_sym_DQUOTE2,
      sym_comment,
    ACTIONS(1531), 14,
      anon_sym_SLASH,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(700), 20,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
  [9599] = 10,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(1549), 1,
      anon_sym_DOLLAR2,
    ACTIONS(1552), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(354), 1,
      sym__immediate_escape_sequence,
    ACTIONS(1546), 3,
      anon_sym_EQ3,
      anon_sym_DASH,
      sym__immediate_string_base_other,
    ACTIONS(5), 4,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    STATE(150), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(685), 9,
      anon_sym_SQUOTE,
      anon_sym_DASH_DASHmount,
      sym_no_cache,
      sym_privileged,
      anon_sym_DASH_DASHsecret,
      anon_sym_EQ4,
      sym_ssh,
      anon_sym_DQUOTE2,
      sym_comment,
    ACTIONS(1543), 14,
      anon_sym_SLASH,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(680), 20,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
  [9678] = 13,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 1,
      sym_line_continuation_comment,
    ACTIONS(1561), 1,
      anon_sym_SQUOTE,
    ACTIONS(1564), 1,
      anon_sym_DQUOTE2,
    ACTIONS(1567), 1,
      anon_sym_DOLLAR2,
    ACTIONS(1570), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(501), 1,
      sym__immediate_escape_sequence,
    ACTIONS(1558), 2,
      anon_sym_LPAREN2,
      sym__immediate_string_base_other,
    STATE(171), 4,
      sym__immediate_double_quoted_string,
      sym__immediate_single_quoted_string,
      sym__immediate_unquoted_string,
      aux_sym_string_repeat1,
    STATE(260), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(469), 6,
      anon_sym_LPAREN3,
      anon_sym_SQUOTE2,
      sym_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(1555), 15,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(464), 20,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      anon_sym_NULL,
  [9763] = 10,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 1,
      sym_line_continuation_comment,
    ACTIONS(1579), 1,
      anon_sym_DOLLAR2,
    ACTIONS(1582), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(309), 1,
      sym__immediate_escape_sequence,
    ACTIONS(1576), 2,
      anon_sym_DASH,
      sym__immediate_string_base_other,
    STATE(172), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(705), 10,
      anon_sym_DASH_DASHcache_DASHfrom,
      sym_cache_hint,
      sym_push,
      sym_without_earthly_labels,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
      sym_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(1573), 15,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(700), 22,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      anon_sym_NULL,
  [9842] = 13,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(1591), 1,
      anon_sym_SQUOTE,
    ACTIONS(1594), 1,
      anon_sym_DQUOTE2,
    ACTIONS(1597), 1,
      anon_sym_DOLLAR2,
    ACTIONS(1600), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(536), 1,
      sym__immediate_escape_sequence,
    ACTIONS(469), 2,
      sym_allow_privileged,
      anon_sym_SQUOTE2,
    ACTIONS(1588), 2,
      anon_sym_DASH,
      sym__immediate_string_base_other,
    STATE(173), 4,
      sym__immediate_double_quoted_string,
      sym__immediate_single_quoted_string,
      sym__immediate_unquoted_string,
      aux_sym_string_repeat1,
    STATE(226), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(1585), 15,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(464), 20,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
  [9927] = 6,
    ACTIONS(3), 1,
      sym_line_continuation,
    STATE(354), 1,
      sym__immediate_escape_sequence,
    ACTIONS(5), 4,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    STATE(169), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(693), 24,
      anon_sym_SLASH,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_SQUOTE,
      anon_sym_DASH_DASHmount,
      sym_no_cache,
      sym_privileged,
      anon_sym_DASH_DASHsecret,
      anon_sym_EQ4,
      sym_ssh,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
      sym_comment,
    ACTIONS(695), 24,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_EQ3,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
  [9998] = 13,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 1,
      sym_line_continuation_comment,
    ACTIONS(1605), 1,
      anon_sym_SQUOTE,
    ACTIONS(1607), 1,
      sym__immediate_string_base_other,
    ACTIONS(1609), 1,
      anon_sym_DQUOTE2,
    ACTIONS(1611), 1,
      anon_sym_DOLLAR2,
    ACTIONS(1613), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(588), 1,
      sym__immediate_escape_sequence,
    STATE(183), 4,
      sym__immediate_double_quoted_string,
      sym__immediate_single_quoted_string,
      sym__immediate_unquoted_string,
      aux_sym_string_repeat1,
    STATE(328), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(449), 5,
      anon_sym_SQUOTE2,
      sym_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(1603), 16,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(445), 20,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      anon_sym_NULL,
  [10082] = 10,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(1622), 1,
      anon_sym_DOLLAR2,
    ACTIONS(1625), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(398), 1,
      sym__immediate_escape_sequence,
    ACTIONS(1619), 3,
      anon_sym_DASH,
      anon_sym_LPAREN2,
      sym__immediate_string_base_other,
    STATE(176), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(705), 8,
      anon_sym_DQUOTE,
      anon_sym_LPAREN3,
      sym_allow_privileged,
      anon_sym_DASH_DASHbuild_DASHarg,
      anon_sym_DASHf,
      anon_sym_DASH_DASHtarget,
      anon_sym_DASH_DASHplatform,
      anon_sym_SQUOTE2,
    ACTIONS(1616), 14,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(700), 19,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
  [10160] = 10,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(1634), 1,
      anon_sym_DOLLAR2,
    ACTIONS(1637), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(395), 1,
      sym__immediate_escape_sequence,
    ACTIONS(1631), 2,
      anon_sym_DASH,
      sym__immediate_string_base_other,
    STATE(189), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(669), 6,
      anon_sym_DASH_DASHchmod,
      anon_sym_DASH_DASHid,
      sym_persist,
      anon_sym_DASH_DASHsharing,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
    ACTIONS(1628), 15,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(664), 21,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
  [10238] = 13,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(1644), 1,
      anon_sym_SQUOTE,
    ACTIONS(1646), 1,
      anon_sym_DQUOTE2,
    ACTIONS(1648), 1,
      anon_sym_DOLLAR2,
    ACTIONS(1650), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(561), 1,
      sym__immediate_escape_sequence,
    ACTIONS(581), 2,
      anon_sym_LPAREN3,
      anon_sym_SQUOTE2,
    ACTIONS(1642), 2,
      anon_sym_LPAREN2,
      sym__immediate_string_base_other,
    STATE(184), 4,
      sym__immediate_double_quoted_string,
      sym__immediate_single_quoted_string,
      sym__immediate_unquoted_string,
      aux_sym_string_repeat1,
    STATE(315), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(1640), 15,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(579), 19,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
  [10322] = 10,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(1659), 1,
      anon_sym_DOLLAR2,
    ACTIONS(1662), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(382), 1,
      sym__immediate_escape_sequence,
    ACTIONS(1656), 2,
      anon_sym_DASH,
      sym__immediate_string_base_other,
    ACTIONS(5), 4,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    STATE(182), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(685), 8,
      anon_sym_SQUOTE,
      anon_sym_DASH_DASHmount,
      sym_no_cache,
      sym_privileged,
      anon_sym_DASH_DASHsecret,
      sym_ssh,
      anon_sym_DQUOTE2,
      sym_comment,
    ACTIONS(1653), 15,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(680), 20,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
  [10400] = 10,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(1671), 1,
      anon_sym_DOLLAR2,
    ACTIONS(1674), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(382), 1,
      sym__immediate_escape_sequence,
    ACTIONS(1668), 2,
      anon_sym_DASH,
      sym__immediate_string_base_other,
    ACTIONS(5), 4,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    STATE(180), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(705), 8,
      anon_sym_SQUOTE,
      anon_sym_DASH_DASHmount,
      sym_no_cache,
      sym_privileged,
      anon_sym_DASH_DASHsecret,
      sym_ssh,
      anon_sym_DQUOTE2,
      sym_comment,
    ACTIONS(1665), 15,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(700), 20,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
  [10478] = 10,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(1683), 1,
      anon_sym_DOLLAR2,
    ACTIONS(1686), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(395), 1,
      sym__immediate_escape_sequence,
    ACTIONS(1680), 2,
      anon_sym_DASH,
      sym__immediate_string_base_other,
    STATE(177), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(685), 6,
      anon_sym_DASH_DASHchmod,
      anon_sym_DASH_DASHid,
      sym_persist,
      anon_sym_DASH_DASHsharing,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
    ACTIONS(1677), 15,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(680), 21,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
  [10556] = 10,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(1695), 1,
      anon_sym_DOLLAR2,
    ACTIONS(1698), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(382), 1,
      sym__immediate_escape_sequence,
    ACTIONS(1692), 2,
      anon_sym_DASH,
      sym__immediate_string_base_other,
    ACTIONS(5), 4,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    STATE(180), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(669), 8,
      anon_sym_SQUOTE,
      anon_sym_DASH_DASHmount,
      sym_no_cache,
      sym_privileged,
      anon_sym_DASH_DASHsecret,
      sym_ssh,
      anon_sym_DQUOTE2,
      sym_comment,
    ACTIONS(1689), 15,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(664), 20,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
  [10634] = 13,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 1,
      sym_line_continuation_comment,
    ACTIONS(1704), 1,
      anon_sym_SQUOTE,
    ACTIONS(1707), 1,
      sym__immediate_string_base_other,
    ACTIONS(1710), 1,
      anon_sym_DQUOTE2,
    ACTIONS(1713), 1,
      anon_sym_DOLLAR2,
    ACTIONS(1716), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(588), 1,
      sym__immediate_escape_sequence,
    STATE(183), 4,
      sym__immediate_double_quoted_string,
      sym__immediate_single_quoted_string,
      sym__immediate_unquoted_string,
      aux_sym_string_repeat1,
    STATE(328), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(469), 5,
      anon_sym_SQUOTE2,
      sym_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(1701), 16,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(464), 20,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      anon_sym_NULL,
  [10718] = 13,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(1644), 1,
      anon_sym_SQUOTE,
    ACTIONS(1646), 1,
      anon_sym_DQUOTE2,
    ACTIONS(1648), 1,
      anon_sym_DOLLAR2,
    ACTIONS(1719), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(561), 1,
      sym__immediate_escape_sequence,
    ACTIONS(449), 2,
      anon_sym_LPAREN3,
      anon_sym_SQUOTE2,
    ACTIONS(1642), 2,
      anon_sym_LPAREN2,
      sym__immediate_string_base_other,
    STATE(190), 4,
      sym__immediate_double_quoted_string,
      sym__immediate_single_quoted_string,
      sym__immediate_unquoted_string,
      aux_sym_string_repeat1,
    STATE(315), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(1640), 15,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(445), 19,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
  [10802] = 9,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(1726), 1,
      anon_sym_DOLLAR2,
    STATE(398), 1,
      sym__immediate_escape_sequence,
    ACTIONS(1724), 3,
      anon_sym_DASH,
      anon_sym_LPAREN2,
      sym__immediate_string_base_other,
    STATE(176), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(693), 8,
      anon_sym_DQUOTE,
      anon_sym_LPAREN3,
      sym_allow_privileged,
      anon_sym_DASH_DASHbuild_DASHarg,
      anon_sym_DASHf,
      anon_sym_DASH_DASHtarget,
      anon_sym_DASH_DASHplatform,
      anon_sym_SQUOTE2,
    ACTIONS(1722), 14,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(695), 20,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      aux_sym__immediate_escape_sequence_token1,
  [10878] = 6,
    ACTIONS(3), 1,
      sym_line_continuation,
    STATE(382), 1,
      sym__immediate_escape_sequence,
    ACTIONS(5), 4,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    STATE(180), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(695), 23,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
    ACTIONS(693), 24,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_SQUOTE,
      anon_sym_DASH_DASHmount,
      sym_no_cache,
      sym_privileged,
      anon_sym_DASH_DASHsecret,
      sym_ssh,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
      sym_comment,
  [10948] = 6,
    ACTIONS(3), 1,
      sym_line_continuation,
    STATE(395), 1,
      sym__immediate_escape_sequence,
    STATE(189), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(693), 22,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_DASH_DASHchmod,
      anon_sym_DASH_DASHid,
      sym_persist,
      anon_sym_DASH_DASHsharing,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
    ACTIONS(695), 24,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
  [11018] = 13,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 1,
      sym_line_continuation_comment,
    ACTIONS(1605), 1,
      anon_sym_SQUOTE,
    ACTIONS(1607), 1,
      sym__immediate_string_base_other,
    ACTIONS(1609), 1,
      anon_sym_DQUOTE2,
    ACTIONS(1611), 1,
      anon_sym_DOLLAR2,
    ACTIONS(1728), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(588), 1,
      sym__immediate_escape_sequence,
    STATE(175), 4,
      sym__immediate_double_quoted_string,
      sym__immediate_single_quoted_string,
      sym__immediate_unquoted_string,
      aux_sym_string_repeat1,
    STATE(328), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(581), 5,
      anon_sym_SQUOTE2,
      sym_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(1603), 16,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(579), 20,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      anon_sym_NULL,
  [11102] = 10,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(1737), 1,
      anon_sym_DOLLAR2,
    ACTIONS(1740), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(395), 1,
      sym__immediate_escape_sequence,
    ACTIONS(1734), 2,
      anon_sym_DASH,
      sym__immediate_string_base_other,
    STATE(189), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(705), 6,
      anon_sym_DASH_DASHchmod,
      anon_sym_DASH_DASHid,
      sym_persist,
      anon_sym_DASH_DASHsharing,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
    ACTIONS(1731), 15,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(700), 21,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
  [11180] = 13,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(1749), 1,
      anon_sym_SQUOTE,
    ACTIONS(1752), 1,
      anon_sym_DQUOTE2,
    ACTIONS(1755), 1,
      anon_sym_DOLLAR2,
    ACTIONS(1758), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(561), 1,
      sym__immediate_escape_sequence,
    ACTIONS(469), 2,
      anon_sym_LPAREN3,
      anon_sym_SQUOTE2,
    ACTIONS(1746), 2,
      anon_sym_LPAREN2,
      sym__immediate_string_base_other,
    STATE(190), 4,
      sym__immediate_double_quoted_string,
      sym__immediate_single_quoted_string,
      sym__immediate_unquoted_string,
      aux_sym_string_repeat1,
    STATE(315), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(1743), 15,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(464), 19,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
  [11264] = 10,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(1767), 1,
      anon_sym_DOLLAR2,
    ACTIONS(1770), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(418), 1,
      sym__immediate_escape_sequence,
    ACTIONS(1764), 2,
      anon_sym_DASH,
      sym__immediate_string_base_other,
    STATE(193), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(669), 5,
      sym_allow_privileged,
      sym_pass_args,
      anon_sym_DASH_DASHplatform,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
    ACTIONS(1761), 15,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(664), 21,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
  [11341] = 9,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(753), 1,
      anon_sym_EQ4,
    ACTIONS(1773), 1,
      sym__immediate_string_base_other,
    STATE(2098), 1,
      aux_sym_variable_repeat1,
    ACTIONS(1776), 2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
    STATE(351), 2,
      sym__immediate_string_base,
      aux_sym__immediate_string_base_repeat1,
    ACTIONS(5), 4,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(749), 21,
      anon_sym_SLASH,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_SQUOTE,
      anon_sym_DASH_DASHmount,
      sym_no_cache,
      sym_privileged,
      anon_sym_DASH_DASHsecret,
      sym_ssh,
      anon_sym_DQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
      sym_comment,
    ACTIONS(751), 23,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_EQ3,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      aux_sym__immediate_escape_sequence_token1,
  [11416] = 10,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(1785), 1,
      anon_sym_DOLLAR2,
    ACTIONS(1788), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(418), 1,
      sym__immediate_escape_sequence,
    ACTIONS(1782), 2,
      anon_sym_DASH,
      sym__immediate_string_base_other,
    STATE(193), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(705), 5,
      sym_allow_privileged,
      sym_pass_args,
      anon_sym_DASH_DASHplatform,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
    ACTIONS(1779), 15,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(700), 21,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
  [11493] = 13,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(581), 1,
      anon_sym_SQUOTE2,
    ACTIONS(1793), 1,
      anon_sym_SQUOTE,
    ACTIONS(1795), 1,
      sym__immediate_string_base_other,
    ACTIONS(1797), 1,
      anon_sym_DQUOTE2,
    ACTIONS(1799), 1,
      anon_sym_DOLLAR2,
    ACTIONS(1801), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(608), 1,
      sym__immediate_escape_sequence,
    STATE(197), 4,
      sym__immediate_double_quoted_string,
      sym__immediate_single_quoted_string,
      sym__immediate_unquoted_string,
      aux_sym_string_repeat1,
    STATE(371), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(1791), 16,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(579), 19,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
  [11576] = 10,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(1810), 1,
      anon_sym_DOLLAR2,
    ACTIONS(1813), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(418), 1,
      sym__immediate_escape_sequence,
    ACTIONS(1807), 2,
      anon_sym_DASH,
      sym__immediate_string_base_other,
    STATE(191), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(685), 5,
      sym_allow_privileged,
      sym_pass_args,
      anon_sym_DASH_DASHplatform,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
    ACTIONS(1804), 15,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(680), 21,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
  [11653] = 13,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(469), 1,
      anon_sym_SQUOTE2,
    ACTIONS(1819), 1,
      anon_sym_SQUOTE,
    ACTIONS(1822), 1,
      sym__immediate_string_base_other,
    ACTIONS(1825), 1,
      anon_sym_DQUOTE2,
    ACTIONS(1828), 1,
      anon_sym_DOLLAR2,
    ACTIONS(1831), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(608), 1,
      sym__immediate_escape_sequence,
    STATE(196), 4,
      sym__immediate_double_quoted_string,
      sym__immediate_single_quoted_string,
      sym__immediate_unquoted_string,
      aux_sym_string_repeat1,
    STATE(371), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(1816), 16,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(464), 19,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
  [11736] = 13,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(449), 1,
      anon_sym_SQUOTE2,
    ACTIONS(1793), 1,
      anon_sym_SQUOTE,
    ACTIONS(1795), 1,
      sym__immediate_string_base_other,
    ACTIONS(1797), 1,
      anon_sym_DQUOTE2,
    ACTIONS(1799), 1,
      anon_sym_DOLLAR2,
    ACTIONS(1834), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(608), 1,
      sym__immediate_escape_sequence,
    STATE(196), 4,
      sym__immediate_double_quoted_string,
      sym__immediate_single_quoted_string,
      sym__immediate_unquoted_string,
      aux_sym_string_repeat1,
    STATE(371), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(1791), 16,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(445), 19,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
  [11819] = 6,
    ACTIONS(3), 1,
      sym_line_continuation,
    STATE(418), 1,
      sym__immediate_escape_sequence,
    STATE(193), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(693), 21,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym_allow_privileged,
      sym_pass_args,
      anon_sym_DASH_DASHplatform,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
    ACTIONS(695), 24,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
  [11888] = 7,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(1837), 1,
      sym__immediate_string_base_other,
    ACTIONS(1840), 2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
    STATE(236), 2,
      sym__immediate_string_base,
      aux_sym__immediate_string_base_repeat1,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(749), 21,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_LPAREN3,
      sym_allow_privileged,
      anon_sym_DASH_DASHbuild_DASHarg,
      anon_sym_DASHf,
      anon_sym_DASH_DASHtarget,
      anon_sym_DASH_DASHplatform,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
    ACTIONS(751), 24,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_LPAREN2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      aux_sym__immediate_escape_sequence_token1,
  [11959] = 5,
    ACTIONS(3), 1,
      sym_line_continuation,
    STATE(222), 1,
      aux_sym_variable_repeat1,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(828), 23,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_LPAREN3,
      sym_allow_privileged,
      anon_sym_DASH_DASHbuild_DASHarg,
      anon_sym_DASHf,
      anon_sym_DASH_DASHtarget,
      anon_sym_DASH_DASHplatform,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
    ACTIONS(830), 25,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_LPAREN2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
  [12025] = 10,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(1849), 1,
      anon_sym_DOLLAR2,
    ACTIONS(1852), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(461), 1,
      sym__immediate_escape_sequence,
    ACTIONS(1846), 2,
      anon_sym_DASH,
      sym__immediate_string_base_other,
    ACTIONS(705), 4,
      anon_sym_DASH_DASHbranch,
      sym_keep_ts,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
    STATE(201), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(1843), 15,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(700), 21,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
  [12101] = 10,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(1861), 1,
      anon_sym_DOLLAR2,
    ACTIONS(1864), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(441), 1,
      sym__immediate_escape_sequence,
    ACTIONS(1858), 2,
      anon_sym_DASH,
      sym__immediate_string_base_other,
    ACTIONS(705), 4,
      sym_allow_privileged,
      sym_pass_args,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
    STATE(202), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(1855), 15,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(700), 21,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
  [12177] = 7,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 1,
      sym_line_continuation_comment,
    ACTIONS(1867), 1,
      sym__immediate_string_base_other,
    ACTIONS(1870), 2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
    STATE(338), 2,
      sym__immediate_string_base,
      aux_sym__immediate_string_base_repeat1,
    ACTIONS(749), 24,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_DASH_DASHcache_DASHfrom,
      sym_cache_hint,
      sym_push,
      sym_without_earthly_labels,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
      sym_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(751), 24,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      aux_sym__immediate_escape_sequence_token1,
      anon_sym_NULL,
  [12247] = 6,
    ACTIONS(3), 1,
      sym_line_continuation,
    STATE(204), 1,
      aux_sym_variable_repeat1,
    ACTIONS(1873), 2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(821), 21,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_LPAREN3,
      sym_allow_privileged,
      anon_sym_DASH_DASHbuild_DASHarg,
      anon_sym_DASHf,
      anon_sym_DASH_DASHtarget,
      anon_sym_DASH_DASHplatform,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
    ACTIONS(823), 25,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_LPAREN2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
  [12315] = 14,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 1,
      sym_line_continuation_comment,
    ACTIONS(1195), 1,
      anon_sym_PLUS,
    ACTIONS(1885), 1,
      anon_sym_DOLLAR2,
    ACTIONS(1888), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(548), 1,
      sym__immediate_escape_sequence,
    STATE(1608), 1,
      aux_sym_earthfile_ref_repeat1,
    ACTIONS(1879), 2,
      anon_sym_EQ3,
      anon_sym_PLUS2,
    ACTIONS(1882), 2,
      anon_sym_LPAREN2,
      sym__immediate_string_base_other,
    STATE(242), 2,
      sym__immediate_expansion,
      aux_sym_unquoted_string_repeat1,
    STATE(527), 2,
      sym__immediate_string_base,
      aux_sym__immediate_string_base_repeat1,
    ACTIONS(685), 7,
      anon_sym_LPAREN3,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
      sym_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(1876), 13,
      anon_sym_SLASH,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
    ACTIONS(680), 20,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      anon_sym_NULL,
  [12399] = 6,
    ACTIONS(3), 1,
      sym_line_continuation,
    STATE(441), 1,
      sym__immediate_escape_sequence,
    STATE(202), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(693), 20,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym_allow_privileged,
      sym_pass_args,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
    ACTIONS(695), 24,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
  [12467] = 23,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(1893), 1,
      anon_sym_DASH_DASH,
    ACTIONS(1897), 1,
      anon_sym_DQUOTE,
    ACTIONS(1899), 1,
      anon_sym_SQUOTE,
    ACTIONS(1901), 1,
      anon_sym_LBRACK3,
    ACTIONS(1905), 1,
      anon_sym_DASH_DASHinteractive,
    ACTIONS(1907), 1,
      anon_sym_DASH_DASHinteractive_DASHkeep,
    ACTIONS(1909), 1,
      anon_sym_DASH_DASHmount,
    ACTIONS(1911), 1,
      anon_sym_DASH_DASHoidc,
    ACTIONS(1913), 1,
      anon_sym_DASH_DASHsecret,
    ACTIONS(1915), 1,
      aux_sym_unknown_option_token1,
    ACTIONS(1917), 1,
      sym__string_base_other,
    ACTIONS(1921), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(1235), 1,
      sym_run_options,
    STATE(1585), 1,
      sym_escape_sequence,
    ACTIONS(1895), 2,
      anon_sym_LBRACK,
      anon_sym_DASH2,
    ACTIONS(1919), 2,
      sym__string_base_alpha,
      sym__string_base_num,
    STATE(1373), 2,
      sym__string_base,
      aux_sym_shell_fragment_repeat3,
    STATE(2211), 2,
      sym_shell_fragment,
      sym_string_array,
    ACTIONS(5), 4,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    STATE(551), 6,
      sym_interactive,
      sym_mount,
      sym_oidc,
      sym_secret,
      sym_unknown_option,
      aux_sym_run_options_repeat1,
    ACTIONS(1903), 8,
      sym_aws,
      sym_entrypoint,
      sym_network_none,
      sym_no_cache,
      sym_privileged,
      sym_push,
      sym_raw_output,
      sym_ssh,
    ACTIONS(1891), 14,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      sym_comment,
  [12569] = 6,
    ACTIONS(3), 1,
      sym_line_continuation,
    STATE(461), 1,
      sym__immediate_escape_sequence,
    STATE(201), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(693), 20,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_DASH_DASHbranch,
      sym_keep_ts,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
    ACTIONS(695), 24,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
  [12637] = 23,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(1897), 1,
      anon_sym_DQUOTE,
    ACTIONS(1899), 1,
      anon_sym_SQUOTE,
    ACTIONS(1901), 1,
      anon_sym_LBRACK3,
    ACTIONS(1905), 1,
      anon_sym_DASH_DASHinteractive,
    ACTIONS(1907), 1,
      anon_sym_DASH_DASHinteractive_DASHkeep,
    ACTIONS(1909), 1,
      anon_sym_DASH_DASHmount,
    ACTIONS(1911), 1,
      anon_sym_DASH_DASHoidc,
    ACTIONS(1913), 1,
      anon_sym_DASH_DASHsecret,
    ACTIONS(1915), 1,
      aux_sym_unknown_option_token1,
    ACTIONS(1917), 1,
      sym__string_base_other,
    ACTIONS(1921), 1,
      aux_sym__immediate_escape_sequence_token1,
    ACTIONS(1923), 1,
      anon_sym_DASH_DASH,
    STATE(1167), 1,
      sym_run_options,
    STATE(1585), 1,
      sym_escape_sequence,
    ACTIONS(1895), 2,
      anon_sym_LBRACK,
      anon_sym_DASH2,
    ACTIONS(1919), 2,
      sym__string_base_alpha,
      sym__string_base_num,
    STATE(1373), 2,
      sym__string_base,
      aux_sym_shell_fragment_repeat3,
    STATE(2476), 2,
      sym_shell_fragment,
      sym_string_array,
    ACTIONS(5), 4,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    STATE(551), 6,
      sym_interactive,
      sym_mount,
      sym_oidc,
      sym_secret,
      sym_unknown_option,
      aux_sym_run_options_repeat1,
    ACTIONS(1903), 8,
      sym_aws,
      sym_entrypoint,
      sym_network_none,
      sym_no_cache,
      sym_privileged,
      sym_push,
      sym_raw_output,
      sym_ssh,
    ACTIONS(1891), 14,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      sym_comment,
  [12739] = 7,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(1773), 1,
      sym__immediate_string_base_other,
    ACTIONS(1925), 2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
    STATE(351), 2,
      sym__immediate_string_base,
      aux_sym__immediate_string_base_repeat1,
    ACTIONS(5), 4,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(749), 22,
      anon_sym_SLASH,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_SQUOTE,
      anon_sym_DASH_DASHmount,
      sym_no_cache,
      sym_privileged,
      anon_sym_DASH_DASHsecret,
      anon_sym_EQ4,
      sym_ssh,
      anon_sym_DQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
      sym_comment,
    ACTIONS(751), 23,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_EQ3,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      aux_sym__immediate_escape_sequence_token1,
  [12809] = 8,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(1928), 1,
      anon_sym_SLASH,
    ACTIONS(1934), 1,
      anon_sym_DASH,
    STATE(1852), 1,
      aux_sym__immediate_identifier_repeat1,
    ACTIONS(1931), 3,
      anon_sym_DOT,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(924), 19,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_LPAREN3,
      sym_allow_privileged,
      anon_sym_DASH_DASHbuild_DASHarg,
      anon_sym_DASHf,
      anon_sym_DASH_DASHtarget,
      anon_sym_DASH_DASHplatform,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
    ACTIONS(926), 24,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_LPAREN2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
  [12881] = 10,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(1943), 1,
      anon_sym_DOLLAR2,
    ACTIONS(1946), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(441), 1,
      sym__immediate_escape_sequence,
    ACTIONS(1940), 2,
      anon_sym_DASH,
      sym__immediate_string_base_other,
    ACTIONS(685), 4,
      sym_allow_privileged,
      sym_pass_args,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
    STATE(217), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(1937), 15,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(680), 21,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
  [12957] = 7,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(1949), 1,
      sym__immediate_string_base_other,
    ACTIONS(1952), 2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
    STATE(352), 2,
      sym__immediate_string_base,
      aux_sym__immediate_string_base_repeat1,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(749), 21,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym_allow_privileged,
      sym_auto_skip,
      anon_sym_DASH_DASHbuild_DASHarg,
      sym_pass_args,
      anon_sym_DASH_DASHplatform,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
    ACTIONS(751), 23,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      aux_sym__immediate_escape_sequence_token1,
  [13027] = 23,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(1897), 1,
      anon_sym_DQUOTE,
    ACTIONS(1899), 1,
      anon_sym_SQUOTE,
    ACTIONS(1901), 1,
      anon_sym_LBRACK3,
    ACTIONS(1905), 1,
      anon_sym_DASH_DASHinteractive,
    ACTIONS(1907), 1,
      anon_sym_DASH_DASHinteractive_DASHkeep,
    ACTIONS(1909), 1,
      anon_sym_DASH_DASHmount,
    ACTIONS(1911), 1,
      anon_sym_DASH_DASHoidc,
    ACTIONS(1913), 1,
      anon_sym_DASH_DASHsecret,
    ACTIONS(1915), 1,
      aux_sym_unknown_option_token1,
    ACTIONS(1917), 1,
      sym__string_base_other,
    ACTIONS(1921), 1,
      aux_sym__immediate_escape_sequence_token1,
    ACTIONS(1955), 1,
      anon_sym_DASH_DASH,
    STATE(1168), 1,
      sym_run_options,
    STATE(1585), 1,
      sym_escape_sequence,
    ACTIONS(1895), 2,
      anon_sym_LBRACK,
      anon_sym_DASH2,
    ACTIONS(1919), 2,
      sym__string_base_alpha,
      sym__string_base_num,
    STATE(1373), 2,
      sym__string_base,
      aux_sym_shell_fragment_repeat3,
    STATE(2510), 2,
      sym_shell_fragment,
      sym_string_array,
    ACTIONS(5), 4,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    STATE(551), 6,
      sym_interactive,
      sym_mount,
      sym_oidc,
      sym_secret,
      sym_unknown_option,
      aux_sym_run_options_repeat1,
    ACTIONS(1903), 8,
      sym_aws,
      sym_entrypoint,
      sym_network_none,
      sym_no_cache,
      sym_privileged,
      sym_push,
      sym_raw_output,
      sym_ssh,
    ACTIONS(1891), 14,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      sym_comment,
  [13129] = 12,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 1,
      sym_line_continuation_comment,
    ACTIONS(1885), 1,
      anon_sym_DOLLAR2,
    ACTIONS(1888), 1,
      aux_sym__immediate_escape_sequence_token1,
    ACTIONS(1960), 1,
      sym__immediate_string_base_alpha,
    STATE(501), 1,
      sym__immediate_escape_sequence,
    STATE(2121), 1,
      sym__immediate_identifier,
    ACTIONS(1957), 2,
      anon_sym_LPAREN2,
      sym__immediate_string_base_other,
    STATE(242), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(685), 7,
      anon_sym_LPAREN3,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
      sym_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(1879), 14,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(680), 21,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      anon_sym_NULL,
  [13209] = 23,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(1897), 1,
      anon_sym_DQUOTE,
    ACTIONS(1899), 1,
      anon_sym_SQUOTE,
    ACTIONS(1901), 1,
      anon_sym_LBRACK3,
    ACTIONS(1905), 1,
      anon_sym_DASH_DASHinteractive,
    ACTIONS(1907), 1,
      anon_sym_DASH_DASHinteractive_DASHkeep,
    ACTIONS(1909), 1,
      anon_sym_DASH_DASHmount,
    ACTIONS(1911), 1,
      anon_sym_DASH_DASHoidc,
    ACTIONS(1913), 1,
      anon_sym_DASH_DASHsecret,
    ACTIONS(1915), 1,
      aux_sym_unknown_option_token1,
    ACTIONS(1917), 1,
      sym__string_base_other,
    ACTIONS(1921), 1,
      aux_sym__immediate_escape_sequence_token1,
    ACTIONS(1963), 1,
      anon_sym_DASH_DASH,
    STATE(1206), 1,
      sym_run_options,
    STATE(1585), 1,
      sym_escape_sequence,
    ACTIONS(1895), 2,
      anon_sym_LBRACK,
      anon_sym_DASH2,
    ACTIONS(1919), 2,
      sym__string_base_alpha,
      sym__string_base_num,
    STATE(1373), 2,
      sym__string_base,
      aux_sym_shell_fragment_repeat3,
    STATE(2477), 2,
      sym_shell_fragment,
      sym_string_array,
    ACTIONS(5), 4,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    STATE(551), 6,
      sym_interactive,
      sym_mount,
      sym_oidc,
      sym_secret,
      sym_unknown_option,
      aux_sym_run_options_repeat1,
    ACTIONS(1903), 8,
      sym_aws,
      sym_entrypoint,
      sym_network_none,
      sym_no_cache,
      sym_privileged,
      sym_push,
      sym_raw_output,
      sym_ssh,
    ACTIONS(1891), 14,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      sym_comment,
  [13311] = 10,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(1971), 1,
      anon_sym_DOLLAR2,
    ACTIONS(1974), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(441), 1,
      sym__immediate_escape_sequence,
    ACTIONS(1968), 2,
      anon_sym_DASH,
      sym__immediate_string_base_other,
    ACTIONS(669), 4,
      sym_allow_privileged,
      sym_pass_args,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
    STATE(202), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(1965), 15,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(664), 21,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
  [13387] = 10,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(1983), 1,
      anon_sym_DOLLAR2,
    ACTIONS(1986), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(461), 1,
      sym__immediate_escape_sequence,
    ACTIONS(1980), 2,
      anon_sym_DASH,
      sym__immediate_string_base_other,
    ACTIONS(669), 4,
      anon_sym_DASH_DASHbranch,
      sym_keep_ts,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
    STATE(201), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(1977), 15,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(664), 21,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
  [13463] = 7,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(1989), 1,
      sym__immediate_string_base_other,
    STATE(219), 1,
      aux_sym__immediate_string_base_repeat1,
    ACTIONS(1992), 2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(807), 21,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_LPAREN3,
      sym_allow_privileged,
      anon_sym_DASH_DASHbuild_DASHarg,
      anon_sym_DASHf,
      anon_sym_DASH_DASHtarget,
      anon_sym_DASH_DASHplatform,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
    ACTIONS(809), 24,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_LPAREN2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      aux_sym__immediate_escape_sequence_token1,
  [13533] = 10,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(2001), 1,
      anon_sym_DOLLAR2,
    ACTIONS(2004), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(461), 1,
      sym__immediate_escape_sequence,
    ACTIONS(1998), 2,
      anon_sym_DASH,
      sym__immediate_string_base_other,
    ACTIONS(685), 4,
      anon_sym_DASH_DASHbranch,
      sym_keep_ts,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
    STATE(218), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(1995), 15,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(680), 21,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
  [13609] = 7,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(2007), 1,
      sym__immediate_string_base_other,
    ACTIONS(2010), 2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
    STATE(348), 2,
      sym__immediate_string_base,
      aux_sym__immediate_string_base_repeat1,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(749), 21,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym_force,
      sym_if_exists,
      sym_keep_own,
      sym_keep_ts,
      sym_symlink_no_follow,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
    ACTIONS(751), 23,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      aux_sym__immediate_escape_sequence_token1,
  [13679] = 5,
    ACTIONS(3), 1,
      sym_line_continuation,
    STATE(204), 1,
      aux_sym_variable_repeat1,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(817), 23,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_LPAREN3,
      sym_allow_privileged,
      anon_sym_DASH_DASHbuild_DASHarg,
      anon_sym_DASHf,
      anon_sym_DASH_DASHtarget,
      anon_sym_DASH_DASHplatform,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
    ACTIONS(819), 25,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_LPAREN2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
  [13745] = 10,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 1,
      sym_line_continuation_comment,
    ACTIONS(1885), 1,
      anon_sym_DOLLAR2,
    ACTIONS(1888), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(501), 1,
      sym__immediate_escape_sequence,
    ACTIONS(1957), 2,
      anon_sym_LPAREN2,
      sym__immediate_string_base_other,
    STATE(242), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(685), 7,
      anon_sym_LPAREN3,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
      sym_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(1879), 15,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(680), 21,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      anon_sym_NULL,
  [13820] = 7,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(2013), 1,
      sym__immediate_string_base_other,
    STATE(224), 1,
      aux_sym__immediate_string_base_repeat1,
    ACTIONS(2016), 2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(807), 21,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym_force,
      sym_if_exists,
      sym_keep_own,
      sym_keep_ts,
      sym_symlink_no_follow,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
    ACTIONS(809), 23,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      aux_sym__immediate_escape_sequence_token1,
  [13889] = 4,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(865), 23,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_LPAREN3,
      sym_allow_privileged,
      anon_sym_DASH_DASHbuild_DASHarg,
      anon_sym_DASHf,
      anon_sym_DASH_DASHtarget,
      anon_sym_DASH_DASHplatform,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
    ACTIONS(867), 25,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_LPAREN2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
  [13952] = 6,
    ACTIONS(3), 1,
      sym_line_continuation,
    STATE(536), 1,
      sym__immediate_escape_sequence,
    STATE(247), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(693), 19,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym_allow_privileged,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
    ACTIONS(695), 24,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
  [14019] = 6,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(2026), 5,
      anon_sym_DASH,
      anon_sym_LPAREN2,
      anon_sym_PLUS,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
    ACTIONS(2024), 11,
      anon_sym_EQ3,
      anon_sym_LPAREN3,
      sym_allow_privileged,
      anon_sym_DASH_DASHbuild_DASHarg,
      anon_sym_DASHf,
      anon_sym_DASH_DASHtarget,
      anon_sym_DASH_DASHplatform,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
    ACTIONS(2019), 12,
      anon_sym_SLASH,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
    ACTIONS(2022), 20,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
  [14086] = 7,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(2029), 1,
      sym__immediate_string_base_other,
    STATE(228), 1,
      aux_sym__immediate_string_base_repeat1,
    ACTIONS(2032), 2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
    ACTIONS(5), 4,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(807), 22,
      anon_sym_SLASH,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_SQUOTE,
      anon_sym_DASH_DASHmount,
      sym_no_cache,
      sym_privileged,
      anon_sym_DASH_DASHsecret,
      anon_sym_EQ4,
      sym_ssh,
      anon_sym_DQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
      sym_comment,
    ACTIONS(809), 23,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_EQ3,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      aux_sym__immediate_escape_sequence_token1,
  [14155] = 6,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(2038), 5,
      anon_sym_DASH,
      anon_sym_LPAREN2,
      anon_sym_PLUS,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
    ACTIONS(832), 11,
      anon_sym_EQ3,
      anon_sym_LPAREN3,
      sym_allow_privileged,
      anon_sym_DASH_DASHbuild_DASHarg,
      anon_sym_DASHf,
      anon_sym_DASH_DASHtarget,
      anon_sym_DASH_DASHplatform,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
    ACTIONS(2035), 12,
      anon_sym_SLASH,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
    ACTIONS(834), 20,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
  [14222] = 4,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(920), 23,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_LPAREN3,
      sym_allow_privileged,
      anon_sym_DASH_DASHbuild_DASHarg,
      anon_sym_DASHf,
      anon_sym_DASH_DASHtarget,
      anon_sym_DASH_DASHplatform,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
    ACTIONS(922), 25,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_LPAREN2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
  [14285] = 14,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(1195), 1,
      anon_sym_PLUS,
    ACTIONS(2050), 1,
      anon_sym_DOLLAR2,
    ACTIONS(2053), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(590), 1,
      sym__immediate_escape_sequence,
    STATE(1608), 1,
      aux_sym_earthfile_ref_repeat1,
    ACTIONS(2044), 2,
      anon_sym_EQ3,
      anon_sym_PLUS2,
    ACTIONS(2047), 2,
      anon_sym_LPAREN2,
      sym__immediate_string_base_other,
    STATE(302), 2,
      sym__immediate_expansion,
      aux_sym_unquoted_string_repeat1,
    STATE(554), 2,
      sym__immediate_string_base,
      aux_sym__immediate_string_base_repeat1,
    ACTIONS(685), 3,
      anon_sym_LPAREN3,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(2041), 13,
      anon_sym_SLASH,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
    ACTIONS(680), 19,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
  [14368] = 4,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(857), 23,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_LPAREN3,
      sym_allow_privileged,
      anon_sym_DASH_DASHbuild_DASHarg,
      anon_sym_DASHf,
      anon_sym_DASH_DASHtarget,
      anon_sym_DASH_DASHplatform,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
    ACTIONS(859), 25,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_LPAREN2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
  [14431] = 12,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(2050), 1,
      anon_sym_DOLLAR2,
    ACTIONS(2053), 1,
      aux_sym__immediate_escape_sequence_token1,
    ACTIONS(2059), 1,
      sym__immediate_string_base_alpha,
    STATE(561), 1,
      sym__immediate_escape_sequence,
    STATE(2121), 1,
      sym__immediate_identifier,
    ACTIONS(2056), 2,
      anon_sym_LPAREN2,
      sym__immediate_string_base_other,
    ACTIONS(685), 3,
      anon_sym_LPAREN3,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
    STATE(302), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(2044), 14,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(680), 20,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
  [14510] = 7,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(2062), 1,
      sym__immediate_string_base_other,
    ACTIONS(2065), 2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
    STATE(375), 2,
      sym__immediate_string_base,
      aux_sym__immediate_string_base_repeat1,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(749), 20,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_DASH_DASHchmod,
      anon_sym_DASH_DASHid,
      sym_persist,
      anon_sym_DASH_DASHsharing,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
    ACTIONS(751), 23,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      aux_sym__immediate_escape_sequence_token1,
  [14579] = 5,
    ACTIONS(3), 1,
      sym_line_continuation,
    STATE(246), 1,
      aux_sym_variable_repeat1,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(817), 23,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym_allow_privileged,
      sym_auto_skip,
      anon_sym_DASH_DASHbuild_DASHarg,
      sym_pass_args,
      anon_sym_DASH_DASHplatform,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
    ACTIONS(819), 24,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
  [14644] = 4,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(942), 23,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_LPAREN3,
      sym_allow_privileged,
      anon_sym_DASH_DASHbuild_DASHarg,
      anon_sym_DASHf,
      anon_sym_DASH_DASHtarget,
      anon_sym_DASH_DASHplatform,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
    ACTIONS(944), 25,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_LPAREN2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
  [14707] = 4,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(853), 23,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_LPAREN3,
      sym_allow_privileged,
      anon_sym_DASH_DASHbuild_DASHarg,
      anon_sym_DASHf,
      anon_sym_DASH_DASHtarget,
      anon_sym_DASH_DASHplatform,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
    ACTIONS(855), 25,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_LPAREN2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
  [14770] = 5,
    ACTIONS(3), 1,
      sym_line_continuation,
    STATE(259), 1,
      aux_sym_variable_repeat1,
    ACTIONS(5), 4,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(828), 24,
      anon_sym_SLASH,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_SQUOTE,
      anon_sym_DASH_DASHmount,
      sym_no_cache,
      sym_privileged,
      anon_sym_DASH_DASHsecret,
      anon_sym_EQ4,
      sym_ssh,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
      sym_comment,
    ACTIONS(830), 24,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_EQ3,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
  [14835] = 4,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(916), 23,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_LPAREN3,
      sym_allow_privileged,
      anon_sym_DASH_DASHbuild_DASHarg,
      anon_sym_DASHf,
      anon_sym_DASH_DASHtarget,
      anon_sym_DASH_DASHplatform,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
    ACTIONS(918), 25,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_LPAREN2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
  [14898] = 7,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(2068), 1,
      sym__immediate_string_base_other,
    ACTIONS(2071), 2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
    STATE(389), 2,
      sym__immediate_string_base,
      aux_sym__immediate_string_base_repeat1,
    ACTIONS(5), 4,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(749), 22,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_SQUOTE,
      anon_sym_DASH_DASHmount,
      sym_no_cache,
      sym_privileged,
      anon_sym_DASH_DASHsecret,
      sym_ssh,
      anon_sym_DQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
      sym_comment,
    ACTIONS(751), 22,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      aux_sym__immediate_escape_sequence_token1,
  [14967] = 5,
    ACTIONS(3), 1,
      sym_line_continuation,
    STATE(252), 1,
      aux_sym_variable_repeat1,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(828), 23,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym_force,
      sym_if_exists,
      sym_keep_own,
      sym_keep_ts,
      sym_symlink_no_follow,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
    ACTIONS(830), 24,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
  [15032] = 10,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 1,
      sym_line_continuation_comment,
    ACTIONS(2080), 1,
      anon_sym_DOLLAR2,
    ACTIONS(2083), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(501), 1,
      sym__immediate_escape_sequence,
    ACTIONS(2077), 2,
      anon_sym_LPAREN2,
      sym__immediate_string_base_other,
    STATE(253), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(669), 7,
      anon_sym_LPAREN3,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
      sym_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(2074), 15,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(664), 21,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      anon_sym_NULL,
  [15107] = 10,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(2092), 1,
      anon_sym_DOLLAR2,
    ACTIONS(2095), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(536), 1,
      sym__immediate_escape_sequence,
    ACTIONS(2089), 2,
      anon_sym_DASH,
      sym__immediate_string_base_other,
    ACTIONS(685), 3,
      sym_allow_privileged,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
    STATE(272), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(2086), 15,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(680), 21,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
  [15182] = 4,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(935), 23,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_LPAREN3,
      sym_allow_privileged,
      anon_sym_DASH_DASHbuild_DASHarg,
      anon_sym_DASHf,
      anon_sym_DASH_DASHtarget,
      anon_sym_DASH_DASHplatform,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
    ACTIONS(937), 25,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_LPAREN2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
  [15245] = 10,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 1,
      sym_line_continuation_comment,
    ACTIONS(2104), 1,
      anon_sym_DOLLAR2,
    ACTIONS(2107), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(510), 1,
      sym__immediate_escape_sequence,
    ACTIONS(2101), 2,
      sym__immediate_string_base_other,
      sym__immediate_string_base_alpha,
    STATE(248), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(669), 7,
      anon_sym_ASLOCAL,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
      sym_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(2098), 15,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(664), 21,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      anon_sym_NULL,
  [15320] = 6,
    ACTIONS(3), 1,
      sym_line_continuation,
    STATE(246), 1,
      aux_sym_variable_repeat1,
    ACTIONS(2110), 2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(821), 21,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym_allow_privileged,
      sym_auto_skip,
      anon_sym_DASH_DASHbuild_DASHarg,
      sym_pass_args,
      anon_sym_DASH_DASHplatform,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
    ACTIONS(823), 24,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
  [15387] = 10,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(2119), 1,
      anon_sym_DOLLAR2,
    ACTIONS(2122), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(536), 1,
      sym__immediate_escape_sequence,
    ACTIONS(2116), 2,
      anon_sym_DASH,
      sym__immediate_string_base_other,
    ACTIONS(705), 3,
      sym_allow_privileged,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
    STATE(247), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(2113), 15,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(700), 21,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
  [15462] = 10,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 1,
      sym_line_continuation_comment,
    ACTIONS(2131), 1,
      anon_sym_DOLLAR2,
    ACTIONS(2134), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(510), 1,
      sym__immediate_escape_sequence,
    ACTIONS(2128), 2,
      sym__immediate_string_base_other,
      sym__immediate_string_base_alpha,
    STATE(248), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(705), 7,
      anon_sym_ASLOCAL,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
      sym_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(2125), 15,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(700), 21,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      anon_sym_NULL,
  [15537] = 4,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(869), 23,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_LPAREN3,
      sym_allow_privileged,
      anon_sym_DASH_DASHbuild_DASHarg,
      anon_sym_DASHf,
      anon_sym_DASH_DASHtarget,
      anon_sym_DASH_DASHplatform,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
    ACTIONS(871), 25,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_LPAREN2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
  [15600] = 6,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 1,
      sym_line_continuation_comment,
    STATE(510), 1,
      sym__immediate_escape_sequence,
    STATE(248), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(693), 23,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_ASLOCAL,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
      sym_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(695), 24,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      sym__immediate_string_base_alpha,
      aux_sym__immediate_escape_sequence_token1,
      anon_sym_NULL,
  [15667] = 4,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(832), 23,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_LPAREN3,
      sym_allow_privileged,
      anon_sym_DASH_DASHbuild_DASHarg,
      anon_sym_DASHf,
      anon_sym_DASH_DASHtarget,
      anon_sym_DASH_DASHplatform,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
    ACTIONS(834), 25,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_LPAREN2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
  [15730] = 5,
    ACTIONS(3), 1,
      sym_line_continuation,
    STATE(267), 1,
      aux_sym_variable_repeat1,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(817), 23,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym_force,
      sym_if_exists,
      sym_keep_own,
      sym_keep_ts,
      sym_symlink_no_follow,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
    ACTIONS(819), 24,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
  [15795] = 10,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 1,
      sym_line_continuation_comment,
    ACTIONS(2143), 1,
      anon_sym_DOLLAR2,
    ACTIONS(2146), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(501), 1,
      sym__immediate_escape_sequence,
    ACTIONS(2140), 2,
      anon_sym_LPAREN2,
      sym__immediate_string_base_other,
    STATE(253), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(705), 7,
      anon_sym_LPAREN3,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
      sym_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(2137), 15,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(700), 21,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      anon_sym_NULL,
  [15870] = 4,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(873), 23,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_LPAREN3,
      sym_allow_privileged,
      anon_sym_DASH_DASHbuild_DASHarg,
      anon_sym_DASHf,
      anon_sym_DASH_DASHtarget,
      anon_sym_DASH_DASHplatform,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
    ACTIONS(875), 25,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_LPAREN2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
  [15933] = 4,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(902), 23,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_LPAREN3,
      sym_allow_privileged,
      anon_sym_DASH_DASHbuild_DASHarg,
      anon_sym_DASHf,
      anon_sym_DASH_DASHtarget,
      anon_sym_DASH_DASHplatform,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
    ACTIONS(904), 25,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_LPAREN2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
  [15996] = 5,
    ACTIONS(3), 1,
      sym_line_continuation,
    STATE(235), 1,
      aux_sym_variable_repeat1,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(828), 23,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym_allow_privileged,
      sym_auto_skip,
      anon_sym_DASH_DASHbuild_DASHarg,
      sym_pass_args,
      anon_sym_DASH_DASHplatform,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
    ACTIONS(830), 24,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
  [16061] = 5,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 1,
      sym_line_continuation_comment,
    STATE(261), 1,
      aux_sym_variable_repeat1,
    ACTIONS(819), 25,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
      anon_sym_NULL,
    ACTIONS(817), 26,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_DASH_DASHcache_DASHfrom,
      sym_cache_hint,
      sym_push,
      sym_without_earthly_labels,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
      sym_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
  [16126] = 4,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(898), 23,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_LPAREN3,
      sym_allow_privileged,
      anon_sym_DASH_DASHbuild_DASHarg,
      anon_sym_DASHf,
      anon_sym_DASH_DASHtarget,
      anon_sym_DASH_DASHplatform,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
    ACTIONS(900), 25,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_LPAREN2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
  [16189] = 5,
    ACTIONS(3), 1,
      sym_line_continuation,
    STATE(265), 1,
      aux_sym_variable_repeat1,
    ACTIONS(5), 4,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(817), 24,
      anon_sym_SLASH,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_SQUOTE,
      anon_sym_DASH_DASHmount,
      sym_no_cache,
      sym_privileged,
      anon_sym_DASH_DASHsecret,
      anon_sym_EQ4,
      sym_ssh,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
      sym_comment,
    ACTIONS(819), 24,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_EQ3,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
  [16254] = 6,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 1,
      sym_line_continuation_comment,
    STATE(501), 1,
      sym__immediate_escape_sequence,
    STATE(253), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(693), 23,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_LPAREN3,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
      sym_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(695), 24,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_LPAREN2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
      anon_sym_NULL,
  [16321] = 6,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 1,
      sym_line_continuation_comment,
    STATE(261), 1,
      aux_sym_variable_repeat1,
    ACTIONS(2149), 2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
    ACTIONS(821), 24,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_DASH_DASHcache_DASHfrom,
      sym_cache_hint,
      sym_push,
      sym_without_earthly_labels,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
      sym_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(823), 25,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
      anon_sym_NULL,
  [16388] = 7,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 1,
      sym_line_continuation_comment,
    ACTIONS(2152), 1,
      sym__immediate_string_base_other,
    STATE(262), 1,
      aux_sym__immediate_string_base_repeat1,
    ACTIONS(2155), 2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
    ACTIONS(807), 24,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_DASH_DASHcache_DASHfrom,
      sym_cache_hint,
      sym_push,
      sym_without_earthly_labels,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
      sym_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(809), 24,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      aux_sym__immediate_escape_sequence_token1,
      anon_sym_NULL,
  [16457] = 4,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(849), 23,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_LPAREN3,
      sym_allow_privileged,
      anon_sym_DASH_DASHbuild_DASHarg,
      anon_sym_DASHf,
      anon_sym_DASH_DASHtarget,
      anon_sym_DASH_DASHplatform,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
    ACTIONS(851), 25,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_LPAREN2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
  [16520] = 5,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 1,
      sym_line_continuation_comment,
    STATE(257), 1,
      aux_sym_variable_repeat1,
    ACTIONS(830), 25,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
      anon_sym_NULL,
    ACTIONS(828), 26,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_DASH_DASHcache_DASHfrom,
      sym_cache_hint,
      sym_push,
      sym_without_earthly_labels,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
      sym_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
  [16585] = 6,
    ACTIONS(3), 1,
      sym_line_continuation,
    STATE(265), 1,
      aux_sym_variable_repeat1,
    ACTIONS(2158), 2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
    ACTIONS(5), 4,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(821), 22,
      anon_sym_SLASH,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_SQUOTE,
      anon_sym_DASH_DASHmount,
      sym_no_cache,
      sym_privileged,
      anon_sym_DASH_DASHsecret,
      anon_sym_EQ4,
      sym_ssh,
      anon_sym_DQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
      sym_comment,
    ACTIONS(823), 24,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_EQ3,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
  [16652] = 4,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(931), 23,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_LPAREN3,
      sym_allow_privileged,
      anon_sym_DASH_DASHbuild_DASHarg,
      anon_sym_DASHf,
      anon_sym_DASH_DASHtarget,
      anon_sym_DASH_DASHplatform,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
    ACTIONS(933), 25,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_LPAREN2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
  [16715] = 6,
    ACTIONS(3), 1,
      sym_line_continuation,
    STATE(267), 1,
      aux_sym_variable_repeat1,
    ACTIONS(2161), 2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(821), 21,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym_force,
      sym_if_exists,
      sym_keep_own,
      sym_keep_ts,
      sym_symlink_no_follow,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
    ACTIONS(823), 24,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
  [16782] = 10,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 1,
      sym_line_continuation_comment,
    ACTIONS(2170), 1,
      anon_sym_DOLLAR2,
    ACTIONS(2173), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(510), 1,
      sym__immediate_escape_sequence,
    ACTIONS(2167), 2,
      sym__immediate_string_base_other,
      sym__immediate_string_base_alpha,
    STATE(245), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(685), 7,
      anon_sym_ASLOCAL,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
      sym_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(2164), 15,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(680), 21,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      anon_sym_NULL,
  [16857] = 4,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(861), 23,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_LPAREN3,
      sym_allow_privileged,
      anon_sym_DASH_DASHbuild_DASHarg,
      anon_sym_DASHf,
      anon_sym_DASH_DASHtarget,
      anon_sym_DASH_DASHplatform,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
    ACTIONS(863), 25,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_LPAREN2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
  [16920] = 4,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(912), 23,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_LPAREN3,
      sym_allow_privileged,
      anon_sym_DASH_DASHbuild_DASHarg,
      anon_sym_DASHf,
      anon_sym_DASH_DASHtarget,
      anon_sym_DASH_DASHplatform,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
    ACTIONS(914), 25,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_LPAREN2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
  [16983] = 16,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 1,
      sym_line_continuation_comment,
    ACTIONS(680), 1,
      anon_sym_SQUOTE,
    ACTIONS(685), 1,
      anon_sym_DQUOTE2,
    ACTIONS(2189), 1,
      sym__immediate_string_base_other,
    ACTIONS(2195), 1,
      anon_sym_DOLLAR2,
    ACTIONS(2198), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(588), 1,
      sym__immediate_escape_sequence,
    STATE(993), 1,
      aux_sym_image_name_repeat1,
    ACTIONS(2185), 2,
      anon_sym_COLON2,
      anon_sym_AT2,
    STATE(329), 2,
      sym__immediate_expansion,
      aux_sym_unquoted_string_repeat1,
    STATE(587), 2,
      sym__immediate_string_base,
      aux_sym__immediate_string_base_repeat1,
    ACTIONS(2176), 5,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_DASH,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
    ACTIONS(2192), 5,
      anon_sym_SQUOTE2,
      sym_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(2182), 9,
      anon_sym_EQ3,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_PLUS2,
    ACTIONS(2179), 20,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      anon_sym_NULL,
  [17070] = 10,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(2208), 1,
      anon_sym_DOLLAR2,
    ACTIONS(2211), 1,
      aux_sym__immediate_escape_sequence_token1,
    STATE(536), 1,
      sym__immediate_escape_sequence,
    ACTIONS(2205), 2,
      anon_sym_DASH,
      sym__immediate_string_base_other,
    ACTIONS(669), 3,
      sym_allow_privileged,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
    STATE(247), 4,
      sym__immediate_string_base,
      sym__immediate_expansion,
      aux_sym__immediate_string_base_repeat1,
      aux_sym_unquoted_string_repeat1,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(2202), 15,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_PLUS2,
    ACTIONS(664), 21,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
  [17145] = 7,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(2214), 1,
      sym__immediate_string_base_other,
    STATE(273), 1,
      aux_sym__immediate_string_base_repeat1,
    ACTIONS(2217), 2,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(807), 21,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym_allow_privileged,
      sym_auto_skip,
      anon_sym_DASH_DASHbuild_DASHarg,
      sym_pass_args,
      anon_sym_DASH_DASHplatform,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
    ACTIONS(809), 23,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      aux_sym__immediate_escape_sequence_token1,
  [17214] = 4,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 5,
      sym_comment,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(849), 23,
      anon_sym_SLASH,
      anon_sym_EQ3,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      sym_force,
      sym_if_exists,
      sym_keep_own,
      sym_keep_ts,
      sym_symlink_no_follow,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_SQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
    ACTIONS(851), 24,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
  [17276] = 4,
    ACTIONS(3), 1,
      sym_line_continuation,
    ACTIONS(5), 4,
      sym_line_continuation_comment,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_FF,
    ACTIONS(920), 24,
      anon_sym_SLASH,
      anon_sym_COLON2,
      anon_sym_DOT,
      anon_sym_LPAREN2,
      anon_sym_RPAREN2,
      anon_sym_LBRACK2,
      anon_sym_RBRACK2,
      anon_sym_LBRACE2,
      anon_sym_RBRACE2,
      anon_sym_COMMA2,
      anon_sym_AT2,
      anon_sym_SQUOTE,
      anon_sym_DASH_DASHmount,
      sym_no_cache,
      sym_privileged,
      anon_sym_DASH_DASHsecret,
      anon_sym_EQ4,
      sym_ssh,
      sym__immediate_string_base_alpha,
      sym__immediate_string_base_num,
      anon_sym_DQUOTE2,
      anon_sym_PLUS2,
      anon_sym_DOLLAR2,
      sym_comment,
    ACTIONS(922), 24,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_EQ3,
      anon_sym_DASH,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH2,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT2,
      anon_sym_DASH2,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_DQUOTE,
      aux_sym_unknown_option_token1,
      sym__string_base_other,
      sym__string_base_alpha,
      sym__string_base_num,
      sym__immediate_string_base_other,
      aux_sym__immediate_escape_sequence_token1,
  [17338] = 4,
    ACTIONS(3), 1,
 