#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize ("O0")
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 3219
#define LARGE_STATE_COUNT 122
#define SYMBOL_COUNT 909
#define ALIAS_COUNT 8
#define TOKEN_COUNT 619
#define EXTERNAL_TOKEN_COUNT 110
#define FIELD_COUNT 34
#define MAX_ALIAS_SEQUENCE_LENGTH 9
#define PRODUCTION_ID_COUNT 125

enum ts_symbol_identifiers {
  sym_keyword = 1,
  anon_sym_COLON = 2,
  anon_sym_a_COLON = 3,
  aux_sym_normal_statement_token1 = 4,
  sym_filetype = 5,
  aux_sym__filetype_immediate_token1 = 6,
  anon_sym_DOT = 7,
  anon_sym_FALLBACK = 8,
  anon_sym_dos = 9,
  anon_sym_unix = 10,
  anon_sym_mac = 11,
  anon_sym_latin1 = 12,
  anon_sym_iso = 13,
  anon_sym_koi8 = 14,
  anon_sym_macroman = 15,
  anon_sym_cp437 = 16,
  anon_sym_cp737 = 17,
  anon_sym_cp775 = 18,
  anon_sym_cp850 = 19,
  anon_sym_cp852 = 20,
  anon_sym_cp855 = 21,
  anon_sym_cp857 = 22,
  anon_sym_cp860 = 23,
  anon_sym_cp861 = 24,
  anon_sym_cp862 = 25,
  anon_sym_cp863 = 26,
  anon_sym_cp865 = 27,
  anon_sym_cp866 = 28,
  anon_sym_cp869 = 29,
  anon_sym_cp874 = 30,
  anon_sym_cp1250 = 31,
  anon_sym_cp1251 = 32,
  anon_sym_cp1253 = 33,
  anon_sym_cp1254 = 34,
  anon_sym_cp1255 = 35,
  anon_sym_cp1256 = 36,
  anon_sym_cp1257 = 37,
  anon_sym_cp1258 = 38,
  anon_sym_cp932 = 39,
  anon_sym_euc_DASHjp = 40,
  anon_sym_sjis = 41,
  anon_sym_cp949 = 42,
  anon_sym_euc_DASHkr = 43,
  anon_sym_cp936 = 44,
  anon_sym_euc_DASHcn = 45,
  anon_sym_cp950 = 46,
  anon_sym_big5 = 47,
  anon_sym_euc_DASHtw = 48,
  anon_sym_utf_DASH8 = 49,
  anon_sym_ucs_DASH2 = 50,
  anon_sym_ucs_DASH21e = 51,
  anon_sym_utf_DASH16 = 52,
  anon_sym_utf_DASH16le = 53,
  anon_sym_ucs_DASH4 = 54,
  anon_sym_ucs_DASH4le = 55,
  anon_sym_ansi = 56,
  anon_sym_japan = 57,
  anon_sym_korea = 58,
  anon_sym_prc = 59,
  anon_sym_chinese = 60,
  anon_sym_taiwan = 61,
  anon_sym_utf8 = 62,
  anon_sym_unicode = 63,
  anon_sym_ucs2be = 64,
  anon_sym_ucs_DASH2be = 65,
  anon_sym_ucs_DASH4be = 66,
  anon_sym_utf_DASH32 = 67,
  anon_sym_utf_DASH32le = 68,
  anon_sym_default = 69,
  anon_sym_latin12 = 70,
  anon_sym_iso2 = 71,
  anon_sym_koi82 = 72,
  anon_sym_macroman2 = 73,
  anon_sym_cp4372 = 74,
  anon_sym_cp7372 = 75,
  anon_sym_cp7752 = 76,
  anon_sym_cp8502 = 77,
  anon_sym_cp8522 = 78,
  anon_sym_cp8552 = 79,
  anon_sym_cp8572 = 80,
  anon_sym_cp8602 = 81,
  anon_sym_cp8612 = 82,
  anon_sym_cp8622 = 83,
  anon_sym_cp8632 = 84,
  anon_sym_cp8652 = 85,
  anon_sym_cp8662 = 86,
  anon_sym_cp8692 = 87,
  anon_sym_cp8742 = 88,
  anon_sym_cp12502 = 89,
  anon_sym_cp12512 = 90,
  anon_sym_cp12532 = 91,
  anon_sym_cp12542 = 92,
  anon_sym_cp12552 = 93,
  anon_sym_cp12562 = 94,
  anon_sym_cp12572 = 95,
  anon_sym_cp12582 = 96,
  anon_sym_cp9322 = 97,
  anon_sym_euc_DASHjp2 = 98,
  anon_sym_sjis2 = 99,
  anon_sym_cp9492 = 100,
  anon_sym_euc_DASHkr2 = 101,
  anon_sym_cp9362 = 102,
  anon_sym_euc_DASHcn2 = 103,
  anon_sym_cp9502 = 104,
  anon_sym_big52 = 105,
  anon_sym_euc_DASHtw2 = 106,
  anon_sym_utf_DASH82 = 107,
  anon_sym_ucs_DASH22 = 108,
  anon_sym_ucs_DASH21e2 = 109,
  anon_sym_utf_DASH162 = 110,
  anon_sym_utf_DASH16le2 = 111,
  anon_sym_ucs_DASH42 = 112,
  anon_sym_ucs_DASH4le2 = 113,
  anon_sym_ansi2 = 114,
  anon_sym_japan2 = 115,
  anon_sym_korea2 = 116,
  anon_sym_prc2 = 117,
  anon_sym_chinese2 = 118,
  anon_sym_taiwan2 = 119,
  anon_sym_utf82 = 120,
  anon_sym_unicode2 = 121,
  anon_sym_ucs2be2 = 122,
  anon_sym_ucs_DASH2be2 = 123,
  anon_sym_ucs_DASH4be2 = 124,
  anon_sym_utf_DASH322 = 125,
  anon_sym_utf_DASH32le2 = 126,
  anon_sym_default2 = 127,
  anon_sym_START = 128,
  anon_sym_OPT = 129,
  anon_sym_PACK = 130,
  anon_sym_ALL = 131,
  aux_sym_wincmd_statement_token1 = 132,
  anon_sym_on = 133,
  anon_sym_off = 134,
  anon_sym_detect = 135,
  anon_sym_plugin = 136,
  anon_sym_indent = 137,
  sym_chunk = 138,
  sym__heredoc_line = 139,
  anon_sym_LT_LT = 140,
  anon_sym_LF = 141,
  anon_sym_in = 142,
  aux_sym__au_pattern_token1 = 143,
  aux_sym__au_pattern_token2 = 144,
  aux_sym__bang_filter_command_argument_token1 = 145,
  anon_sym_BSLASH = 146,
  aux_sym__bang_filter_command_argument_token2 = 147,
  aux_sym__bang_filter_command_argument_token3 = 148,
  aux_sym__bang_filter_command_argument_token4 = 149,
  aux_sym_argument_token1 = 150,
  aux_sym_argument_token2 = 151,
  anon_sym_LBRACE = 152,
  anon_sym_RBRACE = 153,
  anon_sym_LBRACE2 = 154,
  aux_sym_identifier_token1 = 155,
  aux_sym_identifier_token2 = 156,
  aux_sym__immediate_identifier_token1 = 157,
  anon_sym_EQ = 158,
  anon_sym_PLUS_EQ = 159,
  anon_sym_DASH_EQ = 160,
  anon_sym_STAR_EQ = 161,
  anon_sym_SLASH_EQ = 162,
  anon_sym_PERCENT_EQ = 163,
  anon_sym_DOT_EQ = 164,
  anon_sym_DOT_DOT_EQ = 165,
  anon_sym_EQ_LT_LT = 166,
  anon_sym_trim = 167,
  anon_sym_eval = 168,
  aux_sym_option_name_token1 = 169,
  anon_sym_t_ = 170,
  aux_sym_option_name_token2 = 171,
  anon_sym_BANG = 172,
  anon_sym_AMP = 173,
  anon_sym_vi = 174,
  anon_sym_vim = 175,
  anon_sym_all = 176,
  anon_sym_all_AMP = 177,
  anon_sym_QMARK = 178,
  anon_sym_EQ2 = 179,
  anon_sym_COLON2 = 180,
  anon_sym_PLUS_EQ2 = 181,
  anon_sym_CARET_EQ = 182,
  anon_sym_DASH_EQ2 = 183,
  sym_set_value = 184,
  anon_sym_SPACE = 185,
  aux_sym_command_argument_token1 = 186,
  anon_sym_dict = 187,
  anon_sym_range = 188,
  anon_sym_abort = 189,
  anon_sym_closure = 190,
  anon_sym_LPAREN = 191,
  anon_sym_COMMA = 192,
  anon_sym_RPAREN = 193,
  anon_sym_AT = 194,
  sym_spread = 195,
  sym__printable = 196,
  sym_mark = 197,
  anon_sym_PERCENT = 198,
  anon_sym_SEMI = 199,
  anon_sym_SLASH = 200,
  anon_sym_SLASH2 = 201,
  anon_sym_QMARK2 = 202,
  anon_sym_DOT2 = 203,
  anon_sym_PLUS = 204,
  anon_sym_DOLLAR = 205,
  anon_sym_BSLASH_SLASH = 206,
  anon_sym_BSLASH_QMARK = 207,
  anon_sym_BSLASH_AMP = 208,
  anon_sym_LTbuffer_GT = 209,
  anon_sym_LTnowait_GT = 210,
  anon_sym_LTsilent_GT = 211,
  anon_sym_LTunique_GT = 212,
  anon_sym_LTscript_GT = 213,
  anon_sym_LTexpr_GT = 214,
  sym__keycode_modifier = 215,
  aux_sym__keycode_in_token1 = 216,
  aux_sym__keycode_in_token2 = 217,
  aux_sym__keycode_in_token3 = 218,
  aux_sym__keycode_in_token4 = 219,
  aux_sym__keycode_in_token5 = 220,
  aux_sym__keycode_in_token6 = 221,
  aux_sym__keycode_in_token7 = 222,
  aux_sym__keycode_in_token8 = 223,
  aux_sym__keycode_in_token9 = 224,
  aux_sym__keycode_in_token10 = 225,
  aux_sym__keycode_in_token11 = 226,
  aux_sym__keycode_in_token12 = 227,
  aux_sym__keycode_in_token13 = 228,
  aux_sym__keycode_in_token14 = 229,
  aux_sym__keycode_in_token15 = 230,
  aux_sym__keycode_in_token16 = 231,
  aux_sym__keycode_in_token17 = 232,
  aux_sym__keycode_in_token18 = 233,
  aux_sym__keycode_in_token19 = 234,
  aux_sym__keycode_in_token20 = 235,
  aux_sym__keycode_in_token21 = 236,
  aux_sym__keycode_in_token22 = 237,
  aux_sym__keycode_in_token23 = 238,
  aux_sym__keycode_in_token24 = 239,
  aux_sym__keycode_in_token25 = 240,
  aux_sym__keycode_in_token26 = 241,
  aux_sym__keycode_in_token27 = 242,
  aux_sym__keycode_in_token28 = 243,
  aux_sym__keycode_in_token29 = 244,
  aux_sym__keycode_in_token30 = 245,
  aux_sym__keycode_in_token31 = 246,
  aux_sym__keycode_in_token32 = 247,
  aux_sym__keycode_in_token33 = 248,
  aux_sym__keycode_in_token34 = 249,
  aux_sym__keycode_in_token35 = 250,
  aux_sym__keycode_in_token36 = 251,
  aux_sym__keycode_in_token37 = 252,
  aux_sym__keycode_in_token38 = 253,
  aux_sym__keycode_in_token39 = 254,
  aux_sym__keycode_in_token40 = 255,
  aux_sym__keycode_in_token41 = 256,
  aux_sym__keycode_in_token42 = 257,
  aux_sym__keycode_in_token43 = 258,
  anon_sym_LT = 259,
  anon_sym_GT = 260,
  anon_sym_LT2 = 261,
  anon_sym_BSLASH2 = 262,
  aux_sym__map_lhs_token1 = 263,
  aux_sym__map_rhs_statement_token1 = 264,
  anon_sym_BSLASH_PIPE = 265,
  aux_sym__map_rhs_statement_token2 = 266,
  aux_sym__map_rhs_statement_token3 = 267,
  aux_sym__map_rhs_token1 = 268,
  aux_sym__map_rhs_token2 = 269,
  anon_sym_icon = 270,
  anon_sym_linehl = 271,
  anon_sym_numhl = 272,
  anon_sym_text = 273,
  anon_sym_texthl = 274,
  anon_sym_culhl = 275,
  anon_sym_define = 276,
  anon_sym_undefine = 277,
  anon_sym_list = 278,
  anon_sym_line = 279,
  anon_sym_name = 280,
  anon_sym_buffer = 281,
  anon_sym_group = 282,
  anon_sym_priority = 283,
  anon_sym_file = 284,
  anon_sym_STAR = 285,
  anon_sym_place = 286,
  anon_sym_STAR2 = 287,
  anon_sym_unplace = 288,
  anon_sym_jump = 289,
  anon_sym_POUND = 290,
  anon_sym_PIPE_PIPE = 291,
  anon_sym_AMP_AMP = 292,
  anon_sym_DASH = 293,
  anon_sym_DOT_DOT = 294,
  anon_sym_EQ_EQ = 295,
  anon_sym_BANG_EQ = 296,
  anon_sym_GT2 = 297,
  anon_sym_GT_EQ = 298,
  anon_sym_LT_EQ = 299,
  anon_sym_EQ_TILDE = 300,
  anon_sym_BANG_TILDE = 301,
  anon_sym_is = 302,
  anon_sym_isnot = 303,
  anon_sym_BANG2 = 304,
  sym_float_literal = 305,
  sym_integer_literal = 306,
  anon_sym_LBRACK = 307,
  anon_sym_RBRACK = 308,
  anon_sym_LPAREN2 = 309,
  anon_sym_DASH_GT = 310,
  aux_sym_filename_token1 = 311,
  aux_sym_filename_token2 = 312,
  aux_sym_filename_token3 = 313,
  aux_sym_filename_token4 = 314,
  aux_sym_filename_token5 = 315,
  aux_sym_filename_token6 = 316,
  aux_sym_filename_token7 = 317,
  aux_sym_filename_token8 = 318,
  aux_sym_pattern_multi_token1 = 319,
  aux_sym_pattern_multi_token2 = 320,
  aux_sym_pattern_multi_token3 = 321,
  aux_sym__pattern_ordinary_atom_token1 = 322,
  aux_sym__pattern_ordinary_atom_token2 = 323,
  anon_sym_BSLASH_LPAREN = 324,
  anon_sym_BSLASH_RPAREN = 325,
  anon_sym_BSLASH_PERCENT_LPAREN = 326,
  anon_sym_BSLASHz_LPAREN = 327,
  sym_register = 328,
  sym_literal_key = 329,
  anon_sym_POUND_LBRACE = 330,
  anon_sym_keep = 331,
  anon_sym_drop = 332,
  anon_sym_PLUS_PLUS = 333,
  anon_sym_ff = 334,
  anon_sym_fileformat = 335,
  anon_sym_enc = 336,
  anon_sym_encoding = 337,
  anon_sym_bin = 338,
  anon_sym_binary = 339,
  anon_sym_nobin = 340,
  anon_sym_nobinary = 341,
  anon_sym_bad = 342,
  anon_sym_edit = 343,
  aux_sym__plus_cmd_arg_token1 = 344,
  sym_au_event = 345,
  aux_sym__autocmd_pattern_token1 = 346,
  sym_au_once = 347,
  sym_au_nested = 348,
  sym_command_name = 349,
  anon_sym_arglist = 350,
  anon_sym_augroup = 351,
  anon_sym_buffer2 = 352,
  anon_sym_behave = 353,
  anon_sym_color = 354,
  anon_sym_command = 355,
  anon_sym_compiler = 356,
  anon_sym_dir = 357,
  anon_sym_environment = 358,
  anon_sym_even = 359,
  anon_sym_expression = 360,
  anon_sym_file2 = 361,
  anon_sym_file_in_path = 362,
  anon_sym_filetype = 363,
  anon_sym_function = 364,
  anon_sym_help = 365,
  anon_sym_highlight = 366,
  anon_sym_history = 367,
  anon_sym_local = 368,
  anon_sym_lua = 369,
  anon_sym_mapclear = 370,
  anon_sym_mapping = 371,
  anon_sym_menu = 372,
  anon_sym_messages = 373,
  anon_sym_option = 374,
  anon_sym_packadd = 375,
  anon_sym_shellcmd = 376,
  anon_sym_sign = 377,
  anon_sym_syntax = 378,
  anon_sym_syntime = 379,
  anon_sym_tag = 380,
  anon_sym_tag_listfiles = 381,
  anon_sym_user = 382,
  anon_sym_var = 383,
  anon_sym_custom = 384,
  anon_sym_COMMA2 = 385,
  anon_sym_customlist = 386,
  anon_sym_lines = 387,
  anon_sym_arguments = 388,
  anon_sym_buffers = 389,
  anon_sym_loaded_buffers = 390,
  anon_sym_windows = 391,
  anon_sym_tabs = 392,
  anon_sym_quickfix = 393,
  anon_sym_other = 394,
  aux_sym__command_attribute_nargs_value_token1 = 395,
  aux_sym__command_attribute_nargs_value_token2 = 396,
  anon_sym_PERCENT2 = 397,
  anon_sym_DASHnargs = 398,
  anon_sym_DASHcomplete = 399,
  anon_sym_DASHrange = 400,
  anon_sym_DASHcount = 401,
  anon_sym_DASHaddr = 402,
  anon_sym_DASHbang = 403,
  anon_sym_DASHbar = 404,
  anon_sym_DASHregister = 405,
  anon_sym_DASHbuffer = 406,
  anon_sym_DASHkeepscript = 407,
  aux_sym_command_statement_token1 = 408,
  sym_hl_group = 409,
  anon_sym_link = 410,
  anon_sym_clear = 411,
  anon_sym_NONE = 412,
  anon_sym_NONE2 = 413,
  anon_sym_bold = 414,
  anon_sym_underline = 415,
  anon_sym_undercurl = 416,
  anon_sym_underdouble = 417,
  anon_sym_underdotted = 418,
  anon_sym_underdashed = 419,
  anon_sym_strikethrough = 420,
  anon_sym_reverse = 421,
  anon_sym_inverse = 422,
  anon_sym_italic = 423,
  anon_sym_standout = 424,
  anon_sym_nocombine = 425,
  anon_sym_term = 426,
  anon_sym_cterm = 427,
  aux_sym__hl_term_list_token1 = 428,
  anon_sym_start = 429,
  anon_sym_stop = 430,
  sym__hl_color_nr = 431,
  anon_sym_ctermfg = 432,
  anon_sym_ctermbg = 433,
  anon_sym_gui = 434,
  anon_sym_SQUOTE = 435,
  aux_sym__hl_quoted_name_token1 = 436,
  anon_sym_SQUOTE2 = 437,
  anon_sym_bg = 438,
  anon_sym_background = 439,
  anon_sym_fg = 440,
  anon_sym_foreground = 441,
  aux_sym_color_token1 = 442,
  aux_sym_color_token2 = 443,
  anon_sym_guifg = 444,
  anon_sym_guibg = 445,
  anon_sym_guisp = 446,
  aux_sym_font_token1 = 447,
  anon_sym_font = 448,
  anon_sym_blend = 449,
  anon_sym_enable = 450,
  anon_sym_reset = 451,
  anon_sym_case = 452,
  anon_sym_match = 453,
  anon_sym_ignore = 454,
  anon_sym_spell = 455,
  anon_sym_toplevel = 456,
  anon_sym_notoplevel = 457,
  anon_sym_foldlevel = 458,
  anon_sym_minimum = 459,
  anon_sym_iskeyword = 460,
  aux_sym__syn_iskeyword_token1 = 461,
  anon_sym_conceal = 462,
  anon_sym_cchar = 463,
  anon_sym_contained = 464,
  anon_sym_containedin = 465,
  anon_sym_nextgroup = 466,
  anon_sym_transparent = 467,
  anon_sym_skipwhite = 468,
  anon_sym_skipnl = 469,
  anon_sym_skipempty = 470,
  anon_sym_contains = 471,
  anon_sym_fold = 472,
  anon_sym_display = 473,
  anon_sym_extend = 474,
  anon_sym_keepend = 475,
  anon_sym_excludenl = 476,
  anon_sym_matchgroup = 477,
  anon_sym_oneline = 478,
  anon_sym_concealends = 479,
  anon_sym_add = 480,
  anon_sym_remove = 481,
  anon_sym_ms = 482,
  anon_sym_me = 483,
  anon_sym_hs = 484,
  anon_sym_he = 485,
  anon_sym_rs = 486,
  anon_sym_re = 487,
  anon_sym_lc = 488,
  aux_sym__syn_pattern_offset_token1 = 489,
  aux_sym__syn_pattern_offset_token2 = 490,
  anon_sym_keyword = 491,
  aux_sym__syn_keyword_token1 = 492,
  anon_sym_skip = 493,
  anon_sym_end = 494,
  anon_sym_region = 495,
  anon_sym_cluster = 496,
  anon_sym_include = 497,
  anon_sym_minlines = 498,
  anon_sym_maxlines = 499,
  aux_sym__syn_sync_lines_token1 = 500,
  anon_sym_sync = 501,
  anon_sym_linebreaks = 502,
  anon_sym_fromstart = 503,
  anon_sym_ccomment = 504,
  anon_sym_lines2 = 505,
  anon_sym_grouphere = 506,
  anon_sym_groupthere = 507,
  anon_sym_linecont = 508,
  sym__no = 509,
  sym__inv = 510,
  sym__newline_or_pipe = 511,
  sym__line_continuation = 512,
  sym__script_heredoc_marker = 513,
  sym__let_heredoc_marker = 514,
  sym__heredoc_end = 515,
  sym__separator_first = 516,
  sym__separator = 517,
  sym__scope_dict = 518,
  sym_scope = 519,
  sym_string_literal = 520,
  sym_comment = 521,
  sym_line_continuation_comment = 522,
  sym__bang_filter = 523,
  sym__function = 524,
  sym__endfunction = 525,
  sym__for = 526,
  sym__endfor = 527,
  sym__while = 528,
  sym__endwhile = 529,
  sym__if = 530,
  sym__elseif = 531,
  sym__else = 532,
  sym__endif = 533,
  sym__try = 534,
  sym__catch = 535,
  sym__cnext = 536,
  sym__cprevious = 537,
  sym__cNext = 538,
  sym__finally = 539,
  sym__endtry = 540,
  sym__const = 541,
  sym__normal = 542,
  sym__return = 543,
  sym__perl = 544,
  sym__lua = 545,
  sym__ruby = 546,
  sym__python = 547,
  sym__throw = 548,
  sym__execute = 549,
  sym__autocmd = 550,
  sym__silent = 551,
  sym__echo = 552,
  sym__echon = 553,
  sym__echohl = 554,
  sym__echomsg = 555,
  sym__echoerr = 556,
  sym__map = 557,
  sym__nmap = 558,
  sym__vmap = 559,
  sym__xmap = 560,
  sym__smap = 561,
  sym__omap = 562,
  sym__imap = 563,
  sym__lmap = 564,
  sym__cmap = 565,
  sym__tmap = 566,
  sym__noremap = 567,
  sym__nnoremap = 568,
  sym__vnoremap = 569,
  sym__xnoremap = 570,
  sym__snoremap = 571,
  sym__onoremap = 572,
  sym__inoremap = 573,
  sym__lnoremap = 574,
  sym__cnoremap = 575,
  sym__tnoremap = 576,
  sym__augroup = 577,
  sym__highlight = 578,
  sym__default = 579,
  sym__syntax = 580,
  sym__set = 581,
  sym__setlocal = 582,
  sym__setfiletype = 583,
  sym__browse = 584,
  sym__options = 585,
  sym__startinsert = 586,
  sym__stopinsert = 587,
  sym__scriptencoding = 588,
  sym__source = 589,
  sym__global = 590,
  sym__colorscheme = 591,
  sym__command = 592,
  sym__comclear = 593,
  sym__delcommand = 594,
  sym__runtime = 595,
  sym__wincmd = 596,
  sym__sign = 597,
  sym__filetype = 598,
  sym__let = 599,
  sym__unlet = 600,
  sym__call = 601,
  sym__break = 602,
  sym__continue = 603,
  sym__vertical = 604,
  sym__leftabove = 605,
  sym__aboveleft = 606,
  sym__rightbelow = 607,
  sym__belowright = 608,
  sym__topleft = 609,
  sym__botright = 610,
  sym__edit = 611,
  sym__enew = 612,
  sym__find = 613,
  sym__ex = 614,
  sym__visual = 615,
  sym__view = 616,
  sym__eval = 617,
  sym_unknown_command_name = 618,
  sym_script_file = 619,
  sym__cmd_separator = 620,
  aux_sym__separated_statements = 621,
  sym__statement = 622,
  sym_unknown_builtin_statement = 623,
  sym_return_statement = 624,
  sym_break_statement = 625,
  sym_continue_statement = 626,
  sym_scope_dict = 627,
  sym_normal_statement = 628,
  sym__filetype_immediate = 629,
  sym_filetypes = 630,
  sym_setfiletype_statement = 631,
  sym_options_statement = 632,
  sym_startinsert_statement = 633,
  sym_stopinsert_statement = 634,
  sym__immediate_file_format = 635,
  sym_encoding = 636,
  sym__immediate_encoding = 637,
  sym_scriptencoding_statement = 638,
  sym_cnext_statement = 639,
  sym_cprevious_statement = 640,
  sym__runtime_where = 641,
  sym_runtime_statement = 642,
  sym_wincmd_statement = 643,
  sym_source_statement = 644,
  sym_global_statement = 645,
  sym__filetype_state = 646,
  sym__filetype_enable = 647,
  sym__filetype_detect = 648,
  sym__filetype_plugin = 649,
  sym__filetype_indent = 650,
  sym_filetype_statement = 651,
  sym_colorscheme_statement = 652,
  sym_lua_statement = 653,
  sym_ruby_statement = 654,
  sym_python_statement = 655,
  sym_perl_statement = 656,
  sym_script = 657,
  sym_for_loop = 658,
  sym_while_loop = 659,
  sym_if_statement = 660,
  sym_elseif_statement = 661,
  sym_else_statement = 662,
  sym_try_statement = 663,
  sym__au_pattern = 664,
  sym_catch_statement = 665,
  sym_finally_statement = 666,
  sym_throw_statement = 667,
  sym__bang_filter_bangs = 668,
  sym__bang_filter_command_argument = 669,
  sym__bang_filter_command = 670,
  sym_bang_filter_statement = 671,
  sym_scoped_identifier = 672,
  sym_argument = 673,
  sym__curly_braces_name_expression = 674,
  sym__immediate_curly_braces_name_expression = 675,
  sym_identifier = 676,
  sym__immediate_identifier = 677,
  sym__ident = 678,
  sym__let_operator = 679,
  sym__assignment_variable = 680,
  sym__let_assignment = 681,
  sym_let_statement = 682,
  sym__const_assignment = 683,
  sym_const_statement = 684,
  sym__let_heredoc = 685,
  sym__let_heredoc_parameter = 686,
  sym_option_name = 687,
  sym_no_option = 688,
  sym_inv_option = 689,
  sym_default_option = 690,
  sym__set_option = 691,
  sym__set_operator = 692,
  sym__set_rhs = 693,
  sym_set_item = 694,
  sym_set_statement = 695,
  sym_setlocal_statement = 696,
  sym_unlet_statement = 697,
  sym_call_statement = 698,
  sym_echo_statement = 699,
  sym_echon_statement = 700,
  sym_echohl_statement = 701,
  sym_echomsg_statement = 702,
  sym_echoerr_statement = 703,
  sym_execute_statement = 704,
  sym_silent_statement = 705,
  sym_vertical_statement = 706,
  sym_topleft_statement = 707,
  sym_botright_statement = 708,
  sym_aboveleft_statement = 709,
  sym_belowright_statement = 710,
  sym_user_command = 711,
  sym_command_argument = 712,
  sym_function_definition = 713,
  sym_function_declaration = 714,
  sym_parameters = 715,
  sym_default_parameter = 716,
  sym_bang = 717,
  sym_range_statement = 718,
  sym__range = 719,
  sym__range_explicit = 720,
  sym__range_marker = 721,
  sym_current_line = 722,
  sym_next_line = 723,
  sym_last_line = 724,
  sym_previous_pattern = 725,
  sym_register_statement = 726,
  sym_map_statement = 727,
  sym__map_definition = 728,
  sym__keycode_in = 729,
  sym__immediate_keycode = 730,
  sym_keycode = 731,
  sym__map_lhs = 732,
  sym__map_rhs_statement = 733,
  sym__map_rhs = 734,
  sym__sign_name = 735,
  sym__sign_define_arg_text = 736,
  sym__sign_define_argument = 737,
  sym__sign_define = 738,
  sym__sign_undefine = 739,
  sym__sign_list = 740,
  sym__sign_place_place_argument = 741,
  sym__sign_place_place = 742,
  sym__sign_place_list_argument = 743,
  aux_sym__sign_place_list = 744,
  sym__sign_place = 745,
  sym__sign_unplace_cursor_argument = 746,
  sym__sign_unplace_cursor = 747,
  sym__sign_unplace_id_argument = 748,
  sym__sign_unplace_id = 749,
  sym__sign_unplace = 750,
  sym__sign_jump_argument = 751,
  sym__sign_jump = 752,
  sym_sign_statement = 753,
  sym__variable = 754,
  sym__expression = 755,
  sym_ternary_expression = 756,
  sym_match_case = 757,
  sym_binary_operation = 758,
  sym_unary_operation = 759,
  sym_list = 760,
  sym_list_assignment = 761,
  sym_index_expression = 762,
  sym_slice_expression = 763,
  sym_field_expression = 764,
  sym_call_expression = 765,
  sym_eval_statement = 766,
  sym__method_call_expression = 767,
  sym_method_expression = 768,
  sym_filename = 769,
  sym_pattern_multi = 770,
  aux_sym__pattern_ordinary_atom = 771,
  sym__pattern_atom = 772,
  sym__pattern_piece = 773,
  aux_sym__pattern_concat = 774,
  sym__pattern_branch = 775,
  sym_pattern = 776,
  sym_env_variable = 777,
  sym_option = 778,
  sym_dictionnary_entry = 779,
  sym_dictionnary = 780,
  sym__literal_dictionary_entry = 781,
  sym_literal_dictionary = 782,
  sym_lambda_expression = 783,
  sym__immediate_lambda_expression = 784,
  sym__plus_plus_opt_bad = 785,
  sym_plus_plus_opt = 786,
  aux_sym__plus_cmd_arg = 787,
  sym__plus_cmd_number = 788,
  sym__plus_cmd_command = 789,
  sym__plus_cmd_pattern = 790,
  sym_plus_cmd = 791,
  sym_au_event_list = 792,
  sym__augroup_name = 793,
  sym__autocmd_pattern = 794,
  sym__autocmd_command = 795,
  sym__autocmd_define = 796,
  sym__autocmd_remove = 797,
  sym__autocmd_list = 798,
  sym_autocmd_statement = 799,
  sym_augroup_statement = 800,
  sym__command_attribute_completion_behavior = 801,
  sym__command_attribute_address_behavior = 802,
  sym__command_attribute_nargs_value = 803,
  sym__command_attribute_range_value = 804,
  sym_command_attribute = 805,
  sym_command_statement = 806,
  sym_comclear_statement = 807,
  sym_delcommand_statement = 808,
  sym__hl_body_link = 809,
  sym__hl_body_clear = 810,
  sym__hl_body_none = 811,
  sym__hl_none = 812,
  sym__hl_attr_list = 813,
  sym__hl_key_cterm = 814,
  aux_sym__hl_term_list = 815,
  sym__hl_key_start_stop = 816,
  sym__hl_key_ctermfg_ctermbg = 817,
  sym__hl_key_gui = 818,
  sym__hl_quoted_name = 819,
  sym_color = 820,
  sym__hl_key_gui_color = 821,
  sym_font = 822,
  sym__hl_key_font = 823,
  sym__hl_key_blend = 824,
  sym_hl_attribute = 825,
  sym__hl_body_keys = 826,
  sym__hl_body = 827,
  sym_highlight_statement = 828,
  sym__syn_enable = 829,
  sym__syn_case = 830,
  sym__syn_spell = 831,
  sym__syn_foldlevel = 832,
  sym__syn_iskeyword = 833,
  sym__syn_conceal = 834,
  sym__syn_hl_pattern = 835,
  sym_hl_groups = 836,
  sym__syn_arguments_keyword = 837,
  sym__syn_arguments_match = 838,
  sym__syn_arguments_region = 839,
  sym__syn_arguments_cluster = 840,
  sym__syn_pattern_offset = 841,
  sym__syn_keyword = 842,
  sym__syn_match = 843,
  sym__syn_region_start = 844,
  sym__syn_region_skip = 845,
  sym__syn_region_end = 846,
  sym__syn_region = 847,
  sym__syn_cluster = 848,
  sym__syn_include = 849,
  sym__syn_sync_lines = 850,
  sym__syn_sync = 851,
  sym__syn_list = 852,
  sym__syn_clear = 853,
  sym_syntax_statement = 854,
  sym_edit_statement = 855,
  sym_enew_statement = 856,
  sym_find_statement = 857,
  sym_ex_statement = 858,
  sym_visual_statement = 859,
  sym_view_statement = 860,
  aux_sym__statement_repeat1 = 861,
  aux_sym_unknown_builtin_statement_repeat1 = 862,
  aux_sym_filetypes_repeat1 = 863,
  aux_sym_runtime_statement_repeat1 = 864,
  aux_sym_script_repeat1 = 865,
  aux_sym_if_statement_repeat1 = 866,
  aux_sym_try_statement_repeat1 = 867,
  aux_sym__bang_filter_command_argument_repeat1 = 868,
  aux_sym__bang_filter_command_repeat1 = 869,
  aux_sym_identifier_repeat1 = 870,
  aux_sym_let_statement_repeat1 = 871,
  aux_sym__let_heredoc_repeat1 = 872,
  aux_sym_set_statement_repeat1 = 873,
  aux_sym_unlet_statement_repeat1 = 874,
  aux_sym_function_definition_repeat1 = 875,
  aux_sym_parameters_repeat1 = 876,
  aux_sym_parameters_repeat2 = 877,
  aux_sym_map_statement_repeat1 = 878,
  aux_sym__map_lhs_repeat1 = 879,
  aux_sym__map_rhs_statement_repeat1 = 880,
  aux_sym__map_rhs_repeat1 = 881,
  aux_sym__sign_define_repeat1 = 882,
  aux_sym__sign_place_place_repeat1 = 883,
  aux_sym__sign_unplace_id_repeat1 = 884,
  aux_sym__sign_jump_repeat1 = 885,
  aux_sym_list_repeat1 = 886,
  aux_sym_filename_repeat1 = 887,
  aux_sym__pattern_ordinary_atom_repeat1 = 888,
  aux_sym__pattern_branch_repeat1 = 889,
  aux_sym_pattern_repeat1 = 890,
  aux_sym_dictionnary_repeat1 = 891,
  aux_sym_literal_dictionary_repeat1 = 892,
  aux_sym_au_event_list_repeat1 = 893,
  aux_sym__autocmd_pattern_repeat1 = 894,
  aux_sym_command_statement_repeat1 = 895,
  aux_sym__hl_attr_list_repeat1 = 896,
  aux_sym__hl_body_keys_repeat1 = 897,
  aux_sym_hl_groups_repeat1 = 898,
  aux_sym__syn_keyword_repeat1 = 899,
  aux_sym__syn_keyword_repeat2 = 900,
  aux_sym__syn_match_repeat1 = 901,
  aux_sym__syn_match_repeat2 = 902,
  aux_sym__syn_region_repeat1 = 903,
  aux_sym__syn_region_repeat2 = 904,
  aux_sym__syn_cluster_repeat1 = 905,
  aux_sym__syn_sync_repeat1 = 906,
  aux_sym_edit_statement_repeat1 = 907,
  aux_sym_edit_statement_repeat2 = 908,
  alias_sym_arguments = 909,
  alias_sym_augroup_name = 910,
  alias_sym_body = 911,
  alias_sym_file = 912,
  alias_sym_filenames = 913,
  alias_sym_filter_command = 914,
  alias_sym_name = 915,
  alias_sym_range = 916,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_keyword] = "keyword",
  [anon_sym_COLON] = ":",
  [anon_sym_a_COLON] = "a:",
  [aux_sym_normal_statement_token1] = "commands",
  [sym_filetype] = "filetype",
  [aux_sym__filetype_immediate_token1] = "filetype",
  [anon_sym_DOT] = ".",
  [anon_sym_FALLBACK] = "fallback",
  [anon_sym_dos] = "file_format",
  [anon_sym_unix] = "file_format",
  [anon_sym_mac] = "file_format",
  [anon_sym_latin1] = "latin1",
  [anon_sym_iso] = "iso",
  [anon_sym_koi8] = "koi8",
  [anon_sym_macroman] = "macroman",
  [anon_sym_cp437] = "cp437",
  [anon_sym_cp737] = "cp737",
  [anon_sym_cp775] = "cp775",
  [anon_sym_cp850] = "cp850",
  [anon_sym_cp852] = "cp852",
  [anon_sym_cp855] = "cp855",
  [anon_sym_cp857] = "cp857",
  [anon_sym_cp860] = "cp860",
  [anon_sym_cp861] = "cp861",
  [anon_sym_cp862] = "cp862",
  [anon_sym_cp863] = "cp863",
  [anon_sym_cp865] = "cp865",
  [anon_sym_cp866] = "cp866",
  [anon_sym_cp869] = "cp869",
  [anon_sym_cp874] = "cp874",
  [anon_sym_cp1250] = "cp1250",
  [anon_sym_cp1251] = "cp1251",
  [anon_sym_cp1253] = "cp1253",
  [anon_sym_cp1254] = "cp1254",
  [anon_sym_cp1255] = "cp1255",
  [anon_sym_cp1256] = "cp1256",
  [anon_sym_cp1257] = "cp1257",
  [anon_sym_cp1258] = "cp1258",
  [anon_sym_cp932] = "cp932",
  [anon_sym_euc_DASHjp] = "euc-jp",
  [anon_sym_sjis] = "sjis",
  [anon_sym_cp949] = "cp949",
  [anon_sym_euc_DASHkr] = "euc-kr",
  [anon_sym_cp936] = "cp936",
  [anon_sym_euc_DASHcn] = "euc-cn",
  [anon_sym_cp950] = "cp950",
  [anon_sym_big5] = "big5",
  [anon_sym_euc_DASHtw] = "euc-tw",
  [anon_sym_utf_DASH8] = "utf-8",
  [anon_sym_ucs_DASH2] = "ucs-2",
  [anon_sym_ucs_DASH21e] = "ucs-21e",
  [anon_sym_utf_DASH16] = "utf-16",
  [anon_sym_utf_DASH16le] = "utf-16le",
  [anon_sym_ucs_DASH4] = "ucs-4",
  [anon_sym_ucs_DASH4le] = "ucs-4le",
  [anon_sym_ansi] = "ansi",
  [anon_sym_japan] = "japan",
  [anon_sym_korea] = "korea",
  [anon_sym_prc] = "prc",
  [anon_sym_chinese] = "chinese",
  [anon_sym_taiwan] = "taiwan",
  [anon_sym_utf8] = "utf8",
  [anon_sym_unicode] = "unicode",
  [anon_sym_ucs2be] = "ucs2be",
  [anon_sym_ucs_DASH2be] = "ucs-2be",
  [anon_sym_ucs_DASH4be] = "ucs-4be",
  [anon_sym_utf_DASH32] = "utf-32",
  [anon_sym_utf_DASH32le] = "utf-32le",
  [anon_sym_default] = "default",
  [anon_sym_latin12] = "encoding",
  [anon_sym_iso2] = "encoding",
  [anon_sym_koi82] = "encoding",
  [anon_sym_macroman2] = "encoding",
  [anon_sym_cp4372] = "encoding",
  [anon_sym_cp7372] = "encoding",
  [anon_sym_cp7752] = "encoding",
  [anon_sym_cp8502] = "encoding",
  [anon_sym_cp8522] = "encoding",
  [anon_sym_cp8552] = "encoding",
  [anon_sym_cp8572] = "encoding",
  [anon_sym_cp8602] = "encoding",
  [anon_sym_cp8612] = "encoding",
  [anon_sym_cp8622] = "encoding",
  [anon_sym_cp8632] = "encoding",
  [anon_sym_cp8652] = "encoding",
  [anon_sym_cp8662] = "encoding",
  [anon_sym_cp8692] = "encoding",
  [anon_sym_cp8742] = "encoding",
  [anon_sym_cp12502] = "encoding",
  [anon_sym_cp12512] = "encoding",
  [anon_sym_cp12532] = "encoding",
  [anon_sym_cp12542] = "encoding",
  [anon_sym_cp12552] = "encoding",
  [anon_sym_cp12562] = "encoding",
  [anon_sym_cp12572] = "encoding",
  [anon_sym_cp12582] = "encoding",
  [anon_sym_cp9322] = "encoding",
  [anon_sym_euc_DASHjp2] = "encoding",
  [anon_sym_sjis2] = "encoding",
  [anon_sym_cp9492] = "encoding",
  [anon_sym_euc_DASHkr2] = "encoding",
  [anon_sym_cp9362] = "encoding",
  [anon_sym_euc_DASHcn2] = "encoding",
  [anon_sym_cp9502] = "encoding",
  [anon_sym_big52] = "encoding",
  [anon_sym_euc_DASHtw2] = "encoding",
  [anon_sym_utf_DASH82] = "encoding",
  [anon_sym_ucs_DASH22] = "encoding",
  [anon_sym_ucs_DASH21e2] = "encoding",
  [anon_sym_utf_DASH162] = "encoding",
  [anon_sym_utf_DASH16le2] = "encoding",
  [anon_sym_ucs_DASH42] = "encoding",
  [anon_sym_ucs_DASH4le2] = "encoding",
  [anon_sym_ansi2] = "encoding",
  [anon_sym_japan2] = "encoding",
  [anon_sym_korea2] = "encoding",
  [anon_sym_prc2] = "encoding",
  [anon_sym_chinese2] = "encoding",
  [anon_sym_taiwan2] = "encoding",
  [anon_sym_utf82] = "encoding",
  [anon_sym_unicode2] = "encoding",
  [anon_sym_ucs2be2] = "encoding",
  [anon_sym_ucs_DASH2be2] = "encoding",
  [anon_sym_ucs_DASH4be2] = "encoding",
  [anon_sym_utf_DASH322] = "encoding",
  [anon_sym_utf_DASH32le2] = "encoding",
  [anon_sym_default2] = "encoding",
  [anon_sym_START] = "START",
  [anon_sym_OPT] = "OPT",
  [anon_sym_PACK] = "PACK",
  [anon_sym_ALL] = "ALL",
  [aux_sym_wincmd_statement_token1] = "wincmd_statement_token1",
  [anon_sym_on] = "on",
  [anon_sym_off] = "off",
  [anon_sym_detect] = "detect",
  [anon_sym_plugin] = "plugin",
  [anon_sym_indent] = "indent",
  [sym_chunk] = "chunk",
  [sym__heredoc_line] = "_heredoc_line",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_LF] = "\n",
  [anon_sym_in] = "in",
  [aux_sym__au_pattern_token1] = "_au_pattern_token1",
  [aux_sym__au_pattern_token2] = "_au_pattern_token2",
  [aux_sym__bang_filter_command_argument_token1] = "_bang_filter_command_argument_token1",
  [anon_sym_BSLASH] = "\\",
  [aux_sym__bang_filter_command_argument_token2] = "_bang_filter_command_argument_token2",
  [aux_sym__bang_filter_command_argument_token3] = "_bang_filter_command_argument_token3",
  [aux_sym__bang_filter_command_argument_token4] = "_bang_filter_command_argument_token4",
  [aux_sym_argument_token1] = "identifier",
  [aux_sym_argument_token2] = "argument_token2",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_LBRACE2] = "{",
  [aux_sym_identifier_token1] = "identifier_token1",
  [aux_sym_identifier_token2] = "identifier_token2",
  [aux_sym__immediate_identifier_token1] = "_immediate_identifier_token1",
  [anon_sym_EQ] = "=",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_DOT_EQ] = ".=",
  [anon_sym_DOT_DOT_EQ] = "..=",
  [anon_sym_EQ_LT_LT] = "=<<",
  [anon_sym_trim] = "trim",
  [anon_sym_eval] = "eval",
  [aux_sym_option_name_token1] = "option_name_token1",
  [anon_sym_t_] = "t_",
  [aux_sym_option_name_token2] = "option_name_token2",
  [anon_sym_BANG] = "!",
  [anon_sym_AMP] = "&",
  [anon_sym_vi] = "vi",
  [anon_sym_vim] = "vim",
  [anon_sym_all] = "all",
  [anon_sym_all_AMP] = "all&",
  [anon_sym_QMARK] = "\?",
  [anon_sym_EQ2] = "=",
  [anon_sym_COLON2] = ":",
  [anon_sym_PLUS_EQ2] = "+=",
  [anon_sym_CARET_EQ] = "^=",
  [anon_sym_DASH_EQ2] = "-=",
  [sym_set_value] = "set_value",
  [anon_sym_SPACE] = " ",
  [aux_sym_command_argument_token1] = "command_argument_token1",
  [anon_sym_dict] = "dict",
  [anon_sym_range] = "range",
  [anon_sym_abort] = "abort",
  [anon_sym_closure] = "closure",
  [anon_sym_LPAREN] = "(",
  [anon_sym_COMMA] = ",",
  [anon_sym_RPAREN] = ")",
  [anon_sym_AT] = "@",
  [sym_spread] = "spread",
  [sym__printable] = "_printable",
  [sym_mark] = "mark",
  [anon_sym_PERCENT] = "%",
  [anon_sym_SEMI] = ";",
  [anon_sym_SLASH] = "/",
  [anon_sym_SLASH2] = "/",
  [anon_sym_QMARK2] = "\?",
  [anon_sym_DOT2] = ".",
  [anon_sym_PLUS] = "+",
  [anon_sym_DOLLAR] = "$",
  [anon_sym_BSLASH_SLASH] = "\\/",
  [anon_sym_BSLASH_QMARK] = "\\\?",
  [anon_sym_BSLASH_AMP] = "\\&",
  [anon_sym_LTbuffer_GT] = "<buffer>",
  [anon_sym_LTnowait_GT] = "<nowait>",
  [anon_sym_LTsilent_GT] = "<silent>",
  [anon_sym_LTunique_GT] = "<unique>",
  [anon_sym_LTscript_GT] = "<script>",
  [anon_sym_LTexpr_GT] = "<expr>",
  [sym__keycode_modifier] = "_keycode_modifier",
  [aux_sym__keycode_in_token1] = "_keycode_in_token1",
  [aux_sym__keycode_in_token2] = "_keycode_in_token2",
  [aux_sym__keycode_in_token3] = "_keycode_in_token3",
  [aux_sym__keycode_in_token4] = "_keycode_in_token4",
  [aux_sym__keycode_in_token5] = "_keycode_in_token5",
  [aux_sym__keycode_in_token6] = "_keycode_in_token6",
  [aux_sym__keycode_in_token7] = "_keycode_in_token7",
  [aux_sym__keycode_in_token8] = "_keycode_in_token8",
  [aux_sym__keycode_in_token9] = "_keycode_in_token9",
  [aux_sym__keycode_in_token10] = "_keycode_in_token10",
  [aux_sym__keycode_in_token11] = "_keycode_in_token11",
  [aux_sym__keycode_in_token12] = "_keycode_in_token12",
  [aux_sym__keycode_in_token13] = "_keycode_in_token13",
  [aux_sym__keycode_in_token14] = "_keycode_in_token14",
  [aux_sym__keycode_in_token15] = "_keycode_in_token15",
  [aux_sym__keycode_in_token16] = "_keycode_in_token16",
  [aux_sym__keycode_in_token17] = "_keycode_in_token17",
  [aux_sym__keycode_in_token18] = "_keycode_in_token18",
  [aux_sym__keycode_in_token19] = "_keycode_in_token19",
  [aux_sym__keycode_in_token20] = "_keycode_in_token20",
  [aux_sym__keycode_in_token21] = "_keycode_in_token21",
  [aux_sym__keycode_in_token22] = "_keycode_in_token22",
  [aux_sym__keycode_in_token23] = "_keycode_in_token23",
  [aux_sym__keycode_in_token24] = "_keycode_in_token24",
  [aux_sym__keycode_in_token25] = "_keycode_in_token25",
  [aux_sym__keycode_in_token26] = "_keycode_in_token26",
  [aux_sym__keycode_in_token27] = "_keycode_in_token27",
  [aux_sym__keycode_in_token28] = "_keycode_in_token28",
  [aux_sym__keycode_in_token29] = "_keycode_in_token29",
  [aux_sym__keycode_in_token30] = "_keycode_in_token30",
  [aux_sym__keycode_in_token31] = "_keycode_in_token31",
  [aux_sym__keycode_in_token32] = "_keycode_in_token32",
  [aux_sym__keycode_in_token33] = "_keycode_in_token33",
  [aux_sym__keycode_in_token34] = "_keycode_in_token34",
  [aux_sym__keycode_in_token35] = "_keycode_in_token35",
  [aux_sym__keycode_in_token36] = "_keycode_in_token36",
  [aux_sym__keycode_in_token37] = "_keycode_in_token37",
  [aux_sym__keycode_in_token38] = "_keycode_in_token38",
  [aux_sym__keycode_in_token39] = "_keycode_in_token39",
  [aux_sym__keycode_in_token40] = "_keycode_in_token40",
  [aux_sym__keycode_in_token41] = "_keycode_in_token41",
  [aux_sym__keycode_in_token42] = "_keycode_in_token42",
  [aux_sym__keycode_in_token43] = "_keycode_in_token43",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_LT2] = "<",
  [anon_sym_BSLASH2] = "\\",
  [aux_sym__map_lhs_token1] = "_map_lhs_token1",
  [aux_sym__map_rhs_statement_token1] = "keycode",
  [anon_sym_BSLASH_PIPE] = "\\|",
  [aux_sym__map_rhs_statement_token2] = "keycode",
  [aux_sym__map_rhs_statement_token3] = "keycode",
  [aux_sym__map_rhs_token1] = "_map_rhs_token1",
  [aux_sym__map_rhs_token2] = "_map_rhs_token2",
  [anon_sym_icon] = "icon",
  [anon_sym_linehl] = "linehl",
  [anon_sym_numhl] = "numhl",
  [anon_sym_text] = "text",
  [anon_sym_texthl] = "texthl",
  [anon_sym_culhl] = "culhl",
  [anon_sym_define] = "define",
  [anon_sym_undefine] = "undefine",
  [anon_sym_list] = "list",
  [anon_sym_line] = "line",
  [anon_sym_name] = "name",
  [anon_sym_buffer] = "buffer",
  [anon_sym_group] = "group",
  [anon_sym_priority] = "priority",
  [anon_sym_file] = "file",
  [anon_sym_STAR] = "wildcard",
  [anon_sym_place] = "place",
  [anon_sym_STAR2] = "*",
  [anon_sym_unplace] = "unplace",
  [anon_sym_jump] = "jump",
  [anon_sym_POUND] = "#",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_DASH] = "-",
  [anon_sym_DOT_DOT] = "..",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_GT2] = ">",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_EQ_TILDE] = "=~",
  [anon_sym_BANG_TILDE] = "!~",
  [anon_sym_is] = "is",
  [anon_sym_isnot] = "isnot",
  [anon_sym_BANG2] = "!",
  [sym_float_literal] = "float_literal",
  [sym_integer_literal] = "integer_literal",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_LPAREN2] = "(",
  [anon_sym_DASH_GT] = "->",
  [aux_sym_filename_token1] = "filename_token1",
  [aux_sym_filename_token2] = "filename_token2",
  [aux_sym_filename_token3] = "filename_token3",
  [aux_sym_filename_token4] = "filename_token4",
  [aux_sym_filename_token5] = "filename_token5",
  [aux_sym_filename_token6] = "filename_token6",
  [aux_sym_filename_token7] = "filename_token7",
  [aux_sym_filename_token8] = "filename_token8",
  [aux_sym_pattern_multi_token1] = "pattern_multi_token1",
  [aux_sym_pattern_multi_token2] = "pattern_multi_token2",
  [aux_sym_pattern_multi_token3] = "pattern_multi_token3",
  [aux_sym__pattern_ordinary_atom_token1] = "_pattern_ordinary_atom_token1",
  [aux_sym__pattern_ordinary_atom_token2] = "_pattern_ordinary_atom_token2",
  [anon_sym_BSLASH_LPAREN] = "\\(",
  [anon_sym_BSLASH_RPAREN] = "\\)",
  [anon_sym_BSLASH_PERCENT_LPAREN] = "\\%(",
  [anon_sym_BSLASHz_LPAREN] = "\\z(",
  [sym_register] = "register",
  [sym_literal_key] = "literal_key",
  [anon_sym_POUND_LBRACE] = "#{",
  [anon_sym_keep] = "keep",
  [anon_sym_drop] = "drop",
  [anon_sym_PLUS_PLUS] = "++",
  [anon_sym_ff] = "ff",
  [anon_sym_fileformat] = "fileformat",
  [anon_sym_enc] = "enc",
  [anon_sym_encoding] = "encoding",
  [anon_sym_bin] = "bin",
  [anon_sym_binary] = "binary",
  [anon_sym_nobin] = "nobin",
  [anon_sym_nobinary] = "nobinary",
  [anon_sym_bad] = "bad",
  [anon_sym_edit] = "edit",
  [aux_sym__plus_cmd_arg_token1] = "_plus_cmd_arg_token1",
  [sym_au_event] = "au_event",
  [aux_sym__autocmd_pattern_token1] = "pattern",
  [sym_au_once] = "au_once",
  [sym_au_nested] = "au_nested",
  [sym_command_name] = "command_name",
  [anon_sym_arglist] = "arglist",
  [anon_sym_augroup] = "augroup",
  [anon_sym_buffer2] = "buffer",
  [anon_sym_behave] = "behave",
  [anon_sym_color] = "color",
  [anon_sym_command] = "command",
  [anon_sym_compiler] = "compiler",
  [anon_sym_dir] = "dir",
  [anon_sym_environment] = "environment",
  [anon_sym_even] = "even",
  [anon_sym_expression] = "expression",
  [anon_sym_file2] = "file",
  [anon_sym_file_in_path] = "file_in_path",
  [anon_sym_filetype] = "filetype",
  [anon_sym_function] = "function",
  [anon_sym_help] = "help",
  [anon_sym_highlight] = "highlight",
  [anon_sym_history] = "history",
  [anon_sym_local] = "local",
  [anon_sym_lua] = "lua",
  [anon_sym_mapclear] = "mapclear",
  [anon_sym_mapping] = "mapping",
  [anon_sym_menu] = "menu",
  [anon_sym_messages] = "messages",
  [anon_sym_option] = "option",
  [anon_sym_packadd] = "packadd",
  [anon_sym_shellcmd] = "shellcmd",
  [anon_sym_sign] = "sign",
  [anon_sym_syntax] = "syntax",
  [anon_sym_syntime] = "syntime",
  [anon_sym_tag] = "tag",
  [anon_sym_tag_listfiles] = "tag_listfiles",
  [anon_sym_user] = "user",
  [anon_sym_var] = "var",
  [anon_sym_custom] = "custom",
  [anon_sym_COMMA2] = ",",
  [anon_sym_customlist] = "customlist",
  [anon_sym_lines] = "lines",
  [anon_sym_arguments] = "arguments",
  [anon_sym_buffers] = "buffers",
  [anon_sym_loaded_buffers] = "loaded_buffers",
  [anon_sym_windows] = "windows",
  [anon_sym_tabs] = "tabs",
  [anon_sym_quickfix] = "quickfix",
  [anon_sym_other] = "other",
  [aux_sym__command_attribute_nargs_value_token1] = "integer_literal",
  [aux_sym__command_attribute_nargs_value_token2] = "pattern_multi",
  [anon_sym_PERCENT2] = "pattern_multi",
  [anon_sym_DASHnargs] = "-nargs",
  [anon_sym_DASHcomplete] = "-complete",
  [anon_sym_DASHrange] = "-range",
  [anon_sym_DASHcount] = "-count",
  [anon_sym_DASHaddr] = "-addr",
  [anon_sym_DASHbang] = "-bang",
  [anon_sym_DASHbar] = "-bar",
  [anon_sym_DASHregister] = "-register",
  [anon_sym_DASHbuffer] = "-buffer",
  [anon_sym_DASHkeepscript] = "-keepscript",
  [aux_sym_command_statement_token1] = "command",
  [sym_hl_group] = "hl_group",
  [anon_sym_link] = "link",
  [anon_sym_clear] = "clear",
  [anon_sym_NONE] = "hl_group",
  [anon_sym_NONE2] = "NONE",
  [anon_sym_bold] = "bold",
  [anon_sym_underline] = "underline",
  [anon_sym_undercurl] = "undercurl",
  [anon_sym_underdouble] = "underdouble",
  [anon_sym_underdotted] = "underdotted",
  [anon_sym_underdashed] = "underdashed",
  [anon_sym_strikethrough] = "strikethrough",
  [anon_sym_reverse] = "reverse",
  [anon_sym_inverse] = "inverse",
  [anon_sym_italic] = "italic",
  [anon_sym_standout] = "standout",
  [anon_sym_nocombine] = "nocombine",
  [anon_sym_term] = "term",
  [anon_sym_cterm] = "cterm",
  [aux_sym__hl_term_list_token1] = "_hl_term_list_token1",
  [anon_sym_start] = "start",
  [anon_sym_stop] = "stop",
  [sym__hl_color_nr] = "_hl_color_nr",
  [anon_sym_ctermfg] = "ctermfg",
  [anon_sym_ctermbg] = "ctermbg",
  [anon_sym_gui] = "gui",
  [anon_sym_SQUOTE] = "'",
  [aux_sym__hl_quoted_name_token1] = "_hl_quoted_name_token1",
  [anon_sym_SQUOTE2] = "'",
  [anon_sym_bg] = "bg",
  [anon_sym_background] = "background",
  [anon_sym_fg] = "fg",
  [anon_sym_foreground] = "foreground",
  [aux_sym_color_token1] = "color_token1",
  [aux_sym_color_token2] = "color_token2",
  [anon_sym_guifg] = "guifg",
  [anon_sym_guibg] = "guibg",
  [anon_sym_guisp] = "guisp",
  [aux_sym_font_token1] = "font_token1",
  [anon_sym_font] = "font",
  [anon_sym_blend] = "blend",
  [anon_sym_enable] = "enable",
  [anon_sym_reset] = "reset",
  [anon_sym_case] = "case",
  [anon_sym_match] = "match",
  [anon_sym_ignore] = "ignore",
  [anon_sym_spell] = "spell",
  [anon_sym_toplevel] = "toplevel",
  [anon_sym_notoplevel] = "notoplevel",
  [anon_sym_foldlevel] = "foldlevel",
  [anon_sym_minimum] = "minimum",
  [anon_sym_iskeyword] = "iskeyword",
  [aux_sym__syn_iskeyword_token1] = "value",
  [anon_sym_conceal] = "conceal",
  [anon_sym_cchar] = "cchar",
  [anon_sym_contained] = "contained",
  [anon_sym_containedin] = "containedin",
  [anon_sym_nextgroup] = "nextgroup",
  [anon_sym_transparent] = "transparent",
  [anon_sym_skipwhite] = "skipwhite",
  [anon_sym_skipnl] = "skipnl",
  [anon_sym_skipempty] = "skipempty",
  [anon_sym_contains] = "contains",
  [anon_sym_fold] = "fold",
  [anon_sym_display] = "display",
  [anon_sym_extend] = "extend",
  [anon_sym_keepend] = "keepend",
  [anon_sym_excludenl] = "excludenl",
  [anon_sym_matchgroup] = "matchgroup",
  [anon_sym_oneline] = "oneline",
  [anon_sym_concealends] = "concealends",
  [anon_sym_add] = "add",
  [anon_sym_remove] = "remove",
  [anon_sym_ms] = "ms",
  [anon_sym_me] = "me",
  [anon_sym_hs] = "hs",
  [anon_sym_he] = "he",
  [anon_sym_rs] = "rs",
  [anon_sym_re] = "re",
  [anon_sym_lc] = "lc",
  [aux_sym__syn_pattern_offset_token1] = "_syn_pattern_offset_token1",
  [aux_sym__syn_pattern_offset_token2] = "_syn_pattern_offset_token2",
  [anon_sym_keyword] = "keyword",
  [aux_sym__syn_keyword_token1] = "keyword",
  [anon_sym_skip] = "skip",
  [anon_sym_end] = "end",
  [anon_sym_region] = "region",
  [anon_sym_cluster] = "cluster",
  [anon_sym_include] = "include",
  [anon_sym_minlines] = "minlines",
  [anon_sym_maxlines] = "maxlines",
  [aux_sym__syn_sync_lines_token1] = "_syn_sync_lines_token1",
  [anon_sym_sync] = "sync",
  [anon_sym_linebreaks] = "linebreaks",
  [anon_sym_fromstart] = "fromstart",
  [anon_sym_ccomment] = "ccomment",
  [anon_sym_lines2] = "lines",
  [anon_sym_grouphere] = "grouphere",
  [anon_sym_groupthere] = "groupthere",
  [anon_sym_linecont] = "linecont",
  [sym__no] = "_no",
  [sym__inv] = "_inv",
  [sym__newline_or_pipe] = "_newline_or_pipe",
  [sym__line_continuation] = "_line_continuation",
  [sym__script_heredoc_marker] = "marker_definition",
  [sym__let_heredoc_marker] = "marker_definition",
  [sym__heredoc_end] = "endmarker",
  [sym__separator_first] = "_separator_first",
  [sym__separator] = "_separator",
  [sym__scope_dict] = "_scope_dict",
  [sym_scope] = "scope",
  [sym_string_literal] = "string_literal",
  [sym_comment] = "comment",
  [sym_line_continuation_comment] = "line_continuation_comment",
  [sym__bang_filter] = "_bang_filter",
  [sym__function] = "function",
  [sym__endfunction] = "endfunction",
  [sym__for] = "for",
  [sym__endfor] = "endfor",
  [sym__while] = "while",
  [sym__endwhile] = "endwhile",
  [sym__if] = "if",
  [sym__elseif] = "elseif",
  [sym__else] = "else",
  [sym__endif] = "endif",
  [sym__try] = "try",
  [sym__catch] = "catch",
  [sym__cnext] = "cnext",
  [sym__cprevious] = "cprevious",
  [sym__cNext] = "cNext",
  [sym__finally] = "finally",
  [sym__endtry] = "endtry",
  [sym__const] = "const",
  [sym__normal] = "normal",
  [sym__return] = "return",
  [sym__perl] = "perl",
  [sym__lua] = "lua",
  [sym__ruby] = "ruby",
  [sym__python] = "python",
  [sym__throw] = "throw",
  [sym__execute] = "execute",
  [sym__autocmd] = "autocmd",
  [sym__silent] = "silent",
  [sym__echo] = "echo",
  [sym__echon] = "echon",
  [sym__echohl] = "echohl",
  [sym__echomsg] = "echomsg",
  [sym__echoerr] = "echoerr",
  [sym__map] = "map",
  [sym__nmap] = "nmap",
  [sym__vmap] = "vmap",
  [sym__xmap] = "xmap",
  [sym__smap] = "smap",
  [sym__omap] = "omap",
  [sym__imap] = "imap",
  [sym__lmap] = "lmap",
  [sym__cmap] = "cmap",
  [sym__tmap] = "tmap",
  [sym__noremap] = "noremap",
  [sym__nnoremap] = "nnoremap",
  [sym__vnoremap] = "vnoremap",
  [sym__xnoremap] = "xnoremap",
  [sym__snoremap] = "snoremap",
  [sym__onoremap] = "onoremap",
  [sym__inoremap] = "inoremap",
  [sym__lnoremap] = "lnoremap",
  [sym__cnoremap] = "cnoremap",
  [sym__tnoremap] = "tnoremap",
  [sym__augroup] = "augroup",
  [sym__highlight] = "highlight",
  [sym__default] = "default",
  [sym__syntax] = "syntax",
  [sym__set] = "set",
  [sym__setlocal] = "setlocal",
  [sym__setfiletype] = "setfiletype",
  [sym__browse] = "browse",
  [sym__options] = "options",
  [sym__startinsert] = "startinsert",
  [sym__stopinsert] = "stopinsert",
  [sym__scriptencoding] = "scriptencoding",
  [sym__source] = "source",
  [sym__global] = "global",
  [sym__colorscheme] = "colorscheme",
  [sym__command] = "command",
  [sym__comclear] = "comclear",
  [sym__delcommand] = "delcommand",
  [sym__runtime] = "runtime",
  [sym__wincmd] = "wincmd",
  [sym__sign] = "sign",
  [sym__filetype] = "filetype",
  [sym__let] = "let",
  [sym__unlet] = "unlet",
  [sym__call] = "call",
  [sym__break] = "break",
  [sym__continue] = "continue",
  [sym__vertical] = "vertical",
  [sym__leftabove] = "leftabove",
  [sym__aboveleft] = "aboveleft",
  [sym__rightbelow] = "rightbelow",
  [sym__belowright] = "belowright",
  [sym__topleft] = "topleft",
  [sym__botright] = "botright",
  [sym__edit] = "edit",
  [sym__enew] = "enew",
  [sym__find] = "find",
  [sym__ex] = "ex",
  [sym__visual] = "visual",
  [sym__view] = "view",
  [sym__eval] = "eval",
  [sym_unknown_command_name] = "unknown_command_name",
  [sym_script_file] = "script_file",
  [sym__cmd_separator] = "_cmd_separator",
  [aux_sym__separated_statements] = "_separated_statements",
  [sym__statement] = "_statement",
  [sym_unknown_builtin_statement] = "unknown_builtin_statement",
  [sym_return_statement] = "return_statement",
  [sym_break_statement] = "break_statement",
  [sym_continue_statement] = "continue_statement",
  [sym_scope_dict] = "scope_dict",
  [sym_normal_statement] = "normal_statement",
  [sym__filetype_immediate] = "_filetype_immediate",
  [sym_filetypes] = "filetypes",
  [sym_setfiletype_statement] = "setfiletype_statement",
  [sym_options_statement] = "options_statement",
  [sym_startinsert_statement] = "startinsert_statement",
  [sym_stopinsert_statement] = "stopinsert_statement",
  [sym__immediate_file_format] = "_immediate_file_format",
  [sym_encoding] = "encoding",
  [sym__immediate_encoding] = "_immediate_encoding",
  [sym_scriptencoding_statement] = "scriptencoding_statement",
  [sym_cnext_statement] = "cnext_statement",
  [sym_cprevious_statement] = "cprevious_statement",
  [sym__runtime_where] = "where",
  [sym_runtime_statement] = "runtime_statement",
  [sym_wincmd_statement] = "wincmd_statement",
  [sym_source_statement] = "source_statement",
  [sym_global_statement] = "global_statement",
  [sym__filetype_state] = "_filetype_state",
  [sym__filetype_enable] = "_filetype_enable",
  [sym__filetype_detect] = "_filetype_detect",
  [sym__filetype_plugin] = "_filetype_plugin",
  [sym__filetype_indent] = "_filetype_indent",
  [sym_filetype_statement] = "filetype_statement",
  [sym_colorscheme_statement] = "colorscheme_statement",
  [sym_lua_statement] = "lua_statement",
  [sym_ruby_statement] = "ruby_statement",
  [sym_python_statement] = "python_statement",
  [sym_perl_statement] = "perl_statement",
  [sym_script] = "script",
  [sym_for_loop] = "for_loop",
  [sym_while_loop] = "while_loop",
  [sym_if_statement] = "if_statement",
  [sym_elseif_statement] = "elseif_statement",
  [sym_else_statement] = "else_statement",
  [sym_try_statement] = "try_statement",
  [sym__au_pattern] = "pattern",
  [sym_catch_statement] = "catch_statement",
  [sym_finally_statement] = "finally_statement",
  [sym_throw_statement] = "throw_statement",
  [sym__bang_filter_bangs] = "bangs",
  [sym__bang_filter_command_argument] = "command_argument",
  [sym__bang_filter_command] = "command",
  [sym_bang_filter_statement] = "bang_filter_statement",
  [sym_scoped_identifier] = "scoped_identifier",
  [sym_argument] = "argument",
  [sym__curly_braces_name_expression] = "curly_braces_name",
  [sym__immediate_curly_braces_name_expression] = "curly_braces_name",
  [sym_identifier] = "identifier",
  [sym__immediate_identifier] = "identifier",
  [sym__ident] = "_ident",
  [sym__let_operator] = "_let_operator",
  [sym__assignment_variable] = "_assignment_variable",
  [sym__let_assignment] = "_let_assignment",
  [sym_let_statement] = "let_statement",
  [sym__const_assignment] = "_const_assignment",
  [sym_const_statement] = "const_statement",
  [sym__let_heredoc] = "heredoc",
  [sym__let_heredoc_parameter] = "parameter",
  [sym_option_name] = "option_name",
  [sym_no_option] = "no_option",
  [sym_inv_option] = "inv_option",
  [sym_default_option] = "default_option",
  [sym__set_option] = "_set_option",
  [sym__set_operator] = "_set_operator",
  [sym__set_rhs] = "_set_rhs",
  [sym_set_item] = "set_item",
  [sym_set_statement] = "set_statement",
  [sym_setlocal_statement] = "setlocal_statement",
  [sym_unlet_statement] = "unlet_statement",
  [sym_call_statement] = "call_statement",
  [sym_echo_statement] = "echo_statement",
  [sym_echon_statement] = "echon_statement",
  [sym_echohl_statement] = "echohl_statement",
  [sym_echomsg_statement] = "echomsg_statement",
  [sym_echoerr_statement] = "echoerr_statement",
  [sym_execute_statement] = "execute_statement",
  [sym_silent_statement] = "silent_statement",
  [sym_vertical_statement] = "vertical_statement",
  [sym_topleft_statement] = "topleft_statement",
  [sym_botright_statement] = "botright_statement",
  [sym_aboveleft_statement] = "aboveleft_statement",
  [sym_belowright_statement] = "belowright_statement",
  [sym_user_command] = "user_command",
  [sym_command_argument] = "command_argument",
  [sym_function_definition] = "function_definition",
  [sym_function_declaration] = "function_declaration",
  [sym_parameters] = "parameters",
  [sym_default_parameter] = "default_parameter",
  [sym_bang] = "bang",
  [sym_range_statement] = "range_statement",
  [sym__range] = "_range",
  [sym__range_explicit] = "_range_explicit",
  [sym__range_marker] = "_range_marker",
  [sym_current_line] = "current_line",
  [sym_next_line] = "next_line",
  [sym_last_line] = "last_line",
  [sym_previous_pattern] = "previous_pattern",
  [sym_register_statement] = "register_statement",
  [sym_map_statement] = "map_statement",
  [sym__map_definition] = "_map_definition",
  [sym__keycode_in] = "_keycode_in",
  [sym__immediate_keycode] = "_immediate_keycode",
  [sym_keycode] = "keycode",
  [sym__map_lhs] = "map_side",
  [sym__map_rhs_statement] = "_map_rhs_statement",
  [sym__map_rhs] = "map_side",
  [sym__sign_name] = "_sign_name",
  [sym__sign_define_arg_text] = "text",
  [sym__sign_define_argument] = "sign_argument",
  [sym__sign_define] = "_sign_define",
  [sym__sign_undefine] = "_sign_undefine",
  [sym__sign_list] = "_sign_list",
  [sym__sign_place_place_argument] = "sign_argument",
  [sym__sign_place_place] = "_sign_place_place",
  [sym__sign_place_list_argument] = "sign_argument",
  [aux_sym__sign_place_list] = "_sign_place_list",
  [sym__sign_place] = "_sign_place",
  [sym__sign_unplace_cursor_argument] = "sign_argument",
  [sym__sign_unplace_cursor] = "_sign_unplace_cursor",
  [sym__sign_unplace_id_argument] = "sign_argument",
  [sym__sign_unplace_id] = "_sign_unplace_id",
  [sym__sign_unplace] = "_sign_unplace",
  [sym__sign_jump_argument] = "sign_argument",
  [sym__sign_jump] = "_sign_jump",
  [sym_sign_statement] = "sign_statement",
  [sym__variable] = "_variable",
  [sym__expression] = "_expression",
  [sym_ternary_expression] = "ternary_expression",
  [sym_match_case] = "match_case",
  [sym_binary_operation] = "binary_operation",
  [sym_unary_operation] = "unary_operation",
  [sym_list] = "list",
  [sym_list_assignment] = "list_assignment",
  [sym_index_expression] = "index_expression",
  [sym_slice_expression] = "slice_expression",
  [sym_field_expression] = "field_expression",
  [sym_call_expression] = "call_expression",
  [sym_eval_statement] = "eval_statement",
  [sym__method_call_expression] = "call_expression",
  [sym_method_expression] = "method_expression",
  [sym_filename] = "filename",
  [sym_pattern_multi] = "pattern_multi",
  [aux_sym__pattern_ordinary_atom] = "_pattern_ordinary_atom",
  [sym__pattern_atom] = "_pattern_atom",
  [sym__pattern_piece] = "_pattern_piece",
  [aux_sym__pattern_concat] = "_pattern_concat",
  [sym__pattern_branch] = "_pattern_branch",
  [sym_pattern] = "pattern",
  [sym_env_variable] = "env_variable",
  [sym_option] = "option",
  [sym_dictionnary_entry] = "dictionnary_entry",
  [sym_dictionnary] = "dictionnary",
  [sym__literal_dictionary_entry] = "_literal_dictionary_entry",
  [sym_literal_dictionary] = "literal_dictionary",
  [sym_lambda_expression] = "lambda_expression",
  [sym__immediate_lambda_expression] = "lambda_expression",
  [sym__plus_plus_opt_bad] = "_plus_plus_opt_bad",
  [sym_plus_plus_opt] = "plus_plus_opt",
  [aux_sym__plus_cmd_arg] = "_plus_cmd_arg",
  [sym__plus_cmd_number] = "_plus_cmd_number",
  [sym__plus_cmd_command] = "_plus_cmd_command",
  [sym__plus_cmd_pattern] = "_plus_cmd_pattern",
  [sym_plus_cmd] = "plus_cmd",
  [sym_au_event_list] = "au_event_list",
  [sym__augroup_name] = "_augroup_name",
  [sym__autocmd_pattern] = "_autocmd_pattern",
  [sym__autocmd_command] = "_autocmd_command",
  [sym__autocmd_define] = "_autocmd_define",
  [sym__autocmd_remove] = "_autocmd_remove",
  [sym__autocmd_list] = "_autocmd_list",
  [sym_autocmd_statement] = "autocmd_statement",
  [sym_augroup_statement] = "augroup_statement",
  [sym__command_attribute_completion_behavior] = "behavior",
  [sym__command_attribute_address_behavior] = "behavior",
  [sym__command_attribute_nargs_value] = "_command_attribute_nargs_value",
  [sym__command_attribute_range_value] = "_command_attribute_range_value",
  [sym_command_attribute] = "command_attribute",
  [sym_command_statement] = "command_statement",
  [sym_comclear_statement] = "comclear_statement",
  [sym_delcommand_statement] = "delcommand_statement",
  [sym__hl_body_link] = "_hl_body_link",
  [sym__hl_body_clear] = "_hl_body_clear",
  [sym__hl_body_none] = "_hl_body_none",
  [sym__hl_none] = "_hl_none",
  [sym__hl_attr_list] = "_hl_attr_list",
  [sym__hl_key_cterm] = "_hl_key_cterm",
  [aux_sym__hl_term_list] = "_hl_term_list",
  [sym__hl_key_start_stop] = "_hl_key_start_stop",
  [sym__hl_key_ctermfg_ctermbg] = "_hl_key_ctermfg_ctermbg",
  [sym__hl_key_gui] = "_hl_key_gui",
  [sym__hl_quoted_name] = "_hl_quoted_name",
  [sym_color] = "color",
  [sym__hl_key_gui_color] = "_hl_key_gui_color",
  [sym_font] = "font",
  [sym__hl_key_font] = "_hl_key_font",
  [sym__hl_key_blend] = "_hl_key_blend",
  [sym_hl_attribute] = "hl_attribute",
  [sym__hl_body_keys] = "_hl_body_keys",
  [sym__hl_body] = "_hl_body",
  [sym_highlight_statement] = "highlight_statement",
  [sym__syn_enable] = "_syn_enable",
  [sym__syn_case] = "_syn_case",
  [sym__syn_spell] = "_syn_spell",
  [sym__syn_foldlevel] = "_syn_foldlevel",
  [sym__syn_iskeyword] = "_syn_iskeyword",
  [sym__syn_conceal] = "_syn_conceal",
  [sym__syn_hl_pattern] = "_syn_hl_pattern",
  [sym_hl_groups] = "hl_groups",
  [sym__syn_arguments_keyword] = "_syn_arguments_keyword",
  [sym__syn_arguments_match] = "_syn_arguments_match",
  [sym__syn_arguments_region] = "syntax_argument",
  [sym__syn_arguments_cluster] = "syntax_argument",
  [sym__syn_pattern_offset] = "pattern_offset",
  [sym__syn_keyword] = "_syn_keyword",
  [sym__syn_match] = "_syn_match",
  [sym__syn_region_start] = "syntax_argument",
  [sym__syn_region_skip] = "syntax_argument",
  [sym__syn_region_end] = "syntax_argument",
  [sym__syn_region] = "_syn_region",
  [sym__syn_cluster] = "_syn_cluster",
  [sym__syn_include] = "_syn_include",
  [sym__syn_sync_lines] = "_syn_sync_lines",
  [sym__syn_sync] = "_syn_sync",
  [sym__syn_list] = "_syn_list",
  [sym__syn_clear] = "_syn_clear",
  [sym_syntax_statement] = "syntax_statement",
  [sym_edit_statement] = "edit_statement",
  [sym_enew_statement] = "enew_statement",
  [sym_find_statement] = "find_statement",
  [sym_ex_statement] = "ex_statement",
  [sym_visual_statement] = "visual_statement",
  [sym_view_statement] = "view_statement",
  [aux_sym__statement_repeat1] = "_statement_repeat1",
  [aux_sym_unknown_builtin_statement_repeat1] = "unknown_builtin_statement_repeat1",
  [aux_sym_filetypes_repeat1] = "filetypes_repeat1",
  [aux_sym_runtime_statement_repeat1] = "runtime_statement_repeat1",
  [aux_sym_script_repeat1] = "script_repeat1",
  [aux_sym_if_statement_repeat1] = "if_statement_repeat1",
  [aux_sym_try_statement_repeat1] = "try_statement_repeat1",
  [aux_sym__bang_filter_command_argument_repeat1] = "_bang_filter_command_argument_repeat1",
  [aux_sym__bang_filter_command_repeat1] = "_bang_filter_command_repeat1",
  [aux_sym_identifier_repeat1] = "identifier_repeat1",
  [aux_sym_let_statement_repeat1] = "let_statement_repeat1",
  [aux_sym__let_heredoc_repeat1] = "_let_heredoc_repeat1",
  [aux_sym_set_statement_repeat1] = "set_statement_repeat1",
  [aux_sym_unlet_statement_repeat1] = "unlet_statement_repeat1",
  [aux_sym_function_definition_repeat1] = "function_definition_repeat1",
  [aux_sym_parameters_repeat1] = "parameters_repeat1",
  [aux_sym_parameters_repeat2] = "parameters_repeat2",
  [aux_sym_map_statement_repeat1] = "map_statement_repeat1",
  [aux_sym__map_lhs_repeat1] = "_map_lhs_repeat1",
  [aux_sym__map_rhs_statement_repeat1] = "_map_rhs_statement_repeat1",
  [aux_sym__map_rhs_repeat1] = "_map_rhs_repeat1",
  [aux_sym__sign_define_repeat1] = "_sign_define_repeat1",
  [aux_sym__sign_place_place_repeat1] = "_sign_place_place_repeat1",
  [aux_sym__sign_unplace_id_repeat1] = "_sign_unplace_id_repeat1",
  [aux_sym__sign_jump_repeat1] = "_sign_jump_repeat1",
  [aux_sym_list_repeat1] = "list_repeat1",
  [aux_sym_filename_repeat1] = "filename_repeat1",
  [aux_sym__pattern_ordinary_atom_repeat1] = "_pattern_ordinary_atom_repeat1",
  [aux_sym__pattern_branch_repeat1] = "_pattern_branch_repeat1",
  [aux_sym_pattern_repeat1] = "pattern_repeat1",
  [aux_sym_dictionnary_repeat1] = "dictionnary_repeat1",
  [aux_sym_literal_dictionary_repeat1] = "literal_dictionary_repeat1",
  [aux_sym_au_event_list_repeat1] = "au_event_list_repeat1",
  [aux_sym__autocmd_pattern_repeat1] = "_autocmd_pattern_repeat1",
  [aux_sym_command_statement_repeat1] = "command_statement_repeat1",
  [aux_sym__hl_attr_list_repeat1] = "_hl_attr_list_repeat1",
  [aux_sym__hl_body_keys_repeat1] = "_hl_body_keys_repeat1",
  [aux_sym_hl_groups_repeat1] = "hl_groups_repeat1",
  [aux_sym__syn_keyword_repeat1] = "_syn_keyword_repeat1",
  [aux_sym__syn_keyword_repeat2] = "_syn_keyword_repeat2",
  [aux_sym__syn_match_repeat1] = "_syn_match_repeat1",
  [aux_sym__syn_match_repeat2] = "_syn_match_repeat2",
  [aux_sym__syn_region_repeat1] = "_syn_region_repeat1",
  [aux_sym__syn_region_repeat2] = "_syn_region_repeat2",
  [aux_sym__syn_cluster_repeat1] = "_syn_cluster_repeat1",
  [aux_sym__syn_sync_repeat1] = "_syn_sync_repeat1",
  [aux_sym_edit_statement_repeat1] = "edit_statement_repeat1",
  [aux_sym_edit_statement_repeat2] = "edit_statement_repeat2",
  [alias_sym_arguments] = "arguments",
  [alias_sym_augroup_name] = "augroup_name",
  [alias_sym_body] = "body",
  [alias_sym_file] = "file",
  [alias_sym_filenames] = "filenames",
  [alias_sym_filter_command] = "filter_command",
  [alias_sym_name] = "name",
  [alias_sym_range] = "range",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_keyword] = sym_keyword,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_a_COLON] = anon_sym_a_COLON,
  [aux_sym_normal_statement_token1] = aux_sym_normal_statement_token1,
  [sym_filetype] = sym_filetype,
  [aux_sym__filetype_immediate_token1] = sym_filetype,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_FALLBACK] = anon_sym_FALLBACK,
  [anon_sym_dos] = anon_sym_dos,
  [anon_sym_unix] = anon_sym_dos,
  [anon_sym_mac] = anon_sym_dos,
  [anon_sym_latin1] = anon_sym_latin1,
  [anon_sym_iso] = anon_sym_iso,
  [anon_sym_koi8] = anon_sym_koi8,
  [anon_sym_macroman] = anon_sym_macroman,
  [anon_sym_cp437] = anon_sym_cp437,
  [anon_sym_cp737] = anon_sym_cp737,
  [anon_sym_cp775] = anon_sym_cp775,
  [anon_sym_cp850] = anon_sym_cp850,
  [anon_sym_cp852] = anon_sym_cp852,
  [anon_sym_cp855] = anon_sym_cp855,
  [anon_sym_cp857] = anon_sym_cp857,
  [anon_sym_cp860] = anon_sym_cp860,
  [anon_sym_cp861] = anon_sym_cp861,
  [anon_sym_cp862] = anon_sym_cp862,
  [anon_sym_cp863] = anon_sym_cp863,
  [anon_sym_cp865] = anon_sym_cp865,
  [anon_sym_cp866] = anon_sym_cp866,
  [anon_sym_cp869] = anon_sym_cp869,
  [anon_sym_cp874] = anon_sym_cp874,
  [anon_sym_cp1250] = anon_sym_cp1250,
  [anon_sym_cp1251] = anon_sym_cp1251,
  [anon_sym_cp1253] = anon_sym_cp1253,
  [anon_sym_cp1254] = anon_sym_cp1254,
  [anon_sym_cp1255] = anon_sym_cp1255,
  [anon_sym_cp1256] = anon_sym_cp1256,
  [anon_sym_cp1257] = anon_sym_cp1257,
  [anon_sym_cp1258] = anon_sym_cp1258,
  [anon_sym_cp932] = anon_sym_cp932,
  [anon_sym_euc_DASHjp] = anon_sym_euc_DASHjp,
  [anon_sym_sjis] = anon_sym_sjis,
  [anon_sym_cp949] = anon_sym_cp949,
  [anon_sym_euc_DASHkr] = anon_sym_euc_DASHkr,
  [anon_sym_cp936] = anon_sym_cp936,
  [anon_sym_euc_DASHcn] = anon_sym_euc_DASHcn,
  [anon_sym_cp950] = anon_sym_cp950,
  [anon_sym_big5] = anon_sym_big5,
  [anon_sym_euc_DASHtw] = anon_sym_euc_DASHtw,
  [anon_sym_utf_DASH8] = anon_sym_utf_DASH8,
  [anon_sym_ucs_DASH2] = anon_sym_ucs_DASH2,
  [anon_sym_ucs_DASH21e] = anon_sym_ucs_DASH21e,
  [anon_sym_utf_DASH16] = anon_sym_utf_DASH16,
  [anon_sym_utf_DASH16le] = anon_sym_utf_DASH16le,
  [anon_sym_ucs_DASH4] = anon_sym_ucs_DASH4,
  [anon_sym_ucs_DASH4le] = anon_sym_ucs_DASH4le,
  [anon_sym_ansi] = anon_sym_ansi,
  [anon_sym_japan] = anon_sym_japan,
  [anon_sym_korea] = anon_sym_korea,
  [anon_sym_prc] = anon_sym_prc,
  [anon_sym_chinese] = anon_sym_chinese,
  [anon_sym_taiwan] = anon_sym_taiwan,
  [anon_sym_utf8] = anon_sym_utf8,
  [anon_sym_unicode] = anon_sym_unicode,
  [anon_sym_ucs2be] = anon_sym_ucs2be,
  [anon_sym_ucs_DASH2be] = anon_sym_ucs_DASH2be,
  [anon_sym_ucs_DASH4be] = anon_sym_ucs_DASH4be,
  [anon_sym_utf_DASH32] = anon_sym_utf_DASH32,
  [anon_sym_utf_DASH32le] = anon_sym_utf_DASH32le,
  [anon_sym_default] = anon_sym_default,
  [anon_sym_latin12] = sym_encoding,
  [anon_sym_iso2] = sym_encoding,
  [anon_sym_koi82] = sym_encoding,
  [anon_sym_macroman2] = sym_encoding,
  [anon_sym_cp4372] = sym_encoding,
  [anon_sym_cp7372] = sym_encoding,
  [anon_sym_cp7752] = sym_encoding,
  [anon_sym_cp8502] = sym_encoding,
  [anon_sym_cp8522] = sym_encoding,
  [anon_sym_cp8552] = sym_encoding,
  [anon_sym_cp8572] = sym_encoding,
  [anon_sym_cp8602] = sym_encoding,
  [anon_sym_cp8612] = sym_encoding,
  [anon_sym_cp8622] = sym_encoding,
  [anon_sym_cp8632] = sym_encoding,
  [anon_sym_cp8652] = sym_encoding,
  [anon_sym_cp8662] = sym_encoding,
  [anon_sym_cp8692] = sym_encoding,
  [anon_sym_cp8742] = sym_encoding,
  [anon_sym_cp12502] = sym_encoding,
  [anon_sym_cp12512] = sym_encoding,
  [anon_sym_cp12532] = sym_encoding,
  [anon_sym_cp12542] = sym_encoding,
  [anon_sym_cp12552] = sym_encoding,
  [anon_sym_cp12562] = sym_encoding,
  [anon_sym_cp12572] = sym_encoding,
  [anon_sym_cp12582] = sym_encoding,
  [anon_sym_cp9322] = sym_encoding,
  [anon_sym_euc_DASHjp2] = sym_encoding,
  [anon_sym_sjis2] = sym_encoding,
  [anon_sym_cp9492] = sym_encoding,
  [anon_sym_euc_DASHkr2] = sym_encoding,
  [anon_sym_cp9362] = sym_encoding,
  [anon_sym_euc_DASHcn2] = sym_encoding,
  [anon_sym_cp9502] = sym_encoding,
  [anon_sym_big52] = sym_encoding,
  [anon_sym_euc_DASHtw2] = sym_encoding,
  [anon_sym_utf_DASH82] = sym_encoding,
  [anon_sym_ucs_DASH22] = sym_encoding,
  [anon_sym_ucs_DASH21e2] = sym_encoding,
  [anon_sym_utf_DASH162] = sym_encoding,
  [anon_sym_utf_DASH16le2] = sym_encoding,
  [anon_sym_ucs_DASH42] = sym_encoding,
  [anon_sym_ucs_DASH4le2] = sym_encoding,
  [anon_sym_ansi2] = sym_encoding,
  [anon_sym_japan2] = sym_encoding,
  [anon_sym_korea2] = sym_encoding,
  [anon_sym_prc2] = sym_encoding,
  [anon_sym_chinese2] = sym_encoding,
  [anon_sym_taiwan2] = sym_encoding,
  [anon_sym_utf82] = sym_encoding,
  [anon_sym_unicode2] = sym_encoding,
  [anon_sym_ucs2be2] = sym_encoding,
  [anon_sym_ucs_DASH2be2] = sym_encoding,
  [anon_sym_ucs_DASH4be2] = sym_encoding,
  [anon_sym_utf_DASH322] = sym_encoding,
  [anon_sym_utf_DASH32le2] = sym_encoding,
  [anon_sym_default2] = sym_encoding,
  [anon_sym_START] = anon_sym_START,
  [anon_sym_OPT] = anon_sym_OPT,
  [anon_sym_PACK] = anon_sym_PACK,
  [anon_sym_ALL] = anon_sym_ALL,
  [aux_sym_wincmd_statement_token1] = aux_sym_wincmd_statement_token1,
  [anon_sym_on] = anon_sym_on,
  [anon_sym_off] = anon_sym_off,
  [anon_sym_detect] = anon_sym_detect,
  [anon_sym_plugin] = anon_sym_plugin,
  [anon_sym_indent] = anon_sym_indent,
  [sym_chunk] = sym_chunk,
  [sym__heredoc_line] = sym__heredoc_line,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_LF] = anon_sym_LF,
  [anon_sym_in] = anon_sym_in,
  [aux_sym__au_pattern_token1] = aux_sym__au_pattern_token1,
  [aux_sym__au_pattern_token2] = aux_sym__au_pattern_token2,
  [aux_sym__bang_filter_command_argument_token1] = aux_sym__bang_filter_command_argument_token1,
  [anon_sym_BSLASH] = anon_sym_BSLASH,
  [aux_sym__bang_filter_command_argument_token2] = aux_sym__bang_filter_command_argument_token2,
  [aux_sym__bang_filter_command_argument_token3] = aux_sym__bang_filter_command_argument_token3,
  [aux_sym__bang_filter_command_argument_token4] = aux_sym__bang_filter_command_argument_token4,
  [aux_sym_argument_token1] = sym_identifier,
  [aux_sym_argument_token2] = aux_sym_argument_token2,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_LBRACE2] = anon_sym_LBRACE,
  [aux_sym_identifier_token1] = aux_sym_identifier_token1,
  [aux_sym_identifier_token2] = aux_sym_identifier_token2,
  [aux_sym__immediate_identifier_token1] = aux_sym__immediate_identifier_token1,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_PERCENT_EQ] = anon_sym_PERCENT_EQ,
  [anon_sym_DOT_EQ] = anon_sym_DOT_EQ,
  [anon_sym_DOT_DOT_EQ] = anon_sym_DOT_DOT_EQ,
  [anon_sym_EQ_LT_LT] = anon_sym_EQ_LT_LT,
  [anon_sym_trim] = anon_sym_trim,
  [anon_sym_eval] = anon_sym_eval,
  [aux_sym_option_name_token1] = aux_sym_option_name_token1,
  [anon_sym_t_] = anon_sym_t_,
  [aux_sym_option_name_token2] = aux_sym_option_name_token2,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_vi] = anon_sym_vi,
  [anon_sym_vim] = anon_sym_vim,
  [anon_sym_all] = anon_sym_all,
  [anon_sym_all_AMP] = anon_sym_all_AMP,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_EQ2] = anon_sym_EQ,
  [anon_sym_COLON2] = anon_sym_COLON,
  [anon_sym_PLUS_EQ2] = anon_sym_PLUS_EQ,
  [anon_sym_CARET_EQ] = anon_sym_CARET_EQ,
  [anon_sym_DASH_EQ2] = anon_sym_DASH_EQ,
  [sym_set_value] = sym_set_value,
  [anon_sym_SPACE] = anon_sym_SPACE,
  [aux_sym_command_argument_token1] = aux_sym_command_argument_token1,
  [anon_sym_dict] = anon_sym_dict,
  [anon_sym_range] = anon_sym_range,
  [anon_sym_abort] = anon_sym_abort,
  [anon_sym_closure] = anon_sym_closure,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_AT] = anon_sym_AT,
  [sym_spread] = sym_spread,
  [sym__printable] = sym__printable,
  [sym_mark] = sym_mark,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_SLASH2] = anon_sym_SLASH,
  [anon_sym_QMARK2] = anon_sym_QMARK,
  [anon_sym_DOT2] = anon_sym_DOT,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DOLLAR] = anon_sym_DOLLAR,
  [anon_sym_BSLASH_SLASH] = anon_sym_BSLASH_SLASH,
  [anon_sym_BSLASH_QMARK] = anon_sym_BSLASH_QMARK,
  [anon_sym_BSLASH_AMP] = anon_sym_BSLASH_AMP,
  [anon_sym_LTbuffer_GT] = anon_sym_LTbuffer_GT,
  [anon_sym_LTnowait_GT] = anon_sym_LTnowait_GT,
  [anon_sym_LTsilent_GT] = anon_sym_LTsilent_GT,
  [anon_sym_LTunique_GT] = anon_sym_LTunique_GT,
  [anon_sym_LTscript_GT] = anon_sym_LTscript_GT,
  [anon_sym_LTexpr_GT] = anon_sym_LTexpr_GT,
  [sym__keycode_modifier] = sym__keycode_modifier,
  [aux_sym__keycode_in_token1] = aux_sym__keycode_in_token1,
  [aux_sym__keycode_in_token2] = aux_sym__keycode_in_token2,
  [aux_sym__keycode_in_token3] = aux_sym__keycode_in_token3,
  [aux_sym__keycode_in_token4] = aux_sym__keycode_in_token4,
  [aux_sym__keycode_in_token5] = aux_sym__keycode_in_token5,
  [aux_sym__keycode_in_token6] = aux_sym__keycode_in_token6,
  [aux_sym__keycode_in_token7] = aux_sym__keycode_in_token7,
  [aux_sym__keycode_in_token8] = aux_sym__keycode_in_token8,
  [aux_sym__keycode_in_token9] = aux_sym__keycode_in_token9,
  [aux_sym__keycode_in_token10] = aux_sym__keycode_in_token10,
  [aux_sym__keycode_in_token11] = aux_sym__keycode_in_token11,
  [aux_sym__keycode_in_token12] = aux_sym__keycode_in_token12,
  [aux_sym__keycode_in_token13] = aux_sym__keycode_in_token13,
  [aux_sym__keycode_in_token14] = aux_sym__keycode_in_token14,
  [aux_sym__keycode_in_token15] = aux_sym__keycode_in_token15,
  [aux_sym__keycode_in_token16] = aux_sym__keycode_in_token16,
  [aux_sym__keycode_in_token17] = aux_sym__keycode_in_token17,
  [aux_sym__keycode_in_token18] = aux_sym__keycode_in_token18,
  [aux_sym__keycode_in_token19] = aux_sym__keycode_in_token19,
  [aux_sym__keycode_in_token20] = aux_sym__keycode_in_token20,
  [aux_sym__keycode_in_token21] = aux_sym__keycode_in_token21,
  [aux_sym__keycode_in_token22] = aux_sym__keycode_in_token22,
  [aux_sym__keycode_in_token23] = aux_sym__keycode_in_token23,
  [aux_sym__keycode_in_token24] = aux_sym__keycode_in_token24,
  [aux_sym__keycode_in_token25] = aux_sym__keycode_in_token25,
  [aux_sym__keycode_in_token26] = aux_sym__keycode_in_token26,
  [aux_sym__keycode_in_token27] = aux_sym__keycode_in_token27,
  [aux_sym__keycode_in_token28] = aux_sym__keycode_in_token28,
  [aux_sym__keycode_in_token29] = aux_sym__keycode_in_token29,
  [aux_sym__keycode_in_token30] = aux_sym__keycode_in_token30,
  [aux_sym__keycode_in_token31] = aux_sym__keycode_in_token31,
  [aux_sym__keycode_in_token32] = aux_sym__keycode_in_token32,
  [aux_sym__keycode_in_token33] = aux_sym__keycode_in_token33,
  [aux_sym__keycode_in_token34] = aux_sym__keycode_in_token34,
  [aux_sym__keycode_in_token35] = aux_sym__keycode_in_token35,
  [aux_sym__keycode_in_token36] = aux_sym__keycode_in_token36,
  [aux_sym__keycode_in_token37] = aux_sym__keycode_in_token37,
  [aux_sym__keycode_in_token38] = aux_sym__keycode_in_token38,
  [aux_sym__keycode_in_token39] = aux_sym__keycode_in_token39,
  [aux_sym__keycode_in_token40] = aux_sym__keycode_in_token40,
  [aux_sym__keycode_in_token41] = aux_sym__keycode_in_token41,
  [aux_sym__keycode_in_token42] = aux_sym__keycode_in_token42,
  [aux_sym__keycode_in_token43] = aux_sym__keycode_in_token43,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_LT2] = anon_sym_LT,
  [anon_sym_BSLASH2] = anon_sym_BSLASH,
  [aux_sym__map_lhs_token1] = aux_sym__map_lhs_token1,
  [aux_sym__map_rhs_statement_token1] = sym_keycode,
  [anon_sym_BSLASH_PIPE] = anon_sym_BSLASH_PIPE,
  [aux_sym__map_rhs_statement_token2] = sym_keycode,
  [aux_sym__map_rhs_statement_token3] = sym_keycode,
  [aux_sym__map_rhs_token1] = aux_sym__map_rhs_token1,
  [aux_sym__map_rhs_token2] = aux_sym__map_rhs_token2,
  [anon_sym_icon] = anon_sym_icon,
  [anon_sym_linehl] = anon_sym_linehl,
  [anon_sym_numhl] = anon_sym_numhl,
  [anon_sym_text] = anon_sym_text,
  [anon_sym_texthl] = anon_sym_texthl,
  [anon_sym_culhl] = anon_sym_culhl,
  [anon_sym_define] = anon_sym_define,
  [anon_sym_undefine] = anon_sym_undefine,
  [anon_sym_list] = anon_sym_list,
  [anon_sym_line] = anon_sym_line,
  [anon_sym_name] = anon_sym_name,
  [anon_sym_buffer] = anon_sym_buffer,
  [anon_sym_group] = anon_sym_group,
  [anon_sym_priority] = anon_sym_priority,
  [anon_sym_file] = anon_sym_file,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_place] = anon_sym_place,
  [anon_sym_STAR2] = anon_sym_STAR,
  [anon_sym_unplace] = anon_sym_unplace,
  [anon_sym_jump] = anon_sym_jump,
  [anon_sym_POUND] = anon_sym_POUND,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_DOT_DOT] = anon_sym_DOT_DOT,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_GT2] = anon_sym_GT,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_EQ_TILDE] = anon_sym_EQ_TILDE,
  [anon_sym_BANG_TILDE] = anon_sym_BANG_TILDE,
  [anon_sym_is] = anon_sym_is,
  [anon_sym_isnot] = anon_sym_isnot,
  [anon_sym_BANG2] = anon_sym_BANG,
  [sym_float_literal] = sym_float_literal,
  [sym_integer_literal] = sym_integer_literal,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_LPAREN2] = anon_sym_LPAREN,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [aux_sym_filename_token1] = aux_sym_filename_token1,
  [aux_sym_filename_token2] = aux_sym_filename_token2,
  [aux_sym_filename_token3] = aux_sym_filename_token3,
  [aux_sym_filename_token4] = aux_sym_filename_token4,
  [aux_sym_filename_token5] = aux_sym_filename_token5,
  [aux_sym_filename_token6] = aux_sym_filename_token6,
  [aux_sym_filename_token7] = aux_sym_filename_token7,
  [aux_sym_filename_token8] = aux_sym_filename_token8,
  [aux_sym_pattern_multi_token1] = aux_sym_pattern_multi_token1,
  [aux_sym_pattern_multi_token2] = aux_sym_pattern_multi_token2,
  [aux_sym_pattern_multi_token3] = aux_sym_pattern_multi_token3,
  [aux_sym__pattern_ordinary_atom_token1] = aux_sym__pattern_ordinary_atom_token1,
  [aux_sym__pattern_ordinary_atom_token2] = aux_sym__pattern_ordinary_atom_token2,
  [anon_sym_BSLASH_LPAREN] = anon_sym_BSLASH_LPAREN,
  [anon_sym_BSLASH_RPAREN] = anon_sym_BSLASH_RPAREN,
  [anon_sym_BSLASH_PERCENT_LPAREN] = anon_sym_BSLASH_PERCENT_LPAREN,
  [anon_sym_BSLASHz_LPAREN] = anon_sym_BSLASHz_LPAREN,
  [sym_register] = sym_register,
  [sym_literal_key] = sym_literal_key,
  [anon_sym_POUND_LBRACE] = anon_sym_POUND_LBRACE,
  [anon_sym_keep] = anon_sym_keep,
  [anon_sym_drop] = anon_sym_drop,
  [anon_sym_PLUS_PLUS] = anon_sym_PLUS_PLUS,
  [anon_sym_ff] = anon_sym_ff,
  [anon_sym_fileformat] = anon_sym_fileformat,
  [anon_sym_enc] = anon_sym_enc,
  [anon_sym_encoding] = anon_sym_encoding,
  [anon_sym_bin] = anon_sym_bin,
  [anon_sym_binary] = anon_sym_binary,
  [anon_sym_nobin] = anon_sym_nobin,
  [anon_sym_nobinary] = anon_sym_nobinary,
  [anon_sym_bad] = anon_sym_bad,
  [anon_sym_edit] = anon_sym_edit,
  [aux_sym__plus_cmd_arg_token1] = aux_sym__plus_cmd_arg_token1,
  [sym_au_event] = sym_au_event,
  [aux_sym__autocmd_pattern_token1] = sym_pattern,
  [sym_au_once] = sym_au_once,
  [sym_au_nested] = sym_au_nested,
  [sym_command_name] = sym_command_name,
  [anon_sym_arglist] = anon_sym_arglist,
  [anon_sym_augroup] = anon_sym_augroup,
  [anon_sym_buffer2] = anon_sym_buffer,
  [anon_sym_behave] = anon_sym_behave,
  [anon_sym_color] = anon_sym_color,
  [anon_sym_command] = anon_sym_command,
  [anon_sym_compiler] = anon_sym_compiler,
  [anon_sym_dir] = anon_sym_dir,
  [anon_sym_environment] = anon_sym_environment,
  [anon_sym_even] = anon_sym_even,
  [anon_sym_expression] = anon_sym_expression,
  [anon_sym_file2] = anon_sym_file,
  [anon_sym_file_in_path] = anon_sym_file_in_path,
  [anon_sym_filetype] = anon_sym_filetype,
  [anon_sym_function] = anon_sym_function,
  [anon_sym_help] = anon_sym_help,
  [anon_sym_highlight] = anon_sym_highlight,
  [anon_sym_history] = anon_sym_history,
  [anon_sym_local] = anon_sym_local,
  [anon_sym_lua] = anon_sym_lua,
  [anon_sym_mapclear] = anon_sym_mapclear,
  [anon_sym_mapping] = anon_sym_mapping,
  [anon_sym_menu] = anon_sym_menu,
  [anon_sym_messages] = anon_sym_messages,
  [anon_sym_option] = anon_sym_option,
  [anon_sym_packadd] = anon_sym_packadd,
  [anon_sym_shellcmd] = anon_sym_shellcmd,
  [anon_sym_sign] = anon_sym_sign,
  [anon_sym_syntax] = anon_sym_syntax,
  [anon_sym_syntime] = anon_sym_syntime,
  [anon_sym_tag] = anon_sym_tag,
  [anon_sym_tag_listfiles] = anon_sym_tag_listfiles,
  [anon_sym_user] = anon_sym_user,
  [anon_sym_var] = anon_sym_var,
  [anon_sym_custom] = anon_sym_custom,
  [anon_sym_COMMA2] = anon_sym_COMMA,
  [anon_sym_customlist] = anon_sym_customlist,
  [anon_sym_lines] = anon_sym_lines,
  [anon_sym_arguments] = anon_sym_arguments,
  [anon_sym_buffers] = anon_sym_buffers,
  [anon_sym_loaded_buffers] = anon_sym_loaded_buffers,
  [anon_sym_windows] = anon_sym_windows,
  [anon_sym_tabs] = anon_sym_tabs,
  [anon_sym_quickfix] = anon_sym_quickfix,
  [anon_sym_other] = anon_sym_other,
  [aux_sym__command_attribute_nargs_value_token1] = sym_integer_literal,
  [aux_sym__command_attribute_nargs_value_token2] = sym_pattern_multi,
  [anon_sym_PERCENT2] = sym_pattern_multi,
  [anon_sym_DASHnargs] = anon_sym_DASHnargs,
  [anon_sym_DASHcomplete] = anon_sym_DASHcomplete,
  [anon_sym_DASHrange] = anon_sym_DASHrange,
  [anon_sym_DASHcount] = anon_sym_DASHcount,
  [anon_sym_DASHaddr] = anon_sym_DASHaddr,
  [anon_sym_DASHbang] = anon_sym_DASHbang,
  [anon_sym_DASHbar] = anon_sym_DASHbar,
  [anon_sym_DASHregister] = anon_sym_DASHregister,
  [anon_sym_DASHbuffer] = anon_sym_DASHbuffer,
  [anon_sym_DASHkeepscript] = anon_sym_DASHkeepscript,
  [aux_sym_command_statement_token1] = aux_sym_command_statement_token1,
  [sym_hl_group] = sym_hl_group,
  [anon_sym_link] = anon_sym_link,
  [anon_sym_clear] = anon_sym_clear,
  [anon_sym_NONE] = sym_hl_group,
  [anon_sym_NONE2] = anon_sym_NONE,
  [anon_sym_bold] = anon_sym_bold,
  [anon_sym_underline] = anon_sym_underline,
  [anon_sym_undercurl] = anon_sym_undercurl,
  [anon_sym_underdouble] = anon_sym_underdouble,
  [anon_sym_underdotted] = anon_sym_underdotted,
  [anon_sym_underdashed] = anon_sym_underdashed,
  [anon_sym_strikethrough] = anon_sym_strikethrough,
  [anon_sym_reverse] = anon_sym_reverse,
  [anon_sym_inverse] = anon_sym_inverse,
  [anon_sym_italic] = anon_sym_italic,
  [anon_sym_standout] = anon_sym_standout,
  [anon_sym_nocombine] = anon_sym_nocombine,
  [anon_sym_term] = anon_sym_term,
  [anon_sym_cterm] = anon_sym_cterm,
  [aux_sym__hl_term_list_token1] = aux_sym__hl_term_list_token1,
  [anon_sym_start] = anon_sym_start,
  [anon_sym_stop] = anon_sym_stop,
  [sym__hl_color_nr] = sym__hl_color_nr,
  [anon_sym_ctermfg] = anon_sym_ctermfg,
  [anon_sym_ctermbg] = anon_sym_ctermbg,
  [anon_sym_gui] = anon_sym_gui,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [aux_sym__hl_quoted_name_token1] = aux_sym__hl_quoted_name_token1,
  [anon_sym_SQUOTE2] = anon_sym_SQUOTE,
  [anon_sym_bg] = anon_sym_bg,
  [anon_sym_background] = anon_sym_background,
  [anon_sym_fg] = anon_sym_fg,
  [anon_sym_foreground] = anon_sym_foreground,
  [aux_sym_color_token1] = aux_sym_color_token1,
  [aux_sym_color_token2] = aux_sym_color_token2,
  [anon_sym_guifg] = anon_sym_guifg,
  [anon_sym_guibg] = anon_sym_guibg,
  [anon_sym_guisp] = anon_sym_guisp,
  [aux_sym_font_token1] = aux_sym_font_token1,
  [anon_sym_font] = anon_sym_font,
  [anon_sym_blend] = anon_sym_blend,
  [anon_sym_enable] = anon_sym_enable,
  [anon_sym_reset] = anon_sym_reset,
  [anon_sym_case] = anon_sym_case,
  [anon_sym_match] = anon_sym_match,
  [anon_sym_ignore] = anon_sym_ignore,
  [anon_sym_spell] = anon_sym_spell,
  [anon_sym_toplevel] = anon_sym_toplevel,
  [anon_sym_notoplevel] = anon_sym_notoplevel,
  [anon_sym_foldlevel] = anon_sym_foldlevel,
  [anon_sym_minimum] = anon_sym_minimum,
  [anon_sym_iskeyword] = anon_sym_iskeyword,
  [aux_sym__syn_iskeyword_token1] = aux_sym__syn_iskeyword_token1,
  [anon_sym_conceal] = anon_sym_conceal,
  [anon_sym_cchar] = anon_sym_cchar,
  [anon_sym_contained] = anon_sym_contained,
  [anon_sym_containedin] = anon_sym_containedin,
  [anon_sym_nextgroup] = anon_sym_nextgroup,
  [anon_sym_transparent] = anon_sym_transparent,
  [anon_sym_skipwhite] = anon_sym_skipwhite,
  [anon_sym_skipnl] = anon_sym_skipnl,
  [anon_sym_skipempty] = anon_sym_skipempty,
  [anon_sym_contains] = anon_sym_contains,
  [anon_sym_fold] = anon_sym_fold,
  [anon_sym_display] = anon_sym_display,
  [anon_sym_extend] = anon_sym_extend,
  [anon_sym_keepend] = anon_sym_keepend,
  [anon_sym_excludenl] = anon_sym_excludenl,
  [anon_sym_matchgroup] = anon_sym_matchgroup,
  [anon_sym_oneline] = anon_sym_oneline,
  [anon_sym_concealends] = anon_sym_concealends,
  [anon_sym_add] = anon_sym_add,
  [anon_sym_remove] = anon_sym_remove,
  [anon_sym_ms] = anon_sym_ms,
  [anon_sym_me] = anon_sym_me,
  [anon_sym_hs] = anon_sym_hs,
  [anon_sym_he] = anon_sym_he,
  [anon_sym_rs] = anon_sym_rs,
  [anon_sym_re] = anon_sym_re,
  [anon_sym_lc] = anon_sym_lc,
  [aux_sym__syn_pattern_offset_token1] = aux_sym__syn_pattern_offset_token1,
  [aux_sym__syn_pattern_offset_token2] = aux_sym__syn_pattern_offset_token2,
  [anon_sym_keyword] = anon_sym_keyword,
  [aux_sym__syn_keyword_token1] = sym_keyword,
  [anon_sym_skip] = anon_sym_skip,
  [anon_sym_end] = anon_sym_end,
  [anon_sym_region] = anon_sym_region,
  [anon_sym_cluster] = anon_sym_cluster,
  [anon_sym_include] = anon_sym_include,
  [anon_sym_minlines] = anon_sym_minlines,
  [anon_sym_maxlines] = anon_sym_maxlines,
  [aux_sym__syn_sync_lines_token1] = aux_sym__syn_sync_lines_token1,
  [anon_sym_sync] = anon_sym_sync,
  [anon_sym_linebreaks] = anon_sym_linebreaks,
  [anon_sym_fromstart] = anon_sym_fromstart,
  [anon_sym_ccomment] = anon_sym_ccomment,
  [anon_sym_lines2] = anon_sym_lines,
  [anon_sym_grouphere] = anon_sym_grouphere,
  [anon_sym_groupthere] = anon_sym_groupthere,
  [anon_sym_linecont] = anon_sym_linecont,
  [sym__no] = sym__no,
  [sym__inv] = sym__inv,
  [sym__newline_or_pipe] = sym__newline_or_pipe,
  [sym__line_continuation] = sym__line_continuation,
  [sym__script_heredoc_marker] = sym__script_heredoc_marker,
  [sym__let_heredoc_marker] = sym__script_heredoc_marker,
  [sym__heredoc_end] = sym__heredoc_end,
  [sym__separator_first] = sym__separator_first,
  [sym__separator] = sym__separator,
  [sym__scope_dict] = sym__scope_dict,
  [sym_scope] = sym_scope,
  [sym_string_literal] = sym_string_literal,
  [sym_comment] = sym_comment,
  [sym_line_continuation_comment] = sym_line_continuation_comment,
  [sym__bang_filter] = sym__bang_filter,
  [sym__function] = anon_sym_function,
  [sym__endfunction] = sym__endfunction,
  [sym__for] = sym__for,
  [sym__endfor] = sym__endfor,
  [sym__while] = sym__while,
  [sym__endwhile] = sym__endwhile,
  [sym__if] = sym__if,
  [sym__elseif] = sym__elseif,
  [sym__else] = sym__else,
  [sym__endif] = sym__endif,
  [sym__try] = sym__try,
  [sym__catch] = sym__catch,
  [sym__cnext] = sym__cnext,
  [sym__cprevious] = sym__cprevious,
  [sym__cNext] = sym__cNext,
  [sym__finally] = sym__finally,
  [sym__endtry] = sym__endtry,
  [sym__const] = sym__const,
  [sym__normal] = sym__normal,
  [sym__return] = sym__return,
  [sym__perl] = sym__perl,
  [sym__lua] = anon_sym_lua,
  [sym__ruby] = sym__ruby,
  [sym__python] = sym__python,
  [sym__throw] = sym__throw,
  [sym__execute] = sym__execute,
  [sym__autocmd] = sym__autocmd,
  [sym__silent] = sym__silent,
  [sym__echo] = sym__echo,
  [sym__echon] = sym__echon,
  [sym__echohl] = sym__echohl,
  [sym__echomsg] = sym__echomsg,
  [sym__echoerr] = sym__echoerr,
  [sym__map] = sym__map,
  [sym__nmap] = sym__nmap,
  [sym__vmap] = sym__vmap,
  [sym__xmap] = sym__xmap,
  [sym__smap] = sym__smap,
  [sym__omap] = sym__omap,
  [sym__imap] = sym__imap,
  [sym__lmap] = sym__lmap,
  [sym__cmap] = sym__cmap,
  [sym__tmap] = sym__tmap,
  [sym__noremap] = sym__noremap,
  [sym__nnoremap] = sym__nnoremap,
  [sym__vnoremap] = sym__vnoremap,
  [sym__xnoremap] = sym__xnoremap,
  [sym__snoremap] = sym__snoremap,
  [sym__onoremap] = sym__onoremap,
  [sym__inoremap] = sym__inoremap,
  [sym__lnoremap] = sym__lnoremap,
  [sym__cnoremap] = sym__cnoremap,
  [sym__tnoremap] = sym__tnoremap,
  [sym__augroup] = anon_sym_augroup,
  [sym__highlight] = anon_sym_highlight,
  [sym__default] = anon_sym_default,
  [sym__syntax] = anon_sym_syntax,
  [sym__set] = sym__set,
  [sym__setlocal] = sym__setlocal,
  [sym__setfiletype] = sym__setfiletype,
  [sym__browse] = sym__browse,
  [sym__options] = sym__options,
  [sym__startinsert] = sym__startinsert,
  [sym__stopinsert] = sym__stopinsert,
  [sym__scriptencoding] = sym__scriptencoding,
  [sym__source] = sym__source,
  [sym__global] = sym__global,
  [sym__colorscheme] = sym__colorscheme,
  [sym__command] = anon_sym_command,
  [sym__comclear] = sym__comclear,
  [sym__delcommand] = sym__delcommand,
  [sym__runtime] = sym__runtime,
  [sym__wincmd] = sym__wincmd,
  [sym__sign] = anon_sym_sign,
  [sym__filetype] = anon_sym_filetype,
  [sym__let] = sym__let,
  [sym__unlet] = sym__unlet,
  [sym__call] = sym__call,
  [sym__break] = sym__break,
  [sym__continue] = sym__continue,
  [sym__vertical] = sym__vertical,
  [sym__leftabove] = sym__leftabove,
  [sym__aboveleft] = sym__aboveleft,
  [sym__rightbelow] = sym__rightbelow,
  [sym__belowright] = sym__belowright,
  [sym__topleft] = sym__topleft,
  [sym__botright] = sym__botright,
  [sym__edit] = anon_sym_edit,
  [sym__enew] = sym__enew,
  [sym__find] = sym__find,
  [sym__ex] = sym__ex,
  [sym__visual] = sym__visual,
  [sym__view] = sym__view,
  [sym__eval] = anon_sym_eval,
  [sym_unknown_command_name] = sym_unknown_command_name,
  [sym_script_file] = sym_script_file,
  [sym__cmd_separator] = sym__cmd_separator,
  [aux_sym__separated_statements] = aux_sym__separated_statements,
  [sym__statement] = sym__statement,
  [sym_unknown_builtin_statement] = sym_unknown_builtin_statement,
  [sym_return_statement] = sym_return_statement,
  [sym_break_statement] = sym_break_statement,
  [sym_continue_statement] = sym_continue_statement,
  [sym_scope_dict] = sym_scope_dict,
  [sym_normal_statement] = sym_normal_statement,
  [sym__filetype_immediate] = sym__filetype_immediate,
  [sym_filetypes] = sym_filetypes,
  [sym_setfiletype_statement] = sym_setfiletype_statement,
  [sym_options_statement] = sym_options_statement,
  [sym_startinsert_statement] = sym_startinsert_statement,
  [sym_stopinsert_statement] = sym_stopinsert_statement,
  [sym__immediate_file_format] = sym__immediate_file_format,
  [sym_encoding] = sym_encoding,
  [sym__immediate_encoding] = sym__immediate_encoding,
  [sym_scriptencoding_statement] = sym_scriptencoding_statement,
  [sym_cnext_statement] = sym_cnext_statement,
  [sym_cprevious_statement] = sym_cprevious_statement,
  [sym__runtime_where] = sym__runtime_where,
  [sym_runtime_statement] = sym_runtime_statement,
  [sym_wincmd_statement] = sym_wincmd_statement,
  [sym_source_statement] = sym_source_statement,
  [sym_global_statement] = sym_global_statement,
  [sym__filetype_state] = sym__filetype_state,
  [sym__filetype_enable] = sym__filetype_enable,
  [sym__filetype_detect] = sym__filetype_detect,
  [sym__filetype_plugin] = sym__filetype_plugin,
  [sym__filetype_indent] = sym__filetype_indent,
  [sym_filetype_statement] = sym_filetype_statement,
  [sym_colorscheme_statement] = sym_colorscheme_statement,
  [sym_lua_statement] = sym_lua_statement,
  [sym_ruby_statement] = sym_ruby_statement,
  [sym_python_statement] = sym_python_statement,
  [sym_perl_statement] = sym_perl_statement,
  [sym_script] = sym_script,
  [sym_for_loop] = sym_for_loop,
  [sym_while_loop] = sym_while_loop,
  [sym_if_statement] = sym_if_statement,
  [sym_elseif_statement] = sym_elseif_statement,
  [sym_else_statement] = sym_else_statement,
  [sym_try_statement] = sym_try_statement,
  [sym__au_pattern] = sym_pattern,
  [sym_catch_statement] = sym_catch_statement,
  [sym_finally_statement] = sym_finally_statement,
  [sym_throw_statement] = sym_throw_statement,
  [sym__bang_filter_bangs] = sym__bang_filter_bangs,
  [sym__bang_filter_command_argument] = sym_command_argument,
  [sym__bang_filter_command] = aux_sym_command_statement_token1,
  [sym_bang_filter_statement] = sym_bang_filter_statement,
  [sym_scoped_identifier] = sym_scoped_identifier,
  [sym_argument] = sym_argument,
  [sym__curly_braces_name_expression] = sym__curly_braces_name_expression,
  [sym__immediate_curly_braces_name_expression] = sym__curly_braces_name_expression,
  [sym_identifier] = sym_identifier,
  [sym__immediate_identifier] = sym_identifier,
  [sym__ident] = sym__ident,
  [sym__let_operator] = sym__let_operator,
  [sym__assignment_variable] = sym__assignment_variable,
  [sym__let_assignment] = sym__let_assignment,
  [sym_let_statement] = sym_let_statement,
  [sym__const_assignment] = sym__const_assignment,
  [sym_const_statement] = sym_const_statement,
  [sym__let_heredoc] = sym__let_heredoc,
  [sym__let_heredoc_parameter] = sym__let_heredoc_parameter,
  [sym_option_name] = sym_option_name,
  [sym_no_option] = sym_no_option,
  [sym_inv_option] = sym_inv_option,
  [sym_default_option] = sym_default_option,
  [sym__set_option] = sym__set_option,
  [sym__set_operator] = sym__set_operator,
  [sym__set_rhs] = sym__set_rhs,
  [sym_set_item] = sym_set_item,
  [sym_set_statement] = sym_set_statement,
  [sym_setlocal_statement] = sym_setlocal_statement,
  [sym_unlet_statement] = sym_unlet_statement,
  [sym_call_statement] = sym_call_statement,
  [sym_echo_statement] = sym_echo_statement,
  [sym_echon_statement] = sym_echon_statement,
  [sym_echohl_statement] = sym_echohl_statement,
  [sym_echomsg_statement] = sym_echomsg_statement,
  [sym_echoerr_statement] = sym_echoerr_statement,
  [sym_execute_statement] = sym_execute_statement,
  [sym_silent_statement] = sym_silent_statement,
  [sym_vertical_statement] = sym_vertical_statement,
  [sym_topleft_statement] = sym_topleft_statement,
  [sym_botright_statement] = sym_botright_statement,
  [sym_aboveleft_statement] = sym_aboveleft_statement,
  [sym_belowright_statement] = sym_belowright_statement,
  [sym_user_command] = sym_user_command,
  [sym_command_argument] = sym_command_argument,
  [sym_function_definition] = sym_function_definition,
  [sym_function_declaration] = sym_function_declaration,
  [sym_parameters] = sym_parameters,
  [sym_default_parameter] = sym_default_parameter,
  [sym_bang] = sym_bang,
  [sym_range_statement] = sym_range_statement,
  [sym__range] = sym__range,
  [sym__range_explicit] = sym__range_explicit,
  [sym__range_marker] = sym__range_marker,
  [sym_current_line] = sym_current_line,
  [sym_next_line] = sym_next_line,
  [sym_last_line] = sym_last_line,
  [sym_previous_pattern] = sym_previous_pattern,
  [sym_register_statement] = sym_register_statement,
  [sym_map_statement] = sym_map_statement,
  [sym__map_definition] = sym__map_definition,
  [sym__keycode_in] = sym__keycode_in,
  [sym__immediate_keycode] = sym__immediate_keycode,
  [sym_keycode] = sym_keycode,
  [sym__map_lhs] = sym__map_lhs,
  [sym__map_rhs_statement] = sym__map_rhs_statement,
  [sym__map_rhs] = sym__map_lhs,
  [sym__sign_name] = sym__sign_name,
  [sym__sign_define_arg_text] = sym__sign_define_arg_text,
  [sym__sign_define_argument] = sym__sign_define_argument,
  [sym__sign_define] = sym__sign_define,
  [sym__sign_undefine] = sym__sign_undefine,
  [sym__sign_list] = sym__sign_list,
  [sym__sign_place_place_argument] = sym__sign_define_argument,
  [sym__sign_place_place] = sym__sign_place_place,
  [sym__sign_place_list_argument] = sym__sign_define_argument,
  [aux_sym__sign_place_list] = aux_sym__sign_place_list,
  [sym__sign_place] = sym__sign_place,
  [sym__sign_unplace_cursor_argument] = sym__sign_define_argument,
  [sym__sign_unplace_cursor] = sym__sign_unplace_cursor,
  [sym__sign_unplace_id_argument] = sym__sign_define_argument,
  [sym__sign_unplace_id] = sym__sign_unplace_id,
  [sym__sign_unplace] = sym__sign_unplace,
  [sym__sign_jump_argument] = sym__sign_define_argument,
  [sym__sign_jump] = sym__sign_jump,
  [sym_sign_statement] = sym_sign_statement,
  [sym__variable] = sym__variable,
  [sym__expression] = sym__expression,
  [sym_ternary_expression] = sym_ternary_expression,
  [sym_match_case] = sym_match_case,
  [sym_binary_operation] = sym_binary_operation,
  [sym_unary_operation] = sym_unary_operation,
  [sym_list] = sym_list,
  [sym_list_assignment] = sym_list_assignment,
  [sym_index_expression] = sym_index_expression,
  [sym_slice_expression] = sym_slice_expression,
  [sym_field_expression] = sym_field_expression,
  [sym_call_expression] = sym_call_expression,
  [sym_eval_statement] = sym_eval_statement,
  [sym__method_call_expression] = sym_call_expression,
  [sym_method_expression] = sym_method_expression,
  [sym_filename] = sym_filename,
  [sym_pattern_multi] = sym_pattern_multi,
  [aux_sym__pattern_ordinary_atom] = aux_sym__pattern_ordinary_atom,
  [sym__pattern_atom] = sym__pattern_atom,
  [sym__pattern_piece] = sym__pattern_piece,
  [aux_sym__pattern_concat] = aux_sym__pattern_concat,
  [sym__pattern_branch] = sym__pattern_branch,
  [sym_pattern] = sym_pattern,
  [sym_env_variable] = sym_env_variable,
  [sym_option] = sym_option,
  [sym_dictionnary_entry] = sym_dictionnary_entry,
  [sym_dictionnary] = sym_dictionnary,
  [sym__literal_dictionary_entry] = sym__literal_dictionary_entry,
  [sym_literal_dictionary] = sym_literal_dictionary,
  [sym_lambda_expression] = sym_lambda_expression,
  [sym__immediate_lambda_expression] = sym_lambda_expression,
  [sym__plus_plus_opt_bad] = sym__plus_plus_opt_bad,
  [sym_plus_plus_opt] = sym_plus_plus_opt,
  [aux_sym__plus_cmd_arg] = aux_sym__plus_cmd_arg,
  [sym__plus_cmd_number] = sym__plus_cmd_number,
  [sym__plus_cmd_command] = sym__plus_cmd_command,
  [sym__plus_cmd_pattern] = sym__plus_cmd_pattern,
  [sym_plus_cmd] = sym_plus_cmd,
  [sym_au_event_list] = sym_au_event_list,
  [sym__augroup_name] = sym__augroup_name,
  [sym__autocmd_pattern] = sym__autocmd_pattern,
  [sym__autocmd_command] = sym__autocmd_command,
  [sym__autocmd_define] = sym__autocmd_define,
  [sym__autocmd_remove] = sym__autocmd_remove,
  [sym__autocmd_list] = sym__autocmd_list,
  [sym_autocmd_statement] = sym_autocmd_statement,
  [sym_augroup_statement] = sym_augroup_statement,
  [sym__command_attribute_completion_behavior] = sym__command_attribute_completion_behavior,
  [sym__command_attribute_address_behavior] = sym__command_attribute_completion_behavior,
  [sym__command_attribute_nargs_value] = sym__command_attribute_nargs_value,
  [sym__command_attribute_range_value] = sym__command_attribute_range_value,
  [sym_command_attribute] = sym_command_attribute,
  [sym_command_statement] = sym_command_statement,
  [sym_comclear_statement] = sym_comclear_statement,
  [sym_delcommand_statement] = sym_delcommand_statement,
  [sym__hl_body_link] = sym__hl_body_link,
  [sym__hl_body_clear] = sym__hl_body_clear,
  [sym__hl_body_none] = sym__hl_body_none,
  [sym__hl_none] = sym__hl_none,
  [sym__hl_attr_list] = sym__hl_attr_list,
  [sym__hl_key_cterm] = sym__hl_key_cterm,
  [aux_sym__hl_term_list] = aux_sym__hl_term_list,
  [sym__hl_key_start_stop] = sym__hl_key_start_stop,
  [sym__hl_key_ctermfg_ctermbg] = sym__hl_key_ctermfg_ctermbg,
  [sym__hl_key_gui] = sym__hl_key_gui,
  [sym__hl_quoted_name] = sym__hl_quoted_name,
  [sym_color] = sym_color,
  [sym__hl_key_gui_color] = sym__hl_key_gui_color,
  [sym_font] = sym_font,
  [sym__hl_key_font] = sym__hl_key_font,
  [sym__hl_key_blend] = sym__hl_key_blend,
  [sym_hl_attribute] = sym_hl_attribute,
  [sym__hl_body_keys] = sym__hl_body_keys,
  [sym__hl_body] = sym__hl_body,
  [sym_highlight_statement] = sym_highlight_statement,
  [sym__syn_enable] = sym__syn_enable,
  [sym__syn_case] = sym__syn_case,
  [sym__syn_spell] = sym__syn_spell,
  [sym__syn_foldlevel] = sym__syn_foldlevel,
  [sym__syn_iskeyword] = sym__syn_iskeyword,
  [sym__syn_conceal] = sym__syn_conceal,
  [sym__syn_hl_pattern] = sym__syn_hl_pattern,
  [sym_hl_groups] = sym_hl_groups,
  [sym__syn_arguments_keyword] = sym__syn_arguments_keyword,
  [sym__syn_arguments_match] = sym__syn_arguments_match,
  [sym__syn_arguments_region] = sym__syn_arguments_region,
  [sym__syn_arguments_cluster] = sym__syn_arguments_region,
  [sym__syn_pattern_offset] = sym__syn_pattern_offset,
  [sym__syn_keyword] = sym__syn_keyword,
  [sym__syn_match] = sym__syn_match,
  [sym__syn_region_start] = sym__syn_arguments_region,
  [sym__syn_region_skip] = sym__syn_arguments_region,
  [sym__syn_region_end] = sym__syn_arguments_region,
  [sym__syn_region] = sym__syn_region,
  [sym__syn_cluster] = sym__syn_cluster,
  [sym__syn_include] = sym__syn_include,
  [sym__syn_sync_lines] = sym__syn_sync_lines,
  [sym__syn_sync] = sym__syn_sync,
  [sym__syn_list] = sym__syn_list,
  [sym__syn_clear] = sym__syn_clear,
  [sym_syntax_statement] = sym_syntax_statement,
  [sym_edit_statement] = sym_edit_statement,
  [sym_enew_statement] = sym_enew_statement,
  [sym_find_statement] = sym_find_statement,
  [sym_ex_statement] = sym_ex_statement,
  [sym_visual_statement] = sym_visual_statement,
  [sym_view_statement] = sym_view_statement,
  [aux_sym__statement_repeat1] = aux_sym__statement_repeat1,
  [aux_sym_unknown_builtin_statement_repeat1] = aux_sym_unknown_builtin_statement_repeat1,
  [aux_sym_filetypes_repeat1] = aux_sym_filetypes_repeat1,
  [aux_sym_runtime_statement_repeat1] = aux_sym_runtime_statement_repeat1,
  [aux_sym_script_repeat1] = aux_sym_script_repeat1,
  [aux_sym_if_statement_repeat1] = aux_sym_if_statement_repeat1,
  [aux_sym_try_statement_repeat1] = aux_sym_try_statement_repeat1,
  [aux_sym__bang_filter_command_argument_repeat1] = aux_sym__bang_filter_command_argument_repeat1,
  [aux_sym__bang_filter_command_repeat1] = aux_sym__bang_filter_command_repeat1,
  [aux_sym_identifier_repeat1] = aux_sym_identifier_repeat1,
  [aux_sym_let_statement_repeat1] = aux_sym_let_statement_repeat1,
  [aux_sym__let_heredoc_repeat1] = aux_sym__let_heredoc_repeat1,
  [aux_sym_set_statement_repeat1] = aux_sym_set_statement_repeat1,
  [aux_sym_unlet_statement_repeat1] = aux_sym_unlet_statement_repeat1,
  [aux_sym_function_definition_repeat1] = aux_sym_function_definition_repeat1,
  [aux_sym_parameters_repeat1] = aux_sym_parameters_repeat1,
  [aux_sym_parameters_repeat2] = aux_sym_parameters_repeat2,
  [aux_sym_map_statement_repeat1] = aux_sym_map_statement_repeat1,
  [aux_sym__map_lhs_repeat1] = aux_sym__map_lhs_repeat1,
  [aux_sym__map_rhs_statement_repeat1] = aux_sym__map_rhs_statement_repeat1,
  [aux_sym__map_rhs_repeat1] = aux_sym__map_rhs_repeat1,
  [aux_sym__sign_define_repeat1] = aux_sym__sign_define_repeat1,
  [aux_sym__sign_place_place_repeat1] = aux_sym__sign_place_place_repeat1,
  [aux_sym__sign_unplace_id_repeat1] = aux_sym__sign_unplace_id_repeat1,
  [aux_sym__sign_jump_repeat1] = aux_sym__sign_jump_repeat1,
  [aux_sym_list_repeat1] = aux_sym_list_repeat1,
  [aux_sym_filename_repeat1] = aux_sym_filename_repeat1,
  [aux_sym__pattern_ordinary_atom_repeat1] = aux_sym__pattern_ordinary_atom_repeat1,
  [aux_sym__pattern_branch_repeat1] = aux_sym__pattern_branch_repeat1,
  [aux_sym_pattern_repeat1] = aux_sym_pattern_repeat1,
  [aux_sym_dictionnary_repeat1] = aux_sym_dictionnary_repeat1,
  [aux_sym_literal_dictionary_repeat1] = aux_sym_literal_dictionary_repeat1,
  [aux_sym_au_event_list_repeat1] = aux_sym_au_event_list_repeat1,
  [aux_sym__autocmd_pattern_repeat1] = aux_sym__autocmd_pattern_repeat1,
  [aux_sym_command_statement_repeat1] = aux_sym_command_statement_repeat1,
  [aux_sym__hl_attr_list_repeat1] = aux_sym__hl_attr_list_repeat1,
  [aux_sym__hl_body_keys_repeat1] = aux_sym__hl_body_keys_repeat1,
  [aux_sym_hl_groups_repeat1] = aux_sym_hl_groups_repeat1,
  [aux_sym__syn_keyword_repeat1] = aux_sym__syn_keyword_repeat1,
  [aux_sym__syn_keyword_repeat2] = aux_sym__syn_keyword_repeat2,
  [aux_sym__syn_match_repeat1] = aux_sym__syn_match_repeat1,
  [aux_sym__syn_match_repeat2] = aux_sym__syn_match_repeat2,
  [aux_sym__syn_region_repeat1] = aux_sym__syn_region_repeat1,
  [aux_sym__syn_region_repeat2] = aux_sym__syn_region_repeat2,
  [aux_sym__syn_cluster_repeat1] = aux_sym__syn_cluster_repeat1,
  [aux_sym__syn_sync_repeat1] = aux_sym__syn_sync_repeat1,
  [aux_sym_edit_statement_repeat1] = aux_sym_edit_statement_repeat1,
  [aux_sym_edit_statement_repeat2] = aux_sym_edit_statement_repeat2,
  [alias_sym_arguments] = alias_sym_arguments,
  [alias_sym_augroup_name] = alias_sym_augroup_name,
  [alias_sym_body] = alias_sym_body,
  [alias_sym_file] = alias_sym_file,
  [alias_sym_filenames] = alias_sym_filenames,
  [alias_sym_filter_command] = alias_sym_filter_command,
  [alias_sym_name] = alias_sym_name,
  [alias_sym_range] = alias_sym_range,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_keyword] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_a_COLON] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_normal_statement_token1] = {
    .visible = true,
    .named = true,
  },
  [sym_filetype] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__filetype_immediate_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_FALLBACK] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_dos] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_unix] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_mac] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_latin1] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_iso] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_koi8] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_macroman] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_cp437] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_cp737] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_cp775] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_cp850] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_cp852] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_cp855] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_cp857] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_cp860] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_cp861] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_cp862] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_cp863] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_cp865] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_cp866] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_cp869] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_cp874] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_cp1250] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_cp1251] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_cp1253] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_cp1254] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_cp1255] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_cp1256] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_cp1257] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_cp1258] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_cp932] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_euc_DASHjp] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sjis] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_cp949] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_euc_DASHkr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_cp936] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_euc_DASHcn] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_cp950] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_big5] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_euc_DASHtw] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_utf_DASH8] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ucs_DASH2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ucs_DASH21e] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_utf_DASH16] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_utf_DASH16le] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ucs_DASH4] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ucs_DASH4le] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ansi] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_japan] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_korea] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_prc] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_chinese] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_taiwan] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_utf8] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unicode] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ucs2be] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ucs_DASH2be] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ucs_DASH4be] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_utf_DASH32] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_utf_DASH32le] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_default] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_latin12] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_iso2] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_koi82] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_macroman2] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_cp4372] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_cp7372] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_cp7752] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_cp8502] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_cp8522] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_cp8552] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_cp8572] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_cp8602] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_cp8612] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_cp8622] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_cp8632] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_cp8652] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_cp8662] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_cp8692] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_cp8742] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_cp12502] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_cp12512] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_cp12532] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_cp12542] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_cp12552] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_cp12562] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_cp12572] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_cp12582] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_cp9322] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_euc_DASHjp2] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_sjis2] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_cp9492] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_euc_DASHkr2] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_cp9362] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_euc_DASHcn2] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_cp9502] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_big52] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_euc_DASHtw2] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_utf_DASH82] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ucs_DASH22] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ucs_DASH21e2] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_utf_DASH162] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_utf_DASH16le2] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ucs_DASH42] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ucs_DASH4le2] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ansi2] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_japan2] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_korea2] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_prc2] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_chinese2] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_taiwan2] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_utf82] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_unicode2] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ucs2be2] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ucs_DASH2be2] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ucs_DASH4be2] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_utf_DASH322] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_utf_DASH32le2] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_default2] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_START] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_OPT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ALL] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_wincmd_statement_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_on] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_off] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_detect] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_plugin] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_indent] = {
    .visible = true,
    .named = false,
  },
  [sym_chunk] = {
    .visible = true,
    .named = true,
  },
  [sym__heredoc_line] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LF] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__au_pattern_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__au_pattern_token2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__bang_filter_command_argument_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_BSLASH] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__bang_filter_command_argument_token2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__bang_filter_command_argument_token3] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__bang_filter_command_argument_token4] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_argument_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_argument_token2] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_identifier_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_identifier_token2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__immediate_identifier_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_trim] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_eval] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_option_name_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_t_] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_option_name_token2] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_vi] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_vim] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_all] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_all_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ2] = {
    .visible = true,
    .named = false,
  },
  [sym_set_value] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_SPACE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_command_argument_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_dict] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_range] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_abort] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_closure] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [sym_spread] = {
    .visible = true,
    .named = true,
  },
  [sym__printable] = {
    .visible = false,
    .named = true,
  },
  [sym_mark] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASH_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASH_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASH_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LTbuffer_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LTnowait_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LTsilent_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LTunique_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LTscript_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LTexpr_GT] = {
    .visible = true,
    .named = false,
  },
  [sym__keycode_modifier] = {
    .visible = false,
    .named = true,
  },
  [aux_sym__keycode_in_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__keycode_in_token2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__keycode_in_token3] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__keycode_in_token4] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__keycode_in_token5] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__keycode_in_token6] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__keycode_in_token7] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__keycode_in_token8] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__keycode_in_token9] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__keycode_in_token10] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__keycode_in_token11] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__keycode_in_token12] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__keycode_in_token13] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__keycode_in_token14] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__keycode_in_token15] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__keycode_in_token16] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__keycode_in_token17] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__keycode_in_token18] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__keycode_in_token19] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__keycode_in_token20] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__keycode_in_token21] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__keycode_in_token22] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__keycode_in_token23] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__keycode_in_token24] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__keycode_in_token25] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__keycode_in_token26] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__keycode_in_token27] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__keycode_in_token28] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__keycode_in_token29] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__keycode_in_token30] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__keycode_in_token31] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__keycode_in_token32] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__keycode_in_token33] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__keycode_in_token34] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__keycode_in_token35] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__keycode_in_token36] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__keycode_in_token37] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__keycode_in_token38] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__keycode_in_token39] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__keycode_in_token40] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__keycode_in_token41] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__keycode_in_token42] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__keycode_in_token43] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASH2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__map_lhs_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__map_rhs_statement_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BSLASH_PIPE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__map_rhs_statement_token2] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__map_rhs_statement_token3] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__map_rhs_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__map_rhs_token2] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_icon] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_linehl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_numhl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_text] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_texthl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_culhl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_define] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_undefine] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_list] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_line] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_name] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_buffer] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_group] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_priority] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_file] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_place] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unplace] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_jump] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_is] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_isnot] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG2] = {
    .visible = true,
    .named = false,
  },
  [sym_float_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_integer_literal] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_filename_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_filename_token2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_filename_token3] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_filename_token4] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_filename_token5] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_filename_token6] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_filename_token7] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_filename_token8] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pattern_multi_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pattern_multi_token2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pattern_multi_token3] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__pattern_ordinary_atom_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__pattern_ordinary_atom_token2] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_BSLASH_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASH_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASH_PERCENT_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHz_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [sym_register] = {
    .visible = true,
    .named = true,
  },
  [sym_literal_key] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_POUND_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_keep] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_drop] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ff] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_fileformat] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_enc] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_encoding] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bin] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_binary] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_nobin] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_nobinary] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bad] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_edit] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__plus_cmd_arg_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_au_event] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__autocmd_pattern_token1] = {
    .visible = true,
    .named = true,
  },
  [sym_au_once] = {
    .visible = true,
    .named = true,
  },
  [sym_au_nested] = {
    .visible = true,
    .named = true,
  },
  [sym_command_name] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_arglist] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_augroup] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_buffer2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_behave] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_color] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_command] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_compiler] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_dir] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_environment] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_even] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_expression] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_file2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_file_in_path] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_filetype] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_function] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_help] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_highlight] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_history] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_local] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_lua] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_mapclear] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_mapping] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_menu] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_messages] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_option] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_packadd] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_shellcmd] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sign] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_syntax] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_syntime] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_tag] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_tag_listfiles] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_user] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_var] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_custom] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_customlist] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_lines] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_arguments] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_buffers] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_loaded_buffers] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_windows] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_tabs] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_quickfix] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_other] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__command_attribute_nargs_value_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__command_attribute_nargs_value_token2] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_PERCENT2] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DASHnargs] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASHcomplete] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASHrange] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASHcount] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASHaddr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASHbang] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASHbar] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASHregister] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASHbuffer] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASHkeepscript] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_command_statement_token1] = {
    .visible = true,
    .named = true,
  },
  [sym_hl_group] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_link] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_clear] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_NONE] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_NONE2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bold] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_underline] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_undercurl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_underdouble] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_underdotted] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_underdashed] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_strikethrough] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_reverse] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_inverse] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_italic] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_standout] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_nocombine] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_term] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_cterm] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__hl_term_list_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_start] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_stop] = {
    .visible = true,
    .named = false,
  },
  [sym__hl_color_nr] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_ctermfg] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ctermbg] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_gui] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__hl_quoted_name_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_SQUOTE2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bg] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_background] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_fg] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_foreground] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_color_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_color_token2] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_guifg] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_guibg] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_guisp] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_font_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_font] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_blend] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_enable] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_reset] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_match] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ignore] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_spell] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_toplevel] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_notoplevel] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_foldlevel] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_minimum] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_iskeyword] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__syn_iskeyword_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_conceal] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_cchar] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_contained] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_containedin] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_nextgroup] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_transparent] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_skipwhite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_skipnl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_skipempty] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_contains] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_fold] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_display] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_extend] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_keepend] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_excludenl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_matchgroup] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_oneline] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_concealends] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_add] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_remove] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ms] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_me] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_hs] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_he] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_rs] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_re] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_lc] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__syn_pattern_offset_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__syn_pattern_offset_token2] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_keyword] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__syn_keyword_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_skip] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_end] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_region] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_cluster] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_include] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_minlines] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_maxlines] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__syn_sync_lines_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_sync] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_linebreaks] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_fromstart] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ccomment] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_lines2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_grouphere] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_groupthere] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_linecont] = {
    .visible = true,
    .named = false,
  },
  [sym__no] = {
    .visible = false,
    .named = true,
  },
  [sym__inv] = {
    .visible = false,
    .named = true,
  },
  [sym__newline_or_pipe] = {
    .visible = false,
    .named = true,
  },
  [sym__line_continuation] = {
    .visible = false,
    .named = true,
  },
  [sym__script_heredoc_marker] = {
    .visible = true,
    .named = true,
  },
  [sym__let_heredoc_marker] = {
    .visible = true,
    .named = true,
  },
  [sym__heredoc_end] = {
    .visible = true,
    .named = true,
  },
  [sym__separator_first] = {
    .visible = false,
    .named = true,
  },
  [sym__separator] = {
    .visible = false,
    .named = true,
  },
  [sym__scope_dict] = {
    .visible = false,
    .named = true,
  },
  [sym_scope] = {
    .visible = true,
    .named = true,
  },
  [sym_string_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_line_continuation_comment] = {
    .visible = true,
    .named = true,
  },
  [sym__bang_filter] = {
    .visible = false,
    .named = true,
  },
  [sym__function] = {
    .visible = true,
    .named = false,
  },
  [sym__endfunction] = {
    .visible = true,
    .named = false,
  },
  [sym__for] = {
    .visible = true,
    .named = false,
  },
  [sym__endfor] = {
    .visible = true,
    .named = false,
  },
  [sym__while] = {
    .visible = true,
    .named = false,
  },
  [sym__endwhile] = {
    .visible = true,
    .named = false,
  },
  [sym__if] = {
    .visible = true,
    .named = false,
  },
  [sym__elseif] = {
    .visible = true,
    .named = false,
  },
  [sym__else] = {
    .visible = true,
    .named = false,
  },
  [sym__endif] = {
    .visible = true,
    .named = false,
  },
  [sym__try] = {
    .visible = true,
    .named = false,
  },
  [sym__catch] = {
    .visible = true,
    .named = false,
  },
  [sym__cnext] = {
    .visible = true,
    .named = false,
  },
  [sym__cprevious] = {
    .visible = true,
    .named = false,
  },
  [sym__cNext] = {
    .visible = true,
    .named = false,
  },
  [sym__finally] = {
    .visible = true,
    .named = false,
  },
  [sym__endtry] = {
    .visible = true,
    .named = false,
  },
  [sym__const] = {
    .visible = true,
    .named = false,
  },
  [sym__normal] = {
    .visible = true,
    .named = false,
  },
  [sym__return] = {
    .visible = true,
    .named = false,
  },
  [sym__perl] = {
    .visible = true,
    .named = false,
  },
  [sym__lua] = {
    .visible = true,
    .named = false,
  },
  [sym__ruby] = {
    .visible = true,
    .named = false,
  },
  [sym__python] = {
    .visible = true,
    .named = false,
  },
  [sym__throw] = {
    .visible = true,
    .named = false,
  },
  [sym__execute] = {
    .visible = true,
    .named = false,
  },
  [sym__autocmd] = {
    .visible = true,
    .named = false,
  },
  [sym__silent] = {
    .visible = true,
    .named = false,
  },
  [sym__echo] = {
    .visible = true,
    .named = false,
  },
  [sym__echon] = {
    .visible = true,
    .named = false,
  },
  [sym__echohl] = {
    .visible = true,
    .named = false,
  },
  [sym__echomsg] = {
    .visible = true,
    .named = false,
  },
  [sym__echoerr] = {
    .visible = true,
    .named = false,
  },
  [sym__map] = {
    .visible = true,
    .named = false,
  },
  [sym__nmap] = {
    .visible = true,
    .named = false,
  },
  [sym__vmap] = {
    .visible = true,
    .named = false,
  },
  [sym__xmap] = {
    .visible = true,
    .named = false,
  },
  [sym__smap] = {
    .visible = true,
    .named = false,
  },
  [sym__omap] = {
    .visible = true,
    .named = false,
  },
  [sym__imap] = {
    .visible = true,
    .named = false,
  },
  [sym__lmap] = {
    .visible = true,
    .named = false,
  },
  [sym__cmap] = {
    .visible = true,
    .named = false,
  },
  [sym__tmap] = {
    .visible = true,
    .named = false,
  },
  [sym__noremap] = {
    .visible = true,
    .named = false,
  },
  [sym__nnoremap] = {
    .visible = true,
    .named = false,
  },
  [sym__vnoremap] = {
    .visible = true,
    .named = false,
  },
  [sym__xnoremap] = {
    .visible = true,
    .named = false,
  },
  [sym__snoremap] = {
    .visible = true,
    .named = false,
  },
  [sym__onoremap] = {
    .visible = true,
    .named = false,
  },
  [sym__inoremap] = {
    .visible = true,
    .named = false,
  },
  [sym__lnoremap] = {
    .visible = true,
    .named = false,
  },
  [sym__cnoremap] = {
    .visible = true,
    .named = false,
  },
  [sym__tnoremap] = {
    .visible = true,
    .named = false,
  },
  [sym__augroup] = {
    .visible = true,
    .named = false,
  },
  [sym__highlight] = {
    .visible = true,
    .named = false,
  },
  [sym__default] = {
    .visible = true,
    .named = false,
  },
  [sym__syntax] = {
    .visible = true,
    .named = false,
  },
  [sym__set] = {
    .visible = true,
    .named = false,
  },
  [sym__setlocal] = {
    .visible = true,
    .named = false,
  },
  [sym__setfiletype] = {
    .visible = true,
    .named = false,
  },
  [sym__browse] = {
    .visible = true,
    .named = false,
  },
  [sym__options] = {
    .visible = true,
    .named = false,
  },
  [sym__startinsert] = {
    .visible = true,
    .named = false,
  },
  [sym__stopinsert] = {
    .visible = true,
    .named = false,
  },
  [sym__scriptencoding] = {
    .visible = true,
    .named = false,
  },
  [sym__source] = {
    .visible = true,
    .named = false,
  },
  [sym__global] = {
    .visible = true,
    .named = false,
  },
  [sym__colorscheme] = {
    .visible = true,
    .named = false,
  },
  [sym__command] = {
    .visible = true,
    .named = false,
  },
  [sym__comclear] = {
    .visible = true,
    .named = false,
  },
  [sym__delcommand] = {
    .visible = true,
    .named = false,
  },
  [sym__runtime] = {
    .visible = true,
    .named = false,
  },
  [sym__wincmd] = {
    .visible = true,
    .named = false,
  },
  [sym__sign] = {
    .visible = true,
    .named = false,
  },
  [sym__filetype] = {
    .visible = true,
    .named = false,
  },
  [sym__let] = {
    .visible = true,
    .named = false,
  },
  [sym__unlet] = {
    .visible = true,
    .named = false,
  },
  [sym__call] = {
    .visible = true,
    .named = false,
  },
  [sym__break] = {
    .visible = true,
    .named = false,
  },
  [sym__continue] = {
    .visible = true,
    .named = false,
  },
  [sym__vertical] = {
    .visible = true,
    .named = false,
  },
  [sym__leftabove] = {
    .visible = true,
    .named = false,
  },
  [sym__aboveleft] = {
    .visible = true,
    .named = false,
  },
  [sym__rightbelow] = {
    .visible = true,
    .named = false,
  },
  [sym__belowright] = {
    .visible = true,
    .named = false,
  },
  [sym__topleft] = {
    .visible = true,
    .named = false,
  },
  [sym__botright] = {
    .visible = true,
    .named = false,
  },
  [sym__edit] = {
    .visible = true,
    .named = false,
  },
  [sym__enew] = {
    .visible = true,
    .named = false,
  },
  [sym__find] = {
    .visible = true,
    .named = false,
  },
  [sym__ex] = {
    .visible = true,
    .named = false,
  },
  [sym__visual] = {
    .visible = true,
    .named = false,
  },
  [sym__view] = {
    .visible = true,
    .named = false,
  },
  [sym__eval] = {
    .visible = true,
    .named = false,
  },
  [sym_unknown_command_name] = {
    .visible = true,
    .named = true,
  },
  [sym_script_file] = {
    .visible = true,
    .named = true,
  },
  [sym__cmd_separator] = {
    .visible = false,
    .named = true,
  },
  [aux_sym__separated_statements] = {
    .visible = false,
    .named = false,
  },
  [sym__statement] = {
    .visible = false,
    .named = true,
  },
  [sym_unknown_builtin_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continue_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_scope_dict] = {
    .visible = true,
    .named = true,
  },
  [sym_normal_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__filetype_immediate] = {
    .visible = false,
    .named = true,
  },
  [sym_filetypes] = {
    .visible = true,
    .named = true,
  },
  [sym_setfiletype_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_options_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_startinsert_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_stopinsert_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__immediate_file_format] = {
    .visible = false,
    .named = true,
  },
  [sym_encoding] = {
    .visible = true,
    .named = true,
  },
  [sym__immediate_encoding] = {
    .visible = false,
    .named = true,
  },
  [sym_scriptencoding_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_cnext_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_cprevious_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__runtime_where] = {
    .visible = true,
    .named = true,
  },
  [sym_runtime_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_wincmd_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_source_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_global_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__filetype_state] = {
    .visible = false,
    .named = true,
  },
  [sym__filetype_enable] = {
    .visible = false,
    .named = true,
  },
  [sym__filetype_detect] = {
    .visible = false,
    .named = true,
  },
  [sym__filetype_plugin] = {
    .visible = false,
    .named = true,
  },
  [sym__filetype_indent] = {
    .visible = false,
    .named = true,
  },
  [sym_filetype_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_colorscheme_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_lua_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_ruby_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_python_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_perl_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_script] = {
    .visible = true,
    .named = true,
  },
  [sym_for_loop] = {
    .visible = true,
    .named = true,
  },
  [sym_while_loop] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_elseif_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_else_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_try_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__au_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_catch_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_finally_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_throw_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__bang_filter_bangs] = {
    .visible = true,
    .named = true,
  },
  [sym__bang_filter_command_argument] = {
    .visible = true,
    .named = true,
  },
  [sym__bang_filter_command] = {
    .visible = true,
    .named = true,
  },
  [sym_bang_filter_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_scoped_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_argument] = {
    .visible = true,
    .named = true,
  },
  [sym__curly_braces_name_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__immediate_curly_braces_name_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym__immediate_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym__ident] = {
    .visible = false,
    .named = true,
  },
  [sym__let_operator] = {
    .visible = false,
    .named = true,
  },
  [sym__assignment_variable] = {
    .visible = false,
    .named = true,
  },
  [sym__let_assignment] = {
    .visible = false,
    .named = true,
  },
  [sym_let_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__const_assignment] = {
    .visible = false,
    .named = true,
  },
  [sym_const_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__let_heredoc] = {
    .visible = true,
    .named = true,
  },
  [sym__let_heredoc_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_option_name] = {
    .visible = true,
    .named = true,
  },
  [sym_no_option] = {
    .visible = true,
    .named = true,
  },
  [sym_inv_option] = {
    .visible = true,
    .named = true,
  },
  [sym_default_option] = {
    .visible = true,
    .named = true,
  },
  [sym__set_option] = {
    .visible = false,
    .named = true,
  },
  [sym__set_operator] = {
    .visible = false,
    .named = true,
  },
  [sym__set_rhs] = {
    .visible = false,
    .named = true,
  },
  [sym_set_item] = {
    .visible = true,
    .named = true,
  },
  [sym_set_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_setlocal_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_unlet_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_call_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_echo_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_echon_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_echohl_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_echomsg_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_echoerr_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_execute_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_silent_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_vertical_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_topleft_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_botright_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_aboveleft_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_belowright_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_user_command] = {
    .visible = true,
    .named = true,
  },
  [sym_command_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_function_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_function_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_default_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_bang] = {
    .visible = true,
    .named = true,
  },
  [sym_range_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__range] = {
    .visible = false,
    .named = true,
  },
  [sym__range_explicit] = {
    .visible = false,
    .named = true,
  },
  [sym__range_marker] = {
    .visible = false,
    .named = true,
  },
  [sym_current_line] = {
    .visible = true,
    .named = true,
  },
  [sym_next_line] = {
    .visible = true,
    .named = true,
  },
  [sym_last_line] = {
    .visible = true,
    .named = true,
  },
  [sym_previous_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_register_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_map_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__map_definition] = {
    .visible = false,
    .named = true,
  },
  [sym__keycode_in] = {
    .visible = false,
    .named = true,
  },
  [sym__immediate_keycode] = {
    .visible = false,
    .named = true,
  },
  [sym_keycode] = {
    .visible = true,
    .named = true,
  },
  [sym__map_lhs] = {
    .visible = true,
    .named = true,
  },
  [sym__map_rhs_statement] = {
    .visible = false,
    .named = true,
  },
  [sym__map_rhs] = {
    .visible = true,
    .named = true,
  },
  [sym__sign_name] = {
    .visible = false,
    .named = true,
  },
  [sym__sign_define_arg_text] = {
    .visible = true,
    .named = true,
  },
  [sym__sign_define_argument] = {
    .visible = true,
    .named = true,
  },
  [sym__sign_define] = {
    .visible = false,
    .named = true,
  },
  [sym__sign_undefine] = {
    .visible = false,
    .named = true,
  },
  [sym__sign_list] = {
    .visible = false,
    .named = true,
  },
  [sym__sign_place_place_argument] = {
    .visible = true,
    .named = true,
  },
  [sym__sign_place_place] = {
    .visible = false,
    .named = true,
  },
  [sym__sign_place_list_argument] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__sign_place_list] = {
    .visible = false,
    .named = false,
  },
  [sym__sign_place] = {
    .visible = false,
    .named = true,
  },
  [sym__sign_unplace_cursor_argument] = {
    .visible = true,
    .named = true,
  },
  [sym__sign_unplace_cursor] = {
    .visible = false,
    .named = true,
  },
  [sym__sign_unplace_id_argument] = {
    .visible = true,
    .named = true,
  },
  [sym__sign_unplace_id] = {
    .visible = false,
    .named = true,
  },
  [sym__sign_unplace] = {
    .visible = false,
    .named = true,
  },
  [sym__sign_jump_argument] = {
    .visible = true,
    .named = true,
  },
  [sym__sign_jump] = {
    .visible = false,
    .named = true,
  },
  [sym_sign_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__variable] = {
    .visible = false,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
  },
  [sym_ternary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_match_case] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_operation] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_operation] = {
    .visible = true,
    .named = true,
  },
  [sym_list] = {
    .visible = true,
    .named = true,
  },
  [sym_list_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_index_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_slice_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_field_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_eval_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__method_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_method_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_filename] = {
    .visible = true,
    .named = true,
  },
  [sym_pattern_multi] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__pattern_ordinary_atom] = {
    .visible = false,
    .named = false,
  },
  [sym__pattern_atom] = {
    .visible = false,
    .named = true,
  },
  [sym__pattern_piece] = {
    .visible = false,
    .named = true,
  },
  [aux_sym__pattern_concat] = {
    .visible = false,
    .named = false,
  },
  [sym__pattern_branch] = {
    .visible = false,
    .named = true,
  },
  [sym_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_env_variable] = {
    .visible = true,
    .named = true,
  },
  [sym_option] = {
    .visible = true,
    .named = true,
  },
  [sym_dictionnary_entry] = {
    .visible = true,
    .named = true,
  },
  [sym_dictionnary] = {
    .visible = true,
    .named = true,
  },
  [sym__literal_dictionary_entry] = {
    .visible = false,
    .named = true,
  },
  [sym_literal_dictionary] = {
    .visible = true,
    .named = true,
  },
  [sym_lambda_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__immediate_lambda_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__plus_plus_opt_bad] = {
    .visible = false,
    .named = true,
  },
  [sym_plus_plus_opt] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__plus_cmd_arg] = {
    .visible = false,
    .named = false,
  },
  [sym__plus_cmd_number] = {
    .visible = false,
    .named = true,
  },
  [sym__plus_cmd_command] = {
    .visible = false,
    .named = true,
  },
  [sym__plus_cmd_pattern] = {
    .visible = false,
    .named = true,
  },
  [sym_plus_cmd] = {
    .visible = true,
    .named = true,
  },
  [sym_au_event_list] = {
    .visible = true,
    .named = true,
  },
  [sym__augroup_name] = {
    .visible = false,
    .named = true,
  },
  [sym__autocmd_pattern] = {
    .visible = false,
    .named = true,
  },
  [sym__autocmd_command] = {
    .visible = false,
    .named = true,
  },
  [sym__autocmd_define] = {
    .visible = false,
    .named = true,
  },
  [sym__autocmd_remove] = {
    .visible = false,
    .named = true,
  },
  [sym__autocmd_list] = {
    .visible = false,
    .named = true,
  },
  [sym_autocmd_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_augroup_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__command_attribute_completion_behavior] = {
    .visible = true,
    .named = true,
  },
  [sym__command_attribute_address_behavior] = {
    .visible = true,
    .named = true,
  },
  [sym__command_attribute_nargs_value] = {
    .visible = false,
    .named = true,
  },
  [sym__command_attribute_range_value] = {
    .visible = false,
    .named = true,
  },
  [sym_command_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym_command_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_comclear_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_delcommand_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__hl_body_link] = {
    .visible = false,
    .named = true,
  },
  [sym__hl_body_clear] = {
    .visible = false,
    .named = true,
  },
  [sym__hl_body_none] = {
    .visible = false,
    .named = true,
  },
  [sym__hl_none] = {
    .visible = false,
    .named = true,
  },
  [sym__hl_attr_list] = {
    .visible = false,
    .named = true,
  },
  [sym__hl_key_cterm] = {
    .visible = false,
    .named = true,
  },
  [aux_sym__hl_term_list] = {
    .visible = false,
    .named = false,
  },
  [sym__hl_key_start_stop] = {
    .visible = false,
    .named = true,
  },
  [sym__hl_key_ctermfg_ctermbg] = {
    .visible = false,
    .named = true,
  },
  [sym__hl_key_gui] = {
    .visible = false,
    .named = true,
  },
  [sym__hl_quoted_name] = {
    .visible = false,
    .named = true,
  },
  [sym_color] = {
    .visible = true,
    .named = true,
  },
  [sym__hl_key_gui_color] = {
    .visible = false,
    .named = true,
  },
  [sym_font] = {
    .visible = true,
    .named = true,
  },
  [sym__hl_key_font] = {
    .visible = false,
    .named = true,
  },
  [sym__hl_key_blend] = {
    .visible = false,
    .named = true,
  },
  [sym_hl_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym__hl_body_keys] = {
    .visible = false,
    .named = true,
  },
  [sym__hl_body] = {
    .visible = false,
    .named = true,
  },
  [sym_highlight_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__syn_enable] = {
    .visible = false,
    .named = true,
  },
  [sym__syn_case] = {
    .visible = false,
    .named = true,
  },
  [sym__syn_spell] = {
    .visible = false,
    .named = true,
  },
  [sym__syn_foldlevel] = {
    .visible = false,
    .named = true,
  },
  [sym__syn_iskeyword] = {
    .visible = false,
    .named = true,
  },
  [sym__syn_conceal] = {
    .visible = false,
    .named = true,
  },
  [sym__syn_hl_pattern] = {
    .visible = false,
    .named = true,
  },
  [sym_hl_groups] = {
    .visible = true,
    .named = true,
  },
  [sym__syn_arguments_keyword] = {
    .visible = false,
    .named = true,
  },
  [sym__syn_arguments_match] = {
    .visible = false,
    .named = true,
  },
  [sym__syn_arguments_region] = {
    .visible = true,
    .named = true,
  },
  [sym__syn_arguments_cluster] = {
    .visible = true,
    .named = true,
  },
  [sym__syn_pattern_offset] = {
    .visible = true,
    .named = true,
  },
  [sym__syn_keyword] = {
    .visible = false,
    .named = true,
  },
  [sym__syn_match] = {
    .visible = false,
    .named = true,
  },
  [sym__syn_region_start] = {
    .visible = true,
    .named = true,
  },
  [sym__syn_region_skip] = {
    .visible = true,
    .named = true,
  },
  [sym__syn_region_end] = {
    .visible = true,
    .named = true,
  },
  [sym__syn_region] = {
    .visible = false,
    .named = true,
  },
  [sym__syn_cluster] = {
    .visible = false,
    .named = true,
  },
  [sym__syn_include] = {
    .visible = false,
    .named = true,
  },
  [sym__syn_sync_lines] = {
    .visible = false,
    .named = true,
  },
  [sym__syn_sync] = {
    .visible = false,
    .named = true,
  },
  [sym__syn_list] = {
    .visible = false,
    .named = true,
  },
  [sym__syn_clear] = {
    .visible = false,
    .named = true,
  },
  [sym_syntax_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_edit_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_enew_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_find_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_ex_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_visual_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_view_statement] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_unknown_builtin_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_filetypes_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_runtime_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_script_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_if_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_try_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__bang_filter_command_argument_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__bang_filter_command_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_identifier_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_let_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__let_heredoc_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_set_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_unlet_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_function_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_parameters_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_map_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__map_lhs_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__map_rhs_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__map_rhs_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__sign_define_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__sign_place_place_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__sign_unplace_id_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__sign_jump_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_filename_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__pattern_ordinary_atom_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__pattern_branch_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_dictionnary_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_literal_dictionary_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_au_event_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__autocmd_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_command_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__hl_attr_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__hl_body_keys_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_hl_groups_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__syn_keyword_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__syn_keyword_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__syn_match_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__syn_match_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__syn_region_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__syn_region_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__syn_cluster_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__syn_sync_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_edit_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_edit_statement_repeat2] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_arguments] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_augroup_name] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_body] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_file] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_filenames] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_filter_command] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_name] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_range] = {
    .visible = true,
    .named = true,
  },
};

enum ts_field_identifiers {
  field_action = 1,
  field_cmd = 2,
  field_command = 3,
  field_condition = 4,
  field_end = 5,
  field_field = 6,
  field_file = 7,
  field_filter = 8,
  field_from = 9,
  field_function = 10,
  field_grouplist = 11,
  field_id = 12,
  field_index = 13,
  field_iter = 14,
  field_key = 15,
  field_left = 16,
  field_lhs = 17,
  field_method = 18,
  field_name = 19,
  field_offset = 20,
  field_option = 21,
  field_parameters = 22,
  field_range = 23,
  field_repl = 24,
  field_rhs = 25,
  field_right = 26,
  field_start = 27,
  field_stop = 28,
  field_sub = 29,
  field_to = 30,
  field_val = 31,
  field_value = 32,
  field_variable = 33,
  field_what = 34,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_action] = "action",
  [field_cmd] = "cmd",
  [field_command] = "command",
  [field_condition] = "condition",
  [field_end] = "end",
  [field_field] = "field",
  [field_file] = "file",
  [field_filter] = "filter",
  [field_from] = "from",
  [field_function] = "function",
  [field_grouplist] = "grouplist",
  [field_id] = "id",
  [field_index] = "index",
  [field_iter] = "iter",
  [field_key] = "key",
  [field_left] = "left",
  [field_lhs] = "lhs",
  [field_method] = "method",
  [field_name] = "name",
  [field_offset] = "offset",
  [field_option] = "option",
  [field_parameters] = "parameters",
  [field_range] = "range",
  [field_repl] = "repl",
  [field_rhs] = "rhs",
  [field_right] = "right",
  [field_start] = "start",
  [field_stop] = "stop",
  [field_sub] = "sub",
  [field_to] = "to",
  [field_val] = "val",
  [field_value] = "value",
  [field_variable] = "variable",
  [field_what] = "what",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [2] = {.index = 0, .length = 2},
  [3] = {.index = 2, .length = 1},
  [4] = {.index = 3, .length = 1},
  [6] = {.index = 4, .length = 1},
  [7] = {.index = 5, .length = 3},
  [9] = {.index = 8, .length = 2},
  [10] = {.index = 10, .length = 2},
  [11] = {.index = 12, .length = 1},
  [12] = {.index = 13, .length = 1},
  [13] = {.index = 14, .length = 2},
  [14] = {.index = 16, .length = 3},
  [15] = {.index = 19, .length = 1},
  [16] = {.index = 20, .length = 1},
  [18] = {.index = 21, .length = 1},
  [19] = {.index = 22, .length = 1},
  [21] = {.index = 23, .length = 1},
  [22] = {.index = 24, .length = 2},
  [23] = {.index = 26, .length = 2},
  [25] = {.index = 28, .length = 3},
  [27] = {.index = 31, .length = 2},
  [28] = {.index = 33, .length = 1},
  [30] = {.index = 34, .length = 2},
  [31] = {.index = 36, .length = 3},
  [33] = {.index = 39, .length = 2},
  [34] = {.index = 41, .length = 2},
  [35] = {.index = 43, .length = 2},
  [36] = {.index = 45, .length = 2},
  [37] = {.index = 47, .length = 1},
  [38] = {.index = 48, .length = 2},
  [39] = {.index = 50, .length = 1},
  [41] = {.index = 51, .length = 2},
  [42] = {.index = 53, .length = 2},
  [43] = {.index = 55, .length = 2},
  [44] = {.index = 57, .length = 1},
  [45] = {.index = 57, .length = 1},
  [46] = {.index = 58, .length = 2},
  [47] = {.index = 58, .length = 2},
  [52] = {.index = 60, .length = 1},
  [53] = {.index = 61, .length = 4},
  [54] = {.index = 65, .length = 4},
  [55] = {.index = 69, .length = 1},
  [56] = {.index = 70, .length = 2},
  [57] = {.index = 72, .length = 2},
  [58] = {.index = 74, .length = 1},
  [59] = {.index = 75, .length = 2},
  [60] = {.index = 77, .length = 2},
  [61] = {.index = 79, .length = 2},
  [62] = {.index = 81, .length = 1},
  [65] = {.index = 82, .length = 1},
  [66] = {.index = 83, .length = 1},
  [67] = {.index = 84, .length = 2},
  [68] = {.index = 86, .length = 2},
  [69] = {.index = 55, .length = 2},
  [70] = {.index = 88, .length = 1},
  [71] = {.index = 89, .length = 3},
  [72] = {.index = 92, .length = 1},
  [73] = {.index = 93, .length = 2},
  [74] = {.index = 95, .length = 4},
  [75] = {.index = 93, .length = 2},
  [76] = {.index = 99, .length = 3},
  [77] = {.index = 102, .length = 2},
  [81] = {.index = 104, .length = 4},
  [82] = {.index = 108, .length = 2},
  [83] = {.index = 110, .length = 4},
  [84] = {.index = 114, .length = 4},
  [86] = {.index = 118, .length = 2},
  [87] = {.index = 120, .length = 1},
  [88] = {.index = 121, .length = 2},
  [89] = {.index = 81, .length = 1},
  [90] = {.index = 123, .length = 1},
  [91] = {.index = 124, .length = 2},
  [92] = {.index = 126, .length = 2},
  [93] = {.index = 128, .length = 2},
  [94] = {.index = 130, .length = 2},
  [95] = {.index = 132, .length = 3},
  [96] = {.index = 135, .length = 3},
  [97] = {.index = 138, .length = 3},
  [98] = {.index = 141, .length = 3},
  [99] = {.index = 144, .length = 2},
  [100] = {.index = 146, .length = 2},
  [101] = {.index = 148, .length = 2},
  [103] = {.index = 150, .length = 4},
  [104] = {.index = 154, .length = 2},
  [106] = {.index = 156, .length = 3},
  [107] = {.index = 159, .length = 2},
  [108] = {.index = 161, .length = 2},
  [109] = {.index = 163, .length = 2},
  [110] = {.index = 165, .length = 1},
  [111] = {.index = 166, .length = 2},
  [112] = {.index = 168, .length = 5},
  [113] = {.index = 173, .length = 3},
  [114] = {.index = 176, .length = 4},
  [117] = {.index = 180, .length = 3},
  [118] = {.index = 163, .length = 2},
  [119] = {.index = 183, .length = 2},
  [120] = {.index = 185, .length = 1},
  [121] = {.index = 186, .length = 3},
  [122] = {.index = 189, .length = 5},
  [123] = {.index = 194, .length = 5},
  [124] = {.index = 199, .length = 5},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_end, 0, .inherited = true},
    {field_start, 0, .inherited = true},
  [2] =
    {field_start, 0},
  [3] =
    {field_command, 0, .inherited = true},
  [4] =
    {field_command, 1, .inherited = true},
  [5] =
    {field_cmd, 0},
    {field_lhs, 1, .inherited = true},
    {field_rhs, 1, .inherited = true},
  [8] =
    {field_from, 0, .inherited = true},
    {field_to, 0, .inherited = true},
  [10] =
    {field_from, 1, .inherited = true},
    {field_to, 1, .inherited = true},
  [12] =
    {field_sub, 0},
  [13] =
    {field_sub, 1, .inherited = true},
  [14] =
    {field_grouplist, 1, .inherited = true},
    {field_sub, 1, .inherited = true},
  [16] =
    {field_method, 1, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_sub, 1, .inherited = true},
  [19] =
    {field_option, 0},
  [20] =
    {field_file, 1},
  [21] =
    {field_name, 1},
  [22] =
    {field_name, 0},
  [23] =
    {field_action, 1},
  [24] =
    {field_name, 1, .inherited = true},
    {field_sub, 1, .inherited = true},
  [26] =
    {field_id, 1, .inherited = true},
    {field_sub, 1, .inherited = true},
  [28] =
    {field_end, 0, .inherited = true},
    {field_range, 0},
    {field_start, 0, .inherited = true},
  [31] =
    {field_name, 0},
    {field_parameters, 1},
  [33] =
    {field_command, 2, .inherited = true},
  [34] =
    {field_lhs, 0},
    {field_rhs, 1},
  [36] =
    {field_cmd, 0},
    {field_lhs, 2, .inherited = true},
    {field_rhs, 2, .inherited = true},
  [39] =
    {field_key, 0, .inherited = true},
    {field_val, 0, .inherited = true},
  [41] =
    {field_from, 2, .inherited = true},
    {field_to, 2, .inherited = true},
  [43] =
    {field_method, 1},
    {field_sub, 0},
  [45] =
    {field_option, 0},
    {field_value, 1, .inherited = true},
  [47] =
    {field_file, 2},
  [48] =
    {field_name, 1},
    {field_repl, 2},
  [50] =
    {field_name, 2},
  [51] =
    {field_name, 1},
    {field_sub, 0},
  [53] =
    {field_id, 1, .inherited = true},
    {field_sub, 0},
  [55] =
    {field_name, 0, .inherited = true},
    {field_val, 0, .inherited = true},
  [57] =
    {field_id, 0},
  [58] =
    {field_id, 1},
    {field_sub, 0},
  [60] =
    {field_action, 2},
  [61] =
    {field_end, 0, .inherited = true},
    {field_file, 2},
    {field_range, 0},
    {field_start, 0, .inherited = true},
  [65] =
    {field_end, 0, .inherited = true},
    {field_filter, 2, .inherited = true},
    {field_range, 0},
    {field_start, 0, .inherited = true},
  [69] =
    {field_filter, 0},
  [70] =
    {field_end, 2},
    {field_start, 0},
  [72] =
    {field_key, 1, .inherited = true},
    {field_value, 1, .inherited = true},
  [74] =
    {field_function, 0},
  [75] =
    {field_left, 0},
    {field_right, 2},
  [77] =
    {field_field, 2},
    {field_value, 0},
  [79] =
    {field_function, 2, .inherited = true},
    {field_value, 0},
  [81] =
    {field_condition, 1},
  [82] =
    {field_command, 3, .inherited = true},
  [83] =
    {field_command, 2},
  [84] =
    {field_lhs, 1},
    {field_rhs, 2},
  [86] =
    {field_from, 1},
    {field_to, 2},
  [88] =
    {field_name, 0, .inherited = true},
  [89] =
    {field_method, 1},
    {field_name, 2, .inherited = true},
    {field_sub, 0},
  [92] =
    {field_value, 1},
  [93] =
    {field_name, 0},
    {field_val, 2},
  [95] =
    {field_name, 0},
    {field_name, 2, .inherited = true},
    {field_val, 2},
    {field_val, 2, .inherited = true},
  [99] =
    {field_name, 0},
    {field_name, 2, .inherited = true},
    {field_val, 2},
  [102] =
    {field_name, 2},
    {field_repl, 3},
  [104] =
    {field_end, 0, .inherited = true},
    {field_file, 3},
    {field_range, 0},
    {field_start, 0, .inherited = true},
  [108] =
    {field_key, 0},
    {field_value, 2},
  [110] =
    {field_key, 1, .inherited = true},
    {field_key, 2, .inherited = true},
    {field_value, 1, .inherited = true},
    {field_value, 2, .inherited = true},
  [114] =
    {field_key, 0, .inherited = true},
    {field_key, 1, .inherited = true},
    {field_value, 0, .inherited = true},
    {field_value, 1, .inherited = true},
  [118] =
    {field_left, 0},
    {field_right, 3},
  [120] =
    {field_value, 0},
  [121] =
    {field_index, 2},
    {field_value, 0},
  [123] =
    {field_command, 3},
  [124] =
    {field_lhs, 2},
    {field_rhs, 3},
  [126] =
    {field_from, 2},
    {field_to, 3},
  [128] =
    {field_key, 0},
    {field_val, 2},
  [130] =
    {field_sub, 0},
    {field_what, 3, .inherited = true},
  [132] =
    {field_name, 2, .inherited = true},
    {field_sub, 0},
    {field_val, 2, .inherited = true},
  [135] =
    {field_grouplist, 1},
    {field_grouplist, 2},
    {field_sub, 0},
  [138] =
    {field_method, 1},
    {field_sub, 0},
    {field_val, 3},
  [141] =
    {field_method, 1},
    {field_name, 3, .inherited = true},
    {field_sub, 0},
  [144] =
    {field_name, 0, .inherited = true},
    {field_name, 1, .inherited = true},
  [146] =
    {field_name, 3},
    {field_repl, 4},
  [148] =
    {field_name, 1},
    {field_val, 3},
  [150] =
    {field_end, 0, .inherited = true},
    {field_file, 4},
    {field_range, 0},
    {field_start, 0, .inherited = true},
  [154] =
    {field_name, 0},
    {field_value, 2},
  [156] =
    {field_condition, 0},
    {field_left, 2},
    {field_right, 4},
  [159] =
    {field_stop, 3},
    {field_value, 0},
  [161] =
    {field_start, 2},
    {field_value, 0},
  [163] =
    {field_iter, 3},
    {field_variable, 1},
  [165] =
    {field_command, 4},
  [166] =
    {field_sub, 0},
    {field_what, 4, .inherited = true},
  [168] =
    {field_name, 2, .inherited = true},
    {field_name, 3, .inherited = true},
    {field_sub, 0},
    {field_val, 2, .inherited = true},
    {field_val, 3, .inherited = true},
  [173] =
    {field_name, 3, .inherited = true},
    {field_sub, 0},
    {field_val, 3, .inherited = true},
  [176] =
    {field_method, 1},
    {field_name, 2, .inherited = true},
    {field_name, 4, .inherited = true},
    {field_sub, 0},
  [180] =
    {field_start, 2},
    {field_stop, 4},
    {field_value, 0},
  [183] =
    {field_offset, 2},
    {field_what, 0},
  [185] =
    {field_what, 1, .inherited = true},
  [186] =
    {field_name, 0},
    {field_val, 2},
    {field_what, 3, .inherited = true},
  [189] =
    {field_name, 2, .inherited = true},
    {field_name, 4, .inherited = true},
    {field_sub, 0},
    {field_val, 2, .inherited = true},
    {field_val, 4, .inherited = true},
  [194] =
    {field_name, 3, .inherited = true},
    {field_name, 4, .inherited = true},
    {field_sub, 0},
    {field_val, 3, .inherited = true},
    {field_val, 4, .inherited = true},
  [199] =
    {field_name, 3, .inherited = true},
    {field_name, 5, .inherited = true},
    {field_sub, 0},
    {field_val, 3, .inherited = true},
    {field_val, 5, .inherited = true},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = alias_sym_file,
  },
  [5] = {
    [0] = alias_sym_augroup_name,
  },
  [8] = {
    [1] = alias_sym_augroup_name,
  },
  [17] = {
    [1] = alias_sym_name,
  },
  [20] = {
    [1] = alias_sym_filenames,
  },
  [24] = {
    [1] = alias_sym_arguments,
  },
  [25] = {
    [0] = alias_sym_range,
  },
  [26] = {
    [1] = sym_integer_literal,
  },
  [29] = {
    [0] = sym_keycode,
  },
  [32] = {
    [2] = alias_sym_augroup_name,
  },
  [40] = {
    [2] = alias_sym_filenames,
  },
  [44] = {
    [0] = anon_sym_STAR,
  },
  [46] = {
    [1] = anon_sym_STAR,
  },
  [48] = {
    [0] = sym_integer_literal,
  },
  [49] = {
    [0] = aux_sym_command_statement_token1,
  },
  [50] = {
    [2] = sym_integer_literal,
  },
  [51] = {
    [2] = alias_sym_arguments,
  },
  [53] = {
    [0] = alias_sym_range,
  },
  [54] = {
    [0] = alias_sym_range,
  },
  [55] = {
    [0] = alias_sym_filter_command,
  },
  [63] = {
    [1] = alias_sym_body,
  },
  [64] = {
    [2] = alias_sym_body,
  },
  [69] = {
    [0] = sym__syn_arguments_region,
  },
  [75] = {
    [2] = sym_integer_literal,
  },
  [78] = {
    [3] = alias_sym_filenames,
  },
  [79] = {
    [1] = sym_pattern,
  },
  [80] = {
    [3] = sym_integer_literal,
  },
  [81] = {
    [0] = alias_sym_range,
  },
  [85] = {
    [3] = alias_sym_body,
  },
  [89] = {
    [3] = alias_sym_body,
  },
  [102] = {
    [4] = sym_integer_literal,
  },
  [103] = {
    [0] = alias_sym_range,
  },
  [105] = {
    [4] = alias_sym_body,
  },
  [115] = {
    [5] = sym_integer_literal,
  },
  [116] = {
    [5] = alias_sym_body,
  },
  [118] = {
    [5] = alias_sym_body,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  aux_sym__separated_statements, 2,
    aux_sym__separated_statements,
    alias_sym_body,
  sym_identifier, 2,
    sym_identifier,
    alias_sym_augroup_name,
  sym__range, 2,
    sym__range,
    alias_sym_range,
  sym__immediate_keycode, 2,
    sym__immediate_keycode,
    sym_keycode,
  sym_filename, 3,
    sym_filename,
    alias_sym_filter_command,
    alias_sym_name,
  aux_sym__plus_cmd_arg, 3,
    aux_sym__plus_cmd_arg,
    aux_sym_command_statement_token1,
    sym_pattern,
  sym__syn_arguments_keyword, 2,
    sym__syn_arguments_keyword,
    sym__syn_arguments_region,
  sym__syn_arguments_match, 2,
    sym__syn_arguments_match,
    sym__syn_arguments_region,
  aux_sym_unknown_builtin_statement_repeat1, 2,
    aux_sym_unknown_builtin_statement_repeat1,
    alias_sym_arguments,
  aux_sym_runtime_statement_repeat1, 2,
    aux_sym_runtime_statement_repeat1,
    alias_sym_filenames,
  aux_sym_script_repeat1, 2,
    aux_sym_script_repeat1,
    alias_sym_body,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 4,
  [5] = 4,
  [6] = 3,
  [7] = 7,
  [8] = 2,
  [9] = 7,
  [10] = 10,
  [11] = 11,
  [12] = 12,
  [13] = 13,
  [14] = 14,
  [15] = 15,
  [16] = 16,
  [17] = 14,
  [18] = 18,
  [19] = 19,
  [20] = 20,
  [21] = 21,
  [22] = 22,
  [23] = 14,
  [24] = 24,
  [25] = 24,
  [26] = 21,
  [27] = 27,
  [28] = 28,
  [29] = 29,
  [30] = 14,
  [31] = 14,
  [32] = 14,
  [33] = 14,
  [34] = 20,
  [35] = 18,
  [36] = 36,
  [37] = 37,
  [38] = 36,
  [39] = 39,
  [40] = 40,
  [41] = 41,
  [42] = 42,
  [43] = 43,
  [44] = 19,
  [45] = 45,
  [46] = 45,
  [47] = 28,
  [48] = 48,
  [49] = 49,
  [50] = 42,
  [51] = 39,
  [52] = 14,
  [53] = 29,
  [54] = 22,
  [55] = 43,
  [56] = 41,
  [57] = 57,
  [58] = 57,
  [59] = 59,
  [60] = 59,
  [61] = 61,
  [62] = 62,
  [63] = 63,
  [64] = 64,
  [65] = 65,
  [66] = 66,
  [67] = 67,
  [68] = 61,
  [69] = 69,
  [70] = 65,
  [71] = 67,
  [72] = 72,
  [73] = 73,
  [74] = 72,
  [75] = 75,
  [76] = 73,
  [77] = 77,
  [78] = 63,
  [79] = 79,
  [80] = 80,
  [81] = 79,
  [82] = 82,
  [83] = 83,
  [84] = 69,
  [85] = 83,
  [86] = 80,
  [87] = 77,
  [88] = 62,
  [89] = 66,
  [90] = 82,
  [91] = 64,
  [92] = 92,
  [93] = 92,
  [94] = 94,
  [95] = 95,
  [96] = 96,
  [97] = 97,
  [98] = 94,
  [99] = 95,
  [100] = 96,
  [101] = 101,
  [102] = 102,
  [103] = 102,
  [104] = 97,
  [105] = 101,
  [106] = 101,
  [107] = 102,
  [108] = 102,
  [109] = 102,
  [110] = 101,
  [111] = 101,
  [112] = 102,
  [113] = 101,
  [114] = 102,
  [115] = 101,
  [116] = 102,
  [117] = 101,
  [118] = 118,
  [119] = 119,
  [120] = 120,
  [121] = 121,
  [122] = 122,
  [123] = 122,
  [124] = 124,
  [125] = 124,
  [126] = 124,
  [127] = 124,
  [128] = 124,
  [129] = 120,
  [130] = 130,
  [131] = 130,
  [132] = 121,
  [133] = 133,
  [134] = 133,
  [135] = 135,
  [136] = 136,
  [137] = 135,
  [138] = 138,
  [139] = 138,
  [140] = 140,
  [141] = 141,
  [142] = 142,
  [143] = 143,
  [144] = 143,
  [145] = 143,
  [146] = 143,
  [147] = 147,
  [148] = 148,
  [149] = 143,
  [150] = 150,
  [151] = 151,
  [152] = 152,
  [153] = 153,
  [154] = 154,
  [155] = 155,
  [156] = 156,
  [157] = 154,
  [158] = 158,
  [159] = 155,
  [160] = 160,
  [161] = 161,
  [162] = 143,
  [163] = 143,
  [164] = 156,
  [165] = 143,
  [166] = 147,
  [167] = 156,
  [168] = 156,
  [169] = 160,
  [170] = 170,
  [171] = 171,
  [172] = 172,
  [173] = 154,
  [174] = 161,
  [175] = 141,
  [176] = 176,
  [177] = 171,
  [178] = 150,
  [179] = 170,
  [180] = 171,
  [181] = 181,
  [182] = 151,
  [183] = 148,
  [184] = 158,
  [185] = 171,
  [186] = 140,
  [187] = 176,
  [188] = 152,
  [189] = 153,
  [190] = 142,
  [191] = 155,
  [192] = 171,
  [193] = 154,
  [194] = 155,
  [195] = 195,
  [196] = 196,
  [197] = 197,
  [198] = 197,
  [199] = 199,
  [200] = 195,
  [201] = 196,
  [202] = 181,
  [203] = 195,
  [204] = 199,
  [205] = 195,
  [206] = 206,
  [207] = 207,
  [208] = 197,
  [209] = 195,
  [210] = 196,
  [211] = 211,
  [212] = 197,
  [213] = 196,
  [214] = 197,
  [215] = 196,
  [216] = 206,
  [217] = 217,
  [218] = 218,
  [219] = 219,
  [220] = 220,
  [221] = 219,
  [222] = 222,
  [223] = 206,
  [224] = 199,
  [225] = 219,
  [226] = 199,
  [227] = 218,
  [228] = 228,
  [229] = 218,
  [230] = 228,
  [231] = 222,
  [232] = 219,
  [233] = 219,
  [234] = 234,
  [235] = 228,
  [236] = 218,
  [237] = 237,
  [238] = 222,
  [239] = 234,
  [240] = 219,
  [241] = 220,
  [242] = 237,
  [243] = 243,
  [244] = 220,
  [245] = 245,
  [246] = 220,
  [247] = 206,
  [248] = 207,
  [249] = 249,
  [250] = 234,
  [251] = 228,
  [252] = 234,
  [253] = 237,
  [254] = 222,
  [255] = 255,
  [256] = 255,
  [257] = 237,
  [258] = 220,
  [259] = 217,
  [260] = 218,
  [261] = 222,
  [262] = 234,
  [263] = 237,
  [264] = 245,
  [265] = 228,
  [266] = 266,
  [267] = 267,
  [268] = 268,
  [269] = 269,
  [270] = 270,
  [271] = 271,
  [272] = 272,
  [273] = 273,
  [274] = 274,
  [275] = 275,
  [276] = 276,
  [277] = 277,
  [278] = 274,
  [279] = 274,
  [280] = 280,
  [281] = 281,
  [282] = 274,
  [283] = 272,
  [284] = 284,
  [285] = 281,
  [286] = 268,
  [287] = 274,
  [288] = 281,
  [289] = 274,
  [290] = 281,
  [291] = 274,
  [292] = 292,
  [293] = 293,
  [294] = 280,
  [295] = 293,
  [296] = 281,
  [297] = 297,
  [298] = 298,
  [299] = 299,
  [300] = 300,
  [301] = 274,
  [302] = 281,
  [303] = 274,
  [304] = 281,
  [305] = 305,
  [306] = 274,
  [307] = 281,
  [308] = 274,
  [309] = 305,
  [310] = 310,
  [311] = 311,
  [312] = 312,
  [313] = 313,
  [314] = 314,
  [315] = 310,
  [316] = 316,
  [317] = 281,
  [318] = 318,
  [319] = 274,
  [320] = 320,
  [321] = 292,
  [322] = 266,
  [323] = 323,
  [324] = 323,
  [325] = 313,
  [326] = 312,
  [327] = 327,
  [328] = 274,
  [329] = 273,
  [330] = 284,
  [331] = 281,
  [332] = 332,
  [333] = 333,
  [334] = 334,
  [335] = 274,
  [336] = 336,
  [337] = 277,
  [338] = 338,
  [339] = 339,
  [340] = 292,
  [341] = 266,
  [342] = 323,
  [343] = 343,
  [344] = 313,
  [345] = 312,
  [346] = 293,
  [347] = 292,
  [348] = 266,
  [349] = 349,
  [350] = 323,
  [351] = 292,
  [352] = 267,
  [353] = 353,
  [354] = 333,
  [355] = 313,
  [356] = 281,
  [357] = 281,
  [358] = 281,
  [359] = 268,
  [360] = 312,
  [361] = 299,
  [362] = 362,
  [363] = 274,
  [364] = 281,
  [365] = 316,
  [366] = 366,
  [367] = 276,
  [368] = 368,
  [369] = 369,
  [370] = 370,
  [371] = 371,
  [372] = 372,
  [373] = 338,
  [374] = 297,
  [375] = 332,
  [376] = 274,
  [377] = 310,
  [378] = 281,
  [379] = 269,
  [380] = 380,
  [381] = 316,
  [382] = 382,
  [383] = 268,
  [384] = 384,
  [385] = 385,
  [386] = 298,
  [387] = 387,
  [388] = 276,
  [389] = 268,
  [390] = 390,
  [391] = 391,
  [392] = 274,
  [393] = 393,
  [394] = 394,
  [395] = 312,
  [396] = 272,
  [397] = 276,
  [398] = 313,
  [399] = 338,
  [400] = 274,
  [401] = 310,
  [402] = 402,
  [403] = 403,
  [404] = 404,
  [405] = 338,
  [406] = 281,
  [407] = 269,
  [408] = 316,
  [409] = 276,
  [410] = 323,
  [411] = 411,
  [412] = 272,
  [413] = 413,
  [414] = 414,
  [415] = 415,
  [416] = 416,
  [417] = 417,
  [418] = 266,
  [419] = 419,
  [420] = 420,
  [421] = 421,
  [422] = 316,
  [423] = 338,
  [424] = 424,
  [425] = 425,
  [426] = 272,
  [427] = 274,
  [428] = 310,
  [429] = 429,
  [430] = 430,
  [431] = 281,
  [432] = 432,
  [433] = 433,
  [434] = 434,
  [435] = 435,
  [436] = 271,
  [437] = 437,
  [438] = 269,
  [439] = 439,
  [440] = 269,
  [441] = 441,
  [442] = 293,
  [443] = 293,
  [444] = 444,
  [445] = 445,
  [446] = 446,
  [447] = 447,
  [448] = 266,
  [449] = 449,
  [450] = 450,
  [451] = 451,
  [452] = 452,
  [453] = 446,
  [454] = 437,
  [455] = 414,
  [456] = 403,
  [457] = 402,
  [458] = 394,
  [459] = 393,
  [460] = 391,
  [461] = 385,
  [462] = 384,
  [463] = 382,
  [464] = 380,
  [465] = 445,
  [466] = 372,
  [467] = 371,
  [468] = 421,
  [469] = 334,
  [470] = 452,
  [471] = 451,
  [472] = 311,
  [473] = 370,
  [474] = 450,
  [475] = 369,
  [476] = 314,
  [477] = 449,
  [478] = 368,
  [479] = 424,
  [480] = 429,
  [481] = 366,
  [482] = 353,
  [483] = 420,
  [484] = 430,
  [485] = 432,
  [486] = 433,
  [487] = 419,
  [488] = 425,
  [489] = 327,
  [490] = 444,
  [491] = 318,
  [492] = 417,
  [493] = 300,
  [494] = 416,
  [495] = 415,
  [496] = 320,
  [497] = 434,
  [498] = 447,
  [499] = 435,
  [500] = 411,
  [501] = 441,
  [502] = 439,
  [503] = 503,
  [504] = 154,
  [505] = 155,
  [506] = 156,
  [507] = 206,
  [508] = 508,
  [509] = 509,
  [510] = 199,
  [511] = 511,
  [512] = 508,
  [513] = 509,
  [514] = 154,
  [515] = 156,
  [516] = 511,
  [517] = 155,
  [518] = 334,
  [519] = 519,
  [520] = 520,
  [521] = 444,
  [522] = 452,
  [523] = 449,
  [524] = 524,
  [525] = 421,
  [526] = 450,
  [527] = 207,
  [528] = 446,
  [529] = 451,
  [530] = 452,
  [531] = 451,
  [532] = 414,
  [533] = 445,
  [534] = 334,
  [535] = 207,
  [536] = 207,
  [537] = 206,
  [538] = 199,
  [539] = 539,
  [540] = 155,
  [541] = 541,
  [542] = 542,
  [543] = 154,
  [544] = 424,
  [545] = 156,
  [546] = 414,
  [547] = 419,
  [548] = 435,
  [549] = 437,
  [550] = 439,
  [551] = 402,
  [552] = 424,
  [553] = 441,
  [554] = 554,
  [555] = 156,
  [556] = 394,
  [557] = 311,
  [558] = 327,
  [559] = 393,
  [560] = 560,
  [561] = 424,
  [562] = 450,
  [563] = 154,
  [564] = 421,
  [565] = 314,
  [566] = 433,
  [567] = 449,
  [568] = 318,
  [569] = 446,
  [570] = 366,
  [571] = 368,
  [572] = 320,
  [573] = 432,
  [574] = 369,
  [575] = 429,
  [576] = 370,
  [577] = 434,
  [578] = 155,
  [579] = 447,
  [580] = 415,
  [581] = 416,
  [582] = 417,
  [583] = 430,
  [584] = 444,
  [585] = 539,
  [586] = 425,
  [587] = 391,
  [588] = 403,
  [589] = 420,
  [590] = 371,
  [591] = 541,
  [592] = 372,
  [593] = 445,
  [594] = 380,
  [595] = 411,
  [596] = 382,
  [597] = 385,
  [598] = 384,
  [599] = 206,
  [600] = 542,
  [601] = 601,
  [602] = 602,
  [603] = 554,
  [604] = 199,
  [605] = 605,
  [606] = 207,
  [607] = 560,
  [608] = 608,
  [609] = 609,
  [610] = 610,
  [611] = 611,
  [612] = 609,
  [613] = 613,
  [614] = 614,
  [615] = 609,
  [616] = 616,
  [617] = 617,
  [618] = 617,
  [619] = 616,
  [620] = 609,
  [621] = 621,
  [622] = 206,
  [623] = 614,
  [624] = 207,
  [625] = 609,
  [626] = 626,
  [627] = 199,
  [628] = 628,
  [629] = 626,
  [630] = 630,
  [631] = 452,
  [632] = 632,
  [633] = 320,
  [634] = 318,
  [635] = 380,
  [636] = 314,
  [637] = 327,
  [638] = 311,
  [639] = 639,
  [640] = 366,
  [641] = 368,
  [642] = 642,
  [643] = 643,
  [644] = 369,
  [645] = 639,
  [646] = 646,
  [647] = 646,
  [648] = 630,
  [649] = 370,
  [650] = 650,
  [651] = 371,
  [652] = 652,
  [653] = 653,
  [654] = 372,
  [655] = 650,
  [656] = 445,
  [657] = 657,
  [658] = 658,
  [659] = 659,
  [660] = 382,
  [661] = 661,
  [662] = 662,
  [663] = 663,
  [664] = 384,
  [665] = 665,
  [666] = 385,
  [667] = 391,
  [668] = 668,
  [669] = 669,
  [670] = 650,
  [671] = 393,
  [672] = 661,
  [673] = 394,
  [674] = 402,
  [675] = 403,
  [676] = 411,
  [677] = 414,
  [678] = 643,
  [679] = 420,
  [680] = 419,
  [681] = 661,
  [682] = 682,
  [683] = 425,
  [684] = 421,
  [685] = 424,
  [686] = 417,
  [687] = 416,
  [688] = 415,
  [689] = 689,
  [690] = 690,
  [691] = 643,
  [692] = 643,
  [693] = 643,
  [694] = 650,
  [695] = 447,
  [696] = 441,
  [697] = 439,
  [698] = 444,
  [699] = 437,
  [700] = 435,
  [701] = 434,
  [702] = 433,
  [703] = 432,
  [704] = 430,
  [705] = 705,
  [706] = 706,
  [707] = 446,
  [708] = 650,
  [709] = 429,
  [710] = 449,
  [711] = 450,
  [712] = 661,
  [713] = 661,
  [714] = 451,
  [715] = 334,
  [716] = 689,
  [717] = 439,
  [718] = 718,
  [719] = 414,
  [720] = 632,
  [721] = 721,
  [722] = 384,
  [723] = 424,
  [724] = 724,
  [725] = 725,
  [726] = 726,
  [727] = 727,
  [728] = 728,
  [729] = 729,
  [730] = 652,
  [731] = 729,
  [732] = 729,
  [733] = 690,
  [734] = 669,
  [735] = 721,
  [736] = 421,
  [737] = 737,
  [738] = 653,
  [739] = 739,
  [740] = 740,
  [741] = 334,
  [742] = 429,
  [743] = 728,
  [744] = 727,
  [745] = 452,
  [746] = 746,
  [747] = 451,
  [748] = 311,
  [749] = 430,
  [750] = 432,
  [751] = 433,
  [752] = 450,
  [753] = 314,
  [754] = 725,
  [755] = 449,
  [756] = 318,
  [757] = 320,
  [758] = 724,
  [759] = 658,
  [760] = 718,
  [761] = 434,
  [762] = 435,
  [763] = 437,
  [764] = 729,
  [765] = 718,
  [766] = 441,
  [767] = 447,
  [768] = 415,
  [769] = 416,
  [770] = 417,
  [771] = 771,
  [772] = 729,
  [773] = 657,
  [774] = 705,
  [775] = 370,
  [776] = 369,
  [777] = 777,
  [778] = 368,
  [779] = 542,
  [780] = 729,
  [781] = 718,
  [782] = 729,
  [783] = 740,
  [784] = 444,
  [785] = 425,
  [786] = 419,
  [787] = 420,
  [788] = 739,
  [789] = 411,
  [790] = 403,
  [791] = 402,
  [792] = 394,
  [793] = 393,
  [794] = 682,
  [795] = 659,
  [796] = 662,
  [797] = 726,
  [798] = 366,
  [799] = 446,
  [800] = 382,
  [801] = 718,
  [802] = 327,
  [803] = 718,
  [804] = 665,
  [805] = 380,
  [806] = 729,
  [807] = 807,
  [808] = 706,
  [809] = 391,
  [810] = 385,
  [811] = 668,
  [812] = 445,
  [813] = 372,
  [814] = 371,
  [815] = 815,
  [816] = 816,
  [817] = 817,
  [818] = 818,
  [819] = 819,
  [820] = 542,
  [821] = 821,
  [822] = 822,
  [823] = 823,
  [824] = 824,
  [825] = 825,
  [826] = 826,
  [827] = 826,
  [828] = 828,
  [829] = 829,
  [830] = 830,
  [831] = 815,
  [832] = 832,
  [833] = 829,
  [834] = 834,
  [835] = 835,
  [836] = 836,
  [837] = 837,
  [838] = 815,
  [839] = 737,
  [840] = 840,
  [841] = 829,
  [842] = 842,
  [843] = 830,
  [844] = 844,
  [845] = 845,
  [846] = 846,
  [847] = 847,
  [848] = 848,
  [849] = 815,
  [850] = 815,
  [851] = 815,
  [852] = 846,
  [853] = 815,
  [854] = 817,
  [855] = 835,
  [856] = 836,
  [857] = 829,
  [858] = 858,
  [859] = 845,
  [860] = 860,
  [861] = 156,
  [862] = 840,
  [863] = 818,
  [864] = 829,
  [865] = 817,
  [866] = 828,
  [867] = 867,
  [868] = 815,
  [869] = 869,
  [870] = 829,
  [871] = 871,
  [872] = 872,
  [873] = 821,
  [874] = 845,
  [875] = 875,
  [876] = 815,
  [877] = 877,
  [878] = 878,
  [879] = 846,
  [880] = 826,
  [881] = 845,
  [882] = 828,
  [883] = 815,
  [884] = 829,
  [885] = 657,
  [886] = 886,
  [887] = 826,
  [888] = 828,
  [889] = 840,
  [890] = 830,
  [891] = 822,
  [892] = 815,
  [893] = 829,
  [894] = 894,
  [895] = 829,
  [896] = 815,
  [897] = 815,
  [898] = 840,
  [899] = 815,
  [900] = 900,
  [901] = 901,
  [902] = 846,
  [903] = 830,
  [904] = 829,
  [905] = 815,
  [906] = 817,
  [907] = 836,
  [908] = 835,
  [909] = 909,
  [910] = 829,
  [911] = 829,
  [912] = 815,
  [913] = 829,
  [914] = 815,
  [915] = 846,
  [916] = 829,
  [917] = 818,
  [918] = 918,
  [919] = 829,
  [920] = 830,
  [921] = 815,
  [922] = 818,
  [923] = 815,
  [924] = 818,
  [925] = 840,
  [926] = 817,
  [927] = 829,
  [928] = 829,
  [929] = 826,
  [930] = 930,
  [931] = 835,
  [932] = 828,
  [933] = 836,
  [934] = 844,
  [935] = 935,
  [936] = 935,
  [937] = 608,
  [938] = 938,
  [939] = 657,
  [940] = 940,
  [941] = 941,
  [942] = 930,
  [943] = 860,
  [944] = 944,
  [945] = 945,
  [946] = 605,
  [947] = 947,
  [948] = 944,
  [949] = 941,
  [950] = 950,
  [951] = 951,
  [952] = 940,
  [953] = 816,
  [954] = 601,
  [955] = 945,
  [956] = 909,
  [957] = 878,
  [958] = 945,
  [959] = 959,
  [960] = 935,
  [961] = 746,
  [962] = 959,
  [963] = 842,
  [964] = 940,
  [965] = 945,
  [966] = 959,
  [967] = 941,
  [968] = 944,
  [969] = 886,
  [970] = 154,
  [971] = 155,
  [972] = 935,
  [973] = 944,
  [974] = 941,
  [975] = 940,
  [976] = 959,
  [977] = 835,
  [978] = 930,
  [979] = 836,
  [980] = 199,
  [981] = 835,
  [982] = 836,
  [983] = 947,
  [984] = 984,
  [985] = 900,
  [986] = 986,
  [987] = 901,
  [988] = 835,
  [989] = 989,
  [990] = 845,
  [991] = 950,
  [992] = 835,
  [993] = 993,
  [994] = 994,
  [995] = 995,
  [996] = 845,
  [997] = 845,
  [998] = 836,
  [999] = 628,
  [1000] = 951,
  [1001] = 836,
  [1002] = 938,
  [1003] = 860,
  [1004] = 886,
  [1005] = 845,
  [1006] = 1006,
  [1007] = 941,
  [1008] = 940,
  [1009] = 1009,
  [1010] = 1010,
  [1011] = 1011,
  [1012] = 945,
  [1013] = 959,
  [1014] = 940,
  [1015] = 1015,
  [1016] = 1016,
  [1017] = 847,
  [1018] = 944,
  [1019] = 1019,
  [1020] = 1020,
  [1021] = 930,
  [1022] = 945,
  [1023] = 601,
  [1024] = 945,
  [1025] = 959,
  [1026] = 959,
  [1027] = 605,
  [1028] = 940,
  [1029] = 941,
  [1030] = 944,
  [1031] = 894,
  [1032] = 860,
  [1033] = 608,
  [1034] = 1034,
  [1035] = 875,
  [1036] = 940,
  [1037] = 206,
  [1038] = 941,
  [1039] = 944,
  [1040] = 1040,
  [1041] = 848,
  [1042] = 1042,
  [1043] = 945,
  [1044] = 1040,
  [1045] = 832,
  [1046] = 959,
  [1047] = 871,
  [1048] = 886,
  [1049] = 869,
  [1050] = 837,
  [1051] = 872,
  [1052] = 944,
  [1053] = 941,
  [1054] = 1010,
  [1055] = 1055,
  [1056] = 1056,
  [1057] = 930,
  [1058] = 1058,
  [1059] = 1059,
  [1060] = 1015,
  [1061] = 746,
  [1062] = 1062,
  [1063] = 1063,
  [1064] = 1063,
  [1065] = 1009,
  [1066] = 601,
  [1067] = 1034,
  [1068] = 1056,
  [1069] = 605,
  [1070] = 1042,
  [1071] = 608,
  [1072] = 1020,
  [1073] = 628,
  [1074] = 1011,
  [1075] = 886,
  [1076] = 1076,
  [1077] = 1077,
  [1078] = 1076,
  [1079] = 1077,
  [1080] = 1080,
  [1081] = 1042,
  [1082] = 1076,
  [1083] = 901,
  [1084] = 1084,
  [1085] = 900,
  [1086] = 930,
  [1087] = 1076,
  [1088] = 746,
  [1089] = 1077,
  [1090] = 1077,
  [1091] = 628,
  [1092] = 886,
  [1093] = 1093,
  [1094] = 894,
  [1095] = 605,
  [1096] = 900,
  [1097] = 901,
  [1098] = 608,
  [1099] = 930,
  [1100] = 1100,
  [1101] = 886,
  [1102] = 832,
  [1103] = 1084,
  [1104] = 1080,
  [1105] = 1105,
  [1106] = 1106,
  [1107] = 848,
  [1108] = 601,
  [1109] = 1109,
  [1110] = 875,
  [1111] = 837,
  [1112] = 1093,
  [1113] = 836,
  [1114] = 119,
  [1115] = 832,
  [1116] = 1077,
  [1117] = 837,
  [1118] = 1076,
  [1119] = 875,
  [1120] = 1120,
  [1121] = 1106,
  [1122] = 1122,
  [1123] = 1076,
  [1124] = 1077,
  [1125] = 1125,
  [1126] = 1076,
  [1127] = 845,
  [1128] = 1077,
  [1129] = 845,
  [1130] = 1076,
  [1131] = 836,
  [1132] = 1105,
  [1133] = 628,
  [1134] = 835,
  [1135] = 1135,
  [1136] = 848,
  [1137] = 1055,
  [1138] = 1138,
  [1139] = 1077,
  [1140] = 1100,
  [1141] = 1106,
  [1142] = 835,
  [1143] = 894,
  [1144] = 1109,
  [1145] = 1145,
  [1146] = 848,
  [1147] = 1147,
  [1148] = 1055,
  [1149] = 1149,
  [1150] = 944,
  [1151] = 941,
  [1152] = 1138,
  [1153] = 875,
  [1154] = 940,
  [1155] = 1155,
  [1156] = 1156,
  [1157] = 837,
  [1158] = 832,
  [1159] = 1159,
  [1160] = 1156,
  [1161] = 1125,
  [1162] = 941,
  [1163] = 1109,
  [1164] = 940,
  [1165] = 1155,
  [1166] = 959,
  [1167] = 945,
  [1168] = 894,
  [1169] = 945,
  [1170] = 1122,
  [1171] = 1171,
  [1172] = 1135,
  [1173] = 1106,
  [1174] = 944,
  [1175] = 959,
  [1176] = 1176,
  [1177] = 1149,
  [1178] = 1178,
  [1179] = 1179,
  [1180] = 1180,
  [1181] = 1147,
  [1182] = 1182,
  [1183] = 1183,
  [1184] = 1184,
  [1185] = 1185,
  [1186] = 1186,
  [1187] = 1187,
  [1188] = 1182,
  [1189] = 1189,
  [1190] = 1190,
  [1191] = 1191,
  [1192] = 1192,
  [1193] = 886,
  [1194] = 1171,
  [1195] = 1195,
  [1196] = 1196,
  [1197] = 1197,
  [1198] = 1198,
  [1199] = 1199,
  [1200] = 1200,
  [1201] = 1201,
  [1202] = 1202,
  [1203] = 1203,
  [1204] = 845,
  [1205] = 1205,
  [1206] = 1206,
  [1207] = 1207,
  [1208] = 1206,
  [1209] = 1209,
  [1210] = 835,
  [1211] = 1211,
  [1212] = 1145,
  [1213] = 836,
  [1214] = 845,
  [1215] = 836,
  [1216] = 1216,
  [1217] = 835,
  [1218] = 1218,
  [1219] = 1211,
  [1220] = 1220,
  [1221] = 608,
  [1222] = 1191,
  [1223] = 1189,
  [1224] = 1224,
  [1225] = 1225,
  [1226] = 1226,
  [1227] = 1196,
  [1228] = 605,
  [1229] = 1229,
  [1230] = 1159,
  [1231] = 1192,
  [1232] = 601,
  [1233] = 1203,
  [1234] = 1234,
  [1235] = 1196,
  [1236] = 1198,
  [1237] = 1218,
  [1238] = 628,
  [1239] = 836,
  [1240] = 1192,
  [1241] = 1182,
  [1242] = 1189,
  [1243] = 1191,
  [1244] = 1244,
  [1245] = 1183,
  [1246] = 1246,
  [1247] = 1234,
  [1248] = 1248,
  [1249] = 1180,
  [1250] = 1179,
  [1251] = 1248,
  [1252] = 1252,
  [1253] = 1197,
  [1254] = 1192,
  [1255] = 1255,
  [1256] = 1182,
  [1257] = 1207,
  [1258] = 886,
  [1259] = 1209,
  [1260] = 1205,
  [1261] = 1252,
  [1262] = 1178,
  [1263] = 1216,
  [1264] = 1264,
  [1265] = 1184,
  [1266] = 1185,
  [1267] = 1176,
  [1268] = 1220,
  [1269] = 1186,
  [1270] = 1189,
  [1271] = 1187,
  [1272] = 1191,
  [1273] = 1229,
  [1274] = 1274,
  [1275] = 1190,
  [1276] = 1196,
  [1277] = 608,
  [1278] = 1246,
  [1279] = 1192,
  [1280] = 1182,
  [1281] = 605,
  [1282] = 601,
  [1283] = 1283,
  [1284] = 1226,
  [1285] = 1196,
  [1286] = 1264,
  [1287] = 119,
  [1288] = 1274,
  [1289] = 1189,
  [1290] = 835,
  [1291] = 1191,
  [1292] = 1274,
  [1293] = 1195,
  [1294] = 1264,
  [1295] = 1199,
  [1296] = 845,
  [1297] = 1225,
  [1298] = 944,
  [1299] = 941,
  [1300] = 940,
  [1301] = 1224,
  [1302] = 959,
  [1303] = 835,
  [1304] = 836,
  [1305] = 1264,
  [1306] = 1201,
  [1307] = 1200,
  [1308] = 944,
  [1309] = 945,
  [1310] = 845,
  [1311] = 941,
  [1312] = 1244,
  [1313] = 1274,
  [1314] = 1106,
  [1315] = 940,
  [1316] = 945,
  [1317] = 959,
  [1318] = 1202,
  [1319] = 1255,
  [1320] = 628,
  [1321] = 1196,
  [1322] = 1322,
  [1323] = 944,
  [1324] = 1324,
  [1325] = 1325,
  [1326] = 940,
  [1327] = 1327,
  [1328] = 1196,
  [1329] = 945,
  [1330] = 945,
  [1331] = 1192,
  [1332] = 1182,
  [1333] = 1192,
  [1334] = 1334,
  [1335] = 1335,
  [1336] = 1182,
  [1337] = 156,
  [1338] = 1338,
  [1339] = 1334,
  [1340] = 1322,
  [1341] = 1335,
  [1342] = 154,
  [1343] = 941,
  [1344] = 1344,
  [1345] = 1345,
  [1346] = 1191,
  [1347] = 1335,
  [1348] = 155,
  [1349] = 1349,
  [1350] = 1189,
  [1351] = 1351,
  [1352] = 1352,
  [1353] = 959,
  [1354] = 1322,
  [1355] = 1344,
  [1356] = 1334,
  [1357] = 1357,
  [1358] = 1358,
  [1359] = 1322,
  [1360] = 154,
  [1361] = 155,
  [1362] = 1335,
  [1363] = 156,
  [1364] = 119,
  [1365] = 1365,
  [1366] = 1366,
  [1367] = 1338,
  [1368] = 1368,
  [1369] = 1369,
  [1370] = 1370,
  [1371] = 848,
  [1372] = 959,
  [1373] = 940,
  [1374] = 944,
  [1375] = 156,
  [1376] = 1370,
  [1377] = 941,
  [1378] = 875,
  [1379] = 154,
  [1380] = 1191,
  [1381] = 155,
  [1382] = 1358,
  [1383] = 1189,
  [1384] = 1283,
  [1385] = 1365,
  [1386] = 1334,
  [1387] = 1387,
  [1388] = 1182,
  [1389] = 1264,
  [1390] = 1369,
  [1391] = 1391,
  [1392] = 1392,
  [1393] = 154,
  [1394] = 155,
  [1395] = 1366,
  [1396] = 1396,
  [1397] = 1397,
  [1398] = 1398,
  [1399] = 1274,
  [1400] = 1366,
  [1401] = 1327,
  [1402] = 1397,
  [1403] = 1403,
  [1404] = 848,
  [1405] = 1349,
  [1406] = 1406,
  [1407] = 1397,
  [1408] = 1408,
  [1409] = 1409,
  [1410] = 1369,
  [1411] = 1397,
  [1412] = 1412,
  [1413] = 1397,
  [1414] = 1414,
  [1415] = 1076,
  [1416] = 1077,
  [1417] = 421,
  [1418] = 1418,
  [1419] = 1419,
  [1420] = 1420,
  [1421] = 1421,
  [1422] = 1397,
  [1423] = 1423,
  [1424] = 1424,
  [1425] = 1425,
  [1426] = 1397,
  [1427] = 1427,
  [1428] = 1345,
  [1429] = 1429,
  [1430] = 1396,
  [1431] = 1431,
  [1432] = 1264,
  [1433] = 1433,
  [1434] = 875,
  [1435] = 1435,
  [1436] = 1352,
  [1437] = 1368,
  [1438] = 414,
  [1439] = 1439,
  [1440] = 1440,
  [1441] = 1441,
  [1442] = 1397,
  [1443] = 1397,
  [1444] = 1396,
  [1445] = 1191,
  [1446] = 1189,
  [1447] = 156,
  [1448] = 1435,
  [1449] = 1449,
  [1450] = 1450,
  [1451] = 1076,
  [1452] = 1452,
  [1453] = 1264,
  [1454] = 1077,
  [1455] = 1425,
  [1456] = 1450,
  [1457] = 1457,
  [1458] = 1397,
  [1459] = 1449,
  [1460] = 1182,
  [1461] = 1461,
  [1462] = 1192,
  [1463] = 1274,
  [1464] = 1274,
  [1465] = 1324,
  [1466] = 156,
  [1467] = 155,
  [1468] = 1468,
  [1469] = 1427,
  [1470] = 1368,
  [1471] = 1471,
  [1472] = 1472,
  [1473] = 1351,
  [1474] = 1452,
  [1475] = 1196,
  [1476] = 1476,
  [1477] = 1408,
  [1478] = 1478,
  [1479] = 1325,
  [1480] = 154,
  [1481] = 1324,
  [1482] = 1482,
  [1483] = 1418,
  [1484] = 1397,
  [1485] = 1191,
  [1486] = 1189,
  [1487] = 1433,
  [1488] = 1431,
  [1489] = 1476,
  [1490] = 1490,
  [1491] = 1420,
  [1492] = 1468,
  [1493] = 1421,
  [1494] = 1494,
  [1495] = 1495,
  [1496] = 1397,
  [1497] = 1397,
  [1498] = 1196,
  [1499] = 1420,
  [1500] = 1457,
  [1501] = 1501,
  [1502] = 1461,
  [1503] = 1264,
  [1504] = 1490,
  [1505] = 1494,
  [1506] = 1506,
  [1507] = 1403,
  [1508] = 1192,
  [1509] = 1427,
  [1510] = 154,
  [1511] = 1274,
  [1512] = 1427,
  [1513] = 155,
  [1514] = 1396,
  [1515] = 1501,
  [1516] = 156,
  [1517] = 1397,
  [1518] = 1420,
  [1519] = 1424,
  [1520] = 1520,
  [1521] = 1392,
  [1522] = 1391,
  [1523] = 1398,
  [1524] = 1322,
  [1525] = 1525,
  [1526] = 206,
  [1527] = 1525,
  [1528] = 1528,
  [1529] = 1335,
  [1530] = 1525,
  [1531] = 1531,
  [1532] = 1322,
  [1533] = 199,
  [1534] = 1534,
  [1535] = 1535,
  [1536] = 1334,
  [1537] = 1537,
  [1538] = 1538,
  [1539] = 119,
  [1540] = 1324,
  [1541] = 1368,
  [1542] = 1542,
  [1543] = 1322,
  [1544] = 1544,
  [1545] = 1545,
  [1546] = 1495,
  [1547] = 199,
  [1548] = 206,
  [1549] = 1525,
  [1550] = 1550,
  [1551] = 1551,
  [1552] = 1196,
  [1553] = 1334,
  [1554] = 1554,
  [1555] = 1555,
  [1556] = 1556,
  [1557] = 1557,
  [1558] = 1335,
  [1559] = 1559,
  [1560] = 1560,
  [1561] = 1525,
  [1562] = 1482,
  [1563] = 1563,
  [1564] = 1564,
  [1565] = 1520,
  [1566] = 1335,
  [1567] = 1567,
  [1568] = 1334,
  [1569] = 1412,
  [1570] = 206,
  [1571] = 1525,
  [1572] = 421,
  [1573] = 1573,
  [1574] = 1423,
  [1575] = 1495,
  [1576] = 1576,
  [1577] = 1577,
  [1578] = 1406,
  [1579] = 1579,
  [1580] = 1525,
  [1581] = 1581,
  [1582] = 1440,
  [1583] = 1551,
  [1584] = 451,
  [1585] = 1472,
  [1586] = 1567,
  [1587] = 452,
  [1588] = 334,
  [1589] = 1589,
  [1590] = 1590,
  [1591] = 1478,
  [1592] = 1592,
  [1593] = 1387,
  [1594] = 1334,
  [1595] = 1525,
  [1596] = 1596,
  [1597] = 1369,
  [1598] = 1471,
  [1599] = 414,
  [1600] = 1525,
  [1601] = 1192,
  [1602] = 1419,
  [1603] = 1525,
  [1604] = 1182,
  [1605] = 1439,
  [1606] = 1606,
  [1607] = 1366,
  [1608] = 1608,
  [1609] = 1550,
  [1610] = 199,
  [1611] = 1611,
  [1612] = 1406,
  [1613] = 1322,
  [1614] = 1606,
  [1615] = 1506,
  [1616] = 1563,
  [1617] = 1525,
  [1618] = 1441,
  [1619] = 1419,
  [1620] = 1620,
  [1621] = 1191,
  [1622] = 1189,
  [1623] = 1335,
  [1624] = 1525,
  [1625] = 1625,
  [1626] = 1525,
  [1627] = 1525,
  [1628] = 1076,
  [1629] = 1629,
  [1630] = 1077,
  [1631] = 1076,
  [1632] = 1560,
  [1633] = 1538,
  [1634] = 1629,
  [1635] = 1590,
  [1636] = 1629,
  [1637] = 206,
  [1638] = 206,
  [1639] = 1629,
  [1640] = 1640,
  [1641] = 1537,
  [1642] = 1642,
  [1643] = 1629,
  [1644] = 1644,
  [1645] = 1077,
  [1646] = 1495,
  [1647] = 1629,
  [1648] = 199,
  [1649] = 1577,
  [1650] = 1629,
  [1651] = 1560,
  [1652] = 1596,
  [1653] = 1653,
  [1654] = 1644,
  [1655] = 1535,
  [1656] = 1656,
  [1657] = 1579,
  [1658] = 1611,
  [1659] = 1659,
  [1660] = 1576,
  [1661] = 1661,
  [1662] = 1662,
  [1663] = 1629,
  [1664] = 1625,
  [1665] = 1629,
  [1666] = 1644,
  [1667] = 199,
  [1668] = 1629,
  [1669] = 1629,
  [1670] = 1564,
  [1671] = 1592,
  [1672] = 1531,
  [1673] = 1673,
  [1674] = 1674,
  [1675] = 1644,
  [1676] = 1629,
  [1677] = 1581,
  [1678] = 1678,
  [1679] = 1679,
  [1680] = 1680,
  [1681] = 1681,
  [1682] = 1644,
  [1683] = 1642,
  [1684] = 1684,
  [1685] = 1406,
  [1686] = 1419,
  [1687] = 206,
  [1688] = 1688,
  [1689] = 199,
  [1690] = 1573,
  [1691] = 1589,
  [1692] = 1620,
  [1693] = 1528,
  [1694] = 1629,
  [1695] = 1528,
  [1696] = 119,
  [1697] = 1534,
  [1698] = 1698,
  [1699] = 119,
  [1700] = 1629,
  [1701] = 119,
  [1702] = 1656,
  [1703] = 1703,
  [1704] = 1196,
  [1705] = 986,
  [1706] = 1653,
  [1707] = 989,
  [1708] = 1681,
  [1709] = 1709,
  [1710] = 1192,
  [1711] = 1182,
  [1712] = 995,
  [1713] = 1713,
  [1714] = 1714,
  [1715] = 1715,
  [1716] = 1716,
  [1717] = 993,
  [1718] = 1673,
  [1719] = 1077,
  [1720] = 1528,
  [1721] = 1076,
  [1722] = 1722,
  [1723] = 1659,
  [1724] = 1368,
  [1725] = 1725,
  [1726] = 1324,
  [1727] = 1727,
  [1728] = 1728,
  [1729] = 207,
  [1730] = 1730,
  [1731] = 1731,
  [1732] = 154,
  [1733] = 155,
  [1734] = 156,
  [1735] = 1735,
  [1736] = 1189,
  [1737] = 1191,
  [1738] = 1738,
  [1739] = 1739,
  [1740] = 1740,
  [1741] = 1741,
  [1742] = 1742,
  [1743] = 1698,
  [1744] = 1661,
  [1745] = 119,
  [1746] = 1076,
  [1747] = 1747,
  [1748] = 1748,
  [1749] = 1749,
  [1750] = 1077,
  [1751] = 1679,
  [1752] = 1752,
  [1753] = 1753,
  [1754] = 1560,
  [1755] = 1662,
  [1756] = 1756,
  [1757] = 1757,
  [1758] = 1758,
  [1759] = 1759,
  [1760] = 353,
  [1761] = 1761,
  [1762] = 1722,
  [1763] = 1369,
  [1764] = 1366,
  [1765] = 1765,
  [1766] = 1730,
  [1767] = 1709,
  [1768] = 1728,
  [1769] = 1006,
  [1770] = 1739,
  [1771] = 1727,
  [1772] = 1772,
  [1773] = 1684,
  [1774] = 1774,
  [1775] = 1775,
  [1776] = 1679,
  [1777] = 1777,
  [1778] = 1698,
  [1779] = 1725,
  [1780] = 1780,
  [1781] = 1781,
  [1782] = 1774,
  [1783] = 1783,
  [1784] = 1784,
  [1785] = 1785,
  [1786] = 1786,
  [1787] = 1787,
  [1788] = 1788,
  [1789] = 1714,
  [1790] = 1790,
  [1791] = 1791,
  [1792] = 1792,
  [1793] = 1713,
  [1794] = 1794,
  [1795] = 1777,
  [1796] = 1796,
  [1797] = 1495,
  [1798] = 1748,
  [1799] = 1731,
  [1800] = 156,
  [1801] = 1703,
  [1802] = 1802,
  [1803] = 207,
  [1804] = 1753,
  [1805] = 1805,
  [1806] = 353,
  [1807] = 1807,
  [1808] = 1808,
  [1809] = 1809,
  [1810] = 1810,
  [1811] = 1811,
  [1812] = 1812,
  [1813] = 1813,
  [1814] = 1814,
  [1815] = 1740,
  [1816] = 1794,
  [1817] = 1814,
  [1818] = 1818,
  [1819] = 1819,
  [1820] = 1820,
  [1821] = 1759,
  [1822] = 1822,
  [1823] = 1823,
  [1824] = 1781,
  [1825] = 1752,
  [1826] = 1826,
  [1827] = 1735,
  [1828] = 1828,
  [1829] = 1829,
  [1830] = 1715,
  [1831] = 1831,
  [1832] = 1832,
  [1833] = 1741,
  [1834] = 1406,
  [1835] = 1738,
  [1836] = 1419,
  [1837] = 1698,
  [1838] = 1838,
  [1839] = 1839,
  [1840] = 1679,
  [1841] = 1811,
  [1842] = 1747,
  [1843] = 154,
  [1844] = 1742,
  [1845] = 1845,
  [1846] = 1814,
  [1847] = 155,
  [1848] = 1749,
  [1849] = 1849,
  [1850] = 1791,
  [1851] = 1792,
  [1852] = 1852,
  [1853] = 1196,
  [1854] = 1854,
  [1855] = 1765,
  [1856] = 1191,
  [1857] = 1189,
  [1858] = 1858,
  [1859] = 1859,
  [1860] = 1814,
  [1861] = 1775,
  [1862] = 119,
  [1863] = 1758,
  [1864] = 1192,
  [1865] = 1757,
  [1866] = 1756,
  [1867] = 1761,
  [1868] = 1182,
  [1869] = 1055,
  [1870] = 1808,
  [1871] = 1832,
  [1872] = 199,
  [1873] = 119,
  [1874] = 1783,
  [1875] = 1875,
  [1876] = 1859,
  [1877] = 1877,
  [1878] = 1786,
  [1879] = 1802,
  [1880] = 119,
  [1881] = 1881,
  [1882] = 1882,
  [1883] = 1883,
  [1884] = 1884,
  [1885] = 1885,
  [1886] = 1886,
  [1887] = 1887,
  [1888] = 1780,
  [1889] = 119,
  [1890] = 424,
  [1891] = 1829,
  [1892] = 1892,
  [1893] = 1893,
  [1894] = 1560,
  [1895] = 1895,
  [1896] = 1858,
  [1897] = 1854,
  [1898] = 1898,
  [1899] = 1898,
  [1900] = 1893,
  [1901] = 1901,
  [1902] = 1805,
  [1903] = 1903,
  [1904] = 206,
  [1905] = 1905,
  [1906] = 1828,
  [1907] = 1264,
  [1908] = 1785,
  [1909] = 1787,
  [1910] = 1274,
  [1911] = 1911,
  [1912] = 1912,
  [1913] = 1895,
  [1914] = 1678,
  [1915] = 119,
  [1916] = 1822,
  [1917] = 1820,
  [1918] = 1784,
  [1919] = 1812,
  [1920] = 1264,
  [1921] = 1818,
  [1922] = 1813,
  [1923] = 1059,
  [1924] = 1924,
  [1925] = 1925,
  [1926] = 1807,
  [1927] = 1796,
  [1928] = 1884,
  [1929] = 1838,
  [1930] = 1881,
  [1931] = 1892,
  [1932] = 1528,
  [1933] = 1839,
  [1934] = 1058,
  [1935] = 1274,
  [1936] = 1809,
  [1937] = 1790,
  [1938] = 1788,
  [1939] = 1062,
  [1940] = 1819,
  [1941] = 1810,
  [1942] = 1942,
  [1943] = 1942,
  [1944] = 1944,
  [1945] = 1334,
  [1946] = 1946,
  [1947] = 119,
  [1948] = 1882,
  [1949] = 1949,
  [1950] = 1950,
  [1951] = 1951,
  [1952] = 1886,
  [1953] = 1953,
  [1954] = 1911,
  [1955] = 1912,
  [1956] = 1678,
  [1957] = 1957,
  [1958] = 1958,
  [1959] = 1334,
  [1960] = 1960,
  [1961] = 1055,
  [1962] = 119,
  [1963] = 1883,
  [1964] = 1950,
  [1965] = 1965,
  [1966] = 1966,
  [1967] = 206,
  [1968] = 1968,
  [1969] = 1969,
  [1970] = 1970,
  [1971] = 1925,
  [1972] = 1972,
  [1973] = 1949,
  [1974] = 1974,
  [1975] = 1975,
  [1976] = 1960,
  [1977] = 1966,
  [1978] = 1978,
  [1979] = 1979,
  [1980] = 1980,
  [1981] = 199,
  [1982] = 1982,
  [1983] = 1983,
  [1984] = 1984,
  [1985] = 1985,
  [1986] = 1986,
  [1987] = 1987,
  [1988] = 154,
  [1989] = 1951,
  [1990] = 155,
  [1991] = 1991,
  [1992] = 1992,
  [1993] = 1993,
  [1994] = 1982,
  [1995] = 1975,
  [1996] = 1996,
  [1997] = 424,
  [1998] = 119,
  [1999] = 1999,
  [2000] = 2000,
  [2001] = 156,
  [2002] = 2002,
  [2003] = 1058,
  [2004] = 1338,
  [2005] = 2005,
  [2006] = 1335,
  [2007] = 1975,
  [2008] = 2008,
  [2009] = 1975,
  [2010] = 2010,
  [2011] = 1901,
  [2012] = 1970,
  [2013] = 2013,
  [2014] = 1903,
  [2015] = 2015,
  [2016] = 2016,
  [2017] = 1924,
  [2018] = 2018,
  [2019] = 2019,
  [2020] = 2020,
  [2021] = 1969,
  [2022] = 1975,
  [2023] = 2023,
  [2024] = 1978,
  [2025] = 2025,
  [2026] = 1983,
  [2027] = 2027,
  [2028] = 1984,
  [2029] = 2029,
  [2030] = 2030,
  [2031] = 2031,
  [2032] = 2032,
  [2033] = 1679,
  [2034] = 1980,
  [2035] = 1885,
  [2036] = 1698,
  [2037] = 2037,
  [2038] = 2038,
  [2039] = 1322,
  [2040] = 1877,
  [2041] = 2041,
  [2042] = 1875,
  [2043] = 2043,
  [2044] = 2044,
  [2045] = 1322,
  [2046] = 2046,
  [2047] = 1946,
  [2048] = 119,
  [2049] = 2049,
  [2050] = 1335,
  [2051] = 2051,
  [2052] = 1974,
  [2053] = 119,
  [2054] = 2054,
  [2055] = 2055,
  [2056] = 2056,
  [2057] = 2057,
  [2058] = 1979,
  [2059] = 94,
  [2060] = 1274,
  [2061] = 1996,
  [2062] = 119,
  [2063] = 1999,
  [2064] = 1264,
  [2065] = 96,
  [2066] = 2066,
  [2067] = 154,
  [2068] = 2068,
  [2069] = 2069,
  [2070] = 1958,
  [2071] = 2071,
  [2072] = 2072,
  [2073] = 1972,
  [2074] = 2074,
  [2075] = 2075,
  [2076] = 2076,
  [2077] = 2037,
  [2078] = 119,
  [2079] = 155,
  [2080] = 2080,
  [2081] = 2032,
  [2082] = 2082,
  [2083] = 2038,
  [2084] = 2016,
  [2085] = 2085,
  [2086] = 2018,
  [2087] = 2020,
  [2088] = 1957,
  [2089] = 2030,
  [2090] = 2027,
  [2091] = 2029,
  [2092] = 1264,
  [2093] = 1968,
  [2094] = 2094,
  [2095] = 156,
  [2096] = 1993,
  [2097] = 2097,
  [2098] = 1338,
  [2099] = 1274,
  [2100] = 2100,
  [2101] = 2101,
  [2102] = 1965,
  [2103] = 2103,
  [2104] = 95,
  [2105] = 1991,
  [2106] = 1058,
  [2107] = 1826,
  [2108] = 2108,
  [2109] = 2109,
  [2110] = 2110,
  [2111] = 2111,
  [2112] = 2112,
  [2113] = 119,
  [2114] = 2114,
  [2115] = 2115,
  [2116] = 2116,
  [2117] = 2117,
  [2118] = 1986,
  [2119] = 2119,
  [2120] = 2002,
  [2121] = 2121,
  [2122] = 1944,
  [2123] = 1055,
  [2124] = 2124,
  [2125] = 1852,
  [2126] = 2008,
  [2127] = 1953,
  [2128] = 1987,
  [2129] = 2101,
  [2130] = 2130,
  [2131] = 2131,
  [2132] = 2132,
  [2133] = 2133,
  [2134] = 2132,
  [2135] = 2049,
  [2136] = 2015,
  [2137] = 1322,
  [2138] = 2108,
  [2139] = 2139,
  [2140] = 2140,
  [2141] = 2141,
  [2142] = 2100,
  [2143] = 2143,
  [2144] = 95,
  [2145] = 2145,
  [2146] = 2146,
  [2147] = 2147,
  [2148] = 2148,
  [2149] = 2149,
  [2150] = 2141,
  [2151] = 2140,
  [2152] = 2148,
  [2153] = 2069,
  [2154] = 2149,
  [2155] = 2155,
  [2156] = 2148,
  [2157] = 2097,
  [2158] = 2149,
  [2159] = 2085,
  [2160] = 2155,
  [2161] = 2130,
  [2162] = 2148,
  [2163] = 2082,
  [2164] = 2149,
  [2165] = 2149,
  [2166] = 2071,
  [2167] = 2148,
  [2168] = 2155,
  [2169] = 2121,
  [2170] = 2146,
  [2171] = 2145,
  [2172] = 2172,
  [2173] = 2173,
  [2174] = 1264,
  [2175] = 2173,
  [2176] = 2148,
  [2177] = 2149,
  [2178] = 2178,
  [2179] = 2143,
  [2180] = 2180,
  [2181] = 2181,
  [2182] = 1334,
  [2183] = 2147,
  [2184] = 1335,
  [2185] = 2155,
  [2186] = 2186,
  [2187] = 2119,
  [2188] = 2149,
  [2189] = 2189,
  [2190] = 2186,
  [2191] = 2056,
  [2192] = 2155,
  [2193] = 2189,
  [2194] = 2186,
  [2195] = 2155,
  [2196] = 2143,
  [2197] = 2115,
  [2198] = 2198,
  [2199] = 2149,
  [2200] = 2200,
  [2201] = 2201,
  [2202] = 2202,
  [2203] = 1274,
  [2204] = 2148,
  [2205] = 2205,
  [2206] = 2054,
  [2207] = 2117,
  [2208] = 2116,
  [2209] = 2209,
  [2210] = 97,
  [2211] = 2124,
  [2212] = 1826,
  [2213] = 2140,
  [2214] = 2205,
  [2215] = 2141,
  [2216] = 2148,
  [2217] = 2201,
  [2218] = 1274,
  [2219] = 2066,
  [2220] = 2148,
  [2221] = 96,
  [2222] = 2075,
  [2223] = 2141,
  [2224] = 2224,
  [2225] = 2109,
  [2226] = 2140,
  [2227] = 2072,
  [2228] = 2111,
  [2229] = 2172,
  [2230] = 2149,
  [2231] = 1264,
  [2232] = 1852,
  [2233] = 2149,
  [2234] = 2234,
  [2235] = 2235,
  [2236] = 2155,
  [2237] = 2148,
  [2238] = 2238,
  [2239] = 2186,
  [2240] = 1322,
  [2241] = 2148,
  [2242] = 2143,
  [2243] = 2189,
  [2244] = 1334,
  [2245] = 119,
  [2246] = 2143,
  [2247] = 2247,
  [2248] = 2149,
  [2249] = 2249,
  [2250] = 2155,
  [2251] = 2251,
  [2252] = 2252,
  [2253] = 2186,
  [2254] = 206,
  [2255] = 2148,
  [2256] = 2149,
  [2257] = 1335,
  [2258] = 2189,
  [2259] = 2149,
  [2260] = 2055,
  [2261] = 2148,
  [2262] = 2262,
  [2263] = 2148,
  [2264] = 199,
  [2265] = 2141,
  [2266] = 2140,
  [2267] = 94,
  [2268] = 2133,
  [2269] = 2149,
  [2270] = 2189,
  [2271] = 2186,
  [2272] = 2155,
  [2273] = 2143,
  [2274] = 2112,
  [2275] = 2110,
  [2276] = 2276,
  [2277] = 2277,
  [2278] = 2278,
  [2279] = 2279,
  [2280] = 2280,
  [2281] = 2281,
  [2282] = 2282,
  [2283] = 2283,
  [2284] = 2284,
  [2285] = 2285,
  [2286] = 2286,
  [2287] = 2287,
  [2288] = 2288,
  [2289] = 2289,
  [2290] = 2290,
  [2291] = 2291,
  [2292] = 2292,
  [2293] = 2293,
  [2294] = 2294,
  [2295] = 2295,
  [2296] = 2296,
  [2297] = 2297,
  [2298] = 2298,
  [2299] = 2299,
  [2300] = 2284,
  [2301] = 2301,
  [2302] = 2302,
  [2303] = 2303,
  [2304] = 2304,
  [2305] = 2305,
  [2306] = 2306,
  [2307] = 2307,
  [2308] = 2308,
  [2309] = 2309,
  [2310] = 2294,
  [2311] = 2311,
  [2312] = 2312,
  [2313] = 2209,
  [2314] = 2314,
  [2315] = 2315,
  [2316] = 2316,
  [2317] = 2317,
  [2318] = 2299,
  [2319] = 2319,
  [2320] = 2281,
  [2321] = 2315,
  [2322] = 2322,
  [2323] = 2323,
  [2324] = 206,
  [2325] = 2325,
  [2326] = 2326,
  [2327] = 2327,
  [2328] = 2328,
  [2329] = 2329,
  [2330] = 2330,
  [2331] = 2331,
  [2332] = 2332,
  [2333] = 2333,
  [2334] = 2334,
  [2335] = 2335,
  [2336] = 2336,
  [2337] = 2337,
  [2338] = 2278,
  [2339] = 2234,
  [2340] = 2340,
  [2341] = 2341,
  [2342] = 2342,
  [2343] = 2343,
  [2344] = 2344,
  [2345] = 2345,
  [2346] = 2346,
  [2347] = 2283,
  [2348] = 2348,
  [2349] = 2349,
  [2350] = 2350,
  [2351] = 2351,
  [2352] = 2352,
  [2353] = 2353,
  [2354] = 2311,
  [2355] = 2355,
  [2356] = 2356,
  [2357] = 2357,
  [2358] = 2358,
  [2359] = 2359,
  [2360] = 2360,
  [2361] = 2361,
  [2362] = 2311,
  [2363] = 2278,
  [2364] = 2364,
  [2365] = 2365,
  [2366] = 2366,
  [2367] = 2367,
  [2368] = 2368,
  [2369] = 2369,
  [2370] = 2370,
  [2371] = 2371,
  [2372] = 1334,
  [2373] = 2373,
  [2374] = 2309,
  [2375] = 2375,
  [2376] = 2376,
  [2377] = 2377,
  [2378] = 2378,
  [2379] = 2379,
  [2380] = 2380,
  [2381] = 2381,
  [2382] = 2382,
  [2383] = 2383,
  [2384] = 2384,
  [2385] = 2385,
  [2386] = 2386,
  [2387] = 2387,
  [2388] = 2388,
  [2389] = 2389,
  [2390] = 2283,
  [2391] = 2391,
  [2392] = 2392,
  [2393] = 2393,
  [2394] = 2394,
  [2395] = 2395,
  [2396] = 2396,
  [2397] = 2397,
  [2398] = 2398,
  [2399] = 2399,
  [2400] = 2400,
  [2401] = 2307,
  [2402] = 2402,
  [2403] = 2403,
  [2404] = 2404,
  [2405] = 2405,
  [2406] = 2284,
  [2407] = 2407,
  [2408] = 2408,
  [2409] = 1335,
  [2410] = 2410,
  [2411] = 2411,
  [2412] = 2412,
  [2413] = 2413,
  [2414] = 2414,
  [2415] = 2294,
  [2416] = 2249,
  [2417] = 2283,
  [2418] = 2306,
  [2419] = 2305,
  [2420] = 2420,
  [2421] = 2421,
  [2422] = 2422,
  [2423] = 2423,
  [2424] = 2309,
  [2425] = 2425,
  [2426] = 1334,
  [2427] = 2307,
  [2428] = 2306,
  [2429] = 2429,
  [2430] = 2305,
  [2431] = 2305,
  [2432] = 2432,
  [2433] = 2433,
  [2434] = 2434,
  [2435] = 2435,
  [2436] = 2436,
  [2437] = 2306,
  [2438] = 2438,
  [2439] = 2439,
  [2440] = 2440,
  [2441] = 2441,
  [2442] = 2307,
  [2443] = 2443,
  [2444] = 2444,
  [2445] = 2309,
  [2446] = 2446,
  [2447] = 2447,
  [2448] = 2448,
  [2449] = 2251,
  [2450] = 2450,
  [2451] = 2252,
  [2452] = 2311,
  [2453] = 2453,
  [2454] = 2454,
  [2455] = 2455,
  [2456] = 1322,
  [2457] = 2283,
  [2458] = 2353,
  [2459] = 2356,
  [2460] = 2235,
  [2461] = 2461,
  [2462] = 2462,
  [2463] = 2463,
  [2464] = 2464,
  [2465] = 199,
  [2466] = 2466,
  [2467] = 2294,
  [2468] = 2315,
  [2469] = 2469,
  [2470] = 2470,
  [2471] = 2471,
  [2472] = 2472,
  [2473] = 2473,
  [2474] = 2474,
  [2475] = 2475,
  [2476] = 2476,
  [2477] = 2477,
  [2478] = 2478,
  [2479] = 2479,
  [2480] = 2480,
  [2481] = 2481,
  [2482] = 2482,
  [2483] = 2284,
  [2484] = 2278,
  [2485] = 2485,
  [2486] = 2486,
  [2487] = 2299,
  [2488] = 2281,
  [2489] = 2489,
  [2490] = 1322,
  [2491] = 2491,
  [2492] = 2492,
  [2493] = 2493,
  [2494] = 2494,
  [2495] = 2495,
  [2496] = 2496,
  [2497] = 2497,
  [2498] = 2498,
  [2499] = 2499,
  [2500] = 2422,
  [2501] = 2501,
  [2502] = 2502,
  [2503] = 2503,
  [2504] = 2504,
  [2505] = 2505,
  [2506] = 2506,
  [2507] = 2507,
  [2508] = 2508,
  [2509] = 2509,
  [2510] = 2510,
  [2511] = 2511,
  [2512] = 2512,
  [2513] = 2513,
  [2514] = 2514,
  [2515] = 2515,
  [2516] = 2516,
  [2517] = 2517,
  [2518] = 2518,
  [2519] = 2519,
  [2520] = 2520,
  [2521] = 2315,
  [2522] = 2522,
  [2523] = 2523,
  [2524] = 2524,
  [2525] = 2525,
  [2526] = 2299,
  [2527] = 2527,
  [2528] = 2319,
  [2529] = 2529,
  [2530] = 2530,
  [2531] = 2507,
  [2532] = 2532,
  [2533] = 2533,
  [2534] = 2534,
  [2535] = 2535,
  [2536] = 2536,
  [2537] = 2303,
  [2538] = 2282,
  [2539] = 2539,
  [2540] = 2280,
  [2541] = 2541,
  [2542] = 2542,
  [2543] = 2543,
  [2544] = 2544,
  [2545] = 2545,
  [2546] = 2333,
  [2547] = 2299,
  [2548] = 2283,
  [2549] = 2281,
  [2550] = 2337,
  [2551] = 2278,
  [2552] = 1335,
  [2553] = 2553,
  [2554] = 2554,
  [2555] = 2555,
  [2556] = 2556,
  [2557] = 2557,
  [2558] = 2543,
  [2559] = 2559,
  [2560] = 2560,
  [2561] = 2544,
  [2562] = 2562,
  [2563] = 2281,
  [2564] = 2299,
  [2565] = 2499,
  [2566] = 2283,
  [2567] = 2567,
  [2568] = 2498,
  [2569] = 2315,
  [2570] = 2570,
  [2571] = 2571,
  [2572] = 2497,
  [2573] = 2517,
  [2574] = 2557,
  [2575] = 2496,
  [2576] = 2238,
  [2577] = 2329,
  [2578] = 2578,
  [2579] = 2571,
  [2580] = 2438,
  [2581] = 2581,
  [2582] = 2582,
  [2583] = 2284,
  [2584] = 2495,
  [2585] = 2283,
  [2586] = 2586,
  [2587] = 2587,
  [2588] = 2588,
  [2589] = 2400,
  [2590] = 2422,
  [2591] = 2311,
  [2592] = 2592,
  [2593] = 2398,
  [2594] = 2594,
  [2595] = 2595,
  [2596] = 2596,
  [2597] = 2309,
  [2598] = 2422,
  [2599] = 2307,
  [2600] = 2306,
  [2601] = 2305,
  [2602] = 2602,
  [2603] = 2181,
  [2604] = 2180,
  [2605] = 2605,
  [2606] = 2606,
  [2607] = 2607,
  [2608] = 2608,
  [2609] = 97,
  [2610] = 2602,
  [2611] = 2611,
  [2612] = 2178,
  [2613] = 2613,
  [2614] = 2614,
  [2615] = 2615,
  [2616] = 2616,
  [2617] = 2617,
  [2618] = 2618,
  [2619] = 2619,
  [2620] = 2620,
  [2621] = 2621,
  [2622] = 2422,
  [2623] = 2623,
  [2624] = 2301,
  [2625] = 2625,
  [2626] = 2626,
  [2627] = 2627,
  [2628] = 2294,
  [2629] = 2629,
  [2630] = 2493,
  [2631] = 2475,
  [2632] = 2617,
  [2633] = 2453,
  [2634] = 2285,
  [2635] = 2286,
  [2636] = 2636,
  [2637] = 2293,
  [2638] = 2539,
  [2639] = 2639,
  [2640] = 2295,
  [2641] = 2322,
  [2642] = 2620,
  [2643] = 2643,
  [2644] = 2536,
  [2645] = 2621,
  [2646] = 2432,
  [2647] = 2522,
  [2648] = 2429,
  [2649] = 2623,
  [2650] = 2650,
  [2651] = 2508,
  [2652] = 2297,
  [2653] = 2625,
  [2654] = 2527,
  [2655] = 2298,
  [2656] = 2502,
  [2657] = 2657,
  [2658] = 2331,
  [2659] = 2659,
  [2660] = 2660,
  [2661] = 2530,
  [2662] = 2316,
  [2663] = 2608,
  [2664] = 2605,
  [2665] = 2665,
  [2666] = 2666,
  [2667] = 2553,
  [2668] = 2559,
  [2669] = 2556,
  [2670] = 2433,
  [2671] = 2671,
  [2672] = 2327,
  [2673] = 2332,
  [2674] = 2529,
  [2675] = 2434,
  [2676] = 2334,
  [2677] = 2435,
  [2678] = 2352,
  [2679] = 2360,
  [2680] = 2336,
  [2681] = 2328,
  [2682] = 2335,
  [2683] = 2581,
  [2684] = 2657,
  [2685] = 2629,
  [2686] = 2627,
  [2687] = 2626,
  [2688] = 2436,
  [2689] = 2325,
  [2690] = 2534,
  [2691] = 2342,
  [2692] = 2692,
  [2693] = 2693,
  [2694] = 2341,
  [2695] = 2614,
  [2696] = 2696,
  [2697] = 2289,
  [2698] = 2639,
  [2699] = 2619,
  [2700] = 2291,
  [2701] = 2618,
  [2702] = 2343,
  [2703] = 2292,
  [2704] = 2344,
  [2705] = 2476,
  [2706] = 2439,
  [2707] = 2440,
  [2708] = 2441,
  [2709] = 2616,
  [2710] = 2596,
  [2711] = 2345,
  [2712] = 2615,
  [2713] = 2659,
  [2714] = 2348,
  [2715] = 2666,
  [2716] = 2443,
  [2717] = 2444,
  [2718] = 2425,
  [2719] = 2595,
  [2720] = 2720,
  [2721] = 2721,
  [2722] = 2613,
  [2723] = 2721,
  [2724] = 2611,
  [2725] = 2607,
  [2726] = 2446,
  [2727] = 2448,
  [2728] = 2450,
  [2729] = 2729,
  [2730] = 2391,
  [2731] = 2304,
  [2732] = 2606,
  [2733] = 2312,
  [2734] = 2734,
  [2735] = 2314,
  [2736] = 2588,
  [2737] = 2587,
  [2738] = 2454,
  [2739] = 2734,
  [2740] = 2455,
  [2741] = 2586,
  [2742] = 2567,
  [2743] = 2592,
  [2744] = 2346,
  [2745] = 2350,
  [2746] = 2560,
  [2747] = 2351,
  [2748] = 2355,
  [2749] = 2366,
  [2750] = 2367,
  [2751] = 2535,
  [2752] = 2555,
  [2753] = 2357,
  [2754] = 2461,
  [2755] = 2358,
  [2756] = 2756,
  [2757] = 2462,
  [2758] = 2414,
  [2759] = 2463,
  [2760] = 2359,
  [2761] = 2720,
  [2762] = 2396,
  [2763] = 2377,
  [2764] = 2413,
  [2765] = 2361,
  [2766] = 2464,
  [2767] = 2466,
  [2768] = 2287,
  [2769] = 2471,
  [2770] = 2472,
  [2771] = 2771,
  [2772] = 2411,
  [2773] = 2545,
  [2774] = 2729,
  [2775] = 2696,
  [2776] = 2542,
  [2777] = 2364,
  [2778] = 2660,
  [2779] = 2384,
  [2780] = 2394,
  [2781] = 2399,
  [2782] = 2368,
  [2783] = 2520,
  [2784] = 2408,
  [2785] = 2407,
  [2786] = 2473,
  [2787] = 2369,
  [2788] = 2412,
  [2789] = 2370,
  [2790] = 2524,
  [2791] = 2404,
  [2792] = 2523,
  [2793] = 2643,
  [2794] = 2393,
  [2795] = 2403,
  [2796] = 2365,
  [2797] = 2474,
  [2798] = 2402,
  [2799] = 2421,
  [2800] = 2659,
  [2801] = 2423,
  [2802] = 2802,
  [2803] = 2447,
  [2804] = 2519,
  [2805] = 2582,
  [2806] = 2349,
  [2807] = 2516,
  [2808] = 2515,
  [2809] = 2397,
  [2810] = 2692,
  [2811] = 2513,
  [2812] = 2388,
  [2813] = 1338,
  [2814] = 2512,
  [2815] = 2510,
  [2816] = 2506,
  [2817] = 2505,
  [2818] = 2514,
  [2819] = 2376,
  [2820] = 2562,
  [2821] = 2503,
  [2822] = 2509,
  [2823] = 2323,
  [2824] = 2501,
  [2825] = 2494,
  [2826] = 2410,
  [2827] = 2492,
  [2828] = 2828,
  [2829] = 2504,
  [2830] = 2491,
  [2831] = 2378,
  [2832] = 2277,
  [2833] = 2420,
  [2834] = 2469,
  [2835] = 2756,
  [2836] = 2578,
  [2837] = 2541,
  [2838] = 2387,
  [2839] = 2382,
  [2840] = 2317,
  [2841] = 2477,
  [2842] = 2386,
  [2843] = 2381,
  [2844] = 2570,
  [2845] = 2373,
  [2846] = 2485,
  [2847] = 2659,
  [2848] = 2478,
  [2849] = 2385,
  [2850] = 2276,
  [2851] = 2379,
  [2852] = 2383,
  [2853] = 2330,
  [2854] = 2479,
  [2855] = 2380,
  [2856] = 2480,
  [2857] = 2481,
  [2858] = 2482,
  [2859] = 2859,
  [2860] = 2860,
  [2861] = 2861,
  [2862] = 2862,
  [2863] = 2863,
  [2864] = 2864,
  [2865] = 2865,
  [2866] = 2866,
  [2867] = 2867,
  [2868] = 2868,
  [2869] = 2869,
  [2870] = 2859,
  [2871] = 2871,
  [2872] = 2872,
  [2873] = 2873,
  [2874] = 2874,
  [2875] = 2875,
  [2876] = 2876,
  [2877] = 2877,
  [2878] = 2878,
  [2879] = 2879,
  [2880] = 2880,
  [2881] = 2881,
  [2882] = 2882,
  [2883] = 2882,
  [2884] = 2869,
  [2885] = 2885,
  [2886] = 2886,
  [2887] = 2887,
  [2888] = 2888,
  [2889] = 2889,
  [2890] = 2890,
  [2891] = 2891,
  [2892] = 2892,
  [2893] = 2893,
  [2894] = 2894,
  [2895] = 2895,
  [2896] = 2896,
  [2897] = 2897,
  [2898] = 2898,
  [2899] = 2899,
  [2900] = 2862,
  [2901] = 2859,
  [2902] = 2892,
  [2903] = 2903,
  [2904] = 2904,
  [2905] = 2890,
  [2906] = 2906,
  [2907] = 119,
  [2908] = 2908,
  [2909] = 2886,
  [2910] = 2910,
  [2911] = 2885,
  [2912] = 2912,
  [2913] = 2859,
  [2914] = 2871,
  [2915] = 2872,
  [2916] = 2869,
  [2917] = 2882,
  [2918] = 2918,
  [2919] = 2919,
  [2920] = 2920,
  [2921] = 2921,
  [2922] = 2893,
  [2923] = 2923,
  [2924] = 2924,
  [2925] = 2925,
  [2926] = 2926,
  [2927] = 2878,
  [2928] = 2928,
  [2929] = 2880,
  [2930] = 2930,
  [2931] = 2931,
  [2932] = 2880,
  [2933] = 2933,
  [2934] = 2934,
  [2935] = 2878,
  [2936] = 2882,
  [2937] = 2869,
  [2938] = 2885,
  [2939] = 2877,
  [2940] = 2940,
  [2941] = 2877,
  [2942] = 2942,
  [2943] = 2943,
  [2944] = 2862,
  [2945] = 2945,
  [2946] = 2946,
  [2947] = 2859,
  [2948] = 2871,
  [2949] = 2872,
  [2950] = 2878,
  [2951] = 2880,
  [2952] = 2952,
  [2953] = 2882,
  [2954] = 2869,
  [2955] = 2885,
  [2956] = 2956,
  [2957] = 2957,
  [2958] = 2873,
  [2959] = 2872,
  [2960] = 2862,
  [2961] = 2871,
  [2962] = 2871,
  [2963] = 2872,
  [2964] = 2878,
  [2965] = 2880,
  [2966] = 2894,
  [2967] = 2882,
  [2968] = 2869,
  [2969] = 2885,
  [2970] = 2970,
  [2971] = 2971,
  [2972] = 2894,
  [2973] = 2973,
  [2974] = 2862,
  [2975] = 2975,
  [2976] = 2871,
  [2977] = 2977,
  [2978] = 2869,
  [2979] = 2885,
  [2980] = 2980,
  [2981] = 2878,
  [2982] = 2862,
  [2983] = 2862,
  [2984] = 2860,
  [2985] = 2871,
  [2986] = 2869,
  [2987] = 2885,
  [2988] = 2988,
  [2989] = 2898,
  [2990] = 2893,
  [2991] = 2862,
  [2992] = 2890,
  [2993] = 2869,
  [2994] = 2885,
  [2995] = 2892,
  [2996] = 2890,
  [2997] = 2997,
  [2998] = 2862,
  [2999] = 2999,
  [3000] = 2869,
  [3001] = 2885,
  [3002] = 3002,
  [3003] = 3003,
  [3004] = 2886,
  [3005] = 2862,
  [3006] = 3006,
  [3007] = 2885,
  [3008] = 3008,
  [3009] = 2898,
  [3010] = 2885,
  [3011] = 2862,
  [3012] = 3012,
  [3013] = 2885,
  [3014] = 3014,
  [3015] = 3015,
  [3016] = 3016,
  [3017] = 2862,
  [3018] = 2869,
  [3019] = 2882,
  [3020] = 2892,
  [3021] = 2890,
  [3022] = 3022,
  [3023] = 3023,
  [3024] = 3012,
  [3025] = 3025,
  [3026] = 3026,
  [3027] = 3027,
  [3028] = 3028,
  [3029] = 2925,
  [3030] = 2882,
  [3031] = 2869,
  [3032] = 2880,
  [3033] = 2886,
  [3034] = 3034,
  [3035] = 2885,
  [3036] = 3036,
  [3037] = 3037,
  [3038] = 2898,
  [3039] = 2945,
  [3040] = 2928,
  [3041] = 3041,
  [3042] = 3042,
  [3043] = 3043,
  [3044] = 3022,
  [3045] = 3045,
  [3046] = 3046,
  [3047] = 2886,
  [3048] = 3048,
  [3049] = 3049,
  [3050] = 3050,
  [3051] = 3051,
  [3052] = 2895,
  [3053] = 2864,
  [3054] = 2865,
  [3055] = 2866,
  [3056] = 2867,
  [3057] = 2868,
  [3058] = 2874,
  [3059] = 2875,
  [3060] = 2880,
  [3061] = 2899,
  [3062] = 2903,
  [3063] = 3063,
  [3064] = 3064,
  [3065] = 2970,
  [3066] = 2973,
  [3067] = 2977,
  [3068] = 2988,
  [3069] = 3014,
  [3070] = 3016,
  [3071] = 3036,
  [3072] = 3050,
  [3073] = 3041,
  [3074] = 2879,
  [3075] = 3075,
  [3076] = 3076,
  [3077] = 2943,
  [3078] = 2971,
  [3079] = 3079,
  [3080] = 3080,
  [3081] = 3081,
  [3082] = 3082,
  [3083] = 2957,
  [3084] = 3084,
  [3085] = 3051,
  [3086] = 3048,
  [3087] = 3028,
  [3088] = 3027,
  [3089] = 3026,
  [3090] = 3025,
  [3091] = 2888,
  [3092] = 3023,
  [3093] = 2892,
  [3094] = 2910,
  [3095] = 3064,
  [3096] = 3096,
  [3097] = 2940,
  [3098] = 2952,
  [3099] = 2997,
  [3100] = 3076,
  [3101] = 3101,
  [3102] = 3102,
  [3103] = 3103,
  [3104] = 2872,
  [3105] = 119,
  [3106] = 3084,
  [3107] = 3107,
  [3108] = 2934,
  [3109] = 2862,
  [3110] = 3110,
  [3111] = 3103,
  [3112] = 3034,
  [3113] = 2878,
  [3114] = 3014,
  [3115] = 3016,
  [3116] = 3036,
  [3117] = 3117,
  [3118] = 3075,
  [3119] = 3119,
  [3120] = 3079,
  [3121] = 3081,
  [3122] = 3082,
  [3123] = 2952,
  [3124] = 2877,
  [3125] = 3125,
  [3126] = 3126,
  [3127] = 3127,
  [3128] = 3128,
  [3129] = 3129,
  [3130] = 3049,
  [3131] = 3037,
  [3132] = 3045,
  [3133] = 3014,
  [3134] = 3016,
  [3135] = 3036,
  [3136] = 3136,
  [3137] = 3075,
  [3138] = 2906,
  [3139] = 3079,
  [3140] = 2897,
  [3141] = 2952,
  [3142] = 3142,
  [3143] = 3143,
  [3144] = 2975,
  [3145] = 2861,
  [3146] = 2894,
  [3147] = 3147,
  [3148] = 2931,
  [3149] = 3149,
  [3150] = 3014,
  [3151] = 3016,
  [3152] = 3036,
  [3153] = 3153,
  [3154] = 3075,
  [3155] = 3079,
  [3156] = 2934,
  [3157] = 3157,
  [3158] = 2859,
  [3159] = 3159,
  [3160] = 3081,
  [3161] = 3079,
  [3162] = 2885,
  [3163] = 3163,
  [3164] = 2893,
  [3165] = 3079,
  [3166] = 2908,
  [3167] = 2923,
  [3168] = 2930,
  [3169] = 3008,
  [3170] = 2980,
  [3171] = 3171,
  [3172] = 3006,
  [3173] = 3173,
  [3174] = 2920,
  [3175] = 3175,
  [3176] = 3046,
  [3177] = 3117,
  [3178] = 3075,
  [3179] = 2956,
  [3180] = 3126,
  [3181] = 3128,
  [3182] = 3129,
  [3183] = 3142,
  [3184] = 3143,
  [3185] = 3102,
  [3186] = 3002,
  [3187] = 3175,
  [3188] = 3157,
  [3189] = 2942,
  [3190] = 3190,
  [3191] = 3171,
  [3192] = 3190,
  [3193] = 2999,
  [3194] = 2873,
  [3195] = 2873,
  [3196] = 3196,
  [3197] = 2871,
  [3198] = 3079,
  [3199] = 2872,
  [3200] = 2926,
  [3201] = 2863,
  [3202] = 3202,
  [3203] = 3203,
  [3204] = 3063,
  [3205] = 2891,
  [3206] = 3153,
  [3207] = 3173,
  [3208] = 2871,
  [3209] = 3163,
  [3210] = 2918,
  [3211] = 3202,
  [3212] = 3147,
  [3213] = 2862,
  [3214] = 2876,
  [3215] = 3042,
  [3216] = 2898,
  [3217] = 3080,
  [3218] = 3203,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(814);
      ADVANCE_MAP(
        '\n', 914,
        '!', 2166,
        '#', 2418,
        '$', 2227,
        '%', 2971,
        '&', 2169,
        '\'', 3256,
        '(', 2463,
        ')', 2195,
        '*', 2415,
        '+', 2220,
        ',', 2968,
        '-', 2422,
        '.', 828,
        '/', 2215,
        ':', 2175,
        ';', 2212,
        '<', 2333,
        '=', 2174,
        '>', 2338,
        '?', 2216,
        '@', 2196,
        '[', 2461,
        '\\', 2346,
        ']', 2462,
        '_', 977,
        '{', 996,
        '|', 933,
        '}', 995,
        '~', 933,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(811);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(933);
      if (('2' <= lookahead && lookahead <= '9')) ADVANCE(933);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(977);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(933);
      END_STATE();
    case 1:
      if (lookahead == '\t') SKIP(1);
      if (lookahead == ' ') ADVANCE(2186);
      END_STATE();
    case 2:
      if (lookahead == '\t') SKIP(1);
      if (lookahead == ' ') ADVANCE(2186);
      if (lookahead == '\\') ADVANCE(2185);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n') ADVANCE(2184);
      END_STATE();
    case 3:
      if (lookahead == '\t') SKIP(1);
      if (lookahead == ' ') ADVANCE(2186);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(939);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(954);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(942);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(937);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(971);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(974);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(964);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(967);
      if (lookahead == 'K' ||
          lookahead == 'k') ADVANCE(959);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(961);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(934);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(969);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(953);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(965);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(944);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(952);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(973);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(958);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(933);
      END_STATE();
    case 4:
      if (lookahead == '\t') ADVANCE(2531);
      if (lookahead == ' ') SKIP(95);
      if (lookahead == '#') ADVANCE(2418);
      if (lookahead == '*') ADVANCE(2531);
      if (lookahead == '+') ADVANCE(2220);
      if (lookahead == '/') ADVANCE(2213);
      if (lookahead == '<') ADVANCE(2532);
      if (lookahead == '\\') ADVANCE(2346);
      if (lookahead == '!' ||
          lookahead == ':' ||
          lookahead == '@' ||
          ('[' <= lookahead && lookahead <= ']') ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(2531);
      if (lookahead == '$' ||
          lookahead == '%' ||
          (',' <= lookahead && lookahead <= '.') ||
          lookahead == '=' ||
          lookahead == '_' ||
          lookahead == '~') ADVANCE(2531);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(992);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2531);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n') ADVANCE(2531);
      END_STATE();
    case 5:
      if (lookahead == '\t') ADVANCE(2531);
      if (lookahead == ' ') SKIP(96);
      if (lookahead == '#') ADVANCE(2418);
      if (lookahead == '*') ADVANCE(2531);
      if (lookahead == '+') ADVANCE(2220);
      if (lookahead == '/') ADVANCE(2213);
      if (lookahead == '\\') ADVANCE(2345);
      if (lookahead == '!' ||
          lookahead == ':' ||
          lookahead == '@' ||
          ('[' <= lookahead && lookahead <= ']') ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(2531);
      if (lookahead == '$' ||
          lookahead == '%' ||
          (',' <= lookahead && lookahead <= '.') ||
          lookahead == '=' ||
          lookahead == '_' ||
          lookahead == '~') ADVANCE(2531);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(992);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2531);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n') ADVANCE(2531);
      END_STATE();
    case 6:
      if (lookahead == '\t') ADVANCE(2531);
      if (lookahead == ' ') SKIP(122);
      if (lookahead == '*') ADVANCE(2531);
      if (lookahead == '+') ADVANCE(2220);
      if (lookahead == '/') ADVANCE(2213);
      if (lookahead == '<') ADVANCE(2532);
      if (lookahead == '\\') ADVANCE(2346);
      if (lookahead == '!' ||
          lookahead == ':' ||
          lookahead == '@' ||
          ('[' <= lookahead && lookahead <= ']') ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(2531);
      if (('#' <= lookahead && lookahead <= '%') ||
          (',' <= lookahead && lookahead <= '.') ||
          lookahead == '=' ||
          lookahead == '_' ||
          lookahead == '~') ADVANCE(2531);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(992);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2531);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n') ADVANCE(2531);
      END_STATE();
    case 7:
      if (lookahead == '\t') ADVANCE(2531);
      if (lookahead == ' ') SKIP(123);
      if (lookahead == '*') ADVANCE(2531);
      if (lookahead == '+') ADVANCE(2220);
      if (lookahead == '/') ADVANCE(2213);
      if (lookahead == '\\') ADVANCE(2345);
      if (lookahead == '!' ||
          lookahead == ':' ||
          lookahead == '@' ||
          ('[' <= lookahead && lookahead <= ']') ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(2531);
      if (('#' <= lookahead && lookahead <= '%') ||
          (',' <= lookahead && lookahead <= '.') ||
          lookahead == '=' ||
          lookahead == '_' ||
          lookahead == '~') ADVANCE(2531);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(992);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2531);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n') ADVANCE(2531);
      END_STATE();
    case 8:
      if (lookahead == '\t') ADVANCE(2531);
      if (lookahead == ' ') SKIP(97);
      if (lookahead == '#') ADVANCE(2418);
      if (lookahead == '*') ADVANCE(2531);
      if (lookahead == '+') ADVANCE(2220);
      if (lookahead == '<') ADVANCE(2532);
      if (lookahead == '\\') ADVANCE(2346);
      if (lookahead == '!' ||
          lookahead == ':' ||
          lookahead == '@' ||
          ('[' <= lookahead && lookahead <= ']') ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(2531);
      if (lookahead == '$' ||
          lookahead == '%' ||
          (',' <= lookahead && lookahead <= '/') ||
          lookahead == '=' ||
          lookahead == '_' ||
          lookahead == '~') ADVANCE(2531);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2531);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n') ADVANCE(2531);
      END_STATE();
    case 9:
      if (lookahead == '\t') ADVANCE(2531);
      if (lookahead == ' ') SKIP(98);
      if (lookahead == '#') ADVANCE(2418);
      if (lookahead == '*') ADVANCE(2531);
      if (lookahead == '+') ADVANCE(2220);
      if (lookahead == '\\') ADVANCE(2345);
      if (lookahead == '!' ||
          lookahead == ':' ||
          lookahead == '@' ||
          ('[' <= lookahead && lookahead <= ']') ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(2531);
      if (lookahead == '$' ||
          lookahead == '%' ||
          (',' <= lookahead && lookahead <= '/') ||
          lookahead == '=' ||
          lookahead == '_' ||
          lookahead == '~') ADVANCE(2531);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2531);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n') ADVANCE(2531);
      END_STATE();
    case 10:
      if (lookahead == '\t') ADVANCE(2531);
      if (lookahead == ' ') SKIP(124);
      if (lookahead == '*') ADVANCE(2531);
      if (lookahead == '+') ADVANCE(2220);
      if (lookahead == '<') ADVANCE(2532);
      if (lookahead == '\\') ADVANCE(2346);
      if (lookahead == '!' ||
          lookahead == ':' ||
          lookahead == '@' ||
          ('[' <= lookahead && lookahead <= ']') ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(2531);
      if (('#' <= lookahead && lookahead <= '%') ||
          (',' <= lookahead && lookahead <= '/') ||
          lookahead == '=' ||
          lookahead == '_' ||
          lookahead == '~') ADVANCE(2531);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2531);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n') ADVANCE(2531);
      END_STATE();
    case 11:
      if (lookahead == '\t') ADVANCE(2531);
      if (lookahead == ' ') SKIP(125);
      if (lookahead == '*') ADVANCE(2531);
      if (lookahead == '+') ADVANCE(2220);
      if (lookahead == '\\') ADVANCE(2345);
      if (lookahead == '!' ||
          lookahead == ':' ||
          lookahead == '@' ||
          ('[' <= lookahead && lookahead <= ']') ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(2531);
      if (('#' <= lookahead && lookahead <= '%') ||
          (',' <= lookahead && lookahead <= '/') ||
          lookahead == '=' ||
          lookahead == '_' ||
          lookahead == '~') ADVANCE(2531);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2531);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n') ADVANCE(2531);
      END_STATE();
    case 12:
      if (lookahead == '\t') SKIP(13);
      if (lookahead == ' ') ADVANCE(2186);
      if (lookahead == '!') ADVANCE(2166);
      if (lookahead == '&') ADVANCE(2169);
      if (lookahead == '+') ADVANCE(238);
      if (lookahead == '-') ADVANCE(239);
      if (lookahead == ':') ADVANCE(2175);
      if (lookahead == '<') ADVANCE(679);
      if (lookahead == '=') ADVANCE(2174);
      if (lookahead == '?') ADVANCE(2173);
      if (lookahead == '\\') ADVANCE(657);
      if (lookahead == '^') ADVANCE(240);
      if (lookahead == '{') ADVANCE(996);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1986);
      END_STATE();
    case 13:
      if (lookahead == '\t') SKIP(13);
      if (lookahead == ' ') ADVANCE(2186);
      if (lookahead == '&') ADVANCE(2169);
      if (lookahead == '<') ADVANCE(679);
      if (lookahead == '?') ADVANCE(2173);
      if (lookahead == '\\') ADVANCE(657);
      END_STATE();
    case 14:
      if (lookahead == '\t') SKIP(14);
      if (lookahead == ' ') ADVANCE(2199);
      if (lookahead == '<') ADVANCE(2208);
      if (lookahead == '\\') ADVANCE(2207);
      if (lookahead == 'c') ADVANCE(2206);
      if (lookahead == 'i') ADVANCE(2202);
      if (lookahead == 'l') ADVANCE(2204);
      if (lookahead == 'n') ADVANCE(2205);
      if (lookahead == 't') ADVANCE(2203);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(2198);
      END_STATE();
    case 15:
      if (lookahead == '\t') SKIP(16);
      if (lookahead == ' ') ADVANCE(2186);
      if (lookahead == '+') ADVANCE(238);
      if (lookahead == '-') ADVANCE(239);
      if (lookahead == ':') ADVANCE(2175);
      if (lookahead == '<') ADVANCE(679);
      if (lookahead == '=') ADVANCE(2174);
      if (lookahead == '\\') ADVANCE(657);
      if (lookahead == '^') ADVANCE(240);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 16:
      if (lookahead == '\t') SKIP(16);
      if (lookahead == ' ') ADVANCE(2186);
      if (lookahead == '<') ADVANCE(679);
      if (lookahead == '\\') ADVANCE(657);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 17:
      if (lookahead == '\t') SKIP(17);
      if (lookahead == ' ') ADVANCE(2200);
      if (lookahead == 'c') ADVANCE(2206);
      if (lookahead == 'i') ADVANCE(2202);
      if (lookahead == 'l') ADVANCE(2204);
      if (lookahead == 'n') ADVANCE(2205);
      if (lookahead == 't') ADVANCE(2203);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(2198);
      END_STATE();
    case 18:
      if (lookahead == '\t') SKIP(18);
      if (lookahead == ' ') ADVANCE(2186);
      if (lookahead == '<') ADVANCE(679);
      if (lookahead == '\\') ADVANCE(657);
      END_STATE();
    case 19:
      if (lookahead == '\t') SKIP(18);
      if (lookahead == ' ') ADVANCE(2186);
      if (lookahead == '<') ADVANCE(2182);
      if (lookahead == '\\') ADVANCE(2180);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n') ADVANCE(2184);
      END_STATE();
    case 20:
      if (lookahead == '\t') ADVANCE(3278);
      if (lookahead == ' ') SKIP(20);
      if (lookahead == '<') ADVANCE(3288);
      if (lookahead == '\\') ADVANCE(3286);
      if (lookahead == 'c') ADVANCE(3284);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n') ADVANCE(3291);
      END_STATE();
    case 21:
      if (lookahead == '\t') ADVANCE(3279);
      if (lookahead == ' ') SKIP(21);
      if (lookahead == 'c') ADVANCE(3284);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n') ADVANCE(3291);
      END_STATE();
    case 22:
      if (lookahead == '\t') SKIP(22);
      if (lookahead == ' ') ADVANCE(2201);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(2198);
      END_STATE();
    case 23:
      if (lookahead == '\t') SKIP(23);
      if (lookahead == ' ') ADVANCE(817);
      END_STATE();
    case 24:
      if (lookahead == '\t') SKIP(23);
      if (lookahead == ' ') ADVANCE(817);
      if (lookahead == '!') ADVANCE(2166);
      if (lookahead == '\'') ADVANCE(3256);
      if (lookahead == 'N') ADVANCE(3272);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3273);
      END_STATE();
    case 25:
      if (lookahead == '\t') SKIP(23);
      if (lookahead == ' ') ADVANCE(817);
      if (lookahead == '*') ADVANCE(2494);
      if (lookahead == '\\') ADVANCE(2493);
      if (lookahead == '!' ||
          lookahead == ':' ||
          lookahead == '@' ||
          ('[' <= lookahead && lookahead <= ']') ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(2491);
      if (('#' <= lookahead && lookahead <= '%') ||
          ('+' <= lookahead && lookahead <= '/') ||
          lookahead == '=' ||
          lookahead == '_' ||
          lookahead == '~') ADVANCE(2490);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2478);
      END_STATE();
    case 26:
      if (lookahead == '\n') ADVANCE(912);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(26);
      if (lookahead != 0) ADVANCE(27);
      END_STATE();
    case 27:
      if (lookahead == '\n') ADVANCE(912);
      if (lookahead != 0) ADVANCE(27);
      END_STATE();
    case 28:
      if (lookahead == '!') ADVANCE(2166);
      if (lookahead == '#') ADVANCE(2418);
      if (lookahead == '*') ADVANCE(2477);
      if (lookahead == '+') ADVANCE(2222);
      if (lookahead == '<') ADVANCE(679);
      if (lookahead == '\\') ADVANCE(928);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(99);
      if (lookahead == ':' ||
          lookahead == '@' ||
          ('[' <= lookahead && lookahead <= ']') ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(2476);
      if (lookahead == '$' ||
          lookahead == '%' ||
          (',' <= lookahead && lookahead <= '/') ||
          lookahead == '=' ||
          lookahead == '_' ||
          lookahead == '~') ADVANCE(2475);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2465);
      END_STATE();
    case 29:
      if (lookahead == '!') ADVANCE(2166);
      if (lookahead == '#') ADVANCE(2418);
      if (lookahead == '*') ADVANCE(2477);
      if (lookahead == '+') ADVANCE(2222);
      if (lookahead == '\\') ADVANCE(922);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(100);
      if (lookahead == ':' ||
          lookahead == '@' ||
          ('[' <= lookahead && lookahead <= ']') ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(2476);
      if (lookahead == '$' ||
          lookahead == '%' ||
          (',' <= lookahead && lookahead <= '/') ||
          lookahead == '=' ||
          lookahead == '_' ||
          lookahead == '~') ADVANCE(2475);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2465);
      END_STATE();
    case 30:
      ADVANCE_MAP(
        '!', 2166,
        '#', 654,
        '$', 2227,
        '&', 2169,
        '(', 2193,
        '+', 2225,
        '-', 2424,
        '/', 156,
        '0', 2453,
        '?', 251,
        '@', 807,
        '[', 2461,
        'a', 1000,
        '{', 993,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(61);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(2455);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 31:
      ADVANCE_MAP(
        '!', 2166,
        '%', 2971,
        '\'', 3258,
        ',', 2194,
        '.', 828,
        '/', 2215,
        ':', 815,
        ';', 2212,
        '<', 679,
        '?', 2216,
        '\\', 108,
        'e', 2135,
        'u', 2006,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(110);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(992);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 32:
      ADVANCE_MAP(
        '!', 2166,
        ')', 2195,
        ',', 2194,
        '.', 155,
        '0', 2456,
        '<', 679,
        '\\', 657,
        '{', 993,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(115);
      if (('+' <= lookahead && lookahead <= '-')) ADVANCE(158);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(2459);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 33:
      ADVANCE_MAP(
        '!', 2166,
        '*', 2416,
        ',', 2194,
        '/', 2215,
        ':', 815,
        ';', 2212,
        '<', 2521,
        '[', 2461,
        '\\', 925,
        '\t', 2501,
        ' ', 2501,
      );
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n') ADVANCE(2500);
      END_STATE();
    case 34:
      ADVANCE_MAP(
        '!', 2166,
        '*', 2416,
        ',', 2194,
        '/', 2215,
        ':', 815,
        ';', 2212,
        '<', 2520,
        '[', 2461,
        '\\', 925,
        '\t', 2502,
        ' ', 2502,
      );
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n') ADVANCE(2500);
      END_STATE();
    case 35:
      ADVANCE_MAP(
        '!', 2166,
        '*', 2416,
        ',', 2194,
        ':', 815,
        ';', 2212,
        '<', 2521,
        '?', 2216,
        '[', 2461,
        '\\', 925,
        '\t', 2501,
        ' ', 2501,
      );
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n') ADVANCE(2500);
      END_STATE();
    case 36:
      ADVANCE_MAP(
        '!', 2166,
        '*', 2416,
        ',', 2194,
        ':', 815,
        ';', 2212,
        '<', 2520,
        '?', 2216,
        '[', 2461,
        '\\', 925,
        '\t', 2502,
        ' ', 2502,
      );
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n') ADVANCE(2500);
      END_STATE();
    case 37:
      ADVANCE_MAP(
        '!', 2166,
        '*', 2416,
        '/', 2215,
        ':', 815,
        '<', 2521,
        '[', 2461,
        '\\', 925,
        '\t', 2503,
        ' ', 2503,
      );
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n') ADVANCE(2500);
      END_STATE();
    case 38:
      ADVANCE_MAP(
        '!', 2166,
        '*', 2416,
        '/', 2215,
        ':', 815,
        '<', 2520,
        '[', 2461,
        '\\', 925,
        '\t', 2504,
        ' ', 2504,
      );
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n') ADVANCE(2500);
      END_STATE();
    case 39:
      ADVANCE_MAP(
        '!', 2166,
        '*', 2416,
        ':', 815,
        '<', 2521,
        '?', 2216,
        '[', 2461,
        '\\', 925,
        '\t', 2503,
        ' ', 2503,
      );
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n') ADVANCE(2500);
      END_STATE();
    case 40:
      ADVANCE_MAP(
        '!', 2166,
        '*', 2416,
        ':', 815,
        '<', 2520,
        '?', 2216,
        '[', 2461,
        '\\', 925,
        '\t', 2504,
        ' ', 2504,
      );
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n') ADVANCE(2500);
      END_STATE();
    case 41:
      if (lookahead == '!') ADVANCE(2166);
      if (lookahead == '*') ADVANCE(2477);
      if (lookahead == '+') ADVANCE(2222);
      if (lookahead == '<') ADVANCE(679);
      if (lookahead == '\\') ADVANCE(928);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(126);
      if (lookahead == ':' ||
          lookahead == '@' ||
          ('[' <= lookahead && lookahead <= ']') ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(2476);
      if (('#' <= lookahead && lookahead <= '%') ||
          (',' <= lookahead && lookahead <= '/') ||
          lookahead == '=' ||
          lookahead == '_' ||
          lookahead == '~') ADVANCE(2475);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2465);
      END_STATE();
    case 42:
      if (lookahead == '!') ADVANCE(2166);
      if (lookahead == '*') ADVANCE(2477);
      if (lookahead == '+') ADVANCE(2222);
      if (lookahead == '\\') ADVANCE(922);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(127);
      if (lookahead == ':' ||
          lookahead == '@' ||
          ('[' <= lookahead && lookahead <= ']') ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(2476);
      if (('#' <= lookahead && lookahead <= '%') ||
          (',' <= lookahead && lookahead <= '/') ||
          lookahead == '=' ||
          lookahead == '_' ||
          lookahead == '~') ADVANCE(2475);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2465);
      END_STATE();
    case 43:
      if (lookahead == '!') ADVANCE(2166);
      if (lookahead == '*') ADVANCE(2477);
      if (lookahead == '<') ADVANCE(679);
      if (lookahead == '\\') ADVANCE(928);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(129);
      if (lookahead == ':' ||
          lookahead == '@' ||
          ('[' <= lookahead && lookahead <= ']') ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(2476);
      if (('#' <= lookahead && lookahead <= '%') ||
          ('+' <= lookahead && lookahead <= '/') ||
          lookahead == '=' ||
          lookahead == '_' ||
          lookahead == '~') ADVANCE(2475);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2465);
      END_STATE();
    case 44:
      if (lookahead == '!') ADVANCE(2166);
      if (lookahead == '*') ADVANCE(2477);
      if (lookahead == 'A') ADVANCE(2467);
      if (lookahead == 'O') ADVANCE(2468);
      if (lookahead == 'P') ADVANCE(2466);
      if (lookahead == 'S') ADVANCE(2469);
      if (lookahead == '\\') ADVANCE(922);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(131);
      if (lookahead == ':' ||
          lookahead == '@' ||
          ('[' <= lookahead && lookahead <= ']') ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(2476);
      if (('#' <= lookahead && lookahead <= '%') ||
          ('+' <= lookahead && lookahead <= '/') ||
          lookahead == '=' ||
          lookahead == '_' ||
          lookahead == '~') ADVANCE(2475);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2465);
      END_STATE();
    case 45:
      if (lookahead == '!') ADVANCE(2166);
      if (lookahead == '*') ADVANCE(2477);
      if (lookahead == '\\') ADVANCE(922);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(133);
      if (lookahead == ':' ||
          lookahead == '@' ||
          ('[' <= lookahead && lookahead <= ']') ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(2476);
      if (('#' <= lookahead && lookahead <= '%') ||
          ('+' <= lookahead && lookahead <= '/') ||
          lookahead == '=' ||
          lookahead == '_' ||
          lookahead == '~') ADVANCE(2475);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2465);
      END_STATE();
    case 46:
      if (lookahead == '!') ADVANCE(2166);
      if (lookahead == '*') ADVANCE(2494);
      if (lookahead == '<') ADVANCE(920);
      if (lookahead == '\\') ADVANCE(929);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(230);
      if (lookahead == ':' ||
          lookahead == '@' ||
          ('[' <= lookahead && lookahead <= ']') ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(2491);
      if (('#' <= lookahead && lookahead <= '%') ||
          ('+' <= lookahead && lookahead <= '/') ||
          lookahead == '=' ||
          lookahead == '_' ||
          lookahead == '~') ADVANCE(2490);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2478);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(919);
      END_STATE();
    case 47:
      if (lookahead == '!') ADVANCE(2166);
      if (lookahead == '*') ADVANCE(2494);
      if (lookahead == '\\') ADVANCE(930);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(272);
      if (lookahead == ':' ||
          lookahead == '@' ||
          ('[' <= lookahead && lookahead <= ']') ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(2491);
      if (('#' <= lookahead && lookahead <= '%') ||
          ('+' <= lookahead && lookahead <= '/') ||
          lookahead == '=' ||
          lookahead == '_' ||
          lookahead == '~') ADVANCE(2490);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2478);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(919);
      END_STATE();
    case 48:
      ADVANCE_MAP(
        '!', 2166,
        ',', 2194,
        '/', 2215,
        ':', 815,
        ';', 2212,
        '<', 2522,
        '[', 2461,
        '\\', 926,
        '\t', 2509,
        ' ', 2509,
      );
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n') ADVANCE(2500);
      END_STATE();
    case 49:
      ADVANCE_MAP(
        '!', 2166,
        ',', 2194,
        '/', 2215,
        ':', 815,
        ';', 2212,
        '[', 2461,
        '\\', 926,
        '\t', 2510,
        ' ', 2510,
      );
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n') ADVANCE(2500);
      END_STATE();
    case 50:
      ADVANCE_MAP(
        '!', 2166,
        ',', 2194,
        ':', 815,
        ';', 2212,
        '<', 2522,
        '?', 2216,
        '[', 2461,
        '\\', 926,
        '\t', 2509,
        ' ', 2509,
      );
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n') ADVANCE(2500);
      END_STATE();
    case 51:
      ADVANCE_MAP(
        '!', 2166,
        ',', 2194,
        ':', 815,
        ';', 2212,
        '?', 2216,
        '[', 2461,
        '\\', 926,
        '\t', 2510,
        ' ', 2510,
      );
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n') ADVANCE(2500);
      END_STATE();
    case 52:
      ADVANCE_MAP(
        '!', 2166,
        '/', 2215,
        ':', 815,
        '<', 2522,
        '[', 2461,
        '\\', 926,
        '\t', 2511,
        ' ', 2511,
      );
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n') ADVANCE(2500);
      END_STATE();
    case 53:
      if (lookahead == '!') ADVANCE(2166);
      if (lookahead == '/') ADVANCE(2215);
      if (lookahead == ':') ADVANCE(815);
      if (lookahead == '[') ADVANCE(2461);
      if (lookahead == '\\') ADVANCE(926);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(2512);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n') ADVANCE(2500);
      END_STATE();
    case 54:
      ADVANCE_MAP(
        '!', 2166,
        ':', 815,
        '<', 2522,
        '?', 2216,
        '[', 2461,
        '\\', 926,
        '\t', 2511,
        ' ', 2511,
      );
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n') ADVANCE(2500);
      END_STATE();
    case 55:
      if (lookahead == '!') ADVANCE(2166);
      if (lookahead == ':') ADVANCE(815);
      if (lookahead == '?') ADVANCE(2216);
      if (lookahead == '[') ADVANCE(2461);
      if (lookahead == '\\') ADVANCE(926);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(2512);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n') ADVANCE(2500);
      END_STATE();
    case 56:
      if (lookahead == '!') ADVANCE(2166);
      if (lookahead == '<') ADVANCE(679);
      if (lookahead == '\\') ADVANCE(657);
      if (lookahead == 'c') ADVANCE(3100);
      if (lookahead == 'l') ADVANCE(3074);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(206);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3198);
      END_STATE();
    case 57:
      if (lookahead == '!') ADVANCE(2166);
      if (lookahead == '<') ADVANCE(920);
      if (lookahead == '\\') ADVANCE(928);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(230);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(919);
      END_STATE();
    case 58:
      if (lookahead == '!') ADVANCE(2166);
      if (lookahead == '\\') ADVANCE(922);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(272);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(919);
      END_STATE();
    case 59:
      ADVANCE_MAP(
        '!', 2449,
        '#', 948,
        '$', 2227,
        '&', 2169,
        '(', 2193,
        '+', 2225,
        '-', 2424,
        '0', 945,
        '<', 2333,
        '@', 978,
        'A', 938,
        '[', 2461,
        '\\', 2345,
        'a', 935,
        '{', 993,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(62);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(949);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(941);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(936);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(970);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(975);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(963);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(966);
      if (lookahead == 'K' ||
          lookahead == 'k') ADVANCE(956);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(960);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(940);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(968);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(950);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(962);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(943);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(951);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(972);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(957);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(946);
      if (('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(976);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(933);
      END_STATE();
    case 60:
      ADVANCE_MAP(
        '!', 2449,
        '#', 948,
        '$', 2227,
        '&', 2169,
        '(', 2193,
        '+', 2225,
        '-', 2424,
        '0', 945,
        '<', 2333,
        '@', 978,
        '[', 2461,
        '\\', 2345,
        'a', 947,
        '{', 993,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(62);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(946);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(976);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(933);
      END_STATE();
    case 61:
      ADVANCE_MAP(
        '!', 2449,
        '#', 654,
        '$', 2227,
        '&', 2169,
        '(', 2193,
        '+', 2225,
        '-', 2424,
        '/', 156,
        '0', 2453,
        '?', 251,
        '@', 807,
        '[', 2461,
        'a', 1000,
        '{', 993,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(61);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(2455);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 62:
      ADVANCE_MAP(
        '!', 2449,
        '#', 654,
        '$', 2227,
        '&', 2169,
        '(', 2193,
        '+', 2225,
        '-', 2424,
        '0', 2453,
        '@', 807,
        '[', 2461,
        'a', 1000,
        '{', 993,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(62);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(2455);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 63:
      ADVANCE_MAP(
        '!', 2449,
        '#', 2419,
        '$', 2227,
        '&', 2169,
        '(', 2193,
        ')', 2195,
        '+', 2225,
        ',', 2194,
        '-', 2423,
        '.', 155,
        '0', 2453,
        ':', 815,
        ';', 2212,
        '<', 679,
        '=', 2150,
        '?', 2173,
        '@', 807,
        '[', 2461,
        '\\', 657,
        ']', 2462,
        'a', 1000,
        '{', 993,
        '}', 995,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(63);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(2455);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 64:
      ADVANCE_MAP(
        '!', 2450,
        '#', 654,
        '$', 2227,
        '%', 2210,
        '&', 2170,
        '(', 2193,
        '*', 2416,
        '+', 2225,
        '-', 2423,
        '.', 2218,
        '/', 2213,
        '0', 2453,
        '<', 2341,
        '=', 237,
        '>', 2432,
        '?', 2173,
        '@', 807,
        '[', 2461,
        '\\', 657,
        'a', 1000,
        'i', 1002,
        '{', 993,
        '|', 658,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(64);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(2455);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 65:
      ADVANCE_MAP(
        '!', 2450,
        '#', 654,
        '$', 2227,
        '%', 2210,
        '&', 2170,
        '(', 2193,
        '*', 2416,
        '+', 2225,
        '-', 2423,
        '.', 2218,
        '/', 2213,
        '0', 2453,
        '<', 2340,
        '=', 237,
        '>', 2432,
        '?', 2173,
        '@', 807,
        '[', 2461,
        'a', 1000,
        'i', 1002,
        '{', 993,
        '|', 658,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(65);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(2455);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 66:
      ADVANCE_MAP(
        '!', 2450,
        '#', 654,
        '$', 2227,
        '%', 2210,
        '&', 2170,
        '(', 2193,
        '*', 2416,
        '+', 2225,
        '-', 2423,
        '.', 2218,
        '/', 2213,
        '0', 989,
        '<', 2341,
        '=', 237,
        '>', 2432,
        '?', 2173,
        '@', 807,
        '[', 2461,
        '\\', 657,
        'a', 980,
        'i', 983,
        '{', 993,
        '|', 658,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(64);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(991);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(987);
      END_STATE();
    case 67:
      ADVANCE_MAP(
        '!', 2450,
        '#', 654,
        '$', 2227,
        '%', 2210,
        '&', 2170,
        '(', 2193,
        '*', 2416,
        '+', 2225,
        '-', 2423,
        '.', 2218,
        '/', 2213,
        '0', 989,
        '<', 2340,
        '=', 237,
        '>', 2432,
        '?', 2173,
        '@', 807,
        '[', 2461,
        'a', 980,
        'i', 983,
        '{', 993,
        '|', 658,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(65);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(991);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(987);
      END_STATE();
    case 68:
      ADVANCE_MAP(
        '!', 2450,
        '#', 1576,
        '$', 2227,
        '%', 2210,
        '&', 2170,
        '(', 2193,
        '*', 2416,
        '+', 2225,
        '-', 2423,
        '.', 2218,
        '/', 2213,
        '0', 1520,
        '<', 2341,
        '=', 237,
        '>', 2432,
        '?', 2173,
        '@', 807,
        '[', 2461,
        '\\', 657,
        'a', 1523,
        'i', 1564,
        '{', 996,
        '|', 658,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(64);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1522);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1982);
      END_STATE();
    case 69:
      ADVANCE_MAP(
        '!', 2450,
        '#', 1576,
        '$', 2227,
        '%', 2210,
        '&', 2170,
        '(', 2193,
        '*', 2416,
        '+', 2225,
        '-', 2423,
        '.', 2218,
        '/', 2213,
        '0', 1520,
        '<', 2340,
        '=', 237,
        '>', 2432,
        '?', 2173,
        '@', 807,
        '[', 2461,
        'a', 1523,
        'i', 1564,
        '{', 996,
        '|', 658,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(65);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1522);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1982);
      END_STATE();
    case 70:
      if (lookahead == '!') ADVANCE(2168);
      if (lookahead == '<') ADVANCE(2584);
      if (lookahead == '\\') ADVANCE(2553);
      if (lookahead == '{') ADVANCE(994);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(227);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(1482);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1194);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1209);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1300);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1210);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(1486);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1306);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1434);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(1123);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1376);
      if (lookahead == 'Q' ||
          lookahead == 'q') ADVANCE(1489);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1109);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1110);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1006);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1211);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(1212);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1224);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 71:
      if (lookahead == '!') ADVANCE(2168);
      if (lookahead == '{') ADVANCE(994);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(655);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(1482);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1194);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1209);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1300);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1210);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(1486);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1306);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1434);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(1123);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1376);
      if (lookahead == 'Q' ||
          lookahead == 'q') ADVANCE(1489);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1109);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1110);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1006);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1211);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(1212);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1224);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 72:
      if (lookahead == '!') ADVANCE(2167);
      if (lookahead == '<') ADVANCE(2190);
      if (lookahead == '\\') ADVANCE(2188);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(234);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(2192);
      END_STATE();
    case 73:
      if (lookahead == '!') ADVANCE(2167);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(662);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(2192);
      END_STATE();
    case 74:
      ADVANCE_MAP(
        '!', 236,
        '%', 2210,
        '&', 109,
        '(', 2193,
        ')', 2195,
        '*', 2416,
        '+', 2220,
        ',', 2194,
        '-', 2426,
        '.', 2218,
        '/', 2213,
        ':', 815,
        ';', 2212,
        '<', 2340,
        '=', 237,
        '>', 2432,
        '?', 2173,
        '[', 2461,
        ']', 2462,
        'i', 1565,
        '{', 996,
        '|', 658,
        '}', 995,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(76);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1984);
      END_STATE();
    case 75:
      ADVANCE_MAP(
        '!', 236,
        '%', 2210,
        '&', 109,
        '(', 2193,
        ')', 2195,
        '*', 2416,
        '+', 2220,
        ',', 2194,
        '-', 2426,
        '.', 2218,
        '/', 2213,
        ':', 815,
        ';', 2212,
        '<', 2340,
        '=', 237,
        '>', 2432,
        '?', 2173,
        '[', 2461,
        ']', 2462,
        'i', 984,
        '|', 658,
        '}', 995,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(76);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(992);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      END_STATE();
    case 76:
      ADVANCE_MAP(
        '!', 236,
        '%', 2210,
        '&', 109,
        '(', 2193,
        ')', 2195,
        '*', 2416,
        '+', 2220,
        ',', 2194,
        '-', 2426,
        '.', 2218,
        '/', 2213,
        ':', 815,
        ';', 2212,
        '<', 2340,
        '=', 237,
        '>', 2432,
        '?', 2173,
        '[', 2461,
        ']', 2462,
        'i', 599,
        '|', 658,
        '}', 995,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(76);
      END_STATE();
    case 77:
      ADVANCE_MAP(
        '!', 236,
        '%', 2210,
        '&', 109,
        '(', 2193,
        ')', 2195,
        '*', 2416,
        '+', 2220,
        ',', 2194,
        '-', 2426,
        '.', 2218,
        '/', 2213,
        ':', 815,
        ';', 2212,
        '<', 2340,
        '=', 2151,
        '>', 2432,
        '?', 2173,
        '[', 2461,
        ']', 2462,
        'i', 493,
        '|', 658,
        '}', 995,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(77);
      END_STATE();
    case 78:
      ADVANCE_MAP(
        '!', 236,
        '%', 2210,
        '&', 109,
        '(', 2193,
        ')', 2195,
        '*', 2416,
        '+', 2220,
        ',', 2194,
        '-', 2426,
        '.', 2218,
        '/', 2213,
        ':', 815,
        ';', 2212,
        '<', 2340,
        '=', 2151,
        '>', 2432,
        '?', 2173,
        '[', 2461,
        ']', 2462,
        'i', 493,
        '|', 658,
        '}', 995,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(77);
      if (lookahead == 'e' ||
          lookahead == 's') ADVANCE(3371);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(3373);
      END_STATE();
    case 79:
      ADVANCE_MAP(
        '!', 236,
        '%', 2210,
        '&', 109,
        '(', 2193,
        '*', 2416,
        '+', 2220,
        '-', 2426,
        '.', 2218,
        '/', 2213,
        '<', 2341,
        '=', 237,
        '>', 2432,
        '?', 2173,
        'N', 260,
        '[', 2461,
        '\\', 657,
        'b', 470,
        'c', 619,
        'f', 540,
        'g', 630,
        'i', 599,
        's', 607,
        't', 365,
        '|', 658,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(79);
      END_STATE();
    case 80:
      ADVANCE_MAP(
        '!', 236,
        '%', 2210,
        '&', 109,
        '(', 2193,
        '*', 2416,
        '+', 2220,
        '-', 2426,
        '.', 2218,
        '/', 2213,
        '<', 2341,
        '=', 237,
        '>', 2432,
        '?', 2173,
        '[', 2461,
        '\\', 657,
        'a', 1000,
        'i', 1002,
        '{', 993,
        '|', 658,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(80);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 81:
      ADVANCE_MAP(
        '!', 236,
        '%', 2210,
        '&', 109,
        '(', 2193,
        '*', 2416,
        '+', 2220,
        '-', 2426,
        '.', 2218,
        '/', 2213,
        '<', 2341,
        '=', 237,
        '>', 2432,
        '?', 2173,
        '[', 2461,
        '\\', 657,
        'a', 980,
        'i', 983,
        '{', 993,
        '|', 658,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(80);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(992);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(987);
      END_STATE();
    case 82:
      ADVANCE_MAP(
        '!', 236,
        '%', 2210,
        '&', 109,
        '(', 2193,
        '*', 2416,
        '+', 2220,
        '-', 2426,
        '.', 2218,
        '/', 2213,
        '<', 2341,
        '=', 237,
        '>', 2432,
        '?', 2173,
        '[', 2461,
        '\\', 657,
        'i', 1565,
        '{', 996,
        '|', 658,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(84);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1984);
      END_STATE();
    case 83:
      ADVANCE_MAP(
        '!', 236,
        '%', 2210,
        '&', 109,
        '(', 2193,
        '*', 2416,
        '+', 2220,
        '-', 2426,
        '.', 2218,
        '/', 2213,
        '<', 2341,
        '=', 237,
        '>', 2432,
        '?', 2173,
        '[', 2461,
        '\\', 657,
        'i', 984,
        '|', 658,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(84);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(992);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      END_STATE();
    case 84:
      ADVANCE_MAP(
        '!', 236,
        '%', 2210,
        '&', 109,
        '(', 2193,
        '*', 2416,
        '+', 2220,
        '-', 2426,
        '.', 2218,
        '/', 2213,
        '<', 2341,
        '=', 237,
        '>', 2432,
        '?', 2173,
        '[', 2461,
        '\\', 657,
        'i', 599,
        '|', 658,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(84);
      END_STATE();
    case 85:
      ADVANCE_MAP(
        '!', 236,
        '%', 2210,
        '&', 109,
        '(', 2193,
        '*', 2416,
        '+', 2220,
        '-', 2426,
        '.', 2218,
        '/', 2213,
        '<', 2340,
        '=', 237,
        '>', 2432,
        '?', 2173,
        '[', 2461,
        'a', 1000,
        'i', 1002,
        '{', 993,
        '|', 658,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(85);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 86:
      ADVANCE_MAP(
        '!', 236,
        '%', 2210,
        '&', 109,
        '(', 2193,
        '*', 2416,
        '+', 2220,
        '-', 2426,
        '.', 2218,
        '/', 2213,
        '<', 2340,
        '=', 237,
        '>', 2432,
        '?', 2173,
        '[', 2461,
        'a', 980,
        'i', 983,
        '{', 993,
        '|', 658,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(85);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(992);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(987);
      END_STATE();
    case 87:
      ADVANCE_MAP(
        '!', 236,
        '%', 2211,
        '&', 109,
        '(', 2193,
        '*', 2417,
        '+', 2226,
        '-', 2425,
        '.', 2219,
        '/', 2214,
        '<', 2341,
        '=', 2151,
        '>', 2432,
        '?', 2173,
        '[', 2461,
        '\\', 657,
        'a', 1000,
        'i', 1002,
        '{', 993,
        '|', 658,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(87);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 88:
      ADVANCE_MAP(
        '!', 236,
        '%', 2211,
        '&', 109,
        '(', 2193,
        '*', 2417,
        '+', 2226,
        '-', 2425,
        '.', 2219,
        '/', 2214,
        '<', 2341,
        '=', 2151,
        '>', 2432,
        '?', 2173,
        '[', 2461,
        '\\', 657,
        'a', 1000,
        'i', 1002,
        '{', 993,
        '|', 658,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(88);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(3433);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 89:
      ADVANCE_MAP(
        '!', 236,
        '%', 2211,
        '&', 109,
        '(', 2193,
        '*', 2417,
        '+', 2226,
        '-', 2425,
        '.', 2219,
        '/', 2214,
        '<', 2341,
        '=', 2151,
        '>', 2432,
        '?', 2173,
        '[', 2461,
        '\\', 657,
        'a', 1523,
        'i', 1564,
        '{', 996,
        '|', 658,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(87);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(1984);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1982);
      END_STATE();
    case 90:
      ADVANCE_MAP(
        '!', 236,
        '%', 2211,
        '&', 109,
        '(', 2193,
        '*', 2417,
        '+', 2226,
        '-', 2425,
        '.', 2219,
        '/', 2214,
        '<', 2340,
        '=', 2151,
        '>', 2432,
        '?', 2173,
        'N', 260,
        '[', 2461,
        'b', 470,
        'c', 619,
        'f', 540,
        'g', 630,
        'i', 493,
        's', 607,
        't', 365,
        '|', 658,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(90);
      END_STATE();
    case 91:
      ADVANCE_MAP(
        '!', 236,
        '%', 2211,
        '&', 109,
        '(', 2193,
        '*', 2417,
        '+', 2226,
        '-', 2425,
        '.', 2219,
        '/', 2214,
        '<', 2340,
        '=', 2151,
        '>', 2432,
        '?', 2173,
        '[', 2461,
        'a', 1000,
        'i', 1002,
        '{', 993,
        '|', 658,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(91);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 92:
      ADVANCE_MAP(
        '!', 236,
        '%', 2211,
        '&', 109,
        '(', 2193,
        '*', 2417,
        '+', 2226,
        '-', 2425,
        '.', 2219,
        '/', 2214,
        '<', 2340,
        '=', 2151,
        '>', 2432,
        '?', 2173,
        '[', 2461,
        'a', 1523,
        'i', 1564,
        '{', 996,
        '|', 658,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(91);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(1984);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1982);
      END_STATE();
    case 93:
      ADVANCE_MAP(
        '!', 236,
        '%', 2211,
        '&', 109,
        '(', 2193,
        '*', 2417,
        '+', 2226,
        '-', 2425,
        '.', 2219,
        '/', 2214,
        '<', 2340,
        '=', 2151,
        '>', 2432,
        '?', 2173,
        '[', 2461,
        'i', 1565,
        '{', 996,
        '|', 658,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(94);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1984);
      END_STATE();
    case 94:
      ADVANCE_MAP(
        '!', 236,
        '%', 2211,
        '&', 109,
        '(', 2193,
        '*', 2417,
        '+', 2226,
        '-', 2425,
        '.', 2219,
        '/', 2214,
        '<', 2340,
        '=', 2151,
        '>', 2432,
        '?', 2173,
        '[', 2461,
        'i', 599,
        '|', 658,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(94);
      END_STATE();
    case 95:
      if (lookahead == '#') ADVANCE(2418);
      if (lookahead == '*') ADVANCE(2477);
      if (lookahead == '+') ADVANCE(2220);
      if (lookahead == '/') ADVANCE(2213);
      if (lookahead == '<') ADVANCE(679);
      if (lookahead == '\\') ADVANCE(928);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(95);
      if (lookahead == '!' ||
          lookahead == ':' ||
          lookahead == '@' ||
          ('[' <= lookahead && lookahead <= ']') ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(2476);
      if (lookahead == '$' ||
          lookahead == '%' ||
          (',' <= lookahead && lookahead <= '.') ||
          lookahead == '=' ||
          lookahead == '_' ||
          lookahead == '~') ADVANCE(2475);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2465);
      END_STATE();
    case 96:
      if (lookahead == '#') ADVANCE(2418);
      if (lookahead == '*') ADVANCE(2477);
      if (lookahead == '+') ADVANCE(2220);
      if (lookahead == '/') ADVANCE(2213);
      if (lookahead == '\\') ADVANCE(922);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(96);
      if (lookahead == '!' ||
          lookahead == ':' ||
          lookahead == '@' ||
          ('[' <= lookahead && lookahead <= ']') ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(2476);
      if (lookahead == '$' ||
          lookahead == '%' ||
          (',' <= lookahead && lookahead <= '.') ||
          lookahead == '=' ||
          lookahead == '_' ||
          lookahead == '~') ADVANCE(2475);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2465);
      END_STATE();
    case 97:
      if (lookahead == '#') ADVANCE(2418);
      if (lookahead == '*') ADVANCE(2477);
      if (lookahead == '+') ADVANCE(2220);
      if (lookahead == '<') ADVANCE(679);
      if (lookahead == '\\') ADVANCE(928);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(97);
      if (lookahead == '!' ||
          lookahead == ':' ||
          lookahead == '@' ||
          ('[' <= lookahead && lookahead <= ']') ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(2476);
      if (lookahead == '$' ||
          lookahead == '%' ||
          (',' <= lookahead && lookahead <= '/') ||
          lookahead == '=' ||
          lookahead == '_' ||
          lookahead == '~') ADVANCE(2475);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2465);
      END_STATE();
    case 98:
      if (lookahead == '#') ADVANCE(2418);
      if (lookahead == '*') ADVANCE(2477);
      if (lookahead == '+') ADVANCE(2220);
      if (lookahead == '\\') ADVANCE(922);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(98);
      if (lookahead == '!' ||
          lookahead == ':' ||
          lookahead == '@' ||
          ('[' <= lookahead && lookahead <= ']') ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(2476);
      if (lookahead == '$' ||
          lookahead == '%' ||
          (',' <= lookahead && lookahead <= '/') ||
          lookahead == '=' ||
          lookahead == '_' ||
          lookahead == '~') ADVANCE(2475);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2465);
      END_STATE();
    case 99:
      if (lookahead == '#') ADVANCE(2418);
      if (lookahead == '*') ADVANCE(2477);
      if (lookahead == '+') ADVANCE(2222);
      if (lookahead == '<') ADVANCE(679);
      if (lookahead == '\\') ADVANCE(928);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(99);
      if (lookahead == '!' ||
          lookahead == ':' ||
          lookahead == '@' ||
          ('[' <= lookahead && lookahead <= ']') ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(2476);
      if (lookahead == '$' ||
          lookahead == '%' ||
          (',' <= lookahead && lookahead <= '/') ||
          lookahead == '=' ||
          lookahead == '_' ||
          lookahead == '~') ADVANCE(2475);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2465);
      END_STATE();
    case 100:
      if (lookahead == '#') ADVANCE(2418);
      if (lookahead == '*') ADVANCE(2477);
      if (lookahead == '+') ADVANCE(2222);
      if (lookahead == '\\') ADVANCE(922);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(100);
      if (lookahead == '!' ||
          lookahead == ':' ||
          lookahead == '@' ||
          ('[' <= lookahead && lookahead <= ']') ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(2476);
      if (lookahead == '$' ||
          lookahead == '%' ||
          (',' <= lookahead && lookahead <= '/') ||
          lookahead == '=' ||
          lookahead == '_' ||
          lookahead == '~') ADVANCE(2475);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2465);
      END_STATE();
    case 101:
      if (lookahead == '#') ADVANCE(805);
      if (lookahead == '\'') ADVANCE(3256);
      if (lookahead == 'N') ADVANCE(3262);
      if (lookahead == '_') ADVANCE(2148);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(660);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(3249);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3263);
      END_STATE();
    case 102:
      ADVANCE_MAP(
        '$', 2227,
        '%', 2210,
        '\'', 809,
        ')', 2195,
        '+', 2221,
        ',', 2194,
        '-', 158,
        '.', 2217,
        '/', 2213,
        '0', 2456,
        ':', 815,
        '<', 679,
        '=', 2150,
        '?', 2173,
        '@', 807,
        '\\', 107,
        'a', 331,
        'c', 302,
        'd', 438,
        'e', 646,
        'f', 537,
        'i', 313,
        'k', 370,
        'l', 459,
        'n', 338,
        'r', 367,
        's', 461,
        't', 391,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(102);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(2459);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(2964);
      END_STATE();
    case 103:
      ADVANCE_MAP(
        '$', 2227,
        '%', 2210,
        '\'', 809,
        '+', 2223,
        ',', 2968,
        '-', 158,
        '.', 2217,
        '/', 2213,
        '0', 2456,
        ':', 815,
        '?', 2173,
        '@', 807,
        '\\', 106,
        'a', 2162,
        't', 2160,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(104);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(2459);
      if (('b' <= lookahead && lookahead <= 'z')) ADVANCE(2163);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(2964);
      END_STATE();
    case 104:
      ADVANCE_MAP(
        '$', 2227,
        '%', 2210,
        '\'', 809,
        '+', 2223,
        '-', 158,
        '.', 2217,
        '/', 2213,
        '0', 2456,
        ':', 815,
        '?', 2173,
        '@', 807,
        '\\', 106,
        'a', 2162,
        't', 2160,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(104);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(2459);
      if (('b' <= lookahead && lookahead <= 'z')) ADVANCE(2163);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(2964);
      END_STATE();
    case 105:
      if (lookahead == '&') ADVANCE(2230);
      if (lookahead == ')') ADVANCE(2524);
      if (lookahead == '/') ADVANCE(2228);
      if (lookahead == '?') ADVANCE(2229);
      if (lookahead == '|') ADVANCE(2350);
      END_STATE();
    case 106:
      if (lookahead == '&') ADVANCE(2230);
      if (lookahead == '/') ADVANCE(2228);
      if (lookahead == '?') ADVANCE(2229);
      END_STATE();
    case 107:
      if (lookahead == '&') ADVANCE(2230);
      if (lookahead == '/') ADVANCE(2228);
      if (lookahead == '?') ADVANCE(2229);
      if (lookahead == '|') ADVANCE(2350);
      END_STATE();
    case 108:
      if (lookahead == '&') ADVANCE(2230);
      if (lookahead == '|') ADVANCE(2350);
      END_STATE();
    case 109:
      if (lookahead == '&') ADVANCE(2421);
      END_STATE();
    case 110:
      if (lookahead == '\'') ADVANCE(3258);
      if (lookahead == ',') ADVANCE(2194);
      if (lookahead == ':') ADVANCE(815);
      if (lookahead == ';') ADVANCE(2212);
      if (lookahead == '<') ADVANCE(679);
      if (lookahead == '\\') ADVANCE(108);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(110);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 111:
      ADVANCE_MAP(
        '(', 2463,
        ')', 2195,
        ',', 2194,
        '-', 241,
        '<', 679,
        '=', 2150,
        '\\', 657,
        '{', 996,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(114);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(1577);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1984);
      END_STATE();
    case 112:
      if (lookahead == '(') ADVANCE(2525);
      END_STATE();
    case 113:
      if (lookahead == '(') ADVANCE(2526);
      END_STATE();
    case 114:
      if (lookahead == ')') ADVANCE(2195);
      if (lookahead == ',') ADVANCE(2194);
      if (lookahead == '-') ADVANCE(241);
      if (lookahead == '<') ADVANCE(679);
      if (lookahead == '=') ADVANCE(2150);
      if (lookahead == '\\') ADVANCE(657);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(114);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(2964);
      END_STATE();
    case 115:
      if (lookahead == ')') ADVANCE(2195);
      if (lookahead == ',') ADVANCE(2194);
      if (lookahead == '.') ADVANCE(155);
      if (lookahead == '0') ADVANCE(2456);
      if (lookahead == '<') ADVANCE(679);
      if (lookahead == '\\') ADVANCE(657);
      if (lookahead == '{') ADVANCE(993);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(115);
      if (('+' <= lookahead && lookahead <= '-')) ADVANCE(158);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(2459);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 116:
      if (lookahead == '*') ADVANCE(2415);
      if (lookahead == '<') ADVANCE(679);
      if (lookahead == '\\') ADVANCE(657);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(215);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3198);
      END_STATE();
    case 117:
      if (lookahead == '*') ADVANCE(2416);
      if (lookahead == '<') ADVANCE(2521);
      if (lookahead == '[') ADVANCE(2461);
      if (lookahead == '\\') ADVANCE(925);
      if (lookahead == 'm') ADVANCE(2515);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(2505);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n') ADVANCE(2500);
      END_STATE();
    case 118:
      if (lookahead == '*') ADVANCE(2416);
      if (lookahead == '<') ADVANCE(2521);
      if (lookahead == '[') ADVANCE(2461);
      if (lookahead == '\\') ADVANCE(925);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(2506);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n') ADVANCE(2500);
      END_STATE();
    case 119:
      if (lookahead == '*') ADVANCE(2416);
      if (lookahead == '<') ADVANCE(2520);
      if (lookahead == '[') ADVANCE(2461);
      if (lookahead == '\\') ADVANCE(925);
      if (lookahead == 'm') ADVANCE(2515);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(2507);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n') ADVANCE(2500);
      END_STATE();
    case 120:
      if (lookahead == '*') ADVANCE(2416);
      if (lookahead == '<') ADVANCE(2520);
      if (lookahead == '[') ADVANCE(2461);
      if (lookahead == '\\') ADVANCE(925);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(2508);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n') ADVANCE(2500);
      END_STATE();
    case 121:
      if (lookahead == '*') ADVANCE(2416);
      if (lookahead == '<') ADVANCE(2520);
      if (lookahead == '[') ADVANCE(2461);
      if (lookahead == '\\') ADVANCE(923);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(2508);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n') ADVANCE(2500);
      END_STATE();
    case 122:
      if (lookahead == '*') ADVANCE(2477);
      if (lookahead == '+') ADVANCE(2220);
      if (lookahead == '/') ADVANCE(2213);
      if (lookahead == '<') ADVANCE(679);
      if (lookahead == '\\') ADVANCE(928);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(122);
      if (lookahead == '!' ||
          lookahead == ':' ||
          lookahead == '@' ||
          ('[' <= lookahead && lookahead <= ']') ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(2476);
      if (('#' <= lookahead && lookahead <= '%') ||
          (',' <= lookahead && lookahead <= '.') ||
          lookahead == '=' ||
          lookahead == '_' ||
          lookahead == '~') ADVANCE(2475);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2465);
      END_STATE();
    case 123:
      if (lookahead == '*') ADVANCE(2477);
      if (lookahead == '+') ADVANCE(2220);
      if (lookahead == '/') ADVANCE(2213);
      if (lookahead == '\\') ADVANCE(922);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(123);
      if (lookahead == '!' ||
          lookahead == ':' ||
          lookahead == '@' ||
          ('[' <= lookahead && lookahead <= ']') ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(2476);
      if (('#' <= lookahead && lookahead <= '%') ||
          (',' <= lookahead && lookahead <= '.') ||
          lookahead == '=' ||
          lookahead == '_' ||
          lookahead == '~') ADVANCE(2475);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2465);
      END_STATE();
    case 124:
      if (lookahead == '*') ADVANCE(2477);
      if (lookahead == '+') ADVANCE(2220);
      if (lookahead == '<') ADVANCE(679);
      if (lookahead == '\\') ADVANCE(928);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(124);
      if (lookahead == '!' ||
          lookahead == ':' ||
          lookahead == '@' ||
          ('[' <= lookahead && lookahead <= ']') ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(2476);
      if (('#' <= lookahead && lookahead <= '%') ||
          (',' <= lookahead && lookahead <= '/') ||
          lookahead == '=' ||
          lookahead == '_' ||
          lookahead == '~') ADVANCE(2475);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2465);
      END_STATE();
    case 125:
      if (lookahead == '*') ADVANCE(2477);
      if (lookahead == '+') ADVANCE(2220);
      if (lookahead == '\\') ADVANCE(922);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(125);
      if (lookahead == '!' ||
          lookahead == ':' ||
          lookahead == '@' ||
          ('[' <= lookahead && lookahead <= ']') ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(2476);
      if (('#' <= lookahead && lookahead <= '%') ||
          (',' <= lookahead && lookahead <= '/') ||
          lookahead == '=' ||
          lookahead == '_' ||
          lookahead == '~') ADVANCE(2475);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2465);
      END_STATE();
    case 126:
      if (lookahead == '*') ADVANCE(2477);
      if (lookahead == '+') ADVANCE(2222);
      if (lookahead == '<') ADVANCE(679);
      if (lookahead == '\\') ADVANCE(928);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(126);
      if (lookahead == '!' ||
          lookahead == ':' ||
          lookahead == '@' ||
          ('[' <= lookahead && lookahead <= ']') ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(2476);
      if (('#' <= lookahead && lookahead <= '%') ||
          (',' <= lookahead && lookahead <= '/') ||
          lookahead == '=' ||
          lookahead == '_' ||
          lookahead == '~') ADVANCE(2475);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2465);
      END_STATE();
    case 127:
      if (lookahead == '*') ADVANCE(2477);
      if (lookahead == '+') ADVANCE(2222);
      if (lookahead == '\\') ADVANCE(922);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(127);
      if (lookahead == '!' ||
          lookahead == ':' ||
          lookahead == '@' ||
          ('[' <= lookahead && lookahead <= ']') ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(2476);
      if (('#' <= lookahead && lookahead <= '%') ||
          (',' <= lookahead && lookahead <= '/') ||
          lookahead == '=' ||
          lookahead == '_' ||
          lookahead == '~') ADVANCE(2475);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2465);
      END_STATE();
    case 128:
      ADVANCE_MAP(
        '*', 2477,
        '<', 679,
        '\\', 928,
        'c', 2474,
        'i', 2470,
        'l', 2472,
        'n', 2473,
        't', 2471,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(128);
      if (lookahead == '!' ||
          lookahead == ':' ||
          lookahead == '@' ||
          ('[' <= lookahead && lookahead <= ']') ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(2476);
      if (('#' <= lookahead && lookahead <= '%') ||
          ('+' <= lookahead && lookahead <= '/') ||
          lookahead == '=' ||
          lookahead == '_' ||
          lookahead == '~') ADVANCE(2475);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2465);
      END_STATE();
    case 129:
      if (lookahead == '*') ADVANCE(2477);
      if (lookahead == '<') ADVANCE(679);
      if (lookahead == '\\') ADVANCE(928);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(129);
      if (lookahead == '!' ||
          lookahead == ':' ||
          lookahead == '@' ||
          ('[' <= lookahead && lookahead <= ']') ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(2476);
      if (('#' <= lookahead && lookahead <= '%') ||
          ('+' <= lookahead && lookahead <= '/') ||
          lookahead == '=' ||
          lookahead == '_' ||
          lookahead == '~') ADVANCE(2475);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2465);
      END_STATE();
    case 130:
      if (lookahead == '*') ADVANCE(2477);
      if (lookahead == '@') ADVANCE(2196);
      if (lookahead == '\\') ADVANCE(922);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(130);
      if (lookahead == '!' ||
          lookahead == ':' ||
          ('[' <= lookahead && lookahead <= ']') ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(2476);
      if (('#' <= lookahead && lookahead <= '%') ||
          ('+' <= lookahead && lookahead <= '/') ||
          lookahead == '=' ||
          lookahead == '_' ||
          lookahead == '~') ADVANCE(2475);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2465);
      END_STATE();
    case 131:
      if (lookahead == '*') ADVANCE(2477);
      if (lookahead == 'A') ADVANCE(2467);
      if (lookahead == 'O') ADVANCE(2468);
      if (lookahead == 'P') ADVANCE(2466);
      if (lookahead == 'S') ADVANCE(2469);
      if (lookahead == '\\') ADVANCE(922);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(131);
      if (lookahead == '!' ||
          lookahead == ':' ||
          lookahead == '@' ||
          ('[' <= lookahead && lookahead <= ']') ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(2476);
      if (('#' <= lookahead && lookahead <= '%') ||
          ('+' <= lookahead && lookahead <= '/') ||
          lookahead == '=' ||
          lookahead == '_' ||
          lookahead == '~') ADVANCE(2475);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2465);
      END_STATE();
    case 132:
      if (lookahead == '*') ADVANCE(2477);
      if (lookahead == '\\') ADVANCE(922);
      if (lookahead == 'c') ADVANCE(2474);
      if (lookahead == 'i') ADVANCE(2470);
      if (lookahead == 'l') ADVANCE(2472);
      if (lookahead == 'n') ADVANCE(2473);
      if (lookahead == 't') ADVANCE(2471);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(132);
      if (lookahead == '!' ||
          lookahead == ':' ||
          lookahead == '@' ||
          ('[' <= lookahead && lookahead <= ']') ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(2476);
      if (('#' <= lookahead && lookahead <= '%') ||
          ('+' <= lookahead && lookahead <= '/') ||
          lookahead == '=' ||
          lookahead == '_' ||
          lookahead == '~') ADVANCE(2475);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2465);
      END_STATE();
    case 133:
      if (lookahead == '*') ADVANCE(2477);
      if (lookahead == '\\') ADVANCE(922);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(133);
      if (lookahead == '!' ||
          lookahead == ':' ||
          lookahead == '@' ||
          ('[' <= lookahead && lookahead <= ']') ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(2476);
      if (('#' <= lookahead && lookahead <= '%') ||
          ('+' <= lookahead && lookahead <= '/') ||
          lookahead == '=' ||
          lookahead == '_' ||
          lookahead == '~') ADVANCE(2475);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2465);
      END_STATE();
    case 134:
      ADVANCE_MAP(
        '*', 2494,
        '<', 679,
        '\\', 2492,
        'b', 2487,
        'f', 2482,
        'g', 2485,
        'l', 2483,
        'n', 2479,
        'p', 2486,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(196);
      if (lookahead == '!' ||
          lookahead == ':' ||
          lookahead == '@' ||
          ('[' <= lookahead && lookahead <= ']') ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(2491);
      if (('#' <= lookahead && lookahead <= '%') ||
          ('+' <= lookahead && lookahead <= '/') ||
          lookahead == '=' ||
          lookahead == '_' ||
          lookahead == '~') ADVANCE(2490);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2478);
      END_STATE();
    case 135:
      if (lookahead == '*') ADVANCE(2494);
      if (lookahead == '<') ADVANCE(679);
      if (lookahead == '\\') ADVANCE(2492);
      if (lookahead == 'b') ADVANCE(2487);
      if (lookahead == 'f') ADVANCE(2482);
      if (lookahead == 'g') ADVANCE(2485);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(197);
      if (lookahead == '!' ||
          lookahead == ':' ||
          lookahead == '@' ||
          ('[' <= lookahead && lookahead <= ']') ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(2491);
      if (('#' <= lookahead && lookahead <= '%') ||
          ('+' <= lookahead && lookahead <= '/') ||
          lookahead == '=' ||
          lookahead == '_' ||
          lookahead == '~') ADVANCE(2490);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2478);
      END_STATE();
    case 136:
      ADVANCE_MAP(
        '*', 2494,
        '<', 679,
        '\\', 2492,
        'c', 2489,
        'i', 2480,
        'l', 2484,
        'n', 2488,
        't', 2481,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(207);
      if (lookahead == '!' ||
          lookahead == ':' ||
          lookahead == '@' ||
          ('[' <= lookahead && lookahead <= ']') ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(2491);
      if (('#' <= lookahead && lookahead <= '%') ||
          ('+' <= lookahead && lookahead <= '/') ||
          lookahead == '=' ||
          lookahead == '_' ||
          lookahead == '~') ADVANCE(2490);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2478);
      END_STATE();
    case 137:
      if (lookahead == '*') ADVANCE(2494);
      if (lookahead == '<') ADVANCE(679);
      if (lookahead == '\\') ADVANCE(2492);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(214);
      if (lookahead == '!' ||
          lookahead == ':' ||
          lookahead == '@' ||
          ('[' <= lookahead && lookahead <= ']') ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(2491);
      if (('#' <= lookahead && lookahead <= '%') ||
          ('+' <= lookahead && lookahead <= '/') ||
          lookahead == '=' ||
          lookahead == '_' ||
          lookahead == '~') ADVANCE(2490);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2478);
      END_STATE();
    case 138:
      if (lookahead == '*') ADVANCE(2494);
      if (lookahead == '<') ADVANCE(679);
      if (lookahead == '\\') ADVANCE(929);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(129);
      if (lookahead == '!' ||
          lookahead == ':' ||
          lookahead == '@' ||
          ('[' <= lookahead && lookahead <= ']') ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(2491);
      if (('#' <= lookahead && lookahead <= '%') ||
          ('+' <= lookahead && lookahead <= '/') ||
          lookahead == '=' ||
          lookahead == '_' ||
          lookahead == '~') ADVANCE(2490);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2478);
      END_STATE();
    case 139:
      ADVANCE_MAP(
        '*', 2494,
        '\\', 2493,
        'b', 2487,
        'f', 2482,
        'g', 2485,
        'l', 2483,
        'n', 2479,
        'p', 2486,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(297);
      if (lookahead == '!' ||
          lookahead == ':' ||
          lookahead == '@' ||
          ('[' <= lookahead && lookahead <= ']') ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(2491);
      if (('#' <= lookahead && lookahead <= '%') ||
          ('+' <= lookahead && lookahead <= '/') ||
          lookahead == '=' ||
          lookahead == '_' ||
          lookahead == '~') ADVANCE(2490);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2478);
      END_STATE();
    case 140:
      if (lookahead == '*') ADVANCE(2494);
      if (lookahead == '\\') ADVANCE(2493);
      if (lookahead == 'b') ADVANCE(2487);
      if (lookahead == 'f') ADVANCE(2482);
      if (lookahead == 'g') ADVANCE(2485);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(298);
      if (lookahead == '!' ||
          lookahead == ':' ||
          lookahead == '@' ||
          ('[' <= lookahead && lookahead <= ']') ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(2491);
      if (('#' <= lookahead && lookahead <= '%') ||
          ('+' <= lookahead && lookahead <= '/') ||
          lookahead == '=' ||
          lookahead == '_' ||
          lookahead == '~') ADVANCE(2490);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2478);
      END_STATE();
    case 141:
      if (lookahead == '*') ADVANCE(2494);
      if (lookahead == '\\') ADVANCE(2493);
      if (lookahead == 'c') ADVANCE(2489);
      if (lookahead == 'i') ADVANCE(2480);
      if (lookahead == 'l') ADVANCE(2484);
      if (lookahead == 'n') ADVANCE(2488);
      if (lookahead == 't') ADVANCE(2481);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(320);
      if (lookahead == '!' ||
          lookahead == ':' ||
          lookahead == '@' ||
          ('[' <= lookahead && lookahead <= ']') ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(2491);
      if (('#' <= lookahead && lookahead <= '%') ||
          ('+' <= lookahead && lookahead <= '/') ||
          lookahead == '=' ||
          lookahead == '_' ||
          lookahead == '~') ADVANCE(2490);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2478);
      END_STATE();
    case 142:
      if (lookahead == '*') ADVANCE(2494);
      if (lookahead == '\\') ADVANCE(930);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(133);
      if (lookahead == '!' ||
          lookahead == ':' ||
          lookahead == '@' ||
          ('[' <= lookahead && lookahead <= ']') ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(2491);
      if (('#' <= lookahead && lookahead <= '%') ||
          ('+' <= lookahead && lookahead <= '/') ||
          lookahead == '=' ||
          lookahead == '_' ||
          lookahead == '~') ADVANCE(2490);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2478);
      END_STATE();
    case 143:
      if (lookahead == ',') ADVANCE(2194);
      if (lookahead == '<') ADVANCE(679);
      if (lookahead == '\\') ADVANCE(657);
      if (lookahead == 'c') ADVANCE(3379);
      if (lookahead == 'n') ADVANCE(3382);
      if (lookahead == 's') ADVANCE(3394);
      if (lookahead == 't') ADVANCE(3408);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(143);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= ']') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3420);
      END_STATE();
    case 144:
      if (lookahead == ',') ADVANCE(2194);
      if (lookahead == '<') ADVANCE(2584);
      if (lookahead == '\\') ADVANCE(2553);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(144);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n') ADVANCE(2961);
      END_STATE();
    case 145:
      if (lookahead == ',') ADVANCE(2194);
      if (lookahead == '}') ADVANCE(995);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(145);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2528);
      END_STATE();
    case 146:
      if (lookahead == ',') ADVANCE(2194);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(146);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n') ADVANCE(2961);
      END_STATE();
    case 147:
      if (lookahead == ',') ADVANCE(659);
      if (lookahead == '-') ADVANCE(148);
      if (lookahead == '}') ADVANCE(2497);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(148);
      END_STATE();
    case 148:
      if (lookahead == ',') ADVANCE(659);
      if (lookahead == '}') ADVANCE(2497);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(148);
      END_STATE();
    case 149:
      if (lookahead == '-') ADVANCE(314);
      END_STATE();
    case 150:
      if (lookahead == '-') ADVANCE(169);
      if (lookahead == '2') ADVANCE(299);
      END_STATE();
    case 151:
      if (lookahead == '-') ADVANCE(165);
      if (lookahead == '8') ADVANCE(880);
      END_STATE();
    case 152:
      if (lookahead == '-') ADVANCE(2237);
      END_STATE();
    case 153:
      if (lookahead == '-') ADVANCE(163);
      END_STATE();
    case 154:
      if (lookahead == '.') ADVANCE(2197);
      END_STATE();
    case 155:
      if (lookahead == '.') ADVANCE(154);
      END_STATE();
    case 156:
      if (lookahead == '/') ADVANCE(917);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(156);
      END_STATE();
    case 157:
      ADVANCE_MAP(
        '0', 2456,
        '>', 2464,
        'a', 333,
        'b', 279,
        'c', 531,
        'k', 375,
        'n', 283,
        'r', 284,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(2459);
      END_STATE();
    case 158:
      if (lookahead == '0') ADVANCE(2456);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(2459);
      END_STATE();
    case 159:
      if (lookahead == '0') ADVANCE(837);
      if (lookahead == '2') ADVANCE(838);
      if (lookahead == '5') ADVANCE(839);
      if (lookahead == '7') ADVANCE(840);
      END_STATE();
    case 160:
      if (lookahead == '0') ADVANCE(841);
      if (lookahead == '1') ADVANCE(842);
      if (lookahead == '2') ADVANCE(843);
      if (lookahead == '3') ADVANCE(844);
      if (lookahead == '5') ADVANCE(845);
      if (lookahead == '6') ADVANCE(846);
      if (lookahead == '9') ADVANCE(847);
      END_STATE();
    case 161:
      if (lookahead == '0') ADVANCE(864);
      END_STATE();
    case 162:
      ADVANCE_MAP(
        '0', 849,
        '1', 850,
        '3', 851,
        '4', 852,
        '5', 853,
        '6', 854,
        '7', 855,
        '8', 856,
      );
      END_STATE();
    case 163:
      if (lookahead == '0') ADVANCE(2327);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(2329);
      END_STATE();
    case 164:
      if (lookahead == '1') ADVANCE(173);
      if (lookahead == '4') ADVANCE(174);
      if (lookahead == '7') ADVANCE(176);
      if (lookahead == '8') ADVANCE(179);
      if (lookahead == '9') ADVANCE(175);
      END_STATE();
    case 165:
      if (lookahead == '1') ADVANCE(182);
      if (lookahead == '3') ADVANCE(170);
      if (lookahead == '8') ADVANCE(867);
      END_STATE();
    case 166:
      if (lookahead == '1') ADVANCE(830);
      END_STATE();
    case 167:
      if (lookahead == '1') ADVANCE(183);
      if (lookahead == '3') ADVANCE(172);
      if (lookahead == '8') ADVANCE(893);
      END_STATE();
    case 168:
      if (lookahead == '2') ADVANCE(857);
      if (lookahead == '6') ADVANCE(862);
      END_STATE();
    case 169:
      if (lookahead == '2') ADVANCE(868);
      if (lookahead == '4') ADVANCE(872);
      END_STATE();
    case 170:
      if (lookahead == '2') ADVANCE(885);
      END_STATE();
    case 171:
      if (lookahead == '2') ADVANCE(894);
      if (lookahead == '4') ADVANCE(898);
      END_STATE();
    case 172:
      if (lookahead == '2') ADVANCE(902);
      END_STATE();
    case 173:
      if (lookahead == '2') ADVANCE(180);
      END_STATE();
    case 174:
      if (lookahead == '3') ADVANCE(184);
      END_STATE();
    case 175:
      if (lookahead == '3') ADVANCE(168);
      if (lookahead == '4') ADVANCE(187);
      if (lookahead == '5') ADVANCE(161);
      END_STATE();
    case 176:
      if (lookahead == '3') ADVANCE(185);
      if (lookahead == '7') ADVANCE(181);
      END_STATE();
    case 177:
      if (lookahead == '4') ADVANCE(848);
      END_STATE();
    case 178:
      if (lookahead == '5') ADVANCE(865);
      END_STATE();
    case 179:
      if (lookahead == '5') ADVANCE(159);
      if (lookahead == '6') ADVANCE(160);
      if (lookahead == '7') ADVANCE(177);
      END_STATE();
    case 180:
      if (lookahead == '5') ADVANCE(162);
      END_STATE();
    case 181:
      if (lookahead == '5') ADVANCE(836);
      END_STATE();
    case 182:
      if (lookahead == '6') ADVANCE(870);
      END_STATE();
    case 183:
      if (lookahead == '6') ADVANCE(896);
      END_STATE();
    case 184:
      if (lookahead == '7') ADVANCE(834);
      END_STATE();
    case 185:
      if (lookahead == '7') ADVANCE(835);
      END_STATE();
    case 186:
      if (lookahead == '8') ADVANCE(832);
      END_STATE();
    case 187:
      if (lookahead == '9') ADVANCE(860);
      END_STATE();
    case 188:
      ADVANCE_MAP(
        '<', 2333,
        '\\', 2345,
        'A', 2369,
        'a', 2369,
        'B', 2374,
        'b', 2374,
        'C', 2370,
        'c', 2370,
        'D', 2368,
        'd', 2368,
        'E', 2382,
        'e', 2382,
        'F', 2384,
        'f', 2384,
        'H', 2378,
        'h', 2378,
        'I', 2380,
        'i', 2380,
        'K', 2376,
        'k', 2376,
        'L', 2377,
        'l', 2377,
        'M', 2367,
        'm', 2367,
        'N', 2381,
        'n', 2381,
        'P', 2373,
        'p', 2373,
        'R', 2379,
        'r', 2379,
        'S', 2371,
        's', 2371,
        'T', 2372,
        't', 2372,
        'U', 2383,
        'u', 2383,
        'X', 2375,
        'x', 2375,
      );
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '|') ADVANCE(2366);
      END_STATE();
    case 189:
      if (lookahead == '<') ADVANCE(2333);
      if (lookahead == '\\') ADVANCE(2345);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '|') ADVANCE(2366);
      END_STATE();
    case 190:
      if (lookahead == '<') ADVANCE(679);
      if (lookahead == '=') ADVANCE(2150);
      if (lookahead == '\\') ADVANCE(657);
      if (lookahead == 'a') ADVANCE(1000);
      if (lookahead == '{') ADVANCE(993);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(190);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 191:
      if (lookahead == '<') ADVANCE(679);
      if (lookahead == '=') ADVANCE(2150);
      if (lookahead == '\\') ADVANCE(657);
      if (lookahead == 'a') ADVANCE(1523);
      if (lookahead == '{') ADVANCE(996);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(190);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(1984);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1982);
      END_STATE();
    case 192:
      if (lookahead == '<') ADVANCE(679);
      if (lookahead == '\\') ADVANCE(657);
      if (lookahead == 'a') ADVANCE(1000);
      if (lookahead == '{') ADVANCE(993);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(192);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 193:
      if (lookahead == '<') ADVANCE(679);
      if (lookahead == '\\') ADVANCE(657);
      if (lookahead == 'a') ADVANCE(980);
      if (lookahead == '{') ADVANCE(993);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(192);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(992);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(987);
      END_STATE();
    case 194:
      if (lookahead == '<') ADVANCE(679);
      if (lookahead == '\\') ADVANCE(657);
      if (lookahead == 'a') ADVANCE(3027);
      if (lookahead == 'c') ADVANCE(3138);
      if (lookahead == 'r') ADVANCE(3041);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(194);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(3198);
      END_STATE();
    case 195:
      ADVANCE_MAP(
        '<', 679,
        '\\', 657,
        'b', 1572,
        'f', 1540,
        'g', 1561,
        'l', 1541,
        'n', 1524,
        'p', 1562,
        '{', 996,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(196);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1984);
      END_STATE();
    case 196:
      ADVANCE_MAP(
        '<', 679,
        '\\', 657,
        'b', 629,
        'f', 431,
        'g', 575,
        'l', 453,
        'n', 277,
        'p', 585,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(196);
      END_STATE();
    case 197:
      if (lookahead == '<') ADVANCE(679);
      if (lookahead == '\\') ADVANCE(657);
      if (lookahead == 'b') ADVANCE(629);
      if (lookahead == 'f') ADVANCE(431);
      if (lookahead == 'g') ADVANCE(575);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(197);
      END_STATE();
    case 198:
      ADVANCE_MAP(
        '<', 679,
        '\\', 657,
        'b', 470,
        'c', 619,
        'f', 540,
        'g', 630,
        's', 607,
        't', 365,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(198);
      END_STATE();
    case 199:
      if (lookahead == '<') ADVANCE(679);
      if (lookahead == '\\') ADVANCE(657);
      if (lookahead == 'c') ADVANCE(2071);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(199);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 200:
      ADVANCE_MAP(
        '<', 679,
        '\\', 657,
        'c', 2008,
        'd', 2052,
        'e', 2079,
        'f', 2098,
        'k', 2039,
        'm', 1997,
        'n', 2030,
        'o', 2090,
        's', 2061,
        't', 2113,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(200);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 201:
      ADVANCE_MAP(
        '<', 679,
        '\\', 657,
        'c', 2008,
        'd', 2052,
        'e', 2079,
        'f', 2098,
        'k', 2039,
        'm', 1997,
        'n', 2030,
        'o', 2090,
        's', 2062,
        't', 2113,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(201);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 202:
      ADVANCE_MAP(
        '<', 679,
        '\\', 657,
        'c', 3009,
        'd', 3066,
        'e', 3107,
        'f', 3133,
        'k', 3038,
        'm', 2992,
        'n', 3028,
        'o', 3117,
        's', 3083,
        't', 3158,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(202);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3198);
      END_STATE();
    case 203:
      if (lookahead == '<') ADVANCE(679);
      if (lookahead == '\\') ADVANCE(657);
      if (lookahead == 'c') ADVANCE(3011);
      if (lookahead == 'n') ADVANCE(3032);
      if (lookahead == 's') ADVANCE(3080);
      if (lookahead == 't') ADVANCE(3153);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(203);
      if (lookahead == '.' ||
          lookahead == '@') ADVANCE(3198);
      if (('[' <= lookahead && lookahead <= ']')) ADVANCE(3420);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3197);
      END_STATE();
    case 204:
      ADVANCE_MAP(
        '<', 679,
        '\\', 657,
        'c', 1570,
        'i', 1525,
        'l', 1537,
        'n', 1571,
        't', 1526,
        '{', 996,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(207);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1984);
      END_STATE();
    case 205:
      if (lookahead == '<') ADVANCE(679);
      if (lookahead == '\\') ADVANCE(657);
      if (lookahead == 'c') ADVANCE(3187);
      if (lookahead == 'i') ADVANCE(3015);
      if (lookahead == 'l') ADVANCE(3077);
      if (lookahead == 'n') ADVANCE(3182);
      if (lookahead == 't') ADVANCE(3051);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(205);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3198);
      END_STATE();
    case 206:
      if (lookahead == '<') ADVANCE(679);
      if (lookahead == '\\') ADVANCE(657);
      if (lookahead == 'c') ADVANCE(3100);
      if (lookahead == 'l') ADVANCE(3074);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(206);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3198);
      END_STATE();
    case 207:
      if (lookahead == '<') ADVANCE(679);
      if (lookahead == '\\') ADVANCE(657);
      if (lookahead == 'c') ADVANCE(635);
      if (lookahead == 'i') ADVANCE(312);
      if (lookahead == 'l') ADVANCE(459);
      if (lookahead == 'n') ADVANCE(633);
      if (lookahead == 't') ADVANCE(390);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(207);
      END_STATE();
    case 208:
      ADVANCE_MAP(
        '<', 679,
        '\\', 657,
        'c', 2009,
        'd', 2052,
        'e', 2141,
        'f', 2098,
        'k', 2039,
        'n', 2030,
        's', 2061,
        't', 2113,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(208);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 209:
      ADVANCE_MAP(
        '<', 679,
        '\\', 657,
        'c', 3010,
        'd', 3066,
        'e', 3189,
        'f', 3133,
        'k', 3038,
        'n', 3028,
        's', 3083,
        't', 3158,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(209);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3198);
      END_STATE();
    case 210:
      if (lookahead == '<') ADVANCE(679);
      if (lookahead == '\\') ADVANCE(657);
      if (lookahead == 'd') ADVANCE(2027);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(210);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 211:
      if (lookahead == '<') ADVANCE(679);
      if (lookahead == '\\') ADVANCE(657);
      if (lookahead == 'm') ADVANCE(3000);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(211);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3198);
      END_STATE();
    case 212:
      if (lookahead == '<') ADVANCE(679);
      if (lookahead == '\\') ADVANCE(657);
      if (lookahead == 's') ADVANCE(2133);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(212);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 213:
      if (lookahead == '<') ADVANCE(679);
      if (lookahead == '\\') ADVANCE(657);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(213);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 214:
      if (lookahead == '<') ADVANCE(679);
      if (lookahead == '\\') ADVANCE(657);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(214);
      END_STATE();
    case 215:
      if (lookahead == '<') ADVANCE(679);
      if (lookahead == '\\') ADVANCE(657);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(215);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3198);
      END_STATE();
    case 216:
      if (lookahead == '<') ADVANCE(2159);
      END_STATE();
    case 217:
      if (lookahead == '<') ADVANCE(2336);
      if (lookahead == '\\') ADVANCE(2345);
      if (lookahead == '|') ADVANCE(933);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(219);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(939);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(954);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(942);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(937);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(971);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(974);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(964);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(967);
      if (lookahead == 'K' ||
          lookahead == 'k') ADVANCE(959);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(961);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(934);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(969);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(953);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(965);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(944);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(952);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(973);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(958);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(933);
      END_STATE();
    case 218:
      if (lookahead == '<') ADVANCE(2336);
      if (lookahead == '\\') ADVANCE(2345);
      if (lookahead == '|') ADVANCE(933);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(219);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(933);
      END_STATE();
    case 219:
      if (lookahead == '<') ADVANCE(2344);
      if (lookahead == '\\') ADVANCE(922);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(219);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != '|') ADVANCE(2365);
      END_STATE();
    case 220:
      ADVANCE_MAP(
        '<', 2334,
        '\\', 2346,
        '\t', 2366,
        ' ', 2366,
        'A', 2369,
        'a', 2369,
        'B', 2374,
        'b', 2374,
        'C', 2370,
        'c', 2370,
        'D', 2368,
        'd', 2368,
        'E', 2382,
        'e', 2382,
        'F', 2384,
        'f', 2384,
        'H', 2378,
        'h', 2378,
        'I', 2380,
        'i', 2380,
        'K', 2376,
        'k', 2376,
        'L', 2377,
        'l', 2377,
        'M', 2367,
        'm', 2367,
        'N', 2381,
        'n', 2381,
        'P', 2373,
        'p', 2373,
        'R', 2379,
        'r', 2379,
        'S', 2371,
        's', 2371,
        'T', 2372,
        't', 2372,
        'U', 2383,
        'u', 2383,
        'X', 2375,
        'x', 2375,
      );
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '|') ADVANCE(2366);
      END_STATE();
    case 221:
      if (lookahead == '<') ADVANCE(2334);
      if (lookahead == '\\') ADVANCE(2346);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(2366);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '|') ADVANCE(2366);
      END_STATE();
    case 222:
      if (lookahead == '<') ADVANCE(2522);
      if (lookahead == '[') ADVANCE(2461);
      if (lookahead == '\\') ADVANCE(926);
      if (lookahead == 'm') ADVANCE(2515);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(2513);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n') ADVANCE(2500);
      END_STATE();
    case 223:
      if (lookahead == '<') ADVANCE(2522);
      if (lookahead == '[') ADVANCE(2461);
      if (lookahead == '\\') ADVANCE(926);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(2514);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n') ADVANCE(2500);
      END_STATE();
    case 224:
      ADVANCE_MAP(
        '<', 2335,
        '\\', 3238,
        'b', 3222,
        'c', 3236,
        'f', 3227,
        'g', 3237,
        's', 3233,
        't', 3214,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(198);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(3241);
      END_STATE();
    case 225:
      if (lookahead == '<') ADVANCE(2337);
      if (lookahead == 'b') ADVANCE(3222);
      if (lookahead == 'c') ADVANCE(3236);
      if (lookahead == 'f') ADVANCE(3227);
      if (lookahead == 'g') ADVANCE(3237);
      if (lookahead == 's') ADVANCE(3233);
      if (lookahead == 't') ADVANCE(3214);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(300);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(3241);
      END_STATE();
    case 226:
      if (lookahead == '<') ADVANCE(2337);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ') ADVANCE(3241);
      END_STATE();
    case 227:
      if (lookahead == '<') ADVANCE(2584);
      if (lookahead == '\\') ADVANCE(2553);
      if (lookahead == '{') ADVANCE(994);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(227);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(1482);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1194);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1209);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1300);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1210);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(1486);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1306);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1434);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(1123);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1376);
      if (lookahead == 'Q' ||
          lookahead == 'q') ADVANCE(1489);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1109);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1110);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1006);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1211);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(1212);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1224);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 228:
      if (lookahead == '<') ADVANCE(2584);
      if (lookahead == '\\') ADVANCE(2553);
      if (lookahead == '{') ADVANCE(997);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(229);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(1956);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1731);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1742);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1813);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1743);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(1957);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1818);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1920);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(1668);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1875);
      if (lookahead == 'Q' ||
          lookahead == 'q') ADVANCE(1959);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1656);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1657);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1578);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1744);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(1745);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1753);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 229:
      if (lookahead == '<') ADVANCE(2584);
      if (lookahead == '\\') ADVANCE(2553);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(229);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2936);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2709);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2720);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(2791);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2721);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(2937);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(2796);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2900);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(2644);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2853);
      if (lookahead == 'Q' ||
          lookahead == 'q') ADVANCE(2939);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2634);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2635);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(2554);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(2722);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(2723);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2731);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 230:
      if (lookahead == '<') ADVANCE(920);
      if (lookahead == '\\') ADVANCE(928);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(230);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(919);
      END_STATE();
    case 231:
      if (lookahead == '<') ADVANCE(2342);
      if (lookahead == '\\') ADVANCE(922);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(231);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(919);
      END_STATE();
    case 232:
      if (lookahead == '<') ADVANCE(2343);
      if (lookahead == '\\') ADVANCE(922);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(232);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(919);
      END_STATE();
    case 233:
      if (lookahead == '<') ADVANCE(955);
      if (lookahead == '\\') ADVANCE(929);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(230);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(933);
      END_STATE();
    case 234:
      if (lookahead == '<') ADVANCE(2190);
      if (lookahead == '\\') ADVANCE(2188);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(234);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(2192);
      END_STATE();
    case 235:
      if (lookahead == '<') ADVANCE(910);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(235);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(911);
      END_STATE();
    case 236:
      if (lookahead == '=') ADVANCE(2430);
      if (lookahead == '~') ADVANCE(2436);
      END_STATE();
    case 237:
      if (lookahead == '=') ADVANCE(2429);
      if (lookahead == '~') ADVANCE(2435);
      END_STATE();
    case 238:
      if (lookahead == '=') ADVANCE(2176);
      END_STATE();
    case 239:
      if (lookahead == '=') ADVANCE(2178);
      END_STATE();
    case 240:
      if (lookahead == '=') ADVANCE(2177);
      END_STATE();
    case 241:
      if (lookahead == '>') ADVANCE(2464);
      if (lookahead == 'a') ADVANCE(333);
      if (lookahead == 'b') ADVANCE(279);
      if (lookahead == 'c') ADVANCE(531);
      if (lookahead == 'k') ADVANCE(375);
      if (lookahead == 'n') ADVANCE(283);
      if (lookahead == 'r') ADVANCE(284);
      END_STATE();
    case 242:
      if (lookahead == '>') ADVANCE(2361);
      END_STATE();
    case 243:
      if (lookahead == '>') ADVANCE(2357);
      END_STATE();
    case 244:
      if (lookahead == '>') ADVANCE(2349);
      END_STATE();
    case 245:
      if (lookahead == '>') ADVANCE(2236);
      END_STATE();
    case 246:
      if (lookahead == '>') ADVANCE(2231);
      END_STATE();
    case 247:
      if (lookahead == '>') ADVANCE(2232);
      END_STATE();
    case 248:
      if (lookahead == '>') ADVANCE(2235);
      END_STATE();
    case 249:
      if (lookahead == '>') ADVANCE(2233);
      END_STATE();
    case 250:
      if (lookahead == '>') ADVANCE(2234);
      END_STATE();
    case 251:
      if (lookahead == '?') ADVANCE(918);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(251);
      END_STATE();
    case 252:
      if (lookahead == 'A') ADVANCE(261);
      END_STATE();
    case 253:
      if (lookahead == 'C') ADVANCE(256);
      END_STATE();
    case 254:
      if (lookahead == 'E') ADVANCE(3203);
      END_STATE();
    case 255:
      if (lookahead == 'F') ADVANCE(819);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(255);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(826);
      END_STATE();
    case 256:
      if (lookahead == 'K') ADVANCE(906);
      END_STATE();
    case 257:
      if (lookahead == 'L') ADVANCE(907);
      END_STATE();
    case 258:
      if (lookahead == 'N') ADVANCE(254);
      END_STATE();
    case 259:
      if (lookahead == 'N') ADVANCE(1992);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(660);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 260:
      if (lookahead == 'O') ADVANCE(258);
      END_STATE();
    case 261:
      if (lookahead == 'R') ADVANCE(263);
      END_STATE();
    case 262:
      if (lookahead == 'T') ADVANCE(905);
      END_STATE();
    case 263:
      if (lookahead == 'T') ADVANCE(904);
      END_STATE();
    case 264:
      if (lookahead == '[') ADVANCE(2461);
      if (lookahead == '\\') ADVANCE(926);
      if (lookahead == 'm') ADVANCE(2515);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(2517);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n') ADVANCE(2500);
      END_STATE();
    case 265:
      if (lookahead == '[') ADVANCE(2461);
      if (lookahead == '\\') ADVANCE(926);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(2519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n') ADVANCE(2500);
      END_STATE();
    case 266:
      if (lookahead == '[') ADVANCE(2461);
      if (lookahead == '\\') ADVANCE(927);
      if (lookahead == 'g') ADVANCE(2518);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(2516);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n') ADVANCE(2500);
      END_STATE();
    case 267:
      if (lookahead == '[') ADVANCE(2461);
      if (lookahead == '\\') ADVANCE(927);
      if (lookahead == 'm') ADVANCE(2515);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(2517);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n') ADVANCE(2500);
      END_STATE();
    case 268:
      if (lookahead == '[') ADVANCE(2461);
      if (lookahead == '\\') ADVANCE(927);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(2519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n') ADVANCE(2500);
      END_STATE();
    case 269:
      if (lookahead == '[') ADVANCE(2461);
      if (lookahead == '\\') ADVANCE(924);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(2519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n') ADVANCE(2500);
      END_STATE();
    case 270:
      if (lookahead == '\\') ADVANCE(2345);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != ' ') ADVANCE(2531);
      END_STATE();
    case 271:
      if (lookahead == '\\') ADVANCE(922);
      if (lookahead == ']') ADVANCE(2462);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(2499);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n') ADVANCE(2498);
      END_STATE();
    case 272:
      if (lookahead == '\\') ADVANCE(922);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(272);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(919);
      END_STATE();
    case 273:
      if (lookahead == '\\') ADVANCE(930);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(272);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(933);
      END_STATE();
    case 274:
      if (lookahead == 'a') ADVANCE(563);
      END_STATE();
    case 275:
      if (lookahead == 'a') ADVANCE(623);
      if (lookahead == 'i') ADVANCE(517);
      END_STATE();
    case 276:
      if (lookahead == 'a') ADVANCE(310);
      if (lookahead == 'i') ADVANCE(530);
      END_STATE();
    case 277:
      if (lookahead == 'a') ADVANCE(488);
      END_STATE();
    case 278:
      if (lookahead == 'a') ADVANCE(488);
      if (lookahead == 'e') ADVANCE(648);
      END_STATE();
    case 279:
      if (lookahead == 'a') ADVANCE(507);
      if (lookahead == 'u') ADVANCE(409);
      END_STATE();
    case 280:
      if (lookahead == 'a') ADVANCE(876);
      END_STATE();
    case 281:
      if (lookahead == 'a') ADVANCE(651);
      END_STATE();
    case 282:
      if (lookahead == 'a') ADVANCE(631);
      END_STATE();
    case 283:
      if (lookahead == 'a') ADVANCE(578);
      END_STATE();
    case 284:
      if (lookahead == 'a') ADVANCE(509);
      if (lookahead == 'e') ADVANCE(420);
      END_STATE();
    case 285:
      if (lookahead == 'a') ADVANCE(579);
      if (lookahead == 'o') ADVANCE(547);
      END_STATE();
    case 286:
      if (lookahead == 'a') ADVANCE(435);
      if (lookahead == 'e') ADVANCE(577);
      if (lookahead == 'r') ADVANCE(287);
      END_STATE();
    case 287:
      if (lookahead == 'a') ADVANCE(508);
      END_STATE();
    case 288:
      if (lookahead == 'a') ADVANCE(569);
      END_STATE();
    case 289:
      if (lookahead == 'a') ADVANCE(463);
      END_STATE();
    case 290:
      if (lookahead == 'a') ADVANCE(495);
      END_STATE();
    case 291:
      if (lookahead == 'a') ADVANCE(498);
      END_STATE();
    case 292:
      if (lookahead == 'a') ADVANCE(500);
      END_STATE();
    case 293:
      if (lookahead == 'a') ADVANCE(589);
      END_STATE();
    case 294:
      if (lookahead == 'a') ADVANCE(450);
      END_STATE();
    case 295:
      if (lookahead == 'a') ADVANCE(469);
      END_STATE();
    case 296:
      if (lookahead == 'a') ADVANCE(447);
      END_STATE();
    case 297:
      if (lookahead == 'b') ADVANCE(629);
      if (lookahead == 'f') ADVANCE(431);
      if (lookahead == 'g') ADVANCE(575);
      if (lookahead == 'l') ADVANCE(453);
      if (lookahead == 'n') ADVANCE(277);
      if (lookahead == 'p') ADVANCE(585);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(297);
      END_STATE();
    case 298:
      if (lookahead == 'b') ADVANCE(629);
      if (lookahead == 'f') ADVANCE(431);
      if (lookahead == 'g') ADVANCE(575);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(298);
      END_STATE();
    case 299:
      if (lookahead == 'b') ADVANCE(344);
      END_STATE();
    case 300:
      if (lookahead == 'b') ADVANCE(470);
      if (lookahead == 'c') ADVANCE(619);
      if (lookahead == 'f') ADVANCE(540);
      if (lookahead == 'g') ADVANCE(630);
      if (lookahead == 's') ADVANCE(607);
      if (lookahead == 't') ADVANCE(365);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(300);
      END_STATE();
    case 301:
      if (lookahead == 'c') ADVANCE(427);
      if (lookahead == 'h') ADVANCE(454);
      if (lookahead == 'o') ADVANCE(504);
      if (lookahead == 'p') ADVANCE(164);
      if (lookahead == 't') ADVANCE(392);
      END_STATE();
    case 302:
      if (lookahead == 'c') ADVANCE(427);
      if (lookahead == 'o') ADVANCE(529);
      if (lookahead == 'u') ADVANCE(472);
      END_STATE();
    case 303:
      if (lookahead == 'c') ADVANCE(149);
      END_STATE();
    case 304:
      if (lookahead == 'c') ADVANCE(877);
      if (lookahead == 'i') ADVANCE(536);
      END_STATE();
    case 305:
      ADVANCE_MAP(
        'c', 3009,
        'd', 3066,
        'e', 3107,
        'f', 3133,
        'k', 3038,
        'm', 2992,
        'n', 3028,
        'o', 3117,
        's', 3084,
        't', 3158,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(305);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3198);
      END_STATE();
    case 306:
      ADVANCE_MAP(
        'c', 3009,
        'd', 3066,
        'e', 3189,
        'f', 3133,
        'k', 3038,
        'm', 2992,
        'n', 3028,
        'o', 3117,
        's', 3082,
        't', 3158,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(306);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3198);
      END_STATE();
    case 307:
      if (lookahead == 'c') ADVANCE(429);
      END_STATE();
    case 308:
      if (lookahead == 'c') ADVANCE(471);
      if (lookahead == 't') ADVANCE(394);
      END_STATE();
    case 309:
      if (lookahead == 'c') ADVANCE(593);
      if (lookahead == 'n') ADVANCE(439);
      if (lookahead == 't') ADVANCE(402);
      END_STATE();
    case 310:
      if (lookahead == 'c') ADVANCE(583);
      if (lookahead == 't') ADVANCE(307);
      if (lookahead == 'x') ADVANCE(481);
      END_STATE();
    case 311:
      if (lookahead == 'c') ADVANCE(543);
      END_STATE();
    case 312:
      if (lookahead == 'c') ADVANCE(539);
      END_STATE();
    case 313:
      if (lookahead == 'c') ADVANCE(539);
      if (lookahead == 'n') ADVANCE(915);
      END_STATE();
    case 314:
      if (lookahead == 'c') ADVANCE(497);
      if (lookahead == 'j') ADVANCE(550);
      if (lookahead == 'k') ADVANCE(571);
      if (lookahead == 't') ADVANCE(642);
      END_STATE();
    case 315:
      if (lookahead == 'c') ADVANCE(590);
      END_STATE();
    case 316:
      if (lookahead == 'c') ADVANCE(374);
      if (lookahead == 't') ADVANCE(296);
      END_STATE();
    case 317:
      if (lookahead == 'c') ADVANCE(503);
      if (lookahead == 'j') ADVANCE(554);
      if (lookahead == 'k') ADVANCE(574);
      if (lookahead == 't') ADVANCE(643);
      END_STATE();
    case 318:
      if (lookahead == 'c') ADVANCE(356);
      END_STATE();
    case 319:
      if (lookahead == 'c') ADVANCE(2072);
      if (lookahead == 'l') ADVANCE(2058);
      if (lookahead == 'm') ADVANCE(2000);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(319);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 320:
      if (lookahead == 'c') ADVANCE(635);
      if (lookahead == 'i') ADVANCE(312);
      if (lookahead == 'l') ADVANCE(459);
      if (lookahead == 'n') ADVANCE(633);
      if (lookahead == 't') ADVANCE(390);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(320);
      END_STATE();
    case 321:
      if (lookahead == 'c') ADVANCE(396);
      if (lookahead == 't') ADVANCE(296);
      END_STATE();
    case 322:
      if (lookahead == 'c') ADVANCE(592);
      if (lookahead == 'i') ADVANCE(480);
      END_STATE();
    case 323:
      if (lookahead == 'd') ADVANCE(3367);
      END_STATE();
    case 324:
      if (lookahead == 'd') ADVANCE(3424);
      END_STATE();
    case 325:
      if (lookahead == 'd') ADVANCE(3343);
      END_STATE();
    case 326:
      if (lookahead == 'd') ADVANCE(3276);
      END_STATE();
    case 327:
      if (lookahead == 'd') ADVANCE(3349);
      END_STATE();
    case 328:
      if (lookahead == 'd') ADVANCE(3352);
      END_STATE();
    case 329:
      if (lookahead == 'd') ADVANCE(3309);
      END_STATE();
    case 330:
      if (lookahead == 'd') ADVANCE(2963);
      END_STATE();
    case 331:
      if (lookahead == 'd') ADVANCE(323);
      END_STATE();
    case 332:
      if (lookahead == 'd') ADVANCE(323);
      if (lookahead == 'n') ADVANCE(603);
      END_STATE();
    case 333:
      if (lookahead == 'd') ADVANCE(334);
      END_STATE();
    case 334:
      if (lookahead == 'd') ADVANCE(568);
      END_STATE();
    case 335:
      if (lookahead == 'd') ADVANCE(598);
      END_STATE();
    case 336:
      if (lookahead == 'd') ADVANCE(393);
      END_STATE();
    case 337:
      if (lookahead == 'd') ADVANCE(351);
      END_STATE();
    case 338:
      if (lookahead == 'e') ADVANCE(648);
      if (lookahead == 'u') ADVANCE(490);
      END_STATE();
    case 339:
      if (lookahead == 'e') ADVANCE(2413);
      END_STATE();
    case 340:
      if (lookahead == 'e') ADVANCE(2403);
      END_STATE();
    case 341:
      if (lookahead == 'e') ADVANCE(2405);
      END_STATE();
    case 342:
      if (lookahead == 'e') ADVANCE(2974);
      END_STATE();
    case 343:
      if (lookahead == 'e') ADVANCE(3369);
      END_STATE();
    case 344:
      if (lookahead == 'e') ADVANCE(882);
      END_STATE();
    case 345:
      if (lookahead == 'e') ADVANCE(878);
      END_STATE();
    case 346:
      if (lookahead == 'e') ADVANCE(3361);
      END_STATE();
    case 347:
      if (lookahead == 'e') ADVANCE(869);
      END_STATE();
    case 348:
      if (lookahead == 'e') ADVANCE(883);
      END_STATE();
    case 349:
      if (lookahead == 'e') ADVANCE(884);
      END_STATE();
    case 350:
      if (lookahead == 'e') ADVANCE(873);
      END_STATE();
    case 351:
      if (lookahead == 'e') ADVANCE(881);
      END_STATE();
    case 352:
      if (lookahead == 'e') ADVANCE(871);
      END_STATE();
    case 353:
      if (lookahead == 'e') ADVANCE(886);
      END_STATE();
    case 354:
      if (lookahead == 'e') ADVANCE(2973);
      END_STATE();
    case 355:
      if (lookahead == 'e') ADVANCE(3325);
      END_STATE();
    case 356:
      if (lookahead == 'e') ADVANCE(2962);
      END_STATE();
    case 357:
      if (lookahead == 'e') ADVANCE(895);
      END_STATE();
    case 358:
      if (lookahead == 'e') ADVANCE(900);
      END_STATE();
    case 359:
      if (lookahead == 'e') ADVANCE(901);
      END_STATE();
    case 360:
      if (lookahead == 'e') ADVANCE(899);
      END_STATE();
    case 361:
      if (lookahead == 'e') ADVANCE(897);
      END_STATE();
    case 362:
      if (lookahead == 'e') ADVANCE(903);
      END_STATE();
    case 363:
      if (lookahead == 'e') ADVANCE(3435);
      END_STATE();
    case 364:
      if (lookahead == 'e') ADVANCE(3436);
      END_STATE();
    case 365:
      if (lookahead == 'e') ADVANCE(577);
      END_STATE();
    case 366:
      if (lookahead == 'e') ADVANCE(404);
      if (lookahead == 'i') ADVANCE(600);
      END_STATE();
    case 367:
      if (lookahead == 'e') ADVANCE(486);
      END_STATE();
    case 368:
      if (lookahead == 'e') ADVANCE(565);
      END_STATE();
    case 369:
      if (lookahead == 'e') ADVANCE(513);
      END_STATE();
    case 370:
      if (lookahead == 'e') ADVANCE(368);
      END_STATE();
    case 371:
      if (lookahead == 'e') ADVANCE(368);
      if (lookahead == 'o') ADVANCE(434);
      END_STATE();
    case 372:
      if (lookahead == 'e') ADVANCE(280);
      END_STATE();
    case 373:
      if (lookahead == 'e') ADVANCE(489);
      if (lookahead == 'n') ADVANCE(462);
      if (lookahead == 'w') ADVANCE(422);
      END_STATE();
    case 374:
      if (lookahead == 'e') ADVANCE(289);
      END_STATE();
    case 375:
      if (lookahead == 'e') ADVANCE(376);
      END_STATE();
    case 376:
      if (lookahead == 'e') ADVANCE(557);
      END_STATE();
    case 377:
      if (lookahead == 'e') ADVANCE(570);
      END_STATE();
    case 378:
      if (lookahead == 'e') ADVANCE(604);
      END_STATE();
    case 379:
      if (lookahead == 'e') ADVANCE(250);
      END_STATE();
    case 380:
      if (lookahead == 'e') ADVANCE(329);
      if (lookahead == 's') ADVANCE(3340);
      END_STATE();
    case 381:
      if (lookahead == 'e') ADVANCE(596);
      END_STATE();
    case 382:
      if (lookahead == 'e') ADVANCE(597);
      END_STATE();
    case 383:
      if (lookahead == 'e') ADVANCE(572);
      END_STATE();
    case 384:
      if (lookahead == 'e') ADVANCE(330);
      END_STATE();
    case 385:
      if (lookahead == 'e') ADVANCE(519);
      END_STATE();
    case 386:
      if (lookahead == 'e') ADVANCE(573);
      END_STATE();
    case 387:
      if (lookahead == 'e') ADVANCE(586);
      END_STATE();
    case 388:
      if (lookahead == 'e') ADVANCE(582);
      END_STATE();
    case 389:
      if (lookahead == 'e') ADVANCE(522);
      END_STATE();
    case 390:
      if (lookahead == 'e') ADVANCE(649);
      END_STATE();
    case 391:
      if (lookahead == 'e') ADVANCE(649);
      if (lookahead == 'r') ADVANCE(287);
      END_STATE();
    case 392:
      if (lookahead == 'e') ADVANCE(580);
      END_STATE();
    case 393:
      if (lookahead == 'e') ADVANCE(515);
      END_STATE();
    case 394:
      if (lookahead == 'e') ADVANCE(514);
      END_STATE();
    case 395:
      if (lookahead == 'e') ADVANCE(626);
      END_STATE();
    case 396:
      if (lookahead == 'e') ADVANCE(295);
      END_STATE();
    case 397:
      if (lookahead == 'e') ADVANCE(606);
      END_STATE();
    case 398:
      if (lookahead == 'e') ADVANCE(587);
      END_STATE();
    case 399:
      if (lookahead == 'e') ADVANCE(425);
      END_STATE();
    case 400:
      if (lookahead == 'e') ADVANCE(516);
      END_STATE();
    case 401:
      if (lookahead == 'e') ADVANCE(483);
      END_STATE();
    case 402:
      if (lookahead == 'f') ADVANCE(151);
      END_STATE();
    case 403:
      if (lookahead == 'f') ADVANCE(2051);
      if (lookahead == 's') ADVANCE(2144);
      if (lookahead == 'u') ADVANCE(2117);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(660);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(2969);
      if (lookahead == '*' ||
          lookahead == '+' ||
          lookahead == '?') ADVANCE(2970);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 404:
      if (lookahead == 'f') ADVANCE(282);
      END_STATE();
    case 405:
      if (lookahead == 'f') ADVANCE(406);
      END_STATE();
    case 406:
      if (lookahead == 'f') ADVANCE(377);
      END_STATE();
    case 407:
      if (lookahead == 'f') ADVANCE(383);
      END_STATE();
    case 408:
      if (lookahead == 'f') ADVANCE(388);
      END_STATE();
    case 409:
      if (lookahead == 'f') ADVANCE(407);
      END_STATE();
    case 410:
      if (lookahead == 'f') ADVANCE(408);
      END_STATE();
    case 411:
      if (lookahead == 'g') ADVANCE(178);
      END_STATE();
    case 412:
      if (lookahead == 'g') ADVANCE(2977);
      END_STATE();
    case 413:
      if (lookahead == 'g') ADVANCE(3266);
      END_STATE();
    case 414:
      if (lookahead == 'g') ADVANCE(3264);
      END_STATE();
    case 415:
      if (lookahead == 'g') ADVANCE(3252);
      END_STATE();
    case 416:
      if (lookahead == 'g') ADVANCE(3250);
      END_STATE();
    case 417:
      if (lookahead == 'g') ADVANCE(595);
      END_STATE();
    case 418:
      if (lookahead == 'g') ADVANCE(588);
      END_STATE();
    case 419:
      if (lookahead == 'g') ADVANCE(342);
      END_STATE();
    case 420:
      if (lookahead == 'g') ADVANCE(444);
      END_STATE();
    case 421:
      if (lookahead == 'g') ADVANCE(591);
      END_STATE();
    case 422:
      if (lookahead == 'h') ADVANCE(455);
      END_STATE();
    case 423:
      if (lookahead == 'h') ADVANCE(465);
      END_STATE();
    case 424:
      if (lookahead == 'h') ADVANCE(466);
      END_STATE();
    case 425:
      if (lookahead == 'h') ADVANCE(467);
      END_STATE();
    case 426:
      if (lookahead == 'h') ADVANCE(387);
      if (lookahead == 't') ADVANCE(428);
      END_STATE();
    case 427:
      if (lookahead == 'h') ADVANCE(288);
      END_STATE();
    case 428:
      if (lookahead == 'h') ADVANCE(398);
      END_STATE();
    case 429:
      if (lookahead == 'h') ADVANCE(421);
      END_STATE();
    case 430:
      if (lookahead == 'i') ADVANCE(411);
      if (lookahead == 'l') ADVANCE(369);
      if (lookahead == 'u') ADVANCE(405);
      END_STATE();
    case 431:
      if (lookahead == 'i') ADVANCE(477);
      END_STATE();
    case 432:
      if (lookahead == 'i') ADVANCE(477);
      if (lookahead == 'o') ADVANCE(474);
      END_STATE();
    case 433:
      if (lookahead == 'i') ADVANCE(3255);
      END_STATE();
    case 434:
      if (lookahead == 'i') ADVANCE(186);
      if (lookahead == 'r') ADVANCE(372);
      END_STATE();
    case 435:
      if (lookahead == 'i') ADVANCE(645);
      END_STATE();
    case 436:
      if (lookahead == 'i') ADVANCE(874);
      END_STATE();
    case 437:
      if (lookahead == 'i') ADVANCE(566);
      END_STATE();
    case 438:
      if (lookahead == 'i') ADVANCE(600);
      END_STATE();
    case 439:
      if (lookahead == 'i') ADVANCE(311);
      END_STATE();
    case 440:
      if (lookahead == 'i') ADVANCE(1551);
      if (lookahead == '{') ADVANCE(996);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(452);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1984);
      END_STATE();
    case 441:
      if (lookahead == 'i') ADVANCE(536);
      END_STATE();
    case 442:
      if (lookahead == 'i') ADVANCE(594);
      END_STATE();
    case 443:
      if (lookahead == 'i') ADVANCE(546);
      END_STATE();
    case 444:
      if (lookahead == 'i') ADVANCE(602);
      END_STATE();
    case 445:
      if (lookahead == 'i') ADVANCE(617);
      END_STATE();
    case 446:
      if (lookahead == 'i') ADVANCE(496);
      END_STATE();
    case 447:
      if (lookahead == 'i') ADVANCE(499);
      END_STATE();
    case 448:
      if (lookahead == 'i') ADVANCE(559);
      END_STATE();
    case 449:
      if (lookahead == 'i') ADVANCE(553);
      END_STATE();
    case 450:
      if (lookahead == 'i') ADVANCE(620);
      END_STATE();
    case 451:
      if (lookahead == 'i') ADVANCE(560);
      END_STATE();
    case 452:
      if (lookahead == 'i') ADVANCE(492);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(452);
      END_STATE();
    case 453:
      if (lookahead == 'i') ADVANCE(517);
      END_STATE();
    case 454:
      if (lookahead == 'i') ADVANCE(520);
      END_STATE();
    case 455:
      if (lookahead == 'i') ADVANCE(627);
      END_STATE();
    case 456:
      if (lookahead == 'i') ADVANCE(523);
      END_STATE();
    case 457:
      if (lookahead == 'i') ADVANCE(524);
      END_STATE();
    case 458:
      if (lookahead == 'i') ADVANCE(525);
      END_STATE();
    case 459:
      if (lookahead == 'i') ADVANCE(528);
      END_STATE();
    case 460:
      if (lookahead == 'j') ADVANCE(442);
      if (lookahead == 'k') ADVANCE(443);
      if (lookahead == 't') ADVANCE(285);
      END_STATE();
    case 461:
      if (lookahead == 'k') ADVANCE(449);
      END_STATE();
    case 462:
      if (lookahead == 'l') ADVANCE(3330);
      END_STATE();
    case 463:
      if (lookahead == 'l') ADVANCE(3295);
      END_STATE();
    case 464:
      if (lookahead == 'l') ADVANCE(3355);
      END_STATE();
    case 465:
      if (lookahead == 'l') ADVANCE(2400);
      END_STATE();
    case 466:
      if (lookahead == 'l') ADVANCE(2391);
      END_STATE();
    case 467:
      if (lookahead == 'l') ADVANCE(2388);
      END_STATE();
    case 468:
      if (lookahead == 'l') ADVANCE(2397);
      END_STATE();
    case 469:
      if (lookahead == 'l') ADVANCE(3292);
      END_STATE();
    case 470:
      if (lookahead == 'l') ADVANCE(369);
      END_STATE();
    case 471:
      if (lookahead == 'l') ADVANCE(632);
      END_STATE();
    case 472:
      if (lookahead == 'l') ADVANCE(423);
      END_STATE();
    case 473:
      if (lookahead == 'l') ADVANCE(325);
      END_STATE();
    case 474:
      if (lookahead == 'l') ADVANCE(325);
      if (lookahead == 'n') ADVANCE(608);
      END_STATE();
    case 475:
      if (lookahead == 'l') ADVANCE(611);
      END_STATE();
    case 476:
      if (lookahead == 'l') ADVANCE(281);
      END_STATE();
    case 477:
      if (lookahead == 'l') ADVANCE(339);
      END_STATE();
    case 478:
      if (lookahead == 'l') ADVANCE(395);
      END_STATE();
    case 479:
      if (lookahead == 'l') ADVANCE(3074);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(479);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3198);
      END_STATE();
    case 480:
      if (lookahead == 'l') ADVANCE(389);
      END_STATE();
    case 481:
      if (lookahead == 'l') ADVANCE(456);
      END_STATE();
    case 482:
      if (lookahead == 'l') ADVANCE(457);
      END_STATE();
    case 483:
      if (lookahead == 'l') ADVANCE(458);
      END_STATE();
    case 484:
      if (lookahead == 'm') ADVANCE(3207);
      END_STATE();
    case 485:
      if (lookahead == 'm') ADVANCE(3210);
      END_STATE();
    case 486:
      if (lookahead == 'm') ADVANCE(534);
      END_STATE();
    case 487:
      if (lookahead == 'm') ADVANCE(562);
      if (lookahead == 'u') ADVANCE(511);
      END_STATE();
    case 488:
      if (lookahead == 'm') ADVANCE(341);
      END_STATE();
    case 489:
      if (lookahead == 'm') ADVANCE(558);
      END_STATE();
    case 490:
      if (lookahead == 'm') ADVANCE(424);
      END_STATE();
    case 491:
      if (lookahead == 'm') ADVANCE(292);
      END_STATE();
    case 492:
      if (lookahead == 'n') ADVANCE(915);
      END_STATE();
    case 493:
      if (lookahead == 'n') ADVANCE(915);
      if (lookahead == 's') ADVANCE(2442);
      END_STATE();
    case 494:
      if (lookahead == 'n') ADVANCE(915);
      if (lookahead == 's') ADVANCE(533);
      END_STATE();
    case 495:
      if (lookahead == 'n') ADVANCE(875);
      END_STATE();
    case 496:
      if (lookahead == 'n') ADVANCE(166);
      END_STATE();
    case 497:
      if (lookahead == 'n') ADVANCE(863);
      END_STATE();
    case 498:
      if (lookahead == 'n') ADVANCE(879);
      END_STATE();
    case 499:
      if (lookahead == 'n') ADVANCE(380);
      END_STATE();
    case 500:
      if (lookahead == 'n') ADVANCE(833);
      END_STATE();
    case 501:
      if (lookahead == 'n') ADVANCE(3310);
      END_STATE();
    case 502:
      if (lookahead == 'n') ADVANCE(2385);
      END_STATE();
    case 503:
      if (lookahead == 'n') ADVANCE(891);
      END_STATE();
    case 504:
      if (lookahead == 'n') ADVANCE(316);
      END_STATE();
    case 505:
      if (lookahead == 'n') ADVANCE(608);
      END_STATE();
    case 506:
      if (lookahead == 'n') ADVANCE(324);
      if (lookahead == 'u') ADVANCE(303);
      if (lookahead == 'x') ADVANCE(308);
      END_STATE();
    case 507:
      if (lookahead == 'n') ADVANCE(412);
      if (lookahead == 'r') ADVANCE(2978);
      END_STATE();
    case 508:
      if (lookahead == 'n') ADVANCE(605);
      END_STATE();
    case 509:
      if (lookahead == 'n') ADVANCE(419);
      END_STATE();
    case 510:
      if (lookahead == 'n') ADVANCE(318);
      END_STATE();
    case 511:
      if (lookahead == 'n') ADVANCE(610);
      END_STATE();
    case 512:
      if (lookahead == 'n') ADVANCE(401);
      END_STATE();
    case 513:
      if (lookahead == 'n') ADVANCE(326);
      END_STATE();
    case 514:
      if (lookahead == 'n') ADVANCE(327);
      END_STATE();
    case 515:
      if (lookahead == 'n') ADVANCE(464);
      END_STATE();
    case 516:
      if (lookahead == 'n') ADVANCE(328);
      END_STATE();
    case 517:
      if (lookahead == 'n') ADVANCE(340);
      END_STATE();
    case 518:
      if (lookahead == 'n') ADVANCE(335);
      END_STATE();
    case 519:
      if (lookahead == 'n') ADVANCE(613);
      END_STATE();
    case 520:
      if (lookahead == 'n') ADVANCE(378);
      END_STATE();
    case 521:
      if (lookahead == 'n') ADVANCE(437);
      END_STATE();
    case 522:
      if (lookahead == 'n') ADVANCE(624);
      END_STATE();
    case 523:
      if (lookahead == 'n') ADVANCE(381);
      END_STATE();
    case 524:
      if (lookahead == 'n') ADVANCE(382);
      END_STATE();
    case 525:
      if (lookahead == 'n') ADVANCE(346);
      END_STATE();
    case 526:
      if (lookahead == 'n') ADVANCE(397);
      END_STATE();
    case 527:
      if (lookahead == 'n') ADVANCE(397);
      if (lookahead == 'o') ADVANCE(510);
      END_STATE();
    case 528:
      if (lookahead == 'n') ADVANCE(399);
      END_STATE();
    case 529:
      if (lookahead == 'n') ADVANCE(321);
      END_STATE();
    case 530:
      if (lookahead == 'n') ADVANCE(482);
      END_STATE();
    case 531:
      if (lookahead == 'o') ADVANCE(487);
      END_STATE();
    case 532:
      if (lookahead == 'o') ADVANCE(634);
      END_STATE();
    case 533:
      if (lookahead == 'o') ADVANCE(831);
      END_STATE();
    case 534:
      if (lookahead == 'o') ADVANCE(641);
      END_STATE();
    case 535:
      if (lookahead == 'o') ADVANCE(491);
      END_STATE();
    case 536:
      if (lookahead == 'o') ADVANCE(584);
      END_STATE();
    case 537:
      if (lookahead == 'o') ADVANCE(473);
      END_STATE();
    case 538:
      if (lookahead == 'o') ADVANCE(616);
      END_STATE();
    case 539:
      if (lookahead == 'o') ADVANCE(502);
      END_STATE();
    case 540:
      if (lookahead == 'o') ADVANCE(505);
      END_STATE();
    case 541:
      if (lookahead == 'o') ADVANCE(636);
      END_STATE();
    case 542:
      if (lookahead == 'o') ADVANCE(644);
      END_STATE();
    case 543:
      if (lookahead == 'o') ADVANCE(337);
      END_STATE();
    case 544:
      if (lookahead == 'o') ADVANCE(637);
      END_STATE();
    case 545:
      if (lookahead == 'o') ADVANCE(638);
      END_STATE();
    case 546:
      if (lookahead == 'p') ADVANCE(3423);
      END_STATE();
    case 547:
      if (lookahead == 'p') ADVANCE(3246);
      END_STATE();
    case 548:
      if (lookahead == 'p') ADVANCE(2409);
      END_STATE();
    case 549:
      if (lookahead == 'p') ADVANCE(3268);
      END_STATE();
    case 550:
      if (lookahead == 'p') ADVANCE(858);
      END_STATE();
    case 551:
      if (lookahead == 'p') ADVANCE(3315);
      END_STATE();
    case 552:
      if (lookahead == 'p') ADVANCE(3358);
      END_STATE();
    case 553:
      if (lookahead == 'p') ADVANCE(373);
      END_STATE();
    case 554:
      if (lookahead == 'p') ADVANCE(889);
      END_STATE();
    case 555:
      if (lookahead == 'p') ADVANCE(426);
      END_STATE();
    case 556:
      if (lookahead == 'p') ADVANCE(476);
      END_STATE();
    case 557:
      if (lookahead == 'p') ADVANCE(601);
      END_STATE();
    case 558:
      if (lookahead == 'p') ADVANCE(618);
      END_STATE();
    case 559:
      if (lookahead == 'p') ADVANCE(612);
      END_STATE();
    case 560:
      if (lookahead == 'p') ADVANCE(621);
      END_STATE();
    case 561:
      if (lookahead == 'p') ADVANCE(581);
      END_STATE();
    case 562:
      if (lookahead == 'p') ADVANCE(478);
      END_STATE();
    case 563:
      if (lookahead == 'p') ADVANCE(290);
      END_STATE();
    case 564:
      if (lookahead == 'p') ADVANCE(293);
      END_STATE();
    case 565:
      if (lookahead == 'p') ADVANCE(400);
      END_STATE();
    case 566:
      if (lookahead == 'q') ADVANCE(639);
      END_STATE();
    case 567:
      if (lookahead == 'r') ADVANCE(304);
      END_STATE();
    case 568:
      if (lookahead == 'r') ADVANCE(2976);
      END_STATE();
    case 569:
      if (lookahead == 'r') ADVANCE(3300);
      END_STATE();
    case 570:
      if (lookahead == 'r') ADVANCE(2407);
      END_STATE();
    case 571:
      if (lookahead == 'r') ADVANCE(861);
      END_STATE();
    case 572:
      if (lookahead == 'r') ADVANCE(2980);
      END_STATE();
    case 573:
      if (lookahead == 'r') ADVANCE(2979);
      END_STATE();
    case 574:
      if (lookahead == 'r') ADVANCE(890);
      END_STATE();
    case 575:
      if (lookahead == 'r') ADVANCE(532);
      END_STATE();
    case 576:
      if (lookahead == 'r') ADVANCE(532);
      if (lookahead == 'u') ADVANCE(433);
      END_STATE();
    case 577:
      if (lookahead == 'r') ADVANCE(484);
      END_STATE();
    case 578:
      if (lookahead == 'r') ADVANCE(417);
      END_STATE();
    case 579:
      if (lookahead == 'r') ADVANCE(609);
      END_STATE();
    case 580:
      if (lookahead == 'r') ADVANCE(485);
      END_STATE();
    case 581:
      if (lookahead == 'r') ADVANCE(245);
      END_STATE();
    case 582:
      if (lookahead == 'r') ADVANCE(246);
      END_STATE();
    case 583:
      if (lookahead == 'r') ADVANCE(535);
      END_STATE();
    case 584:
      if (lookahead == 'r') ADVANCE(445);
      END_STATE();
    case 585:
      if (lookahead == 'r') ADVANCE(441);
      END_STATE();
    case 586:
      if (lookahead == 'r') ADVANCE(363);
      END_STATE();
    case 587:
      if (lookahead == 'r') ADVANCE(364);
      END_STATE();
    case 588:
      if (lookahead == 'r') ADVANCE(541);
      END_STATE();
    case 589:
      if (lookahead == 'r') ADVANCE(385);
      END_STATE();
    case 590:
      if (lookahead == 'r') ADVANCE(448);
      END_STATE();
    case 591:
      if (lookahead == 'r') ADVANCE(544);
      END_STATE();
    case 592:
      if (lookahead == 'r') ADVANCE(451);
      END_STATE();
    case 593:
      if (lookahead == 's') ADVANCE(150);
      END_STATE();
    case 594:
      if (lookahead == 's') ADVANCE(859);
      END_STATE();
    case 595:
      if (lookahead == 's') ADVANCE(2972);
      END_STATE();
    case 596:
      if (lookahead == 's') ADVANCE(3430);
      END_STATE();
    case 597:
      if (lookahead == 's') ADVANCE(3427);
      END_STATE();
    case 598:
      if (lookahead == 's') ADVANCE(3364);
      END_STATE();
    case 599:
      if (lookahead == 's') ADVANCE(2442);
      END_STATE();
    case 600:
      if (lookahead == 's') ADVANCE(556);
      END_STATE();
    case 601:
      if (lookahead == 's') ADVANCE(315);
      END_STATE();
    case 602:
      if (lookahead == 's') ADVANCE(625);
      END_STATE();
    case 603:
      if (lookahead == 's') ADVANCE(436);
      END_STATE();
    case 604:
      if (lookahead == 's') ADVANCE(345);
      END_STATE();
    case 605:
      if (lookahead == 's') ADVANCE(564);
      END_STATE();
    case 606:
      if (lookahead == 's') ADVANCE(628);
      END_STATE();
    case 607:
      if (lookahead == 't') ADVANCE(285);
      END_STATE();
    case 608:
      if (lookahead == 't') ADVANCE(3274);
      END_STATE();
    case 609:
      if (lookahead == 't') ADVANCE(3242);
      END_STATE();
    case 610:
      if (lookahead == 't') ADVANCE(2975);
      END_STATE();
    case 611:
      if (lookahead == 't') ADVANCE(887);
      END_STATE();
    case 612:
      if (lookahead == 't') ADVANCE(2981);
      END_STATE();
    case 613:
      if (lookahead == 't') ADVANCE(3320);
      END_STATE();
    case 614:
      if (lookahead == 't') ADVANCE(2395);
      END_STATE();
    case 615:
      if (lookahead == 't') ADVANCE(2160);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(615);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(2163);
      END_STATE();
    case 616:
      if (lookahead == 't') ADVANCE(2443);
      END_STATE();
    case 617:
      if (lookahead == 't') ADVANCE(652);
      END_STATE();
    case 618:
      if (lookahead == 't') ADVANCE(653);
      END_STATE();
    case 619:
      if (lookahead == 't') ADVANCE(392);
      END_STATE();
    case 620:
      if (lookahead == 't') ADVANCE(247);
      END_STATE();
    case 621:
      if (lookahead == 't') ADVANCE(248);
      END_STATE();
    case 622:
      if (lookahead == 't') ADVANCE(418);
      END_STATE();
    case 623:
      if (lookahead == 't') ADVANCE(446);
      END_STATE();
    case 624:
      if (lookahead == 't') ADVANCE(249);
      END_STATE();
    case 625:
      if (lookahead == 't') ADVANCE(386);
      END_STATE();
    case 626:
      if (lookahead == 't') ADVANCE(354);
      END_STATE();
    case 627:
      if (lookahead == 't') ADVANCE(355);
      END_STATE();
    case 628:
      if (lookahead == 't') ADVANCE(384);
      END_STATE();
    case 629:
      if (lookahead == 'u') ADVANCE(405);
      END_STATE();
    case 630:
      if (lookahead == 'u') ADVANCE(433);
      END_STATE();
    case 631:
      if (lookahead == 'u') ADVANCE(475);
      END_STATE();
    case 632:
      if (lookahead == 'u') ADVANCE(336);
      END_STATE();
    case 633:
      if (lookahead == 'u') ADVANCE(490);
      END_STATE();
    case 634:
      if (lookahead == 'u') ADVANCE(548);
      END_STATE();
    case 635:
      if (lookahead == 'u') ADVANCE(472);
      END_STATE();
    case 636:
      if (lookahead == 'u') ADVANCE(551);
      END_STATE();
    case 637:
      if (lookahead == 'u') ADVANCE(552);
      END_STATE();
    case 638:
      if (lookahead == 'u') ADVANCE(555);
      END_STATE();
    case 639:
      if (lookahead == 'u') ADVANCE(379);
      END_STATE();
    case 640:
      if (lookahead == 'u') ADVANCE(410);
      END_STATE();
    case 641:
      if (lookahead == 'v') ADVANCE(343);
      END_STATE();
    case 642:
      if (lookahead == 'w') ADVANCE(866);
      END_STATE();
    case 643:
      if (lookahead == 'w') ADVANCE(892);
      END_STATE();
    case 644:
      if (lookahead == 'w') ADVANCE(294);
      END_STATE();
    case 645:
      if (lookahead == 'w') ADVANCE(291);
      END_STATE();
    case 646:
      if (lookahead == 'x') ADVANCE(308);
      END_STATE();
    case 647:
      if (lookahead == 'x') ADVANCE(481);
      END_STATE();
    case 648:
      if (lookahead == 'x') ADVANCE(622);
      END_STATE();
    case 649:
      if (lookahead == 'x') ADVANCE(614);
      END_STATE();
    case 650:
      if (lookahead == 'x') ADVANCE(561);
      END_STATE();
    case 651:
      if (lookahead == 'y') ADVANCE(3346);
      END_STATE();
    case 652:
      if (lookahead == 'y') ADVANCE(2411);
      END_STATE();
    case 653:
      if (lookahead == 'y') ADVANCE(3335);
      END_STATE();
    case 654:
      if (lookahead == '{') ADVANCE(2529);
      END_STATE();
    case 655:
      if (lookahead == '{') ADVANCE(994);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(655);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(1482);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1194);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1209);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1300);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1210);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(1486);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1306);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1434);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(1123);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1376);
      if (lookahead == 'Q' ||
          lookahead == 'q') ADVANCE(1489);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1109);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1110);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1006);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1211);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(1212);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1224);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 656:
      if (lookahead == '{') ADVANCE(997);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(661);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(1956);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1731);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1742);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1813);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1743);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(1957);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1818);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1920);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(1668);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1875);
      if (lookahead == 'Q' ||
          lookahead == 'q') ADVANCE(1959);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1656);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1657);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1578);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1744);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(1745);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1753);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 657:
      if (lookahead == '|') ADVANCE(2350);
      END_STATE();
    case 658:
      if (lookahead == '|') ADVANCE(2420);
      END_STATE();
    case 659:
      if (lookahead == '}') ADVANCE(2497);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(659);
      END_STATE();
    case 660:
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(660);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 661:
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(661);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2936);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2709);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2720);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(2791);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2721);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(2937);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(2796);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2900);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(2644);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2853);
      if (lookahead == 'Q' ||
          lookahead == 'q') ADVANCE(2939);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2634);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2635);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(2554);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(2722);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(2723);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2731);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 662:
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(662);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(2192);
      END_STATE();
    case 663:
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(2347);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2348);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n') ADVANCE(2347);
      END_STATE();
    case 664:
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(664);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(826);
      END_STATE();
    case 665:
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(932);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n') ADVANCE(931);
      END_STATE();
    case 666:
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(666);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2165);
      END_STATE();
    case 667:
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(667);
      if (('<' <= lookahead && lookahead <= '>') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(908);
      END_STATE();
    case 668:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(795);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2452);
      END_STATE();
    case 669:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2316);
      END_STATE();
    case 670:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(760);
      END_STATE();
    case 671:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(709);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(782);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(718);
      END_STATE();
    case 672:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(769);
      END_STATE();
    case 673:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(683);
      END_STATE();
    case 674:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(688);
      END_STATE();
    case 675:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(688);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(771);
      END_STATE();
    case 676:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(729);
      END_STATE();
    case 677:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(725);
      END_STATE();
    case 678:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(759);
      END_STATE();
    case 679:
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(678);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(755);
      END_STATE();
    case 680:
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2244);
      END_STATE();
    case 681:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2254);
      END_STATE();
    case 682:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(676);
      END_STATE();
    case 683:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(697);
      END_STATE();
    case 684:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2300);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(700);
      END_STATE();
    case 685:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2323);
      END_STATE();
    case 686:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(244);
      END_STATE();
    case 687:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(744);
      END_STATE();
    case 688:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(703);
      END_STATE();
    case 689:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(699);
      END_STATE();
    case 690:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(748);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(753);
      END_STATE();
    case 691:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(705);
      END_STATE();
    case 692:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(2286);
      END_STATE();
    case 693:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(2288);
      END_STATE();
    case 694:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(722);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(787);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(788);
      END_STATE();
    case 695:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(2298);
      END_STATE();
    case 696:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(690);
      END_STATE();
    case 697:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(2256);
      END_STATE();
    case 698:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(2270);
      END_STATE();
    case 699:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(2312);
      END_STATE();
    case 700:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(757);
      END_STATE();
    case 701:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(674);
      END_STATE();
    case 702:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(762);
      END_STATE();
    case 703:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(758);
      END_STATE();
    case 704:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(706);
      END_STATE();
    case 705:
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(771);
      END_STATE();
    case 706:
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(773);
      END_STATE();
    case 707:
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(2325);
      END_STATE();
    case 708:
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(712);
      END_STATE();
    case 709:
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(696);
      END_STATE();
    case 710:
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(713);
      END_STATE();
    case 711:
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(2260);
      END_STATE();
    case 712:
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(772);
      END_STATE();
    case 713:
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(776);
      END_STATE();
    case 714:
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(670);
      END_STATE();
    case 715:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(708);
      END_STATE();
    case 716:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(2266);
      END_STATE();
    case 717:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(741);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(728);
      END_STATE();
    case 718:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(740);
      END_STATE();
    case 719:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(754);
      END_STATE();
    case 720:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(689);
      END_STATE();
    case 721:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(710);
      END_STATE();
    case 722:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2264);
      END_STATE();
    case 723:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2268);
      END_STATE();
    case 724:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2240);
      END_STATE();
    case 725:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2318);
      END_STATE();
    case 726:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(790);
      END_STATE();
    case 727:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(752);
      END_STATE();
    case 728:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(779);
      END_STATE();
    case 729:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(730);
      END_STATE();
    case 730:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(701);
      END_STATE();
    case 731:
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(686);
      END_STATE();
    case 732:
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(733);
      END_STATE();
    case 733:
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(669);
      END_STATE();
    case 734:
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(695);
      END_STATE();
    case 735:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2276);
      END_STATE();
    case 736:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(684);
      if (lookahead == 'Q' ||
          lookahead == 'q') ADVANCE(786);
      END_STATE();
    case 737:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2250);
      END_STATE();
    case 738:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2304);
      END_STATE();
    case 739:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(747);
      END_STATE();
    case 740:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(775);
      END_STATE();
    case 741:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(783);
      END_STATE();
    case 742:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(788);
      END_STATE();
    case 743:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(780);
      END_STATE();
    case 744:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2294);
      END_STATE();
    case 745:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(734);
      END_STATE();
    case 746:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(732);
      END_STATE();
    case 747:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(763);
      END_STATE();
    case 748:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(789);
      END_STATE();
    case 749:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(785);
      END_STATE();
    case 750:
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2274);
      END_STATE();
    case 751:
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2272);
      END_STATE();
    case 752:
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2292);
      END_STATE();
    case 753:
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2302);
      END_STATE();
    case 754:
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(726);
      END_STATE();
    case 755:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(242);
      END_STATE();
    case 756:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2262);
      END_STATE();
    case 757:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2252);
      END_STATE();
    case 758:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2321);
      END_STATE();
    case 759:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(243);
      END_STATE();
    case 760:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(153);
      END_STATE();
    case 761:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(737);
      END_STATE();
    case 762:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(774);
      END_STATE();
    case 763:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(698);
      END_STATE();
    case 764:
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2306);
      END_STATE();
    case 765:
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2308);
      END_STATE();
    case 766:
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(692);
      END_STATE();
    case 767:
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(716);
      END_STATE();
    case 768:
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(693);
      END_STATE();
    case 769:
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(711);
      END_STATE();
    case 770:
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(702);
      END_STATE();
    case 771:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(2279);
      END_STATE();
    case 772:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(2283);
      END_STATE();
    case 773:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(2278);
      END_STATE();
    case 774:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(2296);
      END_STATE();
    case 775:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(2314);
      END_STATE();
    case 776:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(2282);
      END_STATE();
    case 777:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(152);
      END_STATE();
    case 778:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(784);
      END_STATE();
    case 779:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(719);
      END_STATE();
    case 780:
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(766);
      END_STATE();
    case 781:
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(707);
      END_STATE();
    case 782:
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(764);
      END_STATE();
    case 783:
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(765);
      END_STATE();
    case 784:
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(761);
      END_STATE();
    case 785:
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(768);
      END_STATE();
    case 786:
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(677);
      END_STATE();
    case 787:
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(720);
      END_STATE();
    case 788:
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(735);
      END_STATE();
    case 789:
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(738);
      END_STATE();
    case 790:
      if (lookahead == 'Y' ||
          lookahead == 'y') ADVANCE(2310);
      END_STATE();
    case 791:
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(2457);
      END_STATE();
    case 792:
      if (lookahead == '!' ||
          lookahead == '=' ||
          lookahead == '>') ADVANCE(2496);
      END_STATE();
    case 793:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2291);
      END_STATE();
    case 794:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2451);
      END_STATE();
    case 795:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2452);
      END_STATE();
    case 796:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(992);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      END_STATE();
    case 797:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(3372);
      END_STATE();
    case 798:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(2460);
      END_STATE();
    case 799:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(2332);
      END_STATE();
    case 800:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(3259);
      END_STATE();
    case 801:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(800);
      END_STATE();
    case 802:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(801);
      END_STATE();
    case 803:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(802);
      END_STATE();
    case 804:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(803);
      END_STATE();
    case 805:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(804);
      END_STATE();
    case 806:
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(827);
      END_STATE();
    case 807:
      if (lookahead == '"' ||
          lookahead == '#' ||
          lookahead == '%' ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('.' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2527);
      END_STATE();
    case 808:
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'') ADVANCE(3257);
      END_STATE();
    case 809:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(2209);
      END_STATE();
    case 810:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(2347);
      END_STATE();
    case 811:
      if (eof) ADVANCE(814);
      ADVANCE_MAP(
        '\n', 914,
        '!', 2449,
        '#', 2418,
        '$', 2227,
        '%', 2210,
        '&', 2169,
        '\'', 3258,
        '(', 2193,
        ')', 2195,
        '*', 2416,
        '+', 2220,
        ',', 2194,
        '-', 2422,
        '.', 2217,
        '/', 2213,
        ':', 815,
        ';', 2212,
        '<', 2339,
        '=', 2149,
        '>', 2431,
        '?', 2173,
        '@', 2196,
        '[', 2461,
        '\\', 928,
        ']', 2462,
        '_', 921,
        '{', 993,
        '|', 919,
        '}', 995,
        '~', 919,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(811);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(919);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(909);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(919);
      END_STATE();
    case 812:
      if (eof) ADVANCE(814);
      ADVANCE_MAP(
        '!', 2166,
        '$', 2227,
        '%', 2210,
        '\'', 809,
        '(', 2463,
        ')', 2195,
        '*', 2416,
        '+', 2224,
        ',', 2194,
        '-', 157,
        '.', 2217,
        '/', 2213,
        '0', 2456,
        ':', 815,
        ';', 2212,
        '<', 679,
        '=', 2174,
        '>', 2338,
        '?', 2173,
        '@', 807,
        '\\', 105,
        ']', 2462,
        'a', 332,
        'b', 430,
        'c', 301,
        'd', 366,
        'e', 506,
        'f', 432,
        'g', 576,
        'i', 494,
        'j', 274,
        'k', 371,
        'l', 275,
        'm', 276,
        'n', 278,
        'o', 512,
        'p', 567,
        'r', 367,
        's', 460,
        't', 286,
        'u', 309,
        '}', 995,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(813);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(2459);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(2964);
      END_STATE();
    case 813:
      if (eof) ADVANCE(814);
      ADVANCE_MAP(
        '$', 2227,
        '%', 2210,
        '\'', 809,
        ')', 2195,
        '*', 2416,
        '+', 2224,
        ',', 2194,
        '-', 157,
        '.', 2217,
        '/', 2213,
        '0', 2456,
        ':', 815,
        ';', 2212,
        '<', 679,
        '?', 2173,
        '@', 807,
        '\\', 105,
        ']', 2462,
        'a', 332,
        'b', 430,
        'c', 301,
        'd', 366,
        'e', 506,
        'f', 432,
        'g', 576,
        'i', 494,
        'j', 274,
        'k', 371,
        'l', 275,
        'm', 276,
        'n', 278,
        'o', 512,
        'p', 567,
        'r', 367,
        's', 460,
        't', 286,
        'u', 309,
        '}', 995,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(813);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(2459);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(2964);
      END_STATE();
    case 814:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 815:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 816:
      ACCEPT_TOKEN(anon_sym_a_COLON);
      END_STATE();
    case 817:
      ACCEPT_TOKEN(aux_sym_normal_statement_token1);
      if (lookahead == '\t') ADVANCE(817);
      if (lookahead == ' ') ADVANCE(817);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n') ADVANCE(818);
      END_STATE();
    case 818:
      ACCEPT_TOKEN(aux_sym_normal_statement_token1);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(818);
      END_STATE();
    case 819:
      ACCEPT_TOKEN(sym_filetype);
      if (lookahead == 'A') ADVANCE(825);
      if (lookahead == '-' ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(826);
      END_STATE();
    case 820:
      ACCEPT_TOKEN(sym_filetype);
      if (lookahead == 'A') ADVANCE(822);
      if (lookahead == '-' ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(826);
      END_STATE();
    case 821:
      ACCEPT_TOKEN(sym_filetype);
      if (lookahead == 'B') ADVANCE(820);
      if (lookahead == '-' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(826);
      END_STATE();
    case 822:
      ACCEPT_TOKEN(sym_filetype);
      if (lookahead == 'C') ADVANCE(823);
      if (lookahead == '-' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(826);
      END_STATE();
    case 823:
      ACCEPT_TOKEN(sym_filetype);
      if (lookahead == 'K') ADVANCE(829);
      if (lookahead == '-' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(826);
      END_STATE();
    case 824:
      ACCEPT_TOKEN(sym_filetype);
      if (lookahead == 'L') ADVANCE(821);
      if (lookahead == '-' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(826);
      END_STATE();
    case 825:
      ACCEPT_TOKEN(sym_filetype);
      if (lookahead == 'L') ADVANCE(824);
      if (lookahead == '-' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(826);
      END_STATE();
    case 826:
      ACCEPT_TOKEN(sym_filetype);
      if (lookahead == '-' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(826);
      END_STATE();
    case 827:
      ACCEPT_TOKEN(aux_sym__filetype_immediate_token1);
      if (lookahead == '-' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(827);
      END_STATE();
    case 828:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 829:
      ACCEPT_TOKEN(anon_sym_FALLBACK);
      if (lookahead == '-' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(826);
      END_STATE();
    case 830:
      ACCEPT_TOKEN(anon_sym_latin1);
      END_STATE();
    case 831:
      ACCEPT_TOKEN(anon_sym_iso);
      END_STATE();
    case 832:
      ACCEPT_TOKEN(anon_sym_koi8);
      END_STATE();
    case 833:
      ACCEPT_TOKEN(anon_sym_macroman);
      END_STATE();
    case 834:
      ACCEPT_TOKEN(anon_sym_cp437);
      END_STATE();
    case 835:
      ACCEPT_TOKEN(anon_sym_cp737);
      END_STATE();
    case 836:
      ACCEPT_TOKEN(anon_sym_cp775);
      END_STATE();
    case 837:
      ACCEPT_TOKEN(anon_sym_cp850);
      END_STATE();
    case 838:
      ACCEPT_TOKEN(anon_sym_cp852);
      END_STATE();
    case 839:
      ACCEPT_TOKEN(anon_sym_cp855);
      END_STATE();
    case 840:
      ACCEPT_TOKEN(anon_sym_cp857);
      END_STATE();
    case 841:
      ACCEPT_TOKEN(anon_sym_cp860);
      END_STATE();
    case 842:
      ACCEPT_TOKEN(anon_sym_cp861);
      END_STATE();
    case 843:
      ACCEPT_TOKEN(anon_sym_cp862);
      END_STATE();
    case 844:
      ACCEPT_TOKEN(anon_sym_cp863);
      END_STATE();
    case 845:
      ACCEPT_TOKEN(anon_sym_cp865);
      END_STATE();
    case 846:
      ACCEPT_TOKEN(anon_sym_cp866);
      END_STATE();
    case 847:
      ACCEPT_TOKEN(anon_sym_cp869);
      END_STATE();
    case 848:
      ACCEPT_TOKEN(anon_sym_cp874);
      END_STATE();
    case 849:
      ACCEPT_TOKEN(anon_sym_cp1250);
      END_STATE();
    case 850:
      ACCEPT_TOKEN(anon_sym_cp1251);
      END_STATE();
    case 851:
      ACCEPT_TOKEN(anon_sym_cp1253);
      END_STATE();
    case 852:
      ACCEPT_TOKEN(anon_sym_cp1254);
      END_STATE();
    case 853:
      ACCEPT_TOKEN(anon_sym_cp1255);
      END_STATE();
    case 854:
      ACCEPT_TOKEN(anon_sym_cp1256);
      END_STATE();
    case 855:
      ACCEPT_TOKEN(anon_sym_cp1257);
      END_STATE();
    case 856:
      ACCEPT_TOKEN(anon_sym_cp1258);
      END_STATE();
    case 857:
      ACCEPT_TOKEN(anon_sym_cp932);
      END_STATE();
    case 858:
      ACCEPT_TOKEN(anon_sym_euc_DASHjp);
      END_STATE();
    case 859:
      ACCEPT_TOKEN(anon_sym_sjis);
      END_STATE();
    case 860:
      ACCEPT_TOKEN(anon_sym_cp949);
      END_STATE();
    case 861:
      ACCEPT_TOKEN(anon_sym_euc_DASHkr);
      END_STATE();
    case 862:
      ACCEPT_TOKEN(anon_sym_cp936);
      END_STATE();
    case 863:
      ACCEPT_TOKEN(anon_sym_euc_DASHcn);
      END_STATE();
    case 864:
      ACCEPT_TOKEN(anon_sym_cp950);
      END_STATE();
    case 865:
      ACCEPT_TOKEN(anon_sym_big5);
      END_STATE();
    case 866:
      ACCEPT_TOKEN(anon_sym_euc_DASHtw);
      END_STATE();
    case 867:
      ACCEPT_TOKEN(anon_sym_utf_DASH8);
      END_STATE();
    case 868:
      ACCEPT_TOKEN(anon_sym_ucs_DASH2);
      if (lookahead == '1') ADVANCE(347);
      if (lookahead == 'b') ADVANCE(348);
      END_STATE();
    case 869:
      ACCEPT_TOKEN(anon_sym_ucs_DASH21e);
      END_STATE();
    case 870:
      ACCEPT_TOKEN(anon_sym_utf_DASH16);
      if (lookahead == 'l') ADVANCE(352);
      END_STATE();
    case 871:
      ACCEPT_TOKEN(anon_sym_utf_DASH16le);
      END_STATE();
    case 872:
      ACCEPT_TOKEN(anon_sym_ucs_DASH4);
      if (lookahead == 'b') ADVANCE(349);
      if (lookahead == 'l') ADVANCE(350);
      END_STATE();
    case 873:
      ACCEPT_TOKEN(anon_sym_ucs_DASH4le);
      END_STATE();
    case 874:
      ACCEPT_TOKEN(anon_sym_ansi);
      END_STATE();
    case 875:
      ACCEPT_TOKEN(anon_sym_japan);
      END_STATE();
    case 876:
      ACCEPT_TOKEN(anon_sym_korea);
      END_STATE();
    case 877:
      ACCEPT_TOKEN(anon_sym_prc);
      END_STATE();
    case 878:
      ACCEPT_TOKEN(anon_sym_chinese);
      END_STATE();
    case 879:
      ACCEPT_TOKEN(anon_sym_taiwan);
      END_STATE();
    case 880:
      ACCEPT_TOKEN(anon_sym_utf8);
      END_STATE();
    case 881:
      ACCEPT_TOKEN(anon_sym_unicode);
      END_STATE();
    case 882:
      ACCEPT_TOKEN(anon_sym_ucs2be);
      END_STATE();
    case 883:
      ACCEPT_TOKEN(anon_sym_ucs_DASH2be);
      END_STATE();
    case 884:
      ACCEPT_TOKEN(anon_sym_ucs_DASH4be);
      END_STATE();
    case 885:
      ACCEPT_TOKEN(anon_sym_utf_DASH32);
      if (lookahead == 'l') ADVANCE(353);
      END_STATE();
    case 886:
      ACCEPT_TOKEN(anon_sym_utf_DASH32le);
      END_STATE();
    case 887:
      ACCEPT_TOKEN(anon_sym_default);
      END_STATE();
    case 888:
      ACCEPT_TOKEN(anon_sym_default);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 889:
      ACCEPT_TOKEN(anon_sym_euc_DASHjp2);
      END_STATE();
    case 890:
      ACCEPT_TOKEN(anon_sym_euc_DASHkr2);
      END_STATE();
    case 891:
      ACCEPT_TOKEN(anon_sym_euc_DASHcn2);
      END_STATE();
    case 892:
      ACCEPT_TOKEN(anon_sym_euc_DASHtw2);
      END_STATE();
    case 893:
      ACCEPT_TOKEN(anon_sym_utf_DASH82);
      END_STATE();
    case 894:
      ACCEPT_TOKEN(anon_sym_ucs_DASH22);
      if (lookahead == '1') ADVANCE(357);
      if (lookahead == 'b') ADVANCE(358);
      END_STATE();
    case 895:
      ACCEPT_TOKEN(anon_sym_ucs_DASH21e2);
      END_STATE();
    case 896:
      ACCEPT_TOKEN(anon_sym_utf_DASH162);
      if (lookahead == 'l') ADVANCE(361);
      END_STATE();
    case 897:
      ACCEPT_TOKEN(anon_sym_utf_DASH16le2);
      END_STATE();
    case 898:
      ACCEPT_TOKEN(anon_sym_ucs_DASH42);
      if (lookahead == 'b') ADVANCE(359);
      if (lookahead == 'l') ADVANCE(360);
      END_STATE();
    case 899:
      ACCEPT_TOKEN(anon_sym_ucs_DASH4le2);
      END_STATE();
    case 900:
      ACCEPT_TOKEN(anon_sym_ucs_DASH2be2);
      END_STATE();
    case 901:
      ACCEPT_TOKEN(anon_sym_ucs_DASH4be2);
      END_STATE();
    case 902:
      ACCEPT_TOKEN(anon_sym_utf_DASH322);
      if (lookahead == 'l') ADVANCE(362);
      END_STATE();
    case 903:
      ACCEPT_TOKEN(anon_sym_utf_DASH32le2);
      END_STATE();
    case 904:
      ACCEPT_TOKEN(anon_sym_START);
      END_STATE();
    case 905:
      ACCEPT_TOKEN(anon_sym_OPT);
      END_STATE();
    case 906:
      ACCEPT_TOKEN(anon_sym_PACK);
      END_STATE();
    case 907:
      ACCEPT_TOKEN(anon_sym_ALL);
      END_STATE();
    case 908:
      ACCEPT_TOKEN(aux_sym_wincmd_statement_token1);
      END_STATE();
    case 909:
      ACCEPT_TOKEN(aux_sym_wincmd_statement_token1);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 910:
      ACCEPT_TOKEN(sym_chunk);
      if (lookahead == '<') ADVANCE(913);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(911);
      END_STATE();
    case 911:
      ACCEPT_TOKEN(sym_chunk);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(911);
      END_STATE();
    case 912:
      ACCEPT_TOKEN(sym__heredoc_line);
      END_STATE();
    case 913:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 914:
      ACCEPT_TOKEN(anon_sym_LF);
      END_STATE();
    case 915:
      ACCEPT_TOKEN(anon_sym_in);
      END_STATE();
    case 916:
      ACCEPT_TOKEN(anon_sym_in);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1984);
      END_STATE();
    case 917:
      ACCEPT_TOKEN(aux_sym__au_pattern_token1);
      if (lookahead == '/') ADVANCE(917);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(156);
      END_STATE();
    case 918:
      ACCEPT_TOKEN(aux_sym__au_pattern_token2);
      if (lookahead == '?') ADVANCE(918);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(251);
      END_STATE();
    case 919:
      ACCEPT_TOKEN(aux_sym__bang_filter_command_argument_token1);
      END_STATE();
    case 920:
      ACCEPT_TOKEN(aux_sym__bang_filter_command_argument_token1);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(678);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(755);
      END_STATE();
    case 921:
      ACCEPT_TOKEN(aux_sym__bang_filter_command_argument_token1);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 922:
      ACCEPT_TOKEN(anon_sym_BSLASH);
      END_STATE();
    case 923:
      ACCEPT_TOKEN(anon_sym_BSLASH);
      ADVANCE_MAP(
        '%', 112,
        '&', 2230,
        '(', 2523,
        ')', 2524,
        '@', 792,
        'z', 113,
        '{', 147,
        '|', 2350,
        '+', 2495,
        '=', 2495,
        '?', 2495,
      );
      END_STATE();
    case 924:
      ACCEPT_TOKEN(anon_sym_BSLASH);
      if (lookahead == '%') ADVANCE(112);
      if (lookahead == '&') ADVANCE(2230);
      if (lookahead == '(') ADVANCE(2523);
      if (lookahead == ')') ADVANCE(2524);
      if (lookahead == 'z') ADVANCE(113);
      if (lookahead == '|') ADVANCE(2350);
      END_STATE();
    case 925:
      ACCEPT_TOKEN(anon_sym_BSLASH);
      ADVANCE_MAP(
        '%', 112,
        '&', 2230,
        '(', 2523,
        '@', 792,
        'z', 113,
        '{', 147,
        '|', 2350,
        '+', 2495,
        '=', 2495,
        '?', 2495,
      );
      END_STATE();
    case 926:
      ACCEPT_TOKEN(anon_sym_BSLASH);
      if (lookahead == '%') ADVANCE(112);
      if (lookahead == '&') ADVANCE(2230);
      if (lookahead == '(') ADVANCE(2523);
      if (lookahead == 'z') ADVANCE(113);
      if (lookahead == '|') ADVANCE(2350);
      END_STATE();
    case 927:
      ACCEPT_TOKEN(anon_sym_BSLASH);
      if (lookahead == '%') ADVANCE(112);
      if (lookahead == '(') ADVANCE(2523);
      if (lookahead == 'z') ADVANCE(113);
      END_STATE();
    case 928:
      ACCEPT_TOKEN(anon_sym_BSLASH);
      if (lookahead == '|') ADVANCE(2350);
      END_STATE();
    case 929:
      ACCEPT_TOKEN(anon_sym_BSLASH);
      if (lookahead == '|') ADVANCE(2350);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(979);
      END_STATE();
    case 930:
      ACCEPT_TOKEN(anon_sym_BSLASH);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(979);
      END_STATE();
    case 931:
      ACCEPT_TOKEN(aux_sym__bang_filter_command_argument_token2);
      END_STATE();
    case 932:
      ACCEPT_TOKEN(aux_sym__bang_filter_command_argument_token2);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(932);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n') ADVANCE(931);
      END_STATE();
    case 933:
      ACCEPT_TOKEN(aux_sym__bang_filter_command_argument_token3);
      END_STATE();
    case 934:
      ACCEPT_TOKEN(aux_sym__bang_filter_command_argument_token3);
      if (lookahead == '-') ADVANCE(2237);
      END_STATE();
    case 935:
      ACCEPT_TOKEN(aux_sym__bang_filter_command_argument_token3);
      if (lookahead == '-') ADVANCE(2237);
      if (lookahead == ':') ADVANCE(816);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1453);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 936:
      ACCEPT_TOKEN(aux_sym__bang_filter_command_argument_token3);
      if (lookahead == '-') ADVANCE(2237);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1253);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1508);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 937:
      ACCEPT_TOKEN(aux_sym__bang_filter_command_argument_token3);
      if (lookahead == '-') ADVANCE(2237);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(722);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(788);
      END_STATE();
    case 938:
      ACCEPT_TOKEN(aux_sym__bang_filter_command_argument_token3);
      if (lookahead == '-') ADVANCE(2237);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1453);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 939:
      ACCEPT_TOKEN(aux_sym__bang_filter_command_argument_token3);
      if (lookahead == '-') ADVANCE(2237);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(777);
      END_STATE();
    case 940:
      ACCEPT_TOKEN(aux_sym__bang_filter_command_argument_token3);
      if (lookahead == '-') ADVANCE(2237);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 941:
      ACCEPT_TOKEN(aux_sym__bang_filter_command_argument_token3);
      if (lookahead == '-') ADVANCE(2239);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(1009);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2249);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1208);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 942:
      ACCEPT_TOKEN(aux_sym__bang_filter_command_argument_token3);
      if (lookahead == '-') ADVANCE(2239);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(670);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2248);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(716);
      END_STATE();
    case 943:
      ACCEPT_TOKEN(aux_sym__bang_filter_command_argument_token3);
      if (lookahead == '-') ADVANCE(2238);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1072);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1012);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 944:
      ACCEPT_TOKEN(aux_sym__bang_filter_command_argument_token3);
      if (lookahead == '-') ADVANCE(2238);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(685);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(673);
      END_STATE();
    case 945:
      ACCEPT_TOKEN(aux_sym__bang_filter_command_argument_token3);
      if (lookahead == '.') ADVANCE(794);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(791);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(798);
      if (lookahead == '8' ||
          lookahead == '9') ADVANCE(2455);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(2454);
      END_STATE();
    case 946:
      ACCEPT_TOKEN(aux_sym__bang_filter_command_argument_token3);
      if (lookahead == '.') ADVANCE(794);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2455);
      END_STATE();
    case 947:
      ACCEPT_TOKEN(aux_sym__bang_filter_command_argument_token3);
      if (lookahead == ':') ADVANCE(816);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 948:
      ACCEPT_TOKEN(aux_sym__bang_filter_command_argument_token3);
      if (lookahead == '{') ADVANCE(2529);
      END_STATE();
    case 949:
      ACCEPT_TOKEN(aux_sym__bang_filter_command_argument_token3);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1398);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2243);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 950:
      ACCEPT_TOKEN(aux_sym__bang_filter_command_argument_token3);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1182);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1483);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 951:
      ACCEPT_TOKEN(aux_sym__bang_filter_command_argument_token3);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1042);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 952:
      ACCEPT_TOKEN(aux_sym__bang_filter_command_argument_token3);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(680);
      END_STATE();
    case 953:
      ACCEPT_TOKEN(aux_sym__bang_filter_command_argument_token3);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(709);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(781);
      END_STATE();
    case 954:
      ACCEPT_TOKEN(aux_sym__bang_filter_command_argument_token3);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(756);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2242);
      END_STATE();
    case 955:
      ACCEPT_TOKEN(aux_sym__bang_filter_command_argument_token3);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(678);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(755);
      END_STATE();
    case 956:
      ACCEPT_TOKEN(aux_sym__bang_filter_command_argument_token3);
      ADVANCE_MAP(
        'C', 1343,
        'c', 1343,
        'D', 1100,
        'd', 1100,
        'E', 1296,
        'e', 1296,
        'H', 1340,
        'h', 1340,
        'L', 1101,
        'l', 1101,
        'M', 1219,
        'm', 1219,
        'P', 1004,
        'p', 1004,
        'R', 1240,
        'r', 1240,
        'U', 1372,
        'u', 1372,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2320);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 957:
      ACCEPT_TOKEN(aux_sym__bang_filter_command_argument_token3);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1427);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 958:
      ACCEPT_TOKEN(aux_sym__bang_filter_command_argument_token3);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(767);
      END_STATE();
    case 959:
      ACCEPT_TOKEN(aux_sym__bang_filter_command_argument_token3);
      ADVANCE_MAP(
        'C', 746,
        'c', 746,
        'D', 694,
        'd', 694,
        'E', 736,
        'e', 736,
        'H', 745,
        'h', 745,
        'L', 704,
        'l', 704,
        'M', 717,
        'm', 717,
        'P', 671,
        'p', 671,
        'R', 721,
        'r', 721,
        'U', 750,
        'u', 750,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2320);
      END_STATE();
    case 960:
      ACCEPT_TOKEN(aux_sym__bang_filter_command_argument_token3);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1014);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1053);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(2259);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 961:
      ACCEPT_TOKEN(aux_sym__bang_filter_command_argument_token3);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(675);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(682);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(2258);
      END_STATE();
    case 962:
      ACCEPT_TOKEN(aux_sym__bang_filter_command_argument_token3);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1464);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1178);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 963:
      ACCEPT_TOKEN(aux_sym__bang_filter_command_argument_token3);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1264);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1288);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 964:
      ACCEPT_TOKEN(aux_sym__bang_filter_command_argument_token3);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(727);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(734);
      END_STATE();
    case 965:
      ACCEPT_TOKEN(aux_sym__bang_filter_command_argument_token3);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(778);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(708);
      END_STATE();
    case 966:
      ACCEPT_TOKEN(aux_sym__bang_filter_command_argument_token3);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(1308);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1447);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 967:
      ACCEPT_TOKEN(aux_sym__bang_filter_command_argument_token3);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(739);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(770);
      END_STATE();
    case 968:
      ACCEPT_TOKEN(aux_sym__bang_filter_command_argument_token3);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2247);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1373);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1255);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 969:
      ACCEPT_TOKEN(aux_sym__bang_filter_command_argument_token3);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2246);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(751);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(724);
      END_STATE();
    case 970:
      ACCEPT_TOKEN(aux_sym__bang_filter_command_argument_token3);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1071);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1254);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1044);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 971:
      ACCEPT_TOKEN(aux_sym__bang_filter_command_argument_token3);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(684);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(723);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(681);
      END_STATE();
    case 972:
      ACCEPT_TOKEN(aux_sym__bang_filter_command_argument_token3);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1081);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2275);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 973:
      ACCEPT_TOKEN(aux_sym__bang_filter_command_argument_token3);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(687);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2274);
      END_STATE();
    case 974:
      ACCEPT_TOKEN(aux_sym__bang_filter_command_argument_token3);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2291);
      END_STATE();
    case 975:
      ACCEPT_TOKEN(aux_sym__bang_filter_command_argument_token3);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2291);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 976:
      ACCEPT_TOKEN(aux_sym__bang_filter_command_argument_token3);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 977:
      ACCEPT_TOKEN(aux_sym__bang_filter_command_argument_token3);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 978:
      ACCEPT_TOKEN(aux_sym__bang_filter_command_argument_token3);
      if (lookahead == '"' ||
          lookahead == '#' ||
          lookahead == '%' ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('.' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2527);
      END_STATE();
    case 979:
      ACCEPT_TOKEN(aux_sym__bang_filter_command_argument_token4);
      END_STATE();
    case 980:
      ACCEPT_TOKEN(aux_sym_argument_token1);
      if (lookahead == ':') ADVANCE(816);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(988);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(987);
      END_STATE();
    case 981:
      ACCEPT_TOKEN(aux_sym_argument_token1);
      if (lookahead == 'o') ADVANCE(985);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(988);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(987);
      END_STATE();
    case 982:
      ACCEPT_TOKEN(aux_sym_argument_token1);
      if (lookahead == 'o') ADVANCE(986);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      END_STATE();
    case 983:
      ACCEPT_TOKEN(aux_sym_argument_token1);
      if (lookahead == 's') ADVANCE(2439);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(988);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(987);
      END_STATE();
    case 984:
      ACCEPT_TOKEN(aux_sym_argument_token1);
      if (lookahead == 's') ADVANCE(2441);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      END_STATE();
    case 985:
      ACCEPT_TOKEN(aux_sym_argument_token1);
      if (lookahead == 't') ADVANCE(2445);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(988);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(987);
      END_STATE();
    case 986:
      ACCEPT_TOKEN(aux_sym_argument_token1);
      if (lookahead == 't') ADVANCE(2448);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      END_STATE();
    case 987:
      ACCEPT_TOKEN(aux_sym_argument_token1);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(988);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(987);
      END_STATE();
    case 988:
      ACCEPT_TOKEN(aux_sym_argument_token1);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(988);
      END_STATE();
    case 989:
      ACCEPT_TOKEN(aux_sym_argument_token2);
      if (lookahead == '.') ADVANCE(794);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(791);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(798);
      if (lookahead == '8' ||
          lookahead == '9') ADVANCE(991);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(990);
      END_STATE();
    case 990:
      ACCEPT_TOKEN(aux_sym_argument_token2);
      if (lookahead == '.') ADVANCE(794);
      if (lookahead == '8' ||
          lookahead == '9') ADVANCE(991);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(990);
      END_STATE();
    case 991:
      ACCEPT_TOKEN(aux_sym_argument_token2);
      if (lookahead == '.') ADVANCE(794);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(991);
      END_STATE();
    case 992:
      ACCEPT_TOKEN(aux_sym_argument_token2);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(992);
      END_STATE();
    case 993:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 994:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 995:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 996:
      ACCEPT_TOKEN(anon_sym_LBRACE2);
      END_STATE();
    case 997:
      ACCEPT_TOKEN(anon_sym_LBRACE2);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 998:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == '-') ADVANCE(2237);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 999:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == '-') ADVANCE(163);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1000:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == ':') ADVANCE(816);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1001:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'o') ADVANCE(1003);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1002:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 's') ADVANCE(2438);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1003:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 't') ADVANCE(2446);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1004:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1182);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1484);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1221);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1005:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2317);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1006:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1043);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1405);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1007:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1502);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1008:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1335);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1009:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1404);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1010:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1407);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1439);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1011:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1511);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1012:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1056);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1013:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1433);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1014:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1093);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1454);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1015:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1093);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1016:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1381);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1017:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      ADVANCE_MAP(
        'A', 1083,
        'a', 1083,
        'C', 1421,
        'c', 1421,
        'D', 1169,
        'd', 1169,
        'E', 1330,
        'e', 1330,
        'F', 1241,
        'f', 1241,
        'H', 1225,
        'h', 1225,
        'L', 1132,
        'l', 1132,
        'M', 1349,
        'm', 1349,
        'N', 1113,
        'n', 1113,
        'R', 1135,
        'r', 1135,
        'U', 1329,
        'u', 1329,
        'W', 1215,
        'w', 1215,
      );
      if (('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1018:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1074);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1019:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1478);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1155);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1344);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1020:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1268);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1021:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1304);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1022:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1256);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1023:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1260);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1024:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      ADVANCE_MAP(
        'A', 1392,
        'a', 1392,
        'C', 1203,
        'c', 1203,
        'E', 1339,
        'e', 1339,
        'R', 1159,
        'r', 1159,
        'T', 1516,
        't', 1516,
        'W', 1420,
        'w', 1420,
      );
      if (('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1025:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1076);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1026:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1057);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1027:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1075);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1028:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1095);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1029:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1087);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1030:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1307);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1031:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1311);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1032:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1185);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1175);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1045);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1033:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1503);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1034:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1327);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1035:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1474);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1036:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1331);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1037:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1334);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1038:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1477);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1039:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1243);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1040:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1245);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1041:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1395);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1042:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2245);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1043:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(1059);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1044:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2255);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1045:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1202);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1046:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1250);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1389);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1047:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      ADVANCE_MAP(
        'C', 1204,
        'c', 1204,
        'E', 1330,
        'e', 1330,
        'L', 1132,
        'l', 1132,
        'O', 1386,
        'o', 1386,
        'R', 1161,
        'r', 1161,
      );
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1048:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1367);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1049:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1196);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1050:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1291);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1227);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1051:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1347);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(1348);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1052:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1201);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1053:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1020);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1054:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1487);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1055:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1199);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1330);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1158);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1056:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1104);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1057:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1195);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1058:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1493);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1059:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      ADVANCE_MAP(
        'C', 1270,
        'c', 1270,
        'E', 1330,
        'e', 1330,
        'L', 1132,
        'l', 1132,
        'N', 1120,
        'n', 1120,
      );
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1060:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      ADVANCE_MAP(
        'C', 1270,
        'c', 1270,
        'E', 1330,
        'e', 1330,
        'L', 1132,
        'l', 1132,
        'N', 1125,
        'n', 1125,
        'R', 1156,
        'r', 1156,
        'S', 1061,
        's', 1061,
      );
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1061:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1414);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1062:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1115);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1063:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1290);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1353);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1064:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1292);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1065:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1068);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1066:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1205);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1363);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1067:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1205);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1330);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1132);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1068:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1069:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1206);
      if (lookahead == 'Y' ||
          lookahead == 'y') ADVANCE(1031);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1070:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1371);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1071:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2301);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1122);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1072:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2324);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1073:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1281);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1074:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2533);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1075:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1063);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1076:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2534);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1077:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2544);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1078:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2543);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1079:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1415);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1080:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2550);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1081:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1341);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1082:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1168);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1083:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1074);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1084:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1358);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1085:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1106);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1086:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1035);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1087:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1379);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1088:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1244);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1089:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1150);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1090:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1127);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1091:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1445);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1092:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1232);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1093:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1133);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1094:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1089);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1095:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1096:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1236);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1097:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1237);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1098:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1238);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1099:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1038);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1100:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1253);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1501);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1508);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1101:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1171);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1102:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(2299);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1103:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1084);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1104:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(2257);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1105:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(2271);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1106:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(2313);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1107:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(2287);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1108:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(2289);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1109:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1051);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1110:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      ADVANCE_MAP(
        'E', 1010,
        'e', 1010,
        'H', 1119,
        'h', 1119,
        'I', 1183,
        'i', 1183,
        'O', 1497,
        'o', 1497,
        'P', 1153,
        'p', 1153,
        'T', 1092,
        't', 1092,
        'W', 1016,
        'w', 1016,
        'Y', 1309,
        'y', 1309,
      );
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1111:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1024);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1140);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1112:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(2533);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1113:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1506);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1114:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1513);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1115:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1063);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1116:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(2534);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1117:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1066);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1118:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(2544);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1119:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1265);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1120:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1507);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1121:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1067);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1122:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1399);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1123:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1315);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1082);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1124:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1401);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1125:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1505);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1126:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1412);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1127:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1176);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1128:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1074);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1129:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1413);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1130:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1293);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1131:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1015);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1132:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1007);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1133:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1400);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1134:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1432);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1135:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1025);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1136:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1330);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1040);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1137:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1330);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1132);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1138:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      ADVANCE_MAP(
        'E', 1330,
        'e', 1330,
        'L', 1158,
        'l', 1158,
        'R', 1134,
        'r', 1134,
        'S', 1496,
        's', 1496,
      );
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1139:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1035);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1140:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1403);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1141:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1461);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1142:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1379);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1143:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1422);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1144:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1078);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1145:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1351);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1146:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1077);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1147:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1091);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1148:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1079);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1149:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1080);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1150:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1305);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1151:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1320);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1152:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1316);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1153:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1267);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1154:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1385);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1155:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1470);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1156:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1442);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1157:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1295);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1158:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1033);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1159:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1027);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1160:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1476);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1161:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1450);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1162:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1418);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1163:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1029);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1164:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1474);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1165:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1271);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1166:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1417);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1167:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1338);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1168:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1068);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1169:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1284);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1170:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1017);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1171:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1455);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1172:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1220);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1173:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1342);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1174:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1239);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1175:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1491);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1176:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1243);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1177:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1246);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1178:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(1197);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1179:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(2326);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1180:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(1137);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1181:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(2533);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1182:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(1103);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1183:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(1313);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1184:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(1039);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1354);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1185:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(1318);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1186:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(1112);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1187:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(1128);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1188:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(1146);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1189:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(1148);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1190:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(1149);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1191:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(1198);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1192:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(1068);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1193:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(2261);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1194:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      ADVANCE_MAP(
        'H', 1021,
        'h', 1021,
        'M', 1073,
        'm', 1073,
        'O', 1258,
        'o', 1258,
        'U', 1406,
        'u', 1406,
      );
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1195:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(2533);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1196:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(1510);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1197:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(1456);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1198:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(1459);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1199:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(1008);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1200:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(1356);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(1360);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1201:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(1157);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1202:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(1030);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1203:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(1034);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1204:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(1036);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1364);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1205:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(1036);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1206:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(1037);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1207:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(1165);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1208:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(2267);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1209:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1032);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1210:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1259);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1054);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1326);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1211:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1137);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1124);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1212:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1285);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1213:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1136);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1214:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1046);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1215:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1301);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1228);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1216:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1517);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1294);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1217:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1517);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1218:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1466);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1219:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1328);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1266);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1220:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1512);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1221:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1319);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1222:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1085);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1223:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1383);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1224:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1303);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1225:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1094);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1226:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1366);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1227:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1283);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1228:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1475);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1229:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1369);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1230:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1065);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1231:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1441);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1232:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1336);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1233:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1312);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1386);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1234:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1321);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1235:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1302);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1236:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1310);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1237:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1314);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1238:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1317);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1239:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1147);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1240:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1191);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1241:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1275);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1242:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1440);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1243:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1322);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1244:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1174);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1245:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1278);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1246:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1279);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1247:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1471);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1248:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1277);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1249:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1472);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1250:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'K' ||
          lookahead == 'k') ADVANCE(1172);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1251:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'K' ||
          lookahead == 'k') ADVANCE(1167);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1252:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'K' ||
          lookahead == 'k') ADVANCE(1390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1253:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2265);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1254:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2269);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1255:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2241);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1256:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2319);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1257:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1514);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1258:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1359);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(1380);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1259:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1260:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2533);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1261:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1050);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1262:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1515);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1263:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2548);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1264:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1374);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1265:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1261);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1266:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1465);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1267:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1280);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1268:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1269);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1269:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1131);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1270:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1361);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1271:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1263);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1272:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1357);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1273:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1160);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1274:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1078);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1275:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1142);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1276:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1365);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1277:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1112);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1278:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1128);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1279:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1130);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1280:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1177);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1281:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1234);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1325);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1235);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1282:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1278);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1283:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1480);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1284:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1164);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1285:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(1138);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1286:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(1047);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1287:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(1289);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1288:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(1102);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1289:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(1005);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1290:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(1074);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1291:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(1095);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1292:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(1087);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1293:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(1231);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1294:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(1112);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1295:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(1118);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1296:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1071);
      if (lookahead == 'Q' ||
          lookahead == 'q') ADVANCE(1498);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1297:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2277);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1298:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2251);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1299:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2305);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1300:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1048);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(1218);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1301:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1137);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1145);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1302:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1137);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1303:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1060);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1304:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1233);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1305:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2533);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1306:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1448);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1307:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1188);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1308:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1345);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1309:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1467);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1310:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1192);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1311:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1252);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1312:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1173);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1313:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1023);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1314:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1180);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1315:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1490);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1316:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1074);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1317:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1181);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1318:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1352);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1319:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1458);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1320:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1075);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1321:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1121);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1322:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1128);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1323:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1118);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1324:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1445);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1325:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1090);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1326:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1058);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1327:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1189);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1328:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1485);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1329:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1272);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1330:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1463);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1331:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1187);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1332:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1276);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1333:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1443);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1334:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1190);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1335:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1186);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1389);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1336:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1424);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1337:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1481);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1338:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1500);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1339:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1070);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1340:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1288);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1341:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2295);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1342:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2533);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1343:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1287);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1344:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1251);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1345:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1410);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1346:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1495);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1347:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1426);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1348:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1479);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1349:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1088);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1350:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1402);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1351:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1492);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1352:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1446);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1353:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1437);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1112);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1354:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1437);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1355:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1393);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1356:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1274);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1357:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1018);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1358:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1509);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1359:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1411);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1360:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1504);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1361:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1444);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1362:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1282);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1363:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1323);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1364:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1443);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1365:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1028);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1366:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1324);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1367:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1096);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1368:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1499);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1369:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1332);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1370:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1333);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1371:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1098);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1372:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2275);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1373:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2273);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1374:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2293);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1375:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2303);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1376:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1468);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1377:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1019);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1378:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2533);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1379:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1353);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1380:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1273);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1381:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1114);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1382:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1355);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1383:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1257);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1384:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1099);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1385:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1262);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1386:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1150);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1387:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1112);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1388:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1128);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1389:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1416);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1390:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1354);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1391:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1151);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1392:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1391);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1393:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1494);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1394:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1152);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1395:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1388);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1396:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1086);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1397:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1370);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1398:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2263);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1399:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2253);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1400:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2322);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1401:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2533);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1402:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1200);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1403:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1423);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1404:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(999);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1405:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1286);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(1460);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1406:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1449);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1407:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1049);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1408:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1298);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1409:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1062);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1410:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1105);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1411:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1435);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1412:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1457);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1413:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1462);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1414:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1362);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1415:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1342);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1207);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1416:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1112);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1417:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1128);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1418:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1154);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1419:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1041);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1420:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1247);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1421:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1139);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1422:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1423:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1163);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1425);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1424:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1163);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1425:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1249);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1426:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1097);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1427:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1208);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1428:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2307);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1429:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2309);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1430:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2533);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1431:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1184);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1432:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1216);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1433:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1193);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1434:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1377);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1435:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1052);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1436:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1107);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1437:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1461);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1438:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1108);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1439:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1229);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1440:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1469);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1441:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1452);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1442:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1217);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1443:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1112);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1444:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1128);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1445:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1141);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1446:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1473);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1447:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1126);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1448:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1129);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1449:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1350);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1450:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1397);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1451:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1394);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1452:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1238);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1453:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(998);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1454:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(2280);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1455:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(2281);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1456:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(2284);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1457:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(2297);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1458:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(2315);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1459:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(2285);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1460:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1069);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1461:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(2533);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1462:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1055);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1463:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1124);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1464:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1488);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1465:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1223);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1466:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1389);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1467:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1011);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1468:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1226);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1469:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1430);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1470:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1026);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1471:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1115);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1472:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1142);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1473:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1230);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1474:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1112);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1475:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1116);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1476:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1117);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1477:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1128);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1478:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1470);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1479:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1162);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1480:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1143);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1481:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1166);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1482:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1170);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1483:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1179);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1484:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1428);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1485:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1429);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1486:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1213);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1487:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1431);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1488:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1408);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1489:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1214);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1490:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1382);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1491:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1384);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1492:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1461);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1493:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1325);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1494:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1378);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1495:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1436);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1496:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1451);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1497:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1409);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1498:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1022);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1499:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1438);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1500:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1396);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1501:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(1222);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1502:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(1112);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1503:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(1118);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1504:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(1144);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1505:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2533);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1506:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2540);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1507:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2537);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1508:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1297);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1509:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1299);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1510:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1419);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1511:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(2533);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1512:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(1064);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1513:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(1242);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1514:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'Y' ||
          lookahead == 'y') ADVANCE(2311);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1515:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'Y' ||
          lookahead == 'y') ADVANCE(2533);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1516:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'Y' ||
          lookahead == 'y') ADVANCE(1387);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1517:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'Z' ||
          lookahead == 'z') ADVANCE(1128);
      if (('A' <= lookahead && lookahead <= 'Y') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'y')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1518:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1518);
      END_STATE();
    case 1519:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1519);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1520:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == '.') ADVANCE(794);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(1981);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(1983);
      if (lookahead == '8' ||
          lookahead == '9') ADVANCE(1522);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(1521);
      if (lookahead == '#' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1984);
      END_STATE();
    case 1521:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == '.') ADVANCE(794);
      if (lookahead == '8' ||
          lookahead == '9') ADVANCE(1522);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(1521);
      if (lookahead == '#' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1984);
      END_STATE();
    case 1522:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == '.') ADVANCE(794);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1522);
      if (lookahead == '#' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1984);
      END_STATE();
    case 1523:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == ':') ADVANCE(816);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(1984);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1982);
      END_STATE();
    case 1524:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'a') ADVANCE(1548);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1984);
      END_STATE();
    case 1525:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'c') ADVANCE(1556);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1984);
      END_STATE();
    case 1526:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'e') ADVANCE(1574);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1984);
      END_STATE();
    case 1527:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'e') ADVANCE(2414);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1984);
      END_STATE();
    case 1528:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'e') ADVANCE(2404);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1984);
      END_STATE();
    case 1529:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'e') ADVANCE(2406);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1984);
      END_STATE();
    case 1530:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'e') ADVANCE(1560);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1984);
      END_STATE();
    case 1531:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'e') ADVANCE(1536);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1984);
      END_STATE();
    case 1532:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'f') ADVANCE(1533);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1984);
      END_STATE();
    case 1533:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'f') ADVANCE(1530);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1984);
      END_STATE();
    case 1534:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'h') ADVANCE(1543);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1984);
      END_STATE();
    case 1535:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'h') ADVANCE(1544);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1984);
      END_STATE();
    case 1536:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'h') ADVANCE(1545);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1984);
      END_STATE();
    case 1537:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'i') ADVANCE(1552);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1984);
      END_STATE();
    case 1538:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'i') ADVANCE(1569);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1984);
      END_STATE();
    case 1539:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'i') ADVANCE(1558);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1984);
      END_STATE();
    case 1540:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'i') ADVANCE(1547);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1984);
      END_STATE();
    case 1541:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'i') ADVANCE(1553);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1984);
      END_STATE();
    case 1542:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'l') ADVANCE(1534);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1984);
      END_STATE();
    case 1543:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'l') ADVANCE(2401);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1984);
      END_STATE();
    case 1544:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'l') ADVANCE(2392);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1984);
      END_STATE();
    case 1545:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'l') ADVANCE(2389);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1984);
      END_STATE();
    case 1546:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'l') ADVANCE(2398);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1984);
      END_STATE();
    case 1547:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'l') ADVANCE(1527);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1984);
      END_STATE();
    case 1548:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'm') ADVANCE(1529);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1984);
      END_STATE();
    case 1549:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'm') ADVANCE(1535);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1984);
      END_STATE();
    case 1550:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'n') ADVANCE(2386);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1984);
      END_STATE();
    case 1551:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'n') ADVANCE(916);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1984);
      END_STATE();
    case 1552:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'n') ADVANCE(1531);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1984);
      END_STATE();
    case 1553:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'n') ADVANCE(1528);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1984);
      END_STATE();
    case 1554:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'o') ADVANCE(1566);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(1984);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1982);
      END_STATE();
    case 1555:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'o') ADVANCE(1567);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1984);
      END_STATE();
    case 1556:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'o') ADVANCE(1550);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1984);
      END_STATE();
    case 1557:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'o') ADVANCE(1573);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1984);
      END_STATE();
    case 1558:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'o') ADVANCE(1563);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1984);
      END_STATE();
    case 1559:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'p') ADVANCE(2410);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1984);
      END_STATE();
    case 1560:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'r') ADVANCE(2408);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1984);
      END_STATE();
    case 1561:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'r') ADVANCE(1557);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1984);
      END_STATE();
    case 1562:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'r') ADVANCE(1539);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1984);
      END_STATE();
    case 1563:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'r') ADVANCE(1538);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1984);
      END_STATE();
    case 1564:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 's') ADVANCE(2437);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(1984);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1982);
      END_STATE();
    case 1565:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 's') ADVANCE(2440);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1984);
      END_STATE();
    case 1566:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 't') ADVANCE(2444);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(1984);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1982);
      END_STATE();
    case 1567:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 't') ADVANCE(2447);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1984);
      END_STATE();
    case 1568:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 't') ADVANCE(2394);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1984);
      END_STATE();
    case 1569:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 't') ADVANCE(1575);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1984);
      END_STATE();
    case 1570:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'u') ADVANCE(1542);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1984);
      END_STATE();
    case 1571:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'u') ADVANCE(1549);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1984);
      END_STATE();
    case 1572:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'u') ADVANCE(1532);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1984);
      END_STATE();
    case 1573:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'u') ADVANCE(1559);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1984);
      END_STATE();
    case 1574:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'x') ADVANCE(1568);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1984);
      END_STATE();
    case 1575:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'y') ADVANCE(2412);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1984);
      END_STATE();
    case 1576:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == '{') ADVANCE(2529);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1984);
      END_STATE();
    case 1577:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == '#' ||
          lookahead == '_') ADVANCE(1984);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1577);
      END_STATE();
    case 1578:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1607);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1898);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1579:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1968);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1580:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1844);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1581:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1900);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1923);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1582:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1975);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1583:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1879);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1584:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      ADVANCE_MAP(
        'A', 1641,
        'a', 1641,
        'C', 1911,
        'c', 1911,
        'D', 1711,
        'd', 1711,
        'E', 1839,
        'e', 1839,
        'F', 1769,
        'f', 1769,
        'H', 1754,
        'h', 1754,
        'L', 1675,
        'l', 1675,
        'M', 1853,
        'm', 1853,
        'N', 1659,
        'n', 1659,
        'R', 1677,
        'r', 1677,
        'U', 1838,
        'u', 1838,
        'W', 1748,
        'w', 1748,
      );
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1585:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1632);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1586:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1952);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1697);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1850);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1587:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1817);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1588:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1781);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1589:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      ADVANCE_MAP(
        'A', 1889,
        'a', 1889,
        'C', 1737,
        'c', 1737,
        'E', 1848,
        'e', 1848,
        'R', 1701,
        'r', 1701,
        'T', 1979,
        't', 1979,
        'W', 1910,
        'w', 1910,
      );
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1590:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1638);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1591:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1618);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1592:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1636);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1593:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1650);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1594:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1643);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1595:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1819);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1596:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1822);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1597:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1723);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1716);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1608);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1598:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1969);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1599:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1837);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1600:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1948);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1601:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1840);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1602:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1843);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1603:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1951);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1604:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1771);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1605:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1773);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1606:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1892);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1607:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(1620);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1608:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1736);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1609:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1778);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1886);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1610:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      ADVANCE_MAP(
        'C', 1738,
        'c', 1738,
        'E', 1839,
        'e', 1839,
        'L', 1675,
        'l', 1675,
        'O', 1883,
        'o', 1883,
        'R', 1703,
        'r', 1703,
      );
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1611:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1870);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1612:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1732);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1613:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1807);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1756);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1614:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1851);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(1852);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1615:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1735);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1616:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1958);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1617:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1733);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1839);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1700);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1618:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1730);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1619:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1963);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1620:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      ADVANCE_MAP(
        'C', 1789,
        'c', 1789,
        'E', 1839,
        'e', 1839,
        'L', 1675,
        'l', 1675,
        'N', 1665,
        'n', 1665,
      );
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1621:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      ADVANCE_MAP(
        'C', 1789,
        'c', 1789,
        'E', 1839,
        'e', 1839,
        'L', 1675,
        'l', 1675,
        'N', 1670,
        'n', 1670,
        'R', 1698,
        'r', 1698,
        'S', 1622,
        's', 1622,
      );
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1622:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1904);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1623:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1661);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1624:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1806);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1857);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1625:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1808);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1626:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1629);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1627:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1739);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1866);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1628:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1739);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1839);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1675);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1629:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1739);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1630:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1740);
      if (lookahead == 'Y' ||
          lookahead == 'y') ADVANCE(1596);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1631:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1873);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1632:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2533);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1633:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2543);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1634:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2550);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1635:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1800);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1636:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1624);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1637:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1905);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1638:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2535);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1639:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2545);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1640:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1710);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1641:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1632);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1642:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1600);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1643:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1877);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1644:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1772);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1645:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1692);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1646:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1671);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1647:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1929);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1648:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1761);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1649:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1645);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1650:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1887);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1651:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1765);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1652:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1766);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1653:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1767);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1654:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1603);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1655:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(2533);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1656:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1614);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1657:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      ADVANCE_MAP(
        'E', 1581,
        'e', 1581,
        'H', 1664,
        'h', 1664,
        'I', 1721,
        'i', 1721,
        'O', 1966,
        'o', 1966,
        'P', 1695,
        'p', 1695,
        'T', 1648,
        't', 1648,
        'W', 1583,
        'w', 1583,
        'Y', 1820,
        'y', 1820,
      );
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1658:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1589);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1682);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1659:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1972);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1660:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1977);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1661:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1624);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1662:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1627);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1663:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(2535);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1664:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1786);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1665:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1973);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1666:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1628);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1667:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(2545);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1668:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1826);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1640);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1669:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1895);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1670:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1971);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1671:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1717);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1672:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1632);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1673:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1903);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1674:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1809);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1675:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1579);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1676:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1919);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1677:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1590);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1678:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1839);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1605);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1679:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1839);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1675);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1680:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      ADVANCE_MAP(
        'E', 1839,
        'e', 1839,
        'L', 1700,
        'l', 1700,
        'R', 1676,
        'r', 1676,
        'S', 1965,
        's', 1965,
      );
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1681:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1600);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1682:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1897);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1683:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1936);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1684:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1877);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1685:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1912);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1686:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1633);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1687:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1855);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1688:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1639);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1689:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1647);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1690:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1637);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1691:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1634);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1692:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1812);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1693:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1830);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1694:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1827);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1695:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1788);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1696:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1882);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1697:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1944);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1698:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1926);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1699:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1811);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1700:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1598);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1701:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1592);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1702:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1950);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1703:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1933);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1704:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1908);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1705:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1594);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1706:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1948);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1707:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1790);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1708:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1907);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1709:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1847);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1710:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1629);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1711:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1803);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1712:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1584);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1713:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1752);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1714:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1849);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1715:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1768);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1716:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1961);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1717:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1771);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1718:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1774);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1719:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(2533);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1720:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(1679);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1721:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(1824);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1722:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(1604);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1858);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1723:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(1829);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1724:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(1655);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1725:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(1672);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1726:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(1688);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1727:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(1690);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1728:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(1691);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1729:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(1629);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1730:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(2533);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1731:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      ADVANCE_MAP(
        'H', 1587,
        'h', 1587,
        'M', 1635,
        'm', 1635,
        'O', 1782,
        'o', 1782,
        'U', 1899,
        'u', 1899,
      );
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1732:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(1974);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1733:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(1580);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1734:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(1860);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(1863);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1735:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(1699);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1736:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(1595);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1737:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(1599);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1738:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(1601);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1867);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1739:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(1601);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1740:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(1602);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1741:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(1707);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1742:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1597);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1743:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1783);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1616);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1836);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1744:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1679);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1669);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1745:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1804);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1746:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1678);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1747:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1609);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1748:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1814);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1757);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1749:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1980);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1810);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1750:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1980);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1751:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1940);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1752:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1976);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1753:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1816);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1754:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1649);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1755:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1869);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1756:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1802);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1757:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1949);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1758:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1871);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1759:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1626);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1760:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1925);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1761:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1845);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1762:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1823);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1883);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1763:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1831);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1764:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1815);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1765:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1821);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1766:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1825);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1767:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1828);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1768:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1689);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1769:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1794);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1770:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1924);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1771:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1832);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1772:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1715);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1773:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1797);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1774:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1798);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1775:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1945);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1776:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1796);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1777:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1946);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1778:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'K' ||
          lookahead == 'k') ADVANCE(1713);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1779:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'K' ||
          lookahead == 'k') ADVANCE(1709);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1780:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'K' ||
          lookahead == 'k') ADVANCE(1887);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1781:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2533);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1782:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1862);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(1878);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1783:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1658);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1784:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1613);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1785:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1978);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1786:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1784);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1787:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2549);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1788:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1799);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1789:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1864);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1790:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1787);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1791:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1861);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1792:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1702);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1793:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1633);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1794:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1684);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1795:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1868);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1796:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1655);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1797:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1672);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1798:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1674);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1799:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1718);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1800:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1763);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1835);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1764);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1801:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1797);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1802:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1954);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1803:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1706);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1804:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(1680);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1805:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(1610);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1806:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(1632);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1807:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(1650);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1808:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(1643);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1809:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(1760);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1810:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(1655);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1811:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(1667);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1812:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2533);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1813:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1611);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(1751);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1814:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1679);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1687);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1815:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1679);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1816:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1621);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1817:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1762);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1818:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1931);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1819:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1726);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1820:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1941);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1821:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1729);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1822:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1780);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1823:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1714);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1824:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1588);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1825:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1720);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1826:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1960);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1827:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1632);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1828:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1719);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1829:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1856);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1830:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1636);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1831:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1666);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1832:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1672);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1833:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1667);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1834:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1929);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1835:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1646);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1836:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1619);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1837:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1727);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1838:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1791);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1839:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1939);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1840:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1725);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1841:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1795);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1842:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1927);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1843:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1728);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1844:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1724);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1886);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1845:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1914);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1846:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1955);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1847:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1967);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1848:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1631);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1849:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2533);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1850:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1779);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1851:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1916);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1852:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1953);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1853:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1644);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1854:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1896);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1855:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1962);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1856:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1930);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1857:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1922);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1655);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1858:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1922);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1859:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1890);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1860:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1793);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1861:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1585);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1862:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1902);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1863:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1970);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1864:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1928);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1865:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1801);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1866:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1833);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1867:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1927);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1868:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1593);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1869:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1834);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1870:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1651);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1871:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1841);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1872:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1842);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1873:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1653);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1874:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2533);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1875:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1942);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1876:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1586);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1877:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1857);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1878:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1792);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1879:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1660);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1880:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1859);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1881:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1654);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1882:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1785);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1883:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1692);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1884:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1655);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1885:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1672);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1886:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1906);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1887:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1858);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1888:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1693);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1889:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1888);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1890:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1964);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1891:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1694);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1892:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1885);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1893:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1642);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1894:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1872);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1895:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2533);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1896:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1734);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1897:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1913);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1898:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1805);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(1937);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1899:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1932);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1900:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1612);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1901:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1623);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1902:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1921);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1903:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1938);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1904:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1865);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1905:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1849);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1741);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1906:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1655);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1907:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1672);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1908:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1696);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1909:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1606);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1910:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1775);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1911:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1681);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1912:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1887);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1913:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1705);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1915);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1914:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1705);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1915:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1777);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1916:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1652);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1917:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2533);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1918:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1722);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1919:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1749);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1920:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1876);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1921:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1615);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1922:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1936);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1923:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1758);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1924:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1943);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1925:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1935);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1926:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1750);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1927:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1655);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1928:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1672);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1929:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1683);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1930:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1947);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1931:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1673);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1932:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1854);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1933:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1894);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1934:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1891);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1935:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1767);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1936:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(2533);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1937:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1630);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1938:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1617);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1939:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1669);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1940:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1886);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1941:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1582);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1942:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1755);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1943:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1917);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1944:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1591);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1945:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1661);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1946:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1684);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1947:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1759);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1948:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1655);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1949:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1663);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1950:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1662);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1951:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1672);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1952:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1944);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1953:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1704);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1954:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1685);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1955:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1708);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1956:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1712);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1957:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1746);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1958:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1918);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1959:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1747);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1960:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1880);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1961:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1881);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1962:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1936);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1963:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1835);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1964:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1874);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1965:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1934);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1966:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1901);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1967:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1893);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1968:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(1655);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1969:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(1667);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1970:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(1686);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1971:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2533);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1972:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2541);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1973:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2538);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1974:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1909);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1975:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(2533);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1976:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(1625);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1977:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(1770);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1978:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'Y' ||
          lookahead == 'y') ADVANCE(2533);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1979:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'Y' ||
          lookahead == 'y') ADVANCE(1884);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1980:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == 'Z' ||
          lookahead == 'z') ADVANCE(1672);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Y') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'y')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1981:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(1981);
      if (lookahead == '#' ||
          ('2' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1984);
      END_STATE();
    case 1982:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(1984);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1982);
      END_STATE();
    case 1983:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(1983);
      if (lookahead == '#' ||
          ('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(1984);
      END_STATE();
    case 1984:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1984);
      END_STATE();
    case 1985:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1985);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 1986:
      ACCEPT_TOKEN(aux_sym__immediate_identifier_token1);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1986);
      END_STATE();
    case 1987:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == '-') ADVANCE(171);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 1988:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == '-') ADVANCE(167);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 1989:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == '-') ADVANCE(317);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 1990:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'E') ADVANCE(3206);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 1991:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'N') ADVANCE(1990);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 1992:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'O') ADVANCE(1991);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 1993:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'a') ADVANCE(2140);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 1994:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'a') ADVANCE(2063);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 1995:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'a') ADVANCE(2110);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 1996:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'a') ADVANCE(2146);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 1997:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'a') ADVANCE(2131);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 1998:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'a') ADVANCE(2139);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 1999:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'a') ADVANCE(2111);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2000:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'a') ADVANCE(2143);
      if (lookahead == 'i') ADVANCE(2096);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2001:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'a') ADVANCE(2055);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2002:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'a') ADVANCE(2084);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2003:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'a') ADVANCE(2115);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2004:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'a') ADVANCE(2114);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2005:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'a') ADVANCE(2065);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2006:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'c') ADVANCE(2122);
      if (lookahead == 't') ADVANCE(2044);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2007:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'c') ADVANCE(1989);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2008:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'c') ADVANCE(2049);
      if (lookahead == 'o') ADVANCE(2083);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2009:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'c') ADVANCE(2049);
      if (lookahead == 'o') ADVANCE(2095);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2010:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'c') ADVANCE(2050);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2011:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'c') ADVANCE(2067);
      if (lookahead == 't') ADVANCE(2034);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2012:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'c') ADVANCE(2031);
      if (lookahead == 't') ADVANCE(2001);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2013:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'c') ADVANCE(2031);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2014:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'c') ADVANCE(2040);
      if (lookahead == 't') ADVANCE(2001);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2015:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'd') ADVANCE(3425);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2016:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'd') ADVANCE(3344);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2017:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'd') ADVANCE(3350);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2018:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'd') ADVANCE(3353);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2019:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'd') ADVANCE(3308);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2020:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'd') ADVANCE(2118);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2021:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'd') ADVANCE(2041);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2022:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'e') ADVANCE(2109);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2023:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'e') ADVANCE(2965);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2024:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'e') ADVANCE(2077);
      if (lookahead == 'n') ADVANCE(2064);
      if (lookahead == 'w') ADVANCE(2048);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2025:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'e') ADVANCE(3362);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2026:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'e') ADVANCE(3327);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2027:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'e') ADVANCE(2045);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2028:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'e') ADVANCE(2130);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2029:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'e') ADVANCE(1995);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2030:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'e') ADVANCE(2142);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2031:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'e') ADVANCE(1994);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2032:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'e') ADVANCE(2070);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2033:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'e') ADVANCE(2119);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2034:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'e') ADVANCE(2085);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2035:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'e') ADVANCE(2019);
      if (lookahead == 's') ADVANCE(3341);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2036:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'e') ADVANCE(2120);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2037:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'e') ADVANCE(2086);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2038:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'e') ADVANCE(2121);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2039:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'e') ADVANCE(2043);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2040:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'e') ADVANCE(2005);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2041:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'e') ADVANCE(2089);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2042:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'e') ADVANCE(2087);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2043:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'e') ADVANCE(2108);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2044:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'f') ADVANCE(1988);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2045:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'f') ADVANCE(1998);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2046:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'g') ADVANCE(2112);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2047:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'g') ADVANCE(2116);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2048:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'h') ADVANCE(2054);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2049:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'h') ADVANCE(1999);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2050:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'h') ADVANCE(2047);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2051:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'i') ADVANCE(2068);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2052:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'i') ADVANCE(2123);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2053:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'i') ADVANCE(2100);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2054:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'i') ADVANCE(2134);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2055:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'i') ADVANCE(2080);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2056:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'i') ADVANCE(2103);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2057:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'i') ADVANCE(2091);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2058:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'i') ADVANCE(2092);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2059:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'i') ADVANCE(2093);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2060:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'i') ADVANCE(2094);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2061:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'k') ADVANCE(2053);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2062:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'k') ADVANCE(2056);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2063:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'l') ADVANCE(3297);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2064:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'l') ADVANCE(3332);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2065:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'l') ADVANCE(3293);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2066:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'l') ADVANCE(3356);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2067:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'l') ADVANCE(2136);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2068:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'l') ADVANCE(2028);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2069:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'l') ADVANCE(2016);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2070:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'l') ADVANCE(2057);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2071:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'l') ADVANCE(2029);
      if (lookahead == 'o') ADVANCE(2082);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2072:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'l') ADVANCE(2029);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2073:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'l') ADVANCE(2128);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2074:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'l') ADVANCE(1996);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2075:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'l') ADVANCE(2059);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2076:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'l') ADVANCE(2060);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2077:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'm') ADVANCE(2105);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2078:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'n') ADVANCE(2125);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2079:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'n') ADVANCE(2015);
      if (lookahead == 'x') ADVANCE(2011);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2080:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'n') ADVANCE(2035);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2081:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'n') ADVANCE(3312);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2082:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'n') ADVANCE(2013);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2083:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'n') ADVANCE(2014);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2084:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'n') ADVANCE(2124);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2085:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'n') ADVANCE(2017);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2086:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'n') ADVANCE(2018);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2087:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'n') ADVANCE(2127);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2088:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'n') ADVANCE(2020);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2089:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'n') ADVANCE(2066);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2090:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'n') ADVANCE(2032);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2091:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'n') ADVANCE(2025);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2092:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'n') ADVANCE(2033);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2093:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'n') ADVANCE(2036);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2094:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'n') ADVANCE(2038);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2095:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'n') ADVANCE(2012);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2096:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'n') ADVANCE(2076);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2097:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'o') ADVANCE(2137);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2098:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'o') ADVANCE(2069);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2099:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'o') ADVANCE(2138);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2100:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'p') ADVANCE(2024);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2101:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'p') ADVANCE(3317);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2102:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'p') ADVANCE(3359);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2103:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'p') ADVANCE(3421);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2104:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'p') ADVANCE(2023);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2105:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'p') ADVANCE(2132);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2106:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'p') ADVANCE(2074);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2107:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'p') ADVANCE(2003);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2108:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'p') ADVANCE(2037);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2109:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'r') ADVANCE(2967);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2110:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'r') ADVANCE(3200);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2111:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'r') ADVANCE(3302);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2112:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'r') ADVANCE(2097);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2113:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'r') ADVANCE(2002);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2114:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'r') ADVANCE(2129);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2115:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'r') ADVANCE(2042);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2116:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'r') ADVANCE(2099);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2117:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 's') ADVANCE(2022);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2118:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 's') ADVANCE(3365);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2119:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 's') ADVANCE(3434);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2120:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 's') ADVANCE(3431);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2121:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 's') ADVANCE(3428);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2122:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 's') ADVANCE(1987);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2123:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 's') ADVANCE(2106);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2124:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 's') ADVANCE(2107);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2125:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 't') ADVANCE(1993);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2126:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 't') ADVANCE(2046);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2127:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 't') ADVANCE(3322);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2128:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 't') ADVANCE(888);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2129:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 't') ADVANCE(3243);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2130:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 't') ADVANCE(2145);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2131:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 't') ADVANCE(2010);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2132:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 't') ADVANCE(2147);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2133:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 't') ADVANCE(2004);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2134:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 't') ADVANCE(2026);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2135:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'u') ADVANCE(2007);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2136:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'u') ADVANCE(2021);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2137:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'u') ADVANCE(2101);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2138:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'u') ADVANCE(2102);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2139:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'u') ADVANCE(2073);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2140:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'x') ADVANCE(2966);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2141:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'x') ADVANCE(2011);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2142:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'x') ADVANCE(2126);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2143:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'x') ADVANCE(2075);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2144:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'y') ADVANCE(2078);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2145:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'y') ADVANCE(2104);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2146:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'y') ADVANCE(3347);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2147:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'y') ADVANCE(3337);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2148:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == '#' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2148);
      END_STATE();
    case 2149:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 2150:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '<') ADVANCE(216);
      END_STATE();
    case 2151:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '<') ADVANCE(216);
      if (lookahead == '=') ADVANCE(2429);
      if (lookahead == '~') ADVANCE(2435);
      END_STATE();
    case 2152:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 2153:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 2154:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 2155:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 2156:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      END_STATE();
    case 2157:
      ACCEPT_TOKEN(anon_sym_DOT_EQ);
      END_STATE();
    case 2158:
      ACCEPT_TOKEN(anon_sym_DOT_DOT_EQ);
      END_STATE();
    case 2159:
      ACCEPT_TOKEN(anon_sym_EQ_LT_LT);
      END_STATE();
    case 2160:
      ACCEPT_TOKEN(aux_sym_option_name_token1);
      if (lookahead == '_') ADVANCE(2164);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(2163);
      END_STATE();
    case 2161:
      ACCEPT_TOKEN(aux_sym_option_name_token1);
      if (lookahead == 'l') ADVANCE(2171);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(2163);
      END_STATE();
    case 2162:
      ACCEPT_TOKEN(aux_sym_option_name_token1);
      if (lookahead == 'l') ADVANCE(2161);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(2163);
      END_STATE();
    case 2163:
      ACCEPT_TOKEN(aux_sym_option_name_token1);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(2163);
      END_STATE();
    case 2164:
      ACCEPT_TOKEN(anon_sym_t_);
      END_STATE();
    case 2165:
      ACCEPT_TOKEN(aux_sym_option_name_token2);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2165);
      END_STATE();
    case 2166:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 2167:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ') ADVANCE(2192);
      END_STATE();
    case 2168:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(2961);
      END_STATE();
    case 2169:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 2170:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(2421);
      END_STATE();
    case 2171:
      ACCEPT_TOKEN(anon_sym_all);
      if (lookahead == '&') ADVANCE(2172);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(2163);
      END_STATE();
    case 2172:
      ACCEPT_TOKEN(anon_sym_all_AMP);
      END_STATE();
    case 2173:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 2174:
      ACCEPT_TOKEN(anon_sym_EQ2);
      END_STATE();
    case 2175:
      ACCEPT_TOKEN(anon_sym_COLON2);
      END_STATE();
    case 2176:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ2);
      END_STATE();
    case 2177:
      ACCEPT_TOKEN(anon_sym_CARET_EQ);
      END_STATE();
    case 2178:
      ACCEPT_TOKEN(anon_sym_DASH_EQ2);
      END_STATE();
    case 2179:
      ACCEPT_TOKEN(sym_set_value);
      if (lookahead == '>') ADVANCE(2184);
      if (lookahead == '\\') ADVANCE(2185);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ') ADVANCE(2184);
      END_STATE();
    case 2180:
      ACCEPT_TOKEN(sym_set_value);
      if (lookahead == '\\') ADVANCE(2185);
      if (lookahead == '|') ADVANCE(2351);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(2184);
      END_STATE();
    case 2181:
      ACCEPT_TOKEN(sym_set_value);
      if (lookahead == '\\') ADVANCE(2185);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2183);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ') ADVANCE(2184);
      END_STATE();
    case 2182:
      ACCEPT_TOKEN(sym_set_value);
      if (lookahead == '\\') ADVANCE(2185);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2181);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2183);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ') ADVANCE(2184);
      END_STATE();
    case 2183:
      ACCEPT_TOKEN(sym_set_value);
      if (lookahead == '\\') ADVANCE(2185);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2179);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ') ADVANCE(2184);
      END_STATE();
    case 2184:
      ACCEPT_TOKEN(sym_set_value);
      if (lookahead == '\\') ADVANCE(2185);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ') ADVANCE(2184);
      END_STATE();
    case 2185:
      ACCEPT_TOKEN(sym_set_value);
      if (lookahead == '\\') ADVANCE(2185);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(2184);
      END_STATE();
    case 2186:
      ACCEPT_TOKEN(anon_sym_SPACE);
      if (lookahead == ' ') ADVANCE(2186);
      END_STATE();
    case 2187:
      ACCEPT_TOKEN(aux_sym_command_argument_token1);
      if (lookahead == '>') ADVANCE(2192);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ') ADVANCE(2192);
      END_STATE();
    case 2188:
      ACCEPT_TOKEN(aux_sym_command_argument_token1);
      if (lookahead == '|') ADVANCE(2353);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ') ADVANCE(2192);
      END_STATE();
    case 2189:
      ACCEPT_TOKEN(aux_sym_command_argument_token1);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2191);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ') ADVANCE(2192);
      END_STATE();
    case 2190:
      ACCEPT_TOKEN(aux_sym_command_argument_token1);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2189);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2191);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ') ADVANCE(2192);
      END_STATE();
    case 2191:
      ACCEPT_TOKEN(aux_sym_command_argument_token1);
      if (lookahead == 'R'