
module Make

# 55 "asllib/Parser.mly"
          (Config : ParserConfig.CONFIG)
# 7 "asllib/Parser.ml"

= struct
  
  module MenhirBasics = struct
    
    exception Error of int
    
    let _eRR =
      fun _s ->
        raise (Error _s)
    
    type token = Tokens.token
    
  end
  
  include MenhirBasics
  
# 63 "asllib/Parser.mly"
  

open AST
open ASTUtils
open Desugar

let version = V1
let t_bit ~loc = T_Bits (E_Literal (L_Int Z.one) |> add_pos_from loc, [])
let zero ~loc = E_Literal (L_Int Z.zero) |> add_pos_from loc

let make_ty_decl_subtype (x, s) =
  let name, _fields = s.desc in
  let ty = ASTUtils.add_pos_from s (T_Named name) in
  D_TypeDecl (x, ty, Some s.desc)

let prec =
  let open AST in
  function
  | `BOR | `BAND | `IMPL | `BEQ -> 0
  | `EQ | `NE -> 1
  | `GT | `GE | `LT | `LE -> 2  (* Non assoc *)
  | `ADD | `SUB | `OR | `XOR | `AND | `BV_CONCAT | `STR_CONCAT | `BIC -> 3
  | `MUL | `DIV | `DIVRM | `RDIV | `MOD | `SHL | `SHR -> 4
  | `POW -> 5

let check_is_associative ~loc (op : AST.binop) =
  match op with
  | `ADD | `AND | `BAND | `BEQ | `BOR | `MUL | `OR | `XOR | `BV_CONCAT
  | `STR_CONCAT ->
      ()
  | _ ->
      Error.(
        fatal_from loc
          (CannotParse
             (Some
                (Format.sprintf
                   "Binary operator `%s` is not associative - parenthesise to \
                    disambiguate."
                   (PP.binop_to_string op)))))


let check_not_same_prec loc op op' =
  if prec op = prec op' then
    Error.(
      fatal_from loc
        (CannotParse
           (Some
              (Format.sprintf
                 "Operators `%s` and `%s` have the same precedence - parenthesise \
                  to disambiguate."
                 (PP.binop_to_string op) (PP.binop_to_string op')))))

let check_not_binop_same_prec op e =
  match e.desc with
  | E_Binop (op', _, _) ->
      if op = op' then check_is_associative ~loc:e op
      else check_not_same_prec e op op'
  | _ -> ()

let e_binop (e1, op, e2) =
  let () = check_not_binop_same_prec op e1
  and () = check_not_binop_same_prec op e2
  in
  E_Binop (op, e1, e2)

let e_call call = E_Call { call with call_type = ST_Function }
let s_call call = S_Call { call with call_type = ST_Procedure }

let le_var x = LE_Var x.desc |> add_pos_from x


# 97 "asllib/Parser.ml"
  
  type ('s, 'r) _menhir_state = 
    | MenhirState000 : ('s, _menhir_box_opn) _menhir_state
      (** State 000.
        Stack shape : .
        Start symbol: opn. *)

    | MenhirState001 : (('s, 'r) _menhir_cell1_WHILE, 'r) _menhir_state
      (** State 001.
        Stack shape : WHILE.
        Start symbol: <undetermined>. *)

    | MenhirState004 : (('s, 'r) _menhir_cell1_NOT, 'r) _menhir_state
      (** State 004.
        Stack shape : NOT.
        Start symbol: <undetermined>. *)

    | MenhirState005 : (('s, 'r) _menhir_cell1_MINUS, 'r) _menhir_state
      (** State 005.
        Stack shape : MINUS.
        Start symbol: <undetermined>. *)

    | MenhirState006 : (('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_state
      (** State 006.
        Stack shape : LPAR.
        Start symbol: <undetermined>. *)

    | MenhirState008 : (('s, 'r) _menhir_cell1_IF, 'r) _menhir_state
      (** State 008.
        Stack shape : IF.
        Start symbol: <undetermined>. *)

    | MenhirState009 : (('s, 'r) _menhir_cell1_IDENTIFIER, 'r) _menhir_state
      (** State 009.
        Stack shape : IDENTIFIER.
        Start symbol: <undetermined>. *)

    | MenhirState010 : ((('s, 'r) _menhir_cell1_IDENTIFIER, 'r) _menhir_cell1_LPAR, 'r) _menhir_state
      (** State 010.
        Stack shape : IDENTIFIER LPAR.
        Start symbol: <undetermined>. *)

    | MenhirState012 : (('s, 'r) _menhir_cell1_BNOT, 'r) _menhir_state
      (** State 012.
        Stack shape : BNOT.
        Start symbol: <undetermined>. *)

    | MenhirState015 : (('s, 'r) _menhir_cell1_ARBITRARY _menhir_cell0_COLON, 'r) _menhir_state
      (** State 015.
        Stack shape : ARBITRARY COLON.
        Start symbol: <undetermined>. *)

    | MenhirState018 : (('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_state
      (** State 018.
        Stack shape : LPAR.
        Start symbol: <undetermined>. *)

    | MenhirState019 : (('s, 'r) _menhir_cell1_INTEGER, 'r) _menhir_state
      (** State 019.
        Stack shape : INTEGER.
        Start symbol: <undetermined>. *)

    | MenhirState020 : (('s, 'r) _menhir_cell1_LBRACE, 'r) _menhir_state
      (** State 020.
        Stack shape : LBRACE.
        Start symbol: <undetermined>. *)

    | MenhirState022 : ((('s, 'r) _menhir_cell1_LBRACE, 'r) _menhir_cell1_MINUS, 'r) _menhir_state
      (** State 022.
        Stack shape : LBRACE MINUS.
        Start symbol: <undetermined>. *)

    | MenhirState025 : ((('s, 'r) _menhir_cell1_MINUS, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 025.
        Stack shape : MINUS expr.
        Start symbol: <undetermined>. *)

    | MenhirState026 : ((('s, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_LLBRACKET, 'r) _menhir_state
      (** State 026.
        Stack shape : expr LLBRACKET.
        Start symbol: <undetermined>. *)

    | MenhirState027 : (((('s, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_LLBRACKET, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 027.
        Stack shape : expr LLBRACKET expr.
        Start symbol: <undetermined>. *)

    | MenhirState028 : ((('s, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_XOR, 'r) _menhir_state
      (** State 028.
        Stack shape : expr XOR.
        Start symbol: <undetermined>. *)

    | MenhirState029 : (((('s, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_XOR, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 029.
        Stack shape : expr XOR expr.
        Start symbol: <undetermined>. *)

    | MenhirState030 : ((('s, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_SHR, 'r) _menhir_state
      (** State 030.
        Stack shape : expr SHR.
        Start symbol: <undetermined>. *)

    | MenhirState031 : (((('s, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_SHR, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 031.
        Stack shape : expr SHR expr.
        Start symbol: <undetermined>. *)

    | MenhirState032 : ((('s, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_POW, 'r) _menhir_state
      (** State 032.
        Stack shape : expr POW.
        Start symbol: <undetermined>. *)

    | MenhirState033 : (((('s, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_POW, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 033.
        Stack shape : expr POW expr.
        Start symbol: <undetermined>. *)

    | MenhirState034 : (('s, 'r) _menhir_cell1_LBRACKET, 'r) _menhir_state
      (** State 034.
        Stack shape : LBRACKET.
        Start symbol: <undetermined>. *)

    | MenhirState035 : (('s, 'r) _menhir_cell1_COLON, 'r) _menhir_state
      (** State 035.
        Stack shape : COLON.
        Start symbol: <undetermined>. *)

    | MenhirState036 : ((('s, 'r) _menhir_cell1_COLON, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 036.
        Stack shape : COLON expr.
        Start symbol: <undetermined>. *)

    | MenhirState037 : ((('s, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_SHL, 'r) _menhir_state
      (** State 037.
        Stack shape : expr SHL.
        Start symbol: <undetermined>. *)

    | MenhirState038 : (((('s, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_SHL, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 038.
        Stack shape : expr SHL expr.
        Start symbol: <undetermined>. *)

    | MenhirState039 : ((('s, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_IN, 'r) _menhir_state
      (** State 039.
        Stack shape : expr IN.
        Start symbol: <undetermined>. *)

    | MenhirState040 : (('s, 'r) _menhir_cell1_LBRACE, 'r) _menhir_state
      (** State 040.
        Stack shape : LBRACE.
        Start symbol: <undetermined>. *)

    | MenhirState041 : (('s, 'r) _menhir_cell1_NOT, 'r) _menhir_state
      (** State 041.
        Stack shape : NOT.
        Start symbol: <undetermined>. *)

    | MenhirState042 : ((('s, 'r) _menhir_cell1_NOT, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 042.
        Stack shape : NOT expr.
        Start symbol: <undetermined>. *)

    | MenhirState044 : ((('s, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_DOT _menhir_cell0_LBRACKET, 'r) _menhir_state
      (** State 044.
        Stack shape : expr DOT LBRACKET.
        Start symbol: <undetermined>. *)

    | MenhirState046 : (('s, 'r) _menhir_cell1_IDENTIFIER, 'r) _menhir_state
      (** State 046.
        Stack shape : IDENTIFIER.
        Start symbol: <undetermined>. *)

    | MenhirState053 : (('s, 'r) _menhir_cell1_MINUS, 'r) _menhir_state
      (** State 053.
        Stack shape : MINUS.
        Start symbol: <undetermined>. *)

    | MenhirState054 : ((('s, 'r) _menhir_cell1_MINUS, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 054.
        Stack shape : MINUS expr.
        Start symbol: <undetermined>. *)

    | MenhirState056 : (('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_state
      (** State 056.
        Stack shape : LPAR.
        Start symbol: <undetermined>. *)

    | MenhirState057 : (('s, 'r) _menhir_cell1_LE, 'r) _menhir_state
      (** State 057.
        Stack shape : LE.
        Start symbol: <undetermined>. *)

    | MenhirState058 : ((('s, 'r) _menhir_cell1_LE, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 058.
        Stack shape : LE expr.
        Start symbol: <undetermined>. *)

    | MenhirState059 : ((('s, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_RDIV, 'r) _menhir_state
      (** State 059.
        Stack shape : expr RDIV.
        Start symbol: <undetermined>. *)

    | MenhirState060 : (((('s, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_RDIV, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 060.
        Stack shape : expr RDIV expr.
        Start symbol: <undetermined>. *)

    | MenhirState061 : ((('s, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_PLUS_PLUS, 'r) _menhir_state
      (** State 061.
        Stack shape : expr PLUS_PLUS.
        Start symbol: <undetermined>. *)

    | MenhirState062 : (((('s, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_PLUS_PLUS, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 062.
        Stack shape : expr PLUS_PLUS expr.
        Start symbol: <undetermined>. *)

    | MenhirState063 : ((('s, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_MUL, 'r) _menhir_state
      (** State 063.
        Stack shape : expr MUL.
        Start symbol: <undetermined>. *)

    | MenhirState064 : (((('s, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_MUL, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 064.
        Stack shape : expr MUL expr.
        Start symbol: <undetermined>. *)

    | MenhirState065 : ((('s, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_MOD, 'r) _menhir_state
      (** State 065.
        Stack shape : expr MOD.
        Start symbol: <undetermined>. *)

    | MenhirState066 : (((('s, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_MOD, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 066.
        Stack shape : expr MOD expr.
        Start symbol: <undetermined>. *)

    | MenhirState067 : ((('s, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_DIVRM, 'r) _menhir_state
      (** State 067.
        Stack shape : expr DIVRM.
        Start symbol: <undetermined>. *)

    | MenhirState068 : (((('s, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_DIVRM, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 068.
        Stack shape : expr DIVRM expr.
        Start symbol: <undetermined>. *)

    | MenhirState069 : ((('s, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_DIV, 'r) _menhir_state
      (** State 069.
        Stack shape : expr DIV.
        Start symbol: <undetermined>. *)

    | MenhirState070 : (((('s, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_DIV, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 070.
        Stack shape : expr DIV expr.
        Start symbol: <undetermined>. *)

    | MenhirState071 : ((('s, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_PLUS, 'r) _menhir_state
      (** State 071.
        Stack shape : expr PLUS.
        Start symbol: <undetermined>. *)

    | MenhirState072 : (((('s, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_PLUS, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 072.
        Stack shape : expr PLUS expr.
        Start symbol: <undetermined>. *)

    | MenhirState073 : ((('s, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_OR, 'r) _menhir_state
      (** State 073.
        Stack shape : expr OR.
        Start symbol: <undetermined>. *)

    | MenhirState074 : (((('s, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_OR, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 074.
        Stack shape : expr OR expr.
        Start symbol: <undetermined>. *)

    | MenhirState075 : ((('s, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_NE, 'r) _menhir_state
      (** State 075.
        Stack shape : expr NE.
        Start symbol: <undetermined>. *)

    | MenhirState077 : (((('s, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_NE, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 077.
        Stack shape : expr NE expr.
        Start symbol: <undetermined>. *)

    | MenhirState078 : ((('s, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_MINUS, 'r) _menhir_state
      (** State 078.
        Stack shape : expr MINUS.
        Start symbol: <undetermined>. *)

    | MenhirState079 : (((('s, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_MINUS, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 079.
        Stack shape : expr MINUS expr.
        Start symbol: <undetermined>. *)

    | MenhirState080 : ((('s, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_LT, 'r) _menhir_state
      (** State 080.
        Stack shape : expr LT.
        Start symbol: <undetermined>. *)

    | MenhirState081 : (((('s, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_LT, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 081.
        Stack shape : expr LT expr.
        Start symbol: <undetermined>. *)

    | MenhirState082 : ((('s, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_COLON_COLON, 'r) _menhir_state
      (** State 082.
        Stack shape : expr COLON_COLON.
        Start symbol: <undetermined>. *)

    | MenhirState083 : (((('s, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_COLON_COLON, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 083.
        Stack shape : expr COLON_COLON expr.
        Start symbol: <undetermined>. *)

    | MenhirState084 : ((('s, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_AND, 'r) _menhir_state
      (** State 084.
        Stack shape : expr AND.
        Start symbol: <undetermined>. *)

    | MenhirState085 : (((('s, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_AND, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 085.
        Stack shape : expr AND expr.
        Start symbol: <undetermined>. *)

    | MenhirState086 : ((('s, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_LE, 'r) _menhir_state
      (** State 086.
        Stack shape : expr LE.
        Start symbol: <undetermined>. *)

    | MenhirState087 : (((('s, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_LE, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 087.
        Stack shape : expr LE expr.
        Start symbol: <undetermined>. *)

    | MenhirState088 : ((('s, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_GT, 'r) _menhir_state
      (** State 088.
        Stack shape : expr GT.
        Start symbol: <undetermined>. *)

    | MenhirState089 : (((('s, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_GT, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 089.
        Stack shape : expr GT expr.
        Start symbol: <undetermined>. *)

    | MenhirState090 : ((('s, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_GE, 'r) _menhir_state
      (** State 090.
        Stack shape : expr GE.
        Start symbol: <undetermined>. *)

    | MenhirState091 : (((('s, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_GE, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 091.
        Stack shape : expr GE expr.
        Start symbol: <undetermined>. *)

    | MenhirState092 : ((('s, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_IMPL, 'r) _menhir_state
      (** State 092.
        Stack shape : expr IMPL.
        Start symbol: <undetermined>. *)

    | MenhirState093 : (((('s, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_IMPL, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 093.
        Stack shape : expr IMPL expr.
        Start symbol: <undetermined>. *)

    | MenhirState094 : ((('s, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_EQ_EQ, 'r) _menhir_state
      (** State 094.
        Stack shape : expr EQ_EQ.
        Start symbol: <undetermined>. *)

    | MenhirState096 : (((('s, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_EQ_EQ, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 096.
        Stack shape : expr EQ_EQ expr.
        Start symbol: <undetermined>. *)

    | MenhirState097 : ((('s, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_BOR, 'r) _menhir_state
      (** State 097.
        Stack shape : expr BOR.
        Start symbol: <undetermined>. *)

    | MenhirState098 : (((('s, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_BOR, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 098.
        Stack shape : expr BOR expr.
        Start symbol: <undetermined>. *)

    | MenhirState099 : ((('s, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_BEQ, 'r) _menhir_state
      (** State 099.
        Stack shape : expr BEQ.
        Start symbol: <undetermined>. *)

    | MenhirState100 : (((('s, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_BEQ, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 100.
        Stack shape : expr BEQ expr.
        Start symbol: <undetermined>. *)

    | MenhirState101 : ((('s, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_BAND, 'r) _menhir_state
      (** State 101.
        Stack shape : expr BAND.
        Start symbol: <undetermined>. *)

    | MenhirState102 : (((('s, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_BAND, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 102.
        Stack shape : expr BAND expr.
        Start symbol: <undetermined>. *)

    | MenhirState103 : ((('s, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_AS, 'r) _menhir_state
      (** State 103.
        Stack shape : expr AS.
        Start symbol: <undetermined>. *)

    | MenhirState107 : (('s, 'r) _menhir_cell1_BITS _menhir_cell0_LPAR, 'r) _menhir_state
      (** State 107.
        Stack shape : BITS LPAR.
        Start symbol: <undetermined>. *)

    | MenhirState108 : ((('s, 'r) _menhir_cell1_BITS _menhir_cell0_LPAR, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 108.
        Stack shape : BITS LPAR expr.
        Start symbol: <undetermined>. *)

    | MenhirState109 : (((('s, 'r) _menhir_cell1_BITS _menhir_cell0_LPAR, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_RPAR, 'r) _menhir_state
      (** State 109.
        Stack shape : BITS LPAR expr RPAR.
        Start symbol: <undetermined>. *)

    | MenhirState110 : (('s, 'r) _menhir_cell1_LBRACE, 'r) _menhir_state
      (** State 110.
        Stack shape : LBRACE.
        Start symbol: <undetermined>. *)

    | MenhirState115 : (('s, 'r) _menhir_cell1_slices _menhir_cell0_IDENTIFIER, 'r) _menhir_state
      (** State 115.
        Stack shape : slices IDENTIFIER.
        Start symbol: <undetermined>. *)

    | MenhirState116 : (('s, 'r) _menhir_cell1_COLON, 'r) _menhir_state
      (** State 116.
        Stack shape : COLON.
        Start symbol: <undetermined>. *)

    | MenhirState119 : (('s, 'r) _menhir_cell1_ARRAY, 'r) _menhir_state
      (** State 119.
        Stack shape : ARRAY.
        Start symbol: <undetermined>. *)

    | MenhirState120 : ((('s, 'r) _menhir_cell1_ARRAY, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 120.
        Stack shape : ARRAY expr.
        Start symbol: <undetermined>. *)

    | MenhirState122 : (((('s, 'r) _menhir_cell1_ARRAY, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_RRBRACKET, 'r) _menhir_state
      (** State 122.
        Stack shape : ARRAY expr RRBRACKET.
        Start symbol: <undetermined>. *)

    | MenhirState128 : (('s, 'r) _menhir_cell1_bitfield, 'r) _menhir_state
      (** State 128.
        Stack shape : bitfield.
        Start symbol: <undetermined>. *)

    | MenhirState134 : (('s, 'r) _menhir_cell1_IF, 'r) _menhir_state
      (** State 134.
        Stack shape : IF.
        Start symbol: <undetermined>. *)

    | MenhirState135 : ((('s, 'r) _menhir_cell1_IF, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 135.
        Stack shape : IF expr.
        Start symbol: <undetermined>. *)

    | MenhirState136 : (((('s, 'r) _menhir_cell1_IF, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_THEN, 'r) _menhir_state
      (** State 136.
        Stack shape : IF expr THEN.
        Start symbol: <undetermined>. *)

    | MenhirState137 : ((((('s, 'r) _menhir_cell1_IF, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_THEN, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 137.
        Stack shape : IF expr THEN expr.
        Start symbol: <undetermined>. *)

    | MenhirState139 : (((((('s, 'r) _menhir_cell1_IF, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_THEN, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_ELSE, 'r) _menhir_state
      (** State 139.
        Stack shape : IF expr THEN expr ELSE.
        Start symbol: <undetermined>. *)

    | MenhirState140 : ((((((('s, 'r) _menhir_cell1_IF, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_THEN, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_ELSE, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 140.
        Stack shape : IF expr THEN expr ELSE expr.
        Start symbol: <undetermined>. *)

    | MenhirState142 : (('s, 'r) _menhir_cell1_IDENTIFIER, 'r) _menhir_state
      (** State 142.
        Stack shape : IDENTIFIER.
        Start symbol: <undetermined>. *)

    | MenhirState143 : ((('s, 'r) _menhir_cell1_IDENTIFIER, 'r) _menhir_cell1_LBRACE, 'r) _menhir_state
      (** State 143.
        Stack shape : IDENTIFIER LBRACE.
        Start symbol: <undetermined>. *)

    | MenhirState144 : (((('s, 'r) _menhir_cell1_IDENTIFIER, 'r) _menhir_cell1_LBRACE, 'r) _menhir_cell1_MINUS, 'r) _menhir_state
      (** State 144.
        Stack shape : IDENTIFIER LBRACE MINUS.
        Start symbol: <undetermined>. *)

    | MenhirState146 : (((('s, 'r) _menhir_cell1_IDENTIFIER, 'r) _menhir_cell1_LBRACE, 'r) _menhir_cell1_IDENTIFIER, 'r) _menhir_state
      (** State 146.
        Stack shape : IDENTIFIER LBRACE IDENTIFIER.
        Start symbol: <undetermined>. *)

    | MenhirState147 : ((('s, 'r) _menhir_cell1_IDENTIFIER, 'r) _menhir_cell1_LBRACE, 'r) _menhir_state
      (** State 147.
        Stack shape : IDENTIFIER LBRACE.
        Start symbol: <undetermined>. *)

    | MenhirState148 : (((('s, 'r) _menhir_cell1_IDENTIFIER, 'r) _menhir_cell1_LBRACE, 'r) _menhir_cell1_MINUS, 'r) _menhir_state
      (** State 148.
        Stack shape : IDENTIFIER LBRACE MINUS.
        Start symbol: <undetermined>. *)

    | MenhirState151 : (('s, 'r) _menhir_cell1_field_assign, 'r) _menhir_state
      (** State 151.
        Stack shape : field_assign.
        Start symbol: <undetermined>. *)

    | MenhirState152 : ((('s, 'r) _menhir_cell1_field_assign, 'r) _menhir_cell1_IDENTIFIER, 'r) _menhir_state
      (** State 152.
        Stack shape : field_assign IDENTIFIER.
        Start symbol: <undetermined>. *)

    | MenhirState153 : ((('s, 'r) _menhir_cell1_IDENTIFIER, 'r) _menhir_cell1_EQ, 'r) _menhir_state
      (** State 153.
        Stack shape : IDENTIFIER EQ.
        Start symbol: <undetermined>. *)

    | MenhirState154 : (((('s, 'r) _menhir_cell1_IDENTIFIER, 'r) _menhir_cell1_EQ, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 154.
        Stack shape : IDENTIFIER EQ expr.
        Start symbol: <undetermined>. *)

    | MenhirState156 : (('s, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 156.
        Stack shape : expr.
        Start symbol: <undetermined>. *)

    | MenhirState157 : ((('s, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_COMMA, 'r) _menhir_state
      (** State 157.
        Stack shape : expr COMMA.
        Start symbol: <undetermined>. *)

    | MenhirState163 : (((('s, 'r) _menhir_cell1_IDENTIFIER, 'r) _menhir_cell1_LBRACE, 'r) _menhir_cell1_clist1_expr_ _menhir_cell0_RBRACE _menhir_cell0_LPAR, 'r) _menhir_state
      (** State 163.
        Stack shape : IDENTIFIER LBRACE clist1(expr) RBRACE LPAR.
        Start symbol: <undetermined>. *)

    | MenhirState169 : (('s, 'r) _menhir_cell1_GE, 'r) _menhir_state
      (** State 169.
        Stack shape : GE.
        Start symbol: <undetermined>. *)

    | MenhirState170 : ((('s, 'r) _menhir_cell1_GE, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 170.
        Stack shape : GE expr.
        Start symbol: <undetermined>. *)

    | MenhirState171 : (('s, 'r) _menhir_cell1_BNOT, 'r) _menhir_state
      (** State 171.
        Stack shape : BNOT.
        Start symbol: <undetermined>. *)

    | MenhirState172 : ((('s, 'r) _menhir_cell1_BNOT, 'r) _menhir_cell1_LBRACE, 'r) _menhir_state
      (** State 172.
        Stack shape : BNOT LBRACE.
        Start symbol: <undetermined>. *)

    | MenhirState174 : (('s, 'r) _menhir_cell1_ARBITRARY _menhir_cell0_COLON, 'r) _menhir_state
      (** State 174.
        Stack shape : ARBITRARY COLON.
        Start symbol: <undetermined>. *)

    | MenhirState181 : (('s, 'r) _menhir_cell1_pattern, 'r) _menhir_state
      (** State 181.
        Stack shape : pattern.
        Start symbol: <undetermined>. *)

    | MenhirState182 : (('s, 'r) _menhir_cell1_expr_pattern, 'r) _menhir_state
      (** State 182.
        Stack shape : expr_pattern.
        Start symbol: <undetermined>. *)

    | MenhirState183 : ((('s, 'r) _menhir_cell1_expr_pattern, 'r) _menhir_cell1_XOR, 'r) _menhir_state
      (** State 183.
        Stack shape : expr_pattern XOR.
        Start symbol: <undetermined>. *)

    | MenhirState184 : (((('s, 'r) _menhir_cell1_expr_pattern, 'r) _menhir_cell1_XOR, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 184.
        Stack shape : expr_pattern XOR expr.
        Start symbol: <undetermined>. *)

    | MenhirState185 : ((('s, 'r) _menhir_cell1_expr_pattern, 'r) _menhir_cell1_SLICING, 'r) _menhir_state
      (** State 185.
        Stack shape : expr_pattern SLICING.
        Start symbol: <undetermined>. *)

    | MenhirState186 : (((('s, 'r) _menhir_cell1_expr_pattern, 'r) _menhir_cell1_SLICING, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 186.
        Stack shape : expr_pattern SLICING expr.
        Start symbol: <undetermined>. *)

    | MenhirState187 : ((('s, 'r) _menhir_cell1_expr_pattern, 'r) _menhir_cell1_SHR, 'r) _menhir_state
      (** State 187.
        Stack shape : expr_pattern SHR.
        Start symbol: <undetermined>. *)

    | MenhirState188 : (((('s, 'r) _menhir_cell1_expr_pattern, 'r) _menhir_cell1_SHR, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 188.
        Stack shape : expr_pattern SHR expr.
        Start symbol: <undetermined>. *)

    | MenhirState189 : ((('s, 'r) _menhir_cell1_expr_pattern, 'r) _menhir_cell1_SHL, 'r) _menhir_state
      (** State 189.
        Stack shape : expr_pattern SHL.
        Start symbol: <undetermined>. *)

    | MenhirState190 : (((('s, 'r) _menhir_cell1_expr_pattern, 'r) _menhir_cell1_SHL, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 190.
        Stack shape : expr_pattern SHL expr.
        Start symbol: <undetermined>. *)

    | MenhirState191 : ((('s, 'r) _menhir_cell1_expr_pattern, 'r) _menhir_cell1_RDIV, 'r) _menhir_state
      (** State 191.
        Stack shape : expr_pattern RDIV.
        Start symbol: <undetermined>. *)

    | MenhirState192 : (((('s, 'r) _menhir_cell1_expr_pattern, 'r) _menhir_cell1_RDIV, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 192.
        Stack shape : expr_pattern RDIV expr.
        Start symbol: <undetermined>. *)

    | MenhirState193 : ((('s, 'r) _menhir_cell1_expr_pattern, 'r) _menhir_cell1_POW, 'r) _menhir_state
      (** State 193.
        Stack shape : expr_pattern POW.
        Start symbol: <undetermined>. *)

    | MenhirState194 : (((('s, 'r) _menhir_cell1_expr_pattern, 'r) _menhir_cell1_POW, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 194.
        Stack shape : expr_pattern POW expr.
        Start symbol: <undetermined>. *)

    | MenhirState195 : ((('s, 'r) _menhir_cell1_expr_pattern, 'r) _menhir_cell1_PLUS_PLUS, 'r) _menhir_state
      (** State 195.
        Stack shape : expr_pattern PLUS_PLUS.
        Start symbol: <undetermined>. *)

    | MenhirState196 : (((('s, 'r) _menhir_cell1_expr_pattern, 'r) _menhir_cell1_PLUS_PLUS, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 196.
        Stack shape : expr_pattern PLUS_PLUS expr.
        Start symbol: <undetermined>. *)

    | MenhirState197 : ((('s, 'r) _menhir_cell1_expr_pattern, 'r) _menhir_cell1_PLUS, 'r) _menhir_state
      (** State 197.
        Stack shape : expr_pattern PLUS.
        Start symbol: <undetermined>. *)

    | MenhirState198 : (((('s, 'r) _menhir_cell1_expr_pattern, 'r) _menhir_cell1_PLUS, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 198.
        Stack shape : expr_pattern PLUS expr.
        Start symbol: <undetermined>. *)

    | MenhirState199 : ((('s, 'r) _menhir_cell1_expr_pattern, 'r) _menhir_cell1_OR, 'r) _menhir_state
      (** State 199.
        Stack shape : expr_pattern OR.
        Start symbol: <undetermined>. *)

    | MenhirState200 : (((('s, 'r) _menhir_cell1_expr_pattern, 'r) _menhir_cell1_OR, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 200.
        Stack shape : expr_pattern OR expr.
        Start symbol: <undetermined>. *)

    | MenhirState201 : ((('s, 'r) _menhir_cell1_expr_pattern, 'r) _menhir_cell1_NE, 'r) _menhir_state
      (** State 201.
        Stack shape : expr_pattern NE.
        Start symbol: <undetermined>. *)

    | MenhirState203 : (((('s, 'r) _menhir_cell1_expr_pattern, 'r) _menhir_cell1_NE, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 203.
        Stack shape : expr_pattern NE expr.
        Start symbol: <undetermined>. *)

    | MenhirState204 : ((('s, 'r) _menhir_cell1_expr_pattern, 'r) _menhir_cell1_MUL, 'r) _menhir_state
      (** State 204.
        Stack shape : expr_pattern MUL.
        Start symbol: <undetermined>. *)

    | MenhirState205 : (((('s, 'r) _menhir_cell1_expr_pattern, 'r) _menhir_cell1_MUL, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 205.
        Stack shape : expr_pattern MUL expr.
        Start symbol: <undetermined>. *)

    | MenhirState206 : ((('s, 'r) _menhir_cell1_expr_pattern, 'r) _menhir_cell1_MOD, 'r) _menhir_state
      (** State 206.
        Stack shape : expr_pattern MOD.
        Start symbol: <undetermined>. *)

    | MenhirState207 : (((('s, 'r) _menhir_cell1_expr_pattern, 'r) _menhir_cell1_MOD, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 207.
        Stack shape : expr_pattern MOD expr.
        Start symbol: <undetermined>. *)

    | MenhirState208 : ((('s, 'r) _menhir_cell1_expr_pattern, 'r) _menhir_cell1_MINUS, 'r) _menhir_state
      (** State 208.
        Stack shape : expr_pattern MINUS.
        Start symbol: <undetermined>. *)

    | MenhirState209 : (((('s, 'r) _menhir_cell1_expr_pattern, 'r) _menhir_cell1_MINUS, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 209.
        Stack shape : expr_pattern MINUS expr.
        Start symbol: <undetermined>. *)

    | MenhirState210 : ((('s, 'r) _menhir_cell1_expr_pattern, 'r) _menhir_cell1_LT, 'r) _menhir_state
      (** State 210.
        Stack shape : expr_pattern LT.
        Start symbol: <undetermined>. *)

    | MenhirState211 : (((('s, 'r) _menhir_cell1_expr_pattern, 'r) _menhir_cell1_LT, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 211.
        Stack shape : expr_pattern LT expr.
        Start symbol: <undetermined>. *)

    | MenhirState212 : ((('s, 'r) _menhir_cell1_expr_pattern, 'r) _menhir_cell1_LLBRACKET, 'r) _menhir_state
      (** State 212.
        Stack shape : expr_pattern LLBRACKET.
        Start symbol: <undetermined>. *)

    | MenhirState213 : (((('s, 'r) _menhir_cell1_expr_pattern, 'r) _menhir_cell1_LLBRACKET, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 213.
        Stack shape : expr_pattern LLBRACKET expr.
        Start symbol: <undetermined>. *)

    | MenhirState215 : ((('s, 'r) _menhir_cell1_expr_pattern, 'r) _menhir_cell1_LE, 'r) _menhir_state
      (** State 215.
        Stack shape : expr_pattern LE.
        Start symbol: <undetermined>. *)

    | MenhirState216 : (((('s, 'r) _menhir_cell1_expr_pattern, 'r) _menhir_cell1_LE, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 216.
        Stack shape : expr_pattern LE expr.
        Start symbol: <undetermined>. *)

    | MenhirState217 : ((('s, 'r) _menhir_cell1_expr_pattern, 'r) _menhir_cell1_IN, 'r) _menhir_state
      (** State 217.
        Stack shape : expr_pattern IN.
        Start symbol: <undetermined>. *)

    | MenhirState218 : ((('s, 'r) _menhir_cell1_IN, 'r) _menhir_cell1_BNOT, 'r) _menhir_state
      (** State 218.
        Stack shape : IN BNOT.
        Start symbol: <undetermined>. *)

    | MenhirState220 : ((('s, 'r) _menhir_cell1_expr_pattern, 'r) _menhir_cell1_IMPL, 'r) _menhir_state
      (** State 220.
        Stack shape : expr_pattern IMPL.
        Start symbol: <undetermined>. *)

    | MenhirState221 : (((('s, 'r) _menhir_cell1_expr_pattern, 'r) _menhir_cell1_IMPL, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 221.
        Stack shape : expr_pattern IMPL expr.
        Start symbol: <undetermined>. *)

    | MenhirState222 : ((('s, 'r) _menhir_cell1_expr_pattern, 'r) _menhir_cell1_GT, 'r) _menhir_state
      (** State 222.
        Stack shape : expr_pattern GT.
        Start symbol: <undetermined>. *)

    | MenhirState223 : (((('s, 'r) _menhir_cell1_expr_pattern, 'r) _menhir_cell1_GT, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 223.
        Stack shape : expr_pattern GT expr.
        Start symbol: <undetermined>. *)

    | MenhirState224 : ((('s, 'r) _menhir_cell1_expr_pattern, 'r) _menhir_cell1_GE, 'r) _menhir_state
      (** State 224.
        Stack shape : expr_pattern GE.
        Start symbol: <undetermined>. *)

    | MenhirState225 : (((('s, 'r) _menhir_cell1_expr_pattern, 'r) _menhir_cell1_GE, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 225.
        Stack shape : expr_pattern GE expr.
        Start symbol: <undetermined>. *)

    | MenhirState226 : ((('s, 'r) _menhir_cell1_expr_pattern, 'r) _menhir_cell1_EQ_EQ, 'r) _menhir_state
      (** State 226.
        Stack shape : expr_pattern EQ_EQ.
        Start symbol: <undetermined>. *)

    | MenhirState228 : (((('s, 'r) _menhir_cell1_expr_pattern, 'r) _menhir_cell1_EQ_EQ, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 228.
        Stack shape : expr_pattern EQ_EQ expr.
        Start symbol: <undetermined>. *)

    | MenhirState230 : ((('s, 'r) _menhir_cell1_expr_pattern, 'r) _menhir_cell1_DOT _menhir_cell0_LBRACKET, 'r) _menhir_state
      (** State 230.
        Stack shape : expr_pattern DOT LBRACKET.
        Start symbol: <undetermined>. *)

    | MenhirState234 : ((('s, 'r) _menhir_cell1_expr_pattern, 'r) _menhir_cell1_DIVRM, 'r) _menhir_state
      (** State 234.
        Stack shape : expr_pattern DIVRM.
        Start symbol: <undetermined>. *)

    | MenhirState235 : (((('s, 'r) _menhir_cell1_expr_pattern, 'r) _menhir_cell1_DIVRM, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 235.
        Stack shape : expr_pattern DIVRM expr.
        Start symbol: <undetermined>. *)

    | MenhirState236 : ((('s, 'r) _menhir_cell1_expr_pattern, 'r) _menhir_cell1_DIV, 'r) _menhir_state
      (** State 236.
        Stack shape : expr_pattern DIV.
        Start symbol: <undetermined>. *)

    | MenhirState237 : (((('s, 'r) _menhir_cell1_expr_pattern, 'r) _menhir_cell1_DIV, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 237.
        Stack shape : expr_pattern DIV expr.
        Start symbol: <undetermined>. *)

    | MenhirState238 : ((('s, 'r) _menhir_cell1_expr_pattern, 'r) _menhir_cell1_COLON_COLON, 'r) _menhir_state
      (** State 238.
        Stack shape : expr_pattern COLON_COLON.
        Start symbol: <undetermined>. *)

    | MenhirState239 : (((('s, 'r) _menhir_cell1_expr_pattern, 'r) _menhir_cell1_COLON_COLON, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 239.
        Stack shape : expr_pattern COLON_COLON expr.
        Start symbol: <undetermined>. *)

    | MenhirState240 : ((('s, 'r) _menhir_cell1_expr_pattern, 'r) _menhir_cell1_BOR, 'r) _menhir_state
      (** State 240.
        Stack shape : expr_pattern BOR.
        Start symbol: <undetermined>. *)

    | MenhirState241 : (((('s, 'r) _menhir_cell1_expr_pattern, 'r) _menhir_cell1_BOR, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 241.
        Stack shape : expr_pattern BOR expr.
        Start symbol: <undetermined>. *)

    | MenhirState242 : ((('s, 'r) _menhir_cell1_expr_pattern, 'r) _menhir_cell1_BEQ, 'r) _menhir_state
      (** State 242.
        Stack shape : expr_pattern BEQ.
        Start symbol: <undetermined>. *)

    | MenhirState243 : (((('s, 'r) _menhir_cell1_expr_pattern, 'r) _menhir_cell1_BEQ, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 243.
        Stack shape : expr_pattern BEQ expr.
        Start symbol: <undetermined>. *)

    | MenhirState244 : ((('s, 'r) _menhir_cell1_expr_pattern, 'r) _menhir_cell1_BAND, 'r) _menhir_state
      (** State 244.
        Stack shape : expr_pattern BAND.
        Start symbol: <undetermined>. *)

    | MenhirState245 : (((('s, 'r) _menhir_cell1_expr_pattern, 'r) _menhir_cell1_BAND, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 245.
        Stack shape : expr_pattern BAND expr.
        Start symbol: <undetermined>. *)

    | MenhirState246 : ((('s, 'r) _menhir_cell1_expr_pattern, 'r) _menhir_cell1_AS, 'r) _menhir_state
      (** State 246.
        Stack shape : expr_pattern AS.
        Start symbol: <undetermined>. *)

    | MenhirState249 : ((('s, 'r) _menhir_cell1_expr_pattern, 'r) _menhir_cell1_AND, 'r) _menhir_state
      (** State 249.
        Stack shape : expr_pattern AND.
        Start symbol: <undetermined>. *)

    | MenhirState250 : (((('s, 'r) _menhir_cell1_expr_pattern, 'r) _menhir_cell1_AND, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 250.
        Stack shape : expr_pattern AND expr.
        Start symbol: <undetermined>. *)

    | MenhirState255 : ((('s, 'r) _menhir_cell1_BNOT, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 255.
        Stack shape : BNOT expr.
        Start symbol: <undetermined>. *)

    | MenhirState257 : ((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_pattern, 'r) _menhir_state
      (** State 257.
        Stack shape : LPAR pattern.
        Start symbol: <undetermined>. *)

    | MenhirState259 : ((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_expr_pattern, 'r) _menhir_state
      (** State 259.
        Stack shape : LPAR expr_pattern.
        Start symbol: <undetermined>. *)

    | MenhirState267 : (('s, 'r) _menhir_cell1_slice, 'r) _menhir_state
      (** State 267.
        Stack shape : slice.
        Start symbol: <undetermined>. *)

    | MenhirState268 : (('s, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 268.
        Stack shape : expr.
        Start symbol: <undetermined>. *)

    | MenhirState269 : ((('s, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_STAR_COLON, 'r) _menhir_state
      (** State 269.
        Stack shape : expr STAR_COLON.
        Start symbol: <undetermined>. *)

    | MenhirState270 : (((('s, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_STAR_COLON, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 270.
        Stack shape : expr STAR_COLON expr.
        Start symbol: <undetermined>. *)

    | MenhirState271 : ((('s, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_PLUS_COLON, 'r) _menhir_state
      (** State 271.
        Stack shape : expr PLUS_COLON.
        Start symbol: <undetermined>. *)

    | MenhirState272 : (((('s, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_PLUS_COLON, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 272.
        Stack shape : expr PLUS_COLON expr.
        Start symbol: <undetermined>. *)

    | MenhirState273 : ((('s, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_COLON, 'r) _menhir_state
      (** State 273.
        Stack shape : expr COLON.
        Start symbol: <undetermined>. *)

    | MenhirState274 : (((('s, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_COLON, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 274.
        Stack shape : expr COLON expr.
        Start symbol: <undetermined>. *)

    | MenhirState280 : (('s, 'r) _menhir_cell1_int_constraint, 'r) _menhir_state
      (** State 280.
        Stack shape : int_constraint.
        Start symbol: <undetermined>. *)

    | MenhirState281 : (('s, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 281.
        Stack shape : expr.
        Start symbol: <undetermined>. *)

    | MenhirState282 : ((('s, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_SLICING, 'r) _menhir_state
      (** State 282.
        Stack shape : expr SLICING.
        Start symbol: <undetermined>. *)

    | MenhirState283 : (((('s, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_SLICING, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 283.
        Stack shape : expr SLICING expr.
        Start symbol: <undetermined>. *)

    | MenhirState291 : ((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_ty, 'r) _menhir_state
      (** State 291.
        Stack shape : LPAR ty.
        Start symbol: <undetermined>. *)

    | MenhirState293 : ((('s, 'r) _menhir_cell1_ty, 'r) _menhir_cell1_ty, 'r) _menhir_state
      (** State 293.
        Stack shape : ty ty.
        Start symbol: <undetermined>. *)

    | MenhirState299 : ((('s, 'r) _menhir_cell1_BNOT, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 299.
        Stack shape : BNOT expr.
        Start symbol: <undetermined>. *)

    | MenhirState302 : ((('s, 'r) _menhir_cell1_IF, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 302.
        Stack shape : IF expr.
        Start symbol: <undetermined>. *)

    | MenhirState303 : (((('s, 'r) _menhir_cell1_IF, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_THEN, 'r) _menhir_state
      (** State 303.
        Stack shape : IF expr THEN.
        Start symbol: <undetermined>. *)

    | MenhirState304 : ((((('s, 'r) _menhir_cell1_IF, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_THEN, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 304.
        Stack shape : IF expr THEN expr.
        Start symbol: <undetermined>. *)

    | MenhirState306 : ((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 306.
        Stack shape : LPAR expr.
        Start symbol: <undetermined>. *)

    | MenhirState308 : (((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_COMMA, 'r) _menhir_state
      (** State 308.
        Stack shape : LPAR expr COMMA.
        Start symbol: <undetermined>. *)

    | MenhirState312 : ((('s, 'r) _menhir_cell1_NOT, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 312.
        Stack shape : NOT expr.
        Start symbol: <undetermined>. *)

    | MenhirState313 : ((('s, 'r) _menhir_cell1_WHILE, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 313.
        Stack shape : WHILE expr.
        Start symbol: <undetermined>. *)

    | MenhirState314 : ((('s, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_LOOPLIMIT, 'r) _menhir_state
      (** State 314.
        Stack shape : expr LOOPLIMIT.
        Start symbol: <undetermined>. *)

    | MenhirState315 : (((('s, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_LOOPLIMIT, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 315.
        Stack shape : expr LOOPLIMIT expr.
        Start symbol: <undetermined>. *)

    | MenhirState317 : (((('s, 'r) _menhir_cell1_WHILE, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_loop_limit, 'r) _menhir_state
      (** State 317.
        Stack shape : WHILE expr loop_limit.
        Start symbol: <undetermined>. *)

    | MenhirState318 : (('s, 'r) _menhir_cell1_VAR, 'r) _menhir_state
      (** State 318.
        Stack shape : VAR.
        Start symbol: <undetermined>. *)

    | MenhirState320 : (('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_state
      (** State 320.
        Stack shape : LPAR.
        Start symbol: <undetermined>. *)

    | MenhirState324 : ((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_discard_or_identifier, 'r) _menhir_state
      (** State 324.
        Stack shape : LPAR discard_or_identifier.
        Start symbol: <undetermined>. *)

    | MenhirState326 : ((('s, 'r) _menhir_cell1_discard_or_identifier, 'r) _menhir_cell1_discard_or_identifier, 'r) _menhir_state
      (** State 326.
        Stack shape : discard_or_identifier discard_or_identifier.
        Start symbol: <undetermined>. *)

    | MenhirState332 : ((('s, 'r) _menhir_cell1_VAR, 'r) _menhir_cell1_IDENTIFIER, 'r) _menhir_state
      (** State 332.
        Stack shape : VAR IDENTIFIER.
        Start symbol: <undetermined>. *)

    | MenhirState334 : ((('s, 'r) _menhir_cell1_IDENTIFIER, 'r) _menhir_cell1_IDENTIFIER, 'r) _menhir_state
      (** State 334.
        Stack shape : IDENTIFIER IDENTIFIER.
        Start symbol: <undetermined>. *)

    | MenhirState337 : ((('s, 'r) _menhir_cell1_VAR, 'r) _menhir_cell1_decl_item, 'r) _menhir_state
      (** State 337.
        Stack shape : VAR decl_item.
        Start symbol: <undetermined>. *)

    | MenhirState338 : (((('s, 'r) _menhir_cell1_VAR, 'r) _menhir_cell1_decl_item, 'r) _menhir_cell1_EQ, 'r) _menhir_state
      (** State 338.
        Stack shape : VAR decl_item EQ.
        Start symbol: <undetermined>. *)

    | MenhirState339 : ((((('s, 'r) _menhir_cell1_VAR, 'r) _menhir_cell1_decl_item, 'r) _menhir_cell1_EQ, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 339.
        Stack shape : VAR decl_item EQ expr.
        Start symbol: <undetermined>. *)

    | MenhirState343 : (((('s, 'r) _menhir_cell1_VAR, 'r) _menhir_cell1_decl_item, 'r) _menhir_cell1_as_ty, 'r) _menhir_state
      (** State 343.
        Stack shape : VAR decl_item as_ty.
        Start symbol: <undetermined>. *)

    | MenhirState344 : ((('s, 'r) _menhir_cell1_as_ty, 'r) _menhir_cell1_IDENTIFIER, 'r) _menhir_state
      (** State 344.
        Stack shape : as_ty IDENTIFIER.
        Start symbol: <undetermined>. *)

    | MenhirState345 : (((('s, 'r) _menhir_cell1_as_ty, 'r) _menhir_cell1_IDENTIFIER, 'r) _menhir_cell1_LBRACE, 'r) _menhir_state
      (** State 345.
        Stack shape : as_ty IDENTIFIER LBRACE.
        Start symbol: <undetermined>. *)

    | MenhirState347 : ((((('s, 'r) _menhir_cell1_as_ty, 'r) _menhir_cell1_IDENTIFIER, 'r) _menhir_cell1_LBRACE, 'r) _menhir_cell1_RBRACE _menhir_cell0_LPAR, 'r) _menhir_state
      (** State 347.
        Stack shape : as_ty IDENTIFIER LBRACE RBRACE LPAR.
        Start symbol: <undetermined>. *)

    | MenhirState350 : ((((('s, 'r) _menhir_cell1_as_ty, 'r) _menhir_cell1_IDENTIFIER, 'r) _menhir_cell1_LBRACE, 'r) _menhir_cell1_COMMA, 'r) _menhir_state
      (** State 350.
        Stack shape : as_ty IDENTIFIER LBRACE COMMA.
        Start symbol: <undetermined>. *)

    | MenhirState353 : (((((('s, 'r) _menhir_cell1_as_ty, 'r) _menhir_cell1_IDENTIFIER, 'r) _menhir_cell1_LBRACE, 'r) _menhir_cell1_COMMA, 'r) _menhir_cell1_clist1_expr_ _menhir_cell0_RBRACE _menhir_cell0_LPAR, 'r) _menhir_state
      (** State 353.
        Stack shape : as_ty IDENTIFIER LBRACE COMMA clist1(expr) RBRACE LPAR.
        Start symbol: <undetermined>. *)

    | MenhirState356 : ((((('s, 'r) _menhir_cell1_VAR, 'r) _menhir_cell1_decl_item, 'r) _menhir_cell1_as_ty, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 356.
        Stack shape : VAR decl_item as_ty expr.
        Start symbol: <undetermined>. *)

    | MenhirState360 : ((('s, 'r) _menhir_cell1_VAR, 'r) _menhir_cell1_clist2_annotated_IDENTIFIER__, 'r) _menhir_state
      (** State 360.
        Stack shape : VAR clist2(annotated(IDENTIFIER)).
        Start symbol: <undetermined>. *)

    | MenhirState365 : (('s, 'r) _menhir_cell1_TRY, 'r) _menhir_state
      (** State 365.
        Stack shape : TRY.
        Start symbol: <undetermined>. *)

    | MenhirState366 : (('s, 'r) _menhir_cell1_THROW, 'r) _menhir_state
      (** State 366.
        Stack shape : THROW.
        Start symbol: <undetermined>. *)

    | MenhirState367 : ((('s, 'r) _menhir_cell1_THROW, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 367.
        Stack shape : THROW expr.
        Start symbol: <undetermined>. *)

    | MenhirState369 : (('s, 'r) _menhir_cell1_RETURN, 'r) _menhir_state
      (** State 369.
        Stack shape : RETURN.
        Start symbol: <undetermined>. *)

    | MenhirState372 : ((('s, 'r) _menhir_cell1_RETURN, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 372.
        Stack shape : RETURN expr.
        Start symbol: <undetermined>. *)

    | MenhirState373 : (('s, 'r) _menhir_cell1_REPEAT, 'r) _menhir_state
      (** State 373.
        Stack shape : REPEAT.
        Start symbol: <undetermined>. *)

    | MenhirState374 : (('s, 'r) _menhir_cell1_PRINTLN, 'r) _menhir_state
      (** State 374.
        Stack shape : PRINTLN.
        Start symbol: <undetermined>. *)

    | MenhirState377 : (('s, 'r) _menhir_cell1_PRINT, 'r) _menhir_state
      (** State 377.
        Stack shape : PRINT.
        Start symbol: <undetermined>. *)

    | MenhirState381 : (('s, 'r) _menhir_cell1_PRAGMA _menhir_cell0_IDENTIFIER, 'r) _menhir_state
      (** State 381.
        Stack shape : PRAGMA IDENTIFIER.
        Start symbol: <undetermined>. *)

    | MenhirState387 : (('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_state
      (** State 387.
        Stack shape : LPAR.
        Start symbol: <undetermined>. *)

    | MenhirState389 : (('s, 'r) _menhir_cell1_IDENTIFIER, 'r) _menhir_state
      (** State 389.
        Stack shape : IDENTIFIER.
        Start symbol: <undetermined>. *)

    | MenhirState390 : (('s, 'r) _menhir_cell1_LLBRACKET, 'r) _menhir_state
      (** State 390.
        Stack shape : LLBRACKET.
        Start symbol: <undetermined>. *)

    | MenhirState391 : ((('s, 'r) _menhir_cell1_LLBRACKET, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 391.
        Stack shape : LLBRACKET expr.
        Start symbol: <undetermined>. *)

    | MenhirState392 : (((('s, 'r) _menhir_cell1_LLBRACKET, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_RRBRACKET, 'r) _menhir_state
      (** State 392.
        Stack shape : LLBRACKET expr RRBRACKET.
        Start symbol: <undetermined>. *)

    | MenhirState394 : (('s, 'r) _menhir_cell1_DOT _menhir_cell0_IDENTIFIER, 'r) _menhir_state
      (** State 394.
        Stack shape : DOT IDENTIFIER.
        Start symbol: <undetermined>. *)

    | MenhirState397 : ((('s, 'r) _menhir_cell1_IDENTIFIER, 'r) _menhir_cell1_access, 'r) _menhir_state
      (** State 397.
        Stack shape : IDENTIFIER access.
        Start symbol: <undetermined>. *)

    | MenhirState400 : ((('s, 'r) _menhir_cell1_LPAR, 'r) _menhir_cell1_discard_or_basic_lexpr, 'r) _menhir_state
      (** State 400.
        Stack shape : LPAR discard_or_basic_lexpr.
        Start symbol: <undetermined>. *)

    | MenhirState402 : ((('s, 'r) _menhir_cell1_discard_or_basic_lexpr, 'r) _menhir_cell1_discard_or_basic_lexpr, 'r) _menhir_state
      (** State 402.
        Stack shape : discard_or_basic_lexpr discard_or_basic_lexpr.
        Start symbol: <undetermined>. *)

    | MenhirState408 : (('s, 'r) _menhir_cell1_LET, 'r) _menhir_state
      (** State 408.
        Stack shape : LET.
        Start symbol: <undetermined>. *)

    | MenhirState410 : ((('s, 'r) _menhir_cell1_LET, 'r) _menhir_cell1_decl_item, 'r) _menhir_state
      (** State 410.
        Stack shape : LET decl_item.
        Start symbol: <undetermined>. *)

    | MenhirState411 : (((('s, 'r) _menhir_cell1_LET, 'r) _menhir_cell1_decl_item, 'r) _menhir_cell1_EQ, 'r) _menhir_state
      (** State 411.
        Stack shape : LET decl_item EQ.
        Start symbol: <undetermined>. *)

    | MenhirState412 : ((((('s, 'r) _menhir_cell1_LET, 'r) _menhir_cell1_decl_item, 'r) _menhir_cell1_EQ, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 412.
        Stack shape : LET decl_item EQ expr.
        Start symbol: <undetermined>. *)

    | MenhirState415 : (((('s, 'r) _menhir_cell1_LET, 'r) _menhir_cell1_decl_item, 'r) _menhir_cell1_as_ty, 'r) _menhir_state
      (** State 415.
        Stack shape : LET decl_item as_ty.
        Start symbol: <undetermined>. *)

    | MenhirState416 : ((((('s, 'r) _menhir_cell1_LET, 'r) _menhir_cell1_decl_item, 'r) _menhir_cell1_as_ty, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 416.
        Stack shape : LET decl_item as_ty expr.
        Start symbol: <undetermined>. *)

    | MenhirState420 : (('s, 'r) _menhir_cell1_IF, 'r) _menhir_state
      (** State 420.
        Stack shape : IF.
        Start symbol: <undetermined>. *)

    | MenhirState421 : ((('s, 'r) _menhir_cell1_IF, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 421.
        Stack shape : IF expr.
        Start symbol: <undetermined>. *)

    | MenhirState422 : (((('s, 'r) _menhir_cell1_IF, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_THEN, 'r) _menhir_state
      (** State 422.
        Stack shape : IF expr THEN.
        Start symbol: <undetermined>. *)

    | MenhirState423 : (('s, 'r) _menhir_cell1_IDENTIFIER, 'r) _menhir_state
      (** State 423.
        Stack shape : IDENTIFIER.
        Start symbol: <undetermined>. *)

    | MenhirState424 : ((('s, 'r) _menhir_cell1_IDENTIFIER, 'r) _menhir_cell1_LBRACE, 'r) _menhir_state
      (** State 424.
        Stack shape : IDENTIFIER LBRACE.
        Start symbol: <undetermined>. *)

    | MenhirState426 : ((('s, 'r) _menhir_cell1_IDENTIFIER, 'r) _menhir_cell1_DOT _menhir_cell0_LPAR, 'r) _menhir_state
      (** State 426.
        Stack shape : IDENTIFIER DOT LPAR.
        Start symbol: <undetermined>. *)

    | MenhirState430 : (((('s, 'r) _menhir_cell1_IDENTIFIER, 'r) _menhir_cell1_DOT _menhir_cell0_LPAR, 'r) _menhir_cell1_discard_or_field, 'r) _menhir_state
      (** State 430.
        Stack shape : IDENTIFIER DOT LPAR discard_or_field.
        Start symbol: <undetermined>. *)

    | MenhirState432 : ((('s, 'r) _menhir_cell1_discard_or_field, 'r) _menhir_cell1_discard_or_field, 'r) _menhir_state
      (** State 432.
        Stack shape : discard_or_field discard_or_field.
        Start symbol: <undetermined>. *)

    | MenhirState437 : ((('s, 'r) _menhir_cell1_IDENTIFIER, 'r) _menhir_cell1_DOT _menhir_cell0_LBRACKET, 'r) _menhir_state
      (** State 437.
        Stack shape : IDENTIFIER DOT LBRACKET.
        Start symbol: <undetermined>. *)

    | MenhirState439 : ((('s, 'r) _menhir_cell1_DOT _menhir_cell0_LBRACKET, 'r) _menhir_cell1_IDENTIFIER, 'r) _menhir_state
      (** State 439.
        Stack shape : DOT LBRACKET IDENTIFIER.
        Start symbol: <undetermined>. *)

    | MenhirState445 : (('s, 'r) _menhir_cell1_FOR _menhir_cell0_IDENTIFIER, 'r) _menhir_state
      (** State 445.
        Stack shape : FOR IDENTIFIER.
        Start symbol: <undetermined>. *)

    | MenhirState446 : ((('s, 'r) _menhir_cell1_FOR _menhir_cell0_IDENTIFIER, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 446.
        Stack shape : FOR IDENTIFIER expr.
        Start symbol: <undetermined>. *)

    | MenhirState449 : (((('s, 'r) _menhir_cell1_FOR _menhir_cell0_IDENTIFIER, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_direction, 'r) _menhir_state
      (** State 449.
        Stack shape : FOR IDENTIFIER expr direction.
        Start symbol: <undetermined>. *)

    | MenhirState450 : ((((('s, 'r) _menhir_cell1_FOR _menhir_cell0_IDENTIFIER, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_direction, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 450.
        Stack shape : FOR IDENTIFIER expr direction expr.
        Start symbol: <undetermined>. *)

    | MenhirState452 : (((((('s, 'r) _menhir_cell1_FOR _menhir_cell0_IDENTIFIER, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_direction, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_loop_limit, 'r) _menhir_state
      (** State 452.
        Stack shape : FOR IDENTIFIER expr direction expr loop_limit.
        Start symbol: <undetermined>. *)

    | MenhirState454 : (('s, 'r) _menhir_cell1_DEBUG _menhir_cell0_LPAR, 'r) _menhir_state
      (** State 454.
        Stack shape : DEBUG LPAR.
        Start symbol: <undetermined>. *)

    | MenhirState458 : (('s, 'r) _menhir_cell1_CONSTANT, 'r) _menhir_state
      (** State 458.
        Stack shape : CONSTANT.
        Start symbol: <undetermined>. *)

    | MenhirState459 : ((('s, 'r) _menhir_cell1_CONSTANT, 'r) _menhir_cell1_decl_item, 'r) _menhir_state
      (** State 459.
        Stack shape : CONSTANT decl_item.
        Start symbol: <undetermined>. *)

    | MenhirState460 : (((('s, 'r) _menhir_cell1_CONSTANT, 'r) _menhir_cell1_decl_item, 'r) _menhir_cell1_EQ, 'r) _menhir_state
      (** State 460.
        Stack shape : CONSTANT decl_item EQ.
        Start symbol: <undetermined>. *)

    | MenhirState461 : ((((('s, 'r) _menhir_cell1_CONSTANT, 'r) _menhir_cell1_decl_item, 'r) _menhir_cell1_EQ, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 461.
        Stack shape : CONSTANT decl_item EQ expr.
        Start symbol: <undetermined>. *)

    | MenhirState464 : (((('s, 'r) _menhir_cell1_CONSTANT, 'r) _menhir_cell1_decl_item, 'r) _menhir_cell1_as_ty, 'r) _menhir_state
      (** State 464.
        Stack shape : CONSTANT decl_item as_ty.
        Start symbol: <undetermined>. *)

    | MenhirState465 : ((((('s, 'r) _menhir_cell1_CONSTANT, 'r) _menhir_cell1_decl_item, 'r) _menhir_cell1_as_ty, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 465.
        Stack shape : CONSTANT decl_item as_ty expr.
        Start symbol: <undetermined>. *)

    | MenhirState469 : (('s, 'r) _menhir_cell1_CASE, 'r) _menhir_state
      (** State 469.
        Stack shape : CASE.
        Start symbol: <undetermined>. *)

    | MenhirState470 : ((('s, 'r) _menhir_cell1_CASE, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 470.
        Stack shape : CASE expr.
        Start symbol: <undetermined>. *)

    | MenhirState471 : (((('s, 'r) _menhir_cell1_CASE, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_OF, 'r) _menhir_state
      (** State 471.
        Stack shape : CASE expr OF.
        Start symbol: <undetermined>. *)

    | MenhirState472 : (('s, 'r) _menhir_cell1_WHEN, 'r) _menhir_state
      (** State 472.
        Stack shape : WHEN.
        Start symbol: <undetermined>. *)

    | MenhirState474 : ((('s, 'r) _menhir_cell1_WHEN, 'r) _menhir_cell1_pattern_list, 'r) _menhir_state
      (** State 474.
        Stack shape : WHEN pattern_list.
        Start symbol: <undetermined>. *)

    | MenhirState475 : (((('s, 'r) _menhir_cell1_WHEN, 'r) _menhir_cell1_pattern_list, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 475.
        Stack shape : WHEN pattern_list expr.
        Start symbol: <undetermined>. *)

    | MenhirState476 : ((((('s, 'r) _menhir_cell1_WHEN, 'r) _menhir_cell1_pattern_list, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_ARROW, 'r) _menhir_state
      (** State 476.
        Stack shape : WHEN pattern_list expr ARROW.
        Start symbol: <undetermined>. *)

    | MenhirState477 : (('s, 'r) _menhir_cell1_ASSERT, 'r) _menhir_state
      (** State 477.
        Stack shape : ASSERT.
        Start symbol: <undetermined>. *)

    | MenhirState478 : ((('s, 'r) _menhir_cell1_ASSERT, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 478.
        Stack shape : ASSERT expr.
        Start symbol: <undetermined>. *)

    | MenhirState481 : (('s, 'r) _menhir_cell1_stmt, 'r) _menhir_state
      (** State 481.
        Stack shape : stmt.
        Start symbol: <undetermined>. *)

    | MenhirState484 : (('s, 'r) _menhir_cell1_lexpr, 'r) _menhir_state
      (** State 484.
        Stack shape : lexpr.
        Start symbol: <undetermined>. *)

    | MenhirState485 : ((('s, 'r) _menhir_cell1_lexpr, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 485.
        Stack shape : lexpr expr.
        Start symbol: <undetermined>. *)

    | MenhirState487 : (('s, 'r) _menhir_cell1_call, 'r) _menhir_state
      (** State 487.
        Stack shape : call.
        Start symbol: <undetermined>. *)

    | MenhirState490 : ((('s, 'r) _menhir_cell1_call, 'r) _menhir_cell1_DOT _menhir_cell0_LBRACKET, 'r) _menhir_state
      (** State 490.
        Stack shape : call DOT LBRACKET.
        Start symbol: <undetermined>. *)

    | MenhirState493 : (((('s, 'r) _menhir_cell1_call, 'r) _menhir_cell1_DOT _menhir_cell0_LBRACKET, 'r) _menhir_cell1_clist2_IDENTIFIER_ _menhir_cell0_RBRACKET, 'r) _menhir_state
      (** State 493.
        Stack shape : call DOT LBRACKET clist2(IDENTIFIER) RBRACKET.
        Start symbol: <undetermined>. *)

    | MenhirState494 : ((((('s, 'r) _menhir_cell1_call, 'r) _menhir_cell1_DOT _menhir_cell0_LBRACKET, 'r) _menhir_cell1_clist2_IDENTIFIER_ _menhir_cell0_RBRACKET, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 494.
        Stack shape : call DOT LBRACKET clist2(IDENTIFIER) RBRACKET expr.
        Start symbol: <undetermined>. *)

    | MenhirState496 : (('s, 'r) _menhir_cell1_DOT _menhir_cell0_IDENTIFIER, 'r) _menhir_state
      (** State 496.
        Stack shape : DOT IDENTIFIER.
        Start symbol: <undetermined>. *)

    | MenhirState499 : ((('s, 'r) _menhir_cell1_call, 'r) _menhir_cell1_setter_access, 'r) _menhir_state
      (** State 499.
        Stack shape : call setter_access.
        Start symbol: <undetermined>. *)

    | MenhirState500 : (((('s, 'r) _menhir_cell1_call, 'r) _menhir_cell1_setter_access, 'r) _menhir_cell1_EQ, 'r) _menhir_state
      (** State 500.
        Stack shape : call setter_access EQ.
        Start symbol: <undetermined>. *)

    | MenhirState501 : ((((('s, 'r) _menhir_cell1_call, 'r) _menhir_cell1_setter_access, 'r) _menhir_cell1_EQ, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 501.
        Stack shape : call setter_access EQ expr.
        Start symbol: <undetermined>. *)

    | MenhirState504 : (((('s, 'r) _menhir_cell1_call, 'r) _menhir_cell1_setter_access, 'r) _menhir_cell1_slices, 'r) _menhir_state
      (** State 504.
        Stack shape : call setter_access slices.
        Start symbol: <undetermined>. *)

    | MenhirState505 : ((((('s, 'r) _menhir_cell1_call, 'r) _menhir_cell1_setter_access, 'r) _menhir_cell1_slices, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 505.
        Stack shape : call setter_access slices expr.
        Start symbol: <undetermined>. *)

    | MenhirState509 : ((('s, 'r) _menhir_cell1_WHEN, 'r) _menhir_cell1_pattern_list, 'r) _menhir_state
      (** State 509.
        Stack shape : WHEN pattern_list.
        Start symbol: <undetermined>. *)

    | MenhirState513 : ((((('s, 'r) _menhir_cell1_CASE, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_OF, 'r) _menhir_cell1_list1_case_alt_, 'r) _menhir_state
      (** State 513.
        Stack shape : CASE expr OF list1(case_alt).
        Start symbol: <undetermined>. *)

    | MenhirState519 : (('s, 'r) _menhir_cell1_case_alt, 'r) _menhir_state
      (** State 519.
        Stack shape : case_alt.
        Start symbol: <undetermined>. *)

    | MenhirState524 : ((((('s, 'r) _menhir_cell1_IF, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_THEN, 'r) _menhir_cell1_stmt_list, 'r) _menhir_state
      (** State 524.
        Stack shape : IF expr THEN stmt_list.
        Start symbol: <undetermined>. *)

    | MenhirState525 : ((((('s, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_THEN, 'r) _menhir_cell1_stmt_list, 'r) _menhir_cell1_ELSIF, 'r) _menhir_state
      (** State 525.
        Stack shape : expr THEN stmt_list ELSIF.
        Start symbol: <undetermined>. *)

    | MenhirState526 : (((((('s, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_THEN, 'r) _menhir_cell1_stmt_list, 'r) _menhir_cell1_ELSIF, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 526.
        Stack shape : expr THEN stmt_list ELSIF expr.
        Start symbol: <undetermined>. *)

    | MenhirState527 : ((((((('s, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_THEN, 'r) _menhir_cell1_stmt_list, 'r) _menhir_cell1_ELSIF, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_THEN, 'r) _menhir_state
      (** State 527.
        Stack shape : expr THEN stmt_list ELSIF expr THEN.
        Start symbol: <undetermined>. *)

    | MenhirState528 : (((((((('s, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_THEN, 'r) _menhir_cell1_stmt_list, 'r) _menhir_cell1_ELSIF, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_THEN, 'r) _menhir_cell1_stmt_list, 'r) _menhir_state
      (** State 528.
        Stack shape : expr THEN stmt_list ELSIF expr THEN stmt_list.
        Start symbol: <undetermined>. *)

    | MenhirState529 : ((((('s, 'r) _menhir_cell1_expr, 'r) _menhir_cell1_THEN, 'r) _menhir_cell1_stmt_list, 'r) _menhir_cell1_ELSE, 'r) _menhir_state
      (** State 529.
        Stack shape : expr THEN stmt_list ELSE.
        Start symbol: <undetermined>. *)

    | MenhirState536 : ((('s, 'r) _menhir_cell1_REPEAT, 'r) _menhir_cell1_stmt_list, 'r) _menhir_state
      (** State 536.
        Stack shape : REPEAT stmt_list.
        Start symbol: <undetermined>. *)

    | MenhirState537 : (((('s, 'r) _menhir_cell1_REPEAT, 'r) _menhir_cell1_stmt_list, 'r) _menhir_cell1_expr, 'r) _menhir_state
      (** State 537.
        Stack shape : REPEAT stmt_list expr.
        Start symbol: <undetermined>. *)

    | MenhirState541 : ((('s, 'r) _menhir_cell1_TRY, 'r) _menhir_cell1_stmt_list, 'r) _menhir_state
      (** State 541.
        Stack shape : TRY stmt_list.
        Start symbol: <undetermined>. *)

    | MenhirState542 : (('s, 'r) _menhir_cell1_WHEN, 'r) _menhir_state
      (** State 542.
        Stack shape : WHEN.
        Start symbol: <undetermined>. *)

    | MenhirState544 : ((('s, 'r) _menhir_cell1_WHEN, 'r) _menhir_cell1_IDENTIFIER _menhir_cell0_COLON, 'r) _menhir_state
      (** State 544.
        Stack shape : WHEN IDENTIFIER COLON.
        Start symbol: <undetermined>. *)

    | MenhirState546 : (((('s, 'r) _menhir_cell1_WHEN, 'r) _menhir_cell1_IDENTIFIER _menhir_cell0_COLON, 'r) _menhir_cell1_ty, 'r) _menhir_state
      (** State 546.
        Stack shape : WHEN IDENTIFIER COLON ty.
        Start symbol: <undetermined>. *)

    | MenhirState549 : ((('s, 'r) _menhir_cell1_WHEN, 'r) _menhir_cell1_ty, 'r) _menhir_state
      (** State 549.
        Stack shape : WHEN ty.
        Start symbol: <undetermined>. *)

    | MenhirState553 : (((('s, 'r) _menhir_cell1_TRY, 'r) _menhir_cell1_stmt_list, 'r) _menhir_cell1_list1_catcher_, 'r) _menhir_state
      (** State 553.
        Stack shape : TRY stmt_list list1(catcher).
        Start symbol: <undetermined>. *)

    | MenhirState558 : (('s, 'r) _menhir_cell1_catcher, 'r) _menhir_state
      (** State 558.
        Stack shape : catcher.
        Start symbol: <undetermined>. *)

    | MenhirState566 : ('s, _menhir_box_spec) _menhir_state
      (** State 566.
        Stack shape : .
        Start symbol: spec. *)

    | MenhirState567 : (('s, _menhir_box_spec) _menhir_cell1_VAR, _menhir_box_spec) _menhir_state
      (** State 567.
        Stack shape : VAR.
        Start symbol: spec. *)

    | MenhirState570 : ((('s, _menhir_box_spec) _menhir_cell1_VAR, _menhir_box_spec) _menhir_cell1_ignored_or_identifier, _menhir_box_spec) _menhir_state
      (** State 570.
        Stack shape : VAR ignored_or_identifier.
        Start symbol: spec. *)

    | MenhirState571 : (((('s, _menhir_box_spec) _menhir_cell1_VAR, _menhir_box_spec) _menhir_cell1_ignored_or_identifier, _menhir_box_spec) _menhir_cell1_EQ, _menhir_box_spec) _menhir_state
      (** State 571.
        Stack shape : VAR ignored_or_identifier EQ.
        Start symbol: spec. *)

    | MenhirState572 : ((((('s, _menhir_box_spec) _menhir_cell1_VAR, _menhir_box_spec) _menhir_cell1_ignored_or_identifier, _menhir_box_spec) _menhir_cell1_EQ, _menhir_box_spec) _menhir_cell1_expr, _menhir_box_spec) _menhir_state
      (** State 572.
        Stack shape : VAR ignored_or_identifier EQ expr.
        Start symbol: spec. *)

    | MenhirState574 : (((('s, _menhir_box_spec) _menhir_cell1_VAR, _menhir_box_spec) _menhir_cell1_ignored_or_identifier, _menhir_box_spec) _menhir_cell1_COLON, _menhir_box_spec) _menhir_state
      (** State 574.
        Stack shape : VAR ignored_or_identifier COLON.
        Start symbol: spec. *)

    | MenhirState575 : ((((('s, _menhir_box_spec) _menhir_cell1_VAR, _menhir_box_spec) _menhir_cell1_ignored_or_identifier, _menhir_box_spec) _menhir_cell1_COLON, _menhir_box_spec) _menhir_cell1_COLLECTION, _menhir_box_spec) _menhir_state
      (** State 575.
        Stack shape : VAR ignored_or_identifier COLON COLLECTION.
        Start symbol: spec. *)

    | MenhirState576 : (('s, _menhir_box_spec) _menhir_cell1_LBRACE, _menhir_box_spec) _menhir_state
      (** State 576.
        Stack shape : LBRACE.
        Start symbol: spec. *)

    | MenhirState579 : (('s, _menhir_box_spec) _menhir_cell1_IDENTIFIER, _menhir_box_spec) _menhir_state
      (** State 579.
        Stack shape : IDENTIFIER.
        Start symbol: spec. *)

    | MenhirState582 : (('s, _menhir_box_spec) _menhir_cell1_typed_identifier, _menhir_box_spec) _menhir_state
      (** State 582.
        Stack shape : typed_identifier.
        Start symbol: spec. *)

    | MenhirState591 : (((('s, _menhir_box_spec) _menhir_cell1_VAR, _menhir_box_spec) _menhir_cell1_ignored_or_identifier, _menhir_box_spec) _menhir_cell1_as_ty, _menhir_box_spec) _menhir_state
      (** State 591.
        Stack shape : VAR ignored_or_identifier as_ty.
        Start symbol: spec. *)

    | MenhirState592 : ((((('s, _menhir_box_spec) _menhir_cell1_VAR, _menhir_box_spec) _menhir_cell1_ignored_or_identifier, _menhir_box_spec) _menhir_cell1_as_ty, _menhir_box_spec) _menhir_cell1_expr, _menhir_box_spec) _menhir_state
      (** State 592.
        Stack shape : VAR ignored_or_identifier as_ty expr.
        Start symbol: spec. *)

    | MenhirState596 : ((('s, _menhir_box_spec) _menhir_cell1_VAR, _menhir_box_spec) _menhir_cell1_clist2_annotated_IDENTIFIER__, _menhir_box_spec) _menhir_state
      (** State 596.
        Stack shape : VAR clist2(annotated(IDENTIFIER)).
        Start symbol: spec. *)

    | MenhirState600 : (('s, _menhir_box_spec) _menhir_cell1_TYPE _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_state
      (** State 600.
        Stack shape : TYPE IDENTIFIER.
        Start symbol: spec. *)

    | MenhirState603 : (('s, _menhir_box_spec) _menhir_cell1_SUBTYPES _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_state
      (** State 603.
        Stack shape : SUBTYPES IDENTIFIER.
        Start symbol: spec. *)

    | MenhirState605 : ((('s, _menhir_box_spec) _menhir_cell1_TYPE _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_OF, _menhir_box_spec) _menhir_state
      (** State 605.
        Stack shape : TYPE IDENTIFIER OF.
        Start symbol: spec. *)

    | MenhirState606 : (((('s, _menhir_box_spec) _menhir_cell1_TYPE _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_OF, _menhir_box_spec) _menhir_cell1_RECORD, _menhir_box_spec) _menhir_state
      (** State 606.
        Stack shape : TYPE IDENTIFIER OF RECORD.
        Start symbol: spec. *)

    | MenhirState608 : (((('s, _menhir_box_spec) _menhir_cell1_TYPE _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_OF, _menhir_box_spec) _menhir_cell1_EXCEPTION, _menhir_box_spec) _menhir_state
      (** State 608.
        Stack shape : TYPE IDENTIFIER OF EXCEPTION.
        Start symbol: spec. *)

    | MenhirState611 : (((('s, _menhir_box_spec) _menhir_cell1_TYPE _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_OF, _menhir_box_spec) _menhir_cell1_ENUMERATION _menhir_cell0_LBRACE, _menhir_box_spec) _menhir_state
      (** State 611.
        Stack shape : TYPE IDENTIFIER OF ENUMERATION LBRACE.
        Start symbol: spec. *)

    | MenhirState613 : (('s, _menhir_box_spec) _menhir_cell1_IDENTIFIER, _menhir_box_spec) _menhir_state
      (** State 613.
        Stack shape : IDENTIFIER.
        Start symbol: spec. *)

    | MenhirState617 : (((('s, _menhir_box_spec) _menhir_cell1_TYPE _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_OF, _menhir_box_spec) _menhir_cell1_ty_decl, _menhir_box_spec) _menhir_state
      (** State 617.
        Stack shape : TYPE IDENTIFIER OF ty_decl.
        Start symbol: spec. *)

    | MenhirState627 : (('s, _menhir_box_spec) _menhir_cell1_READONLY _menhir_cell0_IMPLEMENTATION _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_state
      (** State 627.
        Stack shape : READONLY IMPLEMENTATION FUNC IDENTIFIER.
        Start symbol: spec. *)

    | MenhirState628 : (('s _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_LBRACE, _menhir_box_spec) _menhir_state
      (** State 628.
        Stack shape : IDENTIFIER LBRACE.
        Start symbol: spec. *)

    | MenhirState629 : (('s, _menhir_box_spec) _menhir_cell1_IDENTIFIER, _menhir_box_spec) _menhir_state
      (** State 629.
        Stack shape : IDENTIFIER.
        Start symbol: spec. *)

    | MenhirState632 : (('s, _menhir_box_spec) _menhir_cell1_opt_typed_identifier, _menhir_box_spec) _menhir_state
      (** State 632.
        Stack shape : opt_typed_identifier.
        Start symbol: spec. *)

    | MenhirState636 : ((('s, _menhir_box_spec) _menhir_cell1_READONLY _menhir_cell0_IMPLEMENTATION _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_state
      (** State 636.
        Stack shape : READONLY IMPLEMENTATION FUNC IDENTIFIER params_opt.
        Start symbol: spec. *)

    | MenhirState637 : ((('s _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_LPAR, _menhir_box_spec) _menhir_state
      (** State 637.
        Stack shape : IDENTIFIER params_opt LPAR.
        Start symbol: spec. *)

    | MenhirState639 : (('s, _menhir_box_spec) _menhir_cell1_typed_identifier, _menhir_box_spec) _menhir_state
      (** State 639.
        Stack shape : typed_identifier.
        Start symbol: spec. *)

    | MenhirState644 : (((('s, _menhir_box_spec) _menhir_cell1_READONLY _menhir_cell0_IMPLEMENTATION _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args, _menhir_box_spec) _menhir_state
      (** State 644.
        Stack shape : READONLY IMPLEMENTATION FUNC IDENTIFIER params_opt func_args.
        Start symbol: spec. *)

    | MenhirState645 : (('s, _menhir_box_spec) _menhir_cell1_RECURSELIMIT, _menhir_box_spec) _menhir_state
      (** State 645.
        Stack shape : RECURSELIMIT.
        Start symbol: spec. *)

    | MenhirState646 : ((('s, _menhir_box_spec) _menhir_cell1_RECURSELIMIT, _menhir_box_spec) _menhir_cell1_expr, _menhir_box_spec) _menhir_state
      (** State 646.
        Stack shape : RECURSELIMIT expr.
        Start symbol: spec. *)

    | MenhirState647 : (((('s _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args, _menhir_box_spec) _menhir_cell1_ARROW, _menhir_box_spec) _menhir_state
      (** State 647.
        Stack shape : IDENTIFIER params_opt func_args ARROW.
        Start symbol: spec. *)

    | MenhirState649 : ((((('s, _menhir_box_spec) _menhir_cell1_READONLY _menhir_cell0_IMPLEMENTATION _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args, _menhir_box_spec) _menhir_cell1_return_type, _menhir_box_spec) _menhir_state
      (** State 649.
        Stack shape : READONLY IMPLEMENTATION FUNC IDENTIFIER params_opt func_args return_type.
        Start symbol: spec. *)

    | MenhirState651 : (((((('s, _menhir_box_spec) _menhir_cell1_READONLY _menhir_cell0_IMPLEMENTATION _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args, _menhir_box_spec) _menhir_cell1_return_type, _menhir_box_spec) _menhir_cell1_recurse_limit, _menhir_box_spec) _menhir_state
      (** State 651.
        Stack shape : READONLY IMPLEMENTATION FUNC IDENTIFIER params_opt func_args return_type recurse_limit.
        Start symbol: spec. *)

    | MenhirState656 : ((((('s, _menhir_box_spec) _menhir_cell1_READONLY _menhir_cell0_IMPLEMENTATION _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args, _menhir_box_spec) _menhir_cell1_recurse_limit, _menhir_box_spec) _menhir_state
      (** State 656.
        Stack shape : READONLY IMPLEMENTATION FUNC IDENTIFIER params_opt func_args recurse_limit.
        Start symbol: spec. *)

    | MenhirState662 : (('s, _menhir_box_spec) _menhir_cell1_READONLY _menhir_cell0_IMPDEF _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_state
      (** State 662.
        Stack shape : READONLY IMPDEF FUNC IDENTIFIER.
        Start symbol: spec. *)

    | MenhirState663 : ((('s, _menhir_box_spec) _menhir_cell1_READONLY _menhir_cell0_IMPDEF _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_state
      (** State 663.
        Stack shape : READONLY IMPDEF FUNC IDENTIFIER params_opt.
        Start symbol: spec. *)

    | MenhirState664 : (((('s, _menhir_box_spec) _menhir_cell1_READONLY _menhir_cell0_IMPDEF _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args, _menhir_box_spec) _menhir_state
      (** State 664.
        Stack shape : READONLY IMPDEF FUNC IDENTIFIER params_opt func_args.
        Start symbol: spec. *)

    | MenhirState665 : ((((('s, _menhir_box_spec) _menhir_cell1_READONLY _menhir_cell0_IMPDEF _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args, _menhir_box_spec) _menhir_cell1_return_type, _menhir_box_spec) _menhir_state
      (** State 665.
        Stack shape : READONLY IMPDEF FUNC IDENTIFIER params_opt func_args return_type.
        Start symbol: spec. *)

    | MenhirState667 : (((((('s, _menhir_box_spec) _menhir_cell1_READONLY _menhir_cell0_IMPDEF _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args, _menhir_box_spec) _menhir_cell1_return_type, _menhir_box_spec) _menhir_cell1_recurse_limit, _menhir_box_spec) _menhir_state
      (** State 667.
        Stack shape : READONLY IMPDEF FUNC IDENTIFIER params_opt func_args return_type recurse_limit.
        Start symbol: spec. *)

    | MenhirState672 : ((((('s, _menhir_box_spec) _menhir_cell1_READONLY _menhir_cell0_IMPDEF _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args, _menhir_box_spec) _menhir_cell1_recurse_limit, _menhir_box_spec) _menhir_state
      (** State 672.
        Stack shape : READONLY IMPDEF FUNC IDENTIFIER params_opt func_args recurse_limit.
        Start symbol: spec. *)

    | MenhirState677 : (('s, _menhir_box_spec) _menhir_cell1_READONLY _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_state
      (** State 677.
        Stack shape : READONLY FUNC IDENTIFIER.
        Start symbol: spec. *)

    | MenhirState678 : ((('s, _menhir_box_spec) _menhir_cell1_READONLY _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_state
      (** State 678.
        Stack shape : READONLY FUNC IDENTIFIER params_opt.
        Start symbol: spec. *)

    | MenhirState679 : (((('s, _menhir_box_spec) _menhir_cell1_READONLY _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args, _menhir_box_spec) _menhir_state
      (** State 679.
        Stack shape : READONLY FUNC IDENTIFIER params_opt func_args.
        Start symbol: spec. *)

    | MenhirState680 : ((((('s, _menhir_box_spec) _menhir_cell1_READONLY _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args, _menhir_box_spec) _menhir_cell1_return_type, _menhir_box_spec) _menhir_state
      (** State 680.
        Stack shape : READONLY FUNC IDENTIFIER params_opt func_args return_type.
        Start symbol: spec. *)

    | MenhirState682 : (((((('s, _menhir_box_spec) _menhir_cell1_READONLY _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args, _menhir_box_spec) _menhir_cell1_return_type, _menhir_box_spec) _menhir_cell1_recurse_limit, _menhir_box_spec) _menhir_state
      (** State 682.
        Stack shape : READONLY FUNC IDENTIFIER params_opt func_args return_type recurse_limit.
        Start symbol: spec. *)

    | MenhirState687 : ((((('s, _menhir_box_spec) _menhir_cell1_READONLY _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args, _menhir_box_spec) _menhir_cell1_recurse_limit, _menhir_box_spec) _menhir_state
      (** State 687.
        Stack shape : READONLY FUNC IDENTIFIER params_opt func_args recurse_limit.
        Start symbol: spec. *)

    | MenhirState694 : (('s, _menhir_box_spec) _menhir_cell1_PURE _menhir_cell0_IMPLEMENTATION _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_state
      (** State 694.
        Stack shape : PURE IMPLEMENTATION FUNC IDENTIFIER.
        Start symbol: spec. *)

    | MenhirState695 : ((('s, _menhir_box_spec) _menhir_cell1_PURE _menhir_cell0_IMPLEMENTATION _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_state
      (** State 695.
        Stack shape : PURE IMPLEMENTATION FUNC IDENTIFIER params_opt.
        Start symbol: spec. *)

    | MenhirState696 : (((('s, _menhir_box_spec) _menhir_cell1_PURE _menhir_cell0_IMPLEMENTATION _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args, _menhir_box_spec) _menhir_state
      (** State 696.
        Stack shape : PURE IMPLEMENTATION FUNC IDENTIFIER params_opt func_args.
        Start symbol: spec. *)

    | MenhirState697 : ((((('s, _menhir_box_spec) _menhir_cell1_PURE _menhir_cell0_IMPLEMENTATION _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args, _menhir_box_spec) _menhir_cell1_return_type, _menhir_box_spec) _menhir_state
      (** State 697.
        Stack shape : PURE IMPLEMENTATION FUNC IDENTIFIER params_opt func_args return_type.
        Start symbol: spec. *)

    | MenhirState699 : (((((('s, _menhir_box_spec) _menhir_cell1_PURE _menhir_cell0_IMPLEMENTATION _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args, _menhir_box_spec) _menhir_cell1_return_type, _menhir_box_spec) _menhir_cell1_recurse_limit, _menhir_box_spec) _menhir_state
      (** State 699.
        Stack shape : PURE IMPLEMENTATION FUNC IDENTIFIER params_opt func_args return_type recurse_limit.
        Start symbol: spec. *)

    | MenhirState704 : ((((('s, _menhir_box_spec) _menhir_cell1_PURE _menhir_cell0_IMPLEMENTATION _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args, _menhir_box_spec) _menhir_cell1_recurse_limit, _menhir_box_spec) _menhir_state
      (** State 704.
        Stack shape : PURE IMPLEMENTATION FUNC IDENTIFIER params_opt func_args recurse_limit.
        Start symbol: spec. *)

    | MenhirState710 : (('s, _menhir_box_spec) _menhir_cell1_PURE _menhir_cell0_IMPDEF _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_state
      (** State 710.
        Stack shape : PURE IMPDEF FUNC IDENTIFIER.
        Start symbol: spec. *)

    | MenhirState711 : ((('s, _menhir_box_spec) _menhir_cell1_PURE _menhir_cell0_IMPDEF _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_state
      (** State 711.
        Stack shape : PURE IMPDEF FUNC IDENTIFIER params_opt.
        Start symbol: spec. *)

    | MenhirState712 : (((('s, _menhir_box_spec) _menhir_cell1_PURE _menhir_cell0_IMPDEF _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args, _menhir_box_spec) _menhir_state
      (** State 712.
        Stack shape : PURE IMPDEF FUNC IDENTIFIER params_opt func_args.
        Start symbol: spec. *)

    | MenhirState713 : ((((('s, _menhir_box_spec) _menhir_cell1_PURE _menhir_cell0_IMPDEF _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args, _menhir_box_spec) _menhir_cell1_return_type, _menhir_box_spec) _menhir_state
      (** State 713.
        Stack shape : PURE IMPDEF FUNC IDENTIFIER params_opt func_args return_type.
        Start symbol: spec. *)

    | MenhirState715 : (((((('s, _menhir_box_spec) _menhir_cell1_PURE _menhir_cell0_IMPDEF _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args, _menhir_box_spec) _menhir_cell1_return_type, _menhir_box_spec) _menhir_cell1_recurse_limit, _menhir_box_spec) _menhir_state
      (** State 715.
        Stack shape : PURE IMPDEF FUNC IDENTIFIER params_opt func_args return_type recurse_limit.
        Start symbol: spec. *)

    | MenhirState720 : ((((('s, _menhir_box_spec) _menhir_cell1_PURE _menhir_cell0_IMPDEF _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args, _menhir_box_spec) _menhir_cell1_recurse_limit, _menhir_box_spec) _menhir_state
      (** State 720.
        Stack shape : PURE IMPDEF FUNC IDENTIFIER params_opt func_args recurse_limit.
        Start symbol: spec. *)

    | MenhirState725 : (('s, _menhir_box_spec) _menhir_cell1_PURE _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_state
      (** State 725.
        Stack shape : PURE FUNC IDENTIFIER.
        Start symbol: spec. *)

    | MenhirState726 : ((('s, _menhir_box_spec) _menhir_cell1_PURE _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_state
      (** State 726.
        Stack shape : PURE FUNC IDENTIFIER params_opt.
        Start symbol: spec. *)

    | MenhirState727 : (((('s, _menhir_box_spec) _menhir_cell1_PURE _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args, _menhir_box_spec) _menhir_state
      (** State 727.
        Stack shape : PURE FUNC IDENTIFIER params_opt func_args.
        Start symbol: spec. *)

    | MenhirState728 : ((((('s, _menhir_box_spec) _menhir_cell1_PURE _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args, _menhir_box_spec) _menhir_cell1_return_type, _menhir_box_spec) _menhir_state
      (** State 728.
        Stack shape : PURE FUNC IDENTIFIER params_opt func_args return_type.
        Start symbol: spec. *)

    | MenhirState730 : (((((('s, _menhir_box_spec) _menhir_cell1_PURE _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args, _menhir_box_spec) _menhir_cell1_return_type, _menhir_box_spec) _menhir_cell1_recurse_limit, _menhir_box_spec) _menhir_state
      (** State 730.
        Stack shape : PURE FUNC IDENTIFIER params_opt func_args return_type recurse_limit.
        Start symbol: spec. *)

    | MenhirState735 : ((((('s, _menhir_box_spec) _menhir_cell1_PURE _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args, _menhir_box_spec) _menhir_cell1_recurse_limit, _menhir_box_spec) _menhir_state
      (** State 735.
        Stack shape : PURE FUNC IDENTIFIER params_opt func_args recurse_limit.
        Start symbol: spec. *)

    | MenhirState740 : (('s, _menhir_box_spec) _menhir_cell1_PRAGMA _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_state
      (** State 740.
        Stack shape : PRAGMA IDENTIFIER.
        Start symbol: spec. *)

    | MenhirState746 : (('s, _menhir_box_spec) _menhir_cell1_NORETURN _menhir_cell0_IMPLEMENTATION _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_state
      (** State 746.
        Stack shape : NORETURN IMPLEMENTATION FUNC IDENTIFIER.
        Start symbol: spec. *)

    | MenhirState747 : ((('s, _menhir_box_spec) _menhir_cell1_NORETURN _menhir_cell0_IMPLEMENTATION _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_state
      (** State 747.
        Stack shape : NORETURN IMPLEMENTATION FUNC IDENTIFIER params_opt.
        Start symbol: spec. *)

    | MenhirState748 : (((('s, _menhir_box_spec) _menhir_cell1_NORETURN _menhir_cell0_IMPLEMENTATION _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args, _menhir_box_spec) _menhir_state
      (** State 748.
        Stack shape : NORETURN IMPLEMENTATION FUNC IDENTIFIER params_opt func_args.
        Start symbol: spec. *)

    | MenhirState750 : ((((('s, _menhir_box_spec) _menhir_cell1_NORETURN _menhir_cell0_IMPLEMENTATION _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args, _menhir_box_spec) _menhir_cell1_recurse_limit, _menhir_box_spec) _menhir_state
      (** State 750.
        Stack shape : NORETURN IMPLEMENTATION FUNC IDENTIFIER params_opt func_args recurse_limit.
        Start symbol: spec. *)

    | MenhirState756 : (('s, _menhir_box_spec) _menhir_cell1_NORETURN _menhir_cell0_IMPDEF _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_state
      (** State 756.
        Stack shape : NORETURN IMPDEF FUNC IDENTIFIER.
        Start symbol: spec. *)

    | MenhirState757 : ((('s, _menhir_box_spec) _menhir_cell1_NORETURN _menhir_cell0_IMPDEF _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_state
      (** State 757.
        Stack shape : NORETURN IMPDEF FUNC IDENTIFIER params_opt.
        Start symbol: spec. *)

    | MenhirState758 : (((('s, _menhir_box_spec) _menhir_cell1_NORETURN _menhir_cell0_IMPDEF _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args, _menhir_box_spec) _menhir_state
      (** State 758.
        Stack shape : NORETURN IMPDEF FUNC IDENTIFIER params_opt func_args.
        Start symbol: spec. *)

    | MenhirState760 : ((((('s, _menhir_box_spec) _menhir_cell1_NORETURN _menhir_cell0_IMPDEF _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args, _menhir_box_spec) _menhir_cell1_recurse_limit, _menhir_box_spec) _menhir_state
      (** State 760.
        Stack shape : NORETURN IMPDEF FUNC IDENTIFIER params_opt func_args recurse_limit.
        Start symbol: spec. *)

    | MenhirState765 : (('s, _menhir_box_spec) _menhir_cell1_NORETURN _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_state
      (** State 765.
        Stack shape : NORETURN FUNC IDENTIFIER.
        Start symbol: spec. *)

    | MenhirState766 : ((('s, _menhir_box_spec) _menhir_cell1_NORETURN _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_state
      (** State 766.
        Stack shape : NORETURN FUNC IDENTIFIER params_opt.
        Start symbol: spec. *)

    | MenhirState767 : (((('s, _menhir_box_spec) _menhir_cell1_NORETURN _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args, _menhir_box_spec) _menhir_state
      (** State 767.
        Stack shape : NORETURN FUNC IDENTIFIER params_opt func_args.
        Start symbol: spec. *)

    | MenhirState769 : ((((('s, _menhir_box_spec) _menhir_cell1_NORETURN _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args, _menhir_box_spec) _menhir_cell1_recurse_limit, _menhir_box_spec) _menhir_state
      (** State 769.
        Stack shape : NORETURN FUNC IDENTIFIER params_opt func_args recurse_limit.
        Start symbol: spec. *)

    | MenhirState773 : (('s, _menhir_box_spec) _menhir_cell1_LET, _menhir_box_spec) _menhir_state
      (** State 773.
        Stack shape : LET.
        Start symbol: spec. *)

    | MenhirState775 : ((('s, _menhir_box_spec) _menhir_cell1_LET, _menhir_box_spec) _menhir_cell1_ignored_or_identifier, _menhir_box_spec) _menhir_state
      (** State 775.
        Stack shape : LET ignored_or_identifier.
        Start symbol: spec. *)

    | MenhirState776 : (((('s, _menhir_box_spec) _menhir_cell1_LET, _menhir_box_spec) _menhir_cell1_ignored_or_identifier, _menhir_box_spec) _menhir_cell1_EQ, _menhir_box_spec) _menhir_state
      (** State 776.
        Stack shape : LET ignored_or_identifier EQ.
        Start symbol: spec. *)

    | MenhirState777 : ((((('s, _menhir_box_spec) _menhir_cell1_LET, _menhir_box_spec) _menhir_cell1_ignored_or_identifier, _menhir_box_spec) _menhir_cell1_EQ, _menhir_box_spec) _menhir_cell1_expr, _menhir_box_spec) _menhir_state
      (** State 777.
        Stack shape : LET ignored_or_identifier EQ expr.
        Start symbol: spec. *)

    | MenhirState780 : (((('s, _menhir_box_spec) _menhir_cell1_LET, _menhir_box_spec) _menhir_cell1_ignored_or_identifier, _menhir_box_spec) _menhir_cell1_as_ty, _menhir_box_spec) _menhir_state
      (** State 780.
        Stack shape : LET ignored_or_identifier as_ty.
        Start symbol: spec. *)

    | MenhirState781 : ((((('s, _menhir_box_spec) _menhir_cell1_LET, _menhir_box_spec) _menhir_cell1_ignored_or_identifier, _menhir_box_spec) _menhir_cell1_as_ty, _menhir_box_spec) _menhir_cell1_expr, _menhir_box_spec) _menhir_state
      (** State 781.
        Stack shape : LET ignored_or_identifier as_ty expr.
        Start symbol: spec. *)

    | MenhirState787 : (('s, _menhir_box_spec) _menhir_cell1_IMPLEMENTATION _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_state
      (** State 787.
        Stack shape : IMPLEMENTATION FUNC IDENTIFIER.
        Start symbol: spec. *)

    | MenhirState788 : ((('s, _menhir_box_spec) _menhir_cell1_IMPLEMENTATION _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_state
      (** State 788.
        Stack shape : IMPLEMENTATION FUNC IDENTIFIER params_opt.
        Start symbol: spec. *)

    | MenhirState789 : (((('s, _menhir_box_spec) _menhir_cell1_IMPLEMENTATION _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args, _menhir_box_spec) _menhir_state
      (** State 789.
        Stack shape : IMPLEMENTATION FUNC IDENTIFIER params_opt func_args.
        Start symbol: spec. *)

    | MenhirState790 : ((((('s, _menhir_box_spec) _menhir_cell1_IMPLEMENTATION _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args, _menhir_box_spec) _menhir_cell1_return_type, _menhir_box_spec) _menhir_state
      (** State 790.
        Stack shape : IMPLEMENTATION FUNC IDENTIFIER params_opt func_args return_type.
        Start symbol: spec. *)

    | MenhirState792 : (((((('s, _menhir_box_spec) _menhir_cell1_IMPLEMENTATION _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args, _menhir_box_spec) _menhir_cell1_return_type, _menhir_box_spec) _menhir_cell1_recurse_limit, _menhir_box_spec) _menhir_state
      (** State 792.
        Stack shape : IMPLEMENTATION FUNC IDENTIFIER params_opt func_args return_type recurse_limit.
        Start symbol: spec. *)

    | MenhirState797 : ((((('s, _menhir_box_spec) _menhir_cell1_IMPLEMENTATION _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args, _menhir_box_spec) _menhir_cell1_recurse_limit, _menhir_box_spec) _menhir_state
      (** State 797.
        Stack shape : IMPLEMENTATION FUNC IDENTIFIER params_opt func_args recurse_limit.
        Start symbol: spec. *)

    | MenhirState802 : (('s, _menhir_box_spec) _menhir_cell1_IMPLEMENTATION _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_state
      (** State 802.
        Stack shape : IMPLEMENTATION IDENTIFIER.
        Start symbol: spec. *)

    | MenhirState803 : ((('s, _menhir_box_spec) _menhir_cell1_IMPLEMENTATION _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_state
      (** State 803.
        Stack shape : IMPLEMENTATION IDENTIFIER params_opt.
        Start symbol: spec. *)

    | MenhirState806 : (((('s, _menhir_box_spec) _menhir_cell1_IMPLEMENTATION _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_state
      (** State 806.
        Stack shape : IMPLEMENTATION IDENTIFIER params_opt func_args IDENTIFIER.
        Start symbol: spec. *)

    | MenhirState808 : ((((('s, _menhir_box_spec) _menhir_cell1_IMPLEMENTATION _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_as_ty, _menhir_box_spec) _menhir_state
      (** State 808.
        Stack shape : IMPLEMENTATION IDENTIFIER params_opt func_args IDENTIFIER as_ty.
        Start symbol: spec. *)

    | MenhirState809 : ((((('s _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_as_ty, _menhir_box_spec) _menhir_cell1_SETTER, _menhir_box_spec) _menhir_state
      (** State 809.
        Stack shape : IDENTIFIER params_opt func_args IDENTIFIER as_ty SETTER.
        Start symbol: spec. *)

    | MenhirState812 : (((((('s _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_as_ty, _menhir_box_spec) _menhir_cell1_SETTER, _menhir_box_spec) _menhir_cell1_stmt_list _menhir_cell0_SEMI_COLON, _menhir_box_spec) _menhir_state
      (** State 812.
        Stack shape : IDENTIFIER params_opt func_args IDENTIFIER as_ty SETTER stmt_list SEMI_COLON.
        Start symbol: spec. *)

    | MenhirState815 : ((((((('s _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_as_ty, _menhir_box_spec) _menhir_cell1_SETTER, _menhir_box_spec) _menhir_cell1_stmt_list _menhir_cell0_SEMI_COLON, _menhir_box_spec) _menhir_cell1_is_readonly, _menhir_box_spec) _menhir_state
      (** State 815.
        Stack shape : IDENTIFIER params_opt func_args IDENTIFIER as_ty SETTER stmt_list SEMI_COLON is_readonly.
        Start symbol: spec. *)

    | MenhirState820 : ((((('s _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_as_ty, _menhir_box_spec) _menhir_cell1_is_readonly, _menhir_box_spec) _menhir_state
      (** State 820.
        Stack shape : IDENTIFIER params_opt func_args IDENTIFIER as_ty is_readonly.
        Start symbol: spec. *)

    | MenhirState824 : (((((('s _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_as_ty, _menhir_box_spec) _menhir_cell1_is_readonly, _menhir_box_spec) _menhir_cell1_stmt_list _menhir_cell0_SEMI_COLON, _menhir_box_spec) _menhir_state
      (** State 824.
        Stack shape : IDENTIFIER params_opt func_args IDENTIFIER as_ty is_readonly stmt_list SEMI_COLON.
        Start symbol: spec. *)

    | MenhirState833 : (('s, _menhir_box_spec) _menhir_cell1_IMPDEF _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_state
      (** State 833.
        Stack shape : IMPDEF FUNC IDENTIFIER.
        Start symbol: spec. *)

    | MenhirState834 : ((('s, _menhir_box_spec) _menhir_cell1_IMPDEF _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_state
      (** State 834.
        Stack shape : IMPDEF FUNC IDENTIFIER params_opt.
        Start symbol: spec. *)

    | MenhirState835 : (((('s, _menhir_box_spec) _menhir_cell1_IMPDEF _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args, _menhir_box_spec) _menhir_state
      (** State 835.
        Stack shape : IMPDEF FUNC IDENTIFIER params_opt func_args.
        Start symbol: spec. *)

    | MenhirState836 : ((((('s, _menhir_box_spec) _menhir_cell1_IMPDEF _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args, _menhir_box_spec) _menhir_cell1_return_type, _menhir_box_spec) _menhir_state
      (** State 836.
        Stack shape : IMPDEF FUNC IDENTIFIER params_opt func_args return_type.
        Start symbol: spec. *)

    | MenhirState838 : (((((('s, _menhir_box_spec) _menhir_cell1_IMPDEF _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args, _menhir_box_spec) _menhir_cell1_return_type, _menhir_box_spec) _menhir_cell1_recurse_limit, _menhir_box_spec) _menhir_state
      (** State 838.
        Stack shape : IMPDEF FUNC IDENTIFIER params_opt func_args return_type recurse_limit.
        Start symbol: spec. *)

    | MenhirState843 : ((((('s, _menhir_box_spec) _menhir_cell1_IMPDEF _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args, _menhir_box_spec) _menhir_cell1_recurse_limit, _menhir_box_spec) _menhir_state
      (** State 843.
        Stack shape : IMPDEF FUNC IDENTIFIER params_opt func_args recurse_limit.
        Start symbol: spec. *)

    | MenhirState848 : (('s, _menhir_box_spec) _menhir_cell1_IMPDEF _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_state
      (** State 848.
        Stack shape : IMPDEF IDENTIFIER.
        Start symbol: spec. *)

    | MenhirState849 : ((('s, _menhir_box_spec) _menhir_cell1_IMPDEF _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_state
      (** State 849.
        Stack shape : IMPDEF IDENTIFIER params_opt.
        Start symbol: spec. *)

    | MenhirState852 : (((('s, _menhir_box_spec) _menhir_cell1_IMPDEF _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_state
      (** State 852.
        Stack shape : IMPDEF IDENTIFIER params_opt func_args IDENTIFIER.
        Start symbol: spec. *)

    | MenhirState854 : ((((('s, _menhir_box_spec) _menhir_cell1_IMPDEF _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_as_ty, _menhir_box_spec) _menhir_state
      (** State 854.
        Stack shape : IMPDEF IDENTIFIER params_opt func_args IDENTIFIER as_ty.
        Start symbol: spec. *)

    | MenhirState859 : (('s, _menhir_box_spec) _menhir_cell1_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_state
      (** State 859.
        Stack shape : FUNC IDENTIFIER.
        Start symbol: spec. *)

    | MenhirState860 : ((('s, _menhir_box_spec) _menhir_cell1_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_state
      (** State 860.
        Stack shape : FUNC IDENTIFIER params_opt.
        Start symbol: spec. *)

    | MenhirState861 : (((('s, _menhir_box_spec) _menhir_cell1_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args, _menhir_box_spec) _menhir_state
      (** State 861.
        Stack shape : FUNC IDENTIFIER params_opt func_args.
        Start symbol: spec. *)

    | MenhirState862 : ((((('s, _menhir_box_spec) _menhir_cell1_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args, _menhir_box_spec) _menhir_cell1_return_type, _menhir_box_spec) _menhir_state
      (** State 862.
        Stack shape : FUNC IDENTIFIER params_opt func_args return_type.
        Start symbol: spec. *)

    | MenhirState864 : (((((('s, _menhir_box_spec) _menhir_cell1_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args, _menhir_box_spec) _menhir_cell1_return_type, _menhir_box_spec) _menhir_cell1_recurse_limit, _menhir_box_spec) _menhir_state
      (** State 864.
        Stack shape : FUNC IDENTIFIER params_opt func_args return_type recurse_limit.
        Start symbol: spec. *)

    | MenhirState869 : ((((('s, _menhir_box_spec) _menhir_cell1_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args, _menhir_box_spec) _menhir_cell1_recurse_limit, _menhir_box_spec) _menhir_state
      (** State 869.
        Stack shape : FUNC IDENTIFIER params_opt func_args recurse_limit.
        Start symbol: spec. *)

    | MenhirState873 : (('s, _menhir_box_spec) _menhir_cell1_CONSTANT, _menhir_box_spec) _menhir_state
      (** State 873.
        Stack shape : CONSTANT.
        Start symbol: spec. *)

    | MenhirState874 : ((('s, _menhir_box_spec) _menhir_cell1_CONSTANT, _menhir_box_spec) _menhir_cell1_ignored_or_identifier, _menhir_box_spec) _menhir_state
      (** State 874.
        Stack shape : CONSTANT ignored_or_identifier.
        Start symbol: spec. *)

    | MenhirState875 : (((('s, _menhir_box_spec) _menhir_cell1_CONSTANT, _menhir_box_spec) _menhir_cell1_ignored_or_identifier, _menhir_box_spec) _menhir_cell1_EQ, _menhir_box_spec) _menhir_state
      (** State 875.
        Stack shape : CONSTANT ignored_or_identifier EQ.
        Start symbol: spec. *)

    | MenhirState876 : ((((('s, _menhir_box_spec) _menhir_cell1_CONSTANT, _menhir_box_spec) _menhir_cell1_ignored_or_identifier, _menhir_box_spec) _menhir_cell1_EQ, _menhir_box_spec) _menhir_cell1_expr, _menhir_box_spec) _menhir_state
      (** State 876.
        Stack shape : CONSTANT ignored_or_identifier EQ expr.
        Start symbol: spec. *)

    | MenhirState879 : (((('s, _menhir_box_spec) _menhir_cell1_CONSTANT, _menhir_box_spec) _menhir_cell1_ignored_or_identifier, _menhir_box_spec) _menhir_cell1_as_ty, _menhir_box_spec) _menhir_state
      (** State 879.
        Stack shape : CONSTANT ignored_or_identifier as_ty.
        Start symbol: spec. *)

    | MenhirState880 : ((((('s, _menhir_box_spec) _menhir_cell1_CONSTANT, _menhir_box_spec) _menhir_cell1_ignored_or_identifier, _menhir_box_spec) _menhir_cell1_as_ty, _menhir_box_spec) _menhir_cell1_expr, _menhir_box_spec) _menhir_state
      (** State 880.
        Stack shape : CONSTANT ignored_or_identifier as_ty expr.
        Start symbol: spec. *)

    | MenhirState884 : (('s, _menhir_box_spec) _menhir_cell1_CONFIG, _menhir_box_spec) _menhir_state
      (** State 884.
        Stack shape : CONFIG.
        Start symbol: spec. *)

    | MenhirState885 : ((('s, _menhir_box_spec) _menhir_cell1_CONFIG, _menhir_box_spec) _menhir_cell1_ignored_or_identifier, _menhir_box_spec) _menhir_state
      (** State 885.
        Stack shape : CONFIG ignored_or_identifier.
        Start symbol: spec. *)

    | MenhirState887 : (((('s, _menhir_box_spec) _menhir_cell1_CONFIG, _menhir_box_spec) _menhir_cell1_ignored_or_identifier, _menhir_box_spec) _menhir_cell1_as_ty, _menhir_box_spec) _menhir_state
      (** State 887.
        Stack shape : CONFIG ignored_or_identifier as_ty.
        Start symbol: spec. *)

    | MenhirState888 : ((((('s, _menhir_box_spec) _menhir_cell1_CONFIG, _menhir_box_spec) _menhir_cell1_ignored_or_identifier, _menhir_box_spec) _menhir_cell1_as_ty, _menhir_box_spec) _menhir_cell1_expr, _menhir_box_spec) _menhir_state
      (** State 888.
        Stack shape : CONFIG ignored_or_identifier as_ty expr.
        Start symbol: spec. *)

    | MenhirState893 : (('s, _menhir_box_spec) _menhir_cell1_ACCESSOR _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_state
      (** State 893.
        Stack shape : ACCESSOR IDENTIFIER.
        Start symbol: spec. *)

    | MenhirState894 : ((('s, _menhir_box_spec) _menhir_cell1_ACCESSOR _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_state
      (** State 894.
        Stack shape : ACCESSOR IDENTIFIER params_opt.
        Start symbol: spec. *)

    | MenhirState897 : (((('s, _menhir_box_spec) _menhir_cell1_ACCESSOR _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_state
      (** State 897.
        Stack shape : ACCESSOR IDENTIFIER params_opt func_args IDENTIFIER.
        Start symbol: spec. *)

    | MenhirState899 : ((((('s, _menhir_box_spec) _menhir_cell1_ACCESSOR _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_as_ty, _menhir_box_spec) _menhir_state
      (** State 899.
        Stack shape : ACCESSOR IDENTIFIER params_opt func_args IDENTIFIER as_ty.
        Start symbol: spec. *)

    | MenhirState906 : (('s, _menhir_box_spec) _menhir_cell1_decl, _menhir_box_spec) _menhir_state
      (** State 906.
        Stack shape : decl.
        Start symbol: spec. *)

    | MenhirState908 : ('s, _menhir_box_stmts) _menhir_state
      (** State 908.
        Stack shape : .
        Start symbol: stmts. *)

  
  and ('s, 'r) _menhir_cell1_access = 
    | MenhirCell1_access of 's * ('s, 'r) _menhir_state * (Desugar.field_or_array_access list)
  
  and ('s, 'r) _menhir_cell1_as_ty = 
    | MenhirCell1_as_ty of 's * ('s, 'r) _menhir_state * (AST.ty)
  
  and ('s, 'r) _menhir_cell1_bitfield = 
    | MenhirCell1_bitfield of 's * ('s, 'r) _menhir_state * (AST.bitfield)
  
  and ('s, 'r) _menhir_cell1_call = 
    | MenhirCell1_call of 's * ('s, 'r) _menhir_state * (AST.call) * Lexing.position * Lexing.position
  
  and ('s, 'r) _menhir_cell1_case_alt = 
    | MenhirCell1_case_alt of 's * ('s, 'r) _menhir_state * (AST.case_alt_desc AST.annotated)
  
  and ('s, 'r) _menhir_cell1_catcher = 
    | MenhirCell1_catcher of 's * ('s, 'r) _menhir_state * (AST.catcher)
  
  and ('s, 'r) _menhir_cell1_clist1_expr_ = 
    | MenhirCell1_clist1_expr_ of 's * ('s, 'r) _menhir_state * (AST.expr list)
  
  and ('s, 'r) _menhir_cell1_clist2_IDENTIFIER_ = 
    | MenhirCell1_clist2_IDENTIFIER_ of 's * ('s, 'r) _menhir_state * (string list)
  
  and ('s, 'r) _menhir_cell1_clist2_annotated_IDENTIFIER__ = 
    | MenhirCell1_clist2_annotated_IDENTIFIER__ of 's * ('s, 'r) _menhir_state * (string AST.annotated list)
  
  and ('s, 'r) _menhir_cell1_decl = 
    | MenhirCell1_decl of 's * ('s, 'r) _menhir_state * (AST.decl list)
  
  and ('s, 'r) _menhir_cell1_decl_item = 
    | MenhirCell1_decl_item of 's * ('s, 'r) _menhir_state * (AST.local_decl_item)
  
  and ('s, 'r) _menhir_cell1_direction = 
    | MenhirCell1_direction of 's * ('s, 'r) _menhir_state * (AST.for_direction)
  
  and ('s, 'r) _menhir_cell1_discard_or_basic_lexpr = 
    | MenhirCell1_discard_or_basic_lexpr of 's * ('s, 'r) _menhir_state * ((string AST.annotated * Desugar.lhs_access) option)
  
  and ('s, 'r) _menhir_cell1_discard_or_field = 
    | MenhirCell1_discard_or_field of 's * ('s, 'r) _menhir_state * (Desugar.lhs_field option)
  
  and ('s, 'r) _menhir_cell1_discard_or_identifier = 
    | MenhirCell1_discard_or_identifier of 's * ('s, 'r) _menhir_state * (string)
  
  and ('s, 'r) _menhir_cell1_expr = 
    | MenhirCell1_expr of 's * ('s, 'r) _menhir_state * (AST.expr) * Lexing.position * Lexing.position
  
  and ('s, 'r) _menhir_cell1_expr_pattern = 
    | MenhirCell1_expr_pattern of 's * ('s, 'r) _menhir_state * (AST.expr) * Lexing.position * Lexing.position
  
  and ('s, 'r) _menhir_cell1_field_assign = 
    | MenhirCell1_field_assign of 's * ('s, 'r) _menhir_state * (string * AST.expr)
  
  and ('s, 'r) _menhir_cell1_func_args = 
    | MenhirCell1_func_args of 's * ('s, 'r) _menhir_state * (AST.typed_identifier list)
  
  and ('s, 'r) _menhir_cell1_ignored_or_identifier = 
    | MenhirCell1_ignored_or_identifier of 's * ('s, 'r) _menhir_state * (string)
  
  and ('s, 'r) _menhir_cell1_int_constraint = 
    | MenhirCell1_int_constraint of 's * ('s, 'r) _menhir_state * (AST.int_constraint)
  
  and ('s, 'r) _menhir_cell1_is_readonly = 
    | MenhirCell1_is_readonly of 's * ('s, 'r) _menhir_state * (bool)
  
  and ('s, 'r) _menhir_cell1_lexpr = 
    | MenhirCell1_lexpr of 's * ('s, 'r) _menhir_state * (AST.lexpr) * Lexing.position
  
  and ('s, 'r) _menhir_cell1_list1_case_alt_ = 
    | MenhirCell1_list1_case_alt_ of 's * ('s, 'r) _menhir_state * (AST.case_alt_desc AST.annotated list)
  
  and ('s, 'r) _menhir_cell1_list1_catcher_ = 
    | MenhirCell1_list1_catcher_ of 's * ('s, 'r) _menhir_state * (AST.catcher list)
  
  and ('s, 'r) _menhir_cell1_loop_limit = 
    | MenhirCell1_loop_limit of 's * ('s, 'r) _menhir_state * (AST.expr option)
  
  and ('s, 'r) _menhir_cell1_opt_typed_identifier = 
    | MenhirCell1_opt_typed_identifier of 's * ('s, 'r) _menhir_state * (string * AST.ty option)
  
  and ('s, 'r) _menhir_cell1_params_opt = 
    | MenhirCell1_params_opt of 's * ('s, 'r) _menhir_state * ((string * AST.ty option) list)
  
  and ('s, 'r) _menhir_cell1_pattern = 
    | MenhirCell1_pattern of 's * ('s, 'r) _menhir_state * (AST.pattern) * Lexing.position * Lexing.position
  
  and ('s, 'r) _menhir_cell1_pattern_list = 
    | MenhirCell1_pattern_list of 's * ('s, 'r) _menhir_state * (AST.pattern)
  
  and ('s, 'r) _menhir_cell1_recurse_limit = 
    | MenhirCell1_recurse_limit of 's * ('s, 'r) _menhir_state * (AST.expr option)
  
  and ('s, 'r) _menhir_cell1_return_type = 
    | MenhirCell1_return_type of 's * ('s, 'r) _menhir_state * (AST.ty)
  
  and ('s, 'r) _menhir_cell1_setter_access = 
    | MenhirCell1_setter_access of 's * ('s, 'r) _menhir_state * (Desugar.field_or_array_access list)
  
  and ('s, 'r) _menhir_cell1_slice = 
    | MenhirCell1_slice of 's * ('s, 'r) _menhir_state * (AST.slice)
  
  and ('s, 'r) _menhir_cell1_slices = 
    | MenhirCell1_slices of 's * ('s, 'r) _menhir_state * (AST.slice list) * Lexing.position * Lexing.position
  
  and ('s, 'r) _menhir_cell1_stmt = 
    | MenhirCell1_stmt of 's * ('s, 'r) _menhir_state * (AST.stmt_desc AST.annotated) * Lexing.position
  
  and ('s, 'r) _menhir_cell1_stmt_list = 
    | MenhirCell1_stmt_list of 's * ('s, 'r) _menhir_state * (AST.stmt) * Lexing.position
  
  and ('s, 'r) _menhir_cell1_ty = 
    | MenhirCell1_ty of 's * ('s, 'r) _menhir_state * (AST.ty) * Lexing.position
  
  and ('s, 'r) _menhir_cell1_ty_decl = 
    | MenhirCell1_ty_decl of 's * ('s, 'r) _menhir_state * (AST.ty)
  
  and ('s, 'r) _menhir_cell1_typed_identifier = 
    | MenhirCell1_typed_identifier of 's * ('s, 'r) _menhir_state * (AST.field)
  
  and ('s, 'r) _menhir_cell1_ACCESSOR = 
    | MenhirCell1_ACCESSOR of 's * ('s, 'r) _menhir_state
  
  and ('s, 'r) _menhir_cell1_AND = 
    | MenhirCell1_AND of 's * ('s, 'r) _menhir_state
  
  and ('s, 'r) _menhir_cell1_ARBITRARY = 
    | MenhirCell1_ARBITRARY of 's * ('s, 'r) _menhir_state * Lexing.position
  
  and ('s, 'r) _menhir_cell1_ARRAY = 
    | MenhirCell1_ARRAY of 's * ('s, 'r) _menhir_state * Lexing.position
  
  and ('s, 'r) _menhir_cell1_ARROW = 
    | MenhirCell1_ARROW of 's * ('s, 'r) _menhir_state
  
  and ('s, 'r) _menhir_cell1_AS = 
    | MenhirCell1_AS of 's * ('s, 'r) _menhir_state
  
  and ('s, 'r) _menhir_cell1_ASSERT = 
    | MenhirCell1_ASSERT of 's * ('s, 'r) _menhir_state * Lexing.position
  
  and ('s, 'r) _menhir_cell1_BAND = 
    | MenhirCell1_BAND of 's * ('s, 'r) _menhir_state
  
  and ('s, 'r) _menhir_cell1_BEQ = 
    | MenhirCell1_BEQ of 's * ('s, 'r) _menhir_state
  
  and ('s, 'r) _menhir_cell1_BITS = 
    | MenhirCell1_BITS of 's * ('s, 'r) _menhir_state * Lexing.position
  
  and ('s, 'r) _menhir_cell1_BNOT = 
    | MenhirCell1_BNOT of 's * ('s, 'r) _menhir_state * Lexing.position
  
  and ('s, 'r) _menhir_cell1_BOR = 
    | MenhirCell1_BOR of 's * ('s, 'r) _menhir_state
  
  and ('s, 'r) _menhir_cell1_CASE = 
    | MenhirCell1_CASE of 's * ('s, 'r) _menhir_state * Lexing.position
  
  and ('s, 'r) _menhir_cell1_COLLECTION = 
    | MenhirCell1_COLLECTION of 's * ('s, 'r) _menhir_state * Lexing.position * Lexing.position
  
  and ('s, 'r) _menhir_cell1_COLON = 
    | MenhirCell1_COLON of 's * ('s, 'r) _menhir_state * Lexing.position * Lexing.position
  
  and 's _menhir_cell0_COLON = 
    | MenhirCell0_COLON of 's * Lexing.position * Lexing.position
  
  and ('s, 'r) _menhir_cell1_COLON_COLON = 
    | MenhirCell1_COLON_COLON of 's * ('s, 'r) _menhir_state
  
  and ('s, 'r) _menhir_cell1_COMMA = 
    | MenhirCell1_COMMA of 's * ('s, 'r) _menhir_state
  
  and ('s, 'r) _menhir_cell1_CONFIG = 
    | MenhirCell1_CONFIG of 's * ('s, 'r) _menhir_state * Lexing.position
  
  and ('s, 'r) _menhir_cell1_CONSTANT = 
    | MenhirCell1_CONSTANT of 's * ('s, 'r) _menhir_state * Lexing.position * Lexing.position
  
  and ('s, 'r) _menhir_cell1_DEBUG = 
    | MenhirCell1_DEBUG of 's * ('s, 'r) _menhir_state * Lexing.position
  
  and ('s, 'r) _menhir_cell1_DIV = 
    | MenhirCell1_DIV of 's * ('s, 'r) _menhir_state
  
  and ('s, 'r) _menhir_cell1_DIVRM = 
    | MenhirCell1_DIVRM of 's * ('s, 'r) _menhir_state
  
  and ('s, 'r) _menhir_cell1_DOT = 
    | MenhirCell1_DOT of 's * ('s, 'r) _menhir_state
  
  and ('s, 'r) _menhir_cell1_ELSE = 
    | MenhirCell1_ELSE of 's * ('s, 'r) _menhir_state
  
  and ('s, 'r) _menhir_cell1_ELSIF = 
    | MenhirCell1_ELSIF of 's * ('s, 'r) _menhir_state * Lexing.position * Lexing.position
  
  and ('s, 'r) _menhir_cell1_ENUMERATION = 
    | MenhirCell1_ENUMERATION of 's * ('s, 'r) _menhir_state * Lexing.position
  
  and ('s, 'r) _menhir_cell1_EQ = 
    | MenhirCell1_EQ of 's * ('s, 'r) _menhir_state
  
  and ('s, 'r) _menhir_cell1_EQ_EQ = 
    | MenhirCell1_EQ_EQ of 's * ('s, 'r) _menhir_state
  
  and ('s, 'r) _menhir_cell1_EXCEPTION = 
    | MenhirCell1_EXCEPTION of 's * ('s, 'r) _menhir_state * Lexing.position * Lexing.position
  
  and ('s, 'r) _menhir_cell1_FOR = 
    | MenhirCell1_FOR of 's * ('s, 'r) _menhir_state * Lexing.position
  
  and ('s, 'r) _menhir_cell1_FUNC = 
    | MenhirCell1_FUNC of 's * ('s, 'r) _menhir_state * Lexing.position
  
  and 's _menhir_cell0_FUNC = 
    | MenhirCell0_FUNC of 's * Lexing.position
  
  and ('s, 'r) _menhir_cell1_GE = 
    | MenhirCell1_GE of 's * ('s, 'r) _menhir_state * Lexing.position
  
  and ('s, 'r) _menhir_cell1_GT = 
    | MenhirCell1_GT of 's * ('s, 'r) _menhir_state
  
  and ('s, 'r) _menhir_cell1_IDENTIFIER = 
    | MenhirCell1_IDENTIFIER of 's * ('s, 'r) _menhir_state * (
# 137 "asllib/Tokens.mly"
       (string)
# 2520 "asllib/Parser.ml"
  ) * Lexing.position * Lexing.position
  
  and 's _menhir_cell0_IDENTIFIER = 
    | MenhirCell0_IDENTIFIER of 's * (
# 137 "asllib/Tokens.mly"
       (string)
# 2527 "asllib/Parser.ml"
  ) * Lexing.position * Lexing.position
  
  and ('s, 'r) _menhir_cell1_IF = 
    | MenhirCell1_IF of 's * ('s, 'r) _menhir_state * Lexing.position
  
  and ('s, 'r) _menhir_cell1_IMPDEF = 
    | MenhirCell1_IMPDEF of 's * ('s, 'r) _menhir_state * Lexing.position
  
  and 's _menhir_cell0_IMPDEF = 
    | MenhirCell0_IMPDEF of 's * Lexing.position
  
  and ('s, 'r) _menhir_cell1_IMPL = 
    | MenhirCell1_IMPL of 's * ('s, 'r) _menhir_state
  
  and ('s, 'r) _menhir_cell1_IMPLEMENTATION = 
    | MenhirCell1_IMPLEMENTATION of 's * ('s, 'r) _menhir_state * Lexing.position
  
  and 's _menhir_cell0_IMPLEMENTATION = 
    | MenhirCell0_IMPLEMENTATION of 's * Lexing.position
  
  and ('s, 'r) _menhir_cell1_IN = 
    | MenhirCell1_IN of 's * ('s, 'r) _menhir_state
  
  and ('s, 'r) _menhir_cell1_INTEGER = 
    | MenhirCell1_INTEGER of 's * ('s, 'r) _menhir_state * Lexing.position
  
  and ('s, 'r) _menhir_cell1_LBRACE = 
    | MenhirCell1_LBRACE of 's * ('s, 'r) _menhir_state * Lexing.position
  
  and 's _menhir_cell0_LBRACE = 
    | MenhirCell0_LBRACE of 's * Lexing.position
  
  and ('s, 'r) _menhir_cell1_LBRACKET = 
    | MenhirCell1_LBRACKET of 's * ('s, 'r) _menhir_state * Lexing.position
  
  and 's _menhir_cell0_LBRACKET = 
    | MenhirCell0_LBRACKET of 's * Lexing.position
  
  and ('s, 'r) _menhir_cell1_LE = 
    | MenhirCell1_LE of 's * ('s, 'r) _menhir_state * Lexing.position
  
  and ('s, 'r) _menhir_cell1_LET = 
    | MenhirCell1_LET of 's * ('s, 'r) _menhir_state * Lexing.position
  
  and ('s, 'r) _menhir_cell1_LLBRACKET = 
    | MenhirCell1_LLBRACKET of 's * ('s, 'r) _menhir_state
  
  and ('s, 'r) _menhir_cell1_LOOPLIMIT = 
    | MenhirCell1_LOOPLIMIT of 's * ('s, 'r) _menhir_state
  
  and ('s, 'r) _menhir_cell1_LPAR = 
    | MenhirCell1_LPAR of 's * ('s, 'r) _menhir_state * Lexing.position
  
  and 's _menhir_cell0_LPAR = 
    | MenhirCell0_LPAR of 's * Lexing.position
  
  and ('s, 'r) _menhir_cell1_LT = 
    | MenhirCell1_LT of 's * ('s, 'r) _menhir_state
  
  and ('s, 'r) _menhir_cell1_MINUS = 
    | MenhirCell1_MINUS of 's * ('s, 'r) _menhir_state * Lexing.position * Lexing.position
  
  and ('s, 'r) _menhir_cell1_MOD = 
    | MenhirCell1_MOD of 's * ('s, 'r) _menhir_state
  
  and ('s, 'r) _menhir_cell1_MUL = 
    | MenhirCell1_MUL of 's * ('s, 'r) _menhir_state
  
  and ('s, 'r) _menhir_cell1_NE = 
    | MenhirCell1_NE of 's * ('s, 'r) _menhir_state
  
  and ('s, 'r) _menhir_cell1_NORETURN = 
    | MenhirCell1_NORETURN of 's * ('s, 'r) _menhir_state * Lexing.position
  
  and ('s, 'r) _menhir_cell1_NOT = 
    | MenhirCell1_NOT of 's * ('s, 'r) _menhir_state * Lexing.position
  
  and ('s, 'r) _menhir_cell1_OF = 
    | MenhirCell1_OF of 's * ('s, 'r) _menhir_state
  
  and ('s, 'r) _menhir_cell1_OR = 
    | MenhirCell1_OR of 's * ('s, 'r) _menhir_state
  
  and ('s, 'r) _menhir_cell1_PLUS = 
    | MenhirCell1_PLUS of 's * ('s, 'r) _menhir_state
  
  and ('s, 'r) _menhir_cell1_PLUS_COLON = 
    | MenhirCell1_PLUS_COLON of 's * ('s, 'r) _menhir_state
  
  and ('s, 'r) _menhir_cell1_PLUS_PLUS = 
    | MenhirCell1_PLUS_PLUS of 's * ('s, 'r) _menhir_state
  
  and ('s, 'r) _menhir_cell1_POW = 
    | MenhirCell1_POW of 's * ('s, 'r) _menhir_state
  
  and ('s, 'r) _menhir_cell1_PRAGMA = 
    | MenhirCell1_PRAGMA of 's * ('s, 'r) _menhir_state * Lexing.position
  
  and ('s, 'r) _menhir_cell1_PRINT = 
    | MenhirCell1_PRINT of 's * ('s, 'r) _menhir_state * Lexing.position
  
  and ('s, 'r) _menhir_cell1_PRINTLN = 
    | MenhirCell1_PRINTLN of 's * ('s, 'r) _menhir_state * Lexing.position
  
  and ('s, 'r) _menhir_cell1_PURE = 
    | MenhirCell1_PURE of 's * ('s, 'r) _menhir_state * Lexing.position
  
  and ('s, 'r) _menhir_cell1_RBRACE = 
    | MenhirCell1_RBRACE of 's * ('s, 'r) _menhir_state * Lexing.position
  
  and 's _menhir_cell0_RBRACE = 
    | MenhirCell0_RBRACE of 's * Lexing.position
  
  and 's _menhir_cell0_RBRACKET = 
    | MenhirCell0_RBRACKET of 's * Lexing.position
  
  and ('s, 'r) _menhir_cell1_RDIV = 
    | MenhirCell1_RDIV of 's * ('s, 'r) _menhir_state
  
  and ('s, 'r) _menhir_cell1_READONLY = 
    | MenhirCell1_READONLY of 's * ('s, 'r) _menhir_state * Lexing.position
  
  and ('s, 'r) _menhir_cell1_RECORD = 
    | MenhirCell1_RECORD of 's * ('s, 'r) _menhir_state * Lexing.position * Lexing.position
  
  and ('s, 'r) _menhir_cell1_RECURSELIMIT = 
    | MenhirCell1_RECURSELIMIT of 's * ('s, 'r) _menhir_state
  
  and ('s, 'r) _menhir_cell1_REPEAT = 
    | MenhirCell1_REPEAT of 's * ('s, 'r) _menhir_state * Lexing.position
  
  and ('s, 'r) _menhir_cell1_RETURN = 
    | MenhirCell1_RETURN of 's * ('s, 'r) _menhir_state * Lexing.position
  
  and ('s, 'r) _menhir_cell1_RPAR = 
    | MenhirCell1_RPAR of 's * ('s, 'r) _menhir_state * Lexing.position
  
  and ('s, 'r) _menhir_cell1_RRBRACKET = 
    | MenhirCell1_RRBRACKET of 's * ('s, 'r) _menhir_state * Lexing.position
  
  and 's _menhir_cell0_SEMI_COLON = 
    | MenhirCell0_SEMI_COLON of 's * Lexing.position
  
  and ('s, 'r) _menhir_cell1_SETTER = 
    | MenhirCell1_SETTER of 's * ('s, 'r) _menhir_state
  
  and ('s, 'r) _menhir_cell1_SHL = 
    | MenhirCell1_SHL of 's * ('s, 'r) _menhir_state
  
  and ('s, 'r) _menhir_cell1_SHR = 
    | MenhirCell1_SHR of 's * ('s, 'r) _menhir_state
  
  and ('s, 'r) _menhir_cell1_SLICING = 
    | MenhirCell1_SLICING of 's * ('s, 'r) _menhir_state
  
  and ('s, 'r) _menhir_cell1_STAR_COLON = 
    | MenhirCell1_STAR_COLON of 's * ('s, 'r) _menhir_state
  
  and ('s, 'r) _menhir_cell1_SUBTYPES = 
    | MenhirCell1_SUBTYPES of 's * ('s, 'r) _menhir_state * Lexing.position
  
  and ('s, 'r) _menhir_cell1_THEN = 
    | MenhirCell1_THEN of 's * ('s, 'r) _menhir_state
  
  and ('s, 'r) _menhir_cell1_THROW = 
    | MenhirCell1_THROW of 's * ('s, 'r) _menhir_state * Lexing.position
  
  and ('s, 'r) _menhir_cell1_TRY = 
    | MenhirCell1_TRY of 's * ('s, 'r) _menhir_state * Lexing.position
  
  and ('s, 'r) _menhir_cell1_TYPE = 
    | MenhirCell1_TYPE of 's * ('s, 'r) _menhir_state * Lexing.position
  
  and ('s, 'r) _menhir_cell1_VAR = 
    | MenhirCell1_VAR of 's * ('s, 'r) _menhir_state * Lexing.position
  
  and ('s, 'r) _menhir_cell1_WHEN = 
    | MenhirCell1_WHEN of 's * ('s, 'r) _menhir_state * Lexing.position
  
  and ('s, 'r) _menhir_cell1_WHILE = 
    | MenhirCell1_WHILE of 's * ('s, 'r) _menhir_state * Lexing.position
  
  and ('s, 'r) _menhir_cell1_XOR = 
    | MenhirCell1_XOR of 's * ('s, 'r) _menhir_state
  
  and _menhir_box_stmts = 
    | MenhirBox_stmts of (AST.stmt) [@@unboxed]
  
  and _menhir_box_spec = 
    | MenhirBox_spec of (AST.t) [@@unboxed]
  
  and _menhir_box_opn = 
    | MenhirBox_opn of (AST.t) [@@unboxed]
  
  let _menhir_action_003 =
    fun () ->
      (
# 455 "asllib/Parser.mly"
    ( [] )
# 2727 "asllib/Parser.ml"
       : (Desugar.field_or_array_access list))
  
  let _menhir_action_004 =
    fun _1 _endpos_desc_ _startpos_desc_ desc t ->
      let h =
        let _endpos = _endpos_desc_ in
        let _symbolstartpos = _startpos_desc_ in
        
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 2738 "asllib/Parser.ml"
        
      in
      (
# 456 "asllib/Parser.mly"
                                            ( FieldAccess h :: t )
# 2744 "asllib/Parser.ml"
       : (Desugar.field_or_array_access list))
  
  let _menhir_action_005 =
    fun _1 _3 idx t ->
      (
# 457 "asllib/Parser.mly"
                                              ( ArrayAccess idx :: t )
# 2752 "asllib/Parser.ml"
       : (Desugar.field_or_array_access list))
  
  let _menhir_action_006 =
    fun _1 _1_inlined1 _2 _2_inlined1 _2_inlined2 _5 getter is_readonly setter ->
      let _7 =
        let (_2, _1) = (_2_inlined2, _1_inlined1) in
        ()
      in
      let _4 =
        let _2 = _2_inlined1 in
        ()
      in
      (
# 659 "asllib/Parser.mly"
    ( { is_readonly; getter; setter } )
# 2768 "asllib/Parser.ml"
       : (Desugar.accessor_pair))
  
  let _menhir_action_007 =
    fun _1 _1_inlined1 _1_inlined2 _2 _2_inlined1 _5 getter is_readonly setter ->
      let _7 =
        let (_2, _1) = (_2_inlined1, _1_inlined2) in
        ()
      in
      let _3 =
        let _1 = _1_inlined1 in
        ()
      in
      (
# 662 "asllib/Parser.mly"
    ( { is_readonly; getter; setter } )
# 2784 "asllib/Parser.ml"
       : (Desugar.accessor_pair))
  
  let _menhir_action_008 =
    fun _1 _2 ->
      (_2 : (AST.ty))
  
  let _menhir_action_009 =
    fun _endpos_desc_ _startpos_desc_ access desc ->
      let base =
        let _endpos = _endpos_desc_ in
        let _symbolstartpos = _startpos_desc_ in
        
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 2799 "asllib/Parser.ml"
        
      in
      (
# 461 "asllib/Parser.mly"
    ( ( base, {access; slices=add_dummy_annotation ~version []} ) )
# 2805 "asllib/Parser.ml"
       : (string AST.annotated * Desugar.lhs_access))
  
  let _menhir_action_010 =
    fun _endpos_desc_ _endpos_desc_inlined1_ _startpos_desc_ _startpos_desc_inlined1_ access desc desc_inlined1 ->
      let slices =
        let (_endpos_desc_, _startpos_desc_, desc) = (_endpos_desc_inlined1_, _startpos_desc_inlined1_, desc_inlined1) in
        let _endpos = _endpos_desc_ in
        let _symbolstartpos = _startpos_desc_ in
        
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 2817 "asllib/Parser.ml"
        
      in
      let base =
        let _endpos = _endpos_desc_ in
        let _symbolstartpos = _startpos_desc_ in
        
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 2826 "asllib/Parser.ml"
        
      in
      (
# 463 "asllib/Parser.mly"
    ( ( base, {access; slices} ) )
# 2832 "asllib/Parser.ml"
       : (string AST.annotated * Desugar.lhs_access))
  
  let _menhir_action_011 =
    fun s x ->
      (
# 390 "asllib/Parser.mly"
                                              ( BitField_Simple (x, s)     )
# 2840 "asllib/Parser.ml"
       : (AST.bitfield))
  
  let _menhir_action_012 =
    fun bf s x ->
      (
# 391 "asllib/Parser.mly"
                                              ( BitField_Nested (x, s, bf) )
# 2848 "asllib/Parser.ml"
       : (AST.bitfield))
  
  let _menhir_action_013 =
    fun s ty x ->
      (
# 392 "asllib/Parser.mly"
                                              ( BitField_Type   (x, s, ty) )
# 2856 "asllib/Parser.ml"
       : (AST.bitfield))
  
  let _menhir_action_014 =
    fun x ->
      (
# 205 "<standard.mly>"
    ( x )
# 2864 "asllib/Parser.ml"
       : (AST.bitfield list))
  
  let _menhir_action_015 =
    fun () ->
      (
# 387 "asllib/Parser.mly"
                     ( [] )
# 2872 "asllib/Parser.ml"
       : (AST.bitfield list))
  
  let _menhir_action_016 =
    fun _1 ->
      (_1 : (AST.bitfield list))
  
  let _menhir_action_017 =
    fun name x ->
      let args = 
# 205 "<standard.mly>"
    ( x )
# 2884 "asllib/Parser.ml"
       in
      (
# 618 "asllib/Parser.mly"
    ( { name; params=[]; args; call_type = ST_Function } )
# 2889 "asllib/Parser.ml"
       : (AST.call))
  
  let _menhir_action_018 =
    fun name x ->
      let args = 
# 615 "asllib/Parser.mly"
                     ( [] )
# 2897 "asllib/Parser.ml"
       in
      let params = 
# 205 "<standard.mly>"
    ( x )
# 2902 "asllib/Parser.ml"
       in
      (
# 620 "asllib/Parser.mly"
    ( { name; params; args; call_type = ST_Function } )
# 2907 "asllib/Parser.ml"
       : (AST.call))
  
  let _menhir_action_019 =
    fun name x x_inlined1 ->
      let args =
        let x = x_inlined1 in
        
# 205 "<standard.mly>"
    ( x )
# 2917 "asllib/Parser.ml"
        
      in
      let params = 
# 205 "<standard.mly>"
    ( x )
# 2923 "asllib/Parser.ml"
       in
      (
# 620 "asllib/Parser.mly"
    ( { name; params; args; call_type = ST_Function } )
# 2928 "asllib/Parser.ml"
       : (AST.call))
  
  let _menhir_action_020 =
    fun _1 _4 _endpos_stmt_ _startpos__1_ pattern stmt ->
      let desc =
        let where = 
# 123 "<standard.mly>"
    ( None )
# 2937 "asllib/Parser.ml"
         in
        
# 532 "asllib/Parser.mly"
      ( { pattern; where; stmt } )
# 2942 "asllib/Parser.ml"
        
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_stmt_, _startpos__1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 2951 "asllib/Parser.ml"
       : (AST.case_alt_desc AST.annotated))
  
  let _menhir_action_021 =
    fun _1 _1_inlined1 _2 _4 _endpos_stmt_ _startpos__1_ pattern stmt ->
      let desc =
        let where =
          let _1 = _1_inlined1 in
          let x = _2 in
          
# 126 "<standard.mly>"
    ( Some x )
# 2963 "asllib/Parser.ml"
          
        in
        
# 532 "asllib/Parser.mly"
      ( { pattern; where; stmt } )
# 2969 "asllib/Parser.ml"
        
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_stmt_, _startpos__1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 2978 "asllib/Parser.ml"
       : (AST.case_alt_desc AST.annotated))
  
  let _menhir_action_022 =
    fun _1 _4 stmt_list ty ->
      let _2 = 
# 123 "<standard.mly>"
    ( None )
# 2986 "asllib/Parser.ml"
       in
      let _2_1 = _2 in
      ((_2_1, ty, stmt_list) : (AST.catcher))
  
  let _menhir_action_023 =
    fun _1 _4 stmt_list ty x ->
      let _2 =
        let x = 
# 196 "<standard.mly>"
    ( x )
# 2997 "asllib/Parser.ml"
         in
        
# 126 "<standard.mly>"
    ( Some x )
# 3002 "asllib/Parser.ml"
        
      in
      let _2_1 = _2 in
      ((_2_1, ty, stmt_list) : (AST.catcher))
  
  let _menhir_action_024 =
    fun () ->
      (
# 182 "asllib/Parser.mly"
                 ( [] )
# 3013 "asllib/Parser.ml"
       : (AST.expr list))
  
  let _menhir_action_025 =
    fun _1 ->
      (_1 : (AST.expr list))
  
  let _menhir_action_026 =
    fun () ->
      (
# 182 "asllib/Parser.mly"
                 ( [] )
# 3025 "asllib/Parser.ml"
       : (AST.typed_identifier list))
  
  let _menhir_action_027 =
    fun _1 ->
      (_1 : (AST.typed_identifier list))
  
  let _menhir_action_028 =
    fun x ->
      (
# 178 "asllib/Parser.mly"
         ( [ x ] )
# 3037 "asllib/Parser.ml"
       : (string list))
  
  let _menhir_action_029 =
    fun _2 h t ->
      (
# 179 "asllib/Parser.mly"
                             ( h :: t )
# 3045 "asllib/Parser.ml"
       : (string list))
  
  let _menhir_action_030 =
    fun _endpos_desc_ _startpos_desc_ desc ->
      let x =
        let _endpos = _endpos_desc_ in
        let _symbolstartpos = _startpos_desc_ in
        
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 3056 "asllib/Parser.ml"
        
      in
      (
# 178 "asllib/Parser.mly"
         ( [ x ] )
# 3062 "asllib/Parser.ml"
       : (string AST.annotated list))
  
  let _menhir_action_031 =
    fun _2 _endpos_desc_ _startpos_desc_ desc t ->
      let h =
        let _endpos = _endpos_desc_ in
        let _symbolstartpos = _startpos_desc_ in
        
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 3073 "asllib/Parser.ml"
        
      in
      (
# 179 "asllib/Parser.mly"
                             ( h :: t )
# 3079 "asllib/Parser.ml"
       : (string AST.annotated list))
  
  let _menhir_action_032 =
    fun x ->
      (
# 178 "asllib/Parser.mly"
         ( [ x ] )
# 3087 "asllib/Parser.ml"
       : ((string AST.annotated * Desugar.lhs_access) option list))
  
  let _menhir_action_033 =
    fun _2 h t ->
      (
# 179 "asllib/Parser.mly"
                             ( h :: t )
# 3095 "asllib/Parser.ml"
       : ((string AST.annotated * Desugar.lhs_access) option list))
  
  let _menhir_action_034 =
    fun x ->
      (
# 178 "asllib/Parser.mly"
         ( [ x ] )
# 3103 "asllib/Parser.ml"
       : (Desugar.lhs_field option list))
  
  let _menhir_action_035 =
    fun _2 h t ->
      (
# 179 "asllib/Parser.mly"
                             ( h :: t )
# 3111 "asllib/Parser.ml"
       : (Desugar.lhs_field option list))
  
  let _menhir_action_036 =
    fun x ->
      (
# 178 "asllib/Parser.mly"
         ( [ x ] )
# 3119 "asllib/Parser.ml"
       : (string list))
  
  let _menhir_action_037 =
    fun _2 h t ->
      (
# 179 "asllib/Parser.mly"
                             ( h :: t )
# 3127 "asllib/Parser.ml"
       : (string list))
  
  let _menhir_action_038 =
    fun x ->
      (
# 178 "asllib/Parser.mly"
         ( [ x ] )
# 3135 "asllib/Parser.ml"
       : (AST.expr list))
  
  let _menhir_action_039 =
    fun _2 h t ->
      (
# 179 "asllib/Parser.mly"
                             ( h :: t )
# 3143 "asllib/Parser.ml"
       : (AST.expr list))
  
  let _menhir_action_040 =
    fun x ->
      (
# 178 "asllib/Parser.mly"
         ( [ x ] )
# 3151 "asllib/Parser.ml"
       : ((string * AST.expr) list))
  
  let _menhir_action_041 =
    fun _2 h t ->
      (
# 179 "asllib/Parser.mly"
                             ( h :: t )
# 3159 "asllib/Parser.ml"
       : ((string * AST.expr) list))
  
  let _menhir_action_042 =
    fun x ->
      (
# 178 "asllib/Parser.mly"
         ( [ x ] )
# 3167 "asllib/Parser.ml"
       : (AST.int_constraint list))
  
  let _menhir_action_043 =
    fun _2 h t ->
      (
# 179 "asllib/Parser.mly"
                             ( h :: t )
# 3175 "asllib/Parser.ml"
       : (AST.int_constraint list))
  
  let _menhir_action_044 =
    fun x ->
      (
# 178 "asllib/Parser.mly"
         ( [ x ] )
# 3183 "asllib/Parser.ml"
       : ((string * AST.ty option) list))
  
  let _menhir_action_045 =
    fun _2 h t ->
      (
# 179 "asllib/Parser.mly"
                             ( h :: t )
# 3191 "asllib/Parser.ml"
       : ((string * AST.ty option) list))
  
  let _menhir_action_046 =
    fun x ->
      (
# 178 "asllib/Parser.mly"
         ( [ x ] )
# 3199 "asllib/Parser.ml"
       : (AST.pattern list))
  
  let _menhir_action_047 =
    fun _2 h t ->
      (
# 179 "asllib/Parser.mly"
                             ( h :: t )
# 3207 "asllib/Parser.ml"
       : (AST.pattern list))
  
  let _menhir_action_048 =
    fun x ->
      (
# 178 "asllib/Parser.mly"
         ( [ x ] )
# 3215 "asllib/Parser.ml"
       : (AST.slice list))
  
  let _menhir_action_049 =
    fun _2 h t ->
      (
# 179 "asllib/Parser.mly"
                             ( h :: t )
# 3223 "asllib/Parser.ml"
       : (AST.slice list))
  
  let _menhir_action_050 =
    fun x ->
      (
# 178 "asllib/Parser.mly"
         ( [ x ] )
# 3231 "asllib/Parser.ml"
       : (AST.ty list))
  
  let _menhir_action_051 =
    fun _2 h t ->
      (
# 179 "asllib/Parser.mly"
                             ( h :: t )
# 3239 "asllib/Parser.ml"
       : (AST.ty list))
  
  let _menhir_action_052 =
    fun x ->
      (
# 178 "asllib/Parser.mly"
         ( [ x ] )
# 3247 "asllib/Parser.ml"
       : (AST.typed_identifier list))
  
  let _menhir_action_053 =
    fun _2 h t ->
      (
# 179 "asllib/Parser.mly"
                             ( h :: t )
# 3255 "asllib/Parser.ml"
       : (AST.typed_identifier list))
  
  let _menhir_action_054 =
    fun _2 li x ->
      (
# 185 "asllib/Parser.mly"
                                           ( x :: li )
# 3263 "asllib/Parser.ml"
       : (string list))
  
  let _menhir_action_055 =
    fun _2 _endpos_desc_ _startpos_desc_ desc li ->
      let x =
        let _endpos = _endpos_desc_ in
        let _symbolstartpos = _startpos_desc_ in
        
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 3274 "asllib/Parser.ml"
        
      in
      (
# 185 "asllib/Parser.mly"
                                           ( x :: li )
# 3280 "asllib/Parser.ml"
       : (string AST.annotated list))
  
  let _menhir_action_056 =
    fun _2 li x ->
      (
# 185 "asllib/Parser.mly"
                                           ( x :: li )
# 3288 "asllib/Parser.ml"
       : ((string AST.annotated * Desugar.lhs_access) option list))
  
  let _menhir_action_057 =
    fun _2 li x ->
      (
# 185 "asllib/Parser.mly"
                                           ( x :: li )
# 3296 "asllib/Parser.ml"
       : (Desugar.lhs_field option list))
  
  let _menhir_action_058 =
    fun _2 li x ->
      (
# 185 "asllib/Parser.mly"
                                           ( x :: li )
# 3304 "asllib/Parser.ml"
       : (string list))
  
  let _menhir_action_059 =
    fun _2 li x ->
      (
# 185 "asllib/Parser.mly"
                                           ( x :: li )
# 3312 "asllib/Parser.ml"
       : (AST.expr list))
  
  let _menhir_action_060 =
    fun _2 li x ->
      (
# 185 "asllib/Parser.mly"
                                           ( x :: li )
# 3320 "asllib/Parser.ml"
       : (AST.pattern list))
  
  let _menhir_action_061 =
    fun _2 li x ->
      (
# 185 "asllib/Parser.mly"
                                           ( x :: li )
# 3328 "asllib/Parser.ml"
       : (AST.ty list))
  
  let _menhir_action_062 =
    fun x ->
      let cs = 
# 205 "<standard.mly>"
    ( x )
# 3336 "asllib/Parser.ml"
       in
      (
# 310 "asllib/Parser.mly"
                                       ( WellConstrained (cs, Precision_Full) )
# 3341 "asllib/Parser.ml"
       : (AST.constraint_kind))
  
  let _menhir_action_063 =
    fun _endpos__3_ _startpos__1_ x ->
      let _1 = 
# 205 "<standard.mly>"
    ( x )
# 3349 "asllib/Parser.ml"
       in
      let _endpos__1_ = _endpos__3_ in
      let _endpos = _endpos__1_ in
      let _startpos = _startpos__1_ in
      (
# 311 "asllib/Parser.mly"
                   (
      Error.fatal_here _startpos _endpos @@
        Error.CannotParse (Some "Pending constraints are written `integer{}`.")
  )
# 3360 "asllib/Parser.ml"
       : (AST.constraint_kind))
  
  let _menhir_action_064 =
    fun _1 _2 ->
      (
# 315 "asllib/Parser.mly"
                    ( PendingConstrained )
# 3368 "asllib/Parser.ml"
       : (AST.constraint_kind))
  
  let _menhir_action_065 =
    fun _1 ->
      (_1 : (AST.constraint_kind))
  
  let _menhir_action_066 =
    fun () ->
      (
# 308 "asllib/Parser.mly"
                                             ( UnConstrained )
# 3380 "asllib/Parser.ml"
       : (AST.constraint_kind))
  
  let _menhir_action_067 =
    fun _1_inlined1 _2 _3 _endpos__2_ _startpos__3_ func_args name params_opt recurse_limit return_type x ->
      let d =
        let desc =
          let body =
            let _3 =
              let _1 = _1_inlined1 in
              ()
            in
            
# 205 "<standard.mly>"
    ( x )
# 3395 "asllib/Parser.ml"
            
          in
          let override = 
# 123 "<standard.mly>"
    ( None )
# 3401 "asllib/Parser.ml"
           in
          let purity_keyword = 
# 123 "<standard.mly>"
    ( None )
# 3406 "asllib/Parser.ml"
           in
          
# 668 "asllib/Parser.mly"
        (
          D_Func {
            name;
            parameters = params_opt;
            args = func_args;
            body = SB_ASL body;
            return_type = Some return_type;
            subprogram_type = ST_Function;
            recurse_limit;
            qualifier = purity_keyword;
            override;
            builtin = false;
          }
        )
# 3424 "asllib/Parser.ml"
          
        in
        let (_endpos_desc_, _startpos_desc_) = (_endpos__2_, _startpos__3_) in
        let _endpos = _endpos_desc_ in
        let _symbolstartpos = _startpos_desc_ in
        
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 3433 "asllib/Parser.ml"
        
      in
      (
# 726 "asllib/Parser.mly"
     ( [d] )
# 3439 "asllib/Parser.ml"
       : (AST.decl list))
  
  let _menhir_action_068 =
    fun _1 _1_inlined2 _2 _3 _endpos__2_ _startpos__1_ func_args name params_opt recurse_limit return_type x ->
      let d =
        let desc =
          let body =
            let _1_inlined1 = _1_inlined2 in
            let _3 =
              let _1 = _1_inlined1 in
              ()
            in
            
# 205 "<standard.mly>"
    ( x )
# 3455 "asllib/Parser.ml"
            
          in
          let override =
            let x = 
# 653 "asllib/Parser.mly"
              ( Impdef )
# 3462 "asllib/Parser.ml"
             in
            
# 126 "<standard.mly>"
    ( Some x )
# 3467 "asllib/Parser.ml"
            
          in
          let purity_keyword = 
# 123 "<standard.mly>"
    ( None )
# 3473 "asllib/Parser.ml"
           in
          
# 668 "asllib/Parser.mly"
        (
          D_Func {
            name;
            parameters = params_opt;
            args = func_args;
            body = SB_ASL body;
            return_type = Some return_type;
            subprogram_type = ST_Function;
            recurse_limit;
            qualifier = purity_keyword;
            override;
            builtin = false;
          }
        )
# 3491 "asllib/Parser.ml"
          
        in
        let (_endpos_desc_, _startpos_desc_) = (_endpos__2_, _startpos__1_) in
        let _endpos = _endpos_desc_ in
        let _symbolstartpos = _startpos_desc_ in
        
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 3500 "asllib/Parser.ml"
        
      in
      (
# 726 "asllib/Parser.mly"
     ( [d] )
# 3506 "asllib/Parser.ml"
       : (AST.decl list))
  
  let _menhir_action_069 =
    fun _1 _1_inlined2 _2 _3 _endpos__2_ _startpos__1_ func_args name params_opt recurse_limit return_type x ->
      let d =
        let desc =
          let body =
            let _1_inlined1 = _1_inlined2 in
            let _3 =
              let _1 = _1_inlined1 in
              ()
            in
            
# 205 "<standard.mly>"
    ( x )
# 3522 "asllib/Parser.ml"
            
          in
          let override =
            let x = 
# 654 "asllib/Parser.mly"
                      ( Implementation )
# 3529 "asllib/Parser.ml"
             in
            
# 126 "<standard.mly>"
    ( Some x )
# 3534 "asllib/Parser.ml"
            
          in
          let purity_keyword = 
# 123 "<standard.mly>"
    ( None )
# 3540 "asllib/Parser.ml"
           in
          
# 668 "asllib/Parser.mly"
        (
          D_Func {
            name;
            parameters = params_opt;
            args = func_args;
            body = SB_ASL body;
            return_type = Some return_type;
            subprogram_type = ST_Function;
            recurse_limit;
            qualifier = purity_keyword;
            override;
            builtin = false;
          }
        )
# 3558 "asllib/Parser.ml"
          
        in
        let (_endpos_desc_, _startpos_desc_) = (_endpos__2_, _startpos__1_) in
        let _endpos = _endpos_desc_ in
        let _symbolstartpos = _startpos_desc_ in
        
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 3567 "asllib/Parser.ml"
        
      in
      (
# 726 "asllib/Parser.mly"
     ( [d] )
# 3573 "asllib/Parser.ml"
       : (AST.decl list))
  
  let _menhir_action_070 =
    fun _1 _1_inlined2 _2 _3 _endpos__2_ _startpos__1_ func_args name params_opt recurse_limit return_type x ->
      let d =
        let desc =
          let body =
            let _1_inlined1 = _1_inlined2 in
            let _3 =
              let _1 = _1_inlined1 in
              ()
            in
            
# 205 "<standard.mly>"
    ( x )
# 3589 "asllib/Parser.ml"
            
          in
          let override = 
# 123 "<standard.mly>"
    ( None )
# 3595 "asllib/Parser.ml"
           in
          let purity_keyword =
            let x = 
# 644 "asllib/Parser.mly"
                ( Pure )
# 3601 "asllib/Parser.ml"
             in
            
# 126 "<standard.mly>"
    ( Some x )
# 3606 "asllib/Parser.ml"
            
          in
          
# 668 "asllib/Parser.mly"
        (
          D_Func {
            name;
            parameters = params_opt;
            args = func_args;
            body = SB_ASL body;
            return_type = Some return_type;
            subprogram_type = ST_Function;
            recurse_limit;
            qualifier = purity_keyword;
            override;
            builtin = false;
          }
        )
# 3625 "asllib/Parser.ml"
          
        in
        let (_endpos_desc_, _startpos_desc_) = (_endpos__2_, _startpos__1_) in
        let _endpos = _endpos_desc_ in
        let _symbolstartpos = _startpos_desc_ in
        
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 3634 "asllib/Parser.ml"
        
      in
      (
# 726 "asllib/Parser.mly"
     ( [d] )
# 3640 "asllib/Parser.ml"
       : (AST.decl list))
  
  let _menhir_action_071 =
    fun _1 _1_inlined1 _1_inlined3 _2 _3 _endpos__2_ _startpos__1_ func_args name params_opt recurse_limit return_type x ->
      let d =
        let desc =
          let body =
            let _1_inlined1 = _1_inlined3 in
            let _3 =
              let _1 = _1_inlined1 in
              ()
            in
            
# 205 "<standard.mly>"
    ( x )
# 3656 "asllib/Parser.ml"
            
          in
          let override =
            let _1 = _1_inlined1 in
            let x = 
# 653 "asllib/Parser.mly"
              ( Impdef )
# 3664 "asllib/Parser.ml"
             in
            
# 126 "<standard.mly>"
    ( Some x )
# 3669 "asllib/Parser.ml"
            
          in
          let purity_keyword =
            let x = 
# 644 "asllib/Parser.mly"
                ( Pure )
# 3676 "asllib/Parser.ml"
             in
            
# 126 "<standard.mly>"
    ( Some x )
# 3681 "asllib/Parser.ml"
            
          in
          
# 668 "asllib/Parser.mly"
        (
          D_Func {
            name;
            parameters = params_opt;
            args = func_args;
            body = SB_ASL body;
            return_type = Some return_type;
            subprogram_type = ST_Function;
            recurse_limit;
            qualifier = purity_keyword;
            override;
            builtin = false;
          }
        )
# 3700 "asllib/Parser.ml"
          
        in
        let (_endpos_desc_, _startpos_desc_) = (_endpos__2_, _startpos__1_) in
        let _endpos = _endpos_desc_ in
        let _symbolstartpos = _startpos_desc_ in
        
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 3709 "asllib/Parser.ml"
        
      in
      (
# 726 "asllib/Parser.mly"
     ( [d] )
# 3715 "asllib/Parser.ml"
       : (AST.decl list))
  
  let _menhir_action_072 =
    fun _1 _1_inlined1 _1_inlined3 _2 _3 _endpos__2_ _startpos__1_ func_args name params_opt recurse_limit return_type x ->
      let d =
        let desc =
          let body =
            let _1_inlined1 = _1_inlined3 in
            let _3 =
              let _1 = _1_inlined1 in
              ()
            in
            
# 205 "<standard.mly>"
    ( x )
# 3731 "asllib/Parser.ml"
            
          in
          let override =
            let _1 = _1_inlined1 in
            let x = 
# 654 "asllib/Parser.mly"
                      ( Implementation )
# 3739 "asllib/Parser.ml"
             in
            
# 126 "<standard.mly>"
    ( Some x )
# 3744 "asllib/Parser.ml"
            
          in
          let purity_keyword =
            let x = 
# 644 "asllib/Parser.mly"
                ( Pure )
# 3751 "asllib/Parser.ml"
             in
            
# 126 "<standard.mly>"
    ( Some x )
# 3756 "asllib/Parser.ml"
            
          in
          
# 668 "asllib/Parser.mly"
        (
          D_Func {
            name;
            parameters = params_opt;
            args = func_args;
            body = SB_ASL body;
            return_type = Some return_type;
            subprogram_type = ST_Function;
            recurse_limit;
            qualifier = purity_keyword;
            override;
            builtin = false;
          }
        )
# 3775 "asllib/Parser.ml"
          
        in
        let (_endpos_desc_, _startpos_desc_) = (_endpos__2_, _startpos__1_) in
        let _endpos = _endpos_desc_ in
        let _symbolstartpos = _startpos_desc_ in
        
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 3784 "asllib/Parser.ml"
        
      in
      (
# 726 "asllib/Parser.mly"
     ( [d] )
# 3790 "asllib/Parser.ml"
       : (AST.decl list))
  
  let _menhir_action_073 =
    fun _1 _1_inlined2 _2 _3 _endpos__2_ _startpos__1_ func_args name params_opt recurse_limit return_type x ->
      let d =
        let desc =
          let body =
            let _1_inlined1 = _1_inlined2 in
            let _3 =
              let _1 = _1_inlined1 in
              ()
            in
            
# 205 "<standard.mly>"
    ( x )
# 3806 "asllib/Parser.ml"
            
          in
          let override = 
# 123 "<standard.mly>"
    ( None )
# 3812 "asllib/Parser.ml"
           in
          let purity_keyword =
            let x = 
# 645 "asllib/Parser.mly"
                ( Readonly )
# 3818 "asllib/Parser.ml"
             in
            
# 126 "<standard.mly>"
    ( Some x )
# 3823 "asllib/Parser.ml"
            
          in
          
# 668 "asllib/Parser.mly"
        (
          D_Func {
            name;
            parameters = params_opt;
            args = func_args;
            body = SB_ASL body;
            return_type = Some return_type;
            subprogram_type = ST_Function;
            recurse_limit;
            qualifier = purity_keyword;
            override;
            builtin = false;
          }
        )
# 3842 "asllib/Parser.ml"
          
        in
        let (_endpos_desc_, _startpos_desc_) = (_endpos__2_, _startpos__1_) in
        let _endpos = _endpos_desc_ in
        let _symbolstartpos = _startpos_desc_ in
        
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 3851 "asllib/Parser.ml"
        
      in
      (
# 726 "asllib/Parser.mly"
     ( [d] )
# 3857 "asllib/Parser.ml"
       : (AST.decl list))
  
  let _menhir_action_074 =
    fun _1 _1_inlined1 _1_inlined3 _2 _3 _endpos__2_ _startpos__1_ func_args name params_opt recurse_limit return_type x ->
      let d =
        let desc =
          let body =
            let _1_inlined1 = _1_inlined3 in
            let _3 =
              let _1 = _1_inlined1 in
              ()
            in
            
# 205 "<standard.mly>"
    ( x )
# 3873 "asllib/Parser.ml"
            
          in
          let override =
            let _1 = _1_inlined1 in
            let x = 
# 653 "asllib/Parser.mly"
              ( Impdef )
# 3881 "asllib/Parser.ml"
             in
            
# 126 "<standard.mly>"
    ( Some x )
# 3886 "asllib/Parser.ml"
            
          in
          let purity_keyword =
            let x = 
# 645 "asllib/Parser.mly"
                ( Readonly )
# 3893 "asllib/Parser.ml"
             in
            
# 126 "<standard.mly>"
    ( Some x )
# 3898 "asllib/Parser.ml"
            
          in
          
# 668 "asllib/Parser.mly"
        (
          D_Func {
            name;
            parameters = params_opt;
            args = func_args;
            body = SB_ASL body;
            return_type = Some return_type;
            subprogram_type = ST_Function;
            recurse_limit;
            qualifier = purity_keyword;
            override;
            builtin = false;
          }
        )
# 3917 "asllib/Parser.ml"
          
        in
        let (_endpos_desc_, _startpos_desc_) = (_endpos__2_, _startpos__1_) in
        let _endpos = _endpos_desc_ in
        let _symbolstartpos = _startpos_desc_ in
        
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 3926 "asllib/Parser.ml"
        
      in
      (
# 726 "asllib/Parser.mly"
     ( [d] )
# 3932 "asllib/Parser.ml"
       : (AST.decl list))
  
  let _menhir_action_075 =
    fun _1 _1_inlined1 _1_inlined3 _2 _3 _endpos__2_ _startpos__1_ func_args name params_opt recurse_limit return_type x ->
      let d =
        let desc =
          let body =
            let _1_inlined1 = _1_inlined3 in
            let _3 =
              let _1 = _1_inlined1 in
              ()
            in
            
# 205 "<standard.mly>"
    ( x )
# 3948 "asllib/Parser.ml"
            
          in
          let override =
            let _1 = _1_inlined1 in
            let x = 
# 654 "asllib/Parser.mly"
                      ( Implementation )
# 3956 "asllib/Parser.ml"
             in
            
# 126 "<standard.mly>"
    ( Some x )
# 3961 "asllib/Parser.ml"
            
          in
          let purity_keyword =
            let x = 
# 645 "asllib/Parser.mly"
                ( Readonly )
# 3968 "asllib/Parser.ml"
             in
            
# 126 "<standard.mly>"
    ( Some x )
# 3973 "asllib/Parser.ml"
            
          in
          
# 668 "asllib/Parser.mly"
        (
          D_Func {
            name;
            parameters = params_opt;
            args = func_args;
            body = SB_ASL body;
            return_type = Some return_type;
            subprogram_type = ST_Function;
            recurse_limit;
            qualifier = purity_keyword;
            override;
            builtin = false;
          }
        )
# 3992 "asllib/Parser.ml"
          
        in
        let (_endpos_desc_, _startpos_desc_) = (_endpos__2_, _startpos__1_) in
        let _endpos = _endpos_desc_ in
        let _symbolstartpos = _startpos_desc_ in
        
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 4001 "asllib/Parser.ml"
        
      in
      (
# 726 "asllib/Parser.mly"
     ( [d] )
# 4007 "asllib/Parser.ml"
       : (AST.decl list))
  
  let _menhir_action_076 =
    fun _1_inlined1 _2 _3 _endpos__2_ _startpos__3_ func_args name params_opt recurse_limit x ->
      let d =
        let desc =
          let body =
            let _3 =
              let _1 = _1_inlined1 in
              ()
            in
            
# 205 "<standard.mly>"
    ( x )
# 4022 "asllib/Parser.ml"
            
          in
          let override = 
# 123 "<standard.mly>"
    ( None )
# 4028 "asllib/Parser.ml"
           in
          let qualifier = 
# 123 "<standard.mly>"
    ( None )
# 4033 "asllib/Parser.ml"
           in
          
# 685 "asllib/Parser.mly"
        (
          D_Func {
            name;
            parameters = params_opt;
            args = func_args;
            body = SB_ASL body;
            return_type = None;
            subprogram_type = ST_Procedure;
            recurse_limit;
            qualifier;
            override;
            builtin = false;
          }
        )
# 4051 "asllib/Parser.ml"
          
        in
        let (_endpos_desc_, _startpos_desc_) = (_endpos__2_, _startpos__3_) in
        let _endpos = _endpos_desc_ in
        let _symbolstartpos = _startpos_desc_ in
        
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 4060 "asllib/Parser.ml"
        
      in
      (
# 726 "asllib/Parser.mly"
     ( [d] )
# 4066 "asllib/Parser.ml"
       : (AST.decl list))
  
  let _menhir_action_077 =
    fun _1 _1_inlined2 _2 _3 _endpos__2_ _startpos__1_ func_args name params_opt recurse_limit x ->
      let d =
        let desc =
          let body =
            let _1_inlined1 = _1_inlined2 in
            let _3 =
              let _1 = _1_inlined1 in
              ()
            in
            
# 205 "<standard.mly>"
    ( x )
# 4082 "asllib/Parser.ml"
            
          in
          let override =
            let x = 
# 653 "asllib/Parser.mly"
              ( Impdef )
# 4089 "asllib/Parser.ml"
             in
            
# 126 "<standard.mly>"
    ( Some x )
# 4094 "asllib/Parser.ml"
            
          in
          let qualifier = 
# 123 "<standard.mly>"
    ( None )
# 4100 "asllib/Parser.ml"
           in
          
# 685 "asllib/Parser.mly"
        (
          D_Func {
            name;
            parameters = params_opt;
            args = func_args;
            body = SB_ASL body;
            return_type = None;
            subprogram_type = ST_Procedure;
            recurse_limit;
            qualifier;
            override;
            builtin = false;
          }
        )
# 4118 "asllib/Parser.ml"
          
        in
        let (_endpos_desc_, _startpos_desc_) = (_endpos__2_, _startpos__1_) in
        let _endpos = _endpos_desc_ in
        let _symbolstartpos = _startpos_desc_ in
        
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 4127 "asllib/Parser.ml"
        
      in
      (
# 726 "asllib/Parser.mly"
     ( [d] )
# 4133 "asllib/Parser.ml"
       : (AST.decl list))
  
  let _menhir_action_078 =
    fun _1 _1_inlined2 _2 _3 _endpos__2_ _startpos__1_ func_args name params_opt recurse_limit x ->
      let d =
        let desc =
          let body =
            let _1_inlined1 = _1_inlined2 in
            let _3 =
              let _1 = _1_inlined1 in
              ()
            in
            
# 205 "<standard.mly>"
    ( x )
# 4149 "asllib/Parser.ml"
            
          in
          let override =
            let x = 
# 654 "asllib/Parser.mly"
                      ( Implementation )
# 4156 "asllib/Parser.ml"
             in
            
# 126 "<standard.mly>"
    ( Some x )
# 4161 "asllib/Parser.ml"
            
          in
          let qualifier = 
# 123 "<standard.mly>"
    ( None )
# 4167 "asllib/Parser.ml"
           in
          
# 685 "asllib/Parser.mly"
        (
          D_Func {
            name;
            parameters = params_opt;
            args = func_args;
            body = SB_ASL body;
            return_type = None;
            subprogram_type = ST_Procedure;
            recurse_limit;
            qualifier;
            override;
            builtin = false;
          }
        )
# 4185 "asllib/Parser.ml"
          
        in
        let (_endpos_desc_, _startpos_desc_) = (_endpos__2_, _startpos__1_) in
        let _endpos = _endpos_desc_ in
        let _symbolstartpos = _startpos_desc_ in
        
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 4194 "asllib/Parser.ml"
        
      in
      (
# 726 "asllib/Parser.mly"
     ( [d] )
# 4200 "asllib/Parser.ml"
       : (AST.decl list))
  
  let _menhir_action_079 =
    fun _1 _1_inlined2 _2 _3 _endpos__2_ _startpos__1_ func_args name params_opt recurse_limit x ->
      let d =
        let desc =
          let body =
            let _1_inlined1 = _1_inlined2 in
            let _3 =
              let _1 = _1_inlined1 in
              ()
            in
            
# 205 "<standard.mly>"
    ( x )
# 4216 "asllib/Parser.ml"
            
          in
          let override = 
# 123 "<standard.mly>"
    ( None )
# 4222 "asllib/Parser.ml"
           in
          let qualifier =
            let x = 
# 638 "asllib/Parser.mly"
                ( Pure )
# 4228 "asllib/Parser.ml"
             in
            
# 126 "<standard.mly>"
    ( Some x )
# 4233 "asllib/Parser.ml"
            
          in
          
# 685 "asllib/Parser.mly"
        (
          D_Func {
            name;
            parameters = params_opt;
            args = func_args;
            body = SB_ASL body;
            return_type = None;
            subprogram_type = ST_Procedure;
            recurse_limit;
            qualifier;
            override;
            builtin = false;
          }
        )
# 4252 "asllib/Parser.ml"
          
        in
        let (_endpos_desc_, _startpos_desc_) = (_endpos__2_, _startpos__1_) in
        let _endpos = _endpos_desc_ in
        let _symbolstartpos = _startpos_desc_ in
        
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 4261 "asllib/Parser.ml"
        
      in
      (
# 726 "asllib/Parser.mly"
     ( [d] )
# 4267 "asllib/Parser.ml"
       : (AST.decl list))
  
  let _menhir_action_080 =
    fun _1 _1_inlined1 _1_inlined3 _2 _3 _endpos__2_ _startpos__1_ func_args name params_opt recurse_limit x ->
      let d =
        let desc =
          let body =
            let _1_inlined1 = _1_inlined3 in
            let _3 =
              let _1 = _1_inlined1 in
              ()
            in
            
# 205 "<standard.mly>"
    ( x )
# 4283 "asllib/Parser.ml"
            
          in
          let override =
            let _1 = _1_inlined1 in
            let x = 
# 653 "asllib/Parser.mly"
              ( Impdef )
# 4291 "asllib/Parser.ml"
             in
            
# 126 "<standard.mly>"
    ( Some x )
# 4296 "asllib/Parser.ml"
            
          in
          let qualifier =
            let x = 
# 638 "asllib/Parser.mly"
                ( Pure )
# 4303 "asllib/Parser.ml"
             in
            
# 126 "<standard.mly>"
    ( Some x )
# 4308 "asllib/Parser.ml"
            
          in
          
# 685 "asllib/Parser.mly"
        (
          D_Func {
            name;
            parameters = params_opt;
            args = func_args;
            body = SB_ASL body;
            return_type = None;
            subprogram_type = ST_Procedure;
            recurse_limit;
            qualifier;
            override;
            builtin = false;
          }
        )
# 4327 "asllib/Parser.ml"
          
        in
        let (_endpos_desc_, _startpos_desc_) = (_endpos__2_, _startpos__1_) in
        let _endpos = _endpos_desc_ in
        let _symbolstartpos = _startpos_desc_ in
        
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 4336 "asllib/Parser.ml"
        
      in
      (
# 726 "asllib/Parser.mly"
     ( [d] )
# 4342 "asllib/Parser.ml"
       : (AST.decl list))
  
  let _menhir_action_081 =
    fun _1 _1_inlined1 _1_inlined3 _2 _3 _endpos__2_ _startpos__1_ func_args name params_opt recurse_limit x ->
      let d =
        let desc =
          let body =
            let _1_inlined1 = _1_inlined3 in
            let _3 =
              let _1 = _1_inlined1 in
              ()
            in
            
# 205 "<standard.mly>"
    ( x )
# 4358 "asllib/Parser.ml"
            
          in
          let override =
            let _1 = _1_inlined1 in
            let x = 
# 654 "asllib/Parser.mly"
                      ( Implementation )
# 4366 "asllib/Parser.ml"
             in
            
# 126 "<standard.mly>"
    ( Some x )
# 4371 "asllib/Parser.ml"
            
          in
          let qualifier =
            let x = 
# 638 "asllib/Parser.mly"
                ( Pure )
# 4378 "asllib/Parser.ml"
             in
            
# 126 "<standard.mly>"
    ( Some x )
# 4383 "asllib/Parser.ml"
            
          in
          
# 685 "asllib/Parser.mly"
        (
          D_Func {
            name;
            parameters = params_opt;
            args = func_args;
            body = SB_ASL body;
            return_type = None;
            subprogram_type = ST_Procedure;
            recurse_limit;
            qualifier;
            override;
            builtin = false;
          }
        )
# 4402 "asllib/Parser.ml"
          
        in
        let (_endpos_desc_, _startpos_desc_) = (_endpos__2_, _startpos__1_) in
        let _endpos = _endpos_desc_ in
        let _symbolstartpos = _startpos_desc_ in
        
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 4411 "asllib/Parser.ml"
        
      in
      (
# 726 "asllib/Parser.mly"
     ( [d] )
# 4417 "asllib/Parser.ml"
       : (AST.decl list))
  
  let _menhir_action_082 =
    fun _1 _1_inlined2 _2 _3 _endpos__2_ _startpos__1_ func_args name params_opt recurse_limit x ->
      let d =
        let desc =
          let body =
            let _1_inlined1 = _1_inlined2 in
            let _3 =
              let _1 = _1_inlined1 in
              ()
            in
            
# 205 "<standard.mly>"
    ( x )
# 4433 "asllib/Parser.ml"
            
          in
          let override = 
# 123 "<standard.mly>"
    ( None )
# 4439 "asllib/Parser.ml"
           in
          let qualifier =
            let x = 
# 639 "asllib/Parser.mly"
                ( Readonly )
# 4445 "asllib/Parser.ml"
             in
            
# 126 "<standard.mly>"
    ( Some x )
# 4450 "asllib/Parser.ml"
            
          in
          
# 685 "asllib/Parser.mly"
        (
          D_Func {
            name;
            parameters = params_opt;
            args = func_args;
            body = SB_ASL body;
            return_type = None;
            subprogram_type = ST_Procedure;
            recurse_limit;
            qualifier;
            override;
            builtin = false;
          }
        )
# 4469 "asllib/Parser.ml"
          
        in
        let (_endpos_desc_, _startpos_desc_) = (_endpos__2_, _startpos__1_) in
        let _endpos = _endpos_desc_ in
        let _symbolstartpos = _startpos_desc_ in
        
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 4478 "asllib/Parser.ml"
        
      in
      (
# 726 "asllib/Parser.mly"
     ( [d] )
# 4484 "asllib/Parser.ml"
       : (AST.decl list))
  
  let _menhir_action_083 =
    fun _1 _1_inlined1 _1_inlined3 _2 _3 _endpos__2_ _startpos__1_ func_args name params_opt recurse_limit x ->
      let d =
        let desc =
          let body =
            let _1_inlined1 = _1_inlined3 in
            let _3 =
              let _1 = _1_inlined1 in
              ()
            in
            
# 205 "<standard.mly>"
    ( x )
# 4500 "asllib/Parser.ml"
            
          in
          let override =
            let _1 = _1_inlined1 in
            let x = 
# 653 "asllib/Parser.mly"
              ( Impdef )
# 4508 "asllib/Parser.ml"
             in
            
# 126 "<standard.mly>"
    ( Some x )
# 4513 "asllib/Parser.ml"
            
          in
          let qualifier =
            let x = 
# 639 "asllib/Parser.mly"
                ( Readonly )
# 4520 "asllib/Parser.ml"
             in
            
# 126 "<standard.mly>"
    ( Some x )
# 4525 "asllib/Parser.ml"
            
          in
          
# 685 "asllib/Parser.mly"
        (
          D_Func {
            name;
            parameters = params_opt;
            args = func_args;
            body = SB_ASL body;
            return_type = None;
            subprogram_type = ST_Procedure;
            recurse_limit;
            qualifier;
            override;
            builtin = false;
          }
        )
# 4544 "asllib/Parser.ml"
          
        in
        let (_endpos_desc_, _startpos_desc_) = (_endpos__2_, _startpos__1_) in
        let _endpos = _endpos_desc_ in
        let _symbolstartpos = _startpos_desc_ in
        
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 4553 "asllib/Parser.ml"
        
      in
      (
# 726 "asllib/Parser.mly"
     ( [d] )
# 4559 "asllib/Parser.ml"
       : (AST.decl list))
  
  let _menhir_action_084 =
    fun _1 _1_inlined1 _1_inlined3 _2 _3 _endpos__2_ _startpos__1_ func_args name params_opt recurse_limit x ->
      let d =
        let desc =
          let body =
            let _1_inlined1 = _1_inlined3 in
            let _3 =
              let _1 = _1_inlined1 in
              ()
            in
            
# 205 "<standard.mly>"
    ( x )
# 4575 "asllib/Parser.ml"
            
          in
          let override =
            let _1 = _1_inlined1 in
            let x = 
# 654 "asllib/Parser.mly"
                      ( Implementation )
# 4583 "asllib/Parser.ml"
             in
            
# 126 "<standard.mly>"
    ( Some x )
# 4588 "asllib/Parser.ml"
            
          in
          let qualifier =
            let x = 
# 639 "asllib/Parser.mly"
                ( Readonly )
# 4595 "asllib/Parser.ml"
             in
            
# 126 "<standard.mly>"
    ( Some x )
# 4600 "asllib/Parser.ml"
            
          in
          
# 685 "asllib/Parser.mly"
        (
          D_Func {
            name;
            parameters = params_opt;
            args = func_args;
            body = SB_ASL body;
            return_type = None;
            subprogram_type = ST_Procedure;
            recurse_limit;
            qualifier;
            override;
            builtin = false;
          }
        )
# 4619 "asllib/Parser.ml"
          
        in
        let (_endpos_desc_, _startpos_desc_) = (_endpos__2_, _startpos__1_) in
        let _endpos = _endpos_desc_ in
        let _symbolstartpos = _startpos_desc_ in
        
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 4628 "asllib/Parser.ml"
        
      in
      (
# 726 "asllib/Parser.mly"
     ( [d] )
# 4634 "asllib/Parser.ml"
       : (AST.decl list))
  
  let _menhir_action_085 =
    fun _1 _1_inlined2 _2 _3 _endpos__2_ _startpos__1_ func_args name params_opt recurse_limit x ->
      let d =
        let desc =
          let body =
            let _1_inlined1 = _1_inlined2 in
            let _3 =
              let _1 = _1_inlined1 in
              ()
            in
            
# 205 "<standard.mly>"
    ( x )
# 4650 "asllib/Parser.ml"
            
          in
          let override = 
# 123 "<standard.mly>"
    ( None )
# 4656 "asllib/Parser.ml"
           in
          let qualifier =
            let x = 
# 640 "asllib/Parser.mly"
                ( Noreturn )
# 4662 "asllib/Parser.ml"
             in
            
# 126 "<standard.mly>"
    ( Some x )
# 4667 "asllib/Parser.ml"
            
          in
          
# 685 "asllib/Parser.mly"
        (
          D_Func {
            name;
            parameters = params_opt;
            args = func_args;
            body = SB_ASL body;
            return_type = None;
            subprogram_type = ST_Procedure;
            recurse_limit;
            qualifier;
            override;
            builtin = false;
          }
        )
# 4686 "asllib/Parser.ml"
          
        in
        let (_endpos_desc_, _startpos_desc_) = (_endpos__2_, _startpos__1_) in
        let _endpos = _endpos_desc_ in
        let _symbolstartpos = _startpos_desc_ in
        
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 4695 "asllib/Parser.ml"
        
      in
      (
# 726 "asllib/Parser.mly"
     ( [d] )
# 4701 "asllib/Parser.ml"
       : (AST.decl list))
  
  let _menhir_action_086 =
    fun _1 _1_inlined1 _1_inlined3 _2 _3 _endpos__2_ _startpos__1_ func_args name params_opt recurse_limit x ->
      let d =
        let desc =
          let body =
            let _1_inlined1 = _1_inlined3 in
            let _3 =
              let _1 = _1_inlined1 in
              ()
            in
            
# 205 "<standard.mly>"
    ( x )
# 4717 "asllib/Parser.ml"
            
          in
          let override =
            let _1 = _1_inlined1 in
            let x = 
# 653 "asllib/Parser.mly"
              ( Impdef )
# 4725 "asllib/Parser.ml"
             in
            
# 126 "<standard.mly>"
    ( Some x )
# 4730 "asllib/Parser.ml"
            
          in
          let qualifier =
            let x = 
# 640 "asllib/Parser.mly"
                ( Noreturn )
# 4737 "asllib/Parser.ml"
             in
            
# 126 "<standard.mly>"
    ( Some x )
# 4742 "asllib/Parser.ml"
            
          in
          
# 685 "asllib/Parser.mly"
        (
          D_Func {
            name;
            parameters = params_opt;
            args = func_args;
            body = SB_ASL body;
            return_type = None;
            subprogram_type = ST_Procedure;
            recurse_limit;
            qualifier;
            override;
            builtin = false;
          }
        )
# 4761 "asllib/Parser.ml"
          
        in
        let (_endpos_desc_, _startpos_desc_) = (_endpos__2_, _startpos__1_) in
        let _endpos = _endpos_desc_ in
        let _symbolstartpos = _startpos_desc_ in
        
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 4770 "asllib/Parser.ml"
        
      in
      (
# 726 "asllib/Parser.mly"
     ( [d] )
# 4776 "asllib/Parser.ml"
       : (AST.decl list))
  
  let _menhir_action_087 =
    fun _1 _1_inlined1 _1_inlined3 _2 _3 _endpos__2_ _startpos__1_ func_args name params_opt recurse_limit x ->
      let d =
        let desc =
          let body =
            let _1_inlined1 = _1_inlined3 in
            let _3 =
              let _1 = _1_inlined1 in
              ()
            in
            
# 205 "<standard.mly>"
    ( x )
# 4792 "asllib/Parser.ml"
            
          in
          let override =
            let _1 = _1_inlined1 in
            let x = 
# 654 "asllib/Parser.mly"
                      ( Implementation )
# 4800 "asllib/Parser.ml"
             in
            
# 126 "<standard.mly>"
    ( Some x )
# 4805 "asllib/Parser.ml"
            
          in
          let qualifier =
            let x = 
# 640 "asllib/Parser.mly"
                ( Noreturn )
# 4812 "asllib/Parser.ml"
             in
            
# 126 "<standard.mly>"
    ( Some x )
# 4817 "asllib/Parser.ml"
            
          in
          
# 685 "asllib/Parser.mly"
        (
          D_Func {
            name;
            parameters = params_opt;
            args = func_args;
            body = SB_ASL body;
            return_type = None;
            subprogram_type = ST_Procedure;
            recurse_limit;
            qualifier;
            override;
            builtin = false;
          }
        )
# 4836 "asllib/Parser.ml"
          
        in
        let (_endpos_desc_, _startpos_desc_) = (_endpos__2_, _startpos__1_) in
        let _endpos = _endpos_desc_ in
        let _symbolstartpos = _startpos_desc_ in
        
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 4845 "asllib/Parser.ml"
        
      in
      (
# 726 "asllib/Parser.mly"
     ( [d] )
# 4851 "asllib/Parser.ml"
       : (AST.decl list))
  
  let _menhir_action_088 =
    fun _1 _3 _endpos__2_ _startpos__1_ subtype_opt t x ->
      let d =
        let desc =
          let x = 
# 702 "asllib/Parser.mly"
                                                            D_TypeDecl            
# 4861 "asllib/Parser.ml"
           (x, t, subtype_opt) in
          
# 196 "<standard.mly>"
    ( x )
# 4866 "asllib/Parser.ml"
          
        in
        let (_endpos_desc_, _startpos_desc_) = (_endpos__2_, _startpos__1_) in
        let _endpos = _endpos_desc_ in
        let _symbolstartpos = _startpos_desc_ in
        
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 4875 "asllib/Parser.ml"
        
      in
      (
# 726 "asllib/Parser.mly"
     ( [d] )
# 4881 "asllib/Parser.ml"
       : (AST.decl list))
  
  let _menhir_action_089 =
    fun _1 _endpos__2_ _endpos_desc_ _startpos__1_ _startpos_desc_ desc x ->
      let d =
        let desc =
          let x =
            let s =
              let _endpos = _endpos_desc_ in
              let _symbolstartpos = _startpos_desc_ in
              
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 4895 "asllib/Parser.ml"
              
            in
            
# 705 "asllib/Parser.mly"
                                                            make_ty_decl_subtype  
# 4901 "asllib/Parser.ml"
             (x, s)
          in
          
# 196 "<standard.mly>"
    ( x )
# 4907 "asllib/Parser.ml"
          
        in
        let (_endpos_desc_, _startpos_desc_) = (_endpos__2_, _startpos__1_) in
        let _endpos = _endpos_desc_ in
        let _symbolstartpos = _startpos_desc_ in
        
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 4916 "asllib/Parser.ml"
        
      in
      (
# 726 "asllib/Parser.mly"
     ( [d] )
# 4922 "asllib/Parser.ml"
       : (AST.decl list))
  
  let _menhir_action_090 =
    fun _1 _4 _endpos__2_ _startpos__1_ name x ->
      let d =
        let desc =
          let x =
            let initial_value = 
# 164 "asllib/Parser.mly"
                        Some 
# 4933 "asllib/Parser.ml"
             x in
            let ty = 
# 123 "<standard.mly>"
    ( None )
# 4938 "asllib/Parser.ml"
             in
            let keyword = 
# 517 "asllib/Parser.mly"
                ( GDK_Let      )
# 4943 "asllib/Parser.ml"
             in
            
# 710 "asllib/Parser.mly"
        ( D_GlobalStorage { keyword; name; ty; initial_value } )
# 4948 "asllib/Parser.ml"
            
          in
          
# 196 "<standard.mly>"
    ( x )
# 4954 "asllib/Parser.ml"
          
        in
        let (_endpos_desc_, _startpos_desc_) = (_endpos__2_, _startpos__1_) in
        let _endpos = _endpos_desc_ in
        let _symbolstartpos = _startpos_desc_ in
        
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 4963 "asllib/Parser.ml"
        
      in
      (
# 726 "asllib/Parser.mly"
     ( [d] )
# 4969 "asllib/Parser.ml"
       : (AST.decl list))
  
  let _menhir_action_091 =
    fun _1 _4 _endpos__2_ _startpos__1_ name x x_inlined1 ->
      let d =
        let desc =
          let x =
            let initial_value =
              let x = x_inlined1 in
              
# 164 "asllib/Parser.mly"
                        Some 
# 4982 "asllib/Parser.ml"
               x
            in
            let ty = 
# 126 "<standard.mly>"
    ( Some x )
# 4988 "asllib/Parser.ml"
             in
            let keyword = 
# 517 "asllib/Parser.mly"
                ( GDK_Let      )
# 4993 "asllib/Parser.ml"
             in
            
# 710 "asllib/Parser.mly"
        ( D_GlobalStorage { keyword; name; ty; initial_value } )
# 4998 "asllib/Parser.ml"
            
          in
          
# 196 "<standard.mly>"
    ( x )
# 5004 "asllib/Parser.ml"
          
        in
        let (_endpos_desc_, _startpos_desc_) = (_endpos__2_, _startpos__1_) in
        let _endpos = _endpos_desc_ in
        let _symbolstartpos = _startpos_desc_ in
        
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 5013 "asllib/Parser.ml"
        
      in
      (
# 726 "asllib/Parser.mly"
     ( [d] )
# 5019 "asllib/Parser.ml"
       : (AST.decl list))
  
  let _menhir_action_092 =
    fun _1 _4 _endpos__2_ _startpos__1_ name x ->
      let d =
        let desc =
          let x =
            let initial_value = 
# 164 "asllib/Parser.mly"
                        Some 
# 5030 "asllib/Parser.ml"
             x in
            let ty = 
# 123 "<standard.mly>"
    ( None )
# 5035 "asllib/Parser.ml"
             in
            let keyword = 
# 518 "asllib/Parser.mly"
                ( GDK_Constant )
# 5040 "asllib/Parser.ml"
             in
            
# 710 "asllib/Parser.mly"
        ( D_GlobalStorage { keyword; name; ty; initial_value } )
# 5045 "asllib/Parser.ml"
            
          in
          
# 196 "<standard.mly>"
    ( x )
# 5051 "asllib/Parser.ml"
          
        in
        let (_endpos_desc_, _startpos_desc_) = (_endpos__2_, _startpos__1_) in
        let _endpos = _endpos_desc_ in
        let _symbolstartpos = _startpos_desc_ in
        
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 5060 "asllib/Parser.ml"
        
      in
      (
# 726 "asllib/Parser.mly"
     ( [d] )
# 5066 "asllib/Parser.ml"
       : (AST.decl list))
  
  let _menhir_action_093 =
    fun _1 _4 _endpos__2_ _startpos__1_ name x x_inlined1 ->
      let d =
        let desc =
          let x =
            let initial_value =
              let x = x_inlined1 in
              
# 164 "asllib/Parser.mly"
                        Some 
# 5079 "asllib/Parser.ml"
               x
            in
            let ty = 
# 126 "<standard.mly>"
    ( Some x )
# 5085 "asllib/Parser.ml"
             in
            let keyword = 
# 518 "asllib/Parser.mly"
                ( GDK_Constant )
# 5090 "asllib/Parser.ml"
             in
            
# 710 "asllib/Parser.mly"
        ( D_GlobalStorage { keyword; name; ty; initial_value } )
# 5095 "asllib/Parser.ml"
            
          in
          
# 196 "<standard.mly>"
    ( x )
# 5101 "asllib/Parser.ml"
          
        in
        let (_endpos_desc_, _startpos_desc_) = (_endpos__2_, _startpos__1_) in
        let _endpos = _endpos_desc_ in
        let _symbolstartpos = _startpos_desc_ in
        
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 5110 "asllib/Parser.ml"
        
      in
      (
# 726 "asllib/Parser.mly"
     ( [d] )
# 5116 "asllib/Parser.ml"
       : (AST.decl list))
  
  let _menhir_action_094 =
    fun _1 _4 _endpos__2_ _startpos__1_ name x ->
      let d =
        let desc =
          let x =
            let initial_value = 
# 164 "asllib/Parser.mly"
                        Some 
# 5127 "asllib/Parser.ml"
             x in
            let ty = 
# 123 "<standard.mly>"
    ( None )
# 5132 "asllib/Parser.ml"
             in
            let keyword = 
# 519 "asllib/Parser.mly"
                ( GDK_Var )
# 5137 "asllib/Parser.ml"
             in
            
# 710 "asllib/Parser.mly"
        ( D_GlobalStorage { keyword; name; ty; initial_value } )
# 5142 "asllib/Parser.ml"
            
          in
          
# 196 "<standard.mly>"
    ( x )
# 5148 "asllib/Parser.ml"
          
        in
        let (_endpos_desc_, _startpos_desc_) = (_endpos__2_, _startpos__1_) in
        let _endpos = _endpos_desc_ in
        let _symbolstartpos = _startpos_desc_ in
        
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 5157 "asllib/Parser.ml"
        
      in
      (
# 726 "asllib/Parser.mly"
     ( [d] )
# 5163 "asllib/Parser.ml"
       : (AST.decl list))
  
  let _menhir_action_095 =
    fun _1 _4 _endpos__2_ _startpos__1_ name x x_inlined1 ->
      let d =
        let desc =
          let x =
            let initial_value =
              let x = x_inlined1 in
              
# 164 "asllib/Parser.mly"
                        Some 
# 5176 "asllib/Parser.ml"
               x
            in
            let ty = 
# 126 "<standard.mly>"
    ( Some x )
# 5182 "asllib/Parser.ml"
             in
            let keyword = 
# 519 "asllib/Parser.mly"
                ( GDK_Var )
# 5187 "asllib/Parser.ml"
             in
            
# 710 "asllib/Parser.mly"
        ( D_GlobalStorage { keyword; name; ty; initial_value } )
# 5192 "asllib/Parser.ml"
            
          in
          
# 196 "<standard.mly>"
    ( x )
# 5198 "asllib/Parser.ml"
          
        in
        let (_endpos_desc_, _startpos_desc_) = (_endpos__2_, _startpos__1_) in
        let _endpos = _endpos_desc_ in
        let _symbolstartpos = _startpos_desc_ in
        
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 5207 "asllib/Parser.ml"
        
      in
      (
# 726 "asllib/Parser.mly"
     ( [d] )
# 5213 "asllib/Parser.ml"
       : (AST.decl list))
  
  let _menhir_action_096 =
    fun _1 _4 _endpos__2_ _startpos__1_ name ty x ->
      let d =
        let desc =
          let x =
            let initial_value = 
# 164 "asllib/Parser.mly"
                        Some 
# 5224 "asllib/Parser.ml"
             x in
            
# 713 "asllib/Parser.mly"
        ( D_GlobalStorage { keyword=GDK_Config; name; ty=Some ty; initial_value } )
# 5229 "asllib/Parser.ml"
            
          in
          
# 196 "<standard.mly>"
    ( x )
# 5235 "asllib/Parser.ml"
          
        in
        let (_endpos_desc_, _startpos_desc_) = (_endpos__2_, _startpos__1_) in
        let _endpos = _endpos_desc_ in
        let _symbolstartpos = _startpos_desc_ in
        
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 5244 "asllib/Parser.ml"
        
      in
      (
# 726 "asllib/Parser.mly"
     ( [d] )
# 5250 "asllib/Parser.ml"
       : (AST.decl list))
  
  let _menhir_action_097 =
    fun _1 _4 _endpos__2_ _endpos_desc_ _startpos__1_ _startpos_desc_ desc name ty ->
      let d =
        let desc =
          let x =
            let call =
              let _endpos = _endpos_desc_ in
              let _symbolstartpos = _startpos_desc_ in
              
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 5264 "asllib/Parser.ml"
              
            in
            let keyword = 
# 517 "asllib/Parser.mly"
                ( GDK_Let      )
# 5270 "asllib/Parser.ml"
             in
            
# 716 "asllib/Parser.mly"
        ( D_GlobalStorage { keyword; name; ty=Some ty; initial_value=desugar_elided_parameter ty call } )
# 5275 "asllib/Parser.ml"
            
          in
          
# 196 "<standard.mly>"
    ( x )
# 5281 "asllib/Parser.ml"
          
        in
        let (_endpos_desc_, _startpos_desc_) = (_endpos__2_, _startpos__1_) in
        let _endpos = _endpos_desc_ in
        let _symbolstartpos = _startpos_desc_ in
        
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 5290 "asllib/Parser.ml"
        
      in
      (
# 726 "asllib/Parser.mly"
     ( [d] )
# 5296 "asllib/Parser.ml"
       : (AST.decl list))
  
  let _menhir_action_098 =
    fun _1 _4 _endpos__2_ _endpos_desc_ _startpos__1_ _startpos_desc_ desc name ty ->
      let d =
        let desc =
          let x =
            let call =
              let _endpos = _endpos_desc_ in
              let _symbolstartpos = _startpos_desc_ in
              
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 5310 "asllib/Parser.ml"
              
            in
            let keyword = 
# 518 "asllib/Parser.mly"
                ( GDK_Constant )
# 5316 "asllib/Parser.ml"
             in
            
# 716 "asllib/Parser.mly"
        ( D_GlobalStorage { keyword; name; ty=Some ty; initial_value=desugar_elided_parameter ty call } )
# 5321 "asllib/Parser.ml"
            
          in
          
# 196 "<standard.mly>"
    ( x )
# 5327 "asllib/Parser.ml"
          
        in
        let (_endpos_desc_, _startpos_desc_) = (_endpos__2_, _startpos__1_) in
        let _endpos = _endpos_desc_ in
        let _symbolstartpos = _startpos_desc_ in
        
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 5336 "asllib/Parser.ml"
        
      in
      (
# 726 "asllib/Parser.mly"
     ( [d] )
# 5342 "asllib/Parser.ml"
       : (AST.decl list))
  
  let _menhir_action_099 =
    fun _1 _4 _endpos__2_ _endpos_desc_ _startpos__1_ _startpos_desc_ desc name ty ->
      let d =
        let desc =
          let x =
            let call =
              let _endpos = _endpos_desc_ in
              let _symbolstartpos = _startpos_desc_ in
              
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 5356 "asllib/Parser.ml"
              
            in
            let keyword = 
# 519 "asllib/Parser.mly"
                ( GDK_Var )
# 5362 "asllib/Parser.ml"
             in
            
# 716 "asllib/Parser.mly"
        ( D_GlobalStorage { keyword; name; ty=Some ty; initial_value=desugar_elided_parameter ty call } )
# 5367 "asllib/Parser.ml"
            
          in
          
# 196 "<standard.mly>"
    ( x )
# 5373 "asllib/Parser.ml"
          
        in
        let (_endpos_desc_, _startpos_desc_) = (_endpos__2_, _startpos__1_) in
        let _endpos = _endpos_desc_ in
        let _symbolstartpos = _startpos_desc_ in
        
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 5382 "asllib/Parser.ml"
        
      in
      (
# 726 "asllib/Parser.mly"
     ( [d] )
# 5388 "asllib/Parser.ml"
       : (AST.decl list))
  
  let _menhir_action_100 =
    fun _1 _4 _endpos__2_ _endpos_desc_ _startpos__1_ _startpos_desc_ desc name ty ->
      let d =
        let desc =
          let x =
            let call =
              let _endpos = _endpos_desc_ in
              let _symbolstartpos = _startpos_desc_ in
              
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 5402 "asllib/Parser.ml"
              
            in
            let keyword = 
# 523 "asllib/Parser.mly"
            ( GDK_Config )
# 5408 "asllib/Parser.ml"
             in
            
# 716 "asllib/Parser.mly"
        ( D_GlobalStorage { keyword; name; ty=Some ty; initial_value=desugar_elided_parameter ty call } )
# 5413 "asllib/Parser.ml"
            
          in
          
# 196 "<standard.mly>"
    ( x )
# 5419 "asllib/Parser.ml"
          
        in
        let (_endpos_desc_, _startpos_desc_) = (_endpos__2_, _startpos__1_) in
        let _endpos = _endpos_desc_ in
        let _symbolstartpos = _startpos_desc_ in
        
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 5428 "asllib/Parser.ml"
        
      in
      (
# 726 "asllib/Parser.mly"
     ( [d] )
# 5434 "asllib/Parser.ml"
       : (AST.decl list))
  
  let _menhir_action_101 =
    fun _1 _3 _endpos__2_ _startpos__1_ name x ->
      let d =
        let desc =
          let x =
            let ty = 
# 164 "asllib/Parser.mly"
                        Some 
# 5445 "asllib/Parser.ml"
             x in
            
# 720 "asllib/Parser.mly"
        ( D_GlobalStorage { keyword=GDK_Var; name; ty; initial_value=None})
# 5450 "asllib/Parser.ml"
            
          in
          
# 196 "<standard.mly>"
    ( x )
# 5456 "asllib/Parser.ml"
          
        in
        let (_endpos_desc_, _startpos_desc_) = (_endpos__2_, _startpos__1_) in
        let _endpos = _endpos_desc_ in
        let _symbolstartpos = _startpos_desc_ in
        
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 5465 "asllib/Parser.ml"
        
      in
      (
# 726 "asllib/Parser.mly"
     ( [d] )
# 5471 "asllib/Parser.ml"
       : (AST.decl list))
  
  let _menhir_action_102 =
    fun _1 _endpos__2_ _startpos__1_ e x ->
      let d =
        let desc =
          let x = 
# 723 "asllib/Parser.mly"
                                                D_Pragma  
# 5481 "asllib/Parser.ml"
           (x, e) in
          
# 196 "<standard.mly>"
    ( x )
# 5486 "asllib/Parser.ml"
          
        in
        let (_endpos_desc_, _startpos_desc_) = (_endpos__2_, _startpos__1_) in
        let _endpos = _endpos_desc_ in
        let _symbolstartpos = _startpos_desc_ in
        
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 5495 "asllib/Parser.ml"
        
      in
      (
# 726 "asllib/Parser.mly"
     ( [d] )
# 5501 "asllib/Parser.ml"
       : (AST.decl list))
  
  let _menhir_action_103 =
    fun _1 _2 _4 as_ty ->
      let _2_1 = _2 in
      (
# 727 "asllib/Parser.mly"
                                                                 Desugar.make_global_vars  
# 5510 "asllib/Parser.ml"
       (_2_1, as_ty) : (AST.decl list))
  
  let _menhir_action_104 =
    fun _1 _1_inlined1 _2 _2_inlined1 _6 accessors as_ty func_args name params_opt setter_arg ->
      let accessor_body =
        let _2 = _2_inlined1 in
        let _3 =
          let _1 = _1_inlined1 in
          ()
        in
        
# 733 "asllib/Parser.mly"
  ( accessors )
# 5524 "asllib/Parser.ml"
        
      in
      let override = 
# 123 "<standard.mly>"
    ( None )
# 5530 "asllib/Parser.ml"
       in
      (
# 730 "asllib/Parser.mly"
    ( desugar_accessor_pair override name params_opt func_args setter_arg as_ty accessor_body )
# 5535 "asllib/Parser.ml"
       : (AST.decl list))
  
  let _menhir_action_105 =
    fun _1 _1_inlined1 _1_inlined2 _2 _2_inlined1 _6 accessors as_ty func_args name params_opt setter_arg ->
      let accessor_body =
        let (_2, _1_inlined1, _1) = (_2_inlined1, _1_inlined2, _1_inlined1) in
        let _3 =
          let _1 = _1_inlined1 in
          ()
        in
        
# 733 "asllib/Parser.mly"
  ( accessors )
# 5549 "asllib/Parser.ml"
        
      in
      let override =
        let x = 
# 653 "asllib/Parser.mly"
              ( Impdef )
# 5556 "asllib/Parser.ml"
         in
        
# 126 "<standard.mly>"
    ( Some x )
# 5561 "asllib/Parser.ml"
        
      in
      (
# 730 "asllib/Parser.mly"
    ( desugar_accessor_pair override name params_opt func_args setter_arg as_ty accessor_body )
# 5567 "asllib/Parser.ml"
       : (AST.decl list))
  
  let _menhir_action_106 =
    fun _1 _1_inlined1 _1_inlined2 _2 _2_inlined1 _6 accessors as_ty func_args name params_opt setter_arg ->
      let accessor_body =
        let (_2, _1_inlined1, _1) = (_2_inlined1, _1_inlined2, _1_inlined1) in
        let _3 =
          let _1 = _1_inlined1 in
          ()
        in
        
# 733 "asllib/Parser.mly"
  ( accessors )
# 5581 "asllib/Parser.ml"
        
      in
      let override =
        let x = 
# 654 "asllib/Parser.mly"
                      ( Implementation )
# 5588 "asllib/Parser.ml"
         in
        
# 126 "<standard.mly>"
    ( Some x )
# 5593 "asllib/Parser.ml"
        
      in
      (
# 730 "asllib/Parser.mly"
    ( desugar_accessor_pair override name params_opt func_args setter_arg as_ty accessor_body )
# 5599 "asllib/Parser.ml"
       : (AST.decl list))
  
  let _menhir_action_107 =
    fun _1 _endpos__1_ _startpos__1_ ->
      let _endpos = _endpos__1_ in
      let _startpos = _startpos__1_ in
      (
# 493 "asllib/Parser.mly"
                                       (
      Error.fatal_here _startpos _endpos @@
        Error.CannotParse (Some "A local declaration must declare a name.")
    )
# 5612 "asllib/Parser.ml"
       : (AST.local_decl_item))
  
  let _menhir_action_108 =
    fun _1 ->
      let _1_1 = _1 in
      (
# 497 "asllib/Parser.mly"
                                         LDI_Var  
# 5621 "asllib/Parser.ml"
       _1_1 : (AST.local_decl_item))
  
  let _menhir_action_109 =
    fun _endpos__3_ _startpos__1_ x ->
      let vs = 
# 205 "<standard.mly>"
    ( x )
# 5629 "asllib/Parser.ml"
       in
      let (_endpos_vs_, _startpos_vs_) = (_endpos__3_, _startpos__1_) in
      let _endpos = _endpos_vs_ in
      let _startpos = _startpos_vs_ in
      (
# 498 "asllib/Parser.mly"
                                       (
      if List.for_all is_local_ignored vs then
        Error.fatal_here _startpos _endpos @@
          Error.CannotParse (Some "A local declaration must declare at least one name.")
      else LDI_Tuple vs
    )
# 5642 "asllib/Parser.ml"
       : (AST.local_decl_item))
  
  let _menhir_action_110 =
    fun _1 ->
      (
# 527 "asllib/Parser.mly"
                       ( AST.Up )
# 5650 "asllib/Parser.ml"
       : (AST.for_direction))
  
  let _menhir_action_111 =
    fun _1 ->
      (
# 527 "asllib/Parser.mly"
                                            ( AST.Down )
# 5658 "asllib/Parser.ml"
       : (AST.for_direction))
  
  let _menhir_action_112 =
    fun _1 ->
      (
# 466 "asllib/Parser.mly"
                          ( None )
# 5666 "asllib/Parser.ml"
       : ((string AST.annotated * Desugar.lhs_access) option))
  
  let _menhir_action_113 =
    fun basic_lexpr ->
      (
# 467 "asllib/Parser.mly"
                            Some  
# 5674 "asllib/Parser.ml"
       basic_lexpr : ((string AST.annotated * Desugar.lhs_access) option))
  
  let _menhir_action_114 =
    fun _1 ->
      (
# 470 "asllib/Parser.mly"
                             ( None )
# 5682 "asllib/Parser.ml"
       : (Desugar.lhs_field option))
  
  let _menhir_action_115 =
    fun _endpos_desc_ _startpos_desc_ desc ->
      let _1 =
        let _endpos = _endpos_desc_ in
        let _symbolstartpos = _startpos_desc_ in
        
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 5693 "asllib/Parser.ml"
        
      in
      let _1_1 = _1 in
      (
# 471 "asllib/Parser.mly"
                               Some  
# 5700 "asllib/Parser.ml"
       _1_1 : (Desugar.lhs_field option))
  
  let _menhir_action_116 =
    fun _1 ->
      (
# 489 "asllib/Parser.mly"
                   ( local_ignored () )
# 5708 "asllib/Parser.ml"
       : (string))
  
  let _menhir_action_117 =
    fun _1 ->
      (_1 : (string))
  
  let _menhir_action_118 =
    fun _1 _2 ->
      (_2 : (AST.expr))
  
  let _menhir_action_119 =
    fun _1 _endpos__1_ _startpos__1_ ->
      let _endpos = _endpos__1_ in
      let _startpos = _startpos__1_ in
      (
# 264 "asllib/Parser.mly"
                            (
      Error.fatal_here _startpos _endpos @@
        Error.CannotParse (Some "Use `else if` instead.")
    )
# 5729 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_120 =
    fun _2 _3 name ->
      let args = 
# 615 "asllib/Parser.mly"
                     ( [] )
# 5737 "asllib/Parser.ml"
       in
      (
# 623 "asllib/Parser.mly"
    ( { name; params=[]; args; call_type = ST_Function } )
# 5742 "asllib/Parser.ml"
       : (AST.call))
  
  let _menhir_action_121 =
    fun _2 _3 name x ->
      let args = 
# 205 "<standard.mly>"
    ( x )
# 5750 "asllib/Parser.ml"
       in
      (
# 623 "asllib/Parser.mly"
    ( { name; params=[]; args; call_type = ST_Function } )
# 5755 "asllib/Parser.ml"
       : (AST.call))
  
  let _menhir_action_122 =
    fun _2 _3 _5 name params ->
      let args = 
# 615 "asllib/Parser.mly"
                     ( [] )
# 5763 "asllib/Parser.ml"
       in
      (
# 625 "asllib/Parser.mly"
    ( { name; params; args; call_type = ST_Function } )
# 5768 "asllib/Parser.ml"
       : (AST.call))
  
  let _menhir_action_123 =
    fun _2 _3 _5 name params x ->
      let args = 
# 205 "<standard.mly>"
    ( x )
# 5776 "asllib/Parser.ml"
       in
      (
# 625 "asllib/Parser.mly"
    ( { name; params; args; call_type = ST_Function } )
# 5781 "asllib/Parser.ml"
       : (AST.call))
  
  let _menhir_action_124 =
    fun _endpos_value_ _startpos_value_ value ->
      let desc = 
# 273 "asllib/Parser.mly"
                                                                    E_Literal             
# 5789 "asllib/Parser.ml"
       value in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_value_, _startpos_value_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 5797 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_125 =
    fun _1 _endpos__1_ _startpos__1_ ->
      let desc =
        let _1_1 = _1 in
        
# 274 "asllib/Parser.mly"
                                                                    E_Var                 
# 5807 "asllib/Parser.ml"
         _1_1
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos__1_, _startpos__1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 5816 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_126 =
    fun _1 _endpos_e2_ _startpos_e1_ e1 e2 ->
      let desc =
        let op = 
# 228 "asllib/Parser.mly"
                  ( `AND    )
# 5825 "asllib/Parser.ml"
         in
        
# 275 "asllib/Parser.mly"
                                                                e_binop               
# 5830 "asllib/Parser.ml"
         (e1, op, e2)
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_e2_, _startpos_e1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 5839 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_127 =
    fun _1 _endpos_e2_ _startpos_e1_ e1 e2 ->
      let desc =
        let op = 
# 229 "asllib/Parser.mly"
                  ( `BAND   )
# 5848 "asllib/Parser.ml"
         in
        
# 275 "asllib/Parser.mly"
                                                                e_binop               
# 5853 "asllib/Parser.ml"
         (e1, op, e2)
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_e2_, _startpos_e1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 5862 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_128 =
    fun _1 _endpos_e2_ _startpos_e1_ e1 e2 ->
      let desc =
        let op = 
# 230 "asllib/Parser.mly"
                  ( `BOR    )
# 5871 "asllib/Parser.ml"
         in
        
# 275 "asllib/Parser.mly"
                                                                e_binop               
# 5876 "asllib/Parser.ml"
         (e1, op, e2)
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_e2_, _startpos_e1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 5885 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_129 =
    fun _1 _endpos_e2_ _startpos_e1_ e1 e2 ->
      let desc =
        let op = 
# 231 "asllib/Parser.mly"
                  ( `BEQ    )
# 5894 "asllib/Parser.ml"
         in
        
# 275 "asllib/Parser.mly"
                                                                e_binop               
# 5899 "asllib/Parser.ml"
         (e1, op, e2)
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_e2_, _startpos_e1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 5908 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_130 =
    fun _1 _endpos_e2_ _startpos_e1_ e1 e2 ->
      let desc =
        let op = 
# 232 "asllib/Parser.mly"
                  ( `DIV    )
# 5917 "asllib/Parser.ml"
         in
        
# 275 "asllib/Parser.mly"
                                                                e_binop               
# 5922 "asllib/Parser.ml"
         (e1, op, e2)
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_e2_, _startpos_e1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 5931 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_131 =
    fun _1 _endpos_e2_ _startpos_e1_ e1 e2 ->
      let desc =
        let op = 
# 233 "asllib/Parser.mly"
                  ( `DIVRM  )
# 5940 "asllib/Parser.ml"
         in
        
# 275 "asllib/Parser.mly"
                                                                e_binop               
# 5945 "asllib/Parser.ml"
         (e1, op, e2)
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_e2_, _startpos_e1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 5954 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_132 =
    fun _1 _endpos_e2_ _startpos_e1_ e1 e2 ->
      let desc =
        let op = 
# 234 "asllib/Parser.mly"
                  ( `XOR    )
# 5963 "asllib/Parser.ml"
         in
        
# 275 "asllib/Parser.mly"
                                                                e_binop               
# 5968 "asllib/Parser.ml"
         (e1, op, e2)
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_e2_, _startpos_e1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 5977 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_133 =
    fun _1 _endpos_e2_ _startpos_e1_ e1 e2 ->
      let desc =
        let op = 
# 235 "asllib/Parser.mly"
                  ( `EQ     )
# 5986 "asllib/Parser.ml"
         in
        
# 275 "asllib/Parser.mly"
                                                                e_binop               
# 5991 "asllib/Parser.ml"
         (e1, op, e2)
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_e2_, _startpos_e1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 6000 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_134 =
    fun _1 _endpos_e2_ _startpos_e1_ e1 e2 ->
      let desc =
        let op = 
# 236 "asllib/Parser.mly"
                  ( `NE     )
# 6009 "asllib/Parser.ml"
         in
        
# 275 "asllib/Parser.mly"
                                                                e_binop               
# 6014 "asllib/Parser.ml"
         (e1, op, e2)
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_e2_, _startpos_e1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 6023 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_135 =
    fun _1 _endpos_e2_ _startpos_e1_ e1 e2 ->
      let desc =
        let op = 
# 237 "asllib/Parser.mly"
                  ( `GT     )
# 6032 "asllib/Parser.ml"
         in
        
# 275 "asllib/Parser.mly"
                                                                e_binop               
# 6037 "asllib/Parser.ml"
         (e1, op, e2)
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_e2_, _startpos_e1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 6046 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_136 =
    fun _1 _endpos_e2_ _startpos_e1_ e1 e2 ->
      let desc =
        let op = 
# 238 "asllib/Parser.mly"
                  ( `GE     )
# 6055 "asllib/Parser.ml"
         in
        
# 275 "asllib/Parser.mly"
                                                                e_binop               
# 6060 "asllib/Parser.ml"
         (e1, op, e2)
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_e2_, _startpos_e1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 6069 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_137 =
    fun _1 _endpos_e2_ _startpos_e1_ e1 e2 ->
      let desc =
        let op = 
# 239 "asllib/Parser.mly"
                  ( `IMPL   )
# 6078 "asllib/Parser.ml"
         in
        
# 275 "asllib/Parser.mly"
                                                                e_binop               
# 6083 "asllib/Parser.ml"
         (e1, op, e2)
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_e2_, _startpos_e1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 6092 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_138 =
    fun _1 _endpos_e2_ _startpos_e1_ e1 e2 ->
      let desc =
        let op = 
# 240 "asllib/Parser.mly"
                  ( `LT     )
# 6101 "asllib/Parser.ml"
         in
        
# 275 "asllib/Parser.mly"
                                                                e_binop               
# 6106 "asllib/Parser.ml"
         (e1, op, e2)
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_e2_, _startpos_e1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 6115 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_139 =
    fun _1 _endpos_e2_ _startpos_e1_ e1 e2 ->
      let desc =
        let op = 
# 241 "asllib/Parser.mly"
                  ( `LE     )
# 6124 "asllib/Parser.ml"
         in
        
# 275 "asllib/Parser.mly"
                                                                e_binop               
# 6129 "asllib/Parser.ml"
         (e1, op, e2)
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_e2_, _startpos_e1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 6138 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_140 =
    fun _1 _endpos_e2_ _startpos_e1_ e1 e2 ->
      let desc =
        let op = 
# 242 "asllib/Parser.mly"
                  ( `ADD    )
# 6147 "asllib/Parser.ml"
         in
        
# 275 "asllib/Parser.mly"
                                                                e_binop               
# 6152 "asllib/Parser.ml"
         (e1, op, e2)
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_e2_, _startpos_e1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 6161 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_141 =
    fun _1 _endpos_e2_ _startpos_e1_ e1 e2 ->
      let desc =
        let op = 
# 243 "asllib/Parser.mly"
                  ( `SUB    )
# 6170 "asllib/Parser.ml"
         in
        
# 275 "asllib/Parser.mly"
                                                                e_binop               
# 6175 "asllib/Parser.ml"
         (e1, op, e2)
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_e2_, _startpos_e1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 6184 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_142 =
    fun _1 _endpos_e2_ _startpos_e1_ e1 e2 ->
      let desc =
        let op = 
# 244 "asllib/Parser.mly"
                  ( `MOD    )
# 6193 "asllib/Parser.ml"
         in
        
# 275 "asllib/Parser.mly"
                                                                e_binop               
# 6198 "asllib/Parser.ml"
         (e1, op, e2)
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_e2_, _startpos_e1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 6207 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_143 =
    fun _1 _endpos_e2_ _startpos_e1_ e1 e2 ->
      let desc =
        let op = 
# 245 "asllib/Parser.mly"
                  ( `MUL    )
# 6216 "asllib/Parser.ml"
         in
        
# 275 "asllib/Parser.mly"
                                                                e_binop               
# 6221 "asllib/Parser.ml"
         (e1, op, e2)
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_e2_, _startpos_e1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 6230 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_144 =
    fun _1 _endpos_e2_ _startpos_e1_ e1 e2 ->
      let desc =
        let op = 
# 246 "asllib/Parser.mly"
                  ( `OR     )
# 6239 "asllib/Parser.ml"
         in
        
# 275 "asllib/Parser.mly"
                                                                e_binop               
# 6244 "asllib/Parser.ml"
         (e1, op, e2)
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_e2_, _startpos_e1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 6253 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_145 =
    fun _1 _endpos_e2_ _startpos_e1_ e1 e2 ->
      let desc =
        let op = 
# 247 "asllib/Parser.mly"
                  ( `RDIV   )
# 6262 "asllib/Parser.ml"
         in
        
# 275 "asllib/Parser.mly"
                                                                e_binop               
# 6267 "asllib/Parser.ml"
         (e1, op, e2)
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_e2_, _startpos_e1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 6276 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_146 =
    fun _1 _endpos_e2_ _startpos_e1_ e1 e2 ->
      let desc =
        let op = 
# 248 "asllib/Parser.mly"
                  ( `SHL    )
# 6285 "asllib/Parser.ml"
         in
        
# 275 "asllib/Parser.mly"
                                                                e_binop               
# 6290 "asllib/Parser.ml"
         (e1, op, e2)
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_e2_, _startpos_e1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 6299 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_147 =
    fun _1 _endpos_e2_ _startpos_e1_ e1 e2 ->
      let desc =
        let op = 
# 249 "asllib/Parser.mly"
                  ( `SHR    )
# 6308 "asllib/Parser.ml"
         in
        
# 275 "asllib/Parser.mly"
                                                                e_binop               
# 6313 "asllib/Parser.ml"
         (e1, op, e2)
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_e2_, _startpos_e1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 6322 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_148 =
    fun _1 _endpos_e2_ _startpos_e1_ e1 e2 ->
      let desc =
        let op = 
# 250 "asllib/Parser.mly"
                  ( `POW    )
# 6331 "asllib/Parser.ml"
         in
        
# 275 "asllib/Parser.mly"
                                                                e_binop               
# 6336 "asllib/Parser.ml"
         (e1, op, e2)
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_e2_, _startpos_e1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 6345 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_149 =
    fun _1 _endpos_e2_ _startpos_e1_ e1 e2 ->
      let desc =
        let op = 
# 251 "asllib/Parser.mly"
                  ( `BV_CONCAT  )
# 6354 "asllib/Parser.ml"
         in
        
# 275 "asllib/Parser.mly"
                                                                e_binop               
# 6359 "asllib/Parser.ml"
         (e1, op, e2)
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_e2_, _startpos_e1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 6368 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_150 =
    fun _1 _endpos_e2_ _startpos_e1_ e1 e2 ->
      let desc =
        let op = 
# 252 "asllib/Parser.mly"
                  ( `STR_CONCAT )
# 6377 "asllib/Parser.ml"
         in
        
# 275 "asllib/Parser.mly"
                                                                e_binop               
# 6382 "asllib/Parser.ml"
         (e1, op, e2)
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_e2_, _startpos_e1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 6391 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_151 =
    fun _1 _endpos_e_ _startpos__1_ e ->
      let desc =
        let op = 
# 223 "asllib/Parser.mly"
            ( BNOT )
# 6400 "asllib/Parser.ml"
         in
        
# 276 "asllib/Parser.mly"
                                                                    E_Unop                
# 6405 "asllib/Parser.ml"
         (op, e)
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_e_, _startpos__1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 6414 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_152 =
    fun _1 _endpos_e_ _startpos__1_ e ->
      let desc =
        let op = 
# 224 "asllib/Parser.mly"
            ( NEG )
# 6423 "asllib/Parser.ml"
         in
        
# 276 "asllib/Parser.mly"
                                                                    E_Unop                
# 6428 "asllib/Parser.ml"
         (op, e)
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_e_, _startpos__1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 6437 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_153 =
    fun _1 _endpos_e_ _startpos__1_ e ->
      let desc =
        let op = 
# 225 "asllib/Parser.mly"
            ( NOT )
# 6446 "asllib/Parser.ml"
         in
        
# 276 "asllib/Parser.mly"
                                                                    E_Unop                
# 6451 "asllib/Parser.ml"
         (op, e)
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_e_, _startpos__1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 6460 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_154 =
    fun _1 _3 _endpos_e_else_ _startpos__1_ e1 e2 e_else ->
      let desc = 
# 277 "asllib/Parser.mly"
                                                                    E_Cond                
# 6468 "asllib/Parser.ml"
       (e1, e2, e_else) in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_e_else_, _startpos__1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 6476 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_155 =
    fun _endpos_call_ _startpos_call_ call ->
      let desc = 
# 278 "asllib/Parser.mly"
                                                                    e_call                
# 6484 "asllib/Parser.ml"
       call in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_call_, _startpos_call_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 6492 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_156 =
    fun _endpos_slices_ _startpos_e_ e slices ->
      let desc = 
# 279 "asllib/Parser.mly"
                                                                E_Slice               
# 6500 "asllib/Parser.ml"
       (e, slices) in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_slices_, _startpos_e_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 6508 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_157 =
    fun _2 _4 _endpos__4_ _startpos_e1_ e1 e2 ->
      let desc = 
# 280 "asllib/Parser.mly"
                                                                E_GetArray            
# 6516 "asllib/Parser.ml"
       (e1, e2) in
      let (_endpos_desc_, _startpos_desc_) = (_endpos__4_, _startpos_e1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 6524 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_158 =
    fun _2 _endpos_x_ _startpos_e_ e x ->
      let desc = 
# 281 "asllib/Parser.mly"
                                                                E_GetField            
# 6532 "asllib/Parser.ml"
       (e, x) in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_x_, _startpos_e_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 6540 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_159 =
    fun _2 _endpos__3_ _startpos_e_ e x ->
      let desc =
        let fs = 
# 205 "<standard.mly>"
    ( x )
# 6549 "asllib/Parser.ml"
         in
        
# 282 "asllib/Parser.mly"
                                                                E_GetFields           
# 6554 "asllib/Parser.ml"
         (e, fs)
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos__3_, _startpos_e_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 6563 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_160 =
    fun _2 _endpos_ty_ _startpos_expr_ expr ty ->
      let desc = 
# 284 "asllib/Parser.mly"
                                                                E_ATC                 
# 6571 "asllib/Parser.ml"
       (expr, ty) in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_ty_, _startpos_expr_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 6579 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_161 =
    fun _2 _endpos_constraint_kind_ _startpos_constraint_kind_ _startpos_expr_ constraint_kind expr ->
      let desc =
        let implicit_t_int =
          let desc = 
# 444 "asllib/Parser.mly"
                                                       T_Int 
# 6589 "asllib/Parser.ml"
           constraint_kind in
          let (_endpos_desc_, _startpos_desc_) = (_endpos_constraint_kind_, _startpos_constraint_kind_) in
          let _endpos = _endpos_desc_ in
          let _symbolstartpos = _startpos_desc_ in
          
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 6597 "asllib/Parser.ml"
          
        in
        
# 285 "asllib/Parser.mly"
                                                                E_ATC                 
# 6603 "asllib/Parser.ml"
         (expr, implicit_t_int)
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_constraint_kind_, _startpos_expr_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 6612 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_162 =
    fun _2 _endpos_pattern_set_ _startpos_expr_ expr pattern_set ->
      let desc = 
# 287 "asllib/Parser.mly"
                                                                E_Pattern             
# 6620 "asllib/Parser.ml"
       (expr, pattern_set) in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_pattern_set_, _startpos_expr_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 6628 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_163 =
    fun _1 _2 _endpos__1_ _startpos__1_ _startpos_expr_ expr ->
      let desc =
        let pattern_mask =
          let desc =
            let _1_1 = _1 in
            
# 352 "asllib/Parser.mly"
                                            Pattern_Mask  
# 6640 "asllib/Parser.ml"
             _1_1
          in
          let (_endpos_desc_, _startpos_desc_) = (_endpos__1_, _startpos__1_) in
          let _endpos = _endpos_desc_ in
          let _symbolstartpos = _startpos_desc_ in
          
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 6649 "asllib/Parser.ml"
          
        in
        
# 288 "asllib/Parser.mly"
                                                                E_Pattern             
# 6655 "asllib/Parser.ml"
         (expr, pattern_mask)
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos__1_, _startpos_expr_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 6664 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_164 =
    fun _1 _2 _endpos__1_ _startpos__1_ _startpos_e_ e ->
      let desc =
        let p =
          let desc =
            let _1_1 = _1 in
            
# 352 "asllib/Parser.mly"
                                            Pattern_Mask  
# 6676 "asllib/Parser.ml"
             _1_1
          in
          let (_endpos_desc_, _startpos_desc_) = (_endpos__1_, _startpos__1_) in
          let _endpos = _endpos_desc_ in
          let _symbolstartpos = _startpos_desc_ in
          
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 6685 "asllib/Parser.ml"
          
        in
        
# 289 "asllib/Parser.mly"
                                                              ( E_Pattern (e, Pattern_Not (p) |> add_pos_from p) )
# 6691 "asllib/Parser.ml"
        
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos__1_, _startpos_e_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 6700 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_165 =
    fun _1 _2 _endpos_ty_ _startpos__1_ ty ->
      let desc = 
# 290 "asllib/Parser.mly"
                                                                E_Arbitrary         
# 6708 "asllib/Parser.ml"
       ty in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_ty_, _startpos__1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 6716 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_166 =
    fun _endpos__3_ _startpos__1_ x ->
      let desc =
        let e = 
# 205 "<standard.mly>"
    ( x )
# 6725 "asllib/Parser.ml"
         in
        
# 291 "asllib/Parser.mly"
                                                              ( E_Tuple [ e ]        )
# 6730 "asllib/Parser.ml"
        
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos__3_, _startpos__1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 6739 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_167 =
    fun _2 _3 _4 _endpos__4_ _endpos_desc_ _startpos_desc_ desc ->
      let desc =
        let t =
          let _endpos = _endpos_desc_ in
          let _symbolstartpos = _startpos_desc_ in
          
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 6751 "asllib/Parser.ml"
          
        in
        
# 293 "asllib/Parser.mly"
        ( E_Record (add_pos_from t (T_Named t.desc), []) )
# 6757 "asllib/Parser.ml"
        
      in
      let _endpos_desc_ = _endpos__4_ in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 6766 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_168 =
    fun _endpos__3_ _endpos_desc_ _startpos_desc_ desc x ->
      let desc =
        let fields = 
# 205 "<standard.mly>"
    ( x )
# 6775 "asllib/Parser.ml"
         in
        let t =
          let _endpos = _endpos_desc_ in
          let _symbolstartpos = _startpos_desc_ in
          
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 6783 "asllib/Parser.ml"
          
        in
        
# 295 "asllib/Parser.mly"
        ( E_Record (add_pos_from t (T_Named t.desc), fields) )
# 6789 "asllib/Parser.ml"
        
      in
      let _endpos_desc_ = _endpos__3_ in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 6798 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_169 =
    fun _endpos__3_ _startpos__1_ x ->
      let desc =
        let _1 = 
# 205 "<standard.mly>"
    ( x )
# 6807 "asllib/Parser.ml"
         in
        let _1_1 = _1 in
        
# 297 "asllib/Parser.mly"
                                                                    E_Tuple               
# 6813 "asllib/Parser.ml"
         _1_1
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos__3_, _startpos__1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 6822 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_170 =
    fun _endpos_value_ _startpos_value_ value ->
      let desc = 
# 326 "asllib/Parser.mly"
                                                                    E_Literal             
# 6830 "asllib/Parser.ml"
       value in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_value_, _startpos_value_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 6838 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_171 =
    fun _1 _endpos__1_ _startpos__1_ ->
      let desc =
        let _1_1 = _1 in
        
# 327 "asllib/Parser.mly"
                                                                    E_Var                 
# 6848 "asllib/Parser.ml"
         _1_1
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos__1_, _startpos__1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 6857 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_172 =
    fun _1 _endpos_e2_ _startpos_e1_ e1 e2 ->
      let desc =
        let op = 
# 228 "asllib/Parser.mly"
                  ( `AND    )
# 6866 "asllib/Parser.ml"
         in
        
# 328 "asllib/Parser.mly"
                                                                        e_binop               
# 6871 "asllib/Parser.ml"
         (e1, op, e2)
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_e2_, _startpos_e1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 6880 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_173 =
    fun _1 _endpos_e2_ _startpos_e1_ e1 e2 ->
      let desc =
        let op = 
# 229 "asllib/Parser.mly"
                  ( `BAND   )
# 6889 "asllib/Parser.ml"
         in
        
# 328 "asllib/Parser.mly"
                                                                        e_binop               
# 6894 "asllib/Parser.ml"
         (e1, op, e2)
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_e2_, _startpos_e1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 6903 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_174 =
    fun _1 _endpos_e2_ _startpos_e1_ e1 e2 ->
      let desc =
        let op = 
# 230 "asllib/Parser.mly"
                  ( `BOR    )
# 6912 "asllib/Parser.ml"
         in
        
# 328 "asllib/Parser.mly"
                                                                        e_binop               
# 6917 "asllib/Parser.ml"
         (e1, op, e2)
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_e2_, _startpos_e1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 6926 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_175 =
    fun _1 _endpos_e2_ _startpos_e1_ e1 e2 ->
      let desc =
        let op = 
# 231 "asllib/Parser.mly"
                  ( `BEQ    )
# 6935 "asllib/Parser.ml"
         in
        
# 328 "asllib/Parser.mly"
                                                                        e_binop               
# 6940 "asllib/Parser.ml"
         (e1, op, e2)
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_e2_, _startpos_e1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 6949 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_176 =
    fun _1 _endpos_e2_ _startpos_e1_ e1 e2 ->
      let desc =
        let op = 
# 232 "asllib/Parser.mly"
                  ( `DIV    )
# 6958 "asllib/Parser.ml"
         in
        
# 328 "asllib/Parser.mly"
                                                                        e_binop               
# 6963 "asllib/Parser.ml"
         (e1, op, e2)
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_e2_, _startpos_e1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 6972 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_177 =
    fun _1 _endpos_e2_ _startpos_e1_ e1 e2 ->
      let desc =
        let op = 
# 233 "asllib/Parser.mly"
                  ( `DIVRM  )
# 6981 "asllib/Parser.ml"
         in
        
# 328 "asllib/Parser.mly"
                                                                        e_binop               
# 6986 "asllib/Parser.ml"
         (e1, op, e2)
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_e2_, _startpos_e1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 6995 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_178 =
    fun _1 _endpos_e2_ _startpos_e1_ e1 e2 ->
      let desc =
        let op = 
# 234 "asllib/Parser.mly"
                  ( `XOR    )
# 7004 "asllib/Parser.ml"
         in
        
# 328 "asllib/Parser.mly"
                                                                        e_binop               
# 7009 "asllib/Parser.ml"
         (e1, op, e2)
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_e2_, _startpos_e1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 7018 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_179 =
    fun _1 _endpos_e2_ _startpos_e1_ e1 e2 ->
      let desc =
        let op = 
# 235 "asllib/Parser.mly"
                  ( `EQ     )
# 7027 "asllib/Parser.ml"
         in
        
# 328 "asllib/Parser.mly"
                                                                        e_binop               
# 7032 "asllib/Parser.ml"
         (e1, op, e2)
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_e2_, _startpos_e1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 7041 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_180 =
    fun _1 _endpos_e2_ _startpos_e1_ e1 e2 ->
      let desc =
        let op = 
# 236 "asllib/Parser.mly"
                  ( `NE     )
# 7050 "asllib/Parser.ml"
         in
        
# 328 "asllib/Parser.mly"
                                                                        e_binop               
# 7055 "asllib/Parser.ml"
         (e1, op, e2)
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_e2_, _startpos_e1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 7064 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_181 =
    fun _1 _endpos_e2_ _startpos_e1_ e1 e2 ->
      let desc =
        let op = 
# 237 "asllib/Parser.mly"
                  ( `GT     )
# 7073 "asllib/Parser.ml"
         in
        
# 328 "asllib/Parser.mly"
                                                                        e_binop               
# 7078 "asllib/Parser.ml"
         (e1, op, e2)
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_e2_, _startpos_e1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 7087 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_182 =
    fun _1 _endpos_e2_ _startpos_e1_ e1 e2 ->
      let desc =
        let op = 
# 238 "asllib/Parser.mly"
                  ( `GE     )
# 7096 "asllib/Parser.ml"
         in
        
# 328 "asllib/Parser.mly"
                                                                        e_binop               
# 7101 "asllib/Parser.ml"
         (e1, op, e2)
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_e2_, _startpos_e1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 7110 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_183 =
    fun _1 _endpos_e2_ _startpos_e1_ e1 e2 ->
      let desc =
        let op = 
# 239 "asllib/Parser.mly"
                  ( `IMPL   )
# 7119 "asllib/Parser.ml"
         in
        
# 328 "asllib/Parser.mly"
                                                                        e_binop               
# 7124 "asllib/Parser.ml"
         (e1, op, e2)
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_e2_, _startpos_e1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 7133 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_184 =
    fun _1 _endpos_e2_ _startpos_e1_ e1 e2 ->
      let desc =
        let op = 
# 240 "asllib/Parser.mly"
                  ( `LT     )
# 7142 "asllib/Parser.ml"
         in
        
# 328 "asllib/Parser.mly"
                                                                        e_binop               
# 7147 "asllib/Parser.ml"
         (e1, op, e2)
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_e2_, _startpos_e1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 7156 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_185 =
    fun _1 _endpos_e2_ _startpos_e1_ e1 e2 ->
      let desc =
        let op = 
# 241 "asllib/Parser.mly"
                  ( `LE     )
# 7165 "asllib/Parser.ml"
         in
        
# 328 "asllib/Parser.mly"
                                                                        e_binop               
# 7170 "asllib/Parser.ml"
         (e1, op, e2)
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_e2_, _startpos_e1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 7179 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_186 =
    fun _1 _endpos_e2_ _startpos_e1_ e1 e2 ->
      let desc =
        let op = 
# 242 "asllib/Parser.mly"
                  ( `ADD    )
# 7188 "asllib/Parser.ml"
         in
        
# 328 "asllib/Parser.mly"
                                                                        e_binop               
# 7193 "asllib/Parser.ml"
         (e1, op, e2)
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_e2_, _startpos_e1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 7202 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_187 =
    fun _1 _endpos_e2_ _startpos_e1_ e1 e2 ->
      let desc =
        let op = 
# 243 "asllib/Parser.mly"
                  ( `SUB    )
# 7211 "asllib/Parser.ml"
         in
        
# 328 "asllib/Parser.mly"
                                                                        e_binop               
# 7216 "asllib/Parser.ml"
         (e1, op, e2)
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_e2_, _startpos_e1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 7225 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_188 =
    fun _1 _endpos_e2_ _startpos_e1_ e1 e2 ->
      let desc =
        let op = 
# 244 "asllib/Parser.mly"
                  ( `MOD    )
# 7234 "asllib/Parser.ml"
         in
        
# 328 "asllib/Parser.mly"
                                                                        e_binop               
# 7239 "asllib/Parser.ml"
         (e1, op, e2)
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_e2_, _startpos_e1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 7248 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_189 =
    fun _1 _endpos_e2_ _startpos_e1_ e1 e2 ->
      let desc =
        let op = 
# 245 "asllib/Parser.mly"
                  ( `MUL    )
# 7257 "asllib/Parser.ml"
         in
        
# 328 "asllib/Parser.mly"
                                                                        e_binop               
# 7262 "asllib/Parser.ml"
         (e1, op, e2)
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_e2_, _startpos_e1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 7271 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_190 =
    fun _1 _endpos_e2_ _startpos_e1_ e1 e2 ->
      let desc =
        let op = 
# 246 "asllib/Parser.mly"
                  ( `OR     )
# 7280 "asllib/Parser.ml"
         in
        
# 328 "asllib/Parser.mly"
                                                                        e_binop               
# 7285 "asllib/Parser.ml"
         (e1, op, e2)
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_e2_, _startpos_e1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 7294 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_191 =
    fun _1 _endpos_e2_ _startpos_e1_ e1 e2 ->
      let desc =
        let op = 
# 247 "asllib/Parser.mly"
                  ( `RDIV   )
# 7303 "asllib/Parser.ml"
         in
        
# 328 "asllib/Parser.mly"
                                                                        e_binop               
# 7308 "asllib/Parser.ml"
         (e1, op, e2)
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_e2_, _startpos_e1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 7317 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_192 =
    fun _1 _endpos_e2_ _startpos_e1_ e1 e2 ->
      let desc =
        let op = 
# 248 "asllib/Parser.mly"
                  ( `SHL    )
# 7326 "asllib/Parser.ml"
         in
        
# 328 "asllib/Parser.mly"
                                                                        e_binop               
# 7331 "asllib/Parser.ml"
         (e1, op, e2)
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_e2_, _startpos_e1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 7340 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_193 =
    fun _1 _endpos_e2_ _startpos_e1_ e1 e2 ->
      let desc =
        let op = 
# 249 "asllib/Parser.mly"
                  ( `SHR    )
# 7349 "asllib/Parser.ml"
         in
        
# 328 "asllib/Parser.mly"
                                                                        e_binop               
# 7354 "asllib/Parser.ml"
         (e1, op, e2)
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_e2_, _startpos_e1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 7363 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_194 =
    fun _1 _endpos_e2_ _startpos_e1_ e1 e2 ->
      let desc =
        let op = 
# 250 "asllib/Parser.mly"
                  ( `POW    )
# 7372 "asllib/Parser.ml"
         in
        
# 328 "asllib/Parser.mly"
                                                                        e_binop               
# 7377 "asllib/Parser.ml"
         (e1, op, e2)
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_e2_, _startpos_e1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 7386 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_195 =
    fun _1 _endpos_e2_ _startpos_e1_ e1 e2 ->
      let desc =
        let op = 
# 251 "asllib/Parser.mly"
                  ( `BV_CONCAT  )
# 7395 "asllib/Parser.ml"
         in
        
# 328 "asllib/Parser.mly"
                                                                        e_binop               
# 7400 "asllib/Parser.ml"
         (e1, op, e2)
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_e2_, _startpos_e1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 7409 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_196 =
    fun _1 _endpos_e2_ _startpos_e1_ e1 e2 ->
      let desc =
        let op = 
# 252 "asllib/Parser.mly"
                  ( `STR_CONCAT )
# 7418 "asllib/Parser.ml"
         in
        
# 328 "asllib/Parser.mly"
                                                                        e_binop               
# 7423 "asllib/Parser.ml"
         (e1, op, e2)
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_e2_, _startpos_e1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 7432 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_197 =
    fun _1 _endpos_e_ _startpos__1_ e ->
      let desc =
        let op = 
# 223 "asllib/Parser.mly"
            ( BNOT )
# 7441 "asllib/Parser.ml"
         in
        
# 329 "asllib/Parser.mly"
                                                                    E_Unop                
# 7446 "asllib/Parser.ml"
         (op, e)
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_e_, _startpos__1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 7455 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_198 =
    fun _1 _endpos_e_ _startpos__1_ e ->
      let desc =
        let op = 
# 224 "asllib/Parser.mly"
            ( NEG )
# 7464 "asllib/Parser.ml"
         in
        
# 329 "asllib/Parser.mly"
                                                                    E_Unop                
# 7469 "asllib/Parser.ml"
         (op, e)
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_e_, _startpos__1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 7478 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_199 =
    fun _1 _endpos_e_ _startpos__1_ e ->
      let desc =
        let op = 
# 225 "asllib/Parser.mly"
            ( NOT )
# 7487 "asllib/Parser.ml"
         in
        
# 329 "asllib/Parser.mly"
                                                                    E_Unop                
# 7492 "asllib/Parser.ml"
         (op, e)
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_e_, _startpos__1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 7501 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_200 =
    fun _1 _3 _endpos_e_else_ _startpos__1_ e1 e2 e_else ->
      let desc = 
# 330 "asllib/Parser.mly"
                                                                    E_Cond                
# 7509 "asllib/Parser.ml"
       (e1, e2, e_else) in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_e_else_, _startpos__1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 7517 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_201 =
    fun _endpos_call_ _startpos_call_ call ->
      let desc = 
# 331 "asllib/Parser.mly"
                                                                    e_call                
# 7525 "asllib/Parser.ml"
       call in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_call_, _startpos_call_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 7533 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_202 =
    fun _endpos_slices_ _startpos_e_ e slices ->
      let desc = 
# 332 "asllib/Parser.mly"
                                                                        E_Slice               
# 7541 "asllib/Parser.ml"
       (e, slices) in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_slices_, _startpos_e_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 7549 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_203 =
    fun _2 _4 _endpos__4_ _startpos_e1_ e1 e2 ->
      let desc = 
# 333 "asllib/Parser.mly"
                                                                        E_GetArray            
# 7557 "asllib/Parser.ml"
       (e1, e2) in
      let (_endpos_desc_, _startpos_desc_) = (_endpos__4_, _startpos_e1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 7565 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_204 =
    fun _2 _endpos_x_ _startpos_e_ e x ->
      let desc = 
# 334 "asllib/Parser.mly"
                                                                        E_GetField            
# 7573 "asllib/Parser.ml"
       (e, x) in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_x_, _startpos_e_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 7581 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_205 =
    fun _2 _endpos__3_ _startpos_e_ e x ->
      let desc =
        let fs = 
# 205 "<standard.mly>"
    ( x )
# 7590 "asllib/Parser.ml"
         in
        
# 335 "asllib/Parser.mly"
                                                                        E_GetFields           
# 7595 "asllib/Parser.ml"
         (e, fs)
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos__3_, _startpos_e_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 7604 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_206 =
    fun _2 _endpos_ty_ _startpos_expr_pattern_ expr_pattern ty ->
      let desc = 
# 337 "asllib/Parser.mly"
                                                                        E_ATC                 
# 7612 "asllib/Parser.ml"
       (expr_pattern, ty) in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_ty_, _startpos_expr_pattern_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 7620 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_207 =
    fun _2 _endpos_constraint_kind_ _startpos_constraint_kind_ _startpos_expr_pattern_ constraint_kind expr_pattern ->
      let desc =
        let implicit_t_int =
          let desc = 
# 444 "asllib/Parser.mly"
                                                       T_Int 
# 7630 "asllib/Parser.ml"
           constraint_kind in
          let (_endpos_desc_, _startpos_desc_) = (_endpos_constraint_kind_, _startpos_constraint_kind_) in
          let _endpos = _endpos_desc_ in
          let _symbolstartpos = _startpos_desc_ in
          
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 7638 "asllib/Parser.ml"
          
        in
        
# 338 "asllib/Parser.mly"
                                                                        E_ATC                 
# 7644 "asllib/Parser.ml"
         (expr_pattern, implicit_t_int)
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_constraint_kind_, _startpos_expr_pattern_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 7653 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_208 =
    fun _2 _endpos_pattern_set_ _startpos_expr_pattern_ expr_pattern pattern_set ->
      let desc = 
# 340 "asllib/Parser.mly"
                                                                        E_Pattern             
# 7661 "asllib/Parser.ml"
       (expr_pattern, pattern_set) in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_pattern_set_, _startpos_expr_pattern_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 7669 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_209 =
    fun _1 _2 _endpos__1_ _startpos__1_ _startpos_expr_pattern_ expr_pattern ->
      let desc =
        let pattern_mask =
          let desc =
            let _1_1 = _1 in
            
# 352 "asllib/Parser.mly"
                                            Pattern_Mask  
# 7681 "asllib/Parser.ml"
             _1_1
          in
          let (_endpos_desc_, _startpos_desc_) = (_endpos__1_, _startpos__1_) in
          let _endpos = _endpos_desc_ in
          let _symbolstartpos = _startpos_desc_ in
          
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 7690 "asllib/Parser.ml"
          
        in
        
# 341 "asllib/Parser.mly"
                                                                        E_Pattern             
# 7696 "asllib/Parser.ml"
         (expr_pattern, pattern_mask)
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos__1_, _startpos_expr_pattern_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 7705 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_210 =
    fun _1 _2 _endpos__1_ _startpos__1_ _startpos_e_ e ->
      let desc =
        let p =
          let desc =
            let _1_1 = _1 in
            
# 352 "asllib/Parser.mly"
                                            Pattern_Mask  
# 7717 "asllib/Parser.ml"
             _1_1
          in
          let (_endpos_desc_, _startpos_desc_) = (_endpos__1_, _startpos__1_) in
          let _endpos = _endpos_desc_ in
          let _symbolstartpos = _startpos_desc_ in
          
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 7726 "asllib/Parser.ml"
          
        in
        
# 342 "asllib/Parser.mly"
                                                                      ( E_Pattern (e, Pattern_Not (p) |> add_pos_from p) )
# 7732 "asllib/Parser.ml"
        
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos__1_, _startpos_e_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 7741 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_211 =
    fun _1 _2 _endpos_ty_ _startpos__1_ ty ->
      let desc = 
# 344 "asllib/Parser.mly"
                                                                        E_Arbitrary         
# 7749 "asllib/Parser.ml"
       ty in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_ty_, _startpos__1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 7757 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_212 =
    fun _endpos__3_ _startpos__1_ x ->
      let desc =
        let e = 
# 205 "<standard.mly>"
    ( x )
# 7766 "asllib/Parser.ml"
         in
        
# 345 "asllib/Parser.mly"
                                                                      ( E_Tuple [ e ]        )
# 7771 "asllib/Parser.ml"
        
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos__3_, _startpos__1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 7780 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_213 =
    fun _2 _3 _4 _endpos__4_ _endpos_desc_ _startpos_desc_ desc ->
      let desc =
        let t =
          let _endpos = _endpos_desc_ in
          let _symbolstartpos = _startpos_desc_ in
          
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 7792 "asllib/Parser.ml"
          
        in
        
# 347 "asllib/Parser.mly"
        ( E_Record (add_pos_from t (T_Named t.desc), []) )
# 7798 "asllib/Parser.ml"
        
      in
      let _endpos_desc_ = _endpos__4_ in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 7807 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_214 =
    fun _endpos__3_ _endpos_desc_ _startpos_desc_ desc x ->
      let desc =
        let fields = 
# 205 "<standard.mly>"
    ( x )
# 7816 "asllib/Parser.ml"
         in
        let t =
          let _endpos = _endpos_desc_ in
          let _symbolstartpos = _startpos_desc_ in
          
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 7824 "asllib/Parser.ml"
          
        in
        
# 349 "asllib/Parser.mly"
        ( E_Record (add_pos_from t (T_Named t.desc), fields) )
# 7830 "asllib/Parser.ml"
        
      in
      let _endpos_desc_ = _endpos__3_ in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 7839 "asllib/Parser.ml"
       : (AST.expr))
  
  let _menhir_action_215 =
    fun x y ->
      (
# 180 "<standard.mly>"
    ( (x, y) )
# 7847 "asllib/Parser.ml"
       : (string * AST.expr))
  
  let _menhir_action_216 =
    fun x ->
      let _1 = 
# 205 "<standard.mly>"
    ( x )
# 7855 "asllib/Parser.ml"
       in
      (
# 374 "asllib/Parser.mly"
                   ( [] )
# 7860 "asllib/Parser.ml"
       : (AST.field list))
  
  let _menhir_action_217 =
    fun x ->
      (
# 205 "<standard.mly>"
    ( x )
# 7868 "asllib/Parser.ml"
       : (AST.field list))
  
  let _menhir_action_218 =
    fun x ->
      (
# 205 "<standard.mly>"
    ( x )
# 7876 "asllib/Parser.ml"
       : (AST.typed_identifier list))
  
  let _menhir_action_219 =
    fun _1 _endpos__1_ _startpos__1_ ->
      let _endpos = _endpos__1_ in
      let _startpos = _startpos__1_ in
      (
# 630 "asllib/Parser.mly"
                            (
      Error.fatal_here _startpos _endpos @@
        Error.CannotParse (Some "A global declaration must declare a name.")
    )
# 7889 "asllib/Parser.ml"
       : (string))
  
  let _menhir_action_220 =
    fun _1 ->
      (_1 : (string))
  
  let _menhir_action_221 =
    fun expr ->
      (
# 318 "asllib/Parser.mly"
                                  Constraint_Exact  
# 7901 "asllib/Parser.ml"
       expr : (AST.int_constraint))
  
  let _menhir_action_222 =
    fun _2 e1 e2 ->
      (
# 319 "asllib/Parser.mly"
                                  Constraint_Range  
# 7909 "asllib/Parser.ml"
       (e1, e2) : (AST.int_constraint))
  
  let _menhir_action_223 =
    fun () ->
      (
# 648 "asllib/Parser.mly"
              ( false )
# 7917 "asllib/Parser.ml"
       : (bool))
  
  let _menhir_action_224 =
    fun _1 ->
      (
# 649 "asllib/Parser.mly"
              ( true )
# 7925 "asllib/Parser.ml"
       : (bool))
  
  let _menhir_action_225 =
    fun basic_lexpr ->
      (
# 474 "asllib/Parser.mly"
                     desugar_lhs_access  
# 7933 "asllib/Parser.ml"
       basic_lexpr : (AST.lexpr))
  
  let _menhir_action_226 =
    fun _endpos__3_ _startpos__1_ x ->
      let _1 =
        let desc = 
# 205 "<standard.mly>"
    ( x )
# 7942 "asllib/Parser.ml"
         in
        let (_endpos_desc_, _startpos_desc_) = (_endpos__3_, _startpos__1_) in
        let _endpos = _endpos_desc_ in
        let _symbolstartpos = _startpos_desc_ in
        
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 7950 "asllib/Parser.ml"
        
      in
      let _1_1 = _1 in
      (
# 475 "asllib/Parser.mly"
                                                   desugar_lhs_tuple  
# 7957 "asllib/Parser.ml"
       _1_1 : (AST.lexpr))
  
  let _menhir_action_227 =
    fun _1 _endpos__1_ _startpos__1_ ->
      let desc = 
# 477 "asllib/Parser.mly"
             ( LE_Discard )
# 7965 "asllib/Parser.ml"
       in
      let (_endpos_desc_, _startpos_desc_) = (_endpos__1_, _startpos__1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 7973 "asllib/Parser.ml"
       : (AST.lexpr))
  
  let _menhir_action_228 =
    fun _2 _endpos__3_ _endpos_desc_ _startpos_desc_ desc x ->
      let desc =
        let flds = 
# 205 "<standard.mly>"
    ( x )
# 7982 "asllib/Parser.ml"
         in
        let x =
          let _endpos = _endpos_desc_ in
          let _symbolstartpos = _startpos_desc_ in
          
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 7990 "asllib/Parser.ml"
          
        in
        
# 479 "asllib/Parser.mly"
      ( LE_SetFields (le_var x, flds, []) )
# 7996 "asllib/Parser.ml"
        
      in
      let _endpos_desc_ = _endpos__3_ in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 8005 "asllib/Parser.ml"
       : (AST.lexpr))
  
  let _menhir_action_229 =
    fun _2 _endpos__3_ _endpos_desc_ _startpos_desc_ desc x ->
      let desc =
        let flds = 
# 205 "<standard.mly>"
    ( x )
# 8014 "asllib/Parser.ml"
         in
        let x =
          let _endpos = _endpos_desc_ in
          let _symbolstartpos = _startpos_desc_ in
          
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 8022 "asllib/Parser.ml"
          
        in
        
# 481 "asllib/Parser.mly"
      ( desugar_lhs_fields_tuple x flds )
# 8028 "asllib/Parser.ml"
        
      in
      let _endpos_desc_ = _endpos__3_ in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 8037 "asllib/Parser.ml"
       : (AST.lexpr))
  
  let _menhir_action_230 =
    fun () ->
      (
# 216 "<standard.mly>"
    ( [] )
# 8045 "asllib/Parser.ml"
       : (AST.decl list list))
  
  let _menhir_action_231 =
    fun x xs ->
      (
# 219 "<standard.mly>"
    ( x :: xs )
# 8053 "asllib/Parser.ml"
       : (AST.decl list list))
  
  let _menhir_action_232 =
    fun x ->
      (
# 203 "asllib/Parser.mly"
         ( [ x ] )
# 8061 "asllib/Parser.ml"
       : (AST.case_alt_desc AST.annotated list))
  
  let _menhir_action_233 =
    fun l x ->
      (
# 204 "asllib/Parser.mly"
                     ( x :: l )
# 8069 "asllib/Parser.ml"
       : (AST.case_alt_desc AST.annotated list))
  
  let _menhir_action_234 =
    fun x ->
      (
# 203 "asllib/Parser.mly"
         ( [ x ] )
# 8077 "asllib/Parser.ml"
       : (AST.catcher list))
  
  let _menhir_action_235 =
    fun l x ->
      (
# 204 "asllib/Parser.mly"
                     ( x :: l )
# 8085 "asllib/Parser.ml"
       : (AST.catcher list))
  
  let _menhir_action_236 =
    fun x ->
      (
# 203 "asllib/Parser.mly"
         ( [ x ] )
# 8093 "asllib/Parser.ml"
       : (AST.stmt list))
  
  let _menhir_action_237 =
    fun l x ->
      (
# 204 "asllib/Parser.mly"
                     ( x :: l )
# 8101 "asllib/Parser.ml"
       : (AST.stmt list))
  
  let _menhir_action_238 =
    fun () ->
      (
# 123 "<standard.mly>"
    ( None )
# 8109 "asllib/Parser.ml"
       : (AST.expr option))
  
  let _menhir_action_239 =
    fun _1 _2 ->
      let x = _2 in
      (
# 126 "<standard.mly>"
    ( Some x )
# 8118 "asllib/Parser.ml"
       : (AST.expr option))
  
  let _menhir_action_240 =
    fun _2 body ->
      (
# 740 "asllib/Parser.mly"
    (
      [
        D_Func
          {
            name = "main";
            args = [];
            parameters = [];
            body = SB_ASL body;
            return_type =
              Some (T_Int UnConstrained |> add_dummy_annotation ~version);
            subprogram_type = ST_Function;
            recurse_limit = None;
            qualifier = None;
            override = None;
            builtin = false;
          }
        |> ASTUtils.add_pos_from body
      ]
    )
# 8144 "asllib/Parser.ml"
       : (AST.t))
  
  let _menhir_action_241 =
    fun x ->
      let y = 
# 123 "<standard.mly>"
    ( None )
# 8152 "asllib/Parser.ml"
       in
      (
# 172 "<standard.mly>"
    ( (x, y) )
# 8157 "asllib/Parser.ml"
       : (string * AST.ty option))
  
  let _menhir_action_242 =
    fun x x_inlined1 ->
      let y =
        let x = x_inlined1 in
        
# 126 "<standard.mly>"
    ( Some x )
# 8167 "asllib/Parser.ml"
        
      in
      (
# 172 "<standard.mly>"
    ( (x, y) )
# 8173 "asllib/Parser.ml"
       : (string * AST.ty option))
  
  let _menhir_action_243 =
    fun () ->
      (
# 111 "<standard.mly>"
    ( None )
# 8181 "asllib/Parser.ml"
       : (AST.expr option))
  
  let _menhir_action_244 =
    fun x ->
      (
# 114 "<standard.mly>"
    ( Some x )
# 8189 "asllib/Parser.ml"
       : (AST.expr option))
  
  let _menhir_action_245 =
    fun () ->
      (
# 123 "<standard.mly>"
    ( None )
# 8197 "asllib/Parser.ml"
       : (AST.stmt option))
  
  let _menhir_action_246 =
    fun _1 _2 _3 ->
      let x = _3 in
      (
# 126 "<standard.mly>"
    ( Some x )
# 8206 "asllib/Parser.ml"
       : (AST.stmt option))
  
  let _menhir_action_247 =
    fun () ->
      (
# 613 "asllib/Parser.mly"
                  ( [] )
# 8214 "asllib/Parser.ml"
       : ((string * AST.ty option) list))
  
  let _menhir_action_248 =
    fun x ->
      (
# 205 "<standard.mly>"
    ( x )
# 8222 "asllib/Parser.ml"
       : ((string * AST.ty option) list))
  
  let _menhir_action_249 =
    fun _endpos_expr_pattern_ _startpos_expr_pattern_ expr_pattern ->
      let desc = 
# 357 "asllib/Parser.mly"
                        Pattern_Single  
# 8230 "asllib/Parser.ml"
       expr_pattern in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_expr_pattern_, _startpos_expr_pattern_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 8238 "asllib/Parser.ml"
       : (AST.pattern))
  
  let _menhir_action_250 =
    fun _2 _endpos_e2_ _startpos_e1_ e1 e2 ->
      let desc = 
# 358 "asllib/Parser.mly"
                                           Pattern_Range  
# 8246 "asllib/Parser.ml"
       (e1, e2) in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_e2_, _startpos_e1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 8254 "asllib/Parser.ml"
       : (AST.pattern))
  
  let _menhir_action_251 =
    fun _1 _endpos__1_ _startpos__1_ ->
      let desc = 
# 359 "asllib/Parser.mly"
             ( Pattern_All )
# 8262 "asllib/Parser.ml"
       in
      let (_endpos_desc_, _startpos_desc_) = (_endpos__1_, _startpos__1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 8270 "asllib/Parser.ml"
       : (AST.pattern))
  
  let _menhir_action_252 =
    fun _1 _endpos_expr_ _startpos__1_ expr ->
      let desc = 
# 360 "asllib/Parser.mly"
                    Pattern_Leq  
# 8278 "asllib/Parser.ml"
       expr in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_expr_, _startpos__1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 8286 "asllib/Parser.ml"
       : (AST.pattern))
  
  let _menhir_action_253 =
    fun _1 _endpos_expr_ _startpos__1_ expr ->
      let desc = 
# 361 "asllib/Parser.mly"
                    Pattern_Geq  
# 8294 "asllib/Parser.ml"
       expr in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_expr_, _startpos__1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 8302 "asllib/Parser.ml"
       : (AST.pattern))
  
  let _menhir_action_254 =
    fun _endpos__3_ _startpos__1_ x ->
      let desc =
        let _1 = 
# 205 "<standard.mly>"
    ( x )
# 8311 "asllib/Parser.ml"
         in
        let _1_1 = _1 in
        
# 362 "asllib/Parser.mly"
                           Pattern_Tuple  
# 8317 "asllib/Parser.ml"
         _1_1
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos__3_, _startpos__1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 8326 "asllib/Parser.ml"
       : (AST.pattern))
  
  let _menhir_action_255 =
    fun _1 _endpos__1_ _startpos__1_ ->
      let desc =
        let _1_1 = _1 in
        
# 352 "asllib/Parser.mly"
                                            Pattern_Mask  
# 8336 "asllib/Parser.ml"
         _1_1
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos__1_, _startpos__1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 8345 "asllib/Parser.ml"
       : (AST.pattern))
  
  let _menhir_action_256 =
    fun _1 ->
      (_1 : (AST.pattern))
  
  let _menhir_action_257 =
    fun _1 _endpos__1_ _startpos__1_ ->
      let desc =
        let _1_1 = _1 in
        
# 353 "asllib/Parser.mly"
                                                   Pattern_Any  
# 8359 "asllib/Parser.ml"
         _1_1
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos__1_, _startpos__1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 8368 "asllib/Parser.ml"
       : (AST.pattern))
  
  let _menhir_action_258 =
    fun x ->
      (
# 205 "<standard.mly>"
    ( x )
# 8376 "asllib/Parser.ml"
       : (AST.pattern))
  
  let _menhir_action_259 =
    fun _1 _endpos__3_ _startpos__1_ x ->
      let desc =
        let _2 = 
# 205 "<standard.mly>"
    ( x )
# 8385 "asllib/Parser.ml"
         in
        let _2_1 = _2 in
        
# 370 "asllib/Parser.mly"
                                      Pattern_Not  
# 8391 "asllib/Parser.ml"
         _2_1
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos__3_, _startpos__1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 8400 "asllib/Parser.ml"
       : (AST.pattern))
  
  let _menhir_action_260 =
    fun () ->
      (
# 123 "<standard.mly>"
    ( None )
# 8408 "asllib/Parser.ml"
       : (AST.expr option))
  
  let _menhir_action_261 =
    fun _1 _2 ->
      let x = _2 in
      (
# 126 "<standard.mly>"
    ( Some x )
# 8417 "asllib/Parser.ml"
       : (AST.expr option))
  
  let _menhir_action_262 =
    fun _1 _2 ->
      (_2 : (AST.ty))
  
  let _menhir_action_263 =
    fun _1 _3 _endpos_s2_ _startpos__1_ e s1 s2 ->
      let desc = 
# 595 "asllib/Parser.mly"
                                                     S_Cond 
# 8429 "asllib/Parser.ml"
       (e, s1, s2) in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_s2_, _startpos__1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = if _startpos_desc_ != _endpos_desc_ then
        _startpos_desc_
      else
        _endpos in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 8440 "asllib/Parser.ml"
       : (AST.stmt))
  
  let _menhir_action_264 =
    fun _endpos__0_ ->
      let desc = 
# 525 "asllib/Parser.mly"
            ( S_Pass )
# 8448 "asllib/Parser.ml"
       in
      let (_endpos_desc_, _startpos_desc_) = (_endpos__0_, _endpos__0_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = if _startpos_desc_ != _endpos_desc_ then
        _startpos_desc_
      else
        _endpos in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 8459 "asllib/Parser.ml"
       : (AST.stmt))
  
  let _menhir_action_265 =
    fun _1 _2 ->
      (_2 : (AST.stmt))
  
  let _menhir_action_266 =
    fun () ->
      (
# 547 "asllib/Parser.mly"
    ( [] )
# 8471 "asllib/Parser.ml"
       : (Desugar.field_or_array_access list))
  
  let _menhir_action_267 =
    fun _1 _endpos_desc_ _startpos_desc_ desc t ->
      let h =
        let _endpos = _endpos_desc_ in
        let _symbolstartpos = _startpos_desc_ in
        
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 8482 "asllib/Parser.ml"
        
      in
      (
# 548 "asllib/Parser.mly"
                                                   ( FieldAccess h :: t )
# 8488 "asllib/Parser.ml"
       : (Desugar.field_or_array_access list))
  
  let _menhir_action_268 =
    fun expr ->
      (
# 380 "asllib/Parser.mly"
                                    Slice_Single   
# 8496 "asllib/Parser.ml"
       expr : (AST.slice))
  
  let _menhir_action_269 =
    fun _2 e1 e2 ->
      (
# 381 "asllib/Parser.mly"
                                    Slice_Range    
# 8504 "asllib/Parser.ml"
       (e1, e2) : (AST.slice))
  
  let _menhir_action_270 =
    fun _2 e1 e2 ->
      (
# 382 "asllib/Parser.mly"
                                    Slice_Length   
# 8512 "asllib/Parser.ml"
       (e1, e2) : (AST.slice))
  
  let _menhir_action_271 =
    fun _endpos_desc_ _startpos_desc_ desc e ->
      let loc =
        let _endpos = _endpos_desc_ in
        let _symbolstartpos = _startpos_desc_ in
        
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 8523 "asllib/Parser.ml"
        
      in
      (
# 383 "asllib/Parser.mly"
                                  ( Slice_Length(zero ~loc, e) )
# 8529 "asllib/Parser.ml"
       : (AST.slice))
  
  let _menhir_action_272 =
    fun _2 e1 e2 ->
      (
# 384 "asllib/Parser.mly"
                                    Slice_Star     
# 8537 "asllib/Parser.ml"
       (e1, e2) : (AST.slice))
  
  let _menhir_action_273 =
    fun x ->
      (
# 205 "<standard.mly>"
    ( x )
# 8545 "asllib/Parser.ml"
       : (AST.slice list))
  
  let _menhir_action_274 =
    fun x ->
      let _1 = 
# 196 "<standard.mly>"
    ( x )
# 8553 "asllib/Parser.ml"
       in
      let _1_1 = _1 in
      (
# 736 "asllib/Parser.mly"
                                             List.concat  
# 8559 "asllib/Parser.ml"
       _1_1 : (AST.t))
  
  let _menhir_action_275 =
    fun _1 _1_inlined1 _2 _3 _endpos__2_ _startpos__1_ e s1 s2 ->
      let desc =
        let _2 =
          let _1 = _1_inlined1 in
          ()
        in
        let x = 
# 553 "asllib/Parser.mly"
                                                       S_Cond 
# 8572 "asllib/Parser.ml"
         (e, s1, s2) in
        
# 196 "<standard.mly>"
    ( x )
# 8577 "asllib/Parser.ml"
        
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos__2_, _startpos__1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 8586 "asllib/Parser.ml"
       : (AST.stmt_desc AST.annotated))
  
  let _menhir_action_276 =
    fun _1 _1_inlined1 _1_inlined2 _2 _3 _endpos__2_ _startpos__1_ expr ->
      let desc =
        let _2 =
          let _1 = _1_inlined2 in
          ()
        in
        let x =
          let alt = _1_inlined1 in
          
# 555 "asllib/Parser.mly"
          ( desugar_case_stmt expr alt (S_Unreachable |> ASTUtils.add_pos_from expr))
# 8601 "asllib/Parser.ml"
          
        in
        
# 196 "<standard.mly>"
    ( x )
# 8607 "asllib/Parser.ml"
        
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos__2_, _startpos__1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 8616 "asllib/Parser.ml"
       : (AST.stmt_desc AST.annotated))
  
  let _menhir_action_277 =
    fun _1 _1_inlined1 _1_inlined2 _1_inlined3 _2 _2_inlined1 _3 _endpos__2_ _startpos__1_ expr otherwise_stmt ->
      let desc =
        let _2 =
          let _1 = _1_inlined3 in
          ()
        in
        let x =
          let _2 = _2_inlined1 in
          let case_otherwise =
            let _1 = _1_inlined2 in
            
# 537 "asllib/Parser.mly"
      ( otherwise_stmt )
# 8633 "asllib/Parser.ml"
            
          in
          let alt = _1_inlined1 in
          
# 557 "asllib/Parser.mly"
          ( desugar_case_stmt expr alt case_otherwise )
# 8640 "asllib/Parser.ml"
          
        in
        
# 196 "<standard.mly>"
    ( x )
# 8646 "asllib/Parser.ml"
        
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos__2_, _startpos__1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 8655 "asllib/Parser.ml"
       : (AST.stmt_desc AST.annotated))
  
  let _menhir_action_278 =
    fun _1 _1_inlined1 _2 _4 _endpos__2_ _startpos__1_ expr loop_limit stmt_list ->
      let desc =
        let _2 =
          let _1 = _1_inlined1 in
          ()
        in
        let x = 
# 558 "asllib/Parser.mly"
                                                       S_While 
# 8668 "asllib/Parser.ml"
         (expr, loop_limit, stmt_list) in
        
# 196 "<standard.mly>"
    ( x )
# 8673 "asllib/Parser.ml"
        
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos__2_, _startpos__1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 8682 "asllib/Parser.ml"
       : (AST.stmt_desc AST.annotated))
  
  let _menhir_action_279 =
    fun _1 _1_inlined1 _2 _3 _8 _endpos__2_ _startpos__1_ body dir end_e index_name limit start_e ->
      let desc =
        let _2 =
          let _1 = _1_inlined1 in
          ()
        in
        let x = 
# 561 "asllib/Parser.mly"
          ( S_For { index_name; start_e; end_e; dir; body; limit } )
# 8695 "asllib/Parser.ml"
         in
        
# 196 "<standard.mly>"
    ( x )
# 8700 "asllib/Parser.ml"
        
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos__2_, _startpos__1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 8709 "asllib/Parser.ml"
       : (AST.stmt_desc AST.annotated))
  
  let _menhir_action_280 =
    fun _1 _1_inlined1 _2 _3 _endpos__2_ _startpos__1_ c o s ->
      let desc =
        let _2 =
          let _1 = _1_inlined1 in
          ()
        in
        let x = 
# 562 "asllib/Parser.mly"
                                                                      S_Try  
# 8722 "asllib/Parser.ml"
         (s, c, o) in
        
# 196 "<standard.mly>"
    ( x )
# 8727 "asllib/Parser.ml"
        
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos__2_, _startpos__1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 8736 "asllib/Parser.ml"
       : (AST.stmt_desc AST.annotated))
  
  let _menhir_action_281 =
    fun _1 _endpos__2_ _startpos__1_ ->
      let desc =
        let x = 
# 525 "asllib/Parser.mly"
            ( S_Pass )
# 8745 "asllib/Parser.ml"
         in
        
# 196 "<standard.mly>"
    ( x )
# 8750 "asllib/Parser.ml"
        
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos__2_, _startpos__1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 8759 "asllib/Parser.ml"
       : (AST.stmt_desc AST.annotated))
  
  let _menhir_action_282 =
    fun _1 _2_inlined1 _endpos__2_ _startpos__1_ ->
      let desc =
        let x =
          let _2 = _2_inlined1 in
          let _2_1 = _2 in
          
# 566 "asllib/Parser.mly"
                                                              S_Return  
# 8771 "asllib/Parser.ml"
           _2_1
        in
        
# 196 "<standard.mly>"
    ( x )
# 8777 "asllib/Parser.ml"
        
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos__2_, _startpos__1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 8786 "asllib/Parser.ml"
       : (AST.stmt_desc AST.annotated))
  
  let _menhir_action_283 =
    fun _endpos__2_ _startpos_call_ call ->
      let desc =
        let x = 
# 567 "asllib/Parser.mly"
                                                               s_call  
# 8795 "asllib/Parser.ml"
         call in
        
# 196 "<standard.mly>"
    ( x )
# 8800 "asllib/Parser.ml"
        
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos__2_, _startpos_call_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 8809 "asllib/Parser.ml"
       : (AST.stmt_desc AST.annotated))
  
  let _menhir_action_284 =
    fun _1 _endpos__2_ _startpos__1_ e ->
      let desc =
        let x = 
# 568 "asllib/Parser.mly"
                                                               S_Assert  
# 8818 "asllib/Parser.ml"
         e in
        
# 196 "<standard.mly>"
    ( x )
# 8823 "asllib/Parser.ml"
        
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos__2_, _startpos__1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 8832 "asllib/Parser.ml"
       : (AST.stmt_desc AST.annotated))
  
  let _menhir_action_285 =
    fun _1 _4 _endpos__2_ _startpos__1_ decl_item x ->
      let desc =
        let x =
          let _5 = 
# 164 "asllib/Parser.mly"
                        Some 
# 8842 "asllib/Parser.ml"
           x in
          let ty_opt = 
# 123 "<standard.mly>"
    ( None )
# 8847 "asllib/Parser.ml"
           in
          let local_decl_keyword = 
# 509 "asllib/Parser.mly"
                ( LDK_Let       )
# 8852 "asllib/Parser.ml"
           in
          let _5_1 = _5 in
          
# 569 "asllib/Parser.mly"
                                                                         S_Decl    
# 8858 "asllib/Parser.ml"
           (local_decl_keyword, decl_item, ty_opt, _5_1)
        in
        
# 196 "<standard.mly>"
    ( x )
# 8864 "asllib/Parser.ml"
        
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos__2_, _startpos__1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 8873 "asllib/Parser.ml"
       : (AST.stmt_desc AST.annotated))
  
  let _menhir_action_286 =
    fun _1 _4 _endpos__2_ _startpos__1_ decl_item x x_inlined1 ->
      let desc =
        let x =
          let _5 =
            let x = x_inlined1 in
            
# 164 "asllib/Parser.mly"
                        Some 
# 8885 "asllib/Parser.ml"
             x
          in
          let ty_opt = 
# 126 "<standard.mly>"
    ( Some x )
# 8891 "asllib/Parser.ml"
           in
          let local_decl_keyword = 
# 509 "asllib/Parser.mly"
                ( LDK_Let       )
# 8896 "asllib/Parser.ml"
           in
          let _5_1 = _5 in
          
# 569 "asllib/Parser.mly"
                                                                         S_Decl    
# 8902 "asllib/Parser.ml"
           (local_decl_keyword, decl_item, ty_opt, _5_1)
        in
        
# 196 "<standard.mly>"
    ( x )
# 8908 "asllib/Parser.ml"
        
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos__2_, _startpos__1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 8917 "asllib/Parser.ml"
       : (AST.stmt_desc AST.annotated))
  
  let _menhir_action_287 =
    fun _1 _4 _endpos__1_ _endpos__2_ _startpos__1_ decl_item x ->
      let desc =
        let x =
          let _5 = 
# 164 "asllib/Parser.mly"
                        Some 
# 8927 "asllib/Parser.ml"
           x in
          let ty_opt = 
# 123 "<standard.mly>"
    ( None )
# 8932 "asllib/Parser.ml"
           in
          let local_decl_keyword =
            let _endpos = _endpos__1_ in
            let _startpos = _startpos__1_ in
            
# 510 "asllib/Parser.mly"
                               (
      Error.fatal_here _startpos _endpos @@
        Error.CannotParse (Some "Local constant declarations are not valid ASL1. Did you mean `let`?.")
  )
# 8943 "asllib/Parser.ml"
            
          in
          let _5_1 = _5 in
          
# 569 "asllib/Parser.mly"
                                                                         S_Decl    
# 8950 "asllib/Parser.ml"
           (local_decl_keyword, decl_item, ty_opt, _5_1)
        in
        
# 196 "<standard.mly>"
    ( x )
# 8956 "asllib/Parser.ml"
        
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos__2_, _startpos__1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 8965 "asllib/Parser.ml"
       : (AST.stmt_desc AST.annotated))
  
  let _menhir_action_288 =
    fun _1 _4 _endpos__1_ _endpos__2_ _startpos__1_ decl_item x x_inlined1 ->
      let desc =
        let x =
          let _5 =
            let x = x_inlined1 in
            
# 164 "asllib/Parser.mly"
                        Some 
# 8977 "asllib/Parser.ml"
             x
          in
          let ty_opt = 
# 126 "<standard.mly>"
    ( Some x )
# 8983 "asllib/Parser.ml"
           in
          let local_decl_keyword =
            let _endpos = _endpos__1_ in
            let _startpos = _startpos__1_ in
            
# 510 "asllib/Parser.mly"
                               (
      Error.fatal_here _startpos _endpos @@
        Error.CannotParse (Some "Local constant declarations are not valid ASL1. Did you mean `let`?.")
  )
# 8994 "asllib/Parser.ml"
            
          in
          let _5_1 = _5 in
          
# 569 "asllib/Parser.mly"
                                                                         S_Decl    
# 9001 "asllib/Parser.ml"
           (local_decl_keyword, decl_item, ty_opt, _5_1)
        in
        
# 196 "<standard.mly>"
    ( x )
# 9007 "asllib/Parser.ml"
        
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos__2_, _startpos__1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 9016 "asllib/Parser.ml"
       : (AST.stmt_desc AST.annotated))
  
  let _menhir_action_289 =
    fun _1 _4 _endpos__2_ _startpos__1_ decl_item x ->
      let desc =
        let x =
          let _5 = 
# 164 "asllib/Parser.mly"
                        Some 
# 9026 "asllib/Parser.ml"
           x in
          let ty_opt = 
# 123 "<standard.mly>"
    ( None )
# 9031 "asllib/Parser.ml"
           in
          let local_decl_keyword = 
# 514 "asllib/Parser.mly"
                ( LDK_Var       )
# 9036 "asllib/Parser.ml"
           in
          let _5_1 = _5 in
          
# 569 "asllib/Parser.mly"
                                                                         S_Decl    
# 9042 "asllib/Parser.ml"
           (local_decl_keyword, decl_item, ty_opt, _5_1)
        in
        
# 196 "<standard.mly>"
    ( x )
# 9048 "asllib/Parser.ml"
        
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos__2_, _startpos__1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 9057 "asllib/Parser.ml"
       : (AST.stmt_desc AST.annotated))
  
  let _menhir_action_290 =
    fun _1 _4 _endpos__2_ _startpos__1_ decl_item x x_inlined1 ->
      let desc =
        let x =
          let _5 =
            let x = x_inlined1 in
            
# 164 "asllib/Parser.mly"
                        Some 
# 9069 "asllib/Parser.ml"
             x
          in
          let ty_opt = 
# 126 "<standard.mly>"
    ( Some x )
# 9075 "asllib/Parser.ml"
           in
          let local_decl_keyword = 
# 514 "asllib/Parser.mly"
                ( LDK_Var       )
# 9080 "asllib/Parser.ml"
           in
          let _5_1 = _5 in
          
# 569 "asllib/Parser.mly"
                                                                         S_Decl    
# 9086 "asllib/Parser.ml"
           (local_decl_keyword, decl_item, ty_opt, _5_1)
        in
        
# 196 "<standard.mly>"
    ( x )
# 9092 "asllib/Parser.ml"
        
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos__2_, _startpos__1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 9101 "asllib/Parser.ml"
       : (AST.stmt_desc AST.annotated))
  
  let _menhir_action_291 =
    fun _2_inlined1 _endpos__2_ _startpos_le_ e le ->
      let desc =
        let x =
          let _2 = _2_inlined1 in
          
# 570 "asllib/Parser.mly"
                                                               S_Assign  
# 9112 "asllib/Parser.ml"
           (le, e)
        in
        
# 196 "<standard.mly>"
    ( x )
# 9118 "asllib/Parser.ml"
        
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos__2_, _startpos_le_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 9127 "asllib/Parser.ml"
       : (AST.stmt_desc AST.annotated))
  
  let _menhir_action_292 =
    fun _3 _endpos__2_ _endpos_desc_ _startpos_desc_ desc rhs setter_access ->
      let desc =
        let x =
          let call =
            let _endpos = _endpos_desc_ in
            let _symbolstartpos = _startpos_desc_ in
            
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 9140 "asllib/Parser.ml"
            
          in
          
# 572 "asllib/Parser.mly"
        ( desugar_setter call { access=setter_access; slices=add_dummy_annotation ~version [] } rhs )
# 9146 "asllib/Parser.ml"
          
        in
        
# 196 "<standard.mly>"
    ( x )
# 9152 "asllib/Parser.ml"
        
      in
      let _endpos_desc_ = _endpos__2_ in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 9161 "asllib/Parser.ml"
       : (AST.stmt_desc AST.annotated))
  
  let _menhir_action_293 =
    fun _4 _endpos__2_ _endpos_desc_ _endpos_desc_inlined1_ _startpos_desc_ _startpos_desc_inlined1_ desc desc_inlined1 rhs setter_access ->
      let desc =
        let x =
          let slices =
            let (_endpos_desc_, _startpos_desc_, desc) = (_endpos_desc_inlined1_, _startpos_desc_inlined1_, desc_inlined1) in
            let _endpos = _endpos_desc_ in
            let _symbolstartpos = _startpos_desc_ in
            
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 9175 "asllib/Parser.ml"
            
          in
          let call =
            let _endpos = _endpos_desc_ in
            let _symbolstartpos = _startpos_desc_ in
            
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 9184 "asllib/Parser.ml"
            
          in
          
# 574 "asllib/Parser.mly"
        ( desugar_setter call { access=setter_access; slices } rhs )
# 9190 "asllib/Parser.ml"
          
        in
        
# 196 "<standard.mly>"
    ( x )
# 9196 "asllib/Parser.ml"
        
      in
      let _endpos_desc_ = _endpos__2_ in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 9205 "asllib/Parser.ml"
       : (AST.stmt_desc AST.annotated))
  
  let _menhir_action_294 =
    fun _2_inlined1 _4 _endpos__2_ _endpos_desc_ _startpos_desc_ desc rhs x ->
      let desc =
        let x =
          let _2 = _2_inlined1 in
          let flds = 
# 205 "<standard.mly>"
    ( x )
# 9216 "asllib/Parser.ml"
           in
          let call =
            let _endpos = _endpos_desc_ in
            let _symbolstartpos = _startpos_desc_ in
            
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 9224 "asllib/Parser.ml"
            
          in
          
# 576 "asllib/Parser.mly"
        ( desugar_setter_setfields call flds rhs )
# 9230 "asllib/Parser.ml"
          
        in
        
# 196 "<standard.mly>"
    ( x )
# 9236 "asllib/Parser.ml"
        
      in
      let _endpos_desc_ = _endpos__2_ in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 9245 "asllib/Parser.ml"
       : (AST.stmt_desc AST.annotated))
  
  let _menhir_action_295 =
    fun _1 _4 _endpos__2_ _endpos_desc_ _startpos__1_ _startpos_desc_ desc lhs ty ->
      let desc =
        let x =
          let call =
            let _endpos = _endpos_desc_ in
            let _symbolstartpos = _startpos_desc_ in
            
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 9258 "asllib/Parser.ml"
            
          in
          let ldk = 
# 509 "asllib/Parser.mly"
                ( LDK_Let       )
# 9264 "asllib/Parser.ml"
           in
          
# 578 "asllib/Parser.mly"
        ( S_Decl (ldk, lhs, Some ty, desugar_elided_parameter ty call) )
# 9269 "asllib/Parser.ml"
          
        in
        
# 196 "<standard.mly>"
    ( x )
# 9275 "asllib/Parser.ml"
        
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos__2_, _startpos__1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 9284 "asllib/Parser.ml"
       : (AST.stmt_desc AST.annotated))
  
  let _menhir_action_296 =
    fun _1 _4 _endpos__1_ _endpos__2_ _endpos_desc_ _startpos__1_ _startpos_desc_ desc lhs ty ->
      let desc =
        let x =
          let call =
            let _endpos = _endpos_desc_ in
            let _symbolstartpos = _startpos_desc_ in
            
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 9297 "asllib/Parser.ml"
            
          in
          let ldk =
            let _endpos = _endpos__1_ in
            let _startpos = _startpos__1_ in
            
# 510 "asllib/Parser.mly"
                               (
      Error.fatal_here _startpos _endpos @@
        Error.CannotParse (Some "Local constant declarations are not valid ASL1. Did you mean `let`?.")
  )
# 9309 "asllib/Parser.ml"
            
          in
          
# 578 "asllib/Parser.mly"
        ( S_Decl (ldk, lhs, Some ty, desugar_elided_parameter ty call) )
# 9315 "asllib/Parser.ml"
          
        in
        
# 196 "<standard.mly>"
    ( x )
# 9321 "asllib/Parser.ml"
        
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos__2_, _startpos__1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 9330 "asllib/Parser.ml"
       : (AST.stmt_desc AST.annotated))
  
  let _menhir_action_297 =
    fun _1 _4 _endpos__2_ _endpos_desc_ _startpos__1_ _startpos_desc_ desc lhs ty ->
      let desc =
        let x =
          let call =
            let _endpos = _endpos_desc_ in
            let _symbolstartpos = _startpos_desc_ in
            
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 9343 "asllib/Parser.ml"
            
          in
          let ldk = 
# 514 "asllib/Parser.mly"
                ( LDK_Var       )
# 9349 "asllib/Parser.ml"
           in
          
# 578 "asllib/Parser.mly"
        ( S_Decl (ldk, lhs, Some ty, desugar_elided_parameter ty call) )
# 9354 "asllib/Parser.ml"
          
        in
        
# 196 "<standard.mly>"
    ( x )
# 9360 "asllib/Parser.ml"
        
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos__2_, _startpos__1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 9369 "asllib/Parser.ml"
       : (AST.stmt_desc AST.annotated))
  
  let _menhir_action_298 =
    fun _1 _endpos__2_ _startpos__1_ ldi x ->
      let desc =
        let x =
          let ty = 
# 164 "asllib/Parser.mly"
                        Some 
# 9379 "asllib/Parser.ml"
           x in
          
# 579 "asllib/Parser.mly"
                                                              ( S_Decl (LDK_Var, ldi, ty, None) )
# 9384 "asllib/Parser.ml"
          
        in
        
# 196 "<standard.mly>"
    ( x )
# 9390 "asllib/Parser.ml"
        
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos__2_, _startpos__1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 9399 "asllib/Parser.ml"
       : (AST.stmt_desc AST.annotated))
  
  let _menhir_action_299 =
    fun _1 _2_inlined1 _endpos__2_ _startpos__1_ as_ty ->
      let desc =
        let x =
          let _2 = _2_inlined1 in
          let _2_1 = _2 in
          
# 580 "asllib/Parser.mly"
                                                                Desugar.make_local_vars  
# 9411 "asllib/Parser.ml"
           (_2_1, as_ty)
        in
        
# 196 "<standard.mly>"
    ( x )
# 9417 "asllib/Parser.ml"
        
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos__2_, _startpos__1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 9426 "asllib/Parser.ml"
       : (AST.stmt_desc AST.annotated))
  
  let _menhir_action_300 =
    fun _1 _endpos__2_ _startpos__1_ args ->
      let desc =
        let x = 
# 581 "asllib/Parser.mly"
                                                              ( S_Print { args; newline = true; debug = false } )
# 9435 "asllib/Parser.ml"
         in
        
# 196 "<standard.mly>"
    ( x )
# 9440 "asllib/Parser.ml"
        
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos__2_, _startpos__1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 9449 "asllib/Parser.ml"
       : (AST.stmt_desc AST.annotated))
  
  let _menhir_action_301 =
    fun _1 _endpos__2_ _startpos__1_ args ->
      let desc =
        let x = 
# 582 "asllib/Parser.mly"
                                                              ( S_Print { args; newline = false; debug = false } )
# 9458 "asllib/Parser.ml"
         in
        
# 196 "<standard.mly>"
    ( x )
# 9463 "asllib/Parser.ml"
        
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos__2_, _startpos__1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 9472 "asllib/Parser.ml"
       : (AST.stmt_desc AST.annotated))
  
  let _menhir_action_302 =
    fun _1 _endpos__2_ _startpos__1_ x ->
      let desc =
        let x =
          let args = 
# 205 "<standard.mly>"
    ( x )
# 9482 "asllib/Parser.ml"
           in
          
# 583 "asllib/Parser.mly"
                                             ( S_Print { args; newline = true; debug = true } )
# 9487 "asllib/Parser.ml"
          
        in
        
# 196 "<standard.mly>"
    ( x )
# 9493 "asllib/Parser.ml"
        
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos__2_, _startpos__1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 9502 "asllib/Parser.ml"
       : (AST.stmt_desc AST.annotated))
  
  let _menhir_action_303 =
    fun _1 _endpos__2_ _startpos__1_ ->
      let desc =
        let x = 
# 584 "asllib/Parser.mly"
                                                              ( S_Unreachable )
# 9511 "asllib/Parser.ml"
         in
        
# 196 "<standard.mly>"
    ( x )
# 9516 "asllib/Parser.ml"
        
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos__2_, _startpos__1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 9525 "asllib/Parser.ml"
       : (AST.stmt_desc AST.annotated))
  
  let _menhir_action_304 =
    fun _1 _3 _endpos__2_ _startpos__1_ expr loop_limit stmt_list ->
      let desc =
        let x = 
# 585 "asllib/Parser.mly"
                                                               S_Repeat  
# 9534 "asllib/Parser.ml"
         (stmt_list, expr, loop_limit) in
        
# 196 "<standard.mly>"
    ( x )
# 9539 "asllib/Parser.ml"
        
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos__2_, _startpos__1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 9548 "asllib/Parser.ml"
       : (AST.stmt_desc AST.annotated))
  
  let _menhir_action_305 =
    fun _1 _endpos__2_ _startpos__1_ e ->
      let desc =
        let x = 
# 586 "asllib/Parser.mly"
                                                             ( S_Throw (e, None) )
# 9557 "asllib/Parser.ml"
         in
        
# 196 "<standard.mly>"
    ( x )
# 9562 "asllib/Parser.ml"
        
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos__2_, _startpos__1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 9571 "asllib/Parser.ml"
       : (AST.stmt_desc AST.annotated))
  
  let _menhir_action_306 =
    fun _1 _endpos__2_ _startpos__1_ e x ->
      let desc =
        let x = 
# 587 "asllib/Parser.mly"
                                                                S_Pragma  
# 9580 "asllib/Parser.ml"
         (x, e) in
        
# 196 "<standard.mly>"
    ( x )
# 9585 "asllib/Parser.ml"
        
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos__2_, _startpos__1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 9594 "asllib/Parser.ml"
       : (AST.stmt_desc AST.annotated))
  
  let _menhir_action_307 =
    fun _1 ->
      let _1_1 = _1 in
      (
# 591 "asllib/Parser.mly"
                                    stmt_from_list 
# 9603 "asllib/Parser.ml"
       _1_1 : (AST.stmt))
  
  let _menhir_action_308 =
    fun x ->
      (
# 196 "<standard.mly>"
    ( x )
# 9611 "asllib/Parser.ml"
       : (AST.stmt))
  
  let _menhir_action_309 =
    fun _1 _2 ->
      let with_opt = 
# 606 "asllib/Parser.mly"
                ( [] )
# 9619 "asllib/Parser.ml"
       in
      let _2_1 = _2 in
      ((_2_1, with_opt) : (string * AST.field list))
  
  let _menhir_action_310 =
    fun _1 _1_inlined1 _2 fields ->
      let with_opt =
        let _1 = _1_inlined1 in
        fields
      in
      let _2_1 = _2 in
      ((_2_1, with_opt) : (string * AST.field list))
  
  let _menhir_action_311 =
    fun () ->
      (
# 123 "<standard.mly>"
    ( None )
# 9638 "asllib/Parser.ml"
       : ((string * AST.field list) option))
  
  let _menhir_action_312 =
    fun x ->
      (
# 126 "<standard.mly>"
    ( Some x )
# 9646 "asllib/Parser.ml"
       : ((string * AST.field list) option))
  
  let _menhir_action_313 =
    fun () ->
      (
# 188 "asllib/Parser.mly"
                  ( [] )
# 9654 "asllib/Parser.ml"
       : (AST.bitfield list))
  
  let _menhir_action_314 =
    fun _1 ->
      (_1 : (AST.bitfield list))
  
  let _menhir_action_315 =
    fun x ->
      let _2 = 
# 123 "<standard.mly>"
    ( None )
# 9666 "asllib/Parser.ml"
       in
      (
# 192 "asllib/Parser.mly"
                         ( [ x ] )
# 9671 "asllib/Parser.ml"
       : (string list))
  
  let _menhir_action_316 =
    fun x x_inlined1 ->
      let _2 =
        let x = x_inlined1 in
        
# 126 "<standard.mly>"
    ( Some x )
# 9681 "asllib/Parser.ml"
        
      in
      (
# 192 "asllib/Parser.mly"
                         ( [ x ] )
# 9687 "asllib/Parser.ml"
       : (string list))
  
  let _menhir_action_317 =
    fun _2 h t ->
      (
# 193 "asllib/Parser.mly"
                              ( h :: t )
# 9695 "asllib/Parser.ml"
       : (string list))
  
  let _menhir_action_318 =
    fun x ->
      let _2 = 
# 123 "<standard.mly>"
    ( None )
# 9703 "asllib/Parser.ml"
       in
      (
# 192 "asllib/Parser.mly"
                         ( [ x ] )
# 9708 "asllib/Parser.ml"
       : (AST.bitfield list))
  
  let _menhir_action_319 =
    fun x x_inlined1 ->
      let _2 =
        let x = x_inlined1 in
        
# 126 "<standard.mly>"
    ( Some x )
# 9718 "asllib/Parser.ml"
        
      in
      (
# 192 "asllib/Parser.mly"
                         ( [ x ] )
# 9724 "asllib/Parser.ml"
       : (AST.bitfield list))
  
  let _menhir_action_320 =
    fun _2 h t ->
      (
# 193 "asllib/Parser.mly"
                              ( h :: t )
# 9732 "asllib/Parser.ml"
       : (AST.bitfield list))
  
  let _menhir_action_321 =
    fun x ->
      let _2 = 
# 123 "<standard.mly>"
    ( None )
# 9740 "asllib/Parser.ml"
       in
      (
# 192 "asllib/Parser.mly"
                         ( [ x ] )
# 9745 "asllib/Parser.ml"
       : (AST.field list))
  
  let _menhir_action_322 =
    fun x x_inlined1 ->
      let _2 =
        let x = x_inlined1 in
        
# 126 "<standard.mly>"
    ( Some x )
# 9755 "asllib/Parser.ml"
        
      in
      (
# 192 "asllib/Parser.mly"
                         ( [ x ] )
# 9761 "asllib/Parser.ml"
       : (AST.field list))
  
  let _menhir_action_323 =
    fun _2 h t ->
      (
# 193 "asllib/Parser.mly"
                              ( h :: t )
# 9769 "asllib/Parser.ml"
       : (AST.field list))
  
  let _menhir_action_324 =
    fun x ->
      (
# 205 "<standard.mly>"
    ( x )
# 9777 "asllib/Parser.ml"
       : (AST.ty))
  
  let _menhir_action_325 =
    fun _1 _endpos_c_ _startpos__1_ c ->
      let desc = 
# 398 "asllib/Parser.mly"
                                                          T_Int         
# 9785 "asllib/Parser.ml"
       c in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_c_, _startpos__1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 9793 "asllib/Parser.ml"
       : (AST.ty))
  
  let _menhir_action_326 =
    fun _1 _endpos__1_ _startpos__1_ ->
      let desc = 
# 399 "asllib/Parser.mly"
                                                        ( T_Real       )
# 9801 "asllib/Parser.ml"
       in
      let (_endpos_desc_, _startpos_desc_) = (_endpos__1_, _startpos__1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 9809 "asllib/Parser.ml"
       : (AST.ty))
  
  let _menhir_action_327 =
    fun _1 _endpos__1_ _startpos__1_ ->
      let desc = 
# 400 "asllib/Parser.mly"
                                                        ( T_Bool       )
# 9817 "asllib/Parser.ml"
       in
      let (_endpos_desc_, _startpos_desc_) = (_endpos__1_, _startpos__1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 9825 "asllib/Parser.ml"
       : (AST.ty))
  
  let _menhir_action_328 =
    fun _1 _endpos__1_ _startpos__1_ ->
      let desc = 
# 401 "asllib/Parser.mly"
                                                        ( T_String     )
# 9833 "asllib/Parser.ml"
       in
      let (_endpos_desc_, _startpos_desc_) = (_endpos__1_, _startpos__1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 9841 "asllib/Parser.ml"
       : (AST.ty))
  
  let _menhir_action_329 =
    fun _endpos_desc_ _startpos_desc_ desc ->
      let desc =
        let loc =
          let _endpos = _endpos_desc_ in
          let _symbolstartpos = _startpos_desc_ in
          
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 9853 "asllib/Parser.ml"
          
        in
        
# 402 "asllib/Parser.mly"
                                                        ( t_bit ~loc   )
# 9859 "asllib/Parser.ml"
        
      in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 9867 "asllib/Parser.ml"
       : (AST.ty))
  
  let _menhir_action_330 =
    fun _1 _endpos_bitfields_opt_ _startpos__1_ bitfields_opt x ->
      let desc =
        let _2 = 
# 205 "<standard.mly>"
    ( x )
# 9876 "asllib/Parser.ml"
         in
        let _2_1 = _2 in
        
# 403 "asllib/Parser.mly"
                                                          T_Bits        
# 9882 "asllib/Parser.ml"
         (_2_1, bitfields_opt)
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_bitfields_opt_, _startpos__1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 9891 "asllib/Parser.ml"
       : (AST.ty))
  
  let _menhir_action_331 =
    fun _endpos__3_ _startpos__1_ x ->
      let desc =
        let _1 = 
# 205 "<standard.mly>"
    ( x )
# 9900 "asllib/Parser.ml"
         in
        let _1_1 = _1 in
        
# 404 "asllib/Parser.mly"
                                                          T_Tuple       
# 9906 "asllib/Parser.ml"
         _1_1
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos__3_, _startpos__1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 9915 "asllib/Parser.ml"
       : (AST.ty))
  
  let _menhir_action_332 =
    fun _endpos_name_ _startpos_name_ name ->
      let desc = 
# 405 "asllib/Parser.mly"
                                                          T_Named       
# 9923 "asllib/Parser.ml"
       name in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_name_, _startpos_name_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 9931 "asllib/Parser.ml"
       : (AST.ty))
  
  let _menhir_action_333 =
    fun _1 _2 _4 _5 _endpos_t_ _startpos__1_ e t ->
      let desc = 
# 406 "asllib/Parser.mly"
                                                        ( T_Array (ArrayLength_Expr e, t) )
# 9939 "asllib/Parser.ml"
       in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_t_, _startpos__1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 9947 "asllib/Parser.ml"
       : (AST.ty))
  
  let _menhir_action_334 =
    fun _1 ->
      (_1 : (AST.ty))
  
  let _menhir_action_335 =
    fun _1 _endpos__3_ _startpos__1_ x ->
      let desc =
        let l = 
# 205 "<standard.mly>"
    ( x )
# 9960 "asllib/Parser.ml"
         in
        
# 411 "asllib/Parser.mly"
                                                          T_Enum        
# 9965 "asllib/Parser.ml"
         l
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos__3_, _startpos__1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 9974 "asllib/Parser.ml"
       : (AST.ty))
  
  let _menhir_action_336 =
    fun _1 _endpos__1_ _startpos__1_ ->
      let desc =
        let _endpos = _endpos__1_ in
        let _startpos = _startpos__1_ in
        
# 413 "asllib/Parser.mly"
      ( Error.fatal_here _startpos _endpos @@
          Error.CannotParse (Some "Empty record types must be declared with empty field list `{-}`.") )
# 9986 "asllib/Parser.ml"
        
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos__1_, _startpos__1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 9995 "asllib/Parser.ml"
       : (AST.ty))
  
  let _menhir_action_337 =
    fun _1 _endpos__1_ _startpos__1_ ->
      let desc =
        let _endpos = _endpos__1_ in
        let _startpos = _startpos__1_ in
        
# 416 "asllib/Parser.mly"
      ( Error.fatal_here _startpos _endpos @@
          Error.CannotParse (Some "Empty exception types must be declared with empty field list `{-}`.") )
# 10007 "asllib/Parser.ml"
        
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos__1_, _startpos__1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 10016 "asllib/Parser.ml"
       : (AST.ty))
  
  let _menhir_action_338 =
    fun _1 _endpos_l_ _startpos__1_ l ->
      let desc = 
# 418 "asllib/Parser.mly"
                                                          T_Record      
# 10024 "asllib/Parser.ml"
       l in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_l_, _startpos__1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 10032 "asllib/Parser.ml"
       : (AST.ty))
  
  let _menhir_action_339 =
    fun _1 _endpos_l_ _startpos__1_ l ->
      let desc = 
# 419 "asllib/Parser.mly"
                                                          T_Exception   
# 10040 "asllib/Parser.ml"
       l in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_l_, _startpos__1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 10048 "asllib/Parser.ml"
       : (AST.ty))
  
  let _menhir_action_340 =
    fun _1 ->
      (_1 : (AST.ty))
  
  let _menhir_action_341 =
    fun _1 _endpos__1_ _startpos__1_ ->
      let desc =
        let _endpos = _endpos__1_ in
        let _startpos = _startpos__1_ in
        
# 432 "asllib/Parser.mly"
      ( Error.fatal_here _startpos _endpos @@
          Error.CannotParse (Some "Empty collection types must be declared with empty field list `{-}`.") )
# 10064 "asllib/Parser.ml"
        
      in
      let (_endpos_desc_, _startpos_desc_) = (_endpos__1_, _startpos__1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 10073 "asllib/Parser.ml"
       : (AST.ty))
  
  let _menhir_action_342 =
    fun _1 _endpos_l_ _startpos__1_ l ->
      let desc = 
# 434 "asllib/Parser.mly"
                                                      T_Collection  
# 10081 "asllib/Parser.ml"
       l in
      let (_endpos_desc_, _startpos_desc_) = (_endpos_l_, _startpos__1_) in
      let _endpos = _endpos_desc_ in
      let _symbolstartpos = _startpos_desc_ in
      (
# 171 "asllib/Parser.mly"
                              ( { desc; pos_start=_symbolstartpos; pos_end=_endpos; version } )
# 10089 "asllib/Parser.ml"
       : (AST.ty))
  
  let _menhir_action_343 =
    fun x y ->
      (
# 172 "<standard.mly>"
    ( (x, y) )
# 10097 "asllib/Parser.ml"
       : (AST.field))
  
  let _menhir_action_344 =
    fun i ->
      (
# 216 "asllib/Parser.mly"
                        L_Int          
# 10105 "asllib/Parser.ml"
       i : (AST.literal))
  
  let _menhir_action_345 =
    fun b ->
      (
# 217 "asllib/Parser.mly"
                        L_Bool         
# 10113 "asllib/Parser.ml"
       b : (AST.literal))
  
  let _menhir_action_346 =
    fun r ->
      (
# 218 "asllib/Parser.mly"
                        L_Real         
# 10121 "asllib/Parser.ml"
       r : (AST.literal))
  
  let _menhir_action_347 =
    fun b ->
      (
# 219 "asllib/Parser.mly"
                        L_BitVector    
# 10129 "asllib/Parser.ml"
       b : (AST.literal))
  
  let _menhir_action_348 =
    fun s ->
      (
# 220 "asllib/Parser.mly"
                        L_String       
# 10137 "asllib/Parser.ml"
       s : (AST.literal))
  
  let _menhir_print_token : token -> string =
    fun _tok ->
      match _tok with
      | Tokens.ACCESSOR ->
          "ACCESSOR"
      | Tokens.AND ->
          "AND"
      | Tokens.ARBITRARY ->
          "ARBITRARY"
      | Tokens.ARRAY ->
          "ARRAY"
      | Tokens.ARROW ->
          "ARROW"
      | Tokens.AS ->
          "AS"
      | Tokens.ASSERT ->
          "ASSERT"
      | Tokens.BAND ->
          "BAND"
      | Tokens.BEGIN ->
          "BEGIN"
      | Tokens.BEQ ->
          "BEQ"
      | Tokens.BIT ->
          "BIT"
      | Tokens.BITS ->
          "BITS"
      | Tokens.BITVECTOR_LIT _ ->
          "BITVECTOR_LIT"
      | Tokens.BNOT ->
          "BNOT"
      | Tokens.BOOLEAN ->
          "BOOLEAN"
      | Tokens.BOOL_LIT _ ->
          "BOOL_LIT"
      | Tokens.BOR ->
          "BOR"
      | Tokens.CASE ->
          "CASE"
      | Tokens.CATCH ->
          "CATCH"
      | Tokens.COLLECTION ->
          "COLLECTION"
      | Tokens.COLON ->
          "COLON"
      | Tokens.COLON_COLON ->
          "COLON_COLON"
      | Tokens.COMMA ->
          "COMMA"
      | Tokens.CONFIG ->
          "CONFIG"
      | Tokens.CONSTANT ->
          "CONSTANT"
      | Tokens.DEBUG ->
          "DEBUG"
      | Tokens.DIV ->
          "DIV"
      | Tokens.DIVRM ->
          "DIVRM"
      | Tokens.DO ->
          "DO"
      | Tokens.DOT ->
          "DOT"
      | Tokens.DOWNTO ->
          "DOWNTO"
      | Tokens.ELSE ->
          "ELSE"
      | Tokens.ELSIF ->
          "ELSIF"
      | Tokens.END ->
          "END"
      | Tokens.ENUMERATION ->
          "ENUMERATION"
      | Tokens.EOF ->
          "EOF"
      | Tokens.EQ ->
          "EQ"
      | Tokens.EQ_EQ ->
          "EQ_EQ"
      | Tokens.EXCEPTION ->
          "EXCEPTION"
      | Tokens.FOR ->
          "FOR"
      | Tokens.FUNC ->
          "FUNC"
      | Tokens.GE ->
          "GE"
      | Tokens.GETTER ->
          "GETTER"
      | Tokens.GT ->
          "GT"
      | Tokens.IDENTIFIER _ ->
          "IDENTIFIER"
      | Tokens.IF ->
          "IF"
      | Tokens.IMPDEF ->
          "IMPDEF"
      | Tokens.IMPL ->
          "IMPL"
      | Tokens.IMPLEMENTATION ->
          "IMPLEMENTATION"
      | Tokens.IN ->
          "IN"
      | Tokens.INTEGER ->
          "INTEGER"
      | Tokens.INT_LIT _ ->
          "INT_LIT"
      | Tokens.LBRACE ->
          "LBRACE"
      | Tokens.LBRACKET ->
          "LBRACKET"
      | Tokens.LE ->
          "LE"
      | Tokens.LET ->
          "LET"
      | Tokens.LLBRACKET ->
          "LLBRACKET"
      | Tokens.LOOPLIMIT ->
          "LOOPLIMIT"
      | Tokens.LPAR ->
          "LPAR"
      | Tokens.LT ->
          "LT"
      | Tokens.MASK_LIT _ ->
          "MASK_LIT"
      | Tokens.MINUS ->
          "MINUS"
      | Tokens.MOD ->
          "MOD"
      | Tokens.MUL ->
          "MUL"
      | Tokens.NE ->
          "NE"
      | Tokens.NORETURN ->
          "NORETURN"
      | Tokens.NOT ->
          "NOT"
      | Tokens.OF ->
          "OF"
      | Tokens.OR ->
          "OR"
      | Tokens.OTHERWISE ->
          "OTHERWISE"
      | Tokens.PASS ->
          "PASS"
      | Tokens.PLUS ->
          "PLUS"
      | Tokens.PLUS_COLON ->
          "PLUS_COLON"
      | Tokens.PLUS_PLUS ->
          "PLUS_PLUS"
      | Tokens.POW ->
          "POW"
      | Tokens.PRAGMA ->
          "PRAGMA"
      | Tokens.PRINT ->
          "PRINT"
      | Tokens.PRINTLN ->
          "PRINTLN"
      | Tokens.PURE ->
          "PURE"
      | Tokens.RBRACE ->
          "RBRACE"
      | Tokens.RBRACKET ->
          "RBRACKET"
      | Tokens.RDIV ->
          "RDIV"
      | Tokens.READONLY ->
          "READONLY"
      | Tokens.REAL ->
          "REAL"
      | Tokens.REAL_LIT _ ->
          "REAL_LIT"
      | Tokens.RECORD ->
          "RECORD"
      | Tokens.RECURSELIMIT ->
          "RECURSELIMIT"
      | Tokens.REPEAT ->
          "REPEAT"
      | Tokens.RETURN ->
          "RETURN"
      | Tokens.RPAR ->
          "RPAR"
      | Tokens.RRBRACKET ->
          "RRBRACKET"
      | Tokens.SEMI_COLON ->
          "SEMI_COLON"
      | Tokens.SETTER ->
          "SETTER"
      | Tokens.SHL ->
          "SHL"
      | Tokens.SHR ->
          "SHR"
      | Tokens.SLICING ->
          "SLICING"
      | Tokens.STAR_COLON ->
          "STAR_COLON"
      | Tokens.STRING ->
          "STRING"
      | Tokens.STRING_LIT _ ->
          "STRING_LIT"
      | Tokens.SUBTYPES ->
          "SUBTYPES"
      | Tokens.THEN ->
          "THEN"
      | Tokens.THROW ->
          "THROW"
      | Tokens.TO ->
          "TO"
      | Tokens.TRY ->
          "TRY"
      | Tokens.TYPE ->
          "TYPE"
      | Tokens.UNREACHABLE ->
          "UNREACHABLE"
      | Tokens.UNTIL ->
          "UNTIL"
      | Tokens.VAR ->
          "VAR"
      | Tokens.WHEN ->
          "WHEN"
      | Tokens.WHERE ->
          "WHERE"
      | Tokens.WHILE ->
          "WHILE"
      | Tokens.WITH ->
          "WITH"
      | Tokens.XOR ->
          "XOR"
  
  let _menhir_fail : unit -> 'a =
    fun () ->
      Printf.eprintf "Internal failure -- please contact the parser generator's developers.\n%!";
      assert false
  
  include struct
    
    [@@@ocaml.warning "-4-37"]
    
    let _menhir_run_563 : type  ttv_stack. ttv_stack -> _ -> _ -> _menhir_box_opn =
      fun _menhir_stack _v _tok ->
        match (_tok : MenhirBasics.token) with
        | Tokens.EOF ->
            let (_2, body) = ((), _v) in
            let _v = _menhir_action_240 _2 body in
            MenhirBox_opn _v
        | _ ->
            _eRR 563
    
    let _menhir_run_910 : type  ttv_stack. ttv_stack -> _ -> _ -> _menhir_box_stmts =
      fun _menhir_stack _v _tok ->
        match (_tok : MenhirBasics.token) with
        | Tokens.EOF ->
            let x = _v in
            let _v = _menhir_action_308 x in
            MenhirBox_stmts _v
        | _ ->
            _eRR 910
    
    let _menhir_run_904 : type  ttv_stack. ttv_stack -> _ -> _menhir_box_spec =
      fun _menhir_stack _v ->
        let x = _v in
        let _v = _menhir_action_274 x in
        MenhirBox_spec _v
    
    let rec _menhir_run_907 : type  ttv_stack. (ttv_stack, _menhir_box_spec) _menhir_cell1_decl -> _ -> _menhir_box_spec =
      fun _menhir_stack _v ->
        let MenhirCell1_decl (_menhir_stack, _menhir_s, x) = _menhir_stack in
        let xs = _v in
        let _v = _menhir_action_231 x xs in
        _menhir_goto_list_decl_ _menhir_stack _v _menhir_s
    
    and _menhir_goto_list_decl_ : type  ttv_stack. ttv_stack -> _ -> (ttv_stack, _menhir_box_spec) _menhir_state -> _menhir_box_spec =
      fun _menhir_stack _v _menhir_s ->
        match _menhir_s with
        | MenhirState906 ->
            _menhir_run_907 _menhir_stack _v
        | MenhirState566 ->
            _menhir_run_904 _menhir_stack _v
        | _ ->
            _menhir_fail ()
    
    let rec _menhir_run_001 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _menhir_stack = MenhirCell1_WHILE (_menhir_stack, _menhir_s, _startpos) in
        let _menhir_s = MenhirState001 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.STRING_LIT _v ->
            _menhir_run_002 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.REAL_LIT _v ->
            _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.NOT ->
            _menhir_run_004 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.MINUS ->
            _menhir_run_005 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LPAR ->
            _menhir_run_006 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.INT_LIT _v ->
            _menhir_run_007 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.IF ->
            _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IDENTIFIER _v ->
            _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BOOL_LIT _v ->
            _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BNOT ->
            _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.BITVECTOR_LIT _v ->
            _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.ARBITRARY ->
            _menhir_run_014 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | _ ->
            _eRR 1
    
    and _menhir_run_002 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
        let _tok = _menhir_lexer _menhir_lexbuf in
        let (_endpos_s_, _startpos_s_, s) = (_endpos, _startpos, _v) in
        let _v = _menhir_action_348 s in
        _menhir_goto_value _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_s_ _startpos_s_ _v _menhir_s _tok
    
    and _menhir_goto_value : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
        match _menhir_s with
        | MenhirState472 ->
            _menhir_run_176 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState040 ->
            _menhir_run_176 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState257 ->
            _menhir_run_176 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState056 ->
            _menhir_run_176 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState181 ->
            _menhir_run_176 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState172 ->
            _menhir_run_176 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState887 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState879 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState875 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState780 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState776 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState740 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState645 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState591 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState571 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState536 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState525 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState504 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState500 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState493 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState484 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState477 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState474 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState469 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState464 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState460 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState454 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState449 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState445 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState424 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState420 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState415 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState411 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState390 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState381 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState377 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState374 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState369 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState366 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState343 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState345 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState353 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState350 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState347 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState338 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState314 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState001 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState004 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState005 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState308 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState006 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState303 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState008 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState010 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState012 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState282 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState280 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState020 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState273 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState271 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState269 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState267 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState034 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState171 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState249 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState244 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState242 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState240 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState238 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState236 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState234 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState226 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState224 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState222 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState220 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState215 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState212 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState210 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState208 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState206 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState204 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState201 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState199 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState197 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState195 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState193 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState191 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState189 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState187 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState185 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState183 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState169 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState143 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState163 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState157 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState153 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState147 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState148 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState144 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState139 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState136 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState134 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState119 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState107 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState101 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState099 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState097 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState094 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState092 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState090 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState088 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState086 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState084 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState082 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState080 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState078 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState075 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState073 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState071 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState069 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState067 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState065 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState063 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState061 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState059 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState057 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState053 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState041 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState037 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState035 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState032 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState030 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState028 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState026 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState022 ->
            _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | _ ->
            _menhir_fail ()
    
    and _menhir_run_176 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
        let (_endpos_value_, _startpos_value_, value) = (_endpos, _startpos, _v) in
        let _v = _menhir_action_170 _endpos_value_ _startpos_value_ value in
        _menhir_goto_expr_pattern _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_value_ _startpos_value_ _v _menhir_s _tok
    
    and _menhir_goto_expr_pattern : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
        match _menhir_s with
        | MenhirState056 ->
            _menhir_run_259 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState472 ->
            _menhir_run_182 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState040 ->
            _menhir_run_182 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState257 ->
            _menhir_run_182 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState172 ->
            _menhir_run_182 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState181 ->
            _menhir_run_182 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | _ ->
            _menhir_fail ()
    
    and _menhir_run_259 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_LPAR as 'stack) -> _ -> _ -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
        match (_tok : MenhirBasics.token) with
        | Tokens.XOR ->
            let _menhir_stack = MenhirCell1_expr_pattern (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_183 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState259
        | Tokens.SLICING ->
            let _menhir_stack = MenhirCell1_expr_pattern (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_185 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState259
        | Tokens.SHR ->
            let _menhir_stack = MenhirCell1_expr_pattern (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_187 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState259
        | Tokens.SHL ->
            let _menhir_stack = MenhirCell1_expr_pattern (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_189 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState259
        | Tokens.RPAR ->
            let _endpos_0 = _menhir_lexbuf.Lexing.lex_curr_p in
            let _tok = _menhir_lexer _menhir_lexbuf in
            let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
            let (x, _endpos__3_) = (_v, _endpos_0) in
            let _v = _menhir_action_212 _endpos__3_ _startpos__1_ x in
            _menhir_goto_expr_pattern _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__3_ _startpos__1_ _v _menhir_s _tok
        | Tokens.RDIV ->
            let _menhir_stack = MenhirCell1_expr_pattern (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_191 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState259
        | Tokens.POW ->
            let _menhir_stack = MenhirCell1_expr_pattern (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_193 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState259
        | Tokens.PLUS_PLUS ->
            let _menhir_stack = MenhirCell1_expr_pattern (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_195 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState259
        | Tokens.PLUS ->
            let _menhir_stack = MenhirCell1_expr_pattern (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_197 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState259
        | Tokens.OR ->
            let _menhir_stack = MenhirCell1_expr_pattern (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_199 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState259
        | Tokens.NE ->
            let _menhir_stack = MenhirCell1_expr_pattern (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_201 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState259
        | Tokens.MUL ->
            let _menhir_stack = MenhirCell1_expr_pattern (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_204 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState259
        | Tokens.MOD ->
            let _menhir_stack = MenhirCell1_expr_pattern (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_206 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState259
        | Tokens.MINUS ->
            let _menhir_stack = MenhirCell1_expr_pattern (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_208 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState259
        | Tokens.LT ->
            let _menhir_stack = MenhirCell1_expr_pattern (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_210 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState259
        | Tokens.LLBRACKET ->
            let _menhir_stack = MenhirCell1_expr_pattern (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_212 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState259
        | Tokens.LE ->
            let _menhir_stack = MenhirCell1_expr_pattern (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_215 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState259
        | Tokens.LBRACKET ->
            let _menhir_stack = MenhirCell1_expr_pattern (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_034 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState259
        | Tokens.IN ->
            let _menhir_stack = MenhirCell1_expr_pattern (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_217 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState259
        | Tokens.IMPL ->
            let _menhir_stack = MenhirCell1_expr_pattern (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_220 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState259
        | Tokens.GT ->
            let _menhir_stack = MenhirCell1_expr_pattern (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_222 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState259
        | Tokens.GE ->
            let _menhir_stack = MenhirCell1_expr_pattern (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_224 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState259
        | Tokens.EQ_EQ ->
            let _menhir_stack = MenhirCell1_expr_pattern (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_226 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState259
        | Tokens.DOT ->
            let _menhir_stack = MenhirCell1_expr_pattern (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_229 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState259
        | Tokens.DIVRM ->
            let _menhir_stack = MenhirCell1_expr_pattern (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_234 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState259
        | Tokens.DIV ->
            let _menhir_stack = MenhirCell1_expr_pattern (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_236 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState259
        | Tokens.COLON_COLON ->
            let _menhir_stack = MenhirCell1_expr_pattern (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_238 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState259
        | Tokens.BOR ->
            let _menhir_stack = MenhirCell1_expr_pattern (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_240 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState259
        | Tokens.BEQ ->
            let _menhir_stack = MenhirCell1_expr_pattern (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_242 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState259
        | Tokens.BAND ->
            let _menhir_stack = MenhirCell1_expr_pattern (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_244 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState259
        | Tokens.AS ->
            let _menhir_stack = MenhirCell1_expr_pattern (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_246 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState259
        | Tokens.AND ->
            let _menhir_stack = MenhirCell1_expr_pattern (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_249 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState259
        | Tokens.COMMA ->
            let (_endpos_expr_pattern_, _startpos_expr_pattern_, expr_pattern) = (_endpos, _startpos, _v) in
            let _v = _menhir_action_249 _endpos_expr_pattern_ _startpos_expr_pattern_ expr_pattern in
            _menhir_goto_pattern _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_expr_pattern_ _startpos_expr_pattern_ _v _menhir_s _tok
        | _ ->
            _eRR 259
    
    and _menhir_run_183 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_expr_pattern as 'stack) -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _menhir_stack = MenhirCell1_XOR (_menhir_stack, _menhir_s) in
        let _menhir_s = MenhirState183 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.STRING_LIT _v ->
            _menhir_run_002 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.REAL_LIT _v ->
            _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.NOT ->
            _menhir_run_004 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.MINUS ->
            _menhir_run_005 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LPAR ->
            _menhir_run_006 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.INT_LIT _v ->
            _menhir_run_007 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.IF ->
            _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IDENTIFIER _v ->
            _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BOOL_LIT _v ->
            _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BNOT ->
            _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.BITVECTOR_LIT _v ->
            _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.ARBITRARY ->
            _menhir_run_014 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | _ ->
            _eRR 183
    
    and _menhir_run_003 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
        let _tok = _menhir_lexer _menhir_lexbuf in
        let (_endpos_r_, _startpos_r_, r) = (_endpos, _startpos, _v) in
        let _v = _menhir_action_346 r in
        _menhir_goto_value _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_r_ _startpos_r_ _v _menhir_s _tok
    
    and _menhir_run_004 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _menhir_stack = MenhirCell1_NOT (_menhir_stack, _menhir_s, _startpos) in
        let _menhir_s = MenhirState004 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.STRING_LIT _v ->
            _menhir_run_002 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.REAL_LIT _v ->
            _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.NOT ->
            _menhir_run_004 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.MINUS ->
            _menhir_run_005 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LPAR ->
            _menhir_run_006 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.INT_LIT _v ->
            _menhir_run_007 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.IF ->
            _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IDENTIFIER _v ->
            _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BOOL_LIT _v ->
            _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BNOT ->
            _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.BITVECTOR_LIT _v ->
            _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.ARBITRARY ->
            _menhir_run_014 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | _ ->
            _eRR 4
    
    and _menhir_run_005 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
        let _menhir_stack = MenhirCell1_MINUS (_menhir_stack, _menhir_s, _startpos, _endpos) in
        let _menhir_s = MenhirState005 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.STRING_LIT _v ->
            _menhir_run_002 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.REAL_LIT _v ->
            _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.NOT ->
            _menhir_run_004 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.MINUS ->
            _menhir_run_005 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LPAR ->
            _menhir_run_006 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.INT_LIT _v ->
            _menhir_run_007 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.IF ->
            _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IDENTIFIER _v ->
            _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BOOL_LIT _v ->
            _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BNOT ->
            _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.BITVECTOR_LIT _v ->
            _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.ARBITRARY ->
            _menhir_run_014 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | _ ->
            _eRR 5
    
    and _menhir_run_006 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _menhir_stack = MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos) in
        let _menhir_s = MenhirState006 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.STRING_LIT _v ->
            _menhir_run_002 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.REAL_LIT _v ->
            _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.NOT ->
            _menhir_run_004 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.MINUS ->
            _menhir_run_005 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LPAR ->
            _menhir_run_006 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.INT_LIT _v ->
            _menhir_run_007 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.IF ->
            _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IDENTIFIER _v ->
            _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BOOL_LIT _v ->
            _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BNOT ->
            _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.BITVECTOR_LIT _v ->
            _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.ARBITRARY ->
            _menhir_run_014 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | _ ->
            _eRR 6
    
    and _menhir_run_007 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
        let _tok = _menhir_lexer _menhir_lexbuf in
        let (_endpos_i_, _startpos_i_, i) = (_endpos, _startpos, _v) in
        let _v = _menhir_action_344 i in
        _menhir_goto_value _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_i_ _startpos_i_ _v _menhir_s _tok
    
    and _menhir_run_008 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _menhir_stack = MenhirCell1_IF (_menhir_stack, _menhir_s, _startpos) in
        let _menhir_s = MenhirState008 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.STRING_LIT _v ->
            _menhir_run_002 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.REAL_LIT _v ->
            _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.NOT ->
            _menhir_run_004 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.MINUS ->
            _menhir_run_005 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LPAR ->
            _menhir_run_006 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.INT_LIT _v ->
            _menhir_run_007 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.IF ->
            _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IDENTIFIER _v ->
            _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BOOL_LIT _v ->
            _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BNOT ->
            _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.BITVECTOR_LIT _v ->
            _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.ARBITRARY ->
            _menhir_run_014 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | _ ->
            _eRR 8
    
    and _menhir_run_009 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.LPAR ->
            let _menhir_stack = MenhirCell1_IDENTIFIER (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_010 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState009
        | Tokens.LBRACE ->
            let _menhir_stack = MenhirCell1_IDENTIFIER (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_147 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState009
        | Tokens.AND | Tokens.ARROW | Tokens.AS | Tokens.BAND | Tokens.BEGIN | Tokens.BEQ | Tokens.BOR | Tokens.COLON | Tokens.COLON_COLON | Tokens.COMMA | Tokens.DIV | Tokens.DIVRM | Tokens.DO | Tokens.DOT | Tokens.DOWNTO | Tokens.ELSE | Tokens.ELSIF | Tokens.EQ_EQ | Tokens.GE | Tokens.GT | Tokens.IMPL | Tokens.IN | Tokens.LBRACKET | Tokens.LE | Tokens.LLBRACKET | Tokens.LOOPLIMIT | Tokens.LT | Tokens.MINUS | Tokens.MOD | Tokens.MUL | Tokens.NE | Tokens.OF | Tokens.OR | Tokens.PLUS | Tokens.PLUS_COLON | Tokens.PLUS_PLUS | Tokens.POW | Tokens.RBRACE | Tokens.RBRACKET | Tokens.RDIV | Tokens.RPAR | Tokens.RRBRACKET | Tokens.SEMI_COLON | Tokens.SHL | Tokens.SHR | Tokens.SLICING | Tokens.STAR_COLON | Tokens.THEN | Tokens.TO | Tokens.WHERE | Tokens.XOR ->
            let (_endpos__1_, _startpos__1_, _1) = (_endpos, _startpos, _v) in
            let _v = _menhir_action_125 _1 _endpos__1_ _startpos__1_ in
            _menhir_goto_expr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__1_ _startpos__1_ _v _menhir_s _tok
        | _ ->
            _eRR 9
    
    and _menhir_run_010 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_IDENTIFIER as 'stack) -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _menhir_stack = MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos) in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.STRING_LIT _v ->
            _menhir_run_002 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState010
        | Tokens.REAL_LIT _v ->
            _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState010
        | Tokens.NOT ->
            _menhir_run_004 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState010
        | Tokens.MINUS ->
            _menhir_run_005 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState010
        | Tokens.LPAR ->
            _menhir_run_006 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState010
        | Tokens.INT_LIT _v ->
            _menhir_run_007 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState010
        | Tokens.IF ->
            _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState010
        | Tokens.IDENTIFIER _v ->
            _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState010
        | Tokens.BOOL_LIT _v ->
            _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState010
        | Tokens.BNOT ->
            _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState010
        | Tokens.BITVECTOR_LIT _v ->
            _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState010
        | Tokens.ARBITRARY ->
            _menhir_run_014 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState010
        | Tokens.RPAR ->
            let _v = _menhir_action_024 () in
            _menhir_run_300 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
        | _ ->
            _eRR 10
    
    and _menhir_run_011 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
        let _tok = _menhir_lexer _menhir_lexbuf in
        let (_endpos_b_, _startpos_b_, b) = (_endpos, _startpos, _v) in
        let _v = _menhir_action_345 b in
        _menhir_goto_value _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_b_ _startpos_b_ _v _menhir_s _tok
    
    and _menhir_run_012 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _menhir_stack = MenhirCell1_BNOT (_menhir_stack, _menhir_s, _startpos) in
        let _menhir_s = MenhirState012 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.STRING_LIT _v ->
            _menhir_run_002 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.REAL_LIT _v ->
            _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.NOT ->
            _menhir_run_004 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.MINUS ->
            _menhir_run_005 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LPAR ->
            _menhir_run_006 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.INT_LIT _v ->
            _menhir_run_007 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.IF ->
            _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IDENTIFIER _v ->
            _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BOOL_LIT _v ->
            _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BNOT ->
            _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.BITVECTOR_LIT _v ->
            _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.ARBITRARY ->
            _menhir_run_014 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | _ ->
            _eRR 12
    
    and _menhir_run_013 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
        let _tok = _menhir_lexer _menhir_lexbuf in
        let (_endpos_b_, _startpos_b_, b) = (_endpos, _startpos, _v) in
        let _v = _menhir_action_347 b in
        _menhir_goto_value _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_b_ _startpos_b_ _v _menhir_s _tok
    
    and _menhir_run_014 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _menhir_stack = MenhirCell1_ARBITRARY (_menhir_stack, _menhir_s, _startpos) in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.COLON ->
            let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
            let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
            let _menhir_stack = MenhirCell0_COLON (_menhir_stack, _startpos, _endpos) in
            let _menhir_s = MenhirState015 in
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.STRING ->
                _menhir_run_016 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.REAL ->
                _menhir_run_017 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.LPAR ->
                _menhir_run_018 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.INTEGER ->
                _menhir_run_019 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.IDENTIFIER _v ->
                _menhir_run_104 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | Tokens.BOOLEAN ->
                _menhir_run_105 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.BITS ->
                _menhir_run_106 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.BIT ->
                _menhir_run_117 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.ARRAY ->
                _menhir_run_118 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | _ ->
                _eRR 15)
        | _ ->
            _eRR 14
    
    and _menhir_run_016 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
        let _tok = _menhir_lexer _menhir_lexbuf in
        let (_endpos__1_, _startpos__1_, _1) = (_endpos, _startpos, ()) in
        let _v = _menhir_action_328 _1 _endpos__1_ _startpos__1_ in
        _menhir_goto_ty _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__1_ _v _menhir_s _tok
    
    and _menhir_goto_ty : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok ->
        match _menhir_s with
        | MenhirState647 ->
            _menhir_run_648 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
        | MenhirState605 ->
            _menhir_run_621 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
        | MenhirState574 ->
            _menhir_run_589 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
        | MenhirState542 ->
            _menhir_run_548 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState544 ->
            _menhir_run_545 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState015 ->
            _menhir_run_298 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
        | MenhirState293 ->
            _menhir_run_292 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState291 ->
            _menhir_run_292 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState018 ->
            _menhir_run_289 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState246 ->
            _menhir_run_247 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
        | MenhirState174 ->
            _menhir_run_175 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
        | MenhirState103 ->
            _menhir_run_132 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
        | MenhirState116 ->
            _menhir_run_124 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
        | MenhirState122 ->
            _menhir_run_123 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
        | _ ->
            _menhir_fail ()
    
    and _menhir_run_648 : type  ttv_stack. (((ttv_stack _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args, _menhir_box_spec) _menhir_cell1_ARROW -> _ -> _ -> _ -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
        let MenhirCell1_ARROW (_menhir_stack, _menhir_s) = _menhir_stack in
        let (_1, _2) = ((), _v) in
        let _v = _menhir_action_262 _1 _2 in
        _menhir_goto_return_type _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
    
    and _menhir_goto_return_type : type  ttv_stack. (((ttv_stack _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_spec) _menhir_state -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
        match _menhir_s with
        | MenhirState861 ->
            _menhir_run_862 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
        | MenhirState835 ->
            _menhir_run_836 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
        | MenhirState789 ->
            _menhir_run_790 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
        | MenhirState727 ->
            _menhir_run_728 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
        | MenhirState712 ->
            _menhir_run_713 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
        | MenhirState696 ->
            _menhir_run_697 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
        | MenhirState679 ->
            _menhir_run_680 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
        | MenhirState664 ->
            _menhir_run_665 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
        | MenhirState644 ->
            _menhir_run_649 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
        | _ ->
            _menhir_fail ()
    
    and _menhir_run_862 : type  ttv_stack. ((((ttv_stack, _menhir_box_spec) _menhir_cell1_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_spec) _menhir_state -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
        let _menhir_stack = MenhirCell1_return_type (_menhir_stack, _menhir_s, _v) in
        match (_tok : MenhirBasics.token) with
        | Tokens.RECURSELIMIT ->
            _menhir_run_645 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState862
        | Tokens.BEGIN ->
            let _v_0 = _menhir_action_260 () in
            _menhir_run_863 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState862
        | _ ->
            _eRR 862
    
    and _menhir_run_645 : type  ttv_stack. ttv_stack -> _ -> _ -> (ttv_stack, _menhir_box_spec) _menhir_state -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _menhir_stack = MenhirCell1_RECURSELIMIT (_menhir_stack, _menhir_s) in
        let _menhir_s = MenhirState645 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.STRING_LIT _v ->
            _menhir_run_002 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.REAL_LIT _v ->
            _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.NOT ->
            _menhir_run_004 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.MINUS ->
            _menhir_run_005 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LPAR ->
            _menhir_run_006 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.INT_LIT _v ->
            _menhir_run_007 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.IF ->
            _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IDENTIFIER _v ->
            _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BOOL_LIT _v ->
            _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BNOT ->
            _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.BITVECTOR_LIT _v ->
            _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.ARBITRARY ->
            _menhir_run_014 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | _ ->
            _eRR 645
    
    and _menhir_run_863 : type  ttv_stack. (((((ttv_stack, _menhir_box_spec) _menhir_cell1_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args, _menhir_box_spec) _menhir_cell1_return_type as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_spec) _menhir_state -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
        let _menhir_stack = MenhirCell1_recurse_limit (_menhir_stack, _menhir_s, _v) in
        let _menhir_s = MenhirState864 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.WHILE ->
            _menhir_run_001 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.VAR ->
            _menhir_run_318 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.UNREACHABLE ->
            _menhir_run_363 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.TRY ->
            _menhir_run_365 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.THROW ->
            _menhir_run_366 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.RETURN ->
            _menhir_run_369 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.REPEAT ->
            _menhir_run_373 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PRINTLN ->
            _menhir_run_374 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PRINT ->
            _menhir_run_377 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PRAGMA ->
            _menhir_run_380 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PASS ->
            _menhir_run_384 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.MINUS ->
            _menhir_run_386 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LPAR ->
            _menhir_run_387 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LET ->
            _menhir_run_408 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IF ->
            _menhir_run_420 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IDENTIFIER _v ->
            _menhir_run_423 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.FOR ->
            _menhir_run_443 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.DEBUG ->
            _menhir_run_453 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.CONSTANT ->
            _menhir_run_458 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.CASE ->
            _menhir_run_469 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.ASSERT ->
            _menhir_run_477 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | _ ->
            _eRR 864
    
    and _menhir_run_318 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _menhir_stack = MenhirCell1_VAR (_menhir_stack, _menhir_s, _startpos) in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.MINUS ->
            _menhir_run_319 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState318
        | Tokens.LPAR ->
            _menhir_run_320 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState318
        | Tokens.IDENTIFIER _v ->
            let _startpos_0 = _menhir_lexbuf.Lexing.lex_start_p in
            let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.COMMA ->
                let _menhir_stack = MenhirCell1_IDENTIFIER (_menhir_stack, MenhirState318, _v, _startpos_0, _endpos) in
                _menhir_run_332 _menhir_stack _menhir_lexbuf _menhir_lexer
            | Tokens.COLON | Tokens.EQ ->
                let _v =
                  let _1 = _v in
                  _menhir_action_108 _1
                in
                _menhir_run_337 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState318 _tok
            | _ ->
                _eRR 331)
        | _ ->
            _eRR 318
    
    and _menhir_run_319 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
        let _tok = _menhir_lexer _menhir_lexbuf in
        let (_endpos__1_, _startpos__1_, _1) = (_endpos, _startpos, ()) in
        let _v = _menhir_action_107 _1 _endpos__1_ _startpos__1_ in
        _menhir_goto_decl_item _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
    
    and _menhir_goto_decl_item : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
        match _menhir_s with
        | MenhirState458 ->
            _menhir_run_459 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
        | MenhirState408 ->
            _menhir_run_410 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
        | MenhirState318 ->
            _menhir_run_337 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
        | _ ->
            _menhir_fail ()
    
    and _menhir_run_459 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_CONSTANT as 'stack) -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
        let _menhir_stack = MenhirCell1_decl_item (_menhir_stack, _menhir_s, _v) in
        match (_tok : MenhirBasics.token) with
        | Tokens.EQ ->
            let _menhir_stack = MenhirCell1_EQ (_menhir_stack, MenhirState459) in
            let _menhir_s = MenhirState460 in
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.STRING_LIT _v ->
                _menhir_run_002 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | Tokens.REAL_LIT _v ->
                _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | Tokens.NOT ->
                _menhir_run_004 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.MINUS ->
                _menhir_run_005 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.LPAR ->
                _menhir_run_006 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.INT_LIT _v ->
                _menhir_run_007 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | Tokens.IF ->
                _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.IDENTIFIER _v ->
                _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | Tokens.BOOL_LIT _v ->
                _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | Tokens.BNOT ->
                _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.BITVECTOR_LIT _v ->
                _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | Tokens.ARBITRARY ->
                _menhir_run_014 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | _ ->
                _eRR 460)
        | Tokens.COLON ->
            _menhir_run_116 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState459
        | _ ->
            _eRR 459
    
    and _menhir_run_116 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
        let _menhir_stack = MenhirCell1_COLON (_menhir_stack, _menhir_s, _startpos, _endpos) in
        let _menhir_s = MenhirState116 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.STRING ->
            _menhir_run_016 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.REAL ->
            _menhir_run_017 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LPAR ->
            _menhir_run_018 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.INTEGER ->
            _menhir_run_019 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IDENTIFIER _v ->
            _menhir_run_104 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BOOLEAN ->
            _menhir_run_105 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.BITS ->
            _menhir_run_106 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.BIT ->
            _menhir_run_117 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.ARRAY ->
            _menhir_run_118 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | _ ->
            _eRR 116
    
    and _menhir_run_017 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
        let _tok = _menhir_lexer _menhir_lexbuf in
        let (_endpos__1_, _startpos__1_, _1) = (_endpos, _startpos, ()) in
        let _v = _menhir_action_326 _1 _endpos__1_ _startpos__1_ in
        _menhir_goto_ty _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__1_ _v _menhir_s _tok
    
    and _menhir_run_018 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _menhir_stack = MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos) in
        let _menhir_s = MenhirState018 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.STRING ->
            _menhir_run_016 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.REAL ->
            _menhir_run_017 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LPAR ->
            _menhir_run_018 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.INTEGER ->
            _menhir_run_019 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IDENTIFIER _v ->
            _menhir_run_104 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BOOLEAN ->
            _menhir_run_105 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.BITS ->
            _menhir_run_106 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.BIT ->
            _menhir_run_117 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.ARRAY ->
            _menhir_run_118 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | _ ->
            _eRR 18
    
    and _menhir_run_019 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
        let _menhir_stack = MenhirCell1_INTEGER (_menhir_stack, _menhir_s, _startpos) in
        let _menhir_s = MenhirState019 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.LBRACE ->
            _menhir_run_020 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.AND | Tokens.ARROW | Tokens.AS | Tokens.BAND | Tokens.BEGIN | Tokens.BEQ | Tokens.BOR | Tokens.COLON | Tokens.COLON_COLON | Tokens.COMMA | Tokens.DIV | Tokens.DIVRM | Tokens.DO | Tokens.DOT | Tokens.DOWNTO | Tokens.ELSE | Tokens.ELSIF | Tokens.EQ | Tokens.EQ_EQ | Tokens.GE | Tokens.GT | Tokens.IMPL | Tokens.IN | Tokens.LBRACKET | Tokens.LE | Tokens.LLBRACKET | Tokens.LOOPLIMIT | Tokens.LT | Tokens.MINUS | Tokens.MOD | Tokens.MUL | Tokens.NE | Tokens.OF | Tokens.OR | Tokens.PLUS | Tokens.PLUS_COLON | Tokens.PLUS_PLUS | Tokens.POW | Tokens.RBRACE | Tokens.RBRACKET | Tokens.RDIV | Tokens.RECURSELIMIT | Tokens.RPAR | Tokens.RRBRACKET | Tokens.SEMI_COLON | Tokens.SHL | Tokens.SHR | Tokens.SLICING | Tokens.STAR_COLON | Tokens.SUBTYPES | Tokens.THEN | Tokens.TO | Tokens.WHERE | Tokens.XOR ->
            let _v = _menhir_action_066 () in
            _menhir_goto_constraint_kind_opt _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
        | _ ->
            _eRR 19
    
    and _menhir_run_020 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.STRING_LIT _v ->
            let _menhir_stack = MenhirCell1_LBRACE (_menhir_stack, _menhir_s, _startpos) in
            _menhir_run_002 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState020
        | Tokens.REAL_LIT _v ->
            let _menhir_stack = MenhirCell1_LBRACE (_menhir_stack, _menhir_s, _startpos) in
            _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState020
        | Tokens.RBRACE ->
            let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
            let _tok = _menhir_lexer _menhir_lexbuf in
            let (_startpos__1_, _1, _endpos__2_, _2) = (_startpos, (), _endpos, ()) in
            let _v = _menhir_action_064 _1 _2 in
            _menhir_goto_constraint_kind _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__2_ _startpos__1_ _v _menhir_s _tok
        | Tokens.NOT ->
            let _menhir_stack = MenhirCell1_LBRACE (_menhir_stack, _menhir_s, _startpos) in
            _menhir_run_004 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState020
        | Tokens.MINUS ->
            let _startpos_0 = _menhir_lexbuf.Lexing.lex_start_p in
            let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.STRING_LIT _v ->
                let _menhir_stack = MenhirCell1_LBRACE (_menhir_stack, _menhir_s, _startpos) in
                let _menhir_stack = MenhirCell1_MINUS (_menhir_stack, MenhirState020, _startpos_0, _endpos) in
                _menhir_run_002 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState022
            | Tokens.REAL_LIT _v ->
                let _menhir_stack = MenhirCell1_LBRACE (_menhir_stack, _menhir_s, _startpos) in
                let _menhir_stack = MenhirCell1_MINUS (_menhir_stack, MenhirState020, _startpos_0, _endpos) in
                _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState022
            | Tokens.RBRACE ->
                let _endpos_1 = _menhir_lexbuf.Lexing.lex_curr_p in
                let _tok = _menhir_lexer _menhir_lexbuf in
                let (_startpos__1_, x, _endpos__3_) = (_startpos, (), _endpos_1) in
                let _v = _menhir_action_063 _endpos__3_ _startpos__1_ x in
                _menhir_goto_constraint_kind _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__3_ _startpos__1_ _v _menhir_s _tok
            | Tokens.NOT ->
                let _menhir_stack = MenhirCell1_LBRACE (_menhir_stack, _menhir_s, _startpos) in
                let _menhir_stack = MenhirCell1_MINUS (_menhir_stack, MenhirState020, _startpos_0, _endpos) in
                _menhir_run_004 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState022
            | Tokens.MINUS ->
                let _menhir_stack = MenhirCell1_LBRACE (_menhir_stack, _menhir_s, _startpos) in
                let _menhir_stack = MenhirCell1_MINUS (_menhir_stack, MenhirState020, _startpos_0, _endpos) in
                _menhir_run_005 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState022
            | Tokens.LPAR ->
                let _menhir_stack = MenhirCell1_LBRACE (_menhir_stack, _menhir_s, _startpos) in
                let _menhir_stack = MenhirCell1_MINUS (_menhir_stack, MenhirState020, _startpos_0, _endpos) in
                _menhir_run_006 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState022
            | Tokens.INT_LIT _v ->
                let _menhir_stack = MenhirCell1_LBRACE (_menhir_stack, _menhir_s, _startpos) in
                let _menhir_stack = MenhirCell1_MINUS (_menhir_stack, MenhirState020, _startpos_0, _endpos) in
                _menhir_run_007 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState022
            | Tokens.IF ->
                let _menhir_stack = MenhirCell1_LBRACE (_menhir_stack, _menhir_s, _startpos) in
                let _menhir_stack = MenhirCell1_MINUS (_menhir_stack, MenhirState020, _startpos_0, _endpos) in
                _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState022
            | Tokens.IDENTIFIER _v ->
                let _menhir_stack = MenhirCell1_LBRACE (_menhir_stack, _menhir_s, _startpos) in
                let _menhir_stack = MenhirCell1_MINUS (_menhir_stack, MenhirState020, _startpos_0, _endpos) in
                _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState022
            | Tokens.BOOL_LIT _v ->
                let _menhir_stack = MenhirCell1_LBRACE (_menhir_stack, _menhir_s, _startpos) in
                let _menhir_stack = MenhirCell1_MINUS (_menhir_stack, MenhirState020, _startpos_0, _endpos) in
                _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState022
            | Tokens.BNOT ->
                let _menhir_stack = MenhirCell1_LBRACE (_menhir_stack, _menhir_s, _startpos) in
                let _menhir_stack = MenhirCell1_MINUS (_menhir_stack, MenhirState020, _startpos_0, _endpos) in
                _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState022
            | Tokens.BITVECTOR_LIT _v ->
                let _menhir_stack = MenhirCell1_LBRACE (_menhir_stack, _menhir_s, _startpos) in
                let _menhir_stack = MenhirCell1_MINUS (_menhir_stack, MenhirState020, _startpos_0, _endpos) in
                _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState022
            | Tokens.ARBITRARY ->
                let _menhir_stack = MenhirCell1_LBRACE (_menhir_stack, _menhir_s, _startpos) in
                let _menhir_stack = MenhirCell1_MINUS (_menhir_stack, MenhirState020, _startpos_0, _endpos) in
                _menhir_run_014 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState022
            | _ ->
                _eRR 22)
        | Tokens.LPAR ->
            let _menhir_stack = MenhirCell1_LBRACE (_menhir_stack, _menhir_s, _startpos) in
            _menhir_run_006 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState020
        | Tokens.INT_LIT _v ->
            let _menhir_stack = MenhirCell1_LBRACE (_menhir_stack, _menhir_s, _startpos) in
            _menhir_run_007 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState020
        | Tokens.IF ->
            let _menhir_stack = MenhirCell1_LBRACE (_menhir_stack, _menhir_s, _startpos) in
            _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState020
        | Tokens.IDENTIFIER _v ->
            let _menhir_stack = MenhirCell1_LBRACE (_menhir_stack, _menhir_s, _startpos) in
            _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState020
        | Tokens.BOOL_LIT _v ->
            let _menhir_stack = MenhirCell1_LBRACE (_menhir_stack, _menhir_s, _startpos) in
            _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState020
        | Tokens.BNOT ->
            let _menhir_stack = MenhirCell1_LBRACE (_menhir_stack, _menhir_s, _startpos) in
            _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState020
        | Tokens.BITVECTOR_LIT _v ->
            let _menhir_stack = MenhirCell1_LBRACE (_menhir_stack, _menhir_s, _startpos) in
            _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState020
        | Tokens.ARBITRARY ->
            let _menhir_stack = MenhirCell1_LBRACE (_menhir_stack, _menhir_s, _startpos) in
            _menhir_run_014 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState020
        | _ ->
            _eRR 20
    
    and _menhir_goto_constraint_kind : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
        match _menhir_s with
        | MenhirState019 ->
            _menhir_run_288 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
        | MenhirState246 ->
            _menhir_run_248 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _tok
        | MenhirState103 ->
            _menhir_run_133 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _tok
        | _ ->
            _menhir_fail ()
    
    and _menhir_run_288 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_INTEGER -> _ -> _ -> _ -> _ -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
        let (_endpos__1_, _1) = (_endpos, _v) in
        let _v = _menhir_action_065 _1 in
        _menhir_goto_constraint_kind_opt _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__1_ _v _tok
    
    and _menhir_goto_constraint_kind_opt : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_INTEGER -> _ -> _ -> _ -> _ -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
        let MenhirCell1_INTEGER (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
        let (_1, _endpos_c_, c) = ((), _endpos, _v) in
        let _v = _menhir_action_325 _1 _endpos_c_ _startpos__1_ c in
        _menhir_goto_ty _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_c_ _v _menhir_s _tok
    
    and _menhir_run_248 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_expr_pattern, ttv_result) _menhir_cell1_AS -> _ -> _ -> _ -> _ -> _ -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _tok ->
        let MenhirCell1_AS (_menhir_stack, _) = _menhir_stack in
        let MenhirCell1_expr_pattern (_menhir_stack, _menhir_s, expr_pattern, _startpos_expr_pattern_, _) = _menhir_stack in
        let (_2, _endpos_constraint_kind_, _startpos_constraint_kind_, constraint_kind) = ((), _endpos, _startpos, _v) in
        let _v = _menhir_action_207 _2 _endpos_constraint_kind_ _startpos_constraint_kind_ _startpos_expr_pattern_ constraint_kind expr_pattern in
        _menhir_goto_expr_pattern _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_constraint_kind_ _startpos_expr_pattern_ _v _menhir_s _tok
    
    and _menhir_run_133 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_expr, ttv_result) _menhir_cell1_AS -> _ -> _ -> _ -> _ -> _ -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _tok ->
        let MenhirCell1_AS (_menhir_stack, _) = _menhir_stack in
        let MenhirCell1_expr (_menhir_stack, _menhir_s, expr, _startpos_expr_, _) = _menhir_stack in
        let (_2, _endpos_constraint_kind_, _startpos_constraint_kind_, constraint_kind) = ((), _endpos, _startpos, _v) in
        let _v = _menhir_action_161 _2 _endpos_constraint_kind_ _startpos_constraint_kind_ _startpos_expr_ constraint_kind expr in
        _menhir_goto_expr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_constraint_kind_ _startpos_expr_ _v _menhir_s _tok
    
    and _menhir_goto_expr : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
        match _menhir_s with
        | MenhirState887 ->
            _menhir_run_888 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState879 ->
            _menhir_run_880 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState875 ->
            _menhir_run_876 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState780 ->
            _menhir_run_781 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState776 ->
            _menhir_run_777 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState645 ->
            _menhir_run_646 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState591 ->
            _menhir_run_592 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState571 ->
            _menhir_run_572 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState536 ->
            _menhir_run_537 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState525 ->
            _menhir_run_526 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState504 ->
            _menhir_run_505 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState500 ->
            _menhir_run_501 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState493 ->
            _menhir_run_494 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState484 ->
            _menhir_run_485 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState477 ->
            _menhir_run_478 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState474 ->
            _menhir_run_475 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState469 ->
            _menhir_run_470 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState464 ->
            _menhir_run_465 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState460 ->
            _menhir_run_461 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState449 ->
            _menhir_run_450 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState445 ->
            _menhir_run_446 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState420 ->
            _menhir_run_421 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState415 ->
            _menhir_run_416 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState411 ->
            _menhir_run_412 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState390 ->
            _menhir_run_391 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState369 ->
            _menhir_run_372 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState366 ->
            _menhir_run_367 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState343 ->
            _menhir_run_356 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState338 ->
            _menhir_run_339 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState314 ->
            _menhir_run_315 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState001 ->
            _menhir_run_313 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState004 ->
            _menhir_run_312 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState006 ->
            _menhir_run_306 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState303 ->
            _menhir_run_304 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState008 ->
            _menhir_run_302 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState012 ->
            _menhir_run_299 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState282 ->
            _menhir_run_283 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState020 ->
            _menhir_run_281 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState280 ->
            _menhir_run_281 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState273 ->
            _menhir_run_274 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState271 ->
            _menhir_run_272 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState269 ->
            _menhir_run_270 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState034 ->
            _menhir_run_268 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState267 ->
            _menhir_run_268 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState171 ->
            _menhir_run_255 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState249 ->
            _menhir_run_250 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState244 ->
            _menhir_run_245 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState242 ->
            _menhir_run_243 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState240 ->
            _menhir_run_241 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState238 ->
            _menhir_run_239 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState236 ->
            _menhir_run_237 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState234 ->
            _menhir_run_235 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState226 ->
            _menhir_run_228 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState224 ->
            _menhir_run_225 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState222 ->
            _menhir_run_223 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState220 ->
            _menhir_run_221 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState215 ->
            _menhir_run_216 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState212 ->
            _menhir_run_213 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState210 ->
            _menhir_run_211 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState208 ->
            _menhir_run_209 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState206 ->
            _menhir_run_207 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState204 ->
            _menhir_run_205 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState201 ->
            _menhir_run_203 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState199 ->
            _menhir_run_200 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState197 ->
            _menhir_run_198 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState195 ->
            _menhir_run_196 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState193 ->
            _menhir_run_194 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState191 ->
            _menhir_run_192 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState189 ->
            _menhir_run_190 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState187 ->
            _menhir_run_188 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState185 ->
            _menhir_run_186 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState183 ->
            _menhir_run_184 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState169 ->
            _menhir_run_170 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState740 ->
            _menhir_run_156 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState454 ->
            _menhir_run_156 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState424 ->
            _menhir_run_156 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState381 ->
            _menhir_run_156 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState377 ->
            _menhir_run_156 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState374 ->
            _menhir_run_156 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState345 ->
            _menhir_run_156 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState353 ->
            _menhir_run_156 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState350 ->
            _menhir_run_156 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState347 ->
            _menhir_run_156 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState308 ->
            _menhir_run_156 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState010 ->
            _menhir_run_156 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState143 ->
            _menhir_run_156 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState163 ->
            _menhir_run_156 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState157 ->
            _menhir_run_156 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState147 ->
            _menhir_run_156 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState153 ->
            _menhir_run_154 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState139 ->
            _menhir_run_140 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState136 ->
            _menhir_run_137 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState134 ->
            _menhir_run_135 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState119 ->
            _menhir_run_120 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState107 ->
            _menhir_run_108 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState101 ->
            _menhir_run_102 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState099 ->
            _menhir_run_100 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState097 ->
            _menhir_run_098 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState094 ->
            _menhir_run_096 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState092 ->
            _menhir_run_093 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState090 ->
            _menhir_run_091 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState088 ->
            _menhir_run_089 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState086 ->
            _menhir_run_087 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState084 ->
            _menhir_run_085 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState082 ->
            _menhir_run_083 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState080 ->
            _menhir_run_081 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState078 ->
            _menhir_run_079 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState075 ->
            _menhir_run_077 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState073 ->
            _menhir_run_074 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState071 ->
            _menhir_run_072 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState069 ->
            _menhir_run_070 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState067 ->
            _menhir_run_068 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState065 ->
            _menhir_run_066 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState063 ->
            _menhir_run_064 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState061 ->
            _menhir_run_062 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState059 ->
            _menhir_run_060 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState057 ->
            _menhir_run_058 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState053 ->
            _menhir_run_054 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState041 ->
            _menhir_run_042 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState037 ->
            _menhir_run_038 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState035 ->
            _menhir_run_036 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState032 ->
            _menhir_run_033 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState030 ->
            _menhir_run_031 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState028 ->
            _menhir_run_029 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState026 ->
            _menhir_run_027 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState005 ->
            _menhir_run_025 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState148 ->
            _menhir_run_025 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState144 ->
            _menhir_run_025 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState022 ->
            _menhir_run_025 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | _ ->
            _menhir_fail ()
    
    and _menhir_run_888 : type  ttv_stack. ((((ttv_stack, _menhir_box_spec) _menhir_cell1_CONFIG, _menhir_box_spec) _menhir_cell1_ignored_or_identifier, _menhir_box_spec) _menhir_cell1_as_ty as 'stack) -> _ -> _ -> _ -> _ -> _ -> ('stack, _menhir_box_spec) _menhir_state -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
        match (_tok : MenhirBasics.token) with
        | Tokens.XOR ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_028 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState888
        | Tokens.SHR ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_030 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState888
        | Tokens.SHL ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_037 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState888
        | Tokens.SEMI_COLON ->
            let _endpos_0 = _menhir_lexbuf.Lexing.lex_curr_p in
            let _tok = _menhir_lexer _menhir_lexbuf in
            let MenhirCell1_as_ty (_menhir_stack, _, ty) = _menhir_stack in
            let MenhirCell1_ignored_or_identifier (_menhir_stack, _, name) = _menhir_stack in
            let MenhirCell1_CONFIG (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
            let (_1, _endpos__2_, x, _4) = ((), _endpos_0, _v, ()) in
            let _v = _menhir_action_096 _1 _4 _endpos__2_ _startpos__1_ name ty x in
            _menhir_goto_decl _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
        | Tokens.RDIV ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_059 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState888
        | Tokens.POW ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_032 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState888
        | Tokens.PLUS_PLUS ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_061 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState888
        | Tokens.PLUS ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_071 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState888
        | Tokens.OR ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_073 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState888
        | Tokens.NE ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_075 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState888
        | Tokens.MUL ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_063 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState888
        | Tokens.MOD ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_065 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState888
        | Tokens.MINUS ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_078 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState888
        | Tokens.LT ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_080 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState888
        | Tokens.LLBRACKET ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_026 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState888
        | Tokens.LE ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_086 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState888
        | Tokens.LBRACKET ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_034 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState888
        | Tokens.IN ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_039 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState888
        | Tokens.IMPL ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_092 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState888
        | Tokens.GT ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_088 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState888
        | Tokens.GE ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_090 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState888
        | Tokens.EQ_EQ ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_094 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState888
        | Tokens.DOT ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_043 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState888
        | Tokens.DIVRM ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_067 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState888
        | Tokens.DIV ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_069 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState888
        | Tokens.COLON_COLON ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_082 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState888
        | Tokens.BOR ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_097 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState888
        | Tokens.BEQ ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_099 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState888
        | Tokens.BAND ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_101 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState888
        | Tokens.AS ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_103 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState888
        | Tokens.AND ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_084 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState888
        | _ ->
            _eRR 888
    
    and _menhir_run_028 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_expr as 'stack) -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _menhir_stack = MenhirCell1_XOR (_menhir_stack, _menhir_s) in
        let _menhir_s = MenhirState028 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.STRING_LIT _v ->
            _menhir_run_002 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.REAL_LIT _v ->
            _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.NOT ->
            _menhir_run_004 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.MINUS ->
            _menhir_run_005 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LPAR ->
            _menhir_run_006 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.INT_LIT _v ->
            _menhir_run_007 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.IF ->
            _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IDENTIFIER _v ->
            _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BOOL_LIT _v ->
            _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BNOT ->
            _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.BITVECTOR_LIT _v ->
            _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.ARBITRARY ->
            _menhir_run_014 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | _ ->
            _eRR 28
    
    and _menhir_run_030 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_expr as 'stack) -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _menhir_stack = MenhirCell1_SHR (_menhir_stack, _menhir_s) in
        let _menhir_s = MenhirState030 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.STRING_LIT _v ->
            _menhir_run_002 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.REAL_LIT _v ->
            _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.NOT ->
            _menhir_run_004 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.MINUS ->
            _menhir_run_005 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LPAR ->
            _menhir_run_006 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.INT_LIT _v ->
            _menhir_run_007 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.IF ->
            _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IDENTIFIER _v ->
            _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BOOL_LIT _v ->
            _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BNOT ->
            _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.BITVECTOR_LIT _v ->
            _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.ARBITRARY ->
            _menhir_run_014 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | _ ->
            _eRR 30
    
    and _menhir_run_037 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_expr as 'stack) -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _menhir_stack = MenhirCell1_SHL (_menhir_stack, _menhir_s) in
        let _menhir_s = MenhirState037 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.STRING_LIT _v ->
            _menhir_run_002 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.REAL_LIT _v ->
            _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.NOT ->
            _menhir_run_004 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.MINUS ->
            _menhir_run_005 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LPAR ->
            _menhir_run_006 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.INT_LIT _v ->
            _menhir_run_007 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.IF ->
            _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IDENTIFIER _v ->
            _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BOOL_LIT _v ->
            _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BNOT ->
            _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.BITVECTOR_LIT _v ->
            _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.ARBITRARY ->
            _menhir_run_014 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | _ ->
            _eRR 37
    
    and _menhir_goto_decl : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> (ttv_stack, _menhir_box_spec) _menhir_state -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
        let _menhir_stack = MenhirCell1_decl (_menhir_stack, _menhir_s, _v) in
        match (_tok : MenhirBasics.token) with
        | Tokens.VAR ->
            _menhir_run_567 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState906
        | Tokens.TYPE ->
            _menhir_run_599 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState906
        | Tokens.READONLY ->
            _menhir_run_624 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState906
        | Tokens.PURE ->
            _menhir_run_691 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState906
        | Tokens.PRAGMA ->
            _menhir_run_739 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState906
        | Tokens.NORETURN ->
            _menhir_run_743 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState906
        | Tokens.LET ->
            _menhir_run_773 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState906
        | Tokens.IMPLEMENTATION ->
            _menhir_run_785 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState906
        | Tokens.IMPDEF ->
            _menhir_run_831 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState906
        | Tokens.FUNC ->
            _menhir_run_858 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState906
        | Tokens.CONSTANT ->
            _menhir_run_873 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState906
        | Tokens.CONFIG ->
            _menhir_run_884 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState906
        | Tokens.ACCESSOR ->
            _menhir_run_892 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState906
        | Tokens.EOF ->
            let _v_0 = _menhir_action_230 () in
            _menhir_run_907 _menhir_stack _v_0
        | _ ->
            _eRR 906
    
    and _menhir_run_567 : type  ttv_stack. ttv_stack -> _ -> _ -> (ttv_stack, _menhir_box_spec) _menhir_state -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _menhir_stack = MenhirCell1_VAR (_menhir_stack, _menhir_s, _startpos) in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.MINUS ->
            _menhir_run_568 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState567
        | Tokens.IDENTIFIER _v ->
            let _startpos_0 = _menhir_lexbuf.Lexing.lex_start_p in
            let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.COMMA ->
                let _menhir_stack = MenhirCell1_IDENTIFIER (_menhir_stack, MenhirState567, _v, _startpos_0, _endpos) in
                _menhir_run_332 _menhir_stack _menhir_lexbuf _menhir_lexer
            | Tokens.COLON | Tokens.EQ ->
                let _v =
                  let _1 = _v in
                  _menhir_action_220 _1
                in
                _menhir_run_570 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState567 _tok
            | _ ->
                _eRR 569)
        | _ ->
            _eRR 567
    
    and _menhir_run_568 : type  ttv_stack. ttv_stack -> _ -> _ -> (ttv_stack, _menhir_box_spec) _menhir_state -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
        let _tok = _menhir_lexer _menhir_lexbuf in
        let (_endpos__1_, _startpos__1_, _1) = (_endpos, _startpos, ()) in
        let _v = _menhir_action_219 _1 _endpos__1_ _startpos__1_ in
        _menhir_goto_ignored_or_identifier _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
    
    and _menhir_goto_ignored_or_identifier : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> (ttv_stack, _menhir_box_spec) _menhir_state -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
        match _menhir_s with
        | MenhirState884 ->
            _menhir_run_885 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
        | MenhirState873 ->
            _menhir_run_874 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
        | MenhirState773 ->
            _menhir_run_775 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
        | MenhirState567 ->
            _menhir_run_570 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
        | _ ->
            _menhir_fail ()
    
    and _menhir_run_885 : type  ttv_stack. ((ttv_stack, _menhir_box_spec) _menhir_cell1_CONFIG as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_spec) _menhir_state -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
        let _menhir_stack = MenhirCell1_ignored_or_identifier (_menhir_stack, _menhir_s, _v) in
        match (_tok : MenhirBasics.token) with
        | Tokens.COLON ->
            _menhir_run_116 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState885
        | _ ->
            _eRR 885
    
    and _menhir_run_874 : type  ttv_stack. ((ttv_stack, _menhir_box_spec) _menhir_cell1_CONSTANT as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_spec) _menhir_state -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
        let _menhir_stack = MenhirCell1_ignored_or_identifier (_menhir_stack, _menhir_s, _v) in
        match (_tok : MenhirBasics.token) with
        | Tokens.EQ ->
            let _menhir_stack = MenhirCell1_EQ (_menhir_stack, MenhirState874) in
            let _menhir_s = MenhirState875 in
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.STRING_LIT _v ->
                _menhir_run_002 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | Tokens.REAL_LIT _v ->
                _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | Tokens.NOT ->
                _menhir_run_004 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.MINUS ->
                _menhir_run_005 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.LPAR ->
                _menhir_run_006 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.INT_LIT _v ->
                _menhir_run_007 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | Tokens.IF ->
                _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.IDENTIFIER _v ->
                _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | Tokens.BOOL_LIT _v ->
                _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | Tokens.BNOT ->
                _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.BITVECTOR_LIT _v ->
                _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | Tokens.ARBITRARY ->
                _menhir_run_014 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | _ ->
                _eRR 875)
        | Tokens.COLON ->
            _menhir_run_116 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState874
        | _ ->
            _eRR 874
    
    and _menhir_run_775 : type  ttv_stack. ((ttv_stack, _menhir_box_spec) _menhir_cell1_LET as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_spec) _menhir_state -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
        let _menhir_stack = MenhirCell1_ignored_or_identifier (_menhir_stack, _menhir_s, _v) in
        match (_tok : MenhirBasics.token) with
        | Tokens.EQ ->
            let _menhir_stack = MenhirCell1_EQ (_menhir_stack, MenhirState775) in
            let _menhir_s = MenhirState776 in
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.STRING_LIT _v ->
                _menhir_run_002 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | Tokens.REAL_LIT _v ->
                _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | Tokens.NOT ->
                _menhir_run_004 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.MINUS ->
                _menhir_run_005 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.LPAR ->
                _menhir_run_006 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.INT_LIT _v ->
                _menhir_run_007 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | Tokens.IF ->
                _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.IDENTIFIER _v ->
                _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | Tokens.BOOL_LIT _v ->
                _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | Tokens.BNOT ->
                _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.BITVECTOR_LIT _v ->
                _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | Tokens.ARBITRARY ->
                _menhir_run_014 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | _ ->
                _eRR 776)
        | Tokens.COLON ->
            _menhir_run_116 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState775
        | _ ->
            _eRR 775
    
    and _menhir_run_570 : type  ttv_stack. ((ttv_stack, _menhir_box_spec) _menhir_cell1_VAR as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_spec) _menhir_state -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
        let _menhir_stack = MenhirCell1_ignored_or_identifier (_menhir_stack, _menhir_s, _v) in
        match (_tok : MenhirBasics.token) with
        | Tokens.EQ ->
            let _menhir_stack = MenhirCell1_EQ (_menhir_stack, MenhirState570) in
            let _menhir_s = MenhirState571 in
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.STRING_LIT _v ->
                _menhir_run_002 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | Tokens.REAL_LIT _v ->
                _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | Tokens.NOT ->
                _menhir_run_004 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.MINUS ->
                _menhir_run_005 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.LPAR ->
                _menhir_run_006 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.INT_LIT _v ->
                _menhir_run_007 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | Tokens.IF ->
                _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.IDENTIFIER _v ->
                _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | Tokens.BOOL_LIT _v ->
                _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | Tokens.BNOT ->
                _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.BITVECTOR_LIT _v ->
                _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | Tokens.ARBITRARY ->
                _menhir_run_014 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | _ ->
                _eRR 571)
        | Tokens.COLON ->
            let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
            let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
            let _menhir_stack = MenhirCell1_COLON (_menhir_stack, MenhirState570, _startpos, _endpos) in
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.STRING ->
                _menhir_run_016 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState574
            | Tokens.REAL ->
                _menhir_run_017 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState574
            | Tokens.LPAR ->
                _menhir_run_018 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState574
            | Tokens.INTEGER ->
                _menhir_run_019 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState574
            | Tokens.IDENTIFIER _v_6 ->
                _menhir_run_104 _menhir_stack _menhir_lexbuf _menhir_lexer _v_6 MenhirState574
            | Tokens.COLLECTION ->
                let _startpos_7 = _menhir_lexbuf.Lexing.lex_start_p in
                let _endpos_8 = _menhir_lexbuf.Lexing.lex_curr_p in
                let _tok = _menhir_lexer _menhir_lexbuf in
                (match (_tok : MenhirBasics.token) with
                | Tokens.LBRACE ->
                    let _menhir_stack = MenhirCell1_COLLECTION (_menhir_stack, MenhirState574, _startpos_7, _endpos_8) in
                    _menhir_run_576 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState575
                | Tokens.SEMI_COLON ->
                    let (_endpos__1_, _startpos__1_, _1) = (_endpos_8, _startpos_7, ()) in
                    let _v = _menhir_action_341 _1 _endpos__1_ _startpos__1_ in
                    _menhir_goto_ty_or_collection _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
                | _ ->
                    _eRR 575)
            | Tokens.BOOLEAN ->
                _menhir_run_105 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState574
            | Tokens.BITS ->
                _menhir_run_106 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState574
            | Tokens.BIT ->
                _menhir_run_117 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState574
            | Tokens.ARRAY ->
                _menhir_run_118 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState574
            | _ ->
                _eRR 574)
        | _ ->
            _eRR 570
    
    and _menhir_run_104 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
        let _tok = _menhir_lexer _menhir_lexbuf in
        let (_endpos_name_, _startpos_name_, name) = (_endpos, _startpos, _v) in
        let _v = _menhir_action_332 _endpos_name_ _startpos_name_ name in
        _menhir_goto_ty _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_name_ _v _menhir_s _tok
    
    and _menhir_run_576 : type  ttv_stack. ttv_stack -> _ -> _ -> (ttv_stack, _menhir_box_spec) _menhir_state -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.MINUS ->
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.RBRACE ->
                let _endpos_1 = _menhir_lexbuf.Lexing.lex_curr_p in
                let _tok = _menhir_lexer _menhir_lexbuf in
                let (x, _endpos__3_) = ((), _endpos_1) in
                let _v = _menhir_action_216 x in
                _menhir_goto_fields _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__3_ _v _menhir_s _tok
            | _ ->
                _eRR 577)
        | Tokens.IDENTIFIER _v ->
            let _menhir_stack = MenhirCell1_LBRACE (_menhir_stack, _menhir_s, _startpos) in
            _menhir_run_579 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState576
        | _ ->
            _eRR 576
    
    and _menhir_goto_fields : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_spec) _menhir_state -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok ->
        match _menhir_s with
        | MenhirState608 ->
            _menhir_run_609 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
        | MenhirState606 ->
            _menhir_run_607 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
        | MenhirState603 ->
            _menhir_run_604 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
        | MenhirState575 ->
            _menhir_run_586 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
        | _ ->
            _menhir_fail ()
    
    and _menhir_run_609 : type  ttv_stack. (((ttv_stack, _menhir_box_spec) _menhir_cell1_TYPE _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_OF, _menhir_box_spec) _menhir_cell1_EXCEPTION -> _ -> _ -> _ -> _ -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
        let MenhirCell1_EXCEPTION (_menhir_stack, _menhir_s, _startpos__1_, _) = _menhir_stack in
        let (_1, _endpos_l_, l) = ((), _endpos, _v) in
        let _v = _menhir_action_339 _1 _endpos_l_ _startpos__1_ l in
        _menhir_goto_ty_decl _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
    
    and _menhir_goto_ty_decl : type  ttv_stack. (((ttv_stack, _menhir_box_spec) _menhir_cell1_TYPE _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_OF as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_spec) _menhir_state -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
        let _menhir_stack = MenhirCell1_ty_decl (_menhir_stack, _menhir_s, _v) in
        match (_tok : MenhirBasics.token) with
        | Tokens.SUBTYPES ->
            _menhir_run_601 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState617
        | Tokens.SEMI_COLON ->
            let _v = _menhir_action_311 () in
            _menhir_goto_subtype_opt _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
        | _ ->
            _eRR 617
    
    and _menhir_run_601 : type  ttv_stack. ttv_stack -> _ -> _ -> (ttv_stack, _menhir_box_spec) _menhir_state -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.IDENTIFIER _v ->
            let _startpos_0 = _menhir_lexbuf.Lexing.lex_start_p in
            let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.WITH ->
                let _menhir_stack = MenhirCell1_SUBTYPES (_menhir_stack, _menhir_s, _startpos) in
                let _menhir_stack = MenhirCell0_IDENTIFIER (_menhir_stack, _v, _startpos_0, _endpos) in
                let _menhir_s = MenhirState603 in
                let _tok = _menhir_lexer _menhir_lexbuf in
                (match (_tok : MenhirBasics.token) with
                | Tokens.LBRACE ->
                    _menhir_run_576 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
                | _ ->
                    _eRR 603)
            | Tokens.SEMI_COLON ->
                let (_startpos__1_, _1, _endpos__2_, _2) = (_startpos, (), _endpos, _v) in
                let _v = _menhir_action_309 _1 _2 in
                _menhir_goto_subtype _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__2_ _startpos__1_ _v _menhir_s _tok
            | _ ->
                _eRR 602)
        | _ ->
            _eRR 601
    
    and _menhir_goto_subtype : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_spec) _menhir_state -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
        match _menhir_s with
        | MenhirState600 ->
            _menhir_run_622 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _tok
        | MenhirState617 ->
            _menhir_run_620 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
        | _ ->
            _menhir_fail ()
    
    and _menhir_run_622 : type  ttv_stack. (ttv_stack, _menhir_box_spec) _menhir_cell1_TYPE _menhir_cell0_IDENTIFIER -> _ -> _ -> _ -> _ -> _ -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _tok ->
        match (_tok : MenhirBasics.token) with
        | Tokens.SEMI_COLON ->
            let _endpos_0 = _menhir_lexbuf.Lexing.lex_curr_p in
            let _tok = _menhir_lexer _menhir_lexbuf in
            let MenhirCell0_IDENTIFIER (_menhir_stack, x, _, _) = _menhir_stack in
            let MenhirCell1_TYPE (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
            let (_1, _endpos__2_, _endpos_desc_, _startpos_desc_, desc) = ((), _endpos_0, _endpos, _startpos, _v) in
            let _v = _menhir_action_089 _1 _endpos__2_ _endpos_desc_ _startpos__1_ _startpos_desc_ desc x in
            _menhir_goto_decl _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
        | _ ->
            _eRR 622
    
    and _menhir_run_620 : type  ttv_stack. (((ttv_stack, _menhir_box_spec) _menhir_cell1_TYPE _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_OF, _menhir_box_spec) _menhir_cell1_ty_decl -> _ -> _ -> _ -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
        let x = _v in
        let _v = _menhir_action_312 x in
        _menhir_goto_subtype_opt _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
    
    and _menhir_goto_subtype_opt : type  ttv_stack. (((ttv_stack, _menhir_box_spec) _menhir_cell1_TYPE _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_OF, _menhir_box_spec) _menhir_cell1_ty_decl -> _ -> _ -> _ -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
        match (_tok : MenhirBasics.token) with
        | Tokens.SEMI_COLON ->
            let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
            let _tok = _menhir_lexer _menhir_lexbuf in
            let MenhirCell1_ty_decl (_menhir_stack, _, t) = _menhir_stack in
            let MenhirCell1_OF (_menhir_stack, _) = _menhir_stack in
            let MenhirCell0_IDENTIFIER (_menhir_stack, x, _, _) = _menhir_stack in
            let MenhirCell1_TYPE (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
            let (_1, _endpos__2_, _3, subtype_opt) = ((), _endpos, (), _v) in
            let _v = _menhir_action_088 _1 _3 _endpos__2_ _startpos__1_ subtype_opt t x in
            _menhir_goto_decl _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
        | _ ->
            _eRR 618
    
    and _menhir_run_607 : type  ttv_stack. (((ttv_stack, _menhir_box_spec) _menhir_cell1_TYPE _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_OF, _menhir_box_spec) _menhir_cell1_RECORD -> _ -> _ -> _ -> _ -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
        let MenhirCell1_RECORD (_menhir_stack, _menhir_s, _startpos__1_, _) = _menhir_stack in
        let (_1, _endpos_l_, l) = ((), _endpos, _v) in
        let _v = _menhir_action_338 _1 _endpos_l_ _startpos__1_ l in
        _menhir_goto_ty_decl _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
    
    and _menhir_run_604 : type  ttv_stack. (ttv_stack, _menhir_box_spec) _menhir_cell1_SUBTYPES _menhir_cell0_IDENTIFIER -> _ -> _ -> _ -> _ -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
        let MenhirCell0_IDENTIFIER (_menhir_stack, _2, _, _) = _menhir_stack in
        let MenhirCell1_SUBTYPES (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
        let (_1, _1_inlined1, _endpos_fields_, fields) = ((), (), _endpos, _v) in
        let _v = _menhir_action_310 _1 _1_inlined1 _2 fields in
        _menhir_goto_subtype _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_fields_ _startpos__1_ _v _menhir_s _tok
    
    and _menhir_run_586 : type  ttv_stack. ((((ttv_stack, _menhir_box_spec) _menhir_cell1_VAR, _menhir_box_spec) _menhir_cell1_ignored_or_identifier, _menhir_box_spec) _menhir_cell1_COLON, _menhir_box_spec) _menhir_cell1_COLLECTION -> _ -> _ -> _ -> _ -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
        let MenhirCell1_COLLECTION (_menhir_stack, _, _startpos__1_, _) = _menhir_stack in
        let (_1, _endpos_l_, l) = ((), _endpos, _v) in
        let _v = _menhir_action_342 _1 _endpos_l_ _startpos__1_ l in
        _menhir_goto_ty_or_collection _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
    
    and _menhir_goto_ty_or_collection : type  ttv_stack. (((ttv_stack, _menhir_box_spec) _menhir_cell1_VAR, _menhir_box_spec) _menhir_cell1_ignored_or_identifier, _menhir_box_spec) _menhir_cell1_COLON -> _ -> _ -> _ -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
        match (_tok : MenhirBasics.token) with
        | Tokens.SEMI_COLON ->
            let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
            let _tok = _menhir_lexer _menhir_lexbuf in
            let MenhirCell1_COLON (_menhir_stack, _, _, _) = _menhir_stack in
            let MenhirCell1_ignored_or_identifier (_menhir_stack, _, name) = _menhir_stack in
            let MenhirCell1_VAR (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
            let (_1, _endpos__2_, x, _3) = ((), _endpos, _v, ()) in
            let _v = _menhir_action_101 _1 _3 _endpos__2_ _startpos__1_ name x in
            _menhir_goto_decl _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
        | _ ->
            _eRR 587
    
    and _menhir_run_579 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> (ttv_stack, _menhir_box_spec) _menhir_state -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
        let _menhir_stack = MenhirCell1_IDENTIFIER (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
        let _menhir_s = MenhirState579 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.COLON ->
            _menhir_run_116 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | _ ->
            _eRR 579
    
    and _menhir_run_105 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
        let _tok = _menhir_lexer _menhir_lexbuf in
        let (_endpos__1_, _startpos__1_, _1) = (_endpos, _startpos, ()) in
        let _v = _menhir_action_327 _1 _endpos__1_ _startpos__1_ in
        _menhir_goto_ty _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__1_ _v _menhir_s _tok
    
    and _menhir_run_106 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _menhir_stack = MenhirCell1_BITS (_menhir_stack, _menhir_s, _startpos) in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.LPAR ->
            let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
            let _menhir_stack = MenhirCell0_LPAR (_menhir_stack, _startpos) in
            let _menhir_s = MenhirState107 in
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.STRING_LIT _v ->
                _menhir_run_002 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | Tokens.REAL_LIT _v ->
                _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | Tokens.NOT ->
                _menhir_run_004 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.MINUS ->
                _menhir_run_005 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.LPAR ->
                _menhir_run_006 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.INT_LIT _v ->
                _menhir_run_007 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | Tokens.IF ->
                _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.IDENTIFIER _v ->
                _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | Tokens.BOOL_LIT _v ->
                _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | Tokens.BNOT ->
                _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.BITVECTOR_LIT _v ->
                _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | Tokens.ARBITRARY ->
                _menhir_run_014 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | _ ->
                _eRR 107)
        | _ ->
            _eRR 106
    
    and _menhir_run_117 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
        let _tok = _menhir_lexer _menhir_lexbuf in
        let (_endpos_desc_, _startpos_desc_, desc) = (_endpos, _startpos, ()) in
        let _v = _menhir_action_329 _endpos_desc_ _startpos_desc_ desc in
        _menhir_goto_ty _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_desc_ _v _menhir_s _tok
    
    and _menhir_run_118 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _menhir_stack = MenhirCell1_ARRAY (_menhir_stack, _menhir_s, _startpos) in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.LLBRACKET ->
            let _menhir_s = MenhirState119 in
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.STRING_LIT _v ->
                _menhir_run_002 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | Tokens.REAL_LIT _v ->
                _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | Tokens.NOT ->
                _menhir_run_004 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.MINUS ->
                _menhir_run_005 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.LPAR ->
                _menhir_run_006 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.INT_LIT _v ->
                _menhir_run_007 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | Tokens.IF ->
                _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.IDENTIFIER _v ->
                _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | Tokens.BOOL_LIT _v ->
                _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | Tokens.BNOT ->
                _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.BITVECTOR_LIT _v ->
                _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | Tokens.ARBITRARY ->
                _menhir_run_014 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | _ ->
                _eRR 119)
        | _ ->
            _eRR 118
    
    and _menhir_run_332 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_VAR, ttv_result) _menhir_cell1_IDENTIFIER -> _ -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer ->
        let _menhir_s = MenhirState332 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.IDENTIFIER _v ->
            _menhir_run_333 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | _ ->
            _eRR 332
    
    and _menhir_run_333 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_IDENTIFIER as 'stack) -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.COMMA ->
            let _menhir_stack = MenhirCell1_IDENTIFIER (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            let _menhir_s = MenhirState334 in
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.IDENTIFIER _v ->
                _menhir_run_333 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | _ ->
                _eRR 334)
        | Tokens.COLON ->
            let (_endpos_desc_, _startpos_desc_, desc) = (_endpos, _startpos, _v) in
            let _v = _menhir_action_030 _endpos_desc_ _startpos_desc_ desc in
            _menhir_goto_clist1_annotated_IDENTIFIER__ _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | _ ->
            _eRR 333
    
    and _menhir_goto_clist1_annotated_IDENTIFIER__ : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_IDENTIFIER as 'stack) -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
        match _menhir_s with
        | MenhirState332 ->
            _menhir_run_336 _menhir_stack _menhir_lexbuf _menhir_lexer _v
        | MenhirState334 ->
            _menhir_run_335 _menhir_stack _menhir_lexbuf _menhir_lexer _v
        | _ ->
            _menhir_fail ()
    
    and _menhir_run_336 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_VAR, ttv_result) _menhir_cell1_IDENTIFIER -> _ -> _ -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v ->
        let MenhirCell1_IDENTIFIER (_menhir_stack, _menhir_s, desc, _startpos_desc_, _endpos_desc_) = _menhir_stack in
        let (_2, li) = ((), _v) in
        let _v = _menhir_action_055 _2 _endpos_desc_ _startpos_desc_ desc li in
        _menhir_goto_clist2_annotated_IDENTIFIER__ _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
    
    and _menhir_goto_clist2_annotated_IDENTIFIER__ : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_VAR as 'stack) -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
        match _menhir_s with
        | MenhirState567 ->
            _menhir_run_596 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | MenhirState318 ->
            _menhir_run_360 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | _ ->
            _menhir_fail ()
    
    and _menhir_run_596 : type  ttv_stack. ((ttv_stack, _menhir_box_spec) _menhir_cell1_VAR as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_spec) _menhir_state -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
        let _menhir_stack = MenhirCell1_clist2_annotated_IDENTIFIER__ (_menhir_stack, _menhir_s, _v) in
        _menhir_run_116 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState596
    
    and _menhir_run_360 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_VAR as 'stack) -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
        let _menhir_stack = MenhirCell1_clist2_annotated_IDENTIFIER__ (_menhir_stack, _menhir_s, _v) in
        _menhir_run_116 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState360
    
    and _menhir_run_335 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_IDENTIFIER, ttv_result) _menhir_cell1_IDENTIFIER -> _ -> _ -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v ->
        let MenhirCell1_IDENTIFIER (_menhir_stack, _menhir_s, desc, _startpos_desc_, _endpos_desc_) = _menhir_stack in
        let (_2, t) = ((), _v) in
        let _v = _menhir_action_031 _2 _endpos_desc_ _startpos_desc_ desc t in
        _menhir_goto_clist1_annotated_IDENTIFIER__ _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
    
    and _menhir_run_599 : type  ttv_stack. ttv_stack -> _ -> _ -> (ttv_stack, _menhir_box_spec) _menhir_state -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _menhir_stack = MenhirCell1_TYPE (_menhir_stack, _menhir_s, _startpos) in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.IDENTIFIER _v ->
            let _startpos_0 = _menhir_lexbuf.Lexing.lex_start_p in
            let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
            let _menhir_stack = MenhirCell0_IDENTIFIER (_menhir_stack, _v, _startpos_0, _endpos) in
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.SUBTYPES ->
                _menhir_run_601 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState600
            | Tokens.OF ->
                let _menhir_stack = MenhirCell1_OF (_menhir_stack, MenhirState600) in
                let _tok = _menhir_lexer _menhir_lexbuf in
                (match (_tok : MenhirBasics.token) with
                | Tokens.STRING ->
                    _menhir_run_016 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState605
                | Tokens.RECORD ->
                    let _startpos_1 = _menhir_lexbuf.Lexing.lex_start_p in
                    let _endpos_2 = _menhir_lexbuf.Lexing.lex_curr_p in
                    let _tok = _menhir_lexer _menhir_lexbuf in
                    (match (_tok : MenhirBasics.token) with
                    | Tokens.LBRACE ->
                        let _menhir_stack = MenhirCell1_RECORD (_menhir_stack, MenhirState605, _startpos_1, _endpos_2) in
                        _menhir_run_576 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState606
                    | Tokens.SEMI_COLON | Tokens.SUBTYPES ->
                        let (_menhir_s, _endpos__1_, _startpos__1_, _1) = (MenhirState605, _endpos_2, _startpos_1, ()) in
                        let _v = _menhir_action_336 _1 _endpos__1_ _startpos__1_ in
                        _menhir_goto_ty_decl _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
                    | _ ->
                        _eRR 606)
                | Tokens.REAL ->
                    _menhir_run_017 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState605
                | Tokens.LPAR ->
                    _menhir_run_018 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState605
                | Tokens.INTEGER ->
                    _menhir_run_019 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState605
                | Tokens.IDENTIFIER _v_4 ->
                    _menhir_run_104 _menhir_stack _menhir_lexbuf _menhir_lexer _v_4 MenhirState605
                | Tokens.EXCEPTION ->
                    let _startpos_5 = _menhir_lexbuf.Lexing.lex_start_p in
                    let _endpos_6 = _menhir_lexbuf.Lexing.lex_curr_p in
                    let _tok = _menhir_lexer _menhir_lexbuf in
                    (match (_tok : MenhirBasics.token) with
                    | Tokens.LBRACE ->
                        let _menhir_stack = MenhirCell1_EXCEPTION (_menhir_stack, MenhirState605, _startpos_5, _endpos_6) in
                        _menhir_run_576 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState608
                    | Tokens.SEMI_COLON | Tokens.SUBTYPES ->
                        let (_menhir_s, _endpos__1_, _startpos__1_, _1) = (MenhirState605, _endpos_6, _startpos_5, ()) in
                        let _v = _menhir_action_337 _1 _endpos__1_ _startpos__1_ in
                        _menhir_goto_ty_decl _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
                    | _ ->
                        _eRR 608)
                | Tokens.ENUMERATION ->
                    let _menhir_s = MenhirState605 in
                    let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
                    let _menhir_stack = MenhirCell1_ENUMERATION (_menhir_stack, _menhir_s, _startpos) in
                    let _tok = _menhir_lexer _menhir_lexbuf in
                    (match (_tok : MenhirBasics.token) with
                    | Tokens.LBRACE ->
                        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
                        let _menhir_stack = MenhirCell0_LBRACE (_menhir_stack, _startpos) in
                        let _menhir_s = MenhirState611 in
                        let _tok = _menhir_lexer _menhir_lexbuf in
                        (match (_tok : MenhirBasics.token) with
                        | Tokens.IDENTIFIER _v ->
                            _menhir_run_612 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
                        | _ ->
                            _eRR 611)
                    | _ ->
                        _eRR 610)
                | Tokens.BOOLEAN ->
                    _menhir_run_105 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState605
                | Tokens.BITS ->
                    _menhir_run_106 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState605
                | Tokens.BIT ->
                    _menhir_run_117 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState605
                | Tokens.ARRAY ->
                    _menhir_run_118 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState605
                | _ ->
                    _eRR 605)
            | _ ->
                _eRR 600)
        | _ ->
            _eRR 599
    
    and _menhir_run_612 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> (ttv_stack, _menhir_box_spec) _menhir_state -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.COMMA ->
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.IDENTIFIER _v_0 ->
                let _menhir_stack = MenhirCell1_IDENTIFIER (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
                _menhir_run_612 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState613
            | Tokens.RBRACE ->
                let (x, x_inlined1) = (_v, ()) in
                let _v = _menhir_action_316 x x_inlined1 in
                _menhir_goto_tclist1_IDENTIFIER_ _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | _ ->
                _eRR 613)
        | Tokens.RBRACE ->
            let x = _v in
            let _v = _menhir_action_315 x in
            _menhir_goto_tclist1_IDENTIFIER_ _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | _ ->
            _eRR 612
    
    and _menhir_goto_tclist1_IDENTIFIER_ : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> (ttv_stack, _menhir_box_spec) _menhir_state -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
        match _menhir_s with
        | MenhirState611 ->
            _menhir_run_615 _menhir_stack _menhir_lexbuf _menhir_lexer _v
        | MenhirState613 ->
            _menhir_run_614 _menhir_stack _menhir_lexbuf _menhir_lexer _v
        | _ ->
            _menhir_fail ()
    
    and _menhir_run_615 : type  ttv_stack. (((ttv_stack, _menhir_box_spec) _menhir_cell1_TYPE _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_OF, _menhir_box_spec) _menhir_cell1_ENUMERATION _menhir_cell0_LBRACE -> _ -> _ -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v ->
        let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
        let _tok = _menhir_lexer _menhir_lexbuf in
        let MenhirCell0_LBRACE (_menhir_stack, _) = _menhir_stack in
        let MenhirCell1_ENUMERATION (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
        let (_1, x, _endpos__3_) = ((), _v, _endpos) in
        let _v = _menhir_action_335 _1 _endpos__3_ _startpos__1_ x in
        _menhir_goto_ty_decl _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
    
    and _menhir_run_614 : type  ttv_stack. (ttv_stack, _menhir_box_spec) _menhir_cell1_IDENTIFIER -> _ -> _ -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v ->
        let MenhirCell1_IDENTIFIER (_menhir_stack, _menhir_s, h, _, _) = _menhir_stack in
        let (_2, t) = ((), _v) in
        let _v = _menhir_action_317 _2 h t in
        _menhir_goto_tclist1_IDENTIFIER_ _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
    
    and _menhir_run_624 : type  ttv_stack. ttv_stack -> _ -> _ -> (ttv_stack, _menhir_box_spec) _menhir_state -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _menhir_stack = MenhirCell1_READONLY (_menhir_stack, _menhir_s, _startpos) in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.IMPLEMENTATION ->
            let _startpos_0 = _menhir_lexbuf.Lexing.lex_start_p in
            let _menhir_stack = MenhirCell0_IMPLEMENTATION (_menhir_stack, _startpos_0) in
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.FUNC ->
                let _startpos_1 = _menhir_lexbuf.Lexing.lex_start_p in
                let _menhir_stack = MenhirCell0_FUNC (_menhir_stack, _startpos_1) in
                let _tok = _menhir_lexer _menhir_lexbuf in
                (match (_tok : MenhirBasics.token) with
                | Tokens.IDENTIFIER _v ->
                    let _startpos_2 = _menhir_lexbuf.Lexing.lex_start_p in
                    let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
                    let _menhir_stack = MenhirCell0_IDENTIFIER (_menhir_stack, _v, _startpos_2, _endpos) in
                    let _tok = _menhir_lexer _menhir_lexbuf in
                    (match (_tok : MenhirBasics.token) with
                    | Tokens.LBRACE ->
                        _menhir_run_628 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState627
                    | Tokens.LPAR ->
                        let _v_3 = _menhir_action_247 () in
                        _menhir_run_636 _menhir_stack _menhir_lexbuf _menhir_lexer _v_3 MenhirState627 _tok
                    | _ ->
                        _eRR 627)
                | _ ->
                    _eRR 626)
            | _ ->
                _eRR 625)
        | Tokens.IMPDEF ->
            let _startpos_4 = _menhir_lexbuf.Lexing.lex_start_p in
            let _menhir_stack = MenhirCell0_IMPDEF (_menhir_stack, _startpos_4) in
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.FUNC ->
                let _startpos_5 = _menhir_lexbuf.Lexing.lex_start_p in
                let _menhir_stack = MenhirCell0_FUNC (_menhir_stack, _startpos_5) in
                let _tok = _menhir_lexer _menhir_lexbuf in
                (match (_tok : MenhirBasics.token) with
                | Tokens.IDENTIFIER _v ->
                    let _startpos_6 = _menhir_lexbuf.Lexing.lex_start_p in
                    let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
                    let _menhir_stack = MenhirCell0_IDENTIFIER (_menhir_stack, _v, _startpos_6, _endpos) in
                    let _tok = _menhir_lexer _menhir_lexbuf in
                    (match (_tok : MenhirBasics.token) with
                    | Tokens.LBRACE ->
                        _menhir_run_628 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState662
                    | Tokens.LPAR ->
                        let _v_7 = _menhir_action_247 () in
                        _menhir_run_663 _menhir_stack _menhir_lexbuf _menhir_lexer _v_7 MenhirState662 _tok
                    | _ ->
                        _eRR 662)
                | _ ->
                    _eRR 661)
            | _ ->
                _eRR 660)
        | Tokens.FUNC ->
            let _startpos_8 = _menhir_lexbuf.Lexing.lex_start_p in
            let _menhir_stack = MenhirCell0_FUNC (_menhir_stack, _startpos_8) in
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.IDENTIFIER _v ->
                let _startpos_9 = _menhir_lexbuf.Lexing.lex_start_p in
                let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
                let _menhir_stack = MenhirCell0_IDENTIFIER (_menhir_stack, _v, _startpos_9, _endpos) in
                let _tok = _menhir_lexer _menhir_lexbuf in
                (match (_tok : MenhirBasics.token) with
                | Tokens.LBRACE ->
                    _menhir_run_628 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState677
                | Tokens.LPAR ->
                    let _v_10 = _menhir_action_247 () in
                    _menhir_run_678 _menhir_stack _menhir_lexbuf _menhir_lexer _v_10 MenhirState677 _tok
                | _ ->
                    _eRR 677)
            | _ ->
                _eRR 676)
        | _ ->
            _eRR 624
    
    and _menhir_run_628 : type  ttv_stack. (ttv_stack _menhir_cell0_IDENTIFIER as 'stack) -> _ -> _ -> ('stack, _menhir_box_spec) _menhir_state -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _menhir_stack = MenhirCell1_LBRACE (_menhir_stack, _menhir_s, _startpos) in
        let _menhir_s = MenhirState628 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.IDENTIFIER _v ->
            _menhir_run_629 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | _ ->
            _eRR 628
    
    and _menhir_run_629 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> (ttv_stack, _menhir_box_spec) _menhir_state -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.COLON ->
            let _menhir_stack = MenhirCell1_IDENTIFIER (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_116 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState629
        | Tokens.COMMA | Tokens.RBRACE ->
            let x = _v in
            let _v = _menhir_action_241 x in
            _menhir_goto_opt_typed_identifier _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
        | _ ->
            _eRR 629
    
    and _menhir_goto_opt_typed_identifier : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> (ttv_stack, _menhir_box_spec) _menhir_state -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
        match (_tok : MenhirBasics.token) with
        | Tokens.COMMA ->
            let _menhir_stack = MenhirCell1_opt_typed_identifier (_menhir_stack, _menhir_s, _v) in
            let _menhir_s = MenhirState632 in
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.IDENTIFIER _v ->
                _menhir_run_629 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | _ ->
                _eRR 632)
        | Tokens.RBRACE ->
            let x = _v in
            let _v = _menhir_action_044 x in
            _menhir_goto_clist1_opt_typed_identifier_ _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | _ ->
            _eRR 631
    
    and _menhir_goto_clist1_opt_typed_identifier_ : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> (ttv_stack, _menhir_box_spec) _menhir_state -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
        match _menhir_s with
        | MenhirState628 ->
            _menhir_run_634 _menhir_stack _menhir_lexbuf _menhir_lexer _v
        | MenhirState632 ->
            _menhir_run_633 _menhir_stack _menhir_lexbuf _menhir_lexer _v
        | _ ->
            _menhir_fail ()
    
    and _menhir_run_634 : type  ttv_stack. (ttv_stack _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_LBRACE -> _ -> _ -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v ->
        let _tok = _menhir_lexer _menhir_lexbuf in
        let MenhirCell1_LBRACE (_menhir_stack, _menhir_s, _) = _menhir_stack in
        let x = _v in
        let _v = _menhir_action_248 x in
        _menhir_goto_params_opt _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
    
    and _menhir_goto_params_opt : type  ttv_stack. (ttv_stack _menhir_cell0_IDENTIFIER as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_spec) _menhir_state -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
        match _menhir_s with
        | MenhirState893 ->
            _menhir_run_894 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
        | MenhirState859 ->
            _menhir_run_860 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
        | MenhirState848 ->
            _menhir_run_849 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
        | MenhirState833 ->
            _menhir_run_834 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
        | MenhirState802 ->
            _menhir_run_803 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
        | MenhirState787 ->
            _menhir_run_788 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
        | MenhirState765 ->
            _menhir_run_766 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
        | MenhirState756 ->
            _menhir_run_757 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
        | MenhirState746 ->
            _menhir_run_747 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
        | MenhirState725 ->
            _menhir_run_726 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
        | MenhirState710 ->
            _menhir_run_711 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
        | MenhirState694 ->
            _menhir_run_695 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
        | MenhirState677 ->
            _menhir_run_678 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
        | MenhirState662 ->
            _menhir_run_663 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
        | MenhirState627 ->
            _menhir_run_636 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
        | _ ->
            _menhir_fail ()
    
    and _menhir_run_894 : type  ttv_stack. ((ttv_stack, _menhir_box_spec) _menhir_cell1_ACCESSOR _menhir_cell0_IDENTIFIER as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_spec) _menhir_state -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
        let _menhir_stack = MenhirCell1_params_opt (_menhir_stack, _menhir_s, _v) in
        match (_tok : MenhirBasics.token) with
        | Tokens.LPAR ->
            _menhir_run_637 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState894
        | _ ->
            _eRR 894
    
    and _menhir_run_637 : type  ttv_stack. ((ttv_stack _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt as 'stack) -> _ -> _ -> ('stack, _menhir_box_spec) _menhir_state -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _menhir_stack = MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos) in
        let _menhir_s = MenhirState637 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.IDENTIFIER _v ->
            _menhir_run_579 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.RPAR ->
            let _v = _menhir_action_026 () in
            _menhir_goto_clist0_typed_identifier_ _menhir_stack _menhir_lexbuf _menhir_lexer _v
        | _ ->
            _eRR 637
    
    and _menhir_goto_clist0_typed_identifier_ : type  ttv_stack. ((ttv_stack _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_LPAR -> _ -> _ -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v ->
        let _tok = _menhir_lexer _menhir_lexbuf in
        let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _) = _menhir_stack in
        let x = _v in
        let _v = _menhir_action_218 x in
        _menhir_goto_func_args _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
    
    and _menhir_goto_func_args : type  ttv_stack. ((ttv_stack _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_spec) _menhir_state -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
        match _menhir_s with
        | MenhirState894 ->
            _menhir_run_895 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
        | MenhirState860 ->
            _menhir_run_861 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
        | MenhirState849 ->
            _menhir_run_850 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
        | MenhirState834 ->
            _menhir_run_835 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
        | MenhirState803 ->
            _menhir_run_804 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
        | MenhirState788 ->
            _menhir_run_789 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
        | MenhirState766 ->
            _menhir_run_767 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
        | MenhirState757 ->
            _menhir_run_758 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
        | MenhirState747 ->
            _menhir_run_748 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
        | MenhirState726 ->
            _menhir_run_727 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
        | MenhirState711 ->
            _menhir_run_712 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
        | MenhirState695 ->
            _menhir_run_696 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
        | MenhirState678 ->
            _menhir_run_679 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
        | MenhirState663 ->
            _menhir_run_664 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
        | MenhirState636 ->
            _menhir_run_644 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
        | _ ->
            _menhir_fail ()
    
    and _menhir_run_895 : type  ttv_stack. (((ttv_stack, _menhir_box_spec) _menhir_cell1_ACCESSOR _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_spec) _menhir_state -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
        let _menhir_stack = MenhirCell1_func_args (_menhir_stack, _menhir_s, _v) in
        match (_tok : MenhirBasics.token) with
        | Tokens.BEQ ->
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.IDENTIFIER _v ->
                let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
                let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
                let _menhir_stack = MenhirCell0_IDENTIFIER (_menhir_stack, _v, _startpos, _endpos) in
                let _menhir_s = MenhirState897 in
                let _tok = _menhir_lexer _menhir_lexbuf in
                (match (_tok : MenhirBasics.token) with
                | Tokens.COLON ->
                    _menhir_run_116 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
                | _ ->
                    _eRR 897)
            | _ ->
                _eRR 896)
        | _ ->
            _eRR 895
    
    and _menhir_run_861 : type  ttv_stack. (((ttv_stack, _menhir_box_spec) _menhir_cell1_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_spec) _menhir_state -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
        let _menhir_stack = MenhirCell1_func_args (_menhir_stack, _menhir_s, _v) in
        match (_tok : MenhirBasics.token) with
        | Tokens.RECURSELIMIT ->
            _menhir_run_645 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState861
        | Tokens.ARROW ->
            _menhir_run_647 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState861
        | Tokens.BEGIN ->
            let _v_0 = _menhir_action_260 () in
            _menhir_run_868 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState861
        | _ ->
            _eRR 861
    
    and _menhir_run_647 : type  ttv_stack. (((ttv_stack _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args as 'stack) -> _ -> _ -> ('stack, _menhir_box_spec) _menhir_state -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _menhir_stack = MenhirCell1_ARROW (_menhir_stack, _menhir_s) in
        let _menhir_s = MenhirState647 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.STRING ->
            _menhir_run_016 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.REAL ->
            _menhir_run_017 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LPAR ->
            _menhir_run_018 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.INTEGER ->
            _menhir_run_019 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IDENTIFIER _v ->
            _menhir_run_104 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BOOLEAN ->
            _menhir_run_105 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.BITS ->
            _menhir_run_106 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.BIT ->
            _menhir_run_117 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.ARRAY ->
            _menhir_run_118 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | _ ->
            _eRR 647
    
    and _menhir_run_868 : type  ttv_stack. ((((ttv_stack, _menhir_box_spec) _menhir_cell1_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_spec) _menhir_state -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
        let _menhir_stack = MenhirCell1_recurse_limit (_menhir_stack, _menhir_s, _v) in
        let _menhir_s = MenhirState869 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.WHILE ->
            _menhir_run_001 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.VAR ->
            _menhir_run_318 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.UNREACHABLE ->
            _menhir_run_363 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.TRY ->
            _menhir_run_365 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.THROW ->
            _menhir_run_366 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.RETURN ->
            _menhir_run_369 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.REPEAT ->
            _menhir_run_373 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PRINTLN ->
            _menhir_run_374 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PRINT ->
            _menhir_run_377 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PRAGMA ->
            _menhir_run_380 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PASS ->
            _menhir_run_384 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.MINUS ->
            _menhir_run_386 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LPAR ->
            _menhir_run_387 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LET ->
            _menhir_run_408 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IF ->
            _menhir_run_420 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IDENTIFIER _v ->
            _menhir_run_423 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.FOR ->
            _menhir_run_443 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.DEBUG ->
            _menhir_run_453 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.CONSTANT ->
            _menhir_run_458 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.CASE ->
            _menhir_run_469 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.ASSERT ->
            _menhir_run_477 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | _ ->
            _eRR 869
    
    and _menhir_run_363 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.SEMI_COLON ->
            let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
            let _tok = _menhir_lexer _menhir_lexbuf in
            let (_startpos__1_, _1, _endpos__2_) = (_startpos, (), _endpos) in
            let _v = _menhir_action_303 _1 _endpos__2_ _startpos__1_ in
            _menhir_goto_stmt _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__2_ _v _menhir_s _tok
        | _ ->
            _eRR 363
    
    and _menhir_goto_stmt : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok ->
        match _menhir_s with
        | MenhirState000 ->
            _menhir_run_563 _menhir_stack _v _tok
        | MenhirState908 ->
            _menhir_run_481 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState869 ->
            _menhir_run_481 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState864 ->
            _menhir_run_481 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState843 ->
            _menhir_run_481 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState838 ->
            _menhir_run_481 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState820 ->
            _menhir_run_481 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState824 ->
            _menhir_run_481 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState809 ->
            _menhir_run_481 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState815 ->
            _menhir_run_481 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState797 ->
            _menhir_run_481 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState792 ->
            _menhir_run_481 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState769 ->
            _menhir_run_481 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState760 ->
            _menhir_run_481 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState750 ->
            _menhir_run_481 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState735 ->
            _menhir_run_481 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState730 ->
            _menhir_run_481 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState720 ->
            _menhir_run_481 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState715 ->
            _menhir_run_481 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState704 ->
            _menhir_run_481 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState699 ->
            _menhir_run_481 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState687 ->
            _menhir_run_481 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState682 ->
            _menhir_run_481 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState672 ->
            _menhir_run_481 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState667 ->
            _menhir_run_481 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState656 ->
            _menhir_run_481 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState651 ->
            _menhir_run_481 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState317 ->
            _menhir_run_481 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState365 ->
            _menhir_run_481 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState553 ->
            _menhir_run_481 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState549 ->
            _menhir_run_481 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState546 ->
            _menhir_run_481 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState373 ->
            _menhir_run_481 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState422 ->
            _menhir_run_481 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState527 ->
            _menhir_run_481 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState529 ->
            _menhir_run_481 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState452 ->
            _menhir_run_481 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState513 ->
            _menhir_run_481 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState509 ->
            _menhir_run_481 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState481 ->
            _menhir_run_481 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState476 ->
            _menhir_run_481 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | _ ->
            _menhir_fail ()
    
    and _menhir_run_481 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok ->
        match (_tok : MenhirBasics.token) with
        | Tokens.WHILE ->
            let _menhir_stack = MenhirCell1_stmt (_menhir_stack, _menhir_s, _v, _endpos) in
            _menhir_run_001 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState481
        | Tokens.VAR ->
            let _menhir_stack = MenhirCell1_stmt (_menhir_stack, _menhir_s, _v, _endpos) in
            _menhir_run_318 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState481
        | Tokens.UNREACHABLE ->
            let _menhir_stack = MenhirCell1_stmt (_menhir_stack, _menhir_s, _v, _endpos) in
            _menhir_run_363 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState481
        | Tokens.TRY ->
            let _menhir_stack = MenhirCell1_stmt (_menhir_stack, _menhir_s, _v, _endpos) in
            _menhir_run_365 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState481
        | Tokens.THROW ->
            let _menhir_stack = MenhirCell1_stmt (_menhir_stack, _menhir_s, _v, _endpos) in
            _menhir_run_366 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState481
        | Tokens.RETURN ->
            let _menhir_stack = MenhirCell1_stmt (_menhir_stack, _menhir_s, _v, _endpos) in
            _menhir_run_369 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState481
        | Tokens.REPEAT ->
            let _menhir_stack = MenhirCell1_stmt (_menhir_stack, _menhir_s, _v, _endpos) in
            _menhir_run_373 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState481
        | Tokens.PRINTLN ->
            let _menhir_stack = MenhirCell1_stmt (_menhir_stack, _menhir_s, _v, _endpos) in
            _menhir_run_374 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState481
        | Tokens.PRINT ->
            let _menhir_stack = MenhirCell1_stmt (_menhir_stack, _menhir_s, _v, _endpos) in
            _menhir_run_377 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState481
        | Tokens.PRAGMA ->
            let _menhir_stack = MenhirCell1_stmt (_menhir_stack, _menhir_s, _v, _endpos) in
            _menhir_run_380 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState481
        | Tokens.PASS ->
            let _menhir_stack = MenhirCell1_stmt (_menhir_stack, _menhir_s, _v, _endpos) in
            _menhir_run_384 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState481
        | Tokens.MINUS ->
            let _menhir_stack = MenhirCell1_stmt (_menhir_stack, _menhir_s, _v, _endpos) in
            _menhir_run_386 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState481
        | Tokens.LPAR ->
            let _menhir_stack = MenhirCell1_stmt (_menhir_stack, _menhir_s, _v, _endpos) in
            _menhir_run_387 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState481
        | Tokens.LET ->
            let _menhir_stack = MenhirCell1_stmt (_menhir_stack, _menhir_s, _v, _endpos) in
            _menhir_run_408 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState481
        | Tokens.IF ->
            let _menhir_stack = MenhirCell1_stmt (_menhir_stack, _menhir_s, _v, _endpos) in
            _menhir_run_420 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState481
        | Tokens.IDENTIFIER _v_0 ->
            let _menhir_stack = MenhirCell1_stmt (_menhir_stack, _menhir_s, _v, _endpos) in
            _menhir_run_423 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState481
        | Tokens.FOR ->
            let _menhir_stack = MenhirCell1_stmt (_menhir_stack, _menhir_s, _v, _endpos) in
            _menhir_run_443 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState481
        | Tokens.DEBUG ->
            let _menhir_stack = MenhirCell1_stmt (_menhir_stack, _menhir_s, _v, _endpos) in
            _menhir_run_453 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState481
        | Tokens.CONSTANT ->
            let _menhir_stack = MenhirCell1_stmt (_menhir_stack, _menhir_s, _v, _endpos) in
            _menhir_run_458 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState481
        | Tokens.CASE ->
            let _menhir_stack = MenhirCell1_stmt (_menhir_stack, _menhir_s, _v, _endpos) in
            _menhir_run_469 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState481
        | Tokens.ASSERT ->
            let _menhir_stack = MenhirCell1_stmt (_menhir_stack, _menhir_s, _v, _endpos) in
            _menhir_run_477 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState481
        | Tokens.CATCH | Tokens.ELSE | Tokens.ELSIF | Tokens.END | Tokens.EOF | Tokens.OTHERWISE | Tokens.UNTIL | Tokens.WHEN ->
            let (_endpos_x_, x) = (_endpos, _v) in
            let _v = _menhir_action_236 x in
            _menhir_goto_list1_stmt_ _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_x_ _v _menhir_s _tok
        | _ ->
            _eRR 481
    
    and _menhir_run_365 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _menhir_stack = MenhirCell1_TRY (_menhir_stack, _menhir_s, _startpos) in
        let _menhir_s = MenhirState365 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.WHILE ->
            _menhir_run_001 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.VAR ->
            _menhir_run_318 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.UNREACHABLE ->
            _menhir_run_363 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.TRY ->
            _menhir_run_365 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.THROW ->
            _menhir_run_366 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.RETURN ->
            _menhir_run_369 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.REPEAT ->
            _menhir_run_373 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PRINTLN ->
            _menhir_run_374 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PRINT ->
            _menhir_run_377 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PRAGMA ->
            _menhir_run_380 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PASS ->
            _menhir_run_384 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.MINUS ->
            _menhir_run_386 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LPAR ->
            _menhir_run_387 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LET ->
            _menhir_run_408 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IF ->
            _menhir_run_420 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IDENTIFIER _v ->
            _menhir_run_423 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.FOR ->
            _menhir_run_443 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.DEBUG ->
            _menhir_run_453 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.CONSTANT ->
            _menhir_run_458 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.CASE ->
            _menhir_run_469 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.ASSERT ->
            _menhir_run_477 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | _ ->
            _eRR 365
    
    and _menhir_run_366 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _menhir_stack = MenhirCell1_THROW (_menhir_stack, _menhir_s, _startpos) in
        let _menhir_s = MenhirState366 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.STRING_LIT _v ->
            _menhir_run_002 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.REAL_LIT _v ->
            _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.NOT ->
            _menhir_run_004 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.MINUS ->
            _menhir_run_005 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LPAR ->
            _menhir_run_006 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.INT_LIT _v ->
            _menhir_run_007 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.IF ->
            _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IDENTIFIER _v ->
            _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BOOL_LIT _v ->
            _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BNOT ->
            _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.BITVECTOR_LIT _v ->
            _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.ARBITRARY ->
            _menhir_run_014 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | _ ->
            _eRR 366
    
    and _menhir_run_369 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _menhir_stack = MenhirCell1_RETURN (_menhir_stack, _menhir_s, _startpos) in
        let _menhir_s = MenhirState369 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.STRING_LIT _v ->
            _menhir_run_002 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.REAL_LIT _v ->
            _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.NOT ->
            _menhir_run_004 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.MINUS ->
            _menhir_run_005 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LPAR ->
            _menhir_run_006 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.INT_LIT _v ->
            _menhir_run_007 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.IF ->
            _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IDENTIFIER _v ->
            _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BOOL_LIT _v ->
            _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BNOT ->
            _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.BITVECTOR_LIT _v ->
            _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.ARBITRARY ->
            _menhir_run_014 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.SEMI_COLON ->
            let _v = _menhir_action_243 () in
            _menhir_goto_option_expr_ _menhir_stack _menhir_lexbuf _menhir_lexer _v
        | _ ->
            _eRR 369
    
    and _menhir_goto_option_expr_ : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_RETURN -> _ -> _ -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v ->
        let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
        let _tok = _menhir_lexer _menhir_lexbuf in
        let MenhirCell1_RETURN (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
        let (_1, _endpos__2_, _2_inlined1) = ((), _endpos, _v) in
        let _v = _menhir_action_282 _1 _2_inlined1 _endpos__2_ _startpos__1_ in
        _menhir_goto_stmt _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__2_ _v _menhir_s _tok
    
    and _menhir_run_373 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _menhir_stack = MenhirCell1_REPEAT (_menhir_stack, _menhir_s, _startpos) in
        let _menhir_s = MenhirState373 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.WHILE ->
            _menhir_run_001 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.VAR ->
            _menhir_run_318 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.UNREACHABLE ->
            _menhir_run_363 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.TRY ->
            _menhir_run_365 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.THROW ->
            _menhir_run_366 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.RETURN ->
            _menhir_run_369 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.REPEAT ->
            _menhir_run_373 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PRINTLN ->
            _menhir_run_374 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PRINT ->
            _menhir_run_377 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PRAGMA ->
            _menhir_run_380 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PASS ->
            _menhir_run_384 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.MINUS ->
            _menhir_run_386 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LPAR ->
            _menhir_run_387 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LET ->
            _menhir_run_408 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IF ->
            _menhir_run_420 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IDENTIFIER _v ->
            _menhir_run_423 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.FOR ->
            _menhir_run_443 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.DEBUG ->
            _menhir_run_453 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.CONSTANT ->
            _menhir_run_458 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.CASE ->
            _menhir_run_469 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.ASSERT ->
            _menhir_run_477 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | _ ->
            _eRR 373
    
    and _menhir_run_374 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _menhir_stack = MenhirCell1_PRINTLN (_menhir_stack, _menhir_s, _startpos) in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.STRING_LIT _v ->
            _menhir_run_002 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState374
        | Tokens.REAL_LIT _v ->
            _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState374
        | Tokens.NOT ->
            _menhir_run_004 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState374
        | Tokens.MINUS ->
            _menhir_run_005 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState374
        | Tokens.LPAR ->
            _menhir_run_006 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState374
        | Tokens.INT_LIT _v ->
            _menhir_run_007 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState374
        | Tokens.IF ->
            _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState374
        | Tokens.IDENTIFIER _v ->
            _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState374
        | Tokens.BOOL_LIT _v ->
            _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState374
        | Tokens.BNOT ->
            _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState374
        | Tokens.BITVECTOR_LIT _v ->
            _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState374
        | Tokens.ARBITRARY ->
            _menhir_run_014 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState374
        | Tokens.SEMI_COLON ->
            let _v = _menhir_action_024 () in
            _menhir_run_375 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
        | _ ->
            _eRR 374
    
    and _menhir_run_375 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_PRINTLN -> _ -> _ -> _ -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
        match (_tok : MenhirBasics.token) with
        | Tokens.SEMI_COLON ->
            let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
            let _tok = _menhir_lexer _menhir_lexbuf in
            let MenhirCell1_PRINTLN (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
            let (_1, _endpos__2_, args) = ((), _endpos, _v) in
            let _v = _menhir_action_300 _1 _endpos__2_ _startpos__1_ args in
            _menhir_goto_stmt _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__2_ _v _menhir_s _tok
        | _ ->
            _eRR 375
    
    and _menhir_run_377 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _menhir_stack = MenhirCell1_PRINT (_menhir_stack, _menhir_s, _startpos) in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.STRING_LIT _v ->
            _menhir_run_002 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState377
        | Tokens.REAL_LIT _v ->
            _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState377
        | Tokens.NOT ->
            _menhir_run_004 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState377
        | Tokens.MINUS ->
            _menhir_run_005 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState377
        | Tokens.LPAR ->
            _menhir_run_006 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState377
        | Tokens.INT_LIT _v ->
            _menhir_run_007 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState377
        | Tokens.IF ->
            _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState377
        | Tokens.IDENTIFIER _v ->
            _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState377
        | Tokens.BOOL_LIT _v ->
            _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState377
        | Tokens.BNOT ->
            _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState377
        | Tokens.BITVECTOR_LIT _v ->
            _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState377
        | Tokens.ARBITRARY ->
            _menhir_run_014 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState377
        | Tokens.SEMI_COLON ->
            let _v = _menhir_action_024 () in
            _menhir_run_378 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
        | _ ->
            _eRR 377
    
    and _menhir_run_378 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_PRINT -> _ -> _ -> _ -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
        match (_tok : MenhirBasics.token) with
        | Tokens.SEMI_COLON ->
            let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
            let _tok = _menhir_lexer _menhir_lexbuf in
            let MenhirCell1_PRINT (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
            let (_1, _endpos__2_, args) = ((), _endpos, _v) in
            let _v = _menhir_action_301 _1 _endpos__2_ _startpos__1_ args in
            _menhir_goto_stmt _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__2_ _v _menhir_s _tok
        | _ ->
            _eRR 378
    
    and _menhir_run_380 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _menhir_stack = MenhirCell1_PRAGMA (_menhir_stack, _menhir_s, _startpos) in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.IDENTIFIER _v ->
            let _startpos_0 = _menhir_lexbuf.Lexing.lex_start_p in
            let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
            let _menhir_stack = MenhirCell0_IDENTIFIER (_menhir_stack, _v, _startpos_0, _endpos) in
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.STRING_LIT _v_1 ->
                _menhir_run_002 _menhir_stack _menhir_lexbuf _menhir_lexer _v_1 MenhirState381
            | Tokens.REAL_LIT _v_2 ->
                _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v_2 MenhirState381
            | Tokens.NOT ->
                _menhir_run_004 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState381
            | Tokens.MINUS ->
                _menhir_run_005 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState381
            | Tokens.LPAR ->
                _menhir_run_006 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState381
            | Tokens.INT_LIT _v_3 ->
                _menhir_run_007 _menhir_stack _menhir_lexbuf _menhir_lexer _v_3 MenhirState381
            | Tokens.IF ->
                _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState381
            | Tokens.IDENTIFIER _v_4 ->
                _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v_4 MenhirState381
            | Tokens.BOOL_LIT _v_5 ->
                _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer _v_5 MenhirState381
            | Tokens.BNOT ->
                _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState381
            | Tokens.BITVECTOR_LIT _v_6 ->
                _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _v_6 MenhirState381
            | Tokens.ARBITRARY ->
                _menhir_run_014 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState381
            | Tokens.SEMI_COLON ->
                let _v_7 = _menhir_action_024 () in
                _menhir_run_382 _menhir_stack _menhir_lexbuf _menhir_lexer _v_7 _tok
            | _ ->
                _eRR 381)
        | _ ->
            _eRR 380
    
    and _menhir_run_382 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_PRAGMA _menhir_cell0_IDENTIFIER -> _ -> _ -> _ -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
        match (_tok : MenhirBasics.token) with
        | Tokens.SEMI_COLON ->
            let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
            let _tok = _menhir_lexer _menhir_lexbuf in
            let MenhirCell0_IDENTIFIER (_menhir_stack, x, _, _) = _menhir_stack in
            let MenhirCell1_PRAGMA (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
            let (_1, _endpos__2_, e) = ((), _endpos, _v) in
            let _v = _menhir_action_306 _1 _endpos__2_ _startpos__1_ e x in
            _menhir_goto_stmt _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__2_ _v _menhir_s _tok
        | _ ->
            _eRR 382
    
    and _menhir_run_384 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.SEMI_COLON ->
            let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
            let _tok = _menhir_lexer _menhir_lexbuf in
            let (_startpos__1_, _1, _endpos__2_) = (_startpos, (), _endpos) in
            let _v = _menhir_action_281 _1 _endpos__2_ _startpos__1_ in
            _menhir_goto_stmt _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__2_ _v _menhir_s _tok
        | _ ->
            _eRR 384
    
    and _menhir_run_386 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
        let _tok = _menhir_lexer _menhir_lexbuf in
        let (_endpos__1_, _startpos__1_, _1) = (_endpos, _startpos, ()) in
        let _v = _menhir_action_227 _1 _endpos__1_ _startpos__1_ in
        _menhir_goto_lexpr _menhir_stack _menhir_lexbuf _menhir_lexer _startpos__1_ _v _menhir_s _tok
    
    and _menhir_goto_lexpr : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok ->
        let _menhir_stack = MenhirCell1_lexpr (_menhir_stack, _menhir_s, _v, _startpos) in
        match (_tok : MenhirBasics.token) with
        | Tokens.EQ ->
            let _menhir_s = MenhirState484 in
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.STRING_LIT _v ->
                _menhir_run_002 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | Tokens.REAL_LIT _v ->
                _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | Tokens.NOT ->
                _menhir_run_004 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.MINUS ->
                _menhir_run_005 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.LPAR ->
                _menhir_run_006 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.INT_LIT _v ->
                _menhir_run_007 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | Tokens.IF ->
                _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.IDENTIFIER _v ->
                _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | Tokens.BOOL_LIT _v ->
                _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | Tokens.BNOT ->
                _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.BITVECTOR_LIT _v ->
                _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | Tokens.ARBITRARY ->
                _menhir_run_014 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | _ ->
                _eRR 484)
        | _ ->
            _eRR 483
    
    and _menhir_run_387 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _menhir_stack = MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos) in
        let _menhir_s = MenhirState387 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.MINUS ->
            _menhir_run_388 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IDENTIFIER _v ->
            _menhir_run_389 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | _ ->
            _eRR 387
    
    and _menhir_run_388 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _tok = _menhir_lexer _menhir_lexbuf in
        let _1 = () in
        let _v = _menhir_action_112 _1 in
        _menhir_goto_discard_or_basic_lexpr _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
    
    and _menhir_goto_discard_or_basic_lexpr : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
        match _menhir_s with
        | MenhirState402 ->
            _menhir_run_401 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
        | MenhirState400 ->
            _menhir_run_401 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
        | MenhirState387 ->
            _menhir_run_399 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
        | _ ->
            _menhir_fail ()
    
    and _menhir_run_401 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_discard_or_basic_lexpr as 'stack) -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
        match (_tok : MenhirBasics.token) with
        | Tokens.COMMA ->
            let _menhir_stack = MenhirCell1_discard_or_basic_lexpr (_menhir_stack, _menhir_s, _v) in
            let _menhir_s = MenhirState402 in
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.MINUS ->
                _menhir_run_388 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.IDENTIFIER _v ->
                _menhir_run_389 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | _ ->
                _eRR 402)
        | Tokens.RPAR ->
            let x = _v in
            let _v = _menhir_action_032 x in
            _menhir_goto_clist1_discard_or_basic_lexpr_ _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | _ ->
            _eRR 401
    
    and _menhir_run_389 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
        let _menhir_stack = MenhirCell1_IDENTIFIER (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.LLBRACKET ->
            _menhir_run_390 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState389
        | Tokens.DOT ->
            _menhir_run_393 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState389
        | Tokens.COMMA | Tokens.LBRACKET | Tokens.RPAR ->
            let _v_0 = _menhir_action_003 () in
            _menhir_run_397 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState389 _tok
        | _ ->
            _eRR 389
    
    and _menhir_run_390 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _menhir_stack = MenhirCell1_LLBRACKET (_menhir_stack, _menhir_s) in
        let _menhir_s = MenhirState390 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.STRING_LIT _v ->
            _menhir_run_002 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.REAL_LIT _v ->
            _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.NOT ->
            _menhir_run_004 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.MINUS ->
            _menhir_run_005 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LPAR ->
            _menhir_run_006 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.INT_LIT _v ->
            _menhir_run_007 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.IF ->
            _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IDENTIFIER _v ->
            _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BOOL_LIT _v ->
            _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BNOT ->
            _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.BITVECTOR_LIT _v ->
            _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.ARBITRARY ->
            _menhir_run_014 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | _ ->
            _eRR 390
    
    and _menhir_run_393 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _menhir_stack = MenhirCell1_DOT (_menhir_stack, _menhir_s) in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.IDENTIFIER _v ->
            _menhir_run_394 _menhir_stack _menhir_lexbuf _menhir_lexer _v
        | _ ->
            _eRR 393
    
    and _menhir_run_394 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_DOT -> _ -> _ -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
        let _menhir_stack = MenhirCell0_IDENTIFIER (_menhir_stack, _v, _startpos, _endpos) in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.LLBRACKET ->
            _menhir_run_390 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState394
        | Tokens.DOT ->
            _menhir_run_393 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState394
        | Tokens.COMMA | Tokens.EQ | Tokens.LBRACKET | Tokens.RPAR ->
            let _v_0 = _menhir_action_003 () in
            _menhir_run_395 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 _tok
        | _ ->
            _eRR 394
    
    and _menhir_run_395 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_DOT _menhir_cell0_IDENTIFIER -> _ -> _ -> _ -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
        let MenhirCell0_IDENTIFIER (_menhir_stack, desc, _startpos_desc_, _endpos_desc_) = _menhir_stack in
        let MenhirCell1_DOT (_menhir_stack, _menhir_s) = _menhir_stack in
        let (_1, t) = ((), _v) in
        let _v = _menhir_action_004 _1 _endpos_desc_ _startpos_desc_ desc t in
        _menhir_goto_access _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
    
    and _menhir_goto_access : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
        match _menhir_s with
        | MenhirState423 ->
            _menhir_run_397 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
        | MenhirState389 ->
            _menhir_run_397 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
        | MenhirState392 ->
            _menhir_run_396 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
        | MenhirState394 ->
            _menhir_run_395 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
        | _ ->
            _menhir_fail ()
    
    and _menhir_run_397 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_IDENTIFIER as 'stack) -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
        match (_tok : MenhirBasics.token) with
        | Tokens.LBRACKET ->
            let _menhir_stack = MenhirCell1_access (_menhir_stack, _menhir_s, _v) in
            _menhir_run_034 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState397
        | Tokens.COMMA | Tokens.EQ | Tokens.RPAR ->
            let MenhirCell1_IDENTIFIER (_menhir_stack, _menhir_s, desc, _startpos_desc_, _endpos_desc_) = _menhir_stack in
            let access = _v in
            let _v = _menhir_action_009 _endpos_desc_ _startpos_desc_ access desc in
            _menhir_goto_basic_lexpr _menhir_stack _menhir_lexbuf _menhir_lexer _startpos_desc_ _v _menhir_s _tok
        | _ ->
            _menhir_fail ()
    
    and _menhir_run_034 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _menhir_stack = MenhirCell1_LBRACKET (_menhir_stack, _menhir_s, _startpos) in
        let _menhir_s = MenhirState034 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.STRING_LIT _v ->
            _menhir_run_002 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.REAL_LIT _v ->
            _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.NOT ->
            _menhir_run_004 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.MINUS ->
            _menhir_run_005 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LPAR ->
            _menhir_run_006 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.INT_LIT _v ->
            _menhir_run_007 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.IF ->
            _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IDENTIFIER _v ->
            _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.COLON ->
            _menhir_run_035 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.BOOL_LIT _v ->
            _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BNOT ->
            _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.BITVECTOR_LIT _v ->
            _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.ARBITRARY ->
            _menhir_run_014 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | _ ->
            _eRR 34
    
    and _menhir_run_035 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
        let _menhir_stack = MenhirCell1_COLON (_menhir_stack, _menhir_s, _startpos, _endpos) in
        let _menhir_s = MenhirState035 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.STRING_LIT _v ->
            _menhir_run_002 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.REAL_LIT _v ->
            _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.NOT ->
            _menhir_run_004 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.MINUS ->
            _menhir_run_005 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LPAR ->
            _menhir_run_006 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.INT_LIT _v ->
            _menhir_run_007 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.IF ->
            _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IDENTIFIER _v ->
            _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BOOL_LIT _v ->
            _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BNOT ->
            _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.BITVECTOR_LIT _v ->
            _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.ARBITRARY ->
            _menhir_run_014 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | _ ->
            _eRR 35
    
    and _menhir_goto_basic_lexpr : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok ->
        match _menhir_s with
        | MenhirState908 ->
            _menhir_run_507 _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok
        | MenhirState869 ->
            _menhir_run_507 _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok
        | MenhirState864 ->
            _menhir_run_507 _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok
        | MenhirState843 ->
            _menhir_run_507 _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok
        | MenhirState838 ->
            _menhir_run_507 _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok
        | MenhirState820 ->
            _menhir_run_507 _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok
        | MenhirState824 ->
            _menhir_run_507 _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok
        | MenhirState809 ->
            _menhir_run_507 _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok
        | MenhirState815 ->
            _menhir_run_507 _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok
        | MenhirState797 ->
            _menhir_run_507 _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok
        | MenhirState792 ->
            _menhir_run_507 _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok
        | MenhirState769 ->
            _menhir_run_507 _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok
        | MenhirState760 ->
            _menhir_run_507 _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok
        | MenhirState750 ->
            _menhir_run_507 _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok
        | MenhirState735 ->
            _menhir_run_507 _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok
        | MenhirState730 ->
            _menhir_run_507 _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok
        | MenhirState720 ->
            _menhir_run_507 _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok
        | MenhirState715 ->
            _menhir_run_507 _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok
        | MenhirState704 ->
            _menhir_run_507 _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok
        | MenhirState699 ->
            _menhir_run_507 _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok
        | MenhirState687 ->
            _menhir_run_507 _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok
        | MenhirState682 ->
            _menhir_run_507 _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok
        | MenhirState672 ->
            _menhir_run_507 _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok
        | MenhirState667 ->
            _menhir_run_507 _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok
        | MenhirState656 ->
            _menhir_run_507 _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok
        | MenhirState651 ->
            _menhir_run_507 _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok
        | MenhirState000 ->
            _menhir_run_507 _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok
        | MenhirState317 ->
            _menhir_run_507 _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok
        | MenhirState365 ->
            _menhir_run_507 _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok
        | MenhirState553 ->
            _menhir_run_507 _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok
        | MenhirState549 ->
            _menhir_run_507 _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok
        | MenhirState546 ->
            _menhir_run_507 _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok
        | MenhirState373 ->
            _menhir_run_507 _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok
        | MenhirState422 ->
            _menhir_run_507 _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok
        | MenhirState527 ->
            _menhir_run_507 _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok
        | MenhirState529 ->
            _menhir_run_507 _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok
        | MenhirState452 ->
            _menhir_run_507 _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok
        | MenhirState513 ->
            _menhir_run_507 _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok
        | MenhirState509 ->
            _menhir_run_507 _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok
        | MenhirState476 ->
            _menhir_run_507 _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok
        | MenhirState481 ->
            _menhir_run_507 _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok
        | MenhirState387 ->
            _menhir_run_404 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
        | MenhirState400 ->
            _menhir_run_404 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
        | MenhirState402 ->
            _menhir_run_404 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
        | _ ->
            _menhir_fail ()
    
    and _menhir_run_507 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok ->
        let (_startpos_basic_lexpr_, basic_lexpr) = (_startpos, _v) in
        let _v = _menhir_action_225 basic_lexpr in
        _menhir_goto_lexpr _menhir_stack _menhir_lexbuf _menhir_lexer _startpos_basic_lexpr_ _v _menhir_s _tok
    
    and _menhir_run_404 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
        let basic_lexpr = _v in
        let _v = _menhir_action_113 basic_lexpr in
        _menhir_goto_discard_or_basic_lexpr _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
    
    and _menhir_run_396 : type  ttv_stack ttv_result. (((ttv_stack, ttv_result) _menhir_cell1_LLBRACKET, ttv_result) _menhir_cell1_expr, ttv_result) _menhir_cell1_RRBRACKET -> _ -> _ -> _ -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
        let MenhirCell1_RRBRACKET (_menhir_stack, _, _) = _menhir_stack in
        let MenhirCell1_expr (_menhir_stack, _, idx, _, _) = _menhir_stack in
        let MenhirCell1_LLBRACKET (_menhir_stack, _menhir_s) = _menhir_stack in
        let (_1, t, _3) = ((), _v, ()) in
        let _v = _menhir_action_005 _1 _3 idx t in
        _menhir_goto_access _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
    
    and _menhir_goto_clist1_discard_or_basic_lexpr_ : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_discard_or_basic_lexpr as 'stack) -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
        match _menhir_s with
        | MenhirState400 ->
            _menhir_run_405 _menhir_stack _menhir_lexbuf _menhir_lexer _v
        | MenhirState402 ->
            _menhir_run_403 _menhir_stack _menhir_lexbuf _menhir_lexer _v
        | _ ->
            _menhir_fail ()
    
    and _menhir_run_405 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_discard_or_basic_lexpr -> _ -> _ -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v ->
        let MenhirCell1_discard_or_basic_lexpr (_menhir_stack, _, x) = _menhir_stack in
        let (_2, li) = ((), _v) in
        let _v = _menhir_action_056 _2 li x in
        let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
        let _tok = _menhir_lexer _menhir_lexbuf in
        let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
        let (x, _endpos__3_) = (_v, _endpos) in
        let _v = _menhir_action_226 _endpos__3_ _startpos__1_ x in
        _menhir_goto_lexpr _menhir_stack _menhir_lexbuf _menhir_lexer _startpos__1_ _v _menhir_s _tok
    
    and _menhir_run_403 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_discard_or_basic_lexpr, ttv_result) _menhir_cell1_discard_or_basic_lexpr -> _ -> _ -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v ->
        let MenhirCell1_discard_or_basic_lexpr (_menhir_stack, _menhir_s, h) = _menhir_stack in
        let (_2, t) = ((), _v) in
        let _v = _menhir_action_033 _2 h t in
        _menhir_goto_clist1_discard_or_basic_lexpr_ _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
    
    and _menhir_run_399 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_LPAR as 'stack) -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
        let _menhir_stack = MenhirCell1_discard_or_basic_lexpr (_menhir_stack, _menhir_s, _v) in
        match (_tok : MenhirBasics.token) with
        | Tokens.COMMA ->
            let _menhir_s = MenhirState400 in
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.MINUS ->
                _menhir_run_388 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.IDENTIFIER _v ->
                _menhir_run_389 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | _ ->
                _eRR 400)
        | _ ->
            _eRR 399
    
    and _menhir_run_408 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _menhir_stack = MenhirCell1_LET (_menhir_stack, _menhir_s, _startpos) in
        let _menhir_s = MenhirState408 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.MINUS ->
            _menhir_run_319 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LPAR ->
            _menhir_run_320 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IDENTIFIER _v ->
            _menhir_run_409 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | _ ->
            _eRR 408
    
    and _menhir_run_320 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _menhir_stack = MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos) in
        let _menhir_s = MenhirState320 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.MINUS ->
            _menhir_run_321 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IDENTIFIER _v ->
            _menhir_run_322 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | _ ->
            _eRR 320
    
    and _menhir_run_321 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _tok = _menhir_lexer _menhir_lexbuf in
        let _1 = () in
        let _v = _menhir_action_116 _1 in
        _menhir_goto_discard_or_identifier _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
    
    and _menhir_goto_discard_or_identifier : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
        match _menhir_s with
        | MenhirState326 ->
            _menhir_run_325 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
        | MenhirState324 ->
            _menhir_run_325 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
        | MenhirState320 ->
            _menhir_run_323 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
        | _ ->
            _menhir_fail ()
    
    and _menhir_run_325 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_discard_or_identifier as 'stack) -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
        match (_tok : MenhirBasics.token) with
        | Tokens.COMMA ->
            let _menhir_stack = MenhirCell1_discard_or_identifier (_menhir_stack, _menhir_s, _v) in
            let _menhir_s = MenhirState326 in
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.MINUS ->
                _menhir_run_321 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.IDENTIFIER _v ->
                _menhir_run_322 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | _ ->
                _eRR 326)
        | Tokens.RPAR ->
            let x = _v in
            let _v = _menhir_action_036 x in
            _menhir_goto_clist1_discard_or_identifier_ _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | _ ->
            _eRR 325
    
    and _menhir_run_322 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
        let _tok = _menhir_lexer _menhir_lexbuf in
        let _1 = _v in
        let _v = _menhir_action_117 _1 in
        _menhir_goto_discard_or_identifier _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
    
    and _menhir_goto_clist1_discard_or_identifier_ : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_discard_or_identifier as 'stack) -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
        match _menhir_s with
        | MenhirState324 ->
            _menhir_run_328 _menhir_stack _menhir_lexbuf _menhir_lexer _v
        | MenhirState326 ->
            _menhir_run_327 _menhir_stack _menhir_lexbuf _menhir_lexer _v
        | _ ->
            _menhir_fail ()
    
    and _menhir_run_328 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_discard_or_identifier -> _ -> _ -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v ->
        let MenhirCell1_discard_or_identifier (_menhir_stack, _, x) = _menhir_stack in
        let (_2, li) = ((), _v) in
        let _v = _menhir_action_058 _2 li x in
        let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
        let _tok = _menhir_lexer _menhir_lexbuf in
        let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
        let (x, _endpos__3_) = (_v, _endpos) in
        let _v = _menhir_action_109 _endpos__3_ _startpos__1_ x in
        _menhir_goto_decl_item _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
    
    and _menhir_run_327 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_discard_or_identifier, ttv_result) _menhir_cell1_discard_or_identifier -> _ -> _ -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v ->
        let MenhirCell1_discard_or_identifier (_menhir_stack, _menhir_s, h) = _menhir_stack in
        let (_2, t) = ((), _v) in
        let _v = _menhir_action_037 _2 h t in
        _menhir_goto_clist1_discard_or_identifier_ _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
    
    and _menhir_run_323 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_LPAR as 'stack) -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
        let _menhir_stack = MenhirCell1_discard_or_identifier (_menhir_stack, _menhir_s, _v) in
        match (_tok : MenhirBasics.token) with
        | Tokens.COMMA ->
            let _menhir_s = MenhirState324 in
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.MINUS ->
                _menhir_run_321 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.IDENTIFIER _v ->
                _menhir_run_322 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | _ ->
                _eRR 324)
        | _ ->
            _eRR 323
    
    and _menhir_run_409 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
        let _tok = _menhir_lexer _menhir_lexbuf in
        let _1 = _v in
        let _v = _menhir_action_108 _1 in
        _menhir_goto_decl_item _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
    
    and _menhir_run_420 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _menhir_stack = MenhirCell1_IF (_menhir_stack, _menhir_s, _startpos) in
        let _menhir_s = MenhirState420 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.STRING_LIT _v ->
            _menhir_run_002 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.REAL_LIT _v ->
            _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.NOT ->
            _menhir_run_004 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.MINUS ->
            _menhir_run_005 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LPAR ->
            _menhir_run_006 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.INT_LIT _v ->
            _menhir_run_007 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.IF ->
            _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IDENTIFIER _v ->
            _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BOOL_LIT _v ->
            _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BNOT ->
            _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.BITVECTOR_LIT _v ->
            _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.ARBITRARY ->
            _menhir_run_014 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | _ ->
            _eRR 420
    
    and _menhir_run_423 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
        let _menhir_stack = MenhirCell1_IDENTIFIER (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.LPAR ->
            _menhir_run_010 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState423
        | Tokens.LLBRACKET ->
            _menhir_run_390 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState423
        | Tokens.LBRACE ->
            let _menhir_s = MenhirState423 in
            let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
            let _menhir_stack = MenhirCell1_LBRACE (_menhir_stack, _menhir_s, _startpos) in
            let _menhir_s = MenhirState424 in
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.STRING_LIT _v ->
                _menhir_run_002 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | Tokens.REAL_LIT _v ->
                _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | Tokens.NOT ->
                _menhir_run_004 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.MINUS ->
                _menhir_run_005 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.LPAR ->
                _menhir_run_006 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.INT_LIT _v ->
                _menhir_run_007 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | Tokens.IF ->
                _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.IDENTIFIER _v ->
                _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | Tokens.BOOL_LIT _v ->
                _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | Tokens.BNOT ->
                _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.BITVECTOR_LIT _v ->
                _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | Tokens.ARBITRARY ->
                _menhir_run_014 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | _ ->
                _eRR 424)
        | Tokens.DOT ->
            let _menhir_stack = MenhirCell1_DOT (_menhir_stack, MenhirState423) in
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.LPAR ->
                let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
                let _menhir_stack = MenhirCell0_LPAR (_menhir_stack, _startpos) in
                let _menhir_s = MenhirState426 in
                let _tok = _menhir_lexer _menhir_lexbuf in
                (match (_tok : MenhirBasics.token) with
                | Tokens.MINUS ->
                    _menhir_run_427 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
                | Tokens.IDENTIFIER _v ->
                    _menhir_run_428 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
                | _ ->
                    _eRR 426)
            | Tokens.LBRACKET ->
                let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
                let _menhir_stack = MenhirCell0_LBRACKET (_menhir_stack, _startpos) in
                let _menhir_s = MenhirState437 in
                let _tok = _menhir_lexer _menhir_lexbuf in
                (match (_tok : MenhirBasics.token) with
                | Tokens.IDENTIFIER _v ->
                    _menhir_run_438 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
                | _ ->
                    _eRR 437)
            | Tokens.IDENTIFIER _v ->
                _menhir_run_394 _menhir_stack _menhir_lexbuf _menhir_lexer _v
            | _ ->
                _eRR 425)
        | Tokens.EQ | Tokens.LBRACKET ->
            let _v_12 = _menhir_action_003 () in
            _menhir_run_397 _menhir_stack _menhir_lexbuf _menhir_lexer _v_12 MenhirState423 _tok
        | _ ->
            _eRR 423
    
    and _menhir_run_427 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _tok = _menhir_lexer _menhir_lexbuf in
        let _1 = () in
        let _v = _menhir_action_114 _1 in
        _menhir_goto_discard_or_field _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
    
    and _menhir_goto_discard_or_field : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
        match _menhir_s with
        | MenhirState432 ->
            _menhir_run_431 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
        | MenhirState430 ->
            _menhir_run_431 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
        | MenhirState426 ->
            _menhir_run_429 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
        | _ ->
            _menhir_fail ()
    
    and _menhir_run_431 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_discard_or_field as 'stack) -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
        match (_tok : MenhirBasics.token) with
        | Tokens.COMMA ->
            let _menhir_stack = MenhirCell1_discard_or_field (_menhir_stack, _menhir_s, _v) in
            let _menhir_s = MenhirState432 in
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.MINUS ->
                _menhir_run_427 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.IDENTIFIER _v ->
                _menhir_run_428 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | _ ->
                _eRR 432)
        | Tokens.RPAR ->
            let x = _v in
            let _v = _menhir_action_034 x in
            _menhir_goto_clist1_discard_or_field_ _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | _ ->
            _eRR 431
    
    and _menhir_run_428 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
        let _tok = _menhir_lexer _menhir_lexbuf in
        let (_endpos_desc_, _startpos_desc_, desc) = (_endpos, _startpos, _v) in
        let _v = _menhir_action_115 _endpos_desc_ _startpos_desc_ desc in
        _menhir_goto_discard_or_field _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
    
    and _menhir_goto_clist1_discard_or_field_ : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_discard_or_field as 'stack) -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
        match _menhir_s with
        | MenhirState430 ->
            _menhir_run_434 _menhir_stack _menhir_lexbuf _menhir_lexer _v
        | MenhirState432 ->
            _menhir_run_433 _menhir_stack _menhir_lexbuf _menhir_lexer _v
        | _ ->
            _menhir_fail ()
    
    and _menhir_run_434 : type  ttv_stack ttv_result. (((ttv_stack, ttv_result) _menhir_cell1_IDENTIFIER, ttv_result) _menhir_cell1_DOT _menhir_cell0_LPAR, ttv_result) _menhir_cell1_discard_or_field -> _ -> _ -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v ->
        let MenhirCell1_discard_or_field (_menhir_stack, _, x) = _menhir_stack in
        let (_2, li) = ((), _v) in
        let _v = _menhir_action_057 _2 li x in
        let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
        let _tok = _menhir_lexer _menhir_lexbuf in
        let MenhirCell0_LPAR (_menhir_stack, _) = _menhir_stack in
        let MenhirCell1_DOT (_menhir_stack, _) = _menhir_stack in
        let MenhirCell1_IDENTIFIER (_menhir_stack, _menhir_s, desc, _startpos_desc_, _endpos_desc_) = _menhir_stack in
        let (_2, x, _endpos__3_) = ((), _v, _endpos) in
        let _v = _menhir_action_229 _2 _endpos__3_ _endpos_desc_ _startpos_desc_ desc x in
        _menhir_goto_lexpr _menhir_stack _menhir_lexbuf _menhir_lexer _startpos_desc_ _v _menhir_s _tok
    
    and _menhir_run_433 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_discard_or_field, ttv_result) _menhir_cell1_discard_or_field -> _ -> _ -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v ->
        let MenhirCell1_discard_or_field (_menhir_stack, _menhir_s, h) = _menhir_stack in
        let (_2, t) = ((), _v) in
        let _v = _menhir_action_035 _2 h t in
        _menhir_goto_clist1_discard_or_field_ _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
    
    and _menhir_run_429 : type  ttv_stack ttv_result. (((ttv_stack, ttv_result) _menhir_cell1_IDENTIFIER, ttv_result) _menhir_cell1_DOT _menhir_cell0_LPAR as 'stack) -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
        let _menhir_stack = MenhirCell1_discard_or_field (_menhir_stack, _menhir_s, _v) in
        match (_tok : MenhirBasics.token) with
        | Tokens.COMMA ->
            let _menhir_s = MenhirState430 in
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.MINUS ->
                _menhir_run_427 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.IDENTIFIER _v ->
                _menhir_run_428 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | _ ->
                _eRR 430)
        | _ ->
            _eRR 429
    
    and _menhir_run_438 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_DOT _menhir_cell0_LBRACKET as 'stack) -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
        let _menhir_stack = MenhirCell1_IDENTIFIER (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.COMMA ->
            let _menhir_s = MenhirState439 in
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.IDENTIFIER _v ->
                _menhir_run_045 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | _ ->
                _eRR 439)
        | _ ->
            _eRR 438
    
    and _menhir_run_045 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.COMMA ->
            let _menhir_stack = MenhirCell1_IDENTIFIER (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            let _menhir_s = MenhirState046 in
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.IDENTIFIER _v ->
                _menhir_run_045 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | _ ->
                _eRR 46)
        | Tokens.RBRACKET ->
            let x = _v in
            let _v = _menhir_action_028 x in
            _menhir_goto_clist1_IDENTIFIER_ _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | _ ->
            _eRR 45
    
    and _menhir_goto_clist1_IDENTIFIER_ : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
        match _menhir_s with
        | MenhirState439 ->
            _menhir_run_440 _menhir_stack _menhir_lexbuf _menhir_lexer _v
        | MenhirState230 ->
            _menhir_run_231 _menhir_stack _menhir_lexbuf _menhir_lexer _v
        | MenhirState044 ->
            _menhir_run_048 _menhir_stack _menhir_lexbuf _menhir_lexer _v
        | MenhirState046 ->
            _menhir_run_047 _menhir_stack _menhir_lexbuf _menhir_lexer _v
        | _ ->
            _menhir_fail ()
    
    and _menhir_run_440 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_DOT _menhir_cell0_LBRACKET, ttv_result) _menhir_cell1_IDENTIFIER -> _ -> _ -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v ->
        let MenhirCell1_IDENTIFIER (_menhir_stack, _menhir_s, x, _, _) = _menhir_stack in
        let (_2, li) = ((), _v) in
        let _v = _menhir_action_054 _2 li x in
        _menhir_goto_clist2_IDENTIFIER_ _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
    
    and _menhir_goto_clist2_IDENTIFIER_ : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_DOT _menhir_cell0_LBRACKET as 'stack) -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
        match _menhir_s with
        | MenhirState490 ->
            _menhir_run_491 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | MenhirState437 ->
            _menhir_run_441 _menhir_stack _menhir_lexbuf _menhir_lexer _v
        | _ ->
            _menhir_fail ()
    
    and _menhir_run_491 : type  ttv_stack ttv_result. (((ttv_stack, ttv_result) _menhir_cell1_call, ttv_result) _menhir_cell1_DOT _menhir_cell0_LBRACKET as 'stack) -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
        let _menhir_stack = MenhirCell1_clist2_IDENTIFIER_ (_menhir_stack, _menhir_s, _v) in
        let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
        let _menhir_stack = MenhirCell0_RBRACKET (_menhir_stack, _endpos) in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.EQ ->
            let _menhir_s = MenhirState493 in
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.STRING_LIT _v ->
                _menhir_run_002 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | Tokens.REAL_LIT _v ->
                _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | Tokens.NOT ->
                _menhir_run_004 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.MINUS ->
                _menhir_run_005 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.LPAR ->
                _menhir_run_006 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.INT_LIT _v ->
                _menhir_run_007 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | Tokens.IF ->
                _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.IDENTIFIER _v ->
                _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | Tokens.BOOL_LIT _v ->
                _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | Tokens.BNOT ->
                _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.BITVECTOR_LIT _v ->
                _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | Tokens.ARBITRARY ->
                _menhir_run_014 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | _ ->
                _eRR 493)
        | _ ->
            _eRR 492
    
    and _menhir_run_441 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_IDENTIFIER, ttv_result) _menhir_cell1_DOT _menhir_cell0_LBRACKET -> _ -> _ -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v ->
        let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
        let _tok = _menhir_lexer _menhir_lexbuf in
        let MenhirCell0_LBRACKET (_menhir_stack, _) = _menhir_stack in
        let MenhirCell1_DOT (_menhir_stack, _) = _menhir_stack in
        let MenhirCell1_IDENTIFIER (_menhir_stack, _menhir_s, desc, _startpos_desc_, _endpos_desc_) = _menhir_stack in
        let (_2, x, _endpos__3_) = ((), _v, _endpos) in
        let _v = _menhir_action_228 _2 _endpos__3_ _endpos_desc_ _startpos_desc_ desc x in
        _menhir_goto_lexpr _menhir_stack _menhir_lexbuf _menhir_lexer _startpos_desc_ _v _menhir_s _tok
    
    and _menhir_run_231 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_expr_pattern, ttv_result) _menhir_cell1_DOT _menhir_cell0_LBRACKET -> _ -> _ -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v ->
        let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
        let _tok = _menhir_lexer _menhir_lexbuf in
        let MenhirCell0_LBRACKET (_menhir_stack, _) = _menhir_stack in
        let MenhirCell1_DOT (_menhir_stack, _) = _menhir_stack in
        let MenhirCell1_expr_pattern (_menhir_stack, _menhir_s, e, _startpos_e_, _) = _menhir_stack in
        let (_2, x, _endpos__3_) = ((), _v, _endpos) in
        let _v = _menhir_action_205 _2 _endpos__3_ _startpos_e_ e x in
        _menhir_goto_expr_pattern _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__3_ _startpos_e_ _v _menhir_s _tok
    
    and _menhir_run_048 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_expr, ttv_result) _menhir_cell1_DOT _menhir_cell0_LBRACKET -> _ -> _ -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v ->
        let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
        let _tok = _menhir_lexer _menhir_lexbuf in
        let MenhirCell0_LBRACKET (_menhir_stack, _) = _menhir_stack in
        let MenhirCell1_DOT (_menhir_stack, _) = _menhir_stack in
        let MenhirCell1_expr (_menhir_stack, _menhir_s, e, _startpos_e_, _) = _menhir_stack in
        let (_2, x, _endpos__3_) = ((), _v, _endpos) in
        let _v = _menhir_action_159 _2 _endpos__3_ _startpos_e_ e x in
        _menhir_goto_expr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__3_ _startpos_e_ _v _menhir_s _tok
    
    and _menhir_run_047 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_IDENTIFIER -> _ -> _ -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v ->
        let MenhirCell1_IDENTIFIER (_menhir_stack, _menhir_s, h, _, _) = _menhir_stack in
        let (_2, t) = ((), _v) in
        let _v = _menhir_action_029 _2 h t in
        _menhir_goto_clist1_IDENTIFIER_ _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
    
    and _menhir_run_443 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _menhir_stack = MenhirCell1_FOR (_menhir_stack, _menhir_s, _startpos) in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.IDENTIFIER _v ->
            let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
            let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
            let _menhir_stack = MenhirCell0_IDENTIFIER (_menhir_stack, _v, _startpos, _endpos) in
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.EQ ->
                let _menhir_s = MenhirState445 in
                let _tok = _menhir_lexer _menhir_lexbuf in
                (match (_tok : MenhirBasics.token) with
                | Tokens.STRING_LIT _v ->
                    _menhir_run_002 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
                | Tokens.REAL_LIT _v ->
                    _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
                | Tokens.NOT ->
                    _menhir_run_004 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
                | Tokens.MINUS ->
                    _menhir_run_005 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
                | Tokens.LPAR ->
                    _menhir_run_006 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
                | Tokens.INT_LIT _v ->
                    _menhir_run_007 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
                | Tokens.IF ->
                    _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
                | Tokens.IDENTIFIER _v ->
                    _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
                | Tokens.BOOL_LIT _v ->
                    _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
                | Tokens.BNOT ->
                    _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
                | Tokens.BITVECTOR_LIT _v ->
                    _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
                | Tokens.ARBITRARY ->
                    _menhir_run_014 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
                | _ ->
                    _eRR 445)
            | _ ->
                _eRR 444)
        | _ ->
            _eRR 443
    
    and _menhir_run_453 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _menhir_stack = MenhirCell1_DEBUG (_menhir_stack, _menhir_s, _startpos) in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.LPAR ->
            let _startpos_0 = _menhir_lexbuf.Lexing.lex_start_p in
            let _menhir_stack = MenhirCell0_LPAR (_menhir_stack, _startpos_0) in
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.STRING_LIT _v ->
                _menhir_run_002 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState454
            | Tokens.REAL_LIT _v ->
                _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState454
            | Tokens.NOT ->
                _menhir_run_004 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState454
            | Tokens.MINUS ->
                _menhir_run_005 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState454
            | Tokens.LPAR ->
                _menhir_run_006 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState454
            | Tokens.INT_LIT _v ->
                _menhir_run_007 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState454
            | Tokens.IF ->
                _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState454
            | Tokens.IDENTIFIER _v ->
                _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState454
            | Tokens.BOOL_LIT _v ->
                _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState454
            | Tokens.BNOT ->
                _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState454
            | Tokens.BITVECTOR_LIT _v ->
                _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState454
            | Tokens.ARBITRARY ->
                _menhir_run_014 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState454
            | Tokens.RPAR ->
                let _v = _menhir_action_024 () in
                _menhir_run_455 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
            | _ ->
                _eRR 454)
        | _ ->
            _eRR 453
    
    and _menhir_run_455 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_DEBUG _menhir_cell0_LPAR -> _ -> _ -> _ -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
        match (_tok : MenhirBasics.token) with
        | Tokens.RPAR ->
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.SEMI_COLON ->
                let _endpos_0 = _menhir_lexbuf.Lexing.lex_curr_p in
                let _tok = _menhir_lexer _menhir_lexbuf in
                let MenhirCell0_LPAR (_menhir_stack, _) = _menhir_stack in
                let MenhirCell1_DEBUG (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
                let (_1, _endpos__2_, x) = ((), _endpos_0, _v) in
                let _v = _menhir_action_302 _1 _endpos__2_ _startpos__1_ x in
                _menhir_goto_stmt _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__2_ _v _menhir_s _tok
            | _ ->
                _eRR 456)
        | _ ->
            _eRR 455
    
    and _menhir_run_458 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
        let _menhir_stack = MenhirCell1_CONSTANT (_menhir_stack, _menhir_s, _startpos, _endpos) in
        let _menhir_s = MenhirState458 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.MINUS ->
            _menhir_run_319 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LPAR ->
            _menhir_run_320 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IDENTIFIER _v ->
            _menhir_run_409 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | _ ->
            _eRR 458
    
    and _menhir_run_469 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _menhir_stack = MenhirCell1_CASE (_menhir_stack, _menhir_s, _startpos) in
        let _menhir_s = MenhirState469 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.STRING_LIT _v ->
            _menhir_run_002 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.REAL_LIT _v ->
            _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.NOT ->
            _menhir_run_004 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.MINUS ->
            _menhir_run_005 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LPAR ->
            _menhir_run_006 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.INT_LIT _v ->
            _menhir_run_007 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.IF ->
            _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IDENTIFIER _v ->
            _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BOOL_LIT _v ->
            _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BNOT ->
            _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.BITVECTOR_LIT _v ->
            _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.ARBITRARY ->
            _menhir_run_014 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | _ ->
            _eRR 469
    
    and _menhir_run_477 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _menhir_stack = MenhirCell1_ASSERT (_menhir_stack, _menhir_s, _startpos) in
        let _menhir_s = MenhirState477 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.STRING_LIT _v ->
            _menhir_run_002 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.REAL_LIT _v ->
            _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.NOT ->
            _menhir_run_004 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.MINUS ->
            _menhir_run_005 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LPAR ->
            _menhir_run_006 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.INT_LIT _v ->
            _menhir_run_007 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.IF ->
            _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IDENTIFIER _v ->
            _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BOOL_LIT _v ->
            _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BNOT ->
            _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.BITVECTOR_LIT _v ->
            _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.ARBITRARY ->
            _menhir_run_014 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | _ ->
            _eRR 477
    
    and _menhir_goto_list1_stmt_ : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok ->
        match _menhir_s with
        | MenhirState908 ->
            _menhir_run_508 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState869 ->
            _menhir_run_508 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState864 ->
            _menhir_run_508 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState843 ->
            _menhir_run_508 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState838 ->
            _menhir_run_508 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState820 ->
            _menhir_run_508 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState824 ->
            _menhir_run_508 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState809 ->
            _menhir_run_508 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState815 ->
            _menhir_run_508 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState797 ->
            _menhir_run_508 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState792 ->
            _menhir_run_508 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState769 ->
            _menhir_run_508 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState760 ->
            _menhir_run_508 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState750 ->
            _menhir_run_508 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState735 ->
            _menhir_run_508 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState730 ->
            _menhir_run_508 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState720 ->
            _menhir_run_508 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState715 ->
            _menhir_run_508 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState704 ->
            _menhir_run_508 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState699 ->
            _menhir_run_508 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState687 ->
            _menhir_run_508 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState682 ->
            _menhir_run_508 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState672 ->
            _menhir_run_508 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState667 ->
            _menhir_run_508 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState656 ->
            _menhir_run_508 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState651 ->
            _menhir_run_508 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState317 ->
            _menhir_run_508 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState365 ->
            _menhir_run_508 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState553 ->
            _menhir_run_508 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState549 ->
            _menhir_run_508 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState546 ->
            _menhir_run_508 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState373 ->
            _menhir_run_508 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState422 ->
            _menhir_run_508 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState527 ->
            _menhir_run_508 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState529 ->
            _menhir_run_508 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState452 ->
            _menhir_run_508 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState513 ->
            _menhir_run_508 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState509 ->
            _menhir_run_508 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState476 ->
            _menhir_run_508 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState481 ->
            _menhir_run_482 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
        | _ ->
            _menhir_fail ()
    
    and _menhir_run_508 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok ->
        let (_endpos__1_, _1) = (_endpos, _v) in
        let _v = _menhir_action_307 _1 in
        _menhir_goto_stmt_list _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__1_ _v _menhir_s _tok
    
    and _menhir_goto_stmt_list : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok ->
        match _menhir_s with
        | MenhirState908 ->
            _menhir_run_910 _menhir_stack _v _tok
        | MenhirState869 ->
            _menhir_run_870 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
        | MenhirState864 ->
            _menhir_run_865 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
        | MenhirState843 ->
            _menhir_run_844 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
        | MenhirState838 ->
            _menhir_run_839 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
        | MenhirState824 ->
            _menhir_run_825 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
        | MenhirState820 ->
            _menhir_run_821 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState815 ->
            _menhir_run_816 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
        | MenhirState809 ->
            _menhir_run_810 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState797 ->
            _menhir_run_798 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
        | MenhirState792 ->
            _menhir_run_793 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
        | MenhirState769 ->
            _menhir_run_770 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
        | MenhirState760 ->
            _menhir_run_761 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
        | MenhirState750 ->
            _menhir_run_751 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
        | MenhirState735 ->
            _menhir_run_736 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
        | MenhirState730 ->
            _menhir_run_731 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
        | MenhirState720 ->
            _menhir_run_721 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
        | MenhirState715 ->
            _menhir_run_716 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
        | MenhirState704 ->
            _menhir_run_705 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
        | MenhirState699 ->
            _menhir_run_700 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
        | MenhirState687 ->
            _menhir_run_688 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
        | MenhirState682 ->
            _menhir_run_683 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
        | MenhirState672 ->
            _menhir_run_673 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
        | MenhirState667 ->
            _menhir_run_668 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
        | MenhirState656 ->
            _menhir_run_657 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
        | MenhirState651 ->
            _menhir_run_652 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
        | MenhirState317 ->
            _menhir_run_560 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
        | MenhirState553 ->
            _menhir_run_554 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
        | MenhirState549 ->
            _menhir_run_550 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
        | MenhirState546 ->
            _menhir_run_547 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
        | MenhirState365 ->
            _menhir_run_540 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState373 ->
            _menhir_run_535 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState529 ->
            _menhir_run_530 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
        | MenhirState527 ->
            _menhir_run_528 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState422 ->
            _menhir_run_524 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
        | MenhirState452 ->
            _menhir_run_521 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
        | MenhirState513 ->
            _menhir_run_514 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
        | MenhirState509 ->
            _menhir_run_510 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
        | MenhirState476 ->
            _menhir_run_480 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
        | _ ->
            _menhir_fail ()
    
    and _menhir_run_870 : type  ttv_stack. ((((ttv_stack, _menhir_box_spec) _menhir_cell1_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args, _menhir_box_spec) _menhir_cell1_recurse_limit -> _ -> _ -> _ -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
        match (_tok : MenhirBasics.token) with
        | Tokens.END ->
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.SEMI_COLON ->
                let _endpos_0 = _menhir_lexbuf.Lexing.lex_curr_p in
                let _tok = _menhir_lexer _menhir_lexbuf in
                let MenhirCell1_recurse_limit (_menhir_stack, _, recurse_limit) = _menhir_stack in
                let MenhirCell1_func_args (_menhir_stack, _, func_args) = _menhir_stack in
                let MenhirCell1_params_opt (_menhir_stack, _, params_opt) = _menhir_stack in
                let MenhirCell0_IDENTIFIER (_menhir_stack, name, _, _) = _menhir_stack in
                let MenhirCell1_FUNC (_menhir_stack, _menhir_s, _startpos__3_) = _menhir_stack in
                let (_endpos__2_, _2, x, _3, _1_inlined1) = (_endpos_0, (), _v, (), ()) in
                let _v = _menhir_action_076 _1_inlined1 _2 _3 _endpos__2_ _startpos__3_ func_args name params_opt recurse_limit x in
                _menhir_goto_decl _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
            | _ ->
                _eRR 871)
        | _ ->
            _eRR 870
    
    and _menhir_run_865 : type  ttv_stack. (((((ttv_stack, _menhir_box_spec) _menhir_cell1_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args, _menhir_box_spec) _menhir_cell1_return_type, _menhir_box_spec) _menhir_cell1_recurse_limit -> _ -> _ -> _ -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
        match (_tok : MenhirBasics.token) with
        | Tokens.END ->
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.SEMI_COLON ->
                let _endpos_0 = _menhir_lexbuf.Lexing.lex_curr_p in
                let _tok = _menhir_lexer _menhir_lexbuf in
                let MenhirCell1_recurse_limit (_menhir_stack, _, recurse_limit) = _menhir_stack in
                let MenhirCell1_return_type (_menhir_stack, _, return_type) = _menhir_stack in
                let MenhirCell1_func_args (_menhir_stack, _, func_args) = _menhir_stack in
                let MenhirCell1_params_opt (_menhir_stack, _, params_opt) = _menhir_stack in
                let MenhirCell0_IDENTIFIER (_menhir_stack, name, _, _) = _menhir_stack in
                let MenhirCell1_FUNC (_menhir_stack, _menhir_s, _startpos__3_) = _menhir_stack in
                let (_endpos__2_, _2, x, _3, _1_inlined1) = (_endpos_0, (), _v, (), ()) in
                let _v = _menhir_action_067 _1_inlined1 _2 _3 _endpos__2_ _startpos__3_ func_args name params_opt recurse_limit return_type x in
                _menhir_goto_decl _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
            | _ ->
                _eRR 866)
        | _ ->
            _eRR 865
    
    and _menhir_run_844 : type  ttv_stack. ((((ttv_stack, _menhir_box_spec) _menhir_cell1_IMPDEF _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args, _menhir_box_spec) _menhir_cell1_recurse_limit -> _ -> _ -> _ -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
        match (_tok : MenhirBasics.token) with
        | Tokens.END ->
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.SEMI_COLON ->
                let _endpos_0 = _menhir_lexbuf.Lexing.lex_curr_p in
                let _tok = _menhir_lexer _menhir_lexbuf in
                let MenhirCell1_recurse_limit (_menhir_stack, _, recurse_limit) = _menhir_stack in
                let MenhirCell1_func_args (_menhir_stack, _, func_args) = _menhir_stack in
                let MenhirCell1_params_opt (_menhir_stack, _, params_opt) = _menhir_stack in
                let MenhirCell0_IDENTIFIER (_menhir_stack, name, _, _) = _menhir_stack in
                let MenhirCell0_FUNC (_menhir_stack, _) = _menhir_stack in
                let MenhirCell1_IMPDEF (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
                let (_1, _endpos__2_, _2, x, _3, _1_inlined2) = ((), _endpos_0, (), _v, (), ()) in
                let _v = _menhir_action_077 _1 _1_inlined2 _2 _3 _endpos__2_ _startpos__1_ func_args name params_opt recurse_limit x in
                _menhir_goto_decl _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
            | _ ->
                _eRR 845)
        | _ ->
            _eRR 844
    
    and _menhir_run_839 : type  ttv_stack. (((((ttv_stack, _menhir_box_spec) _menhir_cell1_IMPDEF _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args, _menhir_box_spec) _menhir_cell1_return_type, _menhir_box_spec) _menhir_cell1_recurse_limit -> _ -> _ -> _ -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
        match (_tok : MenhirBasics.token) with
        | Tokens.END ->
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.SEMI_COLON ->
                let _endpos_0 = _menhir_lexbuf.Lexing.lex_curr_p in
                let _tok = _menhir_lexer _menhir_lexbuf in
                let MenhirCell1_recurse_limit (_menhir_stack, _, recurse_limit) = _menhir_stack in
                let MenhirCell1_return_type (_menhir_stack, _, return_type) = _menhir_stack in
                let MenhirCell1_func_args (_menhir_stack, _, func_args) = _menhir_stack in
                let MenhirCell1_params_opt (_menhir_stack, _, params_opt) = _menhir_stack in
                let MenhirCell0_IDENTIFIER (_menhir_stack, name, _, _) = _menhir_stack in
                let MenhirCell0_FUNC (_menhir_stack, _) = _menhir_stack in
                let MenhirCell1_IMPDEF (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
                let (_1, _endpos__2_, _2, x, _3, _1_inlined2) = ((), _endpos_0, (), _v, (), ()) in
                let _v = _menhir_action_068 _1 _1_inlined2 _2 _3 _endpos__2_ _startpos__1_ func_args name params_opt recurse_limit return_type x in
                _menhir_goto_decl _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
            | _ ->
                _eRR 840)
        | _ ->
            _eRR 839
    
    and _menhir_run_825 : type  ttv_stack. (((((ttv_stack _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_as_ty, _menhir_box_spec) _menhir_cell1_is_readonly, _menhir_box_spec) _menhir_cell1_stmt_list _menhir_cell0_SEMI_COLON -> _ -> _ -> _ -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
        match (_tok : MenhirBasics.token) with
        | Tokens.END ->
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.SEMI_COLON ->
                let _tok = _menhir_lexer _menhir_lexbuf in
                let MenhirCell0_SEMI_COLON (_menhir_stack, _) = _menhir_stack in
                let MenhirCell1_stmt_list (_menhir_stack, _, getter, _) = _menhir_stack in
                let MenhirCell1_is_readonly (_menhir_stack, _menhir_s, is_readonly) = _menhir_stack in
                let (_1, _2, _2_inlined1, _5, _1_inlined1, _2_inlined2, setter) = ((), (), (), (), (), (), _v) in
                let _v = _menhir_action_006 _1 _1_inlined1 _2 _2_inlined1 _2_inlined2 _5 getter is_readonly setter in
                _menhir_goto_accessors _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
            | _ ->
                _eRR 826)
        | _ ->
            _eRR 825
    
    and _menhir_goto_accessors : type  ttv_stack. ((((ttv_stack _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_as_ty as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_spec) _menhir_state -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
        match _menhir_s with
        | MenhirState899 ->
            _menhir_run_900 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
        | MenhirState854 ->
            _menhir_run_855 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
        | MenhirState808 ->
            _menhir_run_828 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
        | _ ->
            _menhir_fail ()
    
    and _menhir_run_900 : type  ttv_stack. ((((ttv_stack, _menhir_box_spec) _menhir_cell1_ACCESSOR _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_as_ty -> _ -> _ -> _ -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
        match (_tok : MenhirBasics.token) with
        | Tokens.END ->
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.SEMI_COLON ->
                let _tok = _menhir_lexer _menhir_lexbuf in
                let MenhirCell1_as_ty (_menhir_stack, _, as_ty) = _menhir_stack in
                let MenhirCell0_IDENTIFIER (_menhir_stack, setter_arg, _, _) = _menhir_stack in
                let MenhirCell1_func_args (_menhir_stack, _, func_args) = _menhir_stack in
                let MenhirCell1_params_opt (_menhir_stack, _, params_opt) = _menhir_stack in
                let MenhirCell0_IDENTIFIER (_menhir_stack, name, _, _) = _menhir_stack in
                let MenhirCell1_ACCESSOR (_menhir_stack, _menhir_s) = _menhir_stack in
                let (_1, _2, _2_inlined1, _1_inlined1, accessors, _6) = ((), (), (), (), _v, ()) in
                let _v = _menhir_action_104 _1 _1_inlined1 _2 _2_inlined1 _6 accessors as_ty func_args name params_opt setter_arg in
                _menhir_goto_decl _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
            | _ ->
                _eRR 901)
        | _ ->
            _eRR 900
    
    and _menhir_run_855 : type  ttv_stack. ((((ttv_stack, _menhir_box_spec) _menhir_cell1_IMPDEF _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_as_ty -> _ -> _ -> _ -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
        match (_tok : MenhirBasics.token) with
        | Tokens.END ->
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.SEMI_COLON ->
                let _tok = _menhir_lexer _menhir_lexbuf in
                let MenhirCell1_as_ty (_menhir_stack, _, as_ty) = _menhir_stack in
                let MenhirCell0_IDENTIFIER (_menhir_stack, setter_arg, _, _) = _menhir_stack in
                let MenhirCell1_func_args (_menhir_stack, _, func_args) = _menhir_stack in
                let MenhirCell1_params_opt (_menhir_stack, _, params_opt) = _menhir_stack in
                let MenhirCell0_IDENTIFIER (_menhir_stack, name, _, _) = _menhir_stack in
                let MenhirCell1_IMPDEF (_menhir_stack, _menhir_s, _) = _menhir_stack in
                let (_1, _2, _2_inlined1, _1_inlined1, _1_inlined2, accessors, _6) = ((), (), (), (), (), _v, ()) in
                let _v = _menhir_action_105 _1 _1_inlined1 _1_inlined2 _2 _2_inlined1 _6 accessors as_ty func_args name params_opt setter_arg in
                _menhir_goto_decl _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
            | _ ->
                _eRR 856)
        | _ ->
            _eRR 855
    
    and _menhir_run_828 : type  ttv_stack. ((((ttv_stack, _menhir_box_spec) _menhir_cell1_IMPLEMENTATION _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_as_ty -> _ -> _ -> _ -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
        match (_tok : MenhirBasics.token) with
        | Tokens.END ->
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.SEMI_COLON ->
                let _tok = _menhir_lexer _menhir_lexbuf in
                let MenhirCell1_as_ty (_menhir_stack, _, as_ty) = _menhir_stack in
                let MenhirCell0_IDENTIFIER (_menhir_stack, setter_arg, _, _) = _menhir_stack in
                let MenhirCell1_func_args (_menhir_stack, _, func_args) = _menhir_stack in
                let MenhirCell1_params_opt (_menhir_stack, _, params_opt) = _menhir_stack in
                let MenhirCell0_IDENTIFIER (_menhir_stack, name, _, _) = _menhir_stack in
                let MenhirCell1_IMPLEMENTATION (_menhir_stack, _menhir_s, _) = _menhir_stack in
                let (_1, _2, _2_inlined1, _1_inlined1, _1_inlined2, accessors, _6) = ((), (), (), (), (), _v, ()) in
                let _v = _menhir_action_106 _1 _1_inlined1 _1_inlined2 _2 _2_inlined1 _6 accessors as_ty func_args name params_opt setter_arg in
                _menhir_goto_decl _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
            | _ ->
                _eRR 829)
        | _ ->
            _eRR 828
    
    and _menhir_run_821 : type  ttv_stack. (((((ttv_stack _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_as_ty, _menhir_box_spec) _menhir_cell1_is_readonly as 'stack) -> _ -> _ -> _ -> _ -> ('stack, _menhir_box_spec) _menhir_state -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok ->
        let _menhir_stack = MenhirCell1_stmt_list (_menhir_stack, _menhir_s, _v, _endpos) in
        match (_tok : MenhirBasics.token) with
        | Tokens.END ->
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.SEMI_COLON ->
                let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
                let _menhir_stack = MenhirCell0_SEMI_COLON (_menhir_stack, _endpos) in
                let _tok = _menhir_lexer _menhir_lexbuf in
                (match (_tok : MenhirBasics.token) with
                | Tokens.SETTER ->
                    let _menhir_s = MenhirState824 in
                    let _tok = _menhir_lexer _menhir_lexbuf in
                    (match (_tok : MenhirBasics.token) with
                    | Tokens.WHILE ->
                        _menhir_run_001 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
                    | Tokens.VAR ->
                        _menhir_run_318 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
                    | Tokens.UNREACHABLE ->
                        _menhir_run_363 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
                    | Tokens.TRY ->
                        _menhir_run_365 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
                    | Tokens.THROW ->
                        _menhir_run_366 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
                    | Tokens.RETURN ->
                        _menhir_run_369 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
                    | Tokens.REPEAT ->
                        _menhir_run_373 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
                    | Tokens.PRINTLN ->
                        _menhir_run_374 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
                    | Tokens.PRINT ->
                        _menhir_run_377 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
                    | Tokens.PRAGMA ->
                        _menhir_run_380 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
                    | Tokens.PASS ->
                        _menhir_run_384 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
                    | Tokens.MINUS ->
                        _menhir_run_386 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
                    | Tokens.LPAR ->
                        _menhir_run_387 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
                    | Tokens.LET ->
                        _menhir_run_408 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
                    | Tokens.IF ->
                        _menhir_run_420 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
                    | Tokens.IDENTIFIER _v ->
                        _menhir_run_423 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
                    | Tokens.FOR ->
                        _menhir_run_443 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
                    | Tokens.DEBUG ->
                        _menhir_run_453 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
                    | Tokens.CONSTANT ->
                        _menhir_run_458 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
                    | Tokens.CASE ->
                        _menhir_run_469 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
                    | Tokens.ASSERT ->
                        _menhir_run_477 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
                    | _ ->
                        _eRR 824)
                | _ ->
                    _eRR 823)
            | _ ->
                _eRR 822)
        | _ ->
            _eRR 821
    
    and _menhir_run_816 : type  ttv_stack. ((((((ttv_stack _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_as_ty, _menhir_box_spec) _menhir_cell1_SETTER, _menhir_box_spec) _menhir_cell1_stmt_list _menhir_cell0_SEMI_COLON, _menhir_box_spec) _menhir_cell1_is_readonly -> _ -> _ -> _ -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
        match (_tok : MenhirBasics.token) with
        | Tokens.END ->
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.SEMI_COLON ->
                let _tok = _menhir_lexer _menhir_lexbuf in
                let MenhirCell1_is_readonly (_menhir_stack, _, is_readonly) = _menhir_stack in
                let MenhirCell0_SEMI_COLON (_menhir_stack, _) = _menhir_stack in
                let MenhirCell1_stmt_list (_menhir_stack, _, setter, _) = _menhir_stack in
                let MenhirCell1_SETTER (_menhir_stack, _menhir_s) = _menhir_stack in
                let (_1, _2, _2_inlined1, _5, _1_inlined1, _1_inlined2, getter) = ((), (), (), (), (), (), _v) in
                let _v = _menhir_action_007 _1 _1_inlined1 _1_inlined2 _2 _2_inlined1 _5 getter is_readonly setter in
                _menhir_goto_accessors _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
            | _ ->
                _eRR 817)
        | _ ->
            _eRR 816
    
    and _menhir_run_810 : type  ttv_stack. (((((ttv_stack _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_as_ty, _menhir_box_spec) _menhir_cell1_SETTER as 'stack) -> _ -> _ -> _ -> _ -> ('stack, _menhir_box_spec) _menhir_state -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok ->
        let _menhir_stack = MenhirCell1_stmt_list (_menhir_stack, _menhir_s, _v, _endpos) in
        match (_tok : MenhirBasics.token) with
        | Tokens.END ->
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.SEMI_COLON ->
                let _endpos_0 = _menhir_lexbuf.Lexing.lex_curr_p in
                let _menhir_stack = MenhirCell0_SEMI_COLON (_menhir_stack, _endpos_0) in
                let _tok = _menhir_lexer _menhir_lexbuf in
                (match (_tok : MenhirBasics.token) with
                | Tokens.READONLY ->
                    _menhir_run_813 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState812
                | Tokens.GETTER ->
                    let _v_1 = _menhir_action_223 () in
                    _menhir_run_814 _menhir_stack _menhir_lexbuf _menhir_lexer _v_1 MenhirState812 _tok
                | _ ->
                    _eRR 812)
            | _ ->
                _eRR 811)
        | _ ->
            _eRR 810
    
    and _menhir_run_813 : type  ttv_stack. ttv_stack -> _ -> _ -> (ttv_stack, _menhir_box_spec) _menhir_state -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _tok = _menhir_lexer _menhir_lexbuf in
        let _1 = () in
        let _v = _menhir_action_224 _1 in
        _menhir_goto_is_readonly _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
    
    and _menhir_goto_is_readonly : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> (ttv_stack, _menhir_box_spec) _menhir_state -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
        match _menhir_s with
        | MenhirState899 ->
            _menhir_run_819 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
        | MenhirState854 ->
            _menhir_run_819 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
        | MenhirState808 ->
            _menhir_run_819 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
        | MenhirState812 ->
            _menhir_run_814 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
        | _ ->
            _menhir_fail ()
    
    and _menhir_run_819 : type  ttv_stack. ((((ttv_stack _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_as_ty as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_spec) _menhir_state -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
        let _menhir_stack = MenhirCell1_is_readonly (_menhir_stack, _menhir_s, _v) in
        match (_tok : MenhirBasics.token) with
        | Tokens.GETTER ->
            let _menhir_s = MenhirState820 in
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.WHILE ->
                _menhir_run_001 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.VAR ->
                _menhir_run_318 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.UNREACHABLE ->
                _menhir_run_363 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.TRY ->
                _menhir_run_365 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.THROW ->
                _menhir_run_366 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.RETURN ->
                _menhir_run_369 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.REPEAT ->
                _menhir_run_373 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.PRINTLN ->
                _menhir_run_374 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.PRINT ->
                _menhir_run_377 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.PRAGMA ->
                _menhir_run_380 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.PASS ->
                _menhir_run_384 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.MINUS ->
                _menhir_run_386 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.LPAR ->
                _menhir_run_387 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.LET ->
                _menhir_run_408 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.IF ->
                _menhir_run_420 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.IDENTIFIER _v ->
                _menhir_run_423 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | Tokens.FOR ->
                _menhir_run_443 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.DEBUG ->
                _menhir_run_453 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.CONSTANT ->
                _menhir_run_458 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.CASE ->
                _menhir_run_469 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.ASSERT ->
                _menhir_run_477 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | _ ->
                _eRR 820)
        | _ ->
            _eRR 819
    
    and _menhir_run_814 : type  ttv_stack. ((((((ttv_stack _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_as_ty, _menhir_box_spec) _menhir_cell1_SETTER, _menhir_box_spec) _menhir_cell1_stmt_list _menhir_cell0_SEMI_COLON as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_spec) _menhir_state -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
        let _menhir_stack = MenhirCell1_is_readonly (_menhir_stack, _menhir_s, _v) in
        match (_tok : MenhirBasics.token) with
        | Tokens.GETTER ->
            let _menhir_s = MenhirState815 in
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.WHILE ->
                _menhir_run_001 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.VAR ->
                _menhir_run_318 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.UNREACHABLE ->
                _menhir_run_363 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.TRY ->
                _menhir_run_365 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.THROW ->
                _menhir_run_366 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.RETURN ->
                _menhir_run_369 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.REPEAT ->
                _menhir_run_373 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.PRINTLN ->
                _menhir_run_374 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.PRINT ->
                _menhir_run_377 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.PRAGMA ->
                _menhir_run_380 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.PASS ->
                _menhir_run_384 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.MINUS ->
                _menhir_run_386 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.LPAR ->
                _menhir_run_387 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.LET ->
                _menhir_run_408 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.IF ->
                _menhir_run_420 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.IDENTIFIER _v ->
                _menhir_run_423 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | Tokens.FOR ->
                _menhir_run_443 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.DEBUG ->
                _menhir_run_453 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.CONSTANT ->
                _menhir_run_458 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.CASE ->
                _menhir_run_469 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.ASSERT ->
                _menhir_run_477 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | _ ->
                _eRR 815)
        | _ ->
            _eRR 814
    
    and _menhir_run_798 : type  ttv_stack. ((((ttv_stack, _menhir_box_spec) _menhir_cell1_IMPLEMENTATION _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args, _menhir_box_spec) _menhir_cell1_recurse_limit -> _ -> _ -> _ -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
        match (_tok : MenhirBasics.token) with
        | Tokens.END ->
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.SEMI_COLON ->
                let _endpos_0 = _menhir_lexbuf.Lexing.lex_curr_p in
                let _tok = _menhir_lexer _menhir_lexbuf in
                let MenhirCell1_recurse_limit (_menhir_stack, _, recurse_limit) = _menhir_stack in
                let MenhirCell1_func_args (_menhir_stack, _, func_args) = _menhir_stack in
                let MenhirCell1_params_opt (_menhir_stack, _, params_opt) = _menhir_stack in
                let MenhirCell0_IDENTIFIER (_menhir_stack, name, _, _) = _menhir_stack in
                let MenhirCell0_FUNC (_menhir_stack, _) = _menhir_stack in
                let MenhirCell1_IMPLEMENTATION (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
                let (_1, _endpos__2_, _2, x, _3, _1_inlined2) = ((), _endpos_0, (), _v, (), ()) in
                let _v = _menhir_action_078 _1 _1_inlined2 _2 _3 _endpos__2_ _startpos__1_ func_args name params_opt recurse_limit x in
                _menhir_goto_decl _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
            | _ ->
                _eRR 799)
        | _ ->
            _eRR 798
    
    and _menhir_run_793 : type  ttv_stack. (((((ttv_stack, _menhir_box_spec) _menhir_cell1_IMPLEMENTATION _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args, _menhir_box_spec) _menhir_cell1_return_type, _menhir_box_spec) _menhir_cell1_recurse_limit -> _ -> _ -> _ -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
        match (_tok : MenhirBasics.token) with
        | Tokens.END ->
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.SEMI_COLON ->
                let _endpos_0 = _menhir_lexbuf.Lexing.lex_curr_p in
                let _tok = _menhir_lexer _menhir_lexbuf in
                let MenhirCell1_recurse_limit (_menhir_stack, _, recurse_limit) = _menhir_stack in
                let MenhirCell1_return_type (_menhir_stack, _, return_type) = _menhir_stack in
                let MenhirCell1_func_args (_menhir_stack, _, func_args) = _menhir_stack in
                let MenhirCell1_params_opt (_menhir_stack, _, params_opt) = _menhir_stack in
                let MenhirCell0_IDENTIFIER (_menhir_stack, name, _, _) = _menhir_stack in
                let MenhirCell0_FUNC (_menhir_stack, _) = _menhir_stack in
                let MenhirCell1_IMPLEMENTATION (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
                let (_1, _endpos__2_, _2, x, _3, _1_inlined2) = ((), _endpos_0, (), _v, (), ()) in
                let _v = _menhir_action_069 _1 _1_inlined2 _2 _3 _endpos__2_ _startpos__1_ func_args name params_opt recurse_limit return_type x in
                _menhir_goto_decl _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
            | _ ->
                _eRR 794)
        | _ ->
            _eRR 793
    
    and _menhir_run_770 : type  ttv_stack. ((((ttv_stack, _menhir_box_spec) _menhir_cell1_NORETURN _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args, _menhir_box_spec) _menhir_cell1_recurse_limit -> _ -> _ -> _ -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
        match (_tok : MenhirBasics.token) with
        | Tokens.END ->
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.SEMI_COLON ->
                let _endpos_0 = _menhir_lexbuf.Lexing.lex_curr_p in
                let _tok = _menhir_lexer _menhir_lexbuf in
                let MenhirCell1_recurse_limit (_menhir_stack, _, recurse_limit) = _menhir_stack in
                let MenhirCell1_func_args (_menhir_stack, _, func_args) = _menhir_stack in
                let MenhirCell1_params_opt (_menhir_stack, _, params_opt) = _menhir_stack in
                let MenhirCell0_IDENTIFIER (_menhir_stack, name, _, _) = _menhir_stack in
                let MenhirCell0_FUNC (_menhir_stack, _) = _menhir_stack in
                let MenhirCell1_NORETURN (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
                let (_1, _endpos__2_, _2, x, _3, _1_inlined2) = ((), _endpos_0, (), _v, (), ()) in
                let _v = _menhir_action_085 _1 _1_inlined2 _2 _3 _endpos__2_ _startpos__1_ func_args name params_opt recurse_limit x in
                _menhir_goto_decl _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
            | _ ->
                _eRR 771)
        | _ ->
            _eRR 770
    
    and _menhir_run_761 : type  ttv_stack. ((((ttv_stack, _menhir_box_spec) _menhir_cell1_NORETURN _menhir_cell0_IMPDEF _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args, _menhir_box_spec) _menhir_cell1_recurse_limit -> _ -> _ -> _ -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
        match (_tok : MenhirBasics.token) with
        | Tokens.END ->
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.SEMI_COLON ->
                let _endpos_0 = _menhir_lexbuf.Lexing.lex_curr_p in
                let _tok = _menhir_lexer _menhir_lexbuf in
                let MenhirCell1_recurse_limit (_menhir_stack, _, recurse_limit) = _menhir_stack in
                let MenhirCell1_func_args (_menhir_stack, _, func_args) = _menhir_stack in
                let MenhirCell1_params_opt (_menhir_stack, _, params_opt) = _menhir_stack in
                let MenhirCell0_IDENTIFIER (_menhir_stack, name, _, _) = _menhir_stack in
                let MenhirCell0_FUNC (_menhir_stack, _) = _menhir_stack in
                let MenhirCell0_IMPDEF (_menhir_stack, _) = _menhir_stack in
                let MenhirCell1_NORETURN (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
                let (_1, _endpos__2_, _2, x, _3, _1_inlined1, _1_inlined3) = ((), _endpos_0, (), _v, (), (), ()) in
                let _v = _menhir_action_086 _1 _1_inlined1 _1_inlined3 _2 _3 _endpos__2_ _startpos__1_ func_args name params_opt recurse_limit x in
                _menhir_goto_decl _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
            | _ ->
                _eRR 762)
        | _ ->
            _eRR 761
    
    and _menhir_run_751 : type  ttv_stack. ((((ttv_stack, _menhir_box_spec) _menhir_cell1_NORETURN _menhir_cell0_IMPLEMENTATION _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args, _menhir_box_spec) _menhir_cell1_recurse_limit -> _ -> _ -> _ -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
        match (_tok : MenhirBasics.token) with
        | Tokens.END ->
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.SEMI_COLON ->
                let _endpos_0 = _menhir_lexbuf.Lexing.lex_curr_p in
                let _tok = _menhir_lexer _menhir_lexbuf in
                let MenhirCell1_recurse_limit (_menhir_stack, _, recurse_limit) = _menhir_stack in
                let MenhirCell1_func_args (_menhir_stack, _, func_args) = _menhir_stack in
                let MenhirCell1_params_opt (_menhir_stack, _, params_opt) = _menhir_stack in
                let MenhirCell0_IDENTIFIER (_menhir_stack, name, _, _) = _menhir_stack in
                let MenhirCell0_FUNC (_menhir_stack, _) = _menhir_stack in
                let MenhirCell0_IMPLEMENTATION (_menhir_stack, _) = _menhir_stack in
                let MenhirCell1_NORETURN (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
                let (_1, _endpos__2_, _2, x, _3, _1_inlined1, _1_inlined3) = ((), _endpos_0, (), _v, (), (), ()) in
                let _v = _menhir_action_087 _1 _1_inlined1 _1_inlined3 _2 _3 _endpos__2_ _startpos__1_ func_args name params_opt recurse_limit x in
                _menhir_goto_decl _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
            | _ ->
                _eRR 752)
        | _ ->
            _eRR 751
    
    and _menhir_run_736 : type  ttv_stack. ((((ttv_stack, _menhir_box_spec) _menhir_cell1_PURE _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args, _menhir_box_spec) _menhir_cell1_recurse_limit -> _ -> _ -> _ -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
        match (_tok : MenhirBasics.token) with
        | Tokens.END ->
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.SEMI_COLON ->
                let _endpos_0 = _menhir_lexbuf.Lexing.lex_curr_p in
                let _tok = _menhir_lexer _menhir_lexbuf in
                let MenhirCell1_recurse_limit (_menhir_stack, _, recurse_limit) = _menhir_stack in
                let MenhirCell1_func_args (_menhir_stack, _, func_args) = _menhir_stack in
                let MenhirCell1_params_opt (_menhir_stack, _, params_opt) = _menhir_stack in
                let MenhirCell0_IDENTIFIER (_menhir_stack, name, _, _) = _menhir_stack in
                let MenhirCell0_FUNC (_menhir_stack, _) = _menhir_stack in
                let MenhirCell1_PURE (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
                let (_1, _endpos__2_, _2, x, _3, _1_inlined2) = ((), _endpos_0, (), _v, (), ()) in
                let _v = _menhir_action_079 _1 _1_inlined2 _2 _3 _endpos__2_ _startpos__1_ func_args name params_opt recurse_limit x in
                _menhir_goto_decl _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
            | _ ->
                _eRR 737)
        | _ ->
            _eRR 736
    
    and _menhir_run_731 : type  ttv_stack. (((((ttv_stack, _menhir_box_spec) _menhir_cell1_PURE _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args, _menhir_box_spec) _menhir_cell1_return_type, _menhir_box_spec) _menhir_cell1_recurse_limit -> _ -> _ -> _ -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
        match (_tok : MenhirBasics.token) with
        | Tokens.END ->
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.SEMI_COLON ->
                let _endpos_0 = _menhir_lexbuf.Lexing.lex_curr_p in
                let _tok = _menhir_lexer _menhir_lexbuf in
                let MenhirCell1_recurse_limit (_menhir_stack, _, recurse_limit) = _menhir_stack in
                let MenhirCell1_return_type (_menhir_stack, _, return_type) = _menhir_stack in
                let MenhirCell1_func_args (_menhir_stack, _, func_args) = _menhir_stack in
                let MenhirCell1_params_opt (_menhir_stack, _, params_opt) = _menhir_stack in
                let MenhirCell0_IDENTIFIER (_menhir_stack, name, _, _) = _menhir_stack in
                let MenhirCell0_FUNC (_menhir_stack, _) = _menhir_stack in
                let MenhirCell1_PURE (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
                let (_1, _endpos__2_, _2, x, _3, _1_inlined2) = ((), _endpos_0, (), _v, (), ()) in
                let _v = _menhir_action_070 _1 _1_inlined2 _2 _3 _endpos__2_ _startpos__1_ func_args name params_opt recurse_limit return_type x in
                _menhir_goto_decl _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
            | _ ->
                _eRR 732)
        | _ ->
            _eRR 731
    
    and _menhir_run_721 : type  ttv_stack. ((((ttv_stack, _menhir_box_spec) _menhir_cell1_PURE _menhir_cell0_IMPDEF _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args, _menhir_box_spec) _menhir_cell1_recurse_limit -> _ -> _ -> _ -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
        match (_tok : MenhirBasics.token) with
        | Tokens.END ->
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.SEMI_COLON ->
                let _endpos_0 = _menhir_lexbuf.Lexing.lex_curr_p in
                let _tok = _menhir_lexer _menhir_lexbuf in
                let MenhirCell1_recurse_limit (_menhir_stack, _, recurse_limit) = _menhir_stack in
                let MenhirCell1_func_args (_menhir_stack, _, func_args) = _menhir_stack in
                let MenhirCell1_params_opt (_menhir_stack, _, params_opt) = _menhir_stack in
                let MenhirCell0_IDENTIFIER (_menhir_stack, name, _, _) = _menhir_stack in
                let MenhirCell0_FUNC (_menhir_stack, _) = _menhir_stack in
                let MenhirCell0_IMPDEF (_menhir_stack, _) = _menhir_stack in
                let MenhirCell1_PURE (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
                let (_1, _endpos__2_, _2, x, _3, _1_inlined1, _1_inlined3) = ((), _endpos_0, (), _v, (), (), ()) in
                let _v = _menhir_action_080 _1 _1_inlined1 _1_inlined3 _2 _3 _endpos__2_ _startpos__1_ func_args name params_opt recurse_limit x in
                _menhir_goto_decl _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
            | _ ->
                _eRR 722)
        | _ ->
            _eRR 721
    
    and _menhir_run_716 : type  ttv_stack. (((((ttv_stack, _menhir_box_spec) _menhir_cell1_PURE _menhir_cell0_IMPDEF _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args, _menhir_box_spec) _menhir_cell1_return_type, _menhir_box_spec) _menhir_cell1_recurse_limit -> _ -> _ -> _ -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
        match (_tok : MenhirBasics.token) with
        | Tokens.END ->
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.SEMI_COLON ->
                let _endpos_0 = _menhir_lexbuf.Lexing.lex_curr_p in
                let _tok = _menhir_lexer _menhir_lexbuf in
                let MenhirCell1_recurse_limit (_menhir_stack, _, recurse_limit) = _menhir_stack in
                let MenhirCell1_return_type (_menhir_stack, _, return_type) = _menhir_stack in
                let MenhirCell1_func_args (_menhir_stack, _, func_args) = _menhir_stack in
                let MenhirCell1_params_opt (_menhir_stack, _, params_opt) = _menhir_stack in
                let MenhirCell0_IDENTIFIER (_menhir_stack, name, _, _) = _menhir_stack in
                let MenhirCell0_FUNC (_menhir_stack, _) = _menhir_stack in
                let MenhirCell0_IMPDEF (_menhir_stack, _) = _menhir_stack in
                let MenhirCell1_PURE (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
                let (_1, _endpos__2_, _2, x, _3, _1_inlined1, _1_inlined3) = ((), _endpos_0, (), _v, (), (), ()) in
                let _v = _menhir_action_071 _1 _1_inlined1 _1_inlined3 _2 _3 _endpos__2_ _startpos__1_ func_args name params_opt recurse_limit return_type x in
                _menhir_goto_decl _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
            | _ ->
                _eRR 717)
        | _ ->
            _eRR 716
    
    and _menhir_run_705 : type  ttv_stack. ((((ttv_stack, _menhir_box_spec) _menhir_cell1_PURE _menhir_cell0_IMPLEMENTATION _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args, _menhir_box_spec) _menhir_cell1_recurse_limit -> _ -> _ -> _ -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
        match (_tok : MenhirBasics.token) with
        | Tokens.END ->
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.SEMI_COLON ->
                let _endpos_0 = _menhir_lexbuf.Lexing.lex_curr_p in
                let _tok = _menhir_lexer _menhir_lexbuf in
                let MenhirCell1_recurse_limit (_menhir_stack, _, recurse_limit) = _menhir_stack in
                let MenhirCell1_func_args (_menhir_stack, _, func_args) = _menhir_stack in
                let MenhirCell1_params_opt (_menhir_stack, _, params_opt) = _menhir_stack in
                let MenhirCell0_IDENTIFIER (_menhir_stack, name, _, _) = _menhir_stack in
                let MenhirCell0_FUNC (_menhir_stack, _) = _menhir_stack in
                let MenhirCell0_IMPLEMENTATION (_menhir_stack, _) = _menhir_stack in
                let MenhirCell1_PURE (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
                let (_1, _endpos__2_, _2, x, _3, _1_inlined1, _1_inlined3) = ((), _endpos_0, (), _v, (), (), ()) in
                let _v = _menhir_action_081 _1 _1_inlined1 _1_inlined3 _2 _3 _endpos__2_ _startpos__1_ func_args name params_opt recurse_limit x in
                _menhir_goto_decl _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
            | _ ->
                _eRR 706)
        | _ ->
            _eRR 705
    
    and _menhir_run_700 : type  ttv_stack. (((((ttv_stack, _menhir_box_spec) _menhir_cell1_PURE _menhir_cell0_IMPLEMENTATION _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args, _menhir_box_spec) _menhir_cell1_return_type, _menhir_box_spec) _menhir_cell1_recurse_limit -> _ -> _ -> _ -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
        match (_tok : MenhirBasics.token) with
        | Tokens.END ->
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.SEMI_COLON ->
                let _endpos_0 = _menhir_lexbuf.Lexing.lex_curr_p in
                let _tok = _menhir_lexer _menhir_lexbuf in
                let MenhirCell1_recurse_limit (_menhir_stack, _, recurse_limit) = _menhir_stack in
                let MenhirCell1_return_type (_menhir_stack, _, return_type) = _menhir_stack in
                let MenhirCell1_func_args (_menhir_stack, _, func_args) = _menhir_stack in
                let MenhirCell1_params_opt (_menhir_stack, _, params_opt) = _menhir_stack in
                let MenhirCell0_IDENTIFIER (_menhir_stack, name, _, _) = _menhir_stack in
                let MenhirCell0_FUNC (_menhir_stack, _) = _menhir_stack in
                let MenhirCell0_IMPLEMENTATION (_menhir_stack, _) = _menhir_stack in
                let MenhirCell1_PURE (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
                let (_1, _endpos__2_, _2, x, _3, _1_inlined1, _1_inlined3) = ((), _endpos_0, (), _v, (), (), ()) in
                let _v = _menhir_action_072 _1 _1_inlined1 _1_inlined3 _2 _3 _endpos__2_ _startpos__1_ func_args name params_opt recurse_limit return_type x in
                _menhir_goto_decl _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
            | _ ->
                _eRR 701)
        | _ ->
            _eRR 700
    
    and _menhir_run_688 : type  ttv_stack. ((((ttv_stack, _menhir_box_spec) _menhir_cell1_READONLY _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args, _menhir_box_spec) _menhir_cell1_recurse_limit -> _ -> _ -> _ -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
        match (_tok : MenhirBasics.token) with
        | Tokens.END ->
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.SEMI_COLON ->
                let _endpos_0 = _menhir_lexbuf.Lexing.lex_curr_p in
                let _tok = _menhir_lexer _menhir_lexbuf in
                let MenhirCell1_recurse_limit (_menhir_stack, _, recurse_limit) = _menhir_stack in
                let MenhirCell1_func_args (_menhir_stack, _, func_args) = _menhir_stack in
                let MenhirCell1_params_opt (_menhir_stack, _, params_opt) = _menhir_stack in
                let MenhirCell0_IDENTIFIER (_menhir_stack, name, _, _) = _menhir_stack in
                let MenhirCell0_FUNC (_menhir_stack, _) = _menhir_stack in
                let MenhirCell1_READONLY (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
                let (_1, _endpos__2_, _2, x, _3, _1_inlined2) = ((), _endpos_0, (), _v, (), ()) in
                let _v = _menhir_action_082 _1 _1_inlined2 _2 _3 _endpos__2_ _startpos__1_ func_args name params_opt recurse_limit x in
                _menhir_goto_decl _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
            | _ ->
                _eRR 689)
        | _ ->
            _eRR 688
    
    and _menhir_run_683 : type  ttv_stack. (((((ttv_stack, _menhir_box_spec) _menhir_cell1_READONLY _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args, _menhir_box_spec) _menhir_cell1_return_type, _menhir_box_spec) _menhir_cell1_recurse_limit -> _ -> _ -> _ -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
        match (_tok : MenhirBasics.token) with
        | Tokens.END ->
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.SEMI_COLON ->
                let _endpos_0 = _menhir_lexbuf.Lexing.lex_curr_p in
                let _tok = _menhir_lexer _menhir_lexbuf in
                let MenhirCell1_recurse_limit (_menhir_stack, _, recurse_limit) = _menhir_stack in
                let MenhirCell1_return_type (_menhir_stack, _, return_type) = _menhir_stack in
                let MenhirCell1_func_args (_menhir_stack, _, func_args) = _menhir_stack in
                let MenhirCell1_params_opt (_menhir_stack, _, params_opt) = _menhir_stack in
                let MenhirCell0_IDENTIFIER (_menhir_stack, name, _, _) = _menhir_stack in
                let MenhirCell0_FUNC (_menhir_stack, _) = _menhir_stack in
                let MenhirCell1_READONLY (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
                let (_1, _endpos__2_, _2, x, _3, _1_inlined2) = ((), _endpos_0, (), _v, (), ()) in
                let _v = _menhir_action_073 _1 _1_inlined2 _2 _3 _endpos__2_ _startpos__1_ func_args name params_opt recurse_limit return_type x in
                _menhir_goto_decl _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
            | _ ->
                _eRR 684)
        | _ ->
            _eRR 683
    
    and _menhir_run_673 : type  ttv_stack. ((((ttv_stack, _menhir_box_spec) _menhir_cell1_READONLY _menhir_cell0_IMPDEF _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args, _menhir_box_spec) _menhir_cell1_recurse_limit -> _ -> _ -> _ -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
        match (_tok : MenhirBasics.token) with
        | Tokens.END ->
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.SEMI_COLON ->
                let _endpos_0 = _menhir_lexbuf.Lexing.lex_curr_p in
                let _tok = _menhir_lexer _menhir_lexbuf in
                let MenhirCell1_recurse_limit (_menhir_stack, _, recurse_limit) = _menhir_stack in
                let MenhirCell1_func_args (_menhir_stack, _, func_args) = _menhir_stack in
                let MenhirCell1_params_opt (_menhir_stack, _, params_opt) = _menhir_stack in
                let MenhirCell0_IDENTIFIER (_menhir_stack, name, _, _) = _menhir_stack in
                let MenhirCell0_FUNC (_menhir_stack, _) = _menhir_stack in
                let MenhirCell0_IMPDEF (_menhir_stack, _) = _menhir_stack in
                let MenhirCell1_READONLY (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
                let (_1, _endpos__2_, _2, x, _3, _1_inlined1, _1_inlined3) = ((), _endpos_0, (), _v, (), (), ()) in
                let _v = _menhir_action_083 _1 _1_inlined1 _1_inlined3 _2 _3 _endpos__2_ _startpos__1_ func_args name params_opt recurse_limit x in
                _menhir_goto_decl _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
            | _ ->
                _eRR 674)
        | _ ->
            _eRR 673
    
    and _menhir_run_668 : type  ttv_stack. (((((ttv_stack, _menhir_box_spec) _menhir_cell1_READONLY _menhir_cell0_IMPDEF _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args, _menhir_box_spec) _menhir_cell1_return_type, _menhir_box_spec) _menhir_cell1_recurse_limit -> _ -> _ -> _ -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
        match (_tok : MenhirBasics.token) with
        | Tokens.END ->
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.SEMI_COLON ->
                let _endpos_0 = _menhir_lexbuf.Lexing.lex_curr_p in
                let _tok = _menhir_lexer _menhir_lexbuf in
                let MenhirCell1_recurse_limit (_menhir_stack, _, recurse_limit) = _menhir_stack in
                let MenhirCell1_return_type (_menhir_stack, _, return_type) = _menhir_stack in
                let MenhirCell1_func_args (_menhir_stack, _, func_args) = _menhir_stack in
                let MenhirCell1_params_opt (_menhir_stack, _, params_opt) = _menhir_stack in
                let MenhirCell0_IDENTIFIER (_menhir_stack, name, _, _) = _menhir_stack in
                let MenhirCell0_FUNC (_menhir_stack, _) = _menhir_stack in
                let MenhirCell0_IMPDEF (_menhir_stack, _) = _menhir_stack in
                let MenhirCell1_READONLY (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
                let (_1, _endpos__2_, _2, x, _3, _1_inlined1, _1_inlined3) = ((), _endpos_0, (), _v, (), (), ()) in
                let _v = _menhir_action_074 _1 _1_inlined1 _1_inlined3 _2 _3 _endpos__2_ _startpos__1_ func_args name params_opt recurse_limit return_type x in
                _menhir_goto_decl _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
            | _ ->
                _eRR 669)
        | _ ->
            _eRR 668
    
    and _menhir_run_657 : type  ttv_stack. ((((ttv_stack, _menhir_box_spec) _menhir_cell1_READONLY _menhir_cell0_IMPLEMENTATION _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args, _menhir_box_spec) _menhir_cell1_recurse_limit -> _ -> _ -> _ -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
        match (_tok : MenhirBasics.token) with
        | Tokens.END ->
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.SEMI_COLON ->
                let _endpos_0 = _menhir_lexbuf.Lexing.lex_curr_p in
                let _tok = _menhir_lexer _menhir_lexbuf in
                let MenhirCell1_recurse_limit (_menhir_stack, _, recurse_limit) = _menhir_stack in
                let MenhirCell1_func_args (_menhir_stack, _, func_args) = _menhir_stack in
                let MenhirCell1_params_opt (_menhir_stack, _, params_opt) = _menhir_stack in
                let MenhirCell0_IDENTIFIER (_menhir_stack, name, _, _) = _menhir_stack in
                let MenhirCell0_FUNC (_menhir_stack, _) = _menhir_stack in
                let MenhirCell0_IMPLEMENTATION (_menhir_stack, _) = _menhir_stack in
                let MenhirCell1_READONLY (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
                let (_1, _endpos__2_, _2, x, _3, _1_inlined1, _1_inlined3) = ((), _endpos_0, (), _v, (), (), ()) in
                let _v = _menhir_action_084 _1 _1_inlined1 _1_inlined3 _2 _3 _endpos__2_ _startpos__1_ func_args name params_opt recurse_limit x in
                _menhir_goto_decl _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
            | _ ->
                _eRR 658)
        | _ ->
            _eRR 657
    
    and _menhir_run_652 : type  ttv_stack. (((((ttv_stack, _menhir_box_spec) _menhir_cell1_READONLY _menhir_cell0_IMPLEMENTATION _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args, _menhir_box_spec) _menhir_cell1_return_type, _menhir_box_spec) _menhir_cell1_recurse_limit -> _ -> _ -> _ -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
        match (_tok : MenhirBasics.token) with
        | Tokens.END ->
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.SEMI_COLON ->
                let _endpos_0 = _menhir_lexbuf.Lexing.lex_curr_p in
                let _tok = _menhir_lexer _menhir_lexbuf in
                let MenhirCell1_recurse_limit (_menhir_stack, _, recurse_limit) = _menhir_stack in
                let MenhirCell1_return_type (_menhir_stack, _, return_type) = _menhir_stack in
                let MenhirCell1_func_args (_menhir_stack, _, func_args) = _menhir_stack in
                let MenhirCell1_params_opt (_menhir_stack, _, params_opt) = _menhir_stack in
                let MenhirCell0_IDENTIFIER (_menhir_stack, name, _, _) = _menhir_stack in
                let MenhirCell0_FUNC (_menhir_stack, _) = _menhir_stack in
                let MenhirCell0_IMPLEMENTATION (_menhir_stack, _) = _menhir_stack in
                let MenhirCell1_READONLY (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
                let (_1, _endpos__2_, _2, x, _3, _1_inlined1, _1_inlined3) = ((), _endpos_0, (), _v, (), (), ()) in
                let _v = _menhir_action_075 _1 _1_inlined1 _1_inlined3 _2 _3 _endpos__2_ _startpos__1_ func_args name params_opt recurse_limit return_type x in
                _menhir_goto_decl _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
            | _ ->
                _eRR 653)
        | _ ->
            _eRR 652
    
    and _menhir_run_560 : type  ttv_stack ttv_result. (((ttv_stack, ttv_result) _menhir_cell1_WHILE, ttv_result) _menhir_cell1_expr, ttv_result) _menhir_cell1_loop_limit -> _ -> _ -> _ -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
        match (_tok : MenhirBasics.token) with
        | Tokens.END ->
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.SEMI_COLON ->
                let _endpos_0 = _menhir_lexbuf.Lexing.lex_curr_p in
                let _tok = _menhir_lexer _menhir_lexbuf in
                let MenhirCell1_loop_limit (_menhir_stack, _, loop_limit) = _menhir_stack in
                let MenhirCell1_expr (_menhir_stack, _, expr, _, _) = _menhir_stack in
                let MenhirCell1_WHILE (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
                let (_1, _endpos__2_, _2, _4, _1_inlined1, stmt_list) = ((), _endpos_0, (), (), (), _v) in
                let _v = _menhir_action_278 _1 _1_inlined1 _2 _4 _endpos__2_ _startpos__1_ expr loop_limit stmt_list in
                _menhir_goto_stmt _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__2_ _v _menhir_s _tok
            | _ ->
                _eRR 561)
        | _ ->
            _eRR 560
    
    and _menhir_run_554 : type  ttv_stack ttv_result. (((ttv_stack, ttv_result) _menhir_cell1_TRY, ttv_result) _menhir_cell1_stmt_list, ttv_result) _menhir_cell1_list1_catcher_ -> _ -> _ -> _ -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
        let (_1, _2, _3) = ((), (), _v) in
        let _v = _menhir_action_246 _1 _2 _3 in
        _menhir_goto_otherwise_opt _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
    
    and _menhir_goto_otherwise_opt : type  ttv_stack ttv_result. (((ttv_stack, ttv_result) _menhir_cell1_TRY, ttv_result) _menhir_cell1_stmt_list, ttv_result) _menhir_cell1_list1_catcher_ -> _ -> _ -> _ -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
        match (_tok : MenhirBasics.token) with
        | Tokens.END ->
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.SEMI_COLON ->
                let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
                let _tok = _menhir_lexer _menhir_lexbuf in
                let MenhirCell1_list1_catcher_ (_menhir_stack, _, c) = _menhir_stack in
                let MenhirCell1_stmt_list (_menhir_stack, _, s, _) = _menhir_stack in
                let MenhirCell1_TRY (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
                let (_1, _endpos__2_, _2, _3, _1_inlined1, o) = ((), _endpos, (), (), (), _v) in
                let _v = _menhir_action_280 _1 _1_inlined1 _2 _3 _endpos__2_ _startpos__1_ c o s in
                _menhir_goto_stmt _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__2_ _v _menhir_s _tok
            | _ ->
                _eRR 556)
        | _ ->
            _eRR 555
    
    and _menhir_run_550 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_WHEN, ttv_result) _menhir_cell1_ty -> _ -> _ -> _ -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
        let MenhirCell1_ty (_menhir_stack, _, ty, _) = _menhir_stack in
        let MenhirCell1_WHEN (_menhir_stack, _menhir_s, _) = _menhir_stack in
        let (_1, _4, stmt_list) = ((), (), _v) in
        let _v = _menhir_action_022 _1 _4 stmt_list ty in
        _menhir_goto_catcher _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
    
    and _menhir_goto_catcher : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
        match (_tok : MenhirBasics.token) with
        | Tokens.WHEN ->
            let _menhir_stack = MenhirCell1_catcher (_menhir_stack, _menhir_s, _v) in
            _menhir_run_542 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState558
        | Tokens.END | Tokens.OTHERWISE ->
            let x = _v in
            let _v = _menhir_action_234 x in
            _menhir_goto_list1_catcher_ _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
        | _ ->
            _eRR 558
    
    and _menhir_run_542 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _menhir_stack = MenhirCell1_WHEN (_menhir_stack, _menhir_s, _startpos) in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.STRING ->
            _menhir_run_016 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState542
        | Tokens.REAL ->
            _menhir_run_017 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState542
        | Tokens.LPAR ->
            _menhir_run_018 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState542
        | Tokens.INTEGER ->
            _menhir_run_019 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState542
        | Tokens.IDENTIFIER _v ->
            let _startpos_0 = _menhir_lexbuf.Lexing.lex_start_p in
            let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.COLON ->
                let _menhir_stack = MenhirCell1_IDENTIFIER (_menhir_stack, MenhirState542, _v, _startpos_0, _endpos) in
                let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
                let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
                let _menhir_stack = MenhirCell0_COLON (_menhir_stack, _startpos, _endpos) in
                let _menhir_s = MenhirState544 in
                let _tok = _menhir_lexer _menhir_lexbuf in
                (match (_tok : MenhirBasics.token) with
                | Tokens.STRING ->
                    _menhir_run_016 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
                | Tokens.REAL ->
                    _menhir_run_017 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
                | Tokens.LPAR ->
                    _menhir_run_018 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
                | Tokens.INTEGER ->
                    _menhir_run_019 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
                | Tokens.IDENTIFIER _v ->
                    _menhir_run_104 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
                | Tokens.BOOLEAN ->
                    _menhir_run_105 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
                | Tokens.BITS ->
                    _menhir_run_106 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
                | Tokens.BIT ->
                    _menhir_run_117 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
                | Tokens.ARRAY ->
                    _menhir_run_118 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
                | _ ->
                    _eRR 544)
            | Tokens.ARROW ->
                let _v =
                  let (_endpos_name_, _startpos_name_, name) = (_endpos, _startpos_0, _v) in
                  _menhir_action_332 _endpos_name_ _startpos_name_ name
                in
                _menhir_run_548 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v MenhirState542 _tok
            | _ ->
                _eRR 543)
        | Tokens.BOOLEAN ->
            _menhir_run_105 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState542
        | Tokens.BITS ->
            _menhir_run_106 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState542
        | Tokens.BIT ->
            _menhir_run_117 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState542
        | Tokens.ARRAY ->
            _menhir_run_118 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState542
        | _ ->
            _eRR 542
    
    and _menhir_run_548 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_WHEN as 'stack) -> _ -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok ->
        let _menhir_stack = MenhirCell1_ty (_menhir_stack, _menhir_s, _v, _endpos) in
        match (_tok : MenhirBasics.token) with
        | Tokens.ARROW ->
            let _menhir_s = MenhirState549 in
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.WHILE ->
                _menhir_run_001 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.VAR ->
                _menhir_run_318 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.UNREACHABLE ->
                _menhir_run_363 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.TRY ->
                _menhir_run_365 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.THROW ->
                _menhir_run_366 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.RETURN ->
                _menhir_run_369 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.REPEAT ->
                _menhir_run_373 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.PRINTLN ->
                _menhir_run_374 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.PRINT ->
                _menhir_run_377 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.PRAGMA ->
                _menhir_run_380 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.PASS ->
                _menhir_run_384 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.MINUS ->
                _menhir_run_386 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.LPAR ->
                _menhir_run_387 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.LET ->
                _menhir_run_408 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.IF ->
                _menhir_run_420 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.IDENTIFIER _v ->
                _menhir_run_423 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | Tokens.FOR ->
                _menhir_run_443 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.DEBUG ->
                _menhir_run_453 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.CONSTANT ->
                _menhir_run_458 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.CASE ->
                _menhir_run_469 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.ASSERT ->
                _menhir_run_477 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | _ ->
                _eRR 549)
        | _ ->
            _eRR 548
    
    and _menhir_goto_list1_catcher_ : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
        match _menhir_s with
        | MenhirState558 ->
            _menhir_run_559 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
        | MenhirState541 ->
            _menhir_run_551 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
        | _ ->
            _menhir_fail ()
    
    and _menhir_run_559 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_catcher -> _ -> _ -> _ -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
        let MenhirCell1_catcher (_menhir_stack, _menhir_s, x) = _menhir_stack in
        let l = _v in
        let _v = _menhir_action_235 l x in
        _menhir_goto_list1_catcher_ _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
    
    and _menhir_run_551 : type  ttv_stack ttv_result. (((ttv_stack, ttv_result) _menhir_cell1_TRY, ttv_result) _menhir_cell1_stmt_list as 'stack) -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
        let _menhir_stack = MenhirCell1_list1_catcher_ (_menhir_stack, _menhir_s, _v) in
        match (_tok : MenhirBasics.token) with
        | Tokens.OTHERWISE ->
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.ARROW ->
                let _menhir_s = MenhirState553 in
                let _tok = _menhir_lexer _menhir_lexbuf in
                (match (_tok : MenhirBasics.token) with
                | Tokens.WHILE ->
                    _menhir_run_001 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
                | Tokens.VAR ->
                    _menhir_run_318 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
                | Tokens.UNREACHABLE ->
                    _menhir_run_363 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
                | Tokens.TRY ->
                    _menhir_run_365 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
                | Tokens.THROW ->
                    _menhir_run_366 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
                | Tokens.RETURN ->
                    _menhir_run_369 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
                | Tokens.REPEAT ->
                    _menhir_run_373 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
                | Tokens.PRINTLN ->
                    _menhir_run_374 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
                | Tokens.PRINT ->
                    _menhir_run_377 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
                | Tokens.PRAGMA ->
                    _menhir_run_380 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
                | Tokens.PASS ->
                    _menhir_run_384 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
                | Tokens.MINUS ->
                    _menhir_run_386 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
                | Tokens.LPAR ->
                    _menhir_run_387 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
                | Tokens.LET ->
                    _menhir_run_408 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
                | Tokens.IF ->
                    _menhir_run_420 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
                | Tokens.IDENTIFIER _v ->
                    _menhir_run_423 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
                | Tokens.FOR ->
                    _menhir_run_443 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
                | Tokens.DEBUG ->
                    _menhir_run_453 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
                | Tokens.CONSTANT ->
                    _menhir_run_458 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
                | Tokens.CASE ->
                    _menhir_run_469 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
                | Tokens.ASSERT ->
                    _menhir_run_477 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
                | _ ->
                    _eRR 553)
            | _ ->
                _eRR 552)
        | Tokens.END ->
            let _v = _menhir_action_245 () in
            _menhir_goto_otherwise_opt _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
        | _ ->
            _menhir_fail ()
    
    and _menhir_run_547 : type  ttv_stack ttv_result. (((ttv_stack, ttv_result) _menhir_cell1_WHEN, ttv_result) _menhir_cell1_IDENTIFIER _menhir_cell0_COLON, ttv_result) _menhir_cell1_ty -> _ -> _ -> _ -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
        let MenhirCell1_ty (_menhir_stack, _, ty, _) = _menhir_stack in
        let MenhirCell0_COLON (_menhir_stack, _, _) = _menhir_stack in
        let MenhirCell1_IDENTIFIER (_menhir_stack, _, x, _, _) = _menhir_stack in
        let MenhirCell1_WHEN (_menhir_stack, _menhir_s, _) = _menhir_stack in
        let (_1, _4, stmt_list) = ((), (), _v) in
        let _v = _menhir_action_023 _1 _4 stmt_list ty x in
        _menhir_goto_catcher _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
    
    and _menhir_run_540 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_TRY as 'stack) -> _ -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok ->
        let _menhir_stack = MenhirCell1_stmt_list (_menhir_stack, _menhir_s, _v, _endpos) in
        match (_tok : MenhirBasics.token) with
        | Tokens.CATCH ->
            let _menhir_s = MenhirState541 in
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.WHEN ->
                _menhir_run_542 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | _ ->
                _eRR 541)
        | _ ->
            _eRR 540
    
    and _menhir_run_535 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_REPEAT as 'stack) -> _ -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok ->
        let _menhir_stack = MenhirCell1_stmt_list (_menhir_stack, _menhir_s, _v, _endpos) in
        match (_tok : MenhirBasics.token) with
        | Tokens.UNTIL ->
            let _menhir_s = MenhirState536 in
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.STRING_LIT _v ->
                _menhir_run_002 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | Tokens.REAL_LIT _v ->
                _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | Tokens.NOT ->
                _menhir_run_004 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.MINUS ->
                _menhir_run_005 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.LPAR ->
                _menhir_run_006 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.INT_LIT _v ->
                _menhir_run_007 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | Tokens.IF ->
                _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.IDENTIFIER _v ->
                _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | Tokens.BOOL_LIT _v ->
                _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | Tokens.BNOT ->
                _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.BITVECTOR_LIT _v ->
                _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | Tokens.ARBITRARY ->
                _menhir_run_014 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | _ ->
                _eRR 536)
        | _ ->
            _eRR 535
    
    and _menhir_run_530 : type  ttv_stack ttv_result. ((((ttv_stack, ttv_result) _menhir_cell1_expr, ttv_result) _menhir_cell1_THEN, ttv_result) _menhir_cell1_stmt_list, ttv_result) _menhir_cell1_ELSE -> _ -> _ -> _ -> _ -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
        let MenhirCell1_ELSE (_menhir_stack, _menhir_s) = _menhir_stack in
        let (_1, _endpos__2_, _2) = ((), _endpos, _v) in
        let _v = _menhir_action_265 _1 _2 in
        _menhir_goto_s_else _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__2_ _v _menhir_s _tok
    
    and _menhir_goto_s_else : type  ttv_stack ttv_result. ((((ttv_stack, ttv_result) _menhir_cell1_expr, ttv_result) _menhir_cell1_THEN, ttv_result) _menhir_cell1_stmt_list as 'stack) -> _ -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok ->
        match _menhir_s with
        | MenhirState524 ->
            _menhir_run_532 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
        | MenhirState528 ->
            _menhir_run_531 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
        | _ ->
            _menhir_fail ()
    
    and _menhir_run_532 : type  ttv_stack ttv_result. ((((ttv_stack, ttv_result) _menhir_cell1_IF, ttv_result) _menhir_cell1_expr, ttv_result) _menhir_cell1_THEN, ttv_result) _menhir_cell1_stmt_list -> _ -> _ -> _ -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
        match (_tok : MenhirBasics.token) with
        | Tokens.END ->
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.SEMI_COLON ->
                let _endpos_0 = _menhir_lexbuf.Lexing.lex_curr_p in
                let _tok = _menhir_lexer _menhir_lexbuf in
                let MenhirCell1_stmt_list (_menhir_stack, _, s1, _) = _menhir_stack in
                let MenhirCell1_THEN (_menhir_stack, _) = _menhir_stack in
                let MenhirCell1_expr (_menhir_stack, _, e, _, _) = _menhir_stack in
                let MenhirCell1_IF (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
                let (_1, _endpos__2_, _2, _3, _1_inlined1, s2) = ((), _endpos_0, (), (), (), _v) in
                let _v = _menhir_action_275 _1 _1_inlined1 _2 _3 _endpos__2_ _startpos__1_ e s1 s2 in
                _menhir_goto_stmt _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__2_ _v _menhir_s _tok
            | _ ->
                _eRR 533)
        | _ ->
            _eRR 532
    
    and _menhir_run_531 : type  ttv_stack ttv_result. (((((((ttv_stack, ttv_result) _menhir_cell1_expr, ttv_result) _menhir_cell1_THEN, ttv_result) _menhir_cell1_stmt_list, ttv_result) _menhir_cell1_ELSIF, ttv_result) _menhir_cell1_expr, ttv_result) _menhir_cell1_THEN, ttv_result) _menhir_cell1_stmt_list -> _ -> _ -> _ -> _ -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
        let MenhirCell1_stmt_list (_menhir_stack, _, s1, _) = _menhir_stack in
        let MenhirCell1_THEN (_menhir_stack, _) = _menhir_stack in
        let MenhirCell1_expr (_menhir_stack, _, e, _, _) = _menhir_stack in
        let MenhirCell1_ELSIF (_menhir_stack, _menhir_s, _startpos__1_, _) = _menhir_stack in
        let (_1, _3, _endpos_s2_, s2) = ((), (), _endpos, _v) in
        let _v = _menhir_action_263 _1 _3 _endpos_s2_ _startpos__1_ e s1 s2 in
        _menhir_goto_s_else _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_s2_ _v _menhir_s _tok
    
    and _menhir_run_528 : type  ttv_stack ttv_result. (((((((ttv_stack, ttv_result) _menhir_cell1_expr, ttv_result) _menhir_cell1_THEN, ttv_result) _menhir_cell1_stmt_list, ttv_result) _menhir_cell1_ELSIF, ttv_result) _menhir_cell1_expr, ttv_result) _menhir_cell1_THEN as 'stack) -> _ -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok ->
        let _menhir_stack = MenhirCell1_stmt_list (_menhir_stack, _menhir_s, _v, _endpos) in
        match (_tok : MenhirBasics.token) with
        | Tokens.ELSIF ->
            _menhir_run_525 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState528
        | Tokens.ELSE ->
            _menhir_run_529 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState528
        | Tokens.END ->
            let _v_0 =
              let _endpos__0_ = _endpos in
              _menhir_action_264 _endpos__0_
            in
            _menhir_run_531 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v_0 _tok
        | _ ->
            _eRR 528
    
    and _menhir_run_525 : type  ttv_stack ttv_result. ((((ttv_stack, ttv_result) _menhir_cell1_expr, ttv_result) _menhir_cell1_THEN, ttv_result) _menhir_cell1_stmt_list as 'stack) -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
        let _menhir_stack = MenhirCell1_ELSIF (_menhir_stack, _menhir_s, _startpos, _endpos) in
        let _menhir_s = MenhirState525 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.STRING_LIT _v ->
            _menhir_run_002 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.REAL_LIT _v ->
            _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.NOT ->
            _menhir_run_004 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.MINUS ->
            _menhir_run_005 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LPAR ->
            _menhir_run_006 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.INT_LIT _v ->
            _menhir_run_007 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.IF ->
            _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IDENTIFIER _v ->
            _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BOOL_LIT _v ->
            _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BNOT ->
            _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.BITVECTOR_LIT _v ->
            _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.ARBITRARY ->
            _menhir_run_014 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | _ ->
            _eRR 525
    
    and _menhir_run_529 : type  ttv_stack ttv_result. ((((ttv_stack, ttv_result) _menhir_cell1_expr, ttv_result) _menhir_cell1_THEN, ttv_result) _menhir_cell1_stmt_list as 'stack) -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _menhir_stack = MenhirCell1_ELSE (_menhir_stack, _menhir_s) in
        let _menhir_s = MenhirState529 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.WHILE ->
            _menhir_run_001 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.VAR ->
            _menhir_run_318 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.UNREACHABLE ->
            _menhir_run_363 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.TRY ->
            _menhir_run_365 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.THROW ->
            _menhir_run_366 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.RETURN ->
            _menhir_run_369 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.REPEAT ->
            _menhir_run_373 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PRINTLN ->
            _menhir_run_374 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PRINT ->
            _menhir_run_377 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PRAGMA ->
            _menhir_run_380 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PASS ->
            _menhir_run_384 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.MINUS ->
            _menhir_run_386 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LPAR ->
            _menhir_run_387 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LET ->
            _menhir_run_408 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IF ->
            _menhir_run_420 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IDENTIFIER _v ->
            _menhir_run_423 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.FOR ->
            _menhir_run_443 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.DEBUG ->
            _menhir_run_453 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.CONSTANT ->
            _menhir_run_458 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.CASE ->
            _menhir_run_469 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.ASSERT ->
            _menhir_run_477 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | _ ->
            _eRR 529
    
    and _menhir_run_524 : type  ttv_stack ttv_result. ((((ttv_stack, ttv_result) _menhir_cell1_IF, ttv_result) _menhir_cell1_expr, ttv_result) _menhir_cell1_THEN as 'stack) -> _ -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok ->
        let _menhir_stack = MenhirCell1_stmt_list (_menhir_stack, _menhir_s, _v, _endpos) in
        match (_tok : MenhirBasics.token) with
        | Tokens.ELSIF ->
            _menhir_run_525 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState524
        | Tokens.ELSE ->
            _menhir_run_529 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState524
        | Tokens.END ->
            let _v_0 =
              let _endpos__0_ = _endpos in
              _menhir_action_264 _endpos__0_
            in
            _menhir_run_532 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 _tok
        | _ ->
            _eRR 524
    
    and _menhir_run_521 : type  ttv_stack ttv_result. (((((ttv_stack, ttv_result) _menhir_cell1_FOR _menhir_cell0_IDENTIFIER, ttv_result) _menhir_cell1_expr, ttv_result) _menhir_cell1_direction, ttv_result) _menhir_cell1_expr, ttv_result) _menhir_cell1_loop_limit -> _ -> _ -> _ -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
        match (_tok : MenhirBasics.token) with
        | Tokens.END ->
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.SEMI_COLON ->
                let _endpos_0 = _menhir_lexbuf.Lexing.lex_curr_p in
                let _tok = _menhir_lexer _menhir_lexbuf in
                let MenhirCell1_loop_limit (_menhir_stack, _, limit) = _menhir_stack in
                let MenhirCell1_expr (_menhir_stack, _, end_e, _, _) = _menhir_stack in
                let MenhirCell1_direction (_menhir_stack, _, dir) = _menhir_stack in
                let MenhirCell1_expr (_menhir_stack, _, start_e, _, _) = _menhir_stack in
                let MenhirCell0_IDENTIFIER (_menhir_stack, index_name, _, _) = _menhir_stack in
                let MenhirCell1_FOR (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
                let (_1, _endpos__2_, _2, _3, _1_inlined1, body, _8) = ((), _endpos_0, (), (), (), _v, ()) in
                let _v = _menhir_action_279 _1 _1_inlined1 _2 _3 _8 _endpos__2_ _startpos__1_ body dir end_e index_name limit start_e in
                _menhir_goto_stmt _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__2_ _v _menhir_s _tok
            | _ ->
                _eRR 522)
        | _ ->
            _eRR 521
    
    and _menhir_run_514 : type  ttv_stack ttv_result. ((((ttv_stack, ttv_result) _menhir_cell1_CASE, ttv_result) _menhir_cell1_expr, ttv_result) _menhir_cell1_OF, ttv_result) _menhir_cell1_list1_case_alt_ -> _ -> _ -> _ -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
        match (_tok : MenhirBasics.token) with
        | Tokens.END ->
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.SEMI_COLON ->
                let _endpos_0 = _menhir_lexbuf.Lexing.lex_curr_p in
                let _tok = _menhir_lexer _menhir_lexbuf in
                let MenhirCell1_list1_case_alt_ (_menhir_stack, _, _1_inlined1) = _menhir_stack in
                let MenhirCell1_OF (_menhir_stack, _) = _menhir_stack in
                let MenhirCell1_expr (_menhir_stack, _, expr, _, _) = _menhir_stack in
                let MenhirCell1_CASE (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
                let (_1, _endpos__2_, _2, _3, _2_inlined1, _1_inlined2, _1_inlined3, otherwise_stmt) = ((), _endpos_0, (), (), (), (), (), _v) in
                let _v = _menhir_action_277 _1 _1_inlined1 _1_inlined2 _1_inlined3 _2 _2_inlined1 _3 _endpos__2_ _startpos__1_ expr otherwise_stmt in
                _menhir_goto_stmt _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__2_ _v _menhir_s _tok
            | _ ->
                _eRR 515)
        | _ ->
            _eRR 514
    
    and _menhir_run_510 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_WHEN, ttv_result) _menhir_cell1_pattern_list -> _ -> _ -> _ -> _ -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
        let MenhirCell1_pattern_list (_menhir_stack, _, pattern) = _menhir_stack in
        let MenhirCell1_WHEN (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
        let (_1, _4, _endpos_stmt_, stmt) = ((), (), _endpos, _v) in
        let _v = _menhir_action_020 _1 _4 _endpos_stmt_ _startpos__1_ pattern stmt in
        _menhir_goto_case_alt _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
    
    and _menhir_goto_case_alt : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
        match (_tok : MenhirBasics.token) with
        | Tokens.WHEN ->
            let _menhir_stack = MenhirCell1_case_alt (_menhir_stack, _menhir_s, _v) in
            _menhir_run_472 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState519
        | Tokens.END | Tokens.OTHERWISE ->
            let x = _v in
            let _v = _menhir_action_232 x in
            _menhir_goto_list1_case_alt_ _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
        | _ ->
            _eRR 519
    
    and _menhir_run_472 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _menhir_stack = MenhirCell1_WHEN (_menhir_stack, _menhir_s, _startpos) in
        let _menhir_s = MenhirState472 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.STRING_LIT _v ->
            _menhir_run_002 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.REAL_LIT _v ->
            _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.NOT ->
            _menhir_run_041 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.MINUS ->
            _menhir_run_053 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.MASK_LIT _v ->
            _menhir_run_055 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.LPAR ->
            _menhir_run_056 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LE ->
            _menhir_run_057 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LBRACE ->
            _menhir_run_040 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.INT_LIT _v ->
            _menhir_run_007 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.IF ->
            _menhir_run_134 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IDENTIFIER _v ->
            _menhir_run_142 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.GE ->
            _menhir_run_169 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.BOOL_LIT _v ->
            _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BNOT ->
            _menhir_run_171 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.BITVECTOR_LIT _v ->
            _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.ARBITRARY ->
            _menhir_run_173 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | _ ->
            _eRR 472
    
    and _menhir_run_041 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _menhir_stack = MenhirCell1_NOT (_menhir_stack, _menhir_s, _startpos) in
        let _menhir_s = MenhirState041 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.STRING_LIT _v ->
            _menhir_run_002 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.REAL_LIT _v ->
            _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.NOT ->
            _menhir_run_004 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.MINUS ->
            _menhir_run_005 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LPAR ->
            _menhir_run_006 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.INT_LIT _v ->
            _menhir_run_007 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.IF ->
            _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IDENTIFIER _v ->
            _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BOOL_LIT _v ->
            _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BNOT ->
            _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.BITVECTOR_LIT _v ->
            _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.ARBITRARY ->
            _menhir_run_014 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | _ ->
            _eRR 41
    
    and _menhir_run_053 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.STRING_LIT _v ->
            let _menhir_stack = MenhirCell1_MINUS (_menhir_stack, _menhir_s, _startpos, _endpos) in
            _menhir_run_002 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState053
        | Tokens.REAL_LIT _v ->
            let _menhir_stack = MenhirCell1_MINUS (_menhir_stack, _menhir_s, _startpos, _endpos) in
            _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState053
        | Tokens.NOT ->
            let _menhir_stack = MenhirCell1_MINUS (_menhir_stack, _menhir_s, _startpos, _endpos) in
            _menhir_run_004 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState053
        | Tokens.MINUS ->
            let _menhir_stack = MenhirCell1_MINUS (_menhir_stack, _menhir_s, _startpos, _endpos) in
            _menhir_run_005 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState053
        | Tokens.LPAR ->
            let _menhir_stack = MenhirCell1_MINUS (_menhir_stack, _menhir_s, _startpos, _endpos) in
            _menhir_run_006 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState053
        | Tokens.INT_LIT _v ->
            let _menhir_stack = MenhirCell1_MINUS (_menhir_stack, _menhir_s, _startpos, _endpos) in
            _menhir_run_007 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState053
        | Tokens.IF ->
            let _menhir_stack = MenhirCell1_MINUS (_menhir_stack, _menhir_s, _startpos, _endpos) in
            _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState053
        | Tokens.IDENTIFIER _v ->
            let _menhir_stack = MenhirCell1_MINUS (_menhir_stack, _menhir_s, _startpos, _endpos) in
            _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState053
        | Tokens.BOOL_LIT _v ->
            let _menhir_stack = MenhirCell1_MINUS (_menhir_stack, _menhir_s, _startpos, _endpos) in
            _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState053
        | Tokens.BNOT ->
            let _menhir_stack = MenhirCell1_MINUS (_menhir_stack, _menhir_s, _startpos, _endpos) in
            _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState053
        | Tokens.BITVECTOR_LIT _v ->
            let _menhir_stack = MenhirCell1_MINUS (_menhir_stack, _menhir_s, _startpos, _endpos) in
            _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState053
        | Tokens.ARBITRARY ->
            let _menhir_stack = MenhirCell1_MINUS (_menhir_stack, _menhir_s, _startpos, _endpos) in
            _menhir_run_014 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState053
        | Tokens.ARROW | Tokens.COMMA | Tokens.RBRACE | Tokens.RPAR | Tokens.WHERE ->
            let (_endpos__1_, _startpos__1_, _1) = (_endpos, _startpos, ()) in
            let _v = _menhir_action_251 _1 _endpos__1_ _startpos__1_ in
            _menhir_goto_pattern _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__1_ _startpos__1_ _v _menhir_s _tok
        | _ ->
            _eRR 53
    
    and _menhir_goto_pattern : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
        match _menhir_s with
        | MenhirState056 ->
            _menhir_run_256 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState472 ->
            _menhir_run_180 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState040 ->
            _menhir_run_180 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState257 ->
            _menhir_run_180 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState181 ->
            _menhir_run_180 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState172 ->
            _menhir_run_180 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | _ ->
            _menhir_fail ()
    
    and _menhir_run_256 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_LPAR as 'stack) -> _ -> _ -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
        let _menhir_stack = MenhirCell1_pattern (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
        match (_tok : MenhirBasics.token) with
        | Tokens.COMMA ->
            let _menhir_s = MenhirState257 in
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.STRING_LIT _v ->
                _menhir_run_002 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | Tokens.REAL_LIT _v ->
                _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | Tokens.NOT ->
                _menhir_run_041 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.MINUS ->
                _menhir_run_053 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.MASK_LIT _v ->
                _menhir_run_055 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | Tokens.LPAR ->
                _menhir_run_056 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.LE ->
                _menhir_run_057 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.LBRACE ->
                _menhir_run_040 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.INT_LIT _v ->
                _menhir_run_007 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | Tokens.IF ->
                _menhir_run_134 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.IDENTIFIER _v ->
                _menhir_run_142 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | Tokens.GE ->
                _menhir_run_169 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.BOOL_LIT _v ->
                _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | Tokens.BNOT ->
                _menhir_run_171 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.BITVECTOR_LIT _v ->
                _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | Tokens.ARBITRARY ->
                _menhir_run_173 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | _ ->
                _eRR 257)
        | _ ->
            _eRR 256
    
    and _menhir_run_055 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
        let _tok = _menhir_lexer _menhir_lexbuf in
        let (_endpos__1_, _startpos__1_, _1) = (_endpos, _startpos, _v) in
        let _v = _menhir_action_255 _1 _endpos__1_ _startpos__1_ in
        _menhir_goto_pattern _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__1_ _startpos__1_ _v _menhir_s _tok
    
    and _menhir_run_056 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _menhir_stack = MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos) in
        let _menhir_s = MenhirState056 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.STRING_LIT _v ->
            _menhir_run_002 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.REAL_LIT _v ->
            _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.NOT ->
            _menhir_run_041 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.MINUS ->
            _menhir_run_053 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.MASK_LIT _v ->
            _menhir_run_055 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.LPAR ->
            _menhir_run_056 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LE ->
            _menhir_run_057 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LBRACE ->
            _menhir_run_040 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.INT_LIT _v ->
            _menhir_run_007 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.IF ->
            _menhir_run_134 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IDENTIFIER _v ->
            _menhir_run_142 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.GE ->
            _menhir_run_169 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.BOOL_LIT _v ->
            _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BNOT ->
            _menhir_run_171 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.BITVECTOR_LIT _v ->
            _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.ARBITRARY ->
            _menhir_run_173 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | _ ->
            _eRR 56
    
    and _menhir_run_057 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _menhir_stack = MenhirCell1_LE (_menhir_stack, _menhir_s, _startpos) in
        let _menhir_s = MenhirState057 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.STRING_LIT _v ->
            _menhir_run_002 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.REAL_LIT _v ->
            _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.NOT ->
            _menhir_run_004 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.MINUS ->
            _menhir_run_005 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LPAR ->
            _menhir_run_006 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.INT_LIT _v ->
            _menhir_run_007 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.IF ->
            _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IDENTIFIER _v ->
            _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BOOL_LIT _v ->
            _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BNOT ->
            _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.BITVECTOR_LIT _v ->
            _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.ARBITRARY ->
            _menhir_run_014 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | _ ->
            _eRR 57
    
    and _menhir_run_040 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _menhir_stack = MenhirCell1_LBRACE (_menhir_stack, _menhir_s, _startpos) in
        let _menhir_s = MenhirState040 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.STRING_LIT _v ->
            _menhir_run_002 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.REAL_LIT _v ->
            _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.NOT ->
            _menhir_run_041 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.MINUS ->
            _menhir_run_053 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.MASK_LIT _v ->
            _menhir_run_055 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.LPAR ->
            _menhir_run_056 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LE ->
            _menhir_run_057 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LBRACE ->
            _menhir_run_040 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.INT_LIT _v ->
            _menhir_run_007 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.IF ->
            _menhir_run_134 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IDENTIFIER _v ->
            _menhir_run_142 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.GE ->
            _menhir_run_169 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.BOOL_LIT _v ->
            _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BNOT ->
            _menhir_run_171 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.BITVECTOR_LIT _v ->
            _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.ARBITRARY ->
            _menhir_run_173 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | _ ->
            _eRR 40
    
    and _menhir_run_134 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _menhir_stack = MenhirCell1_IF (_menhir_stack, _menhir_s, _startpos) in
        let _menhir_s = MenhirState134 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.STRING_LIT _v ->
            _menhir_run_002 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.REAL_LIT _v ->
            _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.NOT ->
            _menhir_run_004 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.MINUS ->
            _menhir_run_005 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LPAR ->
            _menhir_run_006 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.INT_LIT _v ->
            _menhir_run_007 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.IF ->
            _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IDENTIFIER _v ->
            _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BOOL_LIT _v ->
            _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BNOT ->
            _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.BITVECTOR_LIT _v ->
            _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.ARBITRARY ->
            _menhir_run_014 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | _ ->
            _eRR 134
    
    and _menhir_run_142 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.LPAR ->
            let _menhir_stack = MenhirCell1_IDENTIFIER (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_010 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState142
        | Tokens.LBRACE ->
            let _startpos_0 = _menhir_lexbuf.Lexing.lex_start_p in
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.STRING_LIT _v_1 ->
                let _menhir_stack = MenhirCell1_IDENTIFIER (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
                let _menhir_stack = MenhirCell1_LBRACE (_menhir_stack, MenhirState142, _startpos_0) in
                _menhir_run_002 _menhir_stack _menhir_lexbuf _menhir_lexer _v_1 MenhirState143
            | Tokens.REAL_LIT _v_2 ->
                let _menhir_stack = MenhirCell1_IDENTIFIER (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
                let _menhir_stack = MenhirCell1_LBRACE (_menhir_stack, MenhirState142, _startpos_0) in
                _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v_2 MenhirState143
            | Tokens.NOT ->
                let _menhir_stack = MenhirCell1_IDENTIFIER (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
                let _menhir_stack = MenhirCell1_LBRACE (_menhir_stack, MenhirState142, _startpos_0) in
                _menhir_run_004 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState143
            | Tokens.MINUS ->
                let _startpos_3 = _menhir_lexbuf.Lexing.lex_start_p in
                let _endpos_4 = _menhir_lexbuf.Lexing.lex_curr_p in
                let _tok = _menhir_lexer _menhir_lexbuf in
                (match (_tok : MenhirBasics.token) with
                | Tokens.STRING_LIT _v_5 ->
                    let _menhir_stack = MenhirCell1_IDENTIFIER (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
                    let _menhir_stack = MenhirCell1_LBRACE (_menhir_stack, MenhirState142, _startpos_0) in
                    let _menhir_stack = MenhirCell1_MINUS (_menhir_stack, MenhirState143, _startpos_3, _endpos_4) in
                    _menhir_run_002 _menhir_stack _menhir_lexbuf _menhir_lexer _v_5 MenhirState144
                | Tokens.REAL_LIT _v_6 ->
                    let _menhir_stack = MenhirCell1_IDENTIFIER (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
                    let _menhir_stack = MenhirCell1_LBRACE (_menhir_stack, MenhirState142, _startpos_0) in
                    let _menhir_stack = MenhirCell1_MINUS (_menhir_stack, MenhirState143, _startpos_3, _endpos_4) in
                    _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v_6 MenhirState144
                | Tokens.RBRACE ->
                    let _endpos_7 = _menhir_lexbuf.Lexing.lex_curr_p in
                    let _tok = _menhir_lexer _menhir_lexbuf in
                    let (_2, _endpos_desc_, _startpos_desc_, desc, _3, _endpos__4_, _4) = ((), _endpos, _startpos, _v, (), _endpos_7, ()) in
                    let _v = _menhir_action_213 _2 _3 _4 _endpos__4_ _endpos_desc_ _startpos_desc_ desc in
                    _menhir_goto_expr_pattern _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__4_ _startpos_desc_ _v _menhir_s _tok
                | Tokens.NOT ->
                    let _menhir_stack = MenhirCell1_IDENTIFIER (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
                    let _menhir_stack = MenhirCell1_LBRACE (_menhir_stack, MenhirState142, _startpos_0) in
                    let _menhir_stack = MenhirCell1_MINUS (_menhir_stack, MenhirState143, _startpos_3, _endpos_4) in
                    _menhir_run_004 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState144
                | Tokens.MINUS ->
                    let _menhir_stack = MenhirCell1_IDENTIFIER (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
                    let _menhir_stack = MenhirCell1_LBRACE (_menhir_stack, MenhirState142, _startpos_0) in
                    let _menhir_stack = MenhirCell1_MINUS (_menhir_stack, MenhirState143, _startpos_3, _endpos_4) in
                    _menhir_run_005 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState144
                | Tokens.LPAR ->
                    let _menhir_stack = MenhirCell1_IDENTIFIER (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
                    let _menhir_stack = MenhirCell1_LBRACE (_menhir_stack, MenhirState142, _startpos_0) in
                    let _menhir_stack = MenhirCell1_MINUS (_menhir_stack, MenhirState143, _startpos_3, _endpos_4) in
                    _menhir_run_006 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState144
                | Tokens.INT_LIT _v_8 ->
                    let _menhir_stack = MenhirCell1_IDENTIFIER (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
                    let _menhir_stack = MenhirCell1_LBRACE (_menhir_stack, MenhirState142, _startpos_0) in
                    let _menhir_stack = MenhirCell1_MINUS (_menhir_stack, MenhirState143, _startpos_3, _endpos_4) in
                    _menhir_run_007 _menhir_stack _menhir_lexbuf _menhir_lexer _v_8 MenhirState144
                | Tokens.IF ->
                    let _menhir_stack = MenhirCell1_IDENTIFIER (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
                    let _menhir_stack = MenhirCell1_LBRACE (_menhir_stack, MenhirState142, _startpos_0) in
                    let _menhir_stack = MenhirCell1_MINUS (_menhir_stack, MenhirState143, _startpos_3, _endpos_4) in
                    _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState144
                | Tokens.IDENTIFIER _v_9 ->
                    let _menhir_stack = MenhirCell1_IDENTIFIER (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
                    let _menhir_stack = MenhirCell1_LBRACE (_menhir_stack, MenhirState142, _startpos_0) in
                    let _menhir_stack = MenhirCell1_MINUS (_menhir_stack, MenhirState143, _startpos_3, _endpos_4) in
                    _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v_9 MenhirState144
                | Tokens.BOOL_LIT _v_10 ->
                    let _menhir_stack = MenhirCell1_IDENTIFIER (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
                    let _menhir_stack = MenhirCell1_LBRACE (_menhir_stack, MenhirState142, _startpos_0) in
                    let _menhir_stack = MenhirCell1_MINUS (_menhir_stack, MenhirState143, _startpos_3, _endpos_4) in
                    _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer _v_10 MenhirState144
                | Tokens.BNOT ->
                    let _menhir_stack = MenhirCell1_IDENTIFIER (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
                    let _menhir_stack = MenhirCell1_LBRACE (_menhir_stack, MenhirState142, _startpos_0) in
                    let _menhir_stack = MenhirCell1_MINUS (_menhir_stack, MenhirState143, _startpos_3, _endpos_4) in
                    _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState144
                | Tokens.BITVECTOR_LIT _v_11 ->
                    let _menhir_stack = MenhirCell1_IDENTIFIER (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
                    let _menhir_stack = MenhirCell1_LBRACE (_menhir_stack, MenhirState142, _startpos_0) in
                    let _menhir_stack = MenhirCell1_MINUS (_menhir_stack, MenhirState143, _startpos_3, _endpos_4) in
                    _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _v_11 MenhirState144
                | Tokens.ARBITRARY ->
                    let _menhir_stack = MenhirCell1_IDENTIFIER (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
                    let _menhir_stack = MenhirCell1_LBRACE (_menhir_stack, MenhirState142, _startpos_0) in
                    let _menhir_stack = MenhirCell1_MINUS (_menhir_stack, MenhirState143, _startpos_3, _endpos_4) in
                    _menhir_run_014 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState144
                | _ ->
                    _eRR 144)
            | Tokens.LPAR ->
                let _menhir_stack = MenhirCell1_IDENTIFIER (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
                let _menhir_stack = MenhirCell1_LBRACE (_menhir_stack, MenhirState142, _startpos_0) in
                _menhir_run_006 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState143
            | Tokens.INT_LIT _v_12 ->
                let _menhir_stack = MenhirCell1_IDENTIFIER (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
                let _menhir_stack = MenhirCell1_LBRACE (_menhir_stack, MenhirState142, _startpos_0) in
                _menhir_run_007 _menhir_stack _menhir_lexbuf _menhir_lexer _v_12 MenhirState143
            | Tokens.IF ->
                let _menhir_stack = MenhirCell1_IDENTIFIER (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
                let _menhir_stack = MenhirCell1_LBRACE (_menhir_stack, MenhirState142, _startpos_0) in
                _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState143
            | Tokens.IDENTIFIER _v_13 ->
                let _menhir_stack = MenhirCell1_IDENTIFIER (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
                let _menhir_stack = MenhirCell1_LBRACE (_menhir_stack, MenhirState142, _startpos_0) in
                _menhir_run_146 _menhir_stack _menhir_lexbuf _menhir_lexer _v_13 MenhirState143
            | Tokens.BOOL_LIT _v_14 ->
                let _menhir_stack = MenhirCell1_IDENTIFIER (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
                let _menhir_stack = MenhirCell1_LBRACE (_menhir_stack, MenhirState142, _startpos_0) in
                _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer _v_14 MenhirState143
            | Tokens.BNOT ->
                let _menhir_stack = MenhirCell1_IDENTIFIER (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
                let _menhir_stack = MenhirCell1_LBRACE (_menhir_stack, MenhirState142, _startpos_0) in
                _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState143
            | Tokens.BITVECTOR_LIT _v_15 ->
                let _menhir_stack = MenhirCell1_IDENTIFIER (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
                let _menhir_stack = MenhirCell1_LBRACE (_menhir_stack, MenhirState142, _startpos_0) in
                _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _v_15 MenhirState143
            | Tokens.ARBITRARY ->
                let _menhir_stack = MenhirCell1_IDENTIFIER (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
                let _menhir_stack = MenhirCell1_LBRACE (_menhir_stack, MenhirState142, _startpos_0) in
                _menhir_run_014 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState143
            | _ ->
                _eRR 143)
        | Tokens.AND | Tokens.ARROW | Tokens.AS | Tokens.BAND | Tokens.BEQ | Tokens.BOR | Tokens.COLON_COLON | Tokens.COMMA | Tokens.DIV | Tokens.DIVRM | Tokens.DOT | Tokens.EQ_EQ | Tokens.GE | Tokens.GT | Tokens.IMPL | Tokens.IN | Tokens.LBRACKET | Tokens.LE | Tokens.LLBRACKET | Tokens.LT | Tokens.MINUS | Tokens.MOD | Tokens.MUL | Tokens.NE | Tokens.OR | Tokens.PLUS | Tokens.PLUS_PLUS | Tokens.POW | Tokens.RBRACE | Tokens.RDIV | Tokens.RPAR | Tokens.SHL | Tokens.SHR | Tokens.SLICING | Tokens.WHERE | Tokens.XOR ->
            let (_endpos__1_, _startpos__1_, _1) = (_endpos, _startpos, _v) in
            let _v = _menhir_action_171 _1 _endpos__1_ _startpos__1_ in
            _menhir_goto_expr_pattern _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__1_ _startpos__1_ _v _menhir_s _tok
        | _ ->
            _eRR 142
    
    and _menhir_run_146 : type  ttv_stack ttv_result. (((ttv_stack, ttv_result) _menhir_cell1_IDENTIFIER, ttv_result) _menhir_cell1_LBRACE as 'stack) -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.LPAR ->
            let _menhir_stack = MenhirCell1_IDENTIFIER (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_010 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState146
        | Tokens.LBRACE ->
            let _menhir_stack = MenhirCell1_IDENTIFIER (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_147 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState146
        | Tokens.EQ ->
            let _menhir_stack = MenhirCell1_IDENTIFIER (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_153 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState146
        | Tokens.AND | Tokens.AS | Tokens.BAND | Tokens.BEQ | Tokens.BOR | Tokens.COLON_COLON | Tokens.COMMA | Tokens.DIV | Tokens.DIVRM | Tokens.DOT | Tokens.EQ_EQ | Tokens.GE | Tokens.GT | Tokens.IMPL | Tokens.IN | Tokens.LBRACKET | Tokens.LE | Tokens.LLBRACKET | Tokens.LT | Tokens.MINUS | Tokens.MOD | Tokens.MUL | Tokens.NE | Tokens.OR | Tokens.PLUS | Tokens.PLUS_PLUS | Tokens.POW | Tokens.RBRACE | Tokens.RDIV | Tokens.SHL | Tokens.SHR | Tokens.XOR ->
            let (_endpos__1_, _startpos__1_, _1) = (_endpos, _startpos, _v) in
            let _v = _menhir_action_125 _1 _endpos__1_ _startpos__1_ in
            _menhir_goto_expr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__1_ _startpos__1_ _v _menhir_s _tok
        | _ ->
            _eRR 146
    
    and _menhir_run_147 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_IDENTIFIER as 'stack) -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _menhir_stack = MenhirCell1_LBRACE (_menhir_stack, _menhir_s, _startpos) in
        let _menhir_s = MenhirState147 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.STRING_LIT _v ->
            _menhir_run_002 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.REAL_LIT _v ->
            _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.NOT ->
            _menhir_run_004 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.MINUS ->
            _menhir_run_148 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LPAR ->
            _menhir_run_006 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.INT_LIT _v ->
            _menhir_run_007 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.IF ->
            _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IDENTIFIER _v ->
            _menhir_run_146 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BOOL_LIT _v ->
            _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BNOT ->
            _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.BITVECTOR_LIT _v ->
            _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.ARBITRARY ->
            _menhir_run_014 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | _ ->
            _eRR 147
    
    and _menhir_run_148 : type  ttv_stack ttv_result. (((ttv_stack, ttv_result) _menhir_cell1_IDENTIFIER, ttv_result) _menhir_cell1_LBRACE as 'stack) -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.STRING_LIT _v ->
            let _menhir_stack = MenhirCell1_MINUS (_menhir_stack, _menhir_s, _startpos, _endpos) in
            _menhir_run_002 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState148
        | Tokens.REAL_LIT _v ->
            let _menhir_stack = MenhirCell1_MINUS (_menhir_stack, _menhir_s, _startpos, _endpos) in
            _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState148
        | Tokens.RBRACE ->
            let _endpos_0 = _menhir_lexbuf.Lexing.lex_curr_p in
            let _tok = _menhir_lexer _menhir_lexbuf in
            let MenhirCell1_LBRACE (_menhir_stack, _, _) = _menhir_stack in
            let MenhirCell1_IDENTIFIER (_menhir_stack, _menhir_s, desc, _startpos_desc_, _endpos_desc_) = _menhir_stack in
            let (_2, _3, _endpos__4_, _4) = ((), (), _endpos_0, ()) in
            let _v = _menhir_action_167 _2 _3 _4 _endpos__4_ _endpos_desc_ _startpos_desc_ desc in
            _menhir_goto_expr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__4_ _startpos_desc_ _v _menhir_s _tok
        | Tokens.NOT ->
            let _menhir_stack = MenhirCell1_MINUS (_menhir_stack, _menhir_s, _startpos, _endpos) in
            _menhir_run_004 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState148
        | Tokens.MINUS ->
            let _menhir_stack = MenhirCell1_MINUS (_menhir_stack, _menhir_s, _startpos, _endpos) in
            _menhir_run_005 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState148
        | Tokens.LPAR ->
            let _menhir_stack = MenhirCell1_MINUS (_menhir_stack, _menhir_s, _startpos, _endpos) in
            _menhir_run_006 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState148
        | Tokens.INT_LIT _v ->
            let _menhir_stack = MenhirCell1_MINUS (_menhir_stack, _menhir_s, _startpos, _endpos) in
            _menhir_run_007 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState148
        | Tokens.IF ->
            let _menhir_stack = MenhirCell1_MINUS (_menhir_stack, _menhir_s, _startpos, _endpos) in
            _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState148
        | Tokens.IDENTIFIER _v ->
            let _menhir_stack = MenhirCell1_MINUS (_menhir_stack, _menhir_s, _startpos, _endpos) in
            _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState148
        | Tokens.BOOL_LIT _v ->
            let _menhir_stack = MenhirCell1_MINUS (_menhir_stack, _menhir_s, _startpos, _endpos) in
            _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState148
        | Tokens.BNOT ->
            let _menhir_stack = MenhirCell1_MINUS (_menhir_stack, _menhir_s, _startpos, _endpos) in
            _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState148
        | Tokens.BITVECTOR_LIT _v ->
            let _menhir_stack = MenhirCell1_MINUS (_menhir_stack, _menhir_s, _startpos, _endpos) in
            _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState148
        | Tokens.ARBITRARY ->
            let _menhir_stack = MenhirCell1_MINUS (_menhir_stack, _menhir_s, _startpos, _endpos) in
            _menhir_run_014 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState148
        | _ ->
            _eRR 148
    
    and _menhir_run_153 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_IDENTIFIER as 'stack) -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _menhir_stack = MenhirCell1_EQ (_menhir_stack, _menhir_s) in
        let _menhir_s = MenhirState153 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.STRING_LIT _v ->
            _menhir_run_002 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.REAL_LIT _v ->
            _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.NOT ->
            _menhir_run_004 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.MINUS ->
            _menhir_run_005 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LPAR ->
            _menhir_run_006 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.INT_LIT _v ->
            _menhir_run_007 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.IF ->
            _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IDENTIFIER _v ->
            _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BOOL_LIT _v ->
            _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BNOT ->
            _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.BITVECTOR_LIT _v ->
            _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.ARBITRARY ->
            _menhir_run_014 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | _ ->
            _eRR 153
    
    and _menhir_run_169 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _menhir_stack = MenhirCell1_GE (_menhir_stack, _menhir_s, _startpos) in
        let _menhir_s = MenhirState169 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.STRING_LIT _v ->
            _menhir_run_002 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.REAL_LIT _v ->
            _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.NOT ->
            _menhir_run_004 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.MINUS ->
            _menhir_run_005 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LPAR ->
            _menhir_run_006 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.INT_LIT _v ->
            _menhir_run_007 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.IF ->
            _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IDENTIFIER _v ->
            _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BOOL_LIT _v ->
            _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BNOT ->
            _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.BITVECTOR_LIT _v ->
            _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.ARBITRARY ->
            _menhir_run_014 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | _ ->
            _eRR 169
    
    and _menhir_run_171 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _menhir_stack = MenhirCell1_BNOT (_menhir_stack, _menhir_s, _startpos) in
        let _menhir_s = MenhirState171 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.STRING_LIT _v ->
            _menhir_run_002 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.REAL_LIT _v ->
            _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.NOT ->
            _menhir_run_004 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.MINUS ->
            _menhir_run_005 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LPAR ->
            _menhir_run_006 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LBRACE ->
            _menhir_run_172 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.INT_LIT _v ->
            _menhir_run_007 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.IF ->
            _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IDENTIFIER _v ->
            _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BOOL_LIT _v ->
            _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BNOT ->
            _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.BITVECTOR_LIT _v ->
            _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.ARBITRARY ->
            _menhir_run_014 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | _ ->
            _eRR 171
    
    and _menhir_run_172 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_BNOT as 'stack) -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _menhir_stack = MenhirCell1_LBRACE (_menhir_stack, _menhir_s, _startpos) in
        let _menhir_s = MenhirState172 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.STRING_LIT _v ->
            _menhir_run_002 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.REAL_LIT _v ->
            _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.NOT ->
            _menhir_run_041 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.MINUS ->
            _menhir_run_053 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.MASK_LIT _v ->
            _menhir_run_055 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.LPAR ->
            _menhir_run_056 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LE ->
            _menhir_run_057 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LBRACE ->
            _menhir_run_040 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.INT_LIT _v ->
            _menhir_run_007 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.IF ->
            _menhir_run_134 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IDENTIFIER _v ->
            _menhir_run_142 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.GE ->
            _menhir_run_169 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.BOOL_LIT _v ->
            _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BNOT ->
            _menhir_run_171 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.BITVECTOR_LIT _v ->
            _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.ARBITRARY ->
            _menhir_run_173 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | _ ->
            _eRR 172
    
    and _menhir_run_173 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _menhir_stack = MenhirCell1_ARBITRARY (_menhir_stack, _menhir_s, _startpos) in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.COLON ->
            let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
            let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
            let _menhir_stack = MenhirCell0_COLON (_menhir_stack, _startpos, _endpos) in
            let _menhir_s = MenhirState174 in
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.STRING ->
                _menhir_run_016 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.REAL ->
                _menhir_run_017 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.LPAR ->
                _menhir_run_018 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.INTEGER ->
                _menhir_run_019 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.IDENTIFIER _v ->
                _menhir_run_104 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | Tokens.BOOLEAN ->
                _menhir_run_105 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.BITS ->
                _menhir_run_106 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.BIT ->
                _menhir_run_117 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.ARRAY ->
                _menhir_run_118 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | _ ->
                _eRR 174)
        | _ ->
            _eRR 173
    
    and _menhir_run_180 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
        match (_tok : MenhirBasics.token) with
        | Tokens.COMMA ->
            let _menhir_stack = MenhirCell1_pattern (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            let _menhir_s = MenhirState181 in
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.STRING_LIT _v ->
                _menhir_run_002 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | Tokens.REAL_LIT _v ->
                _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | Tokens.NOT ->
                _menhir_run_041 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.MINUS ->
                _menhir_run_053 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.MASK_LIT _v ->
                _menhir_run_055 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | Tokens.LPAR ->
                _menhir_run_056 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.LE ->
                _menhir_run_057 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.LBRACE ->
                _menhir_run_040 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.INT_LIT _v ->
                _menhir_run_007 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | Tokens.IF ->
                _menhir_run_134 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.IDENTIFIER _v ->
                _menhir_run_142 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | Tokens.GE ->
                _menhir_run_169 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.BOOL_LIT _v ->
                _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | Tokens.BNOT ->
                _menhir_run_171 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.BITVECTOR_LIT _v ->
                _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | Tokens.ARBITRARY ->
                _menhir_run_173 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | _ ->
                _eRR 181)
        | Tokens.ARROW | Tokens.RBRACE | Tokens.RPAR | Tokens.WHERE ->
            let (_endpos_x_, _startpos_x_, x) = (_endpos, _startpos, _v) in
            let _v = _menhir_action_046 x in
            _menhir_goto_clist1_pattern_ _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_x_ _startpos_x_ _v _menhir_s _tok
        | _ ->
            _eRR 180
    
    and _menhir_goto_clist1_pattern_ : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
        match _menhir_s with
        | MenhirState257 ->
            _menhir_run_258 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
        | MenhirState472 ->
            _menhir_run_254 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState040 ->
            _menhir_run_254 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState172 ->
            _menhir_run_254 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState181 ->
            _menhir_run_252 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
        | _ ->
            _menhir_fail ()
    
    and _menhir_run_258 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_LPAR, ttv_result) _menhir_cell1_pattern -> _ -> _ -> _ -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
        let MenhirCell1_pattern (_menhir_stack, _, x, _, _) = _menhir_stack in
        let (_2, li) = ((), _v) in
        let _v = _menhir_action_060 _2 li x in
        match (_tok : MenhirBasics.token) with
        | Tokens.RPAR ->
            let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
            let _tok = _menhir_lexer _menhir_lexbuf in
            let MenhirCell1_LPAR (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
            let (x, _endpos__3_) = (_v, _endpos) in
            let _v = _menhir_action_254 _endpos__3_ _startpos__1_ x in
            _menhir_goto_pattern _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__3_ _startpos__1_ _v _menhir_s _tok
        | _ ->
            _eRR 261
    
    and _menhir_run_254 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
        let (_endpos__1_, _startpos__1_, _1) = (_endpos, _startpos, _v) in
        let _v = _menhir_action_257 _1 _endpos__1_ _startpos__1_ in
        _menhir_goto_pattern_list _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
    
    and _menhir_goto_pattern_list : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
        match _menhir_s with
        | MenhirState472 ->
            _menhir_run_473 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
        | MenhirState040 ->
            _menhir_run_263 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
        | MenhirState172 ->
            _menhir_run_178 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
        | _ ->
            _menhir_fail ()
    
    and _menhir_run_473 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_WHEN as 'stack) -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
        let _menhir_stack = MenhirCell1_pattern_list (_menhir_stack, _menhir_s, _v) in
        match (_tok : MenhirBasics.token) with
        | Tokens.WHERE ->
            let _menhir_s = MenhirState474 in
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.STRING_LIT _v ->
                _menhir_run_002 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | Tokens.REAL_LIT _v ->
                _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | Tokens.NOT ->
                _menhir_run_004 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.MINUS ->
                _menhir_run_005 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.LPAR ->
                _menhir_run_006 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.INT_LIT _v ->
                _menhir_run_007 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | Tokens.IF ->
                _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.IDENTIFIER _v ->
                _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | Tokens.BOOL_LIT _v ->
                _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | Tokens.BNOT ->
                _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.BITVECTOR_LIT _v ->
                _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | Tokens.ARBITRARY ->
                _menhir_run_014 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | _ ->
                _eRR 474)
        | Tokens.ARROW ->
            let _menhir_s = MenhirState509 in
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.WHILE ->
                _menhir_run_001 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.VAR ->
                _menhir_run_318 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.UNREACHABLE ->
                _menhir_run_363 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.TRY ->
                _menhir_run_365 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.THROW ->
                _menhir_run_366 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.RETURN ->
                _menhir_run_369 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.REPEAT ->
                _menhir_run_373 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.PRINTLN ->
                _menhir_run_374 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.PRINT ->
                _menhir_run_377 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.PRAGMA ->
                _menhir_run_380 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.PASS ->
                _menhir_run_384 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.MINUS ->
                _menhir_run_386 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.LPAR ->
                _menhir_run_387 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.LET ->
                _menhir_run_408 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.IF ->
                _menhir_run_420 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.IDENTIFIER _v ->
                _menhir_run_423 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | Tokens.FOR ->
                _menhir_run_443 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.DEBUG ->
                _menhir_run_453 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.CONSTANT ->
                _menhir_run_458 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.CASE ->
                _menhir_run_469 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | Tokens.ASSERT ->
                _menhir_run_477 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
            | _ ->
                _eRR 509)
        | _ ->
            _eRR 473
    
    and _menhir_run_263 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_LBRACE -> _ -> _ -> _ -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
        match (_tok : MenhirBasics.token) with
        | Tokens.RBRACE ->
            let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
            let _tok = _menhir_lexer _menhir_lexbuf in
            let MenhirCell1_LBRACE (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
            let (x, _endpos__3_) = (_v, _endpos) in
            let _v = _menhir_action_258 x in
            _menhir_goto_pattern_set _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__3_ _startpos__1_ _v _menhir_s _tok
        | _ ->
            _eRR 263
    
    and _menhir_goto_pattern_set : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
        match _menhir_s with
        | MenhirState039 ->
            _menhir_run_265 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
        | MenhirState217 ->
            _menhir_run_219 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
        | MenhirState472 ->
            _menhir_run_177 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState040 ->
            _menhir_run_177 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState257 ->
            _menhir_run_177 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState056 ->
            _menhir_run_177 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState181 ->
            _menhir_run_177 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | MenhirState172 ->
            _menhir_run_177 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
        | _ ->
            _menhir_fail ()
    
    and _menhir_run_265 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_expr, ttv_result) _menhir_cell1_IN -> _ -> _ -> _ -> _ -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
        let MenhirCell1_IN (_menhir_stack, _) = _menhir_stack in
        let MenhirCell1_expr (_menhir_stack, _menhir_s, expr, _startpos_expr_, _) = _menhir_stack in
        let (_2, _endpos_pattern_set_, pattern_set) = ((), _endpos, _v) in
        let _v = _menhir_action_162 _2 _endpos_pattern_set_ _startpos_expr_ expr pattern_set in
        _menhir_goto_expr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_pattern_set_ _startpos_expr_ _v _menhir_s _tok
    
    and _menhir_run_219 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_expr_pattern, ttv_result) _menhir_cell1_IN -> _ -> _ -> _ -> _ -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
        let MenhirCell1_IN (_menhir_stack, _) = _menhir_stack in
        let MenhirCell1_expr_pattern (_menhir_stack, _menhir_s, expr_pattern, _startpos_expr_pattern_, _) = _menhir_stack in
        let (_2, _endpos_pattern_set_, pattern_set) = ((), _endpos, _v) in
        let _v = _menhir_action_208 _2 _endpos_pattern_set_ _startpos_expr_pattern_ expr_pattern pattern_set in
        _menhir_goto_expr_pattern _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_pattern_set_ _startpos_expr_pattern_ _v _menhir_s _tok
    
    and _menhir_run_177 : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
        let (_endpos__1_, _startpos__1_, _1) = (_endpos, _startpos, _v) in
        let _v = _menhir_action_256 _1 in
        _menhir_goto_pattern _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__1_ _startpos__1_ _v _menhir_s _tok
    
    and _menhir_run_178 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_BNOT, ttv_result) _menhir_cell1_LBRACE -> _ -> _ -> _ -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
        match (_tok : MenhirBasics.token) with
        | Tokens.RBRACE ->
            let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
            let _tok = _menhir_lexer _menhir_lexbuf in
            let MenhirCell1_LBRACE (_menhir_stack, _, _) = _menhir_stack in
            let MenhirCell1_BNOT (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
            let (_1, x, _endpos__3_) = ((), _v, _endpos) in
            let _v = _menhir_action_259 _1 _endpos__3_ _startpos__1_ x in
            _menhir_goto_pattern_set _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__3_ _startpos__1_ _v _menhir_s _tok
        | _ ->
            _eRR 178
    
    and _menhir_run_252 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_pattern -> _ -> _ -> _ -> _ -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
        let MenhirCell1_pattern (_menhir_stack, _menhir_s, h, _startpos_h_, _) = _menhir_stack in
        let (_2, _endpos_t_, t) = ((), _endpos, _v) in
        let _v = _menhir_action_047 _2 h t in
        _menhir_goto_clist1_pattern_ _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_t_ _startpos_h_ _v _menhir_s _tok
    
    and _menhir_goto_list1_case_alt_ : type  ttv_stack ttv_result. ttv_stack -> _ -> _ -> _ -> (ttv_stack, ttv_result) _menhir_state -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
        match _menhir_s with
        | MenhirState519 ->
            _menhir_run_520 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
        | MenhirState471 ->
            _menhir_run_511 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
        | _ ->
            _menhir_fail ()
    
    and _menhir_run_520 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_case_alt -> _ -> _ -> _ -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
        let MenhirCell1_case_alt (_menhir_stack, _menhir_s, x) = _menhir_stack in
        let l = _v in
        let _v = _menhir_action_233 l x in
        _menhir_goto_list1_case_alt_ _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
    
    and _menhir_run_511 : type  ttv_stack ttv_result. ((((ttv_stack, ttv_result) _menhir_cell1_CASE, ttv_result) _menhir_cell1_expr, ttv_result) _menhir_cell1_OF as 'stack) -> _ -> _ -> _ -> ('stack, ttv_result) _menhir_state -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
        match (_tok : MenhirBasics.token) with
        | Tokens.OTHERWISE ->
            let _menhir_stack = MenhirCell1_list1_case_alt_ (_menhir_stack, _menhir_s, _v) in
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.ARROW ->
                let _menhir_s = MenhirState513 in
                let _tok = _menhir_lexer _menhir_lexbuf in
                (match (_tok : MenhirBasics.token) with
                | Tokens.WHILE ->
                    _menhir_run_001 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
                | Tokens.VAR ->
                    _menhir_run_318 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
                | Tokens.UNREACHABLE ->
                    _menhir_run_363 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
                | Tokens.TRY ->
                    _menhir_run_365 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
                | Tokens.THROW ->
                    _menhir_run_366 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
                | Tokens.RETURN ->
                    _menhir_run_369 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
                | Tokens.REPEAT ->
                    _menhir_run_373 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
                | Tokens.PRINTLN ->
                    _menhir_run_374 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
                | Tokens.PRINT ->
                    _menhir_run_377 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
                | Tokens.PRAGMA ->
                    _menhir_run_380 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
                | Tokens.PASS ->
                    _menhir_run_384 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
                | Tokens.MINUS ->
                    _menhir_run_386 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
                | Tokens.LPAR ->
                    _menhir_run_387 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
                | Tokens.LET ->
                    _menhir_run_408 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
                | Tokens.IF ->
                    _menhir_run_420 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
                | Tokens.IDENTIFIER _v ->
                    _menhir_run_423 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
                | Tokens.FOR ->
                    _menhir_run_443 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
                | Tokens.DEBUG ->
                    _menhir_run_453 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
                | Tokens.CONSTANT ->
                    _menhir_run_458 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
                | Tokens.CASE ->
                    _menhir_run_469 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
                | Tokens.ASSERT ->
                    _menhir_run_477 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
                | _ ->
                    _eRR 513)
            | _ ->
                _eRR 512)
        | Tokens.END ->
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.SEMI_COLON ->
                let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
                let _tok = _menhir_lexer _menhir_lexbuf in
                let MenhirCell1_OF (_menhir_stack, _) = _menhir_stack in
                let MenhirCell1_expr (_menhir_stack, _, expr, _, _) = _menhir_stack in
                let MenhirCell1_CASE (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
                let (_1, _endpos__2_, _2, _3, _1_inlined1, _1_inlined2) = ((), _endpos, (), (), _v, ()) in
                let _v = _menhir_action_276 _1 _1_inlined1 _1_inlined2 _2 _3 _endpos__2_ _startpos__1_ expr in
                _menhir_goto_stmt _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__2_ _v _menhir_s _tok
            | _ ->
                _eRR 517)
        | _ ->
            _menhir_fail ()
    
    and _menhir_run_480 : type  ttv_stack ttv_result. ((((ttv_stack, ttv_result) _menhir_cell1_WHEN, ttv_result) _menhir_cell1_pattern_list, ttv_result) _menhir_cell1_expr, ttv_result) _menhir_cell1_ARROW -> _ -> _ -> _ -> _ -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
        let MenhirCell1_ARROW (_menhir_stack, _) = _menhir_stack in
        let MenhirCell1_expr (_menhir_stack, _, _2, _, _) = _menhir_stack in
        let MenhirCell1_pattern_list (_menhir_stack, _, pattern) = _menhir_stack in
        let MenhirCell1_WHEN (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
        let (_1, _4, _1_inlined1, _endpos_stmt_, stmt) = ((), (), (), _endpos, _v) in
        let _v = _menhir_action_021 _1 _1_inlined1 _2 _4 _endpos_stmt_ _startpos__1_ pattern stmt in
        _menhir_goto_case_alt _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
    
    and _menhir_run_482 : type  ttv_stack ttv_result. (ttv_stack, ttv_result) _menhir_cell1_stmt -> _ -> _ -> _ -> _ -> _ -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
        let MenhirCell1_stmt (_menhir_stack, _menhir_s, x, _) = _menhir_stack in
        let (_endpos_l_, l) = (_endpos, _v) in
        let _v = _menhir_action_237 l x in
        _menhir_goto_list1_stmt_ _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_l_ _v _menhir_s _tok
    
    and _menhir_run_850 : type  ttv_stack. (((ttv_stack, _menhir_box_spec) _menhir_cell1_IMPDEF _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_spec) _menhir_state -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
        let _menhir_stack = MenhirCell1_func_args (_menhir_stack, _menhir_s, _v) in
        match (_tok : MenhirBasics.token) with
        | Tokens.BEQ ->
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.IDENTIFIER _v ->
                let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
                let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
                let _menhir_stack = MenhirCell0_IDENTIFIER (_menhir_stack, _v, _startpos, _endpos) in
                let _menhir_s = MenhirState852 in
                let _tok = _menhir_lexer _menhir_lexbuf in
                (match (_tok : MenhirBasics.token) with
                | Tokens.COLON ->
                    _menhir_run_116 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
                | _ ->
                    _eRR 852)
            | _ ->
                _eRR 851)
        | _ ->
            _eRR 850
    
    and _menhir_run_835 : type  ttv_stack. (((ttv_stack, _menhir_box_spec) _menhir_cell1_IMPDEF _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_spec) _menhir_state -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
        let _menhir_stack = MenhirCell1_func_args (_menhir_stack, _menhir_s, _v) in
        match (_tok : MenhirBasics.token) with
        | Tokens.RECURSELIMIT ->
            _menhir_run_645 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState835
        | Tokens.ARROW ->
            _menhir_run_647 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState835
        | Tokens.BEGIN ->
            let _v_0 = _menhir_action_260 () in
            _menhir_run_842 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState835
        | _ ->
            _eRR 835
    
    and _menhir_run_842 : type  ttv_stack. ((((ttv_stack, _menhir_box_spec) _menhir_cell1_IMPDEF _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_spec) _menhir_state -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
        let _menhir_stack = MenhirCell1_recurse_limit (_menhir_stack, _menhir_s, _v) in
        let _menhir_s = MenhirState843 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.WHILE ->
            _menhir_run_001 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.VAR ->
            _menhir_run_318 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.UNREACHABLE ->
            _menhir_run_363 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.TRY ->
            _menhir_run_365 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.THROW ->
            _menhir_run_366 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.RETURN ->
            _menhir_run_369 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.REPEAT ->
            _menhir_run_373 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PRINTLN ->
            _menhir_run_374 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PRINT ->
            _menhir_run_377 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PRAGMA ->
            _menhir_run_380 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PASS ->
            _menhir_run_384 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.MINUS ->
            _menhir_run_386 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LPAR ->
            _menhir_run_387 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LET ->
            _menhir_run_408 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IF ->
            _menhir_run_420 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IDENTIFIER _v ->
            _menhir_run_423 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.FOR ->
            _menhir_run_443 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.DEBUG ->
            _menhir_run_453 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.CONSTANT ->
            _menhir_run_458 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.CASE ->
            _menhir_run_469 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.ASSERT ->
            _menhir_run_477 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | _ ->
            _eRR 843
    
    and _menhir_run_804 : type  ttv_stack. (((ttv_stack, _menhir_box_spec) _menhir_cell1_IMPLEMENTATION _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_spec) _menhir_state -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
        let _menhir_stack = MenhirCell1_func_args (_menhir_stack, _menhir_s, _v) in
        match (_tok : MenhirBasics.token) with
        | Tokens.BEQ ->
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.IDENTIFIER _v ->
                let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
                let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
                let _menhir_stack = MenhirCell0_IDENTIFIER (_menhir_stack, _v, _startpos, _endpos) in
                let _menhir_s = MenhirState806 in
                let _tok = _menhir_lexer _menhir_lexbuf in
                (match (_tok : MenhirBasics.token) with
                | Tokens.COLON ->
                    _menhir_run_116 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
                | _ ->
                    _eRR 806)
            | _ ->
                _eRR 805)
        | _ ->
            _eRR 804
    
    and _menhir_run_789 : type  ttv_stack. (((ttv_stack, _menhir_box_spec) _menhir_cell1_IMPLEMENTATION _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_spec) _menhir_state -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
        let _menhir_stack = MenhirCell1_func_args (_menhir_stack, _menhir_s, _v) in
        match (_tok : MenhirBasics.token) with
        | Tokens.RECURSELIMIT ->
            _menhir_run_645 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState789
        | Tokens.ARROW ->
            _menhir_run_647 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState789
        | Tokens.BEGIN ->
            let _v_0 = _menhir_action_260 () in
            _menhir_run_796 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState789
        | _ ->
            _eRR 789
    
    and _menhir_run_796 : type  ttv_stack. ((((ttv_stack, _menhir_box_spec) _menhir_cell1_IMPLEMENTATION _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_spec) _menhir_state -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
        let _menhir_stack = MenhirCell1_recurse_limit (_menhir_stack, _menhir_s, _v) in
        let _menhir_s = MenhirState797 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.WHILE ->
            _menhir_run_001 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.VAR ->
            _menhir_run_318 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.UNREACHABLE ->
            _menhir_run_363 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.TRY ->
            _menhir_run_365 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.THROW ->
            _menhir_run_366 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.RETURN ->
            _menhir_run_369 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.REPEAT ->
            _menhir_run_373 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PRINTLN ->
            _menhir_run_374 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PRINT ->
            _menhir_run_377 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PRAGMA ->
            _menhir_run_380 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PASS ->
            _menhir_run_384 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.MINUS ->
            _menhir_run_386 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LPAR ->
            _menhir_run_387 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LET ->
            _menhir_run_408 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IF ->
            _menhir_run_420 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IDENTIFIER _v ->
            _menhir_run_423 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.FOR ->
            _menhir_run_443 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.DEBUG ->
            _menhir_run_453 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.CONSTANT ->
            _menhir_run_458 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.CASE ->
            _menhir_run_469 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.ASSERT ->
            _menhir_run_477 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | _ ->
            _eRR 797
    
    and _menhir_run_767 : type  ttv_stack. (((ttv_stack, _menhir_box_spec) _menhir_cell1_NORETURN _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_spec) _menhir_state -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
        let _menhir_stack = MenhirCell1_func_args (_menhir_stack, _menhir_s, _v) in
        match (_tok : MenhirBasics.token) with
        | Tokens.RECURSELIMIT ->
            _menhir_run_645 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState767
        | Tokens.BEGIN ->
            let _v_0 = _menhir_action_260 () in
            _menhir_run_768 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState767
        | _ ->
            _eRR 767
    
    and _menhir_run_768 : type  ttv_stack. ((((ttv_stack, _menhir_box_spec) _menhir_cell1_NORETURN _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_spec) _menhir_state -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
        let _menhir_stack = MenhirCell1_recurse_limit (_menhir_stack, _menhir_s, _v) in
        let _menhir_s = MenhirState769 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.WHILE ->
            _menhir_run_001 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.VAR ->
            _menhir_run_318 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.UNREACHABLE ->
            _menhir_run_363 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.TRY ->
            _menhir_run_365 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.THROW ->
            _menhir_run_366 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.RETURN ->
            _menhir_run_369 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.REPEAT ->
            _menhir_run_373 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PRINTLN ->
            _menhir_run_374 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PRINT ->
            _menhir_run_377 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PRAGMA ->
            _menhir_run_380 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PASS ->
            _menhir_run_384 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.MINUS ->
            _menhir_run_386 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LPAR ->
            _menhir_run_387 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LET ->
            _menhir_run_408 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IF ->
            _menhir_run_420 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IDENTIFIER _v ->
            _menhir_run_423 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.FOR ->
            _menhir_run_443 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.DEBUG ->
            _menhir_run_453 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.CONSTANT ->
            _menhir_run_458 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.CASE ->
            _menhir_run_469 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.ASSERT ->
            _menhir_run_477 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | _ ->
            _eRR 769
    
    and _menhir_run_758 : type  ttv_stack. (((ttv_stack, _menhir_box_spec) _menhir_cell1_NORETURN _menhir_cell0_IMPDEF _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_spec) _menhir_state -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
        let _menhir_stack = MenhirCell1_func_args (_menhir_stack, _menhir_s, _v) in
        match (_tok : MenhirBasics.token) with
        | Tokens.RECURSELIMIT ->
            _menhir_run_645 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState758
        | Tokens.BEGIN ->
            let _v_0 = _menhir_action_260 () in
            _menhir_run_759 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState758
        | _ ->
            _eRR 758
    
    and _menhir_run_759 : type  ttv_stack. ((((ttv_stack, _menhir_box_spec) _menhir_cell1_NORETURN _menhir_cell0_IMPDEF _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_spec) _menhir_state -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
        let _menhir_stack = MenhirCell1_recurse_limit (_menhir_stack, _menhir_s, _v) in
        let _menhir_s = MenhirState760 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.WHILE ->
            _menhir_run_001 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.VAR ->
            _menhir_run_318 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.UNREACHABLE ->
            _menhir_run_363 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.TRY ->
            _menhir_run_365 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.THROW ->
            _menhir_run_366 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.RETURN ->
            _menhir_run_369 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.REPEAT ->
            _menhir_run_373 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PRINTLN ->
            _menhir_run_374 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PRINT ->
            _menhir_run_377 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PRAGMA ->
            _menhir_run_380 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PASS ->
            _menhir_run_384 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.MINUS ->
            _menhir_run_386 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LPAR ->
            _menhir_run_387 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LET ->
            _menhir_run_408 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IF ->
            _menhir_run_420 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IDENTIFIER _v ->
            _menhir_run_423 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.FOR ->
            _menhir_run_443 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.DEBUG ->
            _menhir_run_453 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.CONSTANT ->
            _menhir_run_458 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.CASE ->
            _menhir_run_469 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.ASSERT ->
            _menhir_run_477 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | _ ->
            _eRR 760
    
    and _menhir_run_748 : type  ttv_stack. (((ttv_stack, _menhir_box_spec) _menhir_cell1_NORETURN _menhir_cell0_IMPLEMENTATION _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_spec) _menhir_state -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
        let _menhir_stack = MenhirCell1_func_args (_menhir_stack, _menhir_s, _v) in
        match (_tok : MenhirBasics.token) with
        | Tokens.RECURSELIMIT ->
            _menhir_run_645 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState748
        | Tokens.BEGIN ->
            let _v_0 = _menhir_action_260 () in
            _menhir_run_749 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState748
        | _ ->
            _eRR 748
    
    and _menhir_run_749 : type  ttv_stack. ((((ttv_stack, _menhir_box_spec) _menhir_cell1_NORETURN _menhir_cell0_IMPLEMENTATION _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_spec) _menhir_state -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
        let _menhir_stack = MenhirCell1_recurse_limit (_menhir_stack, _menhir_s, _v) in
        let _menhir_s = MenhirState750 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.WHILE ->
            _menhir_run_001 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.VAR ->
            _menhir_run_318 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.UNREACHABLE ->
            _menhir_run_363 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.TRY ->
            _menhir_run_365 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.THROW ->
            _menhir_run_366 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.RETURN ->
            _menhir_run_369 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.REPEAT ->
            _menhir_run_373 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PRINTLN ->
            _menhir_run_374 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PRINT ->
            _menhir_run_377 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PRAGMA ->
            _menhir_run_380 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PASS ->
            _menhir_run_384 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.MINUS ->
            _menhir_run_386 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LPAR ->
            _menhir_run_387 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LET ->
            _menhir_run_408 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IF ->
            _menhir_run_420 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IDENTIFIER _v ->
            _menhir_run_423 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.FOR ->
            _menhir_run_443 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.DEBUG ->
            _menhir_run_453 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.CONSTANT ->
            _menhir_run_458 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.CASE ->
            _menhir_run_469 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.ASSERT ->
            _menhir_run_477 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | _ ->
            _eRR 750
    
    and _menhir_run_727 : type  ttv_stack. (((ttv_stack, _menhir_box_spec) _menhir_cell1_PURE _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_spec) _menhir_state -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
        let _menhir_stack = MenhirCell1_func_args (_menhir_stack, _menhir_s, _v) in
        match (_tok : MenhirBasics.token) with
        | Tokens.RECURSELIMIT ->
            _menhir_run_645 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState727
        | Tokens.ARROW ->
            _menhir_run_647 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState727
        | Tokens.BEGIN ->
            let _v_0 = _menhir_action_260 () in
            _menhir_run_734 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState727
        | _ ->
            _eRR 727
    
    and _menhir_run_734 : type  ttv_stack. ((((ttv_stack, _menhir_box_spec) _menhir_cell1_PURE _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_spec) _menhir_state -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
        let _menhir_stack = MenhirCell1_recurse_limit (_menhir_stack, _menhir_s, _v) in
        let _menhir_s = MenhirState735 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.WHILE ->
            _menhir_run_001 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.VAR ->
            _menhir_run_318 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.UNREACHABLE ->
            _menhir_run_363 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.TRY ->
            _menhir_run_365 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.THROW ->
            _menhir_run_366 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.RETURN ->
            _menhir_run_369 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.REPEAT ->
            _menhir_run_373 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PRINTLN ->
            _menhir_run_374 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PRINT ->
            _menhir_run_377 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PRAGMA ->
            _menhir_run_380 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PASS ->
            _menhir_run_384 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.MINUS ->
            _menhir_run_386 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LPAR ->
            _menhir_run_387 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LET ->
            _menhir_run_408 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IF ->
            _menhir_run_420 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IDENTIFIER _v ->
            _menhir_run_423 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.FOR ->
            _menhir_run_443 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.DEBUG ->
            _menhir_run_453 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.CONSTANT ->
            _menhir_run_458 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.CASE ->
            _menhir_run_469 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.ASSERT ->
            _menhir_run_477 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | _ ->
            _eRR 735
    
    and _menhir_run_712 : type  ttv_stack. (((ttv_stack, _menhir_box_spec) _menhir_cell1_PURE _menhir_cell0_IMPDEF _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_spec) _menhir_state -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
        let _menhir_stack = MenhirCell1_func_args (_menhir_stack, _menhir_s, _v) in
        match (_tok : MenhirBasics.token) with
        | Tokens.RECURSELIMIT ->
            _menhir_run_645 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState712
        | Tokens.ARROW ->
            _menhir_run_647 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState712
        | Tokens.BEGIN ->
            let _v_0 = _menhir_action_260 () in
            _menhir_run_719 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState712
        | _ ->
            _eRR 712
    
    and _menhir_run_719 : type  ttv_stack. ((((ttv_stack, _menhir_box_spec) _menhir_cell1_PURE _menhir_cell0_IMPDEF _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_spec) _menhir_state -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
        let _menhir_stack = MenhirCell1_recurse_limit (_menhir_stack, _menhir_s, _v) in
        let _menhir_s = MenhirState720 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.WHILE ->
            _menhir_run_001 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.VAR ->
            _menhir_run_318 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.UNREACHABLE ->
            _menhir_run_363 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.TRY ->
            _menhir_run_365 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.THROW ->
            _menhir_run_366 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.RETURN ->
            _menhir_run_369 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.REPEAT ->
            _menhir_run_373 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PRINTLN ->
            _menhir_run_374 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PRINT ->
            _menhir_run_377 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PRAGMA ->
            _menhir_run_380 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PASS ->
            _menhir_run_384 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.MINUS ->
            _menhir_run_386 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LPAR ->
            _menhir_run_387 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LET ->
            _menhir_run_408 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IF ->
            _menhir_run_420 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IDENTIFIER _v ->
            _menhir_run_423 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.FOR ->
            _menhir_run_443 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.DEBUG ->
            _menhir_run_453 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.CONSTANT ->
            _menhir_run_458 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.CASE ->
            _menhir_run_469 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.ASSERT ->
            _menhir_run_477 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | _ ->
            _eRR 720
    
    and _menhir_run_696 : type  ttv_stack. (((ttv_stack, _menhir_box_spec) _menhir_cell1_PURE _menhir_cell0_IMPLEMENTATION _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_spec) _menhir_state -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
        let _menhir_stack = MenhirCell1_func_args (_menhir_stack, _menhir_s, _v) in
        match (_tok : MenhirBasics.token) with
        | Tokens.RECURSELIMIT ->
            _menhir_run_645 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState696
        | Tokens.ARROW ->
            _menhir_run_647 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState696
        | Tokens.BEGIN ->
            let _v_0 = _menhir_action_260 () in
            _menhir_run_703 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState696
        | _ ->
            _eRR 696
    
    and _menhir_run_703 : type  ttv_stack. ((((ttv_stack, _menhir_box_spec) _menhir_cell1_PURE _menhir_cell0_IMPLEMENTATION _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_spec) _menhir_state -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
        let _menhir_stack = MenhirCell1_recurse_limit (_menhir_stack, _menhir_s, _v) in
        let _menhir_s = MenhirState704 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.WHILE ->
            _menhir_run_001 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.VAR ->
            _menhir_run_318 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.UNREACHABLE ->
            _menhir_run_363 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.TRY ->
            _menhir_run_365 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.THROW ->
            _menhir_run_366 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.RETURN ->
            _menhir_run_369 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.REPEAT ->
            _menhir_run_373 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PRINTLN ->
            _menhir_run_374 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PRINT ->
            _menhir_run_377 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PRAGMA ->
            _menhir_run_380 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PASS ->
            _menhir_run_384 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.MINUS ->
            _menhir_run_386 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LPAR ->
            _menhir_run_387 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LET ->
            _menhir_run_408 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IF ->
            _menhir_run_420 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IDENTIFIER _v ->
            _menhir_run_423 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.FOR ->
            _menhir_run_443 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.DEBUG ->
            _menhir_run_453 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.CONSTANT ->
            _menhir_run_458 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.CASE ->
            _menhir_run_469 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.ASSERT ->
            _menhir_run_477 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | _ ->
            _eRR 704
    
    and _menhir_run_679 : type  ttv_stack. (((ttv_stack, _menhir_box_spec) _menhir_cell1_READONLY _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_spec) _menhir_state -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
        let _menhir_stack = MenhirCell1_func_args (_menhir_stack, _menhir_s, _v) in
        match (_tok : MenhirBasics.token) with
        | Tokens.RECURSELIMIT ->
            _menhir_run_645 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState679
        | Tokens.ARROW ->
            _menhir_run_647 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState679
        | Tokens.BEGIN ->
            let _v_0 = _menhir_action_260 () in
            _menhir_run_686 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState679
        | _ ->
            _eRR 679
    
    and _menhir_run_686 : type  ttv_stack. ((((ttv_stack, _menhir_box_spec) _menhir_cell1_READONLY _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_spec) _menhir_state -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
        let _menhir_stack = MenhirCell1_recurse_limit (_menhir_stack, _menhir_s, _v) in
        let _menhir_s = MenhirState687 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.WHILE ->
            _menhir_run_001 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.VAR ->
            _menhir_run_318 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.UNREACHABLE ->
            _menhir_run_363 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.TRY ->
            _menhir_run_365 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.THROW ->
            _menhir_run_366 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.RETURN ->
            _menhir_run_369 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.REPEAT ->
            _menhir_run_373 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PRINTLN ->
            _menhir_run_374 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PRINT ->
            _menhir_run_377 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PRAGMA ->
            _menhir_run_380 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PASS ->
            _menhir_run_384 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.MINUS ->
            _menhir_run_386 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LPAR ->
            _menhir_run_387 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LET ->
            _menhir_run_408 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IF ->
            _menhir_run_420 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IDENTIFIER _v ->
            _menhir_run_423 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.FOR ->
            _menhir_run_443 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.DEBUG ->
            _menhir_run_453 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.CONSTANT ->
            _menhir_run_458 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.CASE ->
            _menhir_run_469 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.ASSERT ->
            _menhir_run_477 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | _ ->
            _eRR 687
    
    and _menhir_run_664 : type  ttv_stack. (((ttv_stack, _menhir_box_spec) _menhir_cell1_READONLY _menhir_cell0_IMPDEF _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_spec) _menhir_state -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
        let _menhir_stack = MenhirCell1_func_args (_menhir_stack, _menhir_s, _v) in
        match (_tok : MenhirBasics.token) with
        | Tokens.RECURSELIMIT ->
            _menhir_run_645 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState664
        | Tokens.ARROW ->
            _menhir_run_647 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState664
        | Tokens.BEGIN ->
            let _v_0 = _menhir_action_260 () in
            _menhir_run_671 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState664
        | _ ->
            _eRR 664
    
    and _menhir_run_671 : type  ttv_stack. ((((ttv_stack, _menhir_box_spec) _menhir_cell1_READONLY _menhir_cell0_IMPDEF _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_spec) _menhir_state -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
        let _menhir_stack = MenhirCell1_recurse_limit (_menhir_stack, _menhir_s, _v) in
        let _menhir_s = MenhirState672 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.WHILE ->
            _menhir_run_001 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.VAR ->
            _menhir_run_318 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.UNREACHABLE ->
            _menhir_run_363 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.TRY ->
            _menhir_run_365 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.THROW ->
            _menhir_run_366 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.RETURN ->
            _menhir_run_369 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.REPEAT ->
            _menhir_run_373 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PRINTLN ->
            _menhir_run_374 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PRINT ->
            _menhir_run_377 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PRAGMA ->
            _menhir_run_380 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PASS ->
            _menhir_run_384 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.MINUS ->
            _menhir_run_386 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LPAR ->
            _menhir_run_387 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LET ->
            _menhir_run_408 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IF ->
            _menhir_run_420 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IDENTIFIER _v ->
            _menhir_run_423 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.FOR ->
            _menhir_run_443 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.DEBUG ->
            _menhir_run_453 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.CONSTANT ->
            _menhir_run_458 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.CASE ->
            _menhir_run_469 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.ASSERT ->
            _menhir_run_477 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | _ ->
            _eRR 672
    
    and _menhir_run_644 : type  ttv_stack. (((ttv_stack, _menhir_box_spec) _menhir_cell1_READONLY _menhir_cell0_IMPLEMENTATION _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_spec) _menhir_state -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
        let _menhir_stack = MenhirCell1_func_args (_menhir_stack, _menhir_s, _v) in
        match (_tok : MenhirBasics.token) with
        | Tokens.RECURSELIMIT ->
            _menhir_run_645 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState644
        | Tokens.ARROW ->
            _menhir_run_647 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState644
        | Tokens.BEGIN ->
            let _v_0 = _menhir_action_260 () in
            _menhir_run_655 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState644
        | _ ->
            _eRR 644
    
    and _menhir_run_655 : type  ttv_stack. ((((ttv_stack, _menhir_box_spec) _menhir_cell1_READONLY _menhir_cell0_IMPLEMENTATION _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_spec) _menhir_state -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
        let _menhir_stack = MenhirCell1_recurse_limit (_menhir_stack, _menhir_s, _v) in
        let _menhir_s = MenhirState656 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.WHILE ->
            _menhir_run_001 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.VAR ->
            _menhir_run_318 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.UNREACHABLE ->
            _menhir_run_363 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.TRY ->
            _menhir_run_365 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.THROW ->
            _menhir_run_366 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.RETURN ->
            _menhir_run_369 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.REPEAT ->
            _menhir_run_373 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PRINTLN ->
            _menhir_run_374 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PRINT ->
            _menhir_run_377 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PRAGMA ->
            _menhir_run_380 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PASS ->
            _menhir_run_384 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.MINUS ->
            _menhir_run_386 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LPAR ->
            _menhir_run_387 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LET ->
            _menhir_run_408 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IF ->
            _menhir_run_420 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IDENTIFIER _v ->
            _menhir_run_423 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.FOR ->
            _menhir_run_443 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.DEBUG ->
            _menhir_run_453 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.CONSTANT ->
            _menhir_run_458 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.CASE ->
            _menhir_run_469 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.ASSERT ->
            _menhir_run_477 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | _ ->
            _eRR 656
    
    and _menhir_run_860 : type  ttv_stack. ((ttv_stack, _menhir_box_spec) _menhir_cell1_FUNC _menhir_cell0_IDENTIFIER as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_spec) _menhir_state -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
        let _menhir_stack = MenhirCell1_params_opt (_menhir_stack, _menhir_s, _v) in
        match (_tok : MenhirBasics.token) with
        | Tokens.LPAR ->
            _menhir_run_637 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState860
        | _ ->
            _eRR 860
    
    and _menhir_run_849 : type  ttv_stack. ((ttv_stack, _menhir_box_spec) _menhir_cell1_IMPDEF _menhir_cell0_IDENTIFIER as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_spec) _menhir_state -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
        let _menhir_stack = MenhirCell1_params_opt (_menhir_stack, _menhir_s, _v) in
        match (_tok : MenhirBasics.token) with
        | Tokens.LPAR ->
            _menhir_run_637 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState849
        | _ ->
            _eRR 849
    
    and _menhir_run_834 : type  ttv_stack. ((ttv_stack, _menhir_box_spec) _menhir_cell1_IMPDEF _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_spec) _menhir_state -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
        let _menhir_stack = MenhirCell1_params_opt (_menhir_stack, _menhir_s, _v) in
        match (_tok : MenhirBasics.token) with
        | Tokens.LPAR ->
            _menhir_run_637 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState834
        | _ ->
            _eRR 834
    
    and _menhir_run_803 : type  ttv_stack. ((ttv_stack, _menhir_box_spec) _menhir_cell1_IMPLEMENTATION _menhir_cell0_IDENTIFIER as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_spec) _menhir_state -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
        let _menhir_stack = MenhirCell1_params_opt (_menhir_stack, _menhir_s, _v) in
        match (_tok : MenhirBasics.token) with
        | Tokens.LPAR ->
            _menhir_run_637 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState803
        | _ ->
            _eRR 803
    
    and _menhir_run_788 : type  ttv_stack. ((ttv_stack, _menhir_box_spec) _menhir_cell1_IMPLEMENTATION _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_spec) _menhir_state -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
        let _menhir_stack = MenhirCell1_params_opt (_menhir_stack, _menhir_s, _v) in
        match (_tok : MenhirBasics.token) with
        | Tokens.LPAR ->
            _menhir_run_637 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState788
        | _ ->
            _eRR 788
    
    and _menhir_run_766 : type  ttv_stack. ((ttv_stack, _menhir_box_spec) _menhir_cell1_NORETURN _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_spec) _menhir_state -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
        let _menhir_stack = MenhirCell1_params_opt (_menhir_stack, _menhir_s, _v) in
        match (_tok : MenhirBasics.token) with
        | Tokens.LPAR ->
            _menhir_run_637 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState766
        | _ ->
            _eRR 766
    
    and _menhir_run_757 : type  ttv_stack. ((ttv_stack, _menhir_box_spec) _menhir_cell1_NORETURN _menhir_cell0_IMPDEF _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_spec) _menhir_state -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
        let _menhir_stack = MenhirCell1_params_opt (_menhir_stack, _menhir_s, _v) in
        match (_tok : MenhirBasics.token) with
        | Tokens.LPAR ->
            _menhir_run_637 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState757
        | _ ->
            _eRR 757
    
    and _menhir_run_747 : type  ttv_stack. ((ttv_stack, _menhir_box_spec) _menhir_cell1_NORETURN _menhir_cell0_IMPLEMENTATION _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_spec) _menhir_state -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
        let _menhir_stack = MenhirCell1_params_opt (_menhir_stack, _menhir_s, _v) in
        match (_tok : MenhirBasics.token) with
        | Tokens.LPAR ->
            _menhir_run_637 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState747
        | _ ->
            _eRR 747
    
    and _menhir_run_726 : type  ttv_stack. ((ttv_stack, _menhir_box_spec) _menhir_cell1_PURE _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_spec) _menhir_state -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
        let _menhir_stack = MenhirCell1_params_opt (_menhir_stack, _menhir_s, _v) in
        match (_tok : MenhirBasics.token) with
        | Tokens.LPAR ->
            _menhir_run_637 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState726
        | _ ->
            _eRR 726
    
    and _menhir_run_711 : type  ttv_stack. ((ttv_stack, _menhir_box_spec) _menhir_cell1_PURE _menhir_cell0_IMPDEF _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_spec) _menhir_state -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
        let _menhir_stack = MenhirCell1_params_opt (_menhir_stack, _menhir_s, _v) in
        match (_tok : MenhirBasics.token) with
        | Tokens.LPAR ->
            _menhir_run_637 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState711
        | _ ->
            _eRR 711
    
    and _menhir_run_695 : type  ttv_stack. ((ttv_stack, _menhir_box_spec) _menhir_cell1_PURE _menhir_cell0_IMPLEMENTATION _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_spec) _menhir_state -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
        let _menhir_stack = MenhirCell1_params_opt (_menhir_stack, _menhir_s, _v) in
        match (_tok : MenhirBasics.token) with
        | Tokens.LPAR ->
            _menhir_run_637 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState695
        | _ ->
            _eRR 695
    
    and _menhir_run_678 : type  ttv_stack. ((ttv_stack, _menhir_box_spec) _menhir_cell1_READONLY _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_spec) _menhir_state -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
        let _menhir_stack = MenhirCell1_params_opt (_menhir_stack, _menhir_s, _v) in
        match (_tok : MenhirBasics.token) with
        | Tokens.LPAR ->
            _menhir_run_637 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState678
        | _ ->
            _eRR 678
    
    and _menhir_run_663 : type  ttv_stack. ((ttv_stack, _menhir_box_spec) _menhir_cell1_READONLY _menhir_cell0_IMPDEF _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_spec) _menhir_state -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
        let _menhir_stack = MenhirCell1_params_opt (_menhir_stack, _menhir_s, _v) in
        match (_tok : MenhirBasics.token) with
        | Tokens.LPAR ->
            _menhir_run_637 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState663
        | _ ->
            _eRR 663
    
    and _menhir_run_636 : type  ttv_stack. ((ttv_stack, _menhir_box_spec) _menhir_cell1_READONLY _menhir_cell0_IMPLEMENTATION _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_spec) _menhir_state -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
        let _menhir_stack = MenhirCell1_params_opt (_menhir_stack, _menhir_s, _v) in
        match (_tok : MenhirBasics.token) with
        | Tokens.LPAR ->
            _menhir_run_637 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState636
        | _ ->
            _eRR 636
    
    and _menhir_run_633 : type  ttv_stack. (ttv_stack, _menhir_box_spec) _menhir_cell1_opt_typed_identifier -> _ -> _ -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v ->
        let MenhirCell1_opt_typed_identifier (_menhir_stack, _menhir_s, h) = _menhir_stack in
        let (_2, t) = ((), _v) in
        let _v = _menhir_action_045 _2 h t in
        _menhir_goto_clist1_opt_typed_identifier_ _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
    
    and _menhir_run_691 : type  ttv_stack. ttv_stack -> _ -> _ -> (ttv_stack, _menhir_box_spec) _menhir_state -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _menhir_stack = MenhirCell1_PURE (_menhir_stack, _menhir_s, _startpos) in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.IMPLEMENTATION ->
            let _startpos_0 = _menhir_lexbuf.Lexing.lex_start_p in
            let _menhir_stack = MenhirCell0_IMPLEMENTATION (_menhir_stack, _startpos_0) in
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.FUNC ->
                let _startpos_1 = _menhir_lexbuf.Lexing.lex_start_p in
                let _menhir_stack = MenhirCell0_FUNC (_menhir_stack, _startpos_1) in
                let _tok = _menhir_lexer _menhir_lexbuf in
                (match (_tok : MenhirBasics.token) with
                | Tokens.IDENTIFIER _v ->
                    let _startpos_2 = _menhir_lexbuf.Lexing.lex_start_p in
                    let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
                    let _menhir_stack = MenhirCell0_IDENTIFIER (_menhir_stack, _v, _startpos_2, _endpos) in
                    let _tok = _menhir_lexer _menhir_lexbuf in
                    (match (_tok : MenhirBasics.token) with
                    | Tokens.LBRACE ->
                        _menhir_run_628 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState694
                    | Tokens.LPAR ->
                        let _v_3 = _menhir_action_247 () in
                        _menhir_run_695 _menhir_stack _menhir_lexbuf _menhir_lexer _v_3 MenhirState694 _tok
                    | _ ->
                        _eRR 694)
                | _ ->
                    _eRR 693)
            | _ ->
                _eRR 692)
        | Tokens.IMPDEF ->
            let _startpos_4 = _menhir_lexbuf.Lexing.lex_start_p in
            let _menhir_stack = MenhirCell0_IMPDEF (_menhir_stack, _startpos_4) in
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.FUNC ->
                let _startpos_5 = _menhir_lexbuf.Lexing.lex_start_p in
                let _menhir_stack = MenhirCell0_FUNC (_menhir_stack, _startpos_5) in
                let _tok = _menhir_lexer _menhir_lexbuf in
                (match (_tok : MenhirBasics.token) with
                | Tokens.IDENTIFIER _v ->
                    let _startpos_6 = _menhir_lexbuf.Lexing.lex_start_p in
                    let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
                    let _menhir_stack = MenhirCell0_IDENTIFIER (_menhir_stack, _v, _startpos_6, _endpos) in
                    let _tok = _menhir_lexer _menhir_lexbuf in
                    (match (_tok : MenhirBasics.token) with
                    | Tokens.LBRACE ->
                        _menhir_run_628 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState710
                    | Tokens.LPAR ->
                        let _v_7 = _menhir_action_247 () in
                        _menhir_run_711 _menhir_stack _menhir_lexbuf _menhir_lexer _v_7 MenhirState710 _tok
                    | _ ->
                        _eRR 710)
                | _ ->
                    _eRR 709)
            | _ ->
                _eRR 708)
        | Tokens.FUNC ->
            let _startpos_8 = _menhir_lexbuf.Lexing.lex_start_p in
            let _menhir_stack = MenhirCell0_FUNC (_menhir_stack, _startpos_8) in
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.IDENTIFIER _v ->
                let _startpos_9 = _menhir_lexbuf.Lexing.lex_start_p in
                let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
                let _menhir_stack = MenhirCell0_IDENTIFIER (_menhir_stack, _v, _startpos_9, _endpos) in
                let _tok = _menhir_lexer _menhir_lexbuf in
                (match (_tok : MenhirBasics.token) with
                | Tokens.LBRACE ->
                    _menhir_run_628 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState725
                | Tokens.LPAR ->
                    let _v_10 = _menhir_action_247 () in
                    _menhir_run_726 _menhir_stack _menhir_lexbuf _menhir_lexer _v_10 MenhirState725 _tok
                | _ ->
                    _eRR 725)
            | _ ->
                _eRR 724)
        | _ ->
            _eRR 691
    
    and _menhir_run_739 : type  ttv_stack. ttv_stack -> _ -> _ -> (ttv_stack, _menhir_box_spec) _menhir_state -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _menhir_stack = MenhirCell1_PRAGMA (_menhir_stack, _menhir_s, _startpos) in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.IDENTIFIER _v ->
            let _startpos_0 = _menhir_lexbuf.Lexing.lex_start_p in
            let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
            let _menhir_stack = MenhirCell0_IDENTIFIER (_menhir_stack, _v, _startpos_0, _endpos) in
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.STRING_LIT _v_1 ->
                _menhir_run_002 _menhir_stack _menhir_lexbuf _menhir_lexer _v_1 MenhirState740
            | Tokens.REAL_LIT _v_2 ->
                _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v_2 MenhirState740
            | Tokens.NOT ->
                _menhir_run_004 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState740
            | Tokens.MINUS ->
                _menhir_run_005 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState740
            | Tokens.LPAR ->
                _menhir_run_006 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState740
            | Tokens.INT_LIT _v_3 ->
                _menhir_run_007 _menhir_stack _menhir_lexbuf _menhir_lexer _v_3 MenhirState740
            | Tokens.IF ->
                _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState740
            | Tokens.IDENTIFIER _v_4 ->
                _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v_4 MenhirState740
            | Tokens.BOOL_LIT _v_5 ->
                _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer _v_5 MenhirState740
            | Tokens.BNOT ->
                _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState740
            | Tokens.BITVECTOR_LIT _v_6 ->
                _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _v_6 MenhirState740
            | Tokens.ARBITRARY ->
                _menhir_run_014 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState740
            | Tokens.SEMI_COLON ->
                let _v_7 = _menhir_action_024 () in
                _menhir_run_741 _menhir_stack _menhir_lexbuf _menhir_lexer _v_7 _tok
            | _ ->
                _eRR 740)
        | _ ->
            _eRR 739
    
    and _menhir_run_741 : type  ttv_stack. (ttv_stack, _menhir_box_spec) _menhir_cell1_PRAGMA _menhir_cell0_IDENTIFIER -> _ -> _ -> _ -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
        match (_tok : MenhirBasics.token) with
        | Tokens.SEMI_COLON ->
            let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
            let _tok = _menhir_lexer _menhir_lexbuf in
            let MenhirCell0_IDENTIFIER (_menhir_stack, x, _, _) = _menhir_stack in
            let MenhirCell1_PRAGMA (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
            let (_1, _endpos__2_, e) = ((), _endpos, _v) in
            let _v = _menhir_action_102 _1 _endpos__2_ _startpos__1_ e x in
            _menhir_goto_decl _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
        | _ ->
            _eRR 741
    
    and _menhir_run_743 : type  ttv_stack. ttv_stack -> _ -> _ -> (ttv_stack, _menhir_box_spec) _menhir_state -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _menhir_stack = MenhirCell1_NORETURN (_menhir_stack, _menhir_s, _startpos) in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.IMPLEMENTATION ->
            let _startpos_0 = _menhir_lexbuf.Lexing.lex_start_p in
            let _menhir_stack = MenhirCell0_IMPLEMENTATION (_menhir_stack, _startpos_0) in
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.FUNC ->
                let _startpos_1 = _menhir_lexbuf.Lexing.lex_start_p in
                let _menhir_stack = MenhirCell0_FUNC (_menhir_stack, _startpos_1) in
                let _tok = _menhir_lexer _menhir_lexbuf in
                (match (_tok : MenhirBasics.token) with
                | Tokens.IDENTIFIER _v ->
                    let _startpos_2 = _menhir_lexbuf.Lexing.lex_start_p in
                    let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
                    let _menhir_stack = MenhirCell0_IDENTIFIER (_menhir_stack, _v, _startpos_2, _endpos) in
                    let _tok = _menhir_lexer _menhir_lexbuf in
                    (match (_tok : MenhirBasics.token) with
                    | Tokens.LBRACE ->
                        _menhir_run_628 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState746
                    | Tokens.LPAR ->
                        let _v_3 = _menhir_action_247 () in
                        _menhir_run_747 _menhir_stack _menhir_lexbuf _menhir_lexer _v_3 MenhirState746 _tok
                    | _ ->
                        _eRR 746)
                | _ ->
                    _eRR 745)
            | _ ->
                _eRR 744)
        | Tokens.IMPDEF ->
            let _startpos_4 = _menhir_lexbuf.Lexing.lex_start_p in
            let _menhir_stack = MenhirCell0_IMPDEF (_menhir_stack, _startpos_4) in
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.FUNC ->
                let _startpos_5 = _menhir_lexbuf.Lexing.lex_start_p in
                let _menhir_stack = MenhirCell0_FUNC (_menhir_stack, _startpos_5) in
                let _tok = _menhir_lexer _menhir_lexbuf in
                (match (_tok : MenhirBasics.token) with
                | Tokens.IDENTIFIER _v ->
                    let _startpos_6 = _menhir_lexbuf.Lexing.lex_start_p in
                    let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
                    let _menhir_stack = MenhirCell0_IDENTIFIER (_menhir_stack, _v, _startpos_6, _endpos) in
                    let _tok = _menhir_lexer _menhir_lexbuf in
                    (match (_tok : MenhirBasics.token) with
                    | Tokens.LBRACE ->
                        _menhir_run_628 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState756
                    | Tokens.LPAR ->
                        let _v_7 = _menhir_action_247 () in
                        _menhir_run_757 _menhir_stack _menhir_lexbuf _menhir_lexer _v_7 MenhirState756 _tok
                    | _ ->
                        _eRR 756)
                | _ ->
                    _eRR 755)
            | _ ->
                _eRR 754)
        | Tokens.FUNC ->
            let _startpos_8 = _menhir_lexbuf.Lexing.lex_start_p in
            let _menhir_stack = MenhirCell0_FUNC (_menhir_stack, _startpos_8) in
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.IDENTIFIER _v ->
                let _startpos_9 = _menhir_lexbuf.Lexing.lex_start_p in
                let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
                let _menhir_stack = MenhirCell0_IDENTIFIER (_menhir_stack, _v, _startpos_9, _endpos) in
                let _tok = _menhir_lexer _menhir_lexbuf in
                (match (_tok : MenhirBasics.token) with
                | Tokens.LBRACE ->
                    _menhir_run_628 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState765
                | Tokens.LPAR ->
                    let _v_10 = _menhir_action_247 () in
                    _menhir_run_766 _menhir_stack _menhir_lexbuf _menhir_lexer _v_10 MenhirState765 _tok
                | _ ->
                    _eRR 765)
            | _ ->
                _eRR 764)
        | _ ->
            _eRR 743
    
    and _menhir_run_773 : type  ttv_stack. ttv_stack -> _ -> _ -> (ttv_stack, _menhir_box_spec) _menhir_state -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _menhir_stack = MenhirCell1_LET (_menhir_stack, _menhir_s, _startpos) in
        let _menhir_s = MenhirState773 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.MINUS ->
            _menhir_run_568 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IDENTIFIER _v ->
            _menhir_run_774 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | _ ->
            _eRR 773
    
    and _menhir_run_774 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> (ttv_stack, _menhir_box_spec) _menhir_state -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
        let _tok = _menhir_lexer _menhir_lexbuf in
        let _1 = _v in
        let _v = _menhir_action_220 _1 in
        _menhir_goto_ignored_or_identifier _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
    
    and _menhir_run_785 : type  ttv_stack. ttv_stack -> _ -> _ -> (ttv_stack, _menhir_box_spec) _menhir_state -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _menhir_stack = MenhirCell1_IMPLEMENTATION (_menhir_stack, _menhir_s, _startpos) in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.FUNC ->
            let _startpos_0 = _menhir_lexbuf.Lexing.lex_start_p in
            let _menhir_stack = MenhirCell0_FUNC (_menhir_stack, _startpos_0) in
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.IDENTIFIER _v ->
                let _startpos_1 = _menhir_lexbuf.Lexing.lex_start_p in
                let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
                let _menhir_stack = MenhirCell0_IDENTIFIER (_menhir_stack, _v, _startpos_1, _endpos) in
                let _tok = _menhir_lexer _menhir_lexbuf in
                (match (_tok : MenhirBasics.token) with
                | Tokens.LBRACE ->
                    _menhir_run_628 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState787
                | Tokens.LPAR ->
                    let _v_2 = _menhir_action_247 () in
                    _menhir_run_788 _menhir_stack _menhir_lexbuf _menhir_lexer _v_2 MenhirState787 _tok
                | _ ->
                    _eRR 787)
            | _ ->
                _eRR 786)
        | Tokens.ACCESSOR ->
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.IDENTIFIER _v ->
                let _startpos_3 = _menhir_lexbuf.Lexing.lex_start_p in
                let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
                let _menhir_stack = MenhirCell0_IDENTIFIER (_menhir_stack, _v, _startpos_3, _endpos) in
                let _tok = _menhir_lexer _menhir_lexbuf in
                (match (_tok : MenhirBasics.token) with
                | Tokens.LBRACE ->
                    _menhir_run_628 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState802
                | Tokens.LPAR ->
                    let _v_4 = _menhir_action_247 () in
                    _menhir_run_803 _menhir_stack _menhir_lexbuf _menhir_lexer _v_4 MenhirState802 _tok
                | _ ->
                    _eRR 802)
            | _ ->
                _eRR 801)
        | _ ->
            _eRR 785
    
    and _menhir_run_831 : type  ttv_stack. ttv_stack -> _ -> _ -> (ttv_stack, _menhir_box_spec) _menhir_state -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _menhir_stack = MenhirCell1_IMPDEF (_menhir_stack, _menhir_s, _startpos) in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.FUNC ->
            let _startpos_0 = _menhir_lexbuf.Lexing.lex_start_p in
            let _menhir_stack = MenhirCell0_FUNC (_menhir_stack, _startpos_0) in
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.IDENTIFIER _v ->
                let _startpos_1 = _menhir_lexbuf.Lexing.lex_start_p in
                let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
                let _menhir_stack = MenhirCell0_IDENTIFIER (_menhir_stack, _v, _startpos_1, _endpos) in
                let _tok = _menhir_lexer _menhir_lexbuf in
                (match (_tok : MenhirBasics.token) with
                | Tokens.LBRACE ->
                    _menhir_run_628 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState833
                | Tokens.LPAR ->
                    let _v_2 = _menhir_action_247 () in
                    _menhir_run_834 _menhir_stack _menhir_lexbuf _menhir_lexer _v_2 MenhirState833 _tok
                | _ ->
                    _eRR 833)
            | _ ->
                _eRR 832)
        | Tokens.ACCESSOR ->
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.IDENTIFIER _v ->
                let _startpos_3 = _menhir_lexbuf.Lexing.lex_start_p in
                let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
                let _menhir_stack = MenhirCell0_IDENTIFIER (_menhir_stack, _v, _startpos_3, _endpos) in
                let _tok = _menhir_lexer _menhir_lexbuf in
                (match (_tok : MenhirBasics.token) with
                | Tokens.LBRACE ->
                    _menhir_run_628 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState848
                | Tokens.LPAR ->
                    let _v_4 = _menhir_action_247 () in
                    _menhir_run_849 _menhir_stack _menhir_lexbuf _menhir_lexer _v_4 MenhirState848 _tok
                | _ ->
                    _eRR 848)
            | _ ->
                _eRR 847)
        | _ ->
            _eRR 831
    
    and _menhir_run_858 : type  ttv_stack. ttv_stack -> _ -> _ -> (ttv_stack, _menhir_box_spec) _menhir_state -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _menhir_stack = MenhirCell1_FUNC (_menhir_stack, _menhir_s, _startpos) in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.IDENTIFIER _v ->
            let _startpos_0 = _menhir_lexbuf.Lexing.lex_start_p in
            let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
            let _menhir_stack = MenhirCell0_IDENTIFIER (_menhir_stack, _v, _startpos_0, _endpos) in
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.LBRACE ->
                _menhir_run_628 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState859
            | Tokens.LPAR ->
                let _v_1 = _menhir_action_247 () in
                _menhir_run_860 _menhir_stack _menhir_lexbuf _menhir_lexer _v_1 MenhirState859 _tok
            | _ ->
                _eRR 859)
        | _ ->
            _eRR 858
    
    and _menhir_run_873 : type  ttv_stack. ttv_stack -> _ -> _ -> (ttv_stack, _menhir_box_spec) _menhir_state -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
        let _menhir_stack = MenhirCell1_CONSTANT (_menhir_stack, _menhir_s, _startpos, _endpos) in
        let _menhir_s = MenhirState873 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.MINUS ->
            _menhir_run_568 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IDENTIFIER _v ->
            _menhir_run_774 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | _ ->
            _eRR 873
    
    and _menhir_run_884 : type  ttv_stack. ttv_stack -> _ -> _ -> (ttv_stack, _menhir_box_spec) _menhir_state -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _menhir_stack = MenhirCell1_CONFIG (_menhir_stack, _menhir_s, _startpos) in
        let _menhir_s = MenhirState884 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.MINUS ->
            _menhir_run_568 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IDENTIFIER _v ->
            _menhir_run_774 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | _ ->
            _eRR 884
    
    and _menhir_run_892 : type  ttv_stack. ttv_stack -> _ -> _ -> (ttv_stack, _menhir_box_spec) _menhir_state -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _menhir_stack = MenhirCell1_ACCESSOR (_menhir_stack, _menhir_s) in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.IDENTIFIER _v ->
            let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
            let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
            let _menhir_stack = MenhirCell0_IDENTIFIER (_menhir_stack, _v, _startpos, _endpos) in
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.LBRACE ->
                _menhir_run_628 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState893
            | Tokens.LPAR ->
                let _v_0 = _menhir_action_247 () in
                _menhir_run_894 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState893 _tok
            | _ ->
                _eRR 893)
        | _ ->
            _eRR 892
    
    and _menhir_run_059 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_expr as 'stack) -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _menhir_stack = MenhirCell1_RDIV (_menhir_stack, _menhir_s) in
        let _menhir_s = MenhirState059 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.STRING_LIT _v ->
            _menhir_run_002 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.REAL_LIT _v ->
            _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.NOT ->
            _menhir_run_004 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.MINUS ->
            _menhir_run_005 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LPAR ->
            _menhir_run_006 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.INT_LIT _v ->
            _menhir_run_007 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.IF ->
            _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IDENTIFIER _v ->
            _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BOOL_LIT _v ->
            _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BNOT ->
            _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.BITVECTOR_LIT _v ->
            _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.ARBITRARY ->
            _menhir_run_014 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | _ ->
            _eRR 59
    
    and _menhir_run_032 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_expr as 'stack) -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _menhir_stack = MenhirCell1_POW (_menhir_stack, _menhir_s) in
        let _menhir_s = MenhirState032 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.STRING_LIT _v ->
            _menhir_run_002 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.REAL_LIT _v ->
            _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.NOT ->
            _menhir_run_004 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.MINUS ->
            _menhir_run_005 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LPAR ->
            _menhir_run_006 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.INT_LIT _v ->
            _menhir_run_007 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.IF ->
            _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IDENTIFIER _v ->
            _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BOOL_LIT _v ->
            _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BNOT ->
            _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.BITVECTOR_LIT _v ->
            _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.ARBITRARY ->
            _menhir_run_014 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | _ ->
            _eRR 32
    
    and _menhir_run_061 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_expr as 'stack) -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _menhir_stack = MenhirCell1_PLUS_PLUS (_menhir_stack, _menhir_s) in
        let _menhir_s = MenhirState061 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.STRING_LIT _v ->
            _menhir_run_002 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.REAL_LIT _v ->
            _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.NOT ->
            _menhir_run_004 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.MINUS ->
            _menhir_run_005 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LPAR ->
            _menhir_run_006 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.INT_LIT _v ->
            _menhir_run_007 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.IF ->
            _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IDENTIFIER _v ->
            _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BOOL_LIT _v ->
            _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BNOT ->
            _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.BITVECTOR_LIT _v ->
            _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.ARBITRARY ->
            _menhir_run_014 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | _ ->
            _eRR 61
    
    and _menhir_run_071 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_expr as 'stack) -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _menhir_stack = MenhirCell1_PLUS (_menhir_stack, _menhir_s) in
        let _menhir_s = MenhirState071 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.STRING_LIT _v ->
            _menhir_run_002 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.REAL_LIT _v ->
            _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.NOT ->
            _menhir_run_004 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.MINUS ->
            _menhir_run_005 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LPAR ->
            _menhir_run_006 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.INT_LIT _v ->
            _menhir_run_007 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.IF ->
            _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IDENTIFIER _v ->
            _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BOOL_LIT _v ->
            _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BNOT ->
            _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.BITVECTOR_LIT _v ->
            _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.ARBITRARY ->
            _menhir_run_014 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | _ ->
            _eRR 71
    
    and _menhir_run_073 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_expr as 'stack) -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _menhir_stack = MenhirCell1_OR (_menhir_stack, _menhir_s) in
        let _menhir_s = MenhirState073 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.STRING_LIT _v ->
            _menhir_run_002 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.REAL_LIT _v ->
            _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.NOT ->
            _menhir_run_004 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.MINUS ->
            _menhir_run_005 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LPAR ->
            _menhir_run_006 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.INT_LIT _v ->
            _menhir_run_007 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.IF ->
            _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IDENTIFIER _v ->
            _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BOOL_LIT _v ->
            _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BNOT ->
            _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.BITVECTOR_LIT _v ->
            _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.ARBITRARY ->
            _menhir_run_014 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | _ ->
            _eRR 73
    
    and _menhir_run_075 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_expr as 'stack) -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.STRING_LIT _v ->
            let _menhir_stack = MenhirCell1_NE (_menhir_stack, _menhir_s) in
            _menhir_run_002 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState075
        | Tokens.REAL_LIT _v ->
            let _menhir_stack = MenhirCell1_NE (_menhir_stack, _menhir_s) in
            _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState075
        | Tokens.NOT ->
            let _menhir_stack = MenhirCell1_NE (_menhir_stack, _menhir_s) in
            _menhir_run_004 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState075
        | Tokens.MINUS ->
            let _menhir_stack = MenhirCell1_NE (_menhir_stack, _menhir_s) in
            _menhir_run_005 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState075
        | Tokens.MASK_LIT _v ->
            let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
            let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
            let _tok = _menhir_lexer _menhir_lexbuf in
            let MenhirCell1_expr (_menhir_stack, _menhir_s, e, _startpos_e_, _) = _menhir_stack in
            let (_endpos__1_, _startpos__1_, _1, _2) = (_endpos, _startpos, _v, ()) in
            let _v = _menhir_action_164 _1 _2 _endpos__1_ _startpos__1_ _startpos_e_ e in
            _menhir_goto_expr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__1_ _startpos_e_ _v _menhir_s _tok
        | Tokens.LPAR ->
            let _menhir_stack = MenhirCell1_NE (_menhir_stack, _menhir_s) in
            _menhir_run_006 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState075
        | Tokens.INT_LIT _v ->
            let _menhir_stack = MenhirCell1_NE (_menhir_stack, _menhir_s) in
            _menhir_run_007 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState075
        | Tokens.IF ->
            let _menhir_stack = MenhirCell1_NE (_menhir_stack, _menhir_s) in
            _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState075
        | Tokens.IDENTIFIER _v ->
            let _menhir_stack = MenhirCell1_NE (_menhir_stack, _menhir_s) in
            _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState075
        | Tokens.BOOL_LIT _v ->
            let _menhir_stack = MenhirCell1_NE (_menhir_stack, _menhir_s) in
            _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState075
        | Tokens.BNOT ->
            let _menhir_stack = MenhirCell1_NE (_menhir_stack, _menhir_s) in
            _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState075
        | Tokens.BITVECTOR_LIT _v ->
            let _menhir_stack = MenhirCell1_NE (_menhir_stack, _menhir_s) in
            _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState075
        | Tokens.ARBITRARY ->
            let _menhir_stack = MenhirCell1_NE (_menhir_stack, _menhir_s) in
            _menhir_run_014 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState075
        | _ ->
            _eRR 75
    
    and _menhir_run_063 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_expr as 'stack) -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _menhir_stack = MenhirCell1_MUL (_menhir_stack, _menhir_s) in
        let _menhir_s = MenhirState063 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.STRING_LIT _v ->
            _menhir_run_002 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.REAL_LIT _v ->
            _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.NOT ->
            _menhir_run_004 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.MINUS ->
            _menhir_run_005 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LPAR ->
            _menhir_run_006 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.INT_LIT _v ->
            _menhir_run_007 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.IF ->
            _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IDENTIFIER _v ->
            _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BOOL_LIT _v ->
            _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BNOT ->
            _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.BITVECTOR_LIT _v ->
            _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.ARBITRARY ->
            _menhir_run_014 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | _ ->
            _eRR 63
    
    and _menhir_run_065 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_expr as 'stack) -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _menhir_stack = MenhirCell1_MOD (_menhir_stack, _menhir_s) in
        let _menhir_s = MenhirState065 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.STRING_LIT _v ->
            _menhir_run_002 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.REAL_LIT _v ->
            _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.NOT ->
            _menhir_run_004 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.MINUS ->
            _menhir_run_005 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LPAR ->
            _menhir_run_006 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.INT_LIT _v ->
            _menhir_run_007 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.IF ->
            _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IDENTIFIER _v ->
            _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BOOL_LIT _v ->
            _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BNOT ->
            _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.BITVECTOR_LIT _v ->
            _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.ARBITRARY ->
            _menhir_run_014 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | _ ->
            _eRR 65
    
    and _menhir_run_078 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_expr as 'stack) -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
        let _menhir_stack = MenhirCell1_MINUS (_menhir_stack, _menhir_s, _startpos, _endpos) in
        let _menhir_s = MenhirState078 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.STRING_LIT _v ->
            _menhir_run_002 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.REAL_LIT _v ->
            _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.NOT ->
            _menhir_run_004 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.MINUS ->
            _menhir_run_005 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LPAR ->
            _menhir_run_006 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.INT_LIT _v ->
            _menhir_run_007 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.IF ->
            _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IDENTIFIER _v ->
            _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BOOL_LIT _v ->
            _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BNOT ->
            _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.BITVECTOR_LIT _v ->
            _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.ARBITRARY ->
            _menhir_run_014 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | _ ->
            _eRR 78
    
    and _menhir_run_080 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_expr as 'stack) -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _menhir_stack = MenhirCell1_LT (_menhir_stack, _menhir_s) in
        let _menhir_s = MenhirState080 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.STRING_LIT _v ->
            _menhir_run_002 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.REAL_LIT _v ->
            _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.NOT ->
            _menhir_run_004 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.MINUS ->
            _menhir_run_005 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LPAR ->
            _menhir_run_006 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.INT_LIT _v ->
            _menhir_run_007 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.IF ->
            _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IDENTIFIER _v ->
            _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BOOL_LIT _v ->
            _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BNOT ->
            _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.BITVECTOR_LIT _v ->
            _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.ARBITRARY ->
            _menhir_run_014 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | _ ->
            _eRR 80
    
    and _menhir_run_026 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_expr as 'stack) -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _menhir_stack = MenhirCell1_LLBRACKET (_menhir_stack, _menhir_s) in
        let _menhir_s = MenhirState026 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.STRING_LIT _v ->
            _menhir_run_002 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.REAL_LIT _v ->
            _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.NOT ->
            _menhir_run_004 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.MINUS ->
            _menhir_run_005 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LPAR ->
            _menhir_run_006 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.INT_LIT _v ->
            _menhir_run_007 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.IF ->
            _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IDENTIFIER _v ->
            _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BOOL_LIT _v ->
            _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BNOT ->
            _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.BITVECTOR_LIT _v ->
            _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.ARBITRARY ->
            _menhir_run_014 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | _ ->
            _eRR 26
    
    and _menhir_run_086 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_expr as 'stack) -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _menhir_stack = MenhirCell1_LE (_menhir_stack, _menhir_s, _startpos) in
        let _menhir_s = MenhirState086 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.STRING_LIT _v ->
            _menhir_run_002 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.REAL_LIT _v ->
            _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.NOT ->
            _menhir_run_004 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.MINUS ->
            _menhir_run_005 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LPAR ->
            _menhir_run_006 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.INT_LIT _v ->
            _menhir_run_007 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.IF ->
            _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IDENTIFIER _v ->
            _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BOOL_LIT _v ->
            _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BNOT ->
            _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.BITVECTOR_LIT _v ->
            _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.ARBITRARY ->
            _menhir_run_014 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | _ ->
            _eRR 86
    
    and _menhir_run_039 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_expr as 'stack) -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _menhir_stack = MenhirCell1_IN (_menhir_stack, _menhir_s) in
        let _menhir_s = MenhirState039 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.LBRACE ->
            _menhir_run_040 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.BNOT ->
            _menhir_run_218 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | _ ->
            _eRR 39
    
    and _menhir_run_218 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_IN as 'stack) -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _menhir_stack = MenhirCell1_BNOT (_menhir_stack, _menhir_s, _startpos) in
        let _menhir_s = MenhirState218 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.LBRACE ->
            _menhir_run_172 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | _ ->
            _eRR 218
    
    and _menhir_run_092 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_expr as 'stack) -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _menhir_stack = MenhirCell1_IMPL (_menhir_stack, _menhir_s) in
        let _menhir_s = MenhirState092 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.STRING_LIT _v ->
            _menhir_run_002 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.REAL_LIT _v ->
            _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.NOT ->
            _menhir_run_004 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.MINUS ->
            _menhir_run_005 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LPAR ->
            _menhir_run_006 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.INT_LIT _v ->
            _menhir_run_007 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.IF ->
            _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IDENTIFIER _v ->
            _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BOOL_LIT _v ->
            _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BNOT ->
            _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.BITVECTOR_LIT _v ->
            _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.ARBITRARY ->
            _menhir_run_014 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | _ ->
            _eRR 92
    
    and _menhir_run_088 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_expr as 'stack) -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _menhir_stack = MenhirCell1_GT (_menhir_stack, _menhir_s) in
        let _menhir_s = MenhirState088 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.STRING_LIT _v ->
            _menhir_run_002 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.REAL_LIT _v ->
            _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.NOT ->
            _menhir_run_004 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.MINUS ->
            _menhir_run_005 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LPAR ->
            _menhir_run_006 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.INT_LIT _v ->
            _menhir_run_007 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.IF ->
            _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IDENTIFIER _v ->
            _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BOOL_LIT _v ->
            _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BNOT ->
            _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.BITVECTOR_LIT _v ->
            _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.ARBITRARY ->
            _menhir_run_014 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | _ ->
            _eRR 88
    
    and _menhir_run_090 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_expr as 'stack) -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
        let _menhir_stack = MenhirCell1_GE (_menhir_stack, _menhir_s, _startpos) in
        let _menhir_s = MenhirState090 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.STRING_LIT _v ->
            _menhir_run_002 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.REAL_LIT _v ->
            _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.NOT ->
            _menhir_run_004 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.MINUS ->
            _menhir_run_005 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LPAR ->
            _menhir_run_006 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.INT_LIT _v ->
            _menhir_run_007 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.IF ->
            _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IDENTIFIER _v ->
            _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BOOL_LIT _v ->
            _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BNOT ->
            _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.BITVECTOR_LIT _v ->
            _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.ARBITRARY ->
            _menhir_run_014 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | _ ->
            _eRR 90
    
    and _menhir_run_094 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_expr as 'stack) -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.STRING_LIT _v ->
            let _menhir_stack = MenhirCell1_EQ_EQ (_menhir_stack, _menhir_s) in
            _menhir_run_002 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState094
        | Tokens.REAL_LIT _v ->
            let _menhir_stack = MenhirCell1_EQ_EQ (_menhir_stack, _menhir_s) in
            _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState094
        | Tokens.NOT ->
            let _menhir_stack = MenhirCell1_EQ_EQ (_menhir_stack, _menhir_s) in
            _menhir_run_004 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState094
        | Tokens.MINUS ->
            let _menhir_stack = MenhirCell1_EQ_EQ (_menhir_stack, _menhir_s) in
            _menhir_run_005 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState094
        | Tokens.MASK_LIT _v ->
            let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
            let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
            let _tok = _menhir_lexer _menhir_lexbuf in
            let MenhirCell1_expr (_menhir_stack, _menhir_s, expr, _startpos_expr_, _) = _menhir_stack in
            let (_endpos__1_, _startpos__1_, _1, _2) = (_endpos, _startpos, _v, ()) in
            let _v = _menhir_action_163 _1 _2 _endpos__1_ _startpos__1_ _startpos_expr_ expr in
            _menhir_goto_expr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__1_ _startpos_expr_ _v _menhir_s _tok
        | Tokens.LPAR ->
            let _menhir_stack = MenhirCell1_EQ_EQ (_menhir_stack, _menhir_s) in
            _menhir_run_006 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState094
        | Tokens.INT_LIT _v ->
            let _menhir_stack = MenhirCell1_EQ_EQ (_menhir_stack, _menhir_s) in
            _menhir_run_007 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState094
        | Tokens.IF ->
            let _menhir_stack = MenhirCell1_EQ_EQ (_menhir_stack, _menhir_s) in
            _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState094
        | Tokens.IDENTIFIER _v ->
            let _menhir_stack = MenhirCell1_EQ_EQ (_menhir_stack, _menhir_s) in
            _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState094
        | Tokens.BOOL_LIT _v ->
            let _menhir_stack = MenhirCell1_EQ_EQ (_menhir_stack, _menhir_s) in
            _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState094
        | Tokens.BNOT ->
            let _menhir_stack = MenhirCell1_EQ_EQ (_menhir_stack, _menhir_s) in
            _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState094
        | Tokens.BITVECTOR_LIT _v ->
            let _menhir_stack = MenhirCell1_EQ_EQ (_menhir_stack, _menhir_s) in
            _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState094
        | Tokens.ARBITRARY ->
            let _menhir_stack = MenhirCell1_EQ_EQ (_menhir_stack, _menhir_s) in
            _menhir_run_014 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState094
        | _ ->
            _eRR 94
    
    and _menhir_run_043 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_expr as 'stack) -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.LBRACKET ->
            let _menhir_stack = MenhirCell1_DOT (_menhir_stack, _menhir_s) in
            let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
            let _menhir_stack = MenhirCell0_LBRACKET (_menhir_stack, _startpos) in
            let _menhir_s = MenhirState044 in
            let _tok = _menhir_lexer _menhir_lexbuf in
            (match (_tok : MenhirBasics.token) with
            | Tokens.IDENTIFIER _v ->
                _menhir_run_045 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
            | _ ->
                _eRR 44)
        | Tokens.IDENTIFIER _v ->
            let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
            let _tok = _menhir_lexer _menhir_lexbuf in
            let MenhirCell1_expr (_menhir_stack, _menhir_s, e, _startpos_e_, _) = _menhir_stack in
            let (_2, _endpos_x_, x) = ((), _endpos, _v) in
            let _v = _menhir_action_158 _2 _endpos_x_ _startpos_e_ e x in
            _menhir_goto_expr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_x_ _startpos_e_ _v _menhir_s _tok
        | _ ->
            _eRR 43
    
    and _menhir_run_067 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_expr as 'stack) -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _menhir_stack = MenhirCell1_DIVRM (_menhir_stack, _menhir_s) in
        let _menhir_s = MenhirState067 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.STRING_LIT _v ->
            _menhir_run_002 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.REAL_LIT _v ->
            _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.NOT ->
            _menhir_run_004 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.MINUS ->
            _menhir_run_005 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LPAR ->
            _menhir_run_006 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.INT_LIT _v ->
            _menhir_run_007 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.IF ->
            _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IDENTIFIER _v ->
            _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BOOL_LIT _v ->
            _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BNOT ->
            _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.BITVECTOR_LIT _v ->
            _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.ARBITRARY ->
            _menhir_run_014 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | _ ->
            _eRR 67
    
    and _menhir_run_069 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_expr as 'stack) -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _menhir_stack = MenhirCell1_DIV (_menhir_stack, _menhir_s) in
        let _menhir_s = MenhirState069 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.STRING_LIT _v ->
            _menhir_run_002 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.REAL_LIT _v ->
            _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.NOT ->
            _menhir_run_004 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.MINUS ->
            _menhir_run_005 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LPAR ->
            _menhir_run_006 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.INT_LIT _v ->
            _menhir_run_007 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.IF ->
            _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IDENTIFIER _v ->
            _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BOOL_LIT _v ->
            _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BNOT ->
            _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.BITVECTOR_LIT _v ->
            _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.ARBITRARY ->
            _menhir_run_014 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | _ ->
            _eRR 69
    
    and _menhir_run_082 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_expr as 'stack) -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _menhir_stack = MenhirCell1_COLON_COLON (_menhir_stack, _menhir_s) in
        let _menhir_s = MenhirState082 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.STRING_LIT _v ->
            _menhir_run_002 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.REAL_LIT _v ->
            _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.NOT ->
            _menhir_run_004 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.MINUS ->
            _menhir_run_005 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LPAR ->
            _menhir_run_006 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.INT_LIT _v ->
            _menhir_run_007 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.IF ->
            _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IDENTIFIER _v ->
            _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BOOL_LIT _v ->
            _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BNOT ->
            _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.BITVECTOR_LIT _v ->
            _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.ARBITRARY ->
            _menhir_run_014 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | _ ->
            _eRR 82
    
    and _menhir_run_097 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_expr as 'stack) -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _menhir_stack = MenhirCell1_BOR (_menhir_stack, _menhir_s) in
        let _menhir_s = MenhirState097 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.STRING_LIT _v ->
            _menhir_run_002 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.REAL_LIT _v ->
            _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.NOT ->
            _menhir_run_004 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.MINUS ->
            _menhir_run_005 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LPAR ->
            _menhir_run_006 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.INT_LIT _v ->
            _menhir_run_007 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.IF ->
            _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IDENTIFIER _v ->
            _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BOOL_LIT _v ->
            _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BNOT ->
            _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.BITVECTOR_LIT _v ->
            _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.ARBITRARY ->
            _menhir_run_014 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | _ ->
            _eRR 97
    
    and _menhir_run_099 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_expr as 'stack) -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _menhir_stack = MenhirCell1_BEQ (_menhir_stack, _menhir_s) in
        let _menhir_s = MenhirState099 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.STRING_LIT _v ->
            _menhir_run_002 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.REAL_LIT _v ->
            _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.NOT ->
            _menhir_run_004 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.MINUS ->
            _menhir_run_005 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LPAR ->
            _menhir_run_006 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.INT_LIT _v ->
            _menhir_run_007 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.IF ->
            _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IDENTIFIER _v ->
            _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BOOL_LIT _v ->
            _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BNOT ->
            _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.BITVECTOR_LIT _v ->
            _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.ARBITRARY ->
            _menhir_run_014 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | _ ->
            _eRR 99
    
    and _menhir_run_101 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_expr as 'stack) -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _menhir_stack = MenhirCell1_BAND (_menhir_stack, _menhir_s) in
        let _menhir_s = MenhirState101 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.STRING_LIT _v ->
            _menhir_run_002 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.REAL_LIT _v ->
            _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.NOT ->
            _menhir_run_004 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.MINUS ->
            _menhir_run_005 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LPAR ->
            _menhir_run_006 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.INT_LIT _v ->
            _menhir_run_007 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.IF ->
            _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IDENTIFIER _v ->
            _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BOOL_LIT _v ->
            _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BNOT ->
            _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.BITVECTOR_LIT _v ->
            _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.ARBITRARY ->
            _menhir_run_014 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | _ ->
            _eRR 101
    
    and _menhir_run_103 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_expr as 'stack) -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _menhir_stack = MenhirCell1_AS (_menhir_stack, _menhir_s) in
        let _menhir_s = MenhirState103 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.STRING ->
            _menhir_run_016 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.REAL ->
            _menhir_run_017 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LPAR ->
            _menhir_run_018 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LBRACE ->
            _menhir_run_020 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.INTEGER ->
            _menhir_run_019 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IDENTIFIER _v ->
            _menhir_run_104 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BOOLEAN ->
            _menhir_run_105 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.BITS ->
            _menhir_run_106 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.BIT ->
            _menhir_run_117 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.ARRAY ->
            _menhir_run_118 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | _ ->
            _eRR 103
    
    and _menhir_run_084 : type  ttv_stack ttv_result. ((ttv_stack, ttv_result) _menhir_cell1_expr as 'stack) -> _ -> _ -> ('stack, ttv_result) _menhir_state -> ttv_result =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
        let _menhir_stack = MenhirCell1_AND (_menhir_stack, _menhir_s) in
        let _menhir_s = MenhirState084 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.STRING_LIT _v ->
            _menhir_run_002 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.REAL_LIT _v ->
            _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.NOT ->
            _menhir_run_004 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.MINUS ->
            _menhir_run_005 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LPAR ->
            _menhir_run_006 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.INT_LIT _v ->
            _menhir_run_007 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.IF ->
            _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IDENTIFIER _v ->
            _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BOOL_LIT _v ->
            _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.BNOT ->
            _menhir_run_012 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.BITVECTOR_LIT _v ->
            _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.ARBITRARY ->
            _menhir_run_014 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | _ ->
            _eRR 84
    
    and _menhir_run_880 : type  ttv_stack. ((((ttv_stack, _menhir_box_spec) _menhir_cell1_CONSTANT, _menhir_box_spec) _menhir_cell1_ignored_or_identifier, _menhir_box_spec) _menhir_cell1_as_ty as 'stack) -> _ -> _ -> _ -> _ -> _ -> ('stack, _menhir_box_spec) _menhir_state -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
        match (_tok : MenhirBasics.token) with
        | Tokens.XOR ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_028 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState880
        | Tokens.SHR ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_030 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState880
        | Tokens.SHL ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_037 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState880
        | Tokens.SEMI_COLON ->
            let _endpos_0 = _menhir_lexbuf.Lexing.lex_curr_p in
            let _tok = _menhir_lexer _menhir_lexbuf in
            let MenhirCell1_as_ty (_menhir_stack, _, x) = _menhir_stack in
            let MenhirCell1_ignored_or_identifier (_menhir_stack, _, name) = _menhir_stack in
            let MenhirCell1_CONSTANT (_menhir_stack, _menhir_s, _startpos__1_, _) = _menhir_stack in
            let (_1, _endpos__2_, _4, x_inlined1) = ((), _endpos_0, (), _v) in
            let _v = _menhir_action_093 _1 _4 _endpos__2_ _startpos__1_ name x x_inlined1 in
            _menhir_goto_decl _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
        | Tokens.RDIV ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_059 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState880
        | Tokens.POW ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_032 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState880
        | Tokens.PLUS_PLUS ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_061 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState880
        | Tokens.PLUS ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_071 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState880
        | Tokens.OR ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_073 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState880
        | Tokens.NE ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_075 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState880
        | Tokens.MUL ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_063 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState880
        | Tokens.MOD ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_065 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState880
        | Tokens.MINUS ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_078 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState880
        | Tokens.LT ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_080 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState880
        | Tokens.LLBRACKET ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_026 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState880
        | Tokens.LE ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_086 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState880
        | Tokens.LBRACKET ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_034 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState880
        | Tokens.IN ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_039 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState880
        | Tokens.IMPL ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_092 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState880
        | Tokens.GT ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_088 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState880
        | Tokens.GE ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_090 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState880
        | Tokens.EQ_EQ ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_094 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState880
        | Tokens.DOT ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_043 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState880
        | Tokens.DIVRM ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_067 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState880
        | Tokens.DIV ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_069 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState880
        | Tokens.COLON_COLON ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_082 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState880
        | Tokens.BOR ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_097 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState880
        | Tokens.BEQ ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_099 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState880
        | Tokens.BAND ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_101 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState880
        | Tokens.AS ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_103 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState880
        | Tokens.AND ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_084 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState880
        | _ ->
            _eRR 880
    
    and _menhir_run_876 : type  ttv_stack. ((((ttv_stack, _menhir_box_spec) _menhir_cell1_CONSTANT, _menhir_box_spec) _menhir_cell1_ignored_or_identifier, _menhir_box_spec) _menhir_cell1_EQ as 'stack) -> _ -> _ -> _ -> _ -> _ -> ('stack, _menhir_box_spec) _menhir_state -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
        match (_tok : MenhirBasics.token) with
        | Tokens.XOR ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_028 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState876
        | Tokens.SHR ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_030 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState876
        | Tokens.SHL ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_037 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState876
        | Tokens.SEMI_COLON ->
            let _endpos_0 = _menhir_lexbuf.Lexing.lex_curr_p in
            let _tok = _menhir_lexer _menhir_lexbuf in
            let MenhirCell1_EQ (_menhir_stack, _) = _menhir_stack in
            let MenhirCell1_ignored_or_identifier (_menhir_stack, _, name) = _menhir_stack in
            let MenhirCell1_CONSTANT (_menhir_stack, _menhir_s, _startpos__1_, _) = _menhir_stack in
            let (_1, _endpos__2_, x, _4) = ((), _endpos_0, _v, ()) in
            let _v = _menhir_action_092 _1 _4 _endpos__2_ _startpos__1_ name x in
            _menhir_goto_decl _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
        | Tokens.RDIV ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_059 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState876
        | Tokens.POW ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_032 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState876
        | Tokens.PLUS_PLUS ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_061 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState876
        | Tokens.PLUS ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_071 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState876
        | Tokens.OR ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_073 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState876
        | Tokens.NE ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_075 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState876
        | Tokens.MUL ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_063 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState876
        | Tokens.MOD ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_065 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState876
        | Tokens.MINUS ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_078 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState876
        | Tokens.LT ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_080 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState876
        | Tokens.LLBRACKET ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_026 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState876
        | Tokens.LE ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_086 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState876
        | Tokens.LBRACKET ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_034 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState876
        | Tokens.IN ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_039 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState876
        | Tokens.IMPL ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_092 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState876
        | Tokens.GT ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_088 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState876
        | Tokens.GE ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_090 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState876
        | Tokens.EQ_EQ ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_094 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState876
        | Tokens.DOT ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_043 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState876
        | Tokens.DIVRM ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_067 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState876
        | Tokens.DIV ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_069 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState876
        | Tokens.COLON_COLON ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_082 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState876
        | Tokens.BOR ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_097 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState876
        | Tokens.BEQ ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_099 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState876
        | Tokens.BAND ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_101 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState876
        | Tokens.AS ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_103 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState876
        | Tokens.AND ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_084 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState876
        | _ ->
            _eRR 876
    
    and _menhir_run_781 : type  ttv_stack. ((((ttv_stack, _menhir_box_spec) _menhir_cell1_LET, _menhir_box_spec) _menhir_cell1_ignored_or_identifier, _menhir_box_spec) _menhir_cell1_as_ty as 'stack) -> _ -> _ -> _ -> _ -> _ -> ('stack, _menhir_box_spec) _menhir_state -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
        match (_tok : MenhirBasics.token) with
        | Tokens.XOR ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_028 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState781
        | Tokens.SHR ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_030 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState781
        | Tokens.SHL ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_037 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState781
        | Tokens.SEMI_COLON ->
            let _endpos_0 = _menhir_lexbuf.Lexing.lex_curr_p in
            let _tok = _menhir_lexer _menhir_lexbuf in
            let MenhirCell1_as_ty (_menhir_stack, _, x) = _menhir_stack in
            let MenhirCell1_ignored_or_identifier (_menhir_stack, _, name) = _menhir_stack in
            let MenhirCell1_LET (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
            let (_1, _endpos__2_, _4, x_inlined1) = ((), _endpos_0, (), _v) in
            let _v = _menhir_action_091 _1 _4 _endpos__2_ _startpos__1_ name x x_inlined1 in
            _menhir_goto_decl _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
        | Tokens.RDIV ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_059 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState781
        | Tokens.POW ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_032 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState781
        | Tokens.PLUS_PLUS ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_061 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState781
        | Tokens.PLUS ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_071 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState781
        | Tokens.OR ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_073 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState781
        | Tokens.NE ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_075 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState781
        | Tokens.MUL ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_063 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState781
        | Tokens.MOD ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_065 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState781
        | Tokens.MINUS ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_078 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState781
        | Tokens.LT ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_080 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState781
        | Tokens.LLBRACKET ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_026 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState781
        | Tokens.LE ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_086 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState781
        | Tokens.LBRACKET ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_034 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState781
        | Tokens.IN ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_039 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState781
        | Tokens.IMPL ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_092 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState781
        | Tokens.GT ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_088 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState781
        | Tokens.GE ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_090 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState781
        | Tokens.EQ_EQ ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_094 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState781
        | Tokens.DOT ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_043 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState781
        | Tokens.DIVRM ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_067 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState781
        | Tokens.DIV ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_069 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState781
        | Tokens.COLON_COLON ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_082 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState781
        | Tokens.BOR ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_097 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState781
        | Tokens.BEQ ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_099 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState781
        | Tokens.BAND ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_101 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState781
        | Tokens.AS ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_103 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState781
        | Tokens.AND ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_084 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState781
        | _ ->
            _eRR 781
    
    and _menhir_run_777 : type  ttv_stack. ((((ttv_stack, _menhir_box_spec) _menhir_cell1_LET, _menhir_box_spec) _menhir_cell1_ignored_or_identifier, _menhir_box_spec) _menhir_cell1_EQ as 'stack) -> _ -> _ -> _ -> _ -> _ -> ('stack, _menhir_box_spec) _menhir_state -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
        match (_tok : MenhirBasics.token) with
        | Tokens.XOR ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_028 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState777
        | Tokens.SHR ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_030 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState777
        | Tokens.SHL ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_037 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState777
        | Tokens.SEMI_COLON ->
            let _endpos_0 = _menhir_lexbuf.Lexing.lex_curr_p in
            let _tok = _menhir_lexer _menhir_lexbuf in
            let MenhirCell1_EQ (_menhir_stack, _) = _menhir_stack in
            let MenhirCell1_ignored_or_identifier (_menhir_stack, _, name) = _menhir_stack in
            let MenhirCell1_LET (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
            let (_1, _endpos__2_, x, _4) = ((), _endpos_0, _v, ()) in
            let _v = _menhir_action_090 _1 _4 _endpos__2_ _startpos__1_ name x in
            _menhir_goto_decl _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
        | Tokens.RDIV ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_059 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState777
        | Tokens.POW ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_032 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState777
        | Tokens.PLUS_PLUS ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_061 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState777
        | Tokens.PLUS ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_071 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState777
        | Tokens.OR ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_073 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState777
        | Tokens.NE ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_075 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState777
        | Tokens.MUL ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_063 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState777
        | Tokens.MOD ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_065 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState777
        | Tokens.MINUS ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_078 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState777
        | Tokens.LT ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_080 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState777
        | Tokens.LLBRACKET ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_026 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState777
        | Tokens.LE ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_086 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState777
        | Tokens.LBRACKET ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_034 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState777
        | Tokens.IN ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_039 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState777
        | Tokens.IMPL ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_092 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState777
        | Tokens.GT ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_088 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState777
        | Tokens.GE ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_090 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState777
        | Tokens.EQ_EQ ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_094 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState777
        | Tokens.DOT ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_043 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState777
        | Tokens.DIVRM ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_067 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState777
        | Tokens.DIV ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_069 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState777
        | Tokens.COLON_COLON ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_082 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState777
        | Tokens.BOR ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_097 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState777
        | Tokens.BEQ ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_099 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState777
        | Tokens.BAND ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_101 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState777
        | Tokens.AS ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_103 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState777
        | Tokens.AND ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_084 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState777
        | _ ->
            _eRR 777
    
    and _menhir_run_646 : type  ttv_stack. ((ttv_stack, _menhir_box_spec) _menhir_cell1_RECURSELIMIT as 'stack) -> _ -> _ -> _ -> _ -> _ -> ('stack, _menhir_box_spec) _menhir_state -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
        match (_tok : MenhirBasics.token) with
        | Tokens.XOR ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_028 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState646
        | Tokens.SHR ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_030 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState646
        | Tokens.SHL ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_037 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState646
        | Tokens.RDIV ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_059 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState646
        | Tokens.POW ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_032 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState646
        | Tokens.PLUS_PLUS ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_061 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState646
        | Tokens.PLUS ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_071 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState646
        | Tokens.OR ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_073 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState646
        | Tokens.NE ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_075 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState646
        | Tokens.MUL ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_063 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState646
        | Tokens.MOD ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_065 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState646
        | Tokens.MINUS ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_078 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState646
        | Tokens.LT ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_080 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState646
        | Tokens.LLBRACKET ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_026 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState646
        | Tokens.LE ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_086 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState646
        | Tokens.LBRACKET ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_034 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState646
        | Tokens.IN ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_039 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState646
        | Tokens.IMPL ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_092 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState646
        | Tokens.GT ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_088 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState646
        | Tokens.GE ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_090 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState646
        | Tokens.EQ_EQ ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_094 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState646
        | Tokens.DOT ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_043 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState646
        | Tokens.DIVRM ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_067 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState646
        | Tokens.DIV ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_069 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState646
        | Tokens.COLON_COLON ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_082 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState646
        | Tokens.BOR ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_097 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState646
        | Tokens.BEQ ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_099 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState646
        | Tokens.BAND ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_101 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState646
        | Tokens.AS ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_103 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState646
        | Tokens.AND ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_084 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState646
        | Tokens.BEGIN ->
            let MenhirCell1_RECURSELIMIT (_menhir_stack, _menhir_s) = _menhir_stack in
            let (_1, _2) = ((), _v) in
            let _v = _menhir_action_261 _1 _2 in
            _menhir_goto_recurse_limit _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | _ ->
            _eRR 646
    
    and _menhir_goto_recurse_limit : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> (ttv_stack, _menhir_box_spec) _menhir_state -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
        match _menhir_s with
        | MenhirState861 ->
            _menhir_run_868 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | MenhirState862 ->
            _menhir_run_863 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | MenhirState835 ->
            _menhir_run_842 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | MenhirState836 ->
            _menhir_run_837 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | MenhirState789 ->
            _menhir_run_796 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | MenhirState790 ->
            _menhir_run_791 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | MenhirState767 ->
            _menhir_run_768 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | MenhirState758 ->
            _menhir_run_759 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | MenhirState748 ->
            _menhir_run_749 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | MenhirState727 ->
            _menhir_run_734 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | MenhirState728 ->
            _menhir_run_729 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | MenhirState712 ->
            _menhir_run_719 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | MenhirState713 ->
            _menhir_run_714 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | MenhirState696 ->
            _menhir_run_703 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | MenhirState697 ->
            _menhir_run_698 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | MenhirState679 ->
            _menhir_run_686 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | MenhirState680 ->
            _menhir_run_681 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | MenhirState664 ->
            _menhir_run_671 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | MenhirState665 ->
            _menhir_run_666 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | MenhirState644 ->
            _menhir_run_655 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | MenhirState649 ->
            _menhir_run_650 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | _ ->
            _menhir_fail ()
    
    and _menhir_run_837 : type  ttv_stack. (((((ttv_stack, _menhir_box_spec) _menhir_cell1_IMPDEF _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args, _menhir_box_spec) _menhir_cell1_return_type as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_spec) _menhir_state -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
        let _menhir_stack = MenhirCell1_recurse_limit (_menhir_stack, _menhir_s, _v) in
        let _menhir_s = MenhirState838 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.WHILE ->
            _menhir_run_001 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.VAR ->
            _menhir_run_318 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.UNREACHABLE ->
            _menhir_run_363 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.TRY ->
            _menhir_run_365 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.THROW ->
            _menhir_run_366 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.RETURN ->
            _menhir_run_369 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.REPEAT ->
            _menhir_run_373 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PRINTLN ->
            _menhir_run_374 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PRINT ->
            _menhir_run_377 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PRAGMA ->
            _menhir_run_380 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PASS ->
            _menhir_run_384 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.MINUS ->
            _menhir_run_386 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LPAR ->
            _menhir_run_387 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LET ->
            _menhir_run_408 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IF ->
            _menhir_run_420 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IDENTIFIER _v ->
            _menhir_run_423 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.FOR ->
            _menhir_run_443 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.DEBUG ->
            _menhir_run_453 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.CONSTANT ->
            _menhir_run_458 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.CASE ->
            _menhir_run_469 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.ASSERT ->
            _menhir_run_477 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | _ ->
            _eRR 838
    
    and _menhir_run_791 : type  ttv_stack. (((((ttv_stack, _menhir_box_spec) _menhir_cell1_IMPLEMENTATION _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args, _menhir_box_spec) _menhir_cell1_return_type as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_spec) _menhir_state -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
        let _menhir_stack = MenhirCell1_recurse_limit (_menhir_stack, _menhir_s, _v) in
        let _menhir_s = MenhirState792 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.WHILE ->
            _menhir_run_001 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.VAR ->
            _menhir_run_318 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.UNREACHABLE ->
            _menhir_run_363 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.TRY ->
            _menhir_run_365 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.THROW ->
            _menhir_run_366 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.RETURN ->
            _menhir_run_369 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.REPEAT ->
            _menhir_run_373 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PRINTLN ->
            _menhir_run_374 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PRINT ->
            _menhir_run_377 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PRAGMA ->
            _menhir_run_380 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PASS ->
            _menhir_run_384 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.MINUS ->
            _menhir_run_386 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LPAR ->
            _menhir_run_387 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LET ->
            _menhir_run_408 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IF ->
            _menhir_run_420 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IDENTIFIER _v ->
            _menhir_run_423 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.FOR ->
            _menhir_run_443 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.DEBUG ->
            _menhir_run_453 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.CONSTANT ->
            _menhir_run_458 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.CASE ->
            _menhir_run_469 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.ASSERT ->
            _menhir_run_477 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | _ ->
            _eRR 792
    
    and _menhir_run_729 : type  ttv_stack. (((((ttv_stack, _menhir_box_spec) _menhir_cell1_PURE _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args, _menhir_box_spec) _menhir_cell1_return_type as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_spec) _menhir_state -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
        let _menhir_stack = MenhirCell1_recurse_limit (_menhir_stack, _menhir_s, _v) in
        let _menhir_s = MenhirState730 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.WHILE ->
            _menhir_run_001 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.VAR ->
            _menhir_run_318 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.UNREACHABLE ->
            _menhir_run_363 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.TRY ->
            _menhir_run_365 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.THROW ->
            _menhir_run_366 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.RETURN ->
            _menhir_run_369 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.REPEAT ->
            _menhir_run_373 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PRINTLN ->
            _menhir_run_374 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PRINT ->
            _menhir_run_377 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PRAGMA ->
            _menhir_run_380 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PASS ->
            _menhir_run_384 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.MINUS ->
            _menhir_run_386 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LPAR ->
            _menhir_run_387 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LET ->
            _menhir_run_408 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IF ->
            _menhir_run_420 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IDENTIFIER _v ->
            _menhir_run_423 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.FOR ->
            _menhir_run_443 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.DEBUG ->
            _menhir_run_453 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.CONSTANT ->
            _menhir_run_458 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.CASE ->
            _menhir_run_469 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.ASSERT ->
            _menhir_run_477 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | _ ->
            _eRR 730
    
    and _menhir_run_714 : type  ttv_stack. (((((ttv_stack, _menhir_box_spec) _menhir_cell1_PURE _menhir_cell0_IMPDEF _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args, _menhir_box_spec) _menhir_cell1_return_type as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_spec) _menhir_state -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
        let _menhir_stack = MenhirCell1_recurse_limit (_menhir_stack, _menhir_s, _v) in
        let _menhir_s = MenhirState715 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.WHILE ->
            _menhir_run_001 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.VAR ->
            _menhir_run_318 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.UNREACHABLE ->
            _menhir_run_363 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.TRY ->
            _menhir_run_365 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.THROW ->
            _menhir_run_366 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.RETURN ->
            _menhir_run_369 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.REPEAT ->
            _menhir_run_373 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PRINTLN ->
            _menhir_run_374 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PRINT ->
            _menhir_run_377 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PRAGMA ->
            _menhir_run_380 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PASS ->
            _menhir_run_384 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.MINUS ->
            _menhir_run_386 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LPAR ->
            _menhir_run_387 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LET ->
            _menhir_run_408 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IF ->
            _menhir_run_420 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IDENTIFIER _v ->
            _menhir_run_423 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.FOR ->
            _menhir_run_443 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.DEBUG ->
            _menhir_run_453 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.CONSTANT ->
            _menhir_run_458 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.CASE ->
            _menhir_run_469 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.ASSERT ->
            _menhir_run_477 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | _ ->
            _eRR 715
    
    and _menhir_run_698 : type  ttv_stack. (((((ttv_stack, _menhir_box_spec) _menhir_cell1_PURE _menhir_cell0_IMPLEMENTATION _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args, _menhir_box_spec) _menhir_cell1_return_type as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_spec) _menhir_state -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
        let _menhir_stack = MenhirCell1_recurse_limit (_menhir_stack, _menhir_s, _v) in
        let _menhir_s = MenhirState699 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.WHILE ->
            _menhir_run_001 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.VAR ->
            _menhir_run_318 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.UNREACHABLE ->
            _menhir_run_363 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.TRY ->
            _menhir_run_365 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.THROW ->
            _menhir_run_366 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.RETURN ->
            _menhir_run_369 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.REPEAT ->
            _menhir_run_373 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PRINTLN ->
            _menhir_run_374 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PRINT ->
            _menhir_run_377 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PRAGMA ->
            _menhir_run_380 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PASS ->
            _menhir_run_384 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.MINUS ->
            _menhir_run_386 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LPAR ->
            _menhir_run_387 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LET ->
            _menhir_run_408 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IF ->
            _menhir_run_420 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IDENTIFIER _v ->
            _menhir_run_423 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.FOR ->
            _menhir_run_443 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.DEBUG ->
            _menhir_run_453 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.CONSTANT ->
            _menhir_run_458 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.CASE ->
            _menhir_run_469 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.ASSERT ->
            _menhir_run_477 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | _ ->
            _eRR 699
    
    and _menhir_run_681 : type  ttv_stack. (((((ttv_stack, _menhir_box_spec) _menhir_cell1_READONLY _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args, _menhir_box_spec) _menhir_cell1_return_type as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_spec) _menhir_state -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
        let _menhir_stack = MenhirCell1_recurse_limit (_menhir_stack, _menhir_s, _v) in
        let _menhir_s = MenhirState682 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.WHILE ->
            _menhir_run_001 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.VAR ->
            _menhir_run_318 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.UNREACHABLE ->
            _menhir_run_363 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.TRY ->
            _menhir_run_365 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.THROW ->
            _menhir_run_366 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.RETURN ->
            _menhir_run_369 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.REPEAT ->
            _menhir_run_373 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PRINTLN ->
            _menhir_run_374 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PRINT ->
            _menhir_run_377 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PRAGMA ->
            _menhir_run_380 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PASS ->
            _menhir_run_384 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.MINUS ->
            _menhir_run_386 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LPAR ->
            _menhir_run_387 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LET ->
            _menhir_run_408 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IF ->
            _menhir_run_420 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IDENTIFIER _v ->
            _menhir_run_423 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.FOR ->
            _menhir_run_443 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.DEBUG ->
            _menhir_run_453 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.CONSTANT ->
            _menhir_run_458 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.CASE ->
            _menhir_run_469 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.ASSERT ->
            _menhir_run_477 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | _ ->
            _eRR 682
    
    and _menhir_run_666 : type  ttv_stack. (((((ttv_stack, _menhir_box_spec) _menhir_cell1_READONLY _menhir_cell0_IMPDEF _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args, _menhir_box_spec) _menhir_cell1_return_type as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_spec) _menhir_state -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
        let _menhir_stack = MenhirCell1_recurse_limit (_menhir_stack, _menhir_s, _v) in
        let _menhir_s = MenhirState667 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.WHILE ->
            _menhir_run_001 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.VAR ->
            _menhir_run_318 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.UNREACHABLE ->
            _menhir_run_363 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.TRY ->
            _menhir_run_365 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.THROW ->
            _menhir_run_366 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.RETURN ->
            _menhir_run_369 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.REPEAT ->
            _menhir_run_373 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PRINTLN ->
            _menhir_run_374 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PRINT ->
            _menhir_run_377 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PRAGMA ->
            _menhir_run_380 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PASS ->
            _menhir_run_384 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.MINUS ->
            _menhir_run_386 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LPAR ->
            _menhir_run_387 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LET ->
            _menhir_run_408 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IF ->
            _menhir_run_420 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IDENTIFIER _v ->
            _menhir_run_423 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.FOR ->
            _menhir_run_443 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.DEBUG ->
            _menhir_run_453 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.CONSTANT ->
            _menhir_run_458 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.CASE ->
            _menhir_run_469 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.ASSERT ->
            _menhir_run_477 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | _ ->
            _eRR 667
    
    and _menhir_run_650 : type  ttv_stack. (((((ttv_stack, _menhir_box_spec) _menhir_cell1_READONLY _menhir_cell0_IMPLEMENTATION _menhir_cell0_FUNC _menhir_cell0_IDENTIFIER, _menhir_box_spec) _menhir_cell1_params_opt, _menhir_box_spec) _menhir_cell1_func_args, _menhir_box_spec) _menhir_cell1_return_type as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_spec) _menhir_state -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
        let _menhir_stack = MenhirCell1_recurse_limit (_menhir_stack, _menhir_s, _v) in
        let _menhir_s = MenhirState651 in
        let _tok = _menhir_lexer _menhir_lexbuf in
        match (_tok : MenhirBasics.token) with
        | Tokens.WHILE ->
            _menhir_run_001 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.VAR ->
            _menhir_run_318 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.UNREACHABLE ->
            _menhir_run_363 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.TRY ->
            _menhir_run_365 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.THROW ->
            _menhir_run_366 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.RETURN ->
            _menhir_run_369 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.REPEAT ->
            _menhir_run_373 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PRINTLN ->
            _menhir_run_374 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PRINT ->
            _menhir_run_377 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PRAGMA ->
            _menhir_run_380 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.PASS ->
            _menhir_run_384 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.MINUS ->
            _menhir_run_386 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LPAR ->
            _menhir_run_387 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.LET ->
            _menhir_run_408 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IF ->
            _menhir_run_420 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.IDENTIFIER _v ->
            _menhir_run_423 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
        | Tokens.FOR ->
            _menhir_run_443 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.DEBUG ->
            _menhir_run_453 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.CONSTANT ->
            _menhir_run_458 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.CASE ->
            _menhir_run_469 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | Tokens.ASSERT ->
            _menhir_run_477 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
        | _ ->
            _eRR 651
    
    and _menhir_run_592 : type  ttv_stack. ((((ttv_stack, _menhir_box_spec) _menhir_cell1_VAR, _menhir_box_spec) _menhir_cell1_ignored_or_identifier, _menhir_box_spec) _menhir_cell1_as_ty as 'stack) -> _ -> _ -> _ -> _ -> _ -> ('stack, _menhir_box_spec) _menhir_state -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
        match (_tok : MenhirBasics.token) with
        | Tokens.XOR ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_028 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState592
        | Tokens.SHR ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_030 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState592
        | Tokens.SHL ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_037 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState592
        | Tokens.SEMI_COLON ->
            let _endpos_0 = _menhir_lexbuf.Lexing.lex_curr_p in
            let _tok = _menhir_lexer _menhir_lexbuf in
            let MenhirCell1_as_ty (_menhir_stack, _, x) = _menhir_stack in
            let MenhirCell1_ignored_or_identifier (_menhir_stack, _, name) = _menhir_stack in
            let MenhirCell1_VAR (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
            let (_1, _endpos__2_, _4, x_inlined1) = ((), _endpos_0, (), _v) in
            let _v = _menhir_action_095 _1 _4 _endpos__2_ _startpos__1_ name x x_inlined1 in
            _menhir_goto_decl _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
        | Tokens.RDIV ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_059 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState592
        | Tokens.POW ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_032 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState592
        | Tokens.PLUS_PLUS ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_061 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState592
        | Tokens.PLUS ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_071 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState592
        | Tokens.OR ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_073 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState592
        | Tokens.NE ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_075 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState592
        | Tokens.MUL ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_063 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState592
        | Tokens.MOD ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_065 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState592
        | Tokens.MINUS ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_078 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState592
        | Tokens.LT ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_080 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState592
        | Tokens.LLBRACKET ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_026 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState592
        | Tokens.LE ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_086 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState592
        | Tokens.LBRACKET ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_034 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState592
        | Tokens.IN ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_039 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState592
        | Tokens.IMPL ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_092 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState592
        | Tokens.GT ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_088 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState592
        | Tokens.GE ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_090 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState592
        | Tokens.EQ_EQ ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_094 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState592
        | Tokens.DOT ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_043 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState592
        | Tokens.DIVRM ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_067 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState592
        | Tokens.DIV ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_069 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState592
        | Tokens.COLON_COLON ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_082 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState592
        | Tokens.BOR ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_097 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState592
        | Tokens.BEQ ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_099 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState592
        | Tokens.BAND ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_101 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState592
        | Tokens.AS ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_103 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState592
        | Tokens.AND ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_084 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState592
        | _ ->
            _eRR 592
    
    and _menhir_run_572 : type  ttv_stack. ((((ttv_stack, _menhir_box_spec) _menhir_cell1_VAR, _menhir_box_spec) _menhir_cell1_ignored_or_identifier, _menhir_box_spec) _menhir_cell1_EQ as 'stack) -> _ -> _ -> _ -> _ -> _ -> ('stack, _menhir_box_spec) _menhir_state -> _ -> _menhir_box_spec =
      fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
        match (_tok : MenhirBasics.token) with
        | Tokens.XOR ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_028 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState572
        | Tokens.SHR ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_030 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState572
        | Tokens.SHL ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_037 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState572
        | Tokens.SEMI_COLON ->
            let _endpos_0 = _menhir_lexbuf.Lexing.lex_curr_p in
            let _tok = _menhir_lexer _menhir_lexbuf in
            let MenhirCell1_EQ (_menhir_stack, _) = _menhir_stack in
            let MenhirCell1_ignored_or_identifier (_menhir_stack, _, name) = _menhir_stack in
            let MenhirCell1_VAR (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
            let (_1, _endpos__2_, x, _4) = ((), _endpos_0, _v, ()) in
            let _v = _menhir_action_094 _1 _4 _endpos__2_ _startpos__1_ name x in
            _menhir_goto_decl _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
        | Tokens.RDIV ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_059 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState572
        | Tokens.POW ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_032 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState572
        | Tokens.PLUS_PLUS ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_061 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState572
        | Tokens.PLUS ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_071 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState572
        | Tokens.OR ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_073 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState572
        | Tokens.NE ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_075 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState572
        | Tokens.MUL ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_063 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState572
        | Tokens.MOD ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_065 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState572
        | Tokens.MINUS ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_078 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState572
        | Tokens.LT ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
            _menhir_run_080 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState572
        | Tokens.LLBRACKET ->
            let _menhir_stack = MenhirCell1_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
  