/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.download.game;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.jackhuang.hmcl.download.AbstractDependencyManager;
import org.jackhuang.hmcl.download.LibraryAnalyzer;
import org.jackhuang.hmcl.download.game.LibraryDownloadTask;
import org.jackhuang.hmcl.game.GameRepository;
import org.jackhuang.hmcl.game.Library;
import org.jackhuang.hmcl.game.Version;
import org.jackhuang.hmcl.task.FileDownloadTask;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.util.io.CompressingUtils;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jackhuang.hmcl.util.versioning.GameVersionNumber;
import org.jackhuang.hmcl.util.versioning.VersionNumber;

public final class GameLibrariesTask
extends Task<Void> {
    private final AbstractDependencyManager dependencyManager;
    private final Version version;
    private final boolean integrityCheck;
    private final List<Library> libraries;
    private final List<Task<?>> dependencies = new ArrayList();

    public GameLibrariesTask(AbstractDependencyManager dependencyManager, Version version, boolean integrityCheck) {
        this(dependencyManager, version, integrityCheck, version.resolve(dependencyManager.getGameRepository()).getLibraries());
    }

    public GameLibrariesTask(AbstractDependencyManager dependencyManager, Version version, boolean integrityCheck, List<Library> libraries) {
        this.dependencyManager = dependencyManager;
        this.version = version;
        this.integrityCheck = integrityCheck;
        this.libraries = libraries;
        this.setSignificance(Task.TaskSignificance.MODERATE);
    }

    @Override
    public List<Task<?>> getDependencies() {
        return this.dependencies;
    }

    public static boolean shouldDownloadLibrary(GameRepository gameRepository, Version version, Library library, boolean integrityCheck) {
        block8: {
            File file = gameRepository.getLibraryFile(version, library);
            Path jar = file.toPath();
            if (!file.isFile()) {
                return true;
            }
            if (!integrityCheck) {
                return false;
            }
            try {
                if (!library.getDownload().validateChecksum(jar, true)) {
                    return true;
                }
                if (library.getChecksums() != null && !library.getChecksums().isEmpty() && !LibraryDownloadTask.checksumValid(file, library.getChecksums())) {
                    return true;
                }
                if (!FileUtils.getExtension(file).equals("jar")) break block8;
                try {
                    FileDownloadTask.ZIP_INTEGRITY_CHECK_HANDLER.checkIntegrity(jar, jar);
                }
                catch (IOException ignored) {
                    return true;
                }
            }
            catch (IOException e) {
                Logger.LOG.warning("Unable to calc hash value of file " + jar, e);
            }
        }
        return false;
    }

    @Override
    public void execute() throws IOException {
        GameRepository gameRepository = this.dependencyManager.getGameRepository();
        for (Library library : this.libraries) {
            String forgeVersion;
            if (!library.appliesToCurrentEnvironment()) continue;
            File file = gameRepository.getLibraryFile(this.version, library);
            if ("optifine".equals(library.getGroupId()) && file.exists() && GameVersionNumber.asGameVersion(gameRepository.getGameVersion(this.version)).compareTo("1.20.4") == 0 && (forgeVersion = (String)LibraryAnalyzer.analyze(this.version, "1.20.4").getVersion(LibraryAnalyzer.LibraryType.FORGE).orElse(null)) != null && LibraryAnalyzer.FORGE_OPTIFINE_BROKEN_RANGE.contains(VersionNumber.asVersion(forgeVersion))) {
                try (FileSystem fs2 = CompressingUtils.createWritableZipFileSystem(file.toPath());){
                    Files.deleteIfExists(fs2.getPath("/META-INF/mods.toml", new String[0]));
                }
                catch (IOException e) {
                    throw new IOException("Cannot fix optifine", e);
                }
            }
            if (GameLibrariesTask.shouldDownloadLibrary(gameRepository, this.version, library, this.integrityCheck) && (library.hasDownloadURL() || !"optifine".equals(library.getGroupId()))) {
                this.dependencies.add(new LibraryDownloadTask(this.dependencyManager, file, library));
                continue;
            }
            this.dependencyManager.getCacheRepository().tryCacheLibrary(library, file.toPath());
        }
    }
}

