/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.game.tlauncher;

import com.google.gson.JsonParseException;
import java.time.Instant;
import java.util.List;
import java.util.stream.Collectors;
import org.jackhuang.hmcl.game.Arguments;
import org.jackhuang.hmcl.game.AssetIndexInfo;
import org.jackhuang.hmcl.game.CompatibilityRule;
import org.jackhuang.hmcl.game.DownloadInfo;
import org.jackhuang.hmcl.game.DownloadType;
import org.jackhuang.hmcl.game.GameJavaVersion;
import org.jackhuang.hmcl.game.LoggingInfo;
import org.jackhuang.hmcl.game.ReleaseType;
import org.jackhuang.hmcl.game.Version;
import org.jackhuang.hmcl.game.tlauncher.TLauncherLibrary;
import org.jackhuang.hmcl.util.gson.JsonMap;
import org.jackhuang.hmcl.util.gson.TolerableValidationException;
import org.jackhuang.hmcl.util.gson.Validation;
import org.jetbrains.annotations.Nullable;

public class TLauncherVersion
implements Validation {
    private final String id;
    private final String minecraftArguments;
    private final Arguments arguments;
    private final String mainClass;
    private final String inheritsFrom;
    private final String jar;
    private final AssetIndexInfo assetIndex;
    private final String assets;
    private final Integer complianceLevel;
    @Nullable
    private final GameJavaVersion javaVersion;
    private final List<TLauncherLibrary> libraries;
    private final List<CompatibilityRule> compatibilityRules;
    private final JsonMap<DownloadType, DownloadInfo> downloads;
    private final JsonMap<DownloadType, LoggingInfo> logging;
    private final ReleaseType type;
    private final Instant time;
    private final Instant releaseTime;
    private final Integer minimumLauncherVersion;
    private final Integer tlauncherVersion;

    public TLauncherVersion(String id, String minecraftArguments, Arguments arguments, String mainClass, String inheritsFrom, String jar, AssetIndexInfo assetIndex, String assets, Integer complianceLevel, @Nullable GameJavaVersion javaVersion, List<TLauncherLibrary> libraries, List<CompatibilityRule> compatibilityRules, JsonMap<DownloadType, DownloadInfo> downloads, JsonMap<DownloadType, LoggingInfo> logging, ReleaseType type, Instant time, Instant releaseTime, Integer minimumLauncherVersion, Integer tlauncherVersion) {
        this.id = id;
        this.minecraftArguments = minecraftArguments;
        this.arguments = arguments;
        this.mainClass = mainClass;
        this.inheritsFrom = inheritsFrom;
        this.jar = jar;
        this.assetIndex = assetIndex;
        this.assets = assets;
        this.complianceLevel = complianceLevel;
        this.javaVersion = javaVersion;
        this.libraries = libraries;
        this.compatibilityRules = compatibilityRules;
        this.downloads = downloads;
        this.logging = logging;
        this.type = type;
        this.time = time;
        this.releaseTime = releaseTime;
        this.minimumLauncherVersion = minimumLauncherVersion;
        this.tlauncherVersion = tlauncherVersion;
    }

    @Override
    public void validate() throws JsonParseException, TolerableValidationException {
        Validation.requireNonNull(this.tlauncherVersion, "Not TLauncher version json format");
    }

    public Version toVersion() {
        return new Version(false, this.id, null, null, this.minecraftArguments, this.arguments, this.mainClass, this.inheritsFrom, this.jar, this.assetIndex, this.assets, this.complianceLevel, this.javaVersion, this.libraries == null ? null : this.libraries.stream().map(TLauncherLibrary::toLibrary).collect(Collectors.toList()), this.compatibilityRules, this.downloads, this.logging, this.type, this.time, this.releaseTime, this.minimumLauncherVersion, null, null, null);
    }
}

