/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.mod;

import java.io.File;
import java.util.List;
import org.jackhuang.hmcl.util.Lang;

public interface ModAdviser {
    public static final List<String> MODPACK_BLACK_LIST = Lang.immutableListOf("regex:(.*?)\\.log", "usernamecache.json", "usercache.json", "launcher_profiles.json", "launcher.pack.lzma", "launcher_accounts.json", "launcher_cef_log.txt", "launcher_log.txt", "launcher_msa_credentials.bin", "launcher_settings.json", "launcher_ui_state.json", "realms_persistence.json", "webcache2", "treatment_tags.json", "clientId.txt", "PCL.ini", "backup", "pack.json", "launcher.jar", "cache", "modpack.cfg", "manifest.json", "minecraftinstance.json", ".curseclient", ".fabric", ".mixin.out", "jars", "logs", "versions", "assets", "libraries", "crash-reports", "NVIDIA", "AMD", "screenshots", "natives", "native", "$native", "server-resource-packs", "downloads", "asm", "backups", "TCNodeTracker", "CustomDISkins", "data", "CustomSkinLoader/caches");
    public static final List<String> MODPACK_SUGGESTED_BLACK_LIST = Lang.immutableListOf("fonts", "saves", "servers.dat", "options.txt", "blueprints", "optionsof.txt", "journeymap", "optionsshaders.txt", "mods" + File.separator + "VoxelMods");

    public ModSuggestion advise(String var1, boolean var2);

    public static ModSuggestion suggestMod(String fileName, boolean isDirectory) {
        if (ModAdviser.match(MODPACK_BLACK_LIST, fileName, isDirectory)) {
            return ModSuggestion.HIDDEN;
        }
        if (ModAdviser.match(MODPACK_SUGGESTED_BLACK_LIST, fileName, isDirectory)) {
            return ModSuggestion.NORMAL;
        }
        return ModSuggestion.SUGGESTED;
    }

    public static boolean match(List<String> l, String fileName, boolean isDirectory) {
        for (String s : l) {
            if (!(isDirectory ? fileName.startsWith(s + File.separator) : (s.startsWith("regex:") ? fileName.matches(s.substring("regex:".length())) : fileName.equals(s)))) continue;
            return true;
        }
        return false;
    }

    public static enum ModSuggestion {
        SUGGESTED,
        NORMAL,
        HIDDEN;

    }
}

