/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.terracotta;

import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ChangeListener;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import org.jackhuang.hmcl.game.LauncherHelper;
import org.jackhuang.hmcl.setting.Profile;
import org.jackhuang.hmcl.setting.Profiles;
import org.jackhuang.hmcl.terracotta.TerracottaMetadata;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.animation.ContainerAnimations;
import org.jackhuang.hmcl.ui.animation.TransitionPane;
import org.jackhuang.hmcl.ui.construct.AdvancedListBox;
import org.jackhuang.hmcl.ui.construct.PageAware;
import org.jackhuang.hmcl.ui.construct.TabControl;
import org.jackhuang.hmcl.ui.construct.TabHeader;
import org.jackhuang.hmcl.ui.decorator.DecoratorAnimatedPage;
import org.jackhuang.hmcl.ui.decorator.DecoratorPage;
import org.jackhuang.hmcl.ui.main.MainPage;
import org.jackhuang.hmcl.ui.terracotta.TerracottaControllerPage;
import org.jackhuang.hmcl.ui.versions.Versions;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.i18n.I18n;

public class TerracottaPage
extends DecoratorAnimatedPage
implements DecoratorPage,
PageAware {
    private final ReadOnlyObjectWrapper<DecoratorPage.State> state = new ReadOnlyObjectWrapper((Object)DecoratorPage.State.fromTitle(I18n.i18n("terracotta.terracotta")));
    private final TabHeader tab;
    private final TabControl.Tab<TerracottaControllerPage> statusPage = new TabControl.Tab("statusPage");
    private final TransitionPane transitionPane = new TransitionPane();
    private ChangeListener<String> instanceChangeListenerHolder;

    public TerracottaPage() {
        this.statusPage.setNodeSupplier(TerracottaControllerPage::new);
        this.tab = new TabHeader(this.statusPage);
        this.tab.select(this.statusPage);
        this.transitionPane.setContent((Node)this.statusPage.getNode(), ContainerAnimations.NONE);
        FXUtils.onChange(this.tab.getSelectionModel().selectedItemProperty(), newValue -> this.transitionPane.setContent((Node)newValue.getNode(), ContainerAnimations.FADE));
        BorderPane left = new BorderPane();
        FXUtils.setLimitWidth((Region)left, 200.0);
        VBox.setVgrow((Node)left, (Priority)Priority.ALWAYS);
        this.setLeft(new Node[]{left});
        AdvancedListBox sideBar = new AdvancedListBox().addNavigationDrawerTab(this.tab, this.statusPage, I18n.i18n("terracotta.status"), SVG.TUNE);
        left.setTop((Node)sideBar);
        AdvancedListBox toolbar = new AdvancedListBox().addNavigationDrawerItem(I18n.i18n("version.launch"), SVG.ROCKET_LAUNCH, () -> {
            Profile profile = Profiles.getSelectedProfile();
            Versions.launch(profile, profile.getSelectedVersion(), LauncherHelper::setKeep);
        }, item -> {
            this.instanceChangeListenerHolder = FXUtils.onWeakChangeAndOperate(Profiles.selectedVersionProperty(), instanceName -> item.setSubtitle(StringUtils.isNotBlank(instanceName) ? instanceName : I18n.i18n("version.empty")));
            MainPage mainPage = Controllers.getRootPage().getMainPage();
            FXUtils.onScroll((Node)item, mainPage.getVersions(), list -> {
                String currentId = mainPage.getCurrentGame();
                return Lang.indexWhere(list, instance -> instance.getId().equals(currentId));
            }, it -> mainPage.getProfile().setSelectedVersion(it.getId()));
        }).addNavigationDrawerItem(I18n.i18n("terracotta.feedback.title"), SVG.FEEDBACK, () -> FXUtils.openLink(TerracottaMetadata.FEEDBACK_LINK)).addNavigationDrawerItem(I18n.i18n("terracotta.easytier"), SVG.HOST, () -> FXUtils.openLink("https://easytier.cn/"));
        BorderPane.setMargin((Node)toolbar, (Insets)new Insets(0.0, 0.0, 12.0, 0.0));
        left.setBottom((Node)toolbar);
        this.setCenter(new Node[]{this.transitionPane});
    }

    @Override
    public void onPageShown() {
        this.tab.onPageShown();
    }

    @Override
    public void onPageHidden() {
        this.tab.onPageHidden();
    }

    @Override
    public ReadOnlyObjectProperty<DecoratorPage.State> stateProperty() {
        return this.state.getReadOnlyProperty();
    }
}

