/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.versions;

import com.google.gson.JsonParseException;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.image.Image;
import org.jackhuang.hmcl.download.LibraryAnalyzer;
import org.jackhuang.hmcl.mod.ModpackConfiguration;
import org.jackhuang.hmcl.setting.Profile;
import org.jackhuang.hmcl.ui.versions.GameItemSkin;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.logging.Logger;

public class GameItem
extends Control {
    private static final ThreadPoolExecutor POOL_VERSION_RESOLVE = Lang.threadPool("VersionResolve", true, 1, 1L, TimeUnit.SECONDS);
    private final Profile profile;
    private final String version;
    private final StringProperty title = new SimpleStringProperty();
    private final StringProperty tag = new SimpleStringProperty();
    private final StringProperty subtitle = new SimpleStringProperty();
    private final ObjectProperty<Image> image = new SimpleObjectProperty();

    public GameItem(Profile profile, String id) {
        this.profile = profile;
        this.version = id;
        ((CompletableFuture)CompletableFuture.supplyAsync(() -> profile.getRepository().getGameVersion(id), POOL_VERSION_RESOLVE).thenAcceptAsync(game -> {
            StringBuilder libraries = new StringBuilder(game.orElse(I18n.i18n("message.unknown")));
            LibraryAnalyzer analyzer = LibraryAnalyzer.analyze(profile.getRepository().getResolvedPreservingPatchesVersion(id), game.orElse(null));
            for (LibraryAnalyzer.LibraryMark mark : analyzer) {
                String libraryId = mark.getLibraryId();
                String libraryVersion = mark.getLibraryVersion();
                if (libraryId.equals(LibraryAnalyzer.LibraryType.MINECRAFT.getPatchId()) || !I18n.hasKey("install.installer." + libraryId)) continue;
                libraries.append(", ").append(I18n.i18n("install.installer." + libraryId));
                if (libraryVersion == null) continue;
                libraries.append(": ").append(libraryVersion.replaceAll("(?i)" + libraryId, ""));
            }
            this.subtitle.set((Object)libraries.toString());
        }, Platform::runLater)).exceptionally(Lang.handleUncaught);
        CompletableFuture.runAsync(() -> {
            try {
                ModpackConfiguration<?> config = profile.getRepository().readModpackConfiguration(this.version);
                if (config == null) {
                    return;
                }
                this.tag.set((Object)config.getVersion());
            }
            catch (JsonParseException | IOException e) {
                Logger.LOG.warning("Failed to read modpack configuration from " + this.version, e);
            }
        }, Platform::runLater).exceptionally((Function)Lang.handleUncaught);
        this.title.set((Object)id);
        this.image.set((Object)profile.getRepository().getVersionIconImage(this.version));
    }

    protected Skin<?> createDefaultSkin() {
        return new GameItemSkin(this);
    }

    public Profile getProfile() {
        return this.profile;
    }

    public String getVersion() {
        return this.version;
    }

    public StringProperty titleProperty() {
        return this.title;
    }

    public StringProperty tagProperty() {
        return this.tag;
    }

    public StringProperty subtitleProperty() {
        return this.subtitle;
    }

    public ObjectProperty<Image> imageProperty() {
        return this.image;
    }
}

