
/*** DO NOT EDIT THIS FILE DIRECTLY (use ../config/gen_code.sh to generate) ***/

#ifndef HYPRE_PARCSR_LS_MUP_HEADER
#define HYPRE_PARCSR_LS_MUP_HEADER

#ifdef __cplusplus
extern "C" {
#endif

#if defined (HYPRE_MIXED_PRECISION)

/*** DO NOT EDIT THIS FILE DIRECTLY (use ../config/gen_code.sh to generate) ***/

/******************************************************************************
 * Copyright (c) 1998 Lawrence Livermore National Security, LLC and other
 * HYPRE Project Developers. See the top-level COPYRIGHT file for details.
 *
 * SPDX-License-Identifier: (Apache-2.0 OR MIT)
 ******************************************************************************/


HYPRE_ParCSRMatrix
GenerateDifConv_flt( MPI_Comm comm, HYPRE_BigInt nx, HYPRE_BigInt ny, HYPRE_BigInt nz, HYPRE_Int P, HYPRE_Int Q, HYPRE_Int R, HYPRE_Int p, HYPRE_Int q, HYPRE_Int r, hypre_float *value );
HYPRE_ParCSRMatrix
GenerateDifConv_dbl( MPI_Comm comm, HYPRE_BigInt nx, HYPRE_BigInt ny, HYPRE_BigInt nz, HYPRE_Int P, HYPRE_Int Q, HYPRE_Int R, HYPRE_Int p, HYPRE_Int q, HYPRE_Int r, hypre_double *value );
HYPRE_ParCSRMatrix
GenerateDifConv_long_dbl( MPI_Comm comm, HYPRE_BigInt nx, HYPRE_BigInt ny, HYPRE_BigInt nz, HYPRE_Int P, HYPRE_Int Q, HYPRE_Int R, HYPRE_Int p, HYPRE_Int q, HYPRE_Int r, hypre_long_double *value );

HYPRE_ParCSRMatrix
GenerateLaplacian_flt( MPI_Comm comm, HYPRE_BigInt nx, HYPRE_BigInt ny, HYPRE_BigInt nz, HYPRE_Int P, HYPRE_Int Q, HYPRE_Int R, HYPRE_Int p, HYPRE_Int q, HYPRE_Int r, hypre_float *value );
HYPRE_ParCSRMatrix
GenerateLaplacian_dbl( MPI_Comm comm, HYPRE_BigInt nx, HYPRE_BigInt ny, HYPRE_BigInt nz, HYPRE_Int P, HYPRE_Int Q, HYPRE_Int R, HYPRE_Int p, HYPRE_Int q, HYPRE_Int r, hypre_double *value );
HYPRE_ParCSRMatrix
GenerateLaplacian_long_dbl( MPI_Comm comm, HYPRE_BigInt nx, HYPRE_BigInt ny, HYPRE_BigInt nz, HYPRE_Int P, HYPRE_Int Q, HYPRE_Int R, HYPRE_Int p, HYPRE_Int q, HYPRE_Int r, hypre_long_double *value );

HYPRE_ParCSRMatrix
GenerateLaplacian27pt_flt( MPI_Comm comm, HYPRE_BigInt nx, HYPRE_BigInt ny, HYPRE_BigInt nz, HYPRE_Int P, HYPRE_Int Q, HYPRE_Int R, HYPRE_Int p, HYPRE_Int q, HYPRE_Int r, hypre_float *value );
HYPRE_ParCSRMatrix
GenerateLaplacian27pt_dbl( MPI_Comm comm, HYPRE_BigInt nx, HYPRE_BigInt ny, HYPRE_BigInt nz, HYPRE_Int P, HYPRE_Int Q, HYPRE_Int R, HYPRE_Int p, HYPRE_Int q, HYPRE_Int r, hypre_double *value );
HYPRE_ParCSRMatrix
GenerateLaplacian27pt_long_dbl( MPI_Comm comm, HYPRE_BigInt nx, HYPRE_BigInt ny, HYPRE_BigInt nz, HYPRE_Int P, HYPRE_Int Q, HYPRE_Int R, HYPRE_Int p, HYPRE_Int q, HYPRE_Int r, hypre_long_double *value );

HYPRE_ParCSRMatrix
GenerateLaplacian9pt_flt( MPI_Comm comm, HYPRE_BigInt nx, HYPRE_BigInt ny, HYPRE_Int P, HYPRE_Int Q, HYPRE_Int p, HYPRE_Int q, hypre_float *value );
HYPRE_ParCSRMatrix
GenerateLaplacian9pt_dbl( MPI_Comm comm, HYPRE_BigInt nx, HYPRE_BigInt ny, HYPRE_Int P, HYPRE_Int Q, HYPRE_Int p, HYPRE_Int q, hypre_double *value );
HYPRE_ParCSRMatrix
GenerateLaplacian9pt_long_dbl( MPI_Comm comm, HYPRE_BigInt nx, HYPRE_BigInt ny, HYPRE_Int P, HYPRE_Int Q, HYPRE_Int p, HYPRE_Int q, hypre_long_double *value );

HYPRE_ParCSRMatrix
GenerateRSVarDifConv_flt( MPI_Comm comm, HYPRE_BigInt nx, HYPRE_BigInt ny, HYPRE_BigInt nz, HYPRE_Int P, HYPRE_Int Q, HYPRE_Int R, HYPRE_Int p, HYPRE_Int q, HYPRE_Int r, hypre_float eps, HYPRE_ParVector *rhs_ptr, HYPRE_Int type );
HYPRE_ParCSRMatrix
GenerateRSVarDifConv_dbl( MPI_Comm comm, HYPRE_BigInt nx, HYPRE_BigInt ny, HYPRE_BigInt nz, HYPRE_Int P, HYPRE_Int Q, HYPRE_Int R, HYPRE_Int p, HYPRE_Int q, HYPRE_Int r, hypre_double eps, HYPRE_ParVector *rhs_ptr, HYPRE_Int type );
HYPRE_ParCSRMatrix
GenerateRSVarDifConv_long_dbl( MPI_Comm comm, HYPRE_BigInt nx, HYPRE_BigInt ny, HYPRE_BigInt nz, HYPRE_Int P, HYPRE_Int Q, HYPRE_Int R, HYPRE_Int p, HYPRE_Int q, HYPRE_Int r, hypre_long_double eps, HYPRE_ParVector *rhs_ptr, HYPRE_Int type );

HYPRE_ParCSRMatrix
GenerateRotate7pt_flt( MPI_Comm comm, HYPRE_BigInt nx, HYPRE_BigInt ny, HYPRE_Int P, HYPRE_Int Q, HYPRE_Int p, HYPRE_Int q, hypre_float alpha, hypre_float eps );
HYPRE_ParCSRMatrix
GenerateRotate7pt_dbl( MPI_Comm comm, HYPRE_BigInt nx, HYPRE_BigInt ny, HYPRE_Int P, HYPRE_Int Q, HYPRE_Int p, HYPRE_Int q, hypre_double alpha, hypre_double eps );
HYPRE_ParCSRMatrix
GenerateRotate7pt_long_dbl( MPI_Comm comm, HYPRE_BigInt nx, HYPRE_BigInt ny, HYPRE_Int P, HYPRE_Int Q, HYPRE_Int p, HYPRE_Int q, hypre_long_double alpha, hypre_long_double eps );

HYPRE_ParCSRMatrix
GenerateVarDifConv_flt( MPI_Comm comm, HYPRE_BigInt nx, HYPRE_BigInt ny, HYPRE_BigInt nz, HYPRE_Int P, HYPRE_Int Q, HYPRE_Int R, HYPRE_Int p, HYPRE_Int q, HYPRE_Int r, hypre_float eps, HYPRE_ParVector *rhs_ptr );
HYPRE_ParCSRMatrix
GenerateVarDifConv_dbl( MPI_Comm comm, HYPRE_BigInt nx, HYPRE_BigInt ny, HYPRE_BigInt nz, HYPRE_Int P, HYPRE_Int Q, HYPRE_Int R, HYPRE_Int p, HYPRE_Int q, HYPRE_Int r, hypre_double eps, HYPRE_ParVector *rhs_ptr );
HYPRE_ParCSRMatrix
GenerateVarDifConv_long_dbl( MPI_Comm comm, HYPRE_BigInt nx, HYPRE_BigInt ny, HYPRE_BigInt nz, HYPRE_Int P, HYPRE_Int Q, HYPRE_Int R, HYPRE_Int p, HYPRE_Int q, HYPRE_Int r, hypre_long_double eps, HYPRE_ParVector *rhs_ptr );

float*
hypre_GenerateCoordinates_flt( MPI_Comm comm, HYPRE_BigInt nx, HYPRE_BigInt ny, HYPRE_BigInt nz, HYPRE_Int P, HYPRE_Int Q, HYPRE_Int R, HYPRE_Int p, HYPRE_Int q, HYPRE_Int r, HYPRE_Int coorddim );
float*
hypre_GenerateCoordinates_dbl( MPI_Comm comm, HYPRE_BigInt nx, HYPRE_BigInt ny, HYPRE_BigInt nz, HYPRE_Int P, HYPRE_Int Q, HYPRE_Int R, HYPRE_Int p, HYPRE_Int q, HYPRE_Int r, HYPRE_Int coorddim );
float*
hypre_GenerateCoordinates_long_dbl( MPI_Comm comm, HYPRE_BigInt nx, HYPRE_BigInt ny, HYPRE_BigInt nz, HYPRE_Int P, HYPRE_Int Q, HYPRE_Int R, HYPRE_Int p, HYPRE_Int q, HYPRE_Int r, HYPRE_Int coorddim );


/*** DO NOT EDIT THIS FILE DIRECTLY (use ../config/gen_code.sh to generate) ***/

/******************************************************************************
 * Copyright (c) 1998 Lawrence Livermore National Security, LLC and other
 * HYPRE Project Developers. See the top-level COPYRIGHT file for details.
 *
 * SPDX-License-Identifier: (Apache-2.0 OR MIT)
 ******************************************************************************/


HYPRE_Int
HYPRE_ADSCreate_flt( HYPRE_Solver *solver );
HYPRE_Int
HYPRE_ADSCreate_dbl( HYPRE_Solver *solver );
HYPRE_Int
HYPRE_ADSCreate_long_dbl( HYPRE_Solver *solver );
HYPRE_Int
HYPRE_ADSCreate( HYPRE_Solver *solver );

HYPRE_Int
HYPRE_ADSDestroy_flt( HYPRE_Solver solver );
HYPRE_Int
HYPRE_ADSDestroy_dbl( HYPRE_Solver solver );
HYPRE_Int
HYPRE_ADSDestroy_long_dbl( HYPRE_Solver solver );
HYPRE_Int
HYPRE_ADSDestroy( HYPRE_Solver solver );

HYPRE_Int
HYPRE_ADSGetFinalRelativeResidualNorm_flt( HYPRE_Solver solver, hypre_float *rel_resid_norm );
HYPRE_Int
HYPRE_ADSGetFinalRelativeResidualNorm_dbl( HYPRE_Solver solver, hypre_double *rel_resid_norm );
HYPRE_Int
HYPRE_ADSGetFinalRelativeResidualNorm_long_dbl( HYPRE_Solver solver, hypre_long_double *rel_resid_norm );
HYPRE_Int
HYPRE_ADSGetFinalRelativeResidualNorm( HYPRE_Solver solver, void *rel_resid_norm );

HYPRE_Int
HYPRE_ADSGetNumIterations_flt( HYPRE_Solver solver, HYPRE_Int *num_iterations );
HYPRE_Int
HYPRE_ADSGetNumIterations_dbl( HYPRE_Solver solver, HYPRE_Int *num_iterations );
HYPRE_Int
HYPRE_ADSGetNumIterations_long_dbl( HYPRE_Solver solver, HYPRE_Int *num_iterations );
HYPRE_Int
HYPRE_ADSGetNumIterations( HYPRE_Solver solver, HYPRE_Int *num_iterations );

HYPRE_Int
HYPRE_ADSSetAMGOptions_flt( HYPRE_Solver solver, HYPRE_Int coarsen_type, HYPRE_Int agg_levels, HYPRE_Int relax_type, hypre_float strength_threshold, HYPRE_Int interp_type, HYPRE_Int Pmax );
HYPRE_Int
HYPRE_ADSSetAMGOptions_dbl( HYPRE_Solver solver, HYPRE_Int coarsen_type, HYPRE_Int agg_levels, HYPRE_Int relax_type, hypre_double strength_threshold, HYPRE_Int interp_type, HYPRE_Int Pmax );
HYPRE_Int
HYPRE_ADSSetAMGOptions_long_dbl( HYPRE_Solver solver, HYPRE_Int coarsen_type, HYPRE_Int agg_levels, HYPRE_Int relax_type, hypre_long_double strength_threshold, HYPRE_Int interp_type, HYPRE_Int Pmax );
HYPRE_Int
HYPRE_ADSSetAMGOptions( HYPRE_Solver solver, HYPRE_Int coarsen_type, HYPRE_Int agg_levels, HYPRE_Int relax_type, hypre_long_double strength_threshold, HYPRE_Int interp_type, HYPRE_Int Pmax );

HYPRE_Int
HYPRE_ADSSetAMSOptions_flt( HYPRE_Solver solver, HYPRE_Int cycle_type, HYPRE_Int coarsen_type, HYPRE_Int agg_levels, HYPRE_Int relax_type, hypre_float strength_threshold, HYPRE_Int interp_type, HYPRE_Int Pmax );
HYPRE_Int
HYPRE_ADSSetAMSOptions_dbl( HYPRE_Solver solver, HYPRE_Int cycle_type, HYPRE_Int coarsen_type, HYPRE_Int agg_levels, HYPRE_Int relax_type, hypre_double strength_threshold, HYPRE_Int interp_type, HYPRE_Int Pmax );
HYPRE_Int
HYPRE_ADSSetAMSOptions_long_dbl( HYPRE_Solver solver, HYPRE_Int cycle_type, HYPRE_Int coarsen_type, HYPRE_Int agg_levels, HYPRE_Int relax_type, hypre_long_double strength_threshold, HYPRE_Int interp_type, HYPRE_Int Pmax );
HYPRE_Int
HYPRE_ADSSetAMSOptions( HYPRE_Solver solver, HYPRE_Int cycle_type, HYPRE_Int coarsen_type, HYPRE_Int agg_levels, HYPRE_Int relax_type, hypre_long_double strength_threshold, HYPRE_Int interp_type, HYPRE_Int Pmax );

HYPRE_Int
HYPRE_ADSSetChebySmoothingOptions_flt( HYPRE_Solver solver, HYPRE_Int cheby_order, hypre_float cheby_fraction );
HYPRE_Int
HYPRE_ADSSetChebySmoothingOptions_dbl( HYPRE_Solver solver, HYPRE_Int cheby_order, hypre_double cheby_fraction );
HYPRE_Int
HYPRE_ADSSetChebySmoothingOptions_long_dbl( HYPRE_Solver solver, HYPRE_Int cheby_order, hypre_long_double cheby_fraction );
HYPRE_Int
HYPRE_ADSSetChebySmoothingOptions( HYPRE_Solver solver, HYPRE_Int cheby_order, hypre_long_double cheby_fraction );

HYPRE_Int
HYPRE_ADSSetCoordinateVectors_flt( HYPRE_Solver solver, HYPRE_ParVector x, HYPRE_ParVector y, HYPRE_ParVector z );
HYPRE_Int
HYPRE_ADSSetCoordinateVectors_dbl( HYPRE_Solver solver, HYPRE_ParVector x, HYPRE_ParVector y, HYPRE_ParVector z );
HYPRE_Int
HYPRE_ADSSetCoordinateVectors_long_dbl( HYPRE_Solver solver, HYPRE_ParVector x, HYPRE_ParVector y, HYPRE_ParVector z );
HYPRE_Int
HYPRE_ADSSetCoordinateVectors( HYPRE_Solver solver, HYPRE_ParVector x, HYPRE_ParVector y, HYPRE_ParVector z );

HYPRE_Int
HYPRE_ADSSetCycleType_flt( HYPRE_Solver solver, HYPRE_Int cycle_type );
HYPRE_Int
HYPRE_ADSSetCycleType_dbl( HYPRE_Solver solver, HYPRE_Int cycle_type );
HYPRE_Int
HYPRE_ADSSetCycleType_long_dbl( HYPRE_Solver solver, HYPRE_Int cycle_type );
HYPRE_Int
HYPRE_ADSSetCycleType( HYPRE_Solver solver, HYPRE_Int cycle_type );

HYPRE_Int
HYPRE_ADSSetDiscreteCurl_flt( HYPRE_Solver solver, HYPRE_ParCSRMatrix C );
HYPRE_Int
HYPRE_ADSSetDiscreteCurl_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix C );
HYPRE_Int
HYPRE_ADSSetDiscreteCurl_long_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix C );
HYPRE_Int
HYPRE_ADSSetDiscreteCurl( HYPRE_Solver solver, HYPRE_ParCSRMatrix C );

HYPRE_Int
HYPRE_ADSSetDiscreteGradient_flt( HYPRE_Solver solver, HYPRE_ParCSRMatrix G );
HYPRE_Int
HYPRE_ADSSetDiscreteGradient_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix G );
HYPRE_Int
HYPRE_ADSSetDiscreteGradient_long_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix G );
HYPRE_Int
HYPRE_ADSSetDiscreteGradient( HYPRE_Solver solver, HYPRE_ParCSRMatrix G );

HYPRE_Int
HYPRE_ADSSetInterpolations_flt( HYPRE_Solver solver, HYPRE_ParCSRMatrix RT_Pi, HYPRE_ParCSRMatrix RT_Pix, HYPRE_ParCSRMatrix RT_Piy, HYPRE_ParCSRMatrix RT_Piz, HYPRE_ParCSRMatrix ND_Pi, HYPRE_ParCSRMatrix ND_Pix, HYPRE_ParCSRMatrix ND_Piy, HYPRE_ParCSRMatrix ND_Piz );
HYPRE_Int
HYPRE_ADSSetInterpolations_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix RT_Pi, HYPRE_ParCSRMatrix RT_Pix, HYPRE_ParCSRMatrix RT_Piy, HYPRE_ParCSRMatrix RT_Piz, HYPRE_ParCSRMatrix ND_Pi, HYPRE_ParCSRMatrix ND_Pix, HYPRE_ParCSRMatrix ND_Piy, HYPRE_ParCSRMatrix ND_Piz );
HYPRE_Int
HYPRE_ADSSetInterpolations_long_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix RT_Pi, HYPRE_ParCSRMatrix RT_Pix, HYPRE_ParCSRMatrix RT_Piy, HYPRE_ParCSRMatrix RT_Piz, HYPRE_ParCSRMatrix ND_Pi, HYPRE_ParCSRMatrix ND_Pix, HYPRE_ParCSRMatrix ND_Piy, HYPRE_ParCSRMatrix ND_Piz );
HYPRE_Int
HYPRE_ADSSetInterpolations( HYPRE_Solver solver, HYPRE_ParCSRMatrix RT_Pi, HYPRE_ParCSRMatrix RT_Pix, HYPRE_ParCSRMatrix RT_Piy, HYPRE_ParCSRMatrix RT_Piz, HYPRE_ParCSRMatrix ND_Pi, HYPRE_ParCSRMatrix ND_Pix, HYPRE_ParCSRMatrix ND_Piy, HYPRE_ParCSRMatrix ND_Piz );

HYPRE_Int
HYPRE_ADSSetMaxIter_flt( HYPRE_Solver solver, HYPRE_Int maxit );
HYPRE_Int
HYPRE_ADSSetMaxIter_dbl( HYPRE_Solver solver, HYPRE_Int maxit );
HYPRE_Int
HYPRE_ADSSetMaxIter_long_dbl( HYPRE_Solver solver, HYPRE_Int maxit );
HYPRE_Int
HYPRE_ADSSetMaxIter( HYPRE_Solver solver, HYPRE_Int maxit );

HYPRE_Int
HYPRE_ADSSetPrintLevel_flt( HYPRE_Solver solver, HYPRE_Int print_level );
HYPRE_Int
HYPRE_ADSSetPrintLevel_dbl( HYPRE_Solver solver, HYPRE_Int print_level );
HYPRE_Int
HYPRE_ADSSetPrintLevel_long_dbl( HYPRE_Solver solver, HYPRE_Int print_level );
HYPRE_Int
HYPRE_ADSSetPrintLevel( HYPRE_Solver solver, HYPRE_Int print_level );

HYPRE_Int
HYPRE_ADSSetSmoothingOptions_flt( HYPRE_Solver solver, HYPRE_Int relax_type, HYPRE_Int relax_times, hypre_float relax_weight, hypre_float omega );
HYPRE_Int
HYPRE_ADSSetSmoothingOptions_dbl( HYPRE_Solver solver, HYPRE_Int relax_type, HYPRE_Int relax_times, hypre_double relax_weight, hypre_double omega );
HYPRE_Int
HYPRE_ADSSetSmoothingOptions_long_dbl( HYPRE_Solver solver, HYPRE_Int relax_type, HYPRE_Int relax_times, hypre_long_double relax_weight, hypre_long_double omega );
HYPRE_Int
HYPRE_ADSSetSmoothingOptions( HYPRE_Solver solver, HYPRE_Int relax_type, HYPRE_Int relax_times, hypre_long_double relax_weight, hypre_long_double omega );

HYPRE_Int
HYPRE_ADSSetTol_flt( HYPRE_Solver solver, hypre_float tol );
HYPRE_Int
HYPRE_ADSSetTol_dbl( HYPRE_Solver solver, hypre_double tol );
HYPRE_Int
HYPRE_ADSSetTol_long_dbl( HYPRE_Solver solver, hypre_long_double tol );
HYPRE_Int
HYPRE_ADSSetTol( HYPRE_Solver solver, hypre_long_double tol );

HYPRE_Int
HYPRE_ADSSetup_flt( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_ADSSetup_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_ADSSetup_long_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_ADSSetup( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );

HYPRE_Int
HYPRE_ADSSolve_flt( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_ADSSolve_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_ADSSolve_long_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_ADSSolve( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );

HYPRE_Int
HYPRE_AMECreate_flt( HYPRE_Solver *esolver );
HYPRE_Int
HYPRE_AMECreate_dbl( HYPRE_Solver *esolver );
HYPRE_Int
HYPRE_AMECreate_long_dbl( HYPRE_Solver *esolver );
HYPRE_Int
HYPRE_AMECreate( HYPRE_Solver *esolver );

HYPRE_Int
HYPRE_AMEDestroy_flt( HYPRE_Solver esolver );
HYPRE_Int
HYPRE_AMEDestroy_dbl( HYPRE_Solver esolver );
HYPRE_Int
HYPRE_AMEDestroy_long_dbl( HYPRE_Solver esolver );
HYPRE_Int
HYPRE_AMEDestroy( HYPRE_Solver esolver );

HYPRE_Int
HYPRE_AMEGetEigenvalues_flt( HYPRE_Solver esolver, hypre_float **eigenvalues );
HYPRE_Int
HYPRE_AMEGetEigenvalues_dbl( HYPRE_Solver esolver, hypre_double **eigenvalues );
HYPRE_Int
HYPRE_AMEGetEigenvalues_long_dbl( HYPRE_Solver esolver, hypre_long_double **eigenvalues );
HYPRE_Int
HYPRE_AMEGetEigenvalues( HYPRE_Solver esolver, void *eigenvalues );

HYPRE_Int
HYPRE_AMEGetEigenvectors_flt( HYPRE_Solver esolver, HYPRE_ParVector **eigenvectors );
HYPRE_Int
HYPRE_AMEGetEigenvectors_dbl( HYPRE_Solver esolver, HYPRE_ParVector **eigenvectors );
HYPRE_Int
HYPRE_AMEGetEigenvectors_long_dbl( HYPRE_Solver esolver, HYPRE_ParVector **eigenvectors );
HYPRE_Int
HYPRE_AMEGetEigenvectors( HYPRE_Solver esolver, HYPRE_ParVector **eigenvectors );

HYPRE_Int
HYPRE_AMESetAMSSolver_flt( HYPRE_Solver esolver, HYPRE_Solver ams_solver );
HYPRE_Int
HYPRE_AMESetAMSSolver_dbl( HYPRE_Solver esolver, HYPRE_Solver ams_solver );
HYPRE_Int
HYPRE_AMESetAMSSolver_long_dbl( HYPRE_Solver esolver, HYPRE_Solver ams_solver );
HYPRE_Int
HYPRE_AMESetAMSSolver( HYPRE_Solver esolver, HYPRE_Solver ams_solver );

HYPRE_Int
HYPRE_AMESetBlockSize_flt( HYPRE_Solver esolver, HYPRE_Int block_size );
HYPRE_Int
HYPRE_AMESetBlockSize_dbl( HYPRE_Solver esolver, HYPRE_Int block_size );
HYPRE_Int
HYPRE_AMESetBlockSize_long_dbl( HYPRE_Solver esolver, HYPRE_Int block_size );
HYPRE_Int
HYPRE_AMESetBlockSize( HYPRE_Solver esolver, HYPRE_Int block_size );

HYPRE_Int
HYPRE_AMESetMassMatrix_flt( HYPRE_Solver esolver, HYPRE_ParCSRMatrix M );
HYPRE_Int
HYPRE_AMESetMassMatrix_dbl( HYPRE_Solver esolver, HYPRE_ParCSRMatrix M );
HYPRE_Int
HYPRE_AMESetMassMatrix_long_dbl( HYPRE_Solver esolver, HYPRE_ParCSRMatrix M );
HYPRE_Int
HYPRE_AMESetMassMatrix( HYPRE_Solver esolver, HYPRE_ParCSRMatrix M );

HYPRE_Int
HYPRE_AMESetMaxIter_flt( HYPRE_Solver esolver, HYPRE_Int maxit );
HYPRE_Int
HYPRE_AMESetMaxIter_dbl( HYPRE_Solver esolver, HYPRE_Int maxit );
HYPRE_Int
HYPRE_AMESetMaxIter_long_dbl( HYPRE_Solver esolver, HYPRE_Int maxit );
HYPRE_Int
HYPRE_AMESetMaxIter( HYPRE_Solver esolver, HYPRE_Int maxit );

HYPRE_Int
HYPRE_AMESetMaxPCGIter_flt( HYPRE_Solver esolver, HYPRE_Int maxit );
HYPRE_Int
HYPRE_AMESetMaxPCGIter_dbl( HYPRE_Solver esolver, HYPRE_Int maxit );
HYPRE_Int
HYPRE_AMESetMaxPCGIter_long_dbl( HYPRE_Solver esolver, HYPRE_Int maxit );
HYPRE_Int
HYPRE_AMESetMaxPCGIter( HYPRE_Solver esolver, HYPRE_Int maxit );

HYPRE_Int
HYPRE_AMESetPrintLevel_flt( HYPRE_Solver esolver, HYPRE_Int print_level );
HYPRE_Int
HYPRE_AMESetPrintLevel_dbl( HYPRE_Solver esolver, HYPRE_Int print_level );
HYPRE_Int
HYPRE_AMESetPrintLevel_long_dbl( HYPRE_Solver esolver, HYPRE_Int print_level );
HYPRE_Int
HYPRE_AMESetPrintLevel( HYPRE_Solver esolver, HYPRE_Int print_level );

HYPRE_Int
HYPRE_AMESetRTol_flt( HYPRE_Solver esolver, hypre_float tol );
HYPRE_Int
HYPRE_AMESetRTol_dbl( HYPRE_Solver esolver, hypre_double tol );
HYPRE_Int
HYPRE_AMESetRTol_long_dbl( HYPRE_Solver esolver, hypre_long_double tol );
HYPRE_Int
HYPRE_AMESetRTol( HYPRE_Solver esolver, hypre_long_double tol );

HYPRE_Int
HYPRE_AMESetTol_flt( HYPRE_Solver esolver, hypre_float tol );
HYPRE_Int
HYPRE_AMESetTol_dbl( HYPRE_Solver esolver, hypre_double tol );
HYPRE_Int
HYPRE_AMESetTol_long_dbl( HYPRE_Solver esolver, hypre_long_double tol );
HYPRE_Int
HYPRE_AMESetTol( HYPRE_Solver esolver, hypre_long_double tol );

HYPRE_Int
HYPRE_AMESetup_flt( HYPRE_Solver esolver );
HYPRE_Int
HYPRE_AMESetup_dbl( HYPRE_Solver esolver );
HYPRE_Int
HYPRE_AMESetup_long_dbl( HYPRE_Solver esolver );
HYPRE_Int
HYPRE_AMESetup( HYPRE_Solver esolver );

HYPRE_Int
HYPRE_AMESolve_flt( HYPRE_Solver esolver );
HYPRE_Int
HYPRE_AMESolve_dbl( HYPRE_Solver esolver );
HYPRE_Int
HYPRE_AMESolve_long_dbl( HYPRE_Solver esolver );
HYPRE_Int
HYPRE_AMESolve( HYPRE_Solver esolver );

HYPRE_Int
HYPRE_AMSConstructDiscreteGradient_flt( HYPRE_ParCSRMatrix A, HYPRE_ParVector x_coord, HYPRE_BigInt *edge_vertex, HYPRE_Int edge_orientation, HYPRE_ParCSRMatrix *G );
HYPRE_Int
HYPRE_AMSConstructDiscreteGradient_dbl( HYPRE_ParCSRMatrix A, HYPRE_ParVector x_coord, HYPRE_BigInt *edge_vertex, HYPRE_Int edge_orientation, HYPRE_ParCSRMatrix *G );
HYPRE_Int
HYPRE_AMSConstructDiscreteGradient_long_dbl( HYPRE_ParCSRMatrix A, HYPRE_ParVector x_coord, HYPRE_BigInt *edge_vertex, HYPRE_Int edge_orientation, HYPRE_ParCSRMatrix *G );
HYPRE_Int
HYPRE_AMSConstructDiscreteGradient( HYPRE_ParCSRMatrix A, HYPRE_ParVector x_coord, HYPRE_BigInt *edge_vertex, HYPRE_Int edge_orientation, HYPRE_ParCSRMatrix *G );

HYPRE_Int
HYPRE_AMSCreate_flt( HYPRE_Solver *solver );
HYPRE_Int
HYPRE_AMSCreate_dbl( HYPRE_Solver *solver );
HYPRE_Int
HYPRE_AMSCreate_long_dbl( HYPRE_Solver *solver );
HYPRE_Int
HYPRE_AMSCreate( HYPRE_Solver *solver );

HYPRE_Int
HYPRE_AMSDestroy_flt( HYPRE_Solver solver );
HYPRE_Int
HYPRE_AMSDestroy_dbl( HYPRE_Solver solver );
HYPRE_Int
HYPRE_AMSDestroy_long_dbl( HYPRE_Solver solver );
HYPRE_Int
HYPRE_AMSDestroy( HYPRE_Solver solver );

HYPRE_Int
HYPRE_AMSGetFinalRelativeResidualNorm_flt( HYPRE_Solver solver, hypre_float *rel_resid_norm );
HYPRE_Int
HYPRE_AMSGetFinalRelativeResidualNorm_dbl( HYPRE_Solver solver, hypre_double *rel_resid_norm );
HYPRE_Int
HYPRE_AMSGetFinalRelativeResidualNorm_long_dbl( HYPRE_Solver solver, hypre_long_double *rel_resid_norm );
HYPRE_Int
HYPRE_AMSGetFinalRelativeResidualNorm( HYPRE_Solver solver, void *rel_resid_norm );

HYPRE_Int
HYPRE_AMSGetNumIterations_flt( HYPRE_Solver solver, HYPRE_Int *num_iterations );
HYPRE_Int
HYPRE_AMSGetNumIterations_dbl( HYPRE_Solver solver, HYPRE_Int *num_iterations );
HYPRE_Int
HYPRE_AMSGetNumIterations_long_dbl( HYPRE_Solver solver, HYPRE_Int *num_iterations );
HYPRE_Int
HYPRE_AMSGetNumIterations( HYPRE_Solver solver, HYPRE_Int *num_iterations );

HYPRE_Int
HYPRE_AMSProjectOutGradients_flt( HYPRE_Solver solver, HYPRE_ParVector x );
HYPRE_Int
HYPRE_AMSProjectOutGradients_dbl( HYPRE_Solver solver, HYPRE_ParVector x );
HYPRE_Int
HYPRE_AMSProjectOutGradients_long_dbl( HYPRE_Solver solver, HYPRE_ParVector x );
HYPRE_Int
HYPRE_AMSProjectOutGradients( HYPRE_Solver solver, HYPRE_ParVector x );

HYPRE_Int
HYPRE_AMSSetAlphaAMGCoarseRelaxType_flt( HYPRE_Solver solver, HYPRE_Int alpha_coarse_relax_type );
HYPRE_Int
HYPRE_AMSSetAlphaAMGCoarseRelaxType_dbl( HYPRE_Solver solver, HYPRE_Int alpha_coarse_relax_type );
HYPRE_Int
HYPRE_AMSSetAlphaAMGCoarseRelaxType_long_dbl( HYPRE_Solver solver, HYPRE_Int alpha_coarse_relax_type );
HYPRE_Int
HYPRE_AMSSetAlphaAMGCoarseRelaxType( HYPRE_Solver solver, HYPRE_Int alpha_coarse_relax_type );

HYPRE_Int
HYPRE_AMSSetAlphaAMGOptions_flt( HYPRE_Solver solver, HYPRE_Int alpha_coarsen_type, HYPRE_Int alpha_agg_levels, HYPRE_Int alpha_relax_type, hypre_float alpha_strength_threshold, HYPRE_Int alpha_interp_type, HYPRE_Int alpha_Pmax );
HYPRE_Int
HYPRE_AMSSetAlphaAMGOptions_dbl( HYPRE_Solver solver, HYPRE_Int alpha_coarsen_type, HYPRE_Int alpha_agg_levels, HYPRE_Int alpha_relax_type, hypre_double alpha_strength_threshold, HYPRE_Int alpha_interp_type, HYPRE_Int alpha_Pmax );
HYPRE_Int
HYPRE_AMSSetAlphaAMGOptions_long_dbl( HYPRE_Solver solver, HYPRE_Int alpha_coarsen_type, HYPRE_Int alpha_agg_levels, HYPRE_Int alpha_relax_type, hypre_long_double alpha_strength_threshold, HYPRE_Int alpha_interp_type, HYPRE_Int alpha_Pmax );
HYPRE_Int
HYPRE_AMSSetAlphaAMGOptions( HYPRE_Solver solver, HYPRE_Int alpha_coarsen_type, HYPRE_Int alpha_agg_levels, HYPRE_Int alpha_relax_type, hypre_long_double alpha_strength_threshold, HYPRE_Int alpha_interp_type, HYPRE_Int alpha_Pmax );

HYPRE_Int
HYPRE_AMSSetAlphaPoissonMatrix_flt( HYPRE_Solver solver, HYPRE_ParCSRMatrix A_alpha );
HYPRE_Int
HYPRE_AMSSetAlphaPoissonMatrix_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A_alpha );
HYPRE_Int
HYPRE_AMSSetAlphaPoissonMatrix_long_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A_alpha );
HYPRE_Int
HYPRE_AMSSetAlphaPoissonMatrix( HYPRE_Solver solver, HYPRE_ParCSRMatrix A_alpha );

HYPRE_Int
HYPRE_AMSSetBetaAMGCoarseRelaxType_flt( HYPRE_Solver solver, HYPRE_Int beta_coarse_relax_type );
HYPRE_Int
HYPRE_AMSSetBetaAMGCoarseRelaxType_dbl( HYPRE_Solver solver, HYPRE_Int beta_coarse_relax_type );
HYPRE_Int
HYPRE_AMSSetBetaAMGCoarseRelaxType_long_dbl( HYPRE_Solver solver, HYPRE_Int beta_coarse_relax_type );
HYPRE_Int
HYPRE_AMSSetBetaAMGCoarseRelaxType( HYPRE_Solver solver, HYPRE_Int beta_coarse_relax_type );

HYPRE_Int
HYPRE_AMSSetBetaAMGOptions_flt( HYPRE_Solver solver, HYPRE_Int beta_coarsen_type, HYPRE_Int beta_agg_levels, HYPRE_Int beta_relax_type, hypre_float beta_strength_threshold, HYPRE_Int beta_interp_type, HYPRE_Int beta_Pmax );
HYPRE_Int
HYPRE_AMSSetBetaAMGOptions_dbl( HYPRE_Solver solver, HYPRE_Int beta_coarsen_type, HYPRE_Int beta_agg_levels, HYPRE_Int beta_relax_type, hypre_double beta_strength_threshold, HYPRE_Int beta_interp_type, HYPRE_Int beta_Pmax );
HYPRE_Int
HYPRE_AMSSetBetaAMGOptions_long_dbl( HYPRE_Solver solver, HYPRE_Int beta_coarsen_type, HYPRE_Int beta_agg_levels, HYPRE_Int beta_relax_type, hypre_long_double beta_strength_threshold, HYPRE_Int beta_interp_type, HYPRE_Int beta_Pmax );
HYPRE_Int
HYPRE_AMSSetBetaAMGOptions( HYPRE_Solver solver, HYPRE_Int beta_coarsen_type, HYPRE_Int beta_agg_levels, HYPRE_Int beta_relax_type, hypre_long_double beta_strength_threshold, HYPRE_Int beta_interp_type, HYPRE_Int beta_Pmax );

HYPRE_Int
HYPRE_AMSSetBetaPoissonMatrix_flt( HYPRE_Solver solver, HYPRE_ParCSRMatrix A_beta );
HYPRE_Int
HYPRE_AMSSetBetaPoissonMatrix_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A_beta );
HYPRE_Int
HYPRE_AMSSetBetaPoissonMatrix_long_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A_beta );
HYPRE_Int
HYPRE_AMSSetBetaPoissonMatrix( HYPRE_Solver solver, HYPRE_ParCSRMatrix A_beta );

HYPRE_Int
HYPRE_AMSSetCoordinateVectors_flt( HYPRE_Solver solver, HYPRE_ParVector x, HYPRE_ParVector y, HYPRE_ParVector z );
HYPRE_Int
HYPRE_AMSSetCoordinateVectors_dbl( HYPRE_Solver solver, HYPRE_ParVector x, HYPRE_ParVector y, HYPRE_ParVector z );
HYPRE_Int
HYPRE_AMSSetCoordinateVectors_long_dbl( HYPRE_Solver solver, HYPRE_ParVector x, HYPRE_ParVector y, HYPRE_ParVector z );
HYPRE_Int
HYPRE_AMSSetCoordinateVectors( HYPRE_Solver solver, HYPRE_ParVector x, HYPRE_ParVector y, HYPRE_ParVector z );

HYPRE_Int
HYPRE_AMSSetCycleType_flt( HYPRE_Solver solver, HYPRE_Int cycle_type );
HYPRE_Int
HYPRE_AMSSetCycleType_dbl( HYPRE_Solver solver, HYPRE_Int cycle_type );
HYPRE_Int
HYPRE_AMSSetCycleType_long_dbl( HYPRE_Solver solver, HYPRE_Int cycle_type );
HYPRE_Int
HYPRE_AMSSetCycleType( HYPRE_Solver solver, HYPRE_Int cycle_type );

HYPRE_Int
HYPRE_AMSSetDimension_flt( HYPRE_Solver solver, HYPRE_Int dim );
HYPRE_Int
HYPRE_AMSSetDimension_dbl( HYPRE_Solver solver, HYPRE_Int dim );
HYPRE_Int
HYPRE_AMSSetDimension_long_dbl( HYPRE_Solver solver, HYPRE_Int dim );
HYPRE_Int
HYPRE_AMSSetDimension( HYPRE_Solver solver, HYPRE_Int dim );

HYPRE_Int
HYPRE_AMSSetDiscreteGradient_flt( HYPRE_Solver solver, HYPRE_ParCSRMatrix G );
HYPRE_Int
HYPRE_AMSSetDiscreteGradient_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix G );
HYPRE_Int
HYPRE_AMSSetDiscreteGradient_long_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix G );
HYPRE_Int
HYPRE_AMSSetDiscreteGradient( HYPRE_Solver solver, HYPRE_ParCSRMatrix G );

HYPRE_Int
HYPRE_AMSSetEdgeConstantVectors_flt( HYPRE_Solver solver, HYPRE_ParVector Gx, HYPRE_ParVector Gy, HYPRE_ParVector Gz );
HYPRE_Int
HYPRE_AMSSetEdgeConstantVectors_dbl( HYPRE_Solver solver, HYPRE_ParVector Gx, HYPRE_ParVector Gy, HYPRE_ParVector Gz );
HYPRE_Int
HYPRE_AMSSetEdgeConstantVectors_long_dbl( HYPRE_Solver solver, HYPRE_ParVector Gx, HYPRE_ParVector Gy, HYPRE_ParVector Gz );
HYPRE_Int
HYPRE_AMSSetEdgeConstantVectors( HYPRE_Solver solver, HYPRE_ParVector Gx, HYPRE_ParVector Gy, HYPRE_ParVector Gz );

HYPRE_Int
HYPRE_AMSSetInteriorNodes_flt( HYPRE_Solver solver, HYPRE_ParVector interior_nodes );
HYPRE_Int
HYPRE_AMSSetInteriorNodes_dbl( HYPRE_Solver solver, HYPRE_ParVector interior_nodes );
HYPRE_Int
HYPRE_AMSSetInteriorNodes_long_dbl( HYPRE_Solver solver, HYPRE_ParVector interior_nodes );
HYPRE_Int
HYPRE_AMSSetInteriorNodes( HYPRE_Solver solver, HYPRE_ParVector interior_nodes );

HYPRE_Int
HYPRE_AMSSetInterpolations_flt( HYPRE_Solver solver, HYPRE_ParCSRMatrix Pi, HYPRE_ParCSRMatrix Pix, HYPRE_ParCSRMatrix Piy, HYPRE_ParCSRMatrix Piz );
HYPRE_Int
HYPRE_AMSSetInterpolations_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix Pi, HYPRE_ParCSRMatrix Pix, HYPRE_ParCSRMatrix Piy, HYPRE_ParCSRMatrix Piz );
HYPRE_Int
HYPRE_AMSSetInterpolations_long_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix Pi, HYPRE_ParCSRMatrix Pix, HYPRE_ParCSRMatrix Piy, HYPRE_ParCSRMatrix Piz );
HYPRE_Int
HYPRE_AMSSetInterpolations( HYPRE_Solver solver, HYPRE_ParCSRMatrix Pi, HYPRE_ParCSRMatrix Pix, HYPRE_ParCSRMatrix Piy, HYPRE_ParCSRMatrix Piz );

HYPRE_Int
HYPRE_AMSSetMaxIter_flt( HYPRE_Solver solver, HYPRE_Int maxit );
HYPRE_Int
HYPRE_AMSSetMaxIter_dbl( HYPRE_Solver solver, HYPRE_Int maxit );
HYPRE_Int
HYPRE_AMSSetMaxIter_long_dbl( HYPRE_Solver solver, HYPRE_Int maxit );
HYPRE_Int
HYPRE_AMSSetMaxIter( HYPRE_Solver solver, HYPRE_Int maxit );

HYPRE_Int
HYPRE_AMSSetPrintLevel_flt( HYPRE_Solver solver, HYPRE_Int print_level );
HYPRE_Int
HYPRE_AMSSetPrintLevel_dbl( HYPRE_Solver solver, HYPRE_Int print_level );
HYPRE_Int
HYPRE_AMSSetPrintLevel_long_dbl( HYPRE_Solver solver, HYPRE_Int print_level );
HYPRE_Int
HYPRE_AMSSetPrintLevel( HYPRE_Solver solver, HYPRE_Int print_level );

HYPRE_Int
HYPRE_AMSSetProjectionFrequency_flt( HYPRE_Solver solver, HYPRE_Int projection_frequency );
HYPRE_Int
HYPRE_AMSSetProjectionFrequency_dbl( HYPRE_Solver solver, HYPRE_Int projection_frequency );
HYPRE_Int
HYPRE_AMSSetProjectionFrequency_long_dbl( HYPRE_Solver solver, HYPRE_Int projection_frequency );
HYPRE_Int
HYPRE_AMSSetProjectionFrequency( HYPRE_Solver solver, HYPRE_Int projection_frequency );

HYPRE_Int
HYPRE_AMSSetSmoothingOptions_flt( HYPRE_Solver solver, HYPRE_Int relax_type, HYPRE_Int relax_times, hypre_float relax_weight, hypre_float omega );
HYPRE_Int
HYPRE_AMSSetSmoothingOptions_dbl( HYPRE_Solver solver, HYPRE_Int relax_type, HYPRE_Int relax_times, hypre_double relax_weight, hypre_double omega );
HYPRE_Int
HYPRE_AMSSetSmoothingOptions_long_dbl( HYPRE_Solver solver, HYPRE_Int relax_type, HYPRE_Int relax_times, hypre_long_double relax_weight, hypre_long_double omega );
HYPRE_Int
HYPRE_AMSSetSmoothingOptions( HYPRE_Solver solver, HYPRE_Int relax_type, HYPRE_Int relax_times, hypre_long_double relax_weight, hypre_long_double omega );

HYPRE_Int
HYPRE_AMSSetTol_flt( HYPRE_Solver solver, hypre_float tol );
HYPRE_Int
HYPRE_AMSSetTol_dbl( HYPRE_Solver solver, hypre_double tol );
HYPRE_Int
HYPRE_AMSSetTol_long_dbl( HYPRE_Solver solver, hypre_long_double tol );
HYPRE_Int
HYPRE_AMSSetTol( HYPRE_Solver solver, hypre_long_double tol );

HYPRE_Int
HYPRE_AMSSetup_flt( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_AMSSetup_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_AMSSetup_long_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_AMSSetup( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );

HYPRE_Int
HYPRE_AMSSolve_flt( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_AMSSolve_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_AMSSolve_long_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_AMSSolve( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );

HYPRE_Int
HYPRE_BlockTridiagCreate_flt( HYPRE_Solver *solver );
HYPRE_Int
HYPRE_BlockTridiagCreate_dbl( HYPRE_Solver *solver );
HYPRE_Int
HYPRE_BlockTridiagCreate_long_dbl( HYPRE_Solver *solver );
HYPRE_Int
HYPRE_BlockTridiagCreate( HYPRE_Solver *solver );

HYPRE_Int
HYPRE_BlockTridiagDestroy_flt( HYPRE_Solver solver );
HYPRE_Int
HYPRE_BlockTridiagDestroy_dbl( HYPRE_Solver solver );
HYPRE_Int
HYPRE_BlockTridiagDestroy_long_dbl( HYPRE_Solver solver );
HYPRE_Int
HYPRE_BlockTridiagDestroy( HYPRE_Solver solver );

HYPRE_Int
HYPRE_BlockTridiagSetAMGNumSweeps_flt( HYPRE_Solver solver, HYPRE_Int num_sweeps );
HYPRE_Int
HYPRE_BlockTridiagSetAMGNumSweeps_dbl( HYPRE_Solver solver, HYPRE_Int num_sweeps );
HYPRE_Int
HYPRE_BlockTridiagSetAMGNumSweeps_long_dbl( HYPRE_Solver solver, HYPRE_Int num_sweeps );
HYPRE_Int
HYPRE_BlockTridiagSetAMGNumSweeps( HYPRE_Solver solver, HYPRE_Int num_sweeps );

HYPRE_Int
HYPRE_BlockTridiagSetAMGRelaxType_flt( HYPRE_Solver solver, HYPRE_Int relax_type );
HYPRE_Int
HYPRE_BlockTridiagSetAMGRelaxType_dbl( HYPRE_Solver solver, HYPRE_Int relax_type );
HYPRE_Int
HYPRE_BlockTridiagSetAMGRelaxType_long_dbl( HYPRE_Solver solver, HYPRE_Int relax_type );
HYPRE_Int
HYPRE_BlockTridiagSetAMGRelaxType( HYPRE_Solver solver, HYPRE_Int relax_type );

HYPRE_Int
HYPRE_BlockTridiagSetAMGStrengthThreshold_flt( HYPRE_Solver solver, hypre_float thresh );
HYPRE_Int
HYPRE_BlockTridiagSetAMGStrengthThreshold_dbl( HYPRE_Solver solver, hypre_double thresh );
HYPRE_Int
HYPRE_BlockTridiagSetAMGStrengthThreshold_long_dbl( HYPRE_Solver solver, hypre_long_double thresh );
HYPRE_Int
HYPRE_BlockTridiagSetAMGStrengthThreshold( HYPRE_Solver solver, hypre_long_double thresh );

HYPRE_Int
HYPRE_BlockTridiagSetIndexSet_flt( HYPRE_Solver solver, HYPRE_Int n, HYPRE_Int *inds );
HYPRE_Int
HYPRE_BlockTridiagSetIndexSet_dbl( HYPRE_Solver solver, HYPRE_Int n, HYPRE_Int *inds );
HYPRE_Int
HYPRE_BlockTridiagSetIndexSet_long_dbl( HYPRE_Solver solver, HYPRE_Int n, HYPRE_Int *inds );
HYPRE_Int
HYPRE_BlockTridiagSetIndexSet( HYPRE_Solver solver, HYPRE_Int n, HYPRE_Int *inds );

HYPRE_Int
HYPRE_BlockTridiagSetPrintLevel_flt( HYPRE_Solver solver, HYPRE_Int print_level );
HYPRE_Int
HYPRE_BlockTridiagSetPrintLevel_dbl( HYPRE_Solver solver, HYPRE_Int print_level );
HYPRE_Int
HYPRE_BlockTridiagSetPrintLevel_long_dbl( HYPRE_Solver solver, HYPRE_Int print_level );
HYPRE_Int
HYPRE_BlockTridiagSetPrintLevel( HYPRE_Solver solver, HYPRE_Int print_level );

HYPRE_Int
HYPRE_BlockTridiagSetup_flt( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_BlockTridiagSetup_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_BlockTridiagSetup_long_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_BlockTridiagSetup( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );

HYPRE_Int
HYPRE_BlockTridiagSolve_flt( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_BlockTridiagSolve_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_BlockTridiagSolve_long_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_BlockTridiagSolve( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );

HYPRE_Int
HYPRE_BoomerAMGCreate_flt( HYPRE_Solver *solver );
HYPRE_Int
HYPRE_BoomerAMGCreate_dbl( HYPRE_Solver *solver );
HYPRE_Int
HYPRE_BoomerAMGCreate_long_dbl( HYPRE_Solver *solver );
HYPRE_Int
HYPRE_BoomerAMGCreate( HYPRE_Solver *solver );

HYPRE_Int
HYPRE_BoomerAMGDDCreate_flt( HYPRE_Solver *solver );
HYPRE_Int
HYPRE_BoomerAMGDDCreate_dbl( HYPRE_Solver *solver );
HYPRE_Int
HYPRE_BoomerAMGDDCreate_long_dbl( HYPRE_Solver *solver );
HYPRE_Int
HYPRE_BoomerAMGDDCreate( HYPRE_Solver *solver );

HYPRE_Int
HYPRE_BoomerAMGDDDestroy_flt( HYPRE_Solver solver );
HYPRE_Int
HYPRE_BoomerAMGDDDestroy_dbl( HYPRE_Solver solver );
HYPRE_Int
HYPRE_BoomerAMGDDDestroy_long_dbl( HYPRE_Solver solver );
HYPRE_Int
HYPRE_BoomerAMGDDDestroy( HYPRE_Solver solver );

HYPRE_Int
HYPRE_BoomerAMGDDGetAMG_flt( HYPRE_Solver solver, HYPRE_Solver *amg_solver );
HYPRE_Int
HYPRE_BoomerAMGDDGetAMG_dbl( HYPRE_Solver solver, HYPRE_Solver *amg_solver );
HYPRE_Int
HYPRE_BoomerAMGDDGetAMG_long_dbl( HYPRE_Solver solver, HYPRE_Solver *amg_solver );
HYPRE_Int
HYPRE_BoomerAMGDDGetAMG( HYPRE_Solver solver, HYPRE_Solver *amg_solver );

HYPRE_Int
HYPRE_BoomerAMGDDGetFinalRelativeResidualNorm_flt( HYPRE_Solver solver, hypre_float *rel_resid_norm );
HYPRE_Int
HYPRE_BoomerAMGDDGetFinalRelativeResidualNorm_dbl( HYPRE_Solver solver, hypre_double *rel_resid_norm );
HYPRE_Int
HYPRE_BoomerAMGDDGetFinalRelativeResidualNorm_long_dbl( HYPRE_Solver solver, hypre_long_double *rel_resid_norm );
HYPRE_Int
HYPRE_BoomerAMGDDGetFinalRelativeResidualNorm( HYPRE_Solver solver, void *rel_resid_norm );

HYPRE_Int
HYPRE_BoomerAMGDDGetNumIterations_flt( HYPRE_Solver solver, HYPRE_Int *num_iterations );
HYPRE_Int
HYPRE_BoomerAMGDDGetNumIterations_dbl( HYPRE_Solver solver, HYPRE_Int *num_iterations );
HYPRE_Int
HYPRE_BoomerAMGDDGetNumIterations_long_dbl( HYPRE_Solver solver, HYPRE_Int *num_iterations );
HYPRE_Int
HYPRE_BoomerAMGDDGetNumIterations( HYPRE_Solver solver, HYPRE_Int *num_iterations );

HYPRE_Int
HYPRE_BoomerAMGDDSetFACCycleType_flt( HYPRE_Solver solver, HYPRE_Int amgdd_fac_cycle_type );
HYPRE_Int
HYPRE_BoomerAMGDDSetFACCycleType_dbl( HYPRE_Solver solver, HYPRE_Int amgdd_fac_cycle_type );
HYPRE_Int
HYPRE_BoomerAMGDDSetFACCycleType_long_dbl( HYPRE_Solver solver, HYPRE_Int amgdd_fac_cycle_type );
HYPRE_Int
HYPRE_BoomerAMGDDSetFACCycleType( HYPRE_Solver solver, HYPRE_Int amgdd_fac_cycle_type );

HYPRE_Int
HYPRE_BoomerAMGDDSetFACNumCycles_flt( HYPRE_Solver solver, HYPRE_Int amgdd_fac_num_cycles );
HYPRE_Int
HYPRE_BoomerAMGDDSetFACNumCycles_dbl( HYPRE_Solver solver, HYPRE_Int amgdd_fac_num_cycles );
HYPRE_Int
HYPRE_BoomerAMGDDSetFACNumCycles_long_dbl( HYPRE_Solver solver, HYPRE_Int amgdd_fac_num_cycles );
HYPRE_Int
HYPRE_BoomerAMGDDSetFACNumCycles( HYPRE_Solver solver, HYPRE_Int amgdd_fac_num_cycles );

HYPRE_Int
HYPRE_BoomerAMGDDSetFACNumRelax_flt( HYPRE_Solver solver, HYPRE_Int amgdd_fac_num_relax );
HYPRE_Int
HYPRE_BoomerAMGDDSetFACNumRelax_dbl( HYPRE_Solver solver, HYPRE_Int amgdd_fac_num_relax );
HYPRE_Int
HYPRE_BoomerAMGDDSetFACNumRelax_long_dbl( HYPRE_Solver solver, HYPRE_Int amgdd_fac_num_relax );
HYPRE_Int
HYPRE_BoomerAMGDDSetFACNumRelax( HYPRE_Solver solver, HYPRE_Int amgdd_fac_num_relax );

HYPRE_Int
HYPRE_BoomerAMGDDSetFACRelaxType_flt( HYPRE_Solver solver, HYPRE_Int amgdd_fac_relax_type );
HYPRE_Int
HYPRE_BoomerAMGDDSetFACRelaxType_dbl( HYPRE_Solver solver, HYPRE_Int amgdd_fac_relax_type );
HYPRE_Int
HYPRE_BoomerAMGDDSetFACRelaxType_long_dbl( HYPRE_Solver solver, HYPRE_Int amgdd_fac_relax_type );
HYPRE_Int
HYPRE_BoomerAMGDDSetFACRelaxType( HYPRE_Solver solver, HYPRE_Int amgdd_fac_relax_type );

HYPRE_Int
HYPRE_BoomerAMGDDSetFACRelaxWeight_flt( HYPRE_Solver solver, hypre_float amgdd_fac_relax_weight );
HYPRE_Int
HYPRE_BoomerAMGDDSetFACRelaxWeight_dbl( HYPRE_Solver solver, hypre_double amgdd_fac_relax_weight );
HYPRE_Int
HYPRE_BoomerAMGDDSetFACRelaxWeight_long_dbl( HYPRE_Solver solver, hypre_long_double amgdd_fac_relax_weight );
HYPRE_Int
HYPRE_BoomerAMGDDSetFACRelaxWeight( HYPRE_Solver solver, hypre_long_double amgdd_fac_relax_weight );

HYPRE_Int
HYPRE_BoomerAMGDDSetNumGhostLayers_flt( HYPRE_Solver solver, HYPRE_Int num_ghost_layers );
HYPRE_Int
HYPRE_BoomerAMGDDSetNumGhostLayers_dbl( HYPRE_Solver solver, HYPRE_Int num_ghost_layers );
HYPRE_Int
HYPRE_BoomerAMGDDSetNumGhostLayers_long_dbl( HYPRE_Solver solver, HYPRE_Int num_ghost_layers );
HYPRE_Int
HYPRE_BoomerAMGDDSetNumGhostLayers( HYPRE_Solver solver, HYPRE_Int num_ghost_layers );

HYPRE_Int
HYPRE_BoomerAMGDDSetPadding_flt( HYPRE_Solver solver, HYPRE_Int padding );
HYPRE_Int
HYPRE_BoomerAMGDDSetPadding_dbl( HYPRE_Solver solver, HYPRE_Int padding );
HYPRE_Int
HYPRE_BoomerAMGDDSetPadding_long_dbl( HYPRE_Solver solver, HYPRE_Int padding );
HYPRE_Int
HYPRE_BoomerAMGDDSetPadding( HYPRE_Solver solver, HYPRE_Int padding );

HYPRE_Int
HYPRE_BoomerAMGDDSetStartLevel_flt( HYPRE_Solver solver, HYPRE_Int start_level );
HYPRE_Int
HYPRE_BoomerAMGDDSetStartLevel_dbl( HYPRE_Solver solver, HYPRE_Int start_level );
HYPRE_Int
HYPRE_BoomerAMGDDSetStartLevel_long_dbl( HYPRE_Solver solver, HYPRE_Int start_level );
HYPRE_Int
HYPRE_BoomerAMGDDSetStartLevel( HYPRE_Solver solver, HYPRE_Int start_level );

HYPRE_Int
HYPRE_BoomerAMGDDSetup_flt( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_BoomerAMGDDSetup_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_BoomerAMGDDSetup_long_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_BoomerAMGDDSetup( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );

HYPRE_Int
HYPRE_BoomerAMGDDSolve_flt( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_BoomerAMGDDSolve_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_BoomerAMGDDSolve_long_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_BoomerAMGDDSolve( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );

HYPRE_Int
HYPRE_BoomerAMGDestroy_flt( HYPRE_Solver solver );
HYPRE_Int
HYPRE_BoomerAMGDestroy_dbl( HYPRE_Solver solver );
HYPRE_Int
HYPRE_BoomerAMGDestroy_long_dbl( HYPRE_Solver solver );
HYPRE_Int
HYPRE_BoomerAMGDestroy( HYPRE_Solver solver );

HYPRE_Int
HYPRE_BoomerAMGGetAdditive_flt( HYPRE_Solver solver, HYPRE_Int *additive );
HYPRE_Int
HYPRE_BoomerAMGGetAdditive_dbl( HYPRE_Solver solver, HYPRE_Int *additive );
HYPRE_Int
HYPRE_BoomerAMGGetAdditive_long_dbl( HYPRE_Solver solver, HYPRE_Int *additive );
HYPRE_Int
HYPRE_BoomerAMGGetAdditive( HYPRE_Solver solver, HYPRE_Int *additive );

HYPRE_Int
HYPRE_BoomerAMGGetCoarsenCutFactor_flt( HYPRE_Solver solver, HYPRE_Int *coarsen_cut_factor );
HYPRE_Int
HYPRE_BoomerAMGGetCoarsenCutFactor_dbl( HYPRE_Solver solver, HYPRE_Int *coarsen_cut_factor );
HYPRE_Int
HYPRE_BoomerAMGGetCoarsenCutFactor_long_dbl( HYPRE_Solver solver, HYPRE_Int *coarsen_cut_factor );
HYPRE_Int
HYPRE_BoomerAMGGetCoarsenCutFactor( HYPRE_Solver solver, HYPRE_Int *coarsen_cut_factor );

HYPRE_Int
HYPRE_BoomerAMGGetCoarsenType_flt( HYPRE_Solver solver, HYPRE_Int *coarsen_type );
HYPRE_Int
HYPRE_BoomerAMGGetCoarsenType_dbl( HYPRE_Solver solver, HYPRE_Int *coarsen_type );
HYPRE_Int
HYPRE_BoomerAMGGetCoarsenType_long_dbl( HYPRE_Solver solver, HYPRE_Int *coarsen_type );
HYPRE_Int
HYPRE_BoomerAMGGetCoarsenType( HYPRE_Solver solver, HYPRE_Int *coarsen_type );

HYPRE_Int
HYPRE_BoomerAMGGetConvergeType_flt( HYPRE_Solver solver, HYPRE_Int *type );
HYPRE_Int
HYPRE_BoomerAMGGetConvergeType_dbl( HYPRE_Solver solver, HYPRE_Int *type );
HYPRE_Int
HYPRE_BoomerAMGGetConvergeType_long_dbl( HYPRE_Solver solver, HYPRE_Int *type );
HYPRE_Int
HYPRE_BoomerAMGGetConvergeType( HYPRE_Solver solver, HYPRE_Int *type );

HYPRE_Int
HYPRE_BoomerAMGGetCumNnzAP_flt( HYPRE_Solver solver, hypre_float *cum_nnz_AP );
HYPRE_Int
HYPRE_BoomerAMGGetCumNnzAP_dbl( HYPRE_Solver solver, hypre_double *cum_nnz_AP );
HYPRE_Int
HYPRE_BoomerAMGGetCumNnzAP_long_dbl( HYPRE_Solver solver, hypre_long_double *cum_nnz_AP );
HYPRE_Int
HYPRE_BoomerAMGGetCumNnzAP( HYPRE_Solver solver, void *cum_nnz_AP );

HYPRE_Int
HYPRE_BoomerAMGGetCumNumIterations_flt( HYPRE_Solver solver, HYPRE_Int *cum_num_iterations );
HYPRE_Int
HYPRE_BoomerAMGGetCumNumIterations_dbl( HYPRE_Solver solver, HYPRE_Int *cum_num_iterations );
HYPRE_Int
HYPRE_BoomerAMGGetCumNumIterations_long_dbl( HYPRE_Solver solver, HYPRE_Int *cum_num_iterations );
HYPRE_Int
HYPRE_BoomerAMGGetCumNumIterations( HYPRE_Solver solver, HYPRE_Int *cum_num_iterations );

HYPRE_Int
HYPRE_BoomerAMGGetCycleNumSweeps_flt( HYPRE_Solver solver, HYPRE_Int *num_sweeps, HYPRE_Int k );
HYPRE_Int
HYPRE_BoomerAMGGetCycleNumSweeps_dbl( HYPRE_Solver solver, HYPRE_Int *num_sweeps, HYPRE_Int k );
HYPRE_Int
HYPRE_BoomerAMGGetCycleNumSweeps_long_dbl( HYPRE_Solver solver, HYPRE_Int *num_sweeps, HYPRE_Int k );
HYPRE_Int
HYPRE_BoomerAMGGetCycleNumSweeps( HYPRE_Solver solver, HYPRE_Int *num_sweeps, HYPRE_Int k );

HYPRE_Int
HYPRE_BoomerAMGGetCycleRelaxType_flt( HYPRE_Solver solver, HYPRE_Int *relax_type, HYPRE_Int k );
HYPRE_Int
HYPRE_BoomerAMGGetCycleRelaxType_dbl( HYPRE_Solver solver, HYPRE_Int *relax_type, HYPRE_Int k );
HYPRE_Int
HYPRE_BoomerAMGGetCycleRelaxType_long_dbl( HYPRE_Solver solver, HYPRE_Int *relax_type, HYPRE_Int k );
HYPRE_Int
HYPRE_BoomerAMGGetCycleRelaxType( HYPRE_Solver solver, HYPRE_Int *relax_type, HYPRE_Int k );

HYPRE_Int
HYPRE_BoomerAMGGetCycleType_flt( HYPRE_Solver solver, HYPRE_Int *cycle_type );
HYPRE_Int
HYPRE_BoomerAMGGetCycleType_dbl( HYPRE_Solver solver, HYPRE_Int *cycle_type );
HYPRE_Int
HYPRE_BoomerAMGGetCycleType_long_dbl( HYPRE_Solver solver, HYPRE_Int *cycle_type );
HYPRE_Int
HYPRE_BoomerAMGGetCycleType( HYPRE_Solver solver, HYPRE_Int *cycle_type );

HYPRE_Int
HYPRE_BoomerAMGGetDebugFlag_flt( HYPRE_Solver solver, HYPRE_Int *debug_flag );
HYPRE_Int
HYPRE_BoomerAMGGetDebugFlag_dbl( HYPRE_Solver solver, HYPRE_Int *debug_flag );
HYPRE_Int
HYPRE_BoomerAMGGetDebugFlag_long_dbl( HYPRE_Solver solver, HYPRE_Int *debug_flag );
HYPRE_Int
HYPRE_BoomerAMGGetDebugFlag( HYPRE_Solver solver, HYPRE_Int *debug_flag );

HYPRE_Int
HYPRE_BoomerAMGGetDomainType_flt( HYPRE_Solver solver, HYPRE_Int *domain_type );
HYPRE_Int
HYPRE_BoomerAMGGetDomainType_dbl( HYPRE_Solver solver, HYPRE_Int *domain_type );
HYPRE_Int
HYPRE_BoomerAMGGetDomainType_long_dbl( HYPRE_Solver solver, HYPRE_Int *domain_type );
HYPRE_Int
HYPRE_BoomerAMGGetDomainType( HYPRE_Solver solver, HYPRE_Int *domain_type );

HYPRE_Int
HYPRE_BoomerAMGGetFCycle_flt( HYPRE_Solver solver, HYPRE_Int *fcycle );
HYPRE_Int
HYPRE_BoomerAMGGetFCycle_dbl( HYPRE_Solver solver, HYPRE_Int *fcycle );
HYPRE_Int
HYPRE_BoomerAMGGetFCycle_long_dbl( HYPRE_Solver solver, HYPRE_Int *fcycle );
HYPRE_Int
HYPRE_BoomerAMGGetFCycle( HYPRE_Solver solver, HYPRE_Int *fcycle );

HYPRE_Int
HYPRE_BoomerAMGGetFilterFunctions_flt( HYPRE_Solver solver, HYPRE_Int *filter_functions );
HYPRE_Int
HYPRE_BoomerAMGGetFilterFunctions_dbl( HYPRE_Solver solver, HYPRE_Int *filter_functions );
HYPRE_Int
HYPRE_BoomerAMGGetFilterFunctions_long_dbl( HYPRE_Solver solver, HYPRE_Int *filter_functions );
HYPRE_Int
HYPRE_BoomerAMGGetFilterFunctions( HYPRE_Solver solver, HYPRE_Int *filter_functions );

HYPRE_Int
HYPRE_BoomerAMGGetFilterThresholdR_flt( HYPRE_Solver solver, hypre_float *filter_threshold );
HYPRE_Int
HYPRE_BoomerAMGGetFilterThresholdR_dbl( HYPRE_Solver solver, hypre_double *filter_threshold );
HYPRE_Int
HYPRE_BoomerAMGGetFilterThresholdR_long_dbl( HYPRE_Solver solver, hypre_long_double *filter_threshold );
HYPRE_Int
HYPRE_BoomerAMGGetFilterThresholdR( HYPRE_Solver solver, void *filter_threshold );

HYPRE_Int
HYPRE_BoomerAMGGetFinalRelativeResidualNorm_flt( HYPRE_Solver solver, hypre_float *rel_resid_norm );
HYPRE_Int
HYPRE_BoomerAMGGetFinalRelativeResidualNorm_dbl( HYPRE_Solver solver, hypre_double *rel_resid_norm );
HYPRE_Int
HYPRE_BoomerAMGGetFinalRelativeResidualNorm_long_dbl( HYPRE_Solver solver, hypre_long_double *rel_resid_norm );
HYPRE_Int
HYPRE_BoomerAMGGetFinalRelativeResidualNorm( HYPRE_Solver solver, void *rel_resid_norm );

HYPRE_Int
HYPRE_BoomerAMGGetGridHierarchy_flt( HYPRE_Solver solver, HYPRE_Int *cgrid );
HYPRE_Int
HYPRE_BoomerAMGGetGridHierarchy_dbl( HYPRE_Solver solver, HYPRE_Int *cgrid );
HYPRE_Int
HYPRE_BoomerAMGGetGridHierarchy_long_dbl( HYPRE_Solver solver, HYPRE_Int *cgrid );
HYPRE_Int
HYPRE_BoomerAMGGetGridHierarchy( HYPRE_Solver solver, HYPRE_Int *cgrid );

HYPRE_Int
HYPRE_BoomerAMGGetJacobiTruncThreshold_flt( HYPRE_Solver solver, hypre_float *jacobi_trunc_threshold );
HYPRE_Int
HYPRE_BoomerAMGGetJacobiTruncThreshold_dbl( HYPRE_Solver solver, hypre_double *jacobi_trunc_threshold );
HYPRE_Int
HYPRE_BoomerAMGGetJacobiTruncThreshold_long_dbl( HYPRE_Solver solver, hypre_long_double *jacobi_trunc_threshold );
HYPRE_Int
HYPRE_BoomerAMGGetJacobiTruncThreshold( HYPRE_Solver solver, void *jacobi_trunc_threshold );

HYPRE_Int
HYPRE_BoomerAMGGetLogging_flt( HYPRE_Solver solver, HYPRE_Int *logging );
HYPRE_Int
HYPRE_BoomerAMGGetLogging_dbl( HYPRE_Solver solver, HYPRE_Int *logging );
HYPRE_Int
HYPRE_BoomerAMGGetLogging_long_dbl( HYPRE_Solver solver, HYPRE_Int *logging );
HYPRE_Int
HYPRE_BoomerAMGGetLogging( HYPRE_Solver solver, HYPRE_Int *logging );

HYPRE_Int
HYPRE_BoomerAMGGetMaxCoarseSize_flt( HYPRE_Solver solver, HYPRE_Int *max_coarse_size );
HYPRE_Int
HYPRE_BoomerAMGGetMaxCoarseSize_dbl( HYPRE_Solver solver, HYPRE_Int *max_coarse_size );
HYPRE_Int
HYPRE_BoomerAMGGetMaxCoarseSize_long_dbl( HYPRE_Solver solver, HYPRE_Int *max_coarse_size );
HYPRE_Int
HYPRE_BoomerAMGGetMaxCoarseSize( HYPRE_Solver solver, HYPRE_Int *max_coarse_size );

HYPRE_Int
HYPRE_BoomerAMGGetMaxIter_flt( HYPRE_Solver solver, HYPRE_Int *max_iter );
HYPRE_Int
HYPRE_BoomerAMGGetMaxIter_dbl( HYPRE_Solver solver, HYPRE_Int *max_iter );
HYPRE_Int
HYPRE_BoomerAMGGetMaxIter_long_dbl( HYPRE_Solver solver, HYPRE_Int *max_iter );
HYPRE_Int
HYPRE_BoomerAMGGetMaxIter( HYPRE_Solver solver, HYPRE_Int *max_iter );

HYPRE_Int
HYPRE_BoomerAMGGetMaxLevels_flt( HYPRE_Solver solver, HYPRE_Int *max_levels );
HYPRE_Int
HYPRE_BoomerAMGGetMaxLevels_dbl( HYPRE_Solver solver, HYPRE_Int *max_levels );
HYPRE_Int
HYPRE_BoomerAMGGetMaxLevels_long_dbl( HYPRE_Solver solver, HYPRE_Int *max_levels );
HYPRE_Int
HYPRE_BoomerAMGGetMaxLevels( HYPRE_Solver solver, HYPRE_Int *max_levels );

HYPRE_Int
HYPRE_BoomerAMGGetMaxRowSum_flt( HYPRE_Solver solver, hypre_float *max_row_sum );
HYPRE_Int
HYPRE_BoomerAMGGetMaxRowSum_dbl( HYPRE_Solver solver, hypre_double *max_row_sum );
HYPRE_Int
HYPRE_BoomerAMGGetMaxRowSum_long_dbl( HYPRE_Solver solver, hypre_long_double *max_row_sum );
HYPRE_Int
HYPRE_BoomerAMGGetMaxRowSum( HYPRE_Solver solver, void *max_row_sum );

HYPRE_Int
HYPRE_BoomerAMGGetMeasureType_flt( HYPRE_Solver solver, HYPRE_Int *measure_type );
HYPRE_Int
HYPRE_BoomerAMGGetMeasureType_dbl( HYPRE_Solver solver, HYPRE_Int *measure_type );
HYPRE_Int
HYPRE_BoomerAMGGetMeasureType_long_dbl( HYPRE_Solver solver, HYPRE_Int *measure_type );
HYPRE_Int
HYPRE_BoomerAMGGetMeasureType( HYPRE_Solver solver, HYPRE_Int *measure_type );

HYPRE_Int
HYPRE_BoomerAMGGetMinCoarseSize_flt( HYPRE_Solver solver, HYPRE_Int *min_coarse_size );
HYPRE_Int
HYPRE_BoomerAMGGetMinCoarseSize_dbl( HYPRE_Solver solver, HYPRE_Int *min_coarse_size );
HYPRE_Int
HYPRE_BoomerAMGGetMinCoarseSize_long_dbl( HYPRE_Solver solver, HYPRE_Int *min_coarse_size );
HYPRE_Int
HYPRE_BoomerAMGGetMinCoarseSize( HYPRE_Solver solver, HYPRE_Int *min_coarse_size );

HYPRE_Int
HYPRE_BoomerAMGGetMultAdditive_flt( HYPRE_Solver solver, HYPRE_Int *mult_additive );
HYPRE_Int
HYPRE_BoomerAMGGetMultAdditive_dbl( HYPRE_Solver solver, HYPRE_Int *mult_additive );
HYPRE_Int
HYPRE_BoomerAMGGetMultAdditive_long_dbl( HYPRE_Solver solver, HYPRE_Int *mult_additive );
HYPRE_Int
HYPRE_BoomerAMGGetMultAdditive( HYPRE_Solver solver, HYPRE_Int *mult_additive );

HYPRE_Int
HYPRE_BoomerAMGGetNumFunctions_flt( HYPRE_Solver solver, HYPRE_Int *num_functions );
HYPRE_Int
HYPRE_BoomerAMGGetNumFunctions_dbl( HYPRE_Solver solver, HYPRE_Int *num_functions );
HYPRE_Int
HYPRE_BoomerAMGGetNumFunctions_long_dbl( HYPRE_Solver solver, HYPRE_Int *num_functions );
HYPRE_Int
HYPRE_BoomerAMGGetNumFunctions( HYPRE_Solver solver, HYPRE_Int *num_functions );

HYPRE_Int
HYPRE_BoomerAMGGetNumIterations_flt( HYPRE_Solver solver, HYPRE_Int *num_iterations );
HYPRE_Int
HYPRE_BoomerAMGGetNumIterations_dbl( HYPRE_Solver solver, HYPRE_Int *num_iterations );
HYPRE_Int
HYPRE_BoomerAMGGetNumIterations_long_dbl( HYPRE_Solver solver, HYPRE_Int *num_iterations );
HYPRE_Int
HYPRE_BoomerAMGGetNumIterations( HYPRE_Solver solver, HYPRE_Int *num_iterations );

HYPRE_Int
HYPRE_BoomerAMGGetOverlap_flt( HYPRE_Solver solver, HYPRE_Int *overlap );
HYPRE_Int
HYPRE_BoomerAMGGetOverlap_dbl( HYPRE_Solver solver, HYPRE_Int *overlap );
HYPRE_Int
HYPRE_BoomerAMGGetOverlap_long_dbl( HYPRE_Solver solver, HYPRE_Int *overlap );
HYPRE_Int
HYPRE_BoomerAMGGetOverlap( HYPRE_Solver solver, HYPRE_Int *overlap );

HYPRE_Int
HYPRE_BoomerAMGGetPMaxElmts_flt( HYPRE_Solver solver, HYPRE_Int *P_max_elmts );
HYPRE_Int
HYPRE_BoomerAMGGetPMaxElmts_dbl( HYPRE_Solver solver, HYPRE_Int *P_max_elmts );
HYPRE_Int
HYPRE_BoomerAMGGetPMaxElmts_long_dbl( HYPRE_Solver solver, HYPRE_Int *P_max_elmts );
HYPRE_Int
HYPRE_BoomerAMGGetPMaxElmts( HYPRE_Solver solver, HYPRE_Int *P_max_elmts );

HYPRE_Int
HYPRE_BoomerAMGGetPostInterpType_flt( HYPRE_Solver solver, HYPRE_Int *post_interp_type );
HYPRE_Int
HYPRE_BoomerAMGGetPostInterpType_dbl( HYPRE_Solver solver, HYPRE_Int *post_interp_type );
HYPRE_Int
HYPRE_BoomerAMGGetPostInterpType_long_dbl( HYPRE_Solver solver, HYPRE_Int *post_interp_type );
HYPRE_Int
HYPRE_BoomerAMGGetPostInterpType( HYPRE_Solver solver, HYPRE_Int *post_interp_type );

HYPRE_Int
HYPRE_BoomerAMGGetPrintLevel_flt( HYPRE_Solver solver, HYPRE_Int *print_level );
HYPRE_Int
HYPRE_BoomerAMGGetPrintLevel_dbl( HYPRE_Solver solver, HYPRE_Int *print_level );
HYPRE_Int
HYPRE_BoomerAMGGetPrintLevel_long_dbl( HYPRE_Solver solver, HYPRE_Int *print_level );
HYPRE_Int
HYPRE_BoomerAMGGetPrintLevel( HYPRE_Solver solver, HYPRE_Int *print_level );

HYPRE_Int
HYPRE_BoomerAMGGetRedundant_flt( HYPRE_Solver solver, HYPRE_Int *redundant );
HYPRE_Int
HYPRE_BoomerAMGGetRedundant_dbl( HYPRE_Solver solver, HYPRE_Int *redundant );
HYPRE_Int
HYPRE_BoomerAMGGetRedundant_long_dbl( HYPRE_Solver solver, HYPRE_Int *redundant );
HYPRE_Int
HYPRE_BoomerAMGGetRedundant( HYPRE_Solver solver, HYPRE_Int *redundant );

HYPRE_Int
HYPRE_BoomerAMGGetResidual_flt( HYPRE_Solver solver, HYPRE_ParVector *residual );
HYPRE_Int
HYPRE_BoomerAMGGetResidual_dbl( HYPRE_Solver solver, HYPRE_ParVector *residual );
HYPRE_Int
HYPRE_BoomerAMGGetResidual_long_dbl( HYPRE_Solver solver, HYPRE_ParVector *residual );
HYPRE_Int
HYPRE_BoomerAMGGetResidual( HYPRE_Solver solver, HYPRE_ParVector *residual );

HYPRE_Int
HYPRE_BoomerAMGGetSchwarzRlxWeight_flt( HYPRE_Solver solver, hypre_float *schwarz_rlx_weight );
HYPRE_Int
HYPRE_BoomerAMGGetSchwarzRlxWeight_dbl( HYPRE_Solver solver, hypre_double *schwarz_rlx_weight );
HYPRE_Int
HYPRE_BoomerAMGGetSchwarzRlxWeight_long_dbl( HYPRE_Solver solver, hypre_long_double *schwarz_rlx_weight );
HYPRE_Int
HYPRE_BoomerAMGGetSchwarzRlxWeight( HYPRE_Solver solver, void *schwarz_rlx_weight );

HYPRE_Int
HYPRE_BoomerAMGGetSeqThreshold_flt( HYPRE_Solver solver, HYPRE_Int *seq_threshold );
HYPRE_Int
HYPRE_BoomerAMGGetSeqThreshold_dbl( HYPRE_Solver solver, HYPRE_Int *seq_threshold );
HYPRE_Int
HYPRE_BoomerAMGGetSeqThreshold_long_dbl( HYPRE_Solver solver, HYPRE_Int *seq_threshold );
HYPRE_Int
HYPRE_BoomerAMGGetSeqThreshold( HYPRE_Solver solver, HYPRE_Int *seq_threshold );

HYPRE_Int
HYPRE_BoomerAMGGetSimple_flt( HYPRE_Solver solver, HYPRE_Int *simple );
HYPRE_Int
HYPRE_BoomerAMGGetSimple_dbl( HYPRE_Solver solver, HYPRE_Int *simple );
HYPRE_Int
HYPRE_BoomerAMGGetSimple_long_dbl( HYPRE_Solver solver, HYPRE_Int *simple );
HYPRE_Int
HYPRE_BoomerAMGGetSimple( HYPRE_Solver solver, HYPRE_Int *simple );

HYPRE_Int
HYPRE_BoomerAMGGetSmoothNumLevels_flt( HYPRE_Solver solver, HYPRE_Int *smooth_num_levels );
HYPRE_Int
HYPRE_BoomerAMGGetSmoothNumLevels_dbl( HYPRE_Solver solver, HYPRE_Int *smooth_num_levels );
HYPRE_Int
HYPRE_BoomerAMGGetSmoothNumLevels_long_dbl( HYPRE_Solver solver, HYPRE_Int *smooth_num_levels );
HYPRE_Int
HYPRE_BoomerAMGGetSmoothNumLevels( HYPRE_Solver solver, HYPRE_Int *smooth_num_levels );

HYPRE_Int
HYPRE_BoomerAMGGetSmoothNumSweeps_flt( HYPRE_Solver solver, HYPRE_Int *smooth_num_sweeps );
HYPRE_Int
HYPRE_BoomerAMGGetSmoothNumSweeps_dbl( HYPRE_Solver solver, HYPRE_Int *smooth_num_sweeps );
HYPRE_Int
HYPRE_BoomerAMGGetSmoothNumSweeps_long_dbl( HYPRE_Solver solver, HYPRE_Int *smooth_num_sweeps );
HYPRE_Int
HYPRE_BoomerAMGGetSmoothNumSweeps( HYPRE_Solver solver, HYPRE_Int *smooth_num_sweeps );

HYPRE_Int
HYPRE_BoomerAMGGetSmoothType_flt( HYPRE_Solver solver, HYPRE_Int *smooth_type );
HYPRE_Int
HYPRE_BoomerAMGGetSmoothType_dbl( HYPRE_Solver solver, HYPRE_Int *smooth_type );
HYPRE_Int
HYPRE_BoomerAMGGetSmoothType_long_dbl( HYPRE_Solver solver, HYPRE_Int *smooth_type );
HYPRE_Int
HYPRE_BoomerAMGGetSmoothType( HYPRE_Solver solver, HYPRE_Int *smooth_type );

HYPRE_Int
HYPRE_BoomerAMGGetStrongThreshold_flt( HYPRE_Solver solver, hypre_float *strong_threshold );
HYPRE_Int
HYPRE_BoomerAMGGetStrongThreshold_dbl( HYPRE_Solver solver, hypre_double *strong_threshold );
HYPRE_Int
HYPRE_BoomerAMGGetStrongThreshold_long_dbl( HYPRE_Solver solver, hypre_long_double *strong_threshold );
HYPRE_Int
HYPRE_BoomerAMGGetStrongThreshold( HYPRE_Solver solver, void *strong_threshold );

HYPRE_Int
HYPRE_BoomerAMGGetStrongThresholdR_flt( HYPRE_Solver solver, hypre_float *strong_threshold );
HYPRE_Int
HYPRE_BoomerAMGGetStrongThresholdR_dbl( HYPRE_Solver solver, hypre_double *strong_threshold );
HYPRE_Int
HYPRE_BoomerAMGGetStrongThresholdR_long_dbl( HYPRE_Solver solver, hypre_long_double *strong_threshold );
HYPRE_Int
HYPRE_BoomerAMGGetStrongThresholdR( HYPRE_Solver solver, void *strong_threshold );

HYPRE_Int
HYPRE_BoomerAMGGetTol_flt( HYPRE_Solver solver, hypre_float *tol );
HYPRE_Int
HYPRE_BoomerAMGGetTol_dbl( HYPRE_Solver solver, hypre_double *tol );
HYPRE_Int
HYPRE_BoomerAMGGetTol_long_dbl( HYPRE_Solver solver, hypre_long_double *tol );
HYPRE_Int
HYPRE_BoomerAMGGetTol( HYPRE_Solver solver, void *tol );

HYPRE_Int
HYPRE_BoomerAMGGetTruncFactor_flt( HYPRE_Solver solver, hypre_float *trunc_factor );
HYPRE_Int
HYPRE_BoomerAMGGetTruncFactor_dbl( HYPRE_Solver solver, hypre_double *trunc_factor );
HYPRE_Int
HYPRE_BoomerAMGGetTruncFactor_long_dbl( HYPRE_Solver solver, hypre_long_double *trunc_factor );
HYPRE_Int
HYPRE_BoomerAMGGetTruncFactor( HYPRE_Solver solver, void *trunc_factor );

HYPRE_Int
HYPRE_BoomerAMGGetVariant_flt( HYPRE_Solver solver, HYPRE_Int *variant );
HYPRE_Int
HYPRE_BoomerAMGGetVariant_dbl( HYPRE_Solver solver, HYPRE_Int *variant );
HYPRE_Int
HYPRE_BoomerAMGGetVariant_long_dbl( HYPRE_Solver solver, HYPRE_Int *variant );
HYPRE_Int
HYPRE_BoomerAMGGetVariant( HYPRE_Solver solver, HYPRE_Int *variant );

HYPRE_Int
HYPRE_BoomerAMGInitGridRelaxation_flt( HYPRE_Int **num_grid_sweeps_ptr, HYPRE_Int **grid_relax_type_ptr, HYPRE_Int ***grid_relax_points_ptr, HYPRE_Int coarsen_type, hypre_float **relax_weights_ptr, HYPRE_Int max_levels );
HYPRE_Int
HYPRE_BoomerAMGInitGridRelaxation_dbl( HYPRE_Int **num_grid_sweeps_ptr, HYPRE_Int **grid_relax_type_ptr, HYPRE_Int ***grid_relax_points_ptr, HYPRE_Int coarsen_type, hypre_double **relax_weights_ptr, HYPRE_Int max_levels );
HYPRE_Int
HYPRE_BoomerAMGInitGridRelaxation_long_dbl( HYPRE_Int **num_grid_sweeps_ptr, HYPRE_Int **grid_relax_type_ptr, HYPRE_Int ***grid_relax_points_ptr, HYPRE_Int coarsen_type, hypre_long_double **relax_weights_ptr, HYPRE_Int max_levels );
HYPRE_Int
HYPRE_BoomerAMGInitGridRelaxation( HYPRE_Int **num_grid_sweeps_ptr, HYPRE_Int **grid_relax_type_ptr, HYPRE_Int ***grid_relax_points_ptr, HYPRE_Int coarsen_type, void *relax_weights_ptr, HYPRE_Int max_levels );

HYPRE_Int
HYPRE_BoomerAMGSetADropTol_flt( HYPRE_Solver solver, hypre_float A_drop_tol );
HYPRE_Int
HYPRE_BoomerAMGSetADropTol_dbl( HYPRE_Solver solver, hypre_double A_drop_tol );
HYPRE_Int
HYPRE_BoomerAMGSetADropTol_long_dbl( HYPRE_Solver solver, hypre_long_double A_drop_tol );
HYPRE_Int
HYPRE_BoomerAMGSetADropTol( HYPRE_Solver solver, hypre_long_double A_drop_tol );

HYPRE_Int
HYPRE_BoomerAMGSetADropType_flt( HYPRE_Solver solver, HYPRE_Int A_drop_type );
HYPRE_Int
HYPRE_BoomerAMGSetADropType_dbl( HYPRE_Solver solver, HYPRE_Int A_drop_type );
HYPRE_Int
HYPRE_BoomerAMGSetADropType_long_dbl( HYPRE_Solver solver, HYPRE_Int A_drop_type );
HYPRE_Int
HYPRE_BoomerAMGSetADropType( HYPRE_Solver solver, HYPRE_Int A_drop_type );

HYPRE_Int
HYPRE_BoomerAMGSetAddLastLvl_flt( HYPRE_Solver solver, HYPRE_Int add_last_lvl );
HYPRE_Int
HYPRE_BoomerAMGSetAddLastLvl_dbl( HYPRE_Solver solver, HYPRE_Int add_last_lvl );
HYPRE_Int
HYPRE_BoomerAMGSetAddLastLvl_long_dbl( HYPRE_Solver solver, HYPRE_Int add_last_lvl );
HYPRE_Int
HYPRE_BoomerAMGSetAddLastLvl( HYPRE_Solver solver, HYPRE_Int add_last_lvl );

HYPRE_Int
HYPRE_BoomerAMGSetAddPMaxElmts_flt( HYPRE_Solver solver, HYPRE_Int add_P_max_elmts );
HYPRE_Int
HYPRE_BoomerAMGSetAddPMaxElmts_dbl( HYPRE_Solver solver, HYPRE_Int add_P_max_elmts );
HYPRE_Int
HYPRE_BoomerAMGSetAddPMaxElmts_long_dbl( HYPRE_Solver solver, HYPRE_Int add_P_max_elmts );
HYPRE_Int
HYPRE_BoomerAMGSetAddPMaxElmts( HYPRE_Solver solver, HYPRE_Int add_P_max_elmts );

HYPRE_Int
HYPRE_BoomerAMGSetAddRelaxType_flt( HYPRE_Solver solver, HYPRE_Int add_rlx_type );
HYPRE_Int
HYPRE_BoomerAMGSetAddRelaxType_dbl( HYPRE_Solver solver, HYPRE_Int add_rlx_type );
HYPRE_Int
HYPRE_BoomerAMGSetAddRelaxType_long_dbl( HYPRE_Solver solver, HYPRE_Int add_rlx_type );
HYPRE_Int
HYPRE_BoomerAMGSetAddRelaxType( HYPRE_Solver solver, HYPRE_Int add_rlx_type );

HYPRE_Int
HYPRE_BoomerAMGSetAddRelaxWt_flt( HYPRE_Solver solver, hypre_float add_rlx_wt );
HYPRE_Int
HYPRE_BoomerAMGSetAddRelaxWt_dbl( HYPRE_Solver solver, hypre_double add_rlx_wt );
HYPRE_Int
HYPRE_BoomerAMGSetAddRelaxWt_long_dbl( HYPRE_Solver solver, hypre_long_double add_rlx_wt );
HYPRE_Int
HYPRE_BoomerAMGSetAddRelaxWt( HYPRE_Solver solver, hypre_long_double add_rlx_wt );

HYPRE_Int
HYPRE_BoomerAMGSetAddTruncFactor_flt( HYPRE_Solver solver, hypre_float add_trunc_factor );
HYPRE_Int
HYPRE_BoomerAMGSetAddTruncFactor_dbl( HYPRE_Solver solver, hypre_double add_trunc_factor );
HYPRE_Int
HYPRE_BoomerAMGSetAddTruncFactor_long_dbl( HYPRE_Solver solver, hypre_long_double add_trunc_factor );
HYPRE_Int
HYPRE_BoomerAMGSetAddTruncFactor( HYPRE_Solver solver, hypre_long_double add_trunc_factor );

HYPRE_Int
HYPRE_BoomerAMGSetAdditive_flt( HYPRE_Solver solver, HYPRE_Int addlvl );
HYPRE_Int
HYPRE_BoomerAMGSetAdditive_dbl( HYPRE_Solver solver, HYPRE_Int addlvl );
HYPRE_Int
HYPRE_BoomerAMGSetAdditive_long_dbl( HYPRE_Solver solver, HYPRE_Int addlvl );
HYPRE_Int
HYPRE_BoomerAMGSetAdditive( HYPRE_Solver solver, HYPRE_Int addlvl );

HYPRE_Int
HYPRE_BoomerAMGSetAggInterpType_flt( HYPRE_Solver solver, HYPRE_Int agg_interp_type );
HYPRE_Int
HYPRE_BoomerAMGSetAggInterpType_dbl( HYPRE_Solver solver, HYPRE_Int agg_interp_type );
HYPRE_Int
HYPRE_BoomerAMGSetAggInterpType_long_dbl( HYPRE_Solver solver, HYPRE_Int agg_interp_type );
HYPRE_Int
HYPRE_BoomerAMGSetAggInterpType( HYPRE_Solver solver, HYPRE_Int agg_interp_type );

HYPRE_Int
HYPRE_BoomerAMGSetAggNumLevels_flt( HYPRE_Solver solver, HYPRE_Int agg_num_levels );
HYPRE_Int
HYPRE_BoomerAMGSetAggNumLevels_dbl( HYPRE_Solver solver, HYPRE_Int agg_num_levels );
HYPRE_Int
HYPRE_BoomerAMGSetAggNumLevels_long_dbl( HYPRE_Solver solver, HYPRE_Int agg_num_levels );
HYPRE_Int
HYPRE_BoomerAMGSetAggNumLevels( HYPRE_Solver solver, HYPRE_Int agg_num_levels );

HYPRE_Int
HYPRE_BoomerAMGSetAggP12MaxElmts_flt( HYPRE_Solver solver, HYPRE_Int agg_P12_max_elmts );
HYPRE_Int
HYPRE_BoomerAMGSetAggP12MaxElmts_dbl( HYPRE_Solver solver, HYPRE_Int agg_P12_max_elmts );
HYPRE_Int
HYPRE_BoomerAMGSetAggP12MaxElmts_long_dbl( HYPRE_Solver solver, HYPRE_Int agg_P12_max_elmts );
HYPRE_Int
HYPRE_BoomerAMGSetAggP12MaxElmts( HYPRE_Solver solver, HYPRE_Int agg_P12_max_elmts );

HYPRE_Int
HYPRE_BoomerAMGSetAggP12TruncFactor_flt( HYPRE_Solver solver, hypre_float agg_P12_trunc_factor );
HYPRE_Int
HYPRE_BoomerAMGSetAggP12TruncFactor_dbl( HYPRE_Solver solver, hypre_double agg_P12_trunc_factor );
HYPRE_Int
HYPRE_BoomerAMGSetAggP12TruncFactor_long_dbl( HYPRE_Solver solver, hypre_long_double agg_P12_trunc_factor );
HYPRE_Int
HYPRE_BoomerAMGSetAggP12TruncFactor( HYPRE_Solver solver, hypre_long_double agg_P12_trunc_factor );

HYPRE_Int
HYPRE_BoomerAMGSetAggPMaxElmts_flt( HYPRE_Solver solver, HYPRE_Int agg_P_max_elmts );
HYPRE_Int
HYPRE_BoomerAMGSetAggPMaxElmts_dbl( HYPRE_Solver solver, HYPRE_Int agg_P_max_elmts );
HYPRE_Int
HYPRE_BoomerAMGSetAggPMaxElmts_long_dbl( HYPRE_Solver solver, HYPRE_Int agg_P_max_elmts );
HYPRE_Int
HYPRE_BoomerAMGSetAggPMaxElmts( HYPRE_Solver solver, HYPRE_Int agg_P_max_elmts );

HYPRE_Int
HYPRE_BoomerAMGSetAggTruncFactor_flt( HYPRE_Solver solver, hypre_float agg_trunc_factor );
HYPRE_Int
HYPRE_BoomerAMGSetAggTruncFactor_dbl( HYPRE_Solver solver, hypre_double agg_trunc_factor );
HYPRE_Int
HYPRE_BoomerAMGSetAggTruncFactor_long_dbl( HYPRE_Solver solver, hypre_long_double agg_trunc_factor );
HYPRE_Int
HYPRE_BoomerAMGSetAggTruncFactor( HYPRE_Solver solver, hypre_long_double agg_trunc_factor );

HYPRE_Int
HYPRE_BoomerAMGSetCGCIts_flt( HYPRE_Solver solver, HYPRE_Int its );
HYPRE_Int
HYPRE_BoomerAMGSetCGCIts_dbl( HYPRE_Solver solver, HYPRE_Int its );
HYPRE_Int
HYPRE_BoomerAMGSetCGCIts_long_dbl( HYPRE_Solver solver, HYPRE_Int its );
HYPRE_Int
HYPRE_BoomerAMGSetCGCIts( HYPRE_Solver solver, HYPRE_Int its );

HYPRE_Int
HYPRE_BoomerAMGSetCPoints_flt( HYPRE_Solver solver, HYPRE_Int cpt_coarse_level, HYPRE_Int num_cpt_coarse, HYPRE_BigInt *cpt_coarse_index );
HYPRE_Int
HYPRE_BoomerAMGSetCPoints_dbl( HYPRE_Solver solver, HYPRE_Int cpt_coarse_level, HYPRE_Int num_cpt_coarse, HYPRE_BigInt *cpt_coarse_index );
HYPRE_Int
HYPRE_BoomerAMGSetCPoints_long_dbl( HYPRE_Solver solver, HYPRE_Int cpt_coarse_level, HYPRE_Int num_cpt_coarse, HYPRE_BigInt *cpt_coarse_index );
HYPRE_Int
HYPRE_BoomerAMGSetCPoints( HYPRE_Solver solver, HYPRE_Int cpt_coarse_level, HYPRE_Int num_cpt_coarse, HYPRE_BigInt *cpt_coarse_index );

HYPRE_Int
HYPRE_BoomerAMGSetCRRate_flt( HYPRE_Solver solver, hypre_float CR_rate );
HYPRE_Int
HYPRE_BoomerAMGSetCRRate_dbl( HYPRE_Solver solver, hypre_double CR_rate );
HYPRE_Int
HYPRE_BoomerAMGSetCRRate_long_dbl( HYPRE_Solver solver, hypre_long_double CR_rate );
HYPRE_Int
HYPRE_BoomerAMGSetCRRate( HYPRE_Solver solver, hypre_long_double CR_rate );

HYPRE_Int
HYPRE_BoomerAMGSetCRStrongTh_flt( HYPRE_Solver solver, hypre_float CR_strong_th );
HYPRE_Int
HYPRE_BoomerAMGSetCRStrongTh_dbl( HYPRE_Solver solver, hypre_double CR_strong_th );
HYPRE_Int
HYPRE_BoomerAMGSetCRStrongTh_long_dbl( HYPRE_Solver solver, hypre_long_double CR_strong_th );
HYPRE_Int
HYPRE_BoomerAMGSetCRStrongTh( HYPRE_Solver solver, hypre_long_double CR_strong_th );

HYPRE_Int
HYPRE_BoomerAMGSetCRUseCG_flt( HYPRE_Solver solver, HYPRE_Int CR_use_CG );
HYPRE_Int
HYPRE_BoomerAMGSetCRUseCG_dbl( HYPRE_Solver solver, HYPRE_Int CR_use_CG );
HYPRE_Int
HYPRE_BoomerAMGSetCRUseCG_long_dbl( HYPRE_Solver solver, HYPRE_Int CR_use_CG );
HYPRE_Int
HYPRE_BoomerAMGSetCRUseCG( HYPRE_Solver solver, HYPRE_Int CR_use_CG );

HYPRE_Int
HYPRE_BoomerAMGSetChebyEigEst_flt( HYPRE_Solver solver, HYPRE_Int eig_est );
HYPRE_Int
HYPRE_BoomerAMGSetChebyEigEst_dbl( HYPRE_Solver solver, HYPRE_Int eig_est );
HYPRE_Int
HYPRE_BoomerAMGSetChebyEigEst_long_dbl( HYPRE_Solver solver, HYPRE_Int eig_est );
HYPRE_Int
HYPRE_BoomerAMGSetChebyEigEst( HYPRE_Solver solver, HYPRE_Int eig_est );

HYPRE_Int
HYPRE_BoomerAMGSetChebyFraction_flt( HYPRE_Solver solver, hypre_float ratio );
HYPRE_Int
HYPRE_BoomerAMGSetChebyFraction_dbl( HYPRE_Solver solver, hypre_double ratio );
HYPRE_Int
HYPRE_BoomerAMGSetChebyFraction_long_dbl( HYPRE_Solver solver, hypre_long_double ratio );
HYPRE_Int
HYPRE_BoomerAMGSetChebyFraction( HYPRE_Solver solver, hypre_long_double ratio );

HYPRE_Int
HYPRE_BoomerAMGSetChebyOrder_flt( HYPRE_Solver solver, HYPRE_Int order );
HYPRE_Int
HYPRE_BoomerAMGSetChebyOrder_dbl( HYPRE_Solver solver, HYPRE_Int order );
HYPRE_Int
HYPRE_BoomerAMGSetChebyOrder_long_dbl( HYPRE_Solver solver, HYPRE_Int order );
HYPRE_Int
HYPRE_BoomerAMGSetChebyOrder( HYPRE_Solver solver, HYPRE_Int order );

HYPRE_Int
HYPRE_BoomerAMGSetChebyScale_flt( HYPRE_Solver solver, HYPRE_Int scale );
HYPRE_Int
HYPRE_BoomerAMGSetChebyScale_dbl( HYPRE_Solver solver, HYPRE_Int scale );
HYPRE_Int
HYPRE_BoomerAMGSetChebyScale_long_dbl( HYPRE_Solver solver, HYPRE_Int scale );
HYPRE_Int
HYPRE_BoomerAMGSetChebyScale( HYPRE_Solver solver, HYPRE_Int scale );

HYPRE_Int
HYPRE_BoomerAMGSetChebyVariant_flt( HYPRE_Solver solver, HYPRE_Int variant );
HYPRE_Int
HYPRE_BoomerAMGSetChebyVariant_dbl( HYPRE_Solver solver, HYPRE_Int variant );
HYPRE_Int
HYPRE_BoomerAMGSetChebyVariant_long_dbl( HYPRE_Solver solver, HYPRE_Int variant );
HYPRE_Int
HYPRE_BoomerAMGSetChebyVariant( HYPRE_Solver solver, HYPRE_Int variant );

HYPRE_Int
HYPRE_BoomerAMGSetCoarsenCutFactor_flt( HYPRE_Solver solver, HYPRE_Int coarsen_cut_factor );
HYPRE_Int
HYPRE_BoomerAMGSetCoarsenCutFactor_dbl( HYPRE_Solver solver, HYPRE_Int coarsen_cut_factor );
HYPRE_Int
HYPRE_BoomerAMGSetCoarsenCutFactor_long_dbl( HYPRE_Solver solver, HYPRE_Int coarsen_cut_factor );
HYPRE_Int
HYPRE_BoomerAMGSetCoarsenCutFactor( HYPRE_Solver solver, HYPRE_Int coarsen_cut_factor );

HYPRE_Int
HYPRE_BoomerAMGSetCoarsenType_flt( HYPRE_Solver solver, HYPRE_Int coarsen_type );
HYPRE_Int
HYPRE_BoomerAMGSetCoarsenType_dbl( HYPRE_Solver solver, HYPRE_Int coarsen_type );
HYPRE_Int
HYPRE_BoomerAMGSetCoarsenType_long_dbl( HYPRE_Solver solver, HYPRE_Int coarsen_type );
HYPRE_Int
HYPRE_BoomerAMGSetCoarsenType( HYPRE_Solver solver, HYPRE_Int coarsen_type );

HYPRE_Int
HYPRE_BoomerAMGSetConvergeType_flt( HYPRE_Solver solver, HYPRE_Int type );
HYPRE_Int
HYPRE_BoomerAMGSetConvergeType_dbl( HYPRE_Solver solver, HYPRE_Int type );
HYPRE_Int
HYPRE_BoomerAMGSetConvergeType_long_dbl( HYPRE_Solver solver, HYPRE_Int type );
HYPRE_Int
HYPRE_BoomerAMGSetConvergeType( HYPRE_Solver solver, HYPRE_Int type );

HYPRE_Int
HYPRE_BoomerAMGSetCoordDim_flt( HYPRE_Solver solver, HYPRE_Int coorddim );
HYPRE_Int
HYPRE_BoomerAMGSetCoordDim_dbl( HYPRE_Solver solver, HYPRE_Int coorddim );
HYPRE_Int
HYPRE_BoomerAMGSetCoordDim_long_dbl( HYPRE_Solver solver, HYPRE_Int coorddim );
HYPRE_Int
HYPRE_BoomerAMGSetCoordDim( HYPRE_Solver solver, HYPRE_Int coorddim );

HYPRE_Int
HYPRE_BoomerAMGSetCoordinates_flt( HYPRE_Solver solver, float *coordinates );
HYPRE_Int
HYPRE_BoomerAMGSetCoordinates_dbl( HYPRE_Solver solver, float *coordinates );
HYPRE_Int
HYPRE_BoomerAMGSetCoordinates_long_dbl( HYPRE_Solver solver, float *coordinates );
HYPRE_Int
HYPRE_BoomerAMGSetCoordinates( HYPRE_Solver solver, float *coordinates );

HYPRE_Int
HYPRE_BoomerAMGSetCpointsToKeep_flt( HYPRE_Solver solver, HYPRE_Int cpt_coarse_level, HYPRE_Int num_cpt_coarse, HYPRE_BigInt *cpt_coarse_index );
HYPRE_Int
HYPRE_BoomerAMGSetCpointsToKeep_dbl( HYPRE_Solver solver, HYPRE_Int cpt_coarse_level, HYPRE_Int num_cpt_coarse, HYPRE_BigInt *cpt_coarse_index );
HYPRE_Int
HYPRE_BoomerAMGSetCpointsToKeep_long_dbl( HYPRE_Solver solver, HYPRE_Int cpt_coarse_level, HYPRE_Int num_cpt_coarse, HYPRE_BigInt *cpt_coarse_index );
HYPRE_Int
HYPRE_BoomerAMGSetCpointsToKeep( HYPRE_Solver solver, HYPRE_Int cpt_coarse_level, HYPRE_Int num_cpt_coarse, HYPRE_BigInt *cpt_coarse_index );

HYPRE_Int
HYPRE_BoomerAMGSetCumNnzAP_flt( HYPRE_Solver solver, hypre_float cum_nnz_AP );
HYPRE_Int
HYPRE_BoomerAMGSetCumNnzAP_dbl( HYPRE_Solver solver, hypre_double cum_nnz_AP );
HYPRE_Int
HYPRE_BoomerAMGSetCumNnzAP_long_dbl( HYPRE_Solver solver, hypre_long_double cum_nnz_AP );
HYPRE_Int
HYPRE_BoomerAMGSetCumNnzAP( HYPRE_Solver solver, hypre_long_double cum_nnz_AP );

HYPRE_Int
HYPRE_BoomerAMGSetCycleNumSweeps_flt( HYPRE_Solver solver, HYPRE_Int num_sweeps, HYPRE_Int k );
HYPRE_Int
HYPRE_BoomerAMGSetCycleNumSweeps_dbl( HYPRE_Solver solver, HYPRE_Int num_sweeps, HYPRE_Int k );
HYPRE_Int
HYPRE_BoomerAMGSetCycleNumSweeps_long_dbl( HYPRE_Solver solver, HYPRE_Int num_sweeps, HYPRE_Int k );
HYPRE_Int
HYPRE_BoomerAMGSetCycleNumSweeps( HYPRE_Solver solver, HYPRE_Int num_sweeps, HYPRE_Int k );

HYPRE_Int
HYPRE_BoomerAMGSetCycleRelaxType_flt( HYPRE_Solver solver, HYPRE_Int relax_type, HYPRE_Int k );
HYPRE_Int
HYPRE_BoomerAMGSetCycleRelaxType_dbl( HYPRE_Solver solver, HYPRE_Int relax_type, HYPRE_Int k );
HYPRE_Int
HYPRE_BoomerAMGSetCycleRelaxType_long_dbl( HYPRE_Solver solver, HYPRE_Int relax_type, HYPRE_Int k );
HYPRE_Int
HYPRE_BoomerAMGSetCycleRelaxType( HYPRE_Solver solver, HYPRE_Int relax_type, HYPRE_Int k );

HYPRE_Int
HYPRE_BoomerAMGSetCycleType_flt( HYPRE_Solver solver, HYPRE_Int cycle_type );
HYPRE_Int
HYPRE_BoomerAMGSetCycleType_dbl( HYPRE_Solver solver, HYPRE_Int cycle_type );
HYPRE_Int
HYPRE_BoomerAMGSetCycleType_long_dbl( HYPRE_Solver solver, HYPRE_Int cycle_type );
HYPRE_Int
HYPRE_BoomerAMGSetCycleType( HYPRE_Solver solver, HYPRE_Int cycle_type );

HYPRE_Int
HYPRE_BoomerAMGSetDebugFlag_flt( HYPRE_Solver solver, HYPRE_Int debug_flag );
HYPRE_Int
HYPRE_BoomerAMGSetDebugFlag_dbl( HYPRE_Solver solver, HYPRE_Int debug_flag );
HYPRE_Int
HYPRE_BoomerAMGSetDebugFlag_long_dbl( HYPRE_Solver solver, HYPRE_Int debug_flag );
HYPRE_Int
HYPRE_BoomerAMGSetDebugFlag( HYPRE_Solver solver, HYPRE_Int debug_flag );

HYPRE_Int
HYPRE_BoomerAMGSetDofFunc_flt( HYPRE_Solver solver, HYPRE_Int *dof_func );
HYPRE_Int
HYPRE_BoomerAMGSetDofFunc_dbl( HYPRE_Solver solver, HYPRE_Int *dof_func );
HYPRE_Int
HYPRE_BoomerAMGSetDofFunc_long_dbl( HYPRE_Solver solver, HYPRE_Int *dof_func );
HYPRE_Int
HYPRE_BoomerAMGSetDofFunc( HYPRE_Solver solver, HYPRE_Int *dof_func );

HYPRE_Int
HYPRE_BoomerAMGSetDomainType_flt( HYPRE_Solver solver, HYPRE_Int domain_type );
HYPRE_Int
HYPRE_BoomerAMGSetDomainType_dbl( HYPRE_Solver solver, HYPRE_Int domain_type );
HYPRE_Int
HYPRE_BoomerAMGSetDomainType_long_dbl( HYPRE_Solver solver, HYPRE_Int domain_type );
HYPRE_Int
HYPRE_BoomerAMGSetDomainType( HYPRE_Solver solver, HYPRE_Int domain_type );

HYPRE_Int
HYPRE_BoomerAMGSetDropTol_flt( HYPRE_Solver solver, hypre_float drop_tol );
HYPRE_Int
HYPRE_BoomerAMGSetDropTol_dbl( HYPRE_Solver solver, hypre_double drop_tol );
HYPRE_Int
HYPRE_BoomerAMGSetDropTol_long_dbl( HYPRE_Solver solver, hypre_long_double drop_tol );
HYPRE_Int
HYPRE_BoomerAMGSetDropTol( HYPRE_Solver solver, hypre_long_double drop_tol );

HYPRE_Int
HYPRE_BoomerAMGSetEuBJ_flt( HYPRE_Solver solver, HYPRE_Int eu_bj );
HYPRE_Int
HYPRE_BoomerAMGSetEuBJ_dbl( HYPRE_Solver solver, HYPRE_Int eu_bj );
HYPRE_Int
HYPRE_BoomerAMGSetEuBJ_long_dbl( HYPRE_Solver solver, HYPRE_Int eu_bj );
HYPRE_Int
HYPRE_BoomerAMGSetEuBJ( HYPRE_Solver solver, HYPRE_Int eu_bj );

HYPRE_Int
HYPRE_BoomerAMGSetEuLevel_flt( HYPRE_Solver solver, HYPRE_Int eu_level );
HYPRE_Int
HYPRE_BoomerAMGSetEuLevel_dbl( HYPRE_Solver solver, HYPRE_Int eu_level );
HYPRE_Int
HYPRE_BoomerAMGSetEuLevel_long_dbl( HYPRE_Solver solver, HYPRE_Int eu_level );
HYPRE_Int
HYPRE_BoomerAMGSetEuLevel( HYPRE_Solver solver, HYPRE_Int eu_level );

HYPRE_Int
HYPRE_BoomerAMGSetEuSparseA_flt( HYPRE_Solver solver, hypre_float eu_sparse_A );
HYPRE_Int
HYPRE_BoomerAMGSetEuSparseA_dbl( HYPRE_Solver solver, hypre_double eu_sparse_A );
HYPRE_Int
HYPRE_BoomerAMGSetEuSparseA_long_dbl( HYPRE_Solver solver, hypre_long_double eu_sparse_A );
HYPRE_Int
HYPRE_BoomerAMGSetEuSparseA( HYPRE_Solver solver, hypre_long_double eu_sparse_A );

HYPRE_Int
HYPRE_BoomerAMGSetEuclidFile_flt( HYPRE_Solver solver, char *euclidfile );
HYPRE_Int
HYPRE_BoomerAMGSetEuclidFile_dbl( HYPRE_Solver solver, char *euclidfile );
HYPRE_Int
HYPRE_BoomerAMGSetEuclidFile_long_dbl( HYPRE_Solver solver, char *euclidfile );
HYPRE_Int
HYPRE_BoomerAMGSetEuclidFile( HYPRE_Solver solver, char *euclidfile );

HYPRE_Int
HYPRE_BoomerAMGSetFCycle_flt( HYPRE_Solver solver, HYPRE_Int fcycle );
HYPRE_Int
HYPRE_BoomerAMGSetFCycle_dbl( HYPRE_Solver solver, HYPRE_Int fcycle );
HYPRE_Int
HYPRE_BoomerAMGSetFCycle_long_dbl( HYPRE_Solver solver, HYPRE_Int fcycle );
HYPRE_Int
HYPRE_BoomerAMGSetFCycle( HYPRE_Solver solver, HYPRE_Int fcycle );

HYPRE_Int
HYPRE_BoomerAMGSetFPoints_flt( HYPRE_Solver solver, HYPRE_Int num_fpt, HYPRE_BigInt *fpt_index );
HYPRE_Int
HYPRE_BoomerAMGSetFPoints_dbl( HYPRE_Solver solver, HYPRE_Int num_fpt, HYPRE_BigInt *fpt_index );
HYPRE_Int
HYPRE_BoomerAMGSetFPoints_long_dbl( HYPRE_Solver solver, HYPRE_Int num_fpt, HYPRE_BigInt *fpt_index );
HYPRE_Int
HYPRE_BoomerAMGSetFPoints( HYPRE_Solver solver, HYPRE_Int num_fpt, HYPRE_BigInt *fpt_index );

HYPRE_Int
HYPRE_BoomerAMGSetFSAIAlgoType_flt( HYPRE_Solver solver, HYPRE_Int algo_type );
HYPRE_Int
HYPRE_BoomerAMGSetFSAIAlgoType_dbl( HYPRE_Solver solver, HYPRE_Int algo_type );
HYPRE_Int
HYPRE_BoomerAMGSetFSAIAlgoType_long_dbl( HYPRE_Solver solver, HYPRE_Int algo_type );
HYPRE_Int
HYPRE_BoomerAMGSetFSAIAlgoType( HYPRE_Solver solver, HYPRE_Int algo_type );

HYPRE_Int
HYPRE_BoomerAMGSetFSAIEigMaxIters_flt( HYPRE_Solver solver, HYPRE_Int eig_max_iters );
HYPRE_Int
HYPRE_BoomerAMGSetFSAIEigMaxIters_dbl( HYPRE_Solver solver, HYPRE_Int eig_max_iters );
HYPRE_Int
HYPRE_BoomerAMGSetFSAIEigMaxIters_long_dbl( HYPRE_Solver solver, HYPRE_Int eig_max_iters );
HYPRE_Int
HYPRE_BoomerAMGSetFSAIEigMaxIters( HYPRE_Solver solver, HYPRE_Int eig_max_iters );

HYPRE_Int
HYPRE_BoomerAMGSetFSAIKapTolerance_flt( HYPRE_Solver solver, hypre_float kap_tolerance );
HYPRE_Int
HYPRE_BoomerAMGSetFSAIKapTolerance_dbl( HYPRE_Solver solver, hypre_double kap_tolerance );
HYPRE_Int
HYPRE_BoomerAMGSetFSAIKapTolerance_long_dbl( HYPRE_Solver solver, hypre_long_double kap_tolerance );
HYPRE_Int
HYPRE_BoomerAMGSetFSAIKapTolerance( HYPRE_Solver solver, hypre_long_double kap_tolerance );

HYPRE_Int
HYPRE_BoomerAMGSetFSAILocalSolveType_flt( HYPRE_Solver solver, HYPRE_Int local_solve_type );
HYPRE_Int
HYPRE_BoomerAMGSetFSAILocalSolveType_dbl( HYPRE_Solver solver, HYPRE_Int local_solve_type );
HYPRE_Int
HYPRE_BoomerAMGSetFSAILocalSolveType_long_dbl( HYPRE_Solver solver, HYPRE_Int local_solve_type );
HYPRE_Int
HYPRE_BoomerAMGSetFSAILocalSolveType( HYPRE_Solver solver, HYPRE_Int local_solve_type );

HYPRE_Int
HYPRE_BoomerAMGSetFSAIMaxNnzRow_flt( HYPRE_Solver solver, HYPRE_Int max_nnz_row );
HYPRE_Int
HYPRE_BoomerAMGSetFSAIMaxNnzRow_dbl( HYPRE_Solver solver, HYPRE_Int max_nnz_row );
HYPRE_Int
HYPRE_BoomerAMGSetFSAIMaxNnzRow_long_dbl( HYPRE_Solver solver, HYPRE_Int max_nnz_row );
HYPRE_Int
HYPRE_BoomerAMGSetFSAIMaxNnzRow( HYPRE_Solver solver, HYPRE_Int max_nnz_row );

HYPRE_Int
HYPRE_BoomerAMGSetFSAIMaxStepSize_flt( HYPRE_Solver solver, HYPRE_Int max_step_size );
HYPRE_Int
HYPRE_BoomerAMGSetFSAIMaxStepSize_dbl( HYPRE_Solver solver, HYPRE_Int max_step_size );
HYPRE_Int
HYPRE_BoomerAMGSetFSAIMaxStepSize_long_dbl( HYPRE_Solver solver, HYPRE_Int max_step_size );
HYPRE_Int
HYPRE_BoomerAMGSetFSAIMaxStepSize( HYPRE_Solver solver, HYPRE_Int max_step_size );

HYPRE_Int
HYPRE_BoomerAMGSetFSAIMaxSteps_flt( HYPRE_Solver solver, HYPRE_Int max_steps );
HYPRE_Int
HYPRE_BoomerAMGSetFSAIMaxSteps_dbl( HYPRE_Solver solver, HYPRE_Int max_steps );
HYPRE_Int
HYPRE_BoomerAMGSetFSAIMaxSteps_long_dbl( HYPRE_Solver solver, HYPRE_Int max_steps );
HYPRE_Int
HYPRE_BoomerAMGSetFSAIMaxSteps( HYPRE_Solver solver, HYPRE_Int max_steps );

HYPRE_Int
HYPRE_BoomerAMGSetFSAINumLevels_flt( HYPRE_Solver solver, HYPRE_Int num_levels );
HYPRE_Int
HYPRE_BoomerAMGSetFSAINumLevels_dbl( HYPRE_Solver solver, HYPRE_Int num_levels );
HYPRE_Int
HYPRE_BoomerAMGSetFSAINumLevels_long_dbl( HYPRE_Solver solver, HYPRE_Int num_levels );
HYPRE_Int
HYPRE_BoomerAMGSetFSAINumLevels( HYPRE_Solver solver, HYPRE_Int num_levels );

HYPRE_Int
HYPRE_BoomerAMGSetFSAIThreshold_flt( HYPRE_Solver solver, hypre_float threshold );
HYPRE_Int
HYPRE_BoomerAMGSetFSAIThreshold_dbl( HYPRE_Solver solver, hypre_double threshold );
HYPRE_Int
HYPRE_BoomerAMGSetFSAIThreshold_long_dbl( HYPRE_Solver solver, hypre_long_double threshold );
HYPRE_Int
HYPRE_BoomerAMGSetFSAIThreshold( HYPRE_Solver solver, hypre_long_double threshold );

HYPRE_Int
HYPRE_BoomerAMGSetFilter_flt( HYPRE_Solver solver, hypre_float filter );
HYPRE_Int
HYPRE_BoomerAMGSetFilter_dbl( HYPRE_Solver solver, hypre_double filter );
HYPRE_Int
HYPRE_BoomerAMGSetFilter_long_dbl( HYPRE_Solver solver, hypre_long_double filter );
HYPRE_Int
HYPRE_BoomerAMGSetFilter( HYPRE_Solver solver, hypre_long_double filter );

HYPRE_Int
HYPRE_BoomerAMGSetFilterFunctions_flt( HYPRE_Solver solver, HYPRE_Int filter_functions );
HYPRE_Int
HYPRE_BoomerAMGSetFilterFunctions_dbl( HYPRE_Solver solver, HYPRE_Int filter_functions );
HYPRE_Int
HYPRE_BoomerAMGSetFilterFunctions_long_dbl( HYPRE_Solver solver, HYPRE_Int filter_functions );
HYPRE_Int
HYPRE_BoomerAMGSetFilterFunctions( HYPRE_Solver solver, HYPRE_Int filter_functions );

HYPRE_Int
HYPRE_BoomerAMGSetFilterThresholdR_flt( HYPRE_Solver solver, hypre_float filter_threshold );
HYPRE_Int
HYPRE_BoomerAMGSetFilterThresholdR_dbl( HYPRE_Solver solver, hypre_double filter_threshold );
HYPRE_Int
HYPRE_BoomerAMGSetFilterThresholdR_long_dbl( HYPRE_Solver solver, hypre_long_double filter_threshold );
HYPRE_Int
HYPRE_BoomerAMGSetFilterThresholdR( HYPRE_Solver solver, hypre_long_double filter_threshold );

HYPRE_Int
HYPRE_BoomerAMGSetGMRESSwitchR_flt( HYPRE_Solver solver, HYPRE_Int gmres_switch );
HYPRE_Int
HYPRE_BoomerAMGSetGMRESSwitchR_dbl( HYPRE_Solver solver, HYPRE_Int gmres_switch );
HYPRE_Int
HYPRE_BoomerAMGSetGMRESSwitchR_long_dbl( HYPRE_Solver solver, HYPRE_Int gmres_switch );
HYPRE_Int
HYPRE_BoomerAMGSetGMRESSwitchR( HYPRE_Solver solver, HYPRE_Int gmres_switch );

HYPRE_Int
HYPRE_BoomerAMGSetGSMG_flt( HYPRE_Solver solver, HYPRE_Int gsmg );
HYPRE_Int
HYPRE_BoomerAMGSetGSMG_dbl( HYPRE_Solver solver, HYPRE_Int gsmg );
HYPRE_Int
HYPRE_BoomerAMGSetGSMG_long_dbl( HYPRE_Solver solver, HYPRE_Int gsmg );
HYPRE_Int
HYPRE_BoomerAMGSetGSMG( HYPRE_Solver solver, HYPRE_Int gsmg );

HYPRE_Int
HYPRE_BoomerAMGSetGridRelaxPoints_flt( HYPRE_Solver solver, HYPRE_Int **grid_relax_points );
HYPRE_Int
HYPRE_BoomerAMGSetGridRelaxPoints_dbl( HYPRE_Solver solver, HYPRE_Int **grid_relax_points );
HYPRE_Int
HYPRE_BoomerAMGSetGridRelaxPoints_long_dbl( HYPRE_Solver solver, HYPRE_Int **grid_relax_points );
HYPRE_Int
HYPRE_BoomerAMGSetGridRelaxPoints( HYPRE_Solver solver, HYPRE_Int **grid_relax_points );

HYPRE_Int
HYPRE_BoomerAMGSetGridRelaxType_flt( HYPRE_Solver solver, HYPRE_Int *grid_relax_type );
HYPRE_Int
HYPRE_BoomerAMGSetGridRelaxType_dbl( HYPRE_Solver solver, HYPRE_Int *grid_relax_type );
HYPRE_Int
HYPRE_BoomerAMGSetGridRelaxType_long_dbl( HYPRE_Solver solver, HYPRE_Int *grid_relax_type );
HYPRE_Int
HYPRE_BoomerAMGSetGridRelaxType( HYPRE_Solver solver, HYPRE_Int *grid_relax_type );

HYPRE_Int
HYPRE_BoomerAMGSetILUDroptol_flt( HYPRE_Solver solver, hypre_float ilu_droptol );
HYPRE_Int
HYPRE_BoomerAMGSetILUDroptol_dbl( HYPRE_Solver solver, hypre_double ilu_droptol );
HYPRE_Int
HYPRE_BoomerAMGSetILUDroptol_long_dbl( HYPRE_Solver solver, hypre_long_double ilu_droptol );
HYPRE_Int
HYPRE_BoomerAMGSetILUDroptol( HYPRE_Solver solver, hypre_long_double ilu_droptol );

HYPRE_Int
HYPRE_BoomerAMGSetILUIterSetupMaxIter_flt( HYPRE_Solver solver, HYPRE_Int ilu_iter_setup_max_iter );
HYPRE_Int
HYPRE_BoomerAMGSetILUIterSetupMaxIter_dbl( HYPRE_Solver solver, HYPRE_Int ilu_iter_setup_max_iter );
HYPRE_Int
HYPRE_BoomerAMGSetILUIterSetupMaxIter_long_dbl( HYPRE_Solver solver, HYPRE_Int ilu_iter_setup_max_iter );
HYPRE_Int
HYPRE_BoomerAMGSetILUIterSetupMaxIter( HYPRE_Solver solver, HYPRE_Int ilu_iter_setup_max_iter );

HYPRE_Int
HYPRE_BoomerAMGSetILUIterSetupOption_flt( HYPRE_Solver solver, HYPRE_Int ilu_iter_setup_option );
HYPRE_Int
HYPRE_BoomerAMGSetILUIterSetupOption_dbl( HYPRE_Solver solver, HYPRE_Int ilu_iter_setup_option );
HYPRE_Int
HYPRE_BoomerAMGSetILUIterSetupOption_long_dbl( HYPRE_Solver solver, HYPRE_Int ilu_iter_setup_option );
HYPRE_Int
HYPRE_BoomerAMGSetILUIterSetupOption( HYPRE_Solver solver, HYPRE_Int ilu_iter_setup_option );

HYPRE_Int
HYPRE_BoomerAMGSetILUIterSetupTolerance_flt( HYPRE_Solver solver, hypre_float ilu_iter_setup_tolerance );
HYPRE_Int
HYPRE_BoomerAMGSetILUIterSetupTolerance_dbl( HYPRE_Solver solver, hypre_double ilu_iter_setup_tolerance );
HYPRE_Int
HYPRE_BoomerAMGSetILUIterSetupTolerance_long_dbl( HYPRE_Solver solver, hypre_long_double ilu_iter_setup_tolerance );
HYPRE_Int
HYPRE_BoomerAMGSetILUIterSetupTolerance( HYPRE_Solver solver, hypre_long_double ilu_iter_setup_tolerance );

HYPRE_Int
HYPRE_BoomerAMGSetILUIterSetupType_flt( HYPRE_Solver solver, HYPRE_Int ilu_iter_setup_type );
HYPRE_Int
HYPRE_BoomerAMGSetILUIterSetupType_dbl( HYPRE_Solver solver, HYPRE_Int ilu_iter_setup_type );
HYPRE_Int
HYPRE_BoomerAMGSetILUIterSetupType_long_dbl( HYPRE_Solver solver, HYPRE_Int ilu_iter_setup_type );
HYPRE_Int
HYPRE_BoomerAMGSetILUIterSetupType( HYPRE_Solver solver, HYPRE_Int ilu_iter_setup_type );

HYPRE_Int
HYPRE_BoomerAMGSetILULevel_flt( HYPRE_Solver solver, HYPRE_Int ilu_lfil );
HYPRE_Int
HYPRE_BoomerAMGSetILULevel_dbl( HYPRE_Solver solver, HYPRE_Int ilu_lfil );
HYPRE_Int
HYPRE_BoomerAMGSetILULevel_long_dbl( HYPRE_Solver solver, HYPRE_Int ilu_lfil );
HYPRE_Int
HYPRE_BoomerAMGSetILULevel( HYPRE_Solver solver, HYPRE_Int ilu_lfil );

HYPRE_Int
HYPRE_BoomerAMGSetILULocalReordering_flt( HYPRE_Solver solver, HYPRE_Int ilu_reordering_type );
HYPRE_Int
HYPRE_BoomerAMGSetILULocalReordering_dbl( HYPRE_Solver solver, HYPRE_Int ilu_reordering_type );
HYPRE_Int
HYPRE_BoomerAMGSetILULocalReordering_long_dbl( HYPRE_Solver solver, HYPRE_Int ilu_reordering_type );
HYPRE_Int
HYPRE_BoomerAMGSetILULocalReordering( HYPRE_Solver solver, HYPRE_Int ilu_reordering_type );

HYPRE_Int
HYPRE_BoomerAMGSetILULowerJacobiIters_flt( HYPRE_Solver solver, HYPRE_Int ilu_lower_jacobi_iters );
HYPRE_Int
HYPRE_BoomerAMGSetILULowerJacobiIters_dbl( HYPRE_Solver solver, HYPRE_Int ilu_lower_jacobi_iters );
HYPRE_Int
HYPRE_BoomerAMGSetILULowerJacobiIters_long_dbl( HYPRE_Solver solver, HYPRE_Int ilu_lower_jacobi_iters );
HYPRE_Int
HYPRE_BoomerAMGSetILULowerJacobiIters( HYPRE_Solver solver, HYPRE_Int ilu_lower_jacobi_iters );

HYPRE_Int
HYPRE_BoomerAMGSetILUMaxIter_flt( HYPRE_Solver solver, HYPRE_Int ilu_max_iter );
HYPRE_Int
HYPRE_BoomerAMGSetILUMaxIter_dbl( HYPRE_Solver solver, HYPRE_Int ilu_max_iter );
HYPRE_Int
HYPRE_BoomerAMGSetILUMaxIter_long_dbl( HYPRE_Solver solver, HYPRE_Int ilu_max_iter );
HYPRE_Int
HYPRE_BoomerAMGSetILUMaxIter( HYPRE_Solver solver, HYPRE_Int ilu_max_iter );

HYPRE_Int
HYPRE_BoomerAMGSetILUMaxRowNnz_flt( HYPRE_Solver solver, HYPRE_Int ilu_max_row_nnz );
HYPRE_Int
HYPRE_BoomerAMGSetILUMaxRowNnz_dbl( HYPRE_Solver solver, HYPRE_Int ilu_max_row_nnz );
HYPRE_Int
HYPRE_BoomerAMGSetILUMaxRowNnz_long_dbl( HYPRE_Solver solver, HYPRE_Int ilu_max_row_nnz );
HYPRE_Int
HYPRE_BoomerAMGSetILUMaxRowNnz( HYPRE_Solver solver, HYPRE_Int ilu_max_row_nnz );

HYPRE_Int
HYPRE_BoomerAMGSetILUTriSolve_flt( HYPRE_Solver solver, HYPRE_Int ilu_tri_solve );
HYPRE_Int
HYPRE_BoomerAMGSetILUTriSolve_dbl( HYPRE_Solver solver, HYPRE_Int ilu_tri_solve );
HYPRE_Int
HYPRE_BoomerAMGSetILUTriSolve_long_dbl( HYPRE_Solver solver, HYPRE_Int ilu_tri_solve );
HYPRE_Int
HYPRE_BoomerAMGSetILUTriSolve( HYPRE_Solver solver, HYPRE_Int ilu_tri_solve );

HYPRE_Int
HYPRE_BoomerAMGSetILUType_flt( HYPRE_Solver solver, HYPRE_Int ilu_type );
HYPRE_Int
HYPRE_BoomerAMGSetILUType_dbl( HYPRE_Solver solver, HYPRE_Int ilu_type );
HYPRE_Int
HYPRE_BoomerAMGSetILUType_long_dbl( HYPRE_Solver solver, HYPRE_Int ilu_type );
HYPRE_Int
HYPRE_BoomerAMGSetILUType( HYPRE_Solver solver, HYPRE_Int ilu_type );

HYPRE_Int
HYPRE_BoomerAMGSetILUUpperJacobiIters_flt( HYPRE_Solver solver, HYPRE_Int ilu_upper_jacobi_iters );
HYPRE_Int
HYPRE_BoomerAMGSetILUUpperJacobiIters_dbl( HYPRE_Solver solver, HYPRE_Int ilu_upper_jacobi_iters );
HYPRE_Int
HYPRE_BoomerAMGSetILUUpperJacobiIters_long_dbl( HYPRE_Solver solver, HYPRE_Int ilu_upper_jacobi_iters );
HYPRE_Int
HYPRE_BoomerAMGSetILUUpperJacobiIters( HYPRE_Solver solver, HYPRE_Int ilu_upper_jacobi_iters );

HYPRE_Int
HYPRE_BoomerAMGSetISType_flt( HYPRE_Solver solver, HYPRE_Int IS_type );
HYPRE_Int
HYPRE_BoomerAMGSetISType_dbl( HYPRE_Solver solver, HYPRE_Int IS_type );
HYPRE_Int
HYPRE_BoomerAMGSetISType_long_dbl( HYPRE_Solver solver, HYPRE_Int IS_type );
HYPRE_Int
HYPRE_BoomerAMGSetISType( HYPRE_Solver solver, HYPRE_Int IS_type );

HYPRE_Int
HYPRE_BoomerAMGSetInterpRefine_flt( HYPRE_Solver solver, HYPRE_Int num_refine );
HYPRE_Int
HYPRE_BoomerAMGSetInterpRefine_dbl( HYPRE_Solver solver, HYPRE_Int num_refine );
HYPRE_Int
HYPRE_BoomerAMGSetInterpRefine_long_dbl( HYPRE_Solver solver, HYPRE_Int num_refine );
HYPRE_Int
HYPRE_BoomerAMGSetInterpRefine( HYPRE_Solver solver, HYPRE_Int num_refine );

HYPRE_Int
HYPRE_BoomerAMGSetInterpType_flt( HYPRE_Solver solver, HYPRE_Int interp_type );
HYPRE_Int
HYPRE_BoomerAMGSetInterpType_dbl( HYPRE_Solver solver, HYPRE_Int interp_type );
HYPRE_Int
HYPRE_BoomerAMGSetInterpType_long_dbl( HYPRE_Solver solver, HYPRE_Int interp_type );
HYPRE_Int
HYPRE_BoomerAMGSetInterpType( HYPRE_Solver solver, HYPRE_Int interp_type );

HYPRE_Int
HYPRE_BoomerAMGSetInterpVecAbsQTrunc_flt( HYPRE_Solver solver, hypre_float q_trunc );
HYPRE_Int
HYPRE_BoomerAMGSetInterpVecAbsQTrunc_dbl( HYPRE_Solver solver, hypre_double q_trunc );
HYPRE_Int
HYPRE_BoomerAMGSetInterpVecAbsQTrunc_long_dbl( HYPRE_Solver solver, hypre_long_double q_trunc );
HYPRE_Int
HYPRE_BoomerAMGSetInterpVecAbsQTrunc( HYPRE_Solver solver, hypre_long_double q_trunc );

HYPRE_Int
HYPRE_BoomerAMGSetInterpVecQMax_flt( HYPRE_Solver solver, HYPRE_Int q_max );
HYPRE_Int
HYPRE_BoomerAMGSetInterpVecQMax_dbl( HYPRE_Solver solver, HYPRE_Int q_max );
HYPRE_Int
HYPRE_BoomerAMGSetInterpVecQMax_long_dbl( HYPRE_Solver solver, HYPRE_Int q_max );
HYPRE_Int
HYPRE_BoomerAMGSetInterpVecQMax( HYPRE_Solver solver, HYPRE_Int q_max );

HYPRE_Int
HYPRE_BoomerAMGSetInterpVecVariant_flt( HYPRE_Solver solver, HYPRE_Int var );
HYPRE_Int
HYPRE_BoomerAMGSetInterpVecVariant_dbl( HYPRE_Solver solver, HYPRE_Int var );
HYPRE_Int
HYPRE_BoomerAMGSetInterpVecVariant_long_dbl( HYPRE_Solver solver, HYPRE_Int var );
HYPRE_Int
HYPRE_BoomerAMGSetInterpVecVariant( HYPRE_Solver solver, HYPRE_Int var );

HYPRE_Int
HYPRE_BoomerAMGSetInterpVectors_flt( HYPRE_Solver solver, HYPRE_Int num_vectors, HYPRE_ParVector *interp_vectors );
HYPRE_Int
HYPRE_BoomerAMGSetInterpVectors_dbl( HYPRE_Solver solver, HYPRE_Int num_vectors, HYPRE_ParVector *interp_vectors );
HYPRE_Int
HYPRE_BoomerAMGSetInterpVectors_long_dbl( HYPRE_Solver solver, HYPRE_Int num_vectors, HYPRE_ParVector *interp_vectors );
HYPRE_Int
HYPRE_BoomerAMGSetInterpVectors( HYPRE_Solver solver, HYPRE_Int num_vectors, HYPRE_ParVector *interp_vectors );

HYPRE_Int
HYPRE_BoomerAMGSetIsTriangular_flt( HYPRE_Solver solver, HYPRE_Int is_triangular );
HYPRE_Int
HYPRE_BoomerAMGSetIsTriangular_dbl( HYPRE_Solver solver, HYPRE_Int is_triangular );
HYPRE_Int
HYPRE_BoomerAMGSetIsTriangular_long_dbl( HYPRE_Solver solver, HYPRE_Int is_triangular );
HYPRE_Int
HYPRE_BoomerAMGSetIsTriangular( HYPRE_Solver solver, HYPRE_Int is_triangular );

HYPRE_Int
HYPRE_BoomerAMGSetIsolatedFPoints_flt( HYPRE_Solver solver, HYPRE_Int num_isolated_fpt, HYPRE_BigInt *isolated_fpt_index );
HYPRE_Int
HYPRE_BoomerAMGSetIsolatedFPoints_dbl( HYPRE_Solver solver, HYPRE_Int num_isolated_fpt, HYPRE_BigInt *isolated_fpt_index );
HYPRE_Int
HYPRE_BoomerAMGSetIsolatedFPoints_long_dbl( HYPRE_Solver solver, HYPRE_Int num_isolated_fpt, HYPRE_BigInt *isolated_fpt_index );
HYPRE_Int
HYPRE_BoomerAMGSetIsolatedFPoints( HYPRE_Solver solver, HYPRE_Int num_isolated_fpt, HYPRE_BigInt *isolated_fpt_index );

HYPRE_Int
HYPRE_BoomerAMGSetJacobiTruncThreshold_flt( HYPRE_Solver solver, hypre_float jacobi_trunc_threshold );
HYPRE_Int
HYPRE_BoomerAMGSetJacobiTruncThreshold_dbl( HYPRE_Solver solver, hypre_double jacobi_trunc_threshold );
HYPRE_Int
HYPRE_BoomerAMGSetJacobiTruncThreshold_long_dbl( HYPRE_Solver solver, hypre_long_double jacobi_trunc_threshold );
HYPRE_Int
HYPRE_BoomerAMGSetJacobiTruncThreshold( HYPRE_Solver solver, hypre_long_double jacobi_trunc_threshold );

HYPRE_Int
HYPRE_BoomerAMGSetKeepSameSign_flt( HYPRE_Solver solver, HYPRE_Int keep_same_sign );
HYPRE_Int
HYPRE_BoomerAMGSetKeepSameSign_dbl( HYPRE_Solver solver, HYPRE_Int keep_same_sign );
HYPRE_Int
HYPRE_BoomerAMGSetKeepSameSign_long_dbl( HYPRE_Solver solver, HYPRE_Int keep_same_sign );
HYPRE_Int
HYPRE_BoomerAMGSetKeepSameSign( HYPRE_Solver solver, HYPRE_Int keep_same_sign );

HYPRE_Int
HYPRE_BoomerAMGSetKeepTranspose_flt( HYPRE_Solver solver, HYPRE_Int keepTranspose );
HYPRE_Int
HYPRE_BoomerAMGSetKeepTranspose_dbl( HYPRE_Solver solver, HYPRE_Int keepTranspose );
HYPRE_Int
HYPRE_BoomerAMGSetKeepTranspose_long_dbl( HYPRE_Solver solver, HYPRE_Int keepTranspose );
HYPRE_Int
HYPRE_BoomerAMGSetKeepTranspose( HYPRE_Solver solver, HYPRE_Int keepTranspose );

HYPRE_Int
HYPRE_BoomerAMGSetLevel_flt( HYPRE_Solver solver, HYPRE_Int level );
HYPRE_Int
HYPRE_BoomerAMGSetLevel_dbl( HYPRE_Solver solver, HYPRE_Int level );
HYPRE_Int
HYPRE_BoomerAMGSetLevel_long_dbl( HYPRE_Solver solver, HYPRE_Int level );
HYPRE_Int
HYPRE_BoomerAMGSetLevel( HYPRE_Solver solver, HYPRE_Int level );

HYPRE_Int
HYPRE_BoomerAMGSetLevelNonGalerkinTol_flt( HYPRE_Solver solver, hypre_float nongalerkin_tol, HYPRE_Int level );
HYPRE_Int
HYPRE_BoomerAMGSetLevelNonGalerkinTol_dbl( HYPRE_Solver solver, hypre_double nongalerkin_tol, HYPRE_Int level );
HYPRE_Int
HYPRE_BoomerAMGSetLevelNonGalerkinTol_long_dbl( HYPRE_Solver solver, hypre_long_double nongalerkin_tol, HYPRE_Int level );
HYPRE_Int
HYPRE_BoomerAMGSetLevelNonGalerkinTol( HYPRE_Solver solver, hypre_long_double nongalerkin_tol, HYPRE_Int level );

HYPRE_Int
HYPRE_BoomerAMGSetLevelOuterWt_flt( HYPRE_Solver solver, hypre_float omega, HYPRE_Int level );
HYPRE_Int
HYPRE_BoomerAMGSetLevelOuterWt_dbl( HYPRE_Solver solver, hypre_double omega, HYPRE_Int level );
HYPRE_Int
HYPRE_BoomerAMGSetLevelOuterWt_long_dbl( HYPRE_Solver solver, hypre_long_double omega, HYPRE_Int level );
HYPRE_Int
HYPRE_BoomerAMGSetLevelOuterWt( HYPRE_Solver solver, hypre_long_double omega, HYPRE_Int level );

HYPRE_Int
HYPRE_BoomerAMGSetLevelRelaxWt_flt( HYPRE_Solver solver, hypre_float relax_weight, HYPRE_Int level );
HYPRE_Int
HYPRE_BoomerAMGSetLevelRelaxWt_dbl( HYPRE_Solver solver, hypre_double relax_weight, HYPRE_Int level );
HYPRE_Int
HYPRE_BoomerAMGSetLevelRelaxWt_long_dbl( HYPRE_Solver solver, hypre_long_double relax_weight, HYPRE_Int level );
HYPRE_Int
HYPRE_BoomerAMGSetLevelRelaxWt( HYPRE_Solver solver, hypre_long_double relax_weight, HYPRE_Int level );

HYPRE_Int
HYPRE_BoomerAMGSetLogging_flt( HYPRE_Solver solver, HYPRE_Int logging );
HYPRE_Int
HYPRE_BoomerAMGSetLogging_dbl( HYPRE_Solver solver, HYPRE_Int logging );
HYPRE_Int
HYPRE_BoomerAMGSetLogging_long_dbl( HYPRE_Solver solver, HYPRE_Int logging );
HYPRE_Int
HYPRE_BoomerAMGSetLogging( HYPRE_Solver solver, HYPRE_Int logging );

HYPRE_Int
HYPRE_BoomerAMGSetMaxCoarseSize_flt( HYPRE_Solver solver, HYPRE_Int max_coarse_size );
HYPRE_Int
HYPRE_BoomerAMGSetMaxCoarseSize_dbl( HYPRE_Solver solver, HYPRE_Int max_coarse_size );
HYPRE_Int
HYPRE_BoomerAMGSetMaxCoarseSize_long_dbl( HYPRE_Solver solver, HYPRE_Int max_coarse_size );
HYPRE_Int
HYPRE_BoomerAMGSetMaxCoarseSize( HYPRE_Solver solver, HYPRE_Int max_coarse_size );

HYPRE_Int
HYPRE_BoomerAMGSetMaxIter_flt( HYPRE_Solver solver, HYPRE_Int max_iter );
HYPRE_Int
HYPRE_BoomerAMGSetMaxIter_dbl( HYPRE_Solver solver, HYPRE_Int max_iter );
HYPRE_Int
HYPRE_BoomerAMGSetMaxIter_long_dbl( HYPRE_Solver solver, HYPRE_Int max_iter );
HYPRE_Int
HYPRE_BoomerAMGSetMaxIter( HYPRE_Solver solver, HYPRE_Int max_iter );

HYPRE_Int
HYPRE_BoomerAMGSetMaxLevels_flt( HYPRE_Solver solver, HYPRE_Int max_levels );
HYPRE_Int
HYPRE_BoomerAMGSetMaxLevels_dbl( HYPRE_Solver solver, HYPRE_Int max_levels );
HYPRE_Int
HYPRE_BoomerAMGSetMaxLevels_long_dbl( HYPRE_Solver solver, HYPRE_Int max_levels );
HYPRE_Int
HYPRE_BoomerAMGSetMaxLevels( HYPRE_Solver solver, HYPRE_Int max_levels );

HYPRE_Int
HYPRE_BoomerAMGSetMaxNzPerRow_flt( HYPRE_Solver solver, HYPRE_Int max_nz_per_row );
HYPRE_Int
HYPRE_BoomerAMGSetMaxNzPerRow_dbl( HYPRE_Solver solver, HYPRE_Int max_nz_per_row );
HYPRE_Int
HYPRE_BoomerAMGSetMaxNzPerRow_long_dbl( HYPRE_Solver solver, HYPRE_Int max_nz_per_row );
HYPRE_Int
HYPRE_BoomerAMGSetMaxNzPerRow( HYPRE_Solver solver, HYPRE_Int max_nz_per_row );

HYPRE_Int
HYPRE_BoomerAMGSetMaxRowSum_flt( HYPRE_Solver solver, hypre_float max_row_sum );
HYPRE_Int
HYPRE_BoomerAMGSetMaxRowSum_dbl( HYPRE_Solver solver, hypre_double max_row_sum );
HYPRE_Int
HYPRE_BoomerAMGSetMaxRowSum_long_dbl( HYPRE_Solver solver, hypre_long_double max_row_sum );
HYPRE_Int
HYPRE_BoomerAMGSetMaxRowSum( HYPRE_Solver solver, hypre_long_double max_row_sum );

HYPRE_Int
HYPRE_BoomerAMGSetMeasureType_flt( HYPRE_Solver solver, HYPRE_Int measure_type );
HYPRE_Int
HYPRE_BoomerAMGSetMeasureType_dbl( HYPRE_Solver solver, HYPRE_Int measure_type );
HYPRE_Int
HYPRE_BoomerAMGSetMeasureType_long_dbl( HYPRE_Solver solver, HYPRE_Int measure_type );
HYPRE_Int
HYPRE_BoomerAMGSetMeasureType( HYPRE_Solver solver, HYPRE_Int measure_type );

HYPRE_Int
HYPRE_BoomerAMGSetMinCoarseSize_flt( HYPRE_Solver solver, HYPRE_Int min_coarse_size );
HYPRE_Int
HYPRE_BoomerAMGSetMinCoarseSize_dbl( HYPRE_Solver solver, HYPRE_Int min_coarse_size );
HYPRE_Int
HYPRE_BoomerAMGSetMinCoarseSize_long_dbl( HYPRE_Solver solver, HYPRE_Int min_coarse_size );
HYPRE_Int
HYPRE_BoomerAMGSetMinCoarseSize( HYPRE_Solver solver, HYPRE_Int min_coarse_size );

HYPRE_Int
HYPRE_BoomerAMGSetMinIter_flt( HYPRE_Solver solver, HYPRE_Int min_iter );
HYPRE_Int
HYPRE_BoomerAMGSetMinIter_dbl( HYPRE_Solver solver, HYPRE_Int min_iter );
HYPRE_Int
HYPRE_BoomerAMGSetMinIter_long_dbl( HYPRE_Solver solver, HYPRE_Int min_iter );
HYPRE_Int
HYPRE_BoomerAMGSetMinIter( HYPRE_Solver solver, HYPRE_Int min_iter );

HYPRE_Int
HYPRE_BoomerAMGSetModuleRAP2_flt( HYPRE_Solver solver, HYPRE_Int mod_rap2 );
HYPRE_Int
HYPRE_BoomerAMGSetModuleRAP2_dbl( HYPRE_Solver solver, HYPRE_Int mod_rap2 );
HYPRE_Int
HYPRE_BoomerAMGSetModuleRAP2_long_dbl( HYPRE_Solver solver, HYPRE_Int mod_rap2 );
HYPRE_Int
HYPRE_BoomerAMGSetModuleRAP2( HYPRE_Solver solver, HYPRE_Int mod_rap2 );

HYPRE_Int
HYPRE_BoomerAMGSetMultAddPMaxElmts_flt( HYPRE_Solver solver, HYPRE_Int add_P_max_elmts );
HYPRE_Int
HYPRE_BoomerAMGSetMultAddPMaxElmts_dbl( HYPRE_Solver solver, HYPRE_Int add_P_max_elmts );
HYPRE_Int
HYPRE_BoomerAMGSetMultAddPMaxElmts_long_dbl( HYPRE_Solver solver, HYPRE_Int add_P_max_elmts );
HYPRE_Int
HYPRE_BoomerAMGSetMultAddPMaxElmts( HYPRE_Solver solver, HYPRE_Int add_P_max_elmts );

HYPRE_Int
HYPRE_BoomerAMGSetMultAddTruncFactor_flt( HYPRE_Solver solver, hypre_float add_trunc_factor );
HYPRE_Int
HYPRE_BoomerAMGSetMultAddTruncFactor_dbl( HYPRE_Solver solver, hypre_double add_trunc_factor );
HYPRE_Int
HYPRE_BoomerAMGSetMultAddTruncFactor_long_dbl( HYPRE_Solver solver, hypre_long_double add_trunc_factor );
HYPRE_Int
HYPRE_BoomerAMGSetMultAddTruncFactor( HYPRE_Solver solver, hypre_long_double add_trunc_factor );

HYPRE_Int
HYPRE_BoomerAMGSetMultAdditive_flt( HYPRE_Solver solver, HYPRE_Int addlvl );
HYPRE_Int
HYPRE_BoomerAMGSetMultAdditive_dbl( HYPRE_Solver solver, HYPRE_Int addlvl );
HYPRE_Int
HYPRE_BoomerAMGSetMultAdditive_long_dbl( HYPRE_Solver solver, HYPRE_Int addlvl );
HYPRE_Int
HYPRE_BoomerAMGSetMultAdditive( HYPRE_Solver solver, HYPRE_Int addlvl );

HYPRE_Int
HYPRE_BoomerAMGSetNodal_flt( HYPRE_Solver solver, HYPRE_Int nodal );
HYPRE_Int
HYPRE_BoomerAMGSetNodal_dbl( HYPRE_Solver solver, HYPRE_Int nodal );
HYPRE_Int
HYPRE_BoomerAMGSetNodal_long_dbl( HYPRE_Solver solver, HYPRE_Int nodal );
HYPRE_Int
HYPRE_BoomerAMGSetNodal( HYPRE_Solver solver, HYPRE_Int nodal );

HYPRE_Int
HYPRE_BoomerAMGSetNodalDiag_flt( HYPRE_Solver solver, HYPRE_Int nodal_diag );
HYPRE_Int
HYPRE_BoomerAMGSetNodalDiag_dbl( HYPRE_Solver solver, HYPRE_Int nodal_diag );
HYPRE_Int
HYPRE_BoomerAMGSetNodalDiag_long_dbl( HYPRE_Solver solver, HYPRE_Int nodal_diag );
HYPRE_Int
HYPRE_BoomerAMGSetNodalDiag( HYPRE_Solver solver, HYPRE_Int nodal_diag );

HYPRE_Int
HYPRE_BoomerAMGSetNodalLevels_flt( HYPRE_Solver solver, HYPRE_Int nodal_levels );
HYPRE_Int
HYPRE_BoomerAMGSetNodalLevels_dbl( HYPRE_Solver solver, HYPRE_Int nodal_levels );
HYPRE_Int
HYPRE_BoomerAMGSetNodalLevels_long_dbl( HYPRE_Solver solver, HYPRE_Int nodal_levels );
HYPRE_Int
HYPRE_BoomerAMGSetNodalLevels( HYPRE_Solver solver, HYPRE_Int nodal_levels );

HYPRE_Int
HYPRE_BoomerAMGSetNonGalerkTol_flt( HYPRE_Solver solver, HYPRE_Int nongalerk_num_tol, hypre_float *nongalerk_tol );
HYPRE_Int
HYPRE_BoomerAMGSetNonGalerkTol_dbl( HYPRE_Solver solver, HYPRE_Int nongalerk_num_tol, hypre_double *nongalerk_tol );
HYPRE_Int
HYPRE_BoomerAMGSetNonGalerkTol_long_dbl( HYPRE_Solver solver, HYPRE_Int nongalerk_num_tol, hypre_long_double *nongalerk_tol );
HYPRE_Int
HYPRE_BoomerAMGSetNonGalerkTol( HYPRE_Solver solver, HYPRE_Int nongalerk_num_tol, void *nongalerk_tol );

HYPRE_Int
HYPRE_BoomerAMGSetNonGalerkinTol_flt( HYPRE_Solver solver, hypre_float nongalerkin_tol );
HYPRE_Int
HYPRE_BoomerAMGSetNonGalerkinTol_dbl( HYPRE_Solver solver, hypre_double nongalerkin_tol );
HYPRE_Int
HYPRE_BoomerAMGSetNonGalerkinTol_long_dbl( HYPRE_Solver solver, hypre_long_double nongalerkin_tol );
HYPRE_Int
HYPRE_BoomerAMGSetNonGalerkinTol( HYPRE_Solver solver, hypre_long_double nongalerkin_tol );

HYPRE_Int
HYPRE_BoomerAMGSetNumCRRelaxSteps_flt( HYPRE_Solver solver, HYPRE_Int num_CR_relax_steps );
HYPRE_Int
HYPRE_BoomerAMGSetNumCRRelaxSteps_dbl( HYPRE_Solver solver, HYPRE_Int num_CR_relax_steps );
HYPRE_Int
HYPRE_BoomerAMGSetNumCRRelaxSteps_long_dbl( HYPRE_Solver solver, HYPRE_Int num_CR_relax_steps );
HYPRE_Int
HYPRE_BoomerAMGSetNumCRRelaxSteps( HYPRE_Solver solver, HYPRE_Int num_CR_relax_steps );

HYPRE_Int
HYPRE_BoomerAMGSetNumFunctions_flt( HYPRE_Solver solver, HYPRE_Int num_functions );
HYPRE_Int
HYPRE_BoomerAMGSetNumFunctions_dbl( HYPRE_Solver solver, HYPRE_Int num_functions );
HYPRE_Int
HYPRE_BoomerAMGSetNumFunctions_long_dbl( HYPRE_Solver solver, HYPRE_Int num_functions );
HYPRE_Int
HYPRE_BoomerAMGSetNumFunctions( HYPRE_Solver solver, HYPRE_Int num_functions );

HYPRE_Int
HYPRE_BoomerAMGSetNumGridSweeps_flt( HYPRE_Solver solver, HYPRE_Int *num_grid_sweeps );
HYPRE_Int
HYPRE_BoomerAMGSetNumGridSweeps_dbl( HYPRE_Solver solver, HYPRE_Int *num_grid_sweeps );
HYPRE_Int
HYPRE_BoomerAMGSetNumGridSweeps_long_dbl( HYPRE_Solver solver, HYPRE_Int *num_grid_sweeps );
HYPRE_Int
HYPRE_BoomerAMGSetNumGridSweeps( HYPRE_Solver solver, HYPRE_Int *num_grid_sweeps );

HYPRE_Int
HYPRE_BoomerAMGSetNumPaths_flt( HYPRE_Solver solver, HYPRE_Int num_paths );
HYPRE_Int
HYPRE_BoomerAMGSetNumPaths_dbl( HYPRE_Solver solver, HYPRE_Int num_paths );
HYPRE_Int
HYPRE_BoomerAMGSetNumPaths_long_dbl( HYPRE_Solver solver, HYPRE_Int num_paths );
HYPRE_Int
HYPRE_BoomerAMGSetNumPaths( HYPRE_Solver solver, HYPRE_Int num_paths );

HYPRE_Int
HYPRE_BoomerAMGSetNumSamples_flt( HYPRE_Solver solver, HYPRE_Int num_samples );
HYPRE_Int
HYPRE_BoomerAMGSetNumSamples_dbl( HYPRE_Solver solver, HYPRE_Int num_samples );
HYPRE_Int
HYPRE_BoomerAMGSetNumSamples_long_dbl( HYPRE_Solver solver, HYPRE_Int num_samples );
HYPRE_Int
HYPRE_BoomerAMGSetNumSamples( HYPRE_Solver solver, HYPRE_Int num_samples );

HYPRE_Int
HYPRE_BoomerAMGSetNumSweeps_flt( HYPRE_Solver solver, HYPRE_Int num_sweeps );
HYPRE_Int
HYPRE_BoomerAMGSetNumSweeps_dbl( HYPRE_Solver solver, HYPRE_Int num_sweeps );
HYPRE_Int
HYPRE_BoomerAMGSetNumSweeps_long_dbl( HYPRE_Solver solver, HYPRE_Int num_sweeps );
HYPRE_Int
HYPRE_BoomerAMGSetNumSweeps( HYPRE_Solver solver, HYPRE_Int num_sweeps );

HYPRE_Int
HYPRE_BoomerAMGSetOldDefault_flt( HYPRE_Solver solver );
HYPRE_Int
HYPRE_BoomerAMGSetOldDefault_dbl( HYPRE_Solver solver );
HYPRE_Int
HYPRE_BoomerAMGSetOldDefault_long_dbl( HYPRE_Solver solver );
HYPRE_Int
HYPRE_BoomerAMGSetOldDefault( HYPRE_Solver solver );

HYPRE_Int
HYPRE_BoomerAMGSetOmega_flt( HYPRE_Solver solver, hypre_float *omega );
HYPRE_Int
HYPRE_BoomerAMGSetOmega_dbl( HYPRE_Solver solver, hypre_double *omega );
HYPRE_Int
HYPRE_BoomerAMGSetOmega_long_dbl( HYPRE_Solver solver, hypre_long_double *omega );
HYPRE_Int
HYPRE_BoomerAMGSetOmega( HYPRE_Solver solver, void *omega );

HYPRE_Int
HYPRE_BoomerAMGSetOuterWt_flt( HYPRE_Solver solver, hypre_float omega );
HYPRE_Int
HYPRE_BoomerAMGSetOuterWt_dbl( HYPRE_Solver solver, hypre_double omega );
HYPRE_Int
HYPRE_BoomerAMGSetOuterWt_long_dbl( HYPRE_Solver solver, hypre_long_double omega );
HYPRE_Int
HYPRE_BoomerAMGSetOuterWt( HYPRE_Solver solver, hypre_long_double omega );

HYPRE_Int
HYPRE_BoomerAMGSetOverlap_flt( HYPRE_Solver solver, HYPRE_Int overlap );
HYPRE_Int
HYPRE_BoomerAMGSetOverlap_dbl( HYPRE_Solver solver, HYPRE_Int overlap );
HYPRE_Int
HYPRE_BoomerAMGSetOverlap_long_dbl( HYPRE_Solver solver, HYPRE_Int overlap );
HYPRE_Int
HYPRE_BoomerAMGSetOverlap( HYPRE_Solver solver, HYPRE_Int overlap );

HYPRE_Int
HYPRE_BoomerAMGSetPMaxElmts_flt( HYPRE_Solver solver, HYPRE_Int P_max_elmts );
HYPRE_Int
HYPRE_BoomerAMGSetPMaxElmts_dbl( HYPRE_Solver solver, HYPRE_Int P_max_elmts );
HYPRE_Int
HYPRE_BoomerAMGSetPMaxElmts_long_dbl( HYPRE_Solver solver, HYPRE_Int P_max_elmts );
HYPRE_Int
HYPRE_BoomerAMGSetPMaxElmts( HYPRE_Solver solver, HYPRE_Int P_max_elmts );

HYPRE_Int
HYPRE_BoomerAMGSetPlotFileName_flt( HYPRE_Solver solver, const char *plotfilename );
HYPRE_Int
HYPRE_BoomerAMGSetPlotFileName_dbl( HYPRE_Solver solver, const char *plotfilename );
HYPRE_Int
HYPRE_BoomerAMGSetPlotFileName_long_dbl( HYPRE_Solver solver, const char *plotfilename );
HYPRE_Int
HYPRE_BoomerAMGSetPlotFileName( HYPRE_Solver solver, const char *plotfilename );

HYPRE_Int
HYPRE_BoomerAMGSetPlotGrids_flt( HYPRE_Solver solver, HYPRE_Int plotgrids );
HYPRE_Int
HYPRE_BoomerAMGSetPlotGrids_dbl( HYPRE_Solver solver, HYPRE_Int plotgrids );
HYPRE_Int
HYPRE_BoomerAMGSetPlotGrids_long_dbl( HYPRE_Solver solver, HYPRE_Int plotgrids );
HYPRE_Int
HYPRE_BoomerAMGSetPlotGrids( HYPRE_Solver solver, HYPRE_Int plotgrids );

HYPRE_Int
HYPRE_BoomerAMGSetPostInterpType_flt( HYPRE_Solver solver, HYPRE_Int post_interp_type );
HYPRE_Int
HYPRE_BoomerAMGSetPostInterpType_dbl( HYPRE_Solver solver, HYPRE_Int post_interp_type );
HYPRE_Int
HYPRE_BoomerAMGSetPostInterpType_long_dbl( HYPRE_Solver solver, HYPRE_Int post_interp_type );
HYPRE_Int
HYPRE_BoomerAMGSetPostInterpType( HYPRE_Solver solver, HYPRE_Int post_interp_type );

HYPRE_Int
HYPRE_BoomerAMGSetPrintFileName_flt( HYPRE_Solver solver, const char *print_file_name );
HYPRE_Int
HYPRE_BoomerAMGSetPrintFileName_dbl( HYPRE_Solver solver, const char *print_file_name );
HYPRE_Int
HYPRE_BoomerAMGSetPrintFileName_long_dbl( HYPRE_Solver solver, const char *print_file_name );
HYPRE_Int
HYPRE_BoomerAMGSetPrintFileName( HYPRE_Solver solver, const char *print_file_name );

HYPRE_Int
HYPRE_BoomerAMGSetPrintLevel_flt( HYPRE_Solver solver, HYPRE_Int print_level );
HYPRE_Int
HYPRE_BoomerAMGSetPrintLevel_dbl( HYPRE_Solver solver, HYPRE_Int print_level );
HYPRE_Int
HYPRE_BoomerAMGSetPrintLevel_long_dbl( HYPRE_Solver solver, HYPRE_Int print_level );
HYPRE_Int
HYPRE_BoomerAMGSetPrintLevel( HYPRE_Solver solver, HYPRE_Int print_level );

HYPRE_Int
HYPRE_BoomerAMGSetRAP2_flt( HYPRE_Solver solver, HYPRE_Int rap2 );
HYPRE_Int
HYPRE_BoomerAMGSetRAP2_dbl( HYPRE_Solver solver, HYPRE_Int rap2 );
HYPRE_Int
HYPRE_BoomerAMGSetRAP2_long_dbl( HYPRE_Solver solver, HYPRE_Int rap2 );
HYPRE_Int
HYPRE_BoomerAMGSetRAP2( HYPRE_Solver solver, HYPRE_Int rap2 );

HYPRE_Int
HYPRE_BoomerAMGSetRedundant_flt( HYPRE_Solver solver, HYPRE_Int redundant );
HYPRE_Int
HYPRE_BoomerAMGSetRedundant_dbl( HYPRE_Solver solver, HYPRE_Int redundant );
HYPRE_Int
HYPRE_BoomerAMGSetRedundant_long_dbl( HYPRE_Solver solver, HYPRE_Int redundant );
HYPRE_Int
HYPRE_BoomerAMGSetRedundant( HYPRE_Solver solver, HYPRE_Int redundant );

HYPRE_Int
HYPRE_BoomerAMGSetRelaxOrder_flt( HYPRE_Solver solver, HYPRE_Int relax_order );
HYPRE_Int
HYPRE_BoomerAMGSetRelaxOrder_dbl( HYPRE_Solver solver, HYPRE_Int relax_order );
HYPRE_Int
HYPRE_BoomerAMGSetRelaxOrder_long_dbl( HYPRE_Solver solver, HYPRE_Int relax_order );
HYPRE_Int
HYPRE_BoomerAMGSetRelaxOrder( HYPRE_Solver solver, HYPRE_Int relax_order );

HYPRE_Int
HYPRE_BoomerAMGSetRelaxType_flt( HYPRE_Solver solver, HYPRE_Int relax_type );
HYPRE_Int
HYPRE_BoomerAMGSetRelaxType_dbl( HYPRE_Solver solver, HYPRE_Int relax_type );
HYPRE_Int
HYPRE_BoomerAMGSetRelaxType_long_dbl( HYPRE_Solver solver, HYPRE_Int relax_type );
HYPRE_Int
HYPRE_BoomerAMGSetRelaxType( HYPRE_Solver solver, HYPRE_Int relax_type );

HYPRE_Int
HYPRE_BoomerAMGSetRelaxWeight_flt( HYPRE_Solver solver, hypre_float *relax_weight );
HYPRE_Int
HYPRE_BoomerAMGSetRelaxWeight_dbl( HYPRE_Solver solver, hypre_double *relax_weight );
HYPRE_Int
HYPRE_BoomerAMGSetRelaxWeight_long_dbl( HYPRE_Solver solver, hypre_long_double *relax_weight );
HYPRE_Int
HYPRE_BoomerAMGSetRelaxWeight( HYPRE_Solver solver, void *relax_weight );

HYPRE_Int
HYPRE_BoomerAMGSetRelaxWt_flt( HYPRE_Solver solver, hypre_float relax_weight );
HYPRE_Int
HYPRE_BoomerAMGSetRelaxWt_dbl( HYPRE_Solver solver, hypre_double relax_weight );
HYPRE_Int
HYPRE_BoomerAMGSetRelaxWt_long_dbl( HYPRE_Solver solver, hypre_long_double relax_weight );
HYPRE_Int
HYPRE_BoomerAMGSetRelaxWt( HYPRE_Solver solver, hypre_long_double relax_weight );

HYPRE_Int
HYPRE_BoomerAMGSetRestriction_flt( HYPRE_Solver solver, HYPRE_Int restr_par );
HYPRE_Int
HYPRE_BoomerAMGSetRestriction_dbl( HYPRE_Solver solver, HYPRE_Int restr_par );
HYPRE_Int
HYPRE_BoomerAMGSetRestriction_long_dbl( HYPRE_Solver solver, HYPRE_Int restr_par );
HYPRE_Int
HYPRE_BoomerAMGSetRestriction( HYPRE_Solver solver, HYPRE_Int restr_par );

HYPRE_Int
HYPRE_BoomerAMGSetSCommPkgSwitch_flt( HYPRE_Solver solver, hypre_float S_commpkg_switch );
HYPRE_Int
HYPRE_BoomerAMGSetSCommPkgSwitch_dbl( HYPRE_Solver solver, hypre_double S_commpkg_switch );
HYPRE_Int
HYPRE_BoomerAMGSetSCommPkgSwitch_long_dbl( HYPRE_Solver solver, hypre_long_double S_commpkg_switch );
HYPRE_Int
HYPRE_BoomerAMGSetSCommPkgSwitch( HYPRE_Solver solver, hypre_long_double S_commpkg_switch );

HYPRE_Int
HYPRE_BoomerAMGSetSabs_flt( HYPRE_Solver solver, HYPRE_Int Sabs );
HYPRE_Int
HYPRE_BoomerAMGSetSabs_dbl( HYPRE_Solver solver, HYPRE_Int Sabs );
HYPRE_Int
HYPRE_BoomerAMGSetSabs_long_dbl( HYPRE_Solver solver, HYPRE_Int Sabs );
HYPRE_Int
HYPRE_BoomerAMGSetSabs( HYPRE_Solver solver, HYPRE_Int Sabs );

HYPRE_Int
HYPRE_BoomerAMGSetSchwarzRlxWeight_flt( HYPRE_Solver solver, hypre_float schwarz_rlx_weight );
HYPRE_Int
HYPRE_BoomerAMGSetSchwarzRlxWeight_dbl( HYPRE_Solver solver, hypre_double schwarz_rlx_weight );
HYPRE_Int
HYPRE_BoomerAMGSetSchwarzRlxWeight_long_dbl( HYPRE_Solver solver, hypre_long_double schwarz_rlx_weight );
HYPRE_Int
HYPRE_BoomerAMGSetSchwarzRlxWeight( HYPRE_Solver solver, hypre_long_double schwarz_rlx_weight );

HYPRE_Int
HYPRE_BoomerAMGSetSchwarzUseNonSymm_flt( HYPRE_Solver solver, HYPRE_Int use_nonsymm );
HYPRE_Int
HYPRE_BoomerAMGSetSchwarzUseNonSymm_dbl( HYPRE_Solver solver, HYPRE_Int use_nonsymm );
HYPRE_Int
HYPRE_BoomerAMGSetSchwarzUseNonSymm_long_dbl( HYPRE_Solver solver, HYPRE_Int use_nonsymm );
HYPRE_Int
HYPRE_BoomerAMGSetSchwarzUseNonSymm( HYPRE_Solver solver, HYPRE_Int use_nonsymm );

HYPRE_Int
HYPRE_BoomerAMGSetSepWeight_flt( HYPRE_Solver solver, HYPRE_Int sep_weight );
HYPRE_Int
HYPRE_BoomerAMGSetSepWeight_dbl( HYPRE_Solver solver, HYPRE_Int sep_weight );
HYPRE_Int
HYPRE_BoomerAMGSetSepWeight_long_dbl( HYPRE_Solver solver, HYPRE_Int sep_weight );
HYPRE_Int
HYPRE_BoomerAMGSetSepWeight( HYPRE_Solver solver, HYPRE_Int sep_weight );

HYPRE_Int
HYPRE_BoomerAMGSetSeqThreshold_flt( HYPRE_Solver solver, HYPRE_Int seq_threshold );
HYPRE_Int
HYPRE_BoomerAMGSetSeqThreshold_dbl( HYPRE_Solver solver, HYPRE_Int seq_threshold );
HYPRE_Int
HYPRE_BoomerAMGSetSeqThreshold_long_dbl( HYPRE_Solver solver, HYPRE_Int seq_threshold );
HYPRE_Int
HYPRE_BoomerAMGSetSeqThreshold( HYPRE_Solver solver, HYPRE_Int seq_threshold );

HYPRE_Int
HYPRE_BoomerAMGSetSetupType_flt( HYPRE_Solver solver, HYPRE_Int setup_type );
HYPRE_Int
HYPRE_BoomerAMGSetSetupType_dbl( HYPRE_Solver solver, HYPRE_Int setup_type );
HYPRE_Int
HYPRE_BoomerAMGSetSetupType_long_dbl( HYPRE_Solver solver, HYPRE_Int setup_type );
HYPRE_Int
HYPRE_BoomerAMGSetSetupType( HYPRE_Solver solver, HYPRE_Int setup_type );

HYPRE_Int
HYPRE_BoomerAMGSetSimple_flt( HYPRE_Solver solver, HYPRE_Int addlvl );
HYPRE_Int
HYPRE_BoomerAMGSetSimple_dbl( HYPRE_Solver solver, HYPRE_Int addlvl );
HYPRE_Int
HYPRE_BoomerAMGSetSimple_long_dbl( HYPRE_Solver solver, HYPRE_Int addlvl );
HYPRE_Int
HYPRE_BoomerAMGSetSimple( HYPRE_Solver solver, HYPRE_Int addlvl );

HYPRE_Int
HYPRE_BoomerAMGSetSmoothInterpVectors_flt( HYPRE_Solver solver, HYPRE_Int smooth_interp_vectors );
HYPRE_Int
HYPRE_BoomerAMGSetSmoothInterpVectors_dbl( HYPRE_Solver solver, HYPRE_Int smooth_interp_vectors );
HYPRE_Int
HYPRE_BoomerAMGSetSmoothInterpVectors_long_dbl( HYPRE_Solver solver, HYPRE_Int smooth_interp_vectors );
HYPRE_Int
HYPRE_BoomerAMGSetSmoothInterpVectors( HYPRE_Solver solver, HYPRE_Int smooth_interp_vectors );

HYPRE_Int
HYPRE_BoomerAMGSetSmoothNumLevels_flt( HYPRE_Solver solver, HYPRE_Int smooth_num_levels );
HYPRE_Int
HYPRE_BoomerAMGSetSmoothNumLevels_dbl( HYPRE_Solver solver, HYPRE_Int smooth_num_levels );
HYPRE_Int
HYPRE_BoomerAMGSetSmoothNumLevels_long_dbl( HYPRE_Solver solver, HYPRE_Int smooth_num_levels );
HYPRE_Int
HYPRE_BoomerAMGSetSmoothNumLevels( HYPRE_Solver solver, HYPRE_Int smooth_num_levels );

HYPRE_Int
HYPRE_BoomerAMGSetSmoothNumSweeps_flt( HYPRE_Solver solver, HYPRE_Int smooth_num_sweeps );
HYPRE_Int
HYPRE_BoomerAMGSetSmoothNumSweeps_dbl( HYPRE_Solver solver, HYPRE_Int smooth_num_sweeps );
HYPRE_Int
HYPRE_BoomerAMGSetSmoothNumSweeps_long_dbl( HYPRE_Solver solver, HYPRE_Int smooth_num_sweeps );
HYPRE_Int
HYPRE_BoomerAMGSetSmoothNumSweeps( HYPRE_Solver solver, HYPRE_Int smooth_num_sweeps );

HYPRE_Int
HYPRE_BoomerAMGSetSmoothType_flt( HYPRE_Solver solver, HYPRE_Int smooth_type );
HYPRE_Int
HYPRE_BoomerAMGSetSmoothType_dbl( HYPRE_Solver solver, HYPRE_Int smooth_type );
HYPRE_Int
HYPRE_BoomerAMGSetSmoothType_long_dbl( HYPRE_Solver solver, HYPRE_Int smooth_type );
HYPRE_Int
HYPRE_BoomerAMGSetSmoothType( HYPRE_Solver solver, HYPRE_Int smooth_type );

HYPRE_Int
HYPRE_BoomerAMGSetStrongThreshold_flt( HYPRE_Solver solver, hypre_float strong_threshold );
HYPRE_Int
HYPRE_BoomerAMGSetStrongThreshold_dbl( HYPRE_Solver solver, hypre_double strong_threshold );
HYPRE_Int
HYPRE_BoomerAMGSetStrongThreshold_long_dbl( HYPRE_Solver solver, hypre_long_double strong_threshold );
HYPRE_Int
HYPRE_BoomerAMGSetStrongThreshold( HYPRE_Solver solver, hypre_long_double strong_threshold );

HYPRE_Int
HYPRE_BoomerAMGSetStrongThresholdR_flt( HYPRE_Solver solver, hypre_float strong_threshold );
HYPRE_Int
HYPRE_BoomerAMGSetStrongThresholdR_dbl( HYPRE_Solver solver, hypre_double strong_threshold );
HYPRE_Int
HYPRE_BoomerAMGSetStrongThresholdR_long_dbl( HYPRE_Solver solver, hypre_long_double strong_threshold );
HYPRE_Int
HYPRE_BoomerAMGSetStrongThresholdR( HYPRE_Solver solver, hypre_long_double strong_threshold );

HYPRE_Int
HYPRE_BoomerAMGSetSym_flt( HYPRE_Solver solver, HYPRE_Int sym );
HYPRE_Int
HYPRE_BoomerAMGSetSym_dbl( HYPRE_Solver solver, HYPRE_Int sym );
HYPRE_Int
HYPRE_BoomerAMGSetSym_long_dbl( HYPRE_Solver solver, HYPRE_Int sym );
HYPRE_Int
HYPRE_BoomerAMGSetSym( HYPRE_Solver solver, HYPRE_Int sym );

HYPRE_Int
HYPRE_BoomerAMGSetThreshold_flt( HYPRE_Solver solver, hypre_float threshold );
HYPRE_Int
HYPRE_BoomerAMGSetThreshold_dbl( HYPRE_Solver solver, hypre_double threshold );
HYPRE_Int
HYPRE_BoomerAMGSetThreshold_long_dbl( HYPRE_Solver solver, hypre_long_double threshold );
HYPRE_Int
HYPRE_BoomerAMGSetThreshold( HYPRE_Solver solver, hypre_long_double threshold );

HYPRE_Int
HYPRE_BoomerAMGSetTol_flt( HYPRE_Solver solver, hypre_float tol );
HYPRE_Int
HYPRE_BoomerAMGSetTol_dbl( HYPRE_Solver solver, hypre_double tol );
HYPRE_Int
HYPRE_BoomerAMGSetTol_long_dbl( HYPRE_Solver solver, hypre_long_double tol );
HYPRE_Int
HYPRE_BoomerAMGSetTol( HYPRE_Solver solver, hypre_long_double tol );

HYPRE_Int
HYPRE_BoomerAMGSetTruncFactor_flt( HYPRE_Solver solver, hypre_float trunc_factor );
HYPRE_Int
HYPRE_BoomerAMGSetTruncFactor_dbl( HYPRE_Solver solver, hypre_double trunc_factor );
HYPRE_Int
HYPRE_BoomerAMGSetTruncFactor_long_dbl( HYPRE_Solver solver, hypre_long_double trunc_factor );
HYPRE_Int
HYPRE_BoomerAMGSetTruncFactor( HYPRE_Solver solver, hypre_long_double trunc_factor );

HYPRE_Int
HYPRE_BoomerAMGSetVariant_flt( HYPRE_Solver solver, HYPRE_Int variant );
HYPRE_Int
HYPRE_BoomerAMGSetVariant_dbl( HYPRE_Solver solver, HYPRE_Int variant );
HYPRE_Int
HYPRE_BoomerAMGSetVariant_long_dbl( HYPRE_Solver solver, HYPRE_Int variant );
HYPRE_Int
HYPRE_BoomerAMGSetVariant( HYPRE_Solver solver, HYPRE_Int variant );

HYPRE_Int
HYPRE_BoomerAMGSetup_flt( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_BoomerAMGSetup_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_BoomerAMGSetup_long_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_BoomerAMGSetup( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );

HYPRE_Int
HYPRE_BoomerAMGSolve_flt( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_BoomerAMGSolve_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_BoomerAMGSolve_long_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_BoomerAMGSolve( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );

HYPRE_Int
HYPRE_BoomerAMGSolveT_flt( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_BoomerAMGSolveT_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_BoomerAMGSolveT_long_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_BoomerAMGSolveT( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );

HYPRE_Int
HYPRE_EuclidCreate_flt( MPI_Comm comm, HYPRE_Solver *solver );
HYPRE_Int
HYPRE_EuclidCreate_dbl( MPI_Comm comm, HYPRE_Solver *solver );
HYPRE_Int
HYPRE_EuclidCreate_long_dbl( MPI_Comm comm, HYPRE_Solver *solver );
HYPRE_Int
HYPRE_EuclidCreate( MPI_Comm comm, HYPRE_Solver *solver );

HYPRE_Int
HYPRE_EuclidDestroy_flt( HYPRE_Solver solver );
HYPRE_Int
HYPRE_EuclidDestroy_dbl( HYPRE_Solver solver );
HYPRE_Int
HYPRE_EuclidDestroy_long_dbl( HYPRE_Solver solver );
HYPRE_Int
HYPRE_EuclidDestroy( HYPRE_Solver solver );

HYPRE_Int
HYPRE_EuclidSetBJ_flt( HYPRE_Solver solver, HYPRE_Int bj );
HYPRE_Int
HYPRE_EuclidSetBJ_dbl( HYPRE_Solver solver, HYPRE_Int bj );
HYPRE_Int
HYPRE_EuclidSetBJ_long_dbl( HYPRE_Solver solver, HYPRE_Int bj );
HYPRE_Int
HYPRE_EuclidSetBJ( HYPRE_Solver solver, HYPRE_Int bj );

HYPRE_Int
HYPRE_EuclidSetILUT_flt( HYPRE_Solver solver, hypre_float drop_tol );
HYPRE_Int
HYPRE_EuclidSetILUT_dbl( HYPRE_Solver solver, hypre_double drop_tol );
HYPRE_Int
HYPRE_EuclidSetILUT_long_dbl( HYPRE_Solver solver, hypre_long_double drop_tol );
HYPRE_Int
HYPRE_EuclidSetILUT( HYPRE_Solver solver, hypre_long_double drop_tol );

HYPRE_Int
HYPRE_EuclidSetLevel_flt( HYPRE_Solver solver, HYPRE_Int level );
HYPRE_Int
HYPRE_EuclidSetLevel_dbl( HYPRE_Solver solver, HYPRE_Int level );
HYPRE_Int
HYPRE_EuclidSetLevel_long_dbl( HYPRE_Solver solver, HYPRE_Int level );
HYPRE_Int
HYPRE_EuclidSetLevel( HYPRE_Solver solver, HYPRE_Int level );

HYPRE_Int
HYPRE_EuclidSetMem_flt( HYPRE_Solver solver, HYPRE_Int eu_mem );
HYPRE_Int
HYPRE_EuclidSetMem_dbl( HYPRE_Solver solver, HYPRE_Int eu_mem );
HYPRE_Int
HYPRE_EuclidSetMem_long_dbl( HYPRE_Solver solver, HYPRE_Int eu_mem );
HYPRE_Int
HYPRE_EuclidSetMem( HYPRE_Solver solver, HYPRE_Int eu_mem );

HYPRE_Int
HYPRE_EuclidSetParams_flt( HYPRE_Solver solver, HYPRE_Int argc, char *argv[] );
HYPRE_Int
HYPRE_EuclidSetParams_dbl( HYPRE_Solver solver, HYPRE_Int argc, char *argv[] );
HYPRE_Int
HYPRE_EuclidSetParams_long_dbl( HYPRE_Solver solver, HYPRE_Int argc, char *argv[] );
HYPRE_Int
HYPRE_EuclidSetParams( HYPRE_Solver solver, HYPRE_Int argc, char *argv[] );

HYPRE_Int
HYPRE_EuclidSetParamsFromFile_flt( HYPRE_Solver solver, char *filename );
HYPRE_Int
HYPRE_EuclidSetParamsFromFile_dbl( HYPRE_Solver solver, char *filename );
HYPRE_Int
HYPRE_EuclidSetParamsFromFile_long_dbl( HYPRE_Solver solver, char *filename );
HYPRE_Int
HYPRE_EuclidSetParamsFromFile( HYPRE_Solver solver, char *filename );

HYPRE_Int
HYPRE_EuclidSetRowScale_flt( HYPRE_Solver solver, HYPRE_Int row_scale );
HYPRE_Int
HYPRE_EuclidSetRowScale_dbl( HYPRE_Solver solver, HYPRE_Int row_scale );
HYPRE_Int
HYPRE_EuclidSetRowScale_long_dbl( HYPRE_Solver solver, HYPRE_Int row_scale );
HYPRE_Int
HYPRE_EuclidSetRowScale( HYPRE_Solver solver, HYPRE_Int row_scale );

HYPRE_Int
HYPRE_EuclidSetSparseA_flt( HYPRE_Solver solver, hypre_float sparse_A );
HYPRE_Int
HYPRE_EuclidSetSparseA_dbl( HYPRE_Solver solver, hypre_double sparse_A );
HYPRE_Int
HYPRE_EuclidSetSparseA_long_dbl( HYPRE_Solver solver, hypre_long_double sparse_A );
HYPRE_Int
HYPRE_EuclidSetSparseA( HYPRE_Solver solver, hypre_long_double sparse_A );

HYPRE_Int
HYPRE_EuclidSetStats_flt( HYPRE_Solver solver, HYPRE_Int eu_stats );
HYPRE_Int
HYPRE_EuclidSetStats_dbl( HYPRE_Solver solver, HYPRE_Int eu_stats );
HYPRE_Int
HYPRE_EuclidSetStats_long_dbl( HYPRE_Solver solver, HYPRE_Int eu_stats );
HYPRE_Int
HYPRE_EuclidSetStats( HYPRE_Solver solver, HYPRE_Int eu_stats );

HYPRE_Int
HYPRE_EuclidSetup_flt( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_EuclidSetup_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_EuclidSetup_long_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_EuclidSetup( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );

HYPRE_Int
HYPRE_EuclidSolve_flt( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_EuclidSolve_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_EuclidSolve_long_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_EuclidSolve( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );

HYPRE_Int
HYPRE_FSAICreate_flt( HYPRE_Solver *solver );
HYPRE_Int
HYPRE_FSAICreate_dbl( HYPRE_Solver *solver );
HYPRE_Int
HYPRE_FSAICreate_long_dbl( HYPRE_Solver *solver );
HYPRE_Int
HYPRE_FSAICreate( HYPRE_Solver *solver );

HYPRE_Int
HYPRE_FSAIDestroy_flt( HYPRE_Solver solver );
HYPRE_Int
HYPRE_FSAIDestroy_dbl( HYPRE_Solver solver );
HYPRE_Int
HYPRE_FSAIDestroy_long_dbl( HYPRE_Solver solver );
HYPRE_Int
HYPRE_FSAIDestroy( HYPRE_Solver solver );

HYPRE_Int
HYPRE_FSAISetAlgoType_flt( HYPRE_Solver solver, HYPRE_Int algo_type );
HYPRE_Int
HYPRE_FSAISetAlgoType_dbl( HYPRE_Solver solver, HYPRE_Int algo_type );
HYPRE_Int
HYPRE_FSAISetAlgoType_long_dbl( HYPRE_Solver solver, HYPRE_Int algo_type );
HYPRE_Int
HYPRE_FSAISetAlgoType( HYPRE_Solver solver, HYPRE_Int algo_type );

HYPRE_Int
HYPRE_FSAISetEigMaxIters_flt( HYPRE_Solver solver, HYPRE_Int eig_max_iters );
HYPRE_Int
HYPRE_FSAISetEigMaxIters_dbl( HYPRE_Solver solver, HYPRE_Int eig_max_iters );
HYPRE_Int
HYPRE_FSAISetEigMaxIters_long_dbl( HYPRE_Solver solver, HYPRE_Int eig_max_iters );
HYPRE_Int
HYPRE_FSAISetEigMaxIters( HYPRE_Solver solver, HYPRE_Int eig_max_iters );

HYPRE_Int
HYPRE_FSAISetKapTolerance_flt( HYPRE_Solver solver, hypre_float kap_tolerance );
HYPRE_Int
HYPRE_FSAISetKapTolerance_dbl( HYPRE_Solver solver, hypre_double kap_tolerance );
HYPRE_Int
HYPRE_FSAISetKapTolerance_long_dbl( HYPRE_Solver solver, hypre_long_double kap_tolerance );
HYPRE_Int
HYPRE_FSAISetKapTolerance( HYPRE_Solver solver, hypre_long_double kap_tolerance );

HYPRE_Int
HYPRE_FSAISetLocalSolveType_flt( HYPRE_Solver solver, HYPRE_Int local_solve_type );
HYPRE_Int
HYPRE_FSAISetLocalSolveType_dbl( HYPRE_Solver solver, HYPRE_Int local_solve_type );
HYPRE_Int
HYPRE_FSAISetLocalSolveType_long_dbl( HYPRE_Solver solver, HYPRE_Int local_solve_type );
HYPRE_Int
HYPRE_FSAISetLocalSolveType( HYPRE_Solver solver, HYPRE_Int local_solve_type );

HYPRE_Int
HYPRE_FSAISetMaxIterations_flt( HYPRE_Solver solver, HYPRE_Int max_iterations );
HYPRE_Int
HYPRE_FSAISetMaxIterations_dbl( HYPRE_Solver solver, HYPRE_Int max_iterations );
HYPRE_Int
HYPRE_FSAISetMaxIterations_long_dbl( HYPRE_Solver solver, HYPRE_Int max_iterations );
HYPRE_Int
HYPRE_FSAISetMaxIterations( HYPRE_Solver solver, HYPRE_Int max_iterations );

HYPRE_Int
HYPRE_FSAISetMaxNnzRow_flt( HYPRE_Solver solver, HYPRE_Int max_nnz_row );
HYPRE_Int
HYPRE_FSAISetMaxNnzRow_dbl( HYPRE_Solver solver, HYPRE_Int max_nnz_row );
HYPRE_Int
HYPRE_FSAISetMaxNnzRow_long_dbl( HYPRE_Solver solver, HYPRE_Int max_nnz_row );
HYPRE_Int
HYPRE_FSAISetMaxNnzRow( HYPRE_Solver solver, HYPRE_Int max_nnz_row );

HYPRE_Int
HYPRE_FSAISetMaxStepSize_flt( HYPRE_Solver solver, HYPRE_Int max_step_size );
HYPRE_Int
HYPRE_FSAISetMaxStepSize_dbl( HYPRE_Solver solver, HYPRE_Int max_step_size );
HYPRE_Int
HYPRE_FSAISetMaxStepSize_long_dbl( HYPRE_Solver solver, HYPRE_Int max_step_size );
HYPRE_Int
HYPRE_FSAISetMaxStepSize( HYPRE_Solver solver, HYPRE_Int max_step_size );

HYPRE_Int
HYPRE_FSAISetMaxSteps_flt( HYPRE_Solver solver, HYPRE_Int max_steps );
HYPRE_Int
HYPRE_FSAISetMaxSteps_dbl( HYPRE_Solver solver, HYPRE_Int max_steps );
HYPRE_Int
HYPRE_FSAISetMaxSteps_long_dbl( HYPRE_Solver solver, HYPRE_Int max_steps );
HYPRE_Int
HYPRE_FSAISetMaxSteps( HYPRE_Solver solver, HYPRE_Int max_steps );

HYPRE_Int
HYPRE_FSAISetNumLevels_flt( HYPRE_Solver solver, HYPRE_Int num_levels );
HYPRE_Int
HYPRE_FSAISetNumLevels_dbl( HYPRE_Solver solver, HYPRE_Int num_levels );
HYPRE_Int
HYPRE_FSAISetNumLevels_long_dbl( HYPRE_Solver solver, HYPRE_Int num_levels );
HYPRE_Int
HYPRE_FSAISetNumLevels( HYPRE_Solver solver, HYPRE_Int num_levels );

HYPRE_Int
HYPRE_FSAISetOmega_flt( HYPRE_Solver solver, hypre_float omega );
HYPRE_Int
HYPRE_FSAISetOmega_dbl( HYPRE_Solver solver, hypre_double omega );
HYPRE_Int
HYPRE_FSAISetOmega_long_dbl( HYPRE_Solver solver, hypre_long_double omega );
HYPRE_Int
HYPRE_FSAISetOmega( HYPRE_Solver solver, hypre_long_double omega );

HYPRE_Int
HYPRE_FSAISetPrintLevel_flt( HYPRE_Solver solver, HYPRE_Int print_level );
HYPRE_Int
HYPRE_FSAISetPrintLevel_dbl( HYPRE_Solver solver, HYPRE_Int print_level );
HYPRE_Int
HYPRE_FSAISetPrintLevel_long_dbl( HYPRE_Solver solver, HYPRE_Int print_level );
HYPRE_Int
HYPRE_FSAISetPrintLevel( HYPRE_Solver solver, HYPRE_Int print_level );

HYPRE_Int
HYPRE_FSAISetThreshold_flt( HYPRE_Solver solver, hypre_float threshold );
HYPRE_Int
HYPRE_FSAISetThreshold_dbl( HYPRE_Solver solver, hypre_double threshold );
HYPRE_Int
HYPRE_FSAISetThreshold_long_dbl( HYPRE_Solver solver, hypre_long_double threshold );
HYPRE_Int
HYPRE_FSAISetThreshold( HYPRE_Solver solver, hypre_long_double threshold );

HYPRE_Int
HYPRE_FSAISetTolerance_flt( HYPRE_Solver solver, hypre_float tolerance );
HYPRE_Int
HYPRE_FSAISetTolerance_dbl( HYPRE_Solver solver, hypre_double tolerance );
HYPRE_Int
HYPRE_FSAISetTolerance_long_dbl( HYPRE_Solver solver, hypre_long_double tolerance );
HYPRE_Int
HYPRE_FSAISetTolerance( HYPRE_Solver solver, hypre_long_double tolerance );

HYPRE_Int
HYPRE_FSAISetZeroGuess_flt( HYPRE_Solver solver, HYPRE_Int zero_guess );
HYPRE_Int
HYPRE_FSAISetZeroGuess_dbl( HYPRE_Solver solver, HYPRE_Int zero_guess );
HYPRE_Int
HYPRE_FSAISetZeroGuess_long_dbl( HYPRE_Solver solver, HYPRE_Int zero_guess );
HYPRE_Int
HYPRE_FSAISetZeroGuess( HYPRE_Solver solver, HYPRE_Int zero_guess );

HYPRE_Int
HYPRE_FSAISetup_flt( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_FSAISetup_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_FSAISetup_long_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_FSAISetup( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );

HYPRE_Int
HYPRE_FSAISolve_flt( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_FSAISolve_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_FSAISolve_long_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_FSAISolve( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );

HYPRE_Int
HYPRE_ILUCreate_flt( HYPRE_Solver *solver );
HYPRE_Int
HYPRE_ILUCreate_dbl( HYPRE_Solver *solver );
HYPRE_Int
HYPRE_ILUCreate_long_dbl( HYPRE_Solver *solver );
HYPRE_Int
HYPRE_ILUCreate( HYPRE_Solver *solver );

HYPRE_Int
HYPRE_ILUDestroy_flt( HYPRE_Solver solver );
HYPRE_Int
HYPRE_ILUDestroy_dbl( HYPRE_Solver solver );
HYPRE_Int
HYPRE_ILUDestroy_long_dbl( HYPRE_Solver solver );
HYPRE_Int
HYPRE_ILUDestroy( HYPRE_Solver solver );

HYPRE_Int
HYPRE_ILUGetFinalRelativeResidualNorm_flt( HYPRE_Solver solver, hypre_float *res_norm );
HYPRE_Int
HYPRE_ILUGetFinalRelativeResidualNorm_dbl( HYPRE_Solver solver, hypre_double *res_norm );
HYPRE_Int
HYPRE_ILUGetFinalRelativeResidualNorm_long_dbl( HYPRE_Solver solver, hypre_long_double *res_norm );
HYPRE_Int
HYPRE_ILUGetFinalRelativeResidualNorm( HYPRE_Solver solver, void *res_norm );

HYPRE_Int
HYPRE_ILUGetNumIterations_flt( HYPRE_Solver solver, HYPRE_Int *num_iterations );
HYPRE_Int
HYPRE_ILUGetNumIterations_dbl( HYPRE_Solver solver, HYPRE_Int *num_iterations );
HYPRE_Int
HYPRE_ILUGetNumIterations_long_dbl( HYPRE_Solver solver, HYPRE_Int *num_iterations );
HYPRE_Int
HYPRE_ILUGetNumIterations( HYPRE_Solver solver, HYPRE_Int *num_iterations );

HYPRE_Int
HYPRE_ILUSetDropThreshold_flt( HYPRE_Solver solver, hypre_float threshold );
HYPRE_Int
HYPRE_ILUSetDropThreshold_dbl( HYPRE_Solver solver, hypre_double threshold );
HYPRE_Int
HYPRE_ILUSetDropThreshold_long_dbl( HYPRE_Solver solver, hypre_long_double threshold );
HYPRE_Int
HYPRE_ILUSetDropThreshold( HYPRE_Solver solver, hypre_long_double threshold );

HYPRE_Int
HYPRE_ILUSetDropThresholdArray_flt( HYPRE_Solver solver, hypre_float *threshold );
HYPRE_Int
HYPRE_ILUSetDropThresholdArray_dbl( HYPRE_Solver solver, hypre_double *threshold );
HYPRE_Int
HYPRE_ILUSetDropThresholdArray_long_dbl( HYPRE_Solver solver, hypre_long_double *threshold );
HYPRE_Int
HYPRE_ILUSetDropThresholdArray( HYPRE_Solver solver, void *threshold );

HYPRE_Int
HYPRE_ILUSetIterativeSetupMaxIter_flt( HYPRE_Solver solver, HYPRE_Int iter_setup_max_iter );
HYPRE_Int
HYPRE_ILUSetIterativeSetupMaxIter_dbl( HYPRE_Solver solver, HYPRE_Int iter_setup_max_iter );
HYPRE_Int
HYPRE_ILUSetIterativeSetupMaxIter_long_dbl( HYPRE_Solver solver, HYPRE_Int iter_setup_max_iter );
HYPRE_Int
HYPRE_ILUSetIterativeSetupMaxIter( HYPRE_Solver solver, HYPRE_Int iter_setup_max_iter );

HYPRE_Int
HYPRE_ILUSetIterativeSetupOption_flt( HYPRE_Solver solver, HYPRE_Int iter_setup_option );
HYPRE_Int
HYPRE_ILUSetIterativeSetupOption_dbl( HYPRE_Solver solver, HYPRE_Int iter_setup_option );
HYPRE_Int
HYPRE_ILUSetIterativeSetupOption_long_dbl( HYPRE_Solver solver, HYPRE_Int iter_setup_option );
HYPRE_Int
HYPRE_ILUSetIterativeSetupOption( HYPRE_Solver solver, HYPRE_Int iter_setup_option );

HYPRE_Int
HYPRE_ILUSetIterativeSetupTolerance_flt( HYPRE_Solver solver, hypre_float iter_setup_tolerance );
HYPRE_Int
HYPRE_ILUSetIterativeSetupTolerance_dbl( HYPRE_Solver solver, hypre_double iter_setup_tolerance );
HYPRE_Int
HYPRE_ILUSetIterativeSetupTolerance_long_dbl( HYPRE_Solver solver, hypre_long_double iter_setup_tolerance );
HYPRE_Int
HYPRE_ILUSetIterativeSetupTolerance( HYPRE_Solver solver, hypre_long_double iter_setup_tolerance );

HYPRE_Int
HYPRE_ILUSetIterativeSetupType_flt( HYPRE_Solver solver, HYPRE_Int iter_setup_type );
HYPRE_Int
HYPRE_ILUSetIterativeSetupType_dbl( HYPRE_Solver solver, HYPRE_Int iter_setup_type );
HYPRE_Int
HYPRE_ILUSetIterativeSetupType_long_dbl( HYPRE_Solver solver, HYPRE_Int iter_setup_type );
HYPRE_Int
HYPRE_ILUSetIterativeSetupType( HYPRE_Solver solver, HYPRE_Int iter_setup_type );

HYPRE_Int
HYPRE_ILUSetLevelOfFill_flt( HYPRE_Solver solver, HYPRE_Int lfil );
HYPRE_Int
HYPRE_ILUSetLevelOfFill_dbl( HYPRE_Solver solver, HYPRE_Int lfil );
HYPRE_Int
HYPRE_ILUSetLevelOfFill_long_dbl( HYPRE_Solver solver, HYPRE_Int lfil );
HYPRE_Int
HYPRE_ILUSetLevelOfFill( HYPRE_Solver solver, HYPRE_Int lfil );

HYPRE_Int
HYPRE_ILUSetLocalReordering_flt( HYPRE_Solver solver, HYPRE_Int reordering_type );
HYPRE_Int
HYPRE_ILUSetLocalReordering_dbl( HYPRE_Solver solver, HYPRE_Int reordering_type );
HYPRE_Int
HYPRE_ILUSetLocalReordering_long_dbl( HYPRE_Solver solver, HYPRE_Int reordering_type );
HYPRE_Int
HYPRE_ILUSetLocalReordering( HYPRE_Solver solver, HYPRE_Int reordering_type );

HYPRE_Int
HYPRE_ILUSetLogging_flt( HYPRE_Solver solver, HYPRE_Int logging );
HYPRE_Int
HYPRE_ILUSetLogging_dbl( HYPRE_Solver solver, HYPRE_Int logging );
HYPRE_Int
HYPRE_ILUSetLogging_long_dbl( HYPRE_Solver solver, HYPRE_Int logging );
HYPRE_Int
HYPRE_ILUSetLogging( HYPRE_Solver solver, HYPRE_Int logging );

HYPRE_Int
HYPRE_ILUSetLowerJacobiIters_flt( HYPRE_Solver solver, HYPRE_Int lower_jacobi_iterations );
HYPRE_Int
HYPRE_ILUSetLowerJacobiIters_dbl( HYPRE_Solver solver, HYPRE_Int lower_jacobi_iterations );
HYPRE_Int
HYPRE_ILUSetLowerJacobiIters_long_dbl( HYPRE_Solver solver, HYPRE_Int lower_jacobi_iterations );
HYPRE_Int
HYPRE_ILUSetLowerJacobiIters( HYPRE_Solver solver, HYPRE_Int lower_jacobi_iterations );

HYPRE_Int
HYPRE_ILUSetMaxIter_flt( HYPRE_Solver solver, HYPRE_Int max_iter );
HYPRE_Int
HYPRE_ILUSetMaxIter_dbl( HYPRE_Solver solver, HYPRE_Int max_iter );
HYPRE_Int
HYPRE_ILUSetMaxIter_long_dbl( HYPRE_Solver solver, HYPRE_Int max_iter );
HYPRE_Int
HYPRE_ILUSetMaxIter( HYPRE_Solver solver, HYPRE_Int max_iter );

HYPRE_Int
HYPRE_ILUSetMaxNnzPerRow_flt( HYPRE_Solver solver, HYPRE_Int nzmax );
HYPRE_Int
HYPRE_ILUSetMaxNnzPerRow_dbl( HYPRE_Solver solver, HYPRE_Int nzmax );
HYPRE_Int
HYPRE_ILUSetMaxNnzPerRow_long_dbl( HYPRE_Solver solver, HYPRE_Int nzmax );
HYPRE_Int
HYPRE_ILUSetMaxNnzPerRow( HYPRE_Solver solver, HYPRE_Int nzmax );

HYPRE_Int
HYPRE_ILUSetNSHDropThreshold_flt( HYPRE_Solver solver, hypre_float threshold );
HYPRE_Int
HYPRE_ILUSetNSHDropThreshold_dbl( HYPRE_Solver solver, hypre_double threshold );
HYPRE_Int
HYPRE_ILUSetNSHDropThreshold_long_dbl( HYPRE_Solver solver, hypre_long_double threshold );
HYPRE_Int
HYPRE_ILUSetNSHDropThreshold( HYPRE_Solver solver, hypre_long_double threshold );

HYPRE_Int
HYPRE_ILUSetNSHDropThresholdArray_flt( HYPRE_Solver solver, hypre_float *threshold );
HYPRE_Int
HYPRE_ILUSetNSHDropThresholdArray_dbl( HYPRE_Solver solver, hypre_double *threshold );
HYPRE_Int
HYPRE_ILUSetNSHDropThresholdArray_long_dbl( HYPRE_Solver solver, hypre_long_double *threshold );
HYPRE_Int
HYPRE_ILUSetNSHDropThresholdArray( HYPRE_Solver solver, void *threshold );

HYPRE_Int
HYPRE_ILUSetPrintLevel_flt( HYPRE_Solver solver, HYPRE_Int print_level );
HYPRE_Int
HYPRE_ILUSetPrintLevel_dbl( HYPRE_Solver solver, HYPRE_Int print_level );
HYPRE_Int
HYPRE_ILUSetPrintLevel_long_dbl( HYPRE_Solver solver, HYPRE_Int print_level );
HYPRE_Int
HYPRE_ILUSetPrintLevel( HYPRE_Solver solver, HYPRE_Int print_level );

HYPRE_Int
HYPRE_ILUSetSchurMaxIter_flt( HYPRE_Solver solver, HYPRE_Int ss_max_iter );
HYPRE_Int
HYPRE_ILUSetSchurMaxIter_dbl( HYPRE_Solver solver, HYPRE_Int ss_max_iter );
HYPRE_Int
HYPRE_ILUSetSchurMaxIter_long_dbl( HYPRE_Solver solver, HYPRE_Int ss_max_iter );
HYPRE_Int
HYPRE_ILUSetSchurMaxIter( HYPRE_Solver solver, HYPRE_Int ss_max_iter );

HYPRE_Int
HYPRE_ILUSetTol_flt( HYPRE_Solver solver, hypre_float tol );
HYPRE_Int
HYPRE_ILUSetTol_dbl( HYPRE_Solver solver, hypre_double tol );
HYPRE_Int
HYPRE_ILUSetTol_long_dbl( HYPRE_Solver solver, hypre_long_double tol );
HYPRE_Int
HYPRE_ILUSetTol( HYPRE_Solver solver, hypre_long_double tol );

HYPRE_Int
HYPRE_ILUSetTriSolve_flt( HYPRE_Solver solver, HYPRE_Int tri_solve );
HYPRE_Int
HYPRE_ILUSetTriSolve_dbl( HYPRE_Solver solver, HYPRE_Int tri_solve );
HYPRE_Int
HYPRE_ILUSetTriSolve_long_dbl( HYPRE_Solver solver, HYPRE_Int tri_solve );
HYPRE_Int
HYPRE_ILUSetTriSolve( HYPRE_Solver solver, HYPRE_Int tri_solve );

HYPRE_Int
HYPRE_ILUSetType_flt( HYPRE_Solver solver, HYPRE_Int ilu_type );
HYPRE_Int
HYPRE_ILUSetType_dbl( HYPRE_Solver solver, HYPRE_Int ilu_type );
HYPRE_Int
HYPRE_ILUSetType_long_dbl( HYPRE_Solver solver, HYPRE_Int ilu_type );
HYPRE_Int
HYPRE_ILUSetType( HYPRE_Solver solver, HYPRE_Int ilu_type );

HYPRE_Int
HYPRE_ILUSetUpperJacobiIters_flt( HYPRE_Solver solver, HYPRE_Int upper_jacobi_iterations );
HYPRE_Int
HYPRE_ILUSetUpperJacobiIters_dbl( HYPRE_Solver solver, HYPRE_Int upper_jacobi_iterations );
HYPRE_Int
HYPRE_ILUSetUpperJacobiIters_long_dbl( HYPRE_Solver solver, HYPRE_Int upper_jacobi_iterations );
HYPRE_Int
HYPRE_ILUSetUpperJacobiIters( HYPRE_Solver solver, HYPRE_Int upper_jacobi_iterations );

HYPRE_Int
HYPRE_ILUSetup_flt( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_ILUSetup_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_ILUSetup_long_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_ILUSetup( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );

HYPRE_Int
HYPRE_ILUSolve_flt( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_ILUSolve_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_ILUSolve_long_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_ILUSolve( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );

HYPRE_Int
HYPRE_MGRBuildAff_flt( HYPRE_ParCSRMatrix A, HYPRE_Int *CF_marker, HYPRE_Int debug_flag, HYPRE_ParCSRMatrix *A_ff );
HYPRE_Int
HYPRE_MGRBuildAff_dbl( HYPRE_ParCSRMatrix A, HYPRE_Int *CF_marker, HYPRE_Int debug_flag, HYPRE_ParCSRMatrix *A_ff );
HYPRE_Int
HYPRE_MGRBuildAff_long_dbl( HYPRE_ParCSRMatrix A, HYPRE_Int *CF_marker, HYPRE_Int debug_flag, HYPRE_ParCSRMatrix *A_ff );
HYPRE_Int
HYPRE_MGRBuildAff( HYPRE_ParCSRMatrix A, HYPRE_Int *CF_marker, HYPRE_Int debug_flag, HYPRE_ParCSRMatrix *A_ff );

HYPRE_Int
HYPRE_MGRCreate_flt( HYPRE_Solver *solver );
HYPRE_Int
HYPRE_MGRCreate_dbl( HYPRE_Solver *solver );
HYPRE_Int
HYPRE_MGRCreate_long_dbl( HYPRE_Solver *solver );
HYPRE_Int
HYPRE_MGRCreate( HYPRE_Solver *solver );

HYPRE_Int
HYPRE_MGRDestroy_flt( HYPRE_Solver solver );
HYPRE_Int
HYPRE_MGRDestroy_dbl( HYPRE_Solver solver );
HYPRE_Int
HYPRE_MGRDestroy_long_dbl( HYPRE_Solver solver );
HYPRE_Int
HYPRE_MGRDestroy( HYPRE_Solver solver );

HYPRE_Int
HYPRE_MGRGetCoarseGridConvergenceFactor_flt( HYPRE_Solver solver, hypre_float *conv_factor );
HYPRE_Int
HYPRE_MGRGetCoarseGridConvergenceFactor_dbl( HYPRE_Solver solver, hypre_double *conv_factor );
HYPRE_Int
HYPRE_MGRGetCoarseGridConvergenceFactor_long_dbl( HYPRE_Solver solver, hypre_long_double *conv_factor );
HYPRE_Int
HYPRE_MGRGetCoarseGridConvergenceFactor( HYPRE_Solver solver, void *conv_factor );

HYPRE_Int
HYPRE_MGRGetFinalRelativeResidualNorm_flt( HYPRE_Solver solver, hypre_float *res_norm );
HYPRE_Int
HYPRE_MGRGetFinalRelativeResidualNorm_dbl( HYPRE_Solver solver, hypre_double *res_norm );
HYPRE_Int
HYPRE_MGRGetFinalRelativeResidualNorm_long_dbl( HYPRE_Solver solver, hypre_long_double *res_norm );
HYPRE_Int
HYPRE_MGRGetFinalRelativeResidualNorm( HYPRE_Solver solver, void *res_norm );

HYPRE_Int
HYPRE_MGRGetNumIterations_flt( HYPRE_Solver solver, HYPRE_Int *num_iterations );
HYPRE_Int
HYPRE_MGRGetNumIterations_dbl( HYPRE_Solver solver, HYPRE_Int *num_iterations );
HYPRE_Int
HYPRE_MGRGetNumIterations_long_dbl( HYPRE_Solver solver, HYPRE_Int *num_iterations );
HYPRE_Int
HYPRE_MGRGetNumIterations( HYPRE_Solver solver, HYPRE_Int *num_iterations );

HYPRE_Int
HYPRE_MGRSetBlockJacobiBlockSize_flt( HYPRE_Solver solver, HYPRE_Int blk_size );
HYPRE_Int
HYPRE_MGRSetBlockJacobiBlockSize_dbl( HYPRE_Solver solver, HYPRE_Int blk_size );
HYPRE_Int
HYPRE_MGRSetBlockJacobiBlockSize_long_dbl( HYPRE_Solver solver, HYPRE_Int blk_size );
HYPRE_Int
HYPRE_MGRSetBlockJacobiBlockSize( HYPRE_Solver solver, HYPRE_Int blk_size );

HYPRE_Int
HYPRE_MGRSetBlockSize_flt( HYPRE_Solver solver, HYPRE_Int bsize );
HYPRE_Int
HYPRE_MGRSetBlockSize_dbl( HYPRE_Solver solver, HYPRE_Int bsize );
HYPRE_Int
HYPRE_MGRSetBlockSize_long_dbl( HYPRE_Solver solver, HYPRE_Int bsize );
HYPRE_Int
HYPRE_MGRSetBlockSize( HYPRE_Solver solver, HYPRE_Int bsize );

HYPRE_Int
HYPRE_MGRSetCoarseGridMethod_flt( HYPRE_Solver solver, HYPRE_Int *cg_method );
HYPRE_Int
HYPRE_MGRSetCoarseGridMethod_dbl( HYPRE_Solver solver, HYPRE_Int *cg_method );
HYPRE_Int
HYPRE_MGRSetCoarseGridMethod_long_dbl( HYPRE_Solver solver, HYPRE_Int *cg_method );
HYPRE_Int
HYPRE_MGRSetCoarseGridMethod( HYPRE_Solver solver, HYPRE_Int *cg_method );

HYPRE_Int
HYPRE_MGRSetCoarseGridPrintLevel_flt( HYPRE_Solver solver, HYPRE_Int print_level );
HYPRE_Int
HYPRE_MGRSetCoarseGridPrintLevel_dbl( HYPRE_Solver solver, HYPRE_Int print_level );
HYPRE_Int
HYPRE_MGRSetCoarseGridPrintLevel_long_dbl( HYPRE_Solver solver, HYPRE_Int print_level );
HYPRE_Int
HYPRE_MGRSetCoarseGridPrintLevel( HYPRE_Solver solver, HYPRE_Int print_level );

HYPRE_Int
HYPRE_MGRSetCoarseSolver_flt( HYPRE_Solver solver, HYPRE_PtrToParSolverFcn coarse_grid_solver_solve, HYPRE_PtrToParSolverFcn coarse_grid_solver_setup, HYPRE_Solver coarse_grid_solver );
HYPRE_Int
HYPRE_MGRSetCoarseSolver_dbl( HYPRE_Solver solver, HYPRE_PtrToParSolverFcn coarse_grid_solver_solve, HYPRE_PtrToParSolverFcn coarse_grid_solver_setup, HYPRE_Solver coarse_grid_solver );
HYPRE_Int
HYPRE_MGRSetCoarseSolver_long_dbl( HYPRE_Solver solver, HYPRE_PtrToParSolverFcn coarse_grid_solver_solve, HYPRE_PtrToParSolverFcn coarse_grid_solver_setup, HYPRE_Solver coarse_grid_solver );
HYPRE_Int
HYPRE_MGRSetCoarseSolver( HYPRE_Solver solver, HYPRE_PtrToParSolverFcn coarse_grid_solver_solve, HYPRE_PtrToParSolverFcn coarse_grid_solver_setup, HYPRE_Solver coarse_grid_solver );

HYPRE_Int
HYPRE_MGRSetCpointsByBlock_flt( HYPRE_Solver solver, HYPRE_Int block_size, HYPRE_Int max_num_levels, HYPRE_Int *num_block_coarse_points, HYPRE_Int **block_coarse_indexes );
HYPRE_Int
HYPRE_MGRSetCpointsByBlock_dbl( HYPRE_Solver solver, HYPRE_Int block_size, HYPRE_Int max_num_levels, HYPRE_Int *num_block_coarse_points, HYPRE_Int **block_coarse_indexes );
HYPRE_Int
HYPRE_MGRSetCpointsByBlock_long_dbl( HYPRE_Solver solver, HYPRE_Int block_size, HYPRE_Int max_num_levels, HYPRE_Int *num_block_coarse_points, HYPRE_Int **block_coarse_indexes );
HYPRE_Int
HYPRE_MGRSetCpointsByBlock( HYPRE_Solver solver, HYPRE_Int block_size, HYPRE_Int max_num_levels, HYPRE_Int *num_block_coarse_points, HYPRE_Int **block_coarse_indexes );

HYPRE_Int
HYPRE_MGRSetCpointsByContiguousBlock_flt( HYPRE_Solver solver, HYPRE_Int block_size, HYPRE_Int max_num_levels, HYPRE_BigInt *idx_array, HYPRE_Int *num_block_coarse_points, HYPRE_Int **block_coarse_indexes );
HYPRE_Int
HYPRE_MGRSetCpointsByContiguousBlock_dbl( HYPRE_Solver solver, HYPRE_Int block_size, HYPRE_Int max_num_levels, HYPRE_BigInt *idx_array, HYPRE_Int *num_block_coarse_points, HYPRE_Int **block_coarse_indexes );
HYPRE_Int
HYPRE_MGRSetCpointsByContiguousBlock_long_dbl( HYPRE_Solver solver, HYPRE_Int block_size, HYPRE_Int max_num_levels, HYPRE_BigInt *idx_array, HYPRE_Int *num_block_coarse_points, HYPRE_Int **block_coarse_indexes );
HYPRE_Int
HYPRE_MGRSetCpointsByContiguousBlock( HYPRE_Solver solver, HYPRE_Int block_size, HYPRE_Int max_num_levels, HYPRE_BigInt *idx_array, HYPRE_Int *num_block_coarse_points, HYPRE_Int **block_coarse_indexes );

HYPRE_Int
HYPRE_MGRSetCpointsByPointMarkerArray_flt( HYPRE_Solver solver, HYPRE_Int block_size, HYPRE_Int max_num_levels, HYPRE_Int *num_block_coarse_points, HYPRE_Int **lvl_block_coarse_indexes, HYPRE_Int *point_marker_array );
HYPRE_Int
HYPRE_MGRSetCpointsByPointMarkerArray_dbl( HYPRE_Solver solver, HYPRE_Int block_size, HYPRE_Int max_num_levels, HYPRE_Int *num_block_coarse_points, HYPRE_Int **lvl_block_coarse_indexes, HYPRE_Int *point_marker_array );
HYPRE_Int
HYPRE_MGRSetCpointsByPointMarkerArray_long_dbl( HYPRE_Solver solver, HYPRE_Int block_size, HYPRE_Int max_num_levels, HYPRE_Int *num_block_coarse_points, HYPRE_Int **lvl_block_coarse_indexes, HYPRE_Int *point_marker_array );
HYPRE_Int
HYPRE_MGRSetCpointsByPointMarkerArray( HYPRE_Solver solver, HYPRE_Int block_size, HYPRE_Int max_num_levels, HYPRE_Int *num_block_coarse_points, HYPRE_Int **lvl_block_coarse_indexes, HYPRE_Int *point_marker_array );

HYPRE_Int
HYPRE_MGRSetFRelaxMethod_flt( HYPRE_Solver solver, HYPRE_Int relax_method );
HYPRE_Int
HYPRE_MGRSetFRelaxMethod_dbl( HYPRE_Solver solver, HYPRE_Int relax_method );
HYPRE_Int
HYPRE_MGRSetFRelaxMethod_long_dbl( HYPRE_Solver solver, HYPRE_Int relax_method );
HYPRE_Int
HYPRE_MGRSetFRelaxMethod( HYPRE_Solver solver, HYPRE_Int relax_method );

HYPRE_Int
HYPRE_MGRSetFSolver_flt( HYPRE_Solver solver, HYPRE_PtrToParSolverFcn fine_grid_solver_solve, HYPRE_PtrToParSolverFcn fine_grid_solver_setup, HYPRE_Solver fsolver );
HYPRE_Int
HYPRE_MGRSetFSolver_dbl( HYPRE_Solver solver, HYPRE_PtrToParSolverFcn fine_grid_solver_solve, HYPRE_PtrToParSolverFcn fine_grid_solver_setup, HYPRE_Solver fsolver );
HYPRE_Int
HYPRE_MGRSetFSolver_long_dbl( HYPRE_Solver solver, HYPRE_PtrToParSolverFcn fine_grid_solver_solve, HYPRE_PtrToParSolverFcn fine_grid_solver_setup, HYPRE_Solver fsolver );
HYPRE_Int
HYPRE_MGRSetFSolver( HYPRE_Solver solver, HYPRE_PtrToParSolverFcn fine_grid_solver_solve, HYPRE_PtrToParSolverFcn fine_grid_solver_setup, HYPRE_Solver fsolver );

HYPRE_Int
HYPRE_MGRSetFSolverAtLevel_flt( HYPRE_Solver solver, HYPRE_Solver fsolver, HYPRE_Int level );
HYPRE_Int
HYPRE_MGRSetFSolverAtLevel_dbl( HYPRE_Solver solver, HYPRE_Solver fsolver, HYPRE_Int level );
HYPRE_Int
HYPRE_MGRSetFSolverAtLevel_long_dbl( HYPRE_Solver solver, HYPRE_Solver fsolver, HYPRE_Int level );
HYPRE_Int
HYPRE_MGRSetFSolverAtLevel( HYPRE_Solver solver, HYPRE_Solver fsolver, HYPRE_Int level );

HYPRE_Int
HYPRE_MGRSetFrelaxPrintLevel_flt( HYPRE_Solver solver, HYPRE_Int print_level );
HYPRE_Int
HYPRE_MGRSetFrelaxPrintLevel_dbl( HYPRE_Solver solver, HYPRE_Int print_level );
HYPRE_Int
HYPRE_MGRSetFrelaxPrintLevel_long_dbl( HYPRE_Solver solver, HYPRE_Int print_level );
HYPRE_Int
HYPRE_MGRSetFrelaxPrintLevel( HYPRE_Solver solver, HYPRE_Int print_level );

HYPRE_Int
HYPRE_MGRSetGlobalSmoothCycle_flt( HYPRE_Solver solver, HYPRE_Int global_smooth_cycle );
HYPRE_Int
HYPRE_MGRSetGlobalSmoothCycle_dbl( HYPRE_Solver solver, HYPRE_Int global_smooth_cycle );
HYPRE_Int
HYPRE_MGRSetGlobalSmoothCycle_long_dbl( HYPRE_Solver solver, HYPRE_Int global_smooth_cycle );
HYPRE_Int
HYPRE_MGRSetGlobalSmoothCycle( HYPRE_Solver solver, HYPRE_Int global_smooth_cycle );

HYPRE_Int
HYPRE_MGRSetGlobalSmoothType_flt( HYPRE_Solver solver, HYPRE_Int smooth_type );
HYPRE_Int
HYPRE_MGRSetGlobalSmoothType_dbl( HYPRE_Solver solver, HYPRE_Int smooth_type );
HYPRE_Int
HYPRE_MGRSetGlobalSmoothType_long_dbl( HYPRE_Solver solver, HYPRE_Int smooth_type );
HYPRE_Int
HYPRE_MGRSetGlobalSmoothType( HYPRE_Solver solver, HYPRE_Int smooth_type );

HYPRE_Int
HYPRE_MGRSetGlobalSmootherAtLevel_flt( HYPRE_Solver solver, HYPRE_Solver smoother, HYPRE_Int level );
HYPRE_Int
HYPRE_MGRSetGlobalSmootherAtLevel_dbl( HYPRE_Solver solver, HYPRE_Solver smoother, HYPRE_Int level );
HYPRE_Int
HYPRE_MGRSetGlobalSmootherAtLevel_long_dbl( HYPRE_Solver solver, HYPRE_Solver smoother, HYPRE_Int level );
HYPRE_Int
HYPRE_MGRSetGlobalSmootherAtLevel( HYPRE_Solver solver, HYPRE_Solver smoother, HYPRE_Int level );

HYPRE_Int
HYPRE_MGRSetInterpType_flt( HYPRE_Solver solver, HYPRE_Int interp_type );
HYPRE_Int
HYPRE_MGRSetInterpType_dbl( HYPRE_Solver solver, HYPRE_Int interp_type );
HYPRE_Int
HYPRE_MGRSetInterpType_long_dbl( HYPRE_Solver solver, HYPRE_Int interp_type );
HYPRE_Int
HYPRE_MGRSetInterpType( HYPRE_Solver solver, HYPRE_Int interp_type );

HYPRE_Int
HYPRE_MGRSetLevelFRelaxMethod_flt( HYPRE_Solver solver, HYPRE_Int *relax_method );
HYPRE_Int
HYPRE_MGRSetLevelFRelaxMethod_dbl( HYPRE_Solver solver, HYPRE_Int *relax_method );
HYPRE_Int
HYPRE_MGRSetLevelFRelaxMethod_long_dbl( HYPRE_Solver solver, HYPRE_Int *relax_method );
HYPRE_Int
HYPRE_MGRSetLevelFRelaxMethod( HYPRE_Solver solver, HYPRE_Int *relax_method );

HYPRE_Int
HYPRE_MGRSetLevelFRelaxNumFunctions_flt( HYPRE_Solver solver, HYPRE_Int *num_functions );
HYPRE_Int
HYPRE_MGRSetLevelFRelaxNumFunctions_dbl( HYPRE_Solver solver, HYPRE_Int *num_functions );
HYPRE_Int
HYPRE_MGRSetLevelFRelaxNumFunctions_long_dbl( HYPRE_Solver solver, HYPRE_Int *num_functions );
HYPRE_Int
HYPRE_MGRSetLevelFRelaxNumFunctions( HYPRE_Solver solver, HYPRE_Int *num_functions );

HYPRE_Int
HYPRE_MGRSetLevelFRelaxType_flt( HYPRE_Solver solver, HYPRE_Int *relax_type );
HYPRE_Int
HYPRE_MGRSetLevelFRelaxType_dbl( HYPRE_Solver solver, HYPRE_Int *relax_type );
HYPRE_Int
HYPRE_MGRSetLevelFRelaxType_long_dbl( HYPRE_Solver solver, HYPRE_Int *relax_type );
HYPRE_Int
HYPRE_MGRSetLevelFRelaxType( HYPRE_Solver solver, HYPRE_Int *relax_type );

HYPRE_Int
HYPRE_MGRSetLevelInterpType_flt( HYPRE_Solver solver, HYPRE_Int *interp_type );
HYPRE_Int
HYPRE_MGRSetLevelInterpType_dbl( HYPRE_Solver solver, HYPRE_Int *interp_type );
HYPRE_Int
HYPRE_MGRSetLevelInterpType_long_dbl( HYPRE_Solver solver, HYPRE_Int *interp_type );
HYPRE_Int
HYPRE_MGRSetLevelInterpType( HYPRE_Solver solver, HYPRE_Int *interp_type );

HYPRE_Int
HYPRE_MGRSetLevelNonGalerkinMaxElmts_flt( HYPRE_Solver solver, HYPRE_Int *max_elmts );
HYPRE_Int
HYPRE_MGRSetLevelNonGalerkinMaxElmts_dbl( HYPRE_Solver solver, HYPRE_Int *max_elmts );
HYPRE_Int
HYPRE_MGRSetLevelNonGalerkinMaxElmts_long_dbl( HYPRE_Solver solver, HYPRE_Int *max_elmts );
HYPRE_Int
HYPRE_MGRSetLevelNonGalerkinMaxElmts( HYPRE_Solver solver, HYPRE_Int *max_elmts );

HYPRE_Int
HYPRE_MGRSetLevelNumRelaxSweeps_flt( HYPRE_Solver solver, HYPRE_Int *nsweeps );
HYPRE_Int
HYPRE_MGRSetLevelNumRelaxSweeps_dbl( HYPRE_Solver solver, HYPRE_Int *nsweeps );
HYPRE_Int
HYPRE_MGRSetLevelNumRelaxSweeps_long_dbl( HYPRE_Solver solver, HYPRE_Int *nsweeps );
HYPRE_Int
HYPRE_MGRSetLevelNumRelaxSweeps( HYPRE_Solver solver, HYPRE_Int *nsweeps );

HYPRE_Int
HYPRE_MGRSetLevelPMaxElmts_flt( HYPRE_Solver solver, HYPRE_Int *P_max_elmts );
HYPRE_Int
HYPRE_MGRSetLevelPMaxElmts_dbl( HYPRE_Solver solver, HYPRE_Int *P_max_elmts );
HYPRE_Int
HYPRE_MGRSetLevelPMaxElmts_long_dbl( HYPRE_Solver solver, HYPRE_Int *P_max_elmts );
HYPRE_Int
HYPRE_MGRSetLevelPMaxElmts( HYPRE_Solver solver, HYPRE_Int *P_max_elmts );

HYPRE_Int
HYPRE_MGRSetLevelRestrictType_flt( HYPRE_Solver solver, HYPRE_Int *restrict_type );
HYPRE_Int
HYPRE_MGRSetLevelRestrictType_dbl( HYPRE_Solver solver, HYPRE_Int *restrict_type );
HYPRE_Int
HYPRE_MGRSetLevelRestrictType_long_dbl( HYPRE_Solver solver, HYPRE_Int *restrict_type );
HYPRE_Int
HYPRE_MGRSetLevelRestrictType( HYPRE_Solver solver, HYPRE_Int *restrict_type );

HYPRE_Int
HYPRE_MGRSetLevelSmoothIters_flt( HYPRE_Solver solver, HYPRE_Int *smooth_iters );
HYPRE_Int
HYPRE_MGRSetLevelSmoothIters_dbl( HYPRE_Solver solver, HYPRE_Int *smooth_iters );
HYPRE_Int
HYPRE_MGRSetLevelSmoothIters_long_dbl( HYPRE_Solver solver, HYPRE_Int *smooth_iters );
HYPRE_Int
HYPRE_MGRSetLevelSmoothIters( HYPRE_Solver solver, HYPRE_Int *smooth_iters );

HYPRE_Int
HYPRE_MGRSetLevelSmoothType_flt( HYPRE_Solver solver, HYPRE_Int *smooth_type );
HYPRE_Int
HYPRE_MGRSetLevelSmoothType_dbl( HYPRE_Solver solver, HYPRE_Int *smooth_type );
HYPRE_Int
HYPRE_MGRSetLevelSmoothType_long_dbl( HYPRE_Solver solver, HYPRE_Int *smooth_type );
HYPRE_Int
HYPRE_MGRSetLevelSmoothType( HYPRE_Solver solver, HYPRE_Int *smooth_type );

HYPRE_Int
HYPRE_MGRSetLogging_flt( HYPRE_Solver solver, HYPRE_Int logging );
HYPRE_Int
HYPRE_MGRSetLogging_dbl( HYPRE_Solver solver, HYPRE_Int logging );
HYPRE_Int
HYPRE_MGRSetLogging_long_dbl( HYPRE_Solver solver, HYPRE_Int logging );
HYPRE_Int
HYPRE_MGRSetLogging( HYPRE_Solver solver, HYPRE_Int logging );

HYPRE_Int
HYPRE_MGRSetMaxCoarseLevels_flt( HYPRE_Solver solver, HYPRE_Int maxlev );
HYPRE_Int
HYPRE_MGRSetMaxCoarseLevels_dbl( HYPRE_Solver solver, HYPRE_Int maxlev );
HYPRE_Int
HYPRE_MGRSetMaxCoarseLevels_long_dbl( HYPRE_Solver solver, HYPRE_Int maxlev );
HYPRE_Int
HYPRE_MGRSetMaxCoarseLevels( HYPRE_Solver solver, HYPRE_Int maxlev );

HYPRE_Int
HYPRE_MGRSetMaxGlobalSmoothIters_flt( HYPRE_Solver solver, HYPRE_Int smooth_iter );
HYPRE_Int
HYPRE_MGRSetMaxGlobalSmoothIters_dbl( HYPRE_Solver solver, HYPRE_Int smooth_iter );
HYPRE_Int
HYPRE_MGRSetMaxGlobalSmoothIters_long_dbl( HYPRE_Solver solver, HYPRE_Int smooth_iter );
HYPRE_Int
HYPRE_MGRSetMaxGlobalSmoothIters( HYPRE_Solver solver, HYPRE_Int smooth_iter );

HYPRE_Int
HYPRE_MGRSetMaxIter_flt( HYPRE_Solver solver, HYPRE_Int max_iter );
HYPRE_Int
HYPRE_MGRSetMaxIter_dbl( HYPRE_Solver solver, HYPRE_Int max_iter );
HYPRE_Int
HYPRE_MGRSetMaxIter_long_dbl( HYPRE_Solver solver, HYPRE_Int max_iter );
HYPRE_Int
HYPRE_MGRSetMaxIter( HYPRE_Solver solver, HYPRE_Int max_iter );

HYPRE_Int
HYPRE_MGRSetNonCpointsToFpoints_flt( HYPRE_Solver solver, HYPRE_Int nonCptToFptFlag );
HYPRE_Int
HYPRE_MGRSetNonCpointsToFpoints_dbl( HYPRE_Solver solver, HYPRE_Int nonCptToFptFlag );
HYPRE_Int
HYPRE_MGRSetNonCpointsToFpoints_long_dbl( HYPRE_Solver solver, HYPRE_Int nonCptToFptFlag );
HYPRE_Int
HYPRE_MGRSetNonCpointsToFpoints( HYPRE_Solver solver, HYPRE_Int nonCptToFptFlag );

HYPRE_Int
HYPRE_MGRSetNonGalerkinMaxElmts_flt( HYPRE_Solver solver, HYPRE_Int max_elmts );
HYPRE_Int
HYPRE_MGRSetNonGalerkinMaxElmts_dbl( HYPRE_Solver solver, HYPRE_Int max_elmts );
HYPRE_Int
HYPRE_MGRSetNonGalerkinMaxElmts_long_dbl( HYPRE_Solver solver, HYPRE_Int max_elmts );
HYPRE_Int
HYPRE_MGRSetNonGalerkinMaxElmts( HYPRE_Solver solver, HYPRE_Int max_elmts );

HYPRE_Int
HYPRE_MGRSetNumInterpSweeps_flt( HYPRE_Solver solver, HYPRE_Int nsweeps );
HYPRE_Int
HYPRE_MGRSetNumInterpSweeps_dbl( HYPRE_Solver solver, HYPRE_Int nsweeps );
HYPRE_Int
HYPRE_MGRSetNumInterpSweeps_long_dbl( HYPRE_Solver solver, HYPRE_Int nsweeps );
HYPRE_Int
HYPRE_MGRSetNumInterpSweeps( HYPRE_Solver solver, HYPRE_Int nsweeps );

HYPRE_Int
HYPRE_MGRSetNumRelaxSweeps_flt( HYPRE_Solver solver, HYPRE_Int nsweeps );
HYPRE_Int
HYPRE_MGRSetNumRelaxSweeps_dbl( HYPRE_Solver solver, HYPRE_Int nsweeps );
HYPRE_Int
HYPRE_MGRSetNumRelaxSweeps_long_dbl( HYPRE_Solver solver, HYPRE_Int nsweeps );
HYPRE_Int
HYPRE_MGRSetNumRelaxSweeps( HYPRE_Solver solver, HYPRE_Int nsweeps );

HYPRE_Int
HYPRE_MGRSetNumRestrictSweeps_flt( HYPRE_Solver solver, HYPRE_Int nsweeps );
HYPRE_Int
HYPRE_MGRSetNumRestrictSweeps_dbl( HYPRE_Solver solver, HYPRE_Int nsweeps );
HYPRE_Int
HYPRE_MGRSetNumRestrictSweeps_long_dbl( HYPRE_Solver solver, HYPRE_Int nsweeps );
HYPRE_Int
HYPRE_MGRSetNumRestrictSweeps( HYPRE_Solver solver, HYPRE_Int nsweeps );

HYPRE_Int
HYPRE_MGRSetPMaxElmts_flt( HYPRE_Solver solver, HYPRE_Int P_max_elmts );
HYPRE_Int
HYPRE_MGRSetPMaxElmts_dbl( HYPRE_Solver solver, HYPRE_Int P_max_elmts );
HYPRE_Int
HYPRE_MGRSetPMaxElmts_long_dbl( HYPRE_Solver solver, HYPRE_Int P_max_elmts );
HYPRE_Int
HYPRE_MGRSetPMaxElmts( HYPRE_Solver solver, HYPRE_Int P_max_elmts );

HYPRE_Int
HYPRE_MGRSetPrintLevel_flt( HYPRE_Solver solver, HYPRE_Int print_level );
HYPRE_Int
HYPRE_MGRSetPrintLevel_dbl( HYPRE_Solver solver, HYPRE_Int print_level );
HYPRE_Int
HYPRE_MGRSetPrintLevel_long_dbl( HYPRE_Solver solver, HYPRE_Int print_level );
HYPRE_Int
HYPRE_MGRSetPrintLevel( HYPRE_Solver solver, HYPRE_Int print_level );

HYPRE_Int
HYPRE_MGRSetRelaxType_flt( HYPRE_Solver solver, HYPRE_Int relax_type );
HYPRE_Int
HYPRE_MGRSetRelaxType_dbl( HYPRE_Solver solver, HYPRE_Int relax_type );
HYPRE_Int
HYPRE_MGRSetRelaxType_long_dbl( HYPRE_Solver solver, HYPRE_Int relax_type );
HYPRE_Int
HYPRE_MGRSetRelaxType( HYPRE_Solver solver, HYPRE_Int relax_type );

HYPRE_Int
HYPRE_MGRSetReservedCoarseNodes_flt( HYPRE_Solver solver, HYPRE_Int reserved_coarse_size, HYPRE_BigInt *reserved_coarse_nodes );
HYPRE_Int
HYPRE_MGRSetReservedCoarseNodes_dbl( HYPRE_Solver solver, HYPRE_Int reserved_coarse_size, HYPRE_BigInt *reserved_coarse_nodes );
HYPRE_Int
HYPRE_MGRSetReservedCoarseNodes_long_dbl( HYPRE_Solver solver, HYPRE_Int reserved_coarse_size, HYPRE_BigInt *reserved_coarse_nodes );
HYPRE_Int
HYPRE_MGRSetReservedCoarseNodes( HYPRE_Solver solver, HYPRE_Int reserved_coarse_size, HYPRE_BigInt *reserved_coarse_nodes );

HYPRE_Int
HYPRE_MGRSetReservedCpointsLevelToKeep_flt( HYPRE_Solver solver, HYPRE_Int level );
HYPRE_Int
HYPRE_MGRSetReservedCpointsLevelToKeep_dbl( HYPRE_Solver solver, HYPRE_Int level );
HYPRE_Int
HYPRE_MGRSetReservedCpointsLevelToKeep_long_dbl( HYPRE_Solver solver, HYPRE_Int level );
HYPRE_Int
HYPRE_MGRSetReservedCpointsLevelToKeep( HYPRE_Solver solver, HYPRE_Int level );

HYPRE_Int
HYPRE_MGRSetRestrictType_flt( HYPRE_Solver solver, HYPRE_Int restrict_type );
HYPRE_Int
HYPRE_MGRSetRestrictType_dbl( HYPRE_Solver solver, HYPRE_Int restrict_type );
HYPRE_Int
HYPRE_MGRSetRestrictType_long_dbl( HYPRE_Solver solver, HYPRE_Int restrict_type );
HYPRE_Int
HYPRE_MGRSetRestrictType( HYPRE_Solver solver, HYPRE_Int restrict_type );

HYPRE_Int
HYPRE_MGRSetTol_flt( HYPRE_Solver solver, hypre_float tol );
HYPRE_Int
HYPRE_MGRSetTol_dbl( HYPRE_Solver solver, hypre_double tol );
HYPRE_Int
HYPRE_MGRSetTol_long_dbl( HYPRE_Solver solver, hypre_long_double tol );
HYPRE_Int
HYPRE_MGRSetTol( HYPRE_Solver solver, hypre_long_double tol );

HYPRE_Int
HYPRE_MGRSetTruncateCoarseGridThreshold_flt( HYPRE_Solver solver, hypre_float threshold );
HYPRE_Int
HYPRE_MGRSetTruncateCoarseGridThreshold_dbl( HYPRE_Solver solver, hypre_double threshold );
HYPRE_Int
HYPRE_MGRSetTruncateCoarseGridThreshold_long_dbl( HYPRE_Solver solver, hypre_long_double threshold );
HYPRE_Int
HYPRE_MGRSetTruncateCoarseGridThreshold( HYPRE_Solver solver, hypre_long_double threshold );

HYPRE_Int
HYPRE_MGRSetup_flt( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_MGRSetup_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_MGRSetup_long_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_MGRSetup( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );

HYPRE_Int
HYPRE_MGRSolve_flt( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_MGRSolve_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_MGRSolve_long_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_MGRSolve( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );

HYPRE_Int
HYPRE_ParCSRBiCGSTABCreate_flt( MPI_Comm comm, HYPRE_Solver *solver );
HYPRE_Int
HYPRE_ParCSRBiCGSTABCreate_dbl( MPI_Comm comm, HYPRE_Solver *solver );
HYPRE_Int
HYPRE_ParCSRBiCGSTABCreate_long_dbl( MPI_Comm comm, HYPRE_Solver *solver );
HYPRE_Int
HYPRE_ParCSRBiCGSTABCreate( MPI_Comm comm, HYPRE_Solver *solver );

HYPRE_Int
HYPRE_ParCSRBiCGSTABDestroy_flt( HYPRE_Solver solver );
HYPRE_Int
HYPRE_ParCSRBiCGSTABDestroy_dbl( HYPRE_Solver solver );
HYPRE_Int
HYPRE_ParCSRBiCGSTABDestroy_long_dbl( HYPRE_Solver solver );
HYPRE_Int
HYPRE_ParCSRBiCGSTABDestroy( HYPRE_Solver solver );

HYPRE_Int
HYPRE_ParCSRBiCGSTABGetFinalRelativeResidualNorm_flt( HYPRE_Solver solver, hypre_float *norm );
HYPRE_Int
HYPRE_ParCSRBiCGSTABGetFinalRelativeResidualNorm_dbl( HYPRE_Solver solver, hypre_double *norm );
HYPRE_Int
HYPRE_ParCSRBiCGSTABGetFinalRelativeResidualNorm_long_dbl( HYPRE_Solver solver, hypre_long_double *norm );
HYPRE_Int
HYPRE_ParCSRBiCGSTABGetFinalRelativeResidualNorm( HYPRE_Solver solver, void *norm );

HYPRE_Int
HYPRE_ParCSRBiCGSTABGetNumIterations_flt( HYPRE_Solver solver, HYPRE_Int *num_iterations );
HYPRE_Int
HYPRE_ParCSRBiCGSTABGetNumIterations_dbl( HYPRE_Solver solver, HYPRE_Int *num_iterations );
HYPRE_Int
HYPRE_ParCSRBiCGSTABGetNumIterations_long_dbl( HYPRE_Solver solver, HYPRE_Int *num_iterations );
HYPRE_Int
HYPRE_ParCSRBiCGSTABGetNumIterations( HYPRE_Solver solver, HYPRE_Int *num_iterations );

HYPRE_Int
HYPRE_ParCSRBiCGSTABGetPrecond_flt( HYPRE_Solver solver, HYPRE_Solver *precond_data );
HYPRE_Int
HYPRE_ParCSRBiCGSTABGetPrecond_dbl( HYPRE_Solver solver, HYPRE_Solver *precond_data );
HYPRE_Int
HYPRE_ParCSRBiCGSTABGetPrecond_long_dbl( HYPRE_Solver solver, HYPRE_Solver *precond_data );
HYPRE_Int
HYPRE_ParCSRBiCGSTABGetPrecond( HYPRE_Solver solver, HYPRE_Solver *precond_data );

HYPRE_Int
HYPRE_ParCSRBiCGSTABGetResidual_flt( HYPRE_Solver solver, HYPRE_ParVector *residual );
HYPRE_Int
HYPRE_ParCSRBiCGSTABGetResidual_dbl( HYPRE_Solver solver, HYPRE_ParVector *residual );
HYPRE_Int
HYPRE_ParCSRBiCGSTABGetResidual_long_dbl( HYPRE_Solver solver, HYPRE_ParVector *residual );
HYPRE_Int
HYPRE_ParCSRBiCGSTABGetResidual( HYPRE_Solver solver, HYPRE_ParVector *residual );

HYPRE_Int
HYPRE_ParCSRBiCGSTABSetAbsoluteTol_flt( HYPRE_Solver solver, hypre_float a_tol );
HYPRE_Int
HYPRE_ParCSRBiCGSTABSetAbsoluteTol_dbl( HYPRE_Solver solver, hypre_double a_tol );
HYPRE_Int
HYPRE_ParCSRBiCGSTABSetAbsoluteTol_long_dbl( HYPRE_Solver solver, hypre_long_double a_tol );
HYPRE_Int
HYPRE_ParCSRBiCGSTABSetAbsoluteTol( HYPRE_Solver solver, hypre_long_double a_tol );

HYPRE_Int
HYPRE_ParCSRBiCGSTABSetLogging_flt( HYPRE_Solver solver, HYPRE_Int logging );
HYPRE_Int
HYPRE_ParCSRBiCGSTABSetLogging_dbl( HYPRE_Solver solver, HYPRE_Int logging );
HYPRE_Int
HYPRE_ParCSRBiCGSTABSetLogging_long_dbl( HYPRE_Solver solver, HYPRE_Int logging );
HYPRE_Int
HYPRE_ParCSRBiCGSTABSetLogging( HYPRE_Solver solver, HYPRE_Int logging );

HYPRE_Int
HYPRE_ParCSRBiCGSTABSetMaxIter_flt( HYPRE_Solver solver, HYPRE_Int max_iter );
HYPRE_Int
HYPRE_ParCSRBiCGSTABSetMaxIter_dbl( HYPRE_Solver solver, HYPRE_Int max_iter );
HYPRE_Int
HYPRE_ParCSRBiCGSTABSetMaxIter_long_dbl( HYPRE_Solver solver, HYPRE_Int max_iter );
HYPRE_Int
HYPRE_ParCSRBiCGSTABSetMaxIter( HYPRE_Solver solver, HYPRE_Int max_iter );

HYPRE_Int
HYPRE_ParCSRBiCGSTABSetMinIter_flt( HYPRE_Solver solver, HYPRE_Int min_iter );
HYPRE_Int
HYPRE_ParCSRBiCGSTABSetMinIter_dbl( HYPRE_Solver solver, HYPRE_Int min_iter );
HYPRE_Int
HYPRE_ParCSRBiCGSTABSetMinIter_long_dbl( HYPRE_Solver solver, HYPRE_Int min_iter );
HYPRE_Int
HYPRE_ParCSRBiCGSTABSetMinIter( HYPRE_Solver solver, HYPRE_Int min_iter );

HYPRE_Int
HYPRE_ParCSRBiCGSTABSetPrecond_flt( HYPRE_Solver solver, HYPRE_PtrToParSolverFcn precond, HYPRE_PtrToParSolverFcn precond_setup, HYPRE_Solver precond_solver );
HYPRE_Int
HYPRE_ParCSRBiCGSTABSetPrecond_dbl( HYPRE_Solver solver, HYPRE_PtrToParSolverFcn precond, HYPRE_PtrToParSolverFcn precond_setup, HYPRE_Solver precond_solver );
HYPRE_Int
HYPRE_ParCSRBiCGSTABSetPrecond_long_dbl( HYPRE_Solver solver, HYPRE_PtrToParSolverFcn precond, HYPRE_PtrToParSolverFcn precond_setup, HYPRE_Solver precond_solver );
HYPRE_Int
HYPRE_ParCSRBiCGSTABSetPrecond( HYPRE_Solver solver, HYPRE_PtrToParSolverFcn precond, HYPRE_PtrToParSolverFcn precond_setup, HYPRE_Solver precond_solver );

HYPRE_Int
HYPRE_ParCSRBiCGSTABSetPrintLevel_flt( HYPRE_Solver solver, HYPRE_Int print_level );
HYPRE_Int
HYPRE_ParCSRBiCGSTABSetPrintLevel_dbl( HYPRE_Solver solver, HYPRE_Int print_level );
HYPRE_Int
HYPRE_ParCSRBiCGSTABSetPrintLevel_long_dbl( HYPRE_Solver solver, HYPRE_Int print_level );
HYPRE_Int
HYPRE_ParCSRBiCGSTABSetPrintLevel( HYPRE_Solver solver, HYPRE_Int print_level );

HYPRE_Int
HYPRE_ParCSRBiCGSTABSetStopCrit_flt( HYPRE_Solver solver, HYPRE_Int stop_crit );
HYPRE_Int
HYPRE_ParCSRBiCGSTABSetStopCrit_dbl( HYPRE_Solver solver, HYPRE_Int stop_crit );
HYPRE_Int
HYPRE_ParCSRBiCGSTABSetStopCrit_long_dbl( HYPRE_Solver solver, HYPRE_Int stop_crit );
HYPRE_Int
HYPRE_ParCSRBiCGSTABSetStopCrit( HYPRE_Solver solver, HYPRE_Int stop_crit );

HYPRE_Int
HYPRE_ParCSRBiCGSTABSetTol_flt( HYPRE_Solver solver, hypre_float tol );
HYPRE_Int
HYPRE_ParCSRBiCGSTABSetTol_dbl( HYPRE_Solver solver, hypre_double tol );
HYPRE_Int
HYPRE_ParCSRBiCGSTABSetTol_long_dbl( HYPRE_Solver solver, hypre_long_double tol );
HYPRE_Int
HYPRE_ParCSRBiCGSTABSetTol( HYPRE_Solver solver, hypre_long_double tol );

HYPRE_Int
HYPRE_ParCSRBiCGSTABSetup_flt( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_ParCSRBiCGSTABSetup_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_ParCSRBiCGSTABSetup_long_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_ParCSRBiCGSTABSetup( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );

HYPRE_Int
HYPRE_ParCSRBiCGSTABSolve_flt( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_ParCSRBiCGSTABSolve_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_ParCSRBiCGSTABSolve_long_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_ParCSRBiCGSTABSolve( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );

HYPRE_Int
HYPRE_ParCSRCGNRCreate_flt( MPI_Comm comm, HYPRE_Solver *solver );
HYPRE_Int
HYPRE_ParCSRCGNRCreate_dbl( MPI_Comm comm, HYPRE_Solver *solver );
HYPRE_Int
HYPRE_ParCSRCGNRCreate_long_dbl( MPI_Comm comm, HYPRE_Solver *solver );
HYPRE_Int
HYPRE_ParCSRCGNRCreate( MPI_Comm comm, HYPRE_Solver *solver );

HYPRE_Int
HYPRE_ParCSRCGNRDestroy_flt( HYPRE_Solver solver );
HYPRE_Int
HYPRE_ParCSRCGNRDestroy_dbl( HYPRE_Solver solver );
HYPRE_Int
HYPRE_ParCSRCGNRDestroy_long_dbl( HYPRE_Solver solver );
HYPRE_Int
HYPRE_ParCSRCGNRDestroy( HYPRE_Solver solver );

HYPRE_Int
HYPRE_ParCSRCGNRGetFinalRelativeResidualNorm_flt( HYPRE_Solver solver, hypre_float *norm );
HYPRE_Int
HYPRE_ParCSRCGNRGetFinalRelativeResidualNorm_dbl( HYPRE_Solver solver, hypre_double *norm );
HYPRE_Int
HYPRE_ParCSRCGNRGetFinalRelativeResidualNorm_long_dbl( HYPRE_Solver solver, hypre_long_double *norm );
HYPRE_Int
HYPRE_ParCSRCGNRGetFinalRelativeResidualNorm( HYPRE_Solver solver, void *norm );

HYPRE_Int
HYPRE_ParCSRCGNRGetNumIterations_flt( HYPRE_Solver solver, HYPRE_Int *num_iterations );
HYPRE_Int
HYPRE_ParCSRCGNRGetNumIterations_dbl( HYPRE_Solver solver, HYPRE_Int *num_iterations );
HYPRE_Int
HYPRE_ParCSRCGNRGetNumIterations_long_dbl( HYPRE_Solver solver, HYPRE_Int *num_iterations );
HYPRE_Int
HYPRE_ParCSRCGNRGetNumIterations( HYPRE_Solver solver, HYPRE_Int *num_iterations );

HYPRE_Int
HYPRE_ParCSRCGNRGetPrecond_flt( HYPRE_Solver solver, HYPRE_Solver *precond_data );
HYPRE_Int
HYPRE_ParCSRCGNRGetPrecond_dbl( HYPRE_Solver solver, HYPRE_Solver *precond_data );
HYPRE_Int
HYPRE_ParCSRCGNRGetPrecond_long_dbl( HYPRE_Solver solver, HYPRE_Solver *precond_data );
HYPRE_Int
HYPRE_ParCSRCGNRGetPrecond( HYPRE_Solver solver, HYPRE_Solver *precond_data );

HYPRE_Int
HYPRE_ParCSRCGNRSetLogging_flt( HYPRE_Solver solver, HYPRE_Int logging );
HYPRE_Int
HYPRE_ParCSRCGNRSetLogging_dbl( HYPRE_Solver solver, HYPRE_Int logging );
HYPRE_Int
HYPRE_ParCSRCGNRSetLogging_long_dbl( HYPRE_Solver solver, HYPRE_Int logging );
HYPRE_Int
HYPRE_ParCSRCGNRSetLogging( HYPRE_Solver solver, HYPRE_Int logging );

HYPRE_Int
HYPRE_ParCSRCGNRSetMaxIter_flt( HYPRE_Solver solver, HYPRE_Int max_iter );
HYPRE_Int
HYPRE_ParCSRCGNRSetMaxIter_dbl( HYPRE_Solver solver, HYPRE_Int max_iter );
HYPRE_Int
HYPRE_ParCSRCGNRSetMaxIter_long_dbl( HYPRE_Solver solver, HYPRE_Int max_iter );
HYPRE_Int
HYPRE_ParCSRCGNRSetMaxIter( HYPRE_Solver solver, HYPRE_Int max_iter );

HYPRE_Int
HYPRE_ParCSRCGNRSetMinIter_flt( HYPRE_Solver solver, HYPRE_Int min_iter );
HYPRE_Int
HYPRE_ParCSRCGNRSetMinIter_dbl( HYPRE_Solver solver, HYPRE_Int min_iter );
HYPRE_Int
HYPRE_ParCSRCGNRSetMinIter_long_dbl( HYPRE_Solver solver, HYPRE_Int min_iter );
HYPRE_Int
HYPRE_ParCSRCGNRSetMinIter( HYPRE_Solver solver, HYPRE_Int min_iter );

HYPRE_Int
HYPRE_ParCSRCGNRSetPrecond_flt( HYPRE_Solver solver, HYPRE_PtrToParSolverFcn precond, HYPRE_PtrToParSolverFcn precondT, HYPRE_PtrToParSolverFcn precond_setup, HYPRE_Solver precond_solver );
HYPRE_Int
HYPRE_ParCSRCGNRSetPrecond_dbl( HYPRE_Solver solver, HYPRE_PtrToParSolverFcn precond, HYPRE_PtrToParSolverFcn precondT, HYPRE_PtrToParSolverFcn precond_setup, HYPRE_Solver precond_solver );
HYPRE_Int
HYPRE_ParCSRCGNRSetPrecond_long_dbl( HYPRE_Solver solver, HYPRE_PtrToParSolverFcn precond, HYPRE_PtrToParSolverFcn precondT, HYPRE_PtrToParSolverFcn precond_setup, HYPRE_Solver precond_solver );
HYPRE_Int
HYPRE_ParCSRCGNRSetPrecond( HYPRE_Solver solver, HYPRE_PtrToParSolverFcn precond, HYPRE_PtrToParSolverFcn precondT, HYPRE_PtrToParSolverFcn precond_setup, HYPRE_Solver precond_solver );

HYPRE_Int
HYPRE_ParCSRCGNRSetStopCrit_flt( HYPRE_Solver solver, HYPRE_Int stop_crit );
HYPRE_Int
HYPRE_ParCSRCGNRSetStopCrit_dbl( HYPRE_Solver solver, HYPRE_Int stop_crit );
HYPRE_Int
HYPRE_ParCSRCGNRSetStopCrit_long_dbl( HYPRE_Solver solver, HYPRE_Int stop_crit );
HYPRE_Int
HYPRE_ParCSRCGNRSetStopCrit( HYPRE_Solver solver, HYPRE_Int stop_crit );

HYPRE_Int
HYPRE_ParCSRCGNRSetTol_flt( HYPRE_Solver solver, hypre_float tol );
HYPRE_Int
HYPRE_ParCSRCGNRSetTol_dbl( HYPRE_Solver solver, hypre_double tol );
HYPRE_Int
HYPRE_ParCSRCGNRSetTol_long_dbl( HYPRE_Solver solver, hypre_long_double tol );
HYPRE_Int
HYPRE_ParCSRCGNRSetTol( HYPRE_Solver solver, hypre_long_double tol );

HYPRE_Int
HYPRE_ParCSRCGNRSetup_flt( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_ParCSRCGNRSetup_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_ParCSRCGNRSetup_long_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_ParCSRCGNRSetup( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );

HYPRE_Int
HYPRE_ParCSRCGNRSolve_flt( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_ParCSRCGNRSolve_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_ParCSRCGNRSolve_long_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_ParCSRCGNRSolve( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );

HYPRE_Int
HYPRE_ParCSRCOGMRESCreate_flt( MPI_Comm comm, HYPRE_Solver *solver );
HYPRE_Int
HYPRE_ParCSRCOGMRESCreate_dbl( MPI_Comm comm, HYPRE_Solver *solver );
HYPRE_Int
HYPRE_ParCSRCOGMRESCreate_long_dbl( MPI_Comm comm, HYPRE_Solver *solver );
HYPRE_Int
HYPRE_ParCSRCOGMRESCreate( MPI_Comm comm, HYPRE_Solver *solver );

HYPRE_Int
HYPRE_ParCSRCOGMRESDestroy_flt( HYPRE_Solver solver );
HYPRE_Int
HYPRE_ParCSRCOGMRESDestroy_dbl( HYPRE_Solver solver );
HYPRE_Int
HYPRE_ParCSRCOGMRESDestroy_long_dbl( HYPRE_Solver solver );
HYPRE_Int
HYPRE_ParCSRCOGMRESDestroy( HYPRE_Solver solver );

HYPRE_Int
HYPRE_ParCSRCOGMRESGetFinalRelativeResidualNorm_flt( HYPRE_Solver solver, hypre_float *norm );
HYPRE_Int
HYPRE_ParCSRCOGMRESGetFinalRelativeResidualNorm_dbl( HYPRE_Solver solver, hypre_double *norm );
HYPRE_Int
HYPRE_ParCSRCOGMRESGetFinalRelativeResidualNorm_long_dbl( HYPRE_Solver solver, hypre_long_double *norm );
HYPRE_Int
HYPRE_ParCSRCOGMRESGetFinalRelativeResidualNorm( HYPRE_Solver solver, void *norm );

HYPRE_Int
HYPRE_ParCSRCOGMRESGetNumIterations_flt( HYPRE_Solver solver, HYPRE_Int *num_iterations );
HYPRE_Int
HYPRE_ParCSRCOGMRESGetNumIterations_dbl( HYPRE_Solver solver, HYPRE_Int *num_iterations );
HYPRE_Int
HYPRE_ParCSRCOGMRESGetNumIterations_long_dbl( HYPRE_Solver solver, HYPRE_Int *num_iterations );
HYPRE_Int
HYPRE_ParCSRCOGMRESGetNumIterations( HYPRE_Solver solver, HYPRE_Int *num_iterations );

HYPRE_Int
HYPRE_ParCSRCOGMRESGetPrecond_flt( HYPRE_Solver solver, HYPRE_Solver *precond_data );
HYPRE_Int
HYPRE_ParCSRCOGMRESGetPrecond_dbl( HYPRE_Solver solver, HYPRE_Solver *precond_data );
HYPRE_Int
HYPRE_ParCSRCOGMRESGetPrecond_long_dbl( HYPRE_Solver solver, HYPRE_Solver *precond_data );
HYPRE_Int
HYPRE_ParCSRCOGMRESGetPrecond( HYPRE_Solver solver, HYPRE_Solver *precond_data );

HYPRE_Int
HYPRE_ParCSRCOGMRESGetResidual_flt( HYPRE_Solver solver, HYPRE_ParVector *residual );
HYPRE_Int
HYPRE_ParCSRCOGMRESGetResidual_dbl( HYPRE_Solver solver, HYPRE_ParVector *residual );
HYPRE_Int
HYPRE_ParCSRCOGMRESGetResidual_long_dbl( HYPRE_Solver solver, HYPRE_ParVector *residual );
HYPRE_Int
HYPRE_ParCSRCOGMRESGetResidual( HYPRE_Solver solver, HYPRE_ParVector *residual );

HYPRE_Int
HYPRE_ParCSRCOGMRESSetAbsoluteTol_flt( HYPRE_Solver solver, hypre_float a_tol );
HYPRE_Int
HYPRE_ParCSRCOGMRESSetAbsoluteTol_dbl( HYPRE_Solver solver, hypre_double a_tol );
HYPRE_Int
HYPRE_ParCSRCOGMRESSetAbsoluteTol_long_dbl( HYPRE_Solver solver, hypre_long_double a_tol );
HYPRE_Int
HYPRE_ParCSRCOGMRESSetAbsoluteTol( HYPRE_Solver solver, hypre_long_double a_tol );

HYPRE_Int
HYPRE_ParCSRCOGMRESSetCGS_flt( HYPRE_Solver solver, HYPRE_Int cgs );
HYPRE_Int
HYPRE_ParCSRCOGMRESSetCGS_dbl( HYPRE_Solver solver, HYPRE_Int cgs );
HYPRE_Int
HYPRE_ParCSRCOGMRESSetCGS_long_dbl( HYPRE_Solver solver, HYPRE_Int cgs );
HYPRE_Int
HYPRE_ParCSRCOGMRESSetCGS( HYPRE_Solver solver, HYPRE_Int cgs );

HYPRE_Int
HYPRE_ParCSRCOGMRESSetKDim_flt( HYPRE_Solver solver, HYPRE_Int k_dim );
HYPRE_Int
HYPRE_ParCSRCOGMRESSetKDim_dbl( HYPRE_Solver solver, HYPRE_Int k_dim );
HYPRE_Int
HYPRE_ParCSRCOGMRESSetKDim_long_dbl( HYPRE_Solver solver, HYPRE_Int k_dim );
HYPRE_Int
HYPRE_ParCSRCOGMRESSetKDim( HYPRE_Solver solver, HYPRE_Int k_dim );

HYPRE_Int
HYPRE_ParCSRCOGMRESSetLogging_flt( HYPRE_Solver solver, HYPRE_Int logging );
HYPRE_Int
HYPRE_ParCSRCOGMRESSetLogging_dbl( HYPRE_Solver solver, HYPRE_Int logging );
HYPRE_Int
HYPRE_ParCSRCOGMRESSetLogging_long_dbl( HYPRE_Solver solver, HYPRE_Int logging );
HYPRE_Int
HYPRE_ParCSRCOGMRESSetLogging( HYPRE_Solver solver, HYPRE_Int logging );

HYPRE_Int
HYPRE_ParCSRCOGMRESSetMaxIter_flt( HYPRE_Solver solver, HYPRE_Int max_iter );
HYPRE_Int
HYPRE_ParCSRCOGMRESSetMaxIter_dbl( HYPRE_Solver solver, HYPRE_Int max_iter );
HYPRE_Int
HYPRE_ParCSRCOGMRESSetMaxIter_long_dbl( HYPRE_Solver solver, HYPRE_Int max_iter );
HYPRE_Int
HYPRE_ParCSRCOGMRESSetMaxIter( HYPRE_Solver solver, HYPRE_Int max_iter );

HYPRE_Int
HYPRE_ParCSRCOGMRESSetMinIter_flt( HYPRE_Solver solver, HYPRE_Int min_iter );
HYPRE_Int
HYPRE_ParCSRCOGMRESSetMinIter_dbl( HYPRE_Solver solver, HYPRE_Int min_iter );
HYPRE_Int
HYPRE_ParCSRCOGMRESSetMinIter_long_dbl( HYPRE_Solver solver, HYPRE_Int min_iter );
HYPRE_Int
HYPRE_ParCSRCOGMRESSetMinIter( HYPRE_Solver solver, HYPRE_Int min_iter );

HYPRE_Int
HYPRE_ParCSRCOGMRESSetPrecond_flt( HYPRE_Solver solver, HYPRE_PtrToParSolverFcn precond, HYPRE_PtrToParSolverFcn precond_setup, HYPRE_Solver precond_solver );
HYPRE_Int
HYPRE_ParCSRCOGMRESSetPrecond_dbl( HYPRE_Solver solver, HYPRE_PtrToParSolverFcn precond, HYPRE_PtrToParSolverFcn precond_setup, HYPRE_Solver precond_solver );
HYPRE_Int
HYPRE_ParCSRCOGMRESSetPrecond_long_dbl( HYPRE_Solver solver, HYPRE_PtrToParSolverFcn precond, HYPRE_PtrToParSolverFcn precond_setup, HYPRE_Solver precond_solver );
HYPRE_Int
HYPRE_ParCSRCOGMRESSetPrecond( HYPRE_Solver solver, HYPRE_PtrToParSolverFcn precond, HYPRE_PtrToParSolverFcn precond_setup, HYPRE_Solver precond_solver );

HYPRE_Int
HYPRE_ParCSRCOGMRESSetPrintLevel_flt( HYPRE_Solver solver, HYPRE_Int print_level );
HYPRE_Int
HYPRE_ParCSRCOGMRESSetPrintLevel_dbl( HYPRE_Solver solver, HYPRE_Int print_level );
HYPRE_Int
HYPRE_ParCSRCOGMRESSetPrintLevel_long_dbl( HYPRE_Solver solver, HYPRE_Int print_level );
HYPRE_Int
HYPRE_ParCSRCOGMRESSetPrintLevel( HYPRE_Solver solver, HYPRE_Int print_level );

HYPRE_Int
HYPRE_ParCSRCOGMRESSetTol_flt( HYPRE_Solver solver, hypre_float tol );
HYPRE_Int
HYPRE_ParCSRCOGMRESSetTol_dbl( HYPRE_Solver solver, hypre_double tol );
HYPRE_Int
HYPRE_ParCSRCOGMRESSetTol_long_dbl( HYPRE_Solver solver, hypre_long_double tol );
HYPRE_Int
HYPRE_ParCSRCOGMRESSetTol( HYPRE_Solver solver, hypre_long_double tol );

HYPRE_Int
HYPRE_ParCSRCOGMRESSetUnroll_flt( HYPRE_Solver solver, HYPRE_Int unroll );
HYPRE_Int
HYPRE_ParCSRCOGMRESSetUnroll_dbl( HYPRE_Solver solver, HYPRE_Int unroll );
HYPRE_Int
HYPRE_ParCSRCOGMRESSetUnroll_long_dbl( HYPRE_Solver solver, HYPRE_Int unroll );
HYPRE_Int
HYPRE_ParCSRCOGMRESSetUnroll( HYPRE_Solver solver, HYPRE_Int unroll );

HYPRE_Int
HYPRE_ParCSRCOGMRESSetup_flt( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_ParCSRCOGMRESSetup_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_ParCSRCOGMRESSetup_long_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_ParCSRCOGMRESSetup( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );

HYPRE_Int
HYPRE_ParCSRCOGMRESSolve_flt( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_ParCSRCOGMRESSolve_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_ParCSRCOGMRESSolve_long_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_ParCSRCOGMRESSolve( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );

HYPRE_Int
HYPRE_ParCSRDiagScale_flt( HYPRE_Solver solver, HYPRE_ParCSRMatrix HA, HYPRE_ParVector Hy, HYPRE_ParVector Hx );
HYPRE_Int
HYPRE_ParCSRDiagScale_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix HA, HYPRE_ParVector Hy, HYPRE_ParVector Hx );
HYPRE_Int
HYPRE_ParCSRDiagScale_long_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix HA, HYPRE_ParVector Hy, HYPRE_ParVector Hx );
HYPRE_Int
HYPRE_ParCSRDiagScale( HYPRE_Solver solver, HYPRE_ParCSRMatrix HA, HYPRE_ParVector Hy, HYPRE_ParVector Hx );

HYPRE_Int
HYPRE_ParCSRDiagScaleSetup_flt( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector y, HYPRE_ParVector x );
HYPRE_Int
HYPRE_ParCSRDiagScaleSetup_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector y, HYPRE_ParVector x );
HYPRE_Int
HYPRE_ParCSRDiagScaleSetup_long_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector y, HYPRE_ParVector x );
HYPRE_Int
HYPRE_ParCSRDiagScaleSetup( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector y, HYPRE_ParVector x );

HYPRE_Int
HYPRE_ParCSRFlexGMRESCreate_flt( MPI_Comm comm, HYPRE_Solver *solver );
HYPRE_Int
HYPRE_ParCSRFlexGMRESCreate_dbl( MPI_Comm comm, HYPRE_Solver *solver );
HYPRE_Int
HYPRE_ParCSRFlexGMRESCreate_long_dbl( MPI_Comm comm, HYPRE_Solver *solver );
HYPRE_Int
HYPRE_ParCSRFlexGMRESCreate( MPI_Comm comm, HYPRE_Solver *solver );

HYPRE_Int
HYPRE_ParCSRFlexGMRESDestroy_flt( HYPRE_Solver solver );
HYPRE_Int
HYPRE_ParCSRFlexGMRESDestroy_dbl( HYPRE_Solver solver );
HYPRE_Int
HYPRE_ParCSRFlexGMRESDestroy_long_dbl( HYPRE_Solver solver );
HYPRE_Int
HYPRE_ParCSRFlexGMRESDestroy( HYPRE_Solver solver );

HYPRE_Int
HYPRE_ParCSRFlexGMRESGetFinalRelativeResidualNorm_flt( HYPRE_Solver solver, hypre_float *norm );
HYPRE_Int
HYPRE_ParCSRFlexGMRESGetFinalRelativeResidualNorm_dbl( HYPRE_Solver solver, hypre_double *norm );
HYPRE_Int
HYPRE_ParCSRFlexGMRESGetFinalRelativeResidualNorm_long_dbl( HYPRE_Solver solver, hypre_long_double *norm );
HYPRE_Int
HYPRE_ParCSRFlexGMRESGetFinalRelativeResidualNorm( HYPRE_Solver solver, void *norm );

HYPRE_Int
HYPRE_ParCSRFlexGMRESGetNumIterations_flt( HYPRE_Solver solver, HYPRE_Int *num_iterations );
HYPRE_Int
HYPRE_ParCSRFlexGMRESGetNumIterations_dbl( HYPRE_Solver solver, HYPRE_Int *num_iterations );
HYPRE_Int
HYPRE_ParCSRFlexGMRESGetNumIterations_long_dbl( HYPRE_Solver solver, HYPRE_Int *num_iterations );
HYPRE_Int
HYPRE_ParCSRFlexGMRESGetNumIterations( HYPRE_Solver solver, HYPRE_Int *num_iterations );

HYPRE_Int
HYPRE_ParCSRFlexGMRESGetPrecond_flt( HYPRE_Solver solver, HYPRE_Solver *precond_data );
HYPRE_Int
HYPRE_ParCSRFlexGMRESGetPrecond_dbl( HYPRE_Solver solver, HYPRE_Solver *precond_data );
HYPRE_Int
HYPRE_ParCSRFlexGMRESGetPrecond_long_dbl( HYPRE_Solver solver, HYPRE_Solver *precond_data );
HYPRE_Int
HYPRE_ParCSRFlexGMRESGetPrecond( HYPRE_Solver solver, HYPRE_Solver *precond_data );

HYPRE_Int
HYPRE_ParCSRFlexGMRESGetResidual_flt( HYPRE_Solver solver, HYPRE_ParVector *residual );
HYPRE_Int
HYPRE_ParCSRFlexGMRESGetResidual_dbl( HYPRE_Solver solver, HYPRE_ParVector *residual );
HYPRE_Int
HYPRE_ParCSRFlexGMRESGetResidual_long_dbl( HYPRE_Solver solver, HYPRE_ParVector *residual );
HYPRE_Int
HYPRE_ParCSRFlexGMRESGetResidual( HYPRE_Solver solver, HYPRE_ParVector *residual );

HYPRE_Int
HYPRE_ParCSRFlexGMRESSetAbsoluteTol_flt( HYPRE_Solver solver, hypre_float a_tol );
HYPRE_Int
HYPRE_ParCSRFlexGMRESSetAbsoluteTol_dbl( HYPRE_Solver solver, hypre_double a_tol );
HYPRE_Int
HYPRE_ParCSRFlexGMRESSetAbsoluteTol_long_dbl( HYPRE_Solver solver, hypre_long_double a_tol );
HYPRE_Int
HYPRE_ParCSRFlexGMRESSetAbsoluteTol( HYPRE_Solver solver, hypre_long_double a_tol );

HYPRE_Int
HYPRE_ParCSRFlexGMRESSetKDim_flt( HYPRE_Solver solver, HYPRE_Int k_dim );
HYPRE_Int
HYPRE_ParCSRFlexGMRESSetKDim_dbl( HYPRE_Solver solver, HYPRE_Int k_dim );
HYPRE_Int
HYPRE_ParCSRFlexGMRESSetKDim_long_dbl( HYPRE_Solver solver, HYPRE_Int k_dim );
HYPRE_Int
HYPRE_ParCSRFlexGMRESSetKDim( HYPRE_Solver solver, HYPRE_Int k_dim );

HYPRE_Int
HYPRE_ParCSRFlexGMRESSetLogging_flt( HYPRE_Solver solver, HYPRE_Int logging );
HYPRE_Int
HYPRE_ParCSRFlexGMRESSetLogging_dbl( HYPRE_Solver solver, HYPRE_Int logging );
HYPRE_Int
HYPRE_ParCSRFlexGMRESSetLogging_long_dbl( HYPRE_Solver solver, HYPRE_Int logging );
HYPRE_Int
HYPRE_ParCSRFlexGMRESSetLogging( HYPRE_Solver solver, HYPRE_Int logging );

HYPRE_Int
HYPRE_ParCSRFlexGMRESSetMaxIter_flt( HYPRE_Solver solver, HYPRE_Int max_iter );
HYPRE_Int
HYPRE_ParCSRFlexGMRESSetMaxIter_dbl( HYPRE_Solver solver, HYPRE_Int max_iter );
HYPRE_Int
HYPRE_ParCSRFlexGMRESSetMaxIter_long_dbl( HYPRE_Solver solver, HYPRE_Int max_iter );
HYPRE_Int
HYPRE_ParCSRFlexGMRESSetMaxIter( HYPRE_Solver solver, HYPRE_Int max_iter );

HYPRE_Int
HYPRE_ParCSRFlexGMRESSetMinIter_flt( HYPRE_Solver solver, HYPRE_Int min_iter );
HYPRE_Int
HYPRE_ParCSRFlexGMRESSetMinIter_dbl( HYPRE_Solver solver, HYPRE_Int min_iter );
HYPRE_Int
HYPRE_ParCSRFlexGMRESSetMinIter_long_dbl( HYPRE_Solver solver, HYPRE_Int min_iter );
HYPRE_Int
HYPRE_ParCSRFlexGMRESSetMinIter( HYPRE_Solver solver, HYPRE_Int min_iter );

HYPRE_Int
HYPRE_ParCSRFlexGMRESSetModifyPC_flt( HYPRE_Solver solver, HYPRE_PtrToModifyPCFcn modify_pc );
HYPRE_Int
HYPRE_ParCSRFlexGMRESSetModifyPC_dbl( HYPRE_Solver solver, HYPRE_PtrToModifyPCFcn modify_pc );
HYPRE_Int
HYPRE_ParCSRFlexGMRESSetModifyPC_long_dbl( HYPRE_Solver solver, HYPRE_PtrToModifyPCFcn modify_pc );
HYPRE_Int
HYPRE_ParCSRFlexGMRESSetModifyPC( HYPRE_Solver solver, HYPRE_PtrToModifyPCFcn modify_pc );

HYPRE_Int
HYPRE_ParCSRFlexGMRESSetPrecond_flt( HYPRE_Solver solver, HYPRE_PtrToParSolverFcn precond, HYPRE_PtrToParSolverFcn precond_setup, HYPRE_Solver precond_solver );
HYPRE_Int
HYPRE_ParCSRFlexGMRESSetPrecond_dbl( HYPRE_Solver solver, HYPRE_PtrToParSolverFcn precond, HYPRE_PtrToParSolverFcn precond_setup, HYPRE_Solver precond_solver );
HYPRE_Int
HYPRE_ParCSRFlexGMRESSetPrecond_long_dbl( HYPRE_Solver solver, HYPRE_PtrToParSolverFcn precond, HYPRE_PtrToParSolverFcn precond_setup, HYPRE_Solver precond_solver );
HYPRE_Int
HYPRE_ParCSRFlexGMRESSetPrecond( HYPRE_Solver solver, HYPRE_PtrToParSolverFcn precond, HYPRE_PtrToParSolverFcn precond_setup, HYPRE_Solver precond_solver );

HYPRE_Int
HYPRE_ParCSRFlexGMRESSetPrintLevel_flt( HYPRE_Solver solver, HYPRE_Int print_level );
HYPRE_Int
HYPRE_ParCSRFlexGMRESSetPrintLevel_dbl( HYPRE_Solver solver, HYPRE_Int print_level );
HYPRE_Int
HYPRE_ParCSRFlexGMRESSetPrintLevel_long_dbl( HYPRE_Solver solver, HYPRE_Int print_level );
HYPRE_Int
HYPRE_ParCSRFlexGMRESSetPrintLevel( HYPRE_Solver solver, HYPRE_Int print_level );

HYPRE_Int
HYPRE_ParCSRFlexGMRESSetTol_flt( HYPRE_Solver solver, hypre_float tol );
HYPRE_Int
HYPRE_ParCSRFlexGMRESSetTol_dbl( HYPRE_Solver solver, hypre_double tol );
HYPRE_Int
HYPRE_ParCSRFlexGMRESSetTol_long_dbl( HYPRE_Solver solver, hypre_long_double tol );
HYPRE_Int
HYPRE_ParCSRFlexGMRESSetTol( HYPRE_Solver solver, hypre_long_double tol );

HYPRE_Int
HYPRE_ParCSRFlexGMRESSetup_flt( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_ParCSRFlexGMRESSetup_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_ParCSRFlexGMRESSetup_long_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_ParCSRFlexGMRESSetup( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );

HYPRE_Int
HYPRE_ParCSRFlexGMRESSolve_flt( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_ParCSRFlexGMRESSolve_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_ParCSRFlexGMRESSolve_long_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_ParCSRFlexGMRESSolve( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );

HYPRE_Int
HYPRE_ParCSRGMRESCreate_flt( MPI_Comm comm, HYPRE_Solver *solver );
HYPRE_Int
HYPRE_ParCSRGMRESCreate_dbl( MPI_Comm comm, HYPRE_Solver *solver );
HYPRE_Int
HYPRE_ParCSRGMRESCreate_long_dbl( MPI_Comm comm, HYPRE_Solver *solver );
HYPRE_Int
HYPRE_ParCSRGMRESCreate( MPI_Comm comm, HYPRE_Solver *solver );

HYPRE_Int
HYPRE_ParCSRGMRESDestroy_flt( HYPRE_Solver solver );
HYPRE_Int
HYPRE_ParCSRGMRESDestroy_dbl( HYPRE_Solver solver );
HYPRE_Int
HYPRE_ParCSRGMRESDestroy_long_dbl( HYPRE_Solver solver );
HYPRE_Int
HYPRE_ParCSRGMRESDestroy( HYPRE_Solver solver );

HYPRE_Int
HYPRE_ParCSRGMRESGetFinalRelativeResidualNorm_flt( HYPRE_Solver solver, hypre_float *norm );
HYPRE_Int
HYPRE_ParCSRGMRESGetFinalRelativeResidualNorm_dbl( HYPRE_Solver solver, hypre_double *norm );
HYPRE_Int
HYPRE_ParCSRGMRESGetFinalRelativeResidualNorm_long_dbl( HYPRE_Solver solver, hypre_long_double *norm );
HYPRE_Int
HYPRE_ParCSRGMRESGetFinalRelativeResidualNorm( HYPRE_Solver solver, void *norm );

HYPRE_Int
HYPRE_ParCSRGMRESGetNumIterations_flt( HYPRE_Solver solver, HYPRE_Int *num_iterations );
HYPRE_Int
HYPRE_ParCSRGMRESGetNumIterations_dbl( HYPRE_Solver solver, HYPRE_Int *num_iterations );
HYPRE_Int
HYPRE_ParCSRGMRESGetNumIterations_long_dbl( HYPRE_Solver solver, HYPRE_Int *num_iterations );
HYPRE_Int
HYPRE_ParCSRGMRESGetNumIterations( HYPRE_Solver solver, HYPRE_Int *num_iterations );

HYPRE_Int
HYPRE_ParCSRGMRESGetPrecond_flt( HYPRE_Solver solver, HYPRE_Solver *precond_data );
HYPRE_Int
HYPRE_ParCSRGMRESGetPrecond_dbl( HYPRE_Solver solver, HYPRE_Solver *precond_data );
HYPRE_Int
HYPRE_ParCSRGMRESGetPrecond_long_dbl( HYPRE_Solver solver, HYPRE_Solver *precond_data );
HYPRE_Int
HYPRE_ParCSRGMRESGetPrecond( HYPRE_Solver solver, HYPRE_Solver *precond_data );

HYPRE_Int
HYPRE_ParCSRGMRESGetRefSolution_flt( HYPRE_Solver solver, HYPRE_ParVector *ref_solution );
HYPRE_Int
HYPRE_ParCSRGMRESGetRefSolution_dbl( HYPRE_Solver solver, HYPRE_ParVector *ref_solution );
HYPRE_Int
HYPRE_ParCSRGMRESGetRefSolution_long_dbl( HYPRE_Solver solver, HYPRE_ParVector *ref_solution );
HYPRE_Int
HYPRE_ParCSRGMRESGetRefSolution( HYPRE_Solver solver, HYPRE_ParVector *ref_solution );

HYPRE_Int
HYPRE_ParCSRGMRESGetResidual_flt( HYPRE_Solver solver, HYPRE_ParVector *residual );
HYPRE_Int
HYPRE_ParCSRGMRESGetResidual_dbl( HYPRE_Solver solver, HYPRE_ParVector *residual );
HYPRE_Int
HYPRE_ParCSRGMRESGetResidual_long_dbl( HYPRE_Solver solver, HYPRE_ParVector *residual );
HYPRE_Int
HYPRE_ParCSRGMRESGetResidual( HYPRE_Solver solver, HYPRE_ParVector *residual );

HYPRE_Int
HYPRE_ParCSRGMRESSetAbsoluteTol_flt( HYPRE_Solver solver, hypre_float a_tol );
HYPRE_Int
HYPRE_ParCSRGMRESSetAbsoluteTol_dbl( HYPRE_Solver solver, hypre_double a_tol );
HYPRE_Int
HYPRE_ParCSRGMRESSetAbsoluteTol_long_dbl( HYPRE_Solver solver, hypre_long_double a_tol );
HYPRE_Int
HYPRE_ParCSRGMRESSetAbsoluteTol( HYPRE_Solver solver, hypre_long_double a_tol );

HYPRE_Int
HYPRE_ParCSRGMRESSetKDim_flt( HYPRE_Solver solver, HYPRE_Int k_dim );
HYPRE_Int
HYPRE_ParCSRGMRESSetKDim_dbl( HYPRE_Solver solver, HYPRE_Int k_dim );
HYPRE_Int
HYPRE_ParCSRGMRESSetKDim_long_dbl( HYPRE_Solver solver, HYPRE_Int k_dim );
HYPRE_Int
HYPRE_ParCSRGMRESSetKDim( HYPRE_Solver solver, HYPRE_Int k_dim );

HYPRE_Int
HYPRE_ParCSRGMRESSetLogging_flt( HYPRE_Solver solver, HYPRE_Int logging );
HYPRE_Int
HYPRE_ParCSRGMRESSetLogging_dbl( HYPRE_Solver solver, HYPRE_Int logging );
HYPRE_Int
HYPRE_ParCSRGMRESSetLogging_long_dbl( HYPRE_Solver solver, HYPRE_Int logging );
HYPRE_Int
HYPRE_ParCSRGMRESSetLogging( HYPRE_Solver solver, HYPRE_Int logging );

HYPRE_Int
HYPRE_ParCSRGMRESSetMaxIter_flt( HYPRE_Solver solver, HYPRE_Int max_iter );
HYPRE_Int
HYPRE_ParCSRGMRESSetMaxIter_dbl( HYPRE_Solver solver, HYPRE_Int max_iter );
HYPRE_Int
HYPRE_ParCSRGMRESSetMaxIter_long_dbl( HYPRE_Solver solver, HYPRE_Int max_iter );
HYPRE_Int
HYPRE_ParCSRGMRESSetMaxIter( HYPRE_Solver solver, HYPRE_Int max_iter );

HYPRE_Int
HYPRE_ParCSRGMRESSetMinIter_flt( HYPRE_Solver solver, HYPRE_Int min_iter );
HYPRE_Int
HYPRE_ParCSRGMRESSetMinIter_dbl( HYPRE_Solver solver, HYPRE_Int min_iter );
HYPRE_Int
HYPRE_ParCSRGMRESSetMinIter_long_dbl( HYPRE_Solver solver, HYPRE_Int min_iter );
HYPRE_Int
HYPRE_ParCSRGMRESSetMinIter( HYPRE_Solver solver, HYPRE_Int min_iter );

HYPRE_Int
HYPRE_ParCSRGMRESSetPrecond_flt( HYPRE_Solver solver, HYPRE_PtrToParSolverFcn precond, HYPRE_PtrToParSolverFcn precond_setup, HYPRE_Solver precond_solver );
HYPRE_Int
HYPRE_ParCSRGMRESSetPrecond_dbl( HYPRE_Solver solver, HYPRE_PtrToParSolverFcn precond, HYPRE_PtrToParSolverFcn precond_setup, HYPRE_Solver precond_solver );
HYPRE_Int
HYPRE_ParCSRGMRESSetPrecond_long_dbl( HYPRE_Solver solver, HYPRE_PtrToParSolverFcn precond, HYPRE_PtrToParSolverFcn precond_setup, HYPRE_Solver precond_solver );
HYPRE_Int
HYPRE_ParCSRGMRESSetPrecond( HYPRE_Solver solver, HYPRE_PtrToParSolverFcn precond, HYPRE_PtrToParSolverFcn precond_setup, HYPRE_Solver precond_solver );

HYPRE_Int
HYPRE_ParCSRGMRESSetPrintLevel_flt( HYPRE_Solver solver, HYPRE_Int print_level );
HYPRE_Int
HYPRE_ParCSRGMRESSetPrintLevel_dbl( HYPRE_Solver solver, HYPRE_Int print_level );
HYPRE_Int
HYPRE_ParCSRGMRESSetPrintLevel_long_dbl( HYPRE_Solver solver, HYPRE_Int print_level );
HYPRE_Int
HYPRE_ParCSRGMRESSetPrintLevel( HYPRE_Solver solver, HYPRE_Int print_level );

HYPRE_Int
HYPRE_ParCSRGMRESSetRefSolution_flt( HYPRE_Solver solver, HYPRE_ParVector ref_solution );
HYPRE_Int
HYPRE_ParCSRGMRESSetRefSolution_dbl( HYPRE_Solver solver, HYPRE_ParVector ref_solution );
HYPRE_Int
HYPRE_ParCSRGMRESSetRefSolution_long_dbl( HYPRE_Solver solver, HYPRE_ParVector ref_solution );
HYPRE_Int
HYPRE_ParCSRGMRESSetRefSolution( HYPRE_Solver solver, HYPRE_ParVector ref_solution );

HYPRE_Int
HYPRE_ParCSRGMRESSetStopCrit_flt( HYPRE_Solver solver, HYPRE_Int stop_crit );
HYPRE_Int
HYPRE_ParCSRGMRESSetStopCrit_dbl( HYPRE_Solver solver, HYPRE_Int stop_crit );
HYPRE_Int
HYPRE_ParCSRGMRESSetStopCrit_long_dbl( HYPRE_Solver solver, HYPRE_Int stop_crit );
HYPRE_Int
HYPRE_ParCSRGMRESSetStopCrit( HYPRE_Solver solver, HYPRE_Int stop_crit );

HYPRE_Int
HYPRE_ParCSRGMRESSetTol_flt( HYPRE_Solver solver, hypre_float tol );
HYPRE_Int
HYPRE_ParCSRGMRESSetTol_dbl( HYPRE_Solver solver, hypre_double tol );
HYPRE_Int
HYPRE_ParCSRGMRESSetTol_long_dbl( HYPRE_Solver solver, hypre_long_double tol );
HYPRE_Int
HYPRE_ParCSRGMRESSetTol( HYPRE_Solver solver, hypre_long_double tol );

HYPRE_Int
HYPRE_ParCSRGMRESSetup_flt( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_ParCSRGMRESSetup_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_ParCSRGMRESSetup_long_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_ParCSRGMRESSetup( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );

HYPRE_Int
HYPRE_ParCSRGMRESSolve_flt( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_ParCSRGMRESSolve_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_ParCSRGMRESSolve_long_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_ParCSRGMRESSolve( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );

HYPRE_Int
HYPRE_ParCSRHybridCreate_flt( HYPRE_Solver *solver );
HYPRE_Int
HYPRE_ParCSRHybridCreate_dbl( HYPRE_Solver *solver );
HYPRE_Int
HYPRE_ParCSRHybridCreate_long_dbl( HYPRE_Solver *solver );
HYPRE_Int
HYPRE_ParCSRHybridCreate( HYPRE_Solver *solver );

HYPRE_Int
HYPRE_ParCSRHybridDestroy_flt( HYPRE_Solver solver );
HYPRE_Int
HYPRE_ParCSRHybridDestroy_dbl( HYPRE_Solver solver );
HYPRE_Int
HYPRE_ParCSRHybridDestroy_long_dbl( HYPRE_Solver solver );
HYPRE_Int
HYPRE_ParCSRHybridDestroy( HYPRE_Solver solver );

HYPRE_Int
HYPRE_ParCSRHybridGetDSCGNumIterations_flt( HYPRE_Solver solver, HYPRE_Int *dscg_num_its );
HYPRE_Int
HYPRE_ParCSRHybridGetDSCGNumIterations_dbl( HYPRE_Solver solver, HYPRE_Int *dscg_num_its );
HYPRE_Int
HYPRE_ParCSRHybridGetDSCGNumIterations_long_dbl( HYPRE_Solver solver, HYPRE_Int *dscg_num_its );
HYPRE_Int
HYPRE_ParCSRHybridGetDSCGNumIterations( HYPRE_Solver solver, HYPRE_Int *dscg_num_its );

HYPRE_Int
HYPRE_ParCSRHybridGetFinalRelativeResidualNorm_flt( HYPRE_Solver solver, hypre_float *norm );
HYPRE_Int
HYPRE_ParCSRHybridGetFinalRelativeResidualNorm_dbl( HYPRE_Solver solver, hypre_double *norm );
HYPRE_Int
HYPRE_ParCSRHybridGetFinalRelativeResidualNorm_long_dbl( HYPRE_Solver solver, hypre_long_double *norm );
HYPRE_Int
HYPRE_ParCSRHybridGetFinalRelativeResidualNorm( HYPRE_Solver solver, void *norm );

HYPRE_Int
HYPRE_ParCSRHybridGetNumIterations_flt( HYPRE_Solver solver, HYPRE_Int *num_its );
HYPRE_Int
HYPRE_ParCSRHybridGetNumIterations_dbl( HYPRE_Solver solver, HYPRE_Int *num_its );
HYPRE_Int
HYPRE_ParCSRHybridGetNumIterations_long_dbl( HYPRE_Solver solver, HYPRE_Int *num_its );
HYPRE_Int
HYPRE_ParCSRHybridGetNumIterations( HYPRE_Solver solver, HYPRE_Int *num_its );

HYPRE_Int
HYPRE_ParCSRHybridGetPCGNumIterations_flt( HYPRE_Solver solver, HYPRE_Int *pcg_num_its );
HYPRE_Int
HYPRE_ParCSRHybridGetPCGNumIterations_dbl( HYPRE_Solver solver, HYPRE_Int *pcg_num_its );
HYPRE_Int
HYPRE_ParCSRHybridGetPCGNumIterations_long_dbl( HYPRE_Solver solver, HYPRE_Int *pcg_num_its );
HYPRE_Int
HYPRE_ParCSRHybridGetPCGNumIterations( HYPRE_Solver solver, HYPRE_Int *pcg_num_its );

HYPRE_Int
HYPRE_ParCSRHybridGetRecomputeResidual_flt( HYPRE_Solver solver, HYPRE_Int *recompute_residual );
HYPRE_Int
HYPRE_ParCSRHybridGetRecomputeResidual_dbl( HYPRE_Solver solver, HYPRE_Int *recompute_residual );
HYPRE_Int
HYPRE_ParCSRHybridGetRecomputeResidual_long_dbl( HYPRE_Solver solver, HYPRE_Int *recompute_residual );
HYPRE_Int
HYPRE_ParCSRHybridGetRecomputeResidual( HYPRE_Solver solver, HYPRE_Int *recompute_residual );

HYPRE_Int
HYPRE_ParCSRHybridGetRecomputeResidualP_flt( HYPRE_Solver solver, HYPRE_Int *recompute_residual_p );
HYPRE_Int
HYPRE_ParCSRHybridGetRecomputeResidualP_dbl( HYPRE_Solver solver, HYPRE_Int *recompute_residual_p );
HYPRE_Int
HYPRE_ParCSRHybridGetRecomputeResidualP_long_dbl( HYPRE_Solver solver, HYPRE_Int *recompute_residual_p );
HYPRE_Int
HYPRE_ParCSRHybridGetRecomputeResidualP( HYPRE_Solver solver, HYPRE_Int *recompute_residual_p );

HYPRE_Int
HYPRE_ParCSRHybridGetSetupSolveTime_flt( HYPRE_Solver solver, hypre_float *time );
HYPRE_Int
HYPRE_ParCSRHybridGetSetupSolveTime_dbl( HYPRE_Solver solver, hypre_double *time );
HYPRE_Int
HYPRE_ParCSRHybridGetSetupSolveTime_long_dbl( HYPRE_Solver solver, hypre_long_double *time );
HYPRE_Int
HYPRE_ParCSRHybridGetSetupSolveTime( HYPRE_Solver solver, void *time );

HYPRE_Int
HYPRE_ParCSRHybridSetAbsoluteTol_flt( HYPRE_Solver solver, hypre_float tol );
HYPRE_Int
HYPRE_ParCSRHybridSetAbsoluteTol_dbl( HYPRE_Solver solver, hypre_double tol );
HYPRE_Int
HYPRE_ParCSRHybridSetAbsoluteTol_long_dbl( HYPRE_Solver solver, hypre_long_double tol );
HYPRE_Int
HYPRE_ParCSRHybridSetAbsoluteTol( HYPRE_Solver solver, hypre_long_double tol );

HYPRE_Int
HYPRE_ParCSRHybridSetAggInterpType_flt( HYPRE_Solver solver, HYPRE_Int agg_interp_type );
HYPRE_Int
HYPRE_ParCSRHybridSetAggInterpType_dbl( HYPRE_Solver solver, HYPRE_Int agg_interp_type );
HYPRE_Int
HYPRE_ParCSRHybridSetAggInterpType_long_dbl( HYPRE_Solver solver, HYPRE_Int agg_interp_type );
HYPRE_Int
HYPRE_ParCSRHybridSetAggInterpType( HYPRE_Solver solver, HYPRE_Int agg_interp_type );

HYPRE_Int
HYPRE_ParCSRHybridSetAggNumLevels_flt( HYPRE_Solver solver, HYPRE_Int agg_num_levels );
HYPRE_Int
HYPRE_ParCSRHybridSetAggNumLevels_dbl( HYPRE_Solver solver, HYPRE_Int agg_num_levels );
HYPRE_Int
HYPRE_ParCSRHybridSetAggNumLevels_long_dbl( HYPRE_Solver solver, HYPRE_Int agg_num_levels );
HYPRE_Int
HYPRE_ParCSRHybridSetAggNumLevels( HYPRE_Solver solver, HYPRE_Int agg_num_levels );

HYPRE_Int
HYPRE_ParCSRHybridSetCoarsenType_flt( HYPRE_Solver solver, HYPRE_Int coarsen_type );
HYPRE_Int
HYPRE_ParCSRHybridSetCoarsenType_dbl( HYPRE_Solver solver, HYPRE_Int coarsen_type );
HYPRE_Int
HYPRE_ParCSRHybridSetCoarsenType_long_dbl( HYPRE_Solver solver, HYPRE_Int coarsen_type );
HYPRE_Int
HYPRE_ParCSRHybridSetCoarsenType( HYPRE_Solver solver, HYPRE_Int coarsen_type );

HYPRE_Int
HYPRE_ParCSRHybridSetConvergenceTol_flt( HYPRE_Solver solver, hypre_float cf_tol );
HYPRE_Int
HYPRE_ParCSRHybridSetConvergenceTol_dbl( HYPRE_Solver solver, hypre_double cf_tol );
HYPRE_Int
HYPRE_ParCSRHybridSetConvergenceTol_long_dbl( HYPRE_Solver solver, hypre_long_double cf_tol );
HYPRE_Int
HYPRE_ParCSRHybridSetConvergenceTol( HYPRE_Solver solver, hypre_long_double cf_tol );

HYPRE_Int
HYPRE_ParCSRHybridSetCycleNumSweeps_flt( HYPRE_Solver solver, HYPRE_Int num_sweeps, HYPRE_Int k );
HYPRE_Int
HYPRE_ParCSRHybridSetCycleNumSweeps_dbl( HYPRE_Solver solver, HYPRE_Int num_sweeps, HYPRE_Int k );
HYPRE_Int
HYPRE_ParCSRHybridSetCycleNumSweeps_long_dbl( HYPRE_Solver solver, HYPRE_Int num_sweeps, HYPRE_Int k );
HYPRE_Int
HYPRE_ParCSRHybridSetCycleNumSweeps( HYPRE_Solver solver, HYPRE_Int num_sweeps, HYPRE_Int k );

HYPRE_Int
HYPRE_ParCSRHybridSetCycleRelaxType_flt( HYPRE_Solver solver, HYPRE_Int relax_type, HYPRE_Int k );
HYPRE_Int
HYPRE_ParCSRHybridSetCycleRelaxType_dbl( HYPRE_Solver solver, HYPRE_Int relax_type, HYPRE_Int k );
HYPRE_Int
HYPRE_ParCSRHybridSetCycleRelaxType_long_dbl( HYPRE_Solver solver, HYPRE_Int relax_type, HYPRE_Int k );
HYPRE_Int
HYPRE_ParCSRHybridSetCycleRelaxType( HYPRE_Solver solver, HYPRE_Int relax_type, HYPRE_Int k );

HYPRE_Int
HYPRE_ParCSRHybridSetCycleType_flt( HYPRE_Solver solver, HYPRE_Int cycle_type );
HYPRE_Int
HYPRE_ParCSRHybridSetCycleType_dbl( HYPRE_Solver solver, HYPRE_Int cycle_type );
HYPRE_Int
HYPRE_ParCSRHybridSetCycleType_long_dbl( HYPRE_Solver solver, HYPRE_Int cycle_type );
HYPRE_Int
HYPRE_ParCSRHybridSetCycleType( HYPRE_Solver solver, HYPRE_Int cycle_type );

HYPRE_Int
HYPRE_ParCSRHybridSetDSCGMaxIter_flt( HYPRE_Solver solver, HYPRE_Int dscg_max_its );
HYPRE_Int
HYPRE_ParCSRHybridSetDSCGMaxIter_dbl( HYPRE_Solver solver, HYPRE_Int dscg_max_its );
HYPRE_Int
HYPRE_ParCSRHybridSetDSCGMaxIter_long_dbl( HYPRE_Solver solver, HYPRE_Int dscg_max_its );
HYPRE_Int
HYPRE_ParCSRHybridSetDSCGMaxIter( HYPRE_Solver solver, HYPRE_Int dscg_max_its );

HYPRE_Int
HYPRE_ParCSRHybridSetDofFunc_flt( HYPRE_Solver solver, HYPRE_Int *dof_func );
HYPRE_Int
HYPRE_ParCSRHybridSetDofFunc_dbl( HYPRE_Solver solver, HYPRE_Int *dof_func );
HYPRE_Int
HYPRE_ParCSRHybridSetDofFunc_long_dbl( HYPRE_Solver solver, HYPRE_Int *dof_func );
HYPRE_Int
HYPRE_ParCSRHybridSetDofFunc( HYPRE_Solver solver, HYPRE_Int *dof_func );

HYPRE_Int
HYPRE_ParCSRHybridSetGridRelaxPoints_flt( HYPRE_Solver solver, HYPRE_Int **grid_relax_points );
HYPRE_Int
HYPRE_ParCSRHybridSetGridRelaxPoints_dbl( HYPRE_Solver solver, HYPRE_Int **grid_relax_points );
HYPRE_Int
HYPRE_ParCSRHybridSetGridRelaxPoints_long_dbl( HYPRE_Solver solver, HYPRE_Int **grid_relax_points );
HYPRE_Int
HYPRE_ParCSRHybridSetGridRelaxPoints( HYPRE_Solver solver, HYPRE_Int **grid_relax_points );

HYPRE_Int
HYPRE_ParCSRHybridSetGridRelaxType_flt( HYPRE_Solver solver, HYPRE_Int *grid_relax_type );
HYPRE_Int
HYPRE_ParCSRHybridSetGridRelaxType_dbl( HYPRE_Solver solver, HYPRE_Int *grid_relax_type );
HYPRE_Int
HYPRE_ParCSRHybridSetGridRelaxType_long_dbl( HYPRE_Solver solver, HYPRE_Int *grid_relax_type );
HYPRE_Int
HYPRE_ParCSRHybridSetGridRelaxType( HYPRE_Solver solver, HYPRE_Int *grid_relax_type );

HYPRE_Int
HYPRE_ParCSRHybridSetInterpType_flt( HYPRE_Solver solver, HYPRE_Int interp_type );
HYPRE_Int
HYPRE_ParCSRHybridSetInterpType_dbl( HYPRE_Solver solver, HYPRE_Int interp_type );
HYPRE_Int
HYPRE_ParCSRHybridSetInterpType_long_dbl( HYPRE_Solver solver, HYPRE_Int interp_type );
HYPRE_Int
HYPRE_ParCSRHybridSetInterpType( HYPRE_Solver solver, HYPRE_Int interp_type );

HYPRE_Int
HYPRE_ParCSRHybridSetKDim_flt( HYPRE_Solver solver, HYPRE_Int k_dim );
HYPRE_Int
HYPRE_ParCSRHybridSetKDim_dbl( HYPRE_Solver solver, HYPRE_Int k_dim );
HYPRE_Int
HYPRE_ParCSRHybridSetKDim_long_dbl( HYPRE_Solver solver, HYPRE_Int k_dim );
HYPRE_Int
HYPRE_ParCSRHybridSetKDim( HYPRE_Solver solver, HYPRE_Int k_dim );

HYPRE_Int
HYPRE_ParCSRHybridSetKeepTranspose_flt( HYPRE_Solver solver, HYPRE_Int keepT );
HYPRE_Int
HYPRE_ParCSRHybridSetKeepTranspose_dbl( HYPRE_Solver solver, HYPRE_Int keepT );
HYPRE_Int
HYPRE_ParCSRHybridSetKeepTranspose_long_dbl( HYPRE_Solver solver, HYPRE_Int keepT );
HYPRE_Int
HYPRE_ParCSRHybridSetKeepTranspose( HYPRE_Solver solver, HYPRE_Int keepT );

HYPRE_Int
HYPRE_ParCSRHybridSetLevelOuterWt_flt( HYPRE_Solver solver, hypre_float outer_wt, HYPRE_Int level );
HYPRE_Int
HYPRE_ParCSRHybridSetLevelOuterWt_dbl( HYPRE_Solver solver, hypre_double outer_wt, HYPRE_Int level );
HYPRE_Int
HYPRE_ParCSRHybridSetLevelOuterWt_long_dbl( HYPRE_Solver solver, hypre_long_double outer_wt, HYPRE_Int level );
HYPRE_Int
HYPRE_ParCSRHybridSetLevelOuterWt( HYPRE_Solver solver, hypre_long_double outer_wt, HYPRE_Int level );

HYPRE_Int
HYPRE_ParCSRHybridSetLevelRelaxWt_flt( HYPRE_Solver solver, hypre_float relax_wt, HYPRE_Int level );
HYPRE_Int
HYPRE_ParCSRHybridSetLevelRelaxWt_dbl( HYPRE_Solver solver, hypre_double relax_wt, HYPRE_Int level );
HYPRE_Int
HYPRE_ParCSRHybridSetLevelRelaxWt_long_dbl( HYPRE_Solver solver, hypre_long_double relax_wt, HYPRE_Int level );
HYPRE_Int
HYPRE_ParCSRHybridSetLevelRelaxWt( HYPRE_Solver solver, hypre_long_double relax_wt, HYPRE_Int level );

HYPRE_Int
HYPRE_ParCSRHybridSetLogging_flt( HYPRE_Solver solver, HYPRE_Int logging );
HYPRE_Int
HYPRE_ParCSRHybridSetLogging_dbl( HYPRE_Solver solver, HYPRE_Int logging );
HYPRE_Int
HYPRE_ParCSRHybridSetLogging_long_dbl( HYPRE_Solver solver, HYPRE_Int logging );
HYPRE_Int
HYPRE_ParCSRHybridSetLogging( HYPRE_Solver solver, HYPRE_Int logging );

HYPRE_Int
HYPRE_ParCSRHybridSetMaxCoarseSize_flt( HYPRE_Solver solver, HYPRE_Int max_coarse_size );
HYPRE_Int
HYPRE_ParCSRHybridSetMaxCoarseSize_dbl( HYPRE_Solver solver, HYPRE_Int max_coarse_size );
HYPRE_Int
HYPRE_ParCSRHybridSetMaxCoarseSize_long_dbl( HYPRE_Solver solver, HYPRE_Int max_coarse_size );
HYPRE_Int
HYPRE_ParCSRHybridSetMaxCoarseSize( HYPRE_Solver solver, HYPRE_Int max_coarse_size );

HYPRE_Int
HYPRE_ParCSRHybridSetMaxLevels_flt( HYPRE_Solver solver, HYPRE_Int max_levels );
HYPRE_Int
HYPRE_ParCSRHybridSetMaxLevels_dbl( HYPRE_Solver solver, HYPRE_Int max_levels );
HYPRE_Int
HYPRE_ParCSRHybridSetMaxLevels_long_dbl( HYPRE_Solver solver, HYPRE_Int max_levels );
HYPRE_Int
HYPRE_ParCSRHybridSetMaxLevels( HYPRE_Solver solver, HYPRE_Int max_levels );

HYPRE_Int
HYPRE_ParCSRHybridSetMaxRowSum_flt( HYPRE_Solver solver, hypre_float max_row_sum );
HYPRE_Int
HYPRE_ParCSRHybridSetMaxRowSum_dbl( HYPRE_Solver solver, hypre_double max_row_sum );
HYPRE_Int
HYPRE_ParCSRHybridSetMaxRowSum_long_dbl( HYPRE_Solver solver, hypre_long_double max_row_sum );
HYPRE_Int
HYPRE_ParCSRHybridSetMaxRowSum( HYPRE_Solver solver, hypre_long_double max_row_sum );

HYPRE_Int
HYPRE_ParCSRHybridSetMeasureType_flt( HYPRE_Solver solver, HYPRE_Int measure_type );
HYPRE_Int
HYPRE_ParCSRHybridSetMeasureType_dbl( HYPRE_Solver solver, HYPRE_Int measure_type );
HYPRE_Int
HYPRE_ParCSRHybridSetMeasureType_long_dbl( HYPRE_Solver solver, HYPRE_Int measure_type );
HYPRE_Int
HYPRE_ParCSRHybridSetMeasureType( HYPRE_Solver solver, HYPRE_Int measure_type );

HYPRE_Int
HYPRE_ParCSRHybridSetMinCoarseSize_flt( HYPRE_Solver solver, HYPRE_Int min_coarse_size );
HYPRE_Int
HYPRE_ParCSRHybridSetMinCoarseSize_dbl( HYPRE_Solver solver, HYPRE_Int min_coarse_size );
HYPRE_Int
HYPRE_ParCSRHybridSetMinCoarseSize_long_dbl( HYPRE_Solver solver, HYPRE_Int min_coarse_size );
HYPRE_Int
HYPRE_ParCSRHybridSetMinCoarseSize( HYPRE_Solver solver, HYPRE_Int min_coarse_size );

HYPRE_Int
HYPRE_ParCSRHybridSetNodal_flt( HYPRE_Solver solver, HYPRE_Int nodal );
HYPRE_Int
HYPRE_ParCSRHybridSetNodal_dbl( HYPRE_Solver solver, HYPRE_Int nodal );
HYPRE_Int
HYPRE_ParCSRHybridSetNodal_long_dbl( HYPRE_Solver solver, HYPRE_Int nodal );
HYPRE_Int
HYPRE_ParCSRHybridSetNodal( HYPRE_Solver solver, HYPRE_Int nodal );

HYPRE_Int
HYPRE_ParCSRHybridSetNonGalerkinTol_flt( HYPRE_Solver solver, HYPRE_Int num_levels, hypre_float *nongalerkin_tol );
HYPRE_Int
HYPRE_ParCSRHybridSetNonGalerkinTol_dbl( HYPRE_Solver solver, HYPRE_Int num_levels, hypre_double *nongalerkin_tol );
HYPRE_Int
HYPRE_ParCSRHybridSetNonGalerkinTol_long_dbl( HYPRE_Solver solver, HYPRE_Int num_levels, hypre_long_double *nongalerkin_tol );
HYPRE_Int
HYPRE_ParCSRHybridSetNonGalerkinTol( HYPRE_Solver solver, HYPRE_Int num_levels, void *nongalerkin_tol );

HYPRE_Int
HYPRE_ParCSRHybridSetNumFunctions_flt( HYPRE_Solver solver, HYPRE_Int num_functions );
HYPRE_Int
HYPRE_ParCSRHybridSetNumFunctions_dbl( HYPRE_Solver solver, HYPRE_Int num_functions );
HYPRE_Int
HYPRE_ParCSRHybridSetNumFunctions_long_dbl( HYPRE_Solver solver, HYPRE_Int num_functions );
HYPRE_Int
HYPRE_ParCSRHybridSetNumFunctions( HYPRE_Solver solver, HYPRE_Int num_functions );

HYPRE_Int
HYPRE_ParCSRHybridSetNumGridSweeps_flt( HYPRE_Solver solver, HYPRE_Int *num_grid_sweeps );
HYPRE_Int
HYPRE_ParCSRHybridSetNumGridSweeps_dbl( HYPRE_Solver solver, HYPRE_Int *num_grid_sweeps );
HYPRE_Int
HYPRE_ParCSRHybridSetNumGridSweeps_long_dbl( HYPRE_Solver solver, HYPRE_Int *num_grid_sweeps );
HYPRE_Int
HYPRE_ParCSRHybridSetNumGridSweeps( HYPRE_Solver solver, HYPRE_Int *num_grid_sweeps );

HYPRE_Int
HYPRE_ParCSRHybridSetNumPaths_flt( HYPRE_Solver solver, HYPRE_Int num_paths );
HYPRE_Int
HYPRE_ParCSRHybridSetNumPaths_dbl( HYPRE_Solver solver, HYPRE_Int num_paths );
HYPRE_Int
HYPRE_ParCSRHybridSetNumPaths_long_dbl( HYPRE_Solver solver, HYPRE_Int num_paths );
HYPRE_Int
HYPRE_ParCSRHybridSetNumPaths( HYPRE_Solver solver, HYPRE_Int num_paths );

HYPRE_Int
HYPRE_ParCSRHybridSetNumSweeps_flt( HYPRE_Solver solver, HYPRE_Int num_sweeps );
HYPRE_Int
HYPRE_ParCSRHybridSetNumSweeps_dbl( HYPRE_Solver solver, HYPRE_Int num_sweeps );
HYPRE_Int
HYPRE_ParCSRHybridSetNumSweeps_long_dbl( HYPRE_Solver solver, HYPRE_Int num_sweeps );
HYPRE_Int
HYPRE_ParCSRHybridSetNumSweeps( HYPRE_Solver solver, HYPRE_Int num_sweeps );

HYPRE_Int
HYPRE_ParCSRHybridSetOmega_flt( HYPRE_Solver solver, hypre_float *omega );
HYPRE_Int
HYPRE_ParCSRHybridSetOmega_dbl( HYPRE_Solver solver, hypre_double *omega );
HYPRE_Int
HYPRE_ParCSRHybridSetOmega_long_dbl( HYPRE_Solver solver, hypre_long_double *omega );
HYPRE_Int
HYPRE_ParCSRHybridSetOmega( HYPRE_Solver solver, void *omega );

HYPRE_Int
HYPRE_ParCSRHybridSetOuterWt_flt( HYPRE_Solver solver, hypre_float outer_wt );
HYPRE_Int
HYPRE_ParCSRHybridSetOuterWt_dbl( HYPRE_Solver solver, hypre_double outer_wt );
HYPRE_Int
HYPRE_ParCSRHybridSetOuterWt_long_dbl( HYPRE_Solver solver, hypre_long_double outer_wt );
HYPRE_Int
HYPRE_ParCSRHybridSetOuterWt( HYPRE_Solver solver, hypre_long_double outer_wt );

HYPRE_Int
HYPRE_ParCSRHybridSetPCGMaxIter_flt( HYPRE_Solver solver, HYPRE_Int pcg_max_its );
HYPRE_Int
HYPRE_ParCSRHybridSetPCGMaxIter_dbl( HYPRE_Solver solver, HYPRE_Int pcg_max_its );
HYPRE_Int
HYPRE_ParCSRHybridSetPCGMaxIter_long_dbl( HYPRE_Solver solver, HYPRE_Int pcg_max_its );
HYPRE_Int
HYPRE_ParCSRHybridSetPCGMaxIter( HYPRE_Solver solver, HYPRE_Int pcg_max_its );

HYPRE_Int
HYPRE_ParCSRHybridSetPMaxElmts_flt( HYPRE_Solver solver, HYPRE_Int P_max_elmts );
HYPRE_Int
HYPRE_ParCSRHybridSetPMaxElmts_dbl( HYPRE_Solver solver, HYPRE_Int P_max_elmts );
HYPRE_Int
HYPRE_ParCSRHybridSetPMaxElmts_long_dbl( HYPRE_Solver solver, HYPRE_Int P_max_elmts );
HYPRE_Int
HYPRE_ParCSRHybridSetPMaxElmts( HYPRE_Solver solver, HYPRE_Int P_max_elmts );

HYPRE_Int
HYPRE_ParCSRHybridSetPrecond_flt( HYPRE_Solver solver, HYPRE_PtrToParSolverFcn precond, HYPRE_PtrToParSolverFcn precond_setup, HYPRE_Solver precond_solver );
HYPRE_Int
HYPRE_ParCSRHybridSetPrecond_dbl( HYPRE_Solver solver, HYPRE_PtrToParSolverFcn precond, HYPRE_PtrToParSolverFcn precond_setup, HYPRE_Solver precond_solver );
HYPRE_Int
HYPRE_ParCSRHybridSetPrecond_long_dbl( HYPRE_Solver solver, HYPRE_PtrToParSolverFcn precond, HYPRE_PtrToParSolverFcn precond_setup, HYPRE_Solver precond_solver );
HYPRE_Int
HYPRE_ParCSRHybridSetPrecond( HYPRE_Solver solver, HYPRE_PtrToParSolverFcn precond, HYPRE_PtrToParSolverFcn precond_setup, HYPRE_Solver precond_solver );

HYPRE_Int
HYPRE_ParCSRHybridSetPrintLevel_flt( HYPRE_Solver solver, HYPRE_Int print_level );
HYPRE_Int
HYPRE_ParCSRHybridSetPrintLevel_dbl( HYPRE_Solver solver, HYPRE_Int print_level );
HYPRE_Int
HYPRE_ParCSRHybridSetPrintLevel_long_dbl( HYPRE_Solver solver, HYPRE_Int print_level );
HYPRE_Int
HYPRE_ParCSRHybridSetPrintLevel( HYPRE_Solver solver, HYPRE_Int print_level );

HYPRE_Int
HYPRE_ParCSRHybridSetRecomputeResidual_flt( HYPRE_Solver solver, HYPRE_Int recompute_residual );
HYPRE_Int
HYPRE_ParCSRHybridSetRecomputeResidual_dbl( HYPRE_Solver solver, HYPRE_Int recompute_residual );
HYPRE_Int
HYPRE_ParCSRHybridSetRecomputeResidual_long_dbl( HYPRE_Solver solver, HYPRE_Int recompute_residual );
HYPRE_Int
HYPRE_ParCSRHybridSetRecomputeResidual( HYPRE_Solver solver, HYPRE_Int recompute_residual );

HYPRE_Int
HYPRE_ParCSRHybridSetRecomputeResidualP_flt( HYPRE_Solver solver, HYPRE_Int recompute_residual_p );
HYPRE_Int
HYPRE_ParCSRHybridSetRecomputeResidualP_dbl( HYPRE_Solver solver, HYPRE_Int recompute_residual_p );
HYPRE_Int
HYPRE_ParCSRHybridSetRecomputeResidualP_long_dbl( HYPRE_Solver solver, HYPRE_Int recompute_residual_p );
HYPRE_Int
HYPRE_ParCSRHybridSetRecomputeResidualP( HYPRE_Solver solver, HYPRE_Int recompute_residual_p );

HYPRE_Int
HYPRE_ParCSRHybridSetRelChange_flt( HYPRE_Solver solver, HYPRE_Int rel_change );
HYPRE_Int
HYPRE_ParCSRHybridSetRelChange_dbl( HYPRE_Solver solver, HYPRE_Int rel_change );
HYPRE_Int
HYPRE_ParCSRHybridSetRelChange_long_dbl( HYPRE_Solver solver, HYPRE_Int rel_change );
HYPRE_Int
HYPRE_ParCSRHybridSetRelChange( HYPRE_Solver solver, HYPRE_Int rel_change );

HYPRE_Int
HYPRE_ParCSRHybridSetRelaxOrder_flt( HYPRE_Solver solver, HYPRE_Int relax_order );
HYPRE_Int
HYPRE_ParCSRHybridSetRelaxOrder_dbl( HYPRE_Solver solver, HYPRE_Int relax_order );
HYPRE_Int
HYPRE_ParCSRHybridSetRelaxOrder_long_dbl( HYPRE_Solver solver, HYPRE_Int relax_order );
HYPRE_Int
HYPRE_ParCSRHybridSetRelaxOrder( HYPRE_Solver solver, HYPRE_Int relax_order );

HYPRE_Int
HYPRE_ParCSRHybridSetRelaxType_flt( HYPRE_Solver solver, HYPRE_Int relax_type );
HYPRE_Int
HYPRE_ParCSRHybridSetRelaxType_dbl( HYPRE_Solver solver, HYPRE_Int relax_type );
HYPRE_Int
HYPRE_ParCSRHybridSetRelaxType_long_dbl( HYPRE_Solver solver, HYPRE_Int relax_type );
HYPRE_Int
HYPRE_ParCSRHybridSetRelaxType( HYPRE_Solver solver, HYPRE_Int relax_type );

HYPRE_Int
HYPRE_ParCSRHybridSetRelaxWeight_flt( HYPRE_Solver solver, hypre_float *relax_weight );
HYPRE_Int
HYPRE_ParCSRHybridSetRelaxWeight_dbl( HYPRE_Solver solver, hypre_double *relax_weight );
HYPRE_Int
HYPRE_ParCSRHybridSetRelaxWeight_long_dbl( HYPRE_Solver solver, hypre_long_double *relax_weight );
HYPRE_Int
HYPRE_ParCSRHybridSetRelaxWeight( HYPRE_Solver solver, void *relax_weight );

HYPRE_Int
HYPRE_ParCSRHybridSetRelaxWt_flt( HYPRE_Solver solver, hypre_float relax_wt );
HYPRE_Int
HYPRE_ParCSRHybridSetRelaxWt_dbl( HYPRE_Solver solver, hypre_double relax_wt );
HYPRE_Int
HYPRE_ParCSRHybridSetRelaxWt_long_dbl( HYPRE_Solver solver, hypre_long_double relax_wt );
HYPRE_Int
HYPRE_ParCSRHybridSetRelaxWt( HYPRE_Solver solver, hypre_long_double relax_wt );

HYPRE_Int
HYPRE_ParCSRHybridSetSeqThreshold_flt( HYPRE_Solver solver, HYPRE_Int seq_threshold );
HYPRE_Int
HYPRE_ParCSRHybridSetSeqThreshold_dbl( HYPRE_Solver solver, HYPRE_Int seq_threshold );
HYPRE_Int
HYPRE_ParCSRHybridSetSeqThreshold_long_dbl( HYPRE_Solver solver, HYPRE_Int seq_threshold );
HYPRE_Int
HYPRE_ParCSRHybridSetSeqThreshold( HYPRE_Solver solver, HYPRE_Int seq_threshold );

HYPRE_Int
HYPRE_ParCSRHybridSetSetupType_flt( HYPRE_Solver solver, HYPRE_Int setup_type );
HYPRE_Int
HYPRE_ParCSRHybridSetSetupType_dbl( HYPRE_Solver solver, HYPRE_Int setup_type );
HYPRE_Int
HYPRE_ParCSRHybridSetSetupType_long_dbl( HYPRE_Solver solver, HYPRE_Int setup_type );
HYPRE_Int
HYPRE_ParCSRHybridSetSetupType( HYPRE_Solver solver, HYPRE_Int setup_type );

HYPRE_Int
HYPRE_ParCSRHybridSetSolverType_flt( HYPRE_Solver solver, HYPRE_Int solver_type );
HYPRE_Int
HYPRE_ParCSRHybridSetSolverType_dbl( HYPRE_Solver solver, HYPRE_Int solver_type );
HYPRE_Int
HYPRE_ParCSRHybridSetSolverType_long_dbl( HYPRE_Solver solver, HYPRE_Int solver_type );
HYPRE_Int
HYPRE_ParCSRHybridSetSolverType( HYPRE_Solver solver, HYPRE_Int solver_type );

HYPRE_Int
HYPRE_ParCSRHybridSetStopCrit_flt( HYPRE_Solver solver, HYPRE_Int stop_crit );
HYPRE_Int
HYPRE_ParCSRHybridSetStopCrit_dbl( HYPRE_Solver solver, HYPRE_Int stop_crit );
HYPRE_Int
HYPRE_ParCSRHybridSetStopCrit_long_dbl( HYPRE_Solver solver, HYPRE_Int stop_crit );
HYPRE_Int
HYPRE_ParCSRHybridSetStopCrit( HYPRE_Solver solver, HYPRE_Int stop_crit );

HYPRE_Int
HYPRE_ParCSRHybridSetStrongThreshold_flt( HYPRE_Solver solver, hypre_float strong_threshold );
HYPRE_Int
HYPRE_ParCSRHybridSetStrongThreshold_dbl( HYPRE_Solver solver, hypre_double strong_threshold );
HYPRE_Int
HYPRE_ParCSRHybridSetStrongThreshold_long_dbl( HYPRE_Solver solver, hypre_long_double strong_threshold );
HYPRE_Int
HYPRE_ParCSRHybridSetStrongThreshold( HYPRE_Solver solver, hypre_long_double strong_threshold );

HYPRE_Int
HYPRE_ParCSRHybridSetTol_flt( HYPRE_Solver solver, hypre_float tol );
HYPRE_Int
HYPRE_ParCSRHybridSetTol_dbl( HYPRE_Solver solver, hypre_double tol );
HYPRE_Int
HYPRE_ParCSRHybridSetTol_long_dbl( HYPRE_Solver solver, hypre_long_double tol );
HYPRE_Int
HYPRE_ParCSRHybridSetTol( HYPRE_Solver solver, hypre_long_double tol );

HYPRE_Int
HYPRE_ParCSRHybridSetTruncFactor_flt( HYPRE_Solver solver, hypre_float trunc_factor );
HYPRE_Int
HYPRE_ParCSRHybridSetTruncFactor_dbl( HYPRE_Solver solver, hypre_double trunc_factor );
HYPRE_Int
HYPRE_ParCSRHybridSetTruncFactor_long_dbl( HYPRE_Solver solver, hypre_long_double trunc_factor );
HYPRE_Int
HYPRE_ParCSRHybridSetTruncFactor( HYPRE_Solver solver, hypre_long_double trunc_factor );

HYPRE_Int
HYPRE_ParCSRHybridSetTwoNorm_flt( HYPRE_Solver solver, HYPRE_Int two_norm );
HYPRE_Int
HYPRE_ParCSRHybridSetTwoNorm_dbl( HYPRE_Solver solver, HYPRE_Int two_norm );
HYPRE_Int
HYPRE_ParCSRHybridSetTwoNorm_long_dbl( HYPRE_Solver solver, HYPRE_Int two_norm );
HYPRE_Int
HYPRE_ParCSRHybridSetTwoNorm( HYPRE_Solver solver, HYPRE_Int two_norm );

HYPRE_Int
HYPRE_ParCSRHybridSetup_flt( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_ParCSRHybridSetup_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_ParCSRHybridSetup_long_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_ParCSRHybridSetup( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );

HYPRE_Int
HYPRE_ParCSRHybridSolve_flt( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_ParCSRHybridSolve_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_ParCSRHybridSolve_long_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_ParCSRHybridSolve( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );

HYPRE_Int
HYPRE_ParCSRLGMRESCreate_flt( MPI_Comm comm, HYPRE_Solver *solver );
HYPRE_Int
HYPRE_ParCSRLGMRESCreate_dbl( MPI_Comm comm, HYPRE_Solver *solver );
HYPRE_Int
HYPRE_ParCSRLGMRESCreate_long_dbl( MPI_Comm comm, HYPRE_Solver *solver );
HYPRE_Int
HYPRE_ParCSRLGMRESCreate( MPI_Comm comm, HYPRE_Solver *solver );

HYPRE_Int
HYPRE_ParCSRLGMRESDestroy_flt( HYPRE_Solver solver );
HYPRE_Int
HYPRE_ParCSRLGMRESDestroy_dbl( HYPRE_Solver solver );
HYPRE_Int
HYPRE_ParCSRLGMRESDestroy_long_dbl( HYPRE_Solver solver );
HYPRE_Int
HYPRE_ParCSRLGMRESDestroy( HYPRE_Solver solver );

HYPRE_Int
HYPRE_ParCSRLGMRESGetFinalRelativeResidualNorm_flt( HYPRE_Solver solver, hypre_float *norm );
HYPRE_Int
HYPRE_ParCSRLGMRESGetFinalRelativeResidualNorm_dbl( HYPRE_Solver solver, hypre_double *norm );
HYPRE_Int
HYPRE_ParCSRLGMRESGetFinalRelativeResidualNorm_long_dbl( HYPRE_Solver solver, hypre_long_double *norm );
HYPRE_Int
HYPRE_ParCSRLGMRESGetFinalRelativeResidualNorm( HYPRE_Solver solver, void *norm );

HYPRE_Int
HYPRE_ParCSRLGMRESGetNumIterations_flt( HYPRE_Solver solver, HYPRE_Int *num_iterations );
HYPRE_Int
HYPRE_ParCSRLGMRESGetNumIterations_dbl( HYPRE_Solver solver, HYPRE_Int *num_iterations );
HYPRE_Int
HYPRE_ParCSRLGMRESGetNumIterations_long_dbl( HYPRE_Solver solver, HYPRE_Int *num_iterations );
HYPRE_Int
HYPRE_ParCSRLGMRESGetNumIterations( HYPRE_Solver solver, HYPRE_Int *num_iterations );

HYPRE_Int
HYPRE_ParCSRLGMRESGetPrecond_flt( HYPRE_Solver solver, HYPRE_Solver *precond_data );
HYPRE_Int
HYPRE_ParCSRLGMRESGetPrecond_dbl( HYPRE_Solver solver, HYPRE_Solver *precond_data );
HYPRE_Int
HYPRE_ParCSRLGMRESGetPrecond_long_dbl( HYPRE_Solver solver, HYPRE_Solver *precond_data );
HYPRE_Int
HYPRE_ParCSRLGMRESGetPrecond( HYPRE_Solver solver, HYPRE_Solver *precond_data );

HYPRE_Int
HYPRE_ParCSRLGMRESGetResidual_flt( HYPRE_Solver solver, HYPRE_ParVector *residual );
HYPRE_Int
HYPRE_ParCSRLGMRESGetResidual_dbl( HYPRE_Solver solver, HYPRE_ParVector *residual );
HYPRE_Int
HYPRE_ParCSRLGMRESGetResidual_long_dbl( HYPRE_Solver solver, HYPRE_ParVector *residual );
HYPRE_Int
HYPRE_ParCSRLGMRESGetResidual( HYPRE_Solver solver, HYPRE_ParVector *residual );

HYPRE_Int
HYPRE_ParCSRLGMRESSetAbsoluteTol_flt( HYPRE_Solver solver, hypre_float a_tol );
HYPRE_Int
HYPRE_ParCSRLGMRESSetAbsoluteTol_dbl( HYPRE_Solver solver, hypre_double a_tol );
HYPRE_Int
HYPRE_ParCSRLGMRESSetAbsoluteTol_long_dbl( HYPRE_Solver solver, hypre_long_double a_tol );
HYPRE_Int
HYPRE_ParCSRLGMRESSetAbsoluteTol( HYPRE_Solver solver, hypre_long_double a_tol );

HYPRE_Int
HYPRE_ParCSRLGMRESSetAugDim_flt( HYPRE_Solver solver, HYPRE_Int aug_dim );
HYPRE_Int
HYPRE_ParCSRLGMRESSetAugDim_dbl( HYPRE_Solver solver, HYPRE_Int aug_dim );
HYPRE_Int
HYPRE_ParCSRLGMRESSetAugDim_long_dbl( HYPRE_Solver solver, HYPRE_Int aug_dim );
HYPRE_Int
HYPRE_ParCSRLGMRESSetAugDim( HYPRE_Solver solver, HYPRE_Int aug_dim );

HYPRE_Int
HYPRE_ParCSRLGMRESSetKDim_flt( HYPRE_Solver solver, HYPRE_Int k_dim );
HYPRE_Int
HYPRE_ParCSRLGMRESSetKDim_dbl( HYPRE_Solver solver, HYPRE_Int k_dim );
HYPRE_Int
HYPRE_ParCSRLGMRESSetKDim_long_dbl( HYPRE_Solver solver, HYPRE_Int k_dim );
HYPRE_Int
HYPRE_ParCSRLGMRESSetKDim( HYPRE_Solver solver, HYPRE_Int k_dim );

HYPRE_Int
HYPRE_ParCSRLGMRESSetLogging_flt( HYPRE_Solver solver, HYPRE_Int logging );
HYPRE_Int
HYPRE_ParCSRLGMRESSetLogging_dbl( HYPRE_Solver solver, HYPRE_Int logging );
HYPRE_Int
HYPRE_ParCSRLGMRESSetLogging_long_dbl( HYPRE_Solver solver, HYPRE_Int logging );
HYPRE_Int
HYPRE_ParCSRLGMRESSetLogging( HYPRE_Solver solver, HYPRE_Int logging );

HYPRE_Int
HYPRE_ParCSRLGMRESSetMaxIter_flt( HYPRE_Solver solver, HYPRE_Int max_iter );
HYPRE_Int
HYPRE_ParCSRLGMRESSetMaxIter_dbl( HYPRE_Solver solver, HYPRE_Int max_iter );
HYPRE_Int
HYPRE_ParCSRLGMRESSetMaxIter_long_dbl( HYPRE_Solver solver, HYPRE_Int max_iter );
HYPRE_Int
HYPRE_ParCSRLGMRESSetMaxIter( HYPRE_Solver solver, HYPRE_Int max_iter );

HYPRE_Int
HYPRE_ParCSRLGMRESSetMinIter_flt( HYPRE_Solver solver, HYPRE_Int min_iter );
HYPRE_Int
HYPRE_ParCSRLGMRESSetMinIter_dbl( HYPRE_Solver solver, HYPRE_Int min_iter );
HYPRE_Int
HYPRE_ParCSRLGMRESSetMinIter_long_dbl( HYPRE_Solver solver, HYPRE_Int min_iter );
HYPRE_Int
HYPRE_ParCSRLGMRESSetMinIter( HYPRE_Solver solver, HYPRE_Int min_iter );

HYPRE_Int
HYPRE_ParCSRLGMRESSetPrecond_flt( HYPRE_Solver solver, HYPRE_PtrToParSolverFcn precond, HYPRE_PtrToParSolverFcn precond_setup, HYPRE_Solver precond_solver );
HYPRE_Int
HYPRE_ParCSRLGMRESSetPrecond_dbl( HYPRE_Solver solver, HYPRE_PtrToParSolverFcn precond, HYPRE_PtrToParSolverFcn precond_setup, HYPRE_Solver precond_solver );
HYPRE_Int
HYPRE_ParCSRLGMRESSetPrecond_long_dbl( HYPRE_Solver solver, HYPRE_PtrToParSolverFcn precond, HYPRE_PtrToParSolverFcn precond_setup, HYPRE_Solver precond_solver );
HYPRE_Int
HYPRE_ParCSRLGMRESSetPrecond( HYPRE_Solver solver, HYPRE_PtrToParSolverFcn precond, HYPRE_PtrToParSolverFcn precond_setup, HYPRE_Solver precond_solver );

HYPRE_Int
HYPRE_ParCSRLGMRESSetPrintLevel_flt( HYPRE_Solver solver, HYPRE_Int print_level );
HYPRE_Int
HYPRE_ParCSRLGMRESSetPrintLevel_dbl( HYPRE_Solver solver, HYPRE_Int print_level );
HYPRE_Int
HYPRE_ParCSRLGMRESSetPrintLevel_long_dbl( HYPRE_Solver solver, HYPRE_Int print_level );
HYPRE_Int
HYPRE_ParCSRLGMRESSetPrintLevel( HYPRE_Solver solver, HYPRE_Int print_level );

HYPRE_Int
HYPRE_ParCSRLGMRESSetTol_flt( HYPRE_Solver solver, hypre_float tol );
HYPRE_Int
HYPRE_ParCSRLGMRESSetTol_dbl( HYPRE_Solver solver, hypre_double tol );
HYPRE_Int
HYPRE_ParCSRLGMRESSetTol_long_dbl( HYPRE_Solver solver, hypre_long_double tol );
HYPRE_Int
HYPRE_ParCSRLGMRESSetTol( HYPRE_Solver solver, hypre_long_double tol );

HYPRE_Int
HYPRE_ParCSRLGMRESSetup_flt( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_ParCSRLGMRESSetup_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_ParCSRLGMRESSetup_long_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_ParCSRLGMRESSetup( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );

HYPRE_Int
HYPRE_ParCSRLGMRESSolve_flt( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_ParCSRLGMRESSolve_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_ParCSRLGMRESSolve_long_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_ParCSRLGMRESSolve( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );

HYPRE_Int
HYPRE_ParCSRMultiVectorPrint_flt( void *x_, const char *fileName );
HYPRE_Int
HYPRE_ParCSRMultiVectorPrint_dbl( void *x_, const char *fileName );
HYPRE_Int
HYPRE_ParCSRMultiVectorPrint_long_dbl( void *x_, const char *fileName );
HYPRE_Int
HYPRE_ParCSRMultiVectorPrint( void *x_, const char *fileName );

void *
HYPRE_ParCSRMultiVectorRead_flt( MPI_Comm comm, void *ii_, const char *fileName );
void *
HYPRE_ParCSRMultiVectorRead_dbl( MPI_Comm comm, void *ii_, const char *fileName );
void *
HYPRE_ParCSRMultiVectorRead_long_dbl( MPI_Comm comm, void *ii_, const char *fileName );
void *
HYPRE_ParCSRMultiVectorRead( MPI_Comm comm, void *ii_, const char *fileName );

HYPRE_Int
HYPRE_ParCSROnProcTriSetup_flt( HYPRE_Solver solver, HYPRE_ParCSRMatrix HA, HYPRE_ParVector Hy, HYPRE_ParVector Hx );
HYPRE_Int
HYPRE_ParCSROnProcTriSetup_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix HA, HYPRE_ParVector Hy, HYPRE_ParVector Hx );
HYPRE_Int
HYPRE_ParCSROnProcTriSetup_long_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix HA, HYPRE_ParVector Hy, HYPRE_ParVector Hx );
HYPRE_Int
HYPRE_ParCSROnProcTriSetup( HYPRE_Solver solver, HYPRE_ParCSRMatrix HA, HYPRE_ParVector Hy, HYPRE_ParVector Hx );

HYPRE_Int
HYPRE_ParCSROnProcTriSolve_flt( HYPRE_Solver solver, HYPRE_ParCSRMatrix HA, HYPRE_ParVector Hy, HYPRE_ParVector Hx );
HYPRE_Int
HYPRE_ParCSROnProcTriSolve_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix HA, HYPRE_ParVector Hy, HYPRE_ParVector Hx );
HYPRE_Int
HYPRE_ParCSROnProcTriSolve_long_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix HA, HYPRE_ParVector Hy, HYPRE_ParVector Hx );
HYPRE_Int
HYPRE_ParCSROnProcTriSolve( HYPRE_Solver solver, HYPRE_ParCSRMatrix HA, HYPRE_ParVector Hy, HYPRE_ParVector Hx );

HYPRE_Int
HYPRE_ParCSRPCGCreate_flt( MPI_Comm comm, HYPRE_Solver *solver );
HYPRE_Int
HYPRE_ParCSRPCGCreate_dbl( MPI_Comm comm, HYPRE_Solver *solver );
HYPRE_Int
HYPRE_ParCSRPCGCreate_long_dbl( MPI_Comm comm, HYPRE_Solver *solver );
HYPRE_Int
HYPRE_ParCSRPCGCreate( MPI_Comm comm, HYPRE_Solver *solver );

HYPRE_Int
HYPRE_ParCSRPCGDestroy_flt( HYPRE_Solver solver );
HYPRE_Int
HYPRE_ParCSRPCGDestroy_dbl( HYPRE_Solver solver );
HYPRE_Int
HYPRE_ParCSRPCGDestroy_long_dbl( HYPRE_Solver solver );
HYPRE_Int
HYPRE_ParCSRPCGDestroy( HYPRE_Solver solver );

HYPRE_Int
HYPRE_ParCSRPCGGetFinalRelativeResidualNorm_flt( HYPRE_Solver solver, hypre_float *norm );
HYPRE_Int
HYPRE_ParCSRPCGGetFinalRelativeResidualNorm_dbl( HYPRE_Solver solver, hypre_double *norm );
HYPRE_Int
HYPRE_ParCSRPCGGetFinalRelativeResidualNorm_long_dbl( HYPRE_Solver solver, hypre_long_double *norm );
HYPRE_Int
HYPRE_ParCSRPCGGetFinalRelativeResidualNorm( HYPRE_Solver solver, void *norm );

HYPRE_Int
HYPRE_ParCSRPCGGetNumIterations_flt( HYPRE_Solver solver, HYPRE_Int *num_iterations );
HYPRE_Int
HYPRE_ParCSRPCGGetNumIterations_dbl( HYPRE_Solver solver, HYPRE_Int *num_iterations );
HYPRE_Int
HYPRE_ParCSRPCGGetNumIterations_long_dbl( HYPRE_Solver solver, HYPRE_Int *num_iterations );
HYPRE_Int
HYPRE_ParCSRPCGGetNumIterations( HYPRE_Solver solver, HYPRE_Int *num_iterations );

HYPRE_Int
HYPRE_ParCSRPCGGetPrecond_flt( HYPRE_Solver solver, HYPRE_Solver *precond_data );
HYPRE_Int
HYPRE_ParCSRPCGGetPrecond_dbl( HYPRE_Solver solver, HYPRE_Solver *precond_data );
HYPRE_Int
HYPRE_ParCSRPCGGetPrecond_long_dbl( HYPRE_Solver solver, HYPRE_Solver *precond_data );
HYPRE_Int
HYPRE_ParCSRPCGGetPrecond( HYPRE_Solver solver, HYPRE_Solver *precond_data );

HYPRE_Int
HYPRE_ParCSRPCGGetResidual_flt( HYPRE_Solver solver, HYPRE_ParVector *residual );
HYPRE_Int
HYPRE_ParCSRPCGGetResidual_dbl( HYPRE_Solver solver, HYPRE_ParVector *residual );
HYPRE_Int
HYPRE_ParCSRPCGGetResidual_long_dbl( HYPRE_Solver solver, HYPRE_ParVector *residual );
HYPRE_Int
HYPRE_ParCSRPCGGetResidual( HYPRE_Solver solver, HYPRE_ParVector *residual );

HYPRE_Int
HYPRE_ParCSRPCGSetAbsoluteTol_flt( HYPRE_Solver solver, hypre_float tol );
HYPRE_Int
HYPRE_ParCSRPCGSetAbsoluteTol_dbl( HYPRE_Solver solver, hypre_double tol );
HYPRE_Int
HYPRE_ParCSRPCGSetAbsoluteTol_long_dbl( HYPRE_Solver solver, hypre_long_double tol );
HYPRE_Int
HYPRE_ParCSRPCGSetAbsoluteTol( HYPRE_Solver solver, hypre_long_double tol );

HYPRE_Int
HYPRE_ParCSRPCGSetLogging_flt( HYPRE_Solver solver, HYPRE_Int logging );
HYPRE_Int
HYPRE_ParCSRPCGSetLogging_dbl( HYPRE_Solver solver, HYPRE_Int logging );
HYPRE_Int
HYPRE_ParCSRPCGSetLogging_long_dbl( HYPRE_Solver solver, HYPRE_Int logging );
HYPRE_Int
HYPRE_ParCSRPCGSetLogging( HYPRE_Solver solver, HYPRE_Int logging );

HYPRE_Int
HYPRE_ParCSRPCGSetMaxIter_flt( HYPRE_Solver solver, HYPRE_Int max_iter );
HYPRE_Int
HYPRE_ParCSRPCGSetMaxIter_dbl( HYPRE_Solver solver, HYPRE_Int max_iter );
HYPRE_Int
HYPRE_ParCSRPCGSetMaxIter_long_dbl( HYPRE_Solver solver, HYPRE_Int max_iter );
HYPRE_Int
HYPRE_ParCSRPCGSetMaxIter( HYPRE_Solver solver, HYPRE_Int max_iter );

HYPRE_Int
HYPRE_ParCSRPCGSetPrecond_flt( HYPRE_Solver solver, HYPRE_PtrToParSolverFcn precond, HYPRE_PtrToParSolverFcn precond_setup, HYPRE_Solver precond_solver );
HYPRE_Int
HYPRE_ParCSRPCGSetPrecond_dbl( HYPRE_Solver solver, HYPRE_PtrToParSolverFcn precond, HYPRE_PtrToParSolverFcn precond_setup, HYPRE_Solver precond_solver );
HYPRE_Int
HYPRE_ParCSRPCGSetPrecond_long_dbl( HYPRE_Solver solver, HYPRE_PtrToParSolverFcn precond, HYPRE_PtrToParSolverFcn precond_setup, HYPRE_Solver precond_solver );
HYPRE_Int
HYPRE_ParCSRPCGSetPrecond( HYPRE_Solver solver, HYPRE_PtrToParSolverFcn precond, HYPRE_PtrToParSolverFcn precond_setup, HYPRE_Solver precond_solver );

HYPRE_Int
HYPRE_ParCSRPCGSetPreconditioner_flt( HYPRE_Solver solver, HYPRE_Solver precond );
HYPRE_Int
HYPRE_ParCSRPCGSetPreconditioner_dbl( HYPRE_Solver solver, HYPRE_Solver precond );
HYPRE_Int
HYPRE_ParCSRPCGSetPreconditioner_long_dbl( HYPRE_Solver solver, HYPRE_Solver precond );
HYPRE_Int
HYPRE_ParCSRPCGSetPreconditioner( HYPRE_Solver solver, HYPRE_Solver precond );

HYPRE_Int
HYPRE_ParCSRPCGSetPrintLevel_flt( HYPRE_Solver solver, HYPRE_Int print_level );
HYPRE_Int
HYPRE_ParCSRPCGSetPrintLevel_dbl( HYPRE_Solver solver, HYPRE_Int print_level );
HYPRE_Int
HYPRE_ParCSRPCGSetPrintLevel_long_dbl( HYPRE_Solver solver, HYPRE_Int print_level );
HYPRE_Int
HYPRE_ParCSRPCGSetPrintLevel( HYPRE_Solver solver, HYPRE_Int print_level );

HYPRE_Int
HYPRE_ParCSRPCGSetRelChange_flt( HYPRE_Solver solver, HYPRE_Int rel_change );
HYPRE_Int
HYPRE_ParCSRPCGSetRelChange_dbl( HYPRE_Solver solver, HYPRE_Int rel_change );
HYPRE_Int
HYPRE_ParCSRPCGSetRelChange_long_dbl( HYPRE_Solver solver, HYPRE_Int rel_change );
HYPRE_Int
HYPRE_ParCSRPCGSetRelChange( HYPRE_Solver solver, HYPRE_Int rel_change );

HYPRE_Int
HYPRE_ParCSRPCGSetStopCrit_flt( HYPRE_Solver solver, HYPRE_Int stop_crit );
HYPRE_Int
HYPRE_ParCSRPCGSetStopCrit_dbl( HYPRE_Solver solver, HYPRE_Int stop_crit );
HYPRE_Int
HYPRE_ParCSRPCGSetStopCrit_long_dbl( HYPRE_Solver solver, HYPRE_Int stop_crit );
HYPRE_Int
HYPRE_ParCSRPCGSetStopCrit( HYPRE_Solver solver, HYPRE_Int stop_crit );

HYPRE_Int
HYPRE_ParCSRPCGSetTol_flt( HYPRE_Solver solver, hypre_float tol );
HYPRE_Int
HYPRE_ParCSRPCGSetTol_dbl( HYPRE_Solver solver, hypre_double tol );
HYPRE_Int
HYPRE_ParCSRPCGSetTol_long_dbl( HYPRE_Solver solver, hypre_long_double tol );
HYPRE_Int
HYPRE_ParCSRPCGSetTol( HYPRE_Solver solver, hypre_long_double tol );

HYPRE_Int
HYPRE_ParCSRPCGSetTwoNorm_flt( HYPRE_Solver solver, HYPRE_Int two_norm );
HYPRE_Int
HYPRE_ParCSRPCGSetTwoNorm_dbl( HYPRE_Solver solver, HYPRE_Int two_norm );
HYPRE_Int
HYPRE_ParCSRPCGSetTwoNorm_long_dbl( HYPRE_Solver solver, HYPRE_Int two_norm );
HYPRE_Int
HYPRE_ParCSRPCGSetTwoNorm( HYPRE_Solver solver, HYPRE_Int two_norm );

HYPRE_Int
HYPRE_ParCSRPCGSetup_flt( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_ParCSRPCGSetup_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_ParCSRPCGSetup_long_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_ParCSRPCGSetup( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );

HYPRE_Int
HYPRE_ParCSRPCGSolve_flt( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_ParCSRPCGSolve_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_ParCSRPCGSolve_long_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_ParCSRPCGSolve( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );

HYPRE_Int
HYPRE_ParCSRParaSailsCreate_flt( MPI_Comm comm, HYPRE_Solver *solver );
HYPRE_Int
HYPRE_ParCSRParaSailsCreate_dbl( MPI_Comm comm, HYPRE_Solver *solver );
HYPRE_Int
HYPRE_ParCSRParaSailsCreate_long_dbl( MPI_Comm comm, HYPRE_Solver *solver );
HYPRE_Int
HYPRE_ParCSRParaSailsCreate( MPI_Comm comm, HYPRE_Solver *solver );

HYPRE_Int
HYPRE_ParCSRParaSailsDestroy_flt( HYPRE_Solver solver );
HYPRE_Int
HYPRE_ParCSRParaSailsDestroy_dbl( HYPRE_Solver solver );
HYPRE_Int
HYPRE_ParCSRParaSailsDestroy_long_dbl( HYPRE_Solver solver );
HYPRE_Int
HYPRE_ParCSRParaSailsDestroy( HYPRE_Solver solver );

HYPRE_Int
HYPRE_ParCSRParaSailsSetFilter_flt( HYPRE_Solver solver, hypre_float filter );
HYPRE_Int
HYPRE_ParCSRParaSailsSetFilter_dbl( HYPRE_Solver solver, hypre_double filter );
HYPRE_Int
HYPRE_ParCSRParaSailsSetFilter_long_dbl( HYPRE_Solver solver, hypre_long_double filter );
HYPRE_Int
HYPRE_ParCSRParaSailsSetFilter( HYPRE_Solver solver, hypre_long_double filter );

HYPRE_Int
HYPRE_ParCSRParaSailsSetLoadbal_flt( HYPRE_Solver solver, hypre_float loadbal );
HYPRE_Int
HYPRE_ParCSRParaSailsSetLoadbal_dbl( HYPRE_Solver solver, hypre_double loadbal );
HYPRE_Int
HYPRE_ParCSRParaSailsSetLoadbal_long_dbl( HYPRE_Solver solver, hypre_long_double loadbal );
HYPRE_Int
HYPRE_ParCSRParaSailsSetLoadbal( HYPRE_Solver solver, hypre_long_double loadbal );

HYPRE_Int
HYPRE_ParCSRParaSailsSetLogging_flt( HYPRE_Solver solver, HYPRE_Int logging );
HYPRE_Int
HYPRE_ParCSRParaSailsSetLogging_dbl( HYPRE_Solver solver, HYPRE_Int logging );
HYPRE_Int
HYPRE_ParCSRParaSailsSetLogging_long_dbl( HYPRE_Solver solver, HYPRE_Int logging );
HYPRE_Int
HYPRE_ParCSRParaSailsSetLogging( HYPRE_Solver solver, HYPRE_Int logging );

HYPRE_Int
HYPRE_ParCSRParaSailsSetParams_flt( HYPRE_Solver solver, hypre_float thresh, HYPRE_Int nlevels );
HYPRE_Int
HYPRE_ParCSRParaSailsSetParams_dbl( HYPRE_Solver solver, hypre_double thresh, HYPRE_Int nlevels );
HYPRE_Int
HYPRE_ParCSRParaSailsSetParams_long_dbl( HYPRE_Solver solver, hypre_long_double thresh, HYPRE_Int nlevels );
HYPRE_Int
HYPRE_ParCSRParaSailsSetParams( HYPRE_Solver solver, hypre_long_double thresh, HYPRE_Int nlevels );

HYPRE_Int
HYPRE_ParCSRParaSailsSetReuse_flt( HYPRE_Solver solver, HYPRE_Int reuse );
HYPRE_Int
HYPRE_ParCSRParaSailsSetReuse_dbl( HYPRE_Solver solver, HYPRE_Int reuse );
HYPRE_Int
HYPRE_ParCSRParaSailsSetReuse_long_dbl( HYPRE_Solver solver, HYPRE_Int reuse );
HYPRE_Int
HYPRE_ParCSRParaSailsSetReuse( HYPRE_Solver solver, HYPRE_Int reuse );

HYPRE_Int
HYPRE_ParCSRParaSailsSetSym_flt( HYPRE_Solver solver, HYPRE_Int sym );
HYPRE_Int
HYPRE_ParCSRParaSailsSetSym_dbl( HYPRE_Solver solver, HYPRE_Int sym );
HYPRE_Int
HYPRE_ParCSRParaSailsSetSym_long_dbl( HYPRE_Solver solver, HYPRE_Int sym );
HYPRE_Int
HYPRE_ParCSRParaSailsSetSym( HYPRE_Solver solver, HYPRE_Int sym );

HYPRE_Int
HYPRE_ParCSRParaSailsSetup_flt( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_ParCSRParaSailsSetup_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_ParCSRParaSailsSetup_long_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_ParCSRParaSailsSetup( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );

HYPRE_Int
HYPRE_ParCSRParaSailsSolve_flt( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_ParCSRParaSailsSolve_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_ParCSRParaSailsSolve_long_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_ParCSRParaSailsSolve( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );

HYPRE_Int
HYPRE_ParCSRPilutCreate_flt( MPI_Comm comm, HYPRE_Solver *solver );
HYPRE_Int
HYPRE_ParCSRPilutCreate_dbl( MPI_Comm comm, HYPRE_Solver *solver );
HYPRE_Int
HYPRE_ParCSRPilutCreate_long_dbl( MPI_Comm comm, HYPRE_Solver *solver );
HYPRE_Int
HYPRE_ParCSRPilutCreate( MPI_Comm comm, HYPRE_Solver *solver );

HYPRE_Int
HYPRE_ParCSRPilutDestroy_flt( HYPRE_Solver solver );
HYPRE_Int
HYPRE_ParCSRPilutDestroy_dbl( HYPRE_Solver solver );
HYPRE_Int
HYPRE_ParCSRPilutDestroy_long_dbl( HYPRE_Solver solver );
HYPRE_Int
HYPRE_ParCSRPilutDestroy( HYPRE_Solver solver );

HYPRE_Int
HYPRE_ParCSRPilutSetDropTolerance_flt( HYPRE_Solver solver, hypre_float tol );
HYPRE_Int
HYPRE_ParCSRPilutSetDropTolerance_dbl( HYPRE_Solver solver, hypre_double tol );
HYPRE_Int
HYPRE_ParCSRPilutSetDropTolerance_long_dbl( HYPRE_Solver solver, hypre_long_double tol );
HYPRE_Int
HYPRE_ParCSRPilutSetDropTolerance( HYPRE_Solver solver, hypre_long_double tol );

HYPRE_Int
HYPRE_ParCSRPilutSetFactorRowSize_flt( HYPRE_Solver solver, HYPRE_Int size );
HYPRE_Int
HYPRE_ParCSRPilutSetFactorRowSize_dbl( HYPRE_Solver solver, HYPRE_Int size );
HYPRE_Int
HYPRE_ParCSRPilutSetFactorRowSize_long_dbl( HYPRE_Solver solver, HYPRE_Int size );
HYPRE_Int
HYPRE_ParCSRPilutSetFactorRowSize( HYPRE_Solver solver, HYPRE_Int size );

HYPRE_Int
HYPRE_ParCSRPilutSetLogging_flt( HYPRE_Solver solver, HYPRE_Int logging );
HYPRE_Int
HYPRE_ParCSRPilutSetLogging_dbl( HYPRE_Solver solver, HYPRE_Int logging );
HYPRE_Int
HYPRE_ParCSRPilutSetLogging_long_dbl( HYPRE_Solver solver, HYPRE_Int logging );
HYPRE_Int
HYPRE_ParCSRPilutSetLogging( HYPRE_Solver solver, HYPRE_Int logging );

HYPRE_Int
HYPRE_ParCSRPilutSetMaxIter_flt( HYPRE_Solver solver, HYPRE_Int max_iter );
HYPRE_Int
HYPRE_ParCSRPilutSetMaxIter_dbl( HYPRE_Solver solver, HYPRE_Int max_iter );
HYPRE_Int
HYPRE_ParCSRPilutSetMaxIter_long_dbl( HYPRE_Solver solver, HYPRE_Int max_iter );
HYPRE_Int
HYPRE_ParCSRPilutSetMaxIter( HYPRE_Solver solver, HYPRE_Int max_iter );

HYPRE_Int
HYPRE_ParCSRPilutSetup_flt( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_ParCSRPilutSetup_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_ParCSRPilutSetup_long_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_ParCSRPilutSetup( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );

HYPRE_Int
HYPRE_ParCSRPilutSolve_flt( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_ParCSRPilutSolve_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_ParCSRPilutSolve_long_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_ParCSRPilutSolve( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );

HYPRE_Int
HYPRE_ParCSRSetupInterpreter_flt( mv_InterfaceInterpreter *i );
HYPRE_Int
HYPRE_ParCSRSetupInterpreter_dbl( mv_InterfaceInterpreter *i );
HYPRE_Int
HYPRE_ParCSRSetupInterpreter_long_dbl( mv_InterfaceInterpreter *i );
HYPRE_Int
HYPRE_ParCSRSetupInterpreter( mv_InterfaceInterpreter *i );

HYPRE_Int
HYPRE_ParCSRSetupMatvec_flt( HYPRE_MatvecFunctions *mv );
HYPRE_Int
HYPRE_ParCSRSetupMatvec_dbl( HYPRE_MatvecFunctions *mv );
HYPRE_Int
HYPRE_ParCSRSetupMatvec_long_dbl( HYPRE_MatvecFunctions *mv );
HYPRE_Int
HYPRE_ParCSRSetupMatvec( HYPRE_MatvecFunctions *mv );

HYPRE_Int
HYPRE_ParaSailsBuildIJMatrix_flt( HYPRE_Solver solver, HYPRE_IJMatrix *pij_A );
HYPRE_Int
HYPRE_ParaSailsBuildIJMatrix_dbl( HYPRE_Solver solver, HYPRE_IJMatrix *pij_A );
HYPRE_Int
HYPRE_ParaSailsBuildIJMatrix_long_dbl( HYPRE_Solver solver, HYPRE_IJMatrix *pij_A );
HYPRE_Int
HYPRE_ParaSailsBuildIJMatrix( HYPRE_Solver solver, HYPRE_IJMatrix *pij_A );

HYPRE_Int
HYPRE_ParaSailsCreate_flt( MPI_Comm comm, HYPRE_Solver *solver );
HYPRE_Int
HYPRE_ParaSailsCreate_dbl( MPI_Comm comm, HYPRE_Solver *solver );
HYPRE_Int
HYPRE_ParaSailsCreate_long_dbl( MPI_Comm comm, HYPRE_Solver *solver );
HYPRE_Int
HYPRE_ParaSailsCreate( MPI_Comm comm, HYPRE_Solver *solver );

HYPRE_Int
HYPRE_ParaSailsDestroy_flt( HYPRE_Solver solver );
HYPRE_Int
HYPRE_ParaSailsDestroy_dbl( HYPRE_Solver solver );
HYPRE_Int
HYPRE_ParaSailsDestroy_long_dbl( HYPRE_Solver solver );
HYPRE_Int
HYPRE_ParaSailsDestroy( HYPRE_Solver solver );

HYPRE_Int
HYPRE_ParaSailsGetFilter_flt( HYPRE_Solver solver, hypre_float *filter );
HYPRE_Int
HYPRE_ParaSailsGetFilter_dbl( HYPRE_Solver solver, hypre_double *filter );
HYPRE_Int
HYPRE_ParaSailsGetFilter_long_dbl( HYPRE_Solver solver, hypre_long_double *filter );
HYPRE_Int
HYPRE_ParaSailsGetFilter( HYPRE_Solver solver, void *filter );

HYPRE_Int
HYPRE_ParaSailsGetLoadbal_flt( HYPRE_Solver solver, hypre_float *loadbal );
HYPRE_Int
HYPRE_ParaSailsGetLoadbal_dbl( HYPRE_Solver solver, hypre_double *loadbal );
HYPRE_Int
HYPRE_ParaSailsGetLoadbal_long_dbl( HYPRE_Solver solver, hypre_long_double *loadbal );
HYPRE_Int
HYPRE_ParaSailsGetLoadbal( HYPRE_Solver solver, void *loadbal );

HYPRE_Int
HYPRE_ParaSailsGetLogging_flt( HYPRE_Solver solver, HYPRE_Int *logging );
HYPRE_Int
HYPRE_ParaSailsGetLogging_dbl( HYPRE_Solver solver, HYPRE_Int *logging );
HYPRE_Int
HYPRE_ParaSailsGetLogging_long_dbl( HYPRE_Solver solver, HYPRE_Int *logging );
HYPRE_Int
HYPRE_ParaSailsGetLogging( HYPRE_Solver solver, HYPRE_Int *logging );

HYPRE_Int
HYPRE_ParaSailsGetNlevels_flt( HYPRE_Solver solver, HYPRE_Int *nlevels );
HYPRE_Int
HYPRE_ParaSailsGetNlevels_dbl( HYPRE_Solver solver, HYPRE_Int *nlevels );
HYPRE_Int
HYPRE_ParaSailsGetNlevels_long_dbl( HYPRE_Solver solver, HYPRE_Int *nlevels );
HYPRE_Int
HYPRE_ParaSailsGetNlevels( HYPRE_Solver solver, HYPRE_Int *nlevels );

HYPRE_Int
HYPRE_ParaSailsGetReuse_flt( HYPRE_Solver solver, HYPRE_Int *reuse );
HYPRE_Int
HYPRE_ParaSailsGetReuse_dbl( HYPRE_Solver solver, HYPRE_Int *reuse );
HYPRE_Int
HYPRE_ParaSailsGetReuse_long_dbl( HYPRE_Solver solver, HYPRE_Int *reuse );
HYPRE_Int
HYPRE_ParaSailsGetReuse( HYPRE_Solver solver, HYPRE_Int *reuse );

HYPRE_Int
HYPRE_ParaSailsGetSym_flt( HYPRE_Solver solver, HYPRE_Int *sym );
HYPRE_Int
HYPRE_ParaSailsGetSym_dbl( HYPRE_Solver solver, HYPRE_Int *sym );
HYPRE_Int
HYPRE_ParaSailsGetSym_long_dbl( HYPRE_Solver solver, HYPRE_Int *sym );
HYPRE_Int
HYPRE_ParaSailsGetSym( HYPRE_Solver solver, HYPRE_Int *sym );

HYPRE_Int
HYPRE_ParaSailsGetThresh_flt( HYPRE_Solver solver, hypre_float *thresh );
HYPRE_Int
HYPRE_ParaSailsGetThresh_dbl( HYPRE_Solver solver, hypre_double *thresh );
HYPRE_Int
HYPRE_ParaSailsGetThresh_long_dbl( HYPRE_Solver solver, hypre_long_double *thresh );
HYPRE_Int
HYPRE_ParaSailsGetThresh( HYPRE_Solver solver, void *thresh );

HYPRE_Int
HYPRE_ParaSailsSetFilter_flt( HYPRE_Solver solver, hypre_float filter );
HYPRE_Int
HYPRE_ParaSailsSetFilter_dbl( HYPRE_Solver solver, hypre_double filter );
HYPRE_Int
HYPRE_ParaSailsSetFilter_long_dbl( HYPRE_Solver solver, hypre_long_double filter );
HYPRE_Int
HYPRE_ParaSailsSetFilter( HYPRE_Solver solver, hypre_long_double filter );

HYPRE_Int
HYPRE_ParaSailsSetLoadbal_flt( HYPRE_Solver solver, hypre_float loadbal );
HYPRE_Int
HYPRE_ParaSailsSetLoadbal_dbl( HYPRE_Solver solver, hypre_double loadbal );
HYPRE_Int
HYPRE_ParaSailsSetLoadbal_long_dbl( HYPRE_Solver solver, hypre_long_double loadbal );
HYPRE_Int
HYPRE_ParaSailsSetLoadbal( HYPRE_Solver solver, hypre_long_double loadbal );

HYPRE_Int
HYPRE_ParaSailsSetLogging_flt( HYPRE_Solver solver, HYPRE_Int logging );
HYPRE_Int
HYPRE_ParaSailsSetLogging_dbl( HYPRE_Solver solver, HYPRE_Int logging );
HYPRE_Int
HYPRE_ParaSailsSetLogging_long_dbl( HYPRE_Solver solver, HYPRE_Int logging );
HYPRE_Int
HYPRE_ParaSailsSetLogging( HYPRE_Solver solver, HYPRE_Int logging );

HYPRE_Int
HYPRE_ParaSailsSetNlevels_flt( HYPRE_Solver solver, HYPRE_Int nlevels );
HYPRE_Int
HYPRE_ParaSailsSetNlevels_dbl( HYPRE_Solver solver, HYPRE_Int nlevels );
HYPRE_Int
HYPRE_ParaSailsSetNlevels_long_dbl( HYPRE_Solver solver, HYPRE_Int nlevels );
HYPRE_Int
HYPRE_ParaSailsSetNlevels( HYPRE_Solver solver, HYPRE_Int nlevels );

HYPRE_Int
HYPRE_ParaSailsSetParams_flt( HYPRE_Solver solver, hypre_float thresh, HYPRE_Int nlevels );
HYPRE_Int
HYPRE_ParaSailsSetParams_dbl( HYPRE_Solver solver, hypre_double thresh, HYPRE_Int nlevels );
HYPRE_Int
HYPRE_ParaSailsSetParams_long_dbl( HYPRE_Solver solver, hypre_long_double thresh, HYPRE_Int nlevels );
HYPRE_Int
HYPRE_ParaSailsSetParams( HYPRE_Solver solver, hypre_long_double thresh, HYPRE_Int nlevels );

HYPRE_Int
HYPRE_ParaSailsSetReuse_flt( HYPRE_Solver solver, HYPRE_Int reuse );
HYPRE_Int
HYPRE_ParaSailsSetReuse_dbl( HYPRE_Solver solver, HYPRE_Int reuse );
HYPRE_Int
HYPRE_ParaSailsSetReuse_long_dbl( HYPRE_Solver solver, HYPRE_Int reuse );
HYPRE_Int
HYPRE_ParaSailsSetReuse( HYPRE_Solver solver, HYPRE_Int reuse );

HYPRE_Int
HYPRE_ParaSailsSetSym_flt( HYPRE_Solver solver, HYPRE_Int sym );
HYPRE_Int
HYPRE_ParaSailsSetSym_dbl( HYPRE_Solver solver, HYPRE_Int sym );
HYPRE_Int
HYPRE_ParaSailsSetSym_long_dbl( HYPRE_Solver solver, HYPRE_Int sym );
HYPRE_Int
HYPRE_ParaSailsSetSym( HYPRE_Solver solver, HYPRE_Int sym );

HYPRE_Int
HYPRE_ParaSailsSetThresh_flt( HYPRE_Solver solver, hypre_float thresh );
HYPRE_Int
HYPRE_ParaSailsSetThresh_dbl( HYPRE_Solver solver, hypre_double thresh );
HYPRE_Int
HYPRE_ParaSailsSetThresh_long_dbl( HYPRE_Solver solver, hypre_long_double thresh );
HYPRE_Int
HYPRE_ParaSailsSetThresh( HYPRE_Solver solver, hypre_long_double thresh );

HYPRE_Int
HYPRE_ParaSailsSetup_flt( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_ParaSailsSetup_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_ParaSailsSetup_long_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_ParaSailsSetup( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );

HYPRE_Int
HYPRE_ParaSailsSolve_flt( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_ParaSailsSolve_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_ParaSailsSolve_long_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_ParaSailsSolve( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );

HYPRE_Int
HYPRE_SchwarzCreate_flt( HYPRE_Solver *solver );
HYPRE_Int
HYPRE_SchwarzCreate_dbl( HYPRE_Solver *solver );
HYPRE_Int
HYPRE_SchwarzCreate_long_dbl( HYPRE_Solver *solver );
HYPRE_Int
HYPRE_SchwarzCreate( HYPRE_Solver *solver );

HYPRE_Int
HYPRE_SchwarzDestroy_flt( HYPRE_Solver solver );
HYPRE_Int
HYPRE_SchwarzDestroy_dbl( HYPRE_Solver solver );
HYPRE_Int
HYPRE_SchwarzDestroy_long_dbl( HYPRE_Solver solver );
HYPRE_Int
HYPRE_SchwarzDestroy( HYPRE_Solver solver );

HYPRE_Int
HYPRE_SchwarzSetDofFunc_flt( HYPRE_Solver solver, HYPRE_Int *dof_func );
HYPRE_Int
HYPRE_SchwarzSetDofFunc_dbl( HYPRE_Solver solver, HYPRE_Int *dof_func );
HYPRE_Int
HYPRE_SchwarzSetDofFunc_long_dbl( HYPRE_Solver solver, HYPRE_Int *dof_func );
HYPRE_Int
HYPRE_SchwarzSetDofFunc( HYPRE_Solver solver, HYPRE_Int *dof_func );

HYPRE_Int
HYPRE_SchwarzSetDomainStructure_flt( HYPRE_Solver solver, HYPRE_CSRMatrix domain_structure );
HYPRE_Int
HYPRE_SchwarzSetDomainStructure_dbl( HYPRE_Solver solver, HYPRE_CSRMatrix domain_structure );
HYPRE_Int
HYPRE_SchwarzSetDomainStructure_long_dbl( HYPRE_Solver solver, HYPRE_CSRMatrix domain_structure );
HYPRE_Int
HYPRE_SchwarzSetDomainStructure( HYPRE_Solver solver, HYPRE_CSRMatrix domain_structure );

HYPRE_Int
HYPRE_SchwarzSetDomainType_flt( HYPRE_Solver solver, HYPRE_Int domain_type );
HYPRE_Int
HYPRE_SchwarzSetDomainType_dbl( HYPRE_Solver solver, HYPRE_Int domain_type );
HYPRE_Int
HYPRE_SchwarzSetDomainType_long_dbl( HYPRE_Solver solver, HYPRE_Int domain_type );
HYPRE_Int
HYPRE_SchwarzSetDomainType( HYPRE_Solver solver, HYPRE_Int domain_type );

HYPRE_Int
HYPRE_SchwarzSetNonSymm_flt( HYPRE_Solver solver, HYPRE_Int use_nonsymm );
HYPRE_Int
HYPRE_SchwarzSetNonSymm_dbl( HYPRE_Solver solver, HYPRE_Int use_nonsymm );
HYPRE_Int
HYPRE_SchwarzSetNonSymm_long_dbl( HYPRE_Solver solver, HYPRE_Int use_nonsymm );
HYPRE_Int
HYPRE_SchwarzSetNonSymm( HYPRE_Solver solver, HYPRE_Int use_nonsymm );

HYPRE_Int
HYPRE_SchwarzSetNumFunctions_flt( HYPRE_Solver solver, HYPRE_Int num_functions );
HYPRE_Int
HYPRE_SchwarzSetNumFunctions_dbl( HYPRE_Solver solver, HYPRE_Int num_functions );
HYPRE_Int
HYPRE_SchwarzSetNumFunctions_long_dbl( HYPRE_Solver solver, HYPRE_Int num_functions );
HYPRE_Int
HYPRE_SchwarzSetNumFunctions( HYPRE_Solver solver, HYPRE_Int num_functions );

HYPRE_Int
HYPRE_SchwarzSetOverlap_flt( HYPRE_Solver solver, HYPRE_Int overlap );
HYPRE_Int
HYPRE_SchwarzSetOverlap_dbl( HYPRE_Solver solver, HYPRE_Int overlap );
HYPRE_Int
HYPRE_SchwarzSetOverlap_long_dbl( HYPRE_Solver solver, HYPRE_Int overlap );
HYPRE_Int
HYPRE_SchwarzSetOverlap( HYPRE_Solver solver, HYPRE_Int overlap );

HYPRE_Int
HYPRE_SchwarzSetRelaxWeight_flt( HYPRE_Solver solver, hypre_float relax_weight );
HYPRE_Int
HYPRE_SchwarzSetRelaxWeight_dbl( HYPRE_Solver solver, hypre_double relax_weight );
HYPRE_Int
HYPRE_SchwarzSetRelaxWeight_long_dbl( HYPRE_Solver solver, hypre_long_double relax_weight );
HYPRE_Int
HYPRE_SchwarzSetRelaxWeight( HYPRE_Solver solver, hypre_long_double relax_weight );

HYPRE_Int
HYPRE_SchwarzSetVariant_flt( HYPRE_Solver solver, HYPRE_Int variant );
HYPRE_Int
HYPRE_SchwarzSetVariant_dbl( HYPRE_Solver solver, HYPRE_Int variant );
HYPRE_Int
HYPRE_SchwarzSetVariant_long_dbl( HYPRE_Solver solver, HYPRE_Int variant );
HYPRE_Int
HYPRE_SchwarzSetVariant( HYPRE_Solver solver, HYPRE_Int variant );

HYPRE_Int
HYPRE_SchwarzSetup_flt( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_SchwarzSetup_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_SchwarzSetup_long_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_SchwarzSetup( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );

HYPRE_Int
HYPRE_SchwarzSolve_flt( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_SchwarzSolve_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_SchwarzSolve_long_dbl( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );
HYPRE_Int
HYPRE_SchwarzSolve( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );

HYPRE_Int
HYPRE_TempParCSRSetupInterpreter_flt( mv_InterfaceInterpreter *i );
HYPRE_Int
HYPRE_TempParCSRSetupInterpreter_dbl( mv_InterfaceInterpreter *i );
HYPRE_Int
HYPRE_TempParCSRSetupInterpreter_long_dbl( mv_InterfaceInterpreter *i );
HYPRE_Int
HYPRE_TempParCSRSetupInterpreter( mv_InterfaceInterpreter *i );


/*** DO NOT EDIT THIS FILE DIRECTLY (use ../config/gen_code.sh to generate) ***/

/******************************************************************************
 * Copyright (c) 1998 Lawrence Livermore National Security, LLC and other
 * HYPRE Project Developers. See the top-level COPYRIGHT file for details.
 *
 * SPDX-License-Identifier: (Apache-2.0 OR MIT)
 ******************************************************************************/


HYPRE_Int
HYPRE_ADSCreate_pre( HYPRE_Precision precision, HYPRE_Solver *solver );

HYPRE_Int
HYPRE_ADSDestroy_pre( HYPRE_Precision precision, HYPRE_Solver solver );

HYPRE_Int
HYPRE_ADSGetFinalRelativeResidualNorm_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *rel_resid_norm );

HYPRE_Int
HYPRE_ADSGetNumIterations_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *num_iterations );

HYPRE_Int
HYPRE_ADSSetAMGOptions_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int coarsen_type, HYPRE_Int agg_levels, HYPRE_Int relax_type, hypre_long_double strength_threshold, HYPRE_Int interp_type, HYPRE_Int Pmax );

HYPRE_Int
HYPRE_ADSSetAMSOptions_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int cycle_type, HYPRE_Int coarsen_type, HYPRE_Int agg_levels, HYPRE_Int relax_type, hypre_long_double strength_threshold, HYPRE_Int interp_type, HYPRE_Int Pmax );

HYPRE_Int
HYPRE_ADSSetChebySmoothingOptions_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int cheby_order, hypre_long_double cheby_fraction );

HYPRE_Int
HYPRE_ADSSetCoordinateVectors_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParVector x, HYPRE_ParVector y, HYPRE_ParVector z );

HYPRE_Int
HYPRE_ADSSetCycleType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int cycle_type );

HYPRE_Int
HYPRE_ADSSetDiscreteCurl_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix C );

HYPRE_Int
HYPRE_ADSSetDiscreteGradient_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix G );

HYPRE_Int
HYPRE_ADSSetInterpolations_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix RT_Pi, HYPRE_ParCSRMatrix RT_Pix, HYPRE_ParCSRMatrix RT_Piy, HYPRE_ParCSRMatrix RT_Piz, HYPRE_ParCSRMatrix ND_Pi, HYPRE_ParCSRMatrix ND_Pix, HYPRE_ParCSRMatrix ND_Piy, HYPRE_ParCSRMatrix ND_Piz );

HYPRE_Int
HYPRE_ADSSetMaxIter_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int maxit );

HYPRE_Int
HYPRE_ADSSetPrintLevel_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int print_level );

HYPRE_Int
HYPRE_ADSSetSmoothingOptions_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int relax_type, HYPRE_Int relax_times, hypre_long_double relax_weight, hypre_long_double omega );

HYPRE_Int
HYPRE_ADSSetTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double tol );

HYPRE_Int
HYPRE_ADSSetup_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );

HYPRE_Int
HYPRE_ADSSolve_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );

HYPRE_Int
HYPRE_AMECreate_pre( HYPRE_Precision precision, HYPRE_Solver *esolver );

HYPRE_Int
HYPRE_AMEDestroy_pre( HYPRE_Precision precision, HYPRE_Solver esolver );

HYPRE_Int
HYPRE_AMEGetEigenvalues_pre( HYPRE_Precision precision, HYPRE_Solver esolver, void *eigenvalues );

HYPRE_Int
HYPRE_AMEGetEigenvectors_pre( HYPRE_Precision precision, HYPRE_Solver esolver, HYPRE_ParVector **eigenvectors );

HYPRE_Int
HYPRE_AMESetAMSSolver_pre( HYPRE_Precision precision, HYPRE_Solver esolver, HYPRE_Solver ams_solver );

HYPRE_Int
HYPRE_AMESetBlockSize_pre( HYPRE_Precision precision, HYPRE_Solver esolver, HYPRE_Int block_size );

HYPRE_Int
HYPRE_AMESetMassMatrix_pre( HYPRE_Precision precision, HYPRE_Solver esolver, HYPRE_ParCSRMatrix M );

HYPRE_Int
HYPRE_AMESetMaxIter_pre( HYPRE_Precision precision, HYPRE_Solver esolver, HYPRE_Int maxit );

HYPRE_Int
HYPRE_AMESetMaxPCGIter_pre( HYPRE_Precision precision, HYPRE_Solver esolver, HYPRE_Int maxit );

HYPRE_Int
HYPRE_AMESetPrintLevel_pre( HYPRE_Precision precision, HYPRE_Solver esolver, HYPRE_Int print_level );

HYPRE_Int
HYPRE_AMESetRTol_pre( HYPRE_Precision precision, HYPRE_Solver esolver, hypre_long_double tol );

HYPRE_Int
HYPRE_AMESetTol_pre( HYPRE_Precision precision, HYPRE_Solver esolver, hypre_long_double tol );

HYPRE_Int
HYPRE_AMESetup_pre( HYPRE_Precision precision, HYPRE_Solver esolver );

HYPRE_Int
HYPRE_AMESolve_pre( HYPRE_Precision precision, HYPRE_Solver esolver );

HYPRE_Int
HYPRE_AMSConstructDiscreteGradient_pre( HYPRE_Precision precision, HYPRE_ParCSRMatrix A, HYPRE_ParVector x_coord, HYPRE_BigInt *edge_vertex, HYPRE_Int edge_orientation, HYPRE_ParCSRMatrix *G );

HYPRE_Int
HYPRE_AMSCreate_pre( HYPRE_Precision precision, HYPRE_Solver *solver );

HYPRE_Int
HYPRE_AMSDestroy_pre( HYPRE_Precision precision, HYPRE_Solver solver );

HYPRE_Int
HYPRE_AMSGetFinalRelativeResidualNorm_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *rel_resid_norm );

HYPRE_Int
HYPRE_AMSGetNumIterations_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *num_iterations );

HYPRE_Int
HYPRE_AMSProjectOutGradients_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParVector x );

HYPRE_Int
HYPRE_AMSSetAlphaAMGCoarseRelaxType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int alpha_coarse_relax_type );

HYPRE_Int
HYPRE_AMSSetAlphaAMGOptions_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int alpha_coarsen_type, HYPRE_Int alpha_agg_levels, HYPRE_Int alpha_relax_type, hypre_long_double alpha_strength_threshold, HYPRE_Int alpha_interp_type, HYPRE_Int alpha_Pmax );

HYPRE_Int
HYPRE_AMSSetAlphaPoissonMatrix_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A_alpha );

HYPRE_Int
HYPRE_AMSSetBetaAMGCoarseRelaxType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int beta_coarse_relax_type );

HYPRE_Int
HYPRE_AMSSetBetaAMGOptions_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int beta_coarsen_type, HYPRE_Int beta_agg_levels, HYPRE_Int beta_relax_type, hypre_long_double beta_strength_threshold, HYPRE_Int beta_interp_type, HYPRE_Int beta_Pmax );

HYPRE_Int
HYPRE_AMSSetBetaPoissonMatrix_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A_beta );

HYPRE_Int
HYPRE_AMSSetCoordinateVectors_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParVector x, HYPRE_ParVector y, HYPRE_ParVector z );

HYPRE_Int
HYPRE_AMSSetCycleType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int cycle_type );

HYPRE_Int
HYPRE_AMSSetDimension_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int dim );

HYPRE_Int
HYPRE_AMSSetDiscreteGradient_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix G );

HYPRE_Int
HYPRE_AMSSetEdgeConstantVectors_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParVector Gx, HYPRE_ParVector Gy, HYPRE_ParVector Gz );

HYPRE_Int
HYPRE_AMSSetInteriorNodes_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParVector interior_nodes );

HYPRE_Int
HYPRE_AMSSetInterpolations_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix Pi, HYPRE_ParCSRMatrix Pix, HYPRE_ParCSRMatrix Piy, HYPRE_ParCSRMatrix Piz );

HYPRE_Int
HYPRE_AMSSetMaxIter_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int maxit );

HYPRE_Int
HYPRE_AMSSetPrintLevel_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int print_level );

HYPRE_Int
HYPRE_AMSSetProjectionFrequency_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int projection_frequency );

HYPRE_Int
HYPRE_AMSSetSmoothingOptions_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int relax_type, HYPRE_Int relax_times, hypre_long_double relax_weight, hypre_long_double omega );

HYPRE_Int
HYPRE_AMSSetTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double tol );

HYPRE_Int
HYPRE_AMSSetup_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );

HYPRE_Int
HYPRE_AMSSolve_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );

HYPRE_Int
HYPRE_BlockTridiagCreate_pre( HYPRE_Precision precision, HYPRE_Solver *solver );

HYPRE_Int
HYPRE_BlockTridiagDestroy_pre( HYPRE_Precision precision, HYPRE_Solver solver );

HYPRE_Int
HYPRE_BlockTridiagSetAMGNumSweeps_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int num_sweeps );

HYPRE_Int
HYPRE_BlockTridiagSetAMGRelaxType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int relax_type );

HYPRE_Int
HYPRE_BlockTridiagSetAMGStrengthThreshold_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double thresh );

HYPRE_Int
HYPRE_BlockTridiagSetIndexSet_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int n, HYPRE_Int *inds );

HYPRE_Int
HYPRE_BlockTridiagSetPrintLevel_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int print_level );

HYPRE_Int
HYPRE_BlockTridiagSetup_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );

HYPRE_Int
HYPRE_BlockTridiagSolve_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );

HYPRE_Int
HYPRE_BoomerAMGCreate_pre( HYPRE_Precision precision, HYPRE_Solver *solver );

HYPRE_Int
HYPRE_BoomerAMGDDCreate_pre( HYPRE_Precision precision, HYPRE_Solver *solver );

HYPRE_Int
HYPRE_BoomerAMGDDDestroy_pre( HYPRE_Precision precision, HYPRE_Solver solver );

HYPRE_Int
HYPRE_BoomerAMGDDGetAMG_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Solver *amg_solver );

HYPRE_Int
HYPRE_BoomerAMGDDGetFinalRelativeResidualNorm_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *rel_resid_norm );

HYPRE_Int
HYPRE_BoomerAMGDDGetNumIterations_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *num_iterations );

HYPRE_Int
HYPRE_BoomerAMGDDSetFACCycleType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int amgdd_fac_cycle_type );

HYPRE_Int
HYPRE_BoomerAMGDDSetFACNumCycles_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int amgdd_fac_num_cycles );

HYPRE_Int
HYPRE_BoomerAMGDDSetFACNumRelax_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int amgdd_fac_num_relax );

HYPRE_Int
HYPRE_BoomerAMGDDSetFACRelaxType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int amgdd_fac_relax_type );

HYPRE_Int
HYPRE_BoomerAMGDDSetFACRelaxWeight_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double amgdd_fac_relax_weight );

HYPRE_Int
HYPRE_BoomerAMGDDSetNumGhostLayers_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int num_ghost_layers );

HYPRE_Int
HYPRE_BoomerAMGDDSetPadding_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int padding );

HYPRE_Int
HYPRE_BoomerAMGDDSetStartLevel_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int start_level );

HYPRE_Int
HYPRE_BoomerAMGDDSetup_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );

HYPRE_Int
HYPRE_BoomerAMGDDSolve_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );

HYPRE_Int
HYPRE_BoomerAMGDestroy_pre( HYPRE_Precision precision, HYPRE_Solver solver );

HYPRE_Int
HYPRE_BoomerAMGGetAdditive_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *additive );

HYPRE_Int
HYPRE_BoomerAMGGetCoarsenCutFactor_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *coarsen_cut_factor );

HYPRE_Int
HYPRE_BoomerAMGGetCoarsenType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *coarsen_type );

HYPRE_Int
HYPRE_BoomerAMGGetConvergeType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *type );

HYPRE_Int
HYPRE_BoomerAMGGetCumNnzAP_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *cum_nnz_AP );

HYPRE_Int
HYPRE_BoomerAMGGetCumNumIterations_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *cum_num_iterations );

HYPRE_Int
HYPRE_BoomerAMGGetCycleNumSweeps_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *num_sweeps, HYPRE_Int k );

HYPRE_Int
HYPRE_BoomerAMGGetCycleRelaxType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *relax_type, HYPRE_Int k );

HYPRE_Int
HYPRE_BoomerAMGGetCycleType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *cycle_type );

HYPRE_Int
HYPRE_BoomerAMGGetDebugFlag_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *debug_flag );

HYPRE_Int
HYPRE_BoomerAMGGetDomainType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *domain_type );

HYPRE_Int
HYPRE_BoomerAMGGetFCycle_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *fcycle );

HYPRE_Int
HYPRE_BoomerAMGGetFilterFunctions_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *filter_functions );

HYPRE_Int
HYPRE_BoomerAMGGetFilterThresholdR_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *filter_threshold );

HYPRE_Int
HYPRE_BoomerAMGGetFinalRelativeResidualNorm_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *rel_resid_norm );

HYPRE_Int
HYPRE_BoomerAMGGetGridHierarchy_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *cgrid );

HYPRE_Int
HYPRE_BoomerAMGGetJacobiTruncThreshold_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *jacobi_trunc_threshold );

HYPRE_Int
HYPRE_BoomerAMGGetLogging_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *logging );

HYPRE_Int
HYPRE_BoomerAMGGetMaxCoarseSize_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *max_coarse_size );

HYPRE_Int
HYPRE_BoomerAMGGetMaxIter_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *max_iter );

HYPRE_Int
HYPRE_BoomerAMGGetMaxLevels_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *max_levels );

HYPRE_Int
HYPRE_BoomerAMGGetMaxRowSum_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *max_row_sum );

HYPRE_Int
HYPRE_BoomerAMGGetMeasureType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *measure_type );

HYPRE_Int
HYPRE_BoomerAMGGetMinCoarseSize_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *min_coarse_size );

HYPRE_Int
HYPRE_BoomerAMGGetMultAdditive_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *mult_additive );

HYPRE_Int
HYPRE_BoomerAMGGetNumFunctions_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *num_functions );

HYPRE_Int
HYPRE_BoomerAMGGetNumIterations_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *num_iterations );

HYPRE_Int
HYPRE_BoomerAMGGetOverlap_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *overlap );

HYPRE_Int
HYPRE_BoomerAMGGetPMaxElmts_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *P_max_elmts );

HYPRE_Int
HYPRE_BoomerAMGGetPostInterpType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *post_interp_type );

HYPRE_Int
HYPRE_BoomerAMGGetPrintLevel_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *print_level );

HYPRE_Int
HYPRE_BoomerAMGGetRedundant_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *redundant );

HYPRE_Int
HYPRE_BoomerAMGGetResidual_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParVector *residual );

HYPRE_Int
HYPRE_BoomerAMGGetSchwarzRlxWeight_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *schwarz_rlx_weight );

HYPRE_Int
HYPRE_BoomerAMGGetSeqThreshold_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *seq_threshold );

HYPRE_Int
HYPRE_BoomerAMGGetSimple_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *simple );

HYPRE_Int
HYPRE_BoomerAMGGetSmoothNumLevels_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *smooth_num_levels );

HYPRE_Int
HYPRE_BoomerAMGGetSmoothNumSweeps_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *smooth_num_sweeps );

HYPRE_Int
HYPRE_BoomerAMGGetSmoothType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *smooth_type );

HYPRE_Int
HYPRE_BoomerAMGGetStrongThreshold_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *strong_threshold );

HYPRE_Int
HYPRE_BoomerAMGGetStrongThresholdR_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *strong_threshold );

HYPRE_Int
HYPRE_BoomerAMGGetTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *tol );

HYPRE_Int
HYPRE_BoomerAMGGetTruncFactor_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *trunc_factor );

HYPRE_Int
HYPRE_BoomerAMGGetVariant_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *variant );

HYPRE_Int
HYPRE_BoomerAMGInitGridRelaxation_pre( HYPRE_Precision precision, HYPRE_Int **num_grid_sweeps_ptr, HYPRE_Int **grid_relax_type_ptr, HYPRE_Int ***grid_relax_points_ptr, HYPRE_Int coarsen_type, void *relax_weights_ptr, HYPRE_Int max_levels );

HYPRE_Int
HYPRE_BoomerAMGSetADropTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double A_drop_tol );

HYPRE_Int
HYPRE_BoomerAMGSetADropType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int A_drop_type );

HYPRE_Int
HYPRE_BoomerAMGSetAddLastLvl_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int add_last_lvl );

HYPRE_Int
HYPRE_BoomerAMGSetAddPMaxElmts_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int add_P_max_elmts );

HYPRE_Int
HYPRE_BoomerAMGSetAddRelaxType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int add_rlx_type );

HYPRE_Int
HYPRE_BoomerAMGSetAddRelaxWt_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double add_rlx_wt );

HYPRE_Int
HYPRE_BoomerAMGSetAddTruncFactor_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double add_trunc_factor );

HYPRE_Int
HYPRE_BoomerAMGSetAdditive_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int addlvl );

HYPRE_Int
HYPRE_BoomerAMGSetAggInterpType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int agg_interp_type );

HYPRE_Int
HYPRE_BoomerAMGSetAggNumLevels_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int agg_num_levels );

HYPRE_Int
HYPRE_BoomerAMGSetAggP12MaxElmts_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int agg_P12_max_elmts );

HYPRE_Int
HYPRE_BoomerAMGSetAggP12TruncFactor_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double agg_P12_trunc_factor );

HYPRE_Int
HYPRE_BoomerAMGSetAggPMaxElmts_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int agg_P_max_elmts );

HYPRE_Int
HYPRE_BoomerAMGSetAggTruncFactor_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double agg_trunc_factor );

HYPRE_Int
HYPRE_BoomerAMGSetCGCIts_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int its );

HYPRE_Int
HYPRE_BoomerAMGSetCPoints_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int cpt_coarse_level, HYPRE_Int num_cpt_coarse, HYPRE_BigInt *cpt_coarse_index );

HYPRE_Int
HYPRE_BoomerAMGSetCRRate_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double CR_rate );

HYPRE_Int
HYPRE_BoomerAMGSetCRStrongTh_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double CR_strong_th );

HYPRE_Int
HYPRE_BoomerAMGSetCRUseCG_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int CR_use_CG );

HYPRE_Int
HYPRE_BoomerAMGSetChebyEigEst_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int eig_est );

HYPRE_Int
HYPRE_BoomerAMGSetChebyFraction_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double ratio );

HYPRE_Int
HYPRE_BoomerAMGSetChebyOrder_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int order );

HYPRE_Int
HYPRE_BoomerAMGSetChebyScale_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int scale );

HYPRE_Int
HYPRE_BoomerAMGSetChebyVariant_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int variant );

HYPRE_Int
HYPRE_BoomerAMGSetCoarsenCutFactor_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int coarsen_cut_factor );

HYPRE_Int
HYPRE_BoomerAMGSetCoarsenType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int coarsen_type );

HYPRE_Int
HYPRE_BoomerAMGSetConvergeType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int type );

HYPRE_Int
HYPRE_BoomerAMGSetCoordDim_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int coorddim );

HYPRE_Int
HYPRE_BoomerAMGSetCoordinates_pre( HYPRE_Precision precision, HYPRE_Solver solver, float *coordinates );

HYPRE_Int
HYPRE_BoomerAMGSetCpointsToKeep_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int cpt_coarse_level, HYPRE_Int num_cpt_coarse, HYPRE_BigInt *cpt_coarse_index );

HYPRE_Int
HYPRE_BoomerAMGSetCumNnzAP_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double cum_nnz_AP );

HYPRE_Int
HYPRE_BoomerAMGSetCycleNumSweeps_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int num_sweeps, HYPRE_Int k );

HYPRE_Int
HYPRE_BoomerAMGSetCycleRelaxType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int relax_type, HYPRE_Int k );

HYPRE_Int
HYPRE_BoomerAMGSetCycleType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int cycle_type );

HYPRE_Int
HYPRE_BoomerAMGSetDebugFlag_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int debug_flag );

HYPRE_Int
HYPRE_BoomerAMGSetDofFunc_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *dof_func );

HYPRE_Int
HYPRE_BoomerAMGSetDomainType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int domain_type );

HYPRE_Int
HYPRE_BoomerAMGSetDropTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double drop_tol );

HYPRE_Int
HYPRE_BoomerAMGSetEuBJ_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int eu_bj );

HYPRE_Int
HYPRE_BoomerAMGSetEuLevel_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int eu_level );

HYPRE_Int
HYPRE_BoomerAMGSetEuSparseA_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double eu_sparse_A );

HYPRE_Int
HYPRE_BoomerAMGSetEuclidFile_pre( HYPRE_Precision precision, HYPRE_Solver solver, char *euclidfile );

HYPRE_Int
HYPRE_BoomerAMGSetFCycle_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int fcycle );

HYPRE_Int
HYPRE_BoomerAMGSetFPoints_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int num_fpt, HYPRE_BigInt *fpt_index );

HYPRE_Int
HYPRE_BoomerAMGSetFSAIAlgoType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int algo_type );

HYPRE_Int
HYPRE_BoomerAMGSetFSAIEigMaxIters_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int eig_max_iters );

HYPRE_Int
HYPRE_BoomerAMGSetFSAIKapTolerance_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double kap_tolerance );

HYPRE_Int
HYPRE_BoomerAMGSetFSAILocalSolveType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int local_solve_type );

HYPRE_Int
HYPRE_BoomerAMGSetFSAIMaxNnzRow_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int max_nnz_row );

HYPRE_Int
HYPRE_BoomerAMGSetFSAIMaxStepSize_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int max_step_size );

HYPRE_Int
HYPRE_BoomerAMGSetFSAIMaxSteps_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int max_steps );

HYPRE_Int
HYPRE_BoomerAMGSetFSAINumLevels_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int num_levels );

HYPRE_Int
HYPRE_BoomerAMGSetFSAIThreshold_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double threshold );

HYPRE_Int
HYPRE_BoomerAMGSetFilter_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double filter );

HYPRE_Int
HYPRE_BoomerAMGSetFilterFunctions_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int filter_functions );

HYPRE_Int
HYPRE_BoomerAMGSetFilterThresholdR_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double filter_threshold );

HYPRE_Int
HYPRE_BoomerAMGSetGMRESSwitchR_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int gmres_switch );

HYPRE_Int
HYPRE_BoomerAMGSetGSMG_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int gsmg );

HYPRE_Int
HYPRE_BoomerAMGSetGridRelaxPoints_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int **grid_relax_points );

HYPRE_Int
HYPRE_BoomerAMGSetGridRelaxType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *grid_relax_type );

HYPRE_Int
HYPRE_BoomerAMGSetILUDroptol_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double ilu_droptol );

HYPRE_Int
HYPRE_BoomerAMGSetILUIterSetupMaxIter_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int ilu_iter_setup_max_iter );

HYPRE_Int
HYPRE_BoomerAMGSetILUIterSetupOption_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int ilu_iter_setup_option );

HYPRE_Int
HYPRE_BoomerAMGSetILUIterSetupTolerance_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double ilu_iter_setup_tolerance );

HYPRE_Int
HYPRE_BoomerAMGSetILUIterSetupType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int ilu_iter_setup_type );

HYPRE_Int
HYPRE_BoomerAMGSetILULevel_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int ilu_lfil );

HYPRE_Int
HYPRE_BoomerAMGSetILULocalReordering_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int ilu_reordering_type );

HYPRE_Int
HYPRE_BoomerAMGSetILULowerJacobiIters_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int ilu_lower_jacobi_iters );

HYPRE_Int
HYPRE_BoomerAMGSetILUMaxIter_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int ilu_max_iter );

HYPRE_Int
HYPRE_BoomerAMGSetILUMaxRowNnz_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int ilu_max_row_nnz );

HYPRE_Int
HYPRE_BoomerAMGSetILUTriSolve_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int ilu_tri_solve );

HYPRE_Int
HYPRE_BoomerAMGSetILUType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int ilu_type );

HYPRE_Int
HYPRE_BoomerAMGSetILUUpperJacobiIters_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int ilu_upper_jacobi_iters );

HYPRE_Int
HYPRE_BoomerAMGSetISType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int IS_type );

HYPRE_Int
HYPRE_BoomerAMGSetInterpRefine_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int num_refine );

HYPRE_Int
HYPRE_BoomerAMGSetInterpType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int interp_type );

HYPRE_Int
HYPRE_BoomerAMGSetInterpVecAbsQTrunc_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double q_trunc );

HYPRE_Int
HYPRE_BoomerAMGSetInterpVecQMax_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int q_max );

HYPRE_Int
HYPRE_BoomerAMGSetInterpVecVariant_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int var );

HYPRE_Int
HYPRE_BoomerAMGSetInterpVectors_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int num_vectors, HYPRE_ParVector *interp_vectors );

HYPRE_Int
HYPRE_BoomerAMGSetIsTriangular_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int is_triangular );

HYPRE_Int
HYPRE_BoomerAMGSetIsolatedFPoints_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int num_isolated_fpt, HYPRE_BigInt *isolated_fpt_index );

HYPRE_Int
HYPRE_BoomerAMGSetJacobiTruncThreshold_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double jacobi_trunc_threshold );

HYPRE_Int
HYPRE_BoomerAMGSetKeepSameSign_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int keep_same_sign );

HYPRE_Int
HYPRE_BoomerAMGSetKeepTranspose_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int keepTranspose );

HYPRE_Int
HYPRE_BoomerAMGSetLevel_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int level );

HYPRE_Int
HYPRE_BoomerAMGSetLevelNonGalerkinTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double nongalerkin_tol, HYPRE_Int level );

HYPRE_Int
HYPRE_BoomerAMGSetLevelOuterWt_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double omega, HYPRE_Int level );

HYPRE_Int
HYPRE_BoomerAMGSetLevelRelaxWt_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double relax_weight, HYPRE_Int level );

HYPRE_Int
HYPRE_BoomerAMGSetLogging_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int logging );

HYPRE_Int
HYPRE_BoomerAMGSetMaxCoarseSize_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int max_coarse_size );

HYPRE_Int
HYPRE_BoomerAMGSetMaxIter_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int max_iter );

HYPRE_Int
HYPRE_BoomerAMGSetMaxLevels_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int max_levels );

HYPRE_Int
HYPRE_BoomerAMGSetMaxNzPerRow_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int max_nz_per_row );

HYPRE_Int
HYPRE_BoomerAMGSetMaxRowSum_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double max_row_sum );

HYPRE_Int
HYPRE_BoomerAMGSetMeasureType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int measure_type );

HYPRE_Int
HYPRE_BoomerAMGSetMinCoarseSize_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int min_coarse_size );

HYPRE_Int
HYPRE_BoomerAMGSetMinIter_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int min_iter );

HYPRE_Int
HYPRE_BoomerAMGSetModuleRAP2_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int mod_rap2 );

HYPRE_Int
HYPRE_BoomerAMGSetMultAddPMaxElmts_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int add_P_max_elmts );

HYPRE_Int
HYPRE_BoomerAMGSetMultAddTruncFactor_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double add_trunc_factor );

HYPRE_Int
HYPRE_BoomerAMGSetMultAdditive_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int addlvl );

HYPRE_Int
HYPRE_BoomerAMGSetNodal_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int nodal );

HYPRE_Int
HYPRE_BoomerAMGSetNodalDiag_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int nodal_diag );

HYPRE_Int
HYPRE_BoomerAMGSetNodalLevels_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int nodal_levels );

HYPRE_Int
HYPRE_BoomerAMGSetNonGalerkTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int nongalerk_num_tol, void *nongalerk_tol );

HYPRE_Int
HYPRE_BoomerAMGSetNonGalerkinTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double nongalerkin_tol );

HYPRE_Int
HYPRE_BoomerAMGSetNumCRRelaxSteps_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int num_CR_relax_steps );

HYPRE_Int
HYPRE_BoomerAMGSetNumFunctions_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int num_functions );

HYPRE_Int
HYPRE_BoomerAMGSetNumGridSweeps_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *num_grid_sweeps );

HYPRE_Int
HYPRE_BoomerAMGSetNumPaths_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int num_paths );

HYPRE_Int
HYPRE_BoomerAMGSetNumSamples_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int num_samples );

HYPRE_Int
HYPRE_BoomerAMGSetNumSweeps_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int num_sweeps );

HYPRE_Int
HYPRE_BoomerAMGSetOldDefault_pre( HYPRE_Precision precision, HYPRE_Solver solver );

HYPRE_Int
HYPRE_BoomerAMGSetOmega_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *omega );

HYPRE_Int
HYPRE_BoomerAMGSetOuterWt_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double omega );

HYPRE_Int
HYPRE_BoomerAMGSetOverlap_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int overlap );

HYPRE_Int
HYPRE_BoomerAMGSetPMaxElmts_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int P_max_elmts );

HYPRE_Int
HYPRE_BoomerAMGSetPlotFileName_pre( HYPRE_Precision precision, HYPRE_Solver solver, const char *plotfilename );

HYPRE_Int
HYPRE_BoomerAMGSetPlotGrids_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int plotgrids );

HYPRE_Int
HYPRE_BoomerAMGSetPostInterpType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int post_interp_type );

HYPRE_Int
HYPRE_BoomerAMGSetPrintFileName_pre( HYPRE_Precision precision, HYPRE_Solver solver, const char *print_file_name );

HYPRE_Int
HYPRE_BoomerAMGSetPrintLevel_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int print_level );

HYPRE_Int
HYPRE_BoomerAMGSetRAP2_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int rap2 );

HYPRE_Int
HYPRE_BoomerAMGSetRedundant_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int redundant );

HYPRE_Int
HYPRE_BoomerAMGSetRelaxOrder_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int relax_order );

HYPRE_Int
HYPRE_BoomerAMGSetRelaxType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int relax_type );

HYPRE_Int
HYPRE_BoomerAMGSetRelaxWeight_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *relax_weight );

HYPRE_Int
HYPRE_BoomerAMGSetRelaxWt_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double relax_weight );

HYPRE_Int
HYPRE_BoomerAMGSetRestriction_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int restr_par );

HYPRE_Int
HYPRE_BoomerAMGSetSCommPkgSwitch_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double S_commpkg_switch );

HYPRE_Int
HYPRE_BoomerAMGSetSabs_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int Sabs );

HYPRE_Int
HYPRE_BoomerAMGSetSchwarzRlxWeight_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double schwarz_rlx_weight );

HYPRE_Int
HYPRE_BoomerAMGSetSchwarzUseNonSymm_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int use_nonsymm );

HYPRE_Int
HYPRE_BoomerAMGSetSepWeight_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int sep_weight );

HYPRE_Int
HYPRE_BoomerAMGSetSeqThreshold_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int seq_threshold );

HYPRE_Int
HYPRE_BoomerAMGSetSetupType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int setup_type );

HYPRE_Int
HYPRE_BoomerAMGSetSimple_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int addlvl );

HYPRE_Int
HYPRE_BoomerAMGSetSmoothInterpVectors_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int smooth_interp_vectors );

HYPRE_Int
HYPRE_BoomerAMGSetSmoothNumLevels_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int smooth_num_levels );

HYPRE_Int
HYPRE_BoomerAMGSetSmoothNumSweeps_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int smooth_num_sweeps );

HYPRE_Int
HYPRE_BoomerAMGSetSmoothType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int smooth_type );

HYPRE_Int
HYPRE_BoomerAMGSetStrongThreshold_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double strong_threshold );

HYPRE_Int
HYPRE_BoomerAMGSetStrongThresholdR_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double strong_threshold );

HYPRE_Int
HYPRE_BoomerAMGSetSym_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int sym );

HYPRE_Int
HYPRE_BoomerAMGSetThreshold_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double threshold );

HYPRE_Int
HYPRE_BoomerAMGSetTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double tol );

HYPRE_Int
HYPRE_BoomerAMGSetTruncFactor_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double trunc_factor );

HYPRE_Int
HYPRE_BoomerAMGSetVariant_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int variant );

HYPRE_Int
HYPRE_BoomerAMGSetup_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );

HYPRE_Int
HYPRE_BoomerAMGSolve_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );

HYPRE_Int
HYPRE_BoomerAMGSolveT_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );

HYPRE_Int
HYPRE_EuclidCreate_pre( HYPRE_Precision precision, MPI_Comm comm, HYPRE_Solver *solver );

HYPRE_Int
HYPRE_EuclidDestroy_pre( HYPRE_Precision precision, HYPRE_Solver solver );

HYPRE_Int
HYPRE_EuclidSetBJ_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int bj );

HYPRE_Int
HYPRE_EuclidSetILUT_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double drop_tol );

HYPRE_Int
HYPRE_EuclidSetLevel_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int level );

HYPRE_Int
HYPRE_EuclidSetMem_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int eu_mem );

HYPRE_Int
HYPRE_EuclidSetParams_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int argc, char *argv[] );

HYPRE_Int
HYPRE_EuclidSetParamsFromFile_pre( HYPRE_Precision precision, HYPRE_Solver solver, char *filename );

HYPRE_Int
HYPRE_EuclidSetRowScale_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int row_scale );

HYPRE_Int
HYPRE_EuclidSetSparseA_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double sparse_A );

HYPRE_Int
HYPRE_EuclidSetStats_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int eu_stats );

HYPRE_Int
HYPRE_EuclidSetup_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );

HYPRE_Int
HYPRE_EuclidSolve_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );

HYPRE_Int
HYPRE_FSAICreate_pre( HYPRE_Precision precision, HYPRE_Solver *solver );

HYPRE_Int
HYPRE_FSAIDestroy_pre( HYPRE_Precision precision, HYPRE_Solver solver );

HYPRE_Int
HYPRE_FSAISetAlgoType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int algo_type );

HYPRE_Int
HYPRE_FSAISetEigMaxIters_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int eig_max_iters );

HYPRE_Int
HYPRE_FSAISetKapTolerance_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double kap_tolerance );

HYPRE_Int
HYPRE_FSAISetLocalSolveType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int local_solve_type );

HYPRE_Int
HYPRE_FSAISetMaxIterations_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int max_iterations );

HYPRE_Int
HYPRE_FSAISetMaxNnzRow_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int max_nnz_row );

HYPRE_Int
HYPRE_FSAISetMaxStepSize_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int max_step_size );

HYPRE_Int
HYPRE_FSAISetMaxSteps_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int max_steps );

HYPRE_Int
HYPRE_FSAISetNumLevels_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int num_levels );

HYPRE_Int
HYPRE_FSAISetOmega_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double omega );

HYPRE_Int
HYPRE_FSAISetPrintLevel_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int print_level );

HYPRE_Int
HYPRE_FSAISetThreshold_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double threshold );

HYPRE_Int
HYPRE_FSAISetTolerance_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double tolerance );

HYPRE_Int
HYPRE_FSAISetZeroGuess_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int zero_guess );

HYPRE_Int
HYPRE_FSAISetup_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );

HYPRE_Int
HYPRE_FSAISolve_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );

HYPRE_Int
HYPRE_ILUCreate_pre( HYPRE_Precision precision, HYPRE_Solver *solver );

HYPRE_Int
HYPRE_ILUDestroy_pre( HYPRE_Precision precision, HYPRE_Solver solver );

HYPRE_Int
HYPRE_ILUGetFinalRelativeResidualNorm_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *res_norm );

HYPRE_Int
HYPRE_ILUGetNumIterations_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *num_iterations );

HYPRE_Int
HYPRE_ILUSetDropThreshold_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double threshold );

HYPRE_Int
HYPRE_ILUSetDropThresholdArray_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *threshold );

HYPRE_Int
HYPRE_ILUSetIterativeSetupMaxIter_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int iter_setup_max_iter );

HYPRE_Int
HYPRE_ILUSetIterativeSetupOption_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int iter_setup_option );

HYPRE_Int
HYPRE_ILUSetIterativeSetupTolerance_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double iter_setup_tolerance );

HYPRE_Int
HYPRE_ILUSetIterativeSetupType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int iter_setup_type );

HYPRE_Int
HYPRE_ILUSetLevelOfFill_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int lfil );

HYPRE_Int
HYPRE_ILUSetLocalReordering_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int reordering_type );

HYPRE_Int
HYPRE_ILUSetLogging_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int logging );

HYPRE_Int
HYPRE_ILUSetLowerJacobiIters_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int lower_jacobi_iterations );

HYPRE_Int
HYPRE_ILUSetMaxIter_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int max_iter );

HYPRE_Int
HYPRE_ILUSetMaxNnzPerRow_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int nzmax );

HYPRE_Int
HYPRE_ILUSetNSHDropThreshold_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double threshold );

HYPRE_Int
HYPRE_ILUSetNSHDropThresholdArray_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *threshold );

HYPRE_Int
HYPRE_ILUSetPrintLevel_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int print_level );

HYPRE_Int
HYPRE_ILUSetSchurMaxIter_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int ss_max_iter );

HYPRE_Int
HYPRE_ILUSetTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double tol );

HYPRE_Int
HYPRE_ILUSetTriSolve_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int tri_solve );

HYPRE_Int
HYPRE_ILUSetType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int ilu_type );

HYPRE_Int
HYPRE_ILUSetUpperJacobiIters_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int upper_jacobi_iterations );

HYPRE_Int
HYPRE_ILUSetup_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );

HYPRE_Int
HYPRE_ILUSolve_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );

HYPRE_Int
HYPRE_MGRBuildAff_pre( HYPRE_Precision precision, HYPRE_ParCSRMatrix A, HYPRE_Int *CF_marker, HYPRE_Int debug_flag, HYPRE_ParCSRMatrix *A_ff );

HYPRE_Int
HYPRE_MGRCreate_pre( HYPRE_Precision precision, HYPRE_Solver *solver );

HYPRE_Int
HYPRE_MGRDestroy_pre( HYPRE_Precision precision, HYPRE_Solver solver );

HYPRE_Int
HYPRE_MGRGetCoarseGridConvergenceFactor_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *conv_factor );

HYPRE_Int
HYPRE_MGRGetFinalRelativeResidualNorm_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *res_norm );

HYPRE_Int
HYPRE_MGRGetNumIterations_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *num_iterations );

HYPRE_Int
HYPRE_MGRSetBlockJacobiBlockSize_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int blk_size );

HYPRE_Int
HYPRE_MGRSetBlockSize_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int bsize );

HYPRE_Int
HYPRE_MGRSetCoarseGridMethod_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *cg_method );

HYPRE_Int
HYPRE_MGRSetCoarseGridPrintLevel_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int print_level );

HYPRE_Int
HYPRE_MGRSetCoarseSolver_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_PtrToParSolverFcn coarse_grid_solver_solve, HYPRE_PtrToParSolverFcn coarse_grid_solver_setup, HYPRE_Solver coarse_grid_solver );

HYPRE_Int
HYPRE_MGRSetCpointsByBlock_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int block_size, HYPRE_Int max_num_levels, HYPRE_Int *num_block_coarse_points, HYPRE_Int **block_coarse_indexes );

HYPRE_Int
HYPRE_MGRSetCpointsByContiguousBlock_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int block_size, HYPRE_Int max_num_levels, HYPRE_BigInt *idx_array, HYPRE_Int *num_block_coarse_points, HYPRE_Int **block_coarse_indexes );

HYPRE_Int
HYPRE_MGRSetCpointsByPointMarkerArray_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int block_size, HYPRE_Int max_num_levels, HYPRE_Int *num_block_coarse_points, HYPRE_Int **lvl_block_coarse_indexes, HYPRE_Int *point_marker_array );

HYPRE_Int
HYPRE_MGRSetFRelaxMethod_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int relax_method );

HYPRE_Int
HYPRE_MGRSetFSolver_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_PtrToParSolverFcn fine_grid_solver_solve, HYPRE_PtrToParSolverFcn fine_grid_solver_setup, HYPRE_Solver fsolver );

HYPRE_Int
HYPRE_MGRSetFSolverAtLevel_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Solver fsolver, HYPRE_Int level );

HYPRE_Int
HYPRE_MGRSetFrelaxPrintLevel_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int print_level );

HYPRE_Int
HYPRE_MGRSetGlobalSmoothCycle_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int global_smooth_cycle );

HYPRE_Int
HYPRE_MGRSetGlobalSmoothType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int smooth_type );

HYPRE_Int
HYPRE_MGRSetGlobalSmootherAtLevel_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Solver smoother, HYPRE_Int level );

HYPRE_Int
HYPRE_MGRSetInterpType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int interp_type );

HYPRE_Int
HYPRE_MGRSetLevelFRelaxMethod_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *relax_method );

HYPRE_Int
HYPRE_MGRSetLevelFRelaxNumFunctions_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *num_functions );

HYPRE_Int
HYPRE_MGRSetLevelFRelaxType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *relax_type );

HYPRE_Int
HYPRE_MGRSetLevelInterpType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *interp_type );

HYPRE_Int
HYPRE_MGRSetLevelNonGalerkinMaxElmts_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *max_elmts );

HYPRE_Int
HYPRE_MGRSetLevelNumRelaxSweeps_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *nsweeps );

HYPRE_Int
HYPRE_MGRSetLevelPMaxElmts_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *P_max_elmts );

HYPRE_Int
HYPRE_MGRSetLevelRestrictType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *restrict_type );

HYPRE_Int
HYPRE_MGRSetLevelSmoothIters_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *smooth_iters );

HYPRE_Int
HYPRE_MGRSetLevelSmoothType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *smooth_type );

HYPRE_Int
HYPRE_MGRSetLogging_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int logging );

HYPRE_Int
HYPRE_MGRSetMaxCoarseLevels_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int maxlev );

HYPRE_Int
HYPRE_MGRSetMaxGlobalSmoothIters_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int smooth_iter );

HYPRE_Int
HYPRE_MGRSetMaxIter_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int max_iter );

HYPRE_Int
HYPRE_MGRSetNonCpointsToFpoints_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int nonCptToFptFlag );

HYPRE_Int
HYPRE_MGRSetNonGalerkinMaxElmts_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int max_elmts );

HYPRE_Int
HYPRE_MGRSetNumInterpSweeps_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int nsweeps );

HYPRE_Int
HYPRE_MGRSetNumRelaxSweeps_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int nsweeps );

HYPRE_Int
HYPRE_MGRSetNumRestrictSweeps_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int nsweeps );

HYPRE_Int
HYPRE_MGRSetPMaxElmts_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int P_max_elmts );

HYPRE_Int
HYPRE_MGRSetPrintLevel_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int print_level );

HYPRE_Int
HYPRE_MGRSetRelaxType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int relax_type );

HYPRE_Int
HYPRE_MGRSetReservedCoarseNodes_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int reserved_coarse_size, HYPRE_BigInt *reserved_coarse_nodes );

HYPRE_Int
HYPRE_MGRSetReservedCpointsLevelToKeep_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int level );

HYPRE_Int
HYPRE_MGRSetRestrictType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int restrict_type );

HYPRE_Int
HYPRE_MGRSetTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double tol );

HYPRE_Int
HYPRE_MGRSetTruncateCoarseGridThreshold_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double threshold );

HYPRE_Int
HYPRE_MGRSetup_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );

HYPRE_Int
HYPRE_MGRSolve_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );

HYPRE_Int
HYPRE_ParCSRBiCGSTABCreate_pre( HYPRE_Precision precision, MPI_Comm comm, HYPRE_Solver *solver );

HYPRE_Int
HYPRE_ParCSRBiCGSTABDestroy_pre( HYPRE_Precision precision, HYPRE_Solver solver );

HYPRE_Int
HYPRE_ParCSRBiCGSTABGetFinalRelativeResidualNorm_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *norm );

HYPRE_Int
HYPRE_ParCSRBiCGSTABGetNumIterations_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *num_iterations );

HYPRE_Int
HYPRE_ParCSRBiCGSTABGetPrecond_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Solver *precond_data );

HYPRE_Int
HYPRE_ParCSRBiCGSTABGetResidual_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParVector *residual );

HYPRE_Int
HYPRE_ParCSRBiCGSTABSetAbsoluteTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double a_tol );

HYPRE_Int
HYPRE_ParCSRBiCGSTABSetLogging_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int logging );

HYPRE_Int
HYPRE_ParCSRBiCGSTABSetMaxIter_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int max_iter );

HYPRE_Int
HYPRE_ParCSRBiCGSTABSetMinIter_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int min_iter );

HYPRE_Int
HYPRE_ParCSRBiCGSTABSetPrecond_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_PtrToParSolverFcn precond, HYPRE_PtrToParSolverFcn precond_setup, HYPRE_Solver precond_solver );

HYPRE_Int
HYPRE_ParCSRBiCGSTABSetPrintLevel_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int print_level );

HYPRE_Int
HYPRE_ParCSRBiCGSTABSetStopCrit_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int stop_crit );

HYPRE_Int
HYPRE_ParCSRBiCGSTABSetTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double tol );

HYPRE_Int
HYPRE_ParCSRBiCGSTABSetup_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );

HYPRE_Int
HYPRE_ParCSRBiCGSTABSolve_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );

HYPRE_Int
HYPRE_ParCSRCGNRCreate_pre( HYPRE_Precision precision, MPI_Comm comm, HYPRE_Solver *solver );

HYPRE_Int
HYPRE_ParCSRCGNRDestroy_pre( HYPRE_Precision precision, HYPRE_Solver solver );

HYPRE_Int
HYPRE_ParCSRCGNRGetFinalRelativeResidualNorm_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *norm );

HYPRE_Int
HYPRE_ParCSRCGNRGetNumIterations_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *num_iterations );

HYPRE_Int
HYPRE_ParCSRCGNRGetPrecond_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Solver *precond_data );

HYPRE_Int
HYPRE_ParCSRCGNRSetLogging_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int logging );

HYPRE_Int
HYPRE_ParCSRCGNRSetMaxIter_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int max_iter );

HYPRE_Int
HYPRE_ParCSRCGNRSetMinIter_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int min_iter );

HYPRE_Int
HYPRE_ParCSRCGNRSetPrecond_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_PtrToParSolverFcn precond, HYPRE_PtrToParSolverFcn precondT, HYPRE_PtrToParSolverFcn precond_setup, HYPRE_Solver precond_solver );

HYPRE_Int
HYPRE_ParCSRCGNRSetStopCrit_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int stop_crit );

HYPRE_Int
HYPRE_ParCSRCGNRSetTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double tol );

HYPRE_Int
HYPRE_ParCSRCGNRSetup_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );

HYPRE_Int
HYPRE_ParCSRCGNRSolve_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );

HYPRE_Int
HYPRE_ParCSRCOGMRESCreate_pre( HYPRE_Precision precision, MPI_Comm comm, HYPRE_Solver *solver );

HYPRE_Int
HYPRE_ParCSRCOGMRESDestroy_pre( HYPRE_Precision precision, HYPRE_Solver solver );

HYPRE_Int
HYPRE_ParCSRCOGMRESGetFinalRelativeResidualNorm_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *norm );

HYPRE_Int
HYPRE_ParCSRCOGMRESGetNumIterations_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *num_iterations );

HYPRE_Int
HYPRE_ParCSRCOGMRESGetPrecond_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Solver *precond_data );

HYPRE_Int
HYPRE_ParCSRCOGMRESGetResidual_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParVector *residual );

HYPRE_Int
HYPRE_ParCSRCOGMRESSetAbsoluteTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double a_tol );

HYPRE_Int
HYPRE_ParCSRCOGMRESSetCGS_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int cgs );

HYPRE_Int
HYPRE_ParCSRCOGMRESSetKDim_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int k_dim );

HYPRE_Int
HYPRE_ParCSRCOGMRESSetLogging_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int logging );

HYPRE_Int
HYPRE_ParCSRCOGMRESSetMaxIter_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int max_iter );

HYPRE_Int
HYPRE_ParCSRCOGMRESSetMinIter_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int min_iter );

HYPRE_Int
HYPRE_ParCSRCOGMRESSetPrecond_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_PtrToParSolverFcn precond, HYPRE_PtrToParSolverFcn precond_setup, HYPRE_Solver precond_solver );

HYPRE_Int
HYPRE_ParCSRCOGMRESSetPrintLevel_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int print_level );

HYPRE_Int
HYPRE_ParCSRCOGMRESSetTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double tol );

HYPRE_Int
HYPRE_ParCSRCOGMRESSetUnroll_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int unroll );

HYPRE_Int
HYPRE_ParCSRCOGMRESSetup_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );

HYPRE_Int
HYPRE_ParCSRCOGMRESSolve_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );

HYPRE_Int
HYPRE_ParCSRDiagScale_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix HA, HYPRE_ParVector Hy, HYPRE_ParVector Hx );

HYPRE_Int
HYPRE_ParCSRDiagScaleSetup_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector y, HYPRE_ParVector x );

HYPRE_Int
HYPRE_ParCSRFlexGMRESCreate_pre( HYPRE_Precision precision, MPI_Comm comm, HYPRE_Solver *solver );

HYPRE_Int
HYPRE_ParCSRFlexGMRESDestroy_pre( HYPRE_Precision precision, HYPRE_Solver solver );

HYPRE_Int
HYPRE_ParCSRFlexGMRESGetFinalRelativeResidualNorm_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *norm );

HYPRE_Int
HYPRE_ParCSRFlexGMRESGetNumIterations_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *num_iterations );

HYPRE_Int
HYPRE_ParCSRFlexGMRESGetPrecond_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Solver *precond_data );

HYPRE_Int
HYPRE_ParCSRFlexGMRESGetResidual_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParVector *residual );

HYPRE_Int
HYPRE_ParCSRFlexGMRESSetAbsoluteTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double a_tol );

HYPRE_Int
HYPRE_ParCSRFlexGMRESSetKDim_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int k_dim );

HYPRE_Int
HYPRE_ParCSRFlexGMRESSetLogging_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int logging );

HYPRE_Int
HYPRE_ParCSRFlexGMRESSetMaxIter_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int max_iter );

HYPRE_Int
HYPRE_ParCSRFlexGMRESSetMinIter_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int min_iter );

HYPRE_Int
HYPRE_ParCSRFlexGMRESSetModifyPC_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_PtrToModifyPCFcn modify_pc );

HYPRE_Int
HYPRE_ParCSRFlexGMRESSetPrecond_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_PtrToParSolverFcn precond, HYPRE_PtrToParSolverFcn precond_setup, HYPRE_Solver precond_solver );

HYPRE_Int
HYPRE_ParCSRFlexGMRESSetPrintLevel_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int print_level );

HYPRE_Int
HYPRE_ParCSRFlexGMRESSetTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double tol );

HYPRE_Int
HYPRE_ParCSRFlexGMRESSetup_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );

HYPRE_Int
HYPRE_ParCSRFlexGMRESSolve_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );

HYPRE_Int
HYPRE_ParCSRGMRESCreate_pre( HYPRE_Precision precision, MPI_Comm comm, HYPRE_Solver *solver );

HYPRE_Int
HYPRE_ParCSRGMRESDestroy_pre( HYPRE_Precision precision, HYPRE_Solver solver );

HYPRE_Int
HYPRE_ParCSRGMRESGetFinalRelativeResidualNorm_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *norm );

HYPRE_Int
HYPRE_ParCSRGMRESGetNumIterations_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *num_iterations );

HYPRE_Int
HYPRE_ParCSRGMRESGetPrecond_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Solver *precond_data );

HYPRE_Int
HYPRE_ParCSRGMRESGetRefSolution_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParVector *ref_solution );

HYPRE_Int
HYPRE_ParCSRGMRESGetResidual_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParVector *residual );

HYPRE_Int
HYPRE_ParCSRGMRESSetAbsoluteTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double a_tol );

HYPRE_Int
HYPRE_ParCSRGMRESSetKDim_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int k_dim );

HYPRE_Int
HYPRE_ParCSRGMRESSetLogging_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int logging );

HYPRE_Int
HYPRE_ParCSRGMRESSetMaxIter_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int max_iter );

HYPRE_Int
HYPRE_ParCSRGMRESSetMinIter_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int min_iter );

HYPRE_Int
HYPRE_ParCSRGMRESSetPrecond_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_PtrToParSolverFcn precond, HYPRE_PtrToParSolverFcn precond_setup, HYPRE_Solver precond_solver );

HYPRE_Int
HYPRE_ParCSRGMRESSetPrintLevel_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int print_level );

HYPRE_Int
HYPRE_ParCSRGMRESSetRefSolution_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParVector ref_solution );

HYPRE_Int
HYPRE_ParCSRGMRESSetStopCrit_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int stop_crit );

HYPRE_Int
HYPRE_ParCSRGMRESSetTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double tol );

HYPRE_Int
HYPRE_ParCSRGMRESSetup_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );

HYPRE_Int
HYPRE_ParCSRGMRESSolve_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );

HYPRE_Int
HYPRE_ParCSRHybridCreate_pre( HYPRE_Precision precision, HYPRE_Solver *solver );

HYPRE_Int
HYPRE_ParCSRHybridDestroy_pre( HYPRE_Precision precision, HYPRE_Solver solver );

HYPRE_Int
HYPRE_ParCSRHybridGetDSCGNumIterations_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *dscg_num_its );

HYPRE_Int
HYPRE_ParCSRHybridGetFinalRelativeResidualNorm_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *norm );

HYPRE_Int
HYPRE_ParCSRHybridGetNumIterations_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *num_its );

HYPRE_Int
HYPRE_ParCSRHybridGetPCGNumIterations_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *pcg_num_its );

HYPRE_Int
HYPRE_ParCSRHybridGetRecomputeResidual_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *recompute_residual );

HYPRE_Int
HYPRE_ParCSRHybridGetRecomputeResidualP_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *recompute_residual_p );

HYPRE_Int
HYPRE_ParCSRHybridGetSetupSolveTime_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *time );

HYPRE_Int
HYPRE_ParCSRHybridSetAbsoluteTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double tol );

HYPRE_Int
HYPRE_ParCSRHybridSetAggInterpType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int agg_interp_type );

HYPRE_Int
HYPRE_ParCSRHybridSetAggNumLevels_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int agg_num_levels );

HYPRE_Int
HYPRE_ParCSRHybridSetCoarsenType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int coarsen_type );

HYPRE_Int
HYPRE_ParCSRHybridSetConvergenceTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double cf_tol );

HYPRE_Int
HYPRE_ParCSRHybridSetCycleNumSweeps_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int num_sweeps, HYPRE_Int k );

HYPRE_Int
HYPRE_ParCSRHybridSetCycleRelaxType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int relax_type, HYPRE_Int k );

HYPRE_Int
HYPRE_ParCSRHybridSetCycleType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int cycle_type );

HYPRE_Int
HYPRE_ParCSRHybridSetDSCGMaxIter_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int dscg_max_its );

HYPRE_Int
HYPRE_ParCSRHybridSetDofFunc_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *dof_func );

HYPRE_Int
HYPRE_ParCSRHybridSetGridRelaxPoints_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int **grid_relax_points );

HYPRE_Int
HYPRE_ParCSRHybridSetGridRelaxType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *grid_relax_type );

HYPRE_Int
HYPRE_ParCSRHybridSetInterpType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int interp_type );

HYPRE_Int
HYPRE_ParCSRHybridSetKDim_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int k_dim );

HYPRE_Int
HYPRE_ParCSRHybridSetKeepTranspose_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int keepT );

HYPRE_Int
HYPRE_ParCSRHybridSetLevelOuterWt_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double outer_wt, HYPRE_Int level );

HYPRE_Int
HYPRE_ParCSRHybridSetLevelRelaxWt_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double relax_wt, HYPRE_Int level );

HYPRE_Int
HYPRE_ParCSRHybridSetLogging_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int logging );

HYPRE_Int
HYPRE_ParCSRHybridSetMaxCoarseSize_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int max_coarse_size );

HYPRE_Int
HYPRE_ParCSRHybridSetMaxLevels_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int max_levels );

HYPRE_Int
HYPRE_ParCSRHybridSetMaxRowSum_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double max_row_sum );

HYPRE_Int
HYPRE_ParCSRHybridSetMeasureType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int measure_type );

HYPRE_Int
HYPRE_ParCSRHybridSetMinCoarseSize_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int min_coarse_size );

HYPRE_Int
HYPRE_ParCSRHybridSetNodal_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int nodal );

HYPRE_Int
HYPRE_ParCSRHybridSetNonGalerkinTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int num_levels, void *nongalerkin_tol );

HYPRE_Int
HYPRE_ParCSRHybridSetNumFunctions_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int num_functions );

HYPRE_Int
HYPRE_ParCSRHybridSetNumGridSweeps_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *num_grid_sweeps );

HYPRE_Int
HYPRE_ParCSRHybridSetNumPaths_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int num_paths );

HYPRE_Int
HYPRE_ParCSRHybridSetNumSweeps_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int num_sweeps );

HYPRE_Int
HYPRE_ParCSRHybridSetOmega_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *omega );

HYPRE_Int
HYPRE_ParCSRHybridSetOuterWt_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double outer_wt );

HYPRE_Int
HYPRE_ParCSRHybridSetPCGMaxIter_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int pcg_max_its );

HYPRE_Int
HYPRE_ParCSRHybridSetPMaxElmts_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int P_max_elmts );

HYPRE_Int
HYPRE_ParCSRHybridSetPrecond_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_PtrToParSolverFcn precond, HYPRE_PtrToParSolverFcn precond_setup, HYPRE_Solver precond_solver );

HYPRE_Int
HYPRE_ParCSRHybridSetPrintLevel_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int print_level );

HYPRE_Int
HYPRE_ParCSRHybridSetRecomputeResidual_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int recompute_residual );

HYPRE_Int
HYPRE_ParCSRHybridSetRecomputeResidualP_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int recompute_residual_p );

HYPRE_Int
HYPRE_ParCSRHybridSetRelChange_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int rel_change );

HYPRE_Int
HYPRE_ParCSRHybridSetRelaxOrder_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int relax_order );

HYPRE_Int
HYPRE_ParCSRHybridSetRelaxType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int relax_type );

HYPRE_Int
HYPRE_ParCSRHybridSetRelaxWeight_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *relax_weight );

HYPRE_Int
HYPRE_ParCSRHybridSetRelaxWt_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double relax_wt );

HYPRE_Int
HYPRE_ParCSRHybridSetSeqThreshold_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int seq_threshold );

HYPRE_Int
HYPRE_ParCSRHybridSetSetupType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int setup_type );

HYPRE_Int
HYPRE_ParCSRHybridSetSolverType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int solver_type );

HYPRE_Int
HYPRE_ParCSRHybridSetStopCrit_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int stop_crit );

HYPRE_Int
HYPRE_ParCSRHybridSetStrongThreshold_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double strong_threshold );

HYPRE_Int
HYPRE_ParCSRHybridSetTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double tol );

HYPRE_Int
HYPRE_ParCSRHybridSetTruncFactor_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double trunc_factor );

HYPRE_Int
HYPRE_ParCSRHybridSetTwoNorm_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int two_norm );

HYPRE_Int
HYPRE_ParCSRHybridSetup_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );

HYPRE_Int
HYPRE_ParCSRHybridSolve_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );

HYPRE_Int
HYPRE_ParCSRLGMRESCreate_pre( HYPRE_Precision precision, MPI_Comm comm, HYPRE_Solver *solver );

HYPRE_Int
HYPRE_ParCSRLGMRESDestroy_pre( HYPRE_Precision precision, HYPRE_Solver solver );

HYPRE_Int
HYPRE_ParCSRLGMRESGetFinalRelativeResidualNorm_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *norm );

HYPRE_Int
HYPRE_ParCSRLGMRESGetNumIterations_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *num_iterations );

HYPRE_Int
HYPRE_ParCSRLGMRESGetPrecond_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Solver *precond_data );

HYPRE_Int
HYPRE_ParCSRLGMRESGetResidual_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParVector *residual );

HYPRE_Int
HYPRE_ParCSRLGMRESSetAbsoluteTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double a_tol );

HYPRE_Int
HYPRE_ParCSRLGMRESSetAugDim_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int aug_dim );

HYPRE_Int
HYPRE_ParCSRLGMRESSetKDim_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int k_dim );

HYPRE_Int
HYPRE_ParCSRLGMRESSetLogging_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int logging );

HYPRE_Int
HYPRE_ParCSRLGMRESSetMaxIter_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int max_iter );

HYPRE_Int
HYPRE_ParCSRLGMRESSetMinIter_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int min_iter );

HYPRE_Int
HYPRE_ParCSRLGMRESSetPrecond_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_PtrToParSolverFcn precond, HYPRE_PtrToParSolverFcn precond_setup, HYPRE_Solver precond_solver );

HYPRE_Int
HYPRE_ParCSRLGMRESSetPrintLevel_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int print_level );

HYPRE_Int
HYPRE_ParCSRLGMRESSetTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double tol );

HYPRE_Int
HYPRE_ParCSRLGMRESSetup_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );

HYPRE_Int
HYPRE_ParCSRLGMRESSolve_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );

HYPRE_Int
HYPRE_ParCSRMultiVectorPrint_pre( HYPRE_Precision precision, void *x_, const char *fileName );

void *
HYPRE_ParCSRMultiVectorRead_pre( HYPRE_Precision precision, MPI_Comm comm, void *ii_, const char *fileName );

HYPRE_Int
HYPRE_ParCSROnProcTriSetup_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix HA, HYPRE_ParVector Hy, HYPRE_ParVector Hx );

HYPRE_Int
HYPRE_ParCSROnProcTriSolve_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix HA, HYPRE_ParVector Hy, HYPRE_ParVector Hx );

HYPRE_Int
HYPRE_ParCSRPCGCreate_pre( HYPRE_Precision precision, MPI_Comm comm, HYPRE_Solver *solver );

HYPRE_Int
HYPRE_ParCSRPCGDestroy_pre( HYPRE_Precision precision, HYPRE_Solver solver );

HYPRE_Int
HYPRE_ParCSRPCGGetFinalRelativeResidualNorm_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *norm );

HYPRE_Int
HYPRE_ParCSRPCGGetNumIterations_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *num_iterations );

HYPRE_Int
HYPRE_ParCSRPCGGetPrecond_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Solver *precond_data );

HYPRE_Int
HYPRE_ParCSRPCGGetResidual_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParVector *residual );

HYPRE_Int
HYPRE_ParCSRPCGSetAbsoluteTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double tol );

HYPRE_Int
HYPRE_ParCSRPCGSetLogging_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int logging );

HYPRE_Int
HYPRE_ParCSRPCGSetMaxIter_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int max_iter );

HYPRE_Int
HYPRE_ParCSRPCGSetPrecond_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_PtrToParSolverFcn precond, HYPRE_PtrToParSolverFcn precond_setup, HYPRE_Solver precond_solver );

HYPRE_Int
HYPRE_ParCSRPCGSetPreconditioner_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Solver precond );

HYPRE_Int
HYPRE_ParCSRPCGSetPrintLevel_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int print_level );

HYPRE_Int
HYPRE_ParCSRPCGSetRelChange_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int rel_change );

HYPRE_Int
HYPRE_ParCSRPCGSetStopCrit_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int stop_crit );

HYPRE_Int
HYPRE_ParCSRPCGSetTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double tol );

HYPRE_Int
HYPRE_ParCSRPCGSetTwoNorm_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int two_norm );

HYPRE_Int
HYPRE_ParCSRPCGSetup_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );

HYPRE_Int
HYPRE_ParCSRPCGSolve_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );

HYPRE_Int
HYPRE_ParCSRParaSailsCreate_pre( HYPRE_Precision precision, MPI_Comm comm, HYPRE_Solver *solver );

HYPRE_Int
HYPRE_ParCSRParaSailsDestroy_pre( HYPRE_Precision precision, HYPRE_Solver solver );

HYPRE_Int
HYPRE_ParCSRParaSailsSetFilter_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double filter );

HYPRE_Int
HYPRE_ParCSRParaSailsSetLoadbal_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double loadbal );

HYPRE_Int
HYPRE_ParCSRParaSailsSetLogging_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int logging );

HYPRE_Int
HYPRE_ParCSRParaSailsSetParams_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double thresh, HYPRE_Int nlevels );

HYPRE_Int
HYPRE_ParCSRParaSailsSetReuse_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int reuse );

HYPRE_Int
HYPRE_ParCSRParaSailsSetSym_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int sym );

HYPRE_Int
HYPRE_ParCSRParaSailsSetup_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );

HYPRE_Int
HYPRE_ParCSRParaSailsSolve_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );

HYPRE_Int
HYPRE_ParCSRPilutCreate_pre( HYPRE_Precision precision, MPI_Comm comm, HYPRE_Solver *solver );

HYPRE_Int
HYPRE_ParCSRPilutDestroy_pre( HYPRE_Precision precision, HYPRE_Solver solver );

HYPRE_Int
HYPRE_ParCSRPilutSetDropTolerance_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double tol );

HYPRE_Int
HYPRE_ParCSRPilutSetFactorRowSize_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int size );

HYPRE_Int
HYPRE_ParCSRPilutSetLogging_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int logging );

HYPRE_Int
HYPRE_ParCSRPilutSetMaxIter_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int max_iter );

HYPRE_Int
HYPRE_ParCSRPilutSetup_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );

HYPRE_Int
HYPRE_ParCSRPilutSolve_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );

HYPRE_Int
HYPRE_ParCSRSetupInterpreter_pre( HYPRE_Precision precision, mv_InterfaceInterpreter *i );

HYPRE_Int
HYPRE_ParCSRSetupMatvec_pre( HYPRE_Precision precision, HYPRE_MatvecFunctions *mv );

HYPRE_Int
HYPRE_ParaSailsBuildIJMatrix_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_IJMatrix *pij_A );

HYPRE_Int
HYPRE_ParaSailsCreate_pre( HYPRE_Precision precision, MPI_Comm comm, HYPRE_Solver *solver );

HYPRE_Int
HYPRE_ParaSailsDestroy_pre( HYPRE_Precision precision, HYPRE_Solver solver );

HYPRE_Int
HYPRE_ParaSailsGetFilter_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *filter );

HYPRE_Int
HYPRE_ParaSailsGetLoadbal_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *loadbal );

HYPRE_Int
HYPRE_ParaSailsGetLogging_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *logging );

HYPRE_Int
HYPRE_ParaSailsGetNlevels_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *nlevels );

HYPRE_Int
HYPRE_ParaSailsGetReuse_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *reuse );

HYPRE_Int
HYPRE_ParaSailsGetSym_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *sym );

HYPRE_Int
HYPRE_ParaSailsGetThresh_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *thresh );

HYPRE_Int
HYPRE_ParaSailsSetFilter_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double filter );

HYPRE_Int
HYPRE_ParaSailsSetLoadbal_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double loadbal );

HYPRE_Int
HYPRE_ParaSailsSetLogging_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int logging );

HYPRE_Int
HYPRE_ParaSailsSetNlevels_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int nlevels );

HYPRE_Int
HYPRE_ParaSailsSetParams_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double thresh, HYPRE_Int nlevels );

HYPRE_Int
HYPRE_ParaSailsSetReuse_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int reuse );

HYPRE_Int
HYPRE_ParaSailsSetSym_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int sym );

HYPRE_Int
HYPRE_ParaSailsSetThresh_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double thresh );

HYPRE_Int
HYPRE_ParaSailsSetup_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );

HYPRE_Int
HYPRE_ParaSailsSolve_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );

HYPRE_Int
HYPRE_SchwarzCreate_pre( HYPRE_Precision precision, HYPRE_Solver *solver );

HYPRE_Int
HYPRE_SchwarzDestroy_pre( HYPRE_Precision precision, HYPRE_Solver solver );

HYPRE_Int
HYPRE_SchwarzSetDofFunc_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *dof_func );

HYPRE_Int
HYPRE_SchwarzSetDomainStructure_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_CSRMatrix domain_structure );

HYPRE_Int
HYPRE_SchwarzSetDomainType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int domain_type );

HYPRE_Int
HYPRE_SchwarzSetNonSymm_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int use_nonsymm );

HYPRE_Int
HYPRE_SchwarzSetNumFunctions_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int num_functions );

HYPRE_Int
HYPRE_SchwarzSetOverlap_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int overlap );

HYPRE_Int
HYPRE_SchwarzSetRelaxWeight_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double relax_weight );

HYPRE_Int
HYPRE_SchwarzSetVariant_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int variant );

HYPRE_Int
HYPRE_SchwarzSetup_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );

HYPRE_Int
HYPRE_SchwarzSolve_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x );

HYPRE_Int
HYPRE_TempParCSRSetupInterpreter_pre( HYPRE_Precision precision, mv_InterfaceInterpreter *i );


#endif

#ifdef __cplusplus
}
#endif

#endif

