// Generated with hyprwayland-scanner 0.4.5. Made with vaxry's keyboard and ❤️.
// relative_pointer_unstable_v1

/*
 This protocol's authors' copyright notice is:


    Copyright © 2014      Jonas Ådahl
    Copyright © 2015      Red Hat Inc.

    Permission is hereby granted, free of charge, to any person obtaining a
    copy of this software and associated documentation files (the "Software"),
    to deal in the Software without restriction, including without limitation
    the rights to use, copy, modify, merge, publish, distribute, sublicense,
    and/or sell copies of the Software, and to permit persons to whom the
    Software is furnished to do so, subject to the following conditions:

    The above copyright notice and this permission notice (including the next
    paragraph) shall be included in all copies or substantial portions of the
    Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
    THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
    FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
    DEALINGS IN THE SOFTWARE.
  
*/

#define private public
#define HYPRWAYLAND_SCANNER_NO_INTERFACES
#include "relative-pointer-unstable-v1.hpp"
#undef private
#define F std::function

static const wl_interface* relativePointerUnstableV1_dummyTypes[] = { nullptr };

// Reference all other interfaces.
// The reason why this is in snake is to
// be able to cooperate with existing
// wayland_scanner interfaces (they are interop)
extern const wl_interface zwp_relative_pointer_manager_v1_interface;
extern const wl_interface zwp_relative_pointer_v1_interface;
extern const wl_interface wl_pointer_interface;

static void _CZwpRelativePointerManagerV1Destroy(wl_client* client, wl_resource* resource) {
    const auto PO = (CZwpRelativePointerManagerV1*)wl_resource_get_user_data(resource);
    if (PO && PO->requests.destroy)
        PO->requests.destroy(PO);
}

static void _CZwpRelativePointerManagerV1GetRelativePointer(wl_client* client, wl_resource* resource, uint32_t id, wl_resource* pointer) {
    const auto PO = (CZwpRelativePointerManagerV1*)wl_resource_get_user_data(resource);
    if (PO && PO->requests.getRelativePointer)
        PO->requests.getRelativePointer(PO, id, pointer);
}

static void _CZwpRelativePointerManagerV1__DestroyListener(wl_listener* l, void* d) {
    CZwpRelativePointerManagerV1DestroyWrapper *wrap = wl_container_of(l, wrap, listener);
    CZwpRelativePointerManagerV1* pResource = wrap->parent;
    pResource->onDestroyCalled();
}

static const void* _CZwpRelativePointerManagerV1VTable[] = {
    (void*)_CZwpRelativePointerManagerV1Destroy,
    (void*)_CZwpRelativePointerManagerV1GetRelativePointer,
};
static const wl_interface* _CZwpRelativePointerManagerV1GetRelativePointerTypes[] = {
    &zwp_relative_pointer_v1_interface,
    &wl_pointer_interface,
};

static const wl_message _CZwpRelativePointerManagerV1Requests[] = {
    { .name = "destroy", .signature = "", .types = relativePointerUnstableV1_dummyTypes + 0},
    { .name = "get_relative_pointer", .signature = "no", .types = _CZwpRelativePointerManagerV1GetRelativePointerTypes + 0},
};

const wl_interface zwp_relative_pointer_manager_v1_interface = {
    .name = "zwp_relative_pointer_manager_v1", .version = 1,
    .method_count = 2, .methods = _CZwpRelativePointerManagerV1Requests,
    .event_count = 0, .events = nullptr,
};

CZwpRelativePointerManagerV1::CZwpRelativePointerManagerV1(wl_client* client, uint32_t version, uint32_t id) :
    pResource(wl_resource_create(client, &zwp_relative_pointer_manager_v1_interface, version, id)) {

    if (!pResource)
        return;

    wl_resource_set_user_data(pResource, this);
    wl_list_init(&resourceDestroyListener.listener.link);
    resourceDestroyListener.listener.notify = _CZwpRelativePointerManagerV1__DestroyListener;
    resourceDestroyListener.parent = this;
    wl_resource_add_destroy_listener(pResource, &resourceDestroyListener.listener);

    wl_resource_set_implementation(pResource, _CZwpRelativePointerManagerV1VTable, this, nullptr);
}

CZwpRelativePointerManagerV1::~CZwpRelativePointerManagerV1() {
    wl_list_remove(&resourceDestroyListener.listener.link);
    wl_list_init(&resourceDestroyListener.listener.link);

    // if we still own the wayland resource,
    // it means we need to destroy it.
    if (pResource && wl_resource_get_user_data(pResource) == this) {
        wl_resource_set_user_data(pResource, nullptr);
        wl_resource_destroy(pResource);
    }
}

void CZwpRelativePointerManagerV1::onDestroyCalled() {
    wl_resource_set_user_data(pResource, nullptr);
    wl_list_remove(&resourceDestroyListener.listener.link);
    wl_list_init(&resourceDestroyListener.listener.link);

    // set the resource to nullptr,
    // as it will be freed. If the consumer does not destroy this resource
    // in onDestroy here, we'd be doing a UAF in the ~dtor
    pResource = nullptr;

    if (onDestroy)
        onDestroy(this);
}

void CZwpRelativePointerManagerV1::setDestroy(F<void(CZwpRelativePointerManagerV1*)> handler) {
    requests.destroy = handler;
}

void CZwpRelativePointerManagerV1::setGetRelativePointer(F<void(CZwpRelativePointerManagerV1*, uint32_t, wl_resource*)> handler) {
    requests.getRelativePointer = handler;
}

static void _CZwpRelativePointerV1Destroy(wl_client* client, wl_resource* resource) {
    const auto PO = (CZwpRelativePointerV1*)wl_resource_get_user_data(resource);
    if (PO && PO->requests.destroy)
        PO->requests.destroy(PO);
}

static void _CZwpRelativePointerV1__DestroyListener(wl_listener* l, void* d) {
    CZwpRelativePointerV1DestroyWrapper *wrap = wl_container_of(l, wrap, listener);
    CZwpRelativePointerV1* pResource = wrap->parent;
    pResource->onDestroyCalled();
}

static const void* _CZwpRelativePointerV1VTable[] = {
    (void*)_CZwpRelativePointerV1Destroy,
};

void CZwpRelativePointerV1::sendRelativeMotion(uint32_t utime_hi, uint32_t utime_lo, wl_fixed_t dx, wl_fixed_t dy, wl_fixed_t dx_unaccel, wl_fixed_t dy_unaccel) {
    if (!pResource)
        return;
    wl_resource_post_event(pResource, 0, utime_hi, utime_lo, dx, dy, dx_unaccel, dy_unaccel);
}

void CZwpRelativePointerV1::sendRelativeMotionRaw(uint32_t utime_hi, uint32_t utime_lo, wl_fixed_t dx, wl_fixed_t dy, wl_fixed_t dx_unaccel, wl_fixed_t dy_unaccel) {
    if (!pResource)
        return;
    wl_resource_post_event(pResource, 0, utime_hi, utime_lo, dx, dy, dx_unaccel, dy_unaccel);
}
static const wl_interface* _CZwpRelativePointerV1RelativeMotionTypes[] = {
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
};

static const wl_message _CZwpRelativePointerV1Requests[] = {
    { .name = "destroy", .signature = "", .types = relativePointerUnstableV1_dummyTypes + 0},
};

static const wl_message _CZwpRelativePointerV1Events[] = {
    { .name = "relative_motion", .signature = "uuffff", .types = _CZwpRelativePointerV1RelativeMotionTypes + 0},
};

const wl_interface zwp_relative_pointer_v1_interface = {
    .name = "zwp_relative_pointer_v1", .version = 1,
    .method_count = 1, .methods = _CZwpRelativePointerV1Requests,
    .event_count = 1, .events = _CZwpRelativePointerV1Events,
};

CZwpRelativePointerV1::CZwpRelativePointerV1(wl_client* client, uint32_t version, uint32_t id) :
    pResource(wl_resource_create(client, &zwp_relative_pointer_v1_interface, version, id)) {

    if (!pResource)
        return;

    wl_resource_set_user_data(pResource, this);
    wl_list_init(&resourceDestroyListener.listener.link);
    resourceDestroyListener.listener.notify = _CZwpRelativePointerV1__DestroyListener;
    resourceDestroyListener.parent = this;
    wl_resource_add_destroy_listener(pResource, &resourceDestroyListener.listener);

    wl_resource_set_implementation(pResource, _CZwpRelativePointerV1VTable, this, nullptr);
}

CZwpRelativePointerV1::~CZwpRelativePointerV1() {
    wl_list_remove(&resourceDestroyListener.listener.link);
    wl_list_init(&resourceDestroyListener.listener.link);

    // if we still own the wayland resource,
    // it means we need to destroy it.
    if (pResource && wl_resource_get_user_data(pResource) == this) {
        wl_resource_set_user_data(pResource, nullptr);
        wl_resource_destroy(pResource);
    }
}

void CZwpRelativePointerV1::onDestroyCalled() {
    wl_resource_set_user_data(pResource, nullptr);
    wl_list_remove(&resourceDestroyListener.listener.link);
    wl_list_init(&resourceDestroyListener.listener.link);

    // set the resource to nullptr,
    // as it will be freed. If the consumer does not destroy this resource
    // in onDestroy here, we'd be doing a UAF in the ~dtor
    pResource = nullptr;

    if (onDestroy)
        onDestroy(this);
}

void CZwpRelativePointerV1::setDestroy(F<void(CZwpRelativePointerV1*)> handler) {
    requests.destroy = handler;
}

#undef F
