/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.core.internal.env;

import com.sun.mirror.apt.Filer;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.apt.core.env.Phase;
import org.eclipse.jdt.apt.core.internal.AptPlugin;
import org.eclipse.jdt.apt.core.internal.env.AbstractCompilationEnv;
import org.eclipse.jdt.apt.core.internal.env.BinaryFileOutputStream;
import org.eclipse.jdt.apt.core.internal.env.BuildEnv;
import org.eclipse.jdt.apt.core.internal.env.EncodedFileOutputStream;
import org.eclipse.jdt.apt.core.internal.env.FilerImpl;
import org.eclipse.jdt.apt.core.internal.env.NoOpOutputStream;
import org.eclipse.jdt.apt.core.internal.env.NoOpPrintWriter;
import org.eclipse.jdt.apt.core.internal.generatedfile.GeneratedSourceFolderManager;

public class BuildFilerImpl
extends FilerImpl {
    private boolean _generatedClassFiles = false;
    private final BuildEnv _env;

    public BuildFilerImpl(BuildEnv env) {
        this._env = env;
    }

    @Override
    public OutputStream createClassFile(String typeName) throws IOException {
        IPath path;
        if (typeName == null) {
            throw new IllegalArgumentException("Type name cannot be null");
        }
        if ("".equals(typeName)) {
            throw new IllegalArgumentException("Type name cannot be empty");
        }
        this._env.checkValid();
        try {
            this._env.validateTypeName(typeName);
        }
        catch (CoreException e) {
            throw new IOException(e);
        }
        this._generatedClassFiles = true;
        if (this._env.getPhase() == Phase.RECONCILE) {
            return new NoOpOutputStream();
        }
        GeneratedSourceFolderManager gsfm = this._env.getAptProject().getGeneratedSourceFolderManager(this._env.isTestCode());
        try {
            path = gsfm.getBinaryOutputLocation();
        }
        catch (Exception e) {
            AptPlugin.log(e, "Failure getting the output file");
            throw new IOException(e);
        }
        path = path.append(typeName.replace('.', File.separatorChar) + ".class");
        IFile file = this.getEnv().getProject().getFile(path);
        return new BinaryFileOutputStream(file, this._env);
    }

    public boolean hasGeneratedClassFile() {
        return this._generatedClassFiles;
    }

    @Override
    public PrintWriter createTextFile(Filer.Location loc, String pkg, File relPath, String charsetName) throws IOException {
        if (relPath == null) {
            throw new IllegalArgumentException("Path cannot be null");
        }
        if ("".equals(relPath.getPath())) {
            throw new IllegalArgumentException("Path cannot be empty");
        }
        this._env.checkValid();
        if (this._env.getPhase() == Phase.RECONCILE) {
            return new NoOpPrintWriter();
        }
        IPath path = this.getOutputFileForLocation(loc, pkg, relPath);
        IFile file = this._env.getProject().getFile(path);
        this.validateFile(file);
        EncodedFileOutputStream binaryOut = new EncodedFileOutputStream(file, this._env, charsetName);
        if (charsetName == null) {
            return new PrintWriter(binaryOut);
        }
        OutputStreamWriter outWriter = new OutputStreamWriter((OutputStream)binaryOut, charsetName);
        return new PrintWriter(outWriter);
    }

    @Override
    public OutputStream createBinaryFile(Filer.Location loc, String pkg, File relPath) throws IOException {
        if (relPath == null) {
            throw new IllegalArgumentException("Path cannot be null");
        }
        if ("".equals(relPath.getPath())) {
            throw new IllegalArgumentException("Path cannot be empty");
        }
        this._env.checkValid();
        if (this._env.getPhase() == Phase.RECONCILE) {
            return new NoOpOutputStream();
        }
        IPath path = this.getOutputFileForLocation(loc, pkg, relPath);
        IFile file = this._env.getProject().getFile(path);
        this.validateFile(file);
        return new BinaryFileOutputStream(file, this._env);
    }

    @Override
    protected AbstractCompilationEnv getEnv() {
        return this._env;
    }

    private void validateFile(IFile file) throws IOException {
        IStatus status = file.getWorkspace().validatePath(file.getFullPath().toOSString(), 1);
        if (!status.isOK()) {
            CoreException ce = new CoreException(status);
            throw new IOException("Invalid file name", ce);
        }
    }
}

