"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const base_command_1 = require("./base-command");
const app_1 = require("./app");
const locale_1 = require("@joplin/lib/locale");
const BaseModel_1 = require("@joplin/lib/BaseModel");
const shim_1 = require("@joplin/lib/shim");
class Command extends base_command_1.default {
    usage() {
        return 'attach <note> <file>';
    }
    description() {
        return (0, locale_1._)('Attaches the given file to the note.');
    }
    // eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
    async action(args) {
        const title = args['note'];
        const note = await (0, app_1.default)().loadItem(BaseModel_1.default.TYPE_NOTE, title, { parent: (0, app_1.default)().currentFolder() });
        this.encryptionCheck(note);
        if (!note)
            throw new Error((0, locale_1._)('Cannot find "%s".', title));
        const localFilePath = args['file'];
        await shim_1.default.attachFileToNote(note, localFilePath);
    }
}
module.exports = Command;
//# sourceMappingURL=command-attach.js.map