"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.runtime = exports.declaration = void 0;
const getActivePluginEditorView_1 = require("../services/plugins/utils/getActivePluginEditorView");
const Logger_1 = require("@joplin/utils/Logger");
const getActivePluginEditorViews_1 = require("../services/plugins/utils/getActivePluginEditorViews");
const PluginService_1 = require("../services/plugins/PluginService");
const Setting_1 = require("../models/Setting");
const logger = Logger_1.default.create('showEditorPlugin');
exports.declaration = {
    name: 'showEditorPlugin',
    label: () => 'Show editor plugin',
    iconName: 'fas fa-eye',
};
const runtime = () => {
    return {
        execute: async (context, editorViewId = '', show = true) => {
            logger.info('View:', editorViewId, 'Show:', show);
            const pluginStates = context.state.pluginService.plugins;
            const windowId = context.state.windowId;
            if (!editorViewId) {
                const { editorPlugin, editorView } = (0, getActivePluginEditorView_1.default)(pluginStates, windowId);
                if (!editorPlugin) {
                    logger.warn('No editor plugin to toggle to');
                    return;
                }
                editorViewId = editorView.id;
            }
            const activePlugins = (0, getActivePluginEditorViews_1.default)(pluginStates, windowId);
            const editorPluginData = activePlugins.find(({ editorView }) => editorView.id === editorViewId);
            if (!editorPluginData) {
                logger.warn(`No editor view with ID ${editorViewId} is active.`);
                return;
            }
            const { editorView } = editorPluginData;
            const controller = PluginService_1.default.instance().viewControllerByViewId(editorView.id);
            if (!controller) {
                throw new Error(`No controller registered for editor view ${editorView.id}`);
            }
            const previousVisible = editorView.parentWindowId === windowId && controller.isVisible();
            if (show && previousVisible) {
                logger.info(`Editor is already visible: ${editorViewId}`);
                return;
            }
            else if (!show && !previousVisible) {
                logger.info(`Editor is already hidden: ${editorViewId}`);
                return;
            }
            const getUpdatedShownViewIds = () => {
                let newShownViewTypeIds = [...Setting_1.default.value('plugins.shownEditorViewIds')];
                // Always filter out the current view, even if show is false. This prevents
                // the view ID from being present multiple times.
                const viewIdsWithoutCurrent = newShownViewTypeIds.filter(id => id !== editorView.editorTypeId);
                newShownViewTypeIds = viewIdsWithoutCurrent;
                if (show) {
                    newShownViewTypeIds.push(editorView.editorTypeId);
                }
                return newShownViewTypeIds;
            };
            Setting_1.default.setValue('plugins.shownEditorViewIds', getUpdatedShownViewIds());
            controller.setOpened(show);
        },
    };
};
exports.runtime = runtime;
//# sourceMappingURL=showEditorPlugin.js.map