"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const PluginService_1 = require("../../services/plugins/PluginService");
const Logger_1 = require("@joplin/utils/Logger");
const shim_1 = require("../../shim");
const logger = Logger_1.default.create('usePlugin');
const usePlugin = (pluginId) => {
    const React = shim_1.default.react();
    const [pluginReloadCounter, setPluginReloadCounter] = React.useState(0);
    const plugin = React.useMemo(() => {
        if (!PluginService_1.default.instance().pluginIds.includes(pluginId)) {
            return null;
        }
        if (pluginReloadCounter > 0) {
            logger.debug('Reloading plugin', pluginId, 'because the set of loaded plugins changed.');
        }
        return PluginService_1.default.instance().pluginById(pluginId);
        // The dependency on pluginReloadCounter is important -- it ensures that the plugin
        // matches the one loaded in the PluginService.
    }, [pluginId, pluginReloadCounter]);
    const reloadCounterRef = React.useRef(0);
    reloadCounterRef.current = pluginReloadCounter;
    // The plugin may need to be re-fetched from the PluginService. When a plugin is reloaded,
    // its Plugin object is replaced with a new one.
    React.useEffect(() => {
        const { remove } = PluginService_1.default.instance().addLoadedPluginsChangeListener(() => {
            setPluginReloadCounter(reloadCounterRef.current + 1);
        });
        return () => {
            remove();
        };
    }, []);
    return plugin;
};
exports.default = usePlugin;
//# sourceMappingURL=usePlugin.js.map