"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = default_1;
const shim_1 = require("../shim");
const { useEffect } = shim_1.default.react();
// eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
function default_1(effect, dependencies) {
    useEffect(() => {
        const onCleanupCallbacks = [];
        const event = {
            cancelled: false,
            onCleanup: (callback) => {
                if (event.cancelled) {
                    callback();
                }
                else {
                    onCleanupCallbacks.push(callback);
                }
            },
        };
        void effect(event);
        return () => {
            event.cancelled = true;
            for (const callback of onCleanupCallbacks) {
                callback();
            }
        };
        // eslint-disable-next-line @seiyab/react-hooks/exhaustive-deps -- Old code before rule was applied
    }, dependencies);
}
//# sourceMappingURL=useAsyncEffect.js.map