"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const BaseModel_1 = require("../../BaseModel");
const trash_1 = require("../../services/trash");
const restoreItems_1 = require("../../services/trash/restoreItems");
const Folder_1 = require("../Folder");
const Note_1 = require("../Note");
const rootFolder = {
    id: '',
    deleted_time: 0,
    type_: BaseModel_1.ModelType.Folder,
};
exports.default = async (noteIds, folderIds, targetFolderId) => {
    let targetFolder;
    if (targetFolderId !== '') {
        targetFolder = await Folder_1.default.load(targetFolderId, { fields: ['id', 'deleted_time'] });
    }
    else {
        targetFolder = rootFolder;
    }
    if (!targetFolder)
        throw new Error(`No such folder: ${targetFolderId}`);
    const defaultDeleteOptions = { toTrash: true, sourceDescription: 'onFolderDrop' };
    if (targetFolder.id !== (0, trash_1.getTrashFolderId)()) {
        defaultDeleteOptions.toTrashParentId = targetFolder.id;
    }
    async function processList(itemType, itemIds) {
        const ModelClass = itemType === BaseModel_1.ModelType.Note ? Note_1.default : Folder_1.default;
        const items = await ModelClass.byIds(itemIds, { fields: ['id', 'deleted_time', 'parent_id'] });
        for (const item of items) {
            if (item.id === targetFolder.id)
                continue;
            if (targetFolder.deleted_time || targetFolder.id === (0, trash_1.getTrashFolderId)()) {
                if (item.deleted_time && targetFolder.id === (0, trash_1.getTrashFolderId)()) {
                    await ModelClass.delete(item.id, Object.assign(Object.assign({}, defaultDeleteOptions), { toTrashParentId: '' }));
                }
                else {
                    await ModelClass.delete(item.id, defaultDeleteOptions);
                }
            }
            else if (item.deleted_time && !targetFolder.deleted_time) {
                await (0, restoreItems_1.default)(itemType, [item], { targetFolderId: targetFolder.id });
            }
            else {
                await ModelClass.moveToFolder(item.id, targetFolderId);
            }
        }
    }
    await processList(BaseModel_1.ModelType.Note, noteIds);
    await processList(BaseModel_1.ModelType.Folder, folderIds);
};
//# sourceMappingURL=onFolderDrop.js.map