"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const _1 = require(".");
const Setting_1 = require("../../models/Setting");
exports.default = async (rootProfileDir) => {
    const profileConfig = await (0, _1.loadProfileConfig)(`${rootProfileDir}/profiles.json`);
    const profileDir = (0, _1.getProfileFullPath)((0, _1.getCurrentProfile)(profileConfig), rootProfileDir);
    const isSub = (0, _1.isSubProfile)((0, _1.getCurrentProfile)(profileConfig));
    Setting_1.default.setConstant('isSubProfile', isSub);
    Setting_1.default.setConstant('rootProfileDir', rootProfileDir);
    Setting_1.default.setConstant('profileDir', profileDir);
    return {
        profileConfig,
        profileDir,
        isSubProfile: isSub,
    };
};
//# sourceMappingURL=initProfile.js.map