"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = cssToTheme;
// Need to include it that way due to a bug in the lib:
// https://github.com/reworkcss/css/pull/146#issuecomment-740412799
const css_tools_1 = require("@adobe/css-tools");
function formatCssToThemeVariable(cssVariable) {
    const elements = cssVariable.substr(2).split('-');
    if (elements[0] !== 'joplin')
        throw new Error(`CSS variable name must start with "--joplin": ${cssVariable}`);
    elements.splice(0, 1);
    return elements.map((e, i) => {
        const c = i === 0 ? e[0] : e[0].toUpperCase();
        return c + e.substr(1);
    }).join('');
}
// function unquoteValue(v:string):string {
// 	if (v.startsWith("'") && v.endsWith("'") || v.startsWith('"') && v.endsWith('"')) return v.substr(1, v.length - 2);
// 	return v;
// }
function cssToTheme(css, sourceFilePath) {
    var _a;
    const o = (0, css_tools_1.parse)(css, {
        silent: false,
        source: sourceFilePath,
    });
    const rules = (_a = o === null || o === void 0 ? void 0 : o.stylesheet) === null || _a === void 0 ? void 0 : _a.rules;
    if (!(rules === null || rules === void 0 ? void 0 : rules.length))
        throw new Error(`Invalid CSS color file: ${sourceFilePath}`);
    let rootRule = null;
    for (const rule of rules) {
        if (rule.type === css_tools_1.CssTypes.rule) {
            rootRule = rule;
            break;
        }
    }
    if (!rootRule || !rootRule.selectors.includes(':root'))
        throw new Error('`:root` rule not found');
    // eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
    const declarations = rootRule.declarations;
    // eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
    const output = {};
    for (const declaration of declarations) {
        if (declaration.type !== 'declaration')
            continue; // Skip comment lines
        output[formatCssToThemeVariable(declaration.property)] = declaration.value;
    }
    return output;
}
//# sourceMappingURL=cssToTheme.js.map