"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = default_1;
const MdToHtml_1 = require("../MdToHtml");
const utils = require("../utils");
const createEventHandlingAttrs_1 = require("./createEventHandlingAttrs");
const Entities = require('html-entities').AllHtmlEntities;
const htmlentities = new Entities().encode;
const urlUtils = require('../urlUtils.js');
const { getClassNameForMimeType } = require('font-awesome-filetypes');
function default_1(href, options = null) {
    var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k;
    options = Object.assign({}, options);
    (_a = options.title) !== null && _a !== void 0 ? _a : (options.title = '');
    (_b = options.resources) !== null && _b !== void 0 ? _b : (options.resources = {});
    (_c = options.ResourceModel) !== null && _c !== void 0 ? _c : (options.ResourceModel = null);
    (_d = options.linkRenderingType) !== null && _d !== void 0 ? _d : (options.linkRenderingType = MdToHtml_1.LinkRenderingType.JavaScriptHandler);
    (_e = options.plainResourceRendering) !== null && _e !== void 0 ? _e : (options.plainResourceRendering = false);
    (_f = options.postMessageSyntax) !== null && _f !== void 0 ? _f : (options.postMessageSyntax = 'postMessage');
    (_g = options.enableLongPress) !== null && _g !== void 0 ? _g : (options.enableLongPress = false);
    const resourceHrefInfo = urlUtils.parseResourceUrl(href);
    const isResourceUrl = options.resources && !!resourceHrefInfo;
    let title = options.title;
    let resourceIdAttr = '';
    let icon = '';
    let hrefAttr = '#';
    let mime = '';
    let resourceId = '';
    let resource = null;
    if (isResourceUrl) {
        resourceId = resourceHrefInfo.itemId;
        const result = options.resources[resourceId];
        const resourceStatus = utils.resourceStatus(options.ResourceModel, result);
        if (result && result.item) {
            if (!title)
                title = result.item.title;
            mime = result.item.mime;
            resource = result.item;
        }
        if (result && resourceStatus !== 'ready' && !options.plainResourceRendering) {
            const icon = utils.resourceStatusFile(resourceStatus);
            return {
                resourceReady: false,
                html: `<a class="not-loaded-resource resource-status-${resourceStatus}" data-resource-id="${resourceId}">` + `<img src="data:image/svg+xml;utf8,${htmlentities(icon)}"/>`,
                resource,
                resourceFullPath: null,
            };
        }
        else {
            // If we are rendering a note link, we'll get here too, so in that
            // case "resourceId" would actually be the note ID.
            href = `joplin://${resourceId}`;
            if (resourceHrefInfo.hash)
                href += `#${resourceHrefInfo.hash}`;
            resourceIdAttr = `data-resource-id='${resourceId}'`;
            const iconType = mime ? getClassNameForMimeType(mime) : 'fa-joplin';
            // Icons are defined in lib/renderers/noteStyle using inline svg
            // The icons are taken from fork-awesome but use the font-awesome naming scheme in order
            // to be more compatible with the getClass library
            icon = `<span class="resource-icon ${iconType}"></span>`;
        }
    }
    else {
        // If the link is a plain URL (as opposed to a resource link), set the href to the actual
        // link. This allows the link to be exported too when exporting to PDF.
        hrefAttr = href;
    }
    // A single quote is valid in a URL but we don't want any because the
    // href is already enclosed in single quotes.
    // https://github.com/laurent22/joplin/issues/2030
    href = href.replace(/'/g, '%27');
    let js = `${options.postMessageSyntax}(${JSON.stringify(href)}, { resourceId: ${JSON.stringify(resourceId)} }); return false;`;
    if (options.enableLongPress && !!resourceId) {
        const onClick = `${options.postMessageSyntax}(${JSON.stringify(href)})`;
        js = (0, createEventHandlingAttrs_1.default)(resourceId, {
            enableLongPress: (_h = options.enableLongPress) !== null && _h !== void 0 ? _h : false,
            postMessageSyntax: (_j = options.postMessageSyntax) !== null && _j !== void 0 ? _j : 'void',
            enableEditPopup: false,
        }, onClick);
    }
    else {
        js = `onclick='${htmlentities(js)}'`;
    }
    if (hrefAttr.indexOf('#') === 0 && href.indexOf('#') === 0)
        js = ''; // If it's an internal anchor, don't add any JS since the webview is going to handle navigating to the right place
    const attrHtml = [];
    attrHtml.push('data-from-md');
    if (resourceIdAttr)
        attrHtml.push(resourceIdAttr);
    if (title)
        attrHtml.push(`title='${htmlentities(title)}'`);
    if (mime)
        attrHtml.push(`type='${htmlentities(mime)}'`);
    let resourceFullPath = resource && ((_k = options === null || options === void 0 ? void 0 : options.ResourceModel) === null || _k === void 0 ? void 0 : _k.fullPath) ? options.ResourceModel.fullPath(resource) : null;
    // Handle overrides
    let addedHrefAttr = false;
    if (resourceId && options.itemIdToUrl) {
        const url = options.itemIdToUrl(resourceId);
        if (url !== null) {
            attrHtml.push(`href='${htmlentities(url)}'`);
            resourceFullPath = url;
            addedHrefAttr = true;
        }
    }
    if (addedHrefAttr) {
        // Done -- the HREF has already bee set.
    }
    else if (options.plainResourceRendering || options.linkRenderingType === MdToHtml_1.LinkRenderingType.HrefHandler) {
        icon = '';
        attrHtml.push(`href='${htmlentities(href)}'`);
    }
    else {
        attrHtml.push(`href='${htmlentities(hrefAttr)}'`);
    }
    if (js && options.linkRenderingType === MdToHtml_1.LinkRenderingType.JavaScriptHandler) {
        attrHtml.push(js);
    }
    return {
        html: `<a ${attrHtml.join(' ')}>${icon}`,
        resourceReady: true,
        resource,
        resourceFullPath: resourceFullPath,
    };
}
//# sourceMappingURL=linkReplacement.js.map