"use strict";
var __asyncValues = (this && this.__asyncValues) || function (o) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var m = o[Symbol.asyncIterator], i;
    return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i);
    function verb(n) { i[n] = o[n] && function (v) { return new Promise(function (resolve, reject) { v = o[n](v), settle(resolve, reject, v.done, v.value); }); }; }
    function settle(resolve, reject, d, v) { Promise.resolve(v).then(function(v) { resolve({ value: v, done: d }); }, reject); }
};
var __await = (this && this.__await) || function (v) { return this instanceof __await ? (this.v = v, this) : new __await(v); }
var __asyncDelegator = (this && this.__asyncDelegator) || function (o) {
    var i, p;
    return i = {}, verb("next"), verb("throw", function (e) { throw e; }), verb("return"), i[Symbol.iterator] = function () { return this; }, i;
    function verb(n, f) { i[n] = o[n] ? function (v) { return (p = !p) ? { value: __await(o[n](v)), done: false } : f ? f(v) : v; } : f; }
};
var __asyncGenerator = (this && this.__asyncGenerator) || function (thisArg, _arguments, generator) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var g = generator.apply(thisArg, _arguments || []), i, q = [];
    return i = Object.create((typeof AsyncIterator === "function" ? AsyncIterator : Object).prototype), verb("next"), verb("throw"), verb("return", awaitReturn), i[Symbol.asyncIterator] = function () { return this; }, i;
    function awaitReturn(f) { return function (v) { return Promise.resolve(v).then(f, reject); }; }
    function verb(n, f) { if (g[n]) { i[n] = function (v) { return new Promise(function (a, b) { q.push([n, v, a, b]) > 1 || resume(n, v); }); }; if (f) i[n] = f(i[n]); } }
    function resume(n, v) { try { step(g[n](v)); } catch (e) { settle(q[0][3], e); } }
    function step(r) { r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r); }
    function fulfill(value) { resume("next", value); }
    function reject(value) { resume("throw", value); }
    function settle(f, v) { if (f(v), q.shift(), q.length) resume(q[0][0], q[0][1]); }
};
Object.defineProperty(exports, "__esModule", { value: true });
const string_utils_1 = require("@joplin/lib/string-utils");
const base_command_1 = require("./base-command");
const locale_1 = require("@joplin/lib/locale");
const utils_1 = require("@joplin/utils");
const iterateStdin_1 = require("./utils/iterateStdin");
const fs_extra_1 = require("fs-extra");
const app_1 = require("./app");
class Command extends base_command_1.default {
    constructor() {
        super(...arguments);
        this.streamCommands_ = function (filePath) {
            return __asyncGenerator(this, arguments, function* () {
                var _a, e_1, _b, _c;
                const processLines = function* (lines) {
                    const commandLines = (0, string_utils_1.splitCommandBatch)(lines);
                    for (const command of commandLines) {
                        if (!command.trim())
                            continue;
                        yield (0, utils_1.splitCommandString)(command.trim());
                    }
                };
                if (filePath === '-') { // stdin
                    // Iterating over standard input conflicts with the CLI app's GUI.
                    if ((0, app_1.default)().hasGui()) {
                        throw new Error((0, locale_1._)('Reading commands from standard input is only available in CLI mode.'));
                    }
                    try {
                        for (var _d = true, _e = __asyncValues((0, iterateStdin_1.default)('command> ')), _f; _f = yield __await(_e.next()), _a = _f.done, !_a; _d = true) {
                            _c = _f.value;
                            _d = false;
                            const lines = _c;
                            yield __await(yield* __asyncDelegator(__asyncValues(processLines(lines))));
                        }
                    }
                    catch (e_1_1) { e_1 = { error: e_1_1 }; }
                    finally {
                        try {
                            if (!_d && !_a && (_b = _e.return)) yield __await(_b.call(_e));
                        }
                        finally { if (e_1) throw e_1.error; }
                    }
                }
                else {
                    const data = yield __await((0, fs_extra_1.readFile)(filePath, 'utf-8'));
                    yield __await(yield* __asyncDelegator(__asyncValues(processLines(data))));
                }
            });
        };
    }
    usage() {
        return 'batch <file-path>';
    }
    options() {
        return [
            // These are present mostly for testing purposes
            ['--continue-on-failure', 'Continue running commands when one command in the batch fails.'],
        ];
    }
    description() {
        return (0, locale_1._)('Runs the commands contained in the text file. There should be one command per line.');
    }
    async action(options) {
        var _a, e_2, _b, _c;
        let lastError;
        try {
            for (var _d = true, _e = __asyncValues(this.streamCommands_(options['file-path'])), _f; _f = await _e.next(), _a = _f.done, !_a; _d = true) {
                _c = _f.value;
                _d = false;
                const command = _c;
                try {
                    await (0, app_1.default)().refreshCurrentFolder();
                    await (0, app_1.default)().execCommand(command);
                }
                catch (error) {
                    if (options.options['continue-on-failure']) {
                        (0, app_1.default)().stdout(error.message);
                        lastError = error;
                    }
                    else {
                        throw error;
                    }
                }
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (!_d && !_a && (_b = _e.return)) await _b.call(_e);
            }
            finally { if (e_2) throw e_2.error; }
        }
        if (lastError) {
            throw lastError;
        }
    }
}
module.exports = Command;
//# sourceMappingURL=command-batch.js.map