"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const fs_extra_1 = require("fs-extra");
const path_1 = require("path");
const _1 = require(".");
const outputDirectory = './test-output';
describe('htmlpack/index', () => {
    beforeEach(async () => {
        if (await (0, fs_extra_1.exists)(outputDirectory)) {
            await (0, fs_extra_1.remove)(outputDirectory);
        }
        await (0, fs_extra_1.mkdir)(outputDirectory);
    });
    test('should convert HTML into a single file', async () => {
        const outputFile = (0, path_1.join)(outputDirectory, 'output.html');
        await (0, _1.default)((0, path_1.join)('test-data', 'index.html'), outputFile);
        const outputContent = await (0, fs_extra_1.readFile)(outputFile, 'utf8');
        expect(outputContent).toBe(`
<html>
    <head>
        <style>* {
  color: red;
}</style>
    </head>
    <body>
        <h1>Test</h1>
        <a href="data:text/plain;base64,UmVzb3VyY2Uu" download="resource.txt">Test link.</a>
        <img src="data:image/svg+xml;base64,PHN2ZyB2aWV3Qm94PSItOTUgLTk2IDIwOCAyMDgiIHdpZHRoPSIyMDgiIGhlaWdodD0iMjA4IiB2ZXJzaW9uPSIxLjEiIGJhc2VQcm9maWxlPSJmdWxsIiB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciPjx0ZXh0IHN0eWxlPSJmb250LXNpemU6IDY0cHg7IGZpbGw6IHJlZDsiPlRlc3Q8L3RleHQ+PC9zdmc+" alt="test image"/>
        <p>Test paragraph</p>
    </body>
</html>`);
    });
});
//# sourceMappingURL=index.test.js.map