"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const shim_1 = require("../shim");
const { useEffect, useRef } = shim_1.default.react();
function useEventListener(
// eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
eventName, 
// eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
handler, 
// eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
element) {
    // Create a ref that stores handler
    // eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
    const savedHandler = useRef();
    useEffect(() => {
        // Define the listening target
        const targetElement = (element === null || element === void 0 ? void 0 : element.current) || window;
        if (!(targetElement && targetElement.addEventListener)) {
            return null;
        }
        // Update saved handler if necessary
        if (savedHandler.current !== handler) {
            savedHandler.current = handler;
        }
        // Create event listener that calls handler function stored in ref
        const eventListener = (event) => {
            // eslint-disable-next-line no-extra-boolean-cast
            if (!!(savedHandler === null || savedHandler === void 0 ? void 0 : savedHandler.current)) {
                savedHandler.current(event);
            }
        };
        targetElement.addEventListener(eventName, eventListener);
        // Remove event listener on cleanup
        return () => {
            targetElement.removeEventListener(eventName, eventListener);
        };
    }, [eventName, element, handler]);
}
exports.default = useEventListener;
//# sourceMappingURL=useEventListener.js.map