"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const BaseModel_1 = require("../BaseModel");
const Note_1 = require("./Note");
class Alarm extends BaseModel_1.default {
    static tableName() {
        return 'alarms';
    }
    static modelType() {
        return BaseModel_1.default.TYPE_ALARM;
    }
    static byNoteId(noteId) {
        return this.modelSelectOne('SELECT * FROM alarms WHERE note_id = ?', [noteId]);
    }
    static async deleteExpiredAlarms() {
        return this.db().exec('DELETE FROM alarms WHERE trigger_time <= ?', [Date.now()]);
    }
    static async alarmIdsWithoutNotes() {
        // https://stackoverflow.com/a/4967229/561309
        const alarms = await this.db().selectAll('SELECT alarms.id FROM alarms LEFT JOIN notes ON alarms.note_id = notes.id WHERE notes.id IS NULL');
        // eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
        return alarms.map((a) => {
            return a.id;
        });
    }
    // eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
    static async makeNotification(alarm, note = null) {
        if (!note) {
            note = await Note_1.default.load(alarm.note_id);
        }
        else if (!note.todo_due) {
            this.logger().warn('Trying to create notification for note with todo_due property - reloading note object in case we are dealing with a partial note');
            note = await Note_1.default.load(alarm.note_id);
            this.logger().warn('Reloaded note:', note);
        }
        const output = {
            id: alarm.id,
            noteId: alarm.note_id,
            date: new Date(note.todo_due),
            title: note.title.substr(0, 128),
        };
        if (note.body)
            output.body = note.body.substr(0, 512);
        return output;
    }
    static async allDue() {
        return this.modelSelectAll('SELECT * FROM alarms WHERE trigger_time >= ?', [Date.now()]);
    }
}
exports.default = Alarm;
//# sourceMappingURL=Alarm.js.map