"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const test_utils_1 = require("../testing/test-utils");
const MasterKey_1 = require("./MasterKey");
describe('models/MasterKey', () => {
    beforeEach(async () => {
        await (0, test_utils_1.setupDatabaseAndSynchronizer)(1);
        await (0, test_utils_1.switchClient)(1);
    });
    it('should return the latest master key', (async () => {
        expect(await MasterKey_1.default.latest()).toBeFalsy();
        let mk1 = await (0, test_utils_1.encryptionService)().generateMasterKey('111111');
        mk1 = await MasterKey_1.default.save(mk1);
        expect((await MasterKey_1.default.latest()).id).toBe(mk1.id);
        await (0, test_utils_1.msleep)(1);
        let mk2 = await (0, test_utils_1.encryptionService)().generateMasterKey('111111');
        mk2 = await MasterKey_1.default.save(mk2);
        expect((await MasterKey_1.default.latest()).id).toBe(mk2.id);
        await (0, test_utils_1.msleep)(1);
        mk1 = await MasterKey_1.default.save(mk1);
        expect((await MasterKey_1.default.latest()).id).toBe(mk1.id);
    }));
});
//# sourceMappingURL=MasterKey.test.js.map