"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const BaseModel_1 = require("../BaseModel");
const _42_1 = require("../migrations/42");
// eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
const migrationScripts = {
    20: require('../migrations/20.js'),
    27: require('../migrations/27.js'),
    33: require('../migrations/33.js'),
    35: require('../migrations/35.js'),
    42: _42_1.default,
};
class Migration extends BaseModel_1.default {
    static tableName() {
        return 'migrations';
    }
    static modelType() {
        return BaseModel_1.default.TYPE_MIGRATION;
    }
    static migrationsToDo() {
        return this.modelSelectAll('SELECT * FROM migrations ORDER BY number ASC');
    }
    static script(number) {
        if (!migrationScripts[number])
            throw new Error('Migration script has not been added to "migrationScripts" array');
        return migrationScripts[number];
    }
}
exports.default = Migration;
//# sourceMappingURL=Migration.js.map