"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.separatorItem = void 0;
const reducer_1 = require("../../reducer");
const focusEditorIfEditorCommand_1 = require("./focusEditorIfEditorCommand");
exports.separatorItem = {
    type: 'separator',
};
class ToolbarButtonUtils {
    constructor(service) {
        this.toolbarButtonCache_ = {};
        this.service_ = service;
    }
    get service() {
        return this.service_;
    }
    commandToToolbarButton(commandName, whenClauseContext) {
        const newEnabled = this.service.isEnabled(commandName, whenClauseContext);
        const newTitle = this.service.title(commandName);
        const newIcon = this.service.iconName(commandName);
        const newLabel = this.service.label(commandName);
        if (this.toolbarButtonCache_[commandName] &&
            this.toolbarButtonCache_[commandName].info.enabled === newEnabled &&
            this.toolbarButtonCache_[commandName].info.title === newTitle &&
            this.toolbarButtonCache_[commandName].info.iconName === newIcon &&
            this.toolbarButtonCache_[commandName].info.tooltip === newLabel) {
            return this.toolbarButtonCache_[commandName].info;
        }
        const output = {
            type: 'button',
            name: commandName,
            tooltip: newLabel,
            iconName: newIcon,
            enabled: newEnabled,
            onClick: async () => {
                await this.service.execute(commandName);
                void (0, focusEditorIfEditorCommand_1.default)(commandName, this.service);
            },
            title: newTitle,
        };
        this.toolbarButtonCache_[commandName] = {
            info: output,
        };
        return this.toolbarButtonCache_[commandName].info;
    }
    // This method ensures that if the provided commandNames and state hasn't changed
    // the output also won't change. Invididual toolbarButtonInfo also won't changed
    // if the state they use hasn't changed. This is to avoid useless renders of the toolbars.
    // eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
    commandsToToolbarButtons(commandNames, whenClauseContext) {
        const output = [];
        for (const commandName of commandNames) {
            if (commandName === '-') {
                output.push(exports.separatorItem);
                continue;
            }
            output.push(this.commandToToolbarButton(commandName, whenClauseContext));
        }
        return reducer_1.stateUtils.selectArrayShallow({ array: output }, commandNames.join('_'));
    }
}
exports.default = ToolbarButtonUtils;
//# sourceMappingURL=ToolbarButtonUtils.js.map