"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const utils_1 = require("./utils");
describe('interop/utils', () => {
    test.each([
        [
            '',
            { printTitle: true },
        ],
        [
            '<!-- joplin-metadata-print-title = false -->',
            { printTitle: false },
        ],
        [
            '<!-- joplin-metadata-print-title = true -->',
            { printTitle: true },
        ],
        [
            '<!-- joplin-metadata-print-title = 0 -->',
            { printTitle: false },
        ],
        [
            '<!-- joplin-metadata-print-title = 1 -->',
            { printTitle: true },
        ],
        [
            '<!--  joplin-metadata-print-title    =   0  -->',
            { printTitle: false },
        ],
    ])('should parse metadata from the note HTML body', async (bodyHtml, expected) => {
        const actual = (0, utils_1.parseRenderedNoteMetadata)(bodyHtml);
        expect(actual).toEqual(expected);
    });
});
//# sourceMappingURL=utils.test.js.map