"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const KeychainServiceDriverBase_1 = require("./KeychainServiceDriverBase");
const shim_1 = require("../../shim");
class KeychainServiceDriver extends KeychainServiceDriverBase_1.default {
    constructor() {
        super(...arguments);
        this.driverId = 'node-keytar';
    }
    async supported() {
        var _a;
        return !!((_a = shim_1.default.keytar) === null || _a === void 0 ? void 0 : _a.call(shim_1.default));
    }
    async setPassword(name, password) {
        await shim_1.default.keytar().setPassword(`${this.appId}.${name}`, `${this.clientId}@joplin`, password);
        return true;
    }
    async password(name) {
        return shim_1.default.keytar().getPassword(`${this.appId}.${name}`, `${this.clientId}@joplin`);
    }
    async deletePassword(name) {
        await shim_1.default.keytar().deletePassword(`${this.appId}.${name}`, `${this.clientId}@joplin`);
    }
}
exports.default = KeychainServiceDriver;
//# sourceMappingURL=KeychainServiceDriver.node.js.map