"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const gotoAnythingStyleQuery_1 = require("./gotoAnythingStyleQuery");
describe('search/gotoAnythingStyleQuery', () => {
    it('should prepare queries', () => {
        const testCases = [
            ['hello', 'hello*'],
            ['hello welc', 'hello* welc*'],
            ['joplin://x-callback-url/openNote?id=3600e074af0e4b06aeb0ae76d3d96af7', 'joplin://x-callback-url/openNote?id=3600e074af0e4b06aeb0ae76d3d96af7'],
            ['3600e074af0e4b06aeb0ae76d3d96af7', '3600e074af0e4b06aeb0ae76d3d96af7'],
            ['', ''],
        ];
        for (const [input, expected] of testCases) {
            const actual = (0, gotoAnythingStyleQuery_1.default)(input);
            expect(actual).toBe(expected);
        }
    });
});
//# sourceMappingURL=gotoAnythingStyleQuery.test.js.map